{"vars":[{"name":"vars","containerName":"","line":76,"kind":2},{"line":85,"kind":2,"containerName":"","name":"base"},{"range":{"end":{"character":9999,"line":144},"start":{"line":97,"character":0}},"containerName":"main::","definition":"sub","name":"read","line":97,"children":[{"kind":13,"line":98,"name":"$self","definition":"my","containerName":"read","localvar":"my"},{"line":99,"kind":13,"localvar":"my","containerName":"read","name":"$coll","definition":"my"},{"line":99,"kind":12,"containerName":"read","name":"new"},{"localvar":"my","name":"$seentop","definition":"my","containerName":"read","line":100,"kind":13},{"containerName":"read","name":"$last_type","kind":13,"line":100},{"kind":13,"line":101,"containerName":"read","name":"$line","definition":"my","localvar":"my"},{"name":"$self","containerName":"read","kind":13,"line":101},{"line":101,"kind":12,"name":"_readline","containerName":"read"},{"name":"$line","containerName":"read","line":102,"kind":13},{"line":103,"kind":13,"name":"$line","containerName":"read"},{"name":"$line","containerName":"read","kind":13,"line":104},{"kind":13,"line":105,"name":"$last_type","containerName":"read"},{"containerName":"read","name":"$seentop","line":106,"kind":13},{"name":"$seentop","containerName":"read","kind":13,"line":109},{"localvar":"my","name":"@data","definition":"my","containerName":"read","line":110,"kind":13},{"name":"$line","containerName":"read","kind":13,"line":110},{"line":111,"kind":13,"containerName":"read","name":"$data"},{"localvar":"my","definition":"my","name":"$enzyme","containerName":"read","line":113,"kind":13},{"name":"$is_neo","containerName":"read","kind":13,"line":113},{"name":"$is_proto","containerName":"read","line":113,"kind":13},{"line":113,"kind":13,"containerName":"read","name":"$site"},{"kind":13,"line":114,"name":"$data","containerName":"read"},{"kind":13,"line":115,"name":"$enzyme","containerName":"read"},{"line":115,"kind":13,"containerName":"read","name":"$site"},{"kind":13,"line":115,"containerName":"read","name":"$is_proto"},{"containerName":"read","name":"$is_neo","line":115,"kind":13},{"line":117,"kind":13,"name":"$enzyme","containerName":"read"},{"kind":13,"line":117,"name":"$site","containerName":"read"},{"kind":13,"line":117,"name":"$is_proto","containerName":"read"},{"name":"$is_neo","containerName":"read","line":117,"kind":13},{"kind":13,"line":117,"name":"$data","containerName":"read"},{"containerName":"read","name":"$data","kind":13,"line":117},{"kind":13,"line":119,"name":"$site","containerName":"read"},{"line":121,"kind":13,"localvar":"my","containerName":"read","name":"$precut","definition":"my"},{"kind":13,"line":122,"name":"$site","containerName":"read"},{"name":"$precut","containerName":"read","kind":13,"line":123},{"containerName":"read","name":"$site","kind":13,"line":124},{"localvar":"my","containerName":"read","definition":"my","name":"$cut","line":127,"kind":13},{"line":127,"kind":13,"containerName":"read","name":"$comp_cut"},{"containerName":"read","name":"$site","line":128,"kind":13},{"containerName":"read","name":"$cut","line":128,"kind":13},{"name":"$comp_cut","containerName":"read","kind":13,"line":128},{"name":"$self","containerName":"read","kind":13,"line":128},{"kind":12,"line":128,"containerName":"read","name":"_cuts_from_site"},{"kind":13,"line":128,"containerName":"read","name":"$site"},{"line":130,"kind":13,"localvar":"my","name":"$re","definition":"my","containerName":"read"},{"kind":12,"line":130,"name":"new","containerName":"read"},{"containerName":"read","name":"$last_type","kind":13,"line":131},{"name":"$site","containerName":"read","line":132,"kind":13},{"name":"$enzyme","containerName":"read","line":133,"kind":13},{"line":134,"kind":13,"name":"$is_proto","containerName":"read"},{"name":"$is_neo","containerName":"read","kind":13,"line":135},{"containerName":"read","name":"$cut","line":137,"kind":13},{"name":"$re","containerName":"read","line":138,"kind":13},{"containerName":"read","name":"cut","line":138,"kind":12},{"line":138,"kind":13,"name":"$self","containerName":"read"},{"line":138,"kind":12,"name":"_coordinate_shift_to_cut","containerName":"read"},{"kind":13,"line":138,"name":"$site","containerName":"read"},{"kind":13,"line":138,"containerName":"read","name":"$cut"},{"containerName":"read","name":"$re","kind":13,"line":139},{"kind":12,"line":139,"containerName":"read","name":"complementary_cut"},{"kind":13,"line":139,"name":"$self","containerName":"read"},{"kind":12,"line":139,"name":"_coordinate_shift_to_cut","containerName":"read"},{"containerName":"read","name":"$site","kind":13,"line":139},{"line":139,"kind":13,"name":"$comp_cut","containerName":"read"},{"line":141,"kind":13,"containerName":"read","name":"$coll"},{"line":141,"kind":12,"containerName":"read","name":"enzymes"},{"containerName":"read","name":"$re","kind":13,"line":141},{"line":143,"kind":13,"containerName":"read","name":"$coll"},{"name":"enzymes","containerName":"read","kind":12,"line":143}],"kind":12},{"kind":12,"line":99,"containerName":"Restriction::EnzymeCollection","name":"Bio"},{"containerName":"Restriction::Enzyme","name":"Bio","line":130,"kind":12},{"children":[{"kind":13,"line":158,"containerName":"write","name":"$self","definition":"my","localvar":"my"},{"line":158,"kind":13,"name":"@h","containerName":"write"},{"line":159,"kind":13,"name":"$self","containerName":"write"},{"kind":12,"line":159,"name":"throw_not_implemented","containerName":"write"}],"line":157,"kind":12,"signature":{"documentation":"1;\n# $Id: prototype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Restriction::IO::prototype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields \n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Restriction::IO::prototype - prototype enzyme set\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::Restriction::IO class.\n\n=head1 DESCRIPTION\n\nThis is a parser for the proto/neo file REBASE format, which contains\nprototype information as well as (in the neo file) neoschizomer data.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nRob Edwards, redwards@utmem.edu\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Restriction::IO::prototype;\n\nuse vars qw(%WITH_REFM_FIELD);\nuse strict;\n\n#use Bio::Restriction::IO;\nuse Bio::Restriction::Enzyme;\nuse Bio::Restriction::EnzymeCollection;\n\nuse Data::Dumper;\n\nuse base qw(Bio::Restriction::IO::base);\n\n=head2 read\n\n Title   : read\n Usage   : $renzs = $stream->read\n Function: reads all the restrction enzymes from the stream\n Returns : a Bio::Restriction::Restriction object\n Args    : none\n\n\nsub read {\n    my $self = shift;\n    my $coll = Bio::Restriction::EnzymeCollection->new(-empty => 1);\n    my ($seentop, $last_type);\n    while (defined (my $line = $self->_readline)) {\n        chomp $line;\n        next unless $line;\n        if ($line =~ /TYPE\\s+(I)+/) {\n            $last_type = $1;\n            $seentop ||= 1;\n            next;\n        }\n        next unless $seentop;\n        my @data = split /\\s+/,$line,2;\n        next if $data[0] =~ /^[-\\s]*$/;\n        # neo\n        my ($enzyme, $is_neo, $is_proto, $site);\n        if ($data[0] =~ /^\\s+(\\S+)\\s+(\\S+)/) {\n            ($enzyme, $site, $is_proto, $is_neo) = ($1, $2, 0, 1);\n        } else {\n            ($enzyme, $site, $is_proto, $is_neo) = ($data[0], $data[1], 1, 0);\n        }\n        $site =~ s/\\s+//g;\n        \n        my $precut;\n        if ($site =~ m/^\\((\\d+\\/\\d+)\\)[RYATGCN]+/) {\n            $precut=$1;\n            $site =~ s/\\($precut\\)//;\n        }\n        \n        my ($cut, $comp_cut);\n        ($site, $cut, $comp_cut) = $self->_cuts_from_site($site);\n        \n        my $re = Bio::Restriction::Enzyme->new(\n            -type => $last_type,\n            -site => $site,\n            -name => $enzyme,\n            -is_prototype => $is_proto,\n            -is_neoschizomer => $is_neo);\n        \n        if ($cut) {\n            $re->cut($self->_coordinate_shift_to_cut(length($site), $cut));\n            $re->complementary_cut($self->_coordinate_shift_to_cut(length($site), $comp_cut));\n        }\n        $coll->enzymes($re);\n    }\n    return $coll->enzymes;\n}\n\n=head2 write\n\n Title   : write\n Usage   : $stream->write($renzs)\n Function: writes restriction enzymes into the stream\n Returns : 1 for success and 0 for error\n Args    : a Bio::Restriction::Enzyme\n           or a Bio::Restriction::EnzymeCollection object","parameters":[{"label":"$self"},{"label":"@h"}],"label":"write($self,@h)"},"detail":"($self,@h)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":157},"end":{"line":160,"character":9999}},"name":"write"}],"version":5}