{"vars":[{"line":86,"kind":2,"name":"Storable","containerName":""},{"kind":2,"line":88,"containerName":"","name":"base"},{"kind":13,"line":90,"name":"$USAGE","definition":"my","containerName":null,"localvar":"my"},{"range":{"end":{"character":9999,"line":126},"start":{"character":0,"line":108}},"name":"new","line":108,"children":[{"line":110,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$class"},{"kind":13,"line":110,"name":"@args","containerName":"new"},{"kind":13,"line":112,"containerName":"new","name":"$self","definition":"my","localvar":"my"},{"containerName":"new","name":"$class","line":112,"kind":13},{"line":112,"kind":13,"name":"@args","containerName":"new"},{"line":114,"kind":13,"localvar":"my","name":"$haplotype_block","definition":"my","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":114},{"name":"_rearrange","containerName":"new","line":114,"kind":12},{"containerName":"new","name":"@args","kind":13,"line":114},{"name":"$haplotype_block","containerName":"new","kind":13,"line":116},{"containerName":"new","name":"$self","line":117,"kind":13},{"name":"haplotype_block","containerName":"new","line":117,"kind":12},{"kind":13,"line":117,"containerName":"new","name":"$haplotype_block"},{"name":"$self","containerName":"new","line":120,"kind":13},{"name":"throw","containerName":"new","line":120,"kind":12},{"line":124,"kind":13,"localvar":"my","definition":"my","name":"$i","containerName":"new"},{"line":124,"kind":13,"name":"$i","containerName":"new"},{"line":124,"kind":13,"name":"$haplotype_block","containerName":"new"},{"containerName":"new","name":"$i","kind":13,"line":124},{"name":"$haplotype_block","containerName":"new","line":125,"kind":13},{"line":126,"kind":13,"name":"$haplotype_block","containerName":"new"},{"containerName":"new","name":"$i","line":126,"kind":13}],"kind":12,"detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# module Bio::PopGen::TagHaplotype.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Pedro M. Gomez-Fabre <pgf18872-at-gsk-dot-com>\n#\n# Copyright Pedro M. Gomez-Fabre\n#\n# You may distribute this module under the same term as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::TagHaplotype.pm - Haplotype tag object.\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::TagHaplotype;\n\n    my $obj = Bio::PopGen::TagHaplotype -> new($hap);\n\n=head1 DESCRIPTION\n\nThis module take as input a haplotype and try toe get the minimal set\nof SNP that define the haplotype. This module can be use alone.  But\ndue to the tagging haplotype process is exponential one. My suggestion\nis that before to use this module you pass your data under Select.mp\nmodule also on this folder.  In any case if, you provide an haplotype\nthe module will try to find the answer to your question.\n\n=head1 CONSTRUCTORS\n\n    my $obj = Bio::PopGen::TagHaplotype -> new($hap);\n\n    were $hap is the reference to an array of array with the haplotype.\n\n    $hap= [[0, 0, 0],\n           [1, 0, 0],\n           [0, 1, 1]\n          ];\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Pedro M. Gomez-Fabre\n\nEmail pgf18872-at-gsk-dot-com\n\n\n\n# Let the code begin...\n\npackage Bio::PopGen::TagHaplotype;\nuse strict;\n\nuse Data::Dumper;\nuse Storable qw(dclone);\n\nuse base qw(Bio::Root::Root);\n\nmy $USAGE = <<EOF\nUsage:\n    Bio::PopGen::TagHaplotype->new(-haplotype_block => \\$hapblockref)\n\nEOF\n;\n\n=head2 new\n\n Title   : new\n Function: constructor of the class.\n Returns : self hash\n Args    : input haplotype (array of array)\n Status  : public"},"containerName":"main::","definition":"sub"},{"line":112,"kind":12,"name":"SUPER","containerName":"new"},{"line":128,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","name":"throw","kind":12,"line":128},{"line":133,"kind":13,"localvar":"my","name":"$tag_list","definition":"my","containerName":null},{"line":133,"kind":12,"name":"_scan_snp"},{"line":133,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"haplotype_block","kind":12,"line":133},{"containerName":null,"name":"%tag_list","line":135,"kind":13},{"name":"$self","containerName":null,"line":136,"kind":13},{"line":136,"kind":12,"containerName":"main::","name":"tag_list"},{"name":"%tag_list","containerName":null,"kind":13,"line":136},{"containerName":null,"name":"$self","kind":13,"line":139},{"kind":12,"line":139,"name":"tag_list","containerName":"main::"},{"line":142,"kind":13,"containerName":null,"name":"$self"},{"line":142,"kind":12,"containerName":"main::","name":"tag_list"},{"kind":13,"line":143,"name":"$self","containerName":null},{"containerName":"main::","name":"tag_length","kind":12,"line":143},{"line":143,"kind":13,"containerName":null,"name":"$self"},{"name":"tag_list","containerName":"main::","kind":12,"line":143},{"line":146,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"tag_length","kind":12,"line":146},{"containerName":null,"name":"$self","line":149,"kind":13},{"containerName":"main::","definition":"sub","name":"haplotype_block","range":{"end":{"line":167,"character":9999},"start":{"character":0,"line":163}},"kind":12,"line":163,"children":[{"line":164,"kind":13,"localvar":"my","containerName":"haplotype_block","definition":"my","name":"$self"},{"name":"$self","containerName":"haplotype_block","kind":13,"line":165},{"containerName":"haplotype_block","name":"$self","line":166,"kind":13}]},{"range":{"end":{"character":9999,"line":190},"start":{"character":0,"line":184}},"containerName":"main::","definition":"sub","name":"input_block","line":184,"children":[{"line":186,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"input_block"},{"kind":13,"line":188,"name":"$self","containerName":"input_block"},{"containerName":"input_block","name":"warn","line":188,"kind":12},{"containerName":"input_block","name":"$self","line":188,"kind":13},{"line":189,"kind":13,"containerName":"input_block","name":"$self"},{"kind":12,"line":189,"containerName":"input_block","name":"haplotype_block"}],"kind":12},{"line":205,"children":[{"name":"$self","definition":"my","containerName":"tag_list","localvar":"my","kind":13,"line":207},{"name":"$self","containerName":"tag_list","line":208,"kind":13},{"kind":13,"line":209,"name":"$self","containerName":"tag_list"}],"kind":12,"range":{"end":{"character":9999,"line":210},"start":{"line":205,"character":0}},"containerName":"main::","definition":"sub","name":"tag_list"},{"containerName":"main::","name":"tag_length","definition":"sub","range":{"end":{"line":229,"character":9999},"start":{"line":224,"character":0}},"kind":12,"line":224,"children":[{"localvar":"my","containerName":"tag_length","definition":"my","name":"$self","line":226,"kind":13},{"line":227,"kind":13,"name":"$self","containerName":"tag_length"},{"line":228,"kind":13,"name":"$self","containerName":"tag_length"}]},{"range":{"end":{"line":248,"character":9999},"start":{"character":0,"line":244}},"name":"_scan_snp","children":[{"kind":13,"line":246,"containerName":"_scan_snp","definition":"my","name":"$hap","localvar":"my"},{"containerName":"_scan_snp","name":"$hap_length","definition":"my","localvar":"my","kind":13,"line":248},{"containerName":"_scan_snp","name":"$hap","kind":13,"line":248}],"line":244,"kind":12,"signature":{"label":"_scan_snp($hap)","documentation":"1;\n# module Bio::PopGen::TagHaplotype.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Pedro M. Gomez-Fabre <pgf18872-at-gsk-dot-com>\n#\n# Copyright Pedro M. Gomez-Fabre\n#\n# You may distribute this module under the same term as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::TagHaplotype.pm - Haplotype tag object.\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::TagHaplotype;\n\n    my $obj = Bio::PopGen::TagHaplotype -> new($hap);\n\n=head1 DESCRIPTION\n\nThis module take as input a haplotype and try toe get the minimal set\nof SNP that define the haplotype. This module can be use alone.  But\ndue to the tagging haplotype process is exponential one. My suggestion\nis that before to use this module you pass your data under Select.mp\nmodule also on this folder.  In any case if, you provide an haplotype\nthe module will try to find the answer to your question.\n\n=head1 CONSTRUCTORS\n\n    my $obj = Bio::PopGen::TagHaplotype -> new($hap);\n\n    were $hap is the reference to an array of array with the haplotype.\n\n    $hap= [[0, 0, 0],\n           [1, 0, 0],\n           [0, 1, 1]\n          ];\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Pedro M. Gomez-Fabre\n\nEmail pgf18872-at-gsk-dot-com\n\n\n\n# Let the code begin...\n\npackage Bio::PopGen::TagHaplotype;\nuse strict;\n\nuse Data::Dumper;\nuse Storable qw(dclone);\n\nuse base qw(Bio::Root::Root);\n\nmy $USAGE = <<EOF\nUsage:\n    Bio::PopGen::TagHaplotype->new(-haplotype_block => \\$hapblockref)\n\nEOF\n;\n\n=head2 new\n\n Title   : new\n Function: constructor of the class.\n Returns : self hash\n Args    : input haplotype (array of array)\n Status  : public\n\n\n#------------------------\nsub new{\n#------------------------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($haplotype_block) = $self->_rearrange([qw(HAPLOTYPE_BLOCK)],@args);\n\n    if ($haplotype_block) {\n        $self->haplotype_block($haplotype_block);\n    }\n    else{\n        $self->throw(\"haplotype has not been supplied\\n$USAGE\");\n    }\n\n    # check that the haplotype block is well formed.\n    for (my $i=0; $i<$#$haplotype_block+1; $i++){\n\tif ( $#{$haplotype_block->[0]} !=\n             $#{$haplotype_block->[$i]} ){\n\n            $self->throw(\"The haplotype matrix is not well formed (Not squared)\");\n        }\n    }\n\n    # make the calculation\n    my $tag_list =  _scan_snp( $self ->haplotype_block );\n\n    if ($tag_list){\n        $self ->tag_list($tag_list);\n    }\n    else { \n        $self ->tag_list(undef);\n    }\n\n    if ( defined $self->tag_list){\n        $self ->tag_length(scalar @{$self->tag_list});\n    }\n    else {\n        $self ->tag_length(0);  #\"NO TAGS FOUND!\"\n    }\n\n    return $self;\n}\n\n=head2 haplotype_block\n\n Title   : haplotype_block\n Usage   : my $haplotype_block = $TagHaplotype->haplotype_block();\n Function: Get the haplotype block for a haplotype tagging selection\n Returns : reference of array\n Args    : reference of array with haplotype pattern\n\n\n\nsub haplotype_block{\n    my ($self) =shift;\n    return $self->{'_haplotype_block'} = shift if @_;\n    return $self->{'_haplotype_block'};\n}\n\n\n=head2 input_block \n\n Title   : input_block \n Usage   : $obj->input_block()\n Function: returns haplotype block. By now will produce the same ouput than\n           $self->haplotype_block. but for compatiblity, this method is kept. \n           This method is deprecated.\n Returns : reference to array of array with the haplotype input value \n Args    : none \n Status  : public\n\n\n#------------------------\nsub input_block{\n#------------------------\n    my $self = shift;\n\n    $self->warn(ref($self). \"::input_block - deprecated method. Use haplotype_block() instead.\");\n    return $self->haplotype_block;\n}\n\n=head2 tag_list\n\n Title   : tag_list \n Usage   : $obj->tag_list()\n Function: returns the list of SNPs combination that identify the\n           haplotype. All combinations are displayed as arrays\n Returns : reference to array of array. \n Args    : none\n Status  : public\n\n\n#------------------------\nsub tag_list{\n#------------------------\n    my ($self) = shift;\n    return $self->{'_tag_list'}= shift if @_;\n    return $self->{'_tag_list'};\n}\n\n=head2 tag_length \n\n Title   : tag_length \n Usage   : $obj->tag_length()\n Function: returns the length of the tag.\n Returns : scalar \n Args    : none\n Status  : public\n\n\n#------------------------\nsub tag_length{\n#------------------------\n    my ($self) =shift;\n    return $self ->{'_tag_length'} = shift if @_;\n    return $self ->{'_tag_length'};\n}\n\n=head2 _scan_snp \n\n Title   : _scan_snp \n Usage   : internal\n Function: scan sets increasing the length until find a non degenerated\n           pattern. \n Returns : scalar\n Args    : none\n Status  : private","parameters":[{"label":"$hap"}]},"detail":"($hap)","definition":"sub","containerName":"main::"},{"localvar":"my","containerName":null,"definition":"my","name":"$i","line":250,"kind":13},{"containerName":null,"name":"%hap_length","line":250,"kind":13},{"line":252,"kind":13,"localvar":"my","definition":"my","name":"$list","containerName":null},{"name":"_gen_comb","line":252,"kind":12},{"kind":13,"line":252,"name":"$hap_length","containerName":null},{"containerName":null,"name":"$i","kind":13,"line":252},{"localvar":"my","name":"$snp_collection","definition":"my","containerName":null,"line":254,"kind":13},{"line":254,"kind":12,"name":"_scan_combinations"},{"line":254,"kind":13,"name":"$hap","containerName":null},{"line":254,"kind":13,"name":"$list","containerName":null},{"kind":13,"line":259,"name":"%snp_collection","containerName":null},{"containerName":null,"name":"$snp_collection","kind":13,"line":260},{"line":279,"children":[{"localvar":"my","definition":"my","name":"$hap_length","containerName":"_gen_comb","line":282,"kind":13},{"containerName":"_gen_comb","name":"$n","kind":13,"line":282},{"name":"@array","definition":"my","containerName":"_gen_comb","localvar":"my","kind":13,"line":284},{"containerName":"_gen_comb","name":"$hap_length","line":287,"kind":13},{"kind":13,"line":287,"name":"@array","containerName":"_gen_comb"},{"kind":13,"line":294,"containerName":"_gen_comb","name":"$m","definition":"my","localvar":"my"},{"kind":13,"line":297,"definition":"my","name":"$value","containerName":"_gen_comb","localvar":"my"},{"line":300,"kind":13,"localvar":"my","containerName":"_gen_comb","name":"$list","definition":"my"},{"kind":13,"line":302,"containerName":"_gen_comb","name":"@array"},{"containerName":"_gen_comb","name":"$m","kind":13,"line":302},{"name":"$n","containerName":"_gen_comb","kind":13,"line":302},{"containerName":"_gen_comb","name":"$value","kind":13,"line":302},{"kind":13,"line":302,"name":"$list","containerName":"_gen_comb"},{"name":"$list","containerName":"_gen_comb","kind":13,"line":304}],"kind":12,"detail":"($hap_length,$n)","signature":{"documentation":"1;\n# module Bio::PopGen::TagHaplotype.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Pedro M. Gomez-Fabre <pgf18872-at-gsk-dot-com>\n#\n# Copyright Pedro M. Gomez-Fabre\n#\n# You may distribute this module under the same term as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::TagHaplotype.pm - Haplotype tag object.\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::TagHaplotype;\n\n    my $obj = Bio::PopGen::TagHaplotype -> new($hap);\n\n=head1 DESCRIPTION\n\nThis module take as input a haplotype and try toe get the minimal set\nof SNP that define the haplotype. This module can be use alone.  But\ndue to the tagging haplotype process is exponential one. My suggestion\nis that before to use this module you pass your data under Select.mp\nmodule also on this folder.  In any case if, you provide an haplotype\nthe module will try to find the answer to your question.\n\n=head1 CONSTRUCTORS\n\n    my $obj = Bio::PopGen::TagHaplotype -> new($hap);\n\n    were $hap is the reference to an array of array with the haplotype.\n\n    $hap= [[0, 0, 0],\n           [1, 0, 0],\n           [0, 1, 1]\n          ];\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Pedro M. Gomez-Fabre\n\nEmail pgf18872-at-gsk-dot-com\n\n\n\n# Let the code begin...\n\npackage Bio::PopGen::TagHaplotype;\nuse strict;\n\nuse Data::Dumper;\nuse Storable qw(dclone);\n\nuse base qw(Bio::Root::Root);\n\nmy $USAGE = <<EOF\nUsage:\n    Bio::PopGen::TagHaplotype->new(-haplotype_block => \\$hapblockref)\n\nEOF\n;\n\n=head2 new\n\n Title   : new\n Function: constructor of the class.\n Returns : self hash\n Args    : input haplotype (array of array)\n Status  : public\n\n\n#------------------------\nsub new{\n#------------------------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($haplotype_block) = $self->_rearrange([qw(HAPLOTYPE_BLOCK)],@args);\n\n    if ($haplotype_block) {\n        $self->haplotype_block($haplotype_block);\n    }\n    else{\n        $self->throw(\"haplotype has not been supplied\\n$USAGE\");\n    }\n\n    # check that the haplotype block is well formed.\n    for (my $i=0; $i<$#$haplotype_block+1; $i++){\n\tif ( $#{$haplotype_block->[0]} !=\n             $#{$haplotype_block->[$i]} ){\n\n            $self->throw(\"The haplotype matrix is not well formed (Not squared)\");\n        }\n    }\n\n    # make the calculation\n    my $tag_list =  _scan_snp( $self ->haplotype_block );\n\n    if ($tag_list){\n        $self ->tag_list($tag_list);\n    }\n    else { \n        $self ->tag_list(undef);\n    }\n\n    if ( defined $self->tag_list){\n        $self ->tag_length(scalar @{$self->tag_list});\n    }\n    else {\n        $self ->tag_length(0);  #\"NO TAGS FOUND!\"\n    }\n\n    return $self;\n}\n\n=head2 haplotype_block\n\n Title   : haplotype_block\n Usage   : my $haplotype_block = $TagHaplotype->haplotype_block();\n Function: Get the haplotype block for a haplotype tagging selection\n Returns : reference of array\n Args    : reference of array with haplotype pattern\n\n\n\nsub haplotype_block{\n    my ($self) =shift;\n    return $self->{'_haplotype_block'} = shift if @_;\n    return $self->{'_haplotype_block'};\n}\n\n\n=head2 input_block \n\n Title   : input_block \n Usage   : $obj->input_block()\n Function: returns haplotype block. By now will produce the same ouput than\n           $self->haplotype_block. but for compatiblity, this method is kept. \n           This method is deprecated.\n Returns : reference to array of array with the haplotype input value \n Args    : none \n Status  : public\n\n\n#------------------------\nsub input_block{\n#------------------------\n    my $self = shift;\n\n    $self->warn(ref($self). \"::input_block - deprecated method. Use haplotype_block() instead.\");\n    return $self->haplotype_block;\n}\n\n=head2 tag_list\n\n Title   : tag_list \n Usage   : $obj->tag_list()\n Function: returns the list of SNPs combination that identify the\n           haplotype. All combinations are displayed as arrays\n Returns : reference to array of array. \n Args    : none\n Status  : public\n\n\n#------------------------\nsub tag_list{\n#------------------------\n    my ($self) = shift;\n    return $self->{'_tag_list'}= shift if @_;\n    return $self->{'_tag_list'};\n}\n\n=head2 tag_length \n\n Title   : tag_length \n Usage   : $obj->tag_length()\n Function: returns the length of the tag.\n Returns : scalar \n Args    : none\n Status  : public\n\n\n#------------------------\nsub tag_length{\n#------------------------\n    my ($self) =shift;\n    return $self ->{'_tag_length'} = shift if @_;\n    return $self ->{'_tag_length'};\n}\n\n=head2 _scan_snp \n\n Title   : _scan_snp \n Usage   : internal\n Function: scan sets increasing the length until find a non degenerated\n           pattern. \n Returns : scalar\n Args    : none\n Status  : private\n\n\n#------------------------\nsub _scan_snp{\n#------------------------\n    my ($hap)=@_;\n\n    my $hap_length = scalar @{$hap->[0]};    ## store the haplotype length\n\n    for my $i(1..$hap_length){\n\n        my $list = _gen_comb($hap_length, $i);\n\n        my $snp_collection = _scan_combinations($hap, $list);\n\n        # if there is any element on the collection.\n        # We have reached our goal and \n        # we can stop the calculation.\n        if($#$snp_collection>-1){\n            return $snp_collection;\n        }\n    }\n}\n\n=head2 _gen_comb\n\n Title   : _gen_comb \n Usage   : internal\n Function: we supply the length of the haplotype and the length of the\n           word we need to find and the functions returns the possible\n           list of combinations.\n Returns : scalar\n Args    : none\n Status  : private","parameters":[{"label":"$hap_length"},{"label":"$n"}],"label":"_gen_comb($hap_length,$n)"},"containerName":"main::","definition":"sub","range":{"start":{"line":279,"character":0},"end":{"character":9999,"line":306}},"name":"_gen_comb"},{"name":"_generateCombinations","kind":12,"line":302},{"name":"_generateCombinations","range":{"end":{"character":9999,"line":348},"start":{"line":332,"character":0}},"definition":"sub","containerName":"main::","signature":{"label":"_generateCombinations($rarr,$rm,$rn,$rvalue,$rlist)","documentation":"1;\n# module Bio::PopGen::TagHaplotype.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Pedro M. Gomez-Fabre <pgf18872-at-gsk-dot-com>\n#\n# Copyright Pedro M. Gomez-Fabre\n#\n# You may distribute this module under the same term as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::TagHaplotype.pm - Haplotype tag object.\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::TagHaplotype;\n\n    my $obj = Bio::PopGen::TagHaplotype -> new($hap);\n\n=head1 DESCRIPTION\n\nThis module take as input a haplotype and try toe get the minimal set\nof SNP that define the haplotype. This module can be use alone.  But\ndue to the tagging haplotype process is exponential one. My suggestion\nis that before to use this module you pass your data under Select.mp\nmodule also on this folder.  In any case if, you provide an haplotype\nthe module will try to find the answer to your question.\n\n=head1 CONSTRUCTORS\n\n    my $obj = Bio::PopGen::TagHaplotype -> new($hap);\n\n    were $hap is the reference to an array of array with the haplotype.\n\n    $hap= [[0, 0, 0],\n           [1, 0, 0],\n           [0, 1, 1]\n          ];\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Pedro M. Gomez-Fabre\n\nEmail pgf18872-at-gsk-dot-com\n\n\n\n# Let the code begin...\n\npackage Bio::PopGen::TagHaplotype;\nuse strict;\n\nuse Data::Dumper;\nuse Storable qw(dclone);\n\nuse base qw(Bio::Root::Root);\n\nmy $USAGE = <<EOF\nUsage:\n    Bio::PopGen::TagHaplotype->new(-haplotype_block => \\$hapblockref)\n\nEOF\n;\n\n=head2 new\n\n Title   : new\n Function: constructor of the class.\n Returns : self hash\n Args    : input haplotype (array of array)\n Status  : public\n\n\n#------------------------\nsub new{\n#------------------------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($haplotype_block) = $self->_rearrange([qw(HAPLOTYPE_BLOCK)],@args);\n\n    if ($haplotype_block) {\n        $self->haplotype_block($haplotype_block);\n    }\n    else{\n        $self->throw(\"haplotype has not been supplied\\n$USAGE\");\n    }\n\n    # check that the haplotype block is well formed.\n    for (my $i=0; $i<$#$haplotype_block+1; $i++){\n\tif ( $#{$haplotype_block->[0]} !=\n             $#{$haplotype_block->[$i]} ){\n\n            $self->throw(\"The haplotype matrix is not well formed (Not squared)\");\n        }\n    }\n\n    # make the calculation\n    my $tag_list =  _scan_snp( $self ->haplotype_block );\n\n    if ($tag_list){\n        $self ->tag_list($tag_list);\n    }\n    else { \n        $self ->tag_list(undef);\n    }\n\n    if ( defined $self->tag_list){\n        $self ->tag_length(scalar @{$self->tag_list});\n    }\n    else {\n        $self ->tag_length(0);  #\"NO TAGS FOUND!\"\n    }\n\n    return $self;\n}\n\n=head2 haplotype_block\n\n Title   : haplotype_block\n Usage   : my $haplotype_block = $TagHaplotype->haplotype_block();\n Function: Get the haplotype block for a haplotype tagging selection\n Returns : reference of array\n Args    : reference of array with haplotype pattern\n\n\n\nsub haplotype_block{\n    my ($self) =shift;\n    return $self->{'_haplotype_block'} = shift if @_;\n    return $self->{'_haplotype_block'};\n}\n\n\n=head2 input_block \n\n Title   : input_block \n Usage   : $obj->input_block()\n Function: returns haplotype block. By now will produce the same ouput than\n           $self->haplotype_block. but for compatiblity, this method is kept. \n           This method is deprecated.\n Returns : reference to array of array with the haplotype input value \n Args    : none \n Status  : public\n\n\n#------------------------\nsub input_block{\n#------------------------\n    my $self = shift;\n\n    $self->warn(ref($self). \"::input_block - deprecated method. Use haplotype_block() instead.\");\n    return $self->haplotype_block;\n}\n\n=head2 tag_list\n\n Title   : tag_list \n Usage   : $obj->tag_list()\n Function: returns the list of SNPs combination that identify the\n           haplotype. All combinations are displayed as arrays\n Returns : reference to array of array. \n Args    : none\n Status  : public\n\n\n#------------------------\nsub tag_list{\n#------------------------\n    my ($self) = shift;\n    return $self->{'_tag_list'}= shift if @_;\n    return $self->{'_tag_list'};\n}\n\n=head2 tag_length \n\n Title   : tag_length \n Usage   : $obj->tag_length()\n Function: returns the length of the tag.\n Returns : scalar \n Args    : none\n Status  : public\n\n\n#------------------------\nsub tag_length{\n#------------------------\n    my ($self) =shift;\n    return $self ->{'_tag_length'} = shift if @_;\n    return $self ->{'_tag_length'};\n}\n\n=head2 _scan_snp \n\n Title   : _scan_snp \n Usage   : internal\n Function: scan sets increasing the length until find a non degenerated\n           pattern. \n Returns : scalar\n Args    : none\n Status  : private\n\n\n#------------------------\nsub _scan_snp{\n#------------------------\n    my ($hap)=@_;\n\n    my $hap_length = scalar @{$hap->[0]};    ## store the haplotype length\n\n    for my $i(1..$hap_length){\n\n        my $list = _gen_comb($hap_length, $i);\n\n        my $snp_collection = _scan_combinations($hap, $list);\n\n        # if there is any element on the collection.\n        # We have reached our goal and \n        # we can stop the calculation.\n        if($#$snp_collection>-1){\n            return $snp_collection;\n        }\n    }\n}\n\n=head2 _gen_comb\n\n Title   : _gen_comb \n Usage   : internal\n Function: we supply the length of the haplotype and the length of the\n           word we need to find and the functions returns the possible\n           list of combinations.\n Returns : scalar\n Args    : none\n Status  : private\n\n\n#------------------------\nsub _gen_comb{\n#------------------------\n\n    my ($hap_length,$n) = @_;\n\n    my @array = ();    # list with all elements we have to combine\n\n    \n    for(0..$hap_length-1){ push @array, $_ };\n\n    #\n    # we need some parameters to create the combination list.\n    # This parameters can be changed if we can modify the list values\n    #\n\n    my $m = -1;      # this parameter start the calculation at value\n                     # m+1 on the recursive cicle.\n\n    my $value = [];  ## seems to have not too much sense here, but is\n                     ## needed on the recursion and need to be started\n                     ## from here\n    my $list = [];\n\n    _generateCombinations ( \\@array, \\$m, \\$n, $value, $list);\n\n    return $list;\n\n}\n\n=head2 _generateCombinations \n\n Title   : _generateCombinations \n Usage   : internal\n Function: Recursive function that produce all combinations for a set\n\n           i.e.:\n\n           1, 2, 3, 4\n\n           and word of B<3> will produce:\n\n           1, 2, 3\n           1, 2, 4\n           1, 3, 4\n           2, 3, 4\n\n Returns :\n Args    : none\n Status  : private","parameters":[{"label":"$rarr"},{"label":"$rm"},{"label":"$rn"},{"label":"$rvalue"},{"label":"$rlist"}]},"detail":"($rarr,$rm,$rn,$rvalue,$rlist)","kind":12,"children":[{"name":"$rarr","definition":"my","containerName":"_generateCombinations","localvar":"my","kind":13,"line":334},{"kind":13,"line":334,"name":"$rm","containerName":"_generateCombinations"},{"containerName":"_generateCombinations","name":"$rn","kind":13,"line":334},{"line":334,"kind":13,"name":"$rvalue","containerName":"_generateCombinations"},{"name":"$rlist","containerName":"_generateCombinations","kind":13,"line":334},{"line":336,"kind":13,"localvar":"my","definition":"my","name":"$i","containerName":"_generateCombinations"},{"line":336,"kind":13,"containerName":"_generateCombinations","name":"$i"},{"name":"$rarr","containerName":"_generateCombinations","kind":13,"line":336},{"name":"$i","containerName":"_generateCombinations","kind":13,"line":336},{"definition":"my","name":"@value2","containerName":"_generateCombinations","localvar":"my","kind":13,"line":337},{"kind":13,"line":337,"name":"$rvalue","containerName":"_generateCombinations"},{"containerName":"_generateCombinations","name":"$rarr","kind":13,"line":337},{"name":"$i","containerName":"_generateCombinations","kind":13,"line":337},{"containerName":"_generateCombinations","name":"@value2","kind":13,"line":338},{"line":339,"kind":13,"name":"$rarr","containerName":"_generateCombinations"},{"kind":13,"line":339,"containerName":"_generateCombinations","name":"$i"},{"kind":13,"line":339,"containerName":"_generateCombinations","name":"$rn"},{"kind":13,"line":339,"name":"@value2","containerName":"_generateCombinations"},{"line":339,"kind":13,"name":"$rlist","containerName":"_generateCombinations"},{"line":341,"kind":13,"name":"@value2","containerName":"_generateCombinations"},{"containerName":"_generateCombinations","name":"$rlist","kind":13,"line":342},{"line":342,"kind":13,"containerName":"_generateCombinations","name":"@value2"},{"kind":13,"line":344,"containerName":"_generateCombinations","name":"@value2"}],"line":332},{"name":"rm","kind":12,"line":336},{"kind":12,"line":338,"name":"rn"},{"line":341,"kind":12,"name":"rn"},{"line":344,"kind":12,"name":"rn"},{"line":377,"children":[{"line":380,"kind":13,"localvar":"my","containerName":"_scan_combinations","name":"$hap","definition":"my"},{"line":380,"kind":13,"name":"$list","containerName":"_scan_combinations"},{"line":382,"kind":13,"localvar":"my","containerName":"_scan_combinations","name":"$valid_combination","definition":"my"},{"kind":13,"line":385,"name":"$i","definition":"my","containerName":"_scan_combinations","localvar":"my"},{"kind":13,"line":385,"containerName":"_scan_combinations","name":"$list"},{"name":"$subArray","definition":"my","containerName":"_scan_combinations","localvar":"my","kind":13,"line":388},{"line":388,"kind":13,"name":"$hap","containerName":"_scan_combinations"},{"containerName":"_scan_combinations","name":"$list","line":388,"kind":13},{"line":388,"kind":13,"containerName":"_scan_combinations","name":"$i"},{"localvar":"my","definition":"my","name":"$degeneration","containerName":"_scan_combinations","line":390,"kind":13},{"containerName":"_scan_combinations","name":"$subArray","kind":13,"line":390},{"name":"$degeneration","containerName":"_scan_combinations","line":392,"kind":13},{"name":"$valid_combination","containerName":"_scan_combinations","line":393,"kind":13},{"containerName":"_scan_combinations","name":"$list","kind":13,"line":393},{"line":393,"kind":13,"containerName":"_scan_combinations","name":"$i"}],"kind":12,"detail":"($hap,$list)","signature":{"label":"_scan_combinations($hap,$list)","documentation":"1;\n# module Bio::PopGen::TagHaplotype.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Pedro M. Gomez-Fabre <pgf18872-at-gsk-dot-com>\n#\n# Copyright Pedro M. Gomez-Fabre\n#\n# You may distribute this module under the same term as perl itself\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::TagHaplotype.pm - Haplotype tag object.\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::TagHaplotype;\n\n    my $obj = Bio::PopGen::TagHaplotype -> new($hap);\n\n=head1 DESCRIPTION\n\nThis module take as input a haplotype and try toe get the minimal set\nof SNP that define the haplotype. This module can be use alone.  But\ndue to the tagging haplotype process is exponential one. My suggestion\nis that before to use this module you pass your data under Select.mp\nmodule also on this folder.  In any case if, you provide an haplotype\nthe module will try to find the answer to your question.\n\n=head1 CONSTRUCTORS\n\n    my $obj = Bio::PopGen::TagHaplotype -> new($hap);\n\n    were $hap is the reference to an array of array with the haplotype.\n\n    $hap= [[0, 0, 0],\n           [1, 0, 0],\n           [0, 1, 1]\n          ];\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Pedro M. Gomez-Fabre\n\nEmail pgf18872-at-gsk-dot-com\n\n\n\n# Let the code begin...\n\npackage Bio::PopGen::TagHaplotype;\nuse strict;\n\nuse Data::Dumper;\nuse Storable qw(dclone);\n\nuse base qw(Bio::Root::Root);\n\nmy $USAGE = <<EOF\nUsage:\n    Bio::PopGen::TagHaplotype->new(-haplotype_block => \\$hapblockref)\n\nEOF\n;\n\n=head2 new\n\n Title   : new\n Function: constructor of the class.\n Returns : self hash\n Args    : input haplotype (array of array)\n Status  : public\n\n\n#------------------------\nsub new{\n#------------------------\n    my ($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($haplotype_block) = $self->_rearrange([qw(HAPLOTYPE_BLOCK)],@args);\n\n    if ($haplotype_block) {\n        $self->haplotype_block($haplotype_block);\n    }\n    else{\n        $self->throw(\"haplotype has not been supplied\\n$USAGE\");\n    }\n\n    # check that the haplotype block is well formed.\n    for (my $i=0; $i<$#$haplotype_block+1; $i++){\n\tif ( $#{$haplotype_block->[0]} !=\n             $#{$haplotype_block->[$i]} ){\n\n            $self->throw(\"The haplotype matrix is not well formed (Not squared)\");\n        }\n    }\n\n    # make the calculation\n    my $tag_list =  _scan_snp( $self ->haplotype_block );\n\n    if ($tag_list){\n        $self ->tag_list($tag_list);\n    }\n    else { \n        $self ->tag_list(undef);\n    }\n\n    if ( defined $self->tag_list){\n        $self ->tag_length(scalar @{$self->tag_list});\n    }\n    else {\n        $self ->tag_length(0);  #\"NO TAGS FOUND!\"\n    }\n\n    return $self;\n}\n\n=head2 haplotype_block\n\n Title   : haplotype_block\n Usage   : my $haplotype_block = $TagHaplotype->haplotype_block();\n Function: Get the haplotype block for a haplotype tagging selection\n Returns : reference of array\n Args    : reference of array with haplotype pattern\n\n\n\nsub haplotype_block{\n    my ($self) =shift;\n    return $self->{'_haplotype_block'} = shift if @_;\n    return $self->{'_haplotype_block'};\n}\n\n\n=head2 input_block \n\n Title   : input_block \n Usage   : $obj->input_block()\n Function: returns haplotype block. By now will produce the same ouput than\n           $self->haplotype_block. but for compatiblity, this method is kept. \n           This method is deprecated.\n Returns : reference to array of array with the haplotype input value \n Args    : none \n Status  : public\n\n\n#------------------------\nsub input_block{\n#------------------------\n    my $self = shift;\n\n    $self->warn(ref($self). \"::input_block - deprecated method. Use haplotype_block() instead.\");\n    return $self->haplotype_block;\n}\n\n=head2 tag_list\n\n Title   : tag_list \n Usage   : $obj->tag_list()\n Function: returns the list of SNPs combination that identify the\n           haplotype. All combinations are displayed as arrays\n Returns : reference to array of array. \n Args    : none\n Status  : public\n\n\n#------------------------\nsub tag_list{\n#------------------------\n    my ($self) = shift;\n    return $self->{'_tag_list'}= shift if @_;\n    return $self->{'_tag_list'};\n}\n\n=head2 tag_length \n\n Title   : tag_length \n Usage   : $obj->tag_length()\n Function: returns the length of the tag.\n Returns : scalar \n Args    : none\n Status  : public\n\n\n#------------------------\nsub tag_length{\n#------------------------\n    my ($self) =shift;\n    return $self ->{'_tag_length'} = shift if @_;\n    return $self ->{'_tag_length'};\n}\n\n=head2 _scan_snp \n\n Title   : _scan_snp \n Usage   : internal\n Function: scan sets increasing the length until find a non degenerated\n           pattern. \n Returns : scalar\n Args    : none\n Status  : private\n\n\n#------------------------\nsub _scan_snp{\n#------------------------\n    my ($hap)=@_;\n\n    my $hap_length = scalar @{$hap->[0]};    ## store the haplotype length\n\n    for my $i(1..$hap_length){\n\n        my $list = _gen_comb($hap_length, $i);\n\n        my $snp_collection = _scan_combinations($hap, $list);\n\n        # if there is any element on the collection.\n        # We have reached our goal and \n        # we can stop the calculation.\n        if($#$snp_collection>-1){\n            return $snp_collection;\n        }\n    }\n}\n\n=head2 _gen_comb\n\n Title   : _gen_comb \n Usage   : internal\n Function: we supply the length of the haplotype and the length of the\n           word we need to find and the functions returns the possible\n           list of combinations.\n Returns : scalar\n Args    : none\n Status  : private\n\n\n#------------------------\nsub _gen_comb{\n#------------------------\n\n    my ($hap_length,$n) = @_;\n\n    my @array = ();    # list with all elements we have to combine\n\n    \n    for(0..$hap_length-1){ push @array, $_ };\n\n    #\n    # we need some parameters to create the combination list.\n    # This parameters can be changed if we can modify the list values\n    #\n\n    my $m = -1;      # this parameter start the calculation at value\n                     # m+1 on the recursive cicle.\n\n    my $value = [];  ## seems to have not too much sense here, but is\n                     ## needed on the recursion and need to be started\n                     ## from here\n    my $list = [];\n\n    _generateCombinations ( \\@array, \\$m, \\$n, $value, $list);\n\n    return $list;\n\n}\n\n=head2 _generateCombinations \n\n Title   : _generateCombinations \n Usage   : internal\n Function: Recursive function that produce all combinations for a set\n\n           i.e.:\n\n           1, 2, 3, 4\n\n           and word of B<3> will produce:\n\n           1, 2, 3\n           1, 2, 4\n           1, 3, 4\n           2, 3, 4\n\n Returns :\n Args    : none\n Status  : private\n\n\n#------------------------\nsub _generateCombinations{\n#------------------------\n    my ($rarr, $rm, $rn, $rvalue,$rlist)=@_;\n\n    for (my $i = ($$rm+1); $i<scalar @$rarr; $i++){\n        push (my @value2,@$rvalue,$rarr->[$i]);\n        if (scalar @value2<$$rn){\n            _generateCombinations($rarr,\\$i, $rn, \\@value2, $rlist);\n        }\n        if (scalar @value2==$$rn){\n            push @$rlist, [@value2];\n        }\n        if(scalar @value2>$$rn){\n            last;\n        }\n    }\n}\n\n# take the list of combinations\n# i.e.: 1 2 3\n#       1 2 4\n#       1 3 4\n#       2 3 4\n#\n# generate a sub array from the haplotype with the snp tag for the combination\n# and check all haplotypes for these columns.\n# if two haplotypes have the same value. we can not define the haplotype\n# without ambiguity.\n# Will return a list of valid combinations (SNP Tags)\n#\n\n=head2 _scan_combinations \n\n Title   : _scan_combinations \n Usage   : internal\n Function: take the haplotype and a list of possible combination\n           for that length. Generate a subset and scan it to find if\n           the information is enought to define the haplotype set.\n Returns :\n Args    : none\n Status  : private","parameters":[{"label":"$hap"},{"label":"$list"}]},"containerName":"main::","definition":"sub","range":{"start":{"line":377,"character":0},"end":{"character":9999,"line":395}},"name":"_scan_combinations"},{"name":"_get_subArray","line":388,"kind":12},{"name":"_deg_test","kind":12,"line":390},{"line":396,"kind":13,"containerName":null,"name":"$valid_combination"},{"range":{"start":{"line":401,"character":0},"end":{"line":416,"character":9999}},"name":"_deg_test","children":[{"line":404,"kind":13,"localvar":"my","containerName":"_deg_test","definition":"my","name":"$hap"},{"line":407,"kind":13,"localvar":"my","containerName":"_deg_test","name":"$c1","definition":"my"},{"containerName":"_deg_test","name":"$hap","line":407,"kind":13},{"kind":13,"line":408,"name":"$c2","definition":"my","containerName":"_deg_test","localvar":"my"},{"containerName":"_deg_test","name":"$c1","kind":13,"line":408},{"containerName":"_deg_test","name":"$hap","line":408,"kind":13},{"kind":13,"line":409,"definition":"my","name":"$degeneration","containerName":"_deg_test","localvar":"my"},{"name":"$hap","containerName":"_deg_test","line":409,"kind":13},{"name":"$c1","containerName":"_deg_test","line":409,"kind":13},{"containerName":"_deg_test","name":"$hap","kind":13,"line":409},{"line":409,"kind":13,"containerName":"_deg_test","name":"$c2"},{"name":"$degeneration","containerName":"_deg_test","kind":13,"line":410}],"line":401,"kind":12,"signature":{"label":"_deg_test($hap)","parameters":[{"label":"$hap"}],"documentation":" return 1 if two arrays are degenerated (same haplotype)"},"detail":"($hap)","definition":"sub","containerName":"main::"},{"kind":12,"line":409,"name":"compare_arrays"},{"containerName":"main::","definition":"sub","detail":"($hap,$combination)","signature":{"parameters":[{"label":"$hap"},{"label":"$combination"}],"documentation":"","label":"_get_subArray($hap,$combination)"},"kind":12,"line":419,"children":[{"kind":13,"line":421,"containerName":"_get_subArray","definition":"my","name":"$hap","localvar":"my"},{"line":421,"kind":13,"containerName":"_get_subArray","name":"$combination"},{"localvar":"my","containerName":"_get_subArray","name":"$out","definition":"my","line":423,"kind":13},{"localvar":"my","containerName":"_get_subArray","name":"$i","definition":"my","line":425,"kind":13},{"containerName":"_get_subArray","name":"$hap","line":425,"kind":13},{"kind":13,"line":426,"name":"$combination","containerName":"_get_subArray"},{"kind":13,"line":427,"containerName":"_get_subArray","name":"$out"},{"kind":13,"line":427,"name":"$i","containerName":"_get_subArray"},{"containerName":"_get_subArray","name":"$hap","kind":13,"line":427},{"kind":13,"line":427,"containerName":"_get_subArray","name":"$i"}],"name":"_get_subArray","range":{"end":{"line":429,"character":9999},"start":{"character":0,"line":419}}},{"containerName":null,"name":"$out","kind":13,"line":430},{"kind":12,"children":[{"kind":13,"line":442,"containerName":"compare_arrays","definition":"my","name":"$first","localvar":"my"},{"name":"$second","containerName":"compare_arrays","kind":13,"line":442},{"name":"$first","containerName":"compare_arrays","kind":13,"line":443},{"kind":13,"line":443,"containerName":"compare_arrays","name":"$second"},{"containerName":"compare_arrays","name":"$i","definition":"my","localvar":"my","kind":13,"line":444},{"name":"$i","containerName":"compare_arrays","line":444,"kind":13},{"kind":13,"line":444,"name":"$first","containerName":"compare_arrays"},{"line":444,"kind":13,"name":"$i","containerName":"compare_arrays"},{"line":445,"kind":13,"name":"$first","containerName":"compare_arrays"},{"line":445,"kind":13,"containerName":"compare_arrays","name":"$i"},{"kind":13,"line":445,"name":"$second","containerName":"compare_arrays"},{"containerName":"compare_arrays","name":"$i","kind":13,"line":445}],"line":440,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$first"},{"label":"$second"}],"documentation":" take two arrays and compare their values\n Returns : 1 if the two values are the same\n           0 if the values are different","label":"compare_arrays($first,$second)"},"detail":"($first,$second)","name":"compare_arrays","range":{"start":{"line":440,"character":0},"end":{"line":448,"character":9999}}}],"version":5}