{"vars":[{"kind":2,"line":99,"containerName":"","name":"base"},{"definition":"sub","containerName":"main::","signature":{"label":"name($self,@args)","documentation":"1;\n# $Id: PopulationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::PopulationI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::PopulationI - Interface for Populations\n\n=head1 SYNOPSIS\n\n  # Get Bio::PopGen::PopulationI object somehow, like\n  # from Bio::Population::Population\n\n  print \"name is \", $population->name(), \"\\n\";\n  print \"source is \", $population->source(), \"\\n\";\n  print \"description is \", $population->description(), \"\\n\";\n\n  print \"For marker $markername:\\n\";\n  foreach my $genotype ( $population->get_Genotypes(-marker => $markername) ) {\n      print \"Individual \", $genotype->individual_id, \" genotype alleles are \",\n      join(',', $genotype->get_Alleles()), \"\\n\";\n  }\n  # get a marker with allele frequencies calculated from the population\n  my $marker = $population->get_Marker($markername); \n  my %af = $marker->get_Allele_Frequencies;\n  foreach my $allele ( keys %af ) {\n      print \"$allele $af{$allele}\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basics of a population.  One can use this\nobject to get the genotypes of specific individuals, only those\nindividuals which have a certain marker, or create a marker with\nallele frequency information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::PopulationI;\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $pop->name\n Function: Get the population name\n Returns : string representing population name\n Args    : [optional] string representing population name","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","kind":12,"children":[{"line":113,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"name"},{"containerName":"name","name":"@args","line":113,"kind":13},{"kind":13,"line":114,"name":"$self","containerName":"name"},{"name":"throw_not_implemented","containerName":"name","line":114,"kind":12}],"line":112,"name":"name","range":{"end":{"character":9999,"line":115},"start":{"character":0,"line":112}}},{"range":{"start":{"character":0,"line":130},"end":{"line":133,"character":9999}},"name":"description","signature":{"label":"description($self,@args)","documentation":"1;\n# $Id: PopulationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::PopulationI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::PopulationI - Interface for Populations\n\n=head1 SYNOPSIS\n\n  # Get Bio::PopGen::PopulationI object somehow, like\n  # from Bio::Population::Population\n\n  print \"name is \", $population->name(), \"\\n\";\n  print \"source is \", $population->source(), \"\\n\";\n  print \"description is \", $population->description(), \"\\n\";\n\n  print \"For marker $markername:\\n\";\n  foreach my $genotype ( $population->get_Genotypes(-marker => $markername) ) {\n      print \"Individual \", $genotype->individual_id, \" genotype alleles are \",\n      join(',', $genotype->get_Alleles()), \"\\n\";\n  }\n  # get a marker with allele frequencies calculated from the population\n  my $marker = $population->get_Marker($markername); \n  my %af = $marker->get_Allele_Frequencies;\n  foreach my $allele ( keys %af ) {\n      print \"$allele $af{$allele}\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basics of a population.  One can use this\nobject to get the genotypes of specific individuals, only those\nindividuals which have a certain marker, or create a marker with\nallele frequency information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::PopulationI;\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $pop->name\n Function: Get the population name\n Returns : string representing population name\n Args    : [optional] string representing population name\n\n\n\nsub name{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $pop->description\n Function: Get the population description\n Returns : string representing population description\n Args    : [optional] string representing population description","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"line":131,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"description"},{"kind":13,"line":131,"name":"@args","containerName":"description"},{"containerName":"description","name":"$self","kind":13,"line":132},{"line":132,"kind":12,"name":"throw_not_implemented","containerName":"description"}],"line":130,"kind":12},{"name":"source","range":{"end":{"line":149,"character":9999},"start":{"character":0,"line":146}},"kind":12,"children":[{"localvar":"my","containerName":"source","name":"$self","definition":"my","line":147,"kind":13},{"name":"@args","containerName":"source","line":147,"kind":13},{"kind":13,"line":148,"containerName":"source","name":"$self"},{"kind":12,"line":148,"name":"throw_not_implemented","containerName":"source"}],"line":146,"definition":"sub","containerName":"main::","signature":{"label":"source($self,@args)","documentation":"1;\n# $Id: PopulationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::PopulationI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::PopulationI - Interface for Populations\n\n=head1 SYNOPSIS\n\n  # Get Bio::PopGen::PopulationI object somehow, like\n  # from Bio::Population::Population\n\n  print \"name is \", $population->name(), \"\\n\";\n  print \"source is \", $population->source(), \"\\n\";\n  print \"description is \", $population->description(), \"\\n\";\n\n  print \"For marker $markername:\\n\";\n  foreach my $genotype ( $population->get_Genotypes(-marker => $markername) ) {\n      print \"Individual \", $genotype->individual_id, \" genotype alleles are \",\n      join(',', $genotype->get_Alleles()), \"\\n\";\n  }\n  # get a marker with allele frequencies calculated from the population\n  my $marker = $population->get_Marker($markername); \n  my %af = $marker->get_Allele_Frequencies;\n  foreach my $allele ( keys %af ) {\n      print \"$allele $af{$allele}\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basics of a population.  One can use this\nobject to get the genotypes of specific individuals, only those\nindividuals which have a certain marker, or create a marker with\nallele frequency information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::PopulationI;\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $pop->name\n Function: Get the population name\n Returns : string representing population name\n Args    : [optional] string representing population name\n\n\n\nsub name{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $pop->description\n Function: Get the population description\n Returns : string representing population description\n Args    : [optional] string representing population description\n\n\n\nsub description{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $pop->source\n Function: Get the population source\n Returns : string representing population source\n Args    : [optional] string representing population source","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)"},{"kind":12,"line":163,"children":[{"kind":13,"line":164,"name":"$self","definition":"my","containerName":"annotation","localvar":"my"},{"kind":13,"line":165,"containerName":"annotation","name":"$self"},{"containerName":"annotation","name":"throw_not_implemented","line":165,"kind":12}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"annotation($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PopulationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::PopulationI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::PopulationI - Interface for Populations\n\n=head1 SYNOPSIS\n\n  # Get Bio::PopGen::PopulationI object somehow, like\n  # from Bio::Population::Population\n\n  print \"name is \", $population->name(), \"\\n\";\n  print \"source is \", $population->source(), \"\\n\";\n  print \"description is \", $population->description(), \"\\n\";\n\n  print \"For marker $markername:\\n\";\n  foreach my $genotype ( $population->get_Genotypes(-marker => $markername) ) {\n      print \"Individual \", $genotype->individual_id, \" genotype alleles are \",\n      join(',', $genotype->get_Alleles()), \"\\n\";\n  }\n  # get a marker with allele frequencies calculated from the population\n  my $marker = $population->get_Marker($markername); \n  my %af = $marker->get_Allele_Frequencies;\n  foreach my $allele ( keys %af ) {\n      print \"$allele $af{$allele}\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basics of a population.  One can use this\nobject to get the genotypes of specific individuals, only those\nindividuals which have a certain marker, or create a marker with\nallele frequency information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::PopulationI;\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $pop->name\n Function: Get the population name\n Returns : string representing population name\n Args    : [optional] string representing population name\n\n\n\nsub name{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $pop->description\n Function: Get the population description\n Returns : string representing population description\n Args    : [optional] string representing population description\n\n\n\nsub description{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $pop->source\n Function: Get the population source\n Returns : string representing population source\n Args    : [optional] string representing population source\n\n\n\nsub source{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $pop->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this population\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object"},"name":"annotation","range":{"end":{"character":9999,"line":166},"start":{"line":163,"character":0}}},{"kind":12,"line":183,"children":[{"line":184,"kind":12,"name":"throw_not_implemented","containerName":"get_Individuals"}],"containerName":"main::","name":"get_Individuals","definition":"sub","range":{"start":{"character":0,"line":183},"end":{"character":9999,"line":185}}},{"children":[{"line":200,"kind":12,"name":"throw_not_implemented","containerName":"get_Genotypes"}],"line":199,"kind":12,"range":{"start":{"character":0,"line":199},"end":{"character":9999,"line":201}},"definition":"sub","name":"get_Genotypes","containerName":"main::"},{"range":{"start":{"line":214,"character":0},"end":{"line":216,"character":9999}},"containerName":"main::","name":"get_Marker","definition":"sub","line":214,"children":[{"name":"throw_not_implemented","containerName":"get_Marker","line":215,"kind":12}],"kind":12},{"name":"get_marker_names","range":{"start":{"line":229,"character":0},"end":{"character":9999,"line":232}},"kind":12,"children":[{"localvar":"my","containerName":"get_marker_names","definition":"my","name":"$self","line":230,"kind":13},{"containerName":"get_marker_names","name":"$self","line":231,"kind":13},{"kind":12,"line":231,"containerName":"get_marker_names","name":"throw_not_implemented"}],"line":229,"definition":"sub","containerName":"main::","signature":{"label":"get_marker_names($self)","documentation":"1;\n# $Id: PopulationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::PopulationI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::PopulationI - Interface for Populations\n\n=head1 SYNOPSIS\n\n  # Get Bio::PopGen::PopulationI object somehow, like\n  # from Bio::Population::Population\n\n  print \"name is \", $population->name(), \"\\n\";\n  print \"source is \", $population->source(), \"\\n\";\n  print \"description is \", $population->description(), \"\\n\";\n\n  print \"For marker $markername:\\n\";\n  foreach my $genotype ( $population->get_Genotypes(-marker => $markername) ) {\n      print \"Individual \", $genotype->individual_id, \" genotype alleles are \",\n      join(',', $genotype->get_Alleles()), \"\\n\";\n  }\n  # get a marker with allele frequencies calculated from the population\n  my $marker = $population->get_Marker($markername); \n  my %af = $marker->get_Allele_Frequencies;\n  foreach my $allele ( keys %af ) {\n      print \"$allele $af{$allele}\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basics of a population.  One can use this\nobject to get the genotypes of specific individuals, only those\nindividuals which have a certain marker, or create a marker with\nallele frequency information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::PopulationI;\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $pop->name\n Function: Get the population name\n Returns : string representing population name\n Args    : [optional] string representing population name\n\n\n\nsub name{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $pop->description\n Function: Get the population description\n Returns : string representing population description\n Args    : [optional] string representing population description\n\n\n\nsub description{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $pop->source\n Function: Get the population source\n Returns : string representing population source\n Args    : [optional] string representing population source\n\n\n\nsub source{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $pop->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this population\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\n\nsub annotation{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_Individuals\n\n Title   : get_Individuals\n Usage   : my @inds = $pop->get_Individuals();\n Function: Return the individuals, alternatively restrict by a criteria\n Returns : Array of L<Bio::PopGen::IndividualI> objects\n Args    : none if want all the individuals OR,\n           -unique_id => To get an individual with a specific id\n           -marker    => To only get individuals which have a genotype specific\n                        for a specific marker name\n\n\n\n\nsub get_Individuals{\n    shift->throw_not_implemented();\n}\n\n=head2 get_Genotypes\n\n Title   : get_Genotypes\n Usage   : my @genotypes = $pop->get_Genotypes(-marker => $name)\n Function: Get the genotypes for all the individuals for a specific\n           marker name\n Returns : Array of L<Bio::PopGen::GenotypeI> objects\n Args    : -marker => name of the marker\n\n\n\nsub get_Genotypes{\n    shift->throw_not_implemented;\n}\n\n=head2 get_Marker\n\n Title   : get_Marker\n Usage   : my $marker = $population->get_Marker($name)\n Function: Get a Bio::PopGen::Marker object based on this population\n Returns : L<Bio::PopGen::MarkerI> object\n Args    : name of the marker\n\n\n\nsub get_Marker{\n    shift->throw_not_implemented();\n}\n\n=head2 get_marker_names\n\n Title   : get_marker_names\n Usage   : my @names = $pop->get_marker_names;\n Function: Get the names of the markers\n Returns : Array of strings\n Args    : none","parameters":[{"label":"$self"}]},"detail":"($self)"},{"kind":12,"line":247,"children":[{"containerName":"get_Markers","name":"$self","definition":"my","localvar":"my","kind":13,"line":248},{"line":249,"kind":13,"containerName":"get_Markers","name":"$self"},{"name":"get_Marker","containerName":"get_Markers","kind":12,"line":249},{"kind":13,"line":249,"containerName":"get_Markers","name":"$self"},{"name":"get_marker_names","containerName":"get_Markers","line":249,"kind":12}],"containerName":"main::","definition":"sub","name":"get_Markers","range":{"end":{"character":9999,"line":250},"start":{"line":247,"character":0}}},{"line":265,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"get_number_individuals","line":266,"kind":13},{"containerName":"get_number_individuals","name":"$self","kind":13,"line":267},{"name":"throw_not_implemented","containerName":"get_number_individuals","kind":12,"line":267}],"kind":12,"detail":"($self)","signature":{"label":"get_number_individuals($self)","documentation":"1;\n# $Id: PopulationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::PopulationI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::PopulationI - Interface for Populations\n\n=head1 SYNOPSIS\n\n  # Get Bio::PopGen::PopulationI object somehow, like\n  # from Bio::Population::Population\n\n  print \"name is \", $population->name(), \"\\n\";\n  print \"source is \", $population->source(), \"\\n\";\n  print \"description is \", $population->description(), \"\\n\";\n\n  print \"For marker $markername:\\n\";\n  foreach my $genotype ( $population->get_Genotypes(-marker => $markername) ) {\n      print \"Individual \", $genotype->individual_id, \" genotype alleles are \",\n      join(',', $genotype->get_Alleles()), \"\\n\";\n  }\n  # get a marker with allele frequencies calculated from the population\n  my $marker = $population->get_Marker($markername); \n  my %af = $marker->get_Allele_Frequencies;\n  foreach my $allele ( keys %af ) {\n      print \"$allele $af{$allele}\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the basics of a population.  One can use this\nobject to get the genotypes of specific individuals, only those\nindividuals which have a certain marker, or create a marker with\nallele frequency information.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::PopulationI;\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $pop->name\n Function: Get the population name\n Returns : string representing population name\n Args    : [optional] string representing population name\n\n\n\nsub name{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $pop->description\n Function: Get the population description\n Returns : string representing population description\n Args    : [optional] string representing population description\n\n\n\nsub description{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $pop->source\n Function: Get the population source\n Returns : string representing population source\n Args    : [optional] string representing population source\n\n\n\nsub source{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $pop->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this population\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\n\nsub annotation{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 get_Individuals\n\n Title   : get_Individuals\n Usage   : my @inds = $pop->get_Individuals();\n Function: Return the individuals, alternatively restrict by a criteria\n Returns : Array of L<Bio::PopGen::IndividualI> objects\n Args    : none if want all the individuals OR,\n           -unique_id => To get an individual with a specific id\n           -marker    => To only get individuals which have a genotype specific\n                        for a specific marker name\n\n\n\n\nsub get_Individuals{\n    shift->throw_not_implemented();\n}\n\n=head2 get_Genotypes\n\n Title   : get_Genotypes\n Usage   : my @genotypes = $pop->get_Genotypes(-marker => $name)\n Function: Get the genotypes for all the individuals for a specific\n           marker name\n Returns : Array of L<Bio::PopGen::GenotypeI> objects\n Args    : -marker => name of the marker\n\n\n\nsub get_Genotypes{\n    shift->throw_not_implemented;\n}\n\n=head2 get_Marker\n\n Title   : get_Marker\n Usage   : my $marker = $population->get_Marker($name)\n Function: Get a Bio::PopGen::Marker object based on this population\n Returns : L<Bio::PopGen::MarkerI> object\n Args    : name of the marker\n\n\n\nsub get_Marker{\n    shift->throw_not_implemented();\n}\n\n=head2 get_marker_names\n\n Title   : get_marker_names\n Usage   : my @names = $pop->get_marker_names;\n Function: Get the names of the markers\n Returns : Array of strings\n Args    : none\n\n\n\nsub get_marker_names{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 get_Markers\n\n Title   : get_Markers\n Usage   : my @markers = $pop->get_Markers();\n Function: Will retrieve a list of instantiated MarkerI objects \n           for a population.  This is a convience method combining\n           get_marker_names with get_Marker\n Returns : List of array of Bio::PopGen::MarkerI objects\n Args    : none\n\n\n\nsub get_Markers{\n    my ($self) = shift;\n    return map { $self->get_Marker($_) } $self->get_marker_names();\n}\n\n\n=head2 get_number_individuals\n\n Title   : get_number_individuals\n Usage   : my $count = $pop->get_number_individuals;\n Function: Get the count of the number of individuals\n Returns : integer >= 0\n Args    : [optional] marker name, will return a count of the number\n           of individuals which have this marker","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub","range":{"end":{"line":268,"character":9999},"start":{"line":265,"character":0}},"name":"get_number_individuals"}],"version":5}