{"version":5,"vars":[{"kind":2,"line":85,"containerName":"","name":"vars"},{"containerName":"","name":"strict","kind":2,"line":88},{"line":88,"kind":13,"containerName":null,"name":"$FieldDelim"},{"containerName":null,"name":"$Header","kind":13,"line":88},{"line":95,"kind":2,"containerName":"","name":"base"},{"detail":"($self,@args)","signature":{"documentation":"1;\n# $Id: prettybase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::prettybase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::prettybase - Extract individual allele data from PrettyBase format\n\n=head1 SYNOPSIS\n\nDo not use directly, use through the Bio::PopGen::IO driver\n\n=head1 DESCRIPTION\n\nThis object will parse comma delimited PrettyBase output.  PrettyBase\nis defined by the SeattleSNPs http://pga.gs.washington.edu/\n\nThis is expected to be tab delimited (you can vary with the\nfield_delimiter flag SITE SAMPLE ALLELE1 ALLELE2\n\nThere are 2 initialization parameters, the delimiter\n(-field_delimiter) [default 'tab'] and a boolean -no_header which\nspecifies if there is no header line to read in.  All lines starting\nwith '#' will be skipped\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::prettybase;\nuse vars qw($FieldDelim $Header);\nuse strict;\n\n($FieldDelim,$Header) =( '\\t',0);\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::prettybase->new();\n Function: Builds a new Bio::PopGen::IO::prettybase object \n Returns : an instance of Bio::PopGen::IO::prettybase\n Args    : -field_delimiter      => a field delimiter character or regexp (default is /\\t/ ) \n           -header               => boolean if the file will have a header and parser should\n                                    skip first line in the file (default is false)\n           -convert_indel_states => convert alleles which are longer than one character\n                                    to an 'I' meaning insert state, and alleles which are\n                                    '-' to a delete state.\n                                    (default is false)","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_initialize($self,@args)"},"containerName":"main::","definition":"sub","line":113,"children":[{"definition":"my","name":"$self","containerName":"_initialize","localvar":"my","kind":13,"line":114},{"line":114,"kind":13,"name":"@args","containerName":"_initialize"},{"localvar":"my","containerName":"_initialize","name":"$fieldsep","definition":"my","line":115,"kind":13},{"kind":13,"line":116,"name":"$conv_indels","containerName":"_initialize"},{"line":117,"kind":13,"containerName":"_initialize","name":"$header"},{"name":"$self","containerName":"_initialize","kind":13,"line":117},{"containerName":"_initialize","name":"_rearrange","line":117,"kind":12},{"name":"@args","containerName":"_initialize","line":119,"kind":13},{"line":121,"kind":13,"name":"$self","containerName":"_initialize"},{"kind":12,"line":121,"name":"flag","containerName":"_initialize"},{"line":121,"kind":13,"containerName":"_initialize","name":"$header"},{"line":121,"kind":13,"name":"$header","containerName":"_initialize"},{"name":"$Header","containerName":"_initialize","kind":13,"line":121},{"line":122,"kind":13,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"flag","line":122,"kind":12},{"containerName":"_initialize","name":"$fieldsep","kind":13,"line":122},{"containerName":"_initialize","name":"$fieldsep","kind":13,"line":122},{"kind":13,"line":122,"name":"$FieldDelim","containerName":"_initialize"},{"containerName":"_initialize","name":"$self","kind":13,"line":123},{"containerName":"_initialize","name":"$self","kind":13,"line":124},{"line":125,"kind":13,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"$self","kind":13,"line":126},{"line":126,"kind":12,"name":"flag","containerName":"_initialize"},{"containerName":"_initialize","name":"$conv_indels","kind":13,"line":126}],"kind":12,"range":{"start":{"line":113,"character":0},"end":{"line":128,"character":9999}},"name":"_initialize"},{"range":{"end":{"character":9999,"line":150},"start":{"line":143,"character":0}},"containerName":"main::","definition":"sub","name":"flag","line":143,"children":[{"kind":13,"line":144,"name":"$self","definition":"my","containerName":"flag","localvar":"my"},{"name":"$fieldname","definition":"my","containerName":"flag","localvar":"my","kind":13,"line":145},{"containerName":"flag","name":"$fieldname","kind":13,"line":146},{"containerName":"flag","name":"$self","line":148,"kind":13},{"name":"$fieldname","containerName":"flag","line":148,"kind":13},{"line":149,"kind":13,"name":"$self","containerName":"flag"},{"containerName":"flag","name":"$fieldname","line":149,"kind":13}],"kind":12},{"name":"next_individual","range":{"start":{"character":0,"line":164},"end":{"character":9999,"line":170}},"kind":12,"children":[{"line":165,"kind":13,"localvar":"my","containerName":"next_individual","definition":"my","name":"$self"},{"containerName":"next_individual","name":"$self","line":166,"kind":13},{"kind":13,"line":167,"containerName":"next_individual","name":"$self"},{"line":167,"kind":12,"name":"_parse_prettybase","containerName":"next_individual"},{"name":"$self","containerName":"next_individual","line":169,"kind":13},{"name":"$self","containerName":"next_individual","line":169,"kind":13}],"line":164,"definition":"sub","containerName":"main::","signature":{"label":"next_individual($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: prettybase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::prettybase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::prettybase - Extract individual allele data from PrettyBase format\n\n=head1 SYNOPSIS\n\nDo not use directly, use through the Bio::PopGen::IO driver\n\n=head1 DESCRIPTION\n\nThis object will parse comma delimited PrettyBase output.  PrettyBase\nis defined by the SeattleSNPs http://pga.gs.washington.edu/\n\nThis is expected to be tab delimited (you can vary with the\nfield_delimiter flag SITE SAMPLE ALLELE1 ALLELE2\n\nThere are 2 initialization parameters, the delimiter\n(-field_delimiter) [default 'tab'] and a boolean -no_header which\nspecifies if there is no header line to read in.  All lines starting\nwith '#' will be skipped\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::prettybase;\nuse vars qw($FieldDelim $Header);\nuse strict;\n\n($FieldDelim,$Header) =( '\\t',0);\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::prettybase->new();\n Function: Builds a new Bio::PopGen::IO::prettybase object \n Returns : an instance of Bio::PopGen::IO::prettybase\n Args    : -field_delimiter      => a field delimiter character or regexp (default is /\\t/ ) \n           -header               => boolean if the file will have a header and parser should\n                                    skip first line in the file (default is false)\n           -convert_indel_states => convert alleles which are longer than one character\n                                    to an 'I' meaning insert state, and alleles which are\n                                    '-' to a delete state.\n                                    (default is false)\n\n\nsub _initialize {\n    my($self, @args) = @_;\n    my ($fieldsep,\n\t$conv_indels,\n\t$header) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t CONVERT_INDEL_STATES\n\t\t\t\t\t HEADER)],@args);\n\n    $self->flag('header', defined $header ? $header : $Header);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->{'_header'} = undef;\n    $self->{'_parsed_individiuals'} = [];\n    $self->{'_parsed'} = 0;\n    $self->flag('convert_indel',$conv_indels || 0);\n    return 1;\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\n\nsub flag{\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n    \n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n}\n\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : Bio::PopGen::IndividualI object\n Args    : none"},"detail":"($self)"},{"name":"next_population","range":{"end":{"line":197,"character":9999},"start":{"character":0,"line":189}},"kind":12,"children":[{"localvar":"my","containerName":"next_population","definition":"my","name":"$self","line":190,"kind":13},{"kind":13,"line":191,"containerName":"next_population","name":"@inds","definition":"my","localvar":"my"},{"name":"$ind","definition":"my","containerName":"next_population","localvar":"my","kind":13,"line":192},{"line":192,"kind":13,"containerName":"next_population","name":"$self"},{"containerName":"next_population","name":"next_individual","line":192,"kind":12},{"line":193,"kind":13,"containerName":"next_population","name":"@inds"},{"containerName":"next_population","name":"$ind","line":193,"kind":13},{"name":"@inds","containerName":"next_population","line":195,"kind":13},{"line":196,"kind":12,"name":"new","containerName":"next_population"},{"containerName":"next_population","name":"@inds","kind":13,"line":196}],"line":189,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: prettybase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::prettybase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::prettybase - Extract individual allele data from PrettyBase format\n\n=head1 SYNOPSIS\n\nDo not use directly, use through the Bio::PopGen::IO driver\n\n=head1 DESCRIPTION\n\nThis object will parse comma delimited PrettyBase output.  PrettyBase\nis defined by the SeattleSNPs http://pga.gs.washington.edu/\n\nThis is expected to be tab delimited (you can vary with the\nfield_delimiter flag SITE SAMPLE ALLELE1 ALLELE2\n\nThere are 2 initialization parameters, the delimiter\n(-field_delimiter) [default 'tab'] and a boolean -no_header which\nspecifies if there is no header line to read in.  All lines starting\nwith '#' will be skipped\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::prettybase;\nuse vars qw($FieldDelim $Header);\nuse strict;\n\n($FieldDelim,$Header) =( '\\t',0);\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::prettybase->new();\n Function: Builds a new Bio::PopGen::IO::prettybase object \n Returns : an instance of Bio::PopGen::IO::prettybase\n Args    : -field_delimiter      => a field delimiter character or regexp (default is /\\t/ ) \n           -header               => boolean if the file will have a header and parser should\n                                    skip first line in the file (default is false)\n           -convert_indel_states => convert alleles which are longer than one character\n                                    to an 'I' meaning insert state, and alleles which are\n                                    '-' to a delete state.\n                                    (default is false)\n\n\nsub _initialize {\n    my($self, @args) = @_;\n    my ($fieldsep,\n\t$conv_indels,\n\t$header) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t CONVERT_INDEL_STATES\n\t\t\t\t\t HEADER)],@args);\n\n    $self->flag('header', defined $header ? $header : $Header);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->{'_header'} = undef;\n    $self->{'_parsed_individiuals'} = [];\n    $self->{'_parsed'} = 0;\n    $self->flag('convert_indel',$conv_indels || 0);\n    return 1;\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\n\nsub flag{\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n    \n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n}\n\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : Bio::PopGen::IndividualI object\n Args    : none\n\n\n\nsub next_individual {\n    my ($self) = @_;\n    unless( $self->{'_parsed'} ) {\n\t$self->_parse_prettybase;\n    }\n    return $self->{'_parsed_individiuals'}->[$self->{'_iterator'}++];\n}\n\n\n\n=head2 next_population\n\n Title   : next_population\n Usage   : my $ind = $popgenio->next_population;\n Function: Retrieve the next population from a dataset\n Returns : Bio::PopGen::PopulationI object\n Args    : none\n Note    : Many implementation will not implement this\n\n Plan is to just return the whole dataset as a single population by\n default I think - people would then have each population in a separate\n file.","label":"next_population($self)"},"detail":"($self)"},{"line":196,"kind":12,"name":"Bio","containerName":"PopGen::Population"},{"definition":"sub","name":"_parse_prettybase","containerName":"main::","range":{"end":{"line":239,"character":9999},"start":{"character":0,"line":200}},"kind":12,"children":[{"kind":13,"line":201,"name":"$self","definition":"my","containerName":"_parse_prettybase","localvar":"my"},{"kind":13,"line":202,"definition":"my","name":"%inds","containerName":"_parse_prettybase","localvar":"my"},{"containerName":"_parse_prettybase","name":"$convert_indels","definition":"my","localvar":"my","kind":13,"line":203},{"containerName":"_parse_prettybase","name":"$self","kind":13,"line":203},{"containerName":"_parse_prettybase","name":"flag","kind":12,"line":203},{"name":"$self","containerName":"_parse_prettybase","line":204,"kind":13},{"line":204,"kind":12,"name":"_readline","containerName":"_parse_prettybase"},{"kind":13,"line":207,"definition":"my","name":"$site","containerName":"_parse_prettybase","localvar":"my"},{"containerName":"_parse_prettybase","name":"$sample","line":207,"kind":13},{"name":"@alleles","containerName":"_parse_prettybase","line":207,"kind":13},{"name":"$self","containerName":"_parse_prettybase","kind":13,"line":207},{"kind":12,"line":207,"name":"flag","containerName":"_parse_prettybase"},{"containerName":"_parse_prettybase","name":"$sample","kind":13,"line":208},{"localvar":"my","definition":"my","name":"$allele","containerName":"_parse_prettybase","line":212,"kind":13},{"name":"@alleles","containerName":"_parse_prettybase","kind":13,"line":212},{"line":213,"kind":13,"containerName":"_parse_prettybase","name":"$allele"},{"containerName":"_parse_prettybase","name":"$allele","kind":13,"line":214},{"containerName":"_parse_prettybase","name":"$convert_indels","line":215,"kind":13},{"name":"$allele","containerName":"_parse_prettybase","line":216,"kind":13},{"name":"$allele","containerName":"_parse_prettybase","line":218,"kind":13},{"name":"$allele","containerName":"_parse_prettybase","kind":13,"line":219},{"containerName":"_parse_prettybase","name":"$allele","line":221,"kind":13},{"localvar":"my","definition":"my","name":"$g","containerName":"_parse_prettybase","line":226,"kind":13},{"kind":12,"line":226,"containerName":"_parse_prettybase","name":"new"},{"containerName":"_parse_prettybase","name":"@alleles","kind":13,"line":226},{"line":227,"kind":13,"name":"$site","containerName":"_parse_prettybase"},{"name":"$sample","containerName":"_parse_prettybase","line":228,"kind":13},{"line":231,"kind":13,"name":"$inds","containerName":"_parse_prettybase"},{"kind":13,"line":231,"containerName":"_parse_prettybase","name":"$sample"},{"kind":13,"line":232,"containerName":"_parse_prettybase","name":"$inds"},{"containerName":"_parse_prettybase","name":"$sample","kind":13,"line":232},{"kind":12,"line":232,"containerName":"_parse_prettybase","name":"new"},{"containerName":"_parse_prettybase","name":"$sample","kind":13,"line":232},{"line":234,"kind":13,"name":"$inds","containerName":"_parse_prettybase"},{"name":"$sample","containerName":"_parse_prettybase","line":234,"kind":13},{"line":234,"kind":12,"containerName":"_parse_prettybase","name":"add_Genotype"},{"line":234,"kind":13,"containerName":"_parse_prettybase","name":"$g"},{"name":"$self","containerName":"_parse_prettybase","line":236,"kind":13},{"name":"%inds","containerName":"_parse_prettybase","line":236,"kind":13},{"name":"$self","containerName":"_parse_prettybase","kind":13,"line":237}],"line":200},{"kind":12,"line":226,"name":"Bio","containerName":"PopGen::Genotype"},{"containerName":"PopGen::Individual","name":"Bio","line":232,"kind":12},{"line":252,"children":[{"containerName":"write_individual","definition":"my","name":"$self","localvar":"my","kind":13,"line":253},{"name":"@inds","containerName":"write_individual","kind":13,"line":253},{"localvar":"my","definition":"my","name":"$ind","containerName":"write_individual","line":254,"kind":13},{"containerName":"write_individual","name":"@inds","kind":13,"line":254},{"containerName":"write_individual","name":"$ind","line":255,"kind":13},{"line":255,"kind":13,"name":"$ind","containerName":"write_individual"},{"name":"isa","containerName":"write_individual","line":255,"kind":12},{"kind":13,"line":256,"name":"$self","containerName":"write_individual"},{"kind":12,"line":256,"name":"warn","containerName":"write_individual"},{"localvar":"my","name":"$marker","definition":"my","containerName":"write_individual","line":259,"kind":13},{"kind":13,"line":259,"containerName":"write_individual","name":"$ind"},{"kind":12,"line":259,"name":"get_marker_names","containerName":"write_individual"},{"localvar":"my","definition":"my","name":"$g","containerName":"write_individual","line":260,"kind":13},{"containerName":"write_individual","name":"$ind","kind":13,"line":260},{"name":"get_Genotypes","containerName":"write_individual","line":260,"kind":12},{"kind":13,"line":260,"containerName":"write_individual","name":"$marker"},{"containerName":"write_individual","name":"$g","line":261,"kind":13},{"line":262,"kind":13,"containerName":"write_individual","name":"$self"},{"containerName":"write_individual","name":"_print","line":262,"kind":12},{"line":262,"kind":13,"containerName":"write_individual","name":"$marker"},{"name":"$ind","containerName":"write_individual","kind":13,"line":262},{"line":262,"kind":12,"name":"unique_id","containerName":"write_individual"},{"name":"$g","containerName":"write_individual","kind":13,"line":263},{"containerName":"write_individual","name":"get_Alleles","line":263,"kind":12}],"kind":12,"detail":"($self,@inds)","signature":{"label":"write_individual($self,@inds)","documentation":"1;\n# $Id: prettybase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::prettybase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::prettybase - Extract individual allele data from PrettyBase format\n\n=head1 SYNOPSIS\n\nDo not use directly, use through the Bio::PopGen::IO driver\n\n=head1 DESCRIPTION\n\nThis object will parse comma delimited PrettyBase output.  PrettyBase\nis defined by the SeattleSNPs http://pga.gs.washington.edu/\n\nThis is expected to be tab delimited (you can vary with the\nfield_delimiter flag SITE SAMPLE ALLELE1 ALLELE2\n\nThere are 2 initialization parameters, the delimiter\n(-field_delimiter) [default 'tab'] and a boolean -no_header which\nspecifies if there is no header line to read in.  All lines starting\nwith '#' will be skipped\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::prettybase;\nuse vars qw($FieldDelim $Header);\nuse strict;\n\n($FieldDelim,$Header) =( '\\t',0);\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::prettybase->new();\n Function: Builds a new Bio::PopGen::IO::prettybase object \n Returns : an instance of Bio::PopGen::IO::prettybase\n Args    : -field_delimiter      => a field delimiter character or regexp (default is /\\t/ ) \n           -header               => boolean if the file will have a header and parser should\n                                    skip first line in the file (default is false)\n           -convert_indel_states => convert alleles which are longer than one character\n                                    to an 'I' meaning insert state, and alleles which are\n                                    '-' to a delete state.\n                                    (default is false)\n\n\nsub _initialize {\n    my($self, @args) = @_;\n    my ($fieldsep,\n\t$conv_indels,\n\t$header) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t CONVERT_INDEL_STATES\n\t\t\t\t\t HEADER)],@args);\n\n    $self->flag('header', defined $header ? $header : $Header);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->{'_header'} = undef;\n    $self->{'_parsed_individiuals'} = [];\n    $self->{'_parsed'} = 0;\n    $self->flag('convert_indel',$conv_indels || 0);\n    return 1;\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\n\nsub flag{\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n    \n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n}\n\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : Bio::PopGen::IndividualI object\n Args    : none\n\n\n\nsub next_individual {\n    my ($self) = @_;\n    unless( $self->{'_parsed'} ) {\n\t$self->_parse_prettybase;\n    }\n    return $self->{'_parsed_individiuals'}->[$self->{'_iterator'}++];\n}\n\n\n\n=head2 next_population\n\n Title   : next_population\n Usage   : my $ind = $popgenio->next_population;\n Function: Retrieve the next population from a dataset\n Returns : Bio::PopGen::PopulationI object\n Args    : none\n Note    : Many implementation will not implement this\n\n\n# Plan is to just return the whole dataset as a single population by \n# default I think - people would then have each population in a separate\n# file.\n\nsub next_population{\n    my ($self) = @_;\n    my @inds;\n    while( my $ind = $self->next_individual ) {\n\tpush @inds, $ind;\n    }\n    return unless @inds;\n    Bio::PopGen::Population->new(-individuals => \\@inds);\n}\n\n\nsub _parse_prettybase {\n    my $self = shift;\n    my %inds;\n    my $convert_indels = $self->flag('convert_indel');\n    while( defined( $_ = $self->_readline) ) {\n\tnext if( /^\\s*\\#/ || /^\\s+$/ || ! length($_) );\n\t\n\tmy ($site,$sample,@alleles) = split($self->flag('field_delimiter'),$_);\n\tif( ! defined $sample ) { \n\t    warn(\"sample id is undefined for $_\");\n\t    next;\n\t}\n\tfor my $allele ( @alleles ) {\n\t    $allele =~ s/^\\s+//;\n\t    $allele =~ s/\\s+$//;\n\t    if( $convert_indels ) {\n\t\tif( length($allele) > 1 ) {\n\t\t    # we have an insert state\n\t\t    $allele = 'I';\n\t\t} elsif( $allele eq '-' ) {\n\t\t    # have a delete state\n\t\t    $allele = 'D';\n\t\t}\n\t    }\n\t}\n\t\n\tmy $g = Bio::PopGen::Genotype->new(-alleles      => \\@alleles,\n\t\t\t\t\t  -marker_name  => $site,\n\t\t\t\t\t  -individual_id=> $sample); \n\t\n\n\tif( ! defined $inds{$sample} ) {\n\t    $inds{$sample} = Bio::PopGen::Individual->new(-unique_id => $sample);\n\t}\n\t$inds{$sample}->add_Genotype($g);\n    }\n    $self->{'_parsed_individiuals'} = [ values %inds ];\n    $self->{'_parsed'} = 1;\n    return;\n}\n\n\n=head2 write_individual\n\n Title   : write_individual\n Usage   : $popgenio->write_individual($ind);\n Function: Write an individual out in the file format\n Returns : none\n Args    : L<Bio::PopGen::PopulationI> object(s)","parameters":[{"label":"$self"},{"label":"@inds"}]},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":252},"end":{"character":9999,"line":267}},"name":"write_individual"},{"name":"write_population","range":{"end":{"character":9999,"line":304},"start":{"character":0,"line":282}},"definition":"sub","containerName":"main::","signature":{"label":"write_population($self,@pops)","parameters":[{"label":"$self"},{"label":"@pops"}],"documentation":"1;\n# $Id: prettybase.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO::prettybase\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO::prettybase - Extract individual allele data from PrettyBase format\n\n=head1 SYNOPSIS\n\nDo not use directly, use through the Bio::PopGen::IO driver\n\n=head1 DESCRIPTION\n\nThis object will parse comma delimited PrettyBase output.  PrettyBase\nis defined by the SeattleSNPs http://pga.gs.washington.edu/\n\nThis is expected to be tab delimited (you can vary with the\nfield_delimiter flag SITE SAMPLE ALLELE1 ALLELE2\n\nThere are 2 initialization parameters, the delimiter\n(-field_delimiter) [default 'tab'] and a boolean -no_header which\nspecifies if there is no header line to read in.  All lines starting\nwith '#' will be skipped\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::IO::prettybase;\nuse vars qw($FieldDelim $Header);\nuse strict;\n\n($FieldDelim,$Header) =( '\\t',0);\n\n\nuse Bio::PopGen::Individual;\nuse Bio::PopGen::Population;\nuse Bio::PopGen::Genotype;\n\nuse base qw(Bio::PopGen::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO::prettybase->new();\n Function: Builds a new Bio::PopGen::IO::prettybase object \n Returns : an instance of Bio::PopGen::IO::prettybase\n Args    : -field_delimiter      => a field delimiter character or regexp (default is /\\t/ ) \n           -header               => boolean if the file will have a header and parser should\n                                    skip first line in the file (default is false)\n           -convert_indel_states => convert alleles which are longer than one character\n                                    to an 'I' meaning insert state, and alleles which are\n                                    '-' to a delete state.\n                                    (default is false)\n\n\nsub _initialize {\n    my($self, @args) = @_;\n    my ($fieldsep,\n\t$conv_indels,\n\t$header) = $self->_rearrange([qw(FIELD_DELIMITER\n\t\t\t\t\t CONVERT_INDEL_STATES\n\t\t\t\t\t HEADER)],@args);\n\n    $self->flag('header', defined $header ? $header : $Header);\n    $self->flag('field_delimiter',defined $fieldsep ? $fieldsep : $FieldDelim);\n    $self->{'_header'} = undef;\n    $self->{'_parsed_individiuals'} = [];\n    $self->{'_parsed'} = 0;\n    $self->flag('convert_indel',$conv_indels || 0);\n    return 1;\n}\n\n=head2 flag\n\n Title   : flag\n Usage   : $obj->flag($flagname,$newval)\n Function: Get/Set the flag value\n Returns : value of a flag (a boolean)\n Args    : A flag name, currently we expect \n           'header', 'field_delimiter', or 'allele_delimiter' \n           on set, new value (a boolean or undef, optional)\n\n\n\nsub flag{\n    my $self = shift;\n    my $fieldname = shift;\n    return unless defined $fieldname;\n    \n    return $self->{'_flag'}->{$fieldname} = shift if @_;\n    return $self->{'_flag'}->{$fieldname};\n}\n\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : Bio::PopGen::IndividualI object\n Args    : none\n\n\n\nsub next_individual {\n    my ($self) = @_;\n    unless( $self->{'_parsed'} ) {\n\t$self->_parse_prettybase;\n    }\n    return $self->{'_parsed_individiuals'}->[$self->{'_iterator'}++];\n}\n\n\n\n=head2 next_population\n\n Title   : next_population\n Usage   : my $ind = $popgenio->next_population;\n Function: Retrieve the next population from a dataset\n Returns : Bio::PopGen::PopulationI object\n Args    : none\n Note    : Many implementation will not implement this\n\n\n# Plan is to just return the whole dataset as a single population by \n# default I think - people would then have each population in a separate\n# file.\n\nsub next_population{\n    my ($self) = @_;\n    my @inds;\n    while( my $ind = $self->next_individual ) {\n\tpush @inds, $ind;\n    }\n    return unless @inds;\n    Bio::PopGen::Population->new(-individuals => \\@inds);\n}\n\n\nsub _parse_prettybase {\n    my $self = shift;\n    my %inds;\n    my $convert_indels = $self->flag('convert_indel');\n    while( defined( $_ = $self->_readline) ) {\n\tnext if( /^\\s*\\#/ || /^\\s+$/ || ! length($_) );\n\t\n\tmy ($site,$sample,@alleles) = split($self->flag('field_delimiter'),$_);\n\tif( ! defined $sample ) { \n\t    warn(\"sample id is undefined for $_\");\n\t    next;\n\t}\n\tfor my $allele ( @alleles ) {\n\t    $allele =~ s/^\\s+//;\n\t    $allele =~ s/\\s+$//;\n\t    if( $convert_indels ) {\n\t\tif( length($allele) > 1 ) {\n\t\t    # we have an insert state\n\t\t    $allele = 'I';\n\t\t} elsif( $allele eq '-' ) {\n\t\t    # have a delete state\n\t\t    $allele = 'D';\n\t\t}\n\t    }\n\t}\n\t\n\tmy $g = Bio::PopGen::Genotype->new(-alleles      => \\@alleles,\n\t\t\t\t\t  -marker_name  => $site,\n\t\t\t\t\t  -individual_id=> $sample); \n\t\n\n\tif( ! defined $inds{$sample} ) {\n\t    $inds{$sample} = Bio::PopGen::Individual->new(-unique_id => $sample);\n\t}\n\t$inds{$sample}->add_Genotype($g);\n    }\n    $self->{'_parsed_individiuals'} = [ values %inds ];\n    $self->{'_parsed'} = 1;\n    return;\n}\n\n\n=head2 write_individual\n\n Title   : write_individual\n Usage   : $popgenio->write_individual($ind);\n Function: Write an individual out in the file format\n Returns : none\n Args    : L<Bio::PopGen::PopulationI> object(s)\n\n\nsub write_individual{\n    my ($self,@inds) = @_;\n    foreach my $ind ( @inds ) {\n\tif (! ref($ind) || ! $ind->isa('Bio::PopGen::IndividualI') ) {\n\t    $self->warn(\"Cannot write an object that is not a Bio::PopGen::IndividualI object\");\n\t    next;\n\t}\n\tforeach my $marker ( $ind->get_marker_names ) { \n\t    my $g = $ind->get_Genotypes(-marker=> $marker);\n\t    next unless defined $g;\n\t    $self->_print( join(\"\\t\", $marker, $ind->unique_id, \n\t\t\t\t$g->get_Alleles), \"\\n\");\t    \n\t}\n    }\n    \n}\n\n\n\n=head2 write_population\n\n Title   : write_population\n Usage   : $popgenio->write_population($pop);\n Function: Write a population out in the file format\n Returns : none\n Args    : L<Bio::PopGen::PopulationI> object(s)\n Note    : Many implementation will not implement this"},"detail":"($self,@pops)","kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"write_population","line":283,"kind":13},{"containerName":"write_population","name":"@pops","kind":13,"line":283},{"localvar":"my","containerName":"write_population","definition":"my","name":"$pop","line":284,"kind":13},{"line":284,"kind":13,"containerName":"write_population","name":"@pops"},{"kind":13,"line":285,"name":"$pop","containerName":"write_population"},{"line":285,"kind":13,"containerName":"write_population","name":"$pop"},{"line":285,"kind":12,"name":"isa","containerName":"write_population"},{"line":286,"kind":13,"name":"$self","containerName":"write_population"},{"line":286,"kind":12,"name":"warn","containerName":"write_population"},{"containerName":"write_population","definition":"my","name":"@mnames","localvar":"my","kind":13,"line":289},{"line":289,"kind":13,"containerName":"write_population","name":"$pop"},{"kind":12,"line":289,"name":"get_marker_names","containerName":"write_population"},{"line":290,"kind":13,"localvar":"my","definition":"my","name":"$ind","containerName":"write_population"},{"name":"$pop","containerName":"write_population","line":290,"kind":13},{"line":290,"kind":12,"containerName":"write_population","name":"get_Individuals"},{"kind":13,"line":291,"name":"$ind","containerName":"write_population"},{"name":"$ind","containerName":"write_population","kind":13,"line":291},{"name":"isa","containerName":"write_population","kind":12,"line":291},{"name":"$self","containerName":"write_population","line":292,"kind":13},{"kind":12,"line":292,"containerName":"write_population","name":"warn"},{"kind":13,"line":295,"containerName":"write_population","name":"$marker","definition":"my","localvar":"my"},{"containerName":"write_population","name":"@mnames","kind":13,"line":295},{"localvar":"my","containerName":"write_population","name":"$g","definition":"my","line":296,"kind":13},{"kind":13,"line":296,"containerName":"write_population","name":"$ind"},{"name":"get_Genotypes","containerName":"write_population","kind":12,"line":296},{"line":296,"kind":13,"name":"$marker","containerName":"write_population"},{"kind":13,"line":297,"name":"$g","containerName":"write_population"},{"line":298,"kind":13,"containerName":"write_population","name":"$self"},{"line":298,"kind":12,"containerName":"write_population","name":"_print"},{"line":298,"kind":13,"containerName":"write_population","name":"$marker"},{"name":"$ind","containerName":"write_population","line":298,"kind":13},{"name":"unique_id","containerName":"write_population","kind":12,"line":298},{"containerName":"write_population","name":"$g","kind":13,"line":299},{"containerName":"write_population","name":"get_Alleles","kind":12,"line":299}],"line":282}]}