{"version":5,"vars":[{"line":95,"kind":2,"containerName":"","name":"base"},{"detail":"($class,@args)","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO - Input individual,marker,allele information\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'csv',\n                               -file   => 'data.csv');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n\n=head1 DESCRIPTION\n\nThis is a generic interface to reading in population genetic data (of\nwhich there really isn't too many standard formats).  This implementation\nmakes it easy to provide your own parser for the data.  You need to\nonly implement one function next_individual.  You can also implement \nnext_population if your data has explicit information about population\nmemberhsip for the indidviduals.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n#TODO \n# Set the Individual creation as a factory rather than\n# hardcoded\n\npackage Bio::PopGen::IO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO->new();\n Function: Builds a new Bio::PopGen::IO object \n Returns : an instance of Bio::PopGen::IO\n Args    :","parameters":[{"label":"$class"},{"label":"@args"}]},"containerName":"main::","definition":"sub","line":108,"children":[{"containerName":"new","name":"$class","definition":"my","localvar":"my","kind":13,"line":109},{"containerName":"new","name":"@args","line":109,"kind":13},{"name":"$class","containerName":"new","line":111,"kind":13},{"kind":13,"line":112,"name":"$self","definition":"my","containerName":"new","localvar":"my"},{"containerName":"new","name":"$class","line":112,"kind":13},{"containerName":"new","name":"@args","line":112,"kind":13},{"kind":13,"line":113,"name":"$self","containerName":"new"},{"containerName":"new","name":"_initialize","kind":12,"line":113},{"containerName":"new","name":"@args","line":113,"kind":13},{"line":114,"kind":13,"name":"$self","containerName":"new"},{"line":116,"kind":13,"localvar":"my","name":"%param","definition":"my","containerName":"new"},{"containerName":"new","name":"@args","kind":13,"line":116},{"containerName":"new","name":"@param","kind":13,"line":117},{"line":117,"kind":13,"name":"%param","containerName":"new"},{"name":"%param","containerName":"new","line":117,"kind":13},{"localvar":"my","containerName":"new","definition":"my","name":"$format","line":118,"kind":13},{"line":118,"kind":13,"name":"$param","containerName":"new"},{"name":"$class","containerName":"new","line":119,"kind":13},{"containerName":"new","name":"_guess_format","line":119,"kind":12},{"line":119,"kind":13,"containerName":"new","name":"$param"},{"containerName":"new","name":"$ARGV","line":119,"kind":13},{"containerName":"new","name":"$format","line":122,"kind":13},{"name":"$class","containerName":"new","kind":13,"line":124},{"line":124,"kind":12,"name":"_load_format_module","containerName":"new"},{"name":"$format","containerName":"new","line":124,"kind":13},{"kind":12,"line":125,"name":"new","containerName":"new"},{"containerName":"new","name":"@args","kind":13,"line":125}],"kind":12,"range":{"start":{"character":0,"line":108},"end":{"line":127,"character":9999}},"name":"new"},{"kind":12,"line":112,"containerName":"new","name":"SUPER"},{"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":" _initialize is chained for all PopGen::IO classes","label":"_initialize($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"_initialize","localvar":"my","kind":13,"line":132},{"containerName":"_initialize","name":"@args","kind":13,"line":132},{"line":140,"kind":13,"containerName":"_initialize","name":"$self"},{"kind":12,"line":140,"name":"_initialize_io","containerName":"_initialize"},{"line":140,"kind":13,"name":"@args","containerName":"_initialize"}],"line":131,"kind":12,"range":{"end":{"line":142,"character":9999},"start":{"line":131,"character":0}},"name":"_initialize"},{"signature":{"documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO - Input individual,marker,allele information\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'csv',\n                               -file   => 'data.csv');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n\n=head1 DESCRIPTION\n\nThis is a generic interface to reading in population genetic data (of\nwhich there really isn't too many standard formats).  This implementation\nmakes it easy to provide your own parser for the data.  You need to\nonly implement one function next_individual.  You can also implement \nnext_population if your data has explicit information about population\nmemberhsip for the indidviduals.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n#TODO \n# Set the Individual creation as a factory rather than\n# hardcoded\n\npackage Bio::PopGen::IO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO->new();\n Function: Builds a new Bio::PopGen::IO object \n Returns : an instance of Bio::PopGen::IO\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  if( $class =~ /Bio::PopGen::IO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);\t\n    $self->_initialize(@args);\n    return $self;\n  } else { \n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} ||\n      $class->_guess_format( $param{'-file'} || $ARGV[0] ) || 'csv';\n\n    # normalize capitalization to lower case\n    $format = \"\\L$format\";\n    \n    return unless( $class->_load_format_module($format) );\n    return \"Bio::PopGen::IO::${format}\"->new(@args);\n  }\n}\n\n# _initialize is chained for all PopGen::IO classes\n\nsub _initialize {\n    my($self, @args) = @_;\n#    my ($indfact, $popfact) = $self->_rearrange([qw(INDIVIDUAL_FACTORY\n#\t\t\t\t\t\t    POPULATION_FACTORY)],\n#\t\t\t\t\t\t@args);\n#    $indfact = Bio::PopGen::IndividualBuilder->new() unless $indfact;\n#    $indfact = Bio::PopGen::PopulationBuilder->new() unless $indfact;\n\n    # initialize the IO part\n    $self->_initialize_io(@args);\n    return 1;\n}\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : L<Bio::PopGen::IndividualI> object\n Args    : none","parameters":[{"label":"$self"}],"label":"next_individual($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"next_individual","name":"$self","definition":"my","line":156,"kind":13},{"containerName":"next_individual","name":"$self","line":157,"kind":13},{"kind":12,"line":157,"containerName":"next_individual","name":"throw_not_implemented"}],"line":155,"kind":12,"range":{"start":{"line":155,"character":0},"end":{"line":158,"character":9999}},"name":"next_individual"},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO - Input individual,marker,allele information\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'csv',\n                               -file   => 'data.csv');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n\n=head1 DESCRIPTION\n\nThis is a generic interface to reading in population genetic data (of\nwhich there really isn't too many standard formats).  This implementation\nmakes it easy to provide your own parser for the data.  You need to\nonly implement one function next_individual.  You can also implement \nnext_population if your data has explicit information about population\nmemberhsip for the indidviduals.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n#TODO \n# Set the Individual creation as a factory rather than\n# hardcoded\n\npackage Bio::PopGen::IO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO->new();\n Function: Builds a new Bio::PopGen::IO object \n Returns : an instance of Bio::PopGen::IO\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  if( $class =~ /Bio::PopGen::IO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);\t\n    $self->_initialize(@args);\n    return $self;\n  } else { \n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} ||\n      $class->_guess_format( $param{'-file'} || $ARGV[0] ) || 'csv';\n\n    # normalize capitalization to lower case\n    $format = \"\\L$format\";\n    \n    return unless( $class->_load_format_module($format) );\n    return \"Bio::PopGen::IO::${format}\"->new(@args);\n  }\n}\n\n# _initialize is chained for all PopGen::IO classes\n\nsub _initialize {\n    my($self, @args) = @_;\n#    my ($indfact, $popfact) = $self->_rearrange([qw(INDIVIDUAL_FACTORY\n#\t\t\t\t\t\t    POPULATION_FACTORY)],\n#\t\t\t\t\t\t@args);\n#    $indfact = Bio::PopGen::IndividualBuilder->new() unless $indfact;\n#    $indfact = Bio::PopGen::PopulationBuilder->new() unless $indfact;\n\n    # initialize the IO part\n    $self->_initialize_io(@args);\n    return 1;\n}\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : L<Bio::PopGen::IndividualI> object\n Args    : none\n\n\n\nsub next_individual{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 next_population\n\n Title   : next_population\n Usage   : my $pop = $popgenio->next_population;\n Function: Retrieve the next population from a dataset\n Returns : L<Bio::PopGen::PopulationI> object\n Args    : none\n Note    : Many implementation will not implement this","label":"next_population($self)"},"detail":"($self)","kind":12,"children":[{"name":"$self","definition":"my","containerName":"next_population","localvar":"my","kind":13,"line":173},{"containerName":"next_population","name":"$self","kind":13,"line":174},{"containerName":"next_population","name":"throw_not_implemented","line":174,"kind":12}],"line":172,"name":"next_population","range":{"start":{"line":172,"character":0},"end":{"line":175,"character":9999}}},{"range":{"end":{"line":190,"character":9999},"start":{"line":187,"character":0}},"name":"write_individual","line":187,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"write_individual","line":188,"kind":13},{"containerName":"write_individual","name":"$self","line":189,"kind":13},{"name":"throw_not_implemented","containerName":"write_individual","line":189,"kind":12}],"kind":12,"detail":"($self)","signature":{"label":"write_individual($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO - Input individual,marker,allele information\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'csv',\n                               -file   => 'data.csv');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n\n=head1 DESCRIPTION\n\nThis is a generic interface to reading in population genetic data (of\nwhich there really isn't too many standard formats).  This implementation\nmakes it easy to provide your own parser for the data.  You need to\nonly implement one function next_individual.  You can also implement \nnext_population if your data has explicit information about population\nmemberhsip for the indidviduals.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n#TODO \n# Set the Individual creation as a factory rather than\n# hardcoded\n\npackage Bio::PopGen::IO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO->new();\n Function: Builds a new Bio::PopGen::IO object \n Returns : an instance of Bio::PopGen::IO\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  if( $class =~ /Bio::PopGen::IO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);\t\n    $self->_initialize(@args);\n    return $self;\n  } else { \n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} ||\n      $class->_guess_format( $param{'-file'} || $ARGV[0] ) || 'csv';\n\n    # normalize capitalization to lower case\n    $format = \"\\L$format\";\n    \n    return unless( $class->_load_format_module($format) );\n    return \"Bio::PopGen::IO::${format}\"->new(@args);\n  }\n}\n\n# _initialize is chained for all PopGen::IO classes\n\nsub _initialize {\n    my($self, @args) = @_;\n#    my ($indfact, $popfact) = $self->_rearrange([qw(INDIVIDUAL_FACTORY\n#\t\t\t\t\t\t    POPULATION_FACTORY)],\n#\t\t\t\t\t\t@args);\n#    $indfact = Bio::PopGen::IndividualBuilder->new() unless $indfact;\n#    $indfact = Bio::PopGen::PopulationBuilder->new() unless $indfact;\n\n    # initialize the IO part\n    $self->_initialize_io(@args);\n    return 1;\n}\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : L<Bio::PopGen::IndividualI> object\n Args    : none\n\n\n\nsub next_individual{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 next_population\n\n Title   : next_population\n Usage   : my $pop = $popgenio->next_population;\n Function: Retrieve the next population from a dataset\n Returns : L<Bio::PopGen::PopulationI> object\n Args    : none\n Note    : Many implementation will not implement this\n\n\nsub next_population{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 write_individual\n\n Title   : write_individual\n Usage   : $popgenio->write_individual($ind);\n Function: Write an individual out in the implementation format\n Returns : none\n Args    : L<Bio::PopGen::PopulationI> object(s)"},"containerName":"main::","definition":"sub"},{"name":"write_population","range":{"start":{"line":205,"character":0},"end":{"character":9999,"line":208}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"write_population($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO - Input individual,marker,allele information\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'csv',\n                               -file   => 'data.csv');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n\n=head1 DESCRIPTION\n\nThis is a generic interface to reading in population genetic data (of\nwhich there really isn't too many standard formats).  This implementation\nmakes it easy to provide your own parser for the data.  You need to\nonly implement one function next_individual.  You can also implement \nnext_population if your data has explicit information about population\nmemberhsip for the indidviduals.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n#TODO \n# Set the Individual creation as a factory rather than\n# hardcoded\n\npackage Bio::PopGen::IO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO->new();\n Function: Builds a new Bio::PopGen::IO object \n Returns : an instance of Bio::PopGen::IO\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  if( $class =~ /Bio::PopGen::IO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);\t\n    $self->_initialize(@args);\n    return $self;\n  } else { \n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} ||\n      $class->_guess_format( $param{'-file'} || $ARGV[0] ) || 'csv';\n\n    # normalize capitalization to lower case\n    $format = \"\\L$format\";\n    \n    return unless( $class->_load_format_module($format) );\n    return \"Bio::PopGen::IO::${format}\"->new(@args);\n  }\n}\n\n# _initialize is chained for all PopGen::IO classes\n\nsub _initialize {\n    my($self, @args) = @_;\n#    my ($indfact, $popfact) = $self->_rearrange([qw(INDIVIDUAL_FACTORY\n#\t\t\t\t\t\t    POPULATION_FACTORY)],\n#\t\t\t\t\t\t@args);\n#    $indfact = Bio::PopGen::IndividualBuilder->new() unless $indfact;\n#    $indfact = Bio::PopGen::PopulationBuilder->new() unless $indfact;\n\n    # initialize the IO part\n    $self->_initialize_io(@args);\n    return 1;\n}\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : L<Bio::PopGen::IndividualI> object\n Args    : none\n\n\n\nsub next_individual{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 next_population\n\n Title   : next_population\n Usage   : my $pop = $popgenio->next_population;\n Function: Retrieve the next population from a dataset\n Returns : L<Bio::PopGen::PopulationI> object\n Args    : none\n Note    : Many implementation will not implement this\n\n\nsub next_population{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 write_individual\n\n Title   : write_individual\n Usage   : $popgenio->write_individual($ind);\n Function: Write an individual out in the implementation format\n Returns : none\n Args    : L<Bio::PopGen::PopulationI> object(s)\n\n\nsub write_individual{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 write_population\n\n Title   : write_population\n Usage   : $popgenio->write_population($pop);\n Function: Write a population out in the implementation format\n Returns : none\n Args    : L<Bio::PopGen::PopulationI> object(s)\n Note    : Many implementation will not implement this"},"kind":12,"line":205,"children":[{"definition":"my","name":"$self","containerName":"write_population","localvar":"my","kind":13,"line":206},{"line":207,"kind":13,"name":"$self","containerName":"write_population"},{"kind":12,"line":207,"name":"throw_not_implemented","containerName":"write_population"}]},{"kind":12,"children":[{"line":227,"kind":13,"localvar":"my","definition":"my","name":"$class","containerName":"newFh"},{"line":228,"kind":13,"localvar":"my","containerName":"newFh","definition":"my","name":"$self"},{"name":"$class","containerName":"newFh","line":228,"kind":13},{"containerName":"newFh","name":"new","kind":12,"line":228},{"line":229,"kind":13,"containerName":"newFh","name":"$self"},{"containerName":"newFh","name":"fh","kind":12,"line":229}],"line":226,"name":"newFh","definition":"sub","containerName":"main::","range":{"start":{"line":226,"character":0},"end":{"line":230,"character":9999}}},{"kind":12,"line":246,"children":[{"line":247,"kind":13,"localvar":"my","containerName":"fh","definition":"my","name":"$self"},{"containerName":"fh","definition":"my","name":"$class","localvar":"my","kind":13,"line":248},{"containerName":"fh","name":"$self","kind":13,"line":248},{"kind":13,"line":248,"containerName":"fh","name":"$self"},{"line":249,"kind":13,"localvar":"my","containerName":"fh","name":"$s","definition":"my"},{"line":250,"kind":13,"name":"$class","containerName":"fh"},{"line":250,"kind":13,"name":"$self","containerName":"fh"},{"name":"$s","containerName":"fh","kind":13,"line":251}],"containerName":"main::","name":"fh","definition":"sub","range":{"end":{"line":252,"character":9999},"start":{"character":0,"line":246}}},{"name":"Symbol","containerName":"gensym","kind":12,"line":250},{"containerName":"main::","definition":"sub","detail":"($self,$format)","signature":{"parameters":[{"label":"$self"},{"label":"$format"}],"documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::IO - Input individual,marker,allele information\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::IO;\n  my $io = Bio::PopGen::IO->new(-format => 'csv',\n                               -file   => 'data.csv');\n\n  # Some IO might support reading in a population at a time\n\n  my @population;\n  while( my $ind = $io->next_individual ) {\n      push @population, $ind;\n  }\n\n\n=head1 DESCRIPTION\n\nThis is a generic interface to reading in population genetic data (of\nwhich there really isn't too many standard formats).  This implementation\nmakes it easy to provide your own parser for the data.  You need to\nonly implement one function next_individual.  You can also implement \nnext_population if your data has explicit information about population\nmemberhsip for the indidviduals.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n#TODO \n# Set the Individual creation as a factory rather than\n# hardcoded\n\npackage Bio::PopGen::IO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::IO->new();\n Function: Builds a new Bio::PopGen::IO object \n Returns : an instance of Bio::PopGen::IO\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  if( $class =~ /Bio::PopGen::IO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);\t\n    $self->_initialize(@args);\n    return $self;\n  } else { \n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} ||\n      $class->_guess_format( $param{'-file'} || $ARGV[0] ) || 'csv';\n\n    # normalize capitalization to lower case\n    $format = \"\\L$format\";\n    \n    return unless( $class->_load_format_module($format) );\n    return \"Bio::PopGen::IO::${format}\"->new(@args);\n  }\n}\n\n# _initialize is chained for all PopGen::IO classes\n\nsub _initialize {\n    my($self, @args) = @_;\n#    my ($indfact, $popfact) = $self->_rearrange([qw(INDIVIDUAL_FACTORY\n#\t\t\t\t\t\t    POPULATION_FACTORY)],\n#\t\t\t\t\t\t@args);\n#    $indfact = Bio::PopGen::IndividualBuilder->new() unless $indfact;\n#    $indfact = Bio::PopGen::PopulationBuilder->new() unless $indfact;\n\n    # initialize the IO part\n    $self->_initialize_io(@args);\n    return 1;\n}\n\n=head2 next_individual\n\n Title   : next_individual\n Usage   : my $ind = $popgenio->next_individual;\n Function: Retrieve the next individual from a dataset\n Returns : L<Bio::PopGen::IndividualI> object\n Args    : none\n\n\n\nsub next_individual{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 next_population\n\n Title   : next_population\n Usage   : my $pop = $popgenio->next_population;\n Function: Retrieve the next population from a dataset\n Returns : L<Bio::PopGen::PopulationI> object\n Args    : none\n Note    : Many implementation will not implement this\n\n\nsub next_population{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 write_individual\n\n Title   : write_individual\n Usage   : $popgenio->write_individual($ind);\n Function: Write an individual out in the implementation format\n Returns : none\n Args    : L<Bio::PopGen::PopulationI> object(s)\n\n\nsub write_individual{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 write_population\n\n Title   : write_population\n Usage   : $popgenio->write_population($pop);\n Function: Write a population out in the implementation format\n Returns : none\n Args    : L<Bio::PopGen::PopulationI> object(s)\n Note    : Many implementation will not implement this\n\n\nsub write_population{\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::SeqIO->newFh(-file=>$filename,-format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::SeqIO->newFh(-file=>$filename,-format=>'Format')\n           $sequence = <$fh>;   # read a sequence object\n           print $fh $sequence; # write a sequence object\n Returns : filehandle tied to the Bio::SeqIO::Fh class\n Args    :\n\nSee L<Bio::SeqIO::Fh>\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $sequence = <$fh>;   # read a sequence object\n           print $fh $sequence; # write a sequence object\n Returns : filehandle tied to Bio::SeqIO class\n Args    : none\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n=head2 _load_format_module\n\n Title   : _load_format_module\n Usage   : *INTERNAL Bio::PopGen::IO stuff*\n Function: Loads up (like use) a module at run time on demand\n Example : \n Returns : \n Args    : ","label":"_load_format_module($self,$format)"},"kind":12,"line":265,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_load_format_module","line":266,"kind":13},{"line":266,"kind":13,"containerName":"_load_format_module","name":"$format"},{"line":267,"kind":13,"localvar":"my","containerName":"_load_format_module","name":"$module","definition":"my"},{"name":"$format","containerName":"_load_format_module","kind":13,"line":267},{"line":268,"kind":13,"localvar":"my","name":"$ok","definition":"my","containerName":"_load_format_module"},{"line":271,"kind":13,"containerName":"_load_format_module","name":"$ok"},{"name":"$self","containerName":"_load_format_module","kind":13,"line":271},{"containerName":"_load_format_module","name":"_load_module","line":271,"kind":12},{"containerName":"_load_format_module","name":"$module","line":271,"kind":13},{"line":283,"kind":13,"name":"$ok","containerName":"_load_format_module"}],"name":"_load_format_module","range":{"start":{"character":0,"line":265},"end":{"character":9999,"line":284}}},{"children":[{"line":300,"kind":13,"localvar":"my","name":"$class","definition":"my","containerName":"_guess_format"}],"line":299,"kind":12,"range":{"start":{"line":299,"character":0},"end":{"character":9999,"line":303}},"name":"_guess_format","definition":"sub","containerName":"main::"},{"kind":12,"children":[{"containerName":"close","definition":"my","name":"$self","localvar":"my","kind":13,"line":306},{"containerName":"close","name":"$self","line":307,"kind":13}],"line":305,"name":"close","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":305},"end":{"line":308,"character":9999}}},{"kind":12,"line":307,"name":"SUPER","containerName":"close"},{"definition":"sub","name":"DESTROY","containerName":"main::","range":{"start":{"character":0,"line":310},"end":{"character":9999,"line":313}},"kind":12,"children":[{"line":311,"kind":13,"localvar":"my","containerName":"DESTROY","name":"$self","definition":"my"},{"kind":13,"line":312,"containerName":"DESTROY","name":"$self"},{"containerName":"DESTROY","name":"close","kind":12,"line":312}],"line":310},{"kind":12,"line":315,"children":[{"line":316,"kind":13,"localvar":"my","name":"$class","definition":"my","containerName":"TIEHANDLE"},{"name":"$class","containerName":"TIEHANDLE","kind":13,"line":317}],"containerName":"main::","definition":"sub","name":"TIEHANDLE","range":{"start":{"character":0,"line":315},"end":{"character":9999,"line":318}}},{"name":"processor","line":317,"kind":12},{"children":[{"containerName":"READLINE","definition":"my","name":"$self","localvar":"my","kind":13,"line":321},{"containerName":"READLINE","name":"$self","line":322,"kind":13},{"name":"next_result","containerName":"READLINE","line":322,"kind":12},{"localvar":"my","containerName":"READLINE","definition":"my","name":"@list","line":323,"kind":13},{"containerName":"READLINE","name":"$obj","line":323,"kind":13},{"line":324,"kind":13,"name":"@list","containerName":"READLINE"},{"name":"$obj","containerName":"READLINE","line":324,"kind":13},{"line":324,"kind":13,"containerName":"READLINE","name":"$obj"},{"kind":13,"line":324,"name":"$self","containerName":"READLINE"},{"containerName":"READLINE","name":"next_result","kind":12,"line":324},{"containerName":"READLINE","name":"@list","line":325,"kind":13}],"line":320,"kind":12,"range":{"start":{"line":320,"character":0},"end":{"line":326,"character":9999}},"name":"READLINE","definition":"sub","containerName":"main::"},{"definition":"sub","name":"PRINT","containerName":"main::","range":{"start":{"line":328,"character":0},"end":{"line":331,"character":9999}},"kind":12,"children":[{"kind":13,"line":329,"definition":"my","name":"$self","containerName":"PRINT","localvar":"my"},{"kind":13,"line":330,"containerName":"PRINT","name":"$self"},{"containerName":"PRINT","name":"write_result","kind":12,"line":330}],"line":328}]}