{"version":5,"vars":[{"containerName":"","name":"base","line":191,"kind":2},{"definition":1,"name":"DEFAULT_STATE","containerName":"main::","line":194,"kind":14},{"line":195,"kind":14,"definition":1,"name":"MIM_NUMBER_STATE","containerName":"main::"},{"line":196,"kind":14,"name":"TITLE_STATE","definition":1,"containerName":"main::"},{"line":197,"kind":14,"definition":1,"name":"TEXT_STATE","containerName":"main::"},{"line":198,"kind":14,"definition":1,"name":"MINI_MIM_TEXT_STATE","containerName":"main::"},{"line":199,"kind":14,"containerName":"main::","name":"ALLELIC_VARIANT_STATE","definition":1},{"kind":14,"line":200,"containerName":"main::","definition":1,"name":"SEE_ALSO_STATE"},{"name":"REF_STATE","definition":1,"containerName":"main::","line":201,"kind":14},{"line":202,"kind":14,"name":"SYMPT_STATE","definition":1,"containerName":"main::"},{"line":203,"kind":14,"definition":1,"name":"CONTRIBUTORS_STATE","containerName":"main::"},{"containerName":"main::","definition":1,"name":"CREATED_BY_STATE","line":204,"kind":14},{"name":"EDITED_BY_STATE","definition":1,"containerName":"main::","line":205,"kind":14},{"name":"MINI_MIM_EDITED_BY_STATE","definition":1,"containerName":"main::","kind":14,"line":206},{"line":207,"kind":14,"containerName":"main::","definition":1,"name":"MINI_MIM_CREATED_BY_STATE"},{"kind":14,"line":208,"definition":1,"name":"MINI_MIM_CONTRIBUTORS_STATE","containerName":"main::"},{"line":209,"kind":14,"name":"TRUE","definition":1,"containerName":"main::"},{"containerName":"main::","definition":1,"name":"FALSE","kind":14,"line":210},{"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: OMIMparser.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMparser\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMparser - parser for the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMparser;\n\n  # The OMIM database is available as textfile at:\n  # ftp://ncbi.nlm.nih.gov/repository/OMIM/omim.txt.Z\n  # The genemap is available as textfile at:\n  # ftp://ncbi.nlm.nih.gov/repository/OMIM/genemap\n\n  $omim_parser = Bio::Phenotype::OMIM::OMIMparser->new( -genemap  => \"/path/to/genemap\",\n                                                        -omimtext => \"/path/to/omim.txt\" );\n\n  while ( my $omim_entry = $omim_parser->next_phenotype() ) {\n    # This prints everything.\n    print( $omim_entry->to_string() );\n    print \"\\n\\n\";\n\n    # This gets individual data (some of them object-arrays)\n    # (and illustrates the relevant methods of OMIMentry).\n    my $numb  = $omim_entry->MIM_number();                     # *FIELD* NO\n    my $title = $omim_entry->title();                          # *FIELD* TI - first line\n    my $alt   = $omim_entry->alternative_titles_and_symbols(); # *FIELD* TI - additional lines\n    my $mtt   = $omim_entry->more_than_two_genes();            # \"#\" before title\n    my $sep   = $omim_entry->is_separate();                    # \"*\" before title\n    my $desc  = $omim_entry->description();                    # *FIELD* TX\n    my $mm    = $omim_entry->mapping_method();                 # from genemap\n    my $gs    = $omim_entry->gene_status();                    # from genemap\n    my $cr    = $omim_entry->created();                        # *FIELD* CD\n    my $cont  = $omim_entry->contributors();                   # *FIELD* CN\n    my $ed    = $omim_entry->edited();                         # *FIELD* ED\n    my $sa    = $omim_entry->additional_references();          # *FIELD* SA\n    my $cs    = $omim_entry->clinical_symptoms_raw();              # *FIELD* CS\n    my $comm  = $omim_entry->comment();                        # from genemap\n\n    my $mini_mim   = $omim_entry->miniMIM();                   # *FIELD* MN\n      # A Bio::Phenotype::OMIM::MiniMIMentry object.\n      # class Bio::Phenotype::OMIM::MiniMIMentry\n      # provides the following:\n      # - description()\n      # - created()\n      # - contributors()\n      # - edited() \n      #\n    # Prints the contents of the MINI MIM entry (most OMIM entries do\n    # not have MINI MIM entries, though).\n    print $mini_mim->description().\"\\n\";\n    print $mini_mim->created().\"\\n\";\n    print $mini_mim->contributors().\"\\n\";\n    print $mini_mim->edited().\"\\n\";\n\n    my @corrs      = $omim_entry->each_Correlate();            # from genemap\n      # Array of Bio::Phenotype::Correlate objects.\n      # class Bio::Phenotype::Correlate\n      # provides the following:\n      # - name()\n      # - description() (not used)\n      # - species() (always mouse)\n      # - type() (\"OMIM mouse correlate\")\n      # - comment() \n\n    my @refs       = $omim_entry->each_Reference();            # *FIELD* RF\n      # Array of Bio::Annotation::Reference objects.\n\n\n    my @avs        = $omim_entry->each_AllelicVariant();       # *FIELD* AV\n      # Array of Bio::Phenotype::OMIM::OMIMentryAllelicVariant objects.\n      # class Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n      # provides the following:\n      # - number (e.g \".0001\" )\n      # - title (e.g \"ALCOHOL INTOLERANCE\" )\n      # - symbol (e.g \"ALDH2*2\" )\n      # - description (e.g \"The ALDH2*2-encoded protein has a change ...\" )\n      # - aa_ori  (used if information in the form \"LYS123ARG\" is found)\n      # - aa_mut (used if information in the form \"LYS123ARG\" is found)\n      # - position (used if information in the form \"LYS123ARG\" is found)\n      # - additional_mutations (used for e.g. \"1-BP DEL, 911T\")\n\n    my @cps        = $omim_entry->each_CytoPosition();         # from genemap\n      # Array of Bio::Map::CytoPosition objects.\n\n    my @gss        = $omim_entry->each_gene_symbol();          # from genemap\n      # Array of strings.\n\n    # do something ...\n  }\n\n=head1 DESCRIPTION\n\nThis parser returns Bio::Phenotype::OMIM::OMIMentry objects\n(which inherit from Bio::Phenotype::PhenotypeI).\nIt parses the OMIM database available as \nftp://ncbi.nlm.nih.gov/repository/OMIM/omim.txt.Z \ntogether with (optionally) the gene map file at\nftp://ncbi.nlm.nih.gov/repository/OMIM/genemap.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMparser;\n\nuse strict;\n\nuse Bio::Root::IO;\nuse Bio::Species;\nuse Bio::Annotation::Reference;\nuse Bio::Map::CytoPosition;\nuse Bio::Phenotype::OMIM::OMIMentry;\nuse Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse Bio::Phenotype::Correlate;\n\nuse base qw(Bio::Root::Root);\n\n\nuse constant DEFAULT_STATE               => 0;\nuse constant MIM_NUMBER_STATE            => 1;\nuse constant TITLE_STATE                 => 2;\nuse constant TEXT_STATE                  => 3;\nuse constant MINI_MIM_TEXT_STATE         => 4;\nuse constant ALLELIC_VARIANT_STATE       => 5;\nuse constant SEE_ALSO_STATE              => 6;\nuse constant REF_STATE                   => 7;\nuse constant SYMPT_STATE                 => 8;\nuse constant CONTRIBUTORS_STATE          => 9;\nuse constant CREATED_BY_STATE            => 10;\nuse constant EDITED_BY_STATE             => 11;\nuse constant MINI_MIM_EDITED_BY_STATE    => 12;\nuse constant MINI_MIM_CREATED_BY_STATE   => 13;\nuse constant MINI_MIM_CONTRIBUTORS_STATE => 14;\nuse constant TRUE                        => 1;\nuse constant FALSE                       => 0;\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $omim_parser = Bio::Phenotype::OMIM::OMIMparser->new( -genemap  => \"/path/to/genemap\",\n                                                                 -omimtext => \"/path/to/omim.txt\" );                      \n Function: Creates a new OMIMparser.\n Returns : A new OMIMparser object.\n Args    : -genemap  => the genemap file name (optional)\n           -omimtext => the omim text file name","label":"new($class,@args)"},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$class","containerName":"new","line":227,"kind":13},{"line":227,"kind":13,"name":"@args","containerName":"new"},{"kind":13,"line":229,"name":"$self","definition":"my","containerName":"new","localvar":"my"},{"containerName":"new","name":"$class","line":229,"kind":13},{"line":229,"kind":13,"name":"@args","containerName":"new"},{"line":231,"kind":13,"localvar":"my","definition":"my","name":"$genemap_file_name","containerName":"new"},{"containerName":"new","name":"$omimtxt_file_name","line":231,"kind":13},{"name":"$self","containerName":"new","line":232,"kind":13},{"containerName":"new","name":"_rearrange","line":232,"kind":12},{"containerName":"new","name":"@args","kind":13,"line":232},{"containerName":"new","name":"$self","kind":13,"line":234},{"name":"init","containerName":"new","kind":12,"line":234},{"name":"$genemap_file_name","containerName":"new","kind":13,"line":236},{"kind":13,"line":236,"name":"$self","containerName":"new"},{"containerName":"new","name":"genemap_file_name","line":236,"kind":12},{"name":"$genemap_file_name","containerName":"new","line":236,"kind":13},{"line":238,"kind":13,"name":"$omimtxt_file_name","containerName":"new"},{"kind":13,"line":238,"containerName":"new","name":"$self"},{"name":"omimtxt_file_name","containerName":"new","line":238,"kind":12},{"line":238,"kind":13,"containerName":"new","name":"$omimtxt_file_name"},{"line":240,"kind":13,"containerName":"new","name":"$self"}],"line":226,"kind":12,"range":{"start":{"line":226,"character":0},"end":{"character":9999,"line":241}},"name":"new"},{"line":229,"kind":12,"name":"SUPER","containerName":"new"},{"range":{"start":{"character":0,"line":259},"end":{"character":9999,"line":375}},"name":"next_phenotype","children":[{"kind":13,"line":260,"containerName":"next_phenotype","definition":"my","name":"$self","localvar":"my"},{"name":"$self","containerName":"next_phenotype","kind":13,"line":262},{"line":262,"kind":12,"name":"_OMIM_text_file","containerName":"next_phenotype"},{"kind":13,"line":263,"containerName":"next_phenotype","name":"$self"},{"containerName":"next_phenotype","name":"_no_OMIM_text_file_provided_error","kind":12,"line":263},{"line":266,"kind":13,"containerName":"next_phenotype","name":"$self"},{"containerName":"next_phenotype","name":"_done","line":266,"kind":12},{"localvar":"my","containerName":"next_phenotype","name":"$fieldtag","definition":"my","line":270,"kind":13},{"definition":"my","name":"$contents","containerName":"next_phenotype","localvar":"my","kind":13,"line":271},{"localvar":"my","name":"$line","definition":"my","containerName":"next_phenotype","line":272,"kind":13},{"localvar":"my","name":"$state","definition":"my","containerName":"next_phenotype","line":273,"kind":13},{"localvar":"my","containerName":"next_phenotype","name":"$saw_mini_min_flag","definition":"my","line":274,"kind":13},{"line":275,"kind":13,"localvar":"my","containerName":"next_phenotype","name":"%record","definition":"my"},{"containerName":"next_phenotype","name":"$line","line":277,"kind":13},{"containerName":"next_phenotype","name":"$self","line":277,"kind":13},{"line":277,"kind":12,"name":"_OMIM_text_file","containerName":"next_phenotype"},{"name":"_readline","containerName":"next_phenotype","kind":12,"line":277},{"name":"$line","containerName":"next_phenotype","kind":13,"line":278},{"name":"$self","containerName":"next_phenotype","line":279,"kind":13},{"name":"_is_not_first_record","containerName":"next_phenotype","kind":12,"line":279},{"line":280,"kind":13,"containerName":"next_phenotype","name":"$self"},{"line":280,"kind":12,"containerName":"next_phenotype","name":"_add_to_hash"},{"line":280,"kind":13,"containerName":"next_phenotype","name":"$state"},{"containerName":"next_phenotype","name":"$contents","kind":13,"line":280},{"containerName":"next_phenotype","name":"%record","line":280,"kind":13},{"kind":13,"line":281,"definition":"my","name":"$omim_entry","containerName":"next_phenotype","localvar":"my"},{"line":281,"kind":13,"containerName":"next_phenotype","name":"$self"},{"name":"_createOMIMentry","containerName":"next_phenotype","kind":12,"line":281},{"kind":13,"line":281,"containerName":"next_phenotype","name":"%record"},{"line":282,"kind":13,"containerName":"next_phenotype","name":"$omim_entry"},{"line":285,"kind":13,"name":"$self","containerName":"next_phenotype"},{"kind":12,"line":285,"name":"_is_not_first_record","containerName":"next_phenotype"},{"kind":13,"line":289,"name":"$line","containerName":"next_phenotype"},{"line":290,"kind":13,"containerName":"next_phenotype","name":"$fieldtag"},{"name":"$state","containerName":"next_phenotype","kind":13,"line":291},{"kind":13,"line":292,"name":"$self","containerName":"next_phenotype"},{"name":"_add_to_hash","containerName":"next_phenotype","kind":12,"line":292},{"containerName":"next_phenotype","name":"$state","line":292,"kind":13},{"name":"$contents","containerName":"next_phenotype","line":292,"kind":13},{"name":"%record","containerName":"next_phenotype","kind":13,"line":292},{"kind":13,"line":294,"containerName":"next_phenotype","name":"$contents"},{"containerName":"next_phenotype","name":"$fieldtag","kind":13,"line":296},{"name":"$state","containerName":"next_phenotype","line":297,"kind":13},{"name":"$saw_mini_min_flag","containerName":"next_phenotype","line":298,"kind":13},{"containerName":"next_phenotype","name":"$fieldtag","line":300,"kind":13},{"line":301,"kind":13,"name":"$state","containerName":"next_phenotype"},{"containerName":"next_phenotype","name":"$saw_mini_min_flag","line":302,"kind":13},{"containerName":"next_phenotype","name":"$fieldtag","kind":13,"line":304},{"name":"$state","containerName":"next_phenotype","line":305,"kind":13},{"kind":13,"line":306,"containerName":"next_phenotype","name":"$saw_mini_min_flag"},{"name":"$fieldtag","containerName":"next_phenotype","line":308,"kind":13},{"containerName":"next_phenotype","name":"$state","kind":13,"line":309},{"name":"$saw_mini_min_flag","containerName":"next_phenotype","line":310,"kind":13},{"kind":13,"line":312,"containerName":"next_phenotype","name":"$fieldtag"},{"containerName":"next_phenotype","name":"$state","line":313,"kind":13},{"kind":13,"line":314,"name":"$saw_mini_min_flag","containerName":"next_phenotype"},{"line":316,"kind":13,"name":"$fieldtag","containerName":"next_phenotype"},{"line":317,"kind":13,"containerName":"next_phenotype","name":"$state"},{"kind":13,"line":318,"containerName":"next_phenotype","name":"$saw_mini_min_flag"},{"name":"$fieldtag","containerName":"next_phenotype","kind":13,"line":320},{"line":321,"kind":13,"name":"$state","containerName":"next_phenotype"},{"name":"$saw_mini_min_flag","containerName":"next_phenotype","kind":13,"line":322},{"containerName":"next_phenotype","name":"$fieldtag","line":324,"kind":13},{"name":"$state","containerName":"next_phenotype","kind":13,"line":325},{"kind":13,"line":326,"containerName":"next_phenotype","name":"$saw_mini_min_flag"},{"containerName":"next_phenotype","name":"$fieldtag","kind":13,"line":328},{"containerName":"next_phenotype","name":"$saw_mini_min_flag","kind":13,"line":329},{"containerName":"next_phenotype","name":"$state","line":330,"kind":13},{"containerName":"next_phenotype","name":"$state","line":333,"kind":13},{"line":336,"kind":13,"name":"$fieldtag","containerName":"next_phenotype"},{"name":"$saw_mini_min_flag","containerName":"next_phenotype","kind":13,"line":337},{"containerName":"next_phenotype","name":"$state","kind":13,"line":338},{"line":341,"kind":13,"name":"$state","containerName":"next_phenotype"},{"containerName":"next_phenotype","name":"$fieldtag","kind":13,"line":344},{"containerName":"next_phenotype","name":"$saw_mini_min_flag","line":345,"kind":13},{"containerName":"next_phenotype","name":"$state","kind":13,"line":346},{"kind":13,"line":349,"name":"$state","containerName":"next_phenotype"},{"containerName":"next_phenotype","name":"$contents","kind":13,"line":358},{"line":358,"kind":13,"name":"$line","containerName":"next_phenotype"},{"kind":13,"line":362,"name":"$self","containerName":"next_phenotype"},{"containerName":"next_phenotype","name":"_OMIM_text_file","kind":12,"line":362},{"containerName":"next_phenotype","name":"close","line":362,"kind":12},{"name":"$self","containerName":"next_phenotype","line":363,"kind":13},{"name":"_done","containerName":"next_phenotype","line":363,"kind":12},{"name":"%record","containerName":"next_phenotype","kind":13,"line":365},{"name":"$self","containerName":"next_phenotype","line":366,"kind":13},{"name":"_not_a_OMIM_text_file_error","containerName":"next_phenotype","kind":12,"line":366},{"kind":13,"line":369,"name":"$self","containerName":"next_phenotype"},{"name":"_add_to_hash","containerName":"next_phenotype","kind":12,"line":369},{"containerName":"next_phenotype","name":"$state","kind":13,"line":369},{"line":369,"kind":13,"name":"$contents","containerName":"next_phenotype"},{"name":"%record","containerName":"next_phenotype","kind":13,"line":369},{"line":371,"kind":13,"localvar":"my","containerName":"next_phenotype","definition":"my","name":"$omim_entry"},{"name":"$self","containerName":"next_phenotype","line":371,"kind":13},{"kind":12,"line":371,"containerName":"next_phenotype","name":"_createOMIMentry"},{"line":371,"kind":13,"containerName":"next_phenotype","name":"%record"},{"name":"$omim_entry","containerName":"next_phenotype","line":373,"kind":13}],"line":259,"kind":12,"signature":{"documentation":"1;\n# $Id: OMIMparser.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMparser\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMparser - parser for the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMparser;\n\n  # The OMIM database is available as textfile at:\n  # ftp://ncbi.nlm.nih.gov/repository/OMIM/omim.txt.Z\n  # The genemap is available as textfile at:\n  # ftp://ncbi.nlm.nih.gov/repository/OMIM/genemap\n\n  $omim_parser = Bio::Phenotype::OMIM::OMIMparser->new( -genemap  => \"/path/to/genemap\",\n                                                        -omimtext => \"/path/to/omim.txt\" );\n\n  while ( my $omim_entry = $omim_parser->next_phenotype() ) {\n    # This prints everything.\n    print( $omim_entry->to_string() );\n    print \"\\n\\n\";\n\n    # This gets individual data (some of them object-arrays)\n    # (and illustrates the relevant methods of OMIMentry).\n    my $numb  = $omim_entry->MIM_number();                     # *FIELD* NO\n    my $title = $omim_entry->title();                          # *FIELD* TI - first line\n    my $alt   = $omim_entry->alternative_titles_and_symbols(); # *FIELD* TI - additional lines\n    my $mtt   = $omim_entry->more_than_two_genes();            # \"#\" before title\n    my $sep   = $omim_entry->is_separate();                    # \"*\" before title\n    my $desc  = $omim_entry->description();                    # *FIELD* TX\n    my $mm    = $omim_entry->mapping_method();                 # from genemap\n    my $gs    = $omim_entry->gene_status();                    # from genemap\n    my $cr    = $omim_entry->created();                        # *FIELD* CD\n    my $cont  = $omim_entry->contributors();                   # *FIELD* CN\n    my $ed    = $omim_entry->edited();                         # *FIELD* ED\n    my $sa    = $omim_entry->additional_references();          # *FIELD* SA\n    my $cs    = $omim_entry->clinical_symptoms_raw();              # *FIELD* CS\n    my $comm  = $omim_entry->comment();                        # from genemap\n\n    my $mini_mim   = $omim_entry->miniMIM();                   # *FIELD* MN\n      # A Bio::Phenotype::OMIM::MiniMIMentry object.\n      # class Bio::Phenotype::OMIM::MiniMIMentry\n      # provides the following:\n      # - description()\n      # - created()\n      # - contributors()\n      # - edited() \n      #\n    # Prints the contents of the MINI MIM entry (most OMIM entries do\n    # not have MINI MIM entries, though).\n    print $mini_mim->description().\"\\n\";\n    print $mini_mim->created().\"\\n\";\n    print $mini_mim->contributors().\"\\n\";\n    print $mini_mim->edited().\"\\n\";\n\n    my @corrs      = $omim_entry->each_Correlate();            # from genemap\n      # Array of Bio::Phenotype::Correlate objects.\n      # class Bio::Phenotype::Correlate\n      # provides the following:\n      # - name()\n      # - description() (not used)\n      # - species() (always mouse)\n      # - type() (\"OMIM mouse correlate\")\n      # - comment() \n\n    my @refs       = $omim_entry->each_Reference();            # *FIELD* RF\n      # Array of Bio::Annotation::Reference objects.\n\n\n    my @avs        = $omim_entry->each_AllelicVariant();       # *FIELD* AV\n      # Array of Bio::Phenotype::OMIM::OMIMentryAllelicVariant objects.\n      # class Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n      # provides the following:\n      # - number (e.g \".0001\" )\n      # - title (e.g \"ALCOHOL INTOLERANCE\" )\n      # - symbol (e.g \"ALDH2*2\" )\n      # - description (e.g \"The ALDH2*2-encoded protein has a change ...\" )\n      # - aa_ori  (used if information in the form \"LYS123ARG\" is found)\n      # - aa_mut (used if information in the form \"LYS123ARG\" is found)\n      # - position (used if information in the form \"LYS123ARG\" is found)\n      # - additional_mutations (used for e.g. \"1-BP DEL, 911T\")\n\n    my @cps        = $omim_entry->each_CytoPosition();         # from genemap\n      # Array of Bio::Map::CytoPosition objects.\n\n    my @gss        = $omim_entry->each_gene_symbol();          # from genemap\n      # Array of strings.\n\n    # do something ...\n  }\n\n=head1 DESCRIPTION\n\nThis parser returns Bio::Phenotype::OMIM::OMIMentry objects\n(which inherit from Bio::Phenotype::PhenotypeI).\nIt parses the OMIM database available as \nftp://ncbi.nlm.nih.gov/repository/OMIM/omim.txt.Z \ntogether with (optionally) the gene map file at\nftp://ncbi.nlm.nih.gov/repository/OMIM/genemap.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMparser;\n\nuse strict;\n\nuse Bio::Root::IO;\nuse Bio::Species;\nuse Bio::Annotation::Reference;\nuse Bio::Map::CytoPosition;\nuse Bio::Phenotype::OMIM::OMIMentry;\nuse Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse Bio::Phenotype::Correlate;\n\nuse base qw(Bio::Root::Root);\n\n\nuse constant DEFAULT_STATE               => 0;\nuse constant MIM_NUMBER_STATE            => 1;\nuse constant TITLE_STATE                 => 2;\nuse constant TEXT_STATE                  => 3;\nuse constant MINI_MIM_TEXT_STATE         => 4;\nuse constant ALLELIC_VARIANT_STATE       => 5;\nuse constant SEE_ALSO_STATE              => 6;\nuse constant REF_STATE                   => 7;\nuse constant SYMPT_STATE                 => 8;\nuse constant CONTRIBUTORS_STATE          => 9;\nuse constant CREATED_BY_STATE            => 10;\nuse constant EDITED_BY_STATE             => 11;\nuse constant MINI_MIM_EDITED_BY_STATE    => 12;\nuse constant MINI_MIM_CREATED_BY_STATE   => 13;\nuse constant MINI_MIM_CONTRIBUTORS_STATE => 14;\nuse constant TRUE                        => 1;\nuse constant FALSE                       => 0;\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $omim_parser = Bio::Phenotype::OMIM::OMIMparser->new( -genemap  => \"/path/to/genemap\",\n                                                                 -omimtext => \"/path/to/omim.txt\" );                      \n Function: Creates a new OMIMparser.\n Returns : A new OMIMparser object.\n Args    : -genemap  => the genemap file name (optional)\n           -omimtext => the omim text file name\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $genemap_file_name, $omimtxt_file_name ) \n    = $self->_rearrange( [ qw( GENEMAP OMIMTEXT ) ], @args );\n\n    $self->init(); \n    \n    $genemap_file_name && $self->genemap_file_name( $genemap_file_name );\n    \n    $omimtxt_file_name && $self->omimtxt_file_name( $omimtxt_file_name);\n                         \n    return $self;\n}\n\n\n\n\n=head2 next_phenotype\n\n Title   : next_phenotype()\n Usage   : while ( my $omim_entry = $omim_parser->next_phenotype() ) {\n               # do something with $omim_entry\n           }    \n Function: Returns an Bio::Phenotype::OMIM::OMIMentry or\n           undef once the end of the omim text file is reached.\n Returns : A Bio::Phenotype::OMIM::OMIMentry.\n Args    :","parameters":[{"label":"$self"}],"label":"next_phenotype($self)"},"detail":"($self)","definition":"sub","containerName":"main::"},{"kind":12,"line":266,"name":"TRUE"},{"name":"DEFAULT_STATE","kind":12,"line":273},{"kind":12,"line":274,"name":"FALSE"},{"kind":12,"line":279,"name":"TRUE"},{"name":"TRUE","kind":12,"line":285},{"line":291,"kind":12,"name":"DEFAULT_STATE"},{"name":"MIM_NUMBER_STATE","line":297,"kind":12},{"name":"FALSE","kind":12,"line":298},{"line":301,"kind":12,"name":"TITLE_STATE"},{"kind":12,"line":302,"name":"FALSE"},{"name":"TEXT_STATE","line":305,"kind":12},{"line":306,"kind":12,"name":"FALSE"},{"kind":12,"line":309,"name":"MINI_MIM_TEXT_STATE"},{"line":310,"kind":12,"name":"TRUE"},{"name":"ALLELIC_VARIANT_STATE","line":313,"kind":12},{"name":"FALSE","kind":12,"line":314},{"name":"SEE_ALSO_STATE","kind":12,"line":317},{"name":"FALSE","line":318,"kind":12},{"name":"REF_STATE","kind":12,"line":321},{"kind":12,"line":322,"name":"FALSE"},{"kind":12,"line":325,"name":"SYMPT_STATE"},{"kind":12,"line":326,"name":"FALSE"},{"name":"TRUE","line":329,"kind":12},{"line":330,"kind":12,"name":"MINI_MIM_CONTRIBUTORS_STATE"},{"name":"CONTRIBUTORS_STATE","kind":12,"line":333},{"name":"TRUE","kind":12,"line":337},{"kind":12,"line":338,"name":"MINI_MIM_CREATED_BY_STATE"},{"name":"CREATED_BY_STATE","kind":12,"line":341},{"name":"TRUE","line":345,"kind":12},{"name":"MINI_MIM_EDITED_BY_STATE","line":346,"kind":12},{"line":349,"kind":12,"name":"EDITED_BY_STATE"},{"name":"TRUE","line":363,"kind":12},{"kind":12,"line":390,"children":[{"line":391,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"init"},{"containerName":"init","name":"$self","kind":13,"line":393},{"line":393,"kind":12,"name":"genemap_file_name","containerName":"init"},{"containerName":"init","name":"$self","line":394,"kind":13},{"kind":12,"line":394,"name":"omimtxt_file_name","containerName":"init"},{"line":395,"kind":13,"containerName":"init","name":"$self"},{"name":"_genemap_hash","containerName":"init","line":395,"kind":12},{"name":"$self","containerName":"init","kind":13,"line":396},{"containerName":"init","name":"_OMIM_text_file","line":396,"kind":12},{"line":397,"kind":13,"containerName":"init","name":"$self"},{"name":"_is_not_first_record","containerName":"init","line":397,"kind":12},{"name":"$self","containerName":"init","line":398,"kind":13},{"line":398,"kind":12,"name":"_done","containerName":"init"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"init($self)","documentation":"1;\n# $Id: OMIMparser.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMparser\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMparser - parser for the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMparser;\n\n  # The OMIM database is available as textfile at:\n  # ftp://ncbi.nlm.nih.gov/repository/OMIM/omim.txt.Z\n  # The genemap is available as textfile at:\n  # ftp://ncbi.nlm.nih.gov/repository/OMIM/genemap\n\n  $omim_parser = Bio::Phenotype::OMIM::OMIMparser->new( -genemap  => \"/path/to/genemap\",\n                                                        -omimtext => \"/path/to/omim.txt\" );\n\n  while ( my $omim_entry = $omim_parser->next_phenotype() ) {\n    # This prints everything.\n    print( $omim_entry->to_string() );\n    print \"\\n\\n\";\n\n    # This gets individual data (some of them object-arrays)\n    # (and illustrates the relevant methods of OMIMentry).\n    my $numb  = $omim_entry->MIM_number();                     # *FIELD* NO\n    my $title = $omim_entry->title();                          # *FIELD* TI - first line\n    my $alt   = $omim_entry->alternative_titles_and_symbols(); # *FIELD* TI - additional lines\n    my $mtt   = $omim_entry->more_than_two_genes();            # \"#\" before title\n    my $sep   = $omim_entry->is_separate();                    # \"*\" before title\n    my $desc  = $omim_entry->description();                    # *FIELD* TX\n    my $mm    = $omim_entry->mapping_method();                 # from genemap\n    my $gs    = $omim_entry->gene_status();                    # from genemap\n    my $cr    = $omim_entry->created();                        # *FIELD* CD\n    my $cont  = $omim_entry->contributors();                   # *FIELD* CN\n    my $ed    = $omim_entry->edited();                         # *FIELD* ED\n    my $sa    = $omim_entry->additional_references();          # *FIELD* SA\n    my $cs    = $omim_entry->clinical_symptoms_raw();              # *FIELD* CS\n    my $comm  = $omim_entry->comment();                        # from genemap\n\n    my $mini_mim   = $omim_entry->miniMIM();                   # *FIELD* MN\n      # A Bio::Phenotype::OMIM::MiniMIMentry object.\n      # class Bio::Phenotype::OMIM::MiniMIMentry\n      # provides the following:\n      # - description()\n      # - created()\n      # - contributors()\n      # - edited() \n      #\n    # Prints the contents of the MINI MIM entry (most OMIM entries do\n    # not have MINI MIM entries, though).\n    print $mini_mim->description().\"\\n\";\n    print $mini_mim->created().\"\\n\";\n    print $mini_mim->contributors().\"\\n\";\n    print $mini_mim->edited().\"\\n\";\n\n    my @corrs      = $omim_entry->each_Correlate();            # from genemap\n      # Array of Bio::Phenotype::Correlate objects.\n      # class Bio::Phenotype::Correlate\n      # provides the following:\n      # - name()\n      # - description() (not used)\n      # - species() (always mouse)\n      # - type() (\"OMIM mouse correlate\")\n      # - comment() \n\n    my @refs       = $omim_entry->each_Reference();            # *FIELD* RF\n      # Array of Bio::Annotation::Reference objects.\n\n\n    my @avs        = $omim_entry->each_AllelicVariant();       # *FIELD* AV\n      # Array of Bio::Phenotype::OMIM::OMIMentryAllelicVariant objects.\n      # class Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n      # provides the following:\n      # - number (e.g \".0001\" )\n      # - title (e.g \"ALCOHOL INTOLERANCE\" )\n      # - symbol (e.g \"ALDH2*2\" )\n      # - description (e.g \"The ALDH2*2-encoded protein has a change ...\" )\n      # - aa_ori  (used if information in the form \"LYS123ARG\" is found)\n      # - aa_mut (used if information in the form \"LYS123ARG\" is found)\n      # - position (used if information in the form \"LYS123ARG\" is found)\n      # - additional_mutations (used for e.g. \"1-BP DEL, 911T\")\n\n    my @cps        = $omim_entry->each_CytoPosition();         # from genemap\n      # Array of Bio::Map::CytoPosition objects.\n\n    my @gss        = $omim_entry->each_gene_symbol();          # from genemap\n      # Array of strings.\n\n    # do something ...\n  }\n\n=head1 DESCRIPTION\n\nThis parser returns Bio::Phenotype::OMIM::OMIMentry objects\n(which inherit from Bio::Phenotype::PhenotypeI).\nIt parses the OMIM database available as \nftp://ncbi.nlm.nih.gov/repository/OMIM/omim.txt.Z \ntogether with (optionally) the gene map file at\nftp://ncbi.nlm.nih.gov/repository/OMIM/genemap.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMparser;\n\nuse strict;\n\nuse Bio::Root::IO;\nuse Bio::Species;\nuse Bio::Annotation::Reference;\nuse Bio::Map::CytoPosition;\nuse Bio::Phenotype::OMIM::OMIMentry;\nuse Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse Bio::Phenotype::Correlate;\n\nuse base qw(Bio::Root::Root);\n\n\nuse constant DEFAULT_STATE               => 0;\nuse constant MIM_NUMBER_STATE            => 1;\nuse constant TITLE_STATE                 => 2;\nuse constant TEXT_STATE                  => 3;\nuse constant MINI_MIM_TEXT_STATE         => 4;\nuse constant ALLELIC_VARIANT_STATE       => 5;\nuse constant SEE_ALSO_STATE              => 6;\nuse constant REF_STATE                   => 7;\nuse constant SYMPT_STATE                 => 8;\nuse constant CONTRIBUTORS_STATE          => 9;\nuse constant CREATED_BY_STATE            => 10;\nuse constant EDITED_BY_STATE             => 11;\nuse constant MINI_MIM_EDITED_BY_STATE    => 12;\nuse constant MINI_MIM_CREATED_BY_STATE   => 13;\nuse constant MINI_MIM_CONTRIBUTORS_STATE => 14;\nuse constant TRUE                        => 1;\nuse constant FALSE                       => 0;\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $omim_parser = Bio::Phenotype::OMIM::OMIMparser->new( -genemap  => \"/path/to/genemap\",\n                                                                 -omimtext => \"/path/to/omim.txt\" );                      \n Function: Creates a new OMIMparser.\n Returns : A new OMIMparser object.\n Args    : -genemap  => the genemap file name (optional)\n           -omimtext => the omim text file name\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $genemap_file_name, $omimtxt_file_name ) \n    = $self->_rearrange( [ qw( GENEMAP OMIMTEXT ) ], @args );\n\n    $self->init(); \n    \n    $genemap_file_name && $self->genemap_file_name( $genemap_file_name );\n    \n    $omimtxt_file_name && $self->omimtxt_file_name( $omimtxt_file_name);\n                         \n    return $self;\n}\n\n\n\n\n=head2 next_phenotype\n\n Title   : next_phenotype()\n Usage   : while ( my $omim_entry = $omim_parser->next_phenotype() ) {\n               # do something with $omim_entry\n           }    \n Function: Returns an Bio::Phenotype::OMIM::OMIMentry or\n           undef once the end of the omim text file is reached.\n Returns : A Bio::Phenotype::OMIM::OMIMentry.\n Args    :\n\n\nsub next_phenotype {\n    my ( $self ) = @_;\n    \n    unless( defined( $self->_OMIM_text_file() ) ) {\n        $self->_no_OMIM_text_file_provided_error();\n    }\n    \n    if ( $self->_done() == TRUE ) {\n        return;\n    }\n\n    my $fieldtag          = \"\";\n    my $contents          = \"\";\n    my $line              = \"\";\n    my $state             = DEFAULT_STATE;\n    my $saw_mini_min_flag = FALSE;\n    my %record            = ();\n    \n    while( $line = ( $self->_OMIM_text_file )->_readline() ) {\n        if ( $line =~ /^\\s*\\*RECORD\\*/ ) {\n            if ( $self->_is_not_first_record() == TRUE ) {\n                $self->_add_to_hash( $state, $contents,\\%record );\n                my $omim_entry = $self->_createOMIMentry( \\%record );\n                return $omim_entry;\n            }\n            else {\n                $self->_is_not_first_record( TRUE );\n            }\n            \n        }\n        elsif ( $line =~ /^\\s*\\*FIELD\\*\\s*(\\S+)/ ) {\n            $fieldtag = $1;\n            if ( $state != DEFAULT_STATE ) {\n                $self->_add_to_hash( $state, $contents,\\%record );\n            }\n            $contents = \"\";\n            \n            if ( $fieldtag eq \"NO\" ) {\n                $state = MIM_NUMBER_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"TI\" ) {\n                $state = TITLE_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"TX\" ) {\n                $state = TEXT_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"MN\" ) {\n                $state = MINI_MIM_TEXT_STATE;\n                $saw_mini_min_flag = TRUE;           \n            }\n            elsif ( $fieldtag eq \"AV\" ) {\n                $state = ALLELIC_VARIANT_STATE;\n                $saw_mini_min_flag = FALSE;     \n            }\n            elsif ( $fieldtag eq \"SA\" ) { \n                $state = SEE_ALSO_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"RF\" ) {\n                $state = REF_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"CS\" ) {\n                $state = SYMPT_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"CN\" ) {\n                if ( $saw_mini_min_flag == TRUE ) {\n                    $state = MINI_MIM_CONTRIBUTORS_STATE;\n                }\n                else {\n                    $state = CONTRIBUTORS_STATE;\n                }     \n            }\n            elsif ( $fieldtag eq \"CD\" ) {\n                if ( $saw_mini_min_flag == TRUE ) {\n                    $state = MINI_MIM_CREATED_BY_STATE;\n                }\n                else {\n                    $state = CREATED_BY_STATE;\n                }     \n            }\n            elsif ( $fieldtag eq \"ED\" ) {\n                if ( $saw_mini_min_flag == TRUE ) {\n                    $state = MINI_MIM_EDITED_BY_STATE;\n                }\n                else {\n                    $state = EDITED_BY_STATE;\n                }     \n            }\n            else {\n                print \"Warning: Unknown tag: $fieldtag\\n\";\n            }\n\n        }\n        else {\n            $contents .= $line;\n        }\n    }\n\n    $self->_OMIM_text_file()->close();\n    $self->_done( TRUE );\n\n    unless( %record ) {\n        $self->_not_a_OMIM_text_file_error();\n    }\n\n    $self->_add_to_hash( $state, $contents,\\%record );\n    \n    my $omim_entry = $self->_createOMIMentry( \\%record );\n    \n    return $omim_entry;\n\n} # next_phenotype\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $omim_parser->init();   \n Function: Initializes this OMIMparser to all \"\".\n Returns : \n Args    :","parameters":[{"label":"$self"}]},"name":"init","range":{"start":{"line":390,"character":0},"end":{"character":9999,"line":400}}},{"line":397,"kind":12,"name":"FALSE"},{"line":398,"kind":12,"name":"FALSE"},{"range":{"end":{"character":9999,"line":424},"start":{"line":415,"character":0}},"name":"genemap_file_name","line":415,"children":[{"line":416,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"genemap_file_name"},{"line":416,"kind":13,"name":"$value","containerName":"genemap_file_name"},{"line":418,"kind":13,"containerName":"genemap_file_name","name":"$value"},{"kind":13,"line":419,"name":"$self","containerName":"genemap_file_name"},{"kind":13,"line":419,"containerName":"genemap_file_name","name":"$value"},{"containerName":"genemap_file_name","name":"$self","kind":13,"line":420},{"name":"_genemap_hash","containerName":"genemap_file_name","line":420,"kind":12},{"containerName":"genemap_file_name","name":"$self","line":420,"kind":13},{"line":420,"kind":12,"containerName":"genemap_file_name","name":"_read_genemap"},{"containerName":"genemap_file_name","name":"$value","kind":13,"line":420},{"kind":13,"line":423,"name":"$self","containerName":"genemap_file_name"}],"kind":12,"detail":"($self,$value)","signature":{"label":"genemap_file_name($self,$value)","documentation":"1;\n# $Id: OMIMparser.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMparser\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMparser - parser for the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMparser;\n\n  # The OMIM database is available as textfile at:\n  # ftp://ncbi.nlm.nih.gov/repository/OMIM/omim.txt.Z\n  # The genemap is available as textfile at:\n  # ftp://ncbi.nlm.nih.gov/repository/OMIM/genemap\n\n  $omim_parser = Bio::Phenotype::OMIM::OMIMparser->new( -genemap  => \"/path/to/genemap\",\n                                                        -omimtext => \"/path/to/omim.txt\" );\n\n  while ( my $omim_entry = $omim_parser->next_phenotype() ) {\n    # This prints everything.\n    print( $omim_entry->to_string() );\n    print \"\\n\\n\";\n\n    # This gets individual data (some of them object-arrays)\n    # (and illustrates the relevant methods of OMIMentry).\n    my $numb  = $omim_entry->MIM_number();                     # *FIELD* NO\n    my $title = $omim_entry->title();                          # *FIELD* TI - first line\n    my $alt   = $omim_entry->alternative_titles_and_symbols(); # *FIELD* TI - additional lines\n    my $mtt   = $omim_entry->more_than_two_genes();            # \"#\" before title\n    my $sep   = $omim_entry->is_separate();                    # \"*\" before title\n    my $desc  = $omim_entry->description();                    # *FIELD* TX\n    my $mm    = $omim_entry->mapping_method();                 # from genemap\n    my $gs    = $omim_entry->gene_status();                    # from genemap\n    my $cr    = $omim_entry->created();                        # *FIELD* CD\n    my $cont  = $omim_entry->contributors();                   # *FIELD* CN\n    my $ed    = $omim_entry->edited();                         # *FIELD* ED\n    my $sa    = $omim_entry->additional_references();          # *FIELD* SA\n    my $cs    = $omim_entry->clinical_symptoms_raw();              # *FIELD* CS\n    my $comm  = $omim_entry->comment();                        # from genemap\n\n    my $mini_mim   = $omim_entry->miniMIM();                   # *FIELD* MN\n      # A Bio::Phenotype::OMIM::MiniMIMentry object.\n      # class Bio::Phenotype::OMIM::MiniMIMentry\n      # provides the following:\n      # - description()\n      # - created()\n      # - contributors()\n      # - edited() \n      #\n    # Prints the contents of the MINI MIM entry (most OMIM entries do\n    # not have MINI MIM entries, though).\n    print $mini_mim->description().\"\\n\";\n    print $mini_mim->created().\"\\n\";\n    print $mini_mim->contributors().\"\\n\";\n    print $mini_mim->edited().\"\\n\";\n\n    my @corrs      = $omim_entry->each_Correlate();            # from genemap\n      # Array of Bio::Phenotype::Correlate objects.\n      # class Bio::Phenotype::Correlate\n      # provides the following:\n      # - name()\n      # - description() (not used)\n      # - species() (always mouse)\n      # - type() (\"OMIM mouse correlate\")\n      # - comment() \n\n    my @refs       = $omim_entry->each_Reference();            # *FIELD* RF\n      # Array of Bio::Annotation::Reference objects.\n\n\n    my @avs        = $omim_entry->each_AllelicVariant();       # *FIELD* AV\n      # Array of Bio::Phenotype::OMIM::OMIMentryAllelicVariant objects.\n      # class Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n      # provides the following:\n      # - number (e.g \".0001\" )\n      # - title (e.g \"ALCOHOL INTOLERANCE\" )\n      # - symbol (e.g \"ALDH2*2\" )\n      # - description (e.g \"The ALDH2*2-encoded protein has a change ...\" )\n      # - aa_ori  (used if information in the form \"LYS123ARG\" is found)\n      # - aa_mut (used if information in the form \"LYS123ARG\" is found)\n      # - position (used if information in the form \"LYS123ARG\" is found)\n      # - additional_mutations (used for e.g. \"1-BP DEL, 911T\")\n\n    my @cps        = $omim_entry->each_CytoPosition();         # from genemap\n      # Array of Bio::Map::CytoPosition objects.\n\n    my @gss        = $omim_entry->each_gene_symbol();          # from genemap\n      # Array of strings.\n\n    # do something ...\n  }\n\n=head1 DESCRIPTION\n\nThis parser returns Bio::Phenotype::OMIM::OMIMentry objects\n(which inherit from Bio::Phenotype::PhenotypeI).\nIt parses the OMIM database available as \nftp://ncbi.nlm.nih.gov/repository/OMIM/omim.txt.Z \ntogether with (optionally) the gene map file at\nftp://ncbi.nlm.nih.gov/repository/OMIM/genemap.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMparser;\n\nuse strict;\n\nuse Bio::Root::IO;\nuse Bio::Species;\nuse Bio::Annotation::Reference;\nuse Bio::Map::CytoPosition;\nuse Bio::Phenotype::OMIM::OMIMentry;\nuse Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse Bio::Phenotype::Correlate;\n\nuse base qw(Bio::Root::Root);\n\n\nuse constant DEFAULT_STATE               => 0;\nuse constant MIM_NUMBER_STATE            => 1;\nuse constant TITLE_STATE                 => 2;\nuse constant TEXT_STATE                  => 3;\nuse constant MINI_MIM_TEXT_STATE         => 4;\nuse constant ALLELIC_VARIANT_STATE       => 5;\nuse constant SEE_ALSO_STATE              => 6;\nuse constant REF_STATE                   => 7;\nuse constant SYMPT_STATE                 => 8;\nuse constant CONTRIBUTORS_STATE          => 9;\nuse constant CREATED_BY_STATE            => 10;\nuse constant EDITED_BY_STATE             => 11;\nuse constant MINI_MIM_EDITED_BY_STATE    => 12;\nuse constant MINI_MIM_CREATED_BY_STATE   => 13;\nuse constant MINI_MIM_CONTRIBUTORS_STATE => 14;\nuse constant TRUE                        => 1;\nuse constant FALSE                       => 0;\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $omim_parser = Bio::Phenotype::OMIM::OMIMparser->new( -genemap  => \"/path/to/genemap\",\n                                                                 -omimtext => \"/path/to/omim.txt\" );                      \n Function: Creates a new OMIMparser.\n Returns : A new OMIMparser object.\n Args    : -genemap  => the genemap file name (optional)\n           -omimtext => the omim text file name\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $genemap_file_name, $omimtxt_file_name ) \n    = $self->_rearrange( [ qw( GENEMAP OMIMTEXT ) ], @args );\n\n    $self->init(); \n    \n    $genemap_file_name && $self->genemap_file_name( $genemap_file_name );\n    \n    $omimtxt_file_name && $self->omimtxt_file_name( $omimtxt_file_name);\n                         \n    return $self;\n}\n\n\n\n\n=head2 next_phenotype\n\n Title   : next_phenotype()\n Usage   : while ( my $omim_entry = $omim_parser->next_phenotype() ) {\n               # do something with $omim_entry\n           }    \n Function: Returns an Bio::Phenotype::OMIM::OMIMentry or\n           undef once the end of the omim text file is reached.\n Returns : A Bio::Phenotype::OMIM::OMIMentry.\n Args    :\n\n\nsub next_phenotype {\n    my ( $self ) = @_;\n    \n    unless( defined( $self->_OMIM_text_file() ) ) {\n        $self->_no_OMIM_text_file_provided_error();\n    }\n    \n    if ( $self->_done() == TRUE ) {\n        return;\n    }\n\n    my $fieldtag          = \"\";\n    my $contents          = \"\";\n    my $line              = \"\";\n    my $state             = DEFAULT_STATE;\n    my $saw_mini_min_flag = FALSE;\n    my %record            = ();\n    \n    while( $line = ( $self->_OMIM_text_file )->_readline() ) {\n        if ( $line =~ /^\\s*\\*RECORD\\*/ ) {\n            if ( $self->_is_not_first_record() == TRUE ) {\n                $self->_add_to_hash( $state, $contents,\\%record );\n                my $omim_entry = $self->_createOMIMentry( \\%record );\n                return $omim_entry;\n            }\n            else {\n                $self->_is_not_first_record( TRUE );\n            }\n            \n        }\n        elsif ( $line =~ /^\\s*\\*FIELD\\*\\s*(\\S+)/ ) {\n            $fieldtag = $1;\n            if ( $state != DEFAULT_STATE ) {\n                $self->_add_to_hash( $state, $contents,\\%record );\n            }\n            $contents = \"\";\n            \n            if ( $fieldtag eq \"NO\" ) {\n                $state = MIM_NUMBER_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"TI\" ) {\n                $state = TITLE_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"TX\" ) {\n                $state = TEXT_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"MN\" ) {\n                $state = MINI_MIM_TEXT_STATE;\n                $saw_mini_min_flag = TRUE;           \n            }\n            elsif ( $fieldtag eq \"AV\" ) {\n                $state = ALLELIC_VARIANT_STATE;\n                $saw_mini_min_flag = FALSE;     \n            }\n            elsif ( $fieldtag eq \"SA\" ) { \n                $state = SEE_ALSO_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"RF\" ) {\n                $state = REF_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"CS\" ) {\n                $state = SYMPT_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"CN\" ) {\n                if ( $saw_mini_min_flag == TRUE ) {\n                    $state = MINI_MIM_CONTRIBUTORS_STATE;\n                }\n                else {\n                    $state = CONTRIBUTORS_STATE;\n                }     \n            }\n            elsif ( $fieldtag eq \"CD\" ) {\n                if ( $saw_mini_min_flag == TRUE ) {\n                    $state = MINI_MIM_CREATED_BY_STATE;\n                }\n                else {\n                    $state = CREATED_BY_STATE;\n                }     \n            }\n            elsif ( $fieldtag eq \"ED\" ) {\n                if ( $saw_mini_min_flag == TRUE ) {\n                    $state = MINI_MIM_EDITED_BY_STATE;\n                }\n                else {\n                    $state = EDITED_BY_STATE;\n                }     \n            }\n            else {\n                print \"Warning: Unknown tag: $fieldtag\\n\";\n            }\n\n        }\n        else {\n            $contents .= $line;\n        }\n    }\n\n    $self->_OMIM_text_file()->close();\n    $self->_done( TRUE );\n\n    unless( %record ) {\n        $self->_not_a_OMIM_text_file_error();\n    }\n\n    $self->_add_to_hash( $state, $contents,\\%record );\n    \n    my $omim_entry = $self->_createOMIMentry( \\%record );\n    \n    return $omim_entry;\n\n} # next_phenotype\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $omim_parser->init();   \n Function: Initializes this OMIMparser to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n    \n    $self->genemap_file_name( \"\" );\n    $self->omimtxt_file_name( \"\" );\n    $self->_genemap_hash( {} );\n    $self->_OMIM_text_file( undef );\n    $self->_is_not_first_record( FALSE );\n    $self->_done( FALSE );\n\n} # init\n\n\n\n\n=head2 genemap_file_name\n\n Title   : genemap_file_name\n Usage   : $omimparser->genemap_file_name( \"genemap\" );\n Function: Set/get for the genemap file name.\n Returns : The genemap file name [string].\n Args    : The genemap file name [string] (optional).","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub"},{"name":"omimtxt_file_name","range":{"start":{"character":0,"line":439},"end":{"character":9999,"line":450}},"kind":12,"children":[{"containerName":"omimtxt_file_name","definition":"my","name":"$self","localvar":"my","kind":13,"line":440},{"containerName":"omimtxt_file_name","name":"$value","kind":13,"line":440},{"name":"$value","containerName":"omimtxt_file_name","line":442,"kind":13},{"line":443,"kind":13,"name":"$self","containerName":"omimtxt_file_name"},{"line":443,"kind":13,"name":"$value","containerName":"omimtxt_file_name"},{"containerName":"omimtxt_file_name","name":"$value","line":444,"kind":13},{"containerName":"omimtxt_file_name","name":"$self","line":445,"kind":13},{"containerName":"omimtxt_file_name","name":"_OMIM_text_file","kind":12,"line":445},{"line":445,"kind":12,"name":"new","containerName":"omimtxt_file_name"},{"containerName":"omimtxt_file_name","name":"new","line":445,"kind":12},{"containerName":"omimtxt_file_name","name":"$value","line":445,"kind":13},{"name":"$self","containerName":"omimtxt_file_name","line":449,"kind":13}],"line":439,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: OMIMparser.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMparser\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMparser - parser for the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMparser;\n\n  # The OMIM database is available as textfile at:\n  # ftp://ncbi.nlm.nih.gov/repository/OMIM/omim.txt.Z\n  # The genemap is available as textfile at:\n  # ftp://ncbi.nlm.nih.gov/repository/OMIM/genemap\n\n  $omim_parser = Bio::Phenotype::OMIM::OMIMparser->new( -genemap  => \"/path/to/genemap\",\n                                                        -omimtext => \"/path/to/omim.txt\" );\n\n  while ( my $omim_entry = $omim_parser->next_phenotype() ) {\n    # This prints everything.\n    print( $omim_entry->to_string() );\n    print \"\\n\\n\";\n\n    # This gets individual data (some of them object-arrays)\n    # (and illustrates the relevant methods of OMIMentry).\n    my $numb  = $omim_entry->MIM_number();                     # *FIELD* NO\n    my $title = $omim_entry->title();                          # *FIELD* TI - first line\n    my $alt   = $omim_entry->alternative_titles_and_symbols(); # *FIELD* TI - additional lines\n    my $mtt   = $omim_entry->more_than_two_genes();            # \"#\" before title\n    my $sep   = $omim_entry->is_separate();                    # \"*\" before title\n    my $desc  = $omim_entry->description();                    # *FIELD* TX\n    my $mm    = $omim_entry->mapping_method();                 # from genemap\n    my $gs    = $omim_entry->gene_status();                    # from genemap\n    my $cr    = $omim_entry->created();                        # *FIELD* CD\n    my $cont  = $omim_entry->contributors();                   # *FIELD* CN\n    my $ed    = $omim_entry->edited();                         # *FIELD* ED\n    my $sa    = $omim_entry->additional_references();          # *FIELD* SA\n    my $cs    = $omim_entry->clinical_symptoms_raw();              # *FIELD* CS\n    my $comm  = $omim_entry->comment();                        # from genemap\n\n    my $mini_mim   = $omim_entry->miniMIM();                   # *FIELD* MN\n      # A Bio::Phenotype::OMIM::MiniMIMentry object.\n      # class Bio::Phenotype::OMIM::MiniMIMentry\n      # provides the following:\n      # - description()\n      # - created()\n      # - contributors()\n      # - edited() \n      #\n    # Prints the contents of the MINI MIM entry (most OMIM entries do\n    # not have MINI MIM entries, though).\n    print $mini_mim->description().\"\\n\";\n    print $mini_mim->created().\"\\n\";\n    print $mini_mim->contributors().\"\\n\";\n    print $mini_mim->edited().\"\\n\";\n\n    my @corrs      = $omim_entry->each_Correlate();            # from genemap\n      # Array of Bio::Phenotype::Correlate objects.\n      # class Bio::Phenotype::Correlate\n      # provides the following:\n      # - name()\n      # - description() (not used)\n      # - species() (always mouse)\n      # - type() (\"OMIM mouse correlate\")\n      # - comment() \n\n    my @refs       = $omim_entry->each_Reference();            # *FIELD* RF\n      # Array of Bio::Annotation::Reference objects.\n\n\n    my @avs        = $omim_entry->each_AllelicVariant();       # *FIELD* AV\n      # Array of Bio::Phenotype::OMIM::OMIMentryAllelicVariant objects.\n      # class Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n      # provides the following:\n      # - number (e.g \".0001\" )\n      # - title (e.g \"ALCOHOL INTOLERANCE\" )\n      # - symbol (e.g \"ALDH2*2\" )\n      # - description (e.g \"The ALDH2*2-encoded protein has a change ...\" )\n      # - aa_ori  (used if information in the form \"LYS123ARG\" is found)\n      # - aa_mut (used if information in the form \"LYS123ARG\" is found)\n      # - position (used if information in the form \"LYS123ARG\" is found)\n      # - additional_mutations (used for e.g. \"1-BP DEL, 911T\")\n\n    my @cps        = $omim_entry->each_CytoPosition();         # from genemap\n      # Array of Bio::Map::CytoPosition objects.\n\n    my @gss        = $omim_entry->each_gene_symbol();          # from genemap\n      # Array of strings.\n\n    # do something ...\n  }\n\n=head1 DESCRIPTION\n\nThis parser returns Bio::Phenotype::OMIM::OMIMentry objects\n(which inherit from Bio::Phenotype::PhenotypeI).\nIt parses the OMIM database available as \nftp://ncbi.nlm.nih.gov/repository/OMIM/omim.txt.Z \ntogether with (optionally) the gene map file at\nftp://ncbi.nlm.nih.gov/repository/OMIM/genemap.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMparser;\n\nuse strict;\n\nuse Bio::Root::IO;\nuse Bio::Species;\nuse Bio::Annotation::Reference;\nuse Bio::Map::CytoPosition;\nuse Bio::Phenotype::OMIM::OMIMentry;\nuse Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse Bio::Phenotype::Correlate;\n\nuse base qw(Bio::Root::Root);\n\n\nuse constant DEFAULT_STATE               => 0;\nuse constant MIM_NUMBER_STATE            => 1;\nuse constant TITLE_STATE                 => 2;\nuse constant TEXT_STATE                  => 3;\nuse constant MINI_MIM_TEXT_STATE         => 4;\nuse constant ALLELIC_VARIANT_STATE       => 5;\nuse constant SEE_ALSO_STATE              => 6;\nuse constant REF_STATE                   => 7;\nuse constant SYMPT_STATE                 => 8;\nuse constant CONTRIBUTORS_STATE          => 9;\nuse constant CREATED_BY_STATE            => 10;\nuse constant EDITED_BY_STATE             => 11;\nuse constant MINI_MIM_EDITED_BY_STATE    => 12;\nuse constant MINI_MIM_CREATED_BY_STATE   => 13;\nuse constant MINI_MIM_CONTRIBUTORS_STATE => 14;\nuse constant TRUE                        => 1;\nuse constant FALSE                       => 0;\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $omim_parser = Bio::Phenotype::OMIM::OMIMparser->new( -genemap  => \"/path/to/genemap\",\n                                                                 -omimtext => \"/path/to/omim.txt\" );                      \n Function: Creates a new OMIMparser.\n Returns : A new OMIMparser object.\n Args    : -genemap  => the genemap file name (optional)\n           -omimtext => the omim text file name\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $genemap_file_name, $omimtxt_file_name ) \n    = $self->_rearrange( [ qw( GENEMAP OMIMTEXT ) ], @args );\n\n    $self->init(); \n    \n    $genemap_file_name && $self->genemap_file_name( $genemap_file_name );\n    \n    $omimtxt_file_name && $self->omimtxt_file_name( $omimtxt_file_name);\n                         \n    return $self;\n}\n\n\n\n\n=head2 next_phenotype\n\n Title   : next_phenotype()\n Usage   : while ( my $omim_entry = $omim_parser->next_phenotype() ) {\n               # do something with $omim_entry\n           }    \n Function: Returns an Bio::Phenotype::OMIM::OMIMentry or\n           undef once the end of the omim text file is reached.\n Returns : A Bio::Phenotype::OMIM::OMIMentry.\n Args    :\n\n\nsub next_phenotype {\n    my ( $self ) = @_;\n    \n    unless( defined( $self->_OMIM_text_file() ) ) {\n        $self->_no_OMIM_text_file_provided_error();\n    }\n    \n    if ( $self->_done() == TRUE ) {\n        return;\n    }\n\n    my $fieldtag          = \"\";\n    my $contents          = \"\";\n    my $line              = \"\";\n    my $state             = DEFAULT_STATE;\n    my $saw_mini_min_flag = FALSE;\n    my %record            = ();\n    \n    while( $line = ( $self->_OMIM_text_file )->_readline() ) {\n        if ( $line =~ /^\\s*\\*RECORD\\*/ ) {\n            if ( $self->_is_not_first_record() == TRUE ) {\n                $self->_add_to_hash( $state, $contents,\\%record );\n                my $omim_entry = $self->_createOMIMentry( \\%record );\n                return $omim_entry;\n            }\n            else {\n                $self->_is_not_first_record( TRUE );\n            }\n            \n        }\n        elsif ( $line =~ /^\\s*\\*FIELD\\*\\s*(\\S+)/ ) {\n            $fieldtag = $1;\n            if ( $state != DEFAULT_STATE ) {\n                $self->_add_to_hash( $state, $contents,\\%record );\n            }\n            $contents = \"\";\n            \n            if ( $fieldtag eq \"NO\" ) {\n                $state = MIM_NUMBER_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"TI\" ) {\n                $state = TITLE_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"TX\" ) {\n                $state = TEXT_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"MN\" ) {\n                $state = MINI_MIM_TEXT_STATE;\n                $saw_mini_min_flag = TRUE;           \n            }\n            elsif ( $fieldtag eq \"AV\" ) {\n                $state = ALLELIC_VARIANT_STATE;\n                $saw_mini_min_flag = FALSE;     \n            }\n            elsif ( $fieldtag eq \"SA\" ) { \n                $state = SEE_ALSO_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"RF\" ) {\n                $state = REF_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"CS\" ) {\n                $state = SYMPT_STATE;\n                $saw_mini_min_flag = FALSE;   \n            }\n            elsif ( $fieldtag eq \"CN\" ) {\n                if ( $saw_mini_min_flag == TRUE ) {\n                    $state = MINI_MIM_CONTRIBUTORS_STATE;\n                }\n                else {\n                    $state = CONTRIBUTORS_STATE;\n                }     \n            }\n            elsif ( $fieldtag eq \"CD\" ) {\n                if ( $saw_mini_min_flag == TRUE ) {\n                    $state = MINI_MIM_CREATED_BY_STATE;\n                }\n                else {\n                    $state = CREATED_BY_STATE;\n                }     \n            }\n            elsif ( $fieldtag eq \"ED\" ) {\n                if ( $saw_mini_min_flag == TRUE ) {\n                    $state = MINI_MIM_EDITED_BY_STATE;\n                }\n                else {\n                    $state = EDITED_BY_STATE;\n                }     \n            }\n            else {\n                print \"Warning: Unknown tag: $fieldtag\\n\";\n            }\n\n        }\n        else {\n            $contents .= $line;\n        }\n    }\n\n    $self->_OMIM_text_file()->close();\n    $self->_done( TRUE );\n\n    unless( %record ) {\n        $self->_not_a_OMIM_text_file_error();\n    }\n\n    $self->_add_to_hash( $state, $contents,\\%record );\n    \n    my $omim_entry = $self->_createOMIMentry( \\%record );\n    \n    return $omim_entry;\n\n} # next_phenotype\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $omim_parser->init();   \n Function: Initializes this OMIMparser to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my ( $self ) = @_;\n    \n    $self->genemap_file_name( \"\" );\n    $self->omimtxt_file_name( \"\" );\n    $self->_genemap_hash( {} );\n    $self->_OMIM_text_file( undef );\n    $self->_is_not_first_record( FALSE );\n    $self->_done( FALSE );\n\n} # init\n\n\n\n\n=head2 genemap_file_name\n\n Title   : genemap_file_name\n Usage   : $omimparser->genemap_file_name( \"genemap\" );\n Function: Set/get for the genemap file name.\n Returns : The genemap file name [string].\n Args    : The genemap file name [string] (optional).\n\n\nsub genemap_file_name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_genemap_file_name\" } = $value;\n        $self->_genemap_hash( $self->_read_genemap( $value ) );\n    }\n    \n    return $self->{ \"_genemap_file_name\" };\n} # genemap_file_name\n\n\n\n\n=head2 omimtxt_file_name\n\n Title   : omimtxt_file_name\n Usage   : $omimparser->omimtxt_file_name( \"omim.txt\" );\n Function: Set/get for the omim text file name.\n Returns : The the omim text file name [string].\n Args    : The the omim text file name [string] (optional).","label":"omimtxt_file_name($self,$value)"},"detail":"($self,$value)"},{"name":"Bio","containerName":"Root::IO","line":445,"kind":12},{"name":"_createOMIMentry","range":{"end":{"character":9999,"line":547},"start":{"character":0,"line":456}},"kind":12,"children":[{"line":457,"kind":13,"localvar":"my","containerName":"_createOMIMentry","name":"$self","definition":"my"},{"line":457,"kind":13,"name":"$record_ref","containerName":"_createOMIMentry"},{"containerName":"_createOMIMentry","name":"$omim_entry","definition":"my","localvar":"my","kind":13,"line":459},{"name":"new","containerName":"_createOMIMentry","line":459,"kind":12},{"kind":13,"line":460,"name":"$mini_mim","definition":"my","containerName":"_createOMIMentry","localvar":"my"},{"containerName":"_createOMIMentry","name":"new","kind":12,"line":460},{"line":462,"kind":13,"localvar":"my","definition":"my","name":"$key","containerName":"_createOMIMentry"},{"line":462,"kind":13,"localvar":"my","containerName":"_createOMIMentry","name":"$val","definition":"my"},{"line":462,"kind":13,"containerName":"_createOMIMentry","name":"$record_ref"},{"line":464,"kind":13,"name":"$val","containerName":"_createOMIMentry"},{"kind":13,"line":465,"containerName":"_createOMIMentry","name":"$val"},{"kind":13,"line":467,"containerName":"_createOMIMentry","name":"$key"},{"kind":13,"line":468,"name":"$val","containerName":"_createOMIMentry"},{"name":"$val","containerName":"_createOMIMentry","line":469,"kind":13},{"containerName":"_createOMIMentry","name":"$omim_entry","line":471,"kind":13},{"name":"MIM_number","containerName":"_createOMIMentry","kind":12,"line":471},{"name":"$val","containerName":"_createOMIMentry","line":471,"kind":13},{"line":473,"kind":13,"localvar":"my","containerName":"_createOMIMentry","name":"$gm","definition":"my"},{"name":"$self","containerName":"_createOMIMentry","line":473,"kind":13},{"line":473,"kind":12,"name":"_genemap_hash","containerName":"_createOMIMentry"},{"name":"$val","containerName":"_createOMIMentry","kind":13,"line":474},{"line":475,"kind":13,"containerName":"_createOMIMentry","name":"$self"},{"containerName":"_createOMIMentry","name":"_parse_genemap","line":475,"kind":12},{"line":475,"kind":13,"containerName":"_createOMIMentry","name":"$omim_entry"},{"containerName":"_createOMIMentry","name":"$val","line":475,"kind":13},{"line":479,"kind":13,"containerName":"_createOMIMentry","name":"$key"},{"containerName":"_createOMIMentry","definition":"my","name":"$title","localvar":"my","kind":13,"line":480},{"containerName":"_createOMIMentry","name":"$alt_titles","kind":13,"line":480},{"line":480,"kind":13,"containerName":"_createOMIMentry","name":"$self"},{"containerName":"_createOMIMentry","name":"_parse_title","line":480,"kind":12},{"name":"$val","containerName":"_createOMIMentry","line":480,"kind":13},{"kind":13,"line":481,"containerName":"_createOMIMentry","name":"$omim_entry"},{"line":481,"kind":12,"name":"title","containerName":"_createOMIMentry"},{"name":"$title","containerName":"_createOMIMentry","kind":13,"line":481},{"name":"$omim_entry","containerName":"_createOMIMentry","kind":13,"line":482},{"containerName":"_createOMIMentry","name":"alternative_titles_and_symbols","kind":12,"line":482},{"line":482,"kind":13,"containerName":"_createOMIMentry","name":"$alt_titles"},{"kind":13,"line":483,"name":"$title","containerName":"_createOMIMentry"},{"kind":13,"line":484,"containerName":"_createOMIMentry","name":"$omim_entry"},{"containerName":"_createOMIMentry","name":"is_separate","kind":12,"line":484},{"line":486,"kind":13,"containerName":"_createOMIMentry","name":"$title"},{"containerName":"_createOMIMentry","name":"$omim_entry","kind":13,"line":487},{"name":"more_than_two_genes","containerName":"_createOMIMentry","kind":12,"line":487},{"kind":13,"line":490,"containerName":"_createOMIMentry","name":"$key"},{"name":"$val","containerName":"_createOMIMentry","line":491,"kind":13},{"containerName":"_createOMIMentry","name":"$val","line":491,"kind":13},{"name":"$omim_entry","containerName":"_createOMIMentry","kind":13,"line":492},{"kind":12,"line":492,"name":"description","containerName":"_createOMIMentry"},{"line":492,"kind":13,"containerName":"_createOMIMentry","name":"$val"},{"containerName":"_createOMIMentry","name":"$key","kind":13,"line":494},{"kind":13,"line":495,"definition":"my","name":"@allelic_variants","containerName":"_createOMIMentry","localvar":"my"},{"kind":13,"line":495,"name":"$self","containerName":"_createOMIMentry"},{"containerName":"_createOMIMentry","name":"_parse_allelic_variants","kind":12,"line":495},{"line":495,"kind":13,"containerName":"_createOMIMentry","name":"$val"},{"line":496,"kind":13,"name":"$omim_entry","containerName":"_createOMIMentry"},{"name":"add_AllelicVariants","containerName":"_createOMIMentry","kind":12,"line":496},{"containerName":"_createOMIMentry","name":"@allelic_variants","line":496,"kind":13},{"kind":13,"line":498,"containerName":"_createOMIMentry","name":"$key"},{"containerName":"_createOMIMentry","name":"$omim_entry","line":499,"kind":13},{"containerName":"_createOMIMentry","name":"additional_references","kind":12,"line":499},{"line":499,"kind":13,"containerName":"_createOMIMentry","name":"$val"},{"name":"$key","containerName":"_createOMIMentry","line":501,"kind":13},{"name":"@refs","definition":"my","containerName":"_createOMIMentry","localvar":"my","kind":13,"line":502},{"containerName":"_createOMIMentry","name":"$self","kind":13,"line":502},{"line":502,"kind":12,"name":"_parse_references","containerName":"_createOMIMentry"},{"line":502,"kind":13,"name":"$val","containerName":"_createOMIMentry"},{"kind":13,"line":503,"name":"$omim_entry","containerName":"_createOMIMentry"},{"kind":12,"line":503,"name":"add_References","containerName":"_createOMIMentry"},{"line":503,"kind":13,"containerName":"_createOMIMentry","name":"@refs"},{"name":"$key","containerName":"_createOMIMentry","kind":13,"line":505},{"kind":13,"line":506,"containerName":"_createOMIMentry","name":"$val"},{"kind":13,"line":506,"containerName":"_createOMIMentry","name":"$val"},{"name":"$omim_entry","containerName":"_createOMIMentry","line":507,"kind":13},{"containerName":"_createOMIMentry","name":"clinical_symptoms_raw","line":507,"kind":12},{"name":"$val","containerName":"_createOMIMentry","line":507,"kind":13},{"line":509,"kind":13,"containerName":"_createOMIMentry","name":"$key"},{"name":"$val","containerName":"_createOMIMentry","kind":13,"line":510},{"containerName":"_createOMIMentry","name":"$val","kind":13,"line":510},{"name":"$omim_entry","containerName":"_createOMIMentry","kind":13,"line":511},{"line":511,"kind":12,"containerName":"_createOMIMentry","name":"contributors"},{"kind":13,"line":511,"containerName":"_createOMIMentry","name":"$val"},{"name":"$key","containerName":"_createOMIMentry","kind":13,"line":513},{"line":514,"kind":13,"name":"$val","containerName":"_createOMIMentry"},{"name":"$val","containerName":"_createOMIMentry","line":514,"kind":13},{"line":515,"kind":13,"name":"$omim_entry","containerName":"_createOMIMentry"},{"kind":12,"line":515,"containerName":"_createOMIMentry","name":"created"},{"name":"$val","containerName":"_createOMIMentry","kind":13,"line":515},{"containerName":"_createOMIMentry","name":"$key","kind":13,"line":517},{"kind":13,"line":518,"name":"$val","containerName":"_createOMIMentry"},{"line":518,"kind":13,"name":"$val","containerName":"_createOMIMentry"},{"name":"$omim_entry","containerName":"_createOMIMentry","kind":13,"line":519},{"line":519,"kind":12,"containerName":"_createOMIMentry","name":"edited"},{"line":519,"kind":13,"containerName":"_createOMIMentry","name":"$val"},{"line":521,"kind":13,"containerName":"_createOMIMentry","name":"$key"},{"line":522,"kind":13,"containerName":"_createOMIMentry","name":"$mini_mim"},{"kind":12,"line":522,"containerName":"_createOMIMentry","name":"description"},{"kind":13,"line":522,"containerName":"_createOMIMentry","name":"$val"},{"containerName":"_createOMIMentry","name":"$key","line":524,"kind":13},{"containerName":"_createOMIMentry","name":"$mini_mim","line":525,"kind":13},{"name":"contributors","containerName":"_createOMIMentry","line":525,"kind":12},{"kind":13,"line":525,"containerName":"_createOMIMentry","name":"$val"},{"name":"$key","containerName":"_createOMIMentry","line":527,"kind":13},{"name":"$mini_mim","containerName":"_createOMIMentry","kind":13,"line":528},{"name":"created","containerName":"_createOMIMentry","line":528,"kind":12},{"line":528,"kind":13,"name":"$val","containerName":"_createOMIMentry"},{"kind":13,"line":530,"containerName":"_createOMIMentry","name":"$key"},{"line":531,"kind":13,"name":"$mini_mim","containerName":"_createOMIMentry"},{"name":"edited","containerName":"_createOMIMentry","kind":12,"line":531},{"kind":13,"line":531,"name":"$val","containerName":"_createOMIMentry"},{"name":"$man","definition":"my","containerName":"_createOMIMentry","localvar":"my","kind":13,"line":536},{"kind":12,"line":536,"name":"new","containerName":"_createOMIMentry"},{"kind":13,"line":537,"name":"$man","containerName":"_createOMIMentry"},{"name":"classification","containerName":"_createOMIMentry","kind":12,"line":537},{"name":"$man","containerName":"_createOMIMentry","line":538,"kind":13},{"name":"common_name","containerName":"_createOMIMentry","kind":12,"line":538},{"line":539,"kind":13,"name":"$omim_entry","containerName":"_createOMIMentry"},{"containerName":"_createOMIMentry","name":"species","line":539,"kind":12},{"line":539,"kind":13,"name":"$man","containerName":"_createOMIMentry"},{"name":"$omim_entry","containerName":"_createOMIMentry","kind":13,"line":540},{"line":540,"kind":12,"containerName":"_createOMIMentry","name":"miniMIM"},{"line":540,"kind":13,"containerName":"_createOMIMentry","name":"$mini_mim"},{"containerName":"_createOMIMentry","name":"$self","kind":13,"line":543},{"line":543,"kind":12,"containerName":"_createOMIMentry","name":"_finer_parse_symptoms"},{"kind":13,"line":543,"name":"$omim_entry","containerName":"_createOMIMentry"},{"kind":13,"line":545,"containerName":"_createOMIMentry","name":"$omim_entry"}],"line":456,"definition":"sub","containerName":"main::","signature":{"label":"_createOMIMentry($self,$record_ref)","documentation":"","parameters":[{"label":"$self"},{"label":"$record_ref"}]},"detail":"($self,$record_ref)"},{"name":"Bio","containerName":"Phenotype::OMIM::OMIMentry","line":459,"kind":12},{"containerName":"Phenotype::OMIM::MiniMIMentry","name":"Bio","line":460,"kind":12},{"line":467,"kind":12,"name":"MIM_NUMBER_STATE"},{"line":474,"kind":12,"name":"gm"},{"line":479,"kind":12,"name":"TITLE_STATE"},{"kind":12,"line":484,"name":"TRUE"},{"kind":12,"line":487,"name":"TRUE"},{"kind":12,"line":490,"name":"TEXT_STATE"},{"line":494,"kind":12,"name":"ALLELIC_VARIANT_STATE"},{"line":498,"kind":12,"name":"SEE_ALSO_STATE"},{"name":"REF_STATE","kind":12,"line":501},{"line":505,"kind":12,"name":"SYMPT_STATE"},{"kind":12,"line":509,"name":"CONTRIBUTORS_STATE"},{"name":"CREATED_BY_STATE","line":513,"kind":12},{"name":"EDITED_BY_STATE","kind":12,"line":517},{"kind":12,"line":521,"name":"MINI_MIM_TEXT_STATE"},{"name":"MINI_MIM_CONTRIBUTORS_STATE","kind":12,"line":524},{"name":"MINI_MIM_CREATED_BY_STATE","line":527,"kind":12},{"kind":12,"line":530,"name":"MINI_MIM_EDITED_BY_STATE"},{"name":"Bio","containerName":"Species","kind":12,"line":536},{"definition":"sub","containerName":"main::","signature":{"label":"_finer_parse_symptoms($self,$omim_entry)","parameters":[{"label":"$self"},{"label":"$omim_entry"}],"documentation":""},"detail":"($self,$omim_entry)","kind":12,"children":[{"containerName":"_finer_parse_symptoms","definition":"my","name":"$self","localvar":"my","kind":13,"line":551},{"line":551,"kind":13,"containerName":"_finer_parse_symptoms","name":"$omim_entry"},{"kind":13,"line":552,"definition":"my","name":"$text","containerName":"_finer_parse_symptoms","localvar":"my"},{"name":"$omim_entry","containerName":"_finer_parse_symptoms","line":552,"kind":13},{"name":"clinical_symptoms_raw","containerName":"_finer_parse_symptoms","kind":12,"line":552},{"kind":13,"line":553,"containerName":"_finer_parse_symptoms","name":"$text"},{"kind":13,"line":554,"name":"$part","definition":"my","containerName":"_finer_parse_symptoms","localvar":"my"},{"containerName":"_finer_parse_symptoms","name":"$line","definition":"my","localvar":"my","kind":13,"line":555},{"name":"$text","containerName":"_finer_parse_symptoms","kind":13,"line":555},{"containerName":"_finer_parse_symptoms","name":"$line","line":556,"kind":13},{"name":"$part","containerName":"_finer_parse_symptoms","kind":13,"line":557},{"line":558,"kind":13,"containerName":"_finer_parse_symptoms","name":"$line"},{"kind":13,"line":559,"containerName":"_finer_parse_symptoms","name":"$line"},{"kind":13,"line":560,"name":"$symptom","definition":"my","containerName":"_finer_parse_symptoms","localvar":"my"},{"kind":13,"line":561,"name":"$part","containerName":"_finer_parse_symptoms"},{"line":565,"kind":13,"containerName":"_finer_parse_symptoms","name":"$omim_entry"},{"name":"add_clinical_symptoms","containerName":"_finer_parse_symptoms","line":565,"kind":12},{"kind":13,"line":565,"containerName":"_finer_parse_symptoms","name":"$part"},{"name":"$symptom","containerName":"_finer_parse_symptoms","line":565,"kind":13},{"kind":13,"line":569,"containerName":"_finer_parse_symptoms","name":"$omim_entry"},{"kind":12,"line":569,"containerName":"_finer_parse_symptoms","name":"clinical_symptoms_raw"}],"line":550,"name":"_finer_parse_symptoms","range":{"end":{"character":9999,"line":570},"start":{"character":0,"line":550}}},{"name":"_parse_genemap","range":{"end":{"line":575,"character":9999},"start":{"character":0,"line":572}},"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$omim_entry"},{"label":"$val"}],"label":"_parse_genemap($self,$omim_entry,$val)"},"detail":"($self,$omim_entry,$val)","kind":12,"children":[{"name":"$self","definition":"my","containerName":"_parse_genemap","localvar":"my","kind":13,"line":573},{"kind":13,"line":573,"containerName":"_parse_genemap","name":"$omim_entry"},{"containerName":"_parse_genemap","name":"$val","line":573,"kind":13},{"localvar":"my","containerName":"_parse_genemap","name":"$genemap_line","definition":"my","line":575,"kind":13},{"kind":13,"line":575,"containerName":"_parse_genemap","name":"$self"},{"name":"_genemap_hash","containerName":"_parse_genemap","line":575,"kind":12}],"line":572},{"containerName":null,"name":"$val","line":575,"kind":13},{"line":576,"kind":13,"localvar":"my","definition":"my","name":"@a","containerName":null},{"kind":13,"line":576,"name":"$genemap_line","containerName":null},{"definition":"my","name":"$locations","containerName":null,"localvar":"my","kind":13,"line":578},{"name":"@a","containerName":null,"line":578,"kind":13},{"name":"%locations","containerName":null,"line":579,"kind":13},{"line":580,"kind":13,"name":"$locations","containerName":null},{"kind":13,"line":581,"containerName":null,"name":"@ls","definition":"my","localvar":"my"},{"containerName":null,"name":"$locations","line":581,"kind":13},{"name":"@cps","definition":"my","containerName":null,"localvar":"my","kind":13,"line":582},{"line":583,"kind":13,"localvar":"my","name":"$l","definition":"my","containerName":null},{"containerName":null,"name":"@ls","kind":13,"line":583},{"localvar":"my","containerName":null,"name":"$cp","definition":"my","line":584,"kind":13},{"containerName":"Map::CytoPosition","name":"Bio","kind":12,"line":584},{"containerName":"main::","name":"new","line":584,"kind":12},{"kind":13,"line":584,"containerName":null,"name":"$l"},{"line":585,"kind":13,"name":"@cps","containerName":null},{"line":585,"kind":13,"name":"$cp","containerName":null},{"kind":13,"line":587,"name":"$omim_entry","containerName":null},{"line":587,"kind":12,"containerName":"main::","name":"add_CytoPositions"},{"containerName":null,"name":"@cps","line":587,"kind":13},{"containerName":null,"definition":"my","name":"$gene_symbols","localvar":"my","kind":13,"line":590},{"line":590,"kind":13,"containerName":null,"name":"@a"},{"line":591,"kind":13,"containerName":null,"name":"%gene_symbols"},{"line":592,"kind":13,"containerName":null,"name":"$gene_symbols"},{"containerName":null,"name":"@gss","definition":"my","localvar":"my","kind":13,"line":593},{"kind":13,"line":593,"name":"$gene_symbols","containerName":null},{"line":594,"kind":13,"name":"$omim_entry","containerName":null},{"name":"add_gene_symbols","containerName":"main::","kind":12,"line":594},{"containerName":null,"name":"@gss","kind":13,"line":594},{"line":597,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$mouse_correlates"},{"kind":13,"line":597,"containerName":null,"name":"@a"},{"name":"%mouse_correlates","containerName":null,"kind":13,"line":598},{"containerName":null,"name":"$mouse_correlates","line":599,"kind":13},{"definition":"my","name":"@mcs","containerName":null,"localvar":"my","kind":13,"line":600},{"name":"$mouse_correlates","containerName":null,"kind":13,"line":600},{"line":601,"kind":13,"localvar":"my","containerName":null,"name":"@cs","definition":"my"},{"kind":13,"line":602,"definition":"my","name":"$mc","containerName":null,"localvar":"my"},{"containerName":null,"name":"@mcs","kind":13,"line":602},{"containerName":null,"name":"$mouse","definition":"my","localvar":"my","kind":13,"line":603},{"line":603,"kind":12,"containerName":"Species","name":"Bio"},{"kind":12,"line":603,"containerName":"main::","name":"new"},{"containerName":null,"name":"$mouse","kind":13,"line":604},{"name":"classification","containerName":"main::","kind":12,"line":604},{"line":605,"kind":13,"containerName":null,"name":"$mouse"},{"line":605,"kind":12,"containerName":"main::","name":"common_name"},{"localvar":"my","definition":"my","name":"$c","containerName":null,"line":606,"kind":13},{"line":606,"kind":12,"name":"Bio","containerName":"Phenotype::Correlate"},{"line":606,"kind":12,"name":"new","containerName":"main::"},{"kind":13,"line":607,"containerName":null,"name":"$c"},{"kind":12,"line":607,"containerName":"main::","name":"name"},{"containerName":null,"name":"$mc","line":607,"kind":13},{"line":608,"kind":13,"name":"$c","containerName":null},{"name":"species","containerName":"main::","line":608,"kind":12},{"containerName":null,"name":"$mouse","line":608,"kind":13},{"kind":13,"line":609,"name":"$c","containerName":null},{"line":609,"kind":12,"containerName":"main::","name":"type"},{"kind":13,"line":611,"name":"@cs","containerName":null},{"kind":13,"line":611,"containerName":null,"name":"$c"},{"containerName":null,"name":"$omim_entry","line":613,"kind":13},{"name":"add_Correlates","containerName":"main::","line":613,"kind":12},{"kind":13,"line":613,"containerName":null,"name":"@cs"},{"containerName":null,"name":"$omim_entry","kind":13,"line":616},{"kind":12,"line":616,"name":"gene_status","containerName":"main::"},{"kind":13,"line":616,"name":"@a","containerName":null},{"kind":13,"line":616,"name":"@a","containerName":null},{"name":"$omim_entry","containerName":null,"kind":13,"line":617},{"line":617,"kind":12,"name":"mapping_method","containerName":"main::"},{"name":"@a","containerName":null,"kind":13,"line":617},{"containerName":null,"name":"@a","kind":13,"line":617},{"kind":13,"line":618,"name":"$omim_entry","containerName":null},{"kind":12,"line":618,"containerName":"main::","name":"comment"},{"kind":13,"line":618,"containerName":null,"name":"@a"},{"kind":13,"line":618,"name":"@a","containerName":null},{"line":625,"children":[{"kind":13,"line":626,"name":"$self","definition":"my","containerName":"_parse_allelic_variants","localvar":"my"},{"kind":13,"line":626,"containerName":"_parse_allelic_variants","name":"$text"},{"kind":13,"line":628,"name":"@allelic_variants","definition":"my","containerName":"_parse_allelic_variants","localvar":"my"},{"containerName":"_parse_allelic_variants","definition":"my","name":"$number","localvar":"my","kind":13,"line":629},{"localvar":"my","name":"$title","definition":"my","containerName":"_parse_allelic_variants","line":630,"kind":13},{"name":"$symbol_mut_line","definition":"my","containerName":"_parse_allelic_variants","localvar":"my","kind":13,"line":631},{"containerName":"_parse_allelic_variants","name":"$prev_line","definition":"my","localvar":"my","kind":13,"line":632},{"line":633,"kind":13,"localvar":"my","name":"$description","definition":"my","containerName":"_parse_allelic_variants"},{"definition":"my","name":"$saw_empty_line","containerName":"_parse_allelic_variants","localvar":"my","kind":13,"line":634},{"name":"@lines","definition":"my","containerName":"_parse_allelic_variants","localvar":"my","kind":13,"line":636},{"line":636,"kind":13,"name":"$text","containerName":"_parse_allelic_variants"},{"kind":13,"line":638,"containerName":"_parse_allelic_variants","definition":"my","name":"$line","localvar":"my"},{"kind":13,"line":638,"name":"@lines","containerName":"_parse_allelic_variants"},{"kind":13,"line":639,"containerName":"_parse_allelic_variants","name":"$line"},{"kind":13,"line":640,"name":"$saw_empty_line","containerName":"_parse_allelic_variants"},{"containerName":"_parse_allelic_variants","name":"$line","kind":13,"line":642},{"kind":13,"line":643,"definition":"my","name":"$current_number","containerName":"_parse_allelic_variants","localvar":"my"},{"line":644,"kind":13,"containerName":"_parse_allelic_variants","name":"$number"},{"kind":13,"line":645,"definition":"my","name":"$allelic_variant","containerName":"_parse_allelic_variants","localvar":"my"},{"line":645,"kind":13,"containerName":"_parse_allelic_variants","name":"$self"},{"line":645,"kind":12,"name":"_create_allelic_variant","containerName":"_parse_allelic_variants"},{"kind":13,"line":645,"name":"$number","containerName":"_parse_allelic_variants"},{"kind":13,"line":645,"name":"$title","containerName":"_parse_allelic_variants"},{"name":"$symbol_mut_line","containerName":"_parse_allelic_variants","kind":13,"line":646},{"kind":13,"line":646,"containerName":"_parse_allelic_variants","name":"$description"},{"containerName":"_parse_allelic_variants","name":"@allelic_variants","line":648,"kind":13},{"line":648,"kind":13,"containerName":"_parse_allelic_variants","name":"$allelic_variant"},{"containerName":"_parse_allelic_variants","name":"$number","line":650,"kind":13},{"name":"$current_number","containerName":"_parse_allelic_variants","kind":13,"line":650},{"kind":13,"line":651,"containerName":"_parse_allelic_variants","name":"$title"},{"containerName":"_parse_allelic_variants","name":"$prev_line","line":652,"kind":13},{"kind":13,"line":653,"name":"$symbol_mut_line","containerName":"_parse_allelic_variants"},{"name":"$description","containerName":"_parse_allelic_variants","kind":13,"line":654},{"containerName":"_parse_allelic_variants","name":"$saw_empty_line","kind":13,"line":655},{"kind":13,"line":657,"containerName":"_parse_allelic_variants","name":"$title"},{"kind":13,"line":658,"name":"$title","containerName":"_parse_allelic_variants"},{"containerName":"_parse_allelic_variants","name":"$line","line":658,"kind":13},{"containerName":"_parse_allelic_variants","name":"$saw_empty_line","line":660,"kind":13},{"kind":13,"line":661,"name":"$prev_line","containerName":"_parse_allelic_variants"},{"containerName":"_parse_allelic_variants","name":"$line","line":661,"kind":13},{"containerName":"_parse_allelic_variants","name":"$saw_empty_line","line":663,"kind":13},{"containerName":"_parse_allelic_variants","name":"$prev_line","line":664,"kind":13},{"name":"$symbol_mut_line","containerName":"_parse_allelic_variants","kind":13,"line":665},{"containerName":"_parse_allelic_variants","name":"$prev_line","line":665,"kind":13},{"name":"$prev_line","containerName":"_parse_allelic_variants","line":666,"kind":13},{"containerName":"_parse_allelic_variants","name":"$description","kind":13,"line":668},{"name":"$description","containerName":"_parse_allelic_variants","kind":13,"line":669},{"kind":13,"line":669,"containerName":"_parse_allelic_variants","name":"$line"},{"name":"$description","containerName":"_parse_allelic_variants","line":672,"kind":13},{"line":672,"kind":13,"containerName":"_parse_allelic_variants","name":"$line"},{"containerName":"_parse_allelic_variants","definition":"my","name":"$allelic_variant","localvar":"my","kind":13,"line":677},{"kind":13,"line":677,"containerName":"_parse_allelic_variants","name":"$self"},{"containerName":"_parse_allelic_variants","name":"_create_allelic_variant","line":677,"kind":12},{"line":677,"kind":13,"name":"$number","containerName":"_parse_allelic_variants"},{"containerName":"_parse_allelic_variants","name":"$title","kind":13,"line":677},{"line":678,"kind":13,"containerName":"_parse_allelic_variants","name":"$symbol_mut_line"},{"kind":13,"line":678,"containerName":"_parse_allelic_variants","name":"$description"},{"containerName":"_parse_allelic_variants","name":"@allelic_variants","kind":13,"line":680},{"name":"$allelic_variant","containerName":"_parse_allelic_variants","line":680,"kind":13},{"line":682,"kind":13,"name":"@allelic_variants","containerName":"_parse_allelic_variants"}],"kind":12,"detail":"($self,$text)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$text"}],"label":"_parse_allelic_variants($self,$text)"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":684},"start":{"character":0,"line":625}},"name":"_parse_allelic_variants"},{"name":"FALSE","kind":12,"line":634},{"kind":12,"line":640,"name":"TRUE"},{"line":655,"kind":12,"name":"FALSE"},{"name":"FALSE","line":660,"kind":12},{"name":"TRUE","kind":12,"line":663},{"detail":"($self,$number,$title,$symbol_mut_line,$description)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$number"},{"label":"$title"},{"label":"$symbol_mut_line"},{"label":"$description"}],"label":"_create_allelic_variant($self,$number,$title,$symbol_mut_line,$description)"},"containerName":"main::","definition":"sub","line":689,"children":[{"localvar":"my","containerName":"_create_allelic_variant","definition":"my","name":"$self","line":690,"kind":13},{"kind":13,"line":690,"containerName":"_create_allelic_variant","name":"$number"},{"kind":13,"line":690,"name":"$title","containerName":"_create_allelic_variant"},{"line":690,"kind":13,"containerName":"_create_allelic_variant","name":"$symbol_mut_line"},{"name":"$description","containerName":"_create_allelic_variant","line":690,"kind":13},{"containerName":"_create_allelic_variant","name":"$symbol","definition":"my","localvar":"my","kind":13,"line":692},{"localvar":"my","definition":"my","name":"$mutation","containerName":"_create_allelic_variant","line":693,"kind":13},{"containerName":"_create_allelic_variant","definition":"my","name":"$aa_ori","localvar":"my","kind":13,"line":694},{"line":695,"kind":13,"localvar":"my","definition":"my","name":"$aa_mut","containerName":"_create_allelic_variant"},{"containerName":"_create_allelic_variant","name":"$position","definition":"my","localvar":"my","kind":13,"line":696},{"line":698,"kind":13,"containerName":"_create_allelic_variant","name":"$symbol_mut_line"},{"containerName":"_create_allelic_variant","name":"$symbol","line":699,"kind":13},{"line":700,"kind":13,"containerName":"_create_allelic_variant","name":"$aa_ori"},{"kind":13,"line":701,"name":"$aa_mut","containerName":"_create_allelic_variant"},{"containerName":"_create_allelic_variant","name":"$position","line":702,"kind":13},{"containerName":"_create_allelic_variant","name":"$symbol_mut_line","kind":13,"line":704},{"kind":13,"line":705,"containerName":"_create_allelic_variant","name":"$symbol"},{"containerName":"_create_allelic_variant","name":"$mutation","kind":13,"line":706},{"name":"$symbol","containerName":"_create_allelic_variant","kind":13,"line":709},{"containerName":"_create_allelic_variant","name":"$symbol_mut_line","kind":13,"line":709},{"kind":13,"line":712,"name":"$description","containerName":"_create_allelic_variant"},{"name":"$self","containerName":"_create_allelic_variant","line":712,"kind":13},{"name":"throw","containerName":"_create_allelic_variant","kind":12,"line":712},{"containerName":"_create_allelic_variant","name":"$mutation","kind":13,"line":713},{"kind":13,"line":713,"containerName":"_create_allelic_variant","name":"$self"},{"name":"throw","containerName":"_create_allelic_variant","kind":12,"line":713},{"localvar":"my","containerName":"_create_allelic_variant","name":"$allelic_variant","definition":"my","line":716,"kind":13},{"containerName":"_create_allelic_variant","name":"new","line":716,"kind":12},{"name":"$allelic_variant","containerName":"_create_allelic_variant","line":717,"kind":13},{"name":"number","containerName":"_create_allelic_variant","line":717,"kind":12},{"line":717,"kind":13,"containerName":"_create_allelic_variant","name":"$number"},{"kind":13,"line":718,"name":"$allelic_variant","containerName":"_create_allelic_variant"},{"name":"aa_ori","containerName":"_create_allelic_variant","kind":12,"line":718},{"kind":13,"line":718,"name":"$aa_ori","containerName":"_create_allelic_variant"},{"containerName":"_create_allelic_variant","name":"$allelic_variant","line":719,"kind":13},{"containerName":"_create_allelic_variant","name":"aa_mut","kind":12,"line":719},{"line":719,"kind":13,"containerName":"_create_allelic_variant","name":"$aa_mut"},{"containerName":"_create_allelic_variant","name":"$allelic_variant","line":720,"kind":13},{"containerName":"_create_allelic_variant","name":"position","kind":12,"line":720},{"kind":13,"line":720,"name":"$position","containerName":"_create_allelic_variant"},{"line":721,"kind":13,"name":"$allelic_variant","containerName":"_create_allelic_variant"},{"containerName":"_create_allelic_variant","name":"title","line":721,"kind":12},{"line":721,"kind":13,"containerName":"_create_allelic_variant","name":"$title"},{"containerName":"_create_allelic_variant","name":"$allelic_variant","kind":13,"line":722},{"line":722,"kind":12,"containerName":"_create_allelic_variant","name":"symbol"},{"name":"$symbol","containerName":"_create_allelic_variant","kind":13,"line":722},{"line":723,"kind":13,"name":"$allelic_variant","containerName":"_create_allelic_variant"},{"kind":12,"line":723,"containerName":"_create_allelic_variant","name":"description"},{"containerName":"_create_allelic_variant","name":"$description","kind":13,"line":723},{"kind":13,"line":724,"name":"$allelic_variant","containerName":"_create_allelic_variant"},{"line":724,"kind":12,"name":"additional_mutations","containerName":"_create_allelic_variant"},{"name":"$mutation","containerName":"_create_allelic_variant","kind":13,"line":724},{"kind":13,"line":726,"name":"$allelic_variant","containerName":"_create_allelic_variant"}],"kind":12,"range":{"end":{"line":728,"character":9999},"start":{"line":689,"character":0}},"name":"_create_allelic_variant"},{"containerName":"Phenotype::OMIM::OMIMentryAllelicVariant","name":"Bio","kind":12,"line":716},{"line":733,"children":[{"containerName":"_parse_title","name":"$self","definition":"my","localvar":"my","kind":13,"line":734},{"containerName":"_parse_title","name":"$text","kind":13,"line":734},{"line":735,"kind":13,"localvar":"my","containerName":"_parse_title","definition":"my","name":"$title"},{"line":736,"kind":13,"containerName":"_parse_title","name":"$text"},{"containerName":"_parse_title","name":"$title","line":737,"kind":13},{"line":738,"kind":13,"name":"$text","containerName":"_parse_title"},{"containerName":"_parse_title","name":"$title","line":741,"kind":13},{"line":741,"kind":13,"containerName":"_parse_title","name":"$text"},{"line":742,"kind":13,"name":"$text","containerName":"_parse_title"},{"containerName":"_parse_title","name":"$title","kind":13,"line":746},{"line":746,"kind":13,"name":"$text","containerName":"_parse_title"}],"kind":12,"detail":"($self,$text)","signature":{"label":"_parse_title($self,$text)","documentation":"","parameters":[{"label":"$self"},{"label":"$text"}]},"containerName":"main::","definition":"sub","range":{"end":{"line":747,"character":9999},"start":{"line":733,"character":0}},"name":"_parse_title"},{"containerName":"main::","definition":"sub","detail":"($self,$text)","signature":{"label":"_parse_references($self,$text)","documentation":"","parameters":[{"label":"$self"},{"label":"$text"}]},"kind":12,"line":752,"children":[{"line":753,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_parse_references"},{"line":753,"kind":13,"containerName":"_parse_references","name":"$text"},{"kind":13,"line":755,"containerName":"_parse_references","name":"$text"},{"kind":13,"line":756,"containerName":"_parse_references","name":"$text"},{"kind":13,"line":757,"name":"$text","containerName":"_parse_references"},{"name":"@references","definition":"my","containerName":"_parse_references","localvar":"my","kind":13,"line":759},{"line":761,"kind":13,"localvar":"my","definition":"my","name":"@texts","containerName":"_parse_references"},{"kind":13,"line":761,"name":"$text","containerName":"_parse_references"},{"definition":"my","name":"$t","containerName":"_parse_references","localvar":"my","kind":13,"line":763},{"containerName":"_parse_references","name":"@texts","line":763,"kind":13},{"localvar":"my","name":"$authors","definition":"my","containerName":"_parse_references","line":765,"kind":13},{"name":"$title","definition":"my","containerName":"_parse_references","localvar":"my","kind":13,"line":766},{"kind":13,"line":767,"containerName":"_parse_references","definition":"my","name":"$location","localvar":"my"},{"containerName":"_parse_references","name":"$t","line":769,"kind":13},{"containerName":"_parse_references","name":"$t","line":771,"kind":13},{"line":772,"kind":13,"name":"$authors","containerName":"_parse_references"},{"kind":13,"line":773,"name":"$title","containerName":"_parse_references"},{"kind":13,"line":774,"containerName":"_parse_references","definition":"my","name":"$journal","localvar":"my"},{"line":775,"kind":13,"localvar":"my","containerName":"_parse_references","definition":"my","name":"$volume"},{"kind":13,"line":776,"name":"$fromto","definition":"my","containerName":"_parse_references","localvar":"my"},{"name":"$year","definition":"my","containerName":"_parse_references","localvar":"my","kind":13,"line":777},{"line":778,"kind":13,"localvar":"my","name":"$from","definition":"my","containerName":"_parse_references"},{"kind":13,"line":779,"containerName":"_parse_references","definition":"my","name":"$to","localvar":"my"},{"kind":13,"line":780,"containerName":"_parse_references","name":"$fromto"},{"containerName":"_parse_references","name":"$from","kind":13,"line":781},{"kind":13,"line":782,"containerName":"_parse_references","name":"$to"},{"line":784,"kind":13,"name":"$fromto","containerName":"_parse_references"},{"name":"$from","containerName":"_parse_references","line":785,"kind":13},{"containerName":"_parse_references","name":"$location","kind":13,"line":787},{"kind":13,"line":787,"name":"$journal","containerName":"_parse_references"},{"line":787,"kind":13,"containerName":"_parse_references","name":"$volume"},{"line":787,"kind":13,"name":"$from","containerName":"_parse_references"},{"containerName":"_parse_references","name":"$to","line":787,"kind":13},{"kind":13,"line":787,"containerName":"_parse_references","name":"$year"},{"line":791,"kind":13,"name":"$t","containerName":"_parse_references"},{"line":792,"kind":13,"containerName":"_parse_references","name":"$authors"},{"name":"$title","containerName":"_parse_references","line":793,"kind":13},{"kind":13,"line":794,"containerName":"_parse_references","name":"$location"},{"kind":13,"line":797,"containerName":"_parse_references","name":"$title"},{"name":"$t","containerName":"_parse_references","kind":13,"line":797},{"line":800,"kind":13,"localvar":"my","containerName":"_parse_references","definition":"my","name":"$ref"},{"name":"new","containerName":"_parse_references","kind":12,"line":800},{"line":800,"kind":13,"name":"$title","containerName":"_parse_references"},{"containerName":"_parse_references","name":"$location","line":801,"kind":13},{"line":802,"kind":13,"name":"$authors","containerName":"_parse_references"},{"containerName":"_parse_references","name":"@references","line":803,"kind":13},{"line":803,"kind":13,"containerName":"_parse_references","name":"$ref"},{"kind":13,"line":806,"name":"@references","containerName":"_parse_references"}],"name":"_parse_references","range":{"end":{"line":808,"character":9999},"start":{"line":752,"character":0}}},{"name":"Bio","containerName":"Annotation::Reference","kind":12,"line":800},{"definition":"sub","containerName":"main::","signature":{"label":"_genemap_hash($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":""},"detail":"($self,$value)","kind":12,"children":[{"kind":13,"line":814,"containerName":"_genemap_hash","name":"$self","definition":"my","localvar":"my"},{"line":814,"kind":13,"name":"$value","containerName":"_genemap_hash"},{"kind":13,"line":816,"containerName":"_genemap_hash","name":"$value"},{"line":817,"kind":13,"name":"$value","containerName":"_genemap_hash"},{"kind":13,"line":818,"containerName":"_genemap_hash","name":"$self"},{"line":818,"kind":12,"name":"throw","containerName":"_genemap_hash"},{"name":"$self","containerName":"_genemap_hash","kind":13,"line":820},{"name":"$value","containerName":"_genemap_hash","line":820,"kind":13},{"kind":13,"line":824,"name":"$self","containerName":"_genemap_hash"}],"line":813,"name":"_genemap_hash","range":{"start":{"line":813,"character":0},"end":{"line":825,"character":9999}}},{"name":"_is_not_first_record","range":{"start":{"line":830,"character":0},"end":{"line":843,"character":9999}},"kind":12,"children":[{"kind":13,"line":832,"name":"$self","definition":"my","containerName":"_is_not_first_record","localvar":"my"},{"containerName":"_is_not_first_record","name":"$value","kind":13,"line":832},{"containerName":"_is_not_first_record","name":"$value","kind":13,"line":834},{"name":"$value","containerName":"_is_not_first_record","line":835,"kind":13},{"containerName":"_is_not_first_record","name":"$value","kind":13,"line":835},{"line":836,"kind":13,"containerName":"_is_not_first_record","name":"$self"},{"line":836,"kind":12,"name":"throw","containerName":"_is_not_first_record"},{"line":839,"kind":13,"name":"$self","containerName":"_is_not_first_record"},{"line":839,"kind":13,"name":"$value","containerName":"_is_not_first_record"},{"containerName":"_is_not_first_record","name":"$self","line":842,"kind":13}],"line":830,"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$value"}],"label":"_is_not_first_record($self,$value)"},"detail":"($self,$value)"},{"name":"FALSE","kind":12,"line":835},{"name":"TRUE","line":835,"kind":12},{"kind":12,"line":837,"name":"TRUE"},{"line":837,"kind":12,"name":"FALSE"},{"detail":"($self,$value)","signature":{"label":"_done($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":""},"containerName":"main::","definition":"sub","line":848,"children":[{"containerName":"_done","definition":"my","name":"$self","localvar":"my","kind":13,"line":849},{"line":849,"kind":13,"name":"$value","containerName":"_done"},{"line":851,"kind":13,"containerName":"_done","name":"$value"},{"containerName":"_done","name":"$value","kind":13,"line":852},{"name":"$value","containerName":"_done","line":852,"kind":13},{"kind":13,"line":853,"containerName":"_done","name":"$self"},{"kind":12,"line":853,"name":"throw","containerName":"_done"},{"kind":13,"line":856,"containerName":"_done","name":"$self"},{"name":"$value","containerName":"_done","line":856,"kind":13},{"kind":13,"line":859,"name":"$self","containerName":"_done"}],"kind":12,"range":{"end":{"line":860,"character":9999},"start":{"character":0,"line":848}},"name":"_done"},{"name":"FALSE","kind":12,"line":852},{"name":"TRUE","kind":12,"line":852},{"name":"TRUE","kind":12,"line":854},{"name":"FALSE","line":854,"kind":12},{"kind":12,"line":865,"children":[{"name":"$self","definition":"my","containerName":"_OMIM_text_file","localvar":"my","kind":13,"line":866},{"kind":13,"line":866,"containerName":"_OMIM_text_file","name":"$value"},{"kind":13,"line":868,"containerName":"_OMIM_text_file","name":"$value"},{"kind":13,"line":869,"name":"$value","containerName":"_OMIM_text_file"},{"containerName":"_OMIM_text_file","name":"isa","line":869,"kind":12},{"containerName":"_OMIM_text_file","name":"$self","line":870,"kind":13},{"kind":12,"line":870,"containerName":"_OMIM_text_file","name":"throw"},{"name":"$self","containerName":"_OMIM_text_file","line":872,"kind":13},{"kind":13,"line":872,"containerName":"_OMIM_text_file","name":"$value"},{"name":"$self","containerName":"_OMIM_text_file","line":876,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"","label":"_OMIM_text_file($self,$value)"},"name":"_OMIM_text_file","range":{"start":{"line":865,"character":0},"end":{"character":9999,"line":877}}},{"range":{"end":{"line":903,"character":9999},"start":{"line":882,"character":0}},"name":"_read_genemap","children":[{"kind":13,"line":883,"containerName":"_read_genemap","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":883,"containerName":"_read_genemap","name":"$genemap_file_name"},{"line":885,"kind":13,"localvar":"my","containerName":"_read_genemap","name":"$line","definition":"my"},{"kind":13,"line":886,"name":"%genemap_hash","definition":"my","containerName":"_read_genemap","localvar":"my"},{"line":887,"kind":13,"localvar":"my","containerName":"_read_genemap","name":"$genemap_file","definition":"my"},{"containerName":"_read_genemap","name":"new","kind":12,"line":887},{"containerName":"_read_genemap","name":"$genemap_file_name","kind":13,"line":887},{"line":888,"kind":13,"localvar":"my","definition":"my","name":"@a","containerName":"_read_genemap"},{"line":889,"kind":13,"localvar":"my","name":"%gm","definition":"my","containerName":"_read_genemap"},{"name":"$line","containerName":"_read_genemap","kind":13,"line":891},{"name":"$genemap_file","containerName":"_read_genemap","kind":13,"line":891},{"line":891,"kind":12,"containerName":"_read_genemap","name":"_readline"},{"name":"@a","containerName":"_read_genemap","line":892,"kind":13},{"containerName":"_read_genemap","name":"$line","line":892,"kind":13},{"name":"@a","containerName":"_read_genemap","line":893,"kind":13},{"name":"$self","containerName":"_read_genemap","kind":13,"line":894},{"kind":12,"line":894,"containerName":"_read_genemap","name":"throw"},{"name":"$self","containerName":"_read_genemap","line":894,"kind":13},{"kind":12,"line":894,"containerName":"_read_genemap","name":"genemap_file_name"},{"line":898,"kind":13,"name":"$gm","containerName":"_read_genemap"},{"containerName":"_read_genemap","name":"$a","line":898,"kind":13},{"kind":13,"line":898,"name":"$line","containerName":"_read_genemap"},{"kind":13,"line":900,"containerName":"_read_genemap","name":"$genemap_file"},{"kind":12,"line":900,"name":"close","containerName":"_read_genemap"},{"kind":13,"line":901,"containerName":"_read_genemap","name":"$self"},{"kind":12,"line":901,"name":"_genemap_hash","containerName":"_read_genemap"},{"kind":13,"line":901,"containerName":"_read_genemap","name":"%gm"}],"line":882,"kind":12,"signature":{"label":"_read_genemap($self,$genemap_file_name)","parameters":[{"label":"$self"},{"label":"$genemap_file_name"}],"documentation":""},"detail":"($self,$genemap_file_name)","definition":"sub","containerName":"main::"},{"name":"Bio","containerName":"Root::IO","kind":12,"line":887},{"name":"_no_OMIM_text_file_provided_error","range":{"end":{"character":9999,"line":915},"start":{"character":0,"line":908}},"kind":12,"children":[{"kind":13,"line":909,"name":"$self","definition":"my","containerName":"_no_OMIM_text_file_provided_error","localvar":"my"},{"line":911,"kind":13,"localvar":"my","containerName":"_no_OMIM_text_file_provided_error","name":"$msg","definition":"my"},{"kind":13,"line":912,"containerName":"_no_OMIM_text_file_provided_error","name":"$msg"},{"name":"$msg","containerName":"_no_OMIM_text_file_provided_error","kind":13,"line":913},{"line":914,"kind":13,"containerName":"_no_OMIM_text_file_provided_error","name":"$self"},{"kind":12,"line":914,"containerName":"_no_OMIM_text_file_provided_error","name":"throw"},{"line":914,"kind":13,"name":"$msg","containerName":"_no_OMIM_text_file_provided_error"}],"line":908,"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"_no_OMIM_text_file_provided_error($self)"},"detail":"($self)"},{"name":"_not_a_OMIM_text_file_error","range":{"start":{"character":0,"line":920},"end":{"character":9999,"line":926}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"_not_a_OMIM_text_file_error($self)"},"detail":"($self)","kind":12,"children":[{"containerName":"_not_a_OMIM_text_file_error","definition":"my","name":"$self","localvar":"my","kind":13,"line":921},{"localvar":"my","containerName":"_not_a_OMIM_text_file_error","definition":"my","name":"$msg","line":923,"kind":13},{"containerName":"_not_a_OMIM_text_file_error","name":"$self","line":923,"kind":13},{"containerName":"_not_a_OMIM_text_file_error","name":"omimtxt_file_name","line":923,"kind":12},{"name":"$self","containerName":"_not_a_OMIM_text_file_error","kind":13,"line":925},{"line":925,"kind":12,"name":"throw","containerName":"_not_a_OMIM_text_file_error"},{"containerName":"_not_a_OMIM_text_file_error","name":"$msg","kind":13,"line":925}],"line":920},{"range":{"end":{"character":9999,"line":941},"start":{"line":931,"character":0}},"name":"_add_to_hash","signature":{"label":"_add_to_hash($self,$state,$contents,$record_ref)","parameters":[{"label":"$self"},{"label":"$state"},{"label":"$contents"},{"label":"$record_ref"}],"documentation":""},"detail":"($self,$state,$contents,$record_ref)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":932,"name":"$self","definition":"my","containerName":"_add_to_hash","localvar":"my"},{"name":"$state","containerName":"_add_to_hash","line":932,"kind":13},{"containerName":"_add_to_hash","name":"$contents","line":932,"kind":13},{"containerName":"_add_to_hash","name":"$record_ref","kind":13,"line":932},{"containerName":"_add_to_hash","name":"$record_ref","kind":13,"line":934},{"kind":13,"line":934,"name":"$state","containerName":"_add_to_hash"},{"line":935,"kind":13,"name":"$record_ref","containerName":"_add_to_hash"},{"line":935,"kind":13,"containerName":"_add_to_hash","name":"$state"},{"kind":13,"line":936,"containerName":"_add_to_hash","name":"$record_ref"},{"containerName":"_add_to_hash","name":"$state","kind":13,"line":936},{"containerName":"_add_to_hash","name":"$record_ref","kind":13,"line":936},{"name":"$state","containerName":"_add_to_hash","line":936,"kind":13},{"kind":13,"line":936,"containerName":"_add_to_hash","name":"$contents"},{"kind":13,"line":939,"name":"$record_ref","containerName":"_add_to_hash"},{"name":"$state","containerName":"_add_to_hash","line":939,"kind":13},{"containerName":"_add_to_hash","name":"$contents","kind":13,"line":939}],"line":931,"kind":12}]}