{"version":5,"vars":[{"kind":2,"line":109,"containerName":"","name":"base"},{"range":{"end":{"character":9999,"line":156},"start":{"line":132,"character":0}},"name":"new","signature":{"documentation":"1;\n# $Id: Measure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Measure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Measure - Representation of context/value(-range)/unit triplets\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Measure;\n\n  my $measure = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                              -description => \"reduced length in 4(Tas1r3)\",\n                                              -start       => 0,\n                                              -end         => 15,\n                                              -unit        => \"mm\",\n                                              -comment     => \"see also Miller et al\" );\n\n  print $measure->context();\n  print $measure->description();\n  print $measure->start();\n  print $measure->end();\n  print $measure->unit();\n  print $measure->comment();\n\n  print $measure->to_string();\n\n=head1 DESCRIPTION\n\nMeasure is for biochemically defined phenotypes or any other types of measures.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Measure;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $me = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                                  -description => \"reduced length in 4(Tas1r3)\",\n                                                  -start       => 0,\n                                                  -end         => 15,\n                                                  -unit        => \"mm\",\n                                                  -comment     => \"see Miller also et al\" );                      \n Function: Creates a new Measure object.\n Returns : A new Measure object.\n Args    : -context     => the context\n           -description => a description\n           -start       => the start value\n           -end         => the end value\n           -unit        => the unit\n           -comment     => a comment","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"localvar":"my","name":"$class","definition":"my","containerName":"new","line":133,"kind":13},{"line":133,"kind":13,"name":"@args","containerName":"new"},{"kind":13,"line":135,"definition":"my","name":"$self","containerName":"new","localvar":"my"},{"kind":13,"line":135,"containerName":"new","name":"$class"},{"name":"@args","containerName":"new","line":135,"kind":13},{"kind":13,"line":137,"definition":"my","name":"$con","containerName":"new","localvar":"my"},{"kind":13,"line":137,"name":"$desc","containerName":"new"},{"line":137,"kind":13,"containerName":"new","name":"$start"},{"containerName":"new","name":"$end","line":137,"kind":13},{"kind":13,"line":137,"containerName":"new","name":"$unit"},{"containerName":"new","name":"$comment","kind":13,"line":137},{"kind":13,"line":138,"name":"$self","containerName":"new"},{"line":138,"kind":12,"name":"_rearrange","containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":143},{"kind":13,"line":145,"name":"$self","containerName":"new"},{"name":"init","containerName":"new","line":145,"kind":12},{"kind":13,"line":147,"containerName":"new","name":"$con"},{"name":"$self","containerName":"new","line":147,"kind":13},{"line":147,"kind":12,"containerName":"new","name":"context"},{"kind":13,"line":147,"containerName":"new","name":"$con"},{"containerName":"new","name":"$desc","line":148,"kind":13},{"kind":13,"line":148,"containerName":"new","name":"$self"},{"line":148,"kind":12,"name":"description","containerName":"new"},{"kind":13,"line":148,"name":"$desc","containerName":"new"},{"line":149,"kind":13,"name":"$start","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":149},{"name":"start","containerName":"new","line":149,"kind":12},{"name":"$start","containerName":"new","line":149,"kind":13},{"containerName":"new","name":"$end","line":150,"kind":13},{"name":"$self","containerName":"new","line":150,"kind":13},{"containerName":"new","name":"end","kind":12,"line":150},{"line":150,"kind":13,"containerName":"new","name":"$end"},{"kind":13,"line":151,"containerName":"new","name":"$unit"},{"line":151,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":151,"containerName":"new","name":"unit"},{"kind":13,"line":151,"name":"$unit","containerName":"new"},{"containerName":"new","name":"$comment","line":152,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":152},{"kind":12,"line":152,"containerName":"new","name":"comment"},{"kind":13,"line":152,"name":"$comment","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":154}],"line":132,"kind":12},{"kind":12,"line":135,"containerName":"new","name":"SUPER"},{"range":{"end":{"character":9999,"line":181},"start":{"line":171,"character":0}},"name":"init","signature":{"label":"init($self)","documentation":"1;\n# $Id: Measure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Measure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Measure - Representation of context/value(-range)/unit triplets\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Measure;\n\n  my $measure = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                              -description => \"reduced length in 4(Tas1r3)\",\n                                              -start       => 0,\n                                              -end         => 15,\n                                              -unit        => \"mm\",\n                                              -comment     => \"see also Miller et al\" );\n\n  print $measure->context();\n  print $measure->description();\n  print $measure->start();\n  print $measure->end();\n  print $measure->unit();\n  print $measure->comment();\n\n  print $measure->to_string();\n\n=head1 DESCRIPTION\n\nMeasure is for biochemically defined phenotypes or any other types of measures.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Measure;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $me = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                                  -description => \"reduced length in 4(Tas1r3)\",\n                                                  -start       => 0,\n                                                  -end         => 15,\n                                                  -unit        => \"mm\",\n                                                  -comment     => \"see Miller also et al\" );                      \n Function: Creates a new Measure object.\n Returns : A new Measure object.\n Args    : -context     => the context\n           -description => a description\n           -start       => the start value\n           -end         => the end value\n           -unit        => the unit\n           -comment     => a comment\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $con, $desc, $start, $end, $unit, $comment )\n    = $self->_rearrange( [ qw( CONTEXT\n                               DESCRIPTION\n                               START\n                               END\n                               UNIT\n                               COMMENT ) ], @args );\n\n    $self->init(); \n \n    $con     && $self->context( $con );\n    $desc    && $self->description( $desc );\n    $start   && $self->start( $start );\n    $end     && $self->end( $end );\n    $unit    && $self->unit( $unit );\n    $comment && $self->comment( $comment );\n                           \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $measure->init();   \n Function: Initializes this Measure to all \"\".\n Returns : \n Args    :","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":172,"containerName":"init","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":174,"containerName":"init","name":"$self"},{"containerName":"init","name":"context","kind":12,"line":174},{"name":"$self","containerName":"init","line":175,"kind":13},{"kind":12,"line":175,"name":"description","containerName":"init"},{"containerName":"init","name":"$self","line":176,"kind":13},{"kind":12,"line":176,"containerName":"init","name":"start"},{"line":177,"kind":13,"name":"$self","containerName":"init"},{"kind":12,"line":177,"containerName":"init","name":"end"},{"kind":13,"line":178,"containerName":"init","name":"$self"},{"line":178,"kind":12,"name":"unit","containerName":"init"},{"line":179,"kind":13,"containerName":"init","name":"$self"},{"name":"comment","containerName":"init","kind":12,"line":179}],"line":171,"kind":12},{"range":{"end":{"character":9999,"line":207},"start":{"character":0,"line":198}},"name":"context","children":[{"line":199,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"context"},{"containerName":"context","name":"$value","line":199,"kind":13},{"containerName":"context","name":"$value","line":201,"kind":13},{"containerName":"context","name":"$self","kind":13,"line":202},{"line":202,"kind":13,"containerName":"context","name":"$value"},{"name":"$self","containerName":"context","line":205,"kind":13}],"line":198,"kind":12,"signature":{"documentation":"1;\n# $Id: Measure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Measure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Measure - Representation of context/value(-range)/unit triplets\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Measure;\n\n  my $measure = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                              -description => \"reduced length in 4(Tas1r3)\",\n                                              -start       => 0,\n                                              -end         => 15,\n                                              -unit        => \"mm\",\n                                              -comment     => \"see also Miller et al\" );\n\n  print $measure->context();\n  print $measure->description();\n  print $measure->start();\n  print $measure->end();\n  print $measure->unit();\n  print $measure->comment();\n\n  print $measure->to_string();\n\n=head1 DESCRIPTION\n\nMeasure is for biochemically defined phenotypes or any other types of measures.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Measure;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $me = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                                  -description => \"reduced length in 4(Tas1r3)\",\n                                                  -start       => 0,\n                                                  -end         => 15,\n                                                  -unit        => \"mm\",\n                                                  -comment     => \"see Miller also et al\" );                      \n Function: Creates a new Measure object.\n Returns : A new Measure object.\n Args    : -context     => the context\n           -description => a description\n           -start       => the start value\n           -end         => the end value\n           -unit        => the unit\n           -comment     => a comment\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $con, $desc, $start, $end, $unit, $comment )\n    = $self->_rearrange( [ qw( CONTEXT\n                               DESCRIPTION\n                               START\n                               END\n                               UNIT\n                               COMMENT ) ], @args );\n\n    $self->init(); \n \n    $con     && $self->context( $con );\n    $desc    && $self->description( $desc );\n    $start   && $self->start( $start );\n    $end     && $self->end( $end );\n    $unit    && $self->unit( $unit );\n    $comment && $self->comment( $comment );\n                           \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $measure->init();   \n Function: Initializes this Measure to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->context( \"\" );\n    $self->description( \"\" );\n    $self->start( \"\" );\n    $self->end( \"\" );\n    $self->unit( \"\" );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n\n=head2 context\n\n Title   : context\n Usage   : $measure->context( \"Ca-conc\" );\n           or \n           print $measure->context(); \n Function: Set/get for the context of this Measure.\n Returns : The context.\n Args    : The context (optional).","parameters":[{"label":"$self"},{"label":"$value"}],"label":"context($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"name":"description","range":{"start":{"line":224,"character":0},"end":{"line":233,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Measure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Measure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Measure - Representation of context/value(-range)/unit triplets\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Measure;\n\n  my $measure = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                              -description => \"reduced length in 4(Tas1r3)\",\n                                              -start       => 0,\n                                              -end         => 15,\n                                              -unit        => \"mm\",\n                                              -comment     => \"see also Miller et al\" );\n\n  print $measure->context();\n  print $measure->description();\n  print $measure->start();\n  print $measure->end();\n  print $measure->unit();\n  print $measure->comment();\n\n  print $measure->to_string();\n\n=head1 DESCRIPTION\n\nMeasure is for biochemically defined phenotypes or any other types of measures.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Measure;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $me = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                                  -description => \"reduced length in 4(Tas1r3)\",\n                                                  -start       => 0,\n                                                  -end         => 15,\n                                                  -unit        => \"mm\",\n                                                  -comment     => \"see Miller also et al\" );                      \n Function: Creates a new Measure object.\n Returns : A new Measure object.\n Args    : -context     => the context\n           -description => a description\n           -start       => the start value\n           -end         => the end value\n           -unit        => the unit\n           -comment     => a comment\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $con, $desc, $start, $end, $unit, $comment )\n    = $self->_rearrange( [ qw( CONTEXT\n                               DESCRIPTION\n                               START\n                               END\n                               UNIT\n                               COMMENT ) ], @args );\n\n    $self->init(); \n \n    $con     && $self->context( $con );\n    $desc    && $self->description( $desc );\n    $start   && $self->start( $start );\n    $end     && $self->end( $end );\n    $unit    && $self->unit( $unit );\n    $comment && $self->comment( $comment );\n                           \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $measure->init();   \n Function: Initializes this Measure to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->context( \"\" );\n    $self->description( \"\" );\n    $self->start( \"\" );\n    $self->end( \"\" );\n    $self->unit( \"\" );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n\n=head2 context\n\n Title   : context\n Usage   : $measure->context( \"Ca-conc\" );\n           or \n           print $measure->context(); \n Function: Set/get for the context of this Measure.\n Returns : The context.\n Args    : The context (optional).\n\n\nsub context {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_context\" } = $value;\n    }\n   \n    return $self->{ \"_context\" };\n    \n} # context\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $measure->description( \"reduced in 4(Tas1r3)\" );\n           or \n           print $measure->description(); \n Function: Set/get for the description of this Measure.\n Returns : A description.\n Args    : A description (optional).","label":"description($self,$value)"},"kind":12,"line":224,"children":[{"localvar":"my","containerName":"description","definition":"my","name":"$self","line":225,"kind":13},{"name":"$value","containerName":"description","line":225,"kind":13},{"name":"$value","containerName":"description","line":227,"kind":13},{"containerName":"description","name":"$self","line":228,"kind":13},{"containerName":"description","name":"$value","kind":13,"line":228},{"line":231,"kind":13,"name":"$self","containerName":"description"}]},{"range":{"start":{"line":250,"character":0},"end":{"line":259,"character":9999}},"name":"start","line":250,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"start","line":251,"kind":13},{"line":251,"kind":13,"name":"$value","containerName":"start"},{"kind":13,"line":253,"name":"$value","containerName":"start"},{"name":"$self","containerName":"start","line":254,"kind":13},{"line":254,"kind":13,"name":"$value","containerName":"start"},{"name":"$self","containerName":"start","line":257,"kind":13}],"kind":12,"detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: Measure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Measure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Measure - Representation of context/value(-range)/unit triplets\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Measure;\n\n  my $measure = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                              -description => \"reduced length in 4(Tas1r3)\",\n                                              -start       => 0,\n                                              -end         => 15,\n                                              -unit        => \"mm\",\n                                              -comment     => \"see also Miller et al\" );\n\n  print $measure->context();\n  print $measure->description();\n  print $measure->start();\n  print $measure->end();\n  print $measure->unit();\n  print $measure->comment();\n\n  print $measure->to_string();\n\n=head1 DESCRIPTION\n\nMeasure is for biochemically defined phenotypes or any other types of measures.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Measure;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $me = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                                  -description => \"reduced length in 4(Tas1r3)\",\n                                                  -start       => 0,\n                                                  -end         => 15,\n                                                  -unit        => \"mm\",\n                                                  -comment     => \"see Miller also et al\" );                      \n Function: Creates a new Measure object.\n Returns : A new Measure object.\n Args    : -context     => the context\n           -description => a description\n           -start       => the start value\n           -end         => the end value\n           -unit        => the unit\n           -comment     => a comment\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $con, $desc, $start, $end, $unit, $comment )\n    = $self->_rearrange( [ qw( CONTEXT\n                               DESCRIPTION\n                               START\n                               END\n                               UNIT\n                               COMMENT ) ], @args );\n\n    $self->init(); \n \n    $con     && $self->context( $con );\n    $desc    && $self->description( $desc );\n    $start   && $self->start( $start );\n    $end     && $self->end( $end );\n    $unit    && $self->unit( $unit );\n    $comment && $self->comment( $comment );\n                           \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $measure->init();   \n Function: Initializes this Measure to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->context( \"\" );\n    $self->description( \"\" );\n    $self->start( \"\" );\n    $self->end( \"\" );\n    $self->unit( \"\" );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n\n=head2 context\n\n Title   : context\n Usage   : $measure->context( \"Ca-conc\" );\n           or \n           print $measure->context(); \n Function: Set/get for the context of this Measure.\n Returns : The context.\n Args    : The context (optional).\n\n\nsub context {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_context\" } = $value;\n    }\n   \n    return $self->{ \"_context\" };\n    \n} # context\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $measure->description( \"reduced in 4(Tas1r3)\" );\n           or \n           print $measure->description(); \n Function: Set/get for the description of this Measure.\n Returns : A description.\n Args    : A description (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n   \n    return $self->{ \"_description\" };\n    \n} # description\n\n\n\n\n=head2 start \n\n Title   : start\n Usage   : $measure->start( 330 );\n           or \n           print $measure->start(); \n Function: Set/get for the start value of this Measure.\n Returns : The start value.\n Args    : The start value (optional).","parameters":[{"label":"$self"},{"label":"$value"}],"label":"start($self,$value)"},"containerName":"main::","definition":"sub"},{"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: Measure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Measure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Measure - Representation of context/value(-range)/unit triplets\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Measure;\n\n  my $measure = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                              -description => \"reduced length in 4(Tas1r3)\",\n                                              -start       => 0,\n                                              -end         => 15,\n                                              -unit        => \"mm\",\n                                              -comment     => \"see also Miller et al\" );\n\n  print $measure->context();\n  print $measure->description();\n  print $measure->start();\n  print $measure->end();\n  print $measure->unit();\n  print $measure->comment();\n\n  print $measure->to_string();\n\n=head1 DESCRIPTION\n\nMeasure is for biochemically defined phenotypes or any other types of measures.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Measure;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $me = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                                  -description => \"reduced length in 4(Tas1r3)\",\n                                                  -start       => 0,\n                                                  -end         => 15,\n                                                  -unit        => \"mm\",\n                                                  -comment     => \"see Miller also et al\" );                      \n Function: Creates a new Measure object.\n Returns : A new Measure object.\n Args    : -context     => the context\n           -description => a description\n           -start       => the start value\n           -end         => the end value\n           -unit        => the unit\n           -comment     => a comment\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $con, $desc, $start, $end, $unit, $comment )\n    = $self->_rearrange( [ qw( CONTEXT\n                               DESCRIPTION\n                               START\n                               END\n                               UNIT\n                               COMMENT ) ], @args );\n\n    $self->init(); \n \n    $con     && $self->context( $con );\n    $desc    && $self->description( $desc );\n    $start   && $self->start( $start );\n    $end     && $self->end( $end );\n    $unit    && $self->unit( $unit );\n    $comment && $self->comment( $comment );\n                           \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $measure->init();   \n Function: Initializes this Measure to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->context( \"\" );\n    $self->description( \"\" );\n    $self->start( \"\" );\n    $self->end( \"\" );\n    $self->unit( \"\" );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n\n=head2 context\n\n Title   : context\n Usage   : $measure->context( \"Ca-conc\" );\n           or \n           print $measure->context(); \n Function: Set/get for the context of this Measure.\n Returns : The context.\n Args    : The context (optional).\n\n\nsub context {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_context\" } = $value;\n    }\n   \n    return $self->{ \"_context\" };\n    \n} # context\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $measure->description( \"reduced in 4(Tas1r3)\" );\n           or \n           print $measure->description(); \n Function: Set/get for the description of this Measure.\n Returns : A description.\n Args    : A description (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n   \n    return $self->{ \"_description\" };\n    \n} # description\n\n\n\n\n=head2 start \n\n Title   : start\n Usage   : $measure->start( 330 );\n           or \n           print $measure->start(); \n Function: Set/get for the start value of this Measure.\n Returns : The start value.\n Args    : The start value (optional).\n\n\nsub start {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_start\" } = $value;\n    }\n   \n    return $self->{ \"_start\" };\n    \n} #  start\n\n\n\n\n=head2 end \n\n Title   : end \n Usage   : $measure->end( 459 );\n           or \n           print $measure->end(); \n Function: Set/get for the end value of this Measure.\n Returns : The end value.\n Args    : The end value (optional).","parameters":[{"label":"$self"},{"label":"$value"}],"label":"end($self,$value)"},"detail":"($self,$value)","kind":12,"children":[{"localvar":"my","containerName":"end","definition":"my","name":"$self","line":277,"kind":13},{"kind":13,"line":277,"containerName":"end","name":"$value"},{"name":"$value","containerName":"end","kind":13,"line":279},{"name":"$self","containerName":"end","line":280,"kind":13},{"name":"$value","containerName":"end","line":280,"kind":13},{"line":283,"kind":13,"name":"$self","containerName":"end"}],"line":276,"name":"end","range":{"start":{"character":0,"line":276},"end":{"line":285,"character":9999}}},{"name":"unit","range":{"end":{"character":9999,"line":311},"start":{"character":0,"line":302}},"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Measure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Measure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Measure - Representation of context/value(-range)/unit triplets\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Measure;\n\n  my $measure = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                              -description => \"reduced length in 4(Tas1r3)\",\n                                              -start       => 0,\n                                              -end         => 15,\n                                              -unit        => \"mm\",\n                                              -comment     => \"see also Miller et al\" );\n\n  print $measure->context();\n  print $measure->description();\n  print $measure->start();\n  print $measure->end();\n  print $measure->unit();\n  print $measure->comment();\n\n  print $measure->to_string();\n\n=head1 DESCRIPTION\n\nMeasure is for biochemically defined phenotypes or any other types of measures.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Measure;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $me = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                                  -description => \"reduced length in 4(Tas1r3)\",\n                                                  -start       => 0,\n                                                  -end         => 15,\n                                                  -unit        => \"mm\",\n                                                  -comment     => \"see Miller also et al\" );                      \n Function: Creates a new Measure object.\n Returns : A new Measure object.\n Args    : -context     => the context\n           -description => a description\n           -start       => the start value\n           -end         => the end value\n           -unit        => the unit\n           -comment     => a comment\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $con, $desc, $start, $end, $unit, $comment )\n    = $self->_rearrange( [ qw( CONTEXT\n                               DESCRIPTION\n                               START\n                               END\n                               UNIT\n                               COMMENT ) ], @args );\n\n    $self->init(); \n \n    $con     && $self->context( $con );\n    $desc    && $self->description( $desc );\n    $start   && $self->start( $start );\n    $end     && $self->end( $end );\n    $unit    && $self->unit( $unit );\n    $comment && $self->comment( $comment );\n                           \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $measure->init();   \n Function: Initializes this Measure to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->context( \"\" );\n    $self->description( \"\" );\n    $self->start( \"\" );\n    $self->end( \"\" );\n    $self->unit( \"\" );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n\n=head2 context\n\n Title   : context\n Usage   : $measure->context( \"Ca-conc\" );\n           or \n           print $measure->context(); \n Function: Set/get for the context of this Measure.\n Returns : The context.\n Args    : The context (optional).\n\n\nsub context {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_context\" } = $value;\n    }\n   \n    return $self->{ \"_context\" };\n    \n} # context\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $measure->description( \"reduced in 4(Tas1r3)\" );\n           or \n           print $measure->description(); \n Function: Set/get for the description of this Measure.\n Returns : A description.\n Args    : A description (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n   \n    return $self->{ \"_description\" };\n    \n} # description\n\n\n\n\n=head2 start \n\n Title   : start\n Usage   : $measure->start( 330 );\n           or \n           print $measure->start(); \n Function: Set/get for the start value of this Measure.\n Returns : The start value.\n Args    : The start value (optional).\n\n\nsub start {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_start\" } = $value;\n    }\n   \n    return $self->{ \"_start\" };\n    \n} #  start\n\n\n\n\n=head2 end \n\n Title   : end \n Usage   : $measure->end( 459 );\n           or \n           print $measure->end(); \n Function: Set/get for the end value of this Measure.\n Returns : The end value.\n Args    : The end value (optional).\n\n\nsub end {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_end\" } = $value;\n    }\n   \n    return $self->{ \"_end\" };\n    \n} # end\n\n\n\n\n=head2 unit\n\n Title   : unit\n Usage   : $measure->unit( \"mM\" );\n           or \n           print $measure->unit(); \n Function: Set/get for the unit of this Measure.\n Returns : The unit.\n Args    : The unit (optional).","label":"unit($self,$value)"},"kind":12,"line":302,"children":[{"line":303,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"unit"},{"containerName":"unit","name":"$value","line":303,"kind":13},{"containerName":"unit","name":"$value","line":305,"kind":13},{"line":306,"kind":13,"name":"$self","containerName":"unit"},{"name":"$value","containerName":"unit","kind":13,"line":306},{"line":309,"kind":13,"name":"$self","containerName":"unit"}]},{"range":{"end":{"character":9999,"line":337},"start":{"line":328,"character":0}},"name":"comment","detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: Measure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Measure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Measure - Representation of context/value(-range)/unit triplets\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Measure;\n\n  my $measure = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                              -description => \"reduced length in 4(Tas1r3)\",\n                                              -start       => 0,\n                                              -end         => 15,\n                                              -unit        => \"mm\",\n                                              -comment     => \"see also Miller et al\" );\n\n  print $measure->context();\n  print $measure->description();\n  print $measure->start();\n  print $measure->end();\n  print $measure->unit();\n  print $measure->comment();\n\n  print $measure->to_string();\n\n=head1 DESCRIPTION\n\nMeasure is for biochemically defined phenotypes or any other types of measures.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Measure;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $me = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                                  -description => \"reduced length in 4(Tas1r3)\",\n                                                  -start       => 0,\n                                                  -end         => 15,\n                                                  -unit        => \"mm\",\n                                                  -comment     => \"see Miller also et al\" );                      \n Function: Creates a new Measure object.\n Returns : A new Measure object.\n Args    : -context     => the context\n           -description => a description\n           -start       => the start value\n           -end         => the end value\n           -unit        => the unit\n           -comment     => a comment\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $con, $desc, $start, $end, $unit, $comment )\n    = $self->_rearrange( [ qw( CONTEXT\n                               DESCRIPTION\n                               START\n                               END\n                               UNIT\n                               COMMENT ) ], @args );\n\n    $self->init(); \n \n    $con     && $self->context( $con );\n    $desc    && $self->description( $desc );\n    $start   && $self->start( $start );\n    $end     && $self->end( $end );\n    $unit    && $self->unit( $unit );\n    $comment && $self->comment( $comment );\n                           \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $measure->init();   \n Function: Initializes this Measure to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->context( \"\" );\n    $self->description( \"\" );\n    $self->start( \"\" );\n    $self->end( \"\" );\n    $self->unit( \"\" );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n\n=head2 context\n\n Title   : context\n Usage   : $measure->context( \"Ca-conc\" );\n           or \n           print $measure->context(); \n Function: Set/get for the context of this Measure.\n Returns : The context.\n Args    : The context (optional).\n\n\nsub context {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_context\" } = $value;\n    }\n   \n    return $self->{ \"_context\" };\n    \n} # context\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $measure->description( \"reduced in 4(Tas1r3)\" );\n           or \n           print $measure->description(); \n Function: Set/get for the description of this Measure.\n Returns : A description.\n Args    : A description (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n   \n    return $self->{ \"_description\" };\n    \n} # description\n\n\n\n\n=head2 start \n\n Title   : start\n Usage   : $measure->start( 330 );\n           or \n           print $measure->start(); \n Function: Set/get for the start value of this Measure.\n Returns : The start value.\n Args    : The start value (optional).\n\n\nsub start {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_start\" } = $value;\n    }\n   \n    return $self->{ \"_start\" };\n    \n} #  start\n\n\n\n\n=head2 end \n\n Title   : end \n Usage   : $measure->end( 459 );\n           or \n           print $measure->end(); \n Function: Set/get for the end value of this Measure.\n Returns : The end value.\n Args    : The end value (optional).\n\n\nsub end {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_end\" } = $value;\n    }\n   \n    return $self->{ \"_end\" };\n    \n} # end\n\n\n\n\n=head2 unit\n\n Title   : unit\n Usage   : $measure->unit( \"mM\" );\n           or \n           print $measure->unit(); \n Function: Set/get for the unit of this Measure.\n Returns : The unit.\n Args    : The unit (optional).\n\n\nsub unit {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_unit\" } = $value;\n    }\n   \n    return $self->{ \"_unit\" };\n    \n} # unit\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $measure->comment( \"see also Miller et al\" );\n           or \n           print $measure->comment();\n Function: Set/get for an arbitrary comment about this Measure.\n Returns : A comment.\n Args    : A comment (optional).","parameters":[{"label":"$self"},{"label":"$value"}],"label":"comment($self,$value)"},"containerName":"main::","definition":"sub","line":328,"children":[{"containerName":"comment","name":"$self","definition":"my","localvar":"my","kind":13,"line":329},{"kind":13,"line":329,"name":"$value","containerName":"comment"},{"line":331,"kind":13,"name":"$value","containerName":"comment"},{"containerName":"comment","name":"$self","kind":13,"line":332},{"kind":13,"line":332,"name":"$value","containerName":"comment"},{"line":335,"kind":13,"name":"$self","containerName":"comment"}],"kind":12},{"range":{"start":{"character":0,"line":352},"end":{"character":9999,"line":372}},"name":"to_string","signature":{"label":"to_string($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Measure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Measure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Measure - Representation of context/value(-range)/unit triplets\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Measure;\n\n  my $measure = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                              -description => \"reduced length in 4(Tas1r3)\",\n                                              -start       => 0,\n                                              -end         => 15,\n                                              -unit        => \"mm\",\n                                              -comment     => \"see also Miller et al\" );\n\n  print $measure->context();\n  print $measure->description();\n  print $measure->start();\n  print $measure->end();\n  print $measure->unit();\n  print $measure->comment();\n\n  print $measure->to_string();\n\n=head1 DESCRIPTION\n\nMeasure is for biochemically defined phenotypes or any other types of measures.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Measure;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $me = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                                  -description => \"reduced length in 4(Tas1r3)\",\n                                                  -start       => 0,\n                                                  -end         => 15,\n                                                  -unit        => \"mm\",\n                                                  -comment     => \"see Miller also et al\" );                      \n Function: Creates a new Measure object.\n Returns : A new Measure object.\n Args    : -context     => the context\n           -description => a description\n           -start       => the start value\n           -end         => the end value\n           -unit        => the unit\n           -comment     => a comment\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $con, $desc, $start, $end, $unit, $comment )\n    = $self->_rearrange( [ qw( CONTEXT\n                               DESCRIPTION\n                               START\n                               END\n                               UNIT\n                               COMMENT ) ], @args );\n\n    $self->init(); \n \n    $con     && $self->context( $con );\n    $desc    && $self->description( $desc );\n    $start   && $self->start( $start );\n    $end     && $self->end( $end );\n    $unit    && $self->unit( $unit );\n    $comment && $self->comment( $comment );\n                           \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $measure->init();   \n Function: Initializes this Measure to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->context( \"\" );\n    $self->description( \"\" );\n    $self->start( \"\" );\n    $self->end( \"\" );\n    $self->unit( \"\" );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n\n=head2 context\n\n Title   : context\n Usage   : $measure->context( \"Ca-conc\" );\n           or \n           print $measure->context(); \n Function: Set/get for the context of this Measure.\n Returns : The context.\n Args    : The context (optional).\n\n\nsub context {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_context\" } = $value;\n    }\n   \n    return $self->{ \"_context\" };\n    \n} # context\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $measure->description( \"reduced in 4(Tas1r3)\" );\n           or \n           print $measure->description(); \n Function: Set/get for the description of this Measure.\n Returns : A description.\n Args    : A description (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n   \n    return $self->{ \"_description\" };\n    \n} # description\n\n\n\n\n=head2 start \n\n Title   : start\n Usage   : $measure->start( 330 );\n           or \n           print $measure->start(); \n Function: Set/get for the start value of this Measure.\n Returns : The start value.\n Args    : The start value (optional).\n\n\nsub start {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_start\" } = $value;\n    }\n   \n    return $self->{ \"_start\" };\n    \n} #  start\n\n\n\n\n=head2 end \n\n Title   : end \n Usage   : $measure->end( 459 );\n           or \n           print $measure->end(); \n Function: Set/get for the end value of this Measure.\n Returns : The end value.\n Args    : The end value (optional).\n\n\nsub end {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_end\" } = $value;\n    }\n   \n    return $self->{ \"_end\" };\n    \n} # end\n\n\n\n\n=head2 unit\n\n Title   : unit\n Usage   : $measure->unit( \"mM\" );\n           or \n           print $measure->unit(); \n Function: Set/get for the unit of this Measure.\n Returns : The unit.\n Args    : The unit (optional).\n\n\nsub unit {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_unit\" } = $value;\n    }\n   \n    return $self->{ \"_unit\" };\n    \n} # unit\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $measure->comment( \"see also Miller et al\" );\n           or \n           print $measure->comment();\n Function: Set/get for an arbitrary comment about this Measure.\n Returns : A comment.\n Args    : A comment (optional).\n\n\nsub comment {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_comment\" } = $value;\n    }\n   \n    return $self->{ \"_comment\" };\n    \n} # comment\n\n\n\n\n=head2 to_string\n\n Title   : to_string()\n Usage   : print $measure->to_string();\n Function: To string method for Measure objects.\n Returns : A string representations of this Measure.\n Args    :"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"to_string","localvar":"my","kind":13,"line":353},{"definition":"my","name":"$s","containerName":"to_string","localvar":"my","kind":13,"line":355},{"name":"$s","containerName":"to_string","line":357,"kind":13},{"name":"$s","containerName":"to_string","line":358,"kind":13},{"line":358,"kind":13,"name":"$self","containerName":"to_string"},{"kind":12,"line":358,"containerName":"to_string","name":"context"},{"kind":13,"line":359,"containerName":"to_string","name":"$s"},{"line":360,"kind":13,"name":"$s","containerName":"to_string"},{"name":"$self","containerName":"to_string","kind":13,"line":360},{"kind":12,"line":360,"name":"description","containerName":"to_string"},{"name":"$s","containerName":"to_string","kind":13,"line":361},{"containerName":"to_string","name":"$s","line":362,"kind":13},{"kind":13,"line":362,"name":"$self","containerName":"to_string"},{"kind":12,"line":362,"containerName":"to_string","name":"start"},{"kind":13,"line":363,"name":"$s","containerName":"to_string"},{"kind":13,"line":364,"name":"$s","containerName":"to_string"},{"line":364,"kind":13,"containerName":"to_string","name":"$self"},{"name":"end","containerName":"to_string","line":364,"kind":12},{"line":365,"kind":13,"containerName":"to_string","name":"$s"},{"name":"$s","containerName":"to_string","kind":13,"line":366},{"line":366,"kind":13,"name":"$self","containerName":"to_string"},{"line":366,"kind":12,"name":"unit","containerName":"to_string"},{"containerName":"to_string","name":"$s","kind":13,"line":367},{"kind":13,"line":368,"name":"$s","containerName":"to_string"},{"line":368,"kind":13,"name":"$self","containerName":"to_string"},{"name":"comment","containerName":"to_string","line":368,"kind":12},{"containerName":"to_string","name":"$s","kind":13,"line":370}],"line":352,"kind":12}]}