{"vars":[{"kind":2,"line":116,"containerName":"","name":"base"},{"line":118,"kind":13,"name":"@Bio","containerName":null},{"containerName":"PSM::Psm::HEADER","name":"Matrix","kind":12,"line":118},{"range":{"end":{"line":168,"character":9999},"start":{"line":160,"character":0}},"name":"new","signature":{"label":"new($caller,@args)","documentation":"1;\n#---------------------------------------------------------\n# $Id: ProtPsm.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n#ISA ProtMatrix, HAS InstanceSite\n\n=head1 NAME\n\nBio::Matrix::PSM::ProtPsm - handle combination of site matricies\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::IO;\n\n  #To get a ProtPsm object from a file use the Psm parser:\n  my $psmIO =  Bio::Matrix::PSM::IO->new(-format=>'psiblast', -file=>$file);\n\n  # Now go through all entities in the file with next_psm, which\n  # returns a Psm object see Bio::Matrix::PSM::IO for detailed\n  # documentation (matrix predictions or matrix sequence matches or\n  # both):\n\n  while (my $psm=$psmIO->next_psm) {\n     my %psm_header = $psm->header;\n     my $ic    = $psm_header{IC};\n     my $sites = $psm_header{sites};\n     my $width = $psm_header{width};\n     my $score = $psm_header{e_val};\n     my $IUPAC = $psm->IUPAC;\n     my $instances = $psm->instances;\n     foreach my $instance (@{$instances}) {\n       my $id = $instance->primary_id;\n       #Do something with the id\n     }\n   }\n\n=head1 DESCRIPTION\n\nTo handle a combination of site matrices and/or their corresponding sequence\nmatches (instances). This object inherits from Bio::Matrix::PSM::ProtMatrix, so\nyou can methods from that class. It may hold also an array of\nBio::Matrix::PSM::InstanceSite object, but you will have to retrieve these\nthrough Bio::Matrix::PSM::ProtPsm-E<gt>instances method (see below). To some\nextent this is an expanded ProtMatrix object, holding data from analysis that\nalso deal with sequence matches of a particular matrix.\n\n\n=head2 DESIGN ISSUES\n\nThis does not make too much sense to me I am mixing PSM with PSM sequence\nmatches Though they are very closely related, I am not satisfied by the way\nthis is implemented here.  Heikki suggested different objects when one has\nsomething like meme But does this mean we have to write a different objects for\nmast, meme, transfac, theiresias, etc.?  To me the best way is to return\nSiteMatrix object + arrray of InstanceSite objects and then mast will return\nundef for SiteMatrix and transfac will return undef for InstanceSite. Probably\nI cannot see some other design issues that might arise from such approach, but\nit seems more straightforward.  Hilmar does not like this beacause it is an\nexception from the general BioPerl rules. Should I leave this as an option?\nAlso the header rightfully belongs the driver object, and could be retrieved as\nhashes.  I do not think it can be done any other way, unless we want to create\neven one more object with very unclear content.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - James Thompson\n\nEmail tex@biosysadmin.com\n\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 SEE ALSO\n\nProtMatrix, meme, transfac, psiblast, InstanceSite\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::ProtPsm;\nuse Bio::Matrix::PSM::InstanceSite;\nuse strict;\n\nuse base qw(Bio::Matrix::PSM::ProtMatrix Bio::Matrix::PSM::PsmI Bio::Annotation::Collection);\n\n@Bio::Matrix::PSM::Psm::HEADER = qw(e_val sites IC width);\n\n=head2 new\n\n Title   : new\n Usage   : my $psm = Bio::Matrix::PSM::ProtPsm->new(\n              -pS => [ '0', '33', '0', '16', '1', '12', '11', '25' ],\n              -pF => [ '0', '0', '2', '0', '3', '0', '0', '0' ],\n              -pT => [ '0', '8', '7', '10', '1', '2', '7', '8' ],\n              -pN => [ '0', '0', '2', '13', '0', '36', '1', '4' ],\n              -pK => [ '0', '5', '0', '13', '1', '15', '0', '2' ],\n              -pY => [ '0', '0', '0', '0', '0', '0', '0', '0' ],\n              -pE => [ '0', '41', '1', '12', '0', '0', '0', '15' ],\n              -pV => [ '0', '3', '9', '0', '2', '0', '3', '1' ],\n              -pQ => [ '0', '0', '0', '15', '0', '4', '0', '3' ],\n              -pM => [ '100', '0', '66', '0', '2', '0', '0', '0' ],\n              -pC => [ '0', '0', '0', '0', '0', '0', '0', '0' ],\n              -pL => [ '0', '0', '8', '0', '25', '0', '4', '0' ],\n              -pA => [ '0', '10', '1', '9', '2', '0', '22', '16' ],\n              -pW => [ '0', '0', '0', '0', '0', '0', '0', '0' ],\n              -pP => [ '0', '0', '0', '0', '3', '1', '45', '0' ],\n              -pH => [ '0', '0', '0', '0', '0', '0', '1', '0' ],\n              -pD => [ '0', '0', '1', '7', '2', '2', '0', '22' ],\n              -pR => [ '0', '0', '0', '3', '0', '27', '0', '0' ],\n              -pI => [ '0', '0', '3', '0', '59', '1', '2', '3' ],\n              -pG => [ '0', '0', '0', '1', '0', '0', '4', '1' ],\n              -IC => $ic,\n              -sites => $istes,\n              -width => $width,\n              -e_val => $e_val, \n              -instances => $instances, \n           }\n\n Function: Creates a new Bio::Matrix::PSM::ProtPsm object\n Throws  :\n Example :\n Returns :  Bio::Matrix::PSM::Psm object\n Args    :  hash","parameters":[{"label":"$caller"},{"label":"@args"}]},"detail":"($caller,@args)","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$caller","containerName":"new","line":161,"kind":13},{"containerName":"new","name":"@args","kind":13,"line":161},{"containerName":"new","definition":"my","name":"$class","localvar":"my","kind":13,"line":162},{"containerName":"new","name":"$caller","kind":13,"line":162},{"name":"$caller","containerName":"new","kind":13,"line":162},{"kind":13,"line":163,"containerName":"new","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":163,"containerName":"new","name":"$class"},{"kind":13,"line":163,"containerName":"new","name":"@args"},{"containerName":"new","name":"$self","line":164,"kind":13},{"kind":13,"line":165,"containerName":"new","name":"$self"},{"containerName":"new","name":"_typemap","kind":12,"line":165},{"line":165,"kind":12,"containerName":"new","name":"new"},{"kind":13,"line":166,"containerName":"new","name":"$self"},{"name":"$self","containerName":"new","line":166,"kind":13},{"containerName":"new","name":"_rearrange","kind":12,"line":166},{"containerName":"new","name":"@args","line":166,"kind":13},{"containerName":"new","name":"$self","line":167,"kind":13}],"line":160,"kind":12},{"name":"SUPER","containerName":"new","line":163,"kind":12},{"line":165,"kind":12,"containerName":"Annotation::TypeManager","name":"Bio"},{"name":"instances","kind":12,"line":166},{"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"instances","line":185,"kind":13},{"containerName":"instances","definition":"my","name":"$prev","localvar":"my","kind":13,"line":186},{"containerName":"instances","name":"$self","kind":13,"line":186},{"kind":13,"line":187,"name":"$self","containerName":"instances"},{"containerName":"instances","name":"$prev","line":188,"kind":13}],"line":184,"kind":12,"range":{"end":{"line":189,"character":9999},"start":{"character":0,"line":184}},"definition":"sub","name":"instances","containerName":"main::"},{"name":"instances","kind":12,"line":186},{"kind":12,"line":187,"name":"instances"},{"range":{"end":{"line":220,"character":9999},"start":{"character":0,"line":211}},"containerName":"main::","definition":"sub","name":"header","line":211,"children":[{"kind":13,"line":212,"name":"$self","definition":"my","containerName":"header","localvar":"my"},{"containerName":"header","name":"$self","line":213,"kind":13},{"name":"%header","definition":"my","containerName":"header","localvar":"my","kind":13,"line":214},{"line":215,"kind":13,"localvar":"my","definition":"my","name":"$key","containerName":"header"},{"name":"$self","containerName":"header","line":215,"kind":13},{"containerName":"header","name":"$key","line":215,"kind":13},{"kind":13,"line":216,"name":"$key","definition":"my","containerName":"header","localvar":"my"},{"name":"@Bio","containerName":"header","kind":13,"line":216},{"containerName":"header","name":"$header","line":217,"kind":13},{"containerName":"header","name":"$key","line":217,"kind":13},{"kind":13,"line":217,"containerName":"header","name":"$self"},{"containerName":"header","name":"$key","line":217,"kind":13},{"kind":13,"line":219,"name":"%header","containerName":"header"}],"kind":12},{"line":213,"kind":12,"name":"end"},{"name":"Matrix","containerName":"PSM::ProtPsm::HEADER","line":216,"kind":12},{"range":{"end":{"character":9999,"line":253},"start":{"character":0,"line":236}},"definition":"sub","name":"matrix","containerName":"main::","children":[{"localvar":"my","containerName":"matrix","name":"$self","definition":"my","line":237,"kind":13},{"line":240,"kind":13,"localvar":"my","containerName":"matrix","definition":"my","name":"$matrix"},{"kind":13,"line":241,"name":"@alphabet","definition":"my","containerName":"matrix","localvar":"my"},{"kind":13,"line":241,"name":"$self","containerName":"matrix"},{"kind":12,"line":241,"name":"alphabet","containerName":"matrix"},{"localvar":"my","definition":"my","name":"$char","containerName":"matrix","line":243,"kind":13},{"containerName":"matrix","name":"@alphabet","line":243,"kind":13},{"kind":13,"line":244,"containerName":"matrix","name":"$self"},{"line":244,"kind":13,"name":"$matrix","containerName":"matrix"},{"line":245,"kind":13,"name":"$self","containerName":"matrix"},{"line":245,"kind":13,"containerName":"matrix","name":"$matrix"},{"containerName":"matrix","name":"$self","kind":13,"line":247},{"line":247,"kind":13,"name":"$matrix","containerName":"matrix"},{"line":247,"kind":12,"containerName":"matrix","name":"IC"},{"kind":13,"line":248,"name":"$self","containerName":"matrix"},{"kind":13,"line":248,"name":"$matrix","containerName":"matrix"},{"containerName":"matrix","name":"e_val","line":248,"kind":12},{"containerName":"matrix","name":"$self","line":249,"kind":13},{"line":249,"kind":13,"containerName":"matrix","name":"$matrix"},{"name":"id","containerName":"matrix","line":249,"kind":12},{"containerName":"matrix","name":"$self","kind":13,"line":252}],"line":236,"kind":12},{"kind":12,"line":247,"name":"IC"},{"name":"e_val","line":248,"kind":12},{"line":249,"kind":12,"name":"id"}],"version":5}