{"version":5,"vars":[{"line":78,"kind":2,"containerName":"","name":"base"},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Mlagan.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Mlagan\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Mlagan - A generic matrix with mlagan fields\n\n=head1 SYNOPSIS\n\n  # See L<Bio::Matrix::Generic> for most methods.\n  # These are relevant for mlagan IO:\n  $matrix->gap_open(-400);\n  $matrix->gap_continue(-25);\n\n=head1 DESCRIPTION\n\nThis is based on Bio::Matrix::Generic, differing by storing gap_open and\ngap_continue data members to allow mlagan IO (see Bio::Matrix::IO::mlagan).\n(Those values are 'outside' the matrix.)\n\nIt also limits the structure to a 6x6 matrix with row & column names 'A', 'C',\n'G', 'T', '.' and 'N'.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Matrix::Mlagan;\nuse strict;\n\nuse base qw(Bio::Matrix::Generic);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Generic->new();\n Function: Builds a new Bio::Matrix::Generic object \n Returns : an instance of Bio::Matrix::Generic\n Args    : -values            => arrayref of arrayrefs of data initialization\n           -matrix_id         => id of the matrix\n           -matrix_name       => name of the matrix\n           -matrix_init_value => default value to initialize empty cells\n           -gap_open          => gap open penalty (int)\n           -gap_continue      => gap continue penalty (int)\n\n           NB: -rownames and -colnames should not be given here, since they are\n           always being set to 'A', 'C', 'G', 'T', '.' and 'N'.","label":"new($class,@args)"},"detail":"($class,@args)","kind":12,"children":[{"definition":"my","name":"$class","containerName":"new","localvar":"my","kind":13,"line":100},{"containerName":"new","name":"@args","line":100,"kind":13},{"line":101,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"%args"},{"containerName":"new","name":"@args","kind":13,"line":101},{"line":103,"kind":13,"localvar":"my","containerName":"new","name":"$self","definition":"my"},{"line":103,"kind":13,"containerName":"new","name":"$class"},{"kind":13,"line":103,"name":"%args","containerName":"new"},{"containerName":"new","name":"$self","line":105,"kind":13},{"containerName":"new","name":"_set_from_args","kind":12,"line":105},{"name":"@args","containerName":"new","kind":13,"line":105},{"kind":13,"line":107,"name":"$self","containerName":"new"}],"line":99,"name":"new","range":{"start":{"line":99,"character":0},"end":{"line":108,"character":9999}}},{"containerName":"new","name":"SUPER","kind":12,"line":103},{"kind":12,"children":[{"definition":"my","name":"$self","containerName":"gap_open","localvar":"my","kind":13,"line":121},{"line":122,"kind":13,"containerName":"gap_open","name":"$self"},{"containerName":"gap_open","name":"$self","line":123,"kind":13}],"line":120,"name":"gap_open","definition":"sub","containerName":"main::","range":{"end":{"line":124,"character":9999},"start":{"line":120,"character":0}}},{"line":122,"kind":12,"name":"gap_open"},{"line":123,"kind":12,"name":"gap_open"},{"range":{"end":{"line":140,"character":9999},"start":{"line":136,"character":0}},"containerName":"main::","name":"gap_continue","definition":"sub","line":136,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"gap_continue","line":137,"kind":13},{"name":"$self","containerName":"gap_continue","kind":13,"line":138},{"line":139,"kind":13,"name":"$self","containerName":"gap_continue"}],"kind":12},{"kind":12,"line":138,"name":"gap_continue"},{"name":"gap_continue","kind":12,"line":139},{"children":[{"containerName":"add_row","name":"warn","kind":12,"line":154}],"line":153,"kind":12,"range":{"end":{"character":9999,"line":155},"start":{"line":153,"character":0}},"definition":"sub","name":"add_row","containerName":"main::"},{"kind":12,"line":168,"children":[{"containerName":"remove_row","name":"warn","kind":12,"line":169}],"containerName":"main::","definition":"sub","name":"remove_row","range":{"start":{"character":0,"line":168},"end":{"character":9999,"line":170}}},{"range":{"end":{"character":9999,"line":185},"start":{"line":183,"character":0}},"definition":"sub","name":"add_column","containerName":"main::","children":[{"kind":12,"line":184,"name":"warn","containerName":"add_column"}],"line":183,"kind":12},{"range":{"start":{"character":0,"line":198},"end":{"character":9999,"line":200}},"containerName":"main::","name":"remove_column","definition":"sub","line":198,"children":[{"name":"warn","containerName":"remove_column","line":199,"kind":12}],"kind":12}]}