{"vars":[{"containerName":"","name":"base","kind":2,"line":111},{"range":{"end":{"character":9999,"line":172},"start":{"character":0,"line":149}},"name":"new","children":[{"containerName":"new","definition":"my","name":"$class","localvar":"my","kind":13,"line":150},{"line":150,"kind":13,"containerName":"new","name":"@args"},{"kind":13,"line":151,"containerName":"new","name":"$self","definition":"my","localvar":"my"},{"containerName":"new","name":"$class","line":151,"kind":13},{"line":151,"kind":13,"name":"@args","containerName":"new"},{"containerName":"new","name":"$name","definition":"my","localvar":"my","kind":13,"line":153},{"name":"$type","containerName":"new","line":153,"kind":13},{"containerName":"new","name":"$global","kind":13,"line":153},{"name":"$frame","containerName":"new","line":153,"kind":13},{"containerName":"new","name":"$group","kind":13,"line":153},{"line":154,"kind":13,"containerName":"new","name":"$subgroup"},{"line":154,"kind":13,"containerName":"new","name":"$anchor"},{"kind":13,"line":154,"name":"$clones","containerName":"new"},{"containerName":"new","name":"$contigs","kind":13,"line":154},{"name":"$positions","containerName":"new","line":155,"kind":13},{"containerName":"new","name":"$remark","kind":13,"line":155},{"kind":13,"line":155,"containerName":"new","name":"$self"},{"name":"_rearrange","containerName":"new","kind":12,"line":155},{"name":"@args","containerName":"new","line":157,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":159},{"kind":12,"line":159,"name":"name","containerName":"new"},{"name":"$name","containerName":"new","kind":13,"line":159},{"line":159,"kind":13,"name":"$name","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":160},{"kind":12,"line":160,"name":"type","containerName":"new"},{"kind":13,"line":160,"containerName":"new","name":"$type"},{"name":"$type","containerName":"new","line":160,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":161},{"line":161,"kind":12,"name":"global","containerName":"new"},{"containerName":"new","name":"$global","line":161,"kind":13},{"line":161,"kind":13,"name":"$global","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":162},{"containerName":"new","name":"group","line":162,"kind":12},{"name":"$group","containerName":"new","line":162,"kind":13},{"containerName":"new","name":"$group","line":162,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":163},{"line":163,"kind":12,"containerName":"new","name":"subgroup"},{"containerName":"new","name":"$group","line":163,"kind":13},{"kind":13,"line":163,"name":"$subgroup","containerName":"new"},{"line":164,"kind":13,"containerName":"new","name":"$self"},{"line":164,"kind":12,"name":"anchor","containerName":"new"},{"name":"$anchor","containerName":"new","kind":13,"line":164},{"name":"$anchor","containerName":"new","line":164,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":165},{"name":"remark","containerName":"new","kind":12,"line":165},{"containerName":"new","name":"$remark","line":165,"kind":13},{"name":"$remark","containerName":"new","kind":13,"line":165},{"containerName":"new","name":"$self","kind":13,"line":167},{"containerName":"new","name":"set_clones","line":167,"kind":12},{"containerName":"new","name":"$clones","line":167,"kind":13},{"containerName":"new","name":"$clones","kind":13,"line":167},{"kind":13,"line":168,"containerName":"new","name":"$self"},{"containerName":"new","name":"set_contigs","kind":12,"line":168},{"kind":13,"line":168,"containerName":"new","name":"$contigs"},{"name":"$contigs","containerName":"new","line":168,"kind":13},{"line":169,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":169,"containerName":"new","name":"set_positions"},{"kind":13,"line":169,"containerName":"new","name":"$positions"},{"line":169,"kind":13,"name":"$positions","containerName":"new"},{"kind":13,"line":171,"containerName":"new","name":"$self"}],"line":149,"kind":12,"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: FPCMarker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::fpcmarker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gaurav Gupta <gaurav@genome.arizona.edu>\n#\n# Copyright Gaurav Gupta\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::FPCMarker - An central map object representing a marker\n\n=head1 SYNOPSIS\n\n   # get the marker object of $marker from the Bio::Map::FPCMarker\n   my $markerobj = $physical->get_markerobj($marker);\n\n   # acquire all the clones that hit this marker\n   foreach my $clone ($markerobj->each_cloneid()) {\n       print \"   +++$clone\\n\";\n   }\n\n   # find the position of this marker in $contig\n   print \"Position in contig $contig\",\" = \",$markerobj->position($contig),\n         \"\\n\";\n\n   # find the group of the marker\n   print \"Group : \",$markerobj->group();\n\n\nSee L<Bio::Map::Position> and L<Bio::Map::PositionI> for more information.\n\n=head1 DESCRIPTION\n\nThis object handles the notion of a marker.\nThis object is intended to be used by a map parser like fpc.pm.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::FPCMarker;\nuse strict;\nuse Bio::Map::Position;\nuse Time::Local;\n\nuse base qw(Bio::Root::Root Bio::Map::MappableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $clone = Bio::Map::FPCMarker->new\n                      (\n\t\t       -name    => $marker,\n\t\t       -type    => $type,\n\t\t       -global  => $global,\n\t\t       -frame   => $frame,\n\t\t       -group   => $group,\n\t\t       -subgroup=> $subgroup,\n\t\t       -anchor  => $anchor,\n\t\t       -clones  => \\%clones,\n\t\t       -contigs => \\%contigs,\n\t\t       -position => \\%markerpos,\n               -remark => $remark\n\t\t       );\n\n Function: Initialize a new Bio::Map::FPCMarker object\n           Most people will not use this directly but get Markers\n           through L<Bio::MapIO::fpc>\n Returns : L<Bio::Map::FPCMarker> object\n Args    : -name     => marker name string,\n\t       -type     => type string,\n\t       -global   => global position for marker,\n\t       -frame    => boolean if marker is framework or placement,\n\t       -group    => group number for marker,\n\t       -subgroup => subgroup number of marker,\n\t       -anchor   => boolean if marker is anchored,\n\t       -clones   => all the clone elements in map (hashref),\n\t       -contigs  => all the contig elements (hasref),\n\t       -position => mapping of marker names to map position (hasref),\n           -remark   => remarks, separated by newlines","parameters":[{"label":"$class"},{"label":"@args"}]},"detail":"($class,@args)","definition":"sub","containerName":"main::"},{"containerName":"new","name":"SUPER","kind":12,"line":151},{"children":[{"localvar":"my","containerName":"name","definition":"my","name":"$self","line":189,"kind":13},{"kind":13,"line":190,"containerName":"name","name":"$self"},{"name":"$self","containerName":"name","kind":13,"line":191}],"line":188,"kind":12,"range":{"end":{"character":9999,"line":192},"start":{"character":0,"line":188}},"definition":"sub","name":"name","containerName":"main::"},{"line":204,"children":[{"kind":13,"line":205,"containerName":"type","definition":"my","name":"$self","localvar":"my"},{"containerName":"type","name":"$self","line":206,"kind":13},{"kind":13,"line":207,"name":"$self","containerName":"type"}],"kind":12,"range":{"start":{"character":0,"line":204},"end":{"character":9999,"line":208}},"containerName":"main::","definition":"sub","name":"type"},{"containerName":"main::","definition":"sub","name":"global","range":{"end":{"character":9999,"line":224},"start":{"line":220,"character":0}},"kind":12,"line":220,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"global","line":221,"kind":13},{"containerName":"global","name":"$self","line":222,"kind":13},{"name":"$self","containerName":"global","kind":13,"line":223}]},{"range":{"start":{"character":0,"line":236},"end":{"character":9999,"line":240}},"containerName":"main::","definition":"sub","name":"anchor","line":236,"children":[{"containerName":"anchor","name":"$self","definition":"my","localvar":"my","kind":13,"line":237},{"line":238,"kind":13,"containerName":"anchor","name":"$self"},{"containerName":"anchor","name":"$self","line":239,"kind":13}],"kind":12},{"name":"framework","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":257},"start":{"character":0,"line":253}},"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"framework","line":254,"kind":13},{"kind":13,"line":255,"containerName":"framework","name":"$self"},{"containerName":"framework","name":"$self","line":256,"kind":13}],"line":253},{"children":[{"line":271,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"group"},{"name":"$self","containerName":"group","line":272,"kind":13},{"containerName":"group","name":"$self","kind":13,"line":273}],"line":270,"kind":12,"range":{"end":{"character":9999,"line":274},"start":{"line":270,"character":0}},"name":"group","definition":"sub","containerName":"main::"},{"children":[{"kind":13,"line":290,"containerName":"subgroup","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":291,"containerName":"subgroup","name":"$self"},{"containerName":"subgroup","name":"$self","line":292,"kind":13}],"line":289,"kind":12,"range":{"end":{"line":293,"character":9999},"start":{"character":0,"line":289}},"name":"subgroup","definition":"sub","containerName":"main::"},{"name":"position","range":{"end":{"character":9999,"line":316},"start":{"line":309,"character":0}},"definition":"sub","containerName":"main::","signature":{"label":"position($self,$ctg)","parameters":[{"label":"$self"},{"label":"$ctg"}],"documentation":"1;\n# $Id: FPCMarker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::fpcmarker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gaurav Gupta <gaurav@genome.arizona.edu>\n#\n# Copyright Gaurav Gupta\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::FPCMarker - An central map object representing a marker\n\n=head1 SYNOPSIS\n\n   # get the marker object of $marker from the Bio::Map::FPCMarker\n   my $markerobj = $physical->get_markerobj($marker);\n\n   # acquire all the clones that hit this marker\n   foreach my $clone ($markerobj->each_cloneid()) {\n       print \"   +++$clone\\n\";\n   }\n\n   # find the position of this marker in $contig\n   print \"Position in contig $contig\",\" = \",$markerobj->position($contig),\n         \"\\n\";\n\n   # find the group of the marker\n   print \"Group : \",$markerobj->group();\n\n\nSee L<Bio::Map::Position> and L<Bio::Map::PositionI> for more information.\n\n=head1 DESCRIPTION\n\nThis object handles the notion of a marker.\nThis object is intended to be used by a map parser like fpc.pm.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::FPCMarker;\nuse strict;\nuse Bio::Map::Position;\nuse Time::Local;\n\nuse base qw(Bio::Root::Root Bio::Map::MappableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $clone = Bio::Map::FPCMarker->new\n                      (\n\t\t       -name    => $marker,\n\t\t       -type    => $type,\n\t\t       -global  => $global,\n\t\t       -frame   => $frame,\n\t\t       -group   => $group,\n\t\t       -subgroup=> $subgroup,\n\t\t       -anchor  => $anchor,\n\t\t       -clones  => \\%clones,\n\t\t       -contigs => \\%contigs,\n\t\t       -position => \\%markerpos,\n               -remark => $remark\n\t\t       );\n\n Function: Initialize a new Bio::Map::FPCMarker object\n           Most people will not use this directly but get Markers\n           through L<Bio::MapIO::fpc>\n Returns : L<Bio::Map::FPCMarker> object\n Args    : -name     => marker name string,\n\t       -type     => type string,\n\t       -global   => global position for marker,\n\t       -frame    => boolean if marker is framework or placement,\n\t       -group    => group number for marker,\n\t       -subgroup => subgroup number of marker,\n\t       -anchor   => boolean if marker is anchored,\n\t       -clones   => all the clone elements in map (hashref),\n\t       -contigs  => all the contig elements (hasref),\n\t       -position => mapping of marker names to map position (hasref),\n           -remark   => remarks, separated by newlines\n\n\nsub new {\n   my ($class,@args) = @_;\n   my $self= $class->SUPER::new(@args);\n\n   my ($name,$type,$global,$frame,$group,\n       $subgroup, $anchor, $clones,$contigs,\n       $positions, $remark) = $self->_rearrange([qw(NAME TYPE GLOBAL FRAME\n\t\t\t\t\t   GROUP SUBGROUP ANCHOR\n\t\t\t\t\t   CLONES CONTIGS POSITIONS REMARK)],@args);\n\n   $self->name($name)                  if defined $name;\n   $self->type($type)                  if defined $type;\n   $self->global($global)              if defined $global;\n   $self->group($group)                if defined $group;\n   $self->subgroup($group)             if defined $subgroup;\n   $self->anchor($anchor)              if defined $anchor;\n   $self->remark($remark)              if defined $remark;\n\n   $self->set_clones($clones)          if defined $clones;\n   $self->set_contigs($contigs)        if defined $contigs;\n   $self->set_positions($positions)    if defined $positions;\n\n   return $self;\n}\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $markerobj->name();\n Function: Get/set the name for this marker\n Returns : scalar representing the current name of this marker\n Args    : none to get, OR string to set\n\n\nsub name {\n    my ($self) = shift;\n    return $self->{'_name'} = shift if @_;\n    return $self->{'_name'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $markerobj->type();\n Function: Get/set the type for this marker\n Returns : scalar representing the current type of this marker\n Args    : none to get, OR string to set\n\n\nsub type {\n    my ($self) = shift;\n    return $self->{'_type'} = shift if @_;\n    return $self->{'_type'};\n}\n\n=head2 global\n\n Title   : global\n Usage   : my $type = $markerobj->global();\n Function: Get/set the global position for this marker\n Returns : scalar representing the current global position of this marker\n Args    : none to get, OR string to set\n\n\nsub global {\n    my ($self) = shift;\n    return $self->{'_global'} = shift if @_;\n    return $self->{'_global'};\n}\n\n=head2 anchor\n\n Title   : anchor\n Usage   : my $anchor = $markerobj->anchor();\n Function: indicate if the Marker is anchored or not (True | False)\n Returns : scalar representing the anchor (1 | 0) for this marker\n Args    : none to get, OR 1|0 to set\n\n\nsub anchor {\n    my ($self) = shift;\n    return $self->{'_anchor'} = shift if @_;\n    return $self->{'_anchor'};\n}\n\n=head2 framework\n\n Title   : framework\n Usage   : $frame = $markerobj->framework();\n Function: indicate if the Marker is framework or placement (1 | 0)\n Returns : scalar representing if the marker is framework\n           (1 if framework, 0 if placement)\n Args    : none to get, OR 1|0 to set\n\n\nsub framework {\n    my ($self) = shift;\n    return $self->{'_frame'} = shift if @_;\n    return $self->{'_frame'};\n}\n\n=head2 group\n\n Title   : group\n Usage   : $grpno = $markerobj->group();\n Function: Get/set the group number for this marker. This is a generic term,\n           used for Linkage-Groups as well as for Chromosomes.\n Returns : scalar representing the group number of this marker\n Args    : none to get, OR string to set\n\n\nsub group {\n    my ($self) = shift;\n    $self->{'_group'} = shift if @_;\n    return $self->{'_group'} || 0;\n}\n\n=head2 subgroup\n\n Title   : subgroup\n Usage   : $subgroup = $marker->subgroup();\t\n Function: Get/set the subgroup for this marker. This is a generic term:\n           subgroup here could represent subgroup of a Chromosome or of a\n           Linkage Group. The user must take care of which subgroup he/she is\n           querying for.\t\n Returns : scalar representing the subgroup of this marker\n Args    : none to get, OR string to set\n\n\nsub subgroup {\n    my ($self) = shift;\n    $self->{'_subgroup'} = shift if @_;\n    return $self->{'_subgroup'} || 0;\n}\n\n=head2 position\n\n Title   : position\n Usage   : $markerpos = $markerobj->position($ctg);\n Function: get the position of the marker in the contig\n Returns : scalar representing the position of the markernumber of\n           the contig\n Args    : $ctg is necessary to look for the position of the marker\n           in that contig.\n\n *** This has nothing to do with an actual Bio::Map::PositionI object ***"},"detail":"($self,$ctg)","kind":12,"children":[{"kind":13,"line":310,"definition":"my","name":"$self","containerName":"position","localvar":"my"},{"name":"$ctg","containerName":"position","line":310,"kind":13},{"line":311,"kind":13,"containerName":"position","name":"$ctg"},{"name":"$self","containerName":"position","kind":13,"line":313},{"containerName":"position","name":"$self","kind":13,"line":314},{"line":314,"kind":13,"name":"$ctg","containerName":"position"},{"name":"$self","containerName":"position","line":315,"kind":13},{"line":315,"kind":13,"containerName":"position","name":"$ctg"}],"line":309},{"name":"remark","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":328},"end":{"character":9999,"line":332}},"kind":12,"children":[{"line":329,"kind":13,"localvar":"my","containerName":"remark","definition":"my","name":"$self"},{"kind":13,"line":330,"name":"$self","containerName":"remark"},{"containerName":"remark","name":"$self","kind":13,"line":331}],"line":328},{"kind":12,"children":[{"line":348,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"each_cloneid"},{"kind":13,"line":349,"containerName":"each_cloneid","name":"$self"},{"name":"_each_element","containerName":"each_cloneid","kind":12,"line":349}],"line":347,"definition":"sub","containerName":"main::","signature":{"label":"each_cloneid($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: FPCMarker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::fpcmarker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gaurav Gupta <gaurav@genome.arizona.edu>\n#\n# Copyright Gaurav Gupta\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::FPCMarker - An central map object representing a marker\n\n=head1 SYNOPSIS\n\n   # get the marker object of $marker from the Bio::Map::FPCMarker\n   my $markerobj = $physical->get_markerobj($marker);\n\n   # acquire all the clones that hit this marker\n   foreach my $clone ($markerobj->each_cloneid()) {\n       print \"   +++$clone\\n\";\n   }\n\n   # find the position of this marker in $contig\n   print \"Position in contig $contig\",\" = \",$markerobj->position($contig),\n         \"\\n\";\n\n   # find the group of the marker\n   print \"Group : \",$markerobj->group();\n\n\nSee L<Bio::Map::Position> and L<Bio::Map::PositionI> for more information.\n\n=head1 DESCRIPTION\n\nThis object handles the notion of a marker.\nThis object is intended to be used by a map parser like fpc.pm.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::FPCMarker;\nuse strict;\nuse Bio::Map::Position;\nuse Time::Local;\n\nuse base qw(Bio::Root::Root Bio::Map::MappableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $clone = Bio::Map::FPCMarker->new\n                      (\n\t\t       -name    => $marker,\n\t\t       -type    => $type,\n\t\t       -global  => $global,\n\t\t       -frame   => $frame,\n\t\t       -group   => $group,\n\t\t       -subgroup=> $subgroup,\n\t\t       -anchor  => $anchor,\n\t\t       -clones  => \\%clones,\n\t\t       -contigs => \\%contigs,\n\t\t       -position => \\%markerpos,\n               -remark => $remark\n\t\t       );\n\n Function: Initialize a new Bio::Map::FPCMarker object\n           Most people will not use this directly but get Markers\n           through L<Bio::MapIO::fpc>\n Returns : L<Bio::Map::FPCMarker> object\n Args    : -name     => marker name string,\n\t       -type     => type string,\n\t       -global   => global position for marker,\n\t       -frame    => boolean if marker is framework or placement,\n\t       -group    => group number for marker,\n\t       -subgroup => subgroup number of marker,\n\t       -anchor   => boolean if marker is anchored,\n\t       -clones   => all the clone elements in map (hashref),\n\t       -contigs  => all the contig elements (hasref),\n\t       -position => mapping of marker names to map position (hasref),\n           -remark   => remarks, separated by newlines\n\n\nsub new {\n   my ($class,@args) = @_;\n   my $self= $class->SUPER::new(@args);\n\n   my ($name,$type,$global,$frame,$group,\n       $subgroup, $anchor, $clones,$contigs,\n       $positions, $remark) = $self->_rearrange([qw(NAME TYPE GLOBAL FRAME\n\t\t\t\t\t   GROUP SUBGROUP ANCHOR\n\t\t\t\t\t   CLONES CONTIGS POSITIONS REMARK)],@args);\n\n   $self->name($name)                  if defined $name;\n   $self->type($type)                  if defined $type;\n   $self->global($global)              if defined $global;\n   $self->group($group)                if defined $group;\n   $self->subgroup($group)             if defined $subgroup;\n   $self->anchor($anchor)              if defined $anchor;\n   $self->remark($remark)              if defined $remark;\n\n   $self->set_clones($clones)          if defined $clones;\n   $self->set_contigs($contigs)        if defined $contigs;\n   $self->set_positions($positions)    if defined $positions;\n\n   return $self;\n}\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $markerobj->name();\n Function: Get/set the name for this marker\n Returns : scalar representing the current name of this marker\n Args    : none to get, OR string to set\n\n\nsub name {\n    my ($self) = shift;\n    return $self->{'_name'} = shift if @_;\n    return $self->{'_name'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $markerobj->type();\n Function: Get/set the type for this marker\n Returns : scalar representing the current type of this marker\n Args    : none to get, OR string to set\n\n\nsub type {\n    my ($self) = shift;\n    return $self->{'_type'} = shift if @_;\n    return $self->{'_type'};\n}\n\n=head2 global\n\n Title   : global\n Usage   : my $type = $markerobj->global();\n Function: Get/set the global position for this marker\n Returns : scalar representing the current global position of this marker\n Args    : none to get, OR string to set\n\n\nsub global {\n    my ($self) = shift;\n    return $self->{'_global'} = shift if @_;\n    return $self->{'_global'};\n}\n\n=head2 anchor\n\n Title   : anchor\n Usage   : my $anchor = $markerobj->anchor();\n Function: indicate if the Marker is anchored or not (True | False)\n Returns : scalar representing the anchor (1 | 0) for this marker\n Args    : none to get, OR 1|0 to set\n\n\nsub anchor {\n    my ($self) = shift;\n    return $self->{'_anchor'} = shift if @_;\n    return $self->{'_anchor'};\n}\n\n=head2 framework\n\n Title   : framework\n Usage   : $frame = $markerobj->framework();\n Function: indicate if the Marker is framework or placement (1 | 0)\n Returns : scalar representing if the marker is framework\n           (1 if framework, 0 if placement)\n Args    : none to get, OR 1|0 to set\n\n\nsub framework {\n    my ($self) = shift;\n    return $self->{'_frame'} = shift if @_;\n    return $self->{'_frame'};\n}\n\n=head2 group\n\n Title   : group\n Usage   : $grpno = $markerobj->group();\n Function: Get/set the group number for this marker. This is a generic term,\n           used for Linkage-Groups as well as for Chromosomes.\n Returns : scalar representing the group number of this marker\n Args    : none to get, OR string to set\n\n\nsub group {\n    my ($self) = shift;\n    $self->{'_group'} = shift if @_;\n    return $self->{'_group'} || 0;\n}\n\n=head2 subgroup\n\n Title   : subgroup\n Usage   : $subgroup = $marker->subgroup();\t\n Function: Get/set the subgroup for this marker. This is a generic term:\n           subgroup here could represent subgroup of a Chromosome or of a\n           Linkage Group. The user must take care of which subgroup he/she is\n           querying for.\t\n Returns : scalar representing the subgroup of this marker\n Args    : none to get, OR string to set\n\n\nsub subgroup {\n    my ($self) = shift;\n    $self->{'_subgroup'} = shift if @_;\n    return $self->{'_subgroup'} || 0;\n}\n\n=head2 position\n\n Title   : position\n Usage   : $markerpos = $markerobj->position($ctg);\n Function: get the position of the marker in the contig\n Returns : scalar representing the position of the markernumber of\n           the contig\n Args    : $ctg is necessary to look for the position of the marker\n           in that contig.\n\n *** This has nothing to do with an actual Bio::Map::PositionI object ***\n\n\nsub position {\n    my ($self,$ctg) = @_;\n    return 0 unless defined $ctg;\n\n    return 0 unless( defined $self->{'_position'} &&\n\t\t     defined $self->{'_position'}{$ctg});\n    return $self->{'_position'}{$ctg};\n}\n\n=head2 remark\n\n Title   : remark\n Usage   : $markerremark = $markerobj->remark();\n Function: get the remarks for this marker\n Returns : scalar of newline-separated markers\n Args    : none\n\n\nsub remark {\n    my ($self) = shift;\n    return $self->{'_remark'} = shift if @_;\n    return $self->{'_remark'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones  = $map->each_cloneid();\n Function: retrieves all the clone ids in a map unordered\n Returns : list of strings (ids)\n Args    : none\n\n *** This only supplies the ids set with the set_clones method ***\n *** It has nothing to do with actual Bio::Map::MappableI objects ***"},"detail":"($self)","name":"each_cloneid","range":{"end":{"character":9999,"line":350},"start":{"character":0,"line":347}}},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: FPCMarker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::fpcmarker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gaurav Gupta <gaurav@genome.arizona.edu>\n#\n# Copyright Gaurav Gupta\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::FPCMarker - An central map object representing a marker\n\n=head1 SYNOPSIS\n\n   # get the marker object of $marker from the Bio::Map::FPCMarker\n   my $markerobj = $physical->get_markerobj($marker);\n\n   # acquire all the clones that hit this marker\n   foreach my $clone ($markerobj->each_cloneid()) {\n       print \"   +++$clone\\n\";\n   }\n\n   # find the position of this marker in $contig\n   print \"Position in contig $contig\",\" = \",$markerobj->position($contig),\n         \"\\n\";\n\n   # find the group of the marker\n   print \"Group : \",$markerobj->group();\n\n\nSee L<Bio::Map::Position> and L<Bio::Map::PositionI> for more information.\n\n=head1 DESCRIPTION\n\nThis object handles the notion of a marker.\nThis object is intended to be used by a map parser like fpc.pm.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::FPCMarker;\nuse strict;\nuse Bio::Map::Position;\nuse Time::Local;\n\nuse base qw(Bio::Root::Root Bio::Map::MappableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $clone = Bio::Map::FPCMarker->new\n                      (\n\t\t       -name    => $marker,\n\t\t       -type    => $type,\n\t\t       -global  => $global,\n\t\t       -frame   => $frame,\n\t\t       -group   => $group,\n\t\t       -subgroup=> $subgroup,\n\t\t       -anchor  => $anchor,\n\t\t       -clones  => \\%clones,\n\t\t       -contigs => \\%contigs,\n\t\t       -position => \\%markerpos,\n               -remark => $remark\n\t\t       );\n\n Function: Initialize a new Bio::Map::FPCMarker object\n           Most people will not use this directly but get Markers\n           through L<Bio::MapIO::fpc>\n Returns : L<Bio::Map::FPCMarker> object\n Args    : -name     => marker name string,\n\t       -type     => type string,\n\t       -global   => global position for marker,\n\t       -frame    => boolean if marker is framework or placement,\n\t       -group    => group number for marker,\n\t       -subgroup => subgroup number of marker,\n\t       -anchor   => boolean if marker is anchored,\n\t       -clones   => all the clone elements in map (hashref),\n\t       -contigs  => all the contig elements (hasref),\n\t       -position => mapping of marker names to map position (hasref),\n           -remark   => remarks, separated by newlines\n\n\nsub new {\n   my ($class,@args) = @_;\n   my $self= $class->SUPER::new(@args);\n\n   my ($name,$type,$global,$frame,$group,\n       $subgroup, $anchor, $clones,$contigs,\n       $positions, $remark) = $self->_rearrange([qw(NAME TYPE GLOBAL FRAME\n\t\t\t\t\t   GROUP SUBGROUP ANCHOR\n\t\t\t\t\t   CLONES CONTIGS POSITIONS REMARK)],@args);\n\n   $self->name($name)                  if defined $name;\n   $self->type($type)                  if defined $type;\n   $self->global($global)              if defined $global;\n   $self->group($group)                if defined $group;\n   $self->subgroup($group)             if defined $subgroup;\n   $self->anchor($anchor)              if defined $anchor;\n   $self->remark($remark)              if defined $remark;\n\n   $self->set_clones($clones)          if defined $clones;\n   $self->set_contigs($contigs)        if defined $contigs;\n   $self->set_positions($positions)    if defined $positions;\n\n   return $self;\n}\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $markerobj->name();\n Function: Get/set the name for this marker\n Returns : scalar representing the current name of this marker\n Args    : none to get, OR string to set\n\n\nsub name {\n    my ($self) = shift;\n    return $self->{'_name'} = shift if @_;\n    return $self->{'_name'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $markerobj->type();\n Function: Get/set the type for this marker\n Returns : scalar representing the current type of this marker\n Args    : none to get, OR string to set\n\n\nsub type {\n    my ($self) = shift;\n    return $self->{'_type'} = shift if @_;\n    return $self->{'_type'};\n}\n\n=head2 global\n\n Title   : global\n Usage   : my $type = $markerobj->global();\n Function: Get/set the global position for this marker\n Returns : scalar representing the current global position of this marker\n Args    : none to get, OR string to set\n\n\nsub global {\n    my ($self) = shift;\n    return $self->{'_global'} = shift if @_;\n    return $self->{'_global'};\n}\n\n=head2 anchor\n\n Title   : anchor\n Usage   : my $anchor = $markerobj->anchor();\n Function: indicate if the Marker is anchored or not (True | False)\n Returns : scalar representing the anchor (1 | 0) for this marker\n Args    : none to get, OR 1|0 to set\n\n\nsub anchor {\n    my ($self) = shift;\n    return $self->{'_anchor'} = shift if @_;\n    return $self->{'_anchor'};\n}\n\n=head2 framework\n\n Title   : framework\n Usage   : $frame = $markerobj->framework();\n Function: indicate if the Marker is framework or placement (1 | 0)\n Returns : scalar representing if the marker is framework\n           (1 if framework, 0 if placement)\n Args    : none to get, OR 1|0 to set\n\n\nsub framework {\n    my ($self) = shift;\n    return $self->{'_frame'} = shift if @_;\n    return $self->{'_frame'};\n}\n\n=head2 group\n\n Title   : group\n Usage   : $grpno = $markerobj->group();\n Function: Get/set the group number for this marker. This is a generic term,\n           used for Linkage-Groups as well as for Chromosomes.\n Returns : scalar representing the group number of this marker\n Args    : none to get, OR string to set\n\n\nsub group {\n    my ($self) = shift;\n    $self->{'_group'} = shift if @_;\n    return $self->{'_group'} || 0;\n}\n\n=head2 subgroup\n\n Title   : subgroup\n Usage   : $subgroup = $marker->subgroup();\t\n Function: Get/set the subgroup for this marker. This is a generic term:\n           subgroup here could represent subgroup of a Chromosome or of a\n           Linkage Group. The user must take care of which subgroup he/she is\n           querying for.\t\n Returns : scalar representing the subgroup of this marker\n Args    : none to get, OR string to set\n\n\nsub subgroup {\n    my ($self) = shift;\n    $self->{'_subgroup'} = shift if @_;\n    return $self->{'_subgroup'} || 0;\n}\n\n=head2 position\n\n Title   : position\n Usage   : $markerpos = $markerobj->position($ctg);\n Function: get the position of the marker in the contig\n Returns : scalar representing the position of the markernumber of\n           the contig\n Args    : $ctg is necessary to look for the position of the marker\n           in that contig.\n\n *** This has nothing to do with an actual Bio::Map::PositionI object ***\n\n\nsub position {\n    my ($self,$ctg) = @_;\n    return 0 unless defined $ctg;\n\n    return 0 unless( defined $self->{'_position'} &&\n\t\t     defined $self->{'_position'}{$ctg});\n    return $self->{'_position'}{$ctg};\n}\n\n=head2 remark\n\n Title   : remark\n Usage   : $markerremark = $markerobj->remark();\n Function: get the remarks for this marker\n Returns : scalar of newline-separated markers\n Args    : none\n\n\nsub remark {\n    my ($self) = shift;\n    return $self->{'_remark'} = shift if @_;\n    return $self->{'_remark'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones  = $map->each_cloneid();\n Function: retrieves all the clone ids in a map unordered\n Returns : list of strings (ids)\n Args    : none\n\n *** This only supplies the ids set with the set_clones method ***\n *** It has nothing to do with actual Bio::Map::MappableI objects ***\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return $self->_each_element('clones');\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: retrieves all the contig ids in a map unordered\n Returns : list of strings (ids)\n Args    : none\n\n *** This only supplies the ids set with the set_contigs method ***\n *** It has nothing to do with actual Bio::Map::MapI objects ***","label":"each_contigid($self)"},"detail":"($self)","kind":12,"children":[{"line":366,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"each_contigid"},{"line":367,"kind":13,"containerName":"each_contigid","name":"$self"},{"containerName":"each_contigid","name":"_each_element","kind":12,"line":367}],"line":365,"name":"each_contigid","range":{"end":{"line":368,"character":9999},"start":{"character":0,"line":365}}},{"name":"_each_element","range":{"end":{"line":376,"character":9999},"start":{"line":370,"character":0}},"containerName":"main::","definition":"sub","detail":"($self,$type)","signature":{"parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"","label":"_each_element($self,$type)"},"kind":12,"line":370,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_each_element","line":371,"kind":13},{"containerName":"_each_element","name":"$type","line":371,"kind":13},{"containerName":"_each_element","name":"$type","line":373,"kind":13},{"containerName":"_each_element","name":"$type","kind":13,"line":373},{"name":"$type","containerName":"_each_element","line":374,"kind":13},{"containerName":"_each_element","name":"$self","line":376,"kind":13},{"line":376,"kind":13,"containerName":"_each_element","name":"$type"}]},{"children":[{"containerName":"set_clones","definition":"my","name":"$self","localvar":"my","kind":13,"line":393},{"line":393,"kind":13,"containerName":"set_clones","name":"$clones"},{"containerName":"set_clones","name":"$clones","line":394,"kind":13},{"name":"$clones","containerName":"set_clones","line":394,"kind":13},{"line":395,"kind":13,"containerName":"set_clones","name":"$self"},{"kind":13,"line":395,"containerName":"set_clones","name":"$clones"}],"line":392,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$clones"}],"documentation":"1;\n# $Id: FPCMarker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::fpcmarker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gaurav Gupta <gaurav@genome.arizona.edu>\n#\n# Copyright Gaurav Gupta\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::FPCMarker - An central map object representing a marker\n\n=head1 SYNOPSIS\n\n   # get the marker object of $marker from the Bio::Map::FPCMarker\n   my $markerobj = $physical->get_markerobj($marker);\n\n   # acquire all the clones that hit this marker\n   foreach my $clone ($markerobj->each_cloneid()) {\n       print \"   +++$clone\\n\";\n   }\n\n   # find the position of this marker in $contig\n   print \"Position in contig $contig\",\" = \",$markerobj->position($contig),\n         \"\\n\";\n\n   # find the group of the marker\n   print \"Group : \",$markerobj->group();\n\n\nSee L<Bio::Map::Position> and L<Bio::Map::PositionI> for more information.\n\n=head1 DESCRIPTION\n\nThis object handles the notion of a marker.\nThis object is intended to be used by a map parser like fpc.pm.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::FPCMarker;\nuse strict;\nuse Bio::Map::Position;\nuse Time::Local;\n\nuse base qw(Bio::Root::Root Bio::Map::MappableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $clone = Bio::Map::FPCMarker->new\n                      (\n\t\t       -name    => $marker,\n\t\t       -type    => $type,\n\t\t       -global  => $global,\n\t\t       -frame   => $frame,\n\t\t       -group   => $group,\n\t\t       -subgroup=> $subgroup,\n\t\t       -anchor  => $anchor,\n\t\t       -clones  => \\%clones,\n\t\t       -contigs => \\%contigs,\n\t\t       -position => \\%markerpos,\n               -remark => $remark\n\t\t       );\n\n Function: Initialize a new Bio::Map::FPCMarker object\n           Most people will not use this directly but get Markers\n           through L<Bio::MapIO::fpc>\n Returns : L<Bio::Map::FPCMarker> object\n Args    : -name     => marker name string,\n\t       -type     => type string,\n\t       -global   => global position for marker,\n\t       -frame    => boolean if marker is framework or placement,\n\t       -group    => group number for marker,\n\t       -subgroup => subgroup number of marker,\n\t       -anchor   => boolean if marker is anchored,\n\t       -clones   => all the clone elements in map (hashref),\n\t       -contigs  => all the contig elements (hasref),\n\t       -position => mapping of marker names to map position (hasref),\n           -remark   => remarks, separated by newlines\n\n\nsub new {\n   my ($class,@args) = @_;\n   my $self= $class->SUPER::new(@args);\n\n   my ($name,$type,$global,$frame,$group,\n       $subgroup, $anchor, $clones,$contigs,\n       $positions, $remark) = $self->_rearrange([qw(NAME TYPE GLOBAL FRAME\n\t\t\t\t\t   GROUP SUBGROUP ANCHOR\n\t\t\t\t\t   CLONES CONTIGS POSITIONS REMARK)],@args);\n\n   $self->name($name)                  if defined $name;\n   $self->type($type)                  if defined $type;\n   $self->global($global)              if defined $global;\n   $self->group($group)                if defined $group;\n   $self->subgroup($group)             if defined $subgroup;\n   $self->anchor($anchor)              if defined $anchor;\n   $self->remark($remark)              if defined $remark;\n\n   $self->set_clones($clones)          if defined $clones;\n   $self->set_contigs($contigs)        if defined $contigs;\n   $self->set_positions($positions)    if defined $positions;\n\n   return $self;\n}\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $markerobj->name();\n Function: Get/set the name for this marker\n Returns : scalar representing the current name of this marker\n Args    : none to get, OR string to set\n\n\nsub name {\n    my ($self) = shift;\n    return $self->{'_name'} = shift if @_;\n    return $self->{'_name'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $markerobj->type();\n Function: Get/set the type for this marker\n Returns : scalar representing the current type of this marker\n Args    : none to get, OR string to set\n\n\nsub type {\n    my ($self) = shift;\n    return $self->{'_type'} = shift if @_;\n    return $self->{'_type'};\n}\n\n=head2 global\n\n Title   : global\n Usage   : my $type = $markerobj->global();\n Function: Get/set the global position for this marker\n Returns : scalar representing the current global position of this marker\n Args    : none to get, OR string to set\n\n\nsub global {\n    my ($self) = shift;\n    return $self->{'_global'} = shift if @_;\n    return $self->{'_global'};\n}\n\n=head2 anchor\n\n Title   : anchor\n Usage   : my $anchor = $markerobj->anchor();\n Function: indicate if the Marker is anchored or not (True | False)\n Returns : scalar representing the anchor (1 | 0) for this marker\n Args    : none to get, OR 1|0 to set\n\n\nsub anchor {\n    my ($self) = shift;\n    return $self->{'_anchor'} = shift if @_;\n    return $self->{'_anchor'};\n}\n\n=head2 framework\n\n Title   : framework\n Usage   : $frame = $markerobj->framework();\n Function: indicate if the Marker is framework or placement (1 | 0)\n Returns : scalar representing if the marker is framework\n           (1 if framework, 0 if placement)\n Args    : none to get, OR 1|0 to set\n\n\nsub framework {\n    my ($self) = shift;\n    return $self->{'_frame'} = shift if @_;\n    return $self->{'_frame'};\n}\n\n=head2 group\n\n Title   : group\n Usage   : $grpno = $markerobj->group();\n Function: Get/set the group number for this marker. This is a generic term,\n           used for Linkage-Groups as well as for Chromosomes.\n Returns : scalar representing the group number of this marker\n Args    : none to get, OR string to set\n\n\nsub group {\n    my ($self) = shift;\n    $self->{'_group'} = shift if @_;\n    return $self->{'_group'} || 0;\n}\n\n=head2 subgroup\n\n Title   : subgroup\n Usage   : $subgroup = $marker->subgroup();\t\n Function: Get/set the subgroup for this marker. This is a generic term:\n           subgroup here could represent subgroup of a Chromosome or of a\n           Linkage Group. The user must take care of which subgroup he/she is\n           querying for.\t\n Returns : scalar representing the subgroup of this marker\n Args    : none to get, OR string to set\n\n\nsub subgroup {\n    my ($self) = shift;\n    $self->{'_subgroup'} = shift if @_;\n    return $self->{'_subgroup'} || 0;\n}\n\n=head2 position\n\n Title   : position\n Usage   : $markerpos = $markerobj->position($ctg);\n Function: get the position of the marker in the contig\n Returns : scalar representing the position of the markernumber of\n           the contig\n Args    : $ctg is necessary to look for the position of the marker\n           in that contig.\n\n *** This has nothing to do with an actual Bio::Map::PositionI object ***\n\n\nsub position {\n    my ($self,$ctg) = @_;\n    return 0 unless defined $ctg;\n\n    return 0 unless( defined $self->{'_position'} &&\n\t\t     defined $self->{'_position'}{$ctg});\n    return $self->{'_position'}{$ctg};\n}\n\n=head2 remark\n\n Title   : remark\n Usage   : $markerremark = $markerobj->remark();\n Function: get the remarks for this marker\n Returns : scalar of newline-separated markers\n Args    : none\n\n\nsub remark {\n    my ($self) = shift;\n    return $self->{'_remark'} = shift if @_;\n    return $self->{'_remark'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones  = $map->each_cloneid();\n Function: retrieves all the clone ids in a map unordered\n Returns : list of strings (ids)\n Args    : none\n\n *** This only supplies the ids set with the set_clones method ***\n *** It has nothing to do with actual Bio::Map::MappableI objects ***\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return $self->_each_element('clones');\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: retrieves all the contig ids in a map unordered\n Returns : list of strings (ids)\n Args    : none\n\n *** This only supplies the ids set with the set_contigs method ***\n *** It has nothing to do with actual Bio::Map::MapI objects ***\n\n\nsub each_contigid {\n    my ($self) = @_;\n    return $self->_each_element('contigs');\n}\n\nsub _each_element{\n    my ($self, $type) = @_;\n\n    $type = 'clones' unless defined $type;\n    $type = lc(\"_$type\");\n\n    return keys %{$self->{$type} || {}};\n}\n\n=head2 set_clones\n\n Title   : set_clones\n Usage   : $marker->set_clones(\\%clones)\n Function: Set the clone ids hashref\n Returns : None\n Args    : Hashref of clone ids\n\n *** This only sets a hash of ids ***\n *** It has nothing to do with actual Bio::Map::MappableI objects ***","label":"set_clones($self,$clones)"},"detail":"($self,$clones)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":392},"end":{"character":9999,"line":397}},"name":"set_clones"},{"children":[{"localvar":"my","containerName":"set_contigs","definition":"my","name":"$self","line":413,"kind":13},{"containerName":"set_contigs","name":"$contigs","line":413,"kind":13},{"kind":13,"line":414,"name":"$contigs","containerName":"set_contigs"},{"line":414,"kind":13,"name":"$contigs","containerName":"set_contigs"},{"line":415,"kind":13,"containerName":"set_contigs","name":"$self"},{"name":"$contigs","containerName":"set_contigs","line":415,"kind":13}],"line":412,"kind":12,"signature":{"label":"set_contigs($self,$contigs)","parameters":[{"label":"$self"},{"label":"$contigs"}],"documentation":"1;\n# $Id: FPCMarker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::fpcmarker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gaurav Gupta <gaurav@genome.arizona.edu>\n#\n# Copyright Gaurav Gupta\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::FPCMarker - An central map object representing a marker\n\n=head1 SYNOPSIS\n\n   # get the marker object of $marker from the Bio::Map::FPCMarker\n   my $markerobj = $physical->get_markerobj($marker);\n\n   # acquire all the clones that hit this marker\n   foreach my $clone ($markerobj->each_cloneid()) {\n       print \"   +++$clone\\n\";\n   }\n\n   # find the position of this marker in $contig\n   print \"Position in contig $contig\",\" = \",$markerobj->position($contig),\n         \"\\n\";\n\n   # find the group of the marker\n   print \"Group : \",$markerobj->group();\n\n\nSee L<Bio::Map::Position> and L<Bio::Map::PositionI> for more information.\n\n=head1 DESCRIPTION\n\nThis object handles the notion of a marker.\nThis object is intended to be used by a map parser like fpc.pm.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::FPCMarker;\nuse strict;\nuse Bio::Map::Position;\nuse Time::Local;\n\nuse base qw(Bio::Root::Root Bio::Map::MappableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $clone = Bio::Map::FPCMarker->new\n                      (\n\t\t       -name    => $marker,\n\t\t       -type    => $type,\n\t\t       -global  => $global,\n\t\t       -frame   => $frame,\n\t\t       -group   => $group,\n\t\t       -subgroup=> $subgroup,\n\t\t       -anchor  => $anchor,\n\t\t       -clones  => \\%clones,\n\t\t       -contigs => \\%contigs,\n\t\t       -position => \\%markerpos,\n               -remark => $remark\n\t\t       );\n\n Function: Initialize a new Bio::Map::FPCMarker object\n           Most people will not use this directly but get Markers\n           through L<Bio::MapIO::fpc>\n Returns : L<Bio::Map::FPCMarker> object\n Args    : -name     => marker name string,\n\t       -type     => type string,\n\t       -global   => global position for marker,\n\t       -frame    => boolean if marker is framework or placement,\n\t       -group    => group number for marker,\n\t       -subgroup => subgroup number of marker,\n\t       -anchor   => boolean if marker is anchored,\n\t       -clones   => all the clone elements in map (hashref),\n\t       -contigs  => all the contig elements (hasref),\n\t       -position => mapping of marker names to map position (hasref),\n           -remark   => remarks, separated by newlines\n\n\nsub new {\n   my ($class,@args) = @_;\n   my $self= $class->SUPER::new(@args);\n\n   my ($name,$type,$global,$frame,$group,\n       $subgroup, $anchor, $clones,$contigs,\n       $positions, $remark) = $self->_rearrange([qw(NAME TYPE GLOBAL FRAME\n\t\t\t\t\t   GROUP SUBGROUP ANCHOR\n\t\t\t\t\t   CLONES CONTIGS POSITIONS REMARK)],@args);\n\n   $self->name($name)                  if defined $name;\n   $self->type($type)                  if defined $type;\n   $self->global($global)              if defined $global;\n   $self->group($group)                if defined $group;\n   $self->subgroup($group)             if defined $subgroup;\n   $self->anchor($anchor)              if defined $anchor;\n   $self->remark($remark)              if defined $remark;\n\n   $self->set_clones($clones)          if defined $clones;\n   $self->set_contigs($contigs)        if defined $contigs;\n   $self->set_positions($positions)    if defined $positions;\n\n   return $self;\n}\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $markerobj->name();\n Function: Get/set the name for this marker\n Returns : scalar representing the current name of this marker\n Args    : none to get, OR string to set\n\n\nsub name {\n    my ($self) = shift;\n    return $self->{'_name'} = shift if @_;\n    return $self->{'_name'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $markerobj->type();\n Function: Get/set the type for this marker\n Returns : scalar representing the current type of this marker\n Args    : none to get, OR string to set\n\n\nsub type {\n    my ($self) = shift;\n    return $self->{'_type'} = shift if @_;\n    return $self->{'_type'};\n}\n\n=head2 global\n\n Title   : global\n Usage   : my $type = $markerobj->global();\n Function: Get/set the global position for this marker\n Returns : scalar representing the current global position of this marker\n Args    : none to get, OR string to set\n\n\nsub global {\n    my ($self) = shift;\n    return $self->{'_global'} = shift if @_;\n    return $self->{'_global'};\n}\n\n=head2 anchor\n\n Title   : anchor\n Usage   : my $anchor = $markerobj->anchor();\n Function: indicate if the Marker is anchored or not (True | False)\n Returns : scalar representing the anchor (1 | 0) for this marker\n Args    : none to get, OR 1|0 to set\n\n\nsub anchor {\n    my ($self) = shift;\n    return $self->{'_anchor'} = shift if @_;\n    return $self->{'_anchor'};\n}\n\n=head2 framework\n\n Title   : framework\n Usage   : $frame = $markerobj->framework();\n Function: indicate if the Marker is framework or placement (1 | 0)\n Returns : scalar representing if the marker is framework\n           (1 if framework, 0 if placement)\n Args    : none to get, OR 1|0 to set\n\n\nsub framework {\n    my ($self) = shift;\n    return $self->{'_frame'} = shift if @_;\n    return $self->{'_frame'};\n}\n\n=head2 group\n\n Title   : group\n Usage   : $grpno = $markerobj->group();\n Function: Get/set the group number for this marker. This is a generic term,\n           used for Linkage-Groups as well as for Chromosomes.\n Returns : scalar representing the group number of this marker\n Args    : none to get, OR string to set\n\n\nsub group {\n    my ($self) = shift;\n    $self->{'_group'} = shift if @_;\n    return $self->{'_group'} || 0;\n}\n\n=head2 subgroup\n\n Title   : subgroup\n Usage   : $subgroup = $marker->subgroup();\t\n Function: Get/set the subgroup for this marker. This is a generic term:\n           subgroup here could represent subgroup of a Chromosome or of a\n           Linkage Group. The user must take care of which subgroup he/she is\n           querying for.\t\n Returns : scalar representing the subgroup of this marker\n Args    : none to get, OR string to set\n\n\nsub subgroup {\n    my ($self) = shift;\n    $self->{'_subgroup'} = shift if @_;\n    return $self->{'_subgroup'} || 0;\n}\n\n=head2 position\n\n Title   : position\n Usage   : $markerpos = $markerobj->position($ctg);\n Function: get the position of the marker in the contig\n Returns : scalar representing the position of the markernumber of\n           the contig\n Args    : $ctg is necessary to look for the position of the marker\n           in that contig.\n\n *** This has nothing to do with an actual Bio::Map::PositionI object ***\n\n\nsub position {\n    my ($self,$ctg) = @_;\n    return 0 unless defined $ctg;\n\n    return 0 unless( defined $self->{'_position'} &&\n\t\t     defined $self->{'_position'}{$ctg});\n    return $self->{'_position'}{$ctg};\n}\n\n=head2 remark\n\n Title   : remark\n Usage   : $markerremark = $markerobj->remark();\n Function: get the remarks for this marker\n Returns : scalar of newline-separated markers\n Args    : none\n\n\nsub remark {\n    my ($self) = shift;\n    return $self->{'_remark'} = shift if @_;\n    return $self->{'_remark'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones  = $map->each_cloneid();\n Function: retrieves all the clone ids in a map unordered\n Returns : list of strings (ids)\n Args    : none\n\n *** This only supplies the ids set with the set_clones method ***\n *** It has nothing to do with actual Bio::Map::MappableI objects ***\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return $self->_each_element('clones');\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: retrieves all the contig ids in a map unordered\n Returns : list of strings (ids)\n Args    : none\n\n *** This only supplies the ids set with the set_contigs method ***\n *** It has nothing to do with actual Bio::Map::MapI objects ***\n\n\nsub each_contigid {\n    my ($self) = @_;\n    return $self->_each_element('contigs');\n}\n\nsub _each_element{\n    my ($self, $type) = @_;\n\n    $type = 'clones' unless defined $type;\n    $type = lc(\"_$type\");\n\n    return keys %{$self->{$type} || {}};\n}\n\n=head2 set_clones\n\n Title   : set_clones\n Usage   : $marker->set_clones(\\%clones)\n Function: Set the clone ids hashref\n Returns : None\n Args    : Hashref of clone ids\n\n *** This only sets a hash of ids ***\n *** It has nothing to do with actual Bio::Map::MappableI objects ***\n\n\nsub set_clones{\n   my ($self,$clones) = @_;\n   if( defined $clones && ref($clones) =~ /HASH/ ) {\n       $self->{'_clones'} = $clones;\n   }\n}\n\n=head2 set_contigs\n\n Title   : set_contigs\n Usage   : $marker->set_contigs(\\%contigs)\n Function: Set the contig ids hashref\n Returns : None\n Args    : Hashref of contig ids\n\n *** This only sets a hash of ids ***\n *** It has nothing to do with actual Bio::Map::MapI objects ***"},"detail":"($self,$contigs)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":417},"start":{"character":0,"line":412}},"name":"set_contigs"},{"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: FPCMarker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::fpcmarker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gaurav Gupta <gaurav@genome.arizona.edu>\n#\n# Copyright Gaurav Gupta\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::FPCMarker - An central map object representing a marker\n\n=head1 SYNOPSIS\n\n   # get the marker object of $marker from the Bio::Map::FPCMarker\n   my $markerobj = $physical->get_markerobj($marker);\n\n   # acquire all the clones that hit this marker\n   foreach my $clone ($markerobj->each_cloneid()) {\n       print \"   +++$clone\\n\";\n   }\n\n   # find the position of this marker in $contig\n   print \"Position in contig $contig\",\" = \",$markerobj->position($contig),\n         \"\\n\";\n\n   # find the group of the marker\n   print \"Group : \",$markerobj->group();\n\n\nSee L<Bio::Map::Position> and L<Bio::Map::PositionI> for more information.\n\n=head1 DESCRIPTION\n\nThis object handles the notion of a marker.\nThis object is intended to be used by a map parser like fpc.pm.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Gaurav Gupta\n\nEmail gaurav@genome.arizona.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala  bix@sendu.me.uk\n\n=head1 PROJECT LEADERS\n\nJamie Hatfield      jamie@genome.arizona.edu\nDr. Cari Soderlund  cari@genome.arizona.edu\n\n=head1 PROJECT DESCRIPTION\n\nThe project was done in Arizona Genomics Computational Laboratory (AGCoL)\nat University of Arizona.\n\nThis work was funded by USDA-IFAFS grant #11180 titled \"Web Resources for \nthe Computation and Display of Physical Mapping Data\".\n\nFor more information on this project, please refer: \n  http://www.genome.arizona.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::FPCMarker;\nuse strict;\nuse Bio::Map::Position;\nuse Time::Local;\n\nuse base qw(Bio::Root::Root Bio::Map::MappableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $clone = Bio::Map::FPCMarker->new\n                      (\n\t\t       -name    => $marker,\n\t\t       -type    => $type,\n\t\t       -global  => $global,\n\t\t       -frame   => $frame,\n\t\t       -group   => $group,\n\t\t       -subgroup=> $subgroup,\n\t\t       -anchor  => $anchor,\n\t\t       -clones  => \\%clones,\n\t\t       -contigs => \\%contigs,\n\t\t       -position => \\%markerpos,\n               -remark => $remark\n\t\t       );\n\n Function: Initialize a new Bio::Map::FPCMarker object\n           Most people will not use this directly but get Markers\n           through L<Bio::MapIO::fpc>\n Returns : L<Bio::Map::FPCMarker> object\n Args    : -name     => marker name string,\n\t       -type     => type string,\n\t       -global   => global position for marker,\n\t       -frame    => boolean if marker is framework or placement,\n\t       -group    => group number for marker,\n\t       -subgroup => subgroup number of marker,\n\t       -anchor   => boolean if marker is anchored,\n\t       -clones   => all the clone elements in map (hashref),\n\t       -contigs  => all the contig elements (hasref),\n\t       -position => mapping of marker names to map position (hasref),\n           -remark   => remarks, separated by newlines\n\n\nsub new {\n   my ($class,@args) = @_;\n   my $self= $class->SUPER::new(@args);\n\n   my ($name,$type,$global,$frame,$group,\n       $subgroup, $anchor, $clones,$contigs,\n       $positions, $remark) = $self->_rearrange([qw(NAME TYPE GLOBAL FRAME\n\t\t\t\t\t   GROUP SUBGROUP ANCHOR\n\t\t\t\t\t   CLONES CONTIGS POSITIONS REMARK)],@args);\n\n   $self->name($name)                  if defined $name;\n   $self->type($type)                  if defined $type;\n   $self->global($global)              if defined $global;\n   $self->group($group)                if defined $group;\n   $self->subgroup($group)             if defined $subgroup;\n   $self->anchor($anchor)              if defined $anchor;\n   $self->remark($remark)              if defined $remark;\n\n   $self->set_clones($clones)          if defined $clones;\n   $self->set_contigs($contigs)        if defined $contigs;\n   $self->set_positions($positions)    if defined $positions;\n\n   return $self;\n}\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $markerobj->name();\n Function: Get/set the name for this marker\n Returns : scalar representing the current name of this marker\n Args    : none to get, OR string to set\n\n\nsub name {\n    my ($self) = shift;\n    return $self->{'_name'} = shift if @_;\n    return $self->{'_name'};\n}\n\n=head2 type\n\n Title   : type\n Usage   : my $type = $markerobj->type();\n Function: Get/set the type for this marker\n Returns : scalar representing the current type of this marker\n Args    : none to get, OR string to set\n\n\nsub type {\n    my ($self) = shift;\n    return $self->{'_type'} = shift if @_;\n    return $self->{'_type'};\n}\n\n=head2 global\n\n Title   : global\n Usage   : my $type = $markerobj->global();\n Function: Get/set the global position for this marker\n Returns : scalar representing the current global position of this marker\n Args    : none to get, OR string to set\n\n\nsub global {\n    my ($self) = shift;\n    return $self->{'_global'} = shift if @_;\n    return $self->{'_global'};\n}\n\n=head2 anchor\n\n Title   : anchor\n Usage   : my $anchor = $markerobj->anchor();\n Function: indicate if the Marker is anchored or not (True | False)\n Returns : scalar representing the anchor (1 | 0) for this marker\n Args    : none to get, OR 1|0 to set\n\n\nsub anchor {\n    my ($self) = shift;\n    return $self->{'_anchor'} = shift if @_;\n    return $self->{'_anchor'};\n}\n\n=head2 framework\n\n Title   : framework\n Usage   : $frame = $markerobj->framework();\n Function: indicate if the Marker is framework or placement (1 | 0)\n Returns : scalar representing if the marker is framework\n           (1 if framework, 0 if placement)\n Args    : none to get, OR 1|0 to set\n\n\nsub framework {\n    my ($self) = shift;\n    return $self->{'_frame'} = shift if @_;\n    return $self->{'_frame'};\n}\n\n=head2 group\n\n Title   : group\n Usage   : $grpno = $markerobj->group();\n Function: Get/set the group number for this marker. This is a generic term,\n           used for Linkage-Groups as well as for Chromosomes.\n Returns : scalar representing the group number of this marker\n Args    : none to get, OR string to set\n\n\nsub group {\n    my ($self) = shift;\n    $self->{'_group'} = shift if @_;\n    return $self->{'_group'} || 0;\n}\n\n=head2 subgroup\n\n Title   : subgroup\n Usage   : $subgroup = $marker->subgroup();\t\n Function: Get/set the subgroup for this marker. This is a generic term:\n           subgroup here could represent subgroup of a Chromosome or of a\n           Linkage Group. The user must take care of which subgroup he/she is\n           querying for.\t\n Returns : scalar representing the subgroup of this marker\n Args    : none to get, OR string to set\n\n\nsub subgroup {\n    my ($self) = shift;\n    $self->{'_subgroup'} = shift if @_;\n    return $self->{'_subgroup'} || 0;\n}\n\n=head2 position\n\n Title   : position\n Usage   : $markerpos = $markerobj->position($ctg);\n Function: get the position of the marker in the contig\n Returns : scalar representing the position of the markernumber of\n           the contig\n Args    : $ctg is necessary to look for the position of the marker\n           in that contig.\n\n *** This has nothing to do with an actual Bio::Map::PositionI object ***\n\n\nsub position {\n    my ($self,$ctg) = @_;\n    return 0 unless defined $ctg;\n\n    return 0 unless( defined $self->{'_position'} &&\n\t\t     defined $self->{'_position'}{$ctg});\n    return $self->{'_position'}{$ctg};\n}\n\n=head2 remark\n\n Title   : remark\n Usage   : $markerremark = $markerobj->remark();\n Function: get the remarks for this marker\n Returns : scalar of newline-separated markers\n Args    : none\n\n\nsub remark {\n    my ($self) = shift;\n    return $self->{'_remark'} = shift if @_;\n    return $self->{'_remark'};\n}\n\n=head2 each_cloneid\n\n Title   : each_cloneid\n Usage   : my @clones  = $map->each_cloneid();\n Function: retrieves all the clone ids in a map unordered\n Returns : list of strings (ids)\n Args    : none\n\n *** This only supplies the ids set with the set_clones method ***\n *** It has nothing to do with actual Bio::Map::MappableI objects ***\n\n\nsub each_cloneid {\n    my ($self) = @_;\n    return $self->_each_element('clones');\n}\n\n=head2 each_contigid\n\n Title   : each_contigid\n Usage   : my @contigs = $map->each_contigid();\n Function: retrieves all the contig ids in a map unordered\n Returns : list of strings (ids)\n Args    : none\n\n *** This only supplies the ids set with the set_contigs method ***\n *** It has nothing to do with actual Bio::Map::MapI objects ***\n\n\nsub each_contigid {\n    my ($self) = @_;\n    return $self->_each_element('contigs');\n}\n\nsub _each_element{\n    my ($self, $type) = @_;\n\n    $type = 'clones' unless defined $type;\n    $type = lc(\"_$type\");\n\n    return keys %{$self->{$type} || {}};\n}\n\n=head2 set_clones\n\n Title   : set_clones\n Usage   : $marker->set_clones(\\%clones)\n Function: Set the clone ids hashref\n Returns : None\n Args    : Hashref of clone ids\n\n *** This only sets a hash of ids ***\n *** It has nothing to do with actual Bio::Map::MappableI objects ***\n\n\nsub set_clones{\n   my ($self,$clones) = @_;\n   if( defined $clones && ref($clones) =~ /HASH/ ) {\n       $self->{'_clones'} = $clones;\n   }\n}\n\n=head2 set_contigs\n\n Title   : set_contigs\n Usage   : $marker->set_contigs(\\%contigs)\n Function: Set the contig ids hashref\n Returns : None\n Args    : Hashref of contig ids\n\n *** This only sets a hash of ids ***\n *** It has nothing to do with actual Bio::Map::MapI objects ***\n\n\nsub set_contigs{\n   my ($self,$contigs) = @_;\n   if( defined $contigs && ref($contigs) =~ /HASH/ ) {\n       $self->{'_contigs'} = $contigs;\n   }\n}\n\n=head2 set_positions\n\n Title   : set_positions\n Usage   : $marker->set_positions(\\%markerpos)\n Function: Set the positions hashref\n Returns : None\n Args    : Hashref of marker positions\n\n *** This only sets a hash of numbers ***\n *** It has nothing to do with actual Bio::Map::PositionI objects ***","parameters":[{"label":"$self"},{"label":"$pos"}],"label":"set_positions($self,$pos)"},"detail":"($self,$pos)","kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"set_positions","line":433,"kind":13},{"name":"$pos","containerName":"set_positions","line":433,"kind":13},{"name":"$pos","containerName":"set_positions","line":434,"kind":13},{"containerName":"set_positions","name":"$pos","line":434,"kind":13},{"name":"$self","containerName":"set_positions","kind":13,"line":435},{"line":435,"kind":13,"containerName":"set_positions","name":"$pos"}],"line":432,"name":"set_positions","range":{"end":{"line":437,"character":9999},"start":{"line":432,"character":0}}}],"version":5}