{"vars":[{"containerName":"","name":"base","kind":2,"line":107},{"containerName":"main::","name":"_version","definition":"sub","range":{"end":{"line":116,"character":9999},"start":{"character":0,"line":114}},"kind":12,"line":114,"children":[]},{"definition":"sub","name":"_file_format","containerName":"main::","range":{"start":{"character":0,"line":127},"end":{"character":9999,"line":129}},"kind":12,"children":[],"line":127},{"containerName":"main::","definition":"sub","detail":"($self,$file,$i)","signature":{"parameters":[{"label":"$self"},{"label":"$file"},{"label":"$i"}],"documentation":"1;\n#\n#\n# BioPerl module for Bio::Index::Fastq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Tony Cox <avc@sanger.ac.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::Fastq - Interface for indexing (multiple) fastq files\n\n=head1 SYNOPSIS\n\n    # Complete code for making an index for several\n    # fastq files\n    use Bio::Index::Fastq;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::Fastq->new(\n        '-filename' => $Index_File_Name,\n        '-write_flag' => 1);\n    $inx->make_index(@ARGV);\n\n    # Print out several sequences present in the index\n    # in Fastq format\n    use Bio::Index::Fastq;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::Fastq->new('-filename' => $Index_File_Name);\n    my $out = Bio::SeqIO->new('-format' => 'Fastq','-fh' => \\*STDOUT);\n\n    foreach my $id (@ARGV) {\n        my $seq = $inx->fetch($id); # Returns Bio::Seq::Quality object\n\t$out->write_seq($seq);\n    }\n\n    # or, alternatively\n    my $id;\n    my $seq = $inx->get_Seq_by_id($id); #identical to fetch\n\n=head1 DESCRIPTION\n\nInherits functions for managing dbm files from Bio::Index::Abstract.pm,\nand provides the basic funtionallity for indexing fastq files, and\nretrieving the sequence from them. Note: for best results 'use strict'.\n\nBio::Index::Fastq supports the Bio::DB::BioSeqI interface, meaning\nit can be used as a Sequence database for other parts of bioperl\n\n=head1 FEED_BACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Tony Cox\n\nEmail - avc@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Index::Fastq;\n\nuse strict;\n\nuse Bio::Seq;\n\nuse base qw(Bio::Index::AbstractSeq);\n\n#\n# Suggested fix by Michael G Schwern <schwern@pobox.com> to\n# get around a clash with CPAN shell...\n#\n\nsub _version {\n    return 0.2;\n}\n\n=head2 _file_format\n\n Title   : _file_format\n Function: The file format for this package, which is needed\n           by the SeqIO system when reading the sequence.\n Returns : 'Fastq'\n\n\nsub _file_format {\n    return 'Fastq';\n}\n\n\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file( $file_name, $i )\n  Function: Specialist function to index FASTQ format files.\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : ","label":"_index_file($self,$file,$i)"},"kind":12,"line":146,"children":[{"definition":"my","name":"$self","containerName":"_index_file","localvar":"my","kind":13,"line":147},{"containerName":"_index_file","name":"$file","kind":13,"line":148},{"containerName":"_index_file","name":"$i","kind":13,"line":149},{"definition":"my","name":"$begin","containerName":"_index_file","localvar":"my","kind":13,"line":152},{"name":"$begin","containerName":"_index_file","kind":13,"line":156},{"kind":13,"line":158,"name":"$id_parser","definition":"my","containerName":"_index_file","localvar":"my"},{"kind":13,"line":158,"containerName":"_index_file","name":"$self"},{"name":"id_parser","containerName":"_index_file","line":158,"kind":12},{"kind":13,"line":159,"containerName":"_index_file","definition":"my","name":"$c","localvar":"my"},{"localvar":"my","containerName":"_index_file","definition":"my","name":"$FASTQ","line":160,"kind":13},{"containerName":"_index_file","name":"$file","line":160,"kind":13},{"containerName":"_index_file","name":"$self","line":160,"kind":13},{"kind":12,"line":160,"containerName":"_index_file","name":"throw"},{"kind":13,"line":162,"name":"$FASTQ","containerName":"_index_file"},{"line":165,"kind":13,"localvar":"my","name":"$begin","definition":"my","containerName":"_index_file"},{"line":165,"kind":13,"containerName":"_index_file","name":"$FASTQ"},{"name":"$id","definition":"my","containerName":"_index_file","localvar":"my","kind":13,"line":166},{"name":"$self","containerName":"_index_file","kind":13,"line":167},{"line":167,"kind":12,"name":"add_record","containerName":"_index_file"},{"kind":13,"line":167,"containerName":"_index_file","name":"$id"},{"kind":13,"line":167,"name":"$i","containerName":"_index_file"},{"containerName":"_index_file","name":"$begin","kind":13,"line":167},{"line":168,"kind":13,"name":"$c","containerName":"_index_file"},{"kind":13,"line":173,"name":"$FASTQ","containerName":"_index_file"},{"containerName":"_index_file","name":"$c","line":174,"kind":13}],"name":"_index_file","range":{"end":{"line":175,"character":9999},"start":{"character":0,"line":146}}},{"kind":12,"line":166,"name":"id_parser"},{"signature":{"label":"id_parser($self,$code)","parameters":[{"label":"$self"},{"label":"$code"}],"documentation":"1;\n#\n#\n# BioPerl module for Bio::Index::Fastq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Tony Cox <avc@sanger.ac.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::Fastq - Interface for indexing (multiple) fastq files\n\n=head1 SYNOPSIS\n\n    # Complete code for making an index for several\n    # fastq files\n    use Bio::Index::Fastq;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::Fastq->new(\n        '-filename' => $Index_File_Name,\n        '-write_flag' => 1);\n    $inx->make_index(@ARGV);\n\n    # Print out several sequences present in the index\n    # in Fastq format\n    use Bio::Index::Fastq;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::Fastq->new('-filename' => $Index_File_Name);\n    my $out = Bio::SeqIO->new('-format' => 'Fastq','-fh' => \\*STDOUT);\n\n    foreach my $id (@ARGV) {\n        my $seq = $inx->fetch($id); # Returns Bio::Seq::Quality object\n\t$out->write_seq($seq);\n    }\n\n    # or, alternatively\n    my $id;\n    my $seq = $inx->get_Seq_by_id($id); #identical to fetch\n\n=head1 DESCRIPTION\n\nInherits functions for managing dbm files from Bio::Index::Abstract.pm,\nand provides the basic funtionallity for indexing fastq files, and\nretrieving the sequence from them. Note: for best results 'use strict'.\n\nBio::Index::Fastq supports the Bio::DB::BioSeqI interface, meaning\nit can be used as a Sequence database for other parts of bioperl\n\n=head1 FEED_BACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Tony Cox\n\nEmail - avc@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Index::Fastq;\n\nuse strict;\n\nuse Bio::Seq;\n\nuse base qw(Bio::Index::AbstractSeq);\n\n#\n# Suggested fix by Michael G Schwern <schwern@pobox.com> to\n# get around a clash with CPAN shell...\n#\n\nsub _version {\n    return 0.2;\n}\n\n=head2 _file_format\n\n Title   : _file_format\n Function: The file format for this package, which is needed\n           by the SeqIO system when reading the sequence.\n Returns : 'Fastq'\n\n\nsub _file_format {\n    return 'Fastq';\n}\n\n\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file( $file_name, $i )\n  Function: Specialist function to index FASTQ format files.\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : \n\n\nsub _index_file {\n    my( $self,\n        $file, # File name\n        $i,    # Index-number of file being indexed\n        ) = @_;\n    \n    my( $begin,     # Offset from start of file of the start\n                    # of the last found record.\n        );\n\n    $begin = 0;\n\n    my $id_parser = $self->id_parser;\n    my $c = 0;\n    open my $FASTQ, '<', $file or $self->throw(\"Can't open file for read : $file\");\n    # Main indexing loop\n    while (<$FASTQ>) {\n        if (/^@/) {\n            # $begin is the position of the first character after the '@'\n            my $begin = tell($FASTQ) - length( $_ ) + 1;\n            foreach my $id (&$id_parser($_)) {\n                $self->add_record($id, $i, $begin);\n\t\t$c++;\n            }\n        }\n    }\n\n    close $FASTQ;\n    return ($c);\n}\n\n=head2 id_parser\n\n  Title   : id_parser\n  Usage   : $index->id_parser( CODE )\n  Function: Stores or returns the code used by record_id to\n            parse the ID for record from a string.  Useful\n            for (for instance) specifying a different\n            parser for different flavours of FASTQ file. \n            Returns \\&default_id_parser (see below) if not\n            set. If you supply your own id_parser\n            subroutine, then it should expect a fastq\n            description line.  An entry will be added to\n            the index for each string in the list returned.\n  Example : $index->id_parser( \\&my_id_parser )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE"},"detail":"($self,$code)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"id_parser","definition":"my","name":"$self","line":197,"kind":13},{"kind":13,"line":197,"name":"$code","containerName":"id_parser"},{"name":"$code","containerName":"id_parser","kind":13,"line":199},{"name":"$self","containerName":"id_parser","kind":13,"line":200},{"kind":13,"line":200,"containerName":"id_parser","name":"$code"},{"kind":13,"line":202,"name":"$self","containerName":"id_parser"}],"line":196,"kind":12,"range":{"start":{"line":196,"character":0},"end":{"line":203,"character":9999}},"name":"id_parser"},{"line":202,"kind":12,"name":"default_id_parser"},{"children":[],"line":219,"kind":12,"range":{"start":{"line":219,"character":0},"end":{"character":9999,"line":225}},"definition":"sub","name":"default_id_parser","containerName":"main::"}],"version":5}