{"version":5,"vars":[{"containerName":"","name":"base","kind":2,"line":110},{"kind":12,"children":[],"line":112,"definition":"sub","name":"_version","containerName":"main::","range":{"end":{"character":9999,"line":113},"start":{"line":112,"character":0}}},{"name":"new","range":{"start":{"line":139,"character":0},"end":{"line":145,"character":9999}},"kind":12,"children":[{"localvar":"my","definition":"my","name":"$class","containerName":"new","line":141,"kind":13},{"kind":13,"line":141,"containerName":"new","name":"@args"},{"kind":13,"line":143,"containerName":"new","name":"$self","definition":"my","localvar":"my"},{"containerName":"new","name":"$class","line":143,"kind":13},{"line":143,"kind":13,"containerName":"new","name":"@args"}],"line":139,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: BlastTable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::BlastTable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields@uiuc.edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::BlastTable - Indexes tabular Blast reports (-m 9 format) and supports\nretrieval based on query accession(s)\n\n=head1 SYNOPSIS\n\n    use strict;\n    use Bio::Index::BlastTable;\n    my ($indexfile,$file1,$file2,$query);\n    my $index = Bio::Index::Blast->new(-filename => $indexfile,\n\t\t\t\t                          -write_flag => 1);\n    $index->make_index($file1,$file2);\n\n    my $data = $index->get_stream($query);\n\n    my $blast_result = $index->fetch_report($query);\n    print \"query is \", $blast_result->query_name, \"\\n\";\n    while ( my $hit = $blast_result->next_hit ) {\n        print \"Name \", $hit->name,\"\\n\";\n        while ( my $hsp = $hit->next_hsp ) {\n            print \"Score \", $hsp->score;\n        }\n        print \"\\n\";\n    }\n\n=head1 DESCRIPTION\n\nThis object allows one to build an index on a tabular BLAST file (or files)\nand provide quick access to the blast report for that accession.  This also\nallows for ID parsing using a callback:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /^>.+gi\\|(\\d+)/;\n      $1;\n   }\n\nThe indexer is capable of indexing based on multiple IDs passed back from the\ncallback; this is assuming of course all IDs are unique.\n\nNote: for best results 'use strict'.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Index::BlastTable;\nuse strict;\n\nuse IO::String;\nuse Bio::SearchIO;\nuse base qw(Bio::Index::Abstract Bio::Root::Root);\n\nsub _version {\n\treturn ${Bio::Root::Version::VERSION};\n}\n\n=head2 new\n\n  Usage   : $index = Bio::Index::Abstract->new(\n                -filename    => $dbm_file,\n                -write_flag  => 0,\n                -dbm_package => 'DB_File',\n                -verbose     => 0);\n\n  Function: Returns a new index object.  If filename is\n            specified, then open_dbm() is immediately called. \n            Bio::Index::Abstract->new() will usually be called\n            directly only when opening an existing index.\n  Returns : A new index object\n  Args    : -filename    The name of the dbm index file.\n            -write_flag  TRUE if write access to the dbm file is\n                         needed.\n            -dbm_package The Perl dbm module to use for the\n                         index.\n            -verbose     Print debugging output to STDERR if\n                         TRUE.","label":"new($class,@args)"},"detail":"($class,@args)"},{"kind":12,"line":141,"containerName":"Root::Version::VERSION","name":"Bio"},{"containerName":"new","name":"SUPER","line":143,"kind":12},{"range":{"end":{"character":9999,"line":169},"start":{"line":162,"character":0}},"name":"fetch_report","detail":"($self,$id)","signature":{"label":"fetch_report($self,$id)","documentation":"1;\n# $Id: BlastTable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::BlastTable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields@uiuc.edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::BlastTable - Indexes tabular Blast reports (-m 9 format) and supports\nretrieval based on query accession(s)\n\n=head1 SYNOPSIS\n\n    use strict;\n    use Bio::Index::BlastTable;\n    my ($indexfile,$file1,$file2,$query);\n    my $index = Bio::Index::Blast->new(-filename => $indexfile,\n\t\t\t\t                          -write_flag => 1);\n    $index->make_index($file1,$file2);\n\n    my $data = $index->get_stream($query);\n\n    my $blast_result = $index->fetch_report($query);\n    print \"query is \", $blast_result->query_name, \"\\n\";\n    while ( my $hit = $blast_result->next_hit ) {\n        print \"Name \", $hit->name,\"\\n\";\n        while ( my $hsp = $hit->next_hsp ) {\n            print \"Score \", $hsp->score;\n        }\n        print \"\\n\";\n    }\n\n=head1 DESCRIPTION\n\nThis object allows one to build an index on a tabular BLAST file (or files)\nand provide quick access to the blast report for that accession.  This also\nallows for ID parsing using a callback:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /^>.+gi\\|(\\d+)/;\n      $1;\n   }\n\nThe indexer is capable of indexing based on multiple IDs passed back from the\ncallback; this is assuming of course all IDs are unique.\n\nNote: for best results 'use strict'.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Index::BlastTable;\nuse strict;\n\nuse IO::String;\nuse Bio::SearchIO;\nuse base qw(Bio::Index::Abstract Bio::Root::Root);\n\nsub _version {\n\treturn ${Bio::Root::Version::VERSION};\n}\n\n=head2 new\n\n  Usage   : $index = Bio::Index::Abstract->new(\n                -filename    => $dbm_file,\n                -write_flag  => 0,\n                -dbm_package => 'DB_File',\n                -verbose     => 0);\n\n  Function: Returns a new index object.  If filename is\n            specified, then open_dbm() is immediately called. \n            Bio::Index::Abstract->new() will usually be called\n            directly only when opening an existing index.\n  Returns : A new index object\n  Args    : -filename    The name of the dbm index file.\n            -write_flag  TRUE if write access to the dbm file is\n                         needed.\n            -dbm_package The Perl dbm module to use for the\n                         index.\n            -verbose     Print debugging output to STDERR if\n                         TRUE.\n\n\nsub new {\n\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n}\n\n=head2 Bio::Index::Blast implemented methods\n\n\n=head2 fetch_report\n\n Title   : fetch_report\n Usage   : my $blastreport = $idx->fetch_report($id);\n Function: Returns a Bio::SearchIO report object \n           for a specific blast report\n Returns : Bio::SearchIO\n Args    : valid id","parameters":[{"label":"$self"},{"label":"$id"}]},"containerName":"main::","definition":"sub","line":162,"children":[{"line":163,"kind":13,"localvar":"my","containerName":"fetch_report","name":"$self","definition":"my"},{"kind":13,"line":163,"name":"$id","containerName":"fetch_report"},{"localvar":"my","containerName":"fetch_report","definition":"my","name":"$fh","line":164,"kind":13},{"containerName":"fetch_report","name":"$self","line":164,"kind":13},{"containerName":"fetch_report","name":"get_stream","line":164,"kind":12},{"kind":13,"line":164,"containerName":"fetch_report","name":"$id"},{"containerName":"fetch_report","name":"$report","definition":"my","localvar":"my","kind":13,"line":165},{"line":165,"kind":12,"containerName":"fetch_report","name":"new"},{"line":167,"kind":13,"containerName":"fetch_report","name":"$fh"},{"containerName":"fetch_report","name":"$report","line":168,"kind":13},{"kind":12,"line":168,"containerName":"fetch_report","name":"next_result"}],"kind":12},{"containerName":"SearchIO","name":"Bio","kind":12,"line":165},{"range":{"start":{"line":189,"character":0},"end":{"line":214,"character":9999}},"name":"_index_file","line":189,"children":[{"containerName":"_index_file","definition":"my","name":"$self","localvar":"my","kind":13,"line":190},{"line":191,"kind":13,"containerName":"_index_file","name":"$file"},{"kind":13,"line":192,"name":"$i","containerName":"_index_file"},{"kind":13,"line":195,"containerName":"_index_file","name":"$begin","definition":"my","localvar":"my"},{"localvar":"my","containerName":"_index_file","definition":"my","name":"$BLAST","line":199,"kind":13},{"kind":13,"line":199,"name":"$file","containerName":"_index_file"},{"containerName":"_index_file","name":"$self","kind":13,"line":199},{"line":199,"kind":12,"containerName":"_index_file","name":"throw"},{"kind":13,"line":200,"containerName":"_index_file","definition":"my","name":"$indexpoint","localvar":"my"},{"containerName":"_index_file","name":"$lastline","definition":"my","localvar":"my","kind":13,"line":201},{"kind":13,"line":202,"name":"$BLAST","containerName":"_index_file"},{"kind":13,"line":204,"containerName":"_index_file","definition":"my","name":"$len","localvar":"my"},{"name":"$indexpoint","containerName":"_index_file","line":205,"kind":13},{"name":"$BLAST","containerName":"_index_file","kind":13,"line":205},{"name":"$len","containerName":"_index_file","kind":13,"line":205},{"name":"$id","definition":"my","containerName":"_index_file","localvar":"my","kind":13,"line":208},{"name":"$self","containerName":"_index_file","line":208,"kind":13},{"line":208,"kind":12,"name":"id_parser","containerName":"_index_file"},{"containerName":"_index_file","name":"$self","line":209,"kind":13},{"kind":12,"line":209,"name":"debug","containerName":"_index_file"},{"kind":13,"line":210,"containerName":"_index_file","name":"$self"},{"line":210,"kind":12,"name":"add_record","containerName":"_index_file"},{"name":"$id","containerName":"_index_file","kind":13,"line":210},{"line":210,"kind":13,"containerName":"_index_file","name":"$i"},{"name":"$indexpoint","containerName":"_index_file","kind":13,"line":210}],"kind":12,"detail":"($self,$file,$i)","signature":{"label":"_index_file($self,$file,$i)","documentation":"1;\n# $Id: BlastTable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::BlastTable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields@uiuc.edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::BlastTable - Indexes tabular Blast reports (-m 9 format) and supports\nretrieval based on query accession(s)\n\n=head1 SYNOPSIS\n\n    use strict;\n    use Bio::Index::BlastTable;\n    my ($indexfile,$file1,$file2,$query);\n    my $index = Bio::Index::Blast->new(-filename => $indexfile,\n\t\t\t\t                          -write_flag => 1);\n    $index->make_index($file1,$file2);\n\n    my $data = $index->get_stream($query);\n\n    my $blast_result = $index->fetch_report($query);\n    print \"query is \", $blast_result->query_name, \"\\n\";\n    while ( my $hit = $blast_result->next_hit ) {\n        print \"Name \", $hit->name,\"\\n\";\n        while ( my $hsp = $hit->next_hsp ) {\n            print \"Score \", $hsp->score;\n        }\n        print \"\\n\";\n    }\n\n=head1 DESCRIPTION\n\nThis object allows one to build an index on a tabular BLAST file (or files)\nand provide quick access to the blast report for that accession.  This also\nallows for ID parsing using a callback:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /^>.+gi\\|(\\d+)/;\n      $1;\n   }\n\nThe indexer is capable of indexing based on multiple IDs passed back from the\ncallback; this is assuming of course all IDs are unique.\n\nNote: for best results 'use strict'.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Index::BlastTable;\nuse strict;\n\nuse IO::String;\nuse Bio::SearchIO;\nuse base qw(Bio::Index::Abstract Bio::Root::Root);\n\nsub _version {\n\treturn ${Bio::Root::Version::VERSION};\n}\n\n=head2 new\n\n  Usage   : $index = Bio::Index::Abstract->new(\n                -filename    => $dbm_file,\n                -write_flag  => 0,\n                -dbm_package => 'DB_File',\n                -verbose     => 0);\n\n  Function: Returns a new index object.  If filename is\n            specified, then open_dbm() is immediately called. \n            Bio::Index::Abstract->new() will usually be called\n            directly only when opening an existing index.\n  Returns : A new index object\n  Args    : -filename    The name of the dbm index file.\n            -write_flag  TRUE if write access to the dbm file is\n                         needed.\n            -dbm_package The Perl dbm module to use for the\n                         index.\n            -verbose     Print debugging output to STDERR if\n                         TRUE.\n\n\nsub new {\n\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n}\n\n=head2 Bio::Index::Blast implemented methods\n\n\n=head2 fetch_report\n\n Title   : fetch_report\n Usage   : my $blastreport = $idx->fetch_report($id);\n Function: Returns a Bio::SearchIO report object \n           for a specific blast report\n Returns : Bio::SearchIO\n Args    : valid id\n\n\nsub fetch_report{\n\tmy ($self,$id) = @_;\n\tmy $fh = $self->get_stream($id);\n\tmy $report = Bio::SearchIO->new(-noclose => 1,\n\t\t\t\t\t\t\t\t\t-format => 'blasttable',\n\t\t\t\t\t\t            -fh => $fh);\n\treturn $report->next_result;\n}\n\n\n=head2 Require methods from Bio::Index::Abstract\n\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file( $file_name, $i )\n  Function: Specialist function to index BLAST report file(s).\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : ","parameters":[{"label":"$self"},{"label":"$file"},{"label":"$i"}]},"containerName":"main::","definition":"sub"},{"name":"id_parser","range":{"start":{"character":0,"line":237},"end":{"line":244,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,$code)","signature":{"label":"id_parser($self,$code)","parameters":[{"label":"$self"},{"label":"$code"}],"documentation":"1;\n# $Id: BlastTable.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::BlastTable\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields@uiuc.edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::BlastTable - Indexes tabular Blast reports (-m 9 format) and supports\nretrieval based on query accession(s)\n\n=head1 SYNOPSIS\n\n    use strict;\n    use Bio::Index::BlastTable;\n    my ($indexfile,$file1,$file2,$query);\n    my $index = Bio::Index::Blast->new(-filename => $indexfile,\n\t\t\t\t                          -write_flag => 1);\n    $index->make_index($file1,$file2);\n\n    my $data = $index->get_stream($query);\n\n    my $blast_result = $index->fetch_report($query);\n    print \"query is \", $blast_result->query_name, \"\\n\";\n    while ( my $hit = $blast_result->next_hit ) {\n        print \"Name \", $hit->name,\"\\n\";\n        while ( my $hsp = $hit->next_hsp ) {\n            print \"Score \", $hsp->score;\n        }\n        print \"\\n\";\n    }\n\n=head1 DESCRIPTION\n\nThis object allows one to build an index on a tabular BLAST file (or files)\nand provide quick access to the blast report for that accession.  This also\nallows for ID parsing using a callback:\n\n   $inx->id_parser(\\&get_id);\n   # make the index\n   $inx->make_index($file_name);\n\n   # here is where the retrieval key is specified\n   sub get_id {\n      my $line = shift;\n      $line =~ /^>.+gi\\|(\\d+)/;\n      $1;\n   }\n\nThe indexer is capable of indexing based on multiple IDs passed back from the\ncallback; this is assuming of course all IDs are unique.\n\nNote: for best results 'use strict'.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Index::BlastTable;\nuse strict;\n\nuse IO::String;\nuse Bio::SearchIO;\nuse base qw(Bio::Index::Abstract Bio::Root::Root);\n\nsub _version {\n\treturn ${Bio::Root::Version::VERSION};\n}\n\n=head2 new\n\n  Usage   : $index = Bio::Index::Abstract->new(\n                -filename    => $dbm_file,\n                -write_flag  => 0,\n                -dbm_package => 'DB_File',\n                -verbose     => 0);\n\n  Function: Returns a new index object.  If filename is\n            specified, then open_dbm() is immediately called. \n            Bio::Index::Abstract->new() will usually be called\n            directly only when opening an existing index.\n  Returns : A new index object\n  Args    : -filename    The name of the dbm index file.\n            -write_flag  TRUE if write access to the dbm file is\n                         needed.\n            -dbm_package The Perl dbm module to use for the\n                         index.\n            -verbose     Print debugging output to STDERR if\n                         TRUE.\n\n\nsub new {\n\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n}\n\n=head2 Bio::Index::Blast implemented methods\n\n\n=head2 fetch_report\n\n Title   : fetch_report\n Usage   : my $blastreport = $idx->fetch_report($id);\n Function: Returns a Bio::SearchIO report object \n           for a specific blast report\n Returns : Bio::SearchIO\n Args    : valid id\n\n\nsub fetch_report{\n\tmy ($self,$id) = @_;\n\tmy $fh = $self->get_stream($id);\n\tmy $report = Bio::SearchIO->new(-noclose => 1,\n\t\t\t\t\t\t\t\t\t-format => 'blasttable',\n\t\t\t\t\t\t            -fh => $fh);\n\treturn $report->next_result;\n}\n\n\n=head2 Require methods from Bio::Index::Abstract\n\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file( $file_name, $i )\n  Function: Specialist function to index BLAST report file(s).\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : \n\n\nsub _index_file {\n\tmy( $self,\n\t\t $file, # File name\n\t\t $i,    # Index-number of file being indexed\n\t  ) = @_;\n\n\tmy( $begin,  # Offset from start of file of the start\n\t\t          # of the last found record.\n\t  );\n\n\topen(my $BLAST, '<', $file) or $self->throw(\"cannot open file $file\\n\");\n\tmy $indexpoint = 0;\n\tmy $lastline = 0;\n\twhile( <$BLAST> ) {\n\t\tif(m{^#\\s+T?BLAST[PNX]} ) {\n            my $len = length $_;\n            $indexpoint = tell($BLAST)-$len;\n\t\t}\n        if(m{^#\\s+Query:\\s+([^\\n]+)}) {\n            foreach my $id ($self->id_parser()->($1)) {\n\t\t\t\t$self->debug(\"id is $id, begin is $indexpoint\\n\");\n\t\t\t\t$self->add_record($id, $i, $indexpoint);\n\t\t\t}\n        }\n\t}\n}\n\n# shamelessly stolen from Bio::Index::Fasta\n\n=head2 id_parser\n\n  Title   : id_parser\n  Usage   : $index->id_parser( CODE )\n  Function: Stores or returns the code used by record_id to\n            parse the ID for record from a string.  Useful\n            for (for instance) specifying a different\n            parser for different flavours of blast dbs. \n            Returns \\&default_id_parser (see below) if not\n            set. If you supply your own id_parser\n            subroutine, then it should expect a fasta\n            description line.  An entry will be added to\n            the index for each string in the list returned.\n  Example : $index->id_parser( \\&my_id_parser )\n  Returns : ref to CODE if called without arguments\n  Args    : CODE"},"kind":12,"line":237,"children":[{"kind":13,"line":238,"containerName":"id_parser","definition":"my","name":"$self","localvar":"my"},{"containerName":"id_parser","name":"$code","line":238,"kind":13},{"name":"$code","containerName":"id_parser","kind":13,"line":240},{"kind":13,"line":241,"containerName":"id_parser","name":"$self"},{"name":"$code","containerName":"id_parser","kind":13,"line":241},{"containerName":"id_parser","name":"$self","kind":13,"line":243}]},{"name":"default_id_parser","line":243,"kind":12},{"range":{"start":{"character":0,"line":258},"end":{"character":9999,"line":265}},"name":"default_id_parser","definition":"sub","containerName":"main::","children":[],"line":258,"kind":12}]}