{"vars":[{"kind":12,"line":1,"name":"pod"},{"name":"base","containerName":"","kind":2,"line":77},{"line":81,"kind":2,"containerName":"Bio::SeqFeature::Annotated::Bio::Annotation::SimpleValue::Bio::OntologyIO::Scalar","name":"Util"},{"name":"_initialize","range":{"start":{"character":0,"line":103},"end":{"character":9999,"line":117}},"kind":12,"line":103,"children":[{"kind":13,"line":104,"containerName":"_initialize","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":104,"containerName":"_initialize","name":"%arg"},{"kind":13,"line":106,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"%arg","line":106,"kind":13},{"kind":13,"line":108,"name":"$self","containerName":"_initialize"},{"line":108,"kind":12,"name":"name","containerName":"_initialize"},{"line":108,"kind":13,"containerName":"_initialize","name":"$arg"},{"name":"$self","containerName":"_initialize","kind":13,"line":109},{"containerName":"_initialize","name":"description","kind":12,"line":109},{"kind":13,"line":109,"containerName":"_initialize","name":"$arg"},{"line":110,"kind":13,"containerName":"_initialize","name":"$self"},{"kind":12,"line":110,"containerName":"_initialize","name":"use_score"},{"kind":13,"line":110,"name":"$arg","containerName":"_initialize"},{"name":"$self","containerName":"_initialize","line":112,"kind":13},{"line":112,"kind":12,"containerName":"_initialize","name":"_print"},{"containerName":"_initialize","name":"$self","line":113,"kind":13},{"containerName":"_initialize","name":"name","line":113,"kind":12},{"name":"$self","containerName":"_initialize","kind":13,"line":114},{"kind":12,"line":114,"name":"description","containerName":"_initialize"},{"kind":13,"line":115,"containerName":"_initialize","name":"$self"},{"kind":12,"line":115,"name":"use_score","containerName":"_initialize"},{"containerName":"_initialize","name":"$self","kind":13,"line":116},{"name":"mode","containerName":"_initialize","line":116,"kind":12}],"containerName":"main::","definition":"sub","detail":"($self,%arg)","signature":{"label":"_initialize($self,%arg)","documentation":"=head1 NAME\n\nBio::FeatureIO::bed - read/write features from UCSC BED format\n\n=head1 SYNOPSIS\n\n  my $in = Bio::FeatureIO(-format => 'bed', -file => 'file.bed');\n  for my $feat ($in->next_feature) {\n    # do something with $feat (a Bio::SeqFeature::Annotated object)\n  }\n\n  my $out = Bio::FeatureIO(-format=>'bed');\n  for my $feat ($seq->get_seqFeatures) {\n    $out->write_feature($feat);\n  }\n\n=head1 DESCRIPTION\n\nSee L<http://www.genome.ucsc.edu/goldenPath/help/customTrack.html#BED>.\n\nCurrently for read and write only the first 6 fields (chr, start, end, name,\nscore, strand) are supported.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nEmail allenday@ucla.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::FeatureIO::bed;\n\nuse strict;\nuse base qw(Bio::FeatureIO);\nuse Bio::SeqFeature::Annotated;\nuse Bio::Annotation::SimpleValue;\nuse Bio::OntologyIO;\nuse Scalar::Util qw(looks_like_number);\n\n=head2 _initialize\n\n Title   : _initialize\n Function: initializes BED for reading/writing\n Args    : all optional:\n           name          description\n           ----------------------------------------------------------\n           -name         the name for the BED track, stored in header\n                         name defaults to localtime()\n           -description  the description for the BED track, stored in\n                         header.  defaults to localtime().\n           -use_score    whether or not the score attribute of\n                         features should be used when rendering them.\n                         the higher the score the darker the color.\n                         defaults to 0 (false)","parameters":[{"label":"$self"},{"label":"%arg"}]}},{"kind":12,"line":106,"name":"SUPER","containerName":"_initialize"},{"children":[{"line":132,"kind":13,"localvar":"my","containerName":"use_score","name":"$self","definition":"my"},{"containerName":"use_score","name":"$self","line":134,"kind":13},{"containerName":"use_score","name":"$self","line":135,"kind":13}],"line":131,"kind":12,"range":{"end":{"line":136,"character":9999},"start":{"character":0,"line":131}},"name":"use_score","definition":"sub","containerName":"main::"},{"containerName":"main::","name":"name","definition":"sub","range":{"end":{"character":9999,"line":155},"start":{"character":0,"line":150}},"kind":12,"line":150,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"name","line":151,"kind":13},{"name":"$self","containerName":"name","line":153,"kind":13},{"kind":13,"line":154,"name":"$self","containerName":"name"}]},{"range":{"end":{"character":9999,"line":174},"start":{"character":0,"line":169}},"definition":"sub","name":"description","containerName":"main::","children":[{"kind":13,"line":170,"definition":"my","name":"$self","containerName":"description","localvar":"my"},{"containerName":"description","name":"$self","kind":13,"line":172},{"kind":13,"line":173,"containerName":"description","name":"$self"}],"line":169,"kind":12},{"name":"write_feature","range":{"end":{"character":9999,"line":216},"start":{"character":0,"line":177}},"kind":12,"line":177,"children":[{"line":178,"kind":13,"localvar":"my","containerName":"write_feature","name":"$self","definition":"my"},{"containerName":"write_feature","name":"$feature","line":178,"kind":13},{"containerName":"write_feature","name":"$self","kind":13,"line":179},{"name":"throw","containerName":"write_feature","kind":12,"line":179},{"containerName":"write_feature","name":"$feature","line":179,"kind":13},{"kind":12,"line":179,"containerName":"write_feature","name":"isa"},{"containerName":"write_feature","definition":"my","name":"$chrom","localvar":"my","kind":13,"line":181},{"kind":13,"line":181,"name":"$feature","containerName":"write_feature"},{"name":"seq_id","containerName":"write_feature","kind":12,"line":181},{"line":182,"kind":13,"localvar":"my","containerName":"write_feature","definition":"my","name":"$chrom_start"},{"name":"$feature","containerName":"write_feature","line":182,"kind":13},{"kind":12,"line":182,"containerName":"write_feature","name":"start"},{"kind":13,"line":183,"containerName":"write_feature","name":"$chrom_end","definition":"my","localvar":"my"},{"containerName":"write_feature","name":"$feature","line":183,"kind":13},{"line":183,"kind":12,"name":"end","containerName":"write_feature"},{"name":"$name","definition":"my","containerName":"write_feature","localvar":"my","kind":13,"line":186},{"kind":13,"line":187,"containerName":"write_feature","definition":"my","name":"@v","localvar":"my"},{"name":"@v","containerName":"write_feature","line":188,"kind":13},{"kind":13,"line":188,"name":"$feature","containerName":"write_feature"},{"name":"annotation","containerName":"write_feature","kind":12,"line":188},{"name":"get_Annotations","containerName":"write_feature","kind":12,"line":188},{"name":"$name","containerName":"write_feature","kind":13,"line":189},{"name":"$v","containerName":"write_feature","kind":13,"line":189},{"line":190,"kind":13,"name":"$self","containerName":"write_feature"},{"containerName":"write_feature","name":"warn","kind":12,"line":190},{"containerName":"write_feature","name":"value","line":190,"kind":12},{"line":190,"kind":13,"containerName":"write_feature","name":"@v"},{"name":"@v","containerName":"write_feature","line":190,"kind":13},{"name":"@v","containerName":"write_feature","kind":13,"line":191},{"line":191,"kind":13,"containerName":"write_feature","name":"$feature"},{"kind":12,"line":191,"name":"annotation","containerName":"write_feature"},{"name":"get_Annotations","containerName":"write_feature","line":191,"kind":12},{"containerName":"write_feature","name":"$name","line":192,"kind":13},{"kind":13,"line":192,"containerName":"write_feature","name":"$v"},{"line":193,"kind":13,"containerName":"write_feature","name":"$self"},{"kind":12,"line":193,"containerName":"write_feature","name":"warn"},{"name":"value","containerName":"write_feature","line":193,"kind":12},{"line":193,"kind":13,"containerName":"write_feature","name":"@v"},{"name":"@v","containerName":"write_feature","line":193,"kind":13},{"containerName":"write_feature","name":"$name","kind":13,"line":195},{"kind":13,"line":198,"name":"$name","containerName":"write_feature"},{"line":199,"kind":13,"containerName":"write_feature","name":"$name"},{"containerName":"write_feature","name":"$name","line":199,"kind":13},{"containerName":"write_feature","name":"value","line":199,"kind":12},{"containerName":"write_feature","name":"$chrom","line":201,"kind":13},{"kind":13,"line":202,"name":"$chrom","containerName":"write_feature"},{"containerName":"write_feature","name":"$chrom","kind":13,"line":202},{"name":"value","containerName":"write_feature","kind":12,"line":202},{"containerName":"write_feature","name":"$score","definition":"my","localvar":"my","kind":13,"line":205},{"kind":13,"line":205,"containerName":"write_feature","name":"$feature"},{"containerName":"write_feature","name":"score","line":205,"kind":12},{"localvar":"my","name":"$strand","definition":"my","containerName":"write_feature","line":206,"kind":13},{"containerName":"write_feature","name":"$feature","line":206,"kind":13},{"line":206,"kind":12,"name":"strand","containerName":"write_feature"},{"localvar":"my","containerName":"write_feature","definition":"my","name":"$thick_start","line":207,"kind":13},{"kind":13,"line":208,"name":"$thick_end","definition":"my","containerName":"write_feature","localvar":"my"},{"localvar":"my","containerName":"write_feature","definition":"my","name":"$reserved","line":209,"kind":13},{"localvar":"my","name":"$block_count","definition":"my","containerName":"write_feature","line":210,"kind":13},{"line":211,"kind":13,"localvar":"my","containerName":"write_feature","definition":"my","name":"$block_sizes"},{"localvar":"my","containerName":"write_feature","definition":"my","name":"$block_starts","line":212,"kind":13},{"containerName":"write_feature","name":"$self","line":214,"kind":13},{"containerName":"write_feature","name":"_print","kind":12,"line":214},{"name":"$chrom","containerName":"write_feature","line":214,"kind":13},{"name":"$chrom_start","containerName":"write_feature","line":214,"kind":13},{"line":214,"kind":13,"name":"$chrom_end","containerName":"write_feature"},{"line":214,"kind":13,"containerName":"write_feature","name":"$name"},{"containerName":"write_feature","name":"$score","kind":13,"line":214},{"containerName":"write_feature","name":"$strand","line":214,"kind":13},{"containerName":"write_feature","name":"$thick_start","line":214,"kind":13},{"containerName":"write_feature","name":"$thick_end","kind":13,"line":214},{"containerName":"write_feature","name":"$reserved","kind":13,"line":214},{"containerName":"write_feature","name":"$block_count","kind":13,"line":214},{"containerName":"write_feature","name":"$block_sizes","kind":13,"line":214},{"kind":13,"line":214,"name":"$block_starts","containerName":"write_feature"},{"line":215,"kind":13,"name":"$self","containerName":"write_feature"},{"containerName":"write_feature","name":"write_feature","kind":12,"line":215},{"kind":13,"line":215,"containerName":"write_feature","name":"$feature"},{"line":215,"kind":12,"containerName":"write_feature","name":"get_SeqFeatures"}],"containerName":"main::","definition":"sub","detail":"($self,$feature)","signature":{"label":"write_feature($self,$feature)","documentation":"","parameters":[{"label":"$self"},{"label":"$feature"}]}},{"line":218,"children":[{"definition":"my","name":"$self","containerName":"next_feature","localvar":"my","kind":13,"line":219},{"line":220,"kind":13,"localvar":"my","name":"$line","definition":"my","containerName":"next_feature"},{"line":220,"kind":13,"name":"$self","containerName":"next_feature"},{"name":"_readline","containerName":"next_feature","line":220,"kind":12},{"localvar":"my","name":"$seq_id","definition":"my","containerName":"next_feature","line":222,"kind":13},{"name":"$start","containerName":"next_feature","line":222,"kind":13},{"line":222,"kind":13,"name":"$end","containerName":"next_feature"},{"line":222,"kind":13,"containerName":"next_feature","name":"$name"},{"kind":13,"line":222,"name":"$score","containerName":"next_feature"},{"containerName":"next_feature","name":"$strand","line":222,"kind":13},{"kind":13,"line":222,"containerName":"next_feature","name":"$line"},{"containerName":"next_feature","name":"$strand","kind":13,"line":223},{"kind":13,"line":225,"containerName":"next_feature","name":"$start"},{"containerName":"next_feature","name":"$end","line":225,"kind":13},{"line":227,"kind":13,"name":"$self","containerName":"next_feature"},{"line":227,"kind":12,"name":"next_feature","containerName":"next_feature"},{"containerName":"next_feature","definition":"my","name":"$feature","localvar":"my","kind":13,"line":230},{"containerName":"next_feature","name":"new","line":230,"kind":12},{"containerName":"next_feature","name":"$start","kind":13,"line":230},{"name":"$end","containerName":"next_feature","line":231,"kind":13},{"containerName":"next_feature","name":"$score","kind":13,"line":232},{"line":232,"kind":13,"name":"$score","containerName":"next_feature"},{"containerName":"next_feature","name":"$strand","line":233,"kind":13},{"kind":13,"line":233,"containerName":"next_feature","name":"$strand"},{"kind":13,"line":235,"containerName":"next_feature","name":"$feature"},{"kind":12,"line":235,"name":"seq_id","containerName":"next_feature"},{"kind":13,"line":235,"name":"$seq_id","containerName":"next_feature"},{"name":"$name","containerName":"next_feature","line":236,"kind":13},{"kind":13,"line":237,"containerName":"next_feature","name":"$sv","definition":"my","localvar":"my"},{"kind":12,"line":237,"name":"new","containerName":"next_feature"},{"kind":13,"line":237,"containerName":"next_feature","name":"$name"},{"line":238,"kind":13,"containerName":"next_feature","name":"$feature"},{"name":"annotation","containerName":"next_feature","kind":12,"line":238},{"line":238,"kind":12,"containerName":"next_feature","name":"add_Annotation"},{"containerName":"next_feature","name":"$sv","line":238,"kind":13},{"kind":13,"line":241,"name":"$feature","containerName":"next_feature"}],"kind":12,"range":{"start":{"character":0,"line":218},"end":{"line":242,"character":9999}},"containerName":"main::","definition":"sub","name":"next_feature"},{"line":225,"kind":12,"name":"looks_like_number"},{"line":225,"kind":12,"name":"looks_like_number"},{"line":230,"kind":12,"name":"Bio","containerName":"SeqFeature::Annotated"},{"containerName":"Annotation::SimpleValue","name":"Bio","line":237,"kind":12}],"version":5}