{"vars":[{"name":"base","containerName":"","kind":2,"line":97},{"kind":12,"line":112,"children":[{"line":113,"kind":13,"localvar":"my","name":"$class","definition":"my","containerName":"new"},{"containerName":"new","name":"@args","line":113,"kind":13},{"kind":13,"line":115,"definition":"my","name":"$self","containerName":"new","localvar":"my"},{"containerName":"new","name":"$class","kind":13,"line":115},{"containerName":"new","name":"@args","kind":13,"line":115},{"containerName":"new","name":"$self","line":117,"kind":13},{"kind":12,"line":117,"name":"interface","containerName":"new"},{"line":118,"kind":13,"containerName":"new","name":"$self"},{"line":118,"kind":12,"name":"type","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":118},{"containerName":"new","name":"type","line":118,"kind":12},{"containerName":"new","name":"$self","line":118,"kind":13},{"name":"type","containerName":"new","line":118,"kind":12},{"name":"$self","containerName":"new","line":120,"kind":13}],"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: ClusterFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::ClusterFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::ClusterFactory - Instantiates a new Bio::ClusterI (or derived class) through a factory\n\n=head1 SYNOPSIS\n\n    use Bio::Cluster::ClusterFactory;\n    # if you don't provide a default type, the factory will try\n    # some guesswork based on display_id and namespace\n    my $factory = Bio::Cluster::ClusterFactory->new(-type => 'Bio::Cluster::UniGene');\n    my $clu = $factory->create_object(-description => 'NAT',\n                                      -display_id  => 'Hs.2');\n\n\n=head1 DESCRIPTION\n\nThis object will build L<Bio::ClusterI> objects generically.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::ClusterFactory;\nuse strict;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Factory::ObjectFactory);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Cluster::ClusterFactory->new();\n Function: Builds a new Bio::Cluster::ClusterFactory object \n Returns : Bio::Cluster::ClusterFactory\n Args    : -type => string, name of a ClusterI derived class.\n                    If not provided, the factory will have to guess\n                    from ID and namespace, which may or may not be\n                    successful.","parameters":[{"label":"$class"},{"label":"@args"}]},"name":"new","range":{"end":{"character":9999,"line":121},"start":{"line":112,"character":0}}},{"containerName":"new","name":"SUPER","line":115,"kind":12},{"name":"create_object","range":{"end":{"line":154,"character":9999},"start":{"line":143,"character":0}},"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: ClusterFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::ClusterFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::ClusterFactory - Instantiates a new Bio::ClusterI (or derived class) through a factory\n\n=head1 SYNOPSIS\n\n    use Bio::Cluster::ClusterFactory;\n    # if you don't provide a default type, the factory will try\n    # some guesswork based on display_id and namespace\n    my $factory = Bio::Cluster::ClusterFactory->new(-type => 'Bio::Cluster::UniGene');\n    my $clu = $factory->create_object(-description => 'NAT',\n                                      -display_id  => 'Hs.2');\n\n\n=head1 DESCRIPTION\n\nThis object will build L<Bio::ClusterI> objects generically.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::ClusterFactory;\nuse strict;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Factory::ObjectFactory);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Cluster::ClusterFactory->new();\n Function: Builds a new Bio::Cluster::ClusterFactory object \n Returns : Bio::Cluster::ClusterFactory\n Args    : -type => string, name of a ClusterI derived class.\n                    If not provided, the factory will have to guess\n                    from ID and namespace, which may or may not be\n                    successful.\n\n\nsub new {\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    $self->interface(\"Bio::ClusterI\");\n    $self->type($self->type) if $self->type;\n\n    return $self;\n}\n\n\n=head2 create_object\n\n Title   : create_object\n Usage   : my $seq = $factory->create_object(<named parameters>);\n Function: Instantiates new Bio::ClusterI (or one of its child classes)\n\n           This object allows us to genericize the instantiation of\n           cluster objects.\n\n Returns : L<Bio::ClusterI> compliant object\n           The return type is configurable using new(-type =>\"...\").\n Args    : initialization parameters specific to the type of cluster\n           object we want.  Typically \n           -display_id  => $name\n           -description => description of the cluster\n           -members     => arrayref, members of the cluster","label":"create_object($self,@args)"},"kind":12,"line":143,"children":[{"line":144,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"create_object"},{"name":"@args","containerName":"create_object","line":144,"kind":13},{"kind":13,"line":146,"containerName":"create_object","definition":"my","name":"$type","localvar":"my"},{"line":146,"kind":13,"name":"$self","containerName":"create_object"},{"kind":12,"line":146,"name":"type","containerName":"create_object"},{"name":"$type","containerName":"create_object","kind":13,"line":147},{"line":149,"kind":13,"name":"$type","containerName":"create_object"},{"line":149,"kind":13,"name":"$self","containerName":"create_object"},{"kind":12,"line":149,"name":"_guess_type","containerName":"create_object"},{"name":"@args","containerName":"create_object","line":149,"kind":13},{"kind":13,"line":150,"containerName":"create_object","name":"$self"},{"line":150,"kind":12,"name":"throw","containerName":"create_object"},{"name":"$type","containerName":"create_object","line":150,"kind":13},{"containerName":"create_object","name":"$self","line":151,"kind":13},{"containerName":"create_object","name":"type","line":151,"kind":12},{"name":"$type","containerName":"create_object","line":151,"kind":13},{"name":"$type","containerName":"create_object","kind":13,"line":153},{"name":"new","containerName":"create_object","line":153,"kind":12},{"name":"$self","containerName":"create_object","kind":13,"line":153},{"line":153,"kind":12,"name":"verbose","containerName":"create_object"},{"containerName":"create_object","name":"@args","line":153,"kind":13}]},{"name":"_guess_type","range":{"start":{"character":0,"line":171},"end":{"character":9999,"line":189}},"kind":12,"line":171,"children":[{"localvar":"my","containerName":"_guess_type","name":"$self","definition":"my","line":172,"kind":13},{"name":"@args","containerName":"_guess_type","line":172,"kind":13},{"localvar":"my","name":"$type","definition":"my","containerName":"_guess_type","line":173,"kind":13},{"line":176,"kind":13,"localvar":"my","definition":"my","name":"$dispid","containerName":"_guess_type"},{"line":176,"kind":13,"name":"$ns","containerName":"_guess_type"},{"kind":13,"line":176,"containerName":"_guess_type","name":"$members"},{"containerName":"_guess_type","name":"$self","line":177,"kind":13},{"kind":12,"line":177,"name":"_rearrange","containerName":"_guess_type"},{"containerName":"_guess_type","name":"@args","kind":13,"line":180},{"line":182,"kind":13,"name":"$ns","containerName":"_guess_type"},{"line":182,"kind":13,"containerName":"_guess_type","name":"$ns"},{"kind":13,"line":183,"name":"$type","containerName":"_guess_type"},{"line":184,"kind":13,"containerName":"_guess_type","name":"$dispid"},{"name":"$dispid","containerName":"_guess_type","kind":13,"line":184},{"kind":13,"line":185,"containerName":"_guess_type","name":"$type"},{"containerName":"_guess_type","name":"$type","line":188,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"_guess_type($self,@args)","documentation":"1;\n# $Id: ClusterFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::ClusterFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::ClusterFactory - Instantiates a new Bio::ClusterI (or derived class) through a factory\n\n=head1 SYNOPSIS\n\n    use Bio::Cluster::ClusterFactory;\n    # if you don't provide a default type, the factory will try\n    # some guesswork based on display_id and namespace\n    my $factory = Bio::Cluster::ClusterFactory->new(-type => 'Bio::Cluster::UniGene');\n    my $clu = $factory->create_object(-description => 'NAT',\n                                      -display_id  => 'Hs.2');\n\n\n=head1 DESCRIPTION\n\nThis object will build L<Bio::ClusterI> objects generically.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::ClusterFactory;\nuse strict;\n\nuse Bio::Root::Root;\n\nuse base qw(Bio::Factory::ObjectFactory);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Cluster::ClusterFactory->new();\n Function: Builds a new Bio::Cluster::ClusterFactory object \n Returns : Bio::Cluster::ClusterFactory\n Args    : -type => string, name of a ClusterI derived class.\n                    If not provided, the factory will have to guess\n                    from ID and namespace, which may or may not be\n                    successful.\n\n\nsub new {\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    $self->interface(\"Bio::ClusterI\");\n    $self->type($self->type) if $self->type;\n\n    return $self;\n}\n\n\n=head2 create_object\n\n Title   : create_object\n Usage   : my $seq = $factory->create_object(<named parameters>);\n Function: Instantiates new Bio::ClusterI (or one of its child classes)\n\n           This object allows us to genericize the instantiation of\n           cluster objects.\n\n Returns : L<Bio::ClusterI> compliant object\n           The return type is configurable using new(-type =>\"...\").\n Args    : initialization parameters specific to the type of cluster\n           object we want.  Typically \n           -display_id  => $name\n           -description => description of the cluster\n           -members     => arrayref, members of the cluster\n\n\nsub create_object {\n   my ($self,@args) = @_;\n\n   my $type = $self->type();\n   if(! $type) {\n       # we need to guess this\n       $type = $self->_guess_type(@args);\n       $self->throw(\"No cluster type set and unable to guess.\") unless $type;\n       $self->type($type);\n   }\n   return $type->new(-verbose => $self->verbose, @args);\n}\n\n=head2 _guess_type\n\n Title   : _guess_type\n Usage   :\n Function: Guesses the right type of L<Bio::ClusterI> implementation\n           based on initialization parameters for the prospective\n           object.\n Example :\n Returns : the type (a string, the module name)\n Args    : initialization parameters to be passed to the prospective\n           cluster object","parameters":[{"label":"$self"},{"label":"@args"}]}}],"version":5}