{"vars":[{"name":"base","containerName":"","line":95,"kind":2},{"containerName":"main::","definition":"sub","detail":"($caller,@args)","signature":{"label":"new($caller,@args)","documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::IO\n#\n#   based on the Bio::SeqIO module\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::IO - Handler for Assembly::IO Formats\n\n=head1 SYNOPSIS\n\n    use Bio::Assembly::IO;\n\n    $in  = Bio::Assembly::IO->new(-file=>\"<inputfilename\",\n                                  -format=>'phrap');\n    $out = Bio::Assembly::IO->new(-file=>\">outputfilename\",\n                                  -format=>'phrap');\n\n    while ( my $scaffold = $in->next_assembly() ) {\n       # do something with Bio::Assembly::Scaffold instance\n       # ...\n       $out->write_assembly(-scaffold => $scaffold);\n    }\n\n    $in->close;\n    $out->close;\n\n=head1 DESCRIPTION\n\nBio::Assembly::IO is a handler module for formats in the Assembly::IO set\n(e.g. Bio::Assembly::IO::phrap).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nRobson Francisco de Souza\n\nE-mail: rfsouza@citri.iq.usp.br\n\n=head1 CONTRIBUTORS\n\n#\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::IO;\n\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : Bio::Assembly::IO->new(-file =>$filename,-format=>'format')\n Function: Returns a new assembly stream\n Returns : A Bio::Assembly::IO::Handler initialised\n           with the appropriate format\n Args    : -file => $filename\n           -format => format","parameters":[{"label":"$caller"},{"label":"@args"}]},"kind":12,"line":109,"children":[{"localvar":"my","definition":"my","name":"$caller","containerName":"new","line":110,"kind":13},{"containerName":"new","name":"@args","kind":13,"line":110},{"kind":13,"line":111,"name":"$class","definition":"my","containerName":"new","localvar":"my"},{"kind":13,"line":111,"name":"$caller","containerName":"new"},{"line":111,"kind":13,"name":"$caller","containerName":"new"},{"line":115,"kind":13,"containerName":"new","name":"$class"},{"line":116,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"new"},{"name":"$class","containerName":"new","kind":13,"line":116},{"line":116,"kind":13,"name":"@args","containerName":"new"},{"containerName":"new","name":"$self","line":117,"kind":13},{"name":"_initialize","containerName":"new","line":117,"kind":12},{"name":"@args","containerName":"new","line":117,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":118},{"kind":13,"line":121,"containerName":"new","definition":"my","name":"%param","localvar":"my"},{"kind":13,"line":121,"name":"@args","containerName":"new"},{"containerName":"new","name":"@param","kind":13,"line":122},{"kind":13,"line":122,"containerName":"new","name":"%param"},{"containerName":"new","name":"%param","line":122,"kind":13},{"containerName":"new","name":"$class","line":124,"kind":13},{"line":124,"kind":12,"name":"throw","containerName":"new"},{"name":"$param","containerName":"new","kind":13,"line":125},{"containerName":"new","name":"$ARGV","kind":13,"line":125},{"kind":13,"line":127,"definition":"my","name":"$format","containerName":"new","localvar":"my"},{"name":"$param","containerName":"new","kind":13,"line":127},{"containerName":"new","name":"$class","kind":13,"line":128},{"containerName":"new","name":"_guess_format","line":128,"kind":12},{"line":128,"kind":13,"name":"$param","containerName":"new"},{"containerName":"new","name":"$ARGV","line":128,"kind":13},{"kind":13,"line":129,"containerName":"new","name":"$format"},{"containerName":"new","name":"$class","kind":13,"line":132},{"name":"_load_format_module","containerName":"new","line":132,"kind":12},{"name":"$format","containerName":"new","line":132,"kind":13},{"kind":12,"line":133,"name":"new","containerName":"new"},{"containerName":"new","name":"@args","line":133,"kind":13}],"name":"new","range":{"start":{"character":0,"line":109},"end":{"line":135,"character":9999}}},{"containerName":"new","name":"SUPER","line":116,"kind":12},{"name":"_initialize","range":{"end":{"character":9999,"line":143},"start":{"character":0,"line":139}},"definition":"sub","containerName":"main::","signature":{"label":"_initialize($self,@args)","documentation":" _initialize is chained for all SeqIO classes","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","kind":12,"children":[{"line":140,"kind":13,"localvar":"my","containerName":"_initialize","definition":"my","name":"$self"},{"line":140,"kind":13,"name":"@args","containerName":"_initialize"},{"containerName":"_initialize","name":"$self","line":142,"kind":13},{"kind":12,"line":142,"name":"_initialize_io","containerName":"_initialize"},{"kind":13,"line":142,"name":"@args","containerName":"_initialize"}],"line":139},{"name":"next_assembly","range":{"end":{"character":9999,"line":158},"start":{"line":155,"character":0}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::IO\n#\n#   based on the Bio::SeqIO module\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::IO - Handler for Assembly::IO Formats\n\n=head1 SYNOPSIS\n\n    use Bio::Assembly::IO;\n\n    $in  = Bio::Assembly::IO->new(-file=>\"<inputfilename\",\n                                  -format=>'phrap');\n    $out = Bio::Assembly::IO->new(-file=>\">outputfilename\",\n                                  -format=>'phrap');\n\n    while ( my $scaffold = $in->next_assembly() ) {\n       # do something with Bio::Assembly::Scaffold instance\n       # ...\n       $out->write_assembly(-scaffold => $scaffold);\n    }\n\n    $in->close;\n    $out->close;\n\n=head1 DESCRIPTION\n\nBio::Assembly::IO is a handler module for formats in the Assembly::IO set\n(e.g. Bio::Assembly::IO::phrap).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nRobson Francisco de Souza\n\nE-mail: rfsouza@citri.iq.usp.br\n\n=head1 CONTRIBUTORS\n\n#\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::IO;\n\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : Bio::Assembly::IO->new(-file =>$filename,-format=>'format')\n Function: Returns a new assembly stream\n Returns : A Bio::Assembly::IO::Handler initialised\n           with the appropriate format\n Args    : -file => $filename\n           -format => format\n\n\nsub new {\n    my ($caller,@args) = @_;\n    my $class = ref($caller) || $caller;\n\n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::Assembly::IO::(\\S+)/ ) {\n\tmy ($self) = $class->SUPER::new(@args);\n\t$self->_initialize(@args);\n\treturn $self;\n    } else {\n\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\n\t$class->throw(\"Need at least a file name to proceed!\")\n\t    unless (defined $param{'-file'} || defined $ARGV[0]);\n\n\tmy $format = $param{'-format'} ||\n\t    $class->_guess_format( $param{-file} || $ARGV[0] );\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\n\t# normalize capitalization\n\treturn unless( $class->_load_format_module($format) );\n\treturn \"Bio::Assembly::IO::$format\"->new(@args);\n    }\n}\n\n# _initialize is chained for all SeqIO classes\n\nsub _initialize {\n    my($self, @args) = @_;\n    # initialize the IO part\n    $self->_initialize_io(@args);\n}\n\n=head2 next_assembly\n\n Title   : next_assembly\n Usage   : $cluster = $stream->next_assembly()\n Function: Reads the next assembly object from the stream and returns it.\n Returns : a Bio::Assembly::ScaffoldI compliant object\n Args    : none","parameters":[{"label":"$self"},{"label":"$seq"}],"label":"next_assembly($self,$seq)"},"detail":"($self,$seq)","kind":12,"children":[{"localvar":"my","containerName":"next_assembly","name":"$self","definition":"my","line":156,"kind":13},{"line":156,"kind":13,"name":"$seq","containerName":"next_assembly"},{"containerName":"next_assembly","name":"$self","kind":13,"line":157},{"containerName":"next_assembly","name":"throw","line":157,"kind":12}],"line":155},{"name":"write_assembly","definition":"sub","containerName":"main::","range":{"end":{"line":172,"character":9999},"start":{"line":170,"character":0}},"kind":12,"children":[{"containerName":"write_assembly","name":"throw_not_implemented","kind":12,"line":171}],"line":170},{"definition":"sub","containerName":"main::","signature":{"label":"_load_format_module($self,$format)","parameters":[{"label":"$self"},{"label":"$format"}],"documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::IO\n#\n#   based on the Bio::SeqIO module\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#\n# Copyright Robson Francisco de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::IO - Handler for Assembly::IO Formats\n\n=head1 SYNOPSIS\n\n    use Bio::Assembly::IO;\n\n    $in  = Bio::Assembly::IO->new(-file=>\"<inputfilename\",\n                                  -format=>'phrap');\n    $out = Bio::Assembly::IO->new(-file=>\">outputfilename\",\n                                  -format=>'phrap');\n\n    while ( my $scaffold = $in->next_assembly() ) {\n       # do something with Bio::Assembly::Scaffold instance\n       # ...\n       $out->write_assembly(-scaffold => $scaffold);\n    }\n\n    $in->close;\n    $out->close;\n\n=head1 DESCRIPTION\n\nBio::Assembly::IO is a handler module for formats in the Assembly::IO set\n(e.g. Bio::Assembly::IO::phrap).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nRobson Francisco de Souza\n\nE-mail: rfsouza@citri.iq.usp.br\n\n=head1 CONTRIBUTORS\n\n#\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::IO;\n\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : Bio::Assembly::IO->new(-file =>$filename,-format=>'format')\n Function: Returns a new assembly stream\n Returns : A Bio::Assembly::IO::Handler initialised\n           with the appropriate format\n Args    : -file => $filename\n           -format => format\n\n\nsub new {\n    my ($caller,@args) = @_;\n    my $class = ref($caller) || $caller;\n\n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::Assembly::IO::(\\S+)/ ) {\n\tmy ($self) = $class->SUPER::new(@args);\n\t$self->_initialize(@args);\n\treturn $self;\n    } else {\n\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\n\t$class->throw(\"Need at least a file name to proceed!\")\n\t    unless (defined $param{'-file'} || defined $ARGV[0]);\n\n\tmy $format = $param{'-format'} ||\n\t    $class->_guess_format( $param{-file} || $ARGV[0] );\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\n\t# normalize capitalization\n\treturn unless( $class->_load_format_module($format) );\n\treturn \"Bio::Assembly::IO::$format\"->new(@args);\n    }\n}\n\n# _initialize is chained for all SeqIO classes\n\nsub _initialize {\n    my($self, @args) = @_;\n    # initialize the IO part\n    $self->_initialize_io(@args);\n}\n\n=head2 next_assembly\n\n Title   : next_assembly\n Usage   : $cluster = $stream->next_assembly()\n Function: Reads the next assembly object from the stream and returns it.\n Returns : a Bio::Assembly::ScaffoldI compliant object\n Args    : none\n\n\nsub next_assembly {\n   my ($self, $seq) = @_;\n   $self->throw(\"Sorry, you cannot read from a generic Bio::Assembly::IO object.\");\n}\n\n=head2 write_assembly\n\n  Title   : write_assembly\n  Usage   : $ass_io->write_assembly($assembly)\n  Function: Write the assembly object in Phrap compatible ACE format\n  Returns : 1 on success, 0 for error\n  Args    : A Bio::Assembly::Scaffold object\n\n\nsub write_assembly {\n   shift->throw_not_implemented;\n}\n\n=head2 _load_format_module\n\n Title   : _load_format_module\n Usage   : *INTERNAL Assembly::IO stuff*\n Function: Loads up (like use) a module at run time on demand\n Example :\n Returns :\n Args    :"},"detail":"($self,$format)","kind":12,"children":[{"kind":13,"line":186,"definition":"my","name":"$self","containerName":"_load_format_module","localvar":"my"},{"kind":13,"line":186,"name":"$format","containerName":"_load_format_module"},{"containerName":"_load_format_module","name":"$module","definition":"my","localvar":"my","kind":13,"line":187},{"containerName":"_load_format_module","name":"$format","line":187,"kind":13},{"line":188,"kind":13,"localvar":"my","containerName":"_load_format_module","definition":"my","name":"$ok"},{"line":191,"kind":13,"name":"$ok","containerName":"_load_format_module"},{"line":191,"kind":13,"name":"$self","containerName":"_load_format_module"},{"containerName":"_load_format_module","name":"_load_module","kind":12,"line":191},{"name":"$module","containerName":"_load_format_module","kind":13,"line":191},{"kind":13,"line":200,"containerName":"_load_format_module","name":"$ok"}],"line":185,"name":"_load_format_module","range":{"end":{"character":9999,"line":201},"start":{"line":185,"character":0}}},{"name":"_guess_format","definition":"sub","containerName":"main::","range":{"end":{"line":223,"character":9999},"start":{"line":216,"character":0}},"kind":12,"children":[{"localvar":"my","containerName":"_guess_format","definition":"my","name":"$class","line":217,"kind":13},{"localvar":"my","name":"$arg","definition":"my","containerName":"_guess_format","line":218,"kind":13},{"containerName":"_guess_format","name":"$arg","kind":13,"line":220},{"line":221,"kind":13,"name":"$arg","containerName":"_guess_format"},{"name":"$arg","containerName":"_guess_format","line":222,"kind":13}],"line":216},{"kind":12,"children":[{"kind":13,"line":226,"name":"$self","definition":"my","containerName":"DESTROY","localvar":"my"},{"name":"$self","containerName":"DESTROY","kind":13,"line":228},{"line":228,"kind":12,"name":"close","containerName":"DESTROY"}],"line":225,"definition":"sub","name":"DESTROY","containerName":"main::","range":{"end":{"line":229,"character":9999},"start":{"character":0,"line":225}}},{"kind":12,"line":234,"children":[{"kind":13,"line":235,"containerName":"TIEHANDLE","definition":"my","name":"$class","localvar":"my"},{"line":235,"kind":13,"name":"$val","containerName":"TIEHANDLE"},{"line":236,"kind":13,"containerName":"TIEHANDLE","name":"$val"},{"containerName":"TIEHANDLE","name":"$class","line":236,"kind":13}],"containerName":"main::","definition":"sub","detail":"($class,$val)","signature":{"parameters":[{"label":"$class"},{"label":"$val"}],"documentation":" I need some direction on these!! The module works so I haven't fiddled with them!\n Me neither! (rfsouza)","label":"TIEHANDLE($class,$val)"},"name":"TIEHANDLE","range":{"start":{"line":234,"character":0},"end":{"character":9999,"line":237}}},{"kind":12,"children":[{"kind":13,"line":240,"definition":"my","name":"$self","containerName":"READLINE","localvar":"my"},{"name":"$self","containerName":"READLINE","line":241,"kind":13},{"containerName":"READLINE","name":"next_seq","line":241,"kind":12},{"containerName":"READLINE","name":"@list","definition":"my","localvar":"my","kind":13,"line":242},{"line":242,"kind":13,"containerName":"READLINE","name":"$obj"},{"containerName":"READLINE","name":"@list","kind":13,"line":243},{"line":243,"kind":13,"name":"$obj","containerName":"READLINE"},{"line":243,"kind":13,"name":"$obj","containerName":"READLINE"},{"line":243,"kind":13,"containerName":"READLINE","name":"$self"},{"containerName":"READLINE","name":"next_seq","line":243,"kind":12},{"kind":13,"line":244,"containerName":"READLINE","name":"@list"}],"line":239,"definition":"sub","name":"READLINE","containerName":"main::","range":{"start":{"line":239,"character":0},"end":{"line":245,"character":9999}}},{"name":"PRINT","definition":"sub","containerName":"main::","range":{"start":{"line":247,"character":0},"end":{"line":250,"character":9999}},"kind":12,"children":[{"localvar":"my","containerName":"PRINT","definition":"my","name":"$self","line":248,"kind":13},{"name":"$self","containerName":"PRINT","kind":13,"line":249},{"name":"write_seq","containerName":"PRINT","kind":12,"line":249}],"line":247}],"version":5}