{"version":5,"vars":[{"kind":2,"line":113,"name":"base","containerName":""},{"detail":"($class,@args)","signature":{"documentation":"1;\n# $Id: OntologyTerm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::OntologyTerm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::OntologyTerm - An ontology term adapted to AnnotationI\n\n=head1 SYNOPSIS\n\n   use Bio::Annotation::OntologyTerm;\n   use Bio::Annotation::Collection;\n   use Bio::Ontology::Term;\n\n   my $coll = Bio::Annotation::Collection->new();\n\n   # this also implements a tag/value pair, where tag _and_ value are treated\n   # as ontology terms\n   my $annterm = Bio::Annotation::OntologyTerm->new(-label => 'ABC1',\n                                                   -tagname => 'Gene Name');\n   # ontology terms can be added directly - they implicitly have a tag\n   $coll->add_Annotation($annterm);\n\n   # implementation is by composition - you can get/set the term object\n   # e.g.\n   my $term = $annterm->term(); # term is-a Bio::Ontology::TermI\n   print \"ontology term \",$term->name(),\" (ID \",$term->identifier(),\n         \"), ontology \",$term->ontology()->name(),\"\\n\";\n   $term = Bio::Ontology::Term->new(-name => 'ABC2',\n                                    -ontology => 'Gene Name');\n   $annterm->term($term);\n\n=head1 DESCRIPTION\n\nOntology term annotation object\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::OntologyTerm;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Ontology::Term;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI Bio::Ontology::TermI);\n\n=head2 new\n\n Title   : new\n Usage   : my $sv = Bio::Annotation::OntologyTerm->new();\n Function: Instantiate a new OntologyTerm object\n Returns : Bio::Annotation::OntologyTerm object\n Args    : -term => $term to initialize the term data field [optional]\n           Most named arguments that Bio::Ontology::Term accepts will work\n           here too. -label is a synonym for -name, -tagname is a synonym for\n           -ontology.","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"containerName":"main::","definition":"sub","line":128,"children":[{"kind":13,"line":129,"containerName":"new","name":"$class","definition":"my","localvar":"my"},{"name":"@args","containerName":"new","kind":13,"line":129},{"definition":"my","name":"$self","containerName":"new","localvar":"my","kind":13,"line":131},{"line":131,"kind":13,"name":"$class","containerName":"new"},{"kind":13,"line":131,"containerName":"new","name":"@args"},{"containerName":"new","definition":"my","name":"$term","localvar":"my","kind":13,"line":132},{"line":132,"kind":13,"containerName":"new","name":"$name"},{"containerName":"new","name":"$label","kind":13,"line":132},{"line":132,"kind":13,"name":"$identifier","containerName":"new"},{"kind":13,"line":132,"containerName":"new","name":"$definition"},{"kind":13,"line":132,"containerName":"new","name":"$ont"},{"line":132,"kind":13,"containerName":"new","name":"$tag"},{"line":133,"kind":13,"name":"$self","containerName":"new"},{"name":"_rearrange","containerName":"new","kind":12,"line":133},{"line":140,"kind":13,"name":"@args","containerName":"new"},{"containerName":"new","name":"$term","line":141,"kind":13},{"line":142,"kind":13,"name":"$self","containerName":"new"},{"line":142,"kind":12,"name":"term","containerName":"new"},{"kind":13,"line":142,"name":"$term","containerName":"new"},{"line":144,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":144,"containerName":"new","name":"name"},{"kind":13,"line":144,"containerName":"new","name":"$name"},{"name":"$label","containerName":"new","line":144,"kind":13},{"kind":13,"line":144,"name":"$name","containerName":"new"},{"kind":13,"line":144,"containerName":"new","name":"$label"},{"name":"$self","containerName":"new","kind":13,"line":145},{"line":145,"kind":12,"containerName":"new","name":"identifier"},{"line":145,"kind":13,"containerName":"new","name":"$identifier"},{"kind":13,"line":145,"name":"$identifier","containerName":"new"},{"kind":13,"line":146,"containerName":"new","name":"$self"},{"name":"definition","containerName":"new","line":146,"kind":12},{"line":146,"kind":13,"containerName":"new","name":"$definition"},{"name":"$definition","containerName":"new","line":146,"kind":13},{"line":148,"kind":13,"name":"$self","containerName":"new"},{"line":148,"kind":12,"name":"ontology","containerName":"new"},{"containerName":"new","name":"$ont","line":148,"kind":13},{"name":"$tag","containerName":"new","line":148,"kind":13},{"name":"$ont","containerName":"new","kind":13,"line":148},{"containerName":"new","name":"$tag","kind":13,"line":148},{"kind":13,"line":149,"name":"$self","containerName":"new"}],"kind":12,"range":{"end":{"character":9999,"line":150},"start":{"character":0,"line":128}},"name":"new"},{"kind":12,"line":131,"containerName":"new","name":"SUPER"},{"children":[{"line":173,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"as_text"},{"kind":13,"line":175,"name":"$self","containerName":"as_text"},{"containerName":"as_text","name":"tagname","kind":12,"line":175},{"containerName":"as_text","name":"$self","line":175,"kind":13},{"name":"name","containerName":"as_text","line":175,"kind":12},{"kind":13,"line":175,"name":"$self","containerName":"as_text"},{"kind":12,"line":175,"containerName":"as_text","name":"is_obsolete"}],"line":172,"kind":12,"signature":{"documentation":"1;\n# $Id: OntologyTerm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::OntologyTerm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::OntologyTerm - An ontology term adapted to AnnotationI\n\n=head1 SYNOPSIS\n\n   use Bio::Annotation::OntologyTerm;\n   use Bio::Annotation::Collection;\n   use Bio::Ontology::Term;\n\n   my $coll = Bio::Annotation::Collection->new();\n\n   # this also implements a tag/value pair, where tag _and_ value are treated\n   # as ontology terms\n   my $annterm = Bio::Annotation::OntologyTerm->new(-label => 'ABC1',\n                                                   -tagname => 'Gene Name');\n   # ontology terms can be added directly - they implicitly have a tag\n   $coll->add_Annotation($annterm);\n\n   # implementation is by composition - you can get/set the term object\n   # e.g.\n   my $term = $annterm->term(); # term is-a Bio::Ontology::TermI\n   print \"ontology term \",$term->name(),\" (ID \",$term->identifier(),\n         \"), ontology \",$term->ontology()->name(),\"\\n\";\n   $term = Bio::Ontology::Term->new(-name => 'ABC2',\n                                    -ontology => 'Gene Name');\n   $annterm->term($term);\n\n=head1 DESCRIPTION\n\nOntology term annotation object\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::OntologyTerm;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Ontology::Term;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI Bio::Ontology::TermI);\n\n=head2 new\n\n Title   : new\n Usage   : my $sv = Bio::Annotation::OntologyTerm->new();\n Function: Instantiate a new OntologyTerm object\n Returns : Bio::Annotation::OntologyTerm object\n Args    : -term => $term to initialize the term data field [optional]\n           Most named arguments that Bio::Ontology::Term accepts will work\n           here too. -label is a synonym for -name, -tagname is a synonym for\n           -ontology.\n\n\nsub new{\n    my ($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    my ($term,$name,$label,$identifier,$definition,$ont,$tag) =\n\t$self->_rearrange([qw(TERM\n                          NAME\n                          LABEL\n                          IDENTIFIER\n                          DEFINITION\n                          ONTOLOGY\n                          TAGNAME)],\n                      @args);\n    if($term) {\n        $self->term($term);\n    } else {\n        $self->name($name || $label) if $name || $label;\n        $self->identifier($identifier) if $identifier;\n        $self->definition($definition) if $definition;\n    }\n    $self->ontology($ont || $tag) if $ont || $tag;\n    return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $text = $obj->as_text\n Function: Returns a textual representation of the annotation that\n           this object holds. Presently, it is tag name, name of the\n           term, and the is_obsolete attribute concatenated togather\n           with a delimiter (|).\n\n Returns : string\n Args    : none","parameters":[{"label":"$self"}],"label":"as_text($self)"},"detail":"($self)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":172},"end":{"character":9999,"line":176}},"name":"as_text"},{"name":"%DEFAULT_CB","definition":"my","containerName":null,"localvar":"my","kind":13,"line":195},{"containerName":"main::","name":"identifier","line":195,"kind":12},{"kind":12,"line":197,"children":[{"kind":13,"line":198,"containerName":"display_text","definition":"my","name":"$self","localvar":"my"},{"name":"$cb","containerName":"display_text","line":198,"kind":13},{"name":"$cb","containerName":"display_text","line":199,"kind":13},{"line":199,"kind":13,"containerName":"display_text","name":"$DEFAULT_CB"},{"name":"$self","containerName":"display_text","kind":13,"line":200},{"containerName":"display_text","name":"throw","line":200,"kind":12},{"line":200,"kind":13,"containerName":"display_text","name":"$cb"},{"kind":13,"line":201,"name":"$cb","containerName":"display_text"},{"containerName":"display_text","name":"$self","line":201,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$cb)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$cb"}],"label":"display_text($self,$cb)"},"name":"display_text","range":{"end":{"character":9999,"line":202},"start":{"character":0,"line":197}}},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"hash_tree($self)","documentation":"1;\n# $Id: OntologyTerm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::OntologyTerm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::OntologyTerm - An ontology term adapted to AnnotationI\n\n=head1 SYNOPSIS\n\n   use Bio::Annotation::OntologyTerm;\n   use Bio::Annotation::Collection;\n   use Bio::Ontology::Term;\n\n   my $coll = Bio::Annotation::Collection->new();\n\n   # this also implements a tag/value pair, where tag _and_ value are treated\n   # as ontology terms\n   my $annterm = Bio::Annotation::OntologyTerm->new(-label => 'ABC1',\n                                                   -tagname => 'Gene Name');\n   # ontology terms can be added directly - they implicitly have a tag\n   $coll->add_Annotation($annterm);\n\n   # implementation is by composition - you can get/set the term object\n   # e.g.\n   my $term = $annterm->term(); # term is-a Bio::Ontology::TermI\n   print \"ontology term \",$term->name(),\" (ID \",$term->identifier(),\n         \"), ontology \",$term->ontology()->name(),\"\\n\";\n   $term = Bio::Ontology::Term->new(-name => 'ABC2',\n                                    -ontology => 'Gene Name');\n   $annterm->term($term);\n\n=head1 DESCRIPTION\n\nOntology term annotation object\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::OntologyTerm;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Ontology::Term;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI Bio::Ontology::TermI);\n\n=head2 new\n\n Title   : new\n Usage   : my $sv = Bio::Annotation::OntologyTerm->new();\n Function: Instantiate a new OntologyTerm object\n Returns : Bio::Annotation::OntologyTerm object\n Args    : -term => $term to initialize the term data field [optional]\n           Most named arguments that Bio::Ontology::Term accepts will work\n           here too. -label is a synonym for -name, -tagname is a synonym for\n           -ontology.\n\n\nsub new{\n    my ($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    my ($term,$name,$label,$identifier,$definition,$ont,$tag) =\n\t$self->_rearrange([qw(TERM\n                          NAME\n                          LABEL\n                          IDENTIFIER\n                          DEFINITION\n                          ONTOLOGY\n                          TAGNAME)],\n                      @args);\n    if($term) {\n        $self->term($term);\n    } else {\n        $self->name($name || $label) if $name || $label;\n        $self->identifier($identifier) if $identifier;\n        $self->definition($definition) if $definition;\n    }\n    $self->ontology($ont || $tag) if $ont || $tag;\n    return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $text = $obj->as_text\n Function: Returns a textual representation of the annotation that\n           this object holds. Presently, it is tag name, name of the\n           term, and the is_obsolete attribute concatenated togather\n           with a delimiter (|).\n\n Returns : string\n Args    : none\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   return $self->tagname().\"|\".$self->name().\"|\".($self->is_obsolete()||'');\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->identifier || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   : my $hashtree = $value->hash_tree\n Function: For supporting the AnnotationI interface just returns the value\n           as a hashref with the key 'value' pointing to the value\n Returns : hashrf\n Args    : none","parameters":[{"label":"$self"}]},"kind":12,"line":218,"children":[{"containerName":"hash_tree","name":"$self","definition":"my","localvar":"my","kind":13,"line":219},{"kind":13,"line":221,"name":"$h","definition":"my","containerName":"hash_tree","localvar":"my"},{"line":222,"kind":13,"containerName":"hash_tree","name":"$h"},{"line":222,"kind":13,"name":"$self","containerName":"hash_tree"},{"containerName":"hash_tree","name":"name","line":222,"kind":12},{"name":"$h","containerName":"hash_tree","kind":13,"line":223},{"containerName":"hash_tree","name":"$self","kind":13,"line":223},{"containerName":"hash_tree","name":"identifier","line":223,"kind":12},{"kind":13,"line":224,"containerName":"hash_tree","name":"$h"},{"name":"$self","containerName":"hash_tree","line":224,"kind":13},{"kind":12,"line":224,"name":"definition","containerName":"hash_tree"},{"kind":13,"line":225,"name":"$h","containerName":"hash_tree"},{"line":225,"kind":13,"containerName":"hash_tree","name":"$self"},{"containerName":"hash_tree","name":"get_synonyms","line":225,"kind":12}],"name":"hash_tree","range":{"start":{"line":218,"character":0},"end":{"character":9999,"line":226}}},{"containerName":"main::","name":"tagname","definition":"sub","range":{"start":{"line":246,"character":0},"end":{"line":253,"character":9999}},"kind":12,"line":246,"children":[{"kind":13,"line":247,"name":"$self","definition":"my","containerName":"tagname","localvar":"my"},{"name":"$self","containerName":"tagname","kind":13,"line":249},{"name":"ontology","containerName":"tagname","kind":12,"line":249},{"localvar":"my","containerName":"tagname","definition":"my","name":"$ont","line":251,"kind":13},{"containerName":"tagname","name":"$self","kind":13,"line":251},{"kind":12,"line":251,"containerName":"tagname","name":"ontology"},{"kind":13,"line":252,"name":"$ont","containerName":"tagname"},{"kind":13,"line":252,"containerName":"tagname","name":"$ont"},{"line":252,"kind":12,"containerName":"tagname","name":"name"},{"name":"$ont","containerName":"tagname","kind":13,"line":252}]},{"range":{"end":{"line":283,"character":9999},"start":{"line":274,"character":0}},"name":"term","detail":"($self,$value)","signature":{"label":"term($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: OntologyTerm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::OntologyTerm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::OntologyTerm - An ontology term adapted to AnnotationI\n\n=head1 SYNOPSIS\n\n   use Bio::Annotation::OntologyTerm;\n   use Bio::Annotation::Collection;\n   use Bio::Ontology::Term;\n\n   my $coll = Bio::Annotation::Collection->new();\n\n   # this also implements a tag/value pair, where tag _and_ value are treated\n   # as ontology terms\n   my $annterm = Bio::Annotation::OntologyTerm->new(-label => 'ABC1',\n                                                   -tagname => 'Gene Name');\n   # ontology terms can be added directly - they implicitly have a tag\n   $coll->add_Annotation($annterm);\n\n   # implementation is by composition - you can get/set the term object\n   # e.g.\n   my $term = $annterm->term(); # term is-a Bio::Ontology::TermI\n   print \"ontology term \",$term->name(),\" (ID \",$term->identifier(),\n         \"), ontology \",$term->ontology()->name(),\"\\n\";\n   $term = Bio::Ontology::Term->new(-name => 'ABC2',\n                                    -ontology => 'Gene Name');\n   $annterm->term($term);\n\n=head1 DESCRIPTION\n\nOntology term annotation object\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::OntologyTerm;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Ontology::Term;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI Bio::Ontology::TermI);\n\n=head2 new\n\n Title   : new\n Usage   : my $sv = Bio::Annotation::OntologyTerm->new();\n Function: Instantiate a new OntologyTerm object\n Returns : Bio::Annotation::OntologyTerm object\n Args    : -term => $term to initialize the term data field [optional]\n           Most named arguments that Bio::Ontology::Term accepts will work\n           here too. -label is a synonym for -name, -tagname is a synonym for\n           -ontology.\n\n\nsub new{\n    my ($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    my ($term,$name,$label,$identifier,$definition,$ont,$tag) =\n\t$self->_rearrange([qw(TERM\n                          NAME\n                          LABEL\n                          IDENTIFIER\n                          DEFINITION\n                          ONTOLOGY\n                          TAGNAME)],\n                      @args);\n    if($term) {\n        $self->term($term);\n    } else {\n        $self->name($name || $label) if $name || $label;\n        $self->identifier($identifier) if $identifier;\n        $self->definition($definition) if $definition;\n    }\n    $self->ontology($ont || $tag) if $ont || $tag;\n    return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $text = $obj->as_text\n Function: Returns a textual representation of the annotation that\n           this object holds. Presently, it is tag name, name of the\n           term, and the is_obsolete attribute concatenated togather\n           with a delimiter (|).\n\n Returns : string\n Args    : none\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   return $self->tagname().\"|\".$self->name().\"|\".($self->is_obsolete()||'');\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->identifier || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   : my $hashtree = $value->hash_tree\n Function: For supporting the AnnotationI interface just returns the value\n           as a hashref with the key 'value' pointing to the value\n Returns : hashrf\n Args    : none\n\n\n\nsub hash_tree{\n   my ($self) = @_;\n\n   my $h = {};\n   $h->{'name'} = $self->name();\n   $h->{'identifier'} = $self->identifier();\n   $h->{'definition'} = $self->definition();\n   $h->{'synonyms'} = [$self->get_synonyms()];\n}\n\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to provide\n           a tag to AnnotationCollection when adding this object.\n\n           This is aliased to ontology() here.\n Example :\n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my $self = shift;\n\n    return $self->ontology(@_) if @_;\n    # if in get mode we need to get the name from the ontology\n    my $ont = $self->ontology();\n    return ref($ont) ? $ont->name() : $ont;\n}\n\n=head1 Methods for Bio::Ontology::TermI compliance\n\n\n=head2 term\n\n Title   : term\n Usage   : $obj->term($newval)\n Function: Get/set the Bio::Ontology::TermI implementing object.\n\n           We implement TermI by composition, and this method sets/gets the\n           object we delegate to.\n Example :\n Returns : value of term (a Bio::Ontology::TermI compliant object)\n Args    : new value (a Bio::Ontology::TermI compliant object, optional)"},"containerName":"main::","definition":"sub","line":274,"children":[{"kind":13,"line":275,"definition":"my","name":"$self","containerName":"term","localvar":"my"},{"kind":13,"line":275,"name":"$value","containerName":"term"},{"line":276,"kind":13,"containerName":"term","name":"$value"},{"line":277,"kind":13,"name":"$self","containerName":"term"},{"containerName":"term","name":"$value","kind":13,"line":277},{"name":"$self","containerName":"term","kind":13,"line":279},{"name":"$self","containerName":"term","kind":13,"line":280},{"kind":12,"line":280,"name":"new","containerName":"term"},{"kind":13,"line":282,"containerName":"term","name":"$self"}],"kind":12},{"name":"Bio","containerName":"Ontology::Term","kind":12,"line":280},{"line":297,"children":[{"name":"term","containerName":"identifier","line":298,"kind":12},{"kind":12,"line":298,"name":"identifier","containerName":"identifier"}],"kind":12,"range":{"start":{"line":297,"character":0},"end":{"character":9999,"line":299}},"containerName":"main::","name":"identifier","definition":"sub"},{"kind":12,"line":313,"children":[{"containerName":"name","name":"term","kind":12,"line":314},{"name":"name","containerName":"name","line":314,"kind":12}],"containerName":"main::","definition":"sub","name":"name","range":{"end":{"character":9999,"line":315},"start":{"line":313,"character":0}}},{"kind":12,"children":[{"name":"term","containerName":"definition","line":331,"kind":12},{"name":"definition","containerName":"definition","line":331,"kind":12}],"line":330,"definition":"sub","name":"definition","containerName":"main::","range":{"start":{"line":330,"character":0},"end":{"line":332,"character":9999}}},{"children":[{"line":349,"kind":12,"containerName":"ontology","name":"term"},{"name":"ontology","containerName":"ontology","line":349,"kind":12}],"line":348,"kind":12,"range":{"start":{"line":348,"character":0},"end":{"line":350,"character":9999}},"name":"ontology","definition":"sub","containerName":"main::"},{"line":364,"children":[{"containerName":"is_obsolete","name":"term","line":365,"kind":12},{"kind":12,"line":365,"containerName":"is_obsolete","name":"is_obsolete"}],"kind":12,"range":{"end":{"line":366,"character":9999},"start":{"line":364,"character":0}},"containerName":"main::","definition":"sub","name":"is_obsolete"},{"children":[{"kind":12,"line":381,"containerName":"comment","name":"term"},{"line":381,"kind":12,"name":"comment","containerName":"comment"}],"line":380,"kind":12,"range":{"end":{"character":9999,"line":382},"start":{"character":0,"line":380}},"name":"comment","definition":"sub","containerName":"main::"},{"line":394,"children":[{"containerName":"get_synonyms","name":"term","kind":12,"line":395},{"line":395,"kind":12,"name":"get_synonyms","containerName":"get_synonyms"}],"kind":12,"range":{"end":{"line":396,"character":9999},"start":{"line":394,"character":0}},"containerName":"main::","definition":"sub","name":"get_synonyms"},{"line":410,"children":[{"kind":12,"line":411,"name":"term","containerName":"add_synonym"},{"kind":12,"line":411,"name":"add_synonym","containerName":"add_synonym"}],"kind":12,"range":{"end":{"line":412,"character":9999},"start":{"line":410,"character":0}},"containerName":"main::","name":"add_synonym","definition":"sub"},{"line":425,"children":[{"name":"term","containerName":"remove_synonyms","kind":12,"line":426},{"containerName":"remove_synonyms","name":"remove_synonyms","line":426,"kind":12}],"kind":12,"range":{"end":{"line":427,"character":9999},"start":{"line":425,"character":0}},"containerName":"main::","definition":"sub","name":"remove_synonyms"},{"range":{"end":{"line":445,"character":9999},"start":{"line":441,"character":0}},"containerName":"main::","definition":"sub","name":"get_dblinks","line":441,"children":[{"localvar":"my","containerName":"get_dblinks","name":"$self","definition":"my","line":442,"kind":13},{"kind":13,"line":443,"containerName":"get_dblinks","name":"$self"},{"containerName":"get_dblinks","name":"deprecated","kind":12,"line":443},{"line":444,"kind":13,"containerName":"get_dblinks","name":"$self"},{"name":"term","containerName":"get_dblinks","line":444,"kind":12},{"containerName":"get_dblinks","name":"get_dbxrefs","kind":12,"line":444}],"kind":12},{"range":{"start":{"character":0,"line":457},"end":{"character":9999,"line":459}},"definition":"sub","name":"get_dbxrefs","containerName":"main::","children":[{"line":458,"kind":12,"containerName":"get_dbxrefs","name":"term"},{"line":458,"kind":12,"name":"get_dbxrefs","containerName":"get_dbxrefs"}],"line":457,"kind":12},{"range":{"start":{"character":0,"line":477},"end":{"line":481,"character":9999}},"definition":"sub","name":"add_dblink","containerName":"main::","children":[{"line":478,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"add_dblink"},{"line":479,"kind":13,"containerName":"add_dblink","name":"$self"},{"line":479,"kind":12,"containerName":"add_dblink","name":"deprecated"},{"containerName":"add_dblink","name":"$self","line":480,"kind":13},{"name":"term","containerName":"add_dblink","line":480,"kind":12},{"name":"add_dbxref","containerName":"add_dblink","kind":12,"line":480}],"line":477,"kind":12},{"kind":12,"children":[{"kind":12,"line":497,"containerName":"add_dbxref","name":"term"},{"name":"add_dbxref","containerName":"add_dbxref","line":497,"kind":12}],"line":496,"name":"add_dbxref","definition":"sub","containerName":"main::","range":{"start":{"line":496,"character":0},"end":{"character":9999,"line":498}}},{"line":512,"children":[{"localvar":"my","containerName":"remove_dblinks","name":"$self","definition":"my","line":513,"kind":13},{"kind":13,"line":514,"name":"$self","containerName":"remove_dblinks"},{"containerName":"remove_dblinks","name":"deprecated","line":514,"kind":12},{"containerName":"remove_dblinks","name":"$self","kind":13,"line":515},{"line":515,"kind":12,"containerName":"remove_dblinks","name":"term"},{"containerName":"remove_dblinks","name":"remove_dbxrefs","line":515,"kind":12}],"kind":12,"range":{"end":{"line":516,"character":9999},"start":{"line":512,"character":0}},"containerName":"main::","name":"remove_dblinks","definition":"sub"},{"kind":12,"line":528,"children":[{"name":"term","containerName":"remove_dbxrefs","line":529,"kind":12},{"line":529,"kind":12,"name":"remove_dbxrefs","containerName":"remove_dbxrefs"}],"containerName":"main::","name":"remove_dbxrefs","definition":"sub","range":{"start":{"character":0,"line":528},"end":{"line":530,"character":9999}}},{"containerName":"main::","name":"get_secondary_ids","definition":"sub","range":{"start":{"line":546,"character":0},"end":{"character":9999,"line":548}},"kind":12,"line":546,"children":[{"name":"term","containerName":"get_secondary_ids","kind":12,"line":547},{"line":547,"kind":12,"name":"get_secondary_ids","containerName":"get_secondary_ids"}]},{"kind":12,"children":[{"name":"term","containerName":"add_secondary_id","kind":12,"line":564},{"name":"add_secondary_id","containerName":"add_secondary_id","kind":12,"line":564}],"line":563,"definition":"sub","name":"add_secondary_id","containerName":"main::","range":{"start":{"line":563,"character":0},"end":{"line":565,"character":9999}}},{"range":{"end":{"line":580,"character":9999},"start":{"character":0,"line":578}},"name":"remove_secondary_ids","definition":"sub","containerName":"main::","children":[{"containerName":"remove_secondary_ids","name":"term","line":579,"kind":12},{"containerName":"remove_secondary_ids","name":"remove_secondary_ids","line":579,"kind":12}],"line":578,"kind":12}]}