{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":60},{"range":{"start":{"character":0,"line":89},"end":{"line":118,"character":9999}},"name":"new","line":89,"children":[{"line":90,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$class"},{"containerName":"new","name":"@args","line":90,"kind":13},{"localvar":"my","containerName":"new","definition":"my","name":"$self","line":92,"kind":13},{"containerName":"new","name":"$class","kind":13,"line":92},{"containerName":"new","name":"@args","kind":13,"line":92},{"localvar":"my","containerName":"new","definition":"my","name":"$database","line":94,"kind":13},{"containerName":"new","name":"$primary_id","kind":13,"line":94},{"line":94,"kind":13,"name":"$optional_id","containerName":"new"},{"kind":13,"line":94,"name":"$comment","containerName":"new"},{"line":94,"kind":13,"containerName":"new","name":"$tag"},{"line":94,"kind":13,"name":"$ns","containerName":"new"},{"name":"$auth","containerName":"new","kind":13,"line":94},{"kind":13,"line":94,"containerName":"new","name":"$v"},{"kind":13,"line":94,"containerName":"new","name":"$url"},{"kind":13,"line":95,"containerName":"new","name":"$self"},{"kind":12,"line":95,"containerName":"new","name":"_rearrange"},{"containerName":"new","name":"@args","line":104,"kind":13},{"kind":13,"line":106,"containerName":"new","name":"$database"},{"name":"$self","containerName":"new","kind":13,"line":106},{"containerName":"new","name":"database","kind":12,"line":106},{"line":106,"kind":13,"containerName":"new","name":"$database"},{"line":107,"kind":13,"name":"$primary_id","containerName":"new"},{"line":107,"kind":13,"name":"$self","containerName":"new"},{"line":107,"kind":12,"name":"primary_id","containerName":"new"},{"line":107,"kind":13,"containerName":"new","name":"$primary_id"},{"name":"$optional_id","containerName":"new","kind":13,"line":108},{"containerName":"new","name":"$self","kind":13,"line":108},{"name":"optional_id","containerName":"new","line":108,"kind":12},{"line":108,"kind":13,"containerName":"new","name":"$optional_id"},{"kind":13,"line":109,"name":"$comment","containerName":"new"},{"kind":13,"line":109,"name":"$self","containerName":"new"},{"containerName":"new","name":"comment","kind":12,"line":109},{"name":"$comment","containerName":"new","line":109,"kind":13},{"kind":13,"line":110,"containerName":"new","name":"$tag"},{"containerName":"new","name":"$self","kind":13,"line":110},{"name":"tagname","containerName":"new","line":110,"kind":12},{"name":"$tag","containerName":"new","line":110,"kind":13},{"containerName":"new","name":"$ns","line":112,"kind":13},{"kind":13,"line":112,"name":"$self","containerName":"new"},{"line":112,"kind":12,"name":"namespace","containerName":"new"},{"kind":13,"line":112,"containerName":"new","name":"$ns"},{"line":113,"kind":13,"name":"$auth","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":113},{"kind":12,"line":113,"name":"authority","containerName":"new"},{"name":"$auth","containerName":"new","line":113,"kind":13},{"line":114,"kind":13,"containerName":"new","name":"$v"},{"kind":13,"line":114,"name":"$self","containerName":"new"},{"containerName":"new","name":"version","kind":12,"line":114},{"containerName":"new","name":"$v","line":114,"kind":13},{"line":115,"kind":13,"name":"$url","containerName":"new"},{"name":"$self","containerName":"new","line":115,"kind":13},{"line":115,"kind":12,"containerName":"new","name":"url"},{"line":115,"kind":13,"containerName":"new","name":"$url"},{"containerName":"new","name":"$self","kind":13,"line":117}],"kind":12,"detail":"($class,@args)","signature":{"documentation":"1;\n# $Id: DBLink.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::DBLink\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::DBLink - untyped links between databases\n\n=head1 SYNOPSIS\n\n   $link1 = Bio::Annotation::DBLink->new(-database => 'TSC',\n                                        -primary_id => 'TSC0000030'\n\t\t\t\t\t);\n\n   #or \n\n   $link2 = Bio::Annotation::DBLink->new();\n   $link2->database('dbSNP');\n   $link2->primary_id('2367');\n\n   # DBLink is-a Bio::AnnotationI object, can be added to annotation\n   # collections, e.g. the one on features or seqs\n   $feat->annotation->add_Annotation('dblink', $link2);\n\n\n=head1 DESCRIPTION\n\nProvides an object which represents a link from one object to something\nin another database without prescribing what is in the other database.\n\nAside from L<Bio::AnnotationI>, this class also implements\nL<Bio::IdentifiableI>.\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney - birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::DBLink;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI Bio::IdentifiableI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $dblink = Bio::Annotation::DBLink->new(-database =>\"GenBank\",\n                                                  -primary_id => \"M123456\");\n Function: Creates a new instance of this class.\n Example :\n Returns : A new instance of Bio::Annotation::DBLink.\n Args    : Named parameters. At present, the following parameters are\n           recognized.\n\n             -database    the name of the database referenced by the xref\n             -primary_id  the primary (main) id of the referenced entry\n                          (usually this will be an accession number)\n             -optional_id a secondary ID under which the referenced entry\n                          is known in the same database\n             -comment     comment text for the dbxref\n             -tagname     the name of the tag under which to add this\n                          instance to an annotation bundle (usually 'dblink')\n             -namespace   synonymous with -database (also overrides)\n             -version     version of the referenced entry\n             -authority   attribute of the Bio::IdentifiableI interface\n             -url         attribute of the Bio::IdentifiableI interface","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"containerName":"main::","definition":"sub"},{"containerName":"new","name":"SUPER","line":92,"kind":12},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: DBLink.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::DBLink\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::DBLink - untyped links between databases\n\n=head1 SYNOPSIS\n\n   $link1 = Bio::Annotation::DBLink->new(-database => 'TSC',\n                                        -primary_id => 'TSC0000030'\n\t\t\t\t\t);\n\n   #or \n\n   $link2 = Bio::Annotation::DBLink->new();\n   $link2->database('dbSNP');\n   $link2->primary_id('2367');\n\n   # DBLink is-a Bio::AnnotationI object, can be added to annotation\n   # collections, e.g. the one on features or seqs\n   $feat->annotation->add_Annotation('dblink', $link2);\n\n\n=head1 DESCRIPTION\n\nProvides an object which represents a link from one object to something\nin another database without prescribing what is in the other database.\n\nAside from L<Bio::AnnotationI>, this class also implements\nL<Bio::IdentifiableI>.\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney - birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::DBLink;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI Bio::IdentifiableI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $dblink = Bio::Annotation::DBLink->new(-database =>\"GenBank\",\n                                                  -primary_id => \"M123456\");\n Function: Creates a new instance of this class.\n Example :\n Returns : A new instance of Bio::Annotation::DBLink.\n Args    : Named parameters. At present, the following parameters are\n           recognized.\n\n             -database    the name of the database referenced by the xref\n             -primary_id  the primary (main) id of the referenced entry\n                          (usually this will be an accession number)\n             -optional_id a secondary ID under which the referenced entry\n                          is known in the same database\n             -comment     comment text for the dbxref\n             -tagname     the name of the tag under which to add this\n                          instance to an annotation bundle (usually 'dblink')\n             -namespace   synonymous with -database (also overrides)\n             -version     version of the referenced entry\n             -authority   attribute of the Bio::IdentifiableI interface\n             -url         attribute of the Bio::IdentifiableI interface\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($database,$primary_id,$optional_id,$comment,$tag,$ns,$auth,$v,$url) =\n      $self->_rearrange([qw(DATABASE\n\t\t\t    PRIMARY_ID\n\t\t\t    OPTIONAL_ID\n\t\t\t    COMMENT\n\t\t\t    TAGNAME\n\t\t\t    NAMESPACE\n\t\t\t    AUTHORITY\n\t\t\t    VERSION\n\t\t\t    URL\n\t\t\t    )], @args);\n  \n  $database    && $self->database($database);\n  $primary_id  && $self->primary_id($primary_id);\n  $optional_id && $self->optional_id($optional_id);\n  $comment     && $self->comment($comment);\n  $tag         && $self->tagname($tag);\n  # Bio::IdentifiableI parameters:\n  $ns          && $self->namespace($ns); # this will override $database\n  $auth        && $self->authority($auth);\n  defined($v)  && $self->version($v);\n  defined($url)  && $self->url($url);\n\n  return $self;\n}\n\n=head1 AnnotationI implementing functions\n\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"}],"label":"as_text($self)"},"kind":12,"line":137,"children":[{"line":138,"kind":13,"localvar":"my","containerName":"as_text","definition":"my","name":"$self"},{"containerName":"as_text","name":"$self","line":140,"kind":13},{"line":141,"kind":12,"name":"primary_id","containerName":"as_text"},{"containerName":"as_text","name":"$self","line":141,"kind":13},{"containerName":"as_text","name":"version","line":141,"kind":12},{"line":141,"kind":13,"name":"$self","containerName":"as_text"},{"name":"version","containerName":"as_text","line":141,"kind":12},{"containerName":"as_text","name":"$self","kind":13,"line":142},{"name":"optional_id","containerName":"as_text","line":142,"kind":12},{"line":142,"kind":13,"containerName":"as_text","name":"$self"},{"line":142,"kind":12,"name":"optional_id","containerName":"as_text"},{"containerName":"as_text","name":"$self","kind":13,"line":143},{"kind":12,"line":143,"name":"database","containerName":"as_text"}],"name":"as_text","range":{"start":{"character":0,"line":137},"end":{"line":144,"character":9999}}},{"containerName":null,"definition":"my","name":"%DEFAULT_CB","localvar":"my","kind":13,"line":163},{"line":163,"kind":12,"containerName":"main::","name":"database"},{"containerName":"main::","name":"database","line":163,"kind":12},{"name":"primary_id","containerName":"main::","line":164,"kind":12},{"containerName":"main::","name":"primary_id","line":164,"kind":12},{"line":165,"kind":12,"containerName":"main::","name":"version"},{"kind":12,"line":165,"containerName":"main::","name":"version"},{"kind":12,"line":167,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"display_text","line":168,"kind":13},{"line":168,"kind":13,"name":"$cb","containerName":"display_text"},{"line":169,"kind":13,"name":"$cb","containerName":"display_text"},{"line":169,"kind":13,"containerName":"display_text","name":"$DEFAULT_CB"},{"line":170,"kind":13,"name":"$self","containerName":"display_text"},{"containerName":"display_text","name":"throw","line":170,"kind":12},{"kind":13,"line":170,"containerName":"display_text","name":"$cb"},{"containerName":"display_text","name":"$cb","line":171,"kind":13},{"name":"$self","containerName":"display_text","kind":13,"line":171}],"containerName":"main::","definition":"sub","detail":"($self,$cb)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$cb"}],"label":"display_text($self,$cb)"},"name":"display_text","range":{"end":{"line":172,"character":9999},"start":{"line":167,"character":0}}},{"name":"hash_tree","range":{"end":{"line":203,"character":9999},"start":{"line":188,"character":0}},"kind":12,"children":[{"kind":13,"line":189,"definition":"my","name":"$self","containerName":"hash_tree","localvar":"my"},{"kind":13,"line":191,"definition":"my","name":"$h","containerName":"hash_tree","localvar":"my"},{"line":192,"kind":13,"name":"$h","containerName":"hash_tree"},{"line":192,"kind":13,"containerName":"hash_tree","name":"$self"},{"kind":12,"line":192,"containerName":"hash_tree","name":"database"},{"line":193,"kind":13,"name":"$h","containerName":"hash_tree"},{"line":193,"kind":13,"containerName":"hash_tree","name":"$self"},{"line":193,"kind":12,"name":"primary_id","containerName":"hash_tree"},{"line":194,"kind":13,"containerName":"hash_tree","name":"$self"},{"name":"optional_id","containerName":"hash_tree","kind":12,"line":194},{"kind":13,"line":195,"name":"$h","containerName":"hash_tree"},{"kind":13,"line":195,"name":"$self","containerName":"hash_tree"},{"containerName":"hash_tree","name":"optional_id","kind":12,"line":195},{"line":197,"kind":13,"name":"$self","containerName":"hash_tree"},{"name":"comment","containerName":"hash_tree","line":197,"kind":12},{"kind":13,"line":199,"containerName":"hash_tree","name":"$h"},{"containerName":"hash_tree","name":"$self","kind":13,"line":199},{"line":199,"kind":12,"name":"comment","containerName":"hash_tree"},{"kind":13,"line":202,"name":"$h","containerName":"hash_tree"}],"line":188,"definition":"sub","containerName":"main::","signature":{"label":"hash_tree($self)","documentation":"1;\n# $Id: DBLink.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::DBLink\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::DBLink - untyped links between databases\n\n=head1 SYNOPSIS\n\n   $link1 = Bio::Annotation::DBLink->new(-database => 'TSC',\n                                        -primary_id => 'TSC0000030'\n\t\t\t\t\t);\n\n   #or \n\n   $link2 = Bio::Annotation::DBLink->new();\n   $link2->database('dbSNP');\n   $link2->primary_id('2367');\n\n   # DBLink is-a Bio::AnnotationI object, can be added to annotation\n   # collections, e.g. the one on features or seqs\n   $feat->annotation->add_Annotation('dblink', $link2);\n\n\n=head1 DESCRIPTION\n\nProvides an object which represents a link from one object to something\nin another database without prescribing what is in the other database.\n\nAside from L<Bio::AnnotationI>, this class also implements\nL<Bio::IdentifiableI>.\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney - birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::DBLink;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI Bio::IdentifiableI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $dblink = Bio::Annotation::DBLink->new(-database =>\"GenBank\",\n                                                  -primary_id => \"M123456\");\n Function: Creates a new instance of this class.\n Example :\n Returns : A new instance of Bio::Annotation::DBLink.\n Args    : Named parameters. At present, the following parameters are\n           recognized.\n\n             -database    the name of the database referenced by the xref\n             -primary_id  the primary (main) id of the referenced entry\n                          (usually this will be an accession number)\n             -optional_id a secondary ID under which the referenced entry\n                          is known in the same database\n             -comment     comment text for the dbxref\n             -tagname     the name of the tag under which to add this\n                          instance to an annotation bundle (usually 'dblink')\n             -namespace   synonymous with -database (also overrides)\n             -version     version of the referenced entry\n             -authority   attribute of the Bio::IdentifiableI interface\n             -url         attribute of the Bio::IdentifiableI interface\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($database,$primary_id,$optional_id,$comment,$tag,$ns,$auth,$v,$url) =\n      $self->_rearrange([qw(DATABASE\n\t\t\t    PRIMARY_ID\n\t\t\t    OPTIONAL_ID\n\t\t\t    COMMENT\n\t\t\t    TAGNAME\n\t\t\t    NAMESPACE\n\t\t\t    AUTHORITY\n\t\t\t    VERSION\n\t\t\t    URL\n\t\t\t    )], @args);\n  \n  $database    && $self->database($database);\n  $primary_id  && $self->primary_id($primary_id);\n  $optional_id && $self->optional_id($optional_id);\n  $comment     && $self->comment($comment);\n  $tag         && $self->tagname($tag);\n  # Bio::IdentifiableI parameters:\n  $ns          && $self->namespace($ns); # this will override $database\n  $auth        && $self->authority($auth);\n  defined($v)  && $self->version($v);\n  defined($url)  && $self->url($url);\n\n  return $self;\n}\n\n=head1 AnnotationI implementing functions\n\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   return \"Direct database link to \".$self->primary_id\n       .($self->version ? \".\".$self->version : \"\")\n       .($self->optional_id ? \" (\".$self->optional_id.\")\" : \"\")\n       .\" in database \".$self->database;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { (($_[0]->database ? $_[0]->database . ':' : '' ) .\n                          ($_[0]->primary_id ? $_[0]->primary_id : '') .\n                          ($_[0]->version ? '.' . $_[0]->version : '')) || '' };\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"}]},"detail":"($self)"},{"kind":12,"line":225,"children":[{"kind":13,"line":226,"definition":"my","name":"$self","containerName":"tagname","localvar":"my"},{"containerName":"tagname","name":"$self","kind":13,"line":228},{"containerName":"tagname","name":"$self","line":229,"kind":13}],"containerName":"main::","definition":"sub","name":"tagname","range":{"start":{"character":0,"line":225},"end":{"line":230,"character":9999}}},{"range":{"start":{"line":248,"character":0},"end":{"line":253,"character":9999}},"definition":"sub","name":"database","containerName":"main::","children":[{"line":249,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"database"},{"containerName":"database","name":"$self","kind":13,"line":251},{"kind":13,"line":252,"name":"$self","containerName":"database"}],"line":248,"kind":12},{"range":{"start":{"line":269,"character":0},"end":{"character":9999,"line":274}},"containerName":"main::","name":"primary_id","definition":"sub","line":269,"children":[{"definition":"my","name":"$self","containerName":"primary_id","localvar":"my","kind":13,"line":270},{"name":"$self","containerName":"primary_id","kind":13,"line":272},{"name":"$self","containerName":"primary_id","kind":13,"line":273}],"kind":12},{"range":{"start":{"line":297,"character":0},"end":{"line":302,"character":9999}},"definition":"sub","name":"optional_id","containerName":"main::","children":[{"kind":13,"line":298,"containerName":"optional_id","name":"$self","definition":"my","localvar":"my"},{"name":"$self","containerName":"optional_id","line":300,"kind":13},{"kind":13,"line":301,"name":"$self","containerName":"optional_id"}],"line":297,"kind":12},{"kind":12,"children":[{"line":317,"kind":13,"localvar":"my","containerName":"comment","definition":"my","name":"$self"},{"kind":13,"line":319,"name":"$self","containerName":"comment"},{"name":"$self","containerName":"comment","line":320,"kind":13}],"line":316,"definition":"sub","name":"comment","containerName":"main::","range":{"end":{"character":9999,"line":321},"start":{"character":0,"line":316}}},{"kind":12,"children":[{"name":"primary_id","containerName":"object_id","kind":12,"line":340}],"line":339,"name":"object_id","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":339},"end":{"character":9999,"line":341}}},{"children":[{"containerName":"version","definition":"my","name":"$self","localvar":"my","kind":13,"line":357},{"kind":13,"line":359,"containerName":"version","name":"$self"},{"kind":13,"line":360,"name":"$self","containerName":"version"}],"line":356,"kind":12,"range":{"start":{"line":356,"character":0},"end":{"character":9999,"line":361}},"definition":"sub","name":"version","containerName":"main::"},{"kind":12,"line":373,"children":[{"line":374,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"url"},{"kind":13,"line":375,"name":"$self","containerName":"url"},{"line":376,"kind":13,"containerName":"url","name":"$self"}],"containerName":"main::","name":"url","definition":"sub","range":{"start":{"character":0,"line":373},"end":{"line":377,"character":9999}}},{"range":{"end":{"character":9999,"line":397},"start":{"character":0,"line":392}},"containerName":"main::","definition":"sub","name":"authority","line":392,"children":[{"kind":13,"line":393,"name":"$self","definition":"my","containerName":"authority","localvar":"my"},{"containerName":"authority","name":"$self","kind":13,"line":395},{"line":396,"kind":13,"containerName":"authority","name":"$self"}],"kind":12},{"kind":12,"line":413,"children":[{"containerName":"namespace","name":"database","line":414,"kind":12}],"containerName":"main::","name":"namespace","definition":"sub","range":{"start":{"character":0,"line":413},"end":{"character":9999,"line":415}}}]}