{"vars":[{"line":75,"kind":2,"name":"base","containerName":""},{"signature":{"label":"distance($self,@args)","documentation":"1;\n# $Id: StatisticsI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::StatisticsI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::StatisticsI - Calculate some statistics for an alignment\n\n=head1 SYNOPSIS\n\nGive standard usage here\n\n=head1 DESCRIPTION\n\nDescribe the interface here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::StatisticsI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : Array ref\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"line":92,"kind":13,"localvar":"my","containerName":"distance","name":"$self","definition":"my"},{"containerName":"distance","name":"@args","line":92,"kind":13},{"kind":13,"line":93,"name":"$self","containerName":"distance"},{"line":93,"kind":12,"containerName":"distance","name":"throw_not_implemented"}],"line":91,"kind":12,"range":{"end":{"line":94,"character":9999},"start":{"character":0,"line":91}},"name":"distance"},{"name":"available_distance_methods","range":{"end":{"line":110,"character":9999},"start":{"character":0,"line":107}},"kind":12,"line":107,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"available_distance_methods","line":108,"kind":13},{"line":108,"kind":13,"containerName":"available_distance_methods","name":"@args"},{"containerName":"available_distance_methods","name":"$self","line":109,"kind":13},{"line":109,"kind":12,"containerName":"available_distance_methods","name":"throw_not_implemented"}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"available_distance_methods($self,@args)","documentation":"1;\n# $Id: StatisticsI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::StatisticsI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::StatisticsI - Calculate some statistics for an alignment\n\n=head1 SYNOPSIS\n\nGive standard usage here\n\n=head1 DESCRIPTION\n\nDescribe the interface here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Align::StatisticsI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n=head2 distance\n\n Title   : distance\n Usage   : my $distance_mat = $stats->distance(-align  => $aln, \n\t\t \t\t\t       -method => $method);\n Function: Calculates a distance matrix for all pairwise distances of\n           sequences in an alignment.\n Returns : Array ref\n Args    : -align  => Bio::Align::AlignI object\n           -method => String specifying specific distance method \n                      (implementing class may assume a default)\n\n\nsub distance{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 available_distance_methods\n\n Title   : available_distance_methods\n Usage   : my @methods = $stats->available_distance_methods();\n Function: Enumerates the possible distance methods\n Returns : Array of strings\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}]}}],"version":5}