{"vars":[{"line":109,"name":"base","kind":2,"containerName":""},{"definition":"sub","detail":"($self)","children":[{"containerName":"id","localvar":"my","kind":13,"name":"$self","line":127,"definition":"my"},{"definition":"my","line":128,"name":"@ids","containerName":"id","localvar":"my","kind":13},{"line":128,"kind":13,"containerName":"id","name":"$self"},{"name":"each_DBLink","containerName":"id","kind":12,"line":128},{"line":129,"localvar":"my","containerName":"id","kind":13,"name":"$id","definition":"my"},{"name":"$ids","containerName":"id","kind":13,"line":129},{"containerName":"id","kind":13,"name":"@ids","line":129},{"line":130,"kind":13,"containerName":"id","name":"$id"},{"line":130,"kind":12,"containerName":"id","name":"database"},{"line":130,"containerName":"id","kind":13,"name":"$id"},{"line":130,"name":"primary_id","containerName":"id","kind":12},{"line":130,"kind":13,"containerName":"id","name":"$id"}],"containerName":"main::","name":"id","signature":{"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none","parameters":[{"label":"$self"}],"label":"id($self)"},"line":126,"range":{"start":{"line":126,"character":0},"end":{"character":9999,"line":131}},"kind":12},{"containerName":"main::","name":"add_Allele","children":[{"definition":"my","line":153,"localvar":"my","containerName":"add_Allele","kind":13,"name":"$self"},{"line":153,"name":"$value","kind":13,"containerName":"add_Allele"},{"line":154,"name":"$value","kind":13,"containerName":"add_Allele"},{"line":155,"kind":13,"containerName":"add_Allele","name":"$value"},{"containerName":"add_Allele","kind":12,"name":"isa","line":155},{"definition":"my","localvar":"my","kind":13,"containerName":"add_Allele","name":"$com","line":156},{"name":"$value","kind":13,"containerName":"add_Allele","line":156},{"line":157,"containerName":"add_Allele","kind":13,"name":"$self"},{"line":157,"name":"throw","kind":12,"containerName":"add_Allele"},{"line":160,"kind":13,"containerName":"add_Allele","name":"$self"},{"name":"isa","containerName":"add_Allele","kind":12,"line":160},{"line":161,"name":"$value","containerName":"add_Allele","kind":13},{"line":161,"name":"seq","kind":12,"containerName":"add_Allele"},{"line":161,"name":"$value","kind":13,"containerName":"add_Allele"},{"name":"seq","kind":12,"containerName":"add_Allele","line":161},{"line":161,"containerName":"add_Allele","kind":13,"name":"$value"},{"name":"seq","containerName":"add_Allele","kind":12,"line":161},{"line":163,"name":"$value","containerName":"add_Allele","kind":13},{"line":163,"name":"seq","containerName":"add_Allele","kind":12},{"line":163,"containerName":"add_Allele","kind":13,"name":"$value"},{"name":"seq","containerName":"add_Allele","kind":12,"line":163},{"name":"$value","containerName":"add_Allele","kind":13,"line":163},{"line":163,"containerName":"add_Allele","kind":12,"name":"seq"},{"name":"$self","kind":13,"containerName":"add_Allele","line":165},{"containerName":"add_Allele","kind":13,"name":"$value","line":165},{"name":"$self","kind":13,"containerName":"add_Allele","line":166},{"line":166,"kind":12,"containerName":"add_Allele","name":"allele_mut"},{"containerName":"add_Allele","kind":13,"name":"$value","line":166}],"detail":"($self,$value)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":169},"start":{"character":0,"line":152}},"line":152,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object","label":"add_Allele($self,$value)"}},{"line":189,"kind":12,"range":{"end":{"line":191,"character":9999},"start":{"line":189,"character":0}},"signature":{"label":"each_Allele($self,@args)","documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}]},"children":[{"definition":"my","localvar":"my","kind":13,"containerName":"each_Allele","name":"$self","line":190},{"line":190,"name":"@args","kind":13,"containerName":"each_Allele"},{"line":191,"kind":13,"containerName":"each_Allele","name":"$self"}],"name":"each_Allele","containerName":"main::","definition":"sub","detail":"($self,@args)"},{"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"isMutation","children":[{"containerName":"isMutation","localvar":"my","kind":13,"name":"$self","line":212,"definition":"my"},{"line":212,"kind":13,"containerName":"isMutation","name":"$value"},{"name":"$value","containerName":"isMutation","kind":13,"line":213},{"name":"$value","kind":13,"containerName":"isMutation","line":214},{"kind":13,"containerName":"isMutation","name":"$self","line":215},{"line":217,"containerName":"isMutation","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"isMutation","line":220}],"signature":{"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean","parameters":[{"label":"$self"},{"label":"$value"}],"label":"isMutation($self,$value)"},"kind":12,"range":{"end":{"line":221,"character":9999},"start":{"character":0,"line":211}},"line":211},{"containerName":"main::","name":"allele_ori","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"allele_ori","kind":13,"line":246},{"line":246,"containerName":"allele_ori","kind":13,"name":"$value"},{"containerName":"allele_ori","kind":13,"name":"$value","line":247},{"containerName":"allele_ori","kind":13,"name":"$value","line":248},{"line":248,"kind":13,"containerName":"allele_ori","name":"$value"},{"kind":12,"containerName":"allele_ori","name":"isa","line":248},{"line":249,"containerName":"allele_ori","kind":13,"name":"$self"},{"name":"throw","containerName":"allele_ori","kind":12,"line":249},{"name":"$self","containerName":"allele_ori","kind":13,"line":251},{"name":"isa","kind":12,"containerName":"allele_ori","line":251},{"name":"$value","containerName":"allele_ori","kind":13,"line":252},{"line":252,"containerName":"allele_ori","kind":12,"name":"seq"},{"line":252,"kind":13,"containerName":"allele_ori","name":"$value"},{"line":252,"kind":12,"containerName":"allele_ori","name":"seq"},{"containerName":"allele_ori","kind":13,"name":"$value","line":252},{"line":252,"name":"seq","containerName":"allele_ori","kind":12},{"line":254,"name":"$value","containerName":"allele_ori","kind":13},{"line":254,"kind":12,"containerName":"allele_ori","name":"seq"},{"name":"$value","kind":13,"containerName":"allele_ori","line":254},{"line":254,"name":"seq","kind":12,"containerName":"allele_ori"},{"name":"$value","kind":13,"containerName":"allele_ori","line":254},{"line":254,"containerName":"allele_ori","kind":12,"name":"seq"},{"name":"$self","containerName":"allele_ori","kind":13,"line":256},{"line":256,"name":"$value","kind":13,"containerName":"allele_ori"},{"kind":13,"containerName":"allele_ori","name":"$self","line":259}],"detail":"($self,$value)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":245},"end":{"line":260,"character":9999}},"line":245,"signature":{"label":"allele_ori($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more."}},{"name":"allele_mut","containerName":"main::","children":[{"line":286,"name":"$self","containerName":"allele_mut","localvar":"my","kind":13,"definition":"my"},{"name":"$value","containerName":"allele_mut","kind":13,"line":286},{"line":287,"kind":13,"containerName":"allele_mut","name":"$value"},{"line":288,"containerName":"allele_mut","kind":13,"name":"$value"},{"line":288,"name":"$value","kind":13,"containerName":"allele_mut"},{"line":288,"name":"isa","containerName":"allele_mut","kind":12},{"containerName":"allele_mut","kind":13,"name":"$self","line":289},{"line":289,"name":"throw","kind":12,"containerName":"allele_mut"},{"name":"$self","containerName":"allele_mut","kind":13,"line":291},{"kind":12,"containerName":"allele_mut","name":"isa","line":291},{"line":292,"name":"$value","kind":13,"containerName":"allele_mut"},{"name":"seq","containerName":"allele_mut","kind":12,"line":292},{"line":292,"containerName":"allele_mut","kind":13,"name":"$value"},{"name":"seq","containerName":"allele_mut","kind":12,"line":292},{"line":292,"containerName":"allele_mut","kind":13,"name":"$value"},{"containerName":"allele_mut","kind":12,"name":"seq","line":292},{"name":"$value","kind":13,"containerName":"allele_mut","line":294},{"line":294,"containerName":"allele_mut","kind":12,"name":"seq"},{"line":294,"name":"$value","kind":13,"containerName":"allele_mut"},{"name":"seq","containerName":"allele_mut","kind":12,"line":294},{"name":"$value","containerName":"allele_mut","kind":13,"line":294},{"name":"seq","kind":12,"containerName":"allele_mut","line":294},{"containerName":"allele_mut","kind":13,"name":"$self","line":296},{"line":296,"kind":13,"containerName":"allele_mut","name":"$value"},{"containerName":"allele_mut","kind":13,"name":"$self","line":299}],"detail":"($self,$value)","definition":"sub","range":{"start":{"character":0,"line":285},"end":{"character":9999,"line":300}},"kind":12,"line":285,"signature":{"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.","parameters":[{"label":"$self"},{"label":"$value"}],"label":"allele_mut($self,$value)"}},{"signature":{"label":"length($self,$value)","documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string","parameters":[{"label":"$self"},{"label":"$value"}]},"range":{"start":{"character":0,"line":325},"end":{"character":9999,"line":334}},"kind":12,"line":325,"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"length","children":[{"line":326,"containerName":"length","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$value","containerName":"length","kind":13,"line":326},{"name":"$value","kind":13,"containerName":"length","line":327},{"kind":13,"containerName":"length","name":"$self","line":328},{"name":"$value","containerName":"length","kind":13,"line":328},{"containerName":"length","kind":13,"name":"$self","line":330},{"line":333,"kind":13,"containerName":"length","name":"$self"}]},{"line":353,"range":{"end":{"line":359,"character":9999},"start":{"line":353,"character":0}},"kind":12,"signature":{"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub length {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'length'} = $value;\n  }\n   if ( ! exists $self->{'length'} ) {\n       return 0;\n   } \n   return $self->{'length'};\n}\n\n=head2 upStreamSeq\n\n Title   : upStreamSeq\n Usage   : $obj->upStreamSeq();\n Function: \n\n            Sets and returns upstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string","parameters":[{"label":"$self"},{"label":"$value"}],"label":"upStreamSeq($self,$value)"},"children":[{"containerName":"upStreamSeq","localvar":"my","kind":13,"name":"$self","line":354,"definition":"my"},{"containerName":"upStreamSeq","kind":13,"name":"$value","line":354},{"kind":13,"containerName":"upStreamSeq","name":"$value","line":355},{"line":356,"name":"$self","kind":13,"containerName":"upStreamSeq"},{"line":356,"containerName":"upStreamSeq","kind":13,"name":"$value"},{"name":"$self","containerName":"upStreamSeq","kind":13,"line":358}],"name":"upStreamSeq","containerName":"main::","definition":"sub","detail":"($self,$value)"},{"line":379,"kind":12,"range":{"end":{"line":386,"character":9999},"start":{"line":379,"character":0}},"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub length {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'length'} = $value;\n  }\n   if ( ! exists $self->{'length'} ) {\n       return 0;\n   } \n   return $self->{'length'};\n}\n\n=head2 upStreamSeq\n\n Title   : upStreamSeq\n Usage   : $obj->upStreamSeq();\n Function: \n\n            Sets and returns upstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub upStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'upstreamseq'} = $value;\n    }\n   return $self->{'upstreamseq'};\n}\n\n\n=head2 dnStreamSeq\n\n Title   : dnStreamSeq\n Usage   : $obj->dnStreamSeq();\n Function: \n\n            Sets and returns dnstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string","label":"dnStreamSeq($self,$value)"},"children":[{"containerName":"dnStreamSeq","localvar":"my","kind":13,"name":"$self","line":380,"definition":"my"},{"line":380,"containerName":"dnStreamSeq","kind":13,"name":"$value"},{"name":"$value","kind":13,"containerName":"dnStreamSeq","line":381},{"containerName":"dnStreamSeq","kind":13,"name":"$self","line":382},{"name":"$value","containerName":"dnStreamSeq","kind":13,"line":382},{"line":384,"name":"$self","kind":13,"containerName":"dnStreamSeq"}],"containerName":"main::","name":"dnStreamSeq","definition":"sub","detail":"($self,$value)"},{"kind":12,"range":{"start":{"character":0,"line":408},"end":{"line":411,"character":9999}},"line":408,"signature":{"label":"label($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub length {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'length'} = $value;\n  }\n   if ( ! exists $self->{'length'} ) {\n       return 0;\n   } \n   return $self->{'length'};\n}\n\n=head2 upStreamSeq\n\n Title   : upStreamSeq\n Usage   : $obj->upStreamSeq();\n Function: \n\n            Sets and returns upstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub upStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'upstreamseq'} = $value;\n    }\n   return $self->{'upstreamseq'};\n}\n\n\n=head2 dnStreamSeq\n\n Title   : dnStreamSeq\n Usage   : $obj->dnStreamSeq();\n Function: \n\n            Sets and returns dnstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub dnStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'dnstreamseq'} = $value;\n    }\n    return $self->{'dnstreamseq'};\n    \n}\n\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns mutation event label(s).  If value is not\n            set, or no argument is given returns false.  Each\n            instantiable class needs to implement this method. Valid\n            values are listed in 'Mutation event controlled vocabulary' in\n            http://www.ebi.ac.uk/mutations/recommendations/mutevent.html.\n\n Example : \n Returns : string\n Args    : string"},"containerName":"main::","name":"label","children":[{"definition":"my","localvar":"my","containerName":"label","kind":13,"name":"$self","line":409},{"line":409,"name":"$value","kind":13,"containerName":"label"},{"kind":13,"containerName":"label","name":"$self","line":410},{"line":410,"name":"throw_not_implemented","containerName":"label","kind":12}],"detail":"($self,$value)","definition":"sub"},{"detail":"($self,$value)","definition":"sub","name":"status","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"status","kind":13,"line":433},{"line":433,"name":"$value","containerName":"status","kind":13},{"localvar":"my","kind":13,"containerName":"status","name":"%status","line":434,"definition":"my"},{"kind":13,"containerName":"status","name":"$value","line":438},{"line":439,"containerName":"status","kind":13,"name":"$value"},{"name":"$value","kind":13,"containerName":"status","line":439},{"kind":13,"containerName":"status","name":"$status","line":440},{"kind":13,"containerName":"status","name":"$value","line":440},{"line":441,"name":"$self","kind":13,"containerName":"status"},{"name":"$value","containerName":"status","kind":13,"line":441},{"line":444,"kind":13,"containerName":"status","name":"$self"},{"line":444,"containerName":"status","kind":12,"name":"throw"},{"line":447,"kind":13,"containerName":"status","name":"$self"},{"line":450,"containerName":"status","kind":13,"name":"$self"}],"signature":{"label":"status($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub length {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'length'} = $value;\n  }\n   if ( ! exists $self->{'length'} ) {\n       return 0;\n   } \n   return $self->{'length'};\n}\n\n=head2 upStreamSeq\n\n Title   : upStreamSeq\n Usage   : $obj->upStreamSeq();\n Function: \n\n            Sets and returns upstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub upStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'upstreamseq'} = $value;\n    }\n   return $self->{'upstreamseq'};\n}\n\n\n=head2 dnStreamSeq\n\n Title   : dnStreamSeq\n Usage   : $obj->dnStreamSeq();\n Function: \n\n            Sets and returns dnstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub dnStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'dnstreamseq'} = $value;\n    }\n    return $self->{'dnstreamseq'};\n    \n}\n\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns mutation event label(s).  If value is not\n            set, or no argument is given returns false.  Each\n            instantiable class needs to implement this method. Valid\n            values are listed in 'Mutation event controlled vocabulary' in\n            http://www.ebi.ac.uk/mutations/recommendations/mutevent.html.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub label {\n    my ($self,$value) = @_;\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 status\n\n Title   : status\n Usage   : $obj->status()\n Function: \n\n           Returns the status of the sequence change object.\n           Valid values are: 'suspected' and 'proven'\n\n Example : $obj->status('proven');\n Returns : scalar\n Args    : valid string (optional, for setting)"},"kind":12,"range":{"end":{"line":451,"character":9999},"start":{"line":432,"character":0}},"line":432},{"name":"suspected","kind":12,"line":434},{"name":"proven","kind":12,"line":435},{"kind":12,"range":{"start":{"character":0,"line":471},"end":{"line":486,"character":9999}},"line":471,"signature":{"label":"proof($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub length {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'length'} = $value;\n  }\n   if ( ! exists $self->{'length'} ) {\n       return 0;\n   } \n   return $self->{'length'};\n}\n\n=head2 upStreamSeq\n\n Title   : upStreamSeq\n Usage   : $obj->upStreamSeq();\n Function: \n\n            Sets and returns upstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub upStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'upstreamseq'} = $value;\n    }\n   return $self->{'upstreamseq'};\n}\n\n\n=head2 dnStreamSeq\n\n Title   : dnStreamSeq\n Usage   : $obj->dnStreamSeq();\n Function: \n\n            Sets and returns dnstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub dnStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'dnstreamseq'} = $value;\n    }\n    return $self->{'dnstreamseq'};\n    \n}\n\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns mutation event label(s).  If value is not\n            set, or no argument is given returns false.  Each\n            instantiable class needs to implement this method. Valid\n            values are listed in 'Mutation event controlled vocabulary' in\n            http://www.ebi.ac.uk/mutations/recommendations/mutevent.html.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub label {\n    my ($self,$value) = @_;\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 status\n\n Title   : status\n Usage   : $obj->status()\n Function: \n\n           Returns the status of the sequence change object.\n           Valid values are: 'suspected' and 'proven'\n\n Example : $obj->status('proven');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub status {\n   my ($self,$value) = @_;\n   my %status = (suspected => 1,\n\t\t proven => 1\n\t\t );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($status{$value}) {\n\t   $self->{'status'} = $value;\n       } \n       else {\n\t   $self->throw(\"$value is not valid status value!\");\n       }\n    }\n   if( ! exists $self->{'status'} ) {\n       return \"$self\";\n   }\n   return $self->{'status'};\n}\n\n\n=head2 proof\n\n Title   : proof\n Usage   : $obj->proof()\n Function: \n\n           Returns the proof of the sequence change object.\n           Valid values are: 'computed' and 'experimental'.\n\n Example : $obj->proof('computed');\n Returns : scalar\n Args    : valid string (optional, for setting)"},"containerName":"main::","name":"proof","children":[{"definition":"my","line":472,"name":"$self","containerName":"proof","localvar":"my","kind":13},{"kind":13,"containerName":"proof","name":"$value","line":472},{"line":473,"containerName":"proof","localvar":"my","kind":13,"name":"%proof","definition":"my"},{"name":"$value","kind":13,"containerName":"proof","line":477},{"line":478,"name":"$value","kind":13,"containerName":"proof"},{"containerName":"proof","kind":13,"name":"$value","line":478},{"line":479,"name":"$proof","containerName":"proof","kind":13},{"line":479,"kind":13,"containerName":"proof","name":"$value"},{"line":480,"name":"$self","kind":13,"containerName":"proof"},{"line":480,"containerName":"proof","kind":13,"name":"$value"},{"name":"$self","containerName":"proof","kind":13,"line":482},{"name":"throw","kind":12,"containerName":"proof","line":482},{"containerName":"proof","kind":13,"name":"$self","line":485}],"detail":"($self,$value)","definition":"sub"},{"kind":12,"name":"computed","line":473},{"line":474,"kind":12,"name":"experimental"},{"children":[{"definition":"my","line":507,"name":"$self","localvar":"my","kind":13,"containerName":"region"},{"line":507,"name":"$value","containerName":"region","kind":13},{"name":"$value","kind":13,"containerName":"region","line":508},{"line":509,"kind":13,"containerName":"region","name":"$self"},{"line":509,"name":"$value","kind":13,"containerName":"region"},{"name":"$self","containerName":"region","kind":13,"line":511}],"name":"region","containerName":"main::","definition":"sub","detail":"($self,$value)","line":506,"kind":12,"range":{"start":{"character":0,"line":506},"end":{"line":512,"character":9999}},"signature":{"label":"region($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub length {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'length'} = $value;\n  }\n   if ( ! exists $self->{'length'} ) {\n       return 0;\n   } \n   return $self->{'length'};\n}\n\n=head2 upStreamSeq\n\n Title   : upStreamSeq\n Usage   : $obj->upStreamSeq();\n Function: \n\n            Sets and returns upstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub upStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'upstreamseq'} = $value;\n    }\n   return $self->{'upstreamseq'};\n}\n\n\n=head2 dnStreamSeq\n\n Title   : dnStreamSeq\n Usage   : $obj->dnStreamSeq();\n Function: \n\n            Sets and returns dnstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub dnStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'dnstreamseq'} = $value;\n    }\n    return $self->{'dnstreamseq'};\n    \n}\n\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns mutation event label(s).  If value is not\n            set, or no argument is given returns false.  Each\n            instantiable class needs to implement this method. Valid\n            values are listed in 'Mutation event controlled vocabulary' in\n            http://www.ebi.ac.uk/mutations/recommendations/mutevent.html.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub label {\n    my ($self,$value) = @_;\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 status\n\n Title   : status\n Usage   : $obj->status()\n Function: \n\n           Returns the status of the sequence change object.\n           Valid values are: 'suspected' and 'proven'\n\n Example : $obj->status('proven');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub status {\n   my ($self,$value) = @_;\n   my %status = (suspected => 1,\n\t\t proven => 1\n\t\t );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($status{$value}) {\n\t   $self->{'status'} = $value;\n       } \n       else {\n\t   $self->throw(\"$value is not valid status value!\");\n       }\n    }\n   if( ! exists $self->{'status'} ) {\n       return \"$self\";\n   }\n   return $self->{'status'};\n}\n\n\n=head2 proof\n\n Title   : proof\n Usage   : $obj->proof()\n Function: \n\n           Returns the proof of the sequence change object.\n           Valid values are: 'computed' and 'experimental'.\n\n Example : $obj->proof('computed');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub proof {\n    my ($self,$value) = @_;\n    my %proof = (computed => 1,\n\t\t experimental => 1\n\t\t );\n\n    if( defined $value) {\n\t$value = lc $value;\n\tif ($proof{$value}) {\n\t    $self->{'proof'} = $value;\n\t} else {\n\t    $self->throw(\"$value is not valid proof value!\");\n\t}\n    }\n    return $self->{'proof'};\n}\n\n\n=head2 region\n\n Title   : region\n Usage   : $obj->region();\n Function: \n\n            Sets and returns the name of the sequence region type or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string"}},{"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"region_value","children":[{"kind":13,"localvar":"my","containerName":"region_value","name":"$self","line":533,"definition":"my"},{"kind":13,"containerName":"region_value","name":"$value","line":533},{"kind":13,"containerName":"region_value","name":"$value","line":534},{"line":535,"name":"$self","containerName":"region_value","kind":13},{"name":"$value","containerName":"region_value","kind":13,"line":535},{"name":"$self","kind":13,"containerName":"region_value","line":537}],"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub length {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'length'} = $value;\n  }\n   if ( ! exists $self->{'length'} ) {\n       return 0;\n   } \n   return $self->{'length'};\n}\n\n=head2 upStreamSeq\n\n Title   : upStreamSeq\n Usage   : $obj->upStreamSeq();\n Function: \n\n            Sets and returns upstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub upStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'upstreamseq'} = $value;\n    }\n   return $self->{'upstreamseq'};\n}\n\n\n=head2 dnStreamSeq\n\n Title   : dnStreamSeq\n Usage   : $obj->dnStreamSeq();\n Function: \n\n            Sets and returns dnstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub dnStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'dnstreamseq'} = $value;\n    }\n    return $self->{'dnstreamseq'};\n    \n}\n\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns mutation event label(s).  If value is not\n            set, or no argument is given returns false.  Each\n            instantiable class needs to implement this method. Valid\n            values are listed in 'Mutation event controlled vocabulary' in\n            http://www.ebi.ac.uk/mutations/recommendations/mutevent.html.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub label {\n    my ($self,$value) = @_;\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 status\n\n Title   : status\n Usage   : $obj->status()\n Function: \n\n           Returns the status of the sequence change object.\n           Valid values are: 'suspected' and 'proven'\n\n Example : $obj->status('proven');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub status {\n   my ($self,$value) = @_;\n   my %status = (suspected => 1,\n\t\t proven => 1\n\t\t );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($status{$value}) {\n\t   $self->{'status'} = $value;\n       } \n       else {\n\t   $self->throw(\"$value is not valid status value!\");\n       }\n    }\n   if( ! exists $self->{'status'} ) {\n       return \"$self\";\n   }\n   return $self->{'status'};\n}\n\n\n=head2 proof\n\n Title   : proof\n Usage   : $obj->proof()\n Function: \n\n           Returns the proof of the sequence change object.\n           Valid values are: 'computed' and 'experimental'.\n\n Example : $obj->proof('computed');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub proof {\n    my ($self,$value) = @_;\n    my %proof = (computed => 1,\n\t\t experimental => 1\n\t\t );\n\n    if( defined $value) {\n\t$value = lc $value;\n\tif ($proof{$value}) {\n\t    $self->{'proof'} = $value;\n\t} else {\n\t    $self->throw(\"$value is not valid proof value!\");\n\t}\n    }\n    return $self->{'proof'};\n}\n\n\n=head2 region\n\n Title   : region\n Usage   : $obj->region();\n Function: \n\n            Sets and returns the name of the sequence region type or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region'} = $value;\n    }\n    return $self->{'region'};\n}\n\n\n=head2 region_value\n\n Title   : region_value\n Usage   : $obj->region_value();\n Function: \n\n            Sets and returns the name of the sequence region_value or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string","label":"region_value($self,$value)"},"kind":12,"range":{"start":{"line":532,"character":0},"end":{"character":9999,"line":538}},"line":532},{"definition":"sub","detail":"($self,$value)","children":[{"localvar":"my","containerName":"region_dist","kind":13,"name":"$self","line":558,"definition":"my"},{"line":558,"name":"$value","kind":13,"containerName":"region_dist"},{"line":559,"name":"$value","containerName":"region_dist","kind":13},{"containerName":"region_dist","kind":13,"name":"$value","line":560},{"name":"$self","kind":13,"containerName":"region_dist","line":561},{"kind":12,"containerName":"region_dist","name":"throw","line":561},{"line":563,"kind":13,"containerName":"region_dist","name":"$self"},{"name":"$value","kind":13,"containerName":"region_dist","line":563},{"line":566,"kind":13,"containerName":"region_dist","name":"$self"}],"name":"region_dist","containerName":"main::","signature":{"label":"region_dist($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub length {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'length'} = $value;\n  }\n   if ( ! exists $self->{'length'} ) {\n       return 0;\n   } \n   return $self->{'length'};\n}\n\n=head2 upStreamSeq\n\n Title   : upStreamSeq\n Usage   : $obj->upStreamSeq();\n Function: \n\n            Sets and returns upstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub upStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'upstreamseq'} = $value;\n    }\n   return $self->{'upstreamseq'};\n}\n\n\n=head2 dnStreamSeq\n\n Title   : dnStreamSeq\n Usage   : $obj->dnStreamSeq();\n Function: \n\n            Sets and returns dnstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub dnStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'dnstreamseq'} = $value;\n    }\n    return $self->{'dnstreamseq'};\n    \n}\n\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns mutation event label(s).  If value is not\n            set, or no argument is given returns false.  Each\n            instantiable class needs to implement this method. Valid\n            values are listed in 'Mutation event controlled vocabulary' in\n            http://www.ebi.ac.uk/mutations/recommendations/mutevent.html.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub label {\n    my ($self,$value) = @_;\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 status\n\n Title   : status\n Usage   : $obj->status()\n Function: \n\n           Returns the status of the sequence change object.\n           Valid values are: 'suspected' and 'proven'\n\n Example : $obj->status('proven');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub status {\n   my ($self,$value) = @_;\n   my %status = (suspected => 1,\n\t\t proven => 1\n\t\t );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($status{$value}) {\n\t   $self->{'status'} = $value;\n       } \n       else {\n\t   $self->throw(\"$value is not valid status value!\");\n       }\n    }\n   if( ! exists $self->{'status'} ) {\n       return \"$self\";\n   }\n   return $self->{'status'};\n}\n\n\n=head2 proof\n\n Title   : proof\n Usage   : $obj->proof()\n Function: \n\n           Returns the proof of the sequence change object.\n           Valid values are: 'computed' and 'experimental'.\n\n Example : $obj->proof('computed');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub proof {\n    my ($self,$value) = @_;\n    my %proof = (computed => 1,\n\t\t experimental => 1\n\t\t );\n\n    if( defined $value) {\n\t$value = lc $value;\n\tif ($proof{$value}) {\n\t    $self->{'proof'} = $value;\n\t} else {\n\t    $self->throw(\"$value is not valid proof value!\");\n\t}\n    }\n    return $self->{'proof'};\n}\n\n\n=head2 region\n\n Title   : region\n Usage   : $obj->region();\n Function: \n\n            Sets and returns the name of the sequence region type or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region'} = $value;\n    }\n    return $self->{'region'};\n}\n\n\n=head2 region_value\n\n Title   : region_value\n Usage   : $obj->region_value();\n Function: \n\n            Sets and returns the name of the sequence region_value or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region_value {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region_value'} = $value;\n    }\n    return $self->{'region_value'};\n}\n\n=head2 region_dist\n\n Title   : region_dist\n Usage   : $obj->region_dist();\n Function: \n\n            Sets and returns the distance tot the closest region\n            (i.e. intro/exon or domain) boundary. If distance is not\n            set, returns false.\n\n Example : \n Returns : integer\n Args    : integer"},"line":557,"kind":12,"range":{"start":{"character":0,"line":557},"end":{"character":9999,"line":567}}},{"name":"numbering","containerName":"main::","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"numbering","name":"$self","line":588},{"name":"$value","containerName":"numbering","kind":13,"line":588},{"localvar":"my","kind":13,"containerName":"numbering","name":"%numbering","line":589,"definition":"my"},{"line":593,"name":"$value","kind":13,"containerName":"numbering"},{"name":"$value","containerName":"numbering","kind":13,"line":594},{"containerName":"numbering","kind":13,"name":"$value","line":594},{"containerName":"numbering","kind":13,"name":"$numbering","line":595},{"line":595,"containerName":"numbering","kind":13,"name":"$value"},{"name":"$self","containerName":"numbering","kind":13,"line":596},{"line":596,"kind":13,"containerName":"numbering","name":"$value"},{"line":599,"name":"$self","kind":13,"containerName":"numbering"},{"line":599,"kind":12,"containerName":"numbering","name":"throw"},{"line":602,"name":"$self","kind":13,"containerName":"numbering"},{"kind":13,"containerName":"numbering","name":"$self","line":605}],"detail":"($self,$value)","definition":"sub","range":{"start":{"character":0,"line":587},"end":{"line":606,"character":9999}},"kind":12,"line":587,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub length {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'length'} = $value;\n  }\n   if ( ! exists $self->{'length'} ) {\n       return 0;\n   } \n   return $self->{'length'};\n}\n\n=head2 upStreamSeq\n\n Title   : upStreamSeq\n Usage   : $obj->upStreamSeq();\n Function: \n\n            Sets and returns upstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub upStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'upstreamseq'} = $value;\n    }\n   return $self->{'upstreamseq'};\n}\n\n\n=head2 dnStreamSeq\n\n Title   : dnStreamSeq\n Usage   : $obj->dnStreamSeq();\n Function: \n\n            Sets and returns dnstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub dnStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'dnstreamseq'} = $value;\n    }\n    return $self->{'dnstreamseq'};\n    \n}\n\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns mutation event label(s).  If value is not\n            set, or no argument is given returns false.  Each\n            instantiable class needs to implement this method. Valid\n            values are listed in 'Mutation event controlled vocabulary' in\n            http://www.ebi.ac.uk/mutations/recommendations/mutevent.html.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub label {\n    my ($self,$value) = @_;\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 status\n\n Title   : status\n Usage   : $obj->status()\n Function: \n\n           Returns the status of the sequence change object.\n           Valid values are: 'suspected' and 'proven'\n\n Example : $obj->status('proven');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub status {\n   my ($self,$value) = @_;\n   my %status = (suspected => 1,\n\t\t proven => 1\n\t\t );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($status{$value}) {\n\t   $self->{'status'} = $value;\n       } \n       else {\n\t   $self->throw(\"$value is not valid status value!\");\n       }\n    }\n   if( ! exists $self->{'status'} ) {\n       return \"$self\";\n   }\n   return $self->{'status'};\n}\n\n\n=head2 proof\n\n Title   : proof\n Usage   : $obj->proof()\n Function: \n\n           Returns the proof of the sequence change object.\n           Valid values are: 'computed' and 'experimental'.\n\n Example : $obj->proof('computed');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub proof {\n    my ($self,$value) = @_;\n    my %proof = (computed => 1,\n\t\t experimental => 1\n\t\t );\n\n    if( defined $value) {\n\t$value = lc $value;\n\tif ($proof{$value}) {\n\t    $self->{'proof'} = $value;\n\t} else {\n\t    $self->throw(\"$value is not valid proof value!\");\n\t}\n    }\n    return $self->{'proof'};\n}\n\n\n=head2 region\n\n Title   : region\n Usage   : $obj->region();\n Function: \n\n            Sets and returns the name of the sequence region type or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region'} = $value;\n    }\n    return $self->{'region'};\n}\n\n\n=head2 region_value\n\n Title   : region_value\n Usage   : $obj->region_value();\n Function: \n\n            Sets and returns the name of the sequence region_value or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region_value {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region_value'} = $value;\n    }\n    return $self->{'region_value'};\n}\n\n=head2 region_dist\n\n Title   : region_dist\n Usage   : $obj->region_dist();\n Function: \n\n            Sets and returns the distance tot the closest region\n            (i.e. intro/exon or domain) boundary. If distance is not\n            set, returns false.\n\n Example : \n Returns : integer\n Args    : integer\n\n\n\nsub region_dist {\n    my ($self,$value) = @_;\n    if( defined $value) {\n       if (  not $value =~ /^[+-]?\\d+$/ ) {\n\t   $self->throw(\"[$value] for region_dist has to be an integer\\n\");\n        } else {\n\t    $self->{'region_dist'} = $value;\n        }\n    }\n    return $self->{'region_dist'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering()\n Function: \n\n           Returns the numbering chema used locating sequnce features.\n           Valid values are: 'entry' and 'coding'\n\n Example : $obj->numbering('coding');\n Returns : scalar\n Args    : valid string (optional, for setting)","label":"numbering($self,$value)"}},{"kind":12,"name":"entry","line":589},{"kind":12,"name":"coding","line":590},{"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub length {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'length'} = $value;\n  }\n   if ( ! exists $self->{'length'} ) {\n       return 0;\n   } \n   return $self->{'length'};\n}\n\n=head2 upStreamSeq\n\n Title   : upStreamSeq\n Usage   : $obj->upStreamSeq();\n Function: \n\n            Sets and returns upstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub upStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'upstreamseq'} = $value;\n    }\n   return $self->{'upstreamseq'};\n}\n\n\n=head2 dnStreamSeq\n\n Title   : dnStreamSeq\n Usage   : $obj->dnStreamSeq();\n Function: \n\n            Sets and returns dnstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub dnStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'dnstreamseq'} = $value;\n    }\n    return $self->{'dnstreamseq'};\n    \n}\n\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns mutation event label(s).  If value is not\n            set, or no argument is given returns false.  Each\n            instantiable class needs to implement this method. Valid\n            values are listed in 'Mutation event controlled vocabulary' in\n            http://www.ebi.ac.uk/mutations/recommendations/mutevent.html.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub label {\n    my ($self,$value) = @_;\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 status\n\n Title   : status\n Usage   : $obj->status()\n Function: \n\n           Returns the status of the sequence change object.\n           Valid values are: 'suspected' and 'proven'\n\n Example : $obj->status('proven');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub status {\n   my ($self,$value) = @_;\n   my %status = (suspected => 1,\n\t\t proven => 1\n\t\t );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($status{$value}) {\n\t   $self->{'status'} = $value;\n       } \n       else {\n\t   $self->throw(\"$value is not valid status value!\");\n       }\n    }\n   if( ! exists $self->{'status'} ) {\n       return \"$self\";\n   }\n   return $self->{'status'};\n}\n\n\n=head2 proof\n\n Title   : proof\n Usage   : $obj->proof()\n Function: \n\n           Returns the proof of the sequence change object.\n           Valid values are: 'computed' and 'experimental'.\n\n Example : $obj->proof('computed');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub proof {\n    my ($self,$value) = @_;\n    my %proof = (computed => 1,\n\t\t experimental => 1\n\t\t );\n\n    if( defined $value) {\n\t$value = lc $value;\n\tif ($proof{$value}) {\n\t    $self->{'proof'} = $value;\n\t} else {\n\t    $self->throw(\"$value is not valid proof value!\");\n\t}\n    }\n    return $self->{'proof'};\n}\n\n\n=head2 region\n\n Title   : region\n Usage   : $obj->region();\n Function: \n\n            Sets and returns the name of the sequence region type or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region'} = $value;\n    }\n    return $self->{'region'};\n}\n\n\n=head2 region_value\n\n Title   : region_value\n Usage   : $obj->region_value();\n Function: \n\n            Sets and returns the name of the sequence region_value or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region_value {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region_value'} = $value;\n    }\n    return $self->{'region_value'};\n}\n\n=head2 region_dist\n\n Title   : region_dist\n Usage   : $obj->region_dist();\n Function: \n\n            Sets and returns the distance tot the closest region\n            (i.e. intro/exon or domain) boundary. If distance is not\n            set, returns false.\n\n Example : \n Returns : integer\n Args    : integer\n\n\n\nsub region_dist {\n    my ($self,$value) = @_;\n    if( defined $value) {\n       if (  not $value =~ /^[+-]?\\d+$/ ) {\n\t   $self->throw(\"[$value] for region_dist has to be an integer\\n\");\n        } else {\n\t    $self->{'region_dist'} = $value;\n        }\n    }\n    return $self->{'region_dist'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering()\n Function: \n\n           Returns the numbering chema used locating sequnce features.\n           Valid values are: 'entry' and 'coding'\n\n Example : $obj->numbering('coding');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub numbering {\n   my ($self,$value) = @_;\n   my %numbering = (entry => 1,\n\t\t    coding => 1\n\t\t    );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($numbering{$value}) {\n\t   $self->{'numbering'} = $value;\n       } \n       else {\n\t   $self->throw(\"'$value' is not a valid for numbering!\");\n       }\n    }\n   if( ! exists $self->{'numbering'} ) {\n       return \"$self\";\n   }\n   return $self->{'numbering'};\n}\n\n=head2 mut_number\n\n Title   : mut_number\n Usage   : $num = $obj->mut_number;\n         : $num = $obj->mut_number($number);\n Function: \n\n           Returns or sets the number identifying the order in which the\n           mutation has been issued. Numbers shouldstart from 1.\n           If the number has never been set, the method will return ''\n\n           If you want the output from IO modules look nice and, for\n           multivariant/allele variations, make sense you better set\n           this attribute.\n\n Returns : an integer","label":"mut_number($self,$value)"},"line":628,"kind":12,"range":{"start":{"character":0,"line":628},"end":{"character":9999,"line":638}},"definition":"sub","detail":"($self,$value)","children":[{"line":629,"localvar":"my","containerName":"mut_number","kind":13,"name":"$self","definition":"my"},{"line":629,"name":"$value","kind":13,"containerName":"mut_number"},{"line":630,"name":"$value","containerName":"mut_number","kind":13},{"kind":13,"containerName":"mut_number","name":"$self","line":631},{"line":631,"name":"$value","containerName":"mut_number","kind":13},{"containerName":"mut_number","kind":13,"name":"$self","line":633},{"name":"$self","containerName":"mut_number","kind":13,"line":636}],"name":"mut_number","containerName":"main::"},{"signature":{"label":"SeqDiff($self,$value)","documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub length {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'length'} = $value;\n  }\n   if ( ! exists $self->{'length'} ) {\n       return 0;\n   } \n   return $self->{'length'};\n}\n\n=head2 upStreamSeq\n\n Title   : upStreamSeq\n Usage   : $obj->upStreamSeq();\n Function: \n\n            Sets and returns upstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub upStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'upstreamseq'} = $value;\n    }\n   return $self->{'upstreamseq'};\n}\n\n\n=head2 dnStreamSeq\n\n Title   : dnStreamSeq\n Usage   : $obj->dnStreamSeq();\n Function: \n\n            Sets and returns dnstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub dnStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'dnstreamseq'} = $value;\n    }\n    return $self->{'dnstreamseq'};\n    \n}\n\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns mutation event label(s).  If value is not\n            set, or no argument is given returns false.  Each\n            instantiable class needs to implement this method. Valid\n            values are listed in 'Mutation event controlled vocabulary' in\n            http://www.ebi.ac.uk/mutations/recommendations/mutevent.html.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub label {\n    my ($self,$value) = @_;\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 status\n\n Title   : status\n Usage   : $obj->status()\n Function: \n\n           Returns the status of the sequence change object.\n           Valid values are: 'suspected' and 'proven'\n\n Example : $obj->status('proven');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub status {\n   my ($self,$value) = @_;\n   my %status = (suspected => 1,\n\t\t proven => 1\n\t\t );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($status{$value}) {\n\t   $self->{'status'} = $value;\n       } \n       else {\n\t   $self->throw(\"$value is not valid status value!\");\n       }\n    }\n   if( ! exists $self->{'status'} ) {\n       return \"$self\";\n   }\n   return $self->{'status'};\n}\n\n\n=head2 proof\n\n Title   : proof\n Usage   : $obj->proof()\n Function: \n\n           Returns the proof of the sequence change object.\n           Valid values are: 'computed' and 'experimental'.\n\n Example : $obj->proof('computed');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub proof {\n    my ($self,$value) = @_;\n    my %proof = (computed => 1,\n\t\t experimental => 1\n\t\t );\n\n    if( defined $value) {\n\t$value = lc $value;\n\tif ($proof{$value}) {\n\t    $self->{'proof'} = $value;\n\t} else {\n\t    $self->throw(\"$value is not valid proof value!\");\n\t}\n    }\n    return $self->{'proof'};\n}\n\n\n=head2 region\n\n Title   : region\n Usage   : $obj->region();\n Function: \n\n            Sets and returns the name of the sequence region type or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region'} = $value;\n    }\n    return $self->{'region'};\n}\n\n\n=head2 region_value\n\n Title   : region_value\n Usage   : $obj->region_value();\n Function: \n\n            Sets and returns the name of the sequence region_value or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region_value {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region_value'} = $value;\n    }\n    return $self->{'region_value'};\n}\n\n=head2 region_dist\n\n Title   : region_dist\n Usage   : $obj->region_dist();\n Function: \n\n            Sets and returns the distance tot the closest region\n            (i.e. intro/exon or domain) boundary. If distance is not\n            set, returns false.\n\n Example : \n Returns : integer\n Args    : integer\n\n\n\nsub region_dist {\n    my ($self,$value) = @_;\n    if( defined $value) {\n       if (  not $value =~ /^[+-]?\\d+$/ ) {\n\t   $self->throw(\"[$value] for region_dist has to be an integer\\n\");\n        } else {\n\t    $self->{'region_dist'} = $value;\n        }\n    }\n    return $self->{'region_dist'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering()\n Function: \n\n           Returns the numbering chema used locating sequnce features.\n           Valid values are: 'entry' and 'coding'\n\n Example : $obj->numbering('coding');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub numbering {\n   my ($self,$value) = @_;\n   my %numbering = (entry => 1,\n\t\t    coding => 1\n\t\t    );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($numbering{$value}) {\n\t   $self->{'numbering'} = $value;\n       } \n       else {\n\t   $self->throw(\"'$value' is not a valid for numbering!\");\n       }\n    }\n   if( ! exists $self->{'numbering'} ) {\n       return \"$self\";\n   }\n   return $self->{'numbering'};\n}\n\n=head2 mut_number\n\n Title   : mut_number\n Usage   : $num = $obj->mut_number;\n         : $num = $obj->mut_number($number);\n Function: \n\n           Returns or sets the number identifying the order in which the\n           mutation has been issued. Numbers shouldstart from 1.\n           If the number has never been set, the method will return ''\n\n           If you want the output from IO modules look nice and, for\n           multivariant/allele variations, make sense you better set\n           this attribute.\n\n Returns : an integer\n\n\n\nsub mut_number {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'mut_number'} = $value;\n    }\n    unless (exists $self->{'mut_number'}) {\n\treturn ('');\n    } else {\n\treturn $self->{'mut_number'};\n    }\n}       \n\n\n=head2 SeqDiff\n\n Title   : SeqDiff\n Usage   : $mutobj = $obj->SeqDiff;\n         : $mutobj = $obj->SeqDiff($objref);\n Function: \n\n           Returns or sets the link-reference to the umbrella\n           Bio::Variation::SeqDiff object.  If there is no link,\n           it will return undef\n\n           Note: Adding a variant into a SeqDiff object will\n           automatically set this value.\n\n Returns : an obj_ref or undef\n\nSee L<Bio::Variation::SeqDiff> for more information.","parameters":[{"label":"$self"},{"label":"$value"}]},"range":{"end":{"character":9999,"line":677},"start":{"line":661,"character":0}},"kind":12,"line":661,"detail":"($self,$value)","definition":"sub","name":"SeqDiff","containerName":"main::","children":[{"line":662,"containerName":"SeqDiff","localvar":"my","kind":13,"name":"$self","definition":"my"},{"kind":13,"containerName":"SeqDiff","name":"$value","line":662},{"line":663,"kind":13,"containerName":"SeqDiff","name":"$value"},{"line":664,"name":"$value","kind":13,"containerName":"SeqDiff"},{"name":"isa","containerName":"SeqDiff","kind":12,"line":664},{"line":665,"containerName":"SeqDiff","kind":13,"name":"$self"},{"line":665,"containerName":"SeqDiff","kind":12,"name":"throw"},{"line":669,"kind":13,"containerName":"SeqDiff","name":"$self"},{"kind":13,"containerName":"SeqDiff","name":"$value","line":669},{"containerName":"SeqDiff","kind":13,"name":"$self","line":672},{"line":675,"containerName":"SeqDiff","kind":13,"name":"$self"}]},{"children":[{"definition":"my","localvar":"my","kind":13,"containerName":"add_DBLink","name":"$self","line":693},{"line":693,"name":"$com","kind":13,"containerName":"add_DBLink"},{"line":694,"containerName":"add_DBLink","kind":13,"name":"$com"},{"containerName":"add_DBLink","kind":13,"name":"$com","line":694},{"containerName":"add_DBLink","kind":12,"name":"isa","line":694},{"line":695,"kind":13,"containerName":"add_DBLink","name":"$self"},{"line":695,"name":"throw","containerName":"add_DBLink","kind":12},{"line":697,"name":"$com","containerName":"add_DBLink","kind":13},{"line":697,"kind":13,"containerName":"add_DBLink","name":"$self"}],"name":"add_DBLink","containerName":"main::","definition":"sub","detail":"($self,$com)","line":692,"kind":12,"range":{"start":{"character":0,"line":692},"end":{"character":9999,"line":697}},"signature":{"parameters":[{"label":"$self"},{"label":"$com"}],"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub length {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'length'} = $value;\n  }\n   if ( ! exists $self->{'length'} ) {\n       return 0;\n   } \n   return $self->{'length'};\n}\n\n=head2 upStreamSeq\n\n Title   : upStreamSeq\n Usage   : $obj->upStreamSeq();\n Function: \n\n            Sets and returns upstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub upStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'upstreamseq'} = $value;\n    }\n   return $self->{'upstreamseq'};\n}\n\n\n=head2 dnStreamSeq\n\n Title   : dnStreamSeq\n Usage   : $obj->dnStreamSeq();\n Function: \n\n            Sets and returns dnstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub dnStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'dnstreamseq'} = $value;\n    }\n    return $self->{'dnstreamseq'};\n    \n}\n\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns mutation event label(s).  If value is not\n            set, or no argument is given returns false.  Each\n            instantiable class needs to implement this method. Valid\n            values are listed in 'Mutation event controlled vocabulary' in\n            http://www.ebi.ac.uk/mutations/recommendations/mutevent.html.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub label {\n    my ($self,$value) = @_;\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 status\n\n Title   : status\n Usage   : $obj->status()\n Function: \n\n           Returns the status of the sequence change object.\n           Valid values are: 'suspected' and 'proven'\n\n Example : $obj->status('proven');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub status {\n   my ($self,$value) = @_;\n   my %status = (suspected => 1,\n\t\t proven => 1\n\t\t );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($status{$value}) {\n\t   $self->{'status'} = $value;\n       } \n       else {\n\t   $self->throw(\"$value is not valid status value!\");\n       }\n    }\n   if( ! exists $self->{'status'} ) {\n       return \"$self\";\n   }\n   return $self->{'status'};\n}\n\n\n=head2 proof\n\n Title   : proof\n Usage   : $obj->proof()\n Function: \n\n           Returns the proof of the sequence change object.\n           Valid values are: 'computed' and 'experimental'.\n\n Example : $obj->proof('computed');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub proof {\n    my ($self,$value) = @_;\n    my %proof = (computed => 1,\n\t\t experimental => 1\n\t\t );\n\n    if( defined $value) {\n\t$value = lc $value;\n\tif ($proof{$value}) {\n\t    $self->{'proof'} = $value;\n\t} else {\n\t    $self->throw(\"$value is not valid proof value!\");\n\t}\n    }\n    return $self->{'proof'};\n}\n\n\n=head2 region\n\n Title   : region\n Usage   : $obj->region();\n Function: \n\n            Sets and returns the name of the sequence region type or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region'} = $value;\n    }\n    return $self->{'region'};\n}\n\n\n=head2 region_value\n\n Title   : region_value\n Usage   : $obj->region_value();\n Function: \n\n            Sets and returns the name of the sequence region_value or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region_value {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region_value'} = $value;\n    }\n    return $self->{'region_value'};\n}\n\n=head2 region_dist\n\n Title   : region_dist\n Usage   : $obj->region_dist();\n Function: \n\n            Sets and returns the distance tot the closest region\n            (i.e. intro/exon or domain) boundary. If distance is not\n            set, returns false.\n\n Example : \n Returns : integer\n Args    : integer\n\n\n\nsub region_dist {\n    my ($self,$value) = @_;\n    if( defined $value) {\n       if (  not $value =~ /^[+-]?\\d+$/ ) {\n\t   $self->throw(\"[$value] for region_dist has to be an integer\\n\");\n        } else {\n\t    $self->{'region_dist'} = $value;\n        }\n    }\n    return $self->{'region_dist'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering()\n Function: \n\n           Returns the numbering chema used locating sequnce features.\n           Valid values are: 'entry' and 'coding'\n\n Example : $obj->numbering('coding');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub numbering {\n   my ($self,$value) = @_;\n   my %numbering = (entry => 1,\n\t\t    coding => 1\n\t\t    );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($numbering{$value}) {\n\t   $self->{'numbering'} = $value;\n       } \n       else {\n\t   $self->throw(\"'$value' is not a valid for numbering!\");\n       }\n    }\n   if( ! exists $self->{'numbering'} ) {\n       return \"$self\";\n   }\n   return $self->{'numbering'};\n}\n\n=head2 mut_number\n\n Title   : mut_number\n Usage   : $num = $obj->mut_number;\n         : $num = $obj->mut_number($number);\n Function: \n\n           Returns or sets the number identifying the order in which the\n           mutation has been issued. Numbers shouldstart from 1.\n           If the number has never been set, the method will return ''\n\n           If you want the output from IO modules look nice and, for\n           multivariant/allele variations, make sense you better set\n           this attribute.\n\n Returns : an integer\n\n\n\nsub mut_number {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'mut_number'} = $value;\n    }\n    unless (exists $self->{'mut_number'}) {\n\treturn ('');\n    } else {\n\treturn $self->{'mut_number'};\n    }\n}       \n\n\n=head2 SeqDiff\n\n Title   : SeqDiff\n Usage   : $mutobj = $obj->SeqDiff;\n         : $mutobj = $obj->SeqDiff($objref);\n Function: \n\n           Returns or sets the link-reference to the umbrella\n           Bio::Variation::SeqDiff object.  If there is no link,\n           it will return undef\n\n           Note: Adding a variant into a SeqDiff object will\n           automatically set this value.\n\n Returns : an obj_ref or undef\n\nSee L<Bio::Variation::SeqDiff> for more information.\n\n\nsub SeqDiff {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\tif( ! $value->isa('Bio::Variation::SeqDiff') ) {\n\t    $self->throw(\"Is not a Bio::Variation::SeqDiff object but a [$value]\");\n\t    return;\n\t}\n\telse {\n\t    $self->{'seqDiff'} = $value;\n\t}\n    }\n    unless (exists $self->{'seqDiff'}) {\n\treturn;\n    } else {\n\treturn $self->{'seqDiff'};\n    }\n}\n\n=head2 add_DBLink\n\n Title   : add_DBLink\n Usage   : $self->add_DBLink($ref)\n Function: adds a link object\n Example :\n Returns : \n Args    :","label":"add_DBLink($self,$com)"}},{"kind":13,"containerName":null,"name":"$com","line":697},{"signature":{"documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub length {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'length'} = $value;\n  }\n   if ( ! exists $self->{'length'} ) {\n       return 0;\n   } \n   return $self->{'length'};\n}\n\n=head2 upStreamSeq\n\n Title   : upStreamSeq\n Usage   : $obj->upStreamSeq();\n Function: \n\n            Sets and returns upstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub upStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'upstreamseq'} = $value;\n    }\n   return $self->{'upstreamseq'};\n}\n\n\n=head2 dnStreamSeq\n\n Title   : dnStreamSeq\n Usage   : $obj->dnStreamSeq();\n Function: \n\n            Sets and returns dnstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub dnStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'dnstreamseq'} = $value;\n    }\n    return $self->{'dnstreamseq'};\n    \n}\n\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns mutation event label(s).  If value is not\n            set, or no argument is given returns false.  Each\n            instantiable class needs to implement this method. Valid\n            values are listed in 'Mutation event controlled vocabulary' in\n            http://www.ebi.ac.uk/mutations/recommendations/mutevent.html.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub label {\n    my ($self,$value) = @_;\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 status\n\n Title   : status\n Usage   : $obj->status()\n Function: \n\n           Returns the status of the sequence change object.\n           Valid values are: 'suspected' and 'proven'\n\n Example : $obj->status('proven');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub status {\n   my ($self,$value) = @_;\n   my %status = (suspected => 1,\n\t\t proven => 1\n\t\t );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($status{$value}) {\n\t   $self->{'status'} = $value;\n       } \n       else {\n\t   $self->throw(\"$value is not valid status value!\");\n       }\n    }\n   if( ! exists $self->{'status'} ) {\n       return \"$self\";\n   }\n   return $self->{'status'};\n}\n\n\n=head2 proof\n\n Title   : proof\n Usage   : $obj->proof()\n Function: \n\n           Returns the proof of the sequence change object.\n           Valid values are: 'computed' and 'experimental'.\n\n Example : $obj->proof('computed');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub proof {\n    my ($self,$value) = @_;\n    my %proof = (computed => 1,\n\t\t experimental => 1\n\t\t );\n\n    if( defined $value) {\n\t$value = lc $value;\n\tif ($proof{$value}) {\n\t    $self->{'proof'} = $value;\n\t} else {\n\t    $self->throw(\"$value is not valid proof value!\");\n\t}\n    }\n    return $self->{'proof'};\n}\n\n\n=head2 region\n\n Title   : region\n Usage   : $obj->region();\n Function: \n\n            Sets and returns the name of the sequence region type or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region'} = $value;\n    }\n    return $self->{'region'};\n}\n\n\n=head2 region_value\n\n Title   : region_value\n Usage   : $obj->region_value();\n Function: \n\n            Sets and returns the name of the sequence region_value or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region_value {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region_value'} = $value;\n    }\n    return $self->{'region_value'};\n}\n\n=head2 region_dist\n\n Title   : region_dist\n Usage   : $obj->region_dist();\n Function: \n\n            Sets and returns the distance tot the closest region\n            (i.e. intro/exon or domain) boundary. If distance is not\n            set, returns false.\n\n Example : \n Returns : integer\n Args    : integer\n\n\n\nsub region_dist {\n    my ($self,$value) = @_;\n    if( defined $value) {\n       if (  not $value =~ /^[+-]?\\d+$/ ) {\n\t   $self->throw(\"[$value] for region_dist has to be an integer\\n\");\n        } else {\n\t    $self->{'region_dist'} = $value;\n        }\n    }\n    return $self->{'region_dist'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering()\n Function: \n\n           Returns the numbering chema used locating sequnce features.\n           Valid values are: 'entry' and 'coding'\n\n Example : $obj->numbering('coding');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub numbering {\n   my ($self,$value) = @_;\n   my %numbering = (entry => 1,\n\t\t    coding => 1\n\t\t    );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($numbering{$value}) {\n\t   $self->{'numbering'} = $value;\n       } \n       else {\n\t   $self->throw(\"'$value' is not a valid for numbering!\");\n       }\n    }\n   if( ! exists $self->{'numbering'} ) {\n       return \"$self\";\n   }\n   return $self->{'numbering'};\n}\n\n=head2 mut_number\n\n Title   : mut_number\n Usage   : $num = $obj->mut_number;\n         : $num = $obj->mut_number($number);\n Function: \n\n           Returns or sets the number identifying the order in which the\n           mutation has been issued. Numbers shouldstart from 1.\n           If the number has never been set, the method will return ''\n\n           If you want the output from IO modules look nice and, for\n           multivariant/allele variations, make sense you better set\n           this attribute.\n\n Returns : an integer\n\n\n\nsub mut_number {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'mut_number'} = $value;\n    }\n    unless (exists $self->{'mut_number'}) {\n\treturn ('');\n    } else {\n\treturn $self->{'mut_number'};\n    }\n}       \n\n\n=head2 SeqDiff\n\n Title   : SeqDiff\n Usage   : $mutobj = $obj->SeqDiff;\n         : $mutobj = $obj->SeqDiff($objref);\n Function: \n\n           Returns or sets the link-reference to the umbrella\n           Bio::Variation::SeqDiff object.  If there is no link,\n           it will return undef\n\n           Note: Adding a variant into a SeqDiff object will\n           automatically set this value.\n\n Returns : an obj_ref or undef\n\nSee L<Bio::Variation::SeqDiff> for more information.\n\n\nsub SeqDiff {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\tif( ! $value->isa('Bio::Variation::SeqDiff') ) {\n\t    $self->throw(\"Is not a Bio::Variation::SeqDiff object but a [$value]\");\n\t    return;\n\t}\n\telse {\n\t    $self->{'seqDiff'} = $value;\n\t}\n    }\n    unless (exists $self->{'seqDiff'}) {\n\treturn;\n    } else {\n\treturn $self->{'seqDiff'};\n    }\n}\n\n=head2 add_DBLink\n\n Title   : add_DBLink\n Usage   : $self->add_DBLink($ref)\n Function: adds a link object\n Example :\n Returns : \n Args    :\n\n\n\n\nsub add_DBLink{\n   my ($self,$com) = @_;\n   if( $com && ! $com->isa('Bio::Annotation::DBLink') ) {\n       $self->throw(\"Is not a link object but a  [$com]\");\n   }\n   $com && push(@{$self->{'link'}},$com);\n}\n\n=head2 each_DBLink\n\n Title   : each_DBLink\n Usage   : foreach $ref ( $self->each_DBlink() )\n Function: gets an array of DBlink of objects\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"}],"label":"each_DBLink($self)"},"line":712,"range":{"end":{"line":715,"character":9999},"start":{"line":712,"character":0}},"kind":12,"definition":"sub","detail":"($self)","children":[{"name":"$self","localvar":"my","containerName":"each_DBLink","kind":13,"line":713,"definition":"my"},{"name":"$self","kind":13,"containerName":"each_DBLink","line":715}],"name":"each_DBLink","containerName":"main::"},{"definition":"sub","detail":"($self)","children":[{"definition":"my","localvar":"my","containerName":"restriction_changes","kind":13,"name":"$self","line":736},{"kind":13,"containerName":"restriction_changes","name":"$self","line":738},{"definition":"my","name":"%re","containerName":"restriction_changes","localvar":"my","kind":13,"line":739},{"line":742,"name":"$self","kind":13,"containerName":"restriction_changes"},{"kind":12,"containerName":"restriction_changes","name":"isa","line":742},{"line":743,"containerName":"restriction_changes","kind":13,"name":"$self"},{"line":743,"name":"throw","kind":12,"containerName":"restriction_changes"},{"name":"$self","kind":13,"containerName":"restriction_changes","line":747},{"kind":12,"containerName":"restriction_changes","name":"warn","line":747},{"name":"$self","kind":13,"containerName":"restriction_changes","line":748},{"line":748,"kind":12,"containerName":"restriction_changes","name":"upStreamSeq"},{"line":749,"name":"$self","containerName":"restriction_changes","kind":13},{"line":749,"name":"warn","containerName":"restriction_changes","kind":12},{"name":"$self","kind":13,"containerName":"restriction_changes","line":750},{"name":"dnStreamSeq","kind":12,"containerName":"restriction_changes","line":750},{"line":758,"name":"$self","containerName":"restriction_changes","kind":13},{"containerName":"restriction_changes","kind":12,"name":"isa","line":758},{"line":758,"name":"$self","kind":13,"containerName":"restriction_changes"},{"containerName":"restriction_changes","kind":12,"name":"DNAMutation","line":758},{"line":759,"containerName":"restriction_changes","kind":13,"name":"$self"},{"line":759,"containerName":"restriction_changes","kind":12,"name":"upStreamSeq"},{"line":759,"kind":13,"containerName":"restriction_changes","name":"$self"},{"name":"DNAMutation","containerName":"restriction_changes","kind":12,"line":759},{"line":759,"name":"upStreamSeq","kind":12,"containerName":"restriction_changes"},{"line":760,"name":"$self","kind":13,"containerName":"restriction_changes"},{"name":"dnStreamSeq","kind":12,"containerName":"restriction_changes","line":760},{"kind":13,"containerName":"restriction_changes","name":"$self","line":760},{"line":760,"containerName":"restriction_changes","kind":12,"name":"DNAMutation"},{"name":"dnStreamSeq","kind":12,"containerName":"restriction_changes","line":760},{"line":761,"name":"$self","containerName":"restriction_changes","kind":13},{"line":761,"kind":12,"containerName":"restriction_changes","name":"DNAMutation"},{"kind":12,"containerName":"restriction_changes","name":"restriction_changes","line":761},{"line":762,"name":"$self","containerName":"restriction_changes","kind":13},{"line":762,"kind":13,"containerName":"restriction_changes","name":"$self"},{"containerName":"restriction_changes","kind":12,"name":"DNAMutation","line":762},{"line":762,"kind":12,"containerName":"restriction_changes","name":"restriction_changes"},{"line":766,"name":"$le_dn","containerName":"restriction_changes","localvar":"my","kind":13,"definition":"my"},{"name":"$le_up","kind":13,"localvar":"my","containerName":"restriction_changes","line":767,"definition":"my"},{"kind":13,"containerName":"restriction_changes","name":"$le_dn","line":767},{"line":770,"name":"$le_dn","containerName":"restriction_changes","kind":13},{"line":770,"kind":13,"containerName":"restriction_changes","name":"$self"},{"line":770,"name":"dnStreamSeq","kind":12,"containerName":"restriction_changes"},{"name":"$le_dn","containerName":"restriction_changes","kind":13,"line":770},{"name":"$self","containerName":"restriction_changes","kind":13,"line":770},{"kind":12,"containerName":"restriction_changes","name":"dnStreamSeq","line":770},{"name":"$le_up","containerName":"restriction_changes","kind":13,"line":771},{"line":771,"kind":13,"containerName":"restriction_changes","name":"$self"},{"line":771,"name":"upStreamSeq","containerName":"restriction_changes","kind":12},{"name":"$le_up","containerName":"restriction_changes","kind":13,"line":771},{"line":771,"name":"$self","containerName":"restriction_changes","kind":13},{"line":771,"kind":12,"containerName":"restriction_changes","name":"upStreamSeq"},{"containerName":"restriction_changes","localvar":"my","kind":13,"name":"$oriseq","line":774,"definition":"my"},{"line":774,"name":"$mutseq","containerName":"restriction_changes","kind":13},{"line":775,"name":"$oriseq","kind":13,"containerName":"restriction_changes"},{"name":"$mutseq","containerName":"restriction_changes","kind":13,"line":775},{"line":775,"name":"$self","kind":13,"containerName":"restriction_changes"},{"kind":12,"containerName":"restriction_changes","name":"upStreamSeq","line":775},{"kind":13,"containerName":"restriction_changes","name":"$le_up","line":775},{"line":775,"name":"$le_up","containerName":"restriction_changes","kind":13},{"kind":13,"containerName":"restriction_changes","name":"$oriseq","line":776},{"name":"$self","kind":13,"containerName":"restriction_changes","line":776},{"name":"allele_ori","kind":12,"containerName":"restriction_changes","line":776},{"line":776,"containerName":"restriction_changes","kind":12,"name":"seq"},{"line":776,"kind":13,"containerName":"restriction_changes","name":"$self"},{"kind":12,"containerName":"restriction_changes","name":"allele_ori","line":776},{"line":776,"name":"seq","kind":12,"containerName":"restriction_changes"},{"name":"$mutseq","kind":13,"containerName":"restriction_changes","line":777},{"kind":13,"containerName":"restriction_changes","name":"$self","line":777},{"name":"allele_mut","containerName":"restriction_changes","kind":12,"line":777},{"line":777,"name":"seq","containerName":"restriction_changes","kind":12},{"line":777,"kind":13,"containerName":"restriction_changes","name":"$self"},{"name":"allele_mut","kind":12,"containerName":"restriction_changes","line":777},{"line":777,"containerName":"restriction_changes","kind":12,"name":"seq"},{"name":"$oriseq","containerName":"restriction_changes","kind":13,"line":778},{"kind":13,"containerName":"restriction_changes","name":"$self","line":778},{"line":778,"containerName":"restriction_changes","kind":12,"name":"dnStreamSeq"},{"name":"$le_dn","containerName":"restriction_changes","kind":13,"line":778},{"line":779,"name":"$mutseq","containerName":"restriction_changes","kind":13},{"line":779,"kind":13,"containerName":"restriction_changes","name":"$self"},{"line":779,"name":"dnStreamSeq","containerName":"restriction_changes","kind":12},{"line":779,"kind":13,"containerName":"restriction_changes","name":"$le_dn"},{"definition":"my","kind":13,"localvar":"my","containerName":"restriction_changes","name":"$oriseq_rev","line":782},{"kind":13,"containerName":"restriction_changes","name":"$oriseq","line":782},{"line":783,"name":"$mutseq_rev","containerName":"restriction_changes","localvar":"my","kind":13,"definition":"my"},{"name":"$mutseq","containerName":"restriction_changes","kind":13,"line":783},{"definition":"my","kind":13,"localvar":"my","containerName":"restriction_changes","name":"$rec","line":786},{"definition":"my","name":"$enz","containerName":"restriction_changes","localvar":"my","kind":13,"line":787},{"name":"%re","containerName":"restriction_changes","kind":13,"line":787},{"definition":"my","line":788,"name":"$site","localvar":"my","kind":13,"containerName":"restriction_changes"},{"line":788,"kind":13,"containerName":"restriction_changes","name":"$re"},{"line":788,"name":"$enz","kind":13,"containerName":"restriction_changes"},{"definition":"my","line":789,"kind":13,"localvar":"my","containerName":"restriction_changes","name":"@ori"},{"containerName":"restriction_changes","kind":13,"name":"$oriseq","line":789},{"definition":"my","kind":13,"localvar":"my","containerName":"restriction_changes","name":"@mut","line":790},{"line":790,"kind":13,"containerName":"restriction_changes","name":"$mutseq"},{"line":791,"localvar":"my","containerName":"restriction_changes","kind":13,"name":"@ori_r","definition":"my"},{"containerName":"restriction_changes","kind":13,"name":"$oriseq_rev","line":791},{"definition":"my","localvar":"my","kind":13,"containerName":"restriction_changes","name":"@mut_r","line":792},{"name":"$mutseq_rev","containerName":"restriction_changes","kind":13,"line":792},{"name":"$rec","kind":13,"containerName":"restriction_changes","line":794},{"name":"$enz","containerName":"restriction_changes","kind":13,"line":794},{"line":795,"containerName":"restriction_changes","kind":13,"name":"@ori"},{"kind":13,"containerName":"restriction_changes","name":"@mut","line":795},{"containerName":"restriction_changes","kind":13,"name":"@ori_r","line":795},{"kind":13,"containerName":"restriction_changes","name":"@mut_r","line":795},{"line":796,"containerName":"restriction_changes","kind":13,"name":"$rec"},{"line":796,"name":"$enz","kind":13,"containerName":"restriction_changes"},{"containerName":"restriction_changes","kind":13,"name":"@ori","line":797},{"kind":13,"containerName":"restriction_changes","name":"@mut","line":797},{"containerName":"restriction_changes","kind":13,"name":"@ori_r","line":797},{"line":797,"name":"@mut_r","kind":13,"containerName":"restriction_changes"},{"line":800,"kind":13,"containerName":"restriction_changes","name":"$rec"},{"line":800,"kind":13,"containerName":"restriction_changes","name":"$rec"},{"line":800,"kind":13,"containerName":"restriction_changes","name":"$rec"},{"name":"$rec","kind":13,"containerName":"restriction_changes","line":800},{"line":801,"name":"$self","kind":13,"containerName":"restriction_changes"},{"containerName":"restriction_changes","kind":13,"name":"$rec","line":801},{"name":"$self","kind":13,"containerName":"restriction_changes","line":804}],"name":"restriction_changes","containerName":"main::","signature":{"label":"restriction_changes($self)","documentation":"1;\n# $Id: VariantI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::VariantI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::VariantI - Sequence Change SeqFeature abstract class\n\n=head1 SYNOPSIS\n\n  #get Bio::Variant::VariantI somehow\n  print $var->restriction_changes, \"\\n\";\n  foreach $allele ($var->each_Allele) {\n      #work on Bio::Variation::Allele objects\n  }\n\n=head1 DESCRIPTION\n\nThis superclass defines common methods to basic sequence changes.  The\ninstantiable classes Bio::Variation::DNAMutation,\nBio::Variation::RNAChange and Bio::Variation::AAChange use them.\nSee L<Bio::Variation::DNAMutation>, L<Bio::Variation::RNAChange>,\nand L<Bio::Variation::AAChange> for more information.\n\nThese classes store information, heavy computation to detemine allele\nsequences is done elsewhere.\n\nThe database cross-references are implemented as\nBio::Annotation::DBLink objects. The methods to access them are\ndefined in Bio::DBLinkContainerI. See L<Bio::Annotation::DBLink>\nand L<Bio::DBLinkContainerI> for details.\n\nBio::Variation::VariantI redifines and extends\nBio::SeqFeature::Generic for sequence variations. This class\ndescribes specific sequence change events. These events are always\nfrom a specific reference sequence to something different. See\nL<Bio::SeqFeature::Generic> for more information.\n\nIMPORTANT: The notion of reference sequence permeates all\nBio::Variation classes. This is especially important to remember when\ndealing with Alleles. In a polymorphic site, there can be a large\nnumber of alleles. One of then has to be selected to be the reference\nallele (allele_ori). ALL the rest has to be passed to the Variant\nusing the method add_Allele, including the mutated allele in a\ncanonical mutation. The IO modules and generated attributes depend on\nit. They ignore the allele linked to using allele_mut and circulate\neach Allele returned by each_Allele into allele_mut and calculate\nthe changes between that and allele_ori.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Variation::VariantI;\nuse strict;\n# Object preamble - inheritance\n\nuse base qw(Bio::Root::Root Bio::SeqFeature::Generic Bio::DBLinkContainerI);\n\n=head2 id\n\n Title   : id\n Usage   : $obj->id\n Function:\n\n           Read only method. Returns the id of the variation object.\n           The id is the id of the first DBLink object attached to this object.\n\n Example :\n Returns : scalar\n Args    : none\n\n\nsub id {\n   my ($self) = @_;\n   my @ids = $self->each_DBLink;\n   my $id = $ids[0] if scalar @ids > 0;\n   return $id->database. \"::\". $id->primary_id if $id;\n}\n\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $self->add_Allele($allele)\n Function: \n\n\t    Adds one Bio::Variation::Allele into the list of alleles.\n            Note that the method forces the convention that nucleotide\n            sequence is in lower case and amino acds are in upper\n            case.\n\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : Allele object\n\n\n\nsub add_Allele {\n  my ($self,$value) = @_;\n  if (defined $value) {\n      if( ! $value->isa('Bio::Variation::Allele') ) {\n\t  my $com = ref $value;\n\t  $self->throw(\"Is not a Allele object but a  [$com]\");\n\t  return 0;\n      } else {\n\t  if ( $self->isa('Bio::Variation::AAChange') ) {\n\t      $value->seq( uc $value->seq) if $value->seq;\n\t  } else {\n\t      $value->seq( lc $value->seq) if $value->seq;\n\t  } \n\t  push(@{$self->{'alleles'}},$value); \n\t  $self->allele_mut($value); #????\n\t  return 1;\n      }\n  } else {\n      return 0;\n  }\n}\n\n\n=head2 each_Allele\n\n Title   : alleles\n Usage   : $obj->each_Allele();\n Function: \n\n\t     Returns a list of Bio::Variation::Allele objects\n\n Example : \n Returns : list of Alleles\n Args    : none\n\n\nsub each_Allele{\n   my ($self,@args) = @_;\n   return @{$self->{'alleles'}};\n}\n\n\n=head2 isMutation\n\n Title   : isMutation\n Usage   : print join('/', $obj->each_Allele) if not $obj->isMutation;\n Function:\n\n           Returns or sets the boolean value indicating that the\n           variant descibed is a canonical mutation with two alleles\n           assinged to be the original (wild type) allele and mutated\n           allele, respectively. If this value is not set, it is\n           assumed that the Variant descibes polymorphisms.\n\n Returns : a boolean\n\n\nsub isMutation {\n    my ($self,$value) = @_;\n    if (defined $value) {\n        if ($value ) {\n            $self->{'isMutation'} = 1;\n        } else {\n            $self->{'isMutation'} = 0;\n        }\n    }\n    return $self->{'isMutation'};\n} \n\n\n=head2 allele_ori\n\n Title   : allele_ori\n Usage   : $obj->allele_ori();\n Function: \n\n            Links to and returns the Bio::Variation::Allele object.\n            If value is not set, returns false. All other Alleles are\n            compared to this.\n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\nsub allele_ori {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_ori'} = $value;\n       }\n   }\n   return $self->{'allele_ori'};\n}\n\n\n=head2 allele_mut\n\n Title   : allele_mut\n Usage   : $obj->allele_mut();\n Function: \n\n             Links to and returns the Bio::Variation::Allele\n             object.  Sets and returns the mutated allele sequence.\n             If value is not set, returns false.\n\n             Amino acid sequences are stored in upper case characters,\n             others in lower case.\n\n Example : \n Returns : string\n Args    : string\n\nSee L<Bio::Variation::Allele> for more.\n\n\n\nsub allele_mut {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ( ! ref $value || ! $value->isa('Bio::Variation::Allele')) {\n\t   $self->throw(\"Value is not Bio::Variation::Allele but [$value]\");\n       } else {\n\t   if ( $self->isa('Bio::Variation::AAChange') ) {\n\t       $value->seq( uc $value->seq) if $value->seq;\n\t   } else {\n\t       $value->seq( lc $value->seq) if $value->seq;\n\t   } \n\t   $self->{'allele_mut'} = $value;\n       }\n   }\n   return $self->{'allele_mut'};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $obj->length();\n Function: \n\n            Sets and returns the length of the affected original\n            allele sequence.  If value is not set, returns false == 0.\n\n            Value 0 means that the variant position is before the\n            start=end sequence position. (Value 1 would denote a point\n            mutation). This follows the convension to report an\n            insertion (2insT) in equivalent way to a corresponding\n            deletion (2delT) (Think about indel polymorpism ATC <=> AC\n            where the origianal state is not known ).\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub length {\n   my ($self,$value) = @_;\n   if ( defined $value) {\n       $self->{'length'} = $value;\n  }\n   if ( ! exists $self->{'length'} ) {\n       return 0;\n   } \n   return $self->{'length'};\n}\n\n=head2 upStreamSeq\n\n Title   : upStreamSeq\n Usage   : $obj->upStreamSeq();\n Function: \n\n            Sets and returns upstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub upStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'upstreamseq'} = $value;\n    }\n   return $self->{'upstreamseq'};\n}\n\n\n=head2 dnStreamSeq\n\n Title   : dnStreamSeq\n Usage   : $obj->dnStreamSeq();\n Function: \n\n            Sets and returns dnstream flanking sequence string.  If\n            value is not set, returns false. The sequence should be\n            >=25 characters long, if possible.\n\n Example : \n Returns : string or false\n Args    : string\n\n\n\nsub dnStreamSeq {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'dnstreamseq'} = $value;\n    }\n    return $self->{'dnstreamseq'};\n    \n}\n\n\n=head2 label\n\n Title   : label\n Usage   : $obj->label();\n Function: \n\n            Sets and returns mutation event label(s).  If value is not\n            set, or no argument is given returns false.  Each\n            instantiable class needs to implement this method. Valid\n            values are listed in 'Mutation event controlled vocabulary' in\n            http://www.ebi.ac.uk/mutations/recommendations/mutevent.html.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub label {\n    my ($self,$value) = @_;\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 status\n\n Title   : status\n Usage   : $obj->status()\n Function: \n\n           Returns the status of the sequence change object.\n           Valid values are: 'suspected' and 'proven'\n\n Example : $obj->status('proven');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub status {\n   my ($self,$value) = @_;\n   my %status = (suspected => 1,\n\t\t proven => 1\n\t\t );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($status{$value}) {\n\t   $self->{'status'} = $value;\n       } \n       else {\n\t   $self->throw(\"$value is not valid status value!\");\n       }\n    }\n   if( ! exists $self->{'status'} ) {\n       return \"$self\";\n   }\n   return $self->{'status'};\n}\n\n\n=head2 proof\n\n Title   : proof\n Usage   : $obj->proof()\n Function: \n\n           Returns the proof of the sequence change object.\n           Valid values are: 'computed' and 'experimental'.\n\n Example : $obj->proof('computed');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub proof {\n    my ($self,$value) = @_;\n    my %proof = (computed => 1,\n\t\t experimental => 1\n\t\t );\n\n    if( defined $value) {\n\t$value = lc $value;\n\tif ($proof{$value}) {\n\t    $self->{'proof'} = $value;\n\t} else {\n\t    $self->throw(\"$value is not valid proof value!\");\n\t}\n    }\n    return $self->{'proof'};\n}\n\n\n=head2 region\n\n Title   : region\n Usage   : $obj->region();\n Function: \n\n            Sets and returns the name of the sequence region type or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region'} = $value;\n    }\n    return $self->{'region'};\n}\n\n\n=head2 region_value\n\n Title   : region_value\n Usage   : $obj->region_value();\n Function: \n\n            Sets and returns the name of the sequence region_value or\n            protein domain at this location.  If value is not set,\n            returns false.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub region_value {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'region_value'} = $value;\n    }\n    return $self->{'region_value'};\n}\n\n=head2 region_dist\n\n Title   : region_dist\n Usage   : $obj->region_dist();\n Function: \n\n            Sets and returns the distance tot the closest region\n            (i.e. intro/exon or domain) boundary. If distance is not\n            set, returns false.\n\n Example : \n Returns : integer\n Args    : integer\n\n\n\nsub region_dist {\n    my ($self,$value) = @_;\n    if( defined $value) {\n       if (  not $value =~ /^[+-]?\\d+$/ ) {\n\t   $self->throw(\"[$value] for region_dist has to be an integer\\n\");\n        } else {\n\t    $self->{'region_dist'} = $value;\n        }\n    }\n    return $self->{'region_dist'};\n}\n\n\n=head2 numbering\n\n Title   : numbering\n Usage   : $obj->numbering()\n Function: \n\n           Returns the numbering chema used locating sequnce features.\n           Valid values are: 'entry' and 'coding'\n\n Example : $obj->numbering('coding');\n Returns : scalar\n Args    : valid string (optional, for setting)\n\n\n\n\nsub numbering {\n   my ($self,$value) = @_;\n   my %numbering = (entry => 1,\n\t\t    coding => 1\n\t\t    );\n\n   if( defined $value) {\n       $value = lc $value;\n       if ($numbering{$value}) {\n\t   $self->{'numbering'} = $value;\n       } \n       else {\n\t   $self->throw(\"'$value' is not a valid for numbering!\");\n       }\n    }\n   if( ! exists $self->{'numbering'} ) {\n       return \"$self\";\n   }\n   return $self->{'numbering'};\n}\n\n=head2 mut_number\n\n Title   : mut_number\n Usage   : $num = $obj->mut_number;\n         : $num = $obj->mut_number($number);\n Function: \n\n           Returns or sets the number identifying the order in which the\n           mutation has been issued. Numbers shouldstart from 1.\n           If the number has never been set, the method will return ''\n\n           If you want the output from IO modules look nice and, for\n           multivariant/allele variations, make sense you better set\n           this attribute.\n\n Returns : an integer\n\n\n\nsub mut_number {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\t$self->{'mut_number'} = $value;\n    }\n    unless (exists $self->{'mut_number'}) {\n\treturn ('');\n    } else {\n\treturn $self->{'mut_number'};\n    }\n}       \n\n\n=head2 SeqDiff\n\n Title   : SeqDiff\n Usage   : $mutobj = $obj->SeqDiff;\n         : $mutobj = $obj->SeqDiff($objref);\n Function: \n\n           Returns or sets the link-reference to the umbrella\n           Bio::Variation::SeqDiff object.  If there is no link,\n           it will return undef\n\n           Note: Adding a variant into a SeqDiff object will\n           automatically set this value.\n\n Returns : an obj_ref or undef\n\nSee L<Bio::Variation::SeqDiff> for more information.\n\n\nsub SeqDiff {\n    my ($self,$value) = @_;\n    if (defined $value) {\n\tif( ! $value->isa('Bio::Variation::SeqDiff') ) {\n\t    $self->throw(\"Is not a Bio::Variation::SeqDiff object but a [$value]\");\n\t    return;\n\t}\n\telse {\n\t    $self->{'seqDiff'} = $value;\n\t}\n    }\n    unless (exists $self->{'seqDiff'}) {\n\treturn;\n    } else {\n\treturn $self->{'seqDiff'};\n    }\n}\n\n=head2 add_DBLink\n\n Title   : add_DBLink\n Usage   : $self->add_DBLink($ref)\n Function: adds a link object\n Example :\n Returns : \n Args    :\n\n\n\n\nsub add_DBLink{\n   my ($self,$com) = @_;\n   if( $com && ! $com->isa('Bio::Annotation::DBLink') ) {\n       $self->throw(\"Is not a link object but a  [$com]\");\n   }\n   $com && push(@{$self->{'link'}},$com);\n}\n\n=head2 each_DBLink\n\n Title   : each_DBLink\n Usage   : foreach $ref ( $self->each_DBlink() )\n Function: gets an array of DBlink of objects\n Example :\n Returns : \n Args    :\n\n\n\nsub each_DBLink{\n   my ($self) = @_;\n   \n   return @{$self->{'link'}}; \n}\n\n=head2 restriction_changes\n\n Title   : restriction_changes\n Usage   : $obj->restriction_changes();\n Function: \n\n            Returns a string containing a list of restriction\n            enzyme changes of form +EcoRI, separated by\n            commas. Strings need to be valid restriction enzyme names\n            as stored in REBASE. allele_ori and allele_mut need to be assigned.\n\n Example : \n Returns : string\n Args    : string","parameters":[{"label":"$self"}]},"line":735,"range":{"end":{"line":805,"character":9999},"start":{"character":0,"line":735}},"kind":12},{"line":739,"kind":12,"name":"_enzymes"},{"line":770,"kind":12,"containerName":"length","name":"CORE"},{"name":"CORE","containerName":"length","kind":12,"line":770},{"line":771,"name":"CORE","containerName":"length","kind":12},{"line":771,"kind":12,"containerName":"length","name":"CORE"},{"name":"_revcompl","kind":12,"line":782},{"kind":12,"name":"_revcompl","line":783},{"line":800,"name":"CORE","containerName":"length","kind":12},{"line":808,"range":{"start":{"line":808,"character":0},"end":{"line":815,"character":9999}},"kind":12,"children":[{"line":810,"kind":13,"localvar":"my","containerName":"_revcompl","name":"$seq","definition":"my"},{"line":812,"name":"$seq","containerName":"_revcompl","kind":13},{"containerName":"_revcompl","kind":13,"name":"$seq","line":812},{"kind":13,"containerName":"_revcompl","name":"$seq","line":813},{"kind":13,"containerName":"_revcompl","name":"$seq","line":814}],"containerName":"main::","name":"_revcompl","definition":"sub"},{"range":{"end":{"line":1050,"character":9999},"start":{"character":0,"line":818}},"kind":12,"line":818,"containerName":"main::","name":"_enzymes","children":[{"definition":"my","line":820,"containerName":"_enzymes","localvar":"my","kind":13,"name":"%enzymes"},{"name":"%enzymes","kind":13,"containerName":"_enzymes","line":1049}],"definition":"sub"},{"line":820,"containerName":"reverse","kind":12,"name":"CORE"}],"version":5}