{"version":5,"vars":[{"containerName":"","kind":2,"name":"base","line":243},{"signature":{"label":"new($class,%param)","parameters":[{"label":"$class"},{"label":"%param"}],"documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::IO - Handler for sequence variation IO Formats\n\n=head1 SYNOPSIS\n\n    use Bio::Variation::IO;\n\n    $in  = Bio::Variation::IO->new(-file => \"inputfilename\" , \n                                   -format => 'flat');\n    $out = Bio::Variation::IO->new(-file => \">outputfilename\" ,\n                                   -format => 'xml');\n\n    while ( my $seq = $in->next() ) {\n\t   $out->write($seq);\n    }\n\n  # or\n\n    use Bio::Variation::IO;\n\n    #input file format can be read from the file extension (dat|xml)\n    $in  = Bio::Variation::IO->newFh(-file => \"inputfilename\");\n    $out = Bio::Variation::IO->newFh(-format => 'xml');\n\n    # World's shortest flat<->xml format converter:\n    print $out $_ while <$in>;\n\n=head1 DESCRIPTION\n\nBio::Variation::IO is a handler module for the formats in the \nVariation IO set (eg, Bio::Variation::IO::flat). It is the officially \nsanctioned way of getting at the format objects, which most people \nshould use.\n\nThe structure, conventions and most of the code is inherited from\nL<Bio::SeqIO> module. The main difference is that instead of using\nmethods next_seq and write_seq, you drop '_seq' from the method names.\n\nThe idea is that you request a stream object for a particular format.\nAll the stream objects have a notion of an internal file that is read\nfrom or written to. A particular SeqIO object instance is configured\nfor either input or output. A specific example of a stream object is\nthe Bio::Variation::IO::flat object.\n\nEach stream object has functions\n\n   $stream->next();\n\nand\n\n   $stream->write($seqDiff);\n\nalso\n\n   $stream->type() # returns 'INPUT' or 'OUTPUT'\n\nAs an added bonus, you can recover a filehandle that is tied to the\nSeqIO object, allowing you to use the standard E<lt>E<gt> and print \noperations to read and write sequence objects:\n\n    use Bio::Variation::IO;\n\n    $stream = Bio::Variation::IO->newFh(-format => 'flat'); \n    # read from standard input\n\n    while ( $seq = <$stream> ) {\n\t   # do something with $seq\n    }\n\nand\n\n    print $stream $seq; # when stream is in output mode\n\nThis makes the simplest ever reformatter\n\n    #!/usr/local/bin/perl\n\n    $format1 = shift;\n    $format2 = shift;\n\n    use Bio::Variation::IO;\n\n    $in  = Bio::Variation::IO->newFh(-format => $format1 );\n    $out = Bio::Variation::IO->newFh(-format => $format2 );\n\n    print $out $_ while <$in>;\n\n\n=head1 CONSTRUCTORS\n\n=head2 Bio::Variation::IO-E<gt>new()\n\n   $seqIO = Bio::Variation::IO->new(-file => 'filename',   -format=>$format);\n   $seqIO = Bio::Variation::IO->new(-fh   => \\*FILEHANDLE, -format=>$format);\n   $seqIO = Bio::Variation::IO->new(-format => $format);\n\nThe new() class method constructs a new Bio::Variation::IO object.  The\nreturned object can be used to retrieve or print BioSeq objects. new()\naccepts the following parameters:\n\n=over 4\n\n* -file\n\nA file path to be opened for reading or writing.  The usual Perl\nconventions apply:\n\n   'file'       # open file for reading\n   '>file'      # open file for writing\n   '>>file'     # open file for appending\n   '+<file'     # open file read/write\n   'command |'  # open a pipe from the command\n   '| command'  # open a pipe to the command\n\n* -fh\n\nYou may provide new() with a previously-opened filehandle.  For\nexample, to read from STDIN:\n\n   $seqIO = Bio::Variation::IO->new(-fh => \\*STDIN);\n\nNote that you must pass filehandles as references to globs.\n\nIf neither a filehandle nor a filename is specified, then the module\nwill read from the @ARGV array or STDIN, using the familiar E<lt>E<gt>\nsemantics.\n\n* -format\n\nSpecify the format of the file.  Supported formats include:\n\n   flat        pseudo EMBL format\n   xml         seqvar xml format\n\nIf no format is specified and a filename is given, then the module\nwill attempt to deduce it from the filename.  If this is unsuccessful,\nFasta format is assumed.\n\nThe format name is case insensitive.  'FLAT', 'Flat' and 'flat' are\nall supported.\n\n\n=head2 Bio::Variation::IO-E<gt>newFh()\n\n   $fh = Bio::Variation::IO->newFh(-fh   => \\*FILEHANDLE, -format=>$format);\n   $fh = Bio::Variation::IO->newFh(-format => $format);\n   # etc.\n\n   #e.g.\n   $out = Bio::Variation::IO->newFh( '-FORMAT' => 'flat');\n   print $out $seqDiff;\n\nThis constructor behaves like new(), but returns a tied filehandle\nrather than a Bio::Variation::IO object.  You can read sequences from this\nobject using the familiar E<lt>E<gt> operator, and write to it using print().\nThe usual array and $_ semantics work.  For example, you can read all\nsequence objects into an array like this:\n\n  @mutations = <$fh>;\n\nOther operations, such as read(), sysread(), write(), close(), and printf() \nare not supported.\n\n=head1 OBJECT METHODS\n\nSee below for more detailed summaries.  The main methods are:\n\n=head2 $sequence = $seqIO-E<gt>next()\n\nFetch the next sequence from the stream.\n\n=head2 $seqIO-E<gt>write($sequence [,$another_sequence,...])\n\nWrite the specified sequence(s) to the stream.\n\n=head2 TIEHANDLE(), READLINE(), PRINT()\n\nThese provide the tie interface.  See L<perltie> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::IO;\n\nuse strict;\n\n\nuse base qw(Bio::SeqIO);\n\n=head2 new\n\n Title   : new\n Usage   : $stream = Bio::Variation::IO->new(-file => $filename, -format => 'Format')\n Function: Returns a new seqstream\n Returns : A Bio::Variation::IO::Handler initialised with the appropriate format\n Args    : -file => $filename\n           -format => format\n           -fh => filehandle to attach to"},"line":258,"kind":12,"range":{"start":{"character":0,"line":258},"end":{"character":9999,"line":270}},"definition":"sub","detail":"($class,%param)","children":[{"definition":"my","localvar":"my","containerName":"new","kind":13,"name":"$class","line":259},{"kind":13,"containerName":"new","name":"%param","line":259},{"definition":"my","line":260,"name":"$format","containerName":"new","localvar":"my","kind":13},{"name":"@param","kind":13,"containerName":"new","line":262},{"line":262,"containerName":"new","kind":13,"name":"%param"},{"line":262,"kind":13,"containerName":"new","name":"%param"},{"kind":13,"containerName":"new","name":"$format","line":263},{"line":263,"kind":13,"containerName":"new","name":"$param"},{"line":264,"name":"$class","kind":13,"containerName":"new"},{"line":264,"kind":12,"containerName":"new","name":"_guess_format"},{"kind":13,"containerName":"new","name":"$param","line":264},{"line":264,"name":"$ARGV","containerName":"new","kind":13},{"line":266,"kind":13,"containerName":"new","name":"$format"},{"containerName":"new","kind":13,"name":"$class","line":268},{"kind":12,"containerName":"new","name":"_load_format_module","line":268},{"line":268,"name":"$format","containerName":"new","kind":13},{"line":269,"name":"new","containerName":"new","kind":12},{"line":269,"containerName":"new","kind":13,"name":"%param"}],"containerName":"main::","name":"new"},{"signature":{"label":"_load_format_module($class,$format)","parameters":[{"label":"$class"},{"label":"$format"}],"documentation":""},"line":273,"range":{"start":{"character":0,"line":273},"end":{"line":290,"character":9999}},"kind":12,"definition":"sub","detail":"($class,$format)","children":[{"line":274,"name":"$class","localvar":"my","kind":13,"containerName":"_load_format_module","definition":"my"},{"name":"$format","containerName":"_load_format_module","kind":13,"line":274},{"name":"$module","containerName":"_load_format_module","localvar":"my","kind":13,"line":275,"definition":"my"},{"line":275,"name":"$format","containerName":"_load_format_module","kind":13},{"definition":"my","name":"$ok","localvar":"my","containerName":"_load_format_module","kind":13,"line":276},{"name":"$ok","kind":13,"containerName":"_load_format_module","line":278},{"name":"$class","kind":13,"containerName":"_load_format_module","line":278},{"name":"_load_module","kind":12,"containerName":"_load_format_module","line":278},{"line":278,"name":"$module","kind":13,"containerName":"_load_format_module"},{"line":289,"containerName":"_load_format_module","kind":13,"name":"$ok"}],"containerName":"main::","name":"_load_format_module"},{"range":{"end":{"line":305,"character":9999},"start":{"line":302,"character":0}},"kind":12,"line":302,"signature":{"parameters":[{"label":"$self"},{"label":"$seq"}],"documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::IO - Handler for sequence variation IO Formats\n\n=head1 SYNOPSIS\n\n    use Bio::Variation::IO;\n\n    $in  = Bio::Variation::IO->new(-file => \"inputfilename\" , \n                                   -format => 'flat');\n    $out = Bio::Variation::IO->new(-file => \">outputfilename\" ,\n                                   -format => 'xml');\n\n    while ( my $seq = $in->next() ) {\n\t   $out->write($seq);\n    }\n\n  # or\n\n    use Bio::Variation::IO;\n\n    #input file format can be read from the file extension (dat|xml)\n    $in  = Bio::Variation::IO->newFh(-file => \"inputfilename\");\n    $out = Bio::Variation::IO->newFh(-format => 'xml');\n\n    # World's shortest flat<->xml format converter:\n    print $out $_ while <$in>;\n\n=head1 DESCRIPTION\n\nBio::Variation::IO is a handler module for the formats in the \nVariation IO set (eg, Bio::Variation::IO::flat). It is the officially \nsanctioned way of getting at the format objects, which most people \nshould use.\n\nThe structure, conventions and most of the code is inherited from\nL<Bio::SeqIO> module. The main difference is that instead of using\nmethods next_seq and write_seq, you drop '_seq' from the method names.\n\nThe idea is that you request a stream object for a particular format.\nAll the stream objects have a notion of an internal file that is read\nfrom or written to. A particular SeqIO object instance is configured\nfor either input or output. A specific example of a stream object is\nthe Bio::Variation::IO::flat object.\n\nEach stream object has functions\n\n   $stream->next();\n\nand\n\n   $stream->write($seqDiff);\n\nalso\n\n   $stream->type() # returns 'INPUT' or 'OUTPUT'\n\nAs an added bonus, you can recover a filehandle that is tied to the\nSeqIO object, allowing you to use the standard E<lt>E<gt> and print \noperations to read and write sequence objects:\n\n    use Bio::Variation::IO;\n\n    $stream = Bio::Variation::IO->newFh(-format => 'flat'); \n    # read from standard input\n\n    while ( $seq = <$stream> ) {\n\t   # do something with $seq\n    }\n\nand\n\n    print $stream $seq; # when stream is in output mode\n\nThis makes the simplest ever reformatter\n\n    #!/usr/local/bin/perl\n\n    $format1 = shift;\n    $format2 = shift;\n\n    use Bio::Variation::IO;\n\n    $in  = Bio::Variation::IO->newFh(-format => $format1 );\n    $out = Bio::Variation::IO->newFh(-format => $format2 );\n\n    print $out $_ while <$in>;\n\n\n=head1 CONSTRUCTORS\n\n=head2 Bio::Variation::IO-E<gt>new()\n\n   $seqIO = Bio::Variation::IO->new(-file => 'filename',   -format=>$format);\n   $seqIO = Bio::Variation::IO->new(-fh   => \\*FILEHANDLE, -format=>$format);\n   $seqIO = Bio::Variation::IO->new(-format => $format);\n\nThe new() class method constructs a new Bio::Variation::IO object.  The\nreturned object can be used to retrieve or print BioSeq objects. new()\naccepts the following parameters:\n\n=over 4\n\n* -file\n\nA file path to be opened for reading or writing.  The usual Perl\nconventions apply:\n\n   'file'       # open file for reading\n   '>file'      # open file for writing\n   '>>file'     # open file for appending\n   '+<file'     # open file read/write\n   'command |'  # open a pipe from the command\n   '| command'  # open a pipe to the command\n\n* -fh\n\nYou may provide new() with a previously-opened filehandle.  For\nexample, to read from STDIN:\n\n   $seqIO = Bio::Variation::IO->new(-fh => \\*STDIN);\n\nNote that you must pass filehandles as references to globs.\n\nIf neither a filehandle nor a filename is specified, then the module\nwill read from the @ARGV array or STDIN, using the familiar E<lt>E<gt>\nsemantics.\n\n* -format\n\nSpecify the format of the file.  Supported formats include:\n\n   flat        pseudo EMBL format\n   xml         seqvar xml format\n\nIf no format is specified and a filename is given, then the module\nwill attempt to deduce it from the filename.  If this is unsuccessful,\nFasta format is assumed.\n\nThe format name is case insensitive.  'FLAT', 'Flat' and 'flat' are\nall supported.\n\n\n=head2 Bio::Variation::IO-E<gt>newFh()\n\n   $fh = Bio::Variation::IO->newFh(-fh   => \\*FILEHANDLE, -format=>$format);\n   $fh = Bio::Variation::IO->newFh(-format => $format);\n   # etc.\n\n   #e.g.\n   $out = Bio::Variation::IO->newFh( '-FORMAT' => 'flat');\n   print $out $seqDiff;\n\nThis constructor behaves like new(), but returns a tied filehandle\nrather than a Bio::Variation::IO object.  You can read sequences from this\nobject using the familiar E<lt>E<gt> operator, and write to it using print().\nThe usual array and $_ semantics work.  For example, you can read all\nsequence objects into an array like this:\n\n  @mutations = <$fh>;\n\nOther operations, such as read(), sysread(), write(), close(), and printf() \nare not supported.\n\n=head1 OBJECT METHODS\n\nSee below for more detailed summaries.  The main methods are:\n\n=head2 $sequence = $seqIO-E<gt>next()\n\nFetch the next sequence from the stream.\n\n=head2 $seqIO-E<gt>write($sequence [,$another_sequence,...])\n\nWrite the specified sequence(s) to the stream.\n\n=head2 TIEHANDLE(), READLINE(), PRINT()\n\nThese provide the tie interface.  See L<perltie> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::IO;\n\nuse strict;\n\n\nuse base qw(Bio::SeqIO);\n\n=head2 new\n\n Title   : new\n Usage   : $stream = Bio::Variation::IO->new(-file => $filename, -format => 'Format')\n Function: Returns a new seqstream\n Returns : A Bio::Variation::IO::Handler initialised with the appropriate format\n Args    : -file => $filename\n           -format => format\n           -fh => filehandle to attach to\n\n\n\nsub new {\n   my ($class, %param) = @_;\n   my ($format);\n\n   @param{ map { lc $_ } keys %param } = values %param;  # lowercase keys\n   $format = $param{'-format'}\n             || $class->_guess_format( $param{-file} || $ARGV[0] )\n             || 'flat';\n   $format = \"\\L$format\"; # normalize capitalization to lower case\n\n   return unless $class->_load_format_module($format);\n   return \"Bio::Variation::IO::$format\"->new(%param);\n}\n\n\nsub _load_format_module {\n  my ($class, $format) = @_;\n  my $module = \"Bio::Variation::IO::\" . $format;\n  my $ok;  \n  eval {\n      $ok = $class->_load_module($module);\n  };\n  if ( $@ ) {\n    print STDERR <<END;\n$class: $format cannot be found\nException $@\nFor more information about the IO system please see the IO docs.\nThis includes ways of checking for formats at compile time, not run time\nEND\n  ;\n  }\n  return $ok;\n}\n\n=head2 next\n\n Title   : next\n Usage   : $seqDiff = $stream->next\n Function: reads the next $seqDiff object from the stream\n Returns : a Bio::Variation::SeqDiff object\n Args    :","label":"next($self,$seq)"},"name":"next","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"next","line":303},{"name":"$seq","kind":13,"containerName":"next","line":303},{"line":304,"containerName":"next","kind":13,"name":"$self"},{"kind":12,"containerName":"next","name":"throw","line":304}],"detail":"($self,$seq)","definition":"sub"},{"detail":"($self,$seq)","definition":"sub","name":"next_seq","containerName":"main::","children":[{"line":308,"name":"$self","kind":13,"localvar":"my","containerName":"next_seq","definition":"my"},{"line":308,"kind":13,"containerName":"next_seq","name":"$seq"},{"line":309,"name":"$self","containerName":"next_seq","kind":13},{"name":"throw","kind":12,"containerName":"next_seq","line":309},{"line":310,"kind":13,"containerName":"next_seq","name":"$self"},{"line":310,"kind":12,"containerName":"next_seq","name":"next"},{"name":"$seq","containerName":"next_seq","kind":13,"line":310}],"signature":{"label":"next_seq($self,$seq)","parameters":[{"label":"$self"},{"label":"$seq"}],"documentation":""},"kind":12,"range":{"end":{"line":311,"character":9999},"start":{"line":307,"character":0}},"line":307},{"detail":"($self,$seq)","definition":"sub","name":"write","containerName":"main::","children":[{"line":324,"name":"$self","localvar":"my","containerName":"write","kind":13,"definition":"my"},{"kind":13,"containerName":"write","name":"$seq","line":324},{"line":325,"name":"$self","containerName":"write","kind":13},{"line":325,"name":"throw","kind":12,"containerName":"write"}],"signature":{"documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::IO - Handler for sequence variation IO Formats\n\n=head1 SYNOPSIS\n\n    use Bio::Variation::IO;\n\n    $in  = Bio::Variation::IO->new(-file => \"inputfilename\" , \n                                   -format => 'flat');\n    $out = Bio::Variation::IO->new(-file => \">outputfilename\" ,\n                                   -format => 'xml');\n\n    while ( my $seq = $in->next() ) {\n\t   $out->write($seq);\n    }\n\n  # or\n\n    use Bio::Variation::IO;\n\n    #input file format can be read from the file extension (dat|xml)\n    $in  = Bio::Variation::IO->newFh(-file => \"inputfilename\");\n    $out = Bio::Variation::IO->newFh(-format => 'xml');\n\n    # World's shortest flat<->xml format converter:\n    print $out $_ while <$in>;\n\n=head1 DESCRIPTION\n\nBio::Variation::IO is a handler module for the formats in the \nVariation IO set (eg, Bio::Variation::IO::flat). It is the officially \nsanctioned way of getting at the format objects, which most people \nshould use.\n\nThe structure, conventions and most of the code is inherited from\nL<Bio::SeqIO> module. The main difference is that instead of using\nmethods next_seq and write_seq, you drop '_seq' from the method names.\n\nThe idea is that you request a stream object for a particular format.\nAll the stream objects have a notion of an internal file that is read\nfrom or written to. A particular SeqIO object instance is configured\nfor either input or output. A specific example of a stream object is\nthe Bio::Variation::IO::flat object.\n\nEach stream object has functions\n\n   $stream->next();\n\nand\n\n   $stream->write($seqDiff);\n\nalso\n\n   $stream->type() # returns 'INPUT' or 'OUTPUT'\n\nAs an added bonus, you can recover a filehandle that is tied to the\nSeqIO object, allowing you to use the standard E<lt>E<gt> and print \noperations to read and write sequence objects:\n\n    use Bio::Variation::IO;\n\n    $stream = Bio::Variation::IO->newFh(-format => 'flat'); \n    # read from standard input\n\n    while ( $seq = <$stream> ) {\n\t   # do something with $seq\n    }\n\nand\n\n    print $stream $seq; # when stream is in output mode\n\nThis makes the simplest ever reformatter\n\n    #!/usr/local/bin/perl\n\n    $format1 = shift;\n    $format2 = shift;\n\n    use Bio::Variation::IO;\n\n    $in  = Bio::Variation::IO->newFh(-format => $format1 );\n    $out = Bio::Variation::IO->newFh(-format => $format2 );\n\n    print $out $_ while <$in>;\n\n\n=head1 CONSTRUCTORS\n\n=head2 Bio::Variation::IO-E<gt>new()\n\n   $seqIO = Bio::Variation::IO->new(-file => 'filename',   -format=>$format);\n   $seqIO = Bio::Variation::IO->new(-fh   => \\*FILEHANDLE, -format=>$format);\n   $seqIO = Bio::Variation::IO->new(-format => $format);\n\nThe new() class method constructs a new Bio::Variation::IO object.  The\nreturned object can be used to retrieve or print BioSeq objects. new()\naccepts the following parameters:\n\n=over 4\n\n* -file\n\nA file path to be opened for reading or writing.  The usual Perl\nconventions apply:\n\n   'file'       # open file for reading\n   '>file'      # open file for writing\n   '>>file'     # open file for appending\n   '+<file'     # open file read/write\n   'command |'  # open a pipe from the command\n   '| command'  # open a pipe to the command\n\n* -fh\n\nYou may provide new() with a previously-opened filehandle.  For\nexample, to read from STDIN:\n\n   $seqIO = Bio::Variation::IO->new(-fh => \\*STDIN);\n\nNote that you must pass filehandles as references to globs.\n\nIf neither a filehandle nor a filename is specified, then the module\nwill read from the @ARGV array or STDIN, using the familiar E<lt>E<gt>\nsemantics.\n\n* -format\n\nSpecify the format of the file.  Supported formats include:\n\n   flat        pseudo EMBL format\n   xml         seqvar xml format\n\nIf no format is specified and a filename is given, then the module\nwill attempt to deduce it from the filename.  If this is unsuccessful,\nFasta format is assumed.\n\nThe format name is case insensitive.  'FLAT', 'Flat' and 'flat' are\nall supported.\n\n\n=head2 Bio::Variation::IO-E<gt>newFh()\n\n   $fh = Bio::Variation::IO->newFh(-fh   => \\*FILEHANDLE, -format=>$format);\n   $fh = Bio::Variation::IO->newFh(-format => $format);\n   # etc.\n\n   #e.g.\n   $out = Bio::Variation::IO->newFh( '-FORMAT' => 'flat');\n   print $out $seqDiff;\n\nThis constructor behaves like new(), but returns a tied filehandle\nrather than a Bio::Variation::IO object.  You can read sequences from this\nobject using the familiar E<lt>E<gt> operator, and write to it using print().\nThe usual array and $_ semantics work.  For example, you can read all\nsequence objects into an array like this:\n\n  @mutations = <$fh>;\n\nOther operations, such as read(), sysread(), write(), close(), and printf() \nare not supported.\n\n=head1 OBJECT METHODS\n\nSee below for more detailed summaries.  The main methods are:\n\n=head2 $sequence = $seqIO-E<gt>next()\n\nFetch the next sequence from the stream.\n\n=head2 $seqIO-E<gt>write($sequence [,$another_sequence,...])\n\nWrite the specified sequence(s) to the stream.\n\n=head2 TIEHANDLE(), READLINE(), PRINT()\n\nThese provide the tie interface.  See L<perltie> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Variation::IO;\n\nuse strict;\n\n\nuse base qw(Bio::SeqIO);\n\n=head2 new\n\n Title   : new\n Usage   : $stream = Bio::Variation::IO->new(-file => $filename, -format => 'Format')\n Function: Returns a new seqstream\n Returns : A Bio::Variation::IO::Handler initialised with the appropriate format\n Args    : -file => $filename\n           -format => format\n           -fh => filehandle to attach to\n\n\n\nsub new {\n   my ($class, %param) = @_;\n   my ($format);\n\n   @param{ map { lc $_ } keys %param } = values %param;  # lowercase keys\n   $format = $param{'-format'}\n             || $class->_guess_format( $param{-file} || $ARGV[0] )\n             || 'flat';\n   $format = \"\\L$format\"; # normalize capitalization to lower case\n\n   return unless $class->_load_format_module($format);\n   return \"Bio::Variation::IO::$format\"->new(%param);\n}\n\n\nsub _load_format_module {\n  my ($class, $format) = @_;\n  my $module = \"Bio::Variation::IO::\" . $format;\n  my $ok;  \n  eval {\n      $ok = $class->_load_module($module);\n  };\n  if ( $@ ) {\n    print STDERR <<END;\n$class: $format cannot be found\nException $@\nFor more information about the IO system please see the IO docs.\nThis includes ways of checking for formats at compile time, not run time\nEND\n  ;\n  }\n  return $ok;\n}\n\n=head2 next\n\n Title   : next\n Usage   : $seqDiff = $stream->next\n Function: reads the next $seqDiff object from the stream\n Returns : a Bio::Variation::SeqDiff object\n Args    :\n\n\nsub next {\n   my ($self, $seq) = @_;\n   $self->throw(\"Sorry, you cannot read from a generic Bio::Variation::IO object.\");\n}\n\nsub next_seq {\n   my ($self, $seq) = @_;\n   $self->throw(\"These are not sequence objects. Use method 'next' instead of 'next_seq'.\");\n   $self->next($seq);\n}\n\n=head2 write\n\n Title   : write\n Usage   : $stream->write($seq)\n Function: writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Variation::SeqDiff object","parameters":[{"label":"$self"},{"label":"$seq"}],"label":"write($self,$seq)"},"range":{"start":{"character":0,"line":323},"end":{"line":326,"character":9999}},"kind":12,"line":323},{"detail":"($self,$seq)","definition":"sub","name":"write_seq","containerName":"main::","children":[{"definition":"my","line":329,"containerName":"write_seq","localvar":"my","kind":13,"name":"$self"},{"line":329,"kind":13,"containerName":"write_seq","name":"$seq"},{"name":"$self","kind":13,"containerName":"write_seq","line":330},{"line":330,"name":"warn","kind":12,"containerName":"write_seq"},{"name":"$self","containerName":"write_seq","kind":13,"line":331},{"line":331,"name":"write","kind":12,"containerName":"write_seq"},{"line":331,"kind":13,"containerName":"write_seq","name":"$seq"}],"signature":{"label":"write_seq($self,$seq)","documentation":"","parameters":[{"label":"$self"},{"label":"$seq"}]},"kind":12,"range":{"start":{"line":328,"character":0},"end":{"line":332,"character":9999}},"line":328},{"range":{"start":{"line":345,"character":0},"end":{"line":350,"character":9999}},"kind":12,"line":345,"name":"_guess_format","containerName":"main::","children":[{"line":346,"localvar":"my","containerName":"_guess_format","kind":13,"name":"$class","definition":"my"}],"definition":"sub"}]}