{"version":5,"vars":[{"name":"base","kind":2,"containerName":"","line":94},{"detail":"($class,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"new","name":"$class","line":97,"definition":"my"},{"name":"@args","kind":13,"containerName":"new","line":97},{"containerName":"new","localvar":"my","kind":13,"name":"$self","line":98,"definition":"my"},{"containerName":"new","kind":13,"name":"$class","line":98},{"line":98,"kind":13,"containerName":"new","name":"@args"},{"definition":"my","localvar":"my","kind":13,"containerName":"new","name":"$is_reference","line":100},{"line":100,"name":"$repeat_unit","containerName":"new","kind":13},{"line":100,"kind":13,"containerName":"new","name":"$repeat_count"},{"line":101,"kind":13,"containerName":"new","name":"$self"},{"name":"_rearrange","kind":12,"containerName":"new","line":101},{"name":"@args","containerName":"new","kind":13,"line":105},{"name":"$is_reference","kind":13,"containerName":"new","line":107},{"name":"$self","containerName":"new","kind":13,"line":107},{"line":107,"name":"is_reference","kind":12,"containerName":"new"},{"kind":13,"containerName":"new","name":"$is_reference","line":107},{"line":108,"name":"$repeat_unit","kind":13,"containerName":"new"},{"line":108,"name":"$self","containerName":"new","kind":13},{"line":108,"name":"repeat_unit","containerName":"new","kind":12},{"line":108,"containerName":"new","kind":13,"name":"$repeat_unit"},{"line":109,"kind":13,"containerName":"new","name":"$repeat_count"},{"line":109,"kind":13,"containerName":"new","name":"$self"},{"name":"repeat_count","containerName":"new","kind":12,"line":109},{"containerName":"new","kind":13,"name":"$repeat_count","line":109},{"kind":13,"containerName":"new","name":"$self","line":111}],"signature":{"documentation":"","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"range":{"end":{"line":112,"character":9999},"start":{"character":0,"line":96}},"kind":12,"line":96},{"name":"SUPER","containerName":"new","kind":12,"line":98},{"signature":{"label":"is_reference($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Allele.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::Allele\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::Allele - Sequence object with allele-specific attributes\n\n=head1 SYNOPSIS\n\n  $allele1 = Bio::Variation::Allele->new ( -seq => 'A',\n                                           -id  => 'AC00001.1',\n                                           -alphabet => 'dna',\n                                           -is_reference => 1\n                                         );\n\n=head1 DESCRIPTION\n\nList of alleles describe known sequence alternatives in a variable region.\nAlleles are contained in Bio::Variation::VariantI complying objects.\nSee L<Bio::Variation::VariantI> for details.\n\nBio::Varation::Alleles are PrimarySeqI complying objects which can\ncontain database cross references as specified in\nBio::DBLinkContainerI interface, too.\n\nA lot of the complexity with dealing with Allele objects are caused by\nnull alleles; Allele objects that have zero length sequence string.\n\nIn addition describing the allele by its sequence , it possible to\ngive describe repeat structure within the sequence. This done using\nmethods repeat_unit (e.g. 'ca') and repeat_count (e.g. 7).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Variation::Allele;\n\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::PrimarySeq Bio::DBLinkContainerI);\n\nsub new {\n    my($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($is_reference, $repeat_unit, $repeat_count) =\n\t   $self->_rearrange([qw(IS_REFERENCE\n\t\t\t\t REPEAT_UNIT\n\t\t\t\t REPEAT_COUNT\n\t\t\t\t )],\n\t\t\t     @args);\n\n    $is_reference && $self->is_reference($is_reference);\n    $repeat_unit && $self->repeat_unit($repeat_unit);\n    $repeat_count && $self->repeat_count($repeat_count);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 is_reference\n\n Title   : is_reference\n Usage   : $obj->is_reference()\n Function: sets and returns boolean values. \n           Unset values return false.\n Example : $obj->is_reference()\n Returns : boolean\n Args    : optional true of false value"},"range":{"start":{"character":0,"line":129},"end":{"character":9999,"line":141}},"kind":12,"line":129,"detail":"($self,$value)","definition":"sub","name":"is_reference","containerName":"main::","children":[{"definition":"my","line":130,"name":"$self","localvar":"my","containerName":"is_reference","kind":13},{"line":130,"containerName":"is_reference","kind":13,"name":"$value"},{"line":131,"kind":13,"containerName":"is_reference","name":"$value"},{"line":132,"name":"$value","kind":13,"containerName":"is_reference"},{"name":"$value","containerName":"is_reference","kind":13,"line":132},{"kind":13,"containerName":"is_reference","name":"$value","line":132},{"line":133,"name":"$self","containerName":"is_reference","kind":13},{"line":133,"name":"$value","kind":13,"containerName":"is_reference"},{"line":135,"name":"$self","kind":13,"containerName":"is_reference"},{"line":139,"containerName":"is_reference","kind":13,"name":"$self"}]},{"detail":"($self,$com)","definition":"sub","containerName":"main::","name":"add_DBLink","children":[{"name":"$self","localvar":"my","containerName":"add_DBLink","kind":13,"line":158,"definition":"my"},{"name":"$com","kind":13,"containerName":"add_DBLink","line":158},{"line":159,"kind":13,"containerName":"add_DBLink","name":"$com"},{"name":"isa","kind":12,"containerName":"add_DBLink","line":159},{"line":160,"containerName":"add_DBLink","kind":13,"name":"$self"},{"name":"throw","kind":12,"containerName":"add_DBLink","line":160},{"line":162,"name":"$self","containerName":"add_DBLink","kind":13}],"signature":{"documentation":"1;\n# $Id: Allele.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::Allele\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::Allele - Sequence object with allele-specific attributes\n\n=head1 SYNOPSIS\n\n  $allele1 = Bio::Variation::Allele->new ( -seq => 'A',\n                                           -id  => 'AC00001.1',\n                                           -alphabet => 'dna',\n                                           -is_reference => 1\n                                         );\n\n=head1 DESCRIPTION\n\nList of alleles describe known sequence alternatives in a variable region.\nAlleles are contained in Bio::Variation::VariantI complying objects.\nSee L<Bio::Variation::VariantI> for details.\n\nBio::Varation::Alleles are PrimarySeqI complying objects which can\ncontain database cross references as specified in\nBio::DBLinkContainerI interface, too.\n\nA lot of the complexity with dealing with Allele objects are caused by\nnull alleles; Allele objects that have zero length sequence string.\n\nIn addition describing the allele by its sequence , it possible to\ngive describe repeat structure within the sequence. This done using\nmethods repeat_unit (e.g. 'ca') and repeat_count (e.g. 7).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Variation::Allele;\n\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::PrimarySeq Bio::DBLinkContainerI);\n\nsub new {\n    my($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($is_reference, $repeat_unit, $repeat_count) =\n\t   $self->_rearrange([qw(IS_REFERENCE\n\t\t\t\t REPEAT_UNIT\n\t\t\t\t REPEAT_COUNT\n\t\t\t\t )],\n\t\t\t     @args);\n\n    $is_reference && $self->is_reference($is_reference);\n    $repeat_unit && $self->repeat_unit($repeat_unit);\n    $repeat_count && $self->repeat_count($repeat_count);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 is_reference\n\n Title   : is_reference\n Usage   : $obj->is_reference()\n Function: sets and returns boolean values. \n           Unset values return false.\n Example : $obj->is_reference()\n Returns : boolean\n Args    : optional true of false value\n\n\n\n\nsub is_reference {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$value ? ($value = 1) : ($value = 0);\n\t$self->{'is_reference'} = $value;\n    }\n    if( ! exists $self->{'is_reference'} ) {\n\treturn 0;\n    } \n    else {\n\treturn $self->{'is_reference'};\n    }\n}\n\n\n=head2 add_DBLink\n\n Title   : add_DBLink\n Usage   : $self->add_DBLink($ref)\n Function: adds a link object\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"},{"label":"$com"}],"label":"add_DBLink($self,$com)"},"kind":12,"range":{"end":{"character":9999,"line":162},"start":{"character":0,"line":157}},"line":157},{"containerName":null,"kind":13,"name":"$com","line":162},{"definition":"sub","detail":"($self)","children":[{"localvar":"my","containerName":"each_DBLink","kind":13,"name":"$self","line":178,"definition":"my"},{"containerName":"each_DBLink","kind":13,"name":"$self","line":179}],"containerName":"main::","name":"each_DBLink","signature":{"label":"each_DBLink($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Allele.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::Allele\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::Allele - Sequence object with allele-specific attributes\n\n=head1 SYNOPSIS\n\n  $allele1 = Bio::Variation::Allele->new ( -seq => 'A',\n                                           -id  => 'AC00001.1',\n                                           -alphabet => 'dna',\n                                           -is_reference => 1\n                                         );\n\n=head1 DESCRIPTION\n\nList of alleles describe known sequence alternatives in a variable region.\nAlleles are contained in Bio::Variation::VariantI complying objects.\nSee L<Bio::Variation::VariantI> for details.\n\nBio::Varation::Alleles are PrimarySeqI complying objects which can\ncontain database cross references as specified in\nBio::DBLinkContainerI interface, too.\n\nA lot of the complexity with dealing with Allele objects are caused by\nnull alleles; Allele objects that have zero length sequence string.\n\nIn addition describing the allele by its sequence , it possible to\ngive describe repeat structure within the sequence. This done using\nmethods repeat_unit (e.g. 'ca') and repeat_count (e.g. 7).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Variation::Allele;\n\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::PrimarySeq Bio::DBLinkContainerI);\n\nsub new {\n    my($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($is_reference, $repeat_unit, $repeat_count) =\n\t   $self->_rearrange([qw(IS_REFERENCE\n\t\t\t\t REPEAT_UNIT\n\t\t\t\t REPEAT_COUNT\n\t\t\t\t )],\n\t\t\t     @args);\n\n    $is_reference && $self->is_reference($is_reference);\n    $repeat_unit && $self->repeat_unit($repeat_unit);\n    $repeat_count && $self->repeat_count($repeat_count);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 is_reference\n\n Title   : is_reference\n Usage   : $obj->is_reference()\n Function: sets and returns boolean values. \n           Unset values return false.\n Example : $obj->is_reference()\n Returns : boolean\n Args    : optional true of false value\n\n\n\n\nsub is_reference {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$value ? ($value = 1) : ($value = 0);\n\t$self->{'is_reference'} = $value;\n    }\n    if( ! exists $self->{'is_reference'} ) {\n\treturn 0;\n    } \n    else {\n\treturn $self->{'is_reference'};\n    }\n}\n\n\n=head2 add_DBLink\n\n Title   : add_DBLink\n Usage   : $self->add_DBLink($ref)\n Function: adds a link object\n Example :\n Returns : \n Args    :\n\n\n\n\nsub add_DBLink{\n   my ($self,$com) = @_;\n   if( ! $com->isa('Bio::Annotation::DBLink') ) {\n       $self->throw(\"Is not a link object but a  [$com]\");\n   }\n   push(@{$self->{'link'}},$com);\n}\n\n=head2 each_DBLink\n\n Title   : each_DBLink\n Usage   : foreach $ref ( $self->each_DBlink() )\n Function: gets an array of DBlink of objects\n Example :\n Returns : \n Args    :"},"line":177,"kind":12,"range":{"end":{"line":179,"character":9999},"start":{"character":0,"line":177}}},{"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"repeat_unit","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"repeat_unit","line":198},{"name":"$value","containerName":"repeat_unit","kind":13,"line":198},{"kind":13,"containerName":"repeat_unit","name":"$value","line":199},{"kind":13,"containerName":"repeat_unit","name":"$self","line":200},{"line":200,"kind":13,"containerName":"repeat_unit","name":"$value"},{"line":202,"name":"$self","kind":13,"containerName":"repeat_unit"},{"line":202,"name":"$self","kind":13,"containerName":"repeat_unit"},{"line":202,"kind":13,"containerName":"repeat_unit","name":"$self"},{"line":203,"name":"$self","containerName":"repeat_unit","kind":13},{"name":"warn","kind":12,"containerName":"repeat_unit","line":203},{"name":"$self","containerName":"repeat_unit","kind":13,"line":204},{"kind":13,"containerName":"repeat_unit","name":"$self","line":204},{"kind":13,"containerName":"repeat_unit","name":"$self","line":204},{"line":206,"containerName":"repeat_unit","kind":13,"name":"$self"}],"signature":{"documentation":"1;\n# $Id: Allele.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::Allele\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::Allele - Sequence object with allele-specific attributes\n\n=head1 SYNOPSIS\n\n  $allele1 = Bio::Variation::Allele->new ( -seq => 'A',\n                                           -id  => 'AC00001.1',\n                                           -alphabet => 'dna',\n                                           -is_reference => 1\n                                         );\n\n=head1 DESCRIPTION\n\nList of alleles describe known sequence alternatives in a variable region.\nAlleles are contained in Bio::Variation::VariantI complying objects.\nSee L<Bio::Variation::VariantI> for details.\n\nBio::Varation::Alleles are PrimarySeqI complying objects which can\ncontain database cross references as specified in\nBio::DBLinkContainerI interface, too.\n\nA lot of the complexity with dealing with Allele objects are caused by\nnull alleles; Allele objects that have zero length sequence string.\n\nIn addition describing the allele by its sequence , it possible to\ngive describe repeat structure within the sequence. This done using\nmethods repeat_unit (e.g. 'ca') and repeat_count (e.g. 7).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Variation::Allele;\n\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::PrimarySeq Bio::DBLinkContainerI);\n\nsub new {\n    my($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($is_reference, $repeat_unit, $repeat_count) =\n\t   $self->_rearrange([qw(IS_REFERENCE\n\t\t\t\t REPEAT_UNIT\n\t\t\t\t REPEAT_COUNT\n\t\t\t\t )],\n\t\t\t     @args);\n\n    $is_reference && $self->is_reference($is_reference);\n    $repeat_unit && $self->repeat_unit($repeat_unit);\n    $repeat_count && $self->repeat_count($repeat_count);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 is_reference\n\n Title   : is_reference\n Usage   : $obj->is_reference()\n Function: sets and returns boolean values. \n           Unset values return false.\n Example : $obj->is_reference()\n Returns : boolean\n Args    : optional true of false value\n\n\n\n\nsub is_reference {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$value ? ($value = 1) : ($value = 0);\n\t$self->{'is_reference'} = $value;\n    }\n    if( ! exists $self->{'is_reference'} ) {\n\treturn 0;\n    } \n    else {\n\treturn $self->{'is_reference'};\n    }\n}\n\n\n=head2 add_DBLink\n\n Title   : add_DBLink\n Usage   : $self->add_DBLink($ref)\n Function: adds a link object\n Example :\n Returns : \n Args    :\n\n\n\n\nsub add_DBLink{\n   my ($self,$com) = @_;\n   if( ! $com->isa('Bio::Annotation::DBLink') ) {\n       $self->throw(\"Is not a link object but a  [$com]\");\n   }\n   push(@{$self->{'link'}},$com);\n}\n\n=head2 each_DBLink\n\n Title   : each_DBLink\n Usage   : foreach $ref ( $self->each_DBlink() )\n Function: gets an array of DBlink of objects\n Example :\n Returns : \n Args    :\n\n\n\nsub each_DBLink{\n   my ($self) = @_;   \n   return @{$self->{'link'}}; \n}\n\n=head2 repeat_unit\n\n Title   : repeat_unit\n Usage   : $obj->repeat_unit('ca');\n Function: \n\n            Sets and returns the sequence of the repeat_unit the\n            allele is composed of.\n\n Example : \n Returns : string\n Args    : string","parameters":[{"label":"$self"},{"label":"$value"}],"label":"repeat_unit($self,$value)"},"range":{"end":{"character":9999,"line":207},"start":{"line":197,"character":0}},"kind":12,"line":197},{"children":[{"definition":"my","line":225,"name":"$self","kind":13,"localvar":"my","containerName":"repeat_count"},{"line":225,"name":"$value","containerName":"repeat_count","kind":13},{"containerName":"repeat_count","kind":13,"name":"$value","line":226},{"name":"$value","kind":13,"containerName":"repeat_count","line":227},{"name":"$self","kind":13,"containerName":"repeat_count","line":228},{"containerName":"repeat_count","kind":12,"name":"throw","line":228},{"line":230,"kind":13,"containerName":"repeat_count","name":"$self"},{"line":230,"name":"$value","kind":13,"containerName":"repeat_count"},{"name":"$self","kind":13,"containerName":"repeat_count","line":233},{"line":233,"name":"$self","containerName":"repeat_count","kind":13},{"containerName":"repeat_count","kind":13,"name":"$self","line":233},{"line":234,"name":"$self","kind":13,"containerName":"repeat_count"},{"line":234,"containerName":"repeat_count","kind":12,"name":"warn"},{"line":235,"containerName":"repeat_count","kind":13,"name":"$self"},{"line":235,"name":"$self","containerName":"repeat_count","kind":13},{"kind":13,"containerName":"repeat_count","name":"$self","line":235},{"kind":13,"containerName":"repeat_count","name":"$self","line":237}],"name":"repeat_count","containerName":"main::","definition":"sub","detail":"($self,$value)","line":224,"kind":12,"range":{"start":{"line":224,"character":0},"end":{"character":9999,"line":238}},"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Allele.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::Allele\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::Allele - Sequence object with allele-specific attributes\n\n=head1 SYNOPSIS\n\n  $allele1 = Bio::Variation::Allele->new ( -seq => 'A',\n                                           -id  => 'AC00001.1',\n                                           -alphabet => 'dna',\n                                           -is_reference => 1\n                                         );\n\n=head1 DESCRIPTION\n\nList of alleles describe known sequence alternatives in a variable region.\nAlleles are contained in Bio::Variation::VariantI complying objects.\nSee L<Bio::Variation::VariantI> for details.\n\nBio::Varation::Alleles are PrimarySeqI complying objects which can\ncontain database cross references as specified in\nBio::DBLinkContainerI interface, too.\n\nA lot of the complexity with dealing with Allele objects are caused by\nnull alleles; Allele objects that have zero length sequence string.\n\nIn addition describing the allele by its sequence , it possible to\ngive describe repeat structure within the sequence. This done using\nmethods repeat_unit (e.g. 'ca') and repeat_count (e.g. 7).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Variation::Allele;\n\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::PrimarySeq Bio::DBLinkContainerI);\n\nsub new {\n    my($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($is_reference, $repeat_unit, $repeat_count) =\n\t   $self->_rearrange([qw(IS_REFERENCE\n\t\t\t\t REPEAT_UNIT\n\t\t\t\t REPEAT_COUNT\n\t\t\t\t )],\n\t\t\t     @args);\n\n    $is_reference && $self->is_reference($is_reference);\n    $repeat_unit && $self->repeat_unit($repeat_unit);\n    $repeat_count && $self->repeat_count($repeat_count);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 is_reference\n\n Title   : is_reference\n Usage   : $obj->is_reference()\n Function: sets and returns boolean values. \n           Unset values return false.\n Example : $obj->is_reference()\n Returns : boolean\n Args    : optional true of false value\n\n\n\n\nsub is_reference {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$value ? ($value = 1) : ($value = 0);\n\t$self->{'is_reference'} = $value;\n    }\n    if( ! exists $self->{'is_reference'} ) {\n\treturn 0;\n    } \n    else {\n\treturn $self->{'is_reference'};\n    }\n}\n\n\n=head2 add_DBLink\n\n Title   : add_DBLink\n Usage   : $self->add_DBLink($ref)\n Function: adds a link object\n Example :\n Returns : \n Args    :\n\n\n\n\nsub add_DBLink{\n   my ($self,$com) = @_;\n   if( ! $com->isa('Bio::Annotation::DBLink') ) {\n       $self->throw(\"Is not a link object but a  [$com]\");\n   }\n   push(@{$self->{'link'}},$com);\n}\n\n=head2 each_DBLink\n\n Title   : each_DBLink\n Usage   : foreach $ref ( $self->each_DBlink() )\n Function: gets an array of DBlink of objects\n Example :\n Returns : \n Args    :\n\n\n\nsub each_DBLink{\n   my ($self) = @_;   \n   return @{$self->{'link'}}; \n}\n\n=head2 repeat_unit\n\n Title   : repeat_unit\n Usage   : $obj->repeat_unit('ca');\n Function: \n\n            Sets and returns the sequence of the repeat_unit the\n            allele is composed of.\n\n Example : \n Returns : string\n Args    : string\n\n\nsub repeat_unit {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'repeat_unit'} = $value;\n    }\n    if ($self->{'seq'} && $self->{'repeat_unit'} && $self->{'repeat_count'} ) {\n\t$self->warn(\"Repeats do not add up!\") \n\t    if ( $self->{'repeat_unit'} x $self->{'repeat_count'})  ne $self->{'seq'};\n    }\n    return $self->{'repeat_unit'};\n}\n\n=head2 repeat_count\n\n Title   : repeat_count\n Usage   : $obj->repeat_count();\n Function: \n\n            Sets and returns the number of repeat units in the allele.\n\n Example : \n Returns : string\n Args    : string","label":"repeat_count($self,$value)"}},{"signature":{"label":"count($self,$value)","documentation":"1;\n# $Id: Allele.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::Allele\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::Allele - Sequence object with allele-specific attributes\n\n=head1 SYNOPSIS\n\n  $allele1 = Bio::Variation::Allele->new ( -seq => 'A',\n                                           -id  => 'AC00001.1',\n                                           -alphabet => 'dna',\n                                           -is_reference => 1\n                                         );\n\n=head1 DESCRIPTION\n\nList of alleles describe known sequence alternatives in a variable region.\nAlleles are contained in Bio::Variation::VariantI complying objects.\nSee L<Bio::Variation::VariantI> for details.\n\nBio::Varation::Alleles are PrimarySeqI complying objects which can\ncontain database cross references as specified in\nBio::DBLinkContainerI interface, too.\n\nA lot of the complexity with dealing with Allele objects are caused by\nnull alleles; Allele objects that have zero length sequence string.\n\nIn addition describing the allele by its sequence , it possible to\ngive describe repeat structure within the sequence. This done using\nmethods repeat_unit (e.g. 'ca') and repeat_count (e.g. 7).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Variation::Allele;\n\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::PrimarySeq Bio::DBLinkContainerI);\n\nsub new {\n    my($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($is_reference, $repeat_unit, $repeat_count) =\n\t   $self->_rearrange([qw(IS_REFERENCE\n\t\t\t\t REPEAT_UNIT\n\t\t\t\t REPEAT_COUNT\n\t\t\t\t )],\n\t\t\t     @args);\n\n    $is_reference && $self->is_reference($is_reference);\n    $repeat_unit && $self->repeat_unit($repeat_unit);\n    $repeat_count && $self->repeat_count($repeat_count);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 is_reference\n\n Title   : is_reference\n Usage   : $obj->is_reference()\n Function: sets and returns boolean values. \n           Unset values return false.\n Example : $obj->is_reference()\n Returns : boolean\n Args    : optional true of false value\n\n\n\n\nsub is_reference {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$value ? ($value = 1) : ($value = 0);\n\t$self->{'is_reference'} = $value;\n    }\n    if( ! exists $self->{'is_reference'} ) {\n\treturn 0;\n    } \n    else {\n\treturn $self->{'is_reference'};\n    }\n}\n\n\n=head2 add_DBLink\n\n Title   : add_DBLink\n Usage   : $self->add_DBLink($ref)\n Function: adds a link object\n Example :\n Returns : \n Args    :\n\n\n\n\nsub add_DBLink{\n   my ($self,$com) = @_;\n   if( ! $com->isa('Bio::Annotation::DBLink') ) {\n       $self->throw(\"Is not a link object but a  [$com]\");\n   }\n   push(@{$self->{'link'}},$com);\n}\n\n=head2 each_DBLink\n\n Title   : each_DBLink\n Usage   : foreach $ref ( $self->each_DBlink() )\n Function: gets an array of DBlink of objects\n Example :\n Returns : \n Args    :\n\n\n\nsub each_DBLink{\n   my ($self) = @_;   \n   return @{$self->{'link'}}; \n}\n\n=head2 repeat_unit\n\n Title   : repeat_unit\n Usage   : $obj->repeat_unit('ca');\n Function: \n\n            Sets and returns the sequence of the repeat_unit the\n            allele is composed of.\n\n Example : \n Returns : string\n Args    : string\n\n\nsub repeat_unit {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'repeat_unit'} = $value;\n    }\n    if ($self->{'seq'} && $self->{'repeat_unit'} && $self->{'repeat_count'} ) {\n\t$self->warn(\"Repeats do not add up!\") \n\t    if ( $self->{'repeat_unit'} x $self->{'repeat_count'})  ne $self->{'seq'};\n    }\n    return $self->{'repeat_unit'};\n}\n\n=head2 repeat_count\n\n Title   : repeat_count\n Usage   : $obj->repeat_count();\n Function: \n\n            Sets and returns the number of repeat units in the allele.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub repeat_count {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif (  not $value =~ /^\\d+$/ ) {\n\t    $self->throw(\"[$value] for repeat_count has to be a positive integer\\n\");\n\t} else {\n\t    $self->{'repeat_count'} = $value;\n\t}\n    }\n    if ($self->{'seq'} && $self->{'repeat_unit'} && $self->{'repeat_count'} ) {\n\t$self->warn(\"Repeats do not add up!\") \n\t    if ( $self->{'repeat_unit'} x $self->{'repeat_count'})  ne $self->{'seq'};\n    }\n    return $self->{'repeat_count'};\n}\n\n=head2 count\n\n Title   : count\n Usage   : $obj->count();\n Function: \n\n            Sets and returns the number of times this allele was observed.\n\n Example : \n Returns : string\n Args    : string","parameters":[{"label":"$self"},{"label":"$value"}]},"line":254,"kind":12,"range":{"start":{"character":0,"line":254},"end":{"line":264,"character":9999}},"definition":"sub","detail":"($self,$value)","children":[{"name":"$self","localvar":"my","containerName":"count","kind":13,"line":255,"definition":"my"},{"line":255,"name":"$value","containerName":"count","kind":13},{"kind":13,"containerName":"count","name":"$value","line":256},{"kind":13,"containerName":"count","name":"$value","line":257},{"name":"$self","kind":13,"containerName":"count","line":258},{"containerName":"count","kind":12,"name":"throw","line":258},{"line":260,"name":"$self","containerName":"count","kind":13},{"line":260,"containerName":"count","kind":13,"name":"$value"},{"kind":13,"containerName":"count","name":"$self","line":263}],"containerName":"main::","name":"count"},{"definition":"sub","detail":"($self,$value)","children":[{"line":283,"name":"$self","localvar":"my","kind":13,"containerName":"frequency","definition":"my"},{"containerName":"frequency","kind":13,"name":"$value","line":283},{"name":"$value","kind":13,"containerName":"frequency","line":284},{"kind":13,"containerName":"frequency","name":"$value","line":285},{"kind":13,"containerName":"frequency","name":"$self","line":286},{"line":286,"containerName":"frequency","kind":12,"name":"throw"},{"line":288,"name":"$self","kind":13,"containerName":"frequency"},{"line":288,"containerName":"frequency","kind":13,"name":"$value"},{"containerName":"frequency","kind":13,"name":"$self","line":291}],"name":"frequency","containerName":"main::","signature":{"label":"frequency($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Allele.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::Allele\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::Allele - Sequence object with allele-specific attributes\n\n=head1 SYNOPSIS\n\n  $allele1 = Bio::Variation::Allele->new ( -seq => 'A',\n                                           -id  => 'AC00001.1',\n                                           -alphabet => 'dna',\n                                           -is_reference => 1\n                                         );\n\n=head1 DESCRIPTION\n\nList of alleles describe known sequence alternatives in a variable region.\nAlleles are contained in Bio::Variation::VariantI complying objects.\nSee L<Bio::Variation::VariantI> for details.\n\nBio::Varation::Alleles are PrimarySeqI complying objects which can\ncontain database cross references as specified in\nBio::DBLinkContainerI interface, too.\n\nA lot of the complexity with dealing with Allele objects are caused by\nnull alleles; Allele objects that have zero length sequence string.\n\nIn addition describing the allele by its sequence , it possible to\ngive describe repeat structure within the sequence. This done using\nmethods repeat_unit (e.g. 'ca') and repeat_count (e.g. 7).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Variation::Allele;\n\nuse strict;\n\n# Object preamble - inheritance\n\n\nuse base qw(Bio::PrimarySeq Bio::DBLinkContainerI);\n\nsub new {\n    my($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($is_reference, $repeat_unit, $repeat_count) =\n\t   $self->_rearrange([qw(IS_REFERENCE\n\t\t\t\t REPEAT_UNIT\n\t\t\t\t REPEAT_COUNT\n\t\t\t\t )],\n\t\t\t     @args);\n\n    $is_reference && $self->is_reference($is_reference);\n    $repeat_unit && $self->repeat_unit($repeat_unit);\n    $repeat_count && $self->repeat_count($repeat_count);\n\n    return $self; # success - we hope!\n}\n\n\n=head2 is_reference\n\n Title   : is_reference\n Usage   : $obj->is_reference()\n Function: sets and returns boolean values. \n           Unset values return false.\n Example : $obj->is_reference()\n Returns : boolean\n Args    : optional true of false value\n\n\n\n\nsub is_reference {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$value ? ($value = 1) : ($value = 0);\n\t$self->{'is_reference'} = $value;\n    }\n    if( ! exists $self->{'is_reference'} ) {\n\treturn 0;\n    } \n    else {\n\treturn $self->{'is_reference'};\n    }\n}\n\n\n=head2 add_DBLink\n\n Title   : add_DBLink\n Usage   : $self->add_DBLink($ref)\n Function: adds a link object\n Example :\n Returns : \n Args    :\n\n\n\n\nsub add_DBLink{\n   my ($self,$com) = @_;\n   if( ! $com->isa('Bio::Annotation::DBLink') ) {\n       $self->throw(\"Is not a link object but a  [$com]\");\n   }\n   push(@{$self->{'link'}},$com);\n}\n\n=head2 each_DBLink\n\n Title   : each_DBLink\n Usage   : foreach $ref ( $self->each_DBlink() )\n Function: gets an array of DBlink of objects\n Example :\n Returns : \n Args    :\n\n\n\nsub each_DBLink{\n   my ($self) = @_;   \n   return @{$self->{'link'}}; \n}\n\n=head2 repeat_unit\n\n Title   : repeat_unit\n Usage   : $obj->repeat_unit('ca');\n Function: \n\n            Sets and returns the sequence of the repeat_unit the\n            allele is composed of.\n\n Example : \n Returns : string\n Args    : string\n\n\nsub repeat_unit {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'repeat_unit'} = $value;\n    }\n    if ($self->{'seq'} && $self->{'repeat_unit'} && $self->{'repeat_count'} ) {\n\t$self->warn(\"Repeats do not add up!\") \n\t    if ( $self->{'repeat_unit'} x $self->{'repeat_count'})  ne $self->{'seq'};\n    }\n    return $self->{'repeat_unit'};\n}\n\n=head2 repeat_count\n\n Title   : repeat_count\n Usage   : $obj->repeat_count();\n Function: \n\n            Sets and returns the number of repeat units in the allele.\n\n Example : \n Returns : string\n Args    : string\n\n\n\nsub repeat_count {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif (  not $value =~ /^\\d+$/ ) {\n\t    $self->throw(\"[$value] for repeat_count has to be a positive integer\\n\");\n\t} else {\n\t    $self->{'repeat_count'} = $value;\n\t}\n    }\n    if ($self->{'seq'} && $self->{'repeat_unit'} && $self->{'repeat_count'} ) {\n\t$self->warn(\"Repeats do not add up!\") \n\t    if ( $self->{'repeat_unit'} x $self->{'repeat_count'})  ne $self->{'seq'};\n    }\n    return $self->{'repeat_count'};\n}\n\n=head2 count\n\n Title   : count\n Usage   : $obj->count();\n Function: \n\n            Sets and returns the number of times this allele was observed.\n\n Example : \n Returns : string\n Args    : string\n\n\nsub count {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif (  not $value =~ /^\\d+$/ ) {\n\t    $self->throw(\"[$value] for count has to be a positive integer\\n\");\n\t} else {\n\t    $self->{'count'} = $value;\n\t}\n    }\n    return $self->{'count'};\n}\n\n\n=head2 frequency\n\n Title   : frequency\n Usage   : $obj->frequency();\n Function: \n\n            Sets and returns the frequency of the allele in the observed\n            population.\n\n Example : \n Returns : string\n Args    : string"},"line":282,"kind":12,"range":{"start":{"line":282,"character":0},"end":{"line":292,"character":9999}}}]}