{"version":5,"vars":[{"line":104,"name":"base","containerName":"","kind":2},{"detail":"($class,@args)","definition":"sub","containerName":"main::","name":"new","children":[{"name":"$class","localvar":"my","kind":13,"containerName":"new","line":107,"definition":"my"},{"line":107,"name":"@args","kind":13,"containerName":"new"},{"definition":"my","line":108,"name":"$self","localvar":"my","containerName":"new","kind":13},{"name":"$class","kind":13,"containerName":"new","line":108},{"name":"@args","containerName":"new","kind":13,"line":108},{"name":"$aa_ori","localvar":"my","containerName":"new","kind":13,"line":110,"definition":"my"},{"containerName":"new","kind":13,"name":"$aa_mut","line":110},{"line":110,"kind":13,"containerName":"new","name":"$codon_ori"},{"name":"$codon_table","kind":13,"containerName":"new","line":110},{"line":111,"kind":13,"containerName":"new","name":"$self"},{"name":"_rearrange","containerName":"new","kind":12,"line":111},{"line":115,"kind":13,"containerName":"new","name":"@args"},{"line":117,"kind":13,"containerName":"new","name":"$aa_ori"},{"name":"$self","containerName":"new","kind":13,"line":117},{"line":117,"name":"aa_ori","containerName":"new","kind":12},{"name":"$aa_ori","kind":13,"containerName":"new","line":117},{"name":"$aa_mut","containerName":"new","kind":13,"line":118},{"line":118,"containerName":"new","kind":13,"name":"$self"},{"containerName":"new","kind":12,"name":"aa_mut","line":118},{"name":"$aa_mut","kind":13,"containerName":"new","line":118},{"line":119,"name":"$codon_ori","kind":13,"containerName":"new"},{"line":119,"containerName":"new","kind":13,"name":"$self"},{"name":"codon_ori","containerName":"new","kind":12,"line":119},{"line":119,"containerName":"new","kind":13,"name":"$codon_ori"},{"line":120,"name":"$codon_table","kind":13,"containerName":"new"},{"line":120,"name":"$self","containerName":"new","kind":13},{"containerName":"new","kind":12,"name":"codon_table","line":120},{"kind":13,"containerName":"new","name":"$codon_table","line":120},{"line":122,"kind":13,"containerName":"new","name":"$self"}],"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":""},"range":{"end":{"line":124,"character":9999},"start":{"line":106,"character":0}},"kind":12,"line":106},{"containerName":"new","kind":12,"name":"SUPER","line":108},{"kind":12,"range":{"start":{"character":0,"line":145},"end":{"character":9999,"line":155}},"line":145,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: AAReverseMutate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::AAReverseMutate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::AAReverseMutate - point mutation and codon\n  information from single amino acid changes\n\n=head1 SYNOPSIS\n\n    $aamut = Bio::Variation::AAReverseMutate->new\n                 (-aa_ori => 'F', \n\t\t  -aa_mut => 'S',\n\t\t  -codon_ori => 'ttc', # optional\n\t\t  -codon_table => '3'  # defaults to 1\n\t\t  );\n\n   @points = $aamut->each_Variant;\n\n   if (scalar @points > 0 ) {\n       foreach $rnachange ( @points ) {\n   \t   # $rnachange is a Bio::Variation::RNAChange object\n   \t   print \" \", $rnachange->allele_ori->seq, \">\", \n\t   $rnachange->allele_mut->seq, \" in \",\n   \t   $rnachange->codon_ori, \">\", $rnachange->codon_mut,\n   \t   \" at position \", $rnachange->codon_pos, \"\\n\";\n       }\n   } else  {\n       print \"No point mutations possible\\n\",\n   }\n\n=head1 DESCRIPTION\n\nBio::Variation::AAReverseMutate objects take in reference and mutated\namino acid information and deduces potential point mutations at RNA\nlevel leading to this change. The choice can be further limited by\nletting the object know what is the the codon in the reference\nsequence. The results are returned as L<Bio::Variation::RNAChange>\nobjects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Variation::AAReverseMutate;\n\nuse strict;\n\n# Object preamble - inheritance\nuse Bio::Tools::CodonTable;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::Allele;\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my ($aa_ori, $aa_mut, $codon_ori, $codon_table) =\n\t$self->_rearrange([qw(AA_ORI\n\t\t\t      AA_MUT\n\t\t\t      CODON\n\t\t\t      CODON_TABLE\n\t\t\t      )],@args);\n\n  $aa_ori && $self->aa_ori($aa_ori);\n  $aa_mut  && $self->aa_mut($aa_mut);\n  $codon_ori  && $self->codon_ori($codon_ori);\n  $codon_table && $self->codon_table($codon_table);\n\n  return $self; # success - we hope!\n\n}\n\n\n=head2 aa_ori\n\n Title   : aa_ori\n Usage   : $obj->aa_ori();\n Function: \n\n            Sets and returns original aa sequence.  If value is not\n            set, returns false. \n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : single character amino acid code","label":"aa_ori($self,$value)"},"name":"aa_ori","containerName":"main::","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"aa_ori","line":146,"definition":"my"},{"kind":13,"containerName":"aa_ori","name":"$value","line":146},{"line":147,"containerName":"aa_ori","kind":13,"name":"$value"},{"containerName":"aa_ori","kind":13,"name":"$value","line":148},{"line":149,"kind":13,"containerName":"aa_ori","name":"$self"},{"kind":12,"containerName":"aa_ori","name":"throw","line":149},{"name":"$self","kind":13,"containerName":"aa_ori","line":151},{"line":151,"kind":13,"containerName":"aa_ori","name":"$value"},{"line":154,"containerName":"aa_ori","kind":13,"name":"$self"}],"detail":"($self,$value)","definition":"sub"},{"kind":12,"range":{"start":{"line":174,"character":0},"end":{"character":9999,"line":184}},"line":174,"signature":{"documentation":"1;\n# $Id: AAReverseMutate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::AAReverseMutate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::AAReverseMutate - point mutation and codon\n  information from single amino acid changes\n\n=head1 SYNOPSIS\n\n    $aamut = Bio::Variation::AAReverseMutate->new\n                 (-aa_ori => 'F', \n\t\t  -aa_mut => 'S',\n\t\t  -codon_ori => 'ttc', # optional\n\t\t  -codon_table => '3'  # defaults to 1\n\t\t  );\n\n   @points = $aamut->each_Variant;\n\n   if (scalar @points > 0 ) {\n       foreach $rnachange ( @points ) {\n   \t   # $rnachange is a Bio::Variation::RNAChange object\n   \t   print \" \", $rnachange->allele_ori->seq, \">\", \n\t   $rnachange->allele_mut->seq, \" in \",\n   \t   $rnachange->codon_ori, \">\", $rnachange->codon_mut,\n   \t   \" at position \", $rnachange->codon_pos, \"\\n\";\n       }\n   } else  {\n       print \"No point mutations possible\\n\",\n   }\n\n=head1 DESCRIPTION\n\nBio::Variation::AAReverseMutate objects take in reference and mutated\namino acid information and deduces potential point mutations at RNA\nlevel leading to this change. The choice can be further limited by\nletting the object know what is the the codon in the reference\nsequence. The results are returned as L<Bio::Variation::RNAChange>\nobjects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Variation::AAReverseMutate;\n\nuse strict;\n\n# Object preamble - inheritance\nuse Bio::Tools::CodonTable;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::Allele;\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my ($aa_ori, $aa_mut, $codon_ori, $codon_table) =\n\t$self->_rearrange([qw(AA_ORI\n\t\t\t      AA_MUT\n\t\t\t      CODON\n\t\t\t      CODON_TABLE\n\t\t\t      )],@args);\n\n  $aa_ori && $self->aa_ori($aa_ori);\n  $aa_mut  && $self->aa_mut($aa_mut);\n  $codon_ori  && $self->codon_ori($codon_ori);\n  $codon_table && $self->codon_table($codon_table);\n\n  return $self; # success - we hope!\n\n}\n\n\n=head2 aa_ori\n\n Title   : aa_ori\n Usage   : $obj->aa_ori();\n Function: \n\n            Sets and returns original aa sequence.  If value is not\n            set, returns false. \n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : single character amino acid code\n\n\nsub aa_ori {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif (  uc($value) !~ /^[ARNDCQEGHILKMFPSTWYVBZX*]$/ ) {\n\t    $self->throw(\"'$value' is not a valid one letter amino acid symbol\\n\");\n\t} else {\n\t    $self->{'aa_ori'} = uc $value;\n\t}\n    }\n    return $self->{'aa_ori'};    \n}\n\n\n=head2 aa_mut\n\n Title   : aa_mut\n Usage   : $obj->aa_mut();\n Function: \n\n            Sets and returns the mutated allele sequence.  If value is not\n            set, returns false. \n\n Example : \n Returns : string\n Args    : single character amino acid code","parameters":[{"label":"$self"},{"label":"$value"}],"label":"aa_mut($self,$value)"},"name":"aa_mut","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"aa_mut","kind":13,"name":"$self","line":175},{"line":175,"name":"$value","containerName":"aa_mut","kind":13},{"name":"$value","containerName":"aa_mut","kind":13,"line":176},{"containerName":"aa_mut","kind":13,"name":"$value","line":177},{"line":178,"name":"$self","kind":13,"containerName":"aa_mut"},{"line":178,"containerName":"aa_mut","kind":12,"name":"throw"},{"kind":13,"containerName":"aa_mut","name":"$self","line":180},{"containerName":"aa_mut","kind":13,"name":"$value","line":180},{"line":183,"containerName":"aa_mut","kind":13,"name":"$self"}],"detail":"($self,$value)","definition":"sub"},{"line":203,"range":{"start":{"character":0,"line":203},"end":{"character":9999,"line":212}},"kind":12,"signature":{"documentation":"1;\n# $Id: AAReverseMutate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::AAReverseMutate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::AAReverseMutate - point mutation and codon\n  information from single amino acid changes\n\n=head1 SYNOPSIS\n\n    $aamut = Bio::Variation::AAReverseMutate->new\n                 (-aa_ori => 'F', \n\t\t  -aa_mut => 'S',\n\t\t  -codon_ori => 'ttc', # optional\n\t\t  -codon_table => '3'  # defaults to 1\n\t\t  );\n\n   @points = $aamut->each_Variant;\n\n   if (scalar @points > 0 ) {\n       foreach $rnachange ( @points ) {\n   \t   # $rnachange is a Bio::Variation::RNAChange object\n   \t   print \" \", $rnachange->allele_ori->seq, \">\", \n\t   $rnachange->allele_mut->seq, \" in \",\n   \t   $rnachange->codon_ori, \">\", $rnachange->codon_mut,\n   \t   \" at position \", $rnachange->codon_pos, \"\\n\";\n       }\n   } else  {\n       print \"No point mutations possible\\n\",\n   }\n\n=head1 DESCRIPTION\n\nBio::Variation::AAReverseMutate objects take in reference and mutated\namino acid information and deduces potential point mutations at RNA\nlevel leading to this change. The choice can be further limited by\nletting the object know what is the the codon in the reference\nsequence. The results are returned as L<Bio::Variation::RNAChange>\nobjects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Variation::AAReverseMutate;\n\nuse strict;\n\n# Object preamble - inheritance\nuse Bio::Tools::CodonTable;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::Allele;\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my ($aa_ori, $aa_mut, $codon_ori, $codon_table) =\n\t$self->_rearrange([qw(AA_ORI\n\t\t\t      AA_MUT\n\t\t\t      CODON\n\t\t\t      CODON_TABLE\n\t\t\t      )],@args);\n\n  $aa_ori && $self->aa_ori($aa_ori);\n  $aa_mut  && $self->aa_mut($aa_mut);\n  $codon_ori  && $self->codon_ori($codon_ori);\n  $codon_table && $self->codon_table($codon_table);\n\n  return $self; # success - we hope!\n\n}\n\n\n=head2 aa_ori\n\n Title   : aa_ori\n Usage   : $obj->aa_ori();\n Function: \n\n            Sets and returns original aa sequence.  If value is not\n            set, returns false. \n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : single character amino acid code\n\n\nsub aa_ori {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif (  uc($value) !~ /^[ARNDCQEGHILKMFPSTWYVBZX*]$/ ) {\n\t    $self->throw(\"'$value' is not a valid one letter amino acid symbol\\n\");\n\t} else {\n\t    $self->{'aa_ori'} = uc $value;\n\t}\n    }\n    return $self->{'aa_ori'};    \n}\n\n\n=head2 aa_mut\n\n Title   : aa_mut\n Usage   : $obj->aa_mut();\n Function: \n\n            Sets and returns the mutated allele sequence.  If value is not\n            set, returns false. \n\n Example : \n Returns : string\n Args    : single character amino acid code\n\n\n\nsub aa_mut {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif (  uc($value) !~ /^[ARNDCQEGHILKMFPSTWYVBZX*]$/ ) {\n\t    $self->throw(\"'$value' is not a valid one letter amino acid symbol\\n\");\n\t} else {\n\t    $self->{'aa_mut'} = uc $value;\n\t}\n    }\n    return $self->{'aa_mut'};\n}\n\n\n=head2 codon_ori\n\n Title   : codon_ori\n Usage   : $obj->codon_ori();\n Function: \n\n            Sets and returns codon_ori triplet.  If value is not set,\n            returns false.  The string has to be three characters\n            long. The chracter content is not checked.\n\n Example : \n Returns : string\n Args    : string","parameters":[{"label":"$self"},{"label":"$value"}],"label":"codon_ori($self,$value)"},"children":[{"line":204,"name":"$self","localvar":"my","containerName":"codon_ori","kind":13,"definition":"my"},{"kind":13,"containerName":"codon_ori","name":"$value","line":204},{"containerName":"codon_ori","kind":13,"name":"$value","line":205},{"name":"$value","containerName":"codon_ori","kind":13,"line":206},{"kind":13,"containerName":"codon_ori","name":"$value","line":206},{"line":207,"name":"$self","kind":13,"containerName":"codon_ori"},{"line":207,"name":"warn","kind":12,"containerName":"codon_ori"},{"name":"$self","kind":13,"containerName":"codon_ori","line":209},{"name":"$value","kind":13,"containerName":"codon_ori","line":209},{"line":211,"containerName":"codon_ori","kind":13,"name":"$self"}],"name":"codon_ori","containerName":"main::","definition":"sub","detail":"($self,$value)"},{"line":230,"kind":12,"range":{"end":{"character":9999,"line":245},"start":{"line":230,"character":0}},"signature":{"label":"codon_table($self,$value)","documentation":"1;\n# $Id: AAReverseMutate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::AAReverseMutate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::AAReverseMutate - point mutation and codon\n  information from single amino acid changes\n\n=head1 SYNOPSIS\n\n    $aamut = Bio::Variation::AAReverseMutate->new\n                 (-aa_ori => 'F', \n\t\t  -aa_mut => 'S',\n\t\t  -codon_ori => 'ttc', # optional\n\t\t  -codon_table => '3'  # defaults to 1\n\t\t  );\n\n   @points = $aamut->each_Variant;\n\n   if (scalar @points > 0 ) {\n       foreach $rnachange ( @points ) {\n   \t   # $rnachange is a Bio::Variation::RNAChange object\n   \t   print \" \", $rnachange->allele_ori->seq, \">\", \n\t   $rnachange->allele_mut->seq, \" in \",\n   \t   $rnachange->codon_ori, \">\", $rnachange->codon_mut,\n   \t   \" at position \", $rnachange->codon_pos, \"\\n\";\n       }\n   } else  {\n       print \"No point mutations possible\\n\",\n   }\n\n=head1 DESCRIPTION\n\nBio::Variation::AAReverseMutate objects take in reference and mutated\namino acid information and deduces potential point mutations at RNA\nlevel leading to this change. The choice can be further limited by\nletting the object know what is the the codon in the reference\nsequence. The results are returned as L<Bio::Variation::RNAChange>\nobjects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Variation::AAReverseMutate;\n\nuse strict;\n\n# Object preamble - inheritance\nuse Bio::Tools::CodonTable;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::Allele;\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my ($aa_ori, $aa_mut, $codon_ori, $codon_table) =\n\t$self->_rearrange([qw(AA_ORI\n\t\t\t      AA_MUT\n\t\t\t      CODON\n\t\t\t      CODON_TABLE\n\t\t\t      )],@args);\n\n  $aa_ori && $self->aa_ori($aa_ori);\n  $aa_mut  && $self->aa_mut($aa_mut);\n  $codon_ori  && $self->codon_ori($codon_ori);\n  $codon_table && $self->codon_table($codon_table);\n\n  return $self; # success - we hope!\n\n}\n\n\n=head2 aa_ori\n\n Title   : aa_ori\n Usage   : $obj->aa_ori();\n Function: \n\n            Sets and returns original aa sequence.  If value is not\n            set, returns false. \n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : single character amino acid code\n\n\nsub aa_ori {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif (  uc($value) !~ /^[ARNDCQEGHILKMFPSTWYVBZX*]$/ ) {\n\t    $self->throw(\"'$value' is not a valid one letter amino acid symbol\\n\");\n\t} else {\n\t    $self->{'aa_ori'} = uc $value;\n\t}\n    }\n    return $self->{'aa_ori'};    \n}\n\n\n=head2 aa_mut\n\n Title   : aa_mut\n Usage   : $obj->aa_mut();\n Function: \n\n            Sets and returns the mutated allele sequence.  If value is not\n            set, returns false. \n\n Example : \n Returns : string\n Args    : single character amino acid code\n\n\n\nsub aa_mut {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif (  uc($value) !~ /^[ARNDCQEGHILKMFPSTWYVBZX*]$/ ) {\n\t    $self->throw(\"'$value' is not a valid one letter amino acid symbol\\n\");\n\t} else {\n\t    $self->{'aa_mut'} = uc $value;\n\t}\n    }\n    return $self->{'aa_mut'};\n}\n\n\n=head2 codon_ori\n\n Title   : codon_ori\n Usage   : $obj->codon_ori();\n Function: \n\n            Sets and returns codon_ori triplet.  If value is not set,\n            returns false.  The string has to be three characters\n            long. The chracter content is not checked.\n\n Example : \n Returns : string\n Args    : string\n\n\nsub codon_ori {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif (length $value != 3 or lc $value =~ /[^atgc]/) {\n\t    $self->warn(\"Codon string \\\"$value\\\" is not valid unique codon\");\n\t}\n\t$self->{'codon_ori'} = lc $value;\n    }\n    return $self->{'codon_ori'};\n}\n\n=head2 codon_table\n\n Title   : codon_table\n Usage   : $obj->codon_table();\n Function: \n\n            Sets and returns the codon table id of the RNA\n            If value is not set, returns 1, 'universal' code, as the default.\n\n Example : \n Returns : integer\n Args    : none if get, the new value if set","parameters":[{"label":"$self"},{"label":"$value"}]},"children":[{"definition":"my","name":"$self","localvar":"my","containerName":"codon_table","kind":13,"line":231},{"line":231,"name":"$value","kind":13,"containerName":"codon_table"},{"containerName":"codon_table","kind":13,"name":"$value","line":232},{"line":233,"name":"$value","kind":13,"containerName":"codon_table"},{"name":"$self","containerName":"codon_table","kind":13,"line":234},{"name":"throw","kind":12,"containerName":"codon_table","line":234},{"kind":13,"containerName":"codon_table","name":"$self","line":237},{"line":237,"name":"$value","containerName":"codon_table","kind":13},{"line":240,"kind":13,"containerName":"codon_table","name":"$self"},{"line":243,"name":"$self","containerName":"codon_table","kind":13}],"name":"codon_table","containerName":"main::","definition":"sub","detail":"($self,$value)"},{"children":[{"line":263,"localvar":"my","containerName":"each_Variant","kind":13,"name":"$self","definition":"my"},{"name":"@args","containerName":"each_Variant","kind":13,"line":263},{"line":265,"name":"$self","containerName":"each_Variant","kind":13},{"line":265,"name":"throw","containerName":"each_Variant","kind":12},{"line":265,"name":"$self","containerName":"each_Variant","kind":13},{"name":"aa_ori","kind":12,"containerName":"each_Variant","line":265},{"line":266,"name":"$self","containerName":"each_Variant","kind":13},{"line":266,"containerName":"each_Variant","kind":12,"name":"throw"},{"line":266,"name":"$self","containerName":"each_Variant","kind":13},{"line":266,"name":"aa_mut","containerName":"each_Variant","kind":12},{"localvar":"my","containerName":"each_Variant","kind":13,"name":"@points","line":268,"definition":"my"},{"kind":13,"containerName":"each_Variant","name":"$codon_pos","line":268},{"kind":13,"containerName":"each_Variant","name":"$allele_ori","line":268},{"name":"$allele_mut","kind":13,"containerName":"each_Variant","line":268},{"localvar":"my","containerName":"each_Variant","kind":13,"name":"$ct","line":269,"definition":"my"},{"line":269,"kind":12,"containerName":"each_Variant","name":"new"},{"name":"$self","containerName":"each_Variant","kind":13,"line":269},{"line":269,"name":"codon_table","containerName":"each_Variant","kind":12},{"definition":"my","name":"$codon_ori","localvar":"my","containerName":"each_Variant","kind":13,"line":270},{"line":270,"name":"$ct","kind":13,"containerName":"each_Variant"},{"name":"revtranslate","containerName":"each_Variant","kind":12,"line":270},{"name":"$self","kind":13,"containerName":"each_Variant","line":270},{"line":270,"containerName":"each_Variant","kind":12,"name":"aa_ori"},{"line":271,"name":"$self","kind":13,"containerName":"each_Variant"},{"kind":12,"containerName":"each_Variant","name":"codon_ori","line":271},{"name":"$self","containerName":"each_Variant","kind":13,"line":271},{"name":"codon_ori","kind":12,"containerName":"each_Variant","line":271},{"containerName":"each_Variant","kind":13,"name":"$codon_ori","line":271},{"definition":"my","localvar":"my","containerName":"each_Variant","kind":13,"name":"$codon_mut","line":272},{"line":272,"name":"$ct","containerName":"each_Variant","kind":13},{"line":272,"name":"revtranslate","containerName":"each_Variant","kind":12},{"line":272,"containerName":"each_Variant","kind":13,"name":"$self"},{"name":"aa_mut","kind":12,"containerName":"each_Variant","line":272},{"definition":"my","name":"$k","localvar":"my","kind":13,"containerName":"each_Variant","line":273},{"name":"$length","localvar":"my","kind":13,"containerName":"each_Variant","line":274,"definition":"my"},{"line":275,"kind":13,"containerName":"each_Variant","name":"$codon_pos"},{"kind":13,"containerName":"each_Variant","name":"$allele_ori","line":275},{"containerName":"each_Variant","kind":13,"name":"$allele_mut","line":275},{"containerName":"each_Variant","kind":13,"name":"$k","line":276},{"localvar":"my","containerName":"each_Variant","kind":13,"name":"$nt_ori","line":277,"definition":"my"},{"line":277,"kind":13,"containerName":"each_Variant","name":"$codon_ori"},{"kind":13,"containerName":"each_Variant","name":"$k","line":277},{"definition":"my","localvar":"my","containerName":"each_Variant","kind":13,"name":"$nt_mut","line":278},{"name":"$codon_mut","kind":13,"containerName":"each_Variant","line":278},{"line":278,"containerName":"each_Variant","kind":13,"name":"$k"},{"line":279,"kind":13,"containerName":"each_Variant","name":"$nt_ori"},{"containerName":"each_Variant","kind":13,"name":"$nt_mut","line":279},{"containerName":"each_Variant","kind":13,"name":"$length","line":280},{"line":281,"name":"$codon_pos","kind":13,"containerName":"each_Variant"},{"kind":13,"containerName":"each_Variant","name":"$k","line":281},{"line":282,"name":"$allele_ori","kind":13,"containerName":"each_Variant"},{"line":282,"name":"$nt_ori","containerName":"each_Variant","kind":13},{"name":"$allele_mut","kind":13,"containerName":"each_Variant","line":283},{"name":"$nt_mut","kind":13,"containerName":"each_Variant","line":283},{"containerName":"each_Variant","kind":13,"name":"$k","line":285},{"line":287,"kind":13,"containerName":"each_Variant","name":"$length"},{"line":288,"name":"$rna","localvar":"my","kind":13,"containerName":"each_Variant","definition":"my"},{"name":"new","containerName":"each_Variant","kind":12,"line":288},{"kind":13,"containerName":"each_Variant","name":"$codon_ori","line":290},{"containerName":"each_Variant","kind":13,"name":"$codon_mut","line":291},{"line":292,"name":"$codon_pos","containerName":"each_Variant","kind":13},{"line":295,"name":"$all_ori","localvar":"my","containerName":"each_Variant","kind":13,"definition":"my"},{"line":295,"name":"new","containerName":"each_Variant","kind":12},{"name":"$allele_ori","kind":13,"containerName":"each_Variant","line":295},{"name":"$rna","kind":13,"containerName":"each_Variant","line":296},{"kind":12,"containerName":"each_Variant","name":"allele_ori","line":296},{"name":"$all_ori","containerName":"each_Variant","kind":13,"line":296},{"name":"$all_mut","localvar":"my","containerName":"each_Variant","kind":13,"line":297,"definition":"my"},{"line":297,"containerName":"each_Variant","kind":12,"name":"new"},{"name":"$allele_mut","containerName":"each_Variant","kind":13,"line":297},{"line":298,"containerName":"each_Variant","kind":13,"name":"$rna"},{"name":"allele_mut","containerName":"each_Variant","kind":12,"line":298},{"line":298,"kind":13,"containerName":"each_Variant","name":"$all_mut"},{"line":299,"name":"@points","containerName":"each_Variant","kind":13},{"kind":13,"containerName":"each_Variant","name":"$rna","line":299},{"line":303,"containerName":"each_Variant","kind":13,"name":"@points"}],"name":"each_Variant","containerName":"main::","definition":"sub","detail":"($self,@args)","line":262,"range":{"end":{"character":9999,"line":304},"start":{"character":0,"line":262}},"kind":12,"signature":{"label":"each_Variant($self,@args)","documentation":"1;\n# $Id: AAReverseMutate.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Variation::AAReverseMutate\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Variation::AAReverseMutate - point mutation and codon\n  information from single amino acid changes\n\n=head1 SYNOPSIS\n\n    $aamut = Bio::Variation::AAReverseMutate->new\n                 (-aa_ori => 'F', \n\t\t  -aa_mut => 'S',\n\t\t  -codon_ori => 'ttc', # optional\n\t\t  -codon_table => '3'  # defaults to 1\n\t\t  );\n\n   @points = $aamut->each_Variant;\n\n   if (scalar @points > 0 ) {\n       foreach $rnachange ( @points ) {\n   \t   # $rnachange is a Bio::Variation::RNAChange object\n   \t   print \" \", $rnachange->allele_ori->seq, \">\", \n\t   $rnachange->allele_mut->seq, \" in \",\n   \t   $rnachange->codon_ori, \">\", $rnachange->codon_mut,\n   \t   \" at position \", $rnachange->codon_pos, \"\\n\";\n       }\n   } else  {\n       print \"No point mutations possible\\n\",\n   }\n\n=head1 DESCRIPTION\n\nBio::Variation::AAReverseMutate objects take in reference and mutated\namino acid information and deduces potential point mutations at RNA\nlevel leading to this change. The choice can be further limited by\nletting the object know what is the the codon in the reference\nsequence. The results are returned as L<Bio::Variation::RNAChange>\nobjects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Variation::AAReverseMutate;\n\nuse strict;\n\n# Object preamble - inheritance\nuse Bio::Tools::CodonTable;\nuse Bio::Variation::RNAChange;\nuse Bio::Variation::Allele;\n\nuse base qw(Bio::Root::Root);\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my ($aa_ori, $aa_mut, $codon_ori, $codon_table) =\n\t$self->_rearrange([qw(AA_ORI\n\t\t\t      AA_MUT\n\t\t\t      CODON\n\t\t\t      CODON_TABLE\n\t\t\t      )],@args);\n\n  $aa_ori && $self->aa_ori($aa_ori);\n  $aa_mut  && $self->aa_mut($aa_mut);\n  $codon_ori  && $self->codon_ori($codon_ori);\n  $codon_table && $self->codon_table($codon_table);\n\n  return $self; # success - we hope!\n\n}\n\n\n=head2 aa_ori\n\n Title   : aa_ori\n Usage   : $obj->aa_ori();\n Function: \n\n            Sets and returns original aa sequence.  If value is not\n            set, returns false. \n\n            Amino acid sequences are stored in upper case characters,\n            others in lower case.\n\n Example : \n Returns : string\n Args    : single character amino acid code\n\n\nsub aa_ori {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif (  uc($value) !~ /^[ARNDCQEGHILKMFPSTWYVBZX*]$/ ) {\n\t    $self->throw(\"'$value' is not a valid one letter amino acid symbol\\n\");\n\t} else {\n\t    $self->{'aa_ori'} = uc $value;\n\t}\n    }\n    return $self->{'aa_ori'};    \n}\n\n\n=head2 aa_mut\n\n Title   : aa_mut\n Usage   : $obj->aa_mut();\n Function: \n\n            Sets and returns the mutated allele sequence.  If value is not\n            set, returns false. \n\n Example : \n Returns : string\n Args    : single character amino acid code\n\n\n\nsub aa_mut {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif (  uc($value) !~ /^[ARNDCQEGHILKMFPSTWYVBZX*]$/ ) {\n\t    $self->throw(\"'$value' is not a valid one letter amino acid symbol\\n\");\n\t} else {\n\t    $self->{'aa_mut'} = uc $value;\n\t}\n    }\n    return $self->{'aa_mut'};\n}\n\n\n=head2 codon_ori\n\n Title   : codon_ori\n Usage   : $obj->codon_ori();\n Function: \n\n            Sets and returns codon_ori triplet.  If value is not set,\n            returns false.  The string has to be three characters\n            long. The chracter content is not checked.\n\n Example : \n Returns : string\n Args    : string\n\n\nsub codon_ori {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif (length $value != 3 or lc $value =~ /[^atgc]/) {\n\t    $self->warn(\"Codon string \\\"$value\\\" is not valid unique codon\");\n\t}\n\t$self->{'codon_ori'} = lc $value;\n    }\n    return $self->{'codon_ori'};\n}\n\n=head2 codon_table\n\n Title   : codon_table\n Usage   : $obj->codon_table();\n Function: \n\n            Sets and returns the codon table id of the RNA\n            If value is not set, returns 1, 'universal' code, as the default.\n\n Example : \n Returns : integer\n Args    : none if get, the new value if set\n\n\n\nsub codon_table {\n    my ($self,$value) = @_;\n    if( defined $value) {\n\tif (  not $value =~ /^\\d+$/ ) {\n\t    $self->throw(\"'$value' is not a valid codon table ID\\n\".\n\t\t\t\"Has to be a positive integer. Defaulting to 1\\n\");\n\t} else {\n\t    $self->{'codon_table'} = $value;\n\t}\n    }\n    if( ! exists $self->{'codon_table'} ) {\n\treturn 1;\n    } else {\n\treturn $self->{'codon_table'};\n    }\n}\n\n\n=head2 each_Variant\n\n Title   : each_Variant\n Usage   : $obj->each_Variant();\n Function: \n\n            Returns a list of Variants.\n\n Example : \n Returns : list of Variants\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}]}},{"name":"Bio","containerName":"Tools::CodonTable","kind":12,"line":269},{"line":288,"containerName":"Variation::RNAChange","kind":12,"name":"Bio"},{"line":295,"containerName":"Variation::Allele","kind":12,"name":"Bio"},{"line":297,"kind":12,"containerName":"Variation::Allele","name":"Bio"}]}