{"version":5,"vars":[{"line":95,"name":"base","containerName":"","kind":2},{"line":113,"range":{"start":{"character":0,"line":113},"end":{"line":134,"character":9999}},"kind":12,"children":[{"line":114,"name":"$self","localvar":"my","containerName":"_initialize","kind":13,"definition":"my"},{"definition":"my","name":"$width","localvar":"my","containerName":"_initialize","kind":13,"line":115},{"containerName":"_initialize","kind":13,"name":"$height","line":115},{"line":115,"kind":13,"containerName":"_initialize","name":"$margin"},{"line":115,"containerName":"_initialize","kind":13,"name":"$stroke"},{"line":116,"name":"$stroke_width","containerName":"_initialize","kind":13},{"name":"$font_size","kind":13,"containerName":"_initialize","line":116},{"containerName":"_initialize","kind":13,"name":"$normalize","line":117},{"line":117,"kind":13,"containerName":"_initialize","name":"$self"},{"line":117,"kind":12,"containerName":"_initialize","name":"_rearrange"},{"line":126,"name":"$self","containerName":"_initialize","kind":13},{"line":126,"kind":13,"containerName":"_initialize","name":"$width"},{"kind":13,"containerName":"_initialize","name":"$self","line":127},{"containerName":"_initialize","kind":13,"name":"$height","line":127},{"line":128,"kind":13,"containerName":"_initialize","name":"$self"},{"kind":13,"containerName":"_initialize","name":"$margin","line":128},{"line":128,"name":"$margin","kind":13,"containerName":"_initialize"},{"line":129,"containerName":"_initialize","kind":13,"name":"$self"},{"name":"$stroke","containerName":"_initialize","kind":13,"line":129},{"line":130,"name":"$self","containerName":"_initialize","kind":13},{"line":130,"kind":13,"containerName":"_initialize","name":"$stroke_width"},{"line":131,"name":"$self","kind":13,"containerName":"_initialize"},{"name":"$font_size","kind":13,"containerName":"_initialize","line":131},{"line":132,"containerName":"_initialize","kind":13,"name":"$self"},{"kind":13,"containerName":"_initialize","name":"$normalize","line":132},{"line":133,"containerName":"_initialize","kind":13,"name":"$self"}],"name":"_initialize","containerName":"main::","definition":"sub"},{"name":"_width","kind":12,"line":126},{"line":127,"name":"_height","kind":12},{"line":128,"kind":12,"name":"_margin"},{"line":129,"name":"_stroke","kind":12},{"line":130,"name":"_stroke_width","kind":12},{"kind":12,"name":"_font_size","line":131},{"line":132,"name":"_normalize","kind":12},{"kind":12,"containerName":"_initialize","name":"SUPER","line":133},{"kind":12,"range":{"end":{"character":9999,"line":152},"start":{"character":0,"line":146}},"line":146,"signature":{"documentation":"1;\n#\n# BioPerl module for Bio::TreeIO::svg-graph\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday@ucla.edu>\n#\n# Copyright Brian O'Connor\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::svggraph - A simple output format that converts a Tree object to an SVG output\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-file => 'input', -format => 'newick');\n  my $out = Bio::TreeIO->new(-file => '>output', -format => 'svggraph');\n\n  while( my $tree = $in->next_tree ) {\n      my $svg_xml = $out->write_tree($tree);\n  }\n\n=head1 DESCRIPTION\n\nThis outputs a tree as an SVG graphic using the SVG::Graph API\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Brian OConnor\n\nEmail brian.oconnor-at-excite.com\n\n=head1 CONTRIBUTORS\n\nAllen Day\nGuillaume Rousse, Guillaume-dot-Rousse-at-inria-dot-fr\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::svggraph;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse SVG::Graph;\nuse SVG::Graph::Data;\nuse SVG::Graph::Data::Tree;\nuse SVG::Graph::Data::Node;\nuse Bio::Tree::TreeI;\nuse Bio::Tree::Node;\nuse Tree::DAG_Node;\n\n\nuse base qw(Bio::TreeIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO::svggraph->new();\n Function: Builds a new Bio::TreeIO::svggraph object \n Returns : Bio::TreeIO::svggraph\n Args    :-width    => image width (default 1600)\n          -height   => image height (default 1000)\n          -margin   => margin (default 30)\n          -stroke   => stroke color (default 'black')\n          -stroke_width=> stroke width (default 2)\n          -font_size=> font size (default '10px')\n          -nomalize => undef or 'log' (default is undef)\n\n\nsub _initialize {\n    my $self = shift;\n    my ($width,$height,$margin,$stroke,\n\t$stroke_width,$font_size,\n\t$normalize) = $self->_rearrange([qw\n\t\t\t\t\t (WIDTH\n\t\t\t\t\t  HEIGHT\n\t\t\t\t\t  MARGIN\n\t\t\t\t\t  STROKE\n\t\t\t\t\t  STROKE_WIDTH\n\t\t\t\t\t  FONT_SIZE\n\t\t\t\t\t  NORMALIZE)],\n\t\t\t\t\t@_);\n    $self->{_width}        = $width || 1600;\n    $self->{_height}       = $height || 1000;\n    $self->{_margin}       = defined $margin ? $margin : 30;\n    $self->{_stroke}       = $stroke || 'black';\n    $self->{_stroke_width} = $stroke_width || 2;\n    $self->{_font_size}    = $font_size || '10px';\n    $self->{_normalize}    = $normalize || '';\n    $self->SUPER::_initialize(@_);\n}\n\n=head2 write_tree\n\n Title   : write_tree\n Usage   : $treeio->write_tree($tree);\n Function: Write a tree out to data stream in newick/phylip format\n Returns : none\n Args    : Bio::Tree::TreeI object","parameters":[{"label":"$self"},{"label":"$tree"}],"label":"write_tree($self,$tree)"},"containerName":"main::","name":"write_tree","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"write_tree","kind":13,"line":147},{"name":"$tree","kind":13,"containerName":"write_tree","line":147},{"definition":"my","line":148,"name":"$line","localvar":"my","kind":13,"containerName":"write_tree"},{"line":148,"containerName":"write_tree","kind":13,"name":"$self"},{"line":148,"kind":12,"containerName":"write_tree","name":"_write_tree_Helper"},{"containerName":"write_tree","kind":13,"name":"$tree","line":148},{"line":148,"containerName":"write_tree","kind":12,"name":"get_root_node"},{"name":"$self","kind":13,"containerName":"write_tree","line":149},{"line":149,"name":"_print","kind":12,"containerName":"write_tree"},{"name":"$line","kind":13,"containerName":"write_tree","line":149},{"name":"$self","kind":13,"containerName":"write_tree","line":150},{"line":150,"name":"flush","kind":12,"containerName":"write_tree"},{"line":150,"name":"$self","kind":13,"containerName":"write_tree"},{"line":150,"containerName":"write_tree","kind":12,"name":"_flush_on_write"},{"line":150,"name":"$self","kind":13,"containerName":"write_tree"},{"containerName":"write_tree","kind":12,"name":"_fh","line":150}],"detail":"($self,$tree)","definition":"sub"},{"detail":"($self,$node)","definition":"sub","name":"_write_tree_Helper","containerName":"main::","children":[{"definition":"my","line":155,"localvar":"my","kind":13,"containerName":"_write_tree_Helper","name":"$self"},{"line":155,"name":"$node","containerName":"_write_tree_Helper","kind":13},{"definition":"my","line":157,"name":"$graph","localvar":"my","containerName":"_write_tree_Helper","kind":13},{"kind":12,"containerName":"_write_tree_Helper","name":"new","line":158},{"line":158,"name":"$self","kind":13,"containerName":"_write_tree_Helper"},{"line":159,"containerName":"_write_tree_Helper","kind":13,"name":"$self"},{"name":"$self","containerName":"_write_tree_Helper","kind":13,"line":160},{"definition":"my","line":162,"name":"$group0","kind":13,"localvar":"my","containerName":"_write_tree_Helper"},{"line":162,"name":"$graph","containerName":"_write_tree_Helper","kind":13},{"name":"add_frame","containerName":"_write_tree_Helper","kind":12,"line":162},{"line":163,"localvar":"my","containerName":"_write_tree_Helper","kind":13,"name":"$tree","definition":"my"},{"line":163,"name":"new","containerName":"_write_tree_Helper","kind":12},{"localvar":"my","containerName":"_write_tree_Helper","kind":13,"name":"$root","line":164,"definition":"my"},{"line":164,"name":"new","kind":12,"containerName":"_write_tree_Helper"},{"name":"$root","kind":13,"containerName":"_write_tree_Helper","line":165},{"kind":12,"containerName":"_write_tree_Helper","name":"name","line":165},{"name":"$node","containerName":"_write_tree_Helper","kind":13,"line":165},{"kind":12,"containerName":"_write_tree_Helper","name":"id","line":165},{"line":166,"containerName":"_write_tree_Helper","kind":13,"name":"$self"},{"name":"_decorateRoot","containerName":"_write_tree_Helper","kind":12,"line":166},{"line":166,"containerName":"_write_tree_Helper","kind":13,"name":"$root"},{"line":166,"name":"$node","kind":13,"containerName":"_write_tree_Helper"},{"kind":12,"containerName":"_write_tree_Helper","name":"each_Descendent","line":166},{"kind":13,"containerName":"_write_tree_Helper","name":"$tree","line":167},{"line":167,"name":"root","containerName":"_write_tree_Helper","kind":12},{"name":"$root","kind":13,"containerName":"_write_tree_Helper","line":167},{"name":"$group0","containerName":"_write_tree_Helper","kind":13,"line":168},{"line":168,"name":"add_data","kind":12,"containerName":"_write_tree_Helper"},{"name":"$tree","containerName":"_write_tree_Helper","kind":13,"line":168},{"line":170,"containerName":"_write_tree_Helper","kind":13,"name":"$group0"},{"kind":12,"containerName":"_write_tree_Helper","name":"add_glyph","line":170},{"containerName":"_write_tree_Helper","kind":13,"name":"$self","line":171},{"name":"$self","kind":13,"containerName":"_write_tree_Helper","line":172},{"line":173,"name":"$self","containerName":"_write_tree_Helper","kind":13},{"line":175,"containerName":"_write_tree_Helper","kind":13,"name":"$graph"},{"name":"draw","kind":12,"containerName":"_write_tree_Helper","line":175}],"signature":{"label":"_write_tree_Helper($self,$node)","documentation":"","parameters":[{"label":"$self"},{"label":"$node"}]},"range":{"start":{"line":154,"character":0},"end":{"character":9999,"line":176}},"kind":12,"line":154},{"line":157,"name":"SVG","kind":12,"containerName":"Graph"},{"kind":12,"containerName":"Graph::Data::Tree","name":"SVG","line":163},{"line":164,"name":"SVG","containerName":"Graph::Data::Node","kind":12},{"detail":"($self,$previousNode,@children)","definition":"sub","name":"_decorateRoot","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"_decorateRoot","name":"$self","line":192,"definition":"my"},{"line":192,"name":"$previousNode","containerName":"_decorateRoot","kind":13},{"kind":13,"containerName":"_decorateRoot","name":"@children","line":192},{"line":193,"name":"$child","kind":13,"localvar":"my","containerName":"_decorateRoot","definition":"my"},{"name":"@children","containerName":"_decorateRoot","kind":13,"line":193},{"line":194,"localvar":"my","kind":13,"containerName":"_decorateRoot","name":"$currNode","definition":"my"},{"line":194,"kind":12,"containerName":"_decorateRoot","name":"new"},{"name":"$currNode","containerName":"_decorateRoot","kind":13,"line":195},{"name":"branch_label","containerName":"_decorateRoot","kind":12,"line":195},{"kind":13,"containerName":"_decorateRoot","name":"$child","line":195},{"line":195,"name":"id","containerName":"_decorateRoot","kind":12},{"definition":"my","kind":13,"localvar":"my","containerName":"_decorateRoot","name":"$length","line":196},{"line":196,"name":"$child","containerName":"_decorateRoot","kind":13},{"containerName":"_decorateRoot","kind":12,"name":"branch_length","line":196},{"kind":13,"containerName":"_decorateRoot","name":"$self","line":199},{"name":"$length","kind":13,"containerName":"_decorateRoot","line":200},{"line":200,"kind":13,"containerName":"_decorateRoot","name":"$length"},{"line":204,"name":"$currNode","containerName":"_decorateRoot","kind":13},{"name":"branch_length","containerName":"_decorateRoot","kind":12,"line":204},{"kind":13,"containerName":"_decorateRoot","name":"$length","line":204},{"line":205,"name":"$previousNode","kind":13,"containerName":"_decorateRoot"},{"line":205,"name":"add_daughter","containerName":"_decorateRoot","kind":12},{"line":205,"containerName":"_decorateRoot","kind":13,"name":"$currNode"},{"containerName":"_decorateRoot","kind":13,"name":"$self","line":206},{"containerName":"_decorateRoot","kind":12,"name":"_decorateRoot","line":206},{"kind":13,"containerName":"_decorateRoot","name":"$currNode","line":206},{"line":206,"containerName":"_decorateRoot","kind":13,"name":"$child"},{"line":206,"name":"each_Descendent","containerName":"_decorateRoot","kind":12}],"signature":{"documentation":"1;\n#\n# BioPerl module for Bio::TreeIO::svg-graph\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday@ucla.edu>\n#\n# Copyright Brian O'Connor\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::svggraph - A simple output format that converts a Tree object to an SVG output\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-file => 'input', -format => 'newick');\n  my $out = Bio::TreeIO->new(-file => '>output', -format => 'svggraph');\n\n  while( my $tree = $in->next_tree ) {\n      my $svg_xml = $out->write_tree($tree);\n  }\n\n=head1 DESCRIPTION\n\nThis outputs a tree as an SVG graphic using the SVG::Graph API\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Brian OConnor\n\nEmail brian.oconnor-at-excite.com\n\n=head1 CONTRIBUTORS\n\nAllen Day\nGuillaume Rousse, Guillaume-dot-Rousse-at-inria-dot-fr\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::svggraph;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse SVG::Graph;\nuse SVG::Graph::Data;\nuse SVG::Graph::Data::Tree;\nuse SVG::Graph::Data::Node;\nuse Bio::Tree::TreeI;\nuse Bio::Tree::Node;\nuse Tree::DAG_Node;\n\n\nuse base qw(Bio::TreeIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO::svggraph->new();\n Function: Builds a new Bio::TreeIO::svggraph object \n Returns : Bio::TreeIO::svggraph\n Args    :-width    => image width (default 1600)\n          -height   => image height (default 1000)\n          -margin   => margin (default 30)\n          -stroke   => stroke color (default 'black')\n          -stroke_width=> stroke width (default 2)\n          -font_size=> font size (default '10px')\n          -nomalize => undef or 'log' (default is undef)\n\n\nsub _initialize {\n    my $self = shift;\n    my ($width,$height,$margin,$stroke,\n\t$stroke_width,$font_size,\n\t$normalize) = $self->_rearrange([qw\n\t\t\t\t\t (WIDTH\n\t\t\t\t\t  HEIGHT\n\t\t\t\t\t  MARGIN\n\t\t\t\t\t  STROKE\n\t\t\t\t\t  STROKE_WIDTH\n\t\t\t\t\t  FONT_SIZE\n\t\t\t\t\t  NORMALIZE)],\n\t\t\t\t\t@_);\n    $self->{_width}        = $width || 1600;\n    $self->{_height}       = $height || 1000;\n    $self->{_margin}       = defined $margin ? $margin : 30;\n    $self->{_stroke}       = $stroke || 'black';\n    $self->{_stroke_width} = $stroke_width || 2;\n    $self->{_font_size}    = $font_size || '10px';\n    $self->{_normalize}    = $normalize || '';\n    $self->SUPER::_initialize(@_);\n}\n\n=head2 write_tree\n\n Title   : write_tree\n Usage   : $treeio->write_tree($tree);\n Function: Write a tree out to data stream in newick/phylip format\n Returns : none\n Args    : Bio::Tree::TreeI object\n\n\nsub write_tree{\n   my ($self,$tree) = @_;\n   my $line = $self->_write_tree_Helper($tree->get_root_node);\n   $self->_print($line. \"\\n\");\n   $self->flush if $self->_flush_on_write && defined $self->_fh;\n   return;\n}\n\nsub _write_tree_Helper {\n   my ($self,$node) = @_;\n\n   my $graph = SVG::Graph->new\n       ('width'   => $self->{'_width'},\n\t'height'  => $self->{'_height'},\n\t'margin'  => $self->{'_margin'});\n   \n   my $group0 = $graph->add_frame;\n   my $tree = SVG::Graph::Data::Tree->new;\n   my $root = SVG::Graph::Data::Node->new;\n   $root->name($node->id);\n   $self->_decorateRoot($root, $node->each_Descendent());\n   $tree->root($root);\n   $group0->add_data($tree);\n\n   $group0->add_glyph('tree', \n\t\t      'stroke'      =>$self->{'_stroke'},\n\t\t      'stroke-width'=>$self->{'_stroke_width'},\n\t\t      'font-size'   =>$self->{'_font_size'});\n\n   return($graph->draw);\n}\n\n\n=head2 decorateRoot\n\n Title   : _decorateRoot\n Usage   : internal methods\n Function:\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"$previousNode"},{"label":"@children"}],"label":"_decorateRoot($self,$previousNode,@children)"},"kind":12,"range":{"end":{"character":9999,"line":208},"start":{"line":191,"character":0}},"line":191},{"line":194,"containerName":"Graph::Data::Node","kind":12,"name":"SVG"},{"kind":12,"name":"CASE","line":197},{"kind":12,"name":"_normalize","line":199},{"name":"CASE","kind":12,"line":201},{"definition":"sub","children":[{"line":223,"name":"throw","containerName":"next_tree","kind":12}],"containerName":"main::","name":"next_tree","line":222,"range":{"start":{"character":0,"line":222},"end":{"character":9999,"line":224}},"kind":12}]}