{"version":5,"vars":[{"definition":"our","line":82,"containerName":"main::","kind":13,"name":"$TaxonNameLen"},{"line":82,"name":"strict","containerName":"","kind":2},{"line":84,"name":"base","containerName":"","kind":2},{"range":{"end":{"line":107,"character":9999},"start":{"line":97,"character":0}},"kind":12,"line":97,"containerName":"main::","name":"_initialize","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_initialize","line":98,"definition":"my"},{"line":99,"kind":13,"containerName":"_initialize","name":"$self"},{"definition":"my","line":100,"name":"$name_length","kind":13,"localvar":"my","containerName":"_initialize"},{"line":100,"name":"$self","kind":13,"containerName":"_initialize"},{"line":100,"name":"_rearrange","kind":12,"containerName":"_initialize"},{"line":106,"containerName":"_initialize","kind":13,"name":"$self"},{"line":106,"kind":12,"containerName":"_initialize","name":"name_length"},{"line":106,"name":"$name_length","containerName":"_initialize","kind":13},{"line":106,"name":"$name_length","containerName":"_initialize","kind":13},{"line":106,"name":"$TaxonNameLen","containerName":"_initialize","kind":13}],"definition":"sub"},{"line":99,"kind":12,"containerName":"_initialize","name":"SUPER"},{"kind":12,"range":{"start":{"character":0,"line":127},"end":{"line":232,"character":9999}},"line":127,"signature":{"parameters":[{"label":"$self"},{"label":"$tree"},{"label":"@args"}],"documentation":"1;\n# $Id: pag.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::pag\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::pag - Bio::TreeIO driver for Pagel format\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-format => 'nexus',\n                            -file   => 't/data/adh.mb_tree.nexus');\n\n  my $out = Bio::TreeIO->new(-format => 'pag');\n  while( my $tree = $in->next_tree ) {\n    $out->write_tree($tree);\n  }\n\n=head1 DESCRIPTION\n\nConvert a Bio::TreeIO to Pagel format.\nMore information here http://www.evolution.reading.ac.uk/index.html\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::pag;\nuse strict;\n\nour $TaxonNameLen = 10;\n\nuse base qw(Bio::TreeIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO::pag->new();\n Function: Builds a new Bio::TreeIO::pag object \n Returns : an instance of Bio::TreeIO::pag\n Args    : -file/-fh for filename or filehandles\n           -name_length for minimum name length (default = 10)\n\n\nsub _initialize {\n    my $self = shift;\n    $self->SUPER::_initialize(@_);\n    my ( $name_length ) = $self->_rearrange(\n        [\n            qw(NAME_LENGTH)\n        ],\n        @_\n    );\n    $self->name_length( defined $name_length ? $name_length : $TaxonNameLen );\n}\n\n=head2 write_tree\n\n Title   : write_tree\n Usage   :\n Function: Write a tree out in Pagel format\n           Some options are only appropriate for bayesianmultistate and\n           the simpler output is only proper for discrete\n Returns : none\n Args    : -no_outgroups => (number)\n           -print_header => 0/1 (leave 0 for discrete, 1 for bayesianms)\n           -special_node => special node - not sure what they wanted to do here\n           -keep_outgroup => 0/1 (keep the outgroup node in the output)\n           -outgroup_ancestor => Bio::Tree::Node (if we want to exclude or include the outgroup this is what we operate on)\n           -tree_no       => a tree number label - only useful for BayesianMultistate","label":"write_tree($self,$tree,@args)"},"containerName":"main::","name":"write_tree","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"write_tree","kind":13,"line":128},{"containerName":"write_tree","kind":13,"name":"$tree","line":128},{"containerName":"write_tree","kind":13,"name":"@args","line":128},{"definition":"my","containerName":"write_tree","localvar":"my","kind":13,"name":"$keep_outgroup","line":129},{"line":130,"containerName":"write_tree","kind":13,"name":"$print_header"},{"kind":13,"containerName":"write_tree","name":"$no_outgroups","line":131},{"name":"$special_node","kind":13,"containerName":"write_tree","line":132},{"name":"$outgroup_ancestor","kind":13,"containerName":"write_tree","line":133},{"name":"$tree_no","kind":13,"containerName":"write_tree","line":134},{"line":135,"localvar":"my","containerName":"write_tree","kind":13,"name":"$name_len","definition":"my"},{"line":135,"name":"$self","kind":13,"containerName":"write_tree"},{"line":135,"name":"name_length","kind":12,"containerName":"write_tree"},{"containerName":"write_tree","kind":13,"name":"@args","line":136},{"line":137,"kind":13,"containerName":"write_tree","name":"$no_outgroups"},{"containerName":"write_tree","kind":13,"name":"$print_header","line":138},{"line":139,"name":"$special_node","containerName":"write_tree","kind":13},{"line":140,"name":"$outgroup_ancestor","kind":13,"containerName":"write_tree"},{"kind":13,"containerName":"write_tree","name":"$tree_no","line":141},{"line":142,"name":"$keep_outgroup","kind":13,"containerName":"write_tree"},{"line":142,"name":"$self","kind":13,"containerName":"write_tree"},{"containerName":"write_tree","kind":12,"name":"_rearrange","line":142},{"line":150,"kind":13,"containerName":"write_tree","name":"@args"},{"definition":"my","line":152,"containerName":"write_tree","localvar":"my","kind":13,"name":"$newname_base"},{"definition":"my","name":"$root","localvar":"my","containerName":"write_tree","kind":13,"line":154},{"kind":13,"containerName":"write_tree","name":"$tree","line":154},{"line":154,"name":"get_root_node","kind":12,"containerName":"write_tree"},{"line":155,"localvar":"my","containerName":"write_tree","kind":13,"name":"$eps","definition":"my"},{"definition":"my","line":156,"localvar":"my","kind":13,"containerName":"write_tree","name":"%chars"},{"line":156,"name":"%names","containerName":"write_tree","kind":13},{"line":157,"containerName":"write_tree","localvar":"my","kind":13,"name":"@nodes","definition":"my"},{"name":"$tree","kind":13,"containerName":"write_tree","line":157},{"containerName":"write_tree","kind":12,"name":"get_nodes","line":157},{"definition":"my","line":158,"name":"$species_ct","kind":13,"localvar":"my","containerName":"write_tree"},{"definition":"my","name":"$traitct","localvar":"my","kind":13,"containerName":"write_tree","line":159},{"name":"$node","localvar":"my","kind":13,"containerName":"write_tree","line":160,"definition":"my"},{"name":"@nodes","kind":13,"containerName":"write_tree","line":160},{"line":161,"kind":13,"containerName":"write_tree","name":"$special_node"},{"name":"$node","kind":13,"containerName":"write_tree","line":161},{"line":161,"kind":13,"containerName":"write_tree","name":"$special_node"},{"name":"$no_of_tree_nodes","localvar":"my","kind":13,"containerName":"write_tree","line":162,"definition":"my"},{"line":162,"kind":13,"containerName":"write_tree","name":"@nodes"},{"definition":"my","localvar":"my","containerName":"write_tree","kind":13,"name":"$node_name","line":163},{"containerName":"write_tree","kind":13,"name":"$no_of_tree_nodes","line":163},{"kind":13,"containerName":"write_tree","name":"$names","line":164},{"kind":13,"containerName":"write_tree","name":"$node","line":164},{"containerName":"write_tree","kind":12,"name":"internal_id","line":164},{"containerName":"write_tree","kind":13,"name":"$node_name","line":164},{"containerName":"write_tree","kind":13,"name":"$node","line":166},{"containerName":"write_tree","kind":12,"name":"is_Leaf","line":166},{"name":"$species_ct","kind":13,"containerName":"write_tree","line":167},{"definition":"my","name":"$node_name","localvar":"my","containerName":"write_tree","kind":13,"line":169},{"line":169,"name":"$node","kind":13,"containerName":"write_tree"},{"line":169,"containerName":"write_tree","kind":12,"name":"id"},{"line":170,"name":"$node_name","containerName":"write_tree","kind":13},{"containerName":"write_tree","kind":13,"name":"$name_len","line":170},{"line":171,"name":"$self","kind":13,"containerName":"write_tree"},{"name":"warn","containerName":"write_tree","kind":12,"line":171},{"line":173,"name":"$node_name","kind":13,"containerName":"write_tree"},{"line":173,"name":"$node_name","kind":13,"containerName":"write_tree"},{"name":"$name_len","kind":13,"containerName":"write_tree","line":173},{"kind":13,"containerName":"write_tree","name":"$names","line":177},{"line":177,"name":"$node","containerName":"write_tree","kind":13},{"line":177,"containerName":"write_tree","kind":12,"name":"internal_id"},{"line":177,"name":"$node_name","kind":13,"containerName":"write_tree"},{"line":178,"name":"@tags","localvar":"my","kind":13,"containerName":"write_tree","definition":"my"},{"kind":13,"containerName":"write_tree","name":"$node","line":178},{"name":"get_all_tags","containerName":"write_tree","kind":12,"line":178},{"definition":"my","name":"@charstates","containerName":"write_tree","localvar":"my","kind":13,"line":179},{"kind":13,"containerName":"write_tree","name":"$node","line":179},{"line":179,"name":"get_tag_values","kind":12,"containerName":"write_tree"},{"name":"@tags","kind":13,"containerName":"write_tree","line":179},{"name":"$traitct","containerName":"write_tree","kind":13,"line":180},{"line":180,"kind":13,"containerName":"write_tree","name":"@charstates"},{"line":180,"containerName":"write_tree","kind":13,"name":"$traitct"},{"line":181,"name":"$chars","kind":13,"containerName":"write_tree"},{"line":181,"containerName":"write_tree","kind":13,"name":"$node"},{"line":181,"containerName":"write_tree","kind":12,"name":"internal_id"},{"line":181,"kind":13,"containerName":"write_tree","name":"@charstates"},{"kind":13,"containerName":"write_tree","name":"$names","line":183},{"line":183,"name":"$node","containerName":"write_tree","kind":13},{"line":183,"containerName":"write_tree","kind":12,"name":"internal_id"},{"line":183,"kind":13,"containerName":"write_tree","name":"$newname_base"},{"line":188,"containerName":"write_tree","kind":13,"name":"$print_header"},{"line":189,"name":"$keep_outgroup","containerName":"write_tree","kind":13},{"containerName":"write_tree","kind":13,"name":"$self","line":190},{"line":190,"name":"_print","kind":12,"containerName":"write_tree"},{"line":190,"name":"$species_ct","kind":13,"containerName":"write_tree"},{"line":190,"name":"$traitct","containerName":"write_tree","kind":13},{"line":192,"kind":13,"containerName":"write_tree","name":"$self"},{"line":192,"kind":12,"containerName":"write_tree","name":"_print"},{"kind":13,"containerName":"write_tree","name":"$species_ct","line":192},{"line":192,"containerName":"write_tree","kind":13,"name":"$no_outgroups"},{"kind":13,"containerName":"write_tree","name":"$traitct","line":192},{"name":"@ancestors","containerName":"write_tree","localvar":"my","kind":13,"line":196,"definition":"my"},{"line":197,"name":"$keep_outgroup","kind":13,"containerName":"write_tree"},{"line":198,"name":"@ancestors","kind":13,"containerName":"write_tree"},{"line":198,"kind":13,"containerName":"write_tree","name":"$root"},{"line":200,"kind":13,"containerName":"write_tree","name":"@ancestors"},{"containerName":"write_tree","kind":13,"name":"$root","line":200},{"kind":13,"containerName":"write_tree","name":"$outgroup_ancestor","line":200},{"name":"@rest","localvar":"my","containerName":"write_tree","kind":13,"line":202,"definition":"my"},{"name":"$node","containerName":"write_tree","localvar":"my","kind":13,"line":203,"definition":"my"},{"name":"@nodes","kind":13,"containerName":"write_tree","line":203},{"line":204,"localvar":"my","containerName":"write_tree","kind":13,"name":"$i","definition":"my"},{"localvar":"my","containerName":"write_tree","kind":13,"name":"$anc","line":205,"definition":"my"},{"line":205,"name":"@ancestors","kind":13,"containerName":"write_tree"},{"name":"$anc","containerName":"write_tree","kind":13,"line":206},{"line":206,"containerName":"write_tree","kind":13,"name":"$node"},{"line":206,"name":"$anc","kind":13,"containerName":"write_tree"},{"line":206,"containerName":"write_tree","kind":13,"name":"$i"},{"line":208,"containerName":"write_tree","kind":13,"name":"$i"},{"containerName":"write_tree","localvar":"my","kind":13,"name":"$current_name","line":209,"definition":"my"},{"line":209,"containerName":"write_tree","kind":13,"name":"$names"},{"line":209,"kind":13,"containerName":"write_tree","name":"$node"},{"name":"internal_id","kind":12,"containerName":"write_tree","line":209},{"definition":"my","kind":13,"localvar":"my","containerName":"write_tree","name":"$branch_length_to_output","line":210},{"name":"$node","containerName":"write_tree","kind":13,"line":211},{"containerName":"write_tree","kind":12,"name":"branch_length","line":211},{"kind":13,"containerName":"write_tree","name":"$eps","line":211},{"line":212,"name":"$msg_nodename","localvar":"my","kind":13,"containerName":"write_tree","definition":"my"},{"name":"$current_name","kind":13,"containerName":"write_tree","line":212},{"line":213,"name":"$msg_nodename","containerName":"write_tree","kind":13},{"name":"$node","containerName":"write_tree","kind":13,"line":215},{"name":"branch_length","kind":12,"containerName":"write_tree","line":215},{"name":"$branch_length_to_output","kind":13,"containerName":"write_tree","line":217},{"line":217,"name":"$eps","kind":13,"containerName":"write_tree"},{"name":"$branch_length_to_output","kind":13,"containerName":"write_tree","line":219},{"line":219,"containerName":"write_tree","kind":13,"name":"$node"},{"line":219,"kind":12,"containerName":"write_tree","name":"branch_length"},{"definition":"my","name":"@line","containerName":"write_tree","localvar":"my","kind":13,"line":221},{"line":221,"name":"$current_name","containerName":"write_tree","kind":13},{"line":222,"name":"$names","containerName":"write_tree","kind":13},{"line":222,"name":"$node","kind":13,"containerName":"write_tree"},{"kind":12,"containerName":"write_tree","name":"ancestor","line":222},{"line":222,"containerName":"write_tree","kind":12,"name":"internal_id"},{"name":"$branch_length_to_output","containerName":"write_tree","kind":13,"line":223},{"line":225,"name":"$node","kind":13,"containerName":"write_tree"},{"containerName":"write_tree","kind":12,"name":"is_Leaf","line":225},{"line":226,"containerName":"write_tree","kind":13,"name":"@line"},{"line":226,"containerName":"write_tree","kind":13,"name":"$chars"},{"line":226,"kind":13,"containerName":"write_tree","name":"$node"},{"kind":12,"containerName":"write_tree","name":"internal_id","line":226},{"line":227,"name":"$self","containerName":"write_tree","kind":13},{"line":227,"name":"_print","kind":12,"containerName":"write_tree"},{"line":227,"name":"@line","kind":13,"containerName":"write_tree"},{"line":229,"name":"@rest","kind":13,"containerName":"write_tree"},{"name":"@line","containerName":"write_tree","kind":13,"line":229}],"detail":"($self,$tree,@args)","definition":"sub"},{"line":233,"name":"@rest","kind":13,"containerName":null},{"name":"$self","containerName":null,"kind":13,"line":234},{"line":234,"name":"_print","kind":12,"containerName":"main::"},{"line":234,"name":"$_","kind":13,"containerName":null},{"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"next_tree","children":[{"line":251,"localvar":"my","kind":13,"containerName":"next_tree","name":"$self","definition":"my"},{"line":251,"name":"@args","kind":13,"containerName":"next_tree"},{"line":252,"name":"$self","kind":13,"containerName":"next_tree"},{"line":252,"name":"throw_not_implemented","containerName":"next_tree","kind":12}],"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"@args"}],"label":"next_tree($self,@args)"},"kind":12,"range":{"end":{"character":9999,"line":253},"start":{"line":250,"character":0}},"line":250},{"children":[{"line":266,"containerName":"name_length","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":266,"name":"$val","containerName":"name_length","kind":13},{"containerName":"name_length","kind":13,"name":"$self","line":267},{"kind":13,"containerName":"name_length","name":"$val","line":267},{"name":"$val","containerName":"name_length","kind":13,"line":267},{"line":268,"kind":13,"containerName":"name_length","name":"$self"}],"name":"name_length","containerName":"main::","definition":"sub","detail":"($self,$val)","line":265,"kind":12,"range":{"end":{"character":9999,"line":269},"start":{"line":265,"character":0}},"signature":{"parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"","label":"name_length($self,$val)"}}]}