{"version":5,"vars":[{"containerName":"","kind":2,"name":"vars","line":124},{"line":128,"containerName":"","kind":2,"name":"base"},{"line":129,"name":"%Defaults","kind":13,"containerName":null},{"signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: lintree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::lintree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::lintree - Parser for lintree output trees\n\n=head1 SYNOPSIS\n\n  # do not use directly, use through Bio::TreeIO\n  use Bio::TreeIO;\n  my $treeio = Bio::TreeIO->new(-format => 'lintree',\n                               -file   => 't/data/crab.nj');\n  my $tree = $treeio->next_tree;\n\n=head1 DESCRIPTION\n\nParser for the lintree output which looks like this\n\n  13 sequences     1000 bootstraping\n1 A-salina\n2 C-vittat\n3 C-sp.\n4 L-aequit\n5 P-camtsc\n6 E-tenuim\n7 L-splend\n8 P-bernha\n9 P-acadia\n10 P-p(NE)\n11 P-p(GU)\n12 P-l(NE)\n13 P-l(GU)\n 14 and   2        0.098857      1000\n 14 and   3        0.127932      1000\n 15 and   1        0.197471      1000\n 15 and  14        0.029273       874\n 16 and  10        0.011732      1000\n 16 and  11        0.004529      1000\n 17 and  12        0.002258      1000\n 17 and  13        0.000428      1000\n 18 and  16        0.017512      1000\n 18 and  17        0.010824       998\n 19 and   4        0.006534      1000\n 19 and   5        0.006992      1000\n 20 and  15        0.070461      1000\n 20 and  18        0.030579       998\n 21 and   8        0.003339      1000\n 21 and   9        0.002042      1000\n 22 and   6        0.011142      1000\n 22 and  21        0.010693       983\n 23 and  20        0.020714       996\n 23 and  19        0.020350      1000\n 24 and  23        0.008665       826\n 24 and  22        0.013457       972\n 24 and   7        0.025598      1000\n\nSee http://www.bio.psu.edu/People/Faculty/Nei/Lab/software.htm for access\nto the program and N Takezaki, A Rzhetsky, and M Nei, \"Phylogenetic test\nof the molecular clock and linearized trees.\" Mol Biol Evol 12(5):823-33.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nIdeas and discussion from:\n Alan Christoffels\n Avril Coghlan\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::lintree;\nuse vars qw(%Defaults);\nuse strict;\n\n\nuse base qw(Bio::TreeIO);\n$Defaults{'NodeType'} = \"Bio::Tree::Node\";\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO::lintree->new();\n Function: Builds a new Bio::TreeIO::lintree object \n Returns : an instance of Bio::TreeIO::lintree\n Args    : -nodetype => Node type to create [default Bio::Tree::Node]"},"line":142,"range":{"start":{"character":0,"line":142},"end":{"character":9999,"line":148}},"kind":12,"definition":"sub","detail":"($self,@args)","children":[{"line":143,"localvar":"my","containerName":"_initialize","kind":13,"name":"$self","definition":"my"},{"kind":13,"containerName":"_initialize","name":"@args","line":143},{"line":144,"kind":13,"containerName":"_initialize","name":"$self"},{"line":144,"name":"@args","containerName":"_initialize","kind":13},{"localvar":"my","containerName":"_initialize","kind":13,"name":"$nodetype","line":145,"definition":"my"},{"name":"$self","containerName":"_initialize","kind":13,"line":145},{"containerName":"_initialize","kind":12,"name":"_rearrange","line":145},{"line":145,"containerName":"_initialize","kind":13,"name":"@args"},{"name":"$nodetype","containerName":"_initialize","kind":13,"line":146},{"containerName":"_initialize","kind":13,"name":"$Defaults","line":146},{"containerName":"_initialize","kind":13,"name":"$self","line":147},{"containerName":"_initialize","kind":12,"name":"nodetype","line":147},{"line":147,"name":"$nodetype","containerName":"_initialize","kind":13}],"name":"_initialize","containerName":"main::"},{"kind":12,"containerName":"_initialize","name":"SUPER","line":144},{"signature":{"label":"next_tree($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: lintree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::lintree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::lintree - Parser for lintree output trees\n\n=head1 SYNOPSIS\n\n  # do not use directly, use through Bio::TreeIO\n  use Bio::TreeIO;\n  my $treeio = Bio::TreeIO->new(-format => 'lintree',\n                               -file   => 't/data/crab.nj');\n  my $tree = $treeio->next_tree;\n\n=head1 DESCRIPTION\n\nParser for the lintree output which looks like this\n\n  13 sequences     1000 bootstraping\n1 A-salina\n2 C-vittat\n3 C-sp.\n4 L-aequit\n5 P-camtsc\n6 E-tenuim\n7 L-splend\n8 P-bernha\n9 P-acadia\n10 P-p(NE)\n11 P-p(GU)\n12 P-l(NE)\n13 P-l(GU)\n 14 and   2        0.098857      1000\n 14 and   3        0.127932      1000\n 15 and   1        0.197471      1000\n 15 and  14        0.029273       874\n 16 and  10        0.011732      1000\n 16 and  11        0.004529      1000\n 17 and  12        0.002258      1000\n 17 and  13        0.000428      1000\n 18 and  16        0.017512      1000\n 18 and  17        0.010824       998\n 19 and   4        0.006534      1000\n 19 and   5        0.006992      1000\n 20 and  15        0.070461      1000\n 20 and  18        0.030579       998\n 21 and   8        0.003339      1000\n 21 and   9        0.002042      1000\n 22 and   6        0.011142      1000\n 22 and  21        0.010693       983\n 23 and  20        0.020714       996\n 23 and  19        0.020350      1000\n 24 and  23        0.008665       826\n 24 and  22        0.013457       972\n 24 and   7        0.025598      1000\n\nSee http://www.bio.psu.edu/People/Faculty/Nei/Lab/software.htm for access\nto the program and N Takezaki, A Rzhetsky, and M Nei, \"Phylogenetic test\nof the molecular clock and linearized trees.\" Mol Biol Evol 12(5):823-33.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nIdeas and discussion from:\n Alan Christoffels\n Avril Coghlan\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::lintree;\nuse vars qw(%Defaults);\nuse strict;\n\n\nuse base qw(Bio::TreeIO);\n$Defaults{'NodeType'} = \"Bio::Tree::Node\";\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO::lintree->new();\n Function: Builds a new Bio::TreeIO::lintree object \n Returns : an instance of Bio::TreeIO::lintree\n Args    : -nodetype => Node type to create [default Bio::Tree::Node]\n\n\n\nsub _initialize { \n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($nodetype) = $self->_rearrange([qw(NODETYPE)],@args);\n    $nodetype ||= $Defaults{'NodeType'};\n    $self->nodetype($nodetype);\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $treeio->next_tree\n Function: Gets the next tree in the stream\n Returns : Bio::Tree::TreeI\n Args    : none"},"line":161,"range":{"start":{"character":0,"line":161},"end":{"line":198,"character":9999}},"kind":12,"definition":"sub","detail":"($self)","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"next_tree","name":"$self","line":162},{"containerName":"next_tree","localvar":"my","kind":13,"name":"$seentop","line":163,"definition":"my"},{"definition":"my","containerName":"next_tree","localvar":"my","kind":13,"name":"$tipcount","line":164},{"name":"%data","containerName":"next_tree","kind":13,"line":164},{"line":164,"name":"@nodes","containerName":"next_tree","kind":13},{"definition":"my","line":165,"localvar":"my","containerName":"next_tree","kind":13,"name":"$nodetype"},{"line":165,"containerName":"next_tree","kind":13,"name":"$self"},{"line":165,"name":"nodetype","kind":12,"containerName":"next_tree"},{"line":167,"name":"$self","containerName":"next_tree","kind":13},{"line":167,"name":"_readline","containerName":"next_tree","kind":12},{"line":169,"name":"$seentop","kind":13,"containerName":"next_tree"},{"name":"$self","containerName":"next_tree","kind":13,"line":170},{"name":"_pushback","containerName":"next_tree","kind":12,"line":170},{"name":"$tipcount","kind":13,"containerName":"next_tree","line":173},{"line":174,"name":"$seentop","containerName":"next_tree","kind":13},{"name":"$data","containerName":"next_tree","kind":13,"line":177},{"line":178,"name":"$data","containerName":"next_tree","kind":13},{"containerName":"next_tree","kind":13,"name":"$nodes","line":180},{"line":182,"localvar":"my","kind":13,"containerName":"next_tree","name":"$node","definition":"my"},{"line":182,"containerName":"next_tree","kind":13,"name":"$descend"},{"kind":13,"containerName":"next_tree","name":"$blength","line":182},{"name":"$bootstrap","containerName":"next_tree","kind":13,"line":182},{"name":"$node","kind":13,"containerName":"next_tree","line":185},{"line":185,"name":"$descend","kind":13,"containerName":"next_tree"},{"kind":13,"containerName":"next_tree","name":"$nodes","line":186},{"line":186,"name":"$descend","kind":13,"containerName":"next_tree"},{"kind":13,"containerName":"next_tree","name":"$blength","line":186},{"line":187,"name":"$nodes","kind":13,"containerName":"next_tree"},{"kind":13,"containerName":"next_tree","name":"$descend","line":187},{"containerName":"next_tree","kind":13,"name":"$bootstrap","line":187},{"line":188,"containerName":"next_tree","kind":13,"name":"$nodes"},{"kind":13,"containerName":"next_tree","name":"$node","line":188},{"line":188,"name":"$node","kind":13,"containerName":"next_tree"},{"line":189,"kind":13,"containerName":"next_tree","name":"$nodes"},{"name":"$node","containerName":"next_tree","kind":13,"line":189},{"line":189,"kind":13,"containerName":"next_tree","name":"$descend"},{"containerName":"next_tree","kind":13,"name":"$data","line":192},{"containerName":"next_tree","kind":13,"name":"$data","line":194},{"name":"$data","kind":13,"containerName":"next_tree","line":196}],"containerName":"main::","name":"next_tree"},{"line":199,"containerName":null,"kind":13,"name":"@nodes"},{"line":200,"name":"@treenodes","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"kind":13,"localvar":"my","containerName":null,"name":"$n","line":201,"definition":"my"},{"containerName":null,"kind":13,"name":"@nodes","line":201},{"name":"@treenodes","containerName":null,"kind":13,"line":202},{"line":202,"name":"$nodetype","kind":13,"containerName":null},{"line":202,"name":"new","kind":12,"containerName":"main::"},{"line":202,"containerName":null,"kind":13,"name":"$n"},{"line":205,"containerName":null,"localvar":"my","kind":13,"name":"$tn","definition":"my"},{"containerName":null,"kind":13,"name":"@treenodes","line":205},{"kind":13,"localvar":"my","containerName":null,"name":"$n","line":206,"definition":"my"},{"line":206,"name":"@nodes","containerName":null,"kind":13},{"definition":"my","line":207,"name":"$ptr","containerName":null,"localvar":"my","kind":13},{"containerName":null,"kind":13,"name":"%n","line":207},{"containerName":null,"kind":13,"name":"$tn","line":208},{"line":208,"name":"add_Descendent","kind":12,"containerName":"main::"},{"line":208,"containerName":null,"kind":13,"name":"@treenodes"},{"name":"$ptr","containerName":null,"kind":13,"line":208},{"definition":"my","line":211,"localvar":"my","kind":13,"containerName":null,"name":"$T"},{"name":"Bio","kind":12,"containerName":"Tree::Tree","line":211},{"containerName":"main::","kind":12,"name":"new","line":211},{"containerName":null,"kind":13,"name":"@treenodes","line":211},{"name":"%data","containerName":null,"kind":13,"line":212},{"line":213,"localvar":"my","containerName":null,"kind":13,"name":"$outgroup","definition":"my"},{"line":213,"name":"@treenodes","kind":13,"containerName":null},{"line":213,"containerName":null,"kind":13,"name":"%data"},{"line":214,"containerName":null,"kind":13,"name":"%outgroup"},{"name":"$self","kind":13,"containerName":null,"line":215},{"line":215,"containerName":"main::","kind":12,"name":"warn"},{"name":"%data","containerName":null,"kind":13,"line":215},{"name":"$T","kind":13,"containerName":null,"line":217},{"line":217,"containerName":"main::","kind":12,"name":"reroot"},{"line":217,"name":"$outgroup","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"ancestor","line":217},{"line":220,"containerName":null,"kind":13,"name":"$T"},{"line":238,"kind":12,"range":{"end":{"character":9999,"line":252},"start":{"character":0,"line":238}},"signature":{"label":"nodetype($self,$value)","documentation":"1;\n# $Id: lintree.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO::lintree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::lintree - Parser for lintree output trees\n\n=head1 SYNOPSIS\n\n  # do not use directly, use through Bio::TreeIO\n  use Bio::TreeIO;\n  my $treeio = Bio::TreeIO->new(-format => 'lintree',\n                               -file   => 't/data/crab.nj');\n  my $tree = $treeio->next_tree;\n\n=head1 DESCRIPTION\n\nParser for the lintree output which looks like this\n\n  13 sequences     1000 bootstraping\n1 A-salina\n2 C-vittat\n3 C-sp.\n4 L-aequit\n5 P-camtsc\n6 E-tenuim\n7 L-splend\n8 P-bernha\n9 P-acadia\n10 P-p(NE)\n11 P-p(GU)\n12 P-l(NE)\n13 P-l(GU)\n 14 and   2        0.098857      1000\n 14 and   3        0.127932      1000\n 15 and   1        0.197471      1000\n 15 and  14        0.029273       874\n 16 and  10        0.011732      1000\n 16 and  11        0.004529      1000\n 17 and  12        0.002258      1000\n 17 and  13        0.000428      1000\n 18 and  16        0.017512      1000\n 18 and  17        0.010824       998\n 19 and   4        0.006534      1000\n 19 and   5        0.006992      1000\n 20 and  15        0.070461      1000\n 20 and  18        0.030579       998\n 21 and   8        0.003339      1000\n 21 and   9        0.002042      1000\n 22 and   6        0.011142      1000\n 22 and  21        0.010693       983\n 23 and  20        0.020714       996\n 23 and  19        0.020350      1000\n 24 and  23        0.008665       826\n 24 and  22        0.013457       972\n 24 and   7        0.025598      1000\n\nSee http://www.bio.psu.edu/People/Faculty/Nei/Lab/software.htm for access\nto the program and N Takezaki, A Rzhetsky, and M Nei, \"Phylogenetic test\nof the molecular clock and linearized trees.\" Mol Biol Evol 12(5):823-33.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nIdeas and discussion from:\n Alan Christoffels\n Avril Coghlan\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::lintree;\nuse vars qw(%Defaults);\nuse strict;\n\n\nuse base qw(Bio::TreeIO);\n$Defaults{'NodeType'} = \"Bio::Tree::Node\";\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO::lintree->new();\n Function: Builds a new Bio::TreeIO::lintree object \n Returns : an instance of Bio::TreeIO::lintree\n Args    : -nodetype => Node type to create [default Bio::Tree::Node]\n\n\n\nsub _initialize { \n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($nodetype) = $self->_rearrange([qw(NODETYPE)],@args);\n    $nodetype ||= $Defaults{'NodeType'};\n    $self->nodetype($nodetype);\n}\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $treeio->next_tree\n Function: Gets the next tree in the stream\n Returns : Bio::Tree::TreeI\n Args    : none\n\n\n\nsub next_tree {\n    my ($self) = @_;\n    my $seentop = 0;\n    my ($tipcount,%data,@nodes) = (0);\n    my $nodetype = $self->nodetype;   \n\n    while( defined( $_ = $self->_readline) ) {\n\tif( /^\\s*(\\d+)\\s+sequences/ox ) {\n\t    if( $seentop ) { \n\t\t$self->_pushback($_);\n\t\tlast;\n\t    }\n\t    $tipcount = $1;\n\t    $seentop = 1;\n\t} elsif( /^(\\d+)\\s+(\\S+)\\s*$/ox ) {\n\t    # deal with setting an outgroup\n\t    unless( defined $data{'outgroup'} ) {\n\t\t$data{'outgroup'} = [$1,$2];\n\t    }\n\t    $nodes[$1 - 1] = { '-id' => $2 }; \n\t} elsif( m/^\\s*(\\d+)\\s+and\\s+(\\d+)\\s+(\\-?\\d+\\.\\d+)(?:\\s+(\\d+))?/ox ) {\n\t    my ($node,$descend,$blength,$bootstrap) = ( $1, $2, $3, $4 );\n\t    # need to -- descend and node because\n\t    # array is 0 based\n\t    $node--;$descend--;\n\t    $nodes[$descend]->{'-branch_length'} = $blength;\n\t    $nodes[$descend]->{'-bootstrap'}     = $bootstrap; #? here\n\t    $nodes[$node]->{'-id'} = $node+1;\n\t    push @{$nodes[$node]->{'-d'}}, $descend;\n\t    \n\t} elsif( /\\s+(\\S+)\\-distance was used\\./ox ) {\n\t    $data{'method'} = $1;\n\t} elsif( /\\s*seed=(\\d+)/ox ) {\n\t    $data{'seed'} = $1;\n\t} elsif( m/^outgroup:\\s+(\\d+)\\s+(\\S+)/ox ) {\n\t    $data{'outgroup'} = [$1,$2];\n\t}\n    }\n    if( @nodes ) {\n\tmy @treenodes;\n\tforeach my $n ( @nodes ) { \t\n\t    push @treenodes, $nodetype->new(%{$n});\n\t}\n\t\n\tforeach my $tn ( @treenodes ) {\n\t    my $n = shift @nodes;\n\t    for my $ptr ( @{ $n->{'-d'} || [] } ) {\n\t\t$tn->add_Descendent($treenodes[$ptr]);\n\t    }\n\t}\n\tmy $T = Bio::Tree::Tree->new(-root => (pop @treenodes) );\n\tif( $data{'outgroup'} ) {\n\t    my ($outgroup) = $treenodes[$data{'outgroup'}->[0]];\n\t    if( ! defined $outgroup) {\n\t\t$self->warn(\"cannot find '\". $data{'outgroup'}->[1]. \"'\\n\");\n\t    } else { \n\t\t$T->reroot($outgroup->ancestor);\n\t    }\n\t}\n\treturn $T;\n    }\n    return; # if there are no more trees, return undef\n\t\n}\n\n=head2 nodetype\n\n Title   : nodetype\n Usage   : $obj->nodetype($newval)\n Function: \n Example : \n Returns : value of nodetype (a scalar)\n Args    : on set, new value (a scalar or undef, optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"children":[{"name":"$self","containerName":"nodetype","localvar":"my","kind":13,"line":239,"definition":"my"},{"name":"$value","containerName":"nodetype","kind":13,"line":239},{"kind":13,"containerName":"nodetype","name":"$value","line":240},{"name":"$self","kind":13,"containerName":"nodetype","line":242},{"line":242,"name":"throw","kind":12,"containerName":"nodetype"},{"name":"$self","containerName":"nodetype","kind":13,"line":242},{"definition":"my","line":245,"name":"$a","containerName":"nodetype","localvar":"my","kind":13},{"name":"$value","kind":13,"containerName":"nodetype","line":245},{"kind":13,"containerName":"nodetype","name":"$a","line":246},{"line":246,"containerName":"nodetype","kind":12,"name":"isa"},{"kind":13,"containerName":"nodetype","name":"$self","line":247},{"line":247,"name":"throw","containerName":"nodetype","kind":12},{"containerName":"nodetype","kind":13,"name":"$self","line":249},{"name":"$value","kind":13,"containerName":"nodetype","line":249},{"line":251,"containerName":"nodetype","kind":13,"name":"$self"}],"name":"nodetype","containerName":"main::","definition":"sub","detail":"($self,$value)"}]}