{"version":5,"vars":[{"line":91,"kind":2,"containerName":"","name":"base"},{"definition":1,"kind":14,"containerName":"main::","name":"INTERNAL_NODE_ID","line":93},{"kind":12,"range":{"start":{"character":0,"line":116},"end":{"line":139,"character":9999}},"line":116,"signature":{"label":"new($caller,@args)","parameters":[{"label":"$caller"},{"label":"@args"}],"documentation":"1;\n# $Id: TreeIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO - Parser for Tree files\n\n=head1 SYNOPSIS\n\n  {\n      use Bio::TreeIO;\n      my $treeio = Bio::TreeIO->new('-format' => 'newick',\n                   '-file'   => 'globin.dnd');\n      while( my $tree = $treeio->next_tree ) {\n\t\tprint \"Tree is \", $tree->number_nodes, \"\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the driver module for Tree reading from data streams and\nflatfiles.  This is intended to be able to create Bio::Tree::TreeI\nobjects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nAllen Day E<lt>allenday@ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::TreeIO::TreeEventBuilder;\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::Event::EventGeneratorI Bio::Factory::TreeFactoryI);\n\nuse constant INTERNAL_NODE_ID => 'id'; # id or bootstrap, default is 'id' \n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO->new();\n Function: Builds a new Bio::TreeIO object \n Returns : Bio::TreeIO\n Args    : a hash.  useful keys:\n   -format : Specify the format of the file.  Supported formats:\n\n     newick             Newick tree format\n     nexus              Nexus tree format\n     nhx                NHX tree format\n     svggraph           SVG graphical representation of tree\n     tabtree            ASCII text representation of tree\n     lintree            lintree output format\n   -internal_node_id : what is stored in the internal node ids, \n                       bootstrap values or ids, coded as \n                       'bootstrap' or 'id'"},"containerName":"main::","name":"new","children":[{"definition":"my","line":117,"localvar":"my","kind":13,"containerName":"new","name":"$caller"},{"line":117,"name":"@args","kind":13,"containerName":"new"},{"definition":"my","name":"$class","localvar":"my","kind":13,"containerName":"new","line":118},{"line":118,"name":"$caller","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$caller","line":118},{"name":"$class","kind":13,"containerName":"new","line":122},{"name":"$self","localvar":"my","containerName":"new","kind":13,"line":123,"definition":"my"},{"line":123,"containerName":"new","kind":13,"name":"$class"},{"kind":13,"containerName":"new","name":"@args","line":123},{"line":124,"name":"$self","containerName":"new","kind":13},{"containerName":"new","kind":12,"name":"_initialize","line":124},{"containerName":"new","kind":13,"name":"@args","line":124},{"name":"$self","kind":13,"containerName":"new","line":125},{"definition":"my","name":"%param","containerName":"new","localvar":"my","kind":13,"line":128},{"kind":13,"containerName":"new","name":"@args","line":128},{"containerName":"new","kind":13,"name":"@param","line":129},{"line":129,"kind":13,"containerName":"new","name":"%param"},{"line":129,"containerName":"new","kind":13,"name":"%param"},{"name":"$format","kind":13,"localvar":"my","containerName":"new","line":130,"definition":"my"},{"containerName":"new","kind":13,"name":"$param","line":130},{"line":131,"name":"$class","containerName":"new","kind":13},{"name":"_guess_format","kind":12,"containerName":"new","line":131},{"line":131,"name":"$param","containerName":"new","kind":13},{"name":"$ARGV","kind":13,"containerName":"new","line":131},{"line":133,"containerName":"new","kind":13,"name":"$format"},{"line":136,"name":"$class","containerName":"new","kind":13},{"kind":12,"containerName":"new","name":"_load_format_module","line":136},{"line":136,"containerName":"new","kind":13,"name":"$format"},{"line":137,"name":"new","containerName":"new","kind":12},{"kind":13,"containerName":"new","name":"@args","line":137}],"detail":"($caller,@args)","definition":"sub"},{"line":123,"name":"SUPER","kind":12,"containerName":"new"},{"containerName":"main::","name":"next_tree","children":[{"name":"$self","containerName":"next_tree","localvar":"my","kind":13,"line":153,"definition":"my"},{"line":154,"kind":13,"containerName":"next_tree","name":"$self"},{"line":154,"kind":12,"containerName":"next_tree","name":"throw"}],"detail":"($self)","definition":"sub","kind":12,"range":{"end":{"line":155,"character":9999},"start":{"character":0,"line":152}},"line":152,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: TreeIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO - Parser for Tree files\n\n=head1 SYNOPSIS\n\n  {\n      use Bio::TreeIO;\n      my $treeio = Bio::TreeIO->new('-format' => 'newick',\n                   '-file'   => 'globin.dnd');\n      while( my $tree = $treeio->next_tree ) {\n\t\tprint \"Tree is \", $tree->number_nodes, \"\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the driver module for Tree reading from data streams and\nflatfiles.  This is intended to be able to create Bio::Tree::TreeI\nobjects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nAllen Day E<lt>allenday@ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::TreeIO::TreeEventBuilder;\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::Event::EventGeneratorI Bio::Factory::TreeFactoryI);\n\nuse constant INTERNAL_NODE_ID => 'id'; # id or bootstrap, default is 'id' \n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO->new();\n Function: Builds a new Bio::TreeIO object \n Returns : Bio::TreeIO\n Args    : a hash.  useful keys:\n   -format : Specify the format of the file.  Supported formats:\n\n     newick             Newick tree format\n     nexus              Nexus tree format\n     nhx                NHX tree format\n     svggraph           SVG graphical representation of tree\n     tabtree            ASCII text representation of tree\n     lintree            lintree output format\n   -internal_node_id : what is stored in the internal node ids, \n                       bootstrap values or ids, coded as \n                       'bootstrap' or 'id'\n\n\nsub new {\n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::TreeIO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);     \n    $self->_initialize(@args);\n    return $self;\n    } else { \n\n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} || \n        $class->_guess_format( $param{'-file'} || $ARGV[0] ) ||\n        'newick';\n    $format = \"\\L$format\";  # normalize capitalization to lower case\n    \n    # normalize capitalization\n    return unless( $class->_load_format_module($format) );\n    return \"Bio::TreeIO::$format\"->new(@args);\n    }\n}\n\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $treeio->next_tree;\n Function: Gets the next tree off the stream\n Returns : Bio::Tree::TreeI or undef if no more trees\n Args    : none","label":"next_tree($self)"}},{"signature":{"documentation":"1;\n# $Id: TreeIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO - Parser for Tree files\n\n=head1 SYNOPSIS\n\n  {\n      use Bio::TreeIO;\n      my $treeio = Bio::TreeIO->new('-format' => 'newick',\n                   '-file'   => 'globin.dnd');\n      while( my $tree = $treeio->next_tree ) {\n\t\tprint \"Tree is \", $tree->number_nodes, \"\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the driver module for Tree reading from data streams and\nflatfiles.  This is intended to be able to create Bio::Tree::TreeI\nobjects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nAllen Day E<lt>allenday@ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::TreeIO::TreeEventBuilder;\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::Event::EventGeneratorI Bio::Factory::TreeFactoryI);\n\nuse constant INTERNAL_NODE_ID => 'id'; # id or bootstrap, default is 'id' \n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO->new();\n Function: Builds a new Bio::TreeIO object \n Returns : Bio::TreeIO\n Args    : a hash.  useful keys:\n   -format : Specify the format of the file.  Supported formats:\n\n     newick             Newick tree format\n     nexus              Nexus tree format\n     nhx                NHX tree format\n     svggraph           SVG graphical representation of tree\n     tabtree            ASCII text representation of tree\n     lintree            lintree output format\n   -internal_node_id : what is stored in the internal node ids, \n                       bootstrap values or ids, coded as \n                       'bootstrap' or 'id'\n\n\nsub new {\n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::TreeIO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);     \n    $self->_initialize(@args);\n    return $self;\n    } else { \n\n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} || \n        $class->_guess_format( $param{'-file'} || $ARGV[0] ) ||\n        'newick';\n    $format = \"\\L$format\";  # normalize capitalization to lower case\n    \n    # normalize capitalization\n    return unless( $class->_load_format_module($format) );\n    return \"Bio::TreeIO::$format\"->new(@args);\n    }\n}\n\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $treeio->next_tree;\n Function: Gets the next tree off the stream\n Returns : Bio::Tree::TreeI or undef if no more trees\n Args    : none\n\n\nsub next_tree{\n   my ($self) = @_;\n   $self->throw(\"Cannot call method next_tree on Bio::TreeIO object must use a subclass\");\n}\n\n=head2 write_tree\n\n Title   : write_tree\n Usage   : $treeio->write_tree($tree);\n Function: Writes a tree onto the stream\n Returns : none\n Args    : Bio::Tree::TreeI","parameters":[{"label":"$self"},{"label":"$tree"}],"label":"write_tree($self,$tree)"},"range":{"start":{"character":0,"line":168},"end":{"character":9999,"line":171}},"kind":12,"line":168,"detail":"($self,$tree)","definition":"sub","name":"write_tree","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"write_tree","kind":13,"line":169,"definition":"my"},{"line":169,"name":"$tree","containerName":"write_tree","kind":13},{"line":170,"name":"$self","containerName":"write_tree","kind":13},{"name":"throw","kind":12,"containerName":"write_tree","line":170}]},{"detail":"($self,$handler)","definition":"sub","containerName":"main::","name":"attach_EventHandler","children":[{"definition":"my","line":185,"localvar":"my","containerName":"attach_EventHandler","kind":13,"name":"$self"},{"line":185,"name":"$handler","kind":13,"containerName":"attach_EventHandler"},{"containerName":"attach_EventHandler","kind":13,"name":"$handler","line":186},{"name":"$handler","kind":13,"containerName":"attach_EventHandler","line":187},{"containerName":"attach_EventHandler","kind":12,"name":"isa","line":187},{"line":188,"name":"$self","containerName":"attach_EventHandler","kind":13},{"name":"warn","containerName":"attach_EventHandler","kind":12,"line":188},{"line":188,"kind":13,"containerName":"attach_EventHandler","name":"$handler"},{"line":190,"containerName":"attach_EventHandler","kind":13,"name":"$self"},{"line":190,"name":"$handler","containerName":"attach_EventHandler","kind":13}],"signature":{"label":"attach_EventHandler($self,$handler)","parameters":[{"label":"$self"},{"label":"$handler"}],"documentation":"1;\n# $Id: TreeIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO - Parser for Tree files\n\n=head1 SYNOPSIS\n\n  {\n      use Bio::TreeIO;\n      my $treeio = Bio::TreeIO->new('-format' => 'newick',\n                   '-file'   => 'globin.dnd');\n      while( my $tree = $treeio->next_tree ) {\n\t\tprint \"Tree is \", $tree->number_nodes, \"\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the driver module for Tree reading from data streams and\nflatfiles.  This is intended to be able to create Bio::Tree::TreeI\nobjects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nAllen Day E<lt>allenday@ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::TreeIO::TreeEventBuilder;\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::Event::EventGeneratorI Bio::Factory::TreeFactoryI);\n\nuse constant INTERNAL_NODE_ID => 'id'; # id or bootstrap, default is 'id' \n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO->new();\n Function: Builds a new Bio::TreeIO object \n Returns : Bio::TreeIO\n Args    : a hash.  useful keys:\n   -format : Specify the format of the file.  Supported formats:\n\n     newick             Newick tree format\n     nexus              Nexus tree format\n     nhx                NHX tree format\n     svggraph           SVG graphical representation of tree\n     tabtree            ASCII text representation of tree\n     lintree            lintree output format\n   -internal_node_id : what is stored in the internal node ids, \n                       bootstrap values or ids, coded as \n                       'bootstrap' or 'id'\n\n\nsub new {\n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::TreeIO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);     \n    $self->_initialize(@args);\n    return $self;\n    } else { \n\n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} || \n        $class->_guess_format( $param{'-file'} || $ARGV[0] ) ||\n        'newick';\n    $format = \"\\L$format\";  # normalize capitalization to lower case\n    \n    # normalize capitalization\n    return unless( $class->_load_format_module($format) );\n    return \"Bio::TreeIO::$format\"->new(@args);\n    }\n}\n\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $treeio->next_tree;\n Function: Gets the next tree off the stream\n Returns : Bio::Tree::TreeI or undef if no more trees\n Args    : none\n\n\nsub next_tree{\n   my ($self) = @_;\n   $self->throw(\"Cannot call method next_tree on Bio::TreeIO object must use a subclass\");\n}\n\n=head2 write_tree\n\n Title   : write_tree\n Usage   : $treeio->write_tree($tree);\n Function: Writes a tree onto the stream\n Returns : none\n Args    : Bio::Tree::TreeI\n\n\n\nsub write_tree{\n   my ($self,$tree) = @_;\n   $self->throw(\"Cannot call method write_tree on Bio::TreeIO object must use a subclass\");\n}\n\n\n=head2 attach_EventHandler\n\n Title   : attach_EventHandler\n Usage   : $parser->attatch_EventHandler($handler)\n Function: Adds an event handler to listen for events\n Returns : none\n Args    : Bio::Event::EventHandlerI"},"range":{"end":{"character":9999,"line":192},"start":{"character":0,"line":184}},"kind":12,"line":184},{"definition":"sub","detail":"($self)","children":[{"line":206,"kind":13,"localvar":"my","containerName":"_eventHandler","name":"$self","definition":"my"},{"line":207,"containerName":"_eventHandler","kind":13,"name":"$self"}],"name":"_eventHandler","containerName":"main::","signature":{"documentation":"1;\n# $Id: TreeIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO - Parser for Tree files\n\n=head1 SYNOPSIS\n\n  {\n      use Bio::TreeIO;\n      my $treeio = Bio::TreeIO->new('-format' => 'newick',\n                   '-file'   => 'globin.dnd');\n      while( my $tree = $treeio->next_tree ) {\n\t\tprint \"Tree is \", $tree->number_nodes, \"\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the driver module for Tree reading from data streams and\nflatfiles.  This is intended to be able to create Bio::Tree::TreeI\nobjects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nAllen Day E<lt>allenday@ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::TreeIO::TreeEventBuilder;\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::Event::EventGeneratorI Bio::Factory::TreeFactoryI);\n\nuse constant INTERNAL_NODE_ID => 'id'; # id or bootstrap, default is 'id' \n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO->new();\n Function: Builds a new Bio::TreeIO object \n Returns : Bio::TreeIO\n Args    : a hash.  useful keys:\n   -format : Specify the format of the file.  Supported formats:\n\n     newick             Newick tree format\n     nexus              Nexus tree format\n     nhx                NHX tree format\n     svggraph           SVG graphical representation of tree\n     tabtree            ASCII text representation of tree\n     lintree            lintree output format\n   -internal_node_id : what is stored in the internal node ids, \n                       bootstrap values or ids, coded as \n                       'bootstrap' or 'id'\n\n\nsub new {\n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::TreeIO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);     \n    $self->_initialize(@args);\n    return $self;\n    } else { \n\n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} || \n        $class->_guess_format( $param{'-file'} || $ARGV[0] ) ||\n        'newick';\n    $format = \"\\L$format\";  # normalize capitalization to lower case\n    \n    # normalize capitalization\n    return unless( $class->_load_format_module($format) );\n    return \"Bio::TreeIO::$format\"->new(@args);\n    }\n}\n\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $treeio->next_tree;\n Function: Gets the next tree off the stream\n Returns : Bio::Tree::TreeI or undef if no more trees\n Args    : none\n\n\nsub next_tree{\n   my ($self) = @_;\n   $self->throw(\"Cannot call method next_tree on Bio::TreeIO object must use a subclass\");\n}\n\n=head2 write_tree\n\n Title   : write_tree\n Usage   : $treeio->write_tree($tree);\n Function: Writes a tree onto the stream\n Returns : none\n Args    : Bio::Tree::TreeI\n\n\n\nsub write_tree{\n   my ($self,$tree) = @_;\n   $self->throw(\"Cannot call method write_tree on Bio::TreeIO object must use a subclass\");\n}\n\n\n=head2 attach_EventHandler\n\n Title   : attach_EventHandler\n Usage   : $parser->attatch_EventHandler($handler)\n Function: Adds an event handler to listen for events\n Returns : none\n Args    : Bio::Event::EventHandlerI\n\n\nsub attach_EventHandler{\n    my ($self,$handler) = @_;\n    return if( ! $handler );\n    if( ! $handler->isa('Bio::Event::EventHandlerI') ) {\n    $self->warn(\"Ignoring request to attach handler \".ref($handler). ' because it is not a Bio::Event::EventHandlerI');\n    }\n    $self->{'_handler'} = $handler;\n    return;\n}\n\n=head2 _eventHandler\n\n Title   : _eventHandler\n Usage   : private\n Function: Get the EventHandler\n Returns : Bio::Event::EventHandlerI\n Args    : none","parameters":[{"label":"$self"}],"label":"_eventHandler($self)"},"line":205,"kind":12,"range":{"end":{"character":9999,"line":208},"start":{"line":205,"character":0}}},{"children":[{"kind":13,"localvar":"my","containerName":"_initialize","name":"$self","line":211,"definition":"my"},{"line":211,"containerName":"_initialize","kind":13,"name":"@args"},{"line":212,"name":"$self","containerName":"_initialize","kind":13},{"definition":"my","name":"$internal_node_id","localvar":"my","containerName":"_initialize","kind":13,"line":213},{"kind":13,"containerName":"_initialize","name":"$self","line":214},{"name":"$self","containerName":"_initialize","kind":13,"line":215},{"containerName":"_initialize","kind":13,"name":"$internal_node_id","line":215},{"name":"$self","kind":13,"containerName":"_initialize","line":215},{"name":"_rearrange","containerName":"_initialize","kind":12,"line":216},{"line":216,"name":"@args","containerName":"_initialize","kind":13},{"name":"$self","containerName":"_initialize","kind":13,"line":219},{"name":"_initialize_io","containerName":"_initialize","kind":12,"line":219},{"line":219,"name":"@args","containerName":"_initialize","kind":13},{"kind":13,"containerName":"_initialize","name":"$self","line":220},{"line":220,"containerName":"_initialize","kind":12,"name":"attach_EventHandler"},{"line":221,"containerName":"_initialize","kind":12,"name":"new"},{"line":221,"containerName":"_initialize","kind":13,"name":"$self"},{"containerName":"_initialize","kind":12,"name":"verbose","line":221},{"name":"@args","kind":13,"containerName":"_initialize","line":221},{"line":222,"name":"$self","containerName":"_initialize","kind":13},{"name":"internal_node_id","kind":12,"containerName":"_initialize","line":222},{"line":222,"name":"$internal_node_id","kind":13,"containerName":"_initialize"},{"line":222,"name":"$internal_node_id","containerName":"_initialize","kind":13}],"name":"_initialize","containerName":"main::","definition":"sub","detail":"($self,@args)","line":210,"kind":12,"range":{"start":{"character":0,"line":210},"end":{"line":223,"character":9999}},"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"","label":"_initialize($self,@args)"}},{"line":214,"name":"INTERNAL_NODE_ID","kind":12},{"kind":12,"containerName":"TreeIO::TreeEventBuilder","name":"Bio","line":220},{"signature":{"label":"_load_format_module($self,$format)","parameters":[{"label":"$self"},{"label":"$format"}],"documentation":"1;\n# $Id: TreeIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::TreeIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO - Parser for Tree files\n\n=head1 SYNOPSIS\n\n  {\n      use Bio::TreeIO;\n      my $treeio = Bio::TreeIO->new('-format' => 'newick',\n                   '-file'   => 'globin.dnd');\n      while( my $tree = $treeio->next_tree ) {\n\t\tprint \"Tree is \", $tree->number_nodes, \"\\n\";\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the driver module for Tree reading from data streams and\nflatfiles.  This is intended to be able to create Bio::Tree::TreeI\nobjects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nAllen Day E<lt>allenday@ucla.eduE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::TreeIO::TreeEventBuilder;\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::Event::EventGeneratorI Bio::Factory::TreeFactoryI);\n\nuse constant INTERNAL_NODE_ID => 'id'; # id or bootstrap, default is 'id' \n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO->new();\n Function: Builds a new Bio::TreeIO object \n Returns : Bio::TreeIO\n Args    : a hash.  useful keys:\n   -format : Specify the format of the file.  Supported formats:\n\n     newick             Newick tree format\n     nexus              Nexus tree format\n     nhx                NHX tree format\n     svggraph           SVG graphical representation of tree\n     tabtree            ASCII text representation of tree\n     lintree            lintree output format\n   -internal_node_id : what is stored in the internal node ids, \n                       bootstrap values or ids, coded as \n                       'bootstrap' or 'id'\n\n\nsub new {\n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::TreeIO::(\\S+)/ ) {\n    my ($self) = $class->SUPER::new(@args);     \n    $self->_initialize(@args);\n    return $self;\n    } else { \n\n    my %param = @args;\n    @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n    my $format = $param{'-format'} || \n        $class->_guess_format( $param{'-file'} || $ARGV[0] ) ||\n        'newick';\n    $format = \"\\L$format\";  # normalize capitalization to lower case\n    \n    # normalize capitalization\n    return unless( $class->_load_format_module($format) );\n    return \"Bio::TreeIO::$format\"->new(@args);\n    }\n}\n\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $treeio->next_tree;\n Function: Gets the next tree off the stream\n Returns : Bio::Tree::TreeI or undef if no more trees\n Args    : none\n\n\nsub next_tree{\n   my ($self) = @_;\n   $self->throw(\"Cannot call method next_tree on Bio::TreeIO object must use a subclass\");\n}\n\n=head2 write_tree\n\n Title   : write_tree\n Usage   : $treeio->write_tree($tree);\n Function: Writes a tree onto the stream\n Returns : none\n Args    : Bio::Tree::TreeI\n\n\n\nsub write_tree{\n   my ($self,$tree) = @_;\n   $self->throw(\"Cannot call method write_tree on Bio::TreeIO object must use a subclass\");\n}\n\n\n=head2 attach_EventHandler\n\n Title   : attach_EventHandler\n Usage   : $parser->attatch_EventHandler($handler)\n Function: Adds an event handler to listen for events\n Returns : none\n Args    : Bio::Event::EventHandlerI\n\n\nsub attach_EventHandler{\n    my ($self,$handler) = @_;\n    return if( ! $handler );\n    if( ! $handler->isa('Bio::Event::EventHandlerI') ) {\n    $self->warn(\"Ignoring request to attach handler \".ref($handler). ' because it is not a Bio::Event::EventHandlerI');\n    }\n    $self->{'_handler'} = $handler;\n    return;\n}\n\n=head2 _eventHandler\n\n Title   : _eventHandler\n Usage   : private\n Function: Get the EventHandler\n Returns : Bio::Event::EventHandlerI\n Args    : none\n\n\n\nsub _eventHandler{\n   my ($self) = @_;\n   return $self->{'_handler'};\n}\n\nsub _initialize {\n    my($self, @args) = @_;\n    $self->{'_handler'} = undef;\n    my $internal_node_id;\n    $self->{'internal_node_id'} = INTERNAL_NODE_ID;\n    ($self->{'newline_each_node'},$internal_node_id) = $self->_rearrange\n    ([qw(NEWLINE_EACH_NODE INTERNAL_NODE_ID)],@args);\n    \n    # initialize the IO part\n    $self->_initialize_io(@args);\n    $self->attach_EventHandler(Bio::TreeIO::TreeEventBuilder->new\n                   (-verbose => $self->verbose(), @args));\n    $self->internal_node_id($internal_node_id) if defined $internal_node_id;\n}\n\n=head2 _load_format_module\n\n Title   : _load_format_module\n Usage   : *INTERNAL TreeIO stuff*\n Function: Loads up (like use) a module at run time on demand\n Example :\n Returns :\n Args    :"},"kind":12,"range":{"start":{"character":0,"line":236},"end":{"line":254,"character":9999}},"line":236,"detail":"($self,$format)","definition":"sub","containerName":"main::","name":"_load_format_module","children":[{"definition":"my","line":237,"name":"$self","localvar":"my","containerName":"_load_format_module","kind":13},{"line":237,"containerName":"_load_format_module","kind":13,"name":"$format"},{"definition":"my","name":"$module","containerName":"_load_format_module","localvar":"my","kind":13,"line":238},{"containerName":"_load_format_module","kind":13,"name":"$format","line":238},{"definition":"my","localvar":"my","kind":13,"containerName":"_load_format_module","name":"$ok","line":239},{"kind":13,"containerName":"_load_format_module","name":"$ok","line":242},{"name":"$self","kind":13,"containerName":"_load_format_module","line":242},{"line":242,"kind":12,"containerName":"_load_format_module","name":"_load_module"},{"line":242,"kind":13,"containerName":"_load_format_module","name":"$module"},{"line":253,"name":"$ok","containerName":"_load_format_module","kind":13}]},{"definition":"sub","children":[{"name":"$self","containerName":"newline_each_node","localvar":"my","kind":13,"line":270,"definition":"my"},{"kind":13,"containerName":"newline_each_node","name":"$self","line":271},{"name":"$self","containerName":"newline_each_node","kind":13,"line":272}],"containerName":"main::","name":"newline_each_node","line":269,"kind":12,"range":{"start":{"line":269,"character":0},"end":{"line":273,"character":9999}}},{"kind":12,"range":{"start":{"character":0,"line":287},"end":{"character":9999,"line":301}},"line":287,"definition":"sub","containerName":"main::","name":"internal_node_id","children":[{"line":288,"kind":13,"localvar":"my","containerName":"internal_node_id","name":"$self","definition":"my"},{"line":289,"name":"$val","kind":13,"localvar":"my","containerName":"internal_node_id","definition":"my"},{"line":290,"kind":13,"containerName":"internal_node_id","name":"$val"},{"name":"$val","containerName":"internal_node_id","kind":13,"line":291},{"line":292,"kind":13,"containerName":"internal_node_id","name":"$val"},{"containerName":"internal_node_id","kind":13,"name":"$val","line":293},{"name":"$val","containerName":"internal_node_id","kind":13,"line":294},{"name":"$self","containerName":"internal_node_id","kind":13,"line":296},{"name":"warn","kind":12,"containerName":"internal_node_id","line":296},{"name":"$self","containerName":"internal_node_id","kind":13,"line":298},{"kind":13,"containerName":"internal_node_id","name":"$val","line":298},{"line":300,"name":"$self","containerName":"internal_node_id","kind":13}]},{"containerName":"main::","name":"_guess_format","children":[{"name":"$class","containerName":"_guess_format","localvar":"my","kind":13,"line":316,"definition":"my"}],"definition":"sub","range":{"start":{"character":0,"line":315},"end":{"line":323,"character":9999}},"kind":12,"line":315},{"definition":"sub","children":[{"definition":"my","line":326,"containerName":"DESTROY","localvar":"my","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"DESTROY","line":328},{"containerName":"DESTROY","kind":12,"name":"close","line":328}],"name":"DESTROY","containerName":"main::","line":325,"range":{"end":{"line":329,"character":9999},"start":{"character":0,"line":325}},"kind":12},{"children":[{"definition":"my","line":332,"name":"$class","localvar":"my","kind":13,"containerName":"TIEHANDLE"},{"line":333,"kind":13,"containerName":"TIEHANDLE","name":"$class"}],"name":"TIEHANDLE","containerName":"main::","definition":"sub","line":331,"kind":12,"range":{"end":{"line":334,"character":9999},"start":{"character":0,"line":331}}},{"kind":12,"range":{"start":{"character":0,"line":336},"end":{"line":342,"character":9999}},"line":336,"containerName":"main::","name":"READLINE","children":[{"line":337,"name":"$self","containerName":"READLINE","localvar":"my","kind":13,"definition":"my"},{"containerName":"READLINE","kind":13,"name":"$self","line":338},{"line":338,"kind":12,"containerName":"READLINE","name":"next_tree"},{"line":339,"containerName":"READLINE","localvar":"my","kind":13,"name":"@list","definition":"my"},{"containerName":"READLINE","kind":13,"name":"$obj","line":339},{"name":"@list","containerName":"READLINE","kind":13,"line":340},{"line":340,"name":"$obj","containerName":"READLINE","kind":13},{"kind":13,"containerName":"READLINE","name":"$obj","line":340},{"line":340,"name":"$self","containerName":"READLINE","kind":13},{"line":340,"name":"next_tree","kind":12,"containerName":"READLINE"},{"containerName":"READLINE","kind":13,"name":"@list","line":341}],"definition":"sub"},{"definition":"sub","containerName":"main::","name":"PRINT","children":[{"definition":"my","line":345,"name":"$self","containerName":"PRINT","localvar":"my","kind":13},{"name":"$self","kind":13,"containerName":"PRINT","line":346},{"name":"write_tree","containerName":"PRINT","kind":12,"line":346}],"kind":12,"range":{"end":{"character":9999,"line":347},"start":{"line":344,"character":0}},"line":344}]}