{"version":5,"vars":[{"name":"base","kind":2,"containerName":"","line":84},{"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"assess_bootstrap","line":110},{"line":110,"containerName":"assess_bootstrap","kind":13,"name":"$bs_trees"},{"name":"$guide_tree","kind":13,"containerName":"assess_bootstrap","line":110},{"definition":"my","name":"@consensus","kind":13,"localvar":"my","containerName":"assess_bootstrap","line":111},{"name":"%lookup","containerName":"assess_bootstrap","localvar":"my","kind":13,"line":115,"definition":"my"},{"line":115,"containerName":"assess_bootstrap","kind":13,"name":"%internal"},{"definition":"my","line":116,"localvar":"my","containerName":"assess_bootstrap","kind":13,"name":"$i"},{"definition":"my","line":117,"name":"$tree","localvar":"my","containerName":"assess_bootstrap","kind":13},{"name":"$guide_tree","kind":13,"containerName":"assess_bootstrap","line":117},{"line":117,"name":"$bs_trees","containerName":"assess_bootstrap","kind":13},{"definition":"my","line":122,"name":"@allnodes","localvar":"my","containerName":"assess_bootstrap","kind":13},{"name":"$tree","containerName":"assess_bootstrap","kind":13,"line":122},{"line":122,"kind":12,"containerName":"assess_bootstrap","name":"get_nodes"},{"line":123,"name":"@internalnodes","localvar":"my","containerName":"assess_bootstrap","kind":13,"definition":"my"},{"line":123,"name":"is_Leaf","kind":12,"containerName":"assess_bootstrap"},{"line":123,"kind":13,"containerName":"assess_bootstrap","name":"@allnodes"},{"definition":"my","name":"$node","containerName":"assess_bootstrap","localvar":"my","kind":13,"line":124},{"name":"@internalnodes","kind":13,"containerName":"assess_bootstrap","line":124},{"line":125,"localvar":"my","containerName":"assess_bootstrap","kind":13,"name":"@tips","definition":"my"},{"line":125,"name":"id","kind":12,"containerName":"assess_bootstrap"},{"line":126,"name":"is_Leaf","kind":12,"containerName":"assess_bootstrap"},{"line":126,"name":"$node","kind":13,"containerName":"assess_bootstrap"},{"line":126,"name":"get_all_Descendents","containerName":"assess_bootstrap","kind":12},{"localvar":"my","kind":13,"containerName":"assess_bootstrap","name":"$id","line":127,"definition":"my"},{"line":127,"name":"@tips","containerName":"assess_bootstrap","kind":13},{"containerName":"assess_bootstrap","kind":13,"name":"$i","line":128},{"line":129,"containerName":"assess_bootstrap","kind":13,"name":"$internal"},{"kind":13,"containerName":"assess_bootstrap","name":"$id","line":129},{"line":129,"name":"$node","kind":13,"containerName":"assess_bootstrap"},{"containerName":"assess_bootstrap","kind":12,"name":"internal_id","line":129},{"name":"$lookup","kind":13,"containerName":"assess_bootstrap","line":131},{"kind":13,"containerName":"assess_bootstrap","name":"$id","line":131},{"line":134,"name":"$i","containerName":"assess_bootstrap","kind":13},{"definition":"my","line":136,"name":"@save","localvar":"my","kind":13,"containerName":"assess_bootstrap"},{"definition":"my","line":137,"name":"$l","kind":13,"localvar":"my","containerName":"assess_bootstrap"},{"name":"%lookup","containerName":"assess_bootstrap","kind":13,"line":137},{"kind":13,"containerName":"assess_bootstrap","name":"$internal","line":138},{"line":138,"name":"$l","containerName":"assess_bootstrap","kind":13},{"line":139,"name":"$intnode","kind":13,"localvar":"my","containerName":"assess_bootstrap","definition":"my"},{"name":"$guide_tree","containerName":"assess_bootstrap","kind":13,"line":139},{"line":139,"containerName":"assess_bootstrap","kind":12,"name":"find_node"},{"name":"$internal","kind":13,"containerName":"assess_bootstrap","line":139},{"line":139,"kind":13,"containerName":"assess_bootstrap","name":"$l"},{"kind":13,"containerName":"assess_bootstrap","name":"$intnode","line":140},{"name":"bootstrap","kind":12,"containerName":"assess_bootstrap","line":140},{"name":"$lookup","containerName":"assess_bootstrap","kind":13,"line":140},{"line":140,"name":"$l","containerName":"assess_bootstrap","kind":13},{"containerName":"assess_bootstrap","kind":13,"name":"$i","line":140},{"line":143,"name":"$guide_tree","kind":13,"containerName":"assess_bootstrap"}],"containerName":"main::","name":"assess_bootstrap","definition":"sub","detail":"($self,$bs_trees,$guide_tree)","line":109,"range":{"end":{"line":144,"character":9999},"start":{"line":109,"character":0}},"kind":12,"signature":{"label":"assess_bootstrap($self,$bs_trees,$guide_tree)","documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Statistics - Calculate certain statistics for a Tree\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::Statistics;\n\n=head1 DESCRIPTION\n\nThis should be where Tree statistics are calculated.  It was\npreviously where statistics from a Coalescent simulation.\n\nIt now contains several methods for calculating L<Tree-Trait\nstatistics>.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason AT bioperl.org\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho, heikki at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::Statistics;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Statistics->new();\n Function: Builds a new Bio::Tree::Statistics object \n Returns : Bio::Tree::Statistics\n Args    :\n\n\n\n\n=head2 assess_bootstrap\n\n Title   : assess_bootstrap\n Usage   : my $tree_with_bs = $stats->assess_bootstrap(\\@bs_trees);\n Function: Calculates the bootstrap for internal nodes based on\n Returns : L<Bio::Tree::TreeI>\n Args    : Arrayref of L<Bio::Tree::TreeI>s","parameters":[{"label":"$self"},{"label":"$bs_trees"},{"label":"$guide_tree"}]}},{"signature":{"label":"cherries($;$)","documentation":"1;\n# $Id: Statistics.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::Statistics\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::Statistics - Calculate certain statistics for a Tree\n\n=head1 SYNOPSIS\n\n  use Bio::Tree::Statistics;\n\n=head1 DESCRIPTION\n\nThis should be where Tree statistics are calculated.  It was\npreviously where statistics from a Coalescent simulation.\n\nIt now contains several methods for calculating L<Tree-Trait\nstatistics>.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason AT bioperl.org\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho, heikki at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tree::Statistics;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::Statistics->new();\n Function: Builds a new Bio::Tree::Statistics object \n Returns : Bio::Tree::Statistics\n Args    :\n\n\n\n\n=head2 assess_bootstrap\n\n Title   : assess_bootstrap\n Usage   : my $tree_with_bs = $stats->assess_bootstrap(\\@bs_trees);\n Function: Calculates the bootstrap for internal nodes based on\n Returns : L<Bio::Tree::TreeI>\n Args    : Arrayref of L<Bio::Tree::TreeI>s\n\n\n\nsub assess_bootstrap{\n   my ($self,$bs_trees,$guide_tree) = @_;\n   my @consensus;\n\n   # internal nodes are defined by their children\n\n   my (%lookup,%internal);\n   my $i = 0;\n   for my $tree ( $guide_tree, @$bs_trees ) {\n       # Do this as a top down approach, can probably be\n       # improved by caching internal node states, but not going\n       # to worry about it right now.\n\n       my @allnodes = $tree->get_nodes;\n       my @internalnodes = grep { ! $_->is_Leaf } @allnodes;\n       for my $node ( @internalnodes ) {\n\t   my @tips = sort map { $_->id } \n\t              grep { $_->is_Leaf() } $node->get_all_Descendents;\n\t   my $id = \"(\".join(\",\", @tips).\")\";\n\t   if( $i == 0 ) {\n\t       $internal{$id} = $node->internal_id;\n\t   } else { \n\t       $lookup{$id}++;\n\t   }\n       }\n       $i++;\n   }\n   my @save;\n   for my $l ( keys %lookup ) {\n       if( defined $internal{$l} ) {#&& $lookup{$l} > $min_seen ) {\n\t   my $intnode = $guide_tree->find_node(-internal_id => $internal{$l});\n\t   $intnode->bootstrap(sprintf(\"%d\",100 * $lookup{$l} / $i));\n       }\n   }\n   return $guide_tree;\n}\n\n\n\n=head2 cherries\n\n  Example    : cherries($tree, $node);\n  Description: Count number of paired leaf nodes\n               in a binary tree\n  Returns    : integer\n  Exceptions : \n  Args       : 1. Bio::Tree::TreeI object\n               2. Bio::Tree::NodeI object within the tree, optional\n\nCommonly used statistics assume a binary tree, but this methods\nreturns a value even for trees with polytomies.","parameters":[{"label":"$;$"}]},"line":163,"range":{"start":{"line":163,"character":0},"end":{"character":9999,"line":184}},"kind":12,"definition":"sub","detail":"($;$)","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"cherries","line":164},{"definition":"my","line":165,"containerName":"cherries","localvar":"my","kind":13,"name":"$tree"},{"definition":"my","localvar":"my","containerName":"cherries","kind":13,"name":"$node","line":166},{"name":"$tree","containerName":"cherries","kind":13,"line":166},{"line":166,"name":"get_root_node","containerName":"cherries","kind":12},{"line":168,"name":"$cherries","containerName":"cherries","localvar":"my","kind":13,"definition":"my"},{"name":"@descs","localvar":"my","containerName":"cherries","kind":13,"line":169,"definition":"my"},{"line":169,"containerName":"cherries","kind":13,"name":"$node"},{"containerName":"cherries","kind":12,"name":"each_Descendent","line":169},{"line":171,"kind":13,"containerName":"cherries","name":"$descs"},{"line":171,"name":"is_Leaf","containerName":"cherries","kind":12},{"line":171,"name":"$descs","containerName":"cherries","kind":13},{"line":171,"name":"is_Leaf","kind":12,"containerName":"cherries"},{"line":172,"name":"$descs","kind":13,"containerName":"cherries"},{"name":"$cherries","containerName":"cherries","kind":13,"line":173},{"line":175,"name":"$cherries","kind":13,"containerName":"cherries"},{"definition":"my","name":"$desc","localvar":"my","kind":13,"containerName":"cherries","line":179},{"containerName":"cherries","kind":13,"name":"@descs","line":179},{"line":180,"name":"$cherries","kind":13,"containerName":"cherries"},{"name":"$self","kind":13,"containerName":"cherries","line":180},{"name":"cherries","kind":12,"containerName":"cherries","line":180},{"line":180,"containerName":"cherries","kind":13,"name":"$tree"},{"name":"$desc","kind":13,"containerName":"cherries","line":180},{"kind":13,"containerName":"cherries","name":"$cherries","line":183}],"name":"cherries","containerName":"main::"},{"kind":12,"range":{"start":{"character":0,"line":231},"end":{"line":239,"character":9999}},"line":231,"definition":"sub","containerName":"main::","name":"fitch","children":[{"localvar":"my","containerName":"fitch","kind":13,"name":"$self","line":232,"definition":"my"},{"definition":"my","line":233,"name":"$tree","containerName":"fitch","localvar":"my","kind":13},{"line":234,"kind":13,"localvar":"my","containerName":"fitch","name":"$key","definition":"my"},{"name":"$self","containerName":"fitch","kind":13,"line":234},{"containerName":"fitch","kind":12,"name":"throw","line":234},{"definition":"my","line":235,"containerName":"fitch","localvar":"my","kind":13,"name":"$node"},{"kind":13,"containerName":"fitch","name":"$tree","line":235},{"name":"get_root_node","kind":12,"containerName":"fitch","line":235},{"name":"$self","containerName":"fitch","kind":13,"line":237},{"name":"fitch_up","kind":12,"containerName":"fitch","line":237},{"line":237,"containerName":"fitch","kind":13,"name":"$tree"},{"line":237,"kind":13,"containerName":"fitch","name":"$key"},{"line":237,"name":"$node","kind":13,"containerName":"fitch"},{"line":238,"name":"$self","kind":13,"containerName":"fitch"},{"name":"fitch_down","kind":12,"containerName":"fitch","line":238},{"containerName":"fitch","kind":13,"name":"$tree","line":238},{"line":238,"name":"$node","containerName":"fitch","kind":13}]},{"line":264,"range":{"end":{"character":9999,"line":264},"start":{"line":264,"character":0}},"kind":12,"definition":"sub","children":[{"name":"fitch_up","kind":12,"containerName":"ps","line":264}],"containerName":"main::","name":"ps"},{"definition":"sub","children":[{"line":288,"kind":13,"localvar":"my","containerName":"fitch_up","name":"$self","definition":"my"},{"definition":"my","line":289,"name":"$tree","containerName":"fitch_up","localvar":"my","kind":13},{"definition":"my","localvar":"my","containerName":"fitch_up","kind":13,"name":"$key","line":290},{"line":290,"containerName":"fitch_up","kind":13,"name":"$self"},{"line":290,"containerName":"fitch_up","kind":12,"name":"throw"},{"definition":"my","line":291,"containerName":"fitch_up","localvar":"my","kind":13,"name":"$node"},{"name":"$tree","containerName":"fitch_up","kind":13,"line":291},{"containerName":"fitch_up","kind":12,"name":"get_root_node","line":291},{"containerName":"fitch_up","kind":13,"name":"$node","line":293},{"name":"is_Leaf","containerName":"fitch_up","kind":12,"line":293},{"line":294,"name":"$self","kind":13,"containerName":"fitch_up"},{"name":"throw","containerName":"fitch_up","kind":12,"line":294},{"name":"$node","containerName":"fitch_up","kind":13,"line":294},{"kind":12,"containerName":"fitch_up","name":"internal_id","line":294},{"line":295,"kind":13,"containerName":"fitch_up","name":"$node"},{"line":295,"name":"has_tag","containerName":"fitch_up","kind":12},{"line":295,"name":"$key","kind":13,"containerName":"fitch_up"},{"kind":13,"containerName":"fitch_up","name":"$node","line":296},{"line":296,"name":"set_tag_value","kind":12,"containerName":"fitch_up"},{"name":"$node","containerName":"fitch_up","kind":13,"line":296},{"kind":12,"containerName":"fitch_up","name":"get_tag_values","line":296},{"name":"$key","containerName":"fitch_up","kind":13,"line":296},{"line":297,"name":"$node","kind":13,"containerName":"fitch_up"},{"line":297,"name":"set_tag_value","containerName":"fitch_up","kind":12},{"localvar":"my","containerName":"fitch_up","kind":13,"name":"$child","line":301,"definition":"my"},{"line":301,"name":"$node","kind":13,"containerName":"fitch_up"},{"name":"each_Descendent","kind":12,"containerName":"fitch_up","line":301},{"name":"$self","containerName":"fitch_up","kind":13,"line":302},{"containerName":"fitch_up","kind":12,"name":"fitch_up","line":302},{"line":302,"name":"$tree","containerName":"fitch_up","kind":13},{"line":302,"kind":13,"containerName":"fitch_up","name":"$key"},{"line":302,"containerName":"fitch_up","kind":13,"name":"$child"},{"definition":"my","name":"%intersection","localvar":"my","kind":13,"containerName":"fitch_up","line":305},{"definition":"my","name":"%union","localvar":"my","kind":13,"containerName":"fitch_up","line":306},{"name":"$score","containerName":"fitch_up","localvar":"my","kind":13,"line":307,"definition":"my"},{"line":309,"localvar":"my","kind":13,"containerName":"fitch_up","name":"$child","definition":"my"},{"kind":13,"containerName":"fitch_up","name":"$node","line":309},{"line":309,"name":"each_Descendent","kind":12,"containerName":"fitch_up"},{"definition":"my","name":"$trait","kind":13,"localvar":"my","containerName":"fitch_up","line":310},{"name":"$child","containerName":"fitch_up","kind":13,"line":310},{"name":"get_tag_values","kind":12,"containerName":"fitch_up","line":310},{"line":311,"name":"$intersection","containerName":"fitch_up","kind":13},{"containerName":"fitch_up","kind":13,"name":"$trait","line":311},{"line":311,"name":"$union","kind":13,"containerName":"fitch_up"},{"line":311,"kind":13,"containerName":"fitch_up","name":"$trait"},{"name":"$union","kind":13,"containerName":"fitch_up","line":312},{"line":312,"containerName":"fitch_up","kind":13,"name":"$trait"},{"kind":13,"containerName":"fitch_up","name":"$score","line":314},{"name":"$child","containerName":"fitch_up","kind":13,"line":314},{"line":314,"name":"get_tag_values","containerName":"fitch_up","kind":12},{"line":317,"name":"%intersection","kind":13,"containerName":"fitch_up"},{"line":318,"containerName":"fitch_up","kind":13,"name":"$node"},{"name":"set_tag_value","kind":12,"containerName":"fitch_up","line":318},{"kind":13,"containerName":"fitch_up","name":"%intersection","line":318},{"line":319,"kind":13,"containerName":"fitch_up","name":"$node"},{"line":319,"name":"set_tag_value","kind":12,"containerName":"fitch_up"},{"line":319,"containerName":"fitch_up","kind":13,"name":"$score"},{"line":321,"name":"$node","kind":13,"containerName":"fitch_up"},{"containerName":"fitch_up","kind":12,"name":"set_tag_value","line":321},{"containerName":"fitch_up","kind":13,"name":"%union","line":321},{"name":"$node","containerName":"fitch_up","kind":13,"line":322},{"containerName":"fitch_up","kind":12,"name":"set_tag_value","line":322},{"containerName":"fitch_up","kind":13,"name":"$score","line":322},{"line":325,"name":"$self","kind":13,"containerName":"fitch_up"},{"name":"verbose","containerName":"fitch_up","kind":12,"line":325},{"containerName":"fitch_up","kind":13,"name":"$node","line":327},{"name":"internal_id","containerName":"fitch_up","kind":12,"line":327},{"name":"$node","containerName":"fitch_up","kind":13,"line":327},{"name":"id","kind":12,"containerName":"fitch_up","line":327},{"containerName":"fitch_up","kind":13,"name":"$node","line":328},{"line":328,"containerName":"fitch_up","kind":12,"name":"get_tag_values"},{"line":329,"name":"$node","kind":13,"containerName":"fitch_up"},{"line":329,"kind":12,"containerName":"fitch_up","name":"get_tag_values"},{"line":331,"containerName":"fitch_up","kind":13,"name":"$node"},{"name":"get_tag_values","kind":12,"containerName":"fitch_up","line":331}],"containerName":"main::","name":"fitch_up","line":287,"range":{"end":{"character":9999,"line":332},"start":{"character":0,"line":287}},"kind":12},{"definition":"sub","containerName":"main::","name":"fitch_down","children":[{"line":356,"localvar":"my","kind":13,"containerName":"fitch_down","name":"$self","definition":"my"},{"definition":"my","localvar":"my","containerName":"fitch_down","kind":13,"name":"$tree","line":357},{"definition":"my","kind":13,"localvar":"my","containerName":"fitch_down","name":"$node","line":358},{"line":358,"containerName":"fitch_down","kind":13,"name":"$tree"},{"line":358,"containerName":"fitch_down","kind":12,"name":"get_root_node"},{"line":360,"containerName":"fitch_down","localvar":"my","kind":13,"name":"$key","definition":"my"},{"name":"$self","containerName":"fitch_down","kind":13,"line":361},{"name":"throw","kind":12,"containerName":"fitch_down","line":361},{"line":361,"name":"$node","containerName":"fitch_down","kind":13},{"line":361,"name":"internal_id","kind":12,"containerName":"fitch_down"},{"name":"$node","containerName":"fitch_down","kind":13,"line":362},{"name":"has_tag","containerName":"fitch_down","kind":12,"line":362},{"line":362,"kind":13,"containerName":"fitch_down","name":"$key"},{"name":"$nodev","localvar":"my","kind":13,"containerName":"fitch_down","line":364,"definition":"my"},{"definition":"my","line":365,"name":"$trait","kind":13,"localvar":"my","containerName":"fitch_down"},{"name":"$node","kind":13,"containerName":"fitch_down","line":365},{"line":365,"name":"get_tag_values","kind":12,"containerName":"fitch_down"},{"name":"$key","containerName":"fitch_down","kind":13,"line":365},{"line":366,"name":"$nodev","kind":13,"containerName":"fitch_down"},{"line":366,"name":"$trait","containerName":"fitch_down","kind":13},{"line":369,"name":"$child","localvar":"my","kind":13,"containerName":"fitch_down","definition":"my"},{"line":369,"name":"$node","containerName":"fitch_down","kind":13},{"containerName":"fitch_down","kind":12,"name":"each_Descendent","line":369},{"name":"$child","containerName":"fitch_down","kind":13,"line":370},{"line":370,"name":"is_Leaf","containerName":"fitch_down","kind":12},{"definition":"my","name":"$intersection","kind":13,"localvar":"my","containerName":"fitch_down","line":372},{"name":"$trait","containerName":"fitch_down","localvar":"my","kind":13,"line":373,"definition":"my"},{"line":373,"kind":13,"containerName":"fitch_down","name":"$child"},{"line":373,"name":"get_tag_values","containerName":"fitch_down","kind":12},{"containerName":"fitch_down","kind":13,"name":"$key","line":373},{"line":374,"name":"$intersection","kind":13,"containerName":"fitch_down"},{"line":374,"containerName":"fitch_down","kind":13,"name":"$trait"},{"line":374,"containerName":"fitch_down","kind":13,"name":"$nodev"},{"name":"$trait","containerName":"fitch_down","kind":13,"line":374},{"line":377,"kind":13,"containerName":"fitch_down","name":"$self"},{"line":377,"name":"fitch_down","containerName":"fitch_down","kind":12},{"kind":13,"containerName":"fitch_down","name":"$tree","line":377},{"containerName":"fitch_down","kind":13,"name":"$child","line":377},{"line":378,"name":"$child","kind":13,"containerName":"fitch_down"},{"name":"set_tag_value","kind":12,"containerName":"fitch_down","line":378},{"name":"$key","kind":13,"containerName":"fitch_down","line":378},{"name":"$intersection","kind":13,"containerName":"fitch_down","line":378}],"range":{"end":{"line":381,"character":9999},"start":{"character":0,"line":355}},"kind":12,"line":355},{"kind":12,"range":{"start":{"line":405,"character":0},"end":{"character":9999,"line":425}},"line":405,"definition":"sub","name":"_persistence","containerName":"main::","children":[{"definition":"my","line":406,"containerName":"_persistence","localvar":"my","kind":13,"name":"$self"},{"definition":"my","localvar":"my","kind":13,"containerName":"_persistence","name":"$tree","line":407},{"definition":"my","name":"$node","localvar":"my","containerName":"_persistence","kind":13,"line":408},{"definition":"my","name":"$value","localvar":"my","kind":13,"containerName":"_persistence","line":409},{"name":"$self","kind":13,"containerName":"_persistence","line":409},{"line":409,"name":"throw","containerName":"_persistence","kind":12},{"name":"$key","localvar":"my","containerName":"_persistence","kind":13,"line":412,"definition":"my"},{"kind":13,"containerName":"_persistence","name":"$self","line":414},{"line":414,"name":"throw","kind":12,"containerName":"_persistence"},{"line":414,"name":"$node","containerName":"_persistence","kind":13},{"line":414,"containerName":"_persistence","kind":12,"name":"isa"},{"name":"$node","containerName":"_persistence","kind":13,"line":416},{"line":416,"name":"get_tag_values","kind":12,"containerName":"_persistence"},{"containerName":"_persistence","kind":13,"name":"$key","line":416},{"line":416,"name":"$value","kind":13,"containerName":"_persistence"},{"line":417,"containerName":"_persistence","kind":13,"name":"$node"},{"name":"is_Leaf","kind":12,"containerName":"_persistence","line":417},{"definition":"my","name":"$persistence","localvar":"my","containerName":"_persistence","kind":13,"line":419},{"name":"$child","kind":13,"localvar":"my","containerName":"_persistence","line":420,"definition":"my"},{"line":420,"name":"$node","kind":13,"containerName":"_persistence"},{"line":420,"containerName":"_persistence","kind":12,"name":"each_Descendent"},{"definition":"my","line":421,"name":"$pers","kind":13,"localvar":"my","containerName":"_persistence"},{"kind":13,"containerName":"_persistence","name":"$self","line":421},{"name":"_persistence","kind":12,"containerName":"_persistence","line":421},{"line":421,"kind":13,"containerName":"_persistence","name":"$tree"},{"line":421,"containerName":"_persistence","kind":13,"name":"$child"},{"line":421,"name":"$value","containerName":"_persistence","kind":13},{"line":422,"name":"$persistence","kind":13,"containerName":"_persistence"},{"line":422,"kind":13,"containerName":"_persistence","name":"$pers"},{"line":422,"name":"$pers","kind":13,"containerName":"_persistence"},{"line":422,"name":"$persistence","kind":13,"containerName":"_persistence"},{"name":"$persistence","containerName":"_persistence","kind":13,"line":424}]},{"definition":"sub","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"persistence","line":428,"definition":"my"},{"name":"$tree","localvar":"my","kind":13,"containerName":"persistence","line":429,"definition":"my"},{"line":430,"name":"$node","localvar":"my","kind":13,"containerName":"persistence","definition":"my"},{"containerName":"persistence","kind":13,"name":"$tree","line":430},{"line":430,"name":"get_root_node","containerName":"persistence","kind":12},{"name":"$self","containerName":"persistence","kind":13,"line":431},{"name":"throw","containerName":"persistence","kind":12,"line":431},{"line":431,"containerName":"persistence","kind":13,"name":"$node"},{"containerName":"persistence","kind":12,"name":"isa","line":431},{"definition":"my","line":433,"localvar":"my","kind":13,"containerName":"persistence","name":"$key"},{"definition":"my","line":434,"name":"$value","containerName":"persistence","localvar":"my","kind":13},{"line":434,"name":"$node","kind":13,"containerName":"persistence"},{"name":"get_tag_values","containerName":"persistence","kind":12,"line":434},{"containerName":"persistence","kind":13,"name":"$key","line":434},{"line":437,"containerName":"persistence","localvar":"my","kind":13,"name":"$persistence","definition":"my"},{"line":437,"kind":13,"containerName":"persistence","name":"$self"},{"line":437,"name":"_persistence","containerName":"persistence","kind":12},{"containerName":"persistence","kind":13,"name":"$tree","line":437},{"containerName":"persistence","kind":13,"name":"$node","line":437},{"name":"$value","kind":13,"containerName":"persistence","line":437},{"containerName":"persistence","kind":13,"name":"$node","line":438},{"line":438,"name":"set_tag_value","kind":12,"containerName":"persistence"},{"kind":13,"containerName":"persistence","name":"$persistence","line":438},{"line":439,"kind":13,"containerName":"persistence","name":"$persistence"}],"name":"persistence","containerName":"main::","line":427,"kind":12,"range":{"end":{"character":9999,"line":440},"start":{"line":427,"character":0}}},{"range":{"start":{"line":458,"character":0},"end":{"line":481,"character":9999}},"kind":12,"line":458,"definition":"sub","name":"_count_subclusters","containerName":"main::","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_count_subclusters","name":"$self","line":459},{"localvar":"my","kind":13,"containerName":"_count_subclusters","name":"$tree","line":460,"definition":"my"},{"definition":"my","line":461,"name":"$node","containerName":"_count_subclusters","localvar":"my","kind":13},{"name":"$value","localvar":"my","kind":13,"containerName":"_count_subclusters","line":462,"definition":"my"},{"line":462,"name":"$self","kind":13,"containerName":"_count_subclusters"},{"line":462,"name":"throw","kind":12,"containerName":"_count_subclusters"},{"definition":"my","line":464,"localvar":"my","containerName":"_count_subclusters","kind":13,"name":"$key"},{"name":"$self","kind":13,"containerName":"_count_subclusters","line":466},{"line":466,"kind":12,"containerName":"_count_subclusters","name":"throw"},{"containerName":"_count_subclusters","kind":13,"name":"$node","line":466},{"name":"internal_id","kind":12,"containerName":"_count_subclusters","line":466},{"line":467,"containerName":"_count_subclusters","kind":13,"name":"$node"},{"line":467,"containerName":"_count_subclusters","kind":12,"name":"has_tag"},{"line":467,"name":"$key","containerName":"_count_subclusters","kind":13},{"containerName":"_count_subclusters","kind":13,"name":"$node","line":469},{"line":469,"kind":12,"containerName":"_count_subclusters","name":"get_tag_values"},{"line":469,"containerName":"_count_subclusters","kind":13,"name":"$key"},{"name":"$value","kind":13,"containerName":"_count_subclusters","line":469},{"line":470,"containerName":"_count_subclusters","kind":13,"name":"$node"},{"name":"get_tag_values","containerName":"_count_subclusters","kind":12,"line":470},{"name":"$count","containerName":"_count_subclusters","localvar":"my","kind":13,"line":473,"definition":"my"},{"name":"$child","containerName":"_count_subclusters","localvar":"my","kind":13,"line":474,"definition":"my"},{"line":474,"name":"$node","containerName":"_count_subclusters","kind":13},{"line":474,"containerName":"_count_subclusters","kind":12,"name":"each_Descendent"},{"name":"$count","kind":13,"containerName":"_count_subclusters","line":475},{"line":475,"name":"$self","kind":13,"containerName":"_count_subclusters"},{"line":475,"containerName":"_count_subclusters","kind":12,"name":"_count_subclusters"},{"line":475,"name":"$tree","containerName":"_count_subclusters","kind":13},{"kind":13,"containerName":"_count_subclusters","name":"$child","line":475},{"line":475,"name":"$value","kind":13,"containerName":"_count_subclusters"},{"containerName":"_count_subclusters","kind":13,"name":"$count","line":477}]},{"definition":"sub","name":"count_subclusters","containerName":"main::","children":[{"definition":"my","line":484,"localvar":"my","kind":13,"containerName":"count_subclusters","name":"$self"},{"line":485,"localvar":"my","containerName":"count_subclusters","kind":13,"name":"$tree","definition":"my"},{"definition":"my","line":486,"localvar":"my","containerName":"count_subclusters","kind":13,"name":"$node"},{"containerName":"count_subclusters","kind":13,"name":"$tree","line":486},{"containerName":"count_subclusters","kind":12,"name":"get_root_node","line":486},{"name":"$self","kind":13,"containerName":"count_subclusters","line":487},{"line":487,"name":"throw","containerName":"count_subclusters","kind":12},{"kind":13,"containerName":"count_subclusters","name":"$node","line":487},{"line":487,"containerName":"count_subclusters","kind":12,"name":"isa"},{"definition":"my","line":489,"name":"$key","kind":13,"localvar":"my","containerName":"count_subclusters"},{"definition":"my","localvar":"my","containerName":"count_subclusters","kind":13,"name":"$value","line":490},{"name":"$node","containerName":"count_subclusters","kind":13,"line":490},{"line":490,"name":"get_tag_values","containerName":"count_subclusters","kind":12},{"line":490,"name":"$key","containerName":"count_subclusters","kind":13},{"name":"$self","containerName":"count_subclusters","kind":13,"line":492},{"name":"_count_subclusters","containerName":"count_subclusters","kind":12,"line":492},{"kind":13,"containerName":"count_subclusters","name":"$tree","line":492},{"line":492,"name":"$node","containerName":"count_subclusters","kind":13},{"name":"$value","kind":13,"containerName":"count_subclusters","line":492}],"kind":12,"range":{"start":{"character":0,"line":483},"end":{"line":493,"character":9999}},"line":483},{"range":{"start":{"character":0,"line":511},"end":{"line":533,"character":9999}},"kind":12,"line":511,"containerName":"main::","name":"_count_leaves","children":[{"definition":"my","containerName":"_count_leaves","localvar":"my","kind":13,"name":"$self","line":512},{"localvar":"my","containerName":"_count_leaves","kind":13,"name":"$tree","line":513,"definition":"my"},{"name":"$node","localvar":"my","kind":13,"containerName":"_count_leaves","line":514,"definition":"my"},{"line":514,"kind":13,"containerName":"_count_leaves","name":"$tree"},{"kind":12,"containerName":"_count_leaves","name":"get_root_node","line":514},{"line":515,"kind":13,"localvar":"my","containerName":"_count_leaves","name":"$value","definition":"my"},{"line":517,"containerName":"_count_leaves","localvar":"my","kind":13,"name":"$key","definition":"my"},{"kind":13,"containerName":"_count_leaves","name":"$self","line":519},{"line":519,"name":"throw","containerName":"_count_leaves","kind":12},{"line":519,"containerName":"_count_leaves","kind":13,"name":"$node"},{"line":519,"containerName":"_count_leaves","kind":12,"name":"internal_id"},{"name":"$node","containerName":"_count_leaves","kind":13,"line":520},{"kind":12,"containerName":"_count_leaves","name":"has_tag","line":520},{"containerName":"_count_leaves","kind":13,"name":"$key","line":520},{"line":522,"name":"$node","kind":13,"containerName":"_count_leaves"},{"line":522,"kind":12,"containerName":"_count_leaves","name":"get_tag_values"},{"line":522,"name":"$key","containerName":"_count_leaves","kind":13},{"line":522,"name":"$value","containerName":"_count_leaves","kind":13},{"line":524,"name":"$node","containerName":"_count_leaves","kind":13},{"line":524,"containerName":"_count_leaves","kind":12,"name":"is_Leaf"},{"line":526,"name":"$count","localvar":"my","containerName":"_count_leaves","kind":13,"definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"_count_leaves","name":"$child","line":527},{"line":527,"name":"$node","kind":13,"containerName":"_count_leaves"},{"kind":12,"containerName":"_count_leaves","name":"each_Descendent","line":527},{"line":528,"name":"$count","containerName":"_count_leaves","kind":13},{"line":528,"name":"$self","kind":13,"containerName":"_count_leaves"},{"line":528,"name":"_count_leaves","kind":12,"containerName":"_count_leaves"},{"containerName":"_count_leaves","kind":13,"name":"$tree","line":528},{"kind":13,"containerName":"_count_leaves","name":"$child","line":528},{"line":528,"containerName":"_count_leaves","kind":13,"name":"$value"},{"line":530,"kind":13,"containerName":"_count_leaves","name":"$count"}],"definition":"sub"},{"definition":"sub","children":[{"line":536,"localvar":"my","kind":13,"containerName":"count_leaves","name":"$self","definition":"my"},{"definition":"my","line":537,"localvar":"my","containerName":"count_leaves","kind":13,"name":"$tree"},{"line":538,"localvar":"my","containerName":"count_leaves","kind":13,"name":"$node","definition":"my"},{"line":538,"name":"$tree","containerName":"count_leaves","kind":13},{"kind":12,"containerName":"count_leaves","name":"get_root_node","line":538},{"line":539,"containerName":"count_leaves","kind":13,"name":"$self"},{"line":539,"name":"throw","kind":12,"containerName":"count_leaves"},{"line":539,"containerName":"count_leaves","kind":13,"name":"$node"},{"line":539,"name":"isa","containerName":"count_leaves","kind":12},{"definition":"my","name":"$key","kind":13,"localvar":"my","containerName":"count_leaves","line":541},{"containerName":"count_leaves","localvar":"my","kind":13,"name":"$value","line":542,"definition":"my"},{"line":542,"name":"$node","containerName":"count_leaves","kind":13},{"containerName":"count_leaves","kind":12,"name":"get_tag_values","line":542},{"line":542,"containerName":"count_leaves","kind":13,"name":"$key"},{"containerName":"count_leaves","kind":13,"name":"$self","line":544},{"line":544,"name":"_count_leaves","containerName":"count_leaves","kind":12},{"name":"$tree","containerName":"count_leaves","kind":13,"line":544},{"line":544,"kind":13,"containerName":"count_leaves","name":"$node"},{"name":"$value","containerName":"count_leaves","kind":13,"line":544}],"containerName":"main::","name":"count_leaves","line":535,"range":{"end":{"character":9999,"line":545},"start":{"line":535,"character":0}},"kind":12},{"name":"_phylotype_length","containerName":"main::","children":[{"localvar":"my","containerName":"_phylotype_length","kind":13,"name":"$self","line":563,"definition":"my"},{"line":564,"containerName":"_phylotype_length","localvar":"my","kind":13,"name":"$tree","definition":"my"},{"definition":"my","line":565,"localvar":"my","kind":13,"containerName":"_phylotype_length","name":"$node"},{"definition":"my","name":"$value","kind":13,"localvar":"my","containerName":"_phylotype_length","line":566},{"line":568,"name":"$key","containerName":"_phylotype_length","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"_phylotype_length","name":"$self","line":570},{"line":570,"containerName":"_phylotype_length","kind":12,"name":"throw"},{"line":570,"kind":13,"containerName":"_phylotype_length","name":"$node"},{"kind":12,"containerName":"_phylotype_length","name":"internal_id","line":570},{"kind":13,"containerName":"_phylotype_length","name":"$node","line":571},{"containerName":"_phylotype_length","kind":12,"name":"has_tag","line":571},{"kind":13,"containerName":"_phylotype_length","name":"$key","line":571},{"containerName":"_phylotype_length","kind":13,"name":"$node","line":573},{"containerName":"_phylotype_length","kind":12,"name":"get_tag_values","line":573},{"line":573,"name":"$key","kind":13,"containerName":"_phylotype_length"},{"containerName":"_phylotype_length","kind":13,"name":"$value","line":573},{"line":574,"name":"$node","kind":13,"containerName":"_phylotype_length"},{"containerName":"_phylotype_length","kind":12,"name":"branch_length","line":574},{"line":574,"name":"$node","containerName":"_phylotype_length","kind":13},{"containerName":"_phylotype_length","kind":12,"name":"is_Leaf","line":574},{"containerName":"_phylotype_length","localvar":"my","kind":13,"name":"$length","line":576,"definition":"my"},{"definition":"my","line":577,"name":"$child","localvar":"my","containerName":"_phylotype_length","kind":13},{"line":577,"name":"$node","containerName":"_phylotype_length","kind":13},{"kind":12,"containerName":"_phylotype_length","name":"each_Descendent","line":577},{"definition":"my","line":578,"localvar":"my","kind":13,"containerName":"_phylotype_length","name":"$sub_len"},{"line":578,"name":"$self","kind":13,"containerName":"_phylotype_length"},{"line":578,"name":"_phylotype_length","containerName":"_phylotype_length","kind":12},{"kind":13,"containerName":"_phylotype_length","name":"$tree","line":578},{"name":"$child","containerName":"_phylotype_length","kind":13,"line":578},{"containerName":"_phylotype_length","kind":13,"name":"$value","line":578},{"name":"$length","containerName":"_phylotype_length","kind":13,"line":579},{"line":579,"kind":13,"containerName":"_phylotype_length","name":"$sub_len"},{"line":580,"name":"$length","kind":13,"containerName":"_phylotype_length"},{"line":580,"kind":13,"containerName":"_phylotype_length","name":"$child"},{"line":580,"name":"branch_length","kind":12,"containerName":"_phylotype_length"},{"name":"$child","kind":13,"containerName":"_phylotype_length","line":580},{"kind":12,"containerName":"_phylotype_length","name":"is_Leaf","line":580},{"line":580,"kind":13,"containerName":"_phylotype_length","name":"$sub_len"},{"line":582,"containerName":"_phylotype_length","kind":13,"name":"$length"}],"definition":"sub","kind":12,"range":{"start":{"character":0,"line":562},"end":{"line":583,"character":9999}},"line":562},{"range":{"end":{"character":9999,"line":595},"start":{"line":586,"character":0}},"kind":12,"line":586,"containerName":"main::","name":"phylotype_length","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"phylotype_length","name":"$self","line":587},{"definition":"my","localvar":"my","containerName":"phylotype_length","kind":13,"name":"$tree","line":588},{"definition":"my","localvar":"my","containerName":"phylotype_length","kind":13,"name":"$node","line":589},{"line":589,"kind":13,"containerName":"phylotype_length","name":"$tree"},{"line":589,"kind":12,"containerName":"phylotype_length","name":"get_root_node"},{"definition":"my","line":591,"containerName":"phylotype_length","localvar":"my","kind":13,"name":"$key"},{"definition":"my","line":592,"name":"$value","containerName":"phylotype_length","localvar":"my","kind":13},{"name":"$node","containerName":"phylotype_length","kind":13,"line":592},{"containerName":"phylotype_length","kind":12,"name":"get_tag_values","line":592},{"line":592,"containerName":"phylotype_length","kind":13,"name":"$key"},{"line":594,"name":"$self","kind":13,"containerName":"phylotype_length"},{"line":594,"name":"_phylotype_length","kind":12,"containerName":"phylotype_length"},{"containerName":"phylotype_length","kind":13,"name":"$tree","line":594},{"line":594,"name":"$node","kind":13,"containerName":"phylotype_length"},{"line":594,"name":"$value","kind":13,"containerName":"phylotype_length"}],"definition":"sub"},{"definition":"sub","children":[{"definition":"my","line":613,"name":"$self","kind":13,"localvar":"my","containerName":"_sum_of_leaf_distances"},{"line":614,"kind":13,"localvar":"my","containerName":"_sum_of_leaf_distances","name":"$tree","definition":"my"},{"definition":"my","line":615,"containerName":"_sum_of_leaf_distances","localvar":"my","kind":13,"name":"$node"},{"definition":"my","name":"$value","kind":13,"localvar":"my","containerName":"_sum_of_leaf_distances","line":616},{"localvar":"my","containerName":"_sum_of_leaf_distances","kind":13,"name":"$key","line":618,"definition":"my"},{"containerName":"_sum_of_leaf_distances","kind":13,"name":"$self","line":620},{"line":620,"name":"throw","kind":12,"containerName":"_sum_of_leaf_distances"},{"name":"$node","containerName":"_sum_of_leaf_distances","kind":13,"line":620},{"name":"internal_id","containerName":"_sum_of_leaf_distances","kind":12,"line":620},{"line":621,"containerName":"_sum_of_leaf_distances","kind":13,"name":"$node"},{"name":"has_tag","kind":12,"containerName":"_sum_of_leaf_distances","line":621},{"name":"$key","kind":13,"containerName":"_sum_of_leaf_distances","line":621},{"line":622,"kind":13,"containerName":"_sum_of_leaf_distances","name":"$node"},{"containerName":"_sum_of_leaf_distances","kind":12,"name":"get_tag_values","line":622},{"name":"$key","kind":13,"containerName":"_sum_of_leaf_distances","line":622},{"kind":13,"containerName":"_sum_of_leaf_distances","name":"$value","line":622},{"line":624,"name":"$node","kind":13,"containerName":"_sum_of_leaf_distances"},{"line":624,"name":"is_Leaf","kind":12,"containerName":"_sum_of_leaf_distances"},{"name":"$length","containerName":"_sum_of_leaf_distances","localvar":"my","kind":13,"line":626,"definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"_sum_of_leaf_distances","name":"$child","line":627},{"name":"$node","kind":13,"containerName":"_sum_of_leaf_distances","line":627},{"containerName":"_sum_of_leaf_distances","kind":12,"name":"each_Descendent","line":627},{"line":628,"name":"$length","kind":13,"containerName":"_sum_of_leaf_distances"},{"line":628,"containerName":"_sum_of_leaf_distances","kind":13,"name":"$self"},{"line":628,"kind":12,"containerName":"_sum_of_leaf_distances","name":"_count_leaves"},{"name":"$tree","kind":13,"containerName":"_sum_of_leaf_distances","line":628},{"containerName":"_sum_of_leaf_distances","kind":13,"name":"$child","line":628},{"line":628,"name":"$value","containerName":"_sum_of_leaf_distances","kind":13},{"name":"$child","containerName":"_sum_of_leaf_distances","kind":13,"line":628},{"line":628,"name":"branch_length","containerName":"_sum_of_leaf_distances","kind":12},{"line":629,"name":"$self","kind":13,"containerName":"_sum_of_leaf_distances"},{"line":629,"kind":12,"containerName":"_sum_of_leaf_distances","name":"_sum_of_leaf_distances"},{"kind":13,"containerName":"_sum_of_leaf_distances","name":"$tree","line":629},{"containerName":"_sum_of_leaf_distances","kind":13,"name":"$child","line":629},{"line":629,"name":"$value","kind":13,"containerName":"_sum_of_leaf_distances"},{"line":631,"name":"$length","kind":13,"containerName":"_sum_of_leaf_distances"}],"name":"_sum_of_leaf_distances","containerName":"main::","line":612,"range":{"start":{"line":612,"character":0},"end":{"line":632,"character":9999}},"kind":12},{"children":[{"definition":"my","line":635,"localvar":"my","containerName":"sum_of_leaf_distances","kind":13,"name":"$self"},{"containerName":"sum_of_leaf_distances","localvar":"my","kind":13,"name":"$tree","line":636,"definition":"my"},{"definition":"my","name":"$node","localvar":"my","kind":13,"containerName":"sum_of_leaf_distances","line":637},{"containerName":"sum_of_leaf_distances","kind":13,"name":"$tree","line":637},{"name":"get_root_node","kind":12,"containerName":"sum_of_leaf_distances","line":637},{"kind":13,"localvar":"my","containerName":"sum_of_leaf_distances","name":"$key","line":639,"definition":"my"},{"line":640,"containerName":"sum_of_leaf_distances","localvar":"my","kind":13,"name":"$value","definition":"my"},{"line":640,"name":"$node","containerName":"sum_of_leaf_distances","kind":13},{"line":640,"kind":12,"containerName":"sum_of_leaf_distances","name":"get_tag_values"},{"name":"$key","containerName":"sum_of_leaf_distances","kind":13,"line":640},{"name":"$self","kind":13,"containerName":"sum_of_leaf_distances","line":642},{"line":642,"kind":12,"containerName":"sum_of_leaf_distances","name":"_sum_of_leaf_distances"},{"kind":13,"containerName":"sum_of_leaf_distances","name":"$tree","line":642},{"line":642,"kind":13,"containerName":"sum_of_leaf_distances","name":"$node"},{"line":642,"name":"$value","kind":13,"containerName":"sum_of_leaf_distances"}],"containerName":"main::","name":"sum_of_leaf_distances","definition":"sub","line":634,"range":{"start":{"line":634,"character":0},"end":{"line":643,"character":9999}},"kind":12},{"definition":"sub","name":"genetic_diversity","containerName":"main::","children":[{"containerName":"genetic_diversity","localvar":"my","kind":13,"name":"$self","line":661,"definition":"my"},{"definition":"my","localvar":"my","containerName":"genetic_diversity","kind":13,"name":"$tree","line":662},{"definition":"my","containerName":"genetic_diversity","localvar":"my","kind":13,"name":"$node","line":663},{"name":"$tree","containerName":"genetic_diversity","kind":13,"line":663},{"line":663,"name":"get_root_node","kind":12,"containerName":"genetic_diversity"},{"line":665,"name":"$self","containerName":"genetic_diversity","kind":13},{"line":665,"kind":12,"containerName":"genetic_diversity","name":"sum_of_leaf_distances"},{"line":665,"name":"$tree","kind":13,"containerName":"genetic_diversity"},{"line":665,"name":"$node","containerName":"genetic_diversity","kind":13},{"name":"$self","kind":13,"containerName":"genetic_diversity","line":666},{"containerName":"genetic_diversity","kind":12,"name":"count_leaves","line":666},{"kind":13,"containerName":"genetic_diversity","name":"$tree","line":666},{"line":666,"name":"$node","containerName":"genetic_diversity","kind":13}],"range":{"start":{"line":660,"character":0},"end":{"line":667,"character":9999}},"kind":12,"line":660},{"definition":"sub","containerName":"main::","name":"statratio","children":[{"line":687,"localvar":"my","kind":13,"containerName":"statratio","name":"$self","definition":"my"},{"definition":"my","line":688,"name":"$tree","localvar":"my","kind":13,"containerName":"statratio"},{"line":689,"name":"$node","localvar":"my","containerName":"statratio","kind":13,"definition":"my"},{"line":689,"containerName":"statratio","kind":13,"name":"$tree"},{"name":"get_root_node","kind":12,"containerName":"statratio","line":689},{"line":691,"name":"$div","kind":13,"localvar":"my","containerName":"statratio","definition":"my"},{"line":691,"name":"$self","kind":13,"containerName":"statratio"},{"name":"genetic_diversity","kind":12,"containerName":"statratio","line":691},{"name":"$tree","containerName":"statratio","kind":13,"line":691},{"containerName":"statratio","kind":13,"name":"$node","line":691},{"line":692,"name":"$div","containerName":"statratio","kind":13},{"kind":13,"containerName":"statratio","name":"$node","line":693},{"containerName":"statratio","kind":12,"name":"branch_length","line":693},{"name":"$div","kind":13,"containerName":"statratio","line":693}],"range":{"end":{"character":9999,"line":695},"start":{"line":686,"character":0}},"kind":12,"line":686},{"line":720,"kind":12,"range":{"end":{"character":9999,"line":740},"start":{"line":720,"character":0}},"definition":"sub","children":[{"line":721,"localvar":"my","kind":13,"containerName":"_node_ai","name":"$self","definition":"my"},{"definition":"my","line":722,"name":"$node","localvar":"my","containerName":"_node_ai","kind":13},{"line":723,"containerName":"_node_ai","localvar":"my","kind":13,"name":"$key","definition":"my"},{"line":725,"containerName":"_node_ai","localvar":"my","kind":13,"name":"$traits","definition":"my"},{"definition":"my","line":726,"localvar":"my","containerName":"_node_ai","kind":13,"name":"$leaf_count"},{"line":727,"localvar":"my","containerName":"_node_ai","kind":13,"name":"$desc","definition":"my"},{"name":"$node","kind":13,"containerName":"_node_ai","line":727},{"line":727,"containerName":"_node_ai","kind":12,"name":"get_all_Descendents"},{"name":"$desc","containerName":"_node_ai","kind":13,"line":728},{"containerName":"_node_ai","kind":12,"name":"is_Leaf","line":728},{"containerName":"_node_ai","kind":13,"name":"$leaf_count","line":729},{"containerName":"_node_ai","kind":13,"name":"$self","line":730},{"name":"throw","kind":12,"containerName":"_node_ai","line":730},{"kind":13,"containerName":"_node_ai","name":"$desc","line":730},{"line":730,"name":"id","kind":12,"containerName":"_node_ai"},{"kind":13,"containerName":"_node_ai","name":"$desc","line":731},{"name":"has_tag","containerName":"_node_ai","kind":12,"line":731},{"line":731,"kind":13,"containerName":"_node_ai","name":"$key"},{"definition":"my","line":732,"containerName":"_node_ai","localvar":"my","kind":13,"name":"$trait"},{"line":732,"kind":13,"containerName":"_node_ai","name":"$desc"},{"line":732,"containerName":"_node_ai","kind":12,"name":"get_tag_values"},{"kind":13,"containerName":"_node_ai","name":"$key","line":732},{"kind":13,"containerName":"_node_ai","name":"$traits","line":733},{"line":733,"name":"$trait","kind":13,"containerName":"_node_ai"},{"line":735,"localvar":"my","kind":13,"containerName":"_node_ai","name":"$most_common","definition":"my"},{"name":"$traits","kind":13,"containerName":"_node_ai","line":736},{"line":737,"kind":13,"containerName":"_node_ai","name":"$most_common"},{"line":737,"kind":13,"containerName":"_node_ai","name":"$traits"},{"name":"$traits","containerName":"_node_ai","kind":13,"line":737},{"kind":13,"containerName":"_node_ai","name":"$most_common","line":737},{"kind":13,"containerName":"_node_ai","name":"$most_common","line":739},{"kind":13,"containerName":"_node_ai","name":"$leaf_count","line":739},{"line":739,"name":"$leaf_count","kind":13,"containerName":"_node_ai"}],"containerName":"main::","name":"_node_ai"},{"line":742,"kind":12,"range":{"end":{"line":755,"character":9999},"start":{"character":0,"line":742}},"children":[{"containerName":"ai","localvar":"my","kind":13,"name":"$self","line":743,"definition":"my"},{"line":744,"name":"$tree","kind":13,"localvar":"my","containerName":"ai","definition":"my"},{"line":745,"localvar":"my","kind":13,"containerName":"ai","name":"$key","definition":"my"},{"line":745,"name":"$self","kind":13,"containerName":"ai"},{"name":"throw","kind":12,"containerName":"ai","line":745},{"definition":"my","kind":13,"localvar":"my","containerName":"ai","name":"$start_node","line":746},{"line":746,"name":"$tree","containerName":"ai","kind":13},{"line":746,"name":"get_root_node","kind":12,"containerName":"ai"},{"containerName":"ai","kind":13,"name":"$start_node","line":747},{"line":749,"localvar":"my","containerName":"ai","kind":13,"name":"$sum","definition":"my"},{"name":"$node","kind":13,"localvar":"my","containerName":"ai","line":750,"definition":"my"},{"kind":13,"containerName":"ai","name":"$start_node","line":750},{"line":750,"name":"get_all_Descendents","kind":12,"containerName":"ai"},{"name":"$node","containerName":"ai","kind":13,"line":751},{"line":751,"name":"is_Leaf","containerName":"ai","kind":12},{"name":"$sum","containerName":"ai","kind":13,"line":752},{"name":"$self","containerName":"ai","kind":13,"line":752},{"name":"_node_ai","kind":12,"containerName":"ai","line":752},{"name":"$node","containerName":"ai","kind":13,"line":752},{"name":"$key","kind":13,"containerName":"ai","line":752},{"name":"$sum","containerName":"ai","kind":13,"line":754}],"containerName":"main::","name":"ai","definition":"sub"},{"range":{"start":{"line":790,"character":0},"end":{"character":9999,"line":804}},"kind":12,"line":790,"containerName":"main::","name":"_node_mc","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_node_mc","line":791},{"definition":"my","name":"$node","localvar":"my","containerName":"_node_mc","kind":13,"line":792},{"localvar":"my","kind":13,"containerName":"_node_mc","name":"$key","line":793,"definition":"my"},{"line":795,"localvar":"my","kind":13,"containerName":"_node_mc","name":"$traits","definition":"my"},{"definition":"my","containerName":"_node_mc","localvar":"my","kind":13,"name":"$leaf_count","line":796},{"definition":"my","line":797,"kind":13,"localvar":"my","containerName":"_node_mc","name":"$node2"},{"kind":13,"containerName":"_node_mc","name":"$node","line":797},{"line":797,"kind":12,"containerName":"_node_mc","name":"get_all_Descendents"},{"containerName":"_node_mc","kind":13,"name":"$node2","line":798},{"line":798,"name":"is_Leaf","kind":12,"containerName":"_node_mc"},{"name":"$leaf_count","containerName":"_node_mc","kind":13,"line":799},{"name":"$trait","kind":13,"localvar":"my","containerName":"_node_mc","line":800,"definition":"my"},{"containerName":"_node_mc","kind":13,"name":"$node2","line":800},{"line":800,"name":"get_tag_values","containerName":"_node_mc","kind":12},{"name":"$key","kind":13,"containerName":"_node_mc","line":800},{"kind":13,"containerName":"_node_mc","name":"$traits","line":801},{"name":"$trait","containerName":"_node_mc","kind":13,"line":801},{"line":803,"name":"$traits","kind":13,"containerName":"_node_mc"}],"definition":"sub"},{"definition":"sub","children":[{"name":"$self","localvar":"my","containerName":"mc","kind":13,"line":808,"definition":"my"},{"definition":"my","name":"$tree","localvar":"my","containerName":"mc","kind":13,"line":809},{"line":810,"name":"$key","localvar":"my","kind":13,"containerName":"mc","definition":"my"},{"definition":"my","line":811,"containerName":"mc","localvar":"my","kind":13,"name":"$start_node"},{"line":811,"containerName":"mc","kind":13,"name":"$tree"},{"name":"get_root_node","containerName":"mc","kind":12,"line":811},{"line":812,"kind":13,"containerName":"mc","name":"$start_node"},{"definition":"my","localvar":"my","containerName":"mc","kind":13,"name":"$sum","line":814},{"definition":"my","localvar":"my","containerName":"mc","kind":13,"name":"$keys","line":815},{"definition":"my","localvar":"my","kind":13,"containerName":"mc","name":"$node","line":816},{"line":816,"name":"$start_node","containerName":"mc","kind":13},{"line":816,"kind":12,"containerName":"mc","name":"get_all_Descendents"},{"line":817,"name":"$node","kind":13,"containerName":"mc"},{"name":"is_Leaf","containerName":"mc","kind":12,"line":817},{"definition":"my","line":818,"localvar":"my","kind":13,"containerName":"mc","name":"$traits"},{"line":818,"containerName":"mc","kind":13,"name":"$self"},{"name":"_node_mc","kind":12,"containerName":"mc","line":818},{"kind":13,"containerName":"mc","name":"$node","line":818},{"line":818,"kind":13,"containerName":"mc","name":"$key"},{"line":819,"name":"$traits","containerName":"mc","kind":13},{"line":820,"localvar":"my","kind":13,"containerName":"mc","name":"$value","definition":"my"},{"line":820,"name":"$traits","containerName":"mc","kind":13},{"line":821,"kind":13,"containerName":"mc","name":"$warnings"},{"line":822,"kind":13,"containerName":"mc","name":"$sum"},{"line":822,"name":"$value","containerName":"mc","kind":13},{"name":"$traits","containerName":"mc","kind":13,"line":822},{"line":822,"containerName":"mc","kind":13,"name":"$value"},{"line":823,"name":"$sum","kind":13,"containerName":"mc"},{"line":823,"name":"$value","containerName":"mc","kind":13},{"name":"$traits","kind":13,"containerName":"mc","line":823},{"kind":13,"containerName":"mc","name":"$value","line":823},{"line":825,"name":"$keys","containerName":"mc","kind":13},{"name":"$traits","kind":13,"containerName":"mc","line":825},{"name":"$value","kind":13,"localvar":"my","containerName":"mc","line":829,"definition":"my"},{"containerName":"mc","kind":13,"name":"$sum","line":830},{"containerName":"mc","kind":13,"name":"$value","line":830},{"name":"$sum","containerName":"mc","kind":13,"line":830},{"containerName":"mc","kind":13,"name":"$value","line":830},{"kind":13,"containerName":"mc","name":"$sum","line":832}],"name":"mc","containerName":"main::","line":807,"kind":12,"range":{"end":{"character":9999,"line":833},"start":{"line":807,"character":0}}}]}