{"vars":[{"containerName":"","kind":2,"name":"base","line":91},{"line":109,"kind":12,"range":{"end":{"character":9999,"line":116},"start":{"line":109,"character":0}},"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: NodeNHX.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeNHX\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey <amackey@virginia.edu>\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeNHX - A Simple Tree Node with support for NHX tags\n\n=head1 SYNOPSIS\n\n    use Bio::Tree::NodeNHX;\n    my $nodeA = Bio::Tree::NodeNHX->new();\n    my $nodeL = Bio::Tree::NodeNHX->new();\n    my $nodeR = Bio::Tree::NodeNHX->new();\n\n    my $node = Bio::Tree::NodeNHX->new();\n    $node->add_Descendents($nodeL);\n    $node->add_Descendents($nodeR);\n\n    print \"node is not a leaf \\n\" if( $node->is_leaf);\n\n=head1 DESCRIPTION\n\nMakes a Tree Node with NHX tags, suitable for building a Tree.  See\nL<Bio::Tree::Node> for a full list of functionality.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey\n\nEmail amackey@virginia.edu\n\n=head1 CONTRIBUTORS\n\nThe NHX (New Hampshire eXtended) format was created by Chris Zmasek,\nand is described at:\n\n  http://sourceforge.net/projects/forester-atv/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeNHX;\nuse strict;\n\n\nuse base qw(Bio::Tree::Node);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::NodeNHX->new();\n Function: Builds a new Bio::Tree::NodeNHX object\n Returns : Bio::Tree::NodeNHX\n Args    : -left          => pointer to Left descendent (optional)\n           -right         => pointer to Right descenent (optional)\n\t   -branch_length => branch length [integer] (optional)\n           -bootstrap     => bootstrap value (string)\n           -description   => description of node\n           -id            => unique id for node\n           -nhx           => hashref of NHX tags and values","label":"new($class,@args)"},"children":[{"definition":"my","line":110,"name":"$class","localvar":"my","kind":13,"containerName":"new"},{"line":110,"name":"@args","kind":13,"containerName":"new"},{"definition":"my","line":112,"kind":13,"localvar":"my","containerName":"new","name":"$self"},{"line":112,"containerName":"new","kind":13,"name":"$class"},{"line":112,"kind":13,"containerName":"new","name":"@args"},{"localvar":"my","containerName":"new","kind":13,"name":"$nhx","line":113,"definition":"my"},{"line":113,"kind":13,"containerName":"new","name":"$self"},{"name":"_rearrange","kind":12,"containerName":"new","line":113},{"name":"@args","containerName":"new","kind":13,"line":113},{"line":114,"kind":13,"containerName":"new","name":"$self"},{"name":"nhx_tag","containerName":"new","kind":12,"line":114},{"name":"$nhx","containerName":"new","kind":13,"line":114},{"name":"$self","containerName":"new","kind":13,"line":115}],"containerName":"main::","name":"new","definition":"sub","detail":"($class,@args)"},{"name":"SUPER","kind":12,"containerName":"new","line":112},{"line":118,"range":{"start":{"line":118,"character":0},"end":{"line":130,"character":9999}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"DESTROY($self)"},"children":[{"line":119,"name":"$self","containerName":"DESTROY","localvar":"my","kind":13,"definition":"my"},{"containerName":"DESTROY","kind":13,"name":"$self","line":121},{"name":"$self","containerName":"DESTROY","kind":13,"line":122},{"name":"$self","containerName":"DESTROY","kind":13,"line":123},{"definition":"my","localvar":"my","kind":13,"containerName":"DESTROY","name":"$nodeid","line":124},{"containerName":"DESTROY","kind":13,"name":"$node","line":124},{"containerName":"DESTROY","kind":13,"name":"$self","line":124},{"containerName":"DESTROY","kind":13,"name":"$node","line":125},{"line":126,"containerName":"DESTROY","kind":13,"name":"$node"},{"containerName":"DESTROY","kind":12,"name":"DESTROY","line":126},{"name":"$node","kind":13,"containerName":"DESTROY","line":127},{"containerName":"DESTROY","kind":13,"name":"$self","line":129}],"containerName":"main::","name":"DESTROY","definition":"sub","detail":"($self)"},{"line":121,"name":"SUPER","containerName":"DESTROY","kind":12},{"children":[{"containerName":"to_string","localvar":"my","kind":13,"name":"$self","line":134,"definition":"my"},{"line":135,"name":"@tags","localvar":"my","containerName":"to_string","kind":13,"definition":"my"},{"line":135,"kind":13,"containerName":"to_string","name":"$self"},{"kind":12,"containerName":"to_string","name":"get_all_tags","line":135},{"line":136,"name":"$tagstr","localvar":"my","containerName":"to_string","kind":13,"definition":"my"},{"line":137,"containerName":"to_string","kind":13,"name":"@tags"},{"kind":13,"containerName":"to_string","name":"$tagstr","line":138},{"line":140,"kind":13,"containerName":"to_string","name":"$self"},{"line":140,"kind":12,"containerName":"to_string","name":"get_tag_values"},{"name":"@tags","kind":13,"containerName":"to_string","line":141},{"line":144,"kind":13,"containerName":"to_string","name":"$self"},{"containerName":"to_string","kind":12,"name":"id","line":144},{"name":"$self","kind":13,"containerName":"to_string","line":144},{"line":144,"containerName":"to_string","kind":12,"name":"id"},{"name":"$self","containerName":"to_string","kind":13,"line":145},{"line":145,"name":"branch_length","kind":12,"containerName":"to_string"},{"line":146,"containerName":"to_string","kind":13,"name":"$self"},{"line":146,"kind":12,"containerName":"to_string","name":"branch_length"},{"name":"$tagstr","kind":13,"containerName":"to_string","line":147}],"name":"to_string","containerName":"main::","definition":"sub","detail":"($self)","line":133,"kind":12,"range":{"end":{"line":148,"character":9999},"start":{"line":133,"character":0}},"signature":{"label":"to_string($self)","parameters":[{"label":"$self"}],"documentation":""}},{"line":163,"range":{"end":{"line":183,"character":9999},"start":{"character":0,"line":163}},"kind":12,"signature":{"label":"nhx_tag($self,$tags)","documentation":"1;\n# $Id: NodeNHX.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tree::NodeNHX\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey <amackey@virginia.edu>\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tree::NodeNHX - A Simple Tree Node with support for NHX tags\n\n=head1 SYNOPSIS\n\n    use Bio::Tree::NodeNHX;\n    my $nodeA = Bio::Tree::NodeNHX->new();\n    my $nodeL = Bio::Tree::NodeNHX->new();\n    my $nodeR = Bio::Tree::NodeNHX->new();\n\n    my $node = Bio::Tree::NodeNHX->new();\n    $node->add_Descendents($nodeL);\n    $node->add_Descendents($nodeR);\n\n    print \"node is not a leaf \\n\" if( $node->is_leaf);\n\n=head1 DESCRIPTION\n\nMakes a Tree Node with NHX tags, suitable for building a Tree.  See\nL<Bio::Tree::Node> for a full list of functionality.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey\n\nEmail amackey@virginia.edu\n\n=head1 CONTRIBUTORS\n\nThe NHX (New Hampshire eXtended) format was created by Chris Zmasek,\nand is described at:\n\n  http://sourceforge.net/projects/forester-atv/\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tree::NodeNHX;\nuse strict;\n\n\nuse base qw(Bio::Tree::Node);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tree::NodeNHX->new();\n Function: Builds a new Bio::Tree::NodeNHX object\n Returns : Bio::Tree::NodeNHX\n Args    : -left          => pointer to Left descendent (optional)\n           -right         => pointer to Right descenent (optional)\n\t   -branch_length => branch length [integer] (optional)\n           -bootstrap     => bootstrap value (string)\n           -description   => description of node\n           -id            => unique id for node\n           -nhx           => hashref of NHX tags and values\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($nhx) = $self->_rearrange([qw(NHX)], @args);\n  $self->nhx_tag($nhx);\n  return $self;\n}\n\nsub DESTROY {\n    my ($self) = @_;\n    # try to insure that everything is cleaned up\n    $self->SUPER::DESTROY();\n    if( defined $self->{'_desc'} &&\n\tref($self->{'_desc'}) =~ /ARRAY/i ) {\n\twhile( my ($nodeid,$node) = each %{ $self->{'_desc'} } ) {\n\t    $node->{'_ancestor'} = undef; # insure no circular references\n\t    $node->DESTROY();\n\t    $node = undef;\n\t}\n\t$self->{'_desc'} = {};\n    }\n}\n\nsub to_string{\n   my ($self) = @_;\n   my @tags = $self->get_all_tags;\n   my $tagstr = '';\n   if( @tags ) {\n       $tagstr = '[' . join(\":\", \"&&NHX\", \n\t\t\t    map { \"$_=\" .join(',',\n\t\t\t\t\t      $self->get_tag_values($_))}\n\t\t\t    @tags ) . ']';\n   }\n   return sprintf(\"%s%s%s\",\n\t\t  defined $self->id ? $self->id : '',\n\t\t  defined $self->branch_length ? ':' . \n\t\t  $self->branch_length : ' ',\n\t\t  $tagstr);\n}\n\n=head2 nhx_tag\n\n Title   : nhx_tag\n Usage   : my $tag = $nodenhx->nhx_tag(%tags);\n Function: Set tag-value pairs for NHX nodes\n Returns : none\n Args    : hashref to update the tags/value pairs\n           OR \n           with a scalar value update the bootstrap value by default","parameters":[{"label":"$self"},{"label":"$tags"}]},"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"nhx_tag","line":164},{"line":164,"containerName":"nhx_tag","kind":13,"name":"$tags"},{"line":165,"containerName":"nhx_tag","kind":13,"name":"$tags"},{"containerName":"nhx_tag","kind":13,"name":"$tags","line":165},{"kind":13,"localvar":"my","containerName":"nhx_tag","name":"$tag","line":166,"definition":"my"},{"kind":13,"containerName":"nhx_tag","name":"$val","line":166},{"name":"$tags","kind":13,"containerName":"nhx_tag","line":166},{"line":167,"kind":13,"containerName":"nhx_tag","name":"$val"},{"localvar":"my","containerName":"nhx_tag","kind":13,"name":"$v","line":168,"definition":"my"},{"line":168,"name":"$val","kind":13,"containerName":"nhx_tag"},{"name":"$self","containerName":"nhx_tag","kind":13,"line":169},{"line":169,"containerName":"nhx_tag","kind":12,"name":"add_tag_value"},{"line":169,"containerName":"nhx_tag","kind":13,"name":"$tag"},{"name":"$v","kind":13,"containerName":"nhx_tag","line":169},{"line":172,"containerName":"nhx_tag","kind":13,"name":"$self"},{"kind":12,"containerName":"nhx_tag","name":"add_tag_value","line":172},{"line":172,"name":"$tag","kind":13,"containerName":"nhx_tag"},{"line":172,"name":"$val","kind":13,"containerName":"nhx_tag"},{"name":"$tags","containerName":"nhx_tag","kind":13,"line":175},{"line":176,"containerName":"nhx_tag","kind":13,"name":"$self"},{"containerName":"nhx_tag","kind":12,"name":"bootstrap","line":176},{"containerName":"nhx_tag","kind":13,"name":"$tags","line":176},{"kind":13,"containerName":"nhx_tag","name":"$tags","line":178},{"line":178,"name":"$tags","kind":13,"containerName":"nhx_tag"},{"line":179,"kind":13,"containerName":"nhx_tag","name":"$self"},{"name":"debug","containerName":"nhx_tag","kind":12,"line":179},{"line":181,"kind":13,"containerName":"nhx_tag","name":"$self"},{"kind":12,"containerName":"nhx_tag","name":"bootstrap","line":181},{"containerName":"nhx_tag","kind":13,"name":"$tags","line":181}],"containerName":"main::","name":"nhx_tag","definition":"sub","detail":"($self,$tags)"}],"version":5}