{"vars":[{"kind":2,"containerName":"","name":"base","line":101},{"line":133,"kind":12,"range":{"start":{"line":133,"character":0},"end":{"character":9999,"line":167}},"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: ipcress.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ipcress\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# Copyright Sheldon McKay\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::ipcress - Parse ipcress output and make features\n\n=head1 SYNOPSIS\n\n    # A simple annotation pipeline wrapper for ipcress data\n    # assuming ipcress data is already generated in file seq1.ipcress\n    # and sequence data is in fasta format in file called seq1.fa\n\n    use Bio::Tools::ipcress;\n    use Bio::SeqIO;\n    my $parser = Bio::Tools::ipcress->new(-file => 'seq1.ipcress');\n    my $seqio = Bio::SeqIO->new(-format => 'fasta', -file => 'seq1.fa');\n    my $seq = $seqio->next_seq || die(\"cannot get a seq object from SeqIO\");\n\n    while( my $feat = $parser->next_feature ) {\n\t# add ipcress annotation to a sequence\n\t$seq->add_SeqFeature($feat);\n    }\n    my $seqout = Bio::SeqIO->new(-format => 'embl');\n    $seqout->write_seq($seq);\n\n\n=head1 DESCRIPTION\n\nThis object serves as a parser for ipcress data, creating a\nBio::SeqFeatureI for each ipcress hit.  These can be processed or added\nas annotation to an existing Bio::SeqI object for the purposes of\nautomated annotation.\n\nThis module is adapted from the Bio::Tools::EPCR module\nwritten by Jason Stajich (jason-at-bioperl.org).\n\nIpcress is available through Guy Slater's Exonerate package \nhttp://www.ebi.ac.uk/~guy/exonerate/\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::ipcress;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $ipcress = Bio::Tools::ipcress->new(-file => $file,\n\t\t\t\t\t   -primary => $fprimary, \n\t\t\t\t\t   -source => $fsource, \n\t\t\t\t\t   -groupclass => $fgroupclass);\n Function: Initializes a new ipcress parser\n Returns : Bio::Tools::ipcress\n Args    : -fh   => filehandle\n           OR\n           -file => filename\n\n           -primary => a string to be used as the common value for\n                       each features '-primary' tag.  Defaults to\n                       the sequence ontology term 'PCR_product'.\n                       (This in turn maps to the GFF 'type'\n                       tag (aka 'method')).\n\n            -source => a string to be used as the common value for\n                       each features '-source' tag.  Defaults to\n                       'ipcress'. (This in turn maps to the GFF 'source'\n                       tag)\n\n             -groupclass => a string to be used as the name of the tag\n                           which will hold the sts marker namefirst\n                           attribute.  Defaults to 'name'.","label":"new($class,@args)"},"children":[{"definition":"my","localvar":"my","kind":13,"containerName":"new","name":"$class","line":134},{"containerName":"new","kind":13,"name":"@args","line":134},{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"new","line":136},{"name":"$class","containerName":"new","kind":13,"line":136},{"line":136,"name":"@args","containerName":"new","kind":13},{"definition":"my","name":"$primary","containerName":"new","localvar":"my","kind":13,"line":137},{"name":"$source","containerName":"new","kind":13,"line":137},{"name":"$groupclass","kind":13,"containerName":"new","line":138},{"line":138,"name":"$file","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$fh","line":138},{"line":138,"name":"$self","kind":13,"containerName":"new"},{"name":"_rearrange","kind":12,"containerName":"new","line":138},{"name":"@args","kind":13,"containerName":"new","line":141},{"line":142,"kind":13,"containerName":"new","name":"$self"},{"name":"primary","kind":12,"containerName":"new","line":142},{"kind":13,"containerName":"new","name":"$primary","line":142},{"line":142,"containerName":"new","kind":13,"name":"$primary"},{"name":"$self","containerName":"new","kind":13,"line":143},{"name":"source","containerName":"new","kind":12,"line":143},{"line":143,"name":"$source","containerName":"new","kind":13},{"name":"$source","kind":13,"containerName":"new","line":143},{"name":"$self","containerName":"new","kind":13,"line":144},{"line":144,"name":"groupclass","containerName":"new","kind":12},{"line":144,"name":"$groupclass","kind":13,"containerName":"new"},{"name":"$groupclass","containerName":"new","kind":13,"line":144},{"definition":"my","localvar":"my","containerName":"new","kind":13,"name":"@result","line":147},{"line":149,"name":"$file","containerName":"new","kind":13},{"line":150,"containerName":"new","kind":13,"name":"$file"},{"name":"@result","containerName":"new","kind":13,"line":151},{"kind":13,"containerName":"new","name":"$fh","line":154},{"containerName":"new","kind":13,"name":"@result","line":155},{"line":155,"name":"$fh","kind":13,"containerName":"new"},{"line":158,"name":"$self","kind":13,"containerName":"new"},{"line":158,"containerName":"new","kind":12,"name":"throw"},{"kind":13,"containerName":"new","name":"@result","line":162},{"containerName":"new","kind":13,"name":"$self","line":164},{"kind":13,"containerName":"new","name":"@result","line":164},{"line":166,"kind":13,"containerName":"new","name":"$self"}],"containerName":"main::","name":"new","definition":"sub","detail":"($class,@args)"},{"line":136,"name":"SUPER","containerName":"new","kind":12},{"line":150,"kind":12,"name":"FH"},{"line":151,"name":"FH","kind":12},{"line":152,"kind":12,"name":"FH"},{"kind":12,"name":"result","line":164},{"line":182,"range":{"start":{"character":0,"line":182},"end":{"line":184,"character":9999}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: ipcress.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ipcress\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sheldon McKay <mckays@cshl.edu>\n#\n# Copyright Sheldon McKay\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::ipcress - Parse ipcress output and make features\n\n=head1 SYNOPSIS\n\n    # A simple annotation pipeline wrapper for ipcress data\n    # assuming ipcress data is already generated in file seq1.ipcress\n    # and sequence data is in fasta format in file called seq1.fa\n\n    use Bio::Tools::ipcress;\n    use Bio::SeqIO;\n    my $parser = Bio::Tools::ipcress->new(-file => 'seq1.ipcress');\n    my $seqio = Bio::SeqIO->new(-format => 'fasta', -file => 'seq1.fa');\n    my $seq = $seqio->next_seq || die(\"cannot get a seq object from SeqIO\");\n\n    while( my $feat = $parser->next_feature ) {\n\t# add ipcress annotation to a sequence\n\t$seq->add_SeqFeature($feat);\n    }\n    my $seqout = Bio::SeqIO->new(-format => 'embl');\n    $seqout->write_seq($seq);\n\n\n=head1 DESCRIPTION\n\nThis object serves as a parser for ipcress data, creating a\nBio::SeqFeatureI for each ipcress hit.  These can be processed or added\nas annotation to an existing Bio::SeqI object for the purposes of\nautomated annotation.\n\nThis module is adapted from the Bio::Tools::EPCR module\nwritten by Jason Stajich (jason-at-bioperl.org).\n\nIpcress is available through Guy Slater's Exonerate package \nhttp://www.ebi.ac.uk/~guy/exonerate/\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sheldon McKay\n\nEmail mckays@cshl.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::ipcress;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : my $ipcress = Bio::Tools::ipcress->new(-file => $file,\n\t\t\t\t\t   -primary => $fprimary, \n\t\t\t\t\t   -source => $fsource, \n\t\t\t\t\t   -groupclass => $fgroupclass);\n Function: Initializes a new ipcress parser\n Returns : Bio::Tools::ipcress\n Args    : -fh   => filehandle\n           OR\n           -file => filename\n\n           -primary => a string to be used as the common value for\n                       each features '-primary' tag.  Defaults to\n                       the sequence ontology term 'PCR_product'.\n                       (This in turn maps to the GFF 'type'\n                       tag (aka 'method')).\n\n            -source => a string to be used as the common value for\n                       each features '-source' tag.  Defaults to\n                       'ipcress'. (This in turn maps to the GFF 'source'\n                       tag)\n\n             -groupclass => a string to be used as the name of the tag\n                           which will hold the sts marker namefirst\n                           attribute.  Defaults to 'name'.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($primary, $source, \n      $groupclass, $file, $fh) = $self->_rearrange([qw(PRIMARY\n\t\t\t\t\t\t       SOURCE \n\t\t\t\t\t\t       GROUPCLASS\n\t\t\t\t\t\t       FILE FH)],@args);\n  $self->primary(defined $primary ? $primary : 'PCR_product');\n  $self->source(defined $source ? $source : 'ipcress');\n  $self->groupclass(defined $groupclass ? $groupclass : 'name');\n\n  local $/ = 'Ipcress result';\n  my @result;\n\n  if ($file) {\n      open FH, $file;\n      @result = (<FH>);\n      close FH;\n  }\n  elsif ($fh) {\n      @result = (<$fh>);\n  }\n  else {\n      $self->throw(\"Bio::Tools::ipcress: no input file\");\n  }\n\n\n  shift @result;\n\n  $self->{result} = \\@result;\n\n  return $self;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $obj->next_feature();\n Function: Returns the next feature available in the analysis result, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    ","label":"next_feature($self)"},"children":[{"line":183,"kind":13,"localvar":"my","containerName":"next_feature","name":"$self","definition":"my"},{"line":184,"localvar":"my","containerName":"next_feature","kind":13,"name":"$result","definition":"my"},{"line":184,"name":"$self","containerName":"next_feature","kind":13}],"containerName":"main::","name":"next_feature","definition":"sub","detail":"($self)"},{"line":184,"kind":12,"name":"result"},{"line":185,"name":"$result","kind":13,"containerName":null},{"name":"$result","kind":13,"containerName":null,"line":187},{"name":"@lines","kind":13,"localvar":"my","containerName":null,"line":188,"definition":"my"},{"line":188,"name":"$result","containerName":null,"kind":13},{"localvar":"my","kind":13,"containerName":null,"name":"$ipcress","line":189,"definition":"my"},{"line":189,"kind":13,"containerName":null,"name":"@lines"},{"kind":13,"localvar":"my","containerName":null,"name":"$seqname","line":191,"definition":"my"},{"line":191,"containerName":null,"kind":13,"name":"$mkrname"},{"line":191,"name":"$length","kind":13,"containerName":null},{"name":"$start","containerName":null,"kind":13,"line":191},{"name":"$mismatchL","kind":13,"containerName":null,"line":191},{"containerName":null,"kind":13,"name":"$mismatchR","line":192},{"line":192,"name":"$desc","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$ipcress","line":192},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$end","line":194},{"line":194,"kind":13,"containerName":null,"name":"$start"},{"line":194,"name":"$length","kind":13,"containerName":null},{"line":195,"containerName":null,"kind":13,"name":"$start"},{"localvar":"my","containerName":null,"kind":13,"name":"$strand","line":197,"definition":"my"},{"line":197,"containerName":null,"kind":13,"name":"$desc"},{"line":197,"name":"$desc","containerName":null,"kind":13},{"line":199,"name":"$left","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"line":199,"name":"@lines","containerName":null,"kind":13},{"line":200,"name":"$left","kind":13,"containerName":null},{"line":201,"name":"$right","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"line":201,"name":"@lines","containerName":null,"kind":13},{"name":"$right","containerName":null,"kind":13,"line":202},{"line":203,"kind":13,"containerName":null,"name":"$right"},{"line":203,"containerName":null,"kind":13,"name":"$right"},{"line":207,"kind":13,"containerName":null,"name":"%self"},{"line":207,"name":"seen","kind":12},{"line":207,"name":"%mkrname","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$mkrname","line":208},{"definition":"my","name":"$markerfeature","containerName":null,"localvar":"my","kind":13,"line":212},{"line":212,"kind":12,"containerName":"SeqFeature::Generic","name":"Bio"},{"kind":12,"containerName":"main::","name":"new","line":212},{"name":"$start","containerName":null,"kind":13,"line":213},{"line":214,"name":"$end","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$strand","line":215},{"containerName":null,"kind":13,"name":"$self","line":216},{"containerName":"main::","kind":12,"name":"source","line":216},{"name":"$self","containerName":null,"kind":13,"line":217},{"name":"primary","containerName":"main::","kind":12,"line":217},{"line":218,"name":"%seqname","containerName":null,"kind":13},{"line":220,"name":"$self","kind":13,"containerName":null},{"containerName":"main::","kind":12,"name":"groupclass","line":220},{"line":220,"kind":13,"containerName":null,"name":"$mkrname"},{"name":"%strand","containerName":null,"kind":13,"line":223},{"line":224,"kind":13,"containerName":null,"name":"$markerfeature"},{"line":224,"containerName":"main::","kind":12,"name":"add_tag_value"},{"line":227,"name":"$markerfeature","containerName":null,"kind":13},{"line":227,"containerName":"main::","kind":12,"name":"add_tag_value"},{"kind":13,"containerName":null,"name":"$left","line":227},{"name":"$markerfeature","containerName":null,"kind":13,"line":228},{"line":228,"name":"add_tag_value","containerName":"main::","kind":12},{"line":228,"name":"$right","containerName":null,"kind":13},{"line":229,"containerName":null,"kind":13,"name":"$markerfeature"},{"name":"add_tag_value","kind":12,"containerName":"main::","line":229},{"line":229,"name":"$mismatchL","kind":13,"containerName":null},{"line":229,"name":"$mismatchL","kind":13,"containerName":null},{"name":"$markerfeature","kind":13,"containerName":null,"line":230},{"line":230,"name":"add_tag_value","containerName":"main::","kind":12},{"line":230,"name":"$mismatchR","kind":13,"containerName":null},{"line":230,"name":"$mismatchR","containerName":null,"kind":13},{"line":232,"name":"$markerfeature","kind":13,"containerName":null},{"kind":12,"range":{"start":{"character":0,"line":247},"end":{"line":251,"character":9999}},"line":247,"definition":"sub","name":"source","containerName":"main::","children":[{"definition":"my","line":248,"name":"$self","containerName":"source","localvar":"my","kind":13},{"containerName":"source","kind":13,"name":"$self","line":249},{"kind":13,"containerName":"source","name":"$self","line":250}]},{"children":[{"line":266,"kind":13,"localvar":"my","containerName":"primary","name":"$self","definition":"my"},{"name":"$self","containerName":"primary","kind":13,"line":267},{"line":268,"name":"$self","containerName":"primary","kind":13}],"containerName":"main::","name":"primary","definition":"sub","line":265,"kind":12,"range":{"end":{"character":9999,"line":269},"start":{"line":265,"character":0}}},{"definition":"sub","containerName":"main::","name":"groupclass","children":[{"line":284,"name":"$self","containerName":"groupclass","localvar":"my","kind":13,"definition":"my"},{"name":"$self","kind":13,"containerName":"groupclass","line":286},{"line":287,"kind":13,"containerName":"groupclass","name":"$self"}],"range":{"start":{"line":283,"character":0},"end":{"line":288,"character":9999}},"kind":12,"line":283}],"version":5}