{"version":5,"vars":[{"line":211,"name":"base","kind":2,"containerName":""},{"name":"DPALIGN_LOCAL_MILLER_MYERS","containerName":"main::","kind":14,"line":219,"definition":1},{"definition":1,"line":220,"containerName":"main::","kind":14,"name":"DPALIGN_GLOBAL_MILLER_MYERS"},{"definition":1,"name":"DPALIGN_ENDSFREE_MILLER_MYERS","containerName":"main::","kind":14,"line":221},{"name":"Bio","kind":12,"containerName":"Ext::Align","line":235},{"range":{"start":{"character":0,"line":241},"end":{"character":9999,"line":318}},"kind":12,"line":241,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"","label":"new($class,@args)"},"name":"new","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"$class","line":242},{"line":242,"kind":13,"containerName":"new","name":"@args"},{"definition":"my","line":244,"name":"$self","containerName":"new","localvar":"my","kind":13},{"line":244,"name":"$class","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"@args","line":244},{"line":246,"containerName":"new","localvar":"my","kind":13,"name":"$match","definition":"my"},{"line":246,"containerName":"new","kind":13,"name":"$mismatch"},{"name":"$gap","containerName":"new","kind":13,"line":246},{"containerName":"new","kind":13,"name":"$ext","line":246},{"kind":13,"containerName":"new","name":"$alg","line":246},{"line":246,"name":"$matrix","kind":13,"containerName":"new"},{"line":246,"name":"$self","containerName":"new","kind":13},{"line":246,"kind":12,"containerName":"new","name":"_rearrange"},{"line":252,"kind":13,"containerName":"new","name":"@args"},{"kind":13,"containerName":"new","name":"$self","line":254},{"line":254,"name":"match","containerName":"new","kind":12},{"name":"$match","containerName":"new","kind":13,"line":254},{"containerName":"new","kind":13,"name":"$self","line":255},{"kind":12,"containerName":"new","name":"mismatch","line":255},{"line":255,"name":"$mismatch","containerName":"new","kind":13},{"name":"$self","containerName":"new","kind":13,"line":256},{"name":"gap","containerName":"new","kind":12,"line":256},{"kind":13,"containerName":"new","name":"$gap","line":256},{"line":257,"name":"$self","containerName":"new","kind":13},{"line":257,"name":"ext","kind":12,"containerName":"new"},{"line":257,"name":"$ext","kind":13,"containerName":"new"},{"line":258,"name":"$self","kind":13,"containerName":"new"},{"kind":12,"containerName":"new","name":"alg","line":258},{"line":258,"containerName":"new","kind":13,"name":"$alg"},{"name":"$match","containerName":"new","kind":13,"line":260},{"containerName":"new","kind":13,"name":"$match","line":261},{"name":"$self","containerName":"new","kind":13,"line":262},{"name":"match","kind":12,"containerName":"new","line":262},{"containerName":"new","kind":13,"name":"$match","line":262},{"line":265,"containerName":"new","kind":13,"name":"$self"},{"containerName":"new","kind":12,"name":"throw","line":265},{"line":269,"name":"$mismatch","kind":13,"containerName":"new"},{"name":"$match","kind":13,"containerName":"new","line":270},{"line":271,"kind":13,"containerName":"new","name":"$self"},{"name":"mismatch","containerName":"new","kind":12,"line":271},{"line":271,"name":"$mismatch","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$self","line":274},{"line":274,"name":"throw","kind":12,"containerName":"new"},{"containerName":"new","kind":13,"name":"$gap","line":278},{"name":"$gap","kind":13,"containerName":"new","line":279},{"line":280,"name":"$self","kind":13,"containerName":"new"},{"line":280,"kind":12,"containerName":"new","name":"gap"},{"line":280,"name":"$gap","containerName":"new","kind":13},{"line":283,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","kind":12,"name":"throw","line":283},{"line":287,"containerName":"new","kind":13,"name":"$ext"},{"line":288,"containerName":"new","kind":13,"name":"$ext"},{"kind":13,"containerName":"new","name":"$self","line":289},{"line":289,"kind":12,"containerName":"new","name":"ext"},{"name":"$ext","containerName":"new","kind":13,"line":289},{"line":292,"name":"$self","containerName":"new","kind":13},{"containerName":"new","kind":12,"name":"throw","line":292},{"name":"$alg","containerName":"new","kind":13,"line":296},{"name":"$alg","containerName":"new","kind":13,"line":297},{"kind":13,"containerName":"new","name":"$alg","line":297},{"name":"$alg","kind":13,"containerName":"new","line":297},{"line":298,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","kind":12,"name":"alg","line":298},{"line":298,"containerName":"new","kind":13,"name":"$alg"},{"kind":13,"containerName":"new","name":"$self","line":301},{"line":301,"name":"throw","containerName":"new","kind":12},{"line":305,"containerName":"new","kind":13,"name":"$matrix"},{"name":"$matrix","containerName":"new","kind":13,"line":305},{"containerName":"new","kind":12,"name":"isa","line":305},{"line":306,"kind":13,"containerName":"new","name":"$self"},{"line":306,"containerName":"new","kind":12,"name":"new"},{"line":306,"containerName":"new","kind":13,"name":"$matrix"},{"kind":12,"containerName":"new","name":"row_names","line":306},{"line":306,"kind":13,"containerName":"new","name":"$self"},{"line":306,"name":"gap","containerName":"new","kind":12},{"name":"$self","kind":13,"containerName":"new","line":306},{"kind":12,"containerName":"new","name":"ext","line":306},{"line":307,"name":"$rowname","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$matrix","line":307},{"name":"row_names","containerName":"new","kind":12,"line":307},{"containerName":"new","kind":13,"name":"$colname","line":308},{"line":308,"name":"$matrix","kind":13,"containerName":"new"},{"line":308,"name":"column_names","containerName":"new","kind":12},{"name":"set_entry","containerName":"new","kind":12,"line":309},{"line":309,"kind":13,"containerName":"new","name":"$self"},{"name":"$rowname","containerName":"new","kind":13,"line":309},{"kind":13,"containerName":"new","name":"$colname","line":309},{"line":309,"name":"$matrix","kind":13,"containerName":"new"},{"line":309,"kind":12,"containerName":"new","name":"entry"},{"line":309,"name":"$rowname","kind":13,"containerName":"new"},{"line":309,"containerName":"new","kind":13,"name":"$colname"},{"name":"$self","containerName":"new","kind":13,"line":314},{"line":317,"name":"$self","containerName":"new","kind":13}],"detail":"($class,@args)","definition":"sub"},{"line":244,"containerName":"new","kind":12,"name":"SUPER"},{"line":258,"kind":12,"name":"DPALIGN_LOCAL_MILLER_MYERS"},{"name":"DPALIGN_LOCAL_MILLER_MYERS","kind":12,"line":297},{"name":"DPALIGN_GLOBAL_MILLER_MYERS","kind":12,"line":297},{"name":"DPALIGN_ENDSFREE_MILLER_MYERS","kind":12,"line":297},{"line":306,"containerName":"Ext::Align::ScoringMatrix","kind":12,"name":"Bio"},{"containerName":"Ext::Align::ScoringMatrix","kind":12,"name":"Bio","line":309},{"signature":{"parameters":[{"label":"$self"},{"label":"$seq1"}],"documentation":"1;\n## $Id: dpAlign.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n# BioPerl module for Bio::Tools::dpAlign\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Yee Man Chan <ymc@yahoo.com>\n#\n# Copyright Yee Man Chan\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::dpAlign - Perl extension to do pairwise dynamic programming sequence alignment\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::dpAlign;\n  use Bio::SeqIO;\n  use Bio::SimpleAlign;\n  use Bio::AlignIO;\n  use Bio::Matrix::IO;\n\n  $seq1 = Bio::SeqIO->new(-file => $ARGV[0], -format => 'fasta');\n  $seq2 = Bio::SeqIO->new(-file => $ARGV[1], -format => 'fasta');\n\n  # create a dpAlign object\n  # to do global alignment, specify DPALIGN_GLOBAL_MILLER_MYERS\n  # to do ends-free alignment, specify DPALIGN_ENDSFREE_MILLER_MYERS\n  $factory = new dpAlign(-match => 3,\n                     -mismatch => -1,\n                     -gap => 3,\n                     -ext => 1,\n                     -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLER_MYERS);\n\n  # actually do the alignment\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout = Bio::AlignIO->new(-format => 'pfam', -fh => \\*STDOUT);\n  $alnout->write_aln($out);\n\n  # To do protein alignment, set the sequence type to protein\n  # By default all protein alignments are using BLOSUM62 matrix\n  # the gap opening cost is 7 and gap extension is 1. These\n  # values are from ssearch. To use your own custom substitution \n  # matrix, you can create a Bio::Matrix::MatrixI object.\n\n  $parser = Bio::Matrix::IO->new(-format => 'scoring', -file => 'blosum50.mat');\n  $matrix = $parser->next_matrix;\n  $factory = Bio::Tools::dpAlign->new(-matrix => $matrix, -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLERMYERS);\n  $seq1->alphabet('protein');\n  $seq2->alphabet('protein');\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout->write_aln($out);\n\n  # use the factory to make some output\n\n  $factory->align_and_show($seq1, $seq2, STDOUT);\n\n  # use Phil Green's algorithm to calculate the optimal local\n  # alignment score between two sequences quickly. It is very\n  # useful when you are searching a query sequence in a database\n  # of sequences. Since finding a alignment is more costly \n  # than just calculating scores, you can save time if you only \n  # align sequences that have a high alignment score.\n\n  # To use this feature, first you call the sequence_profile function\n  # to obtain the profile of the query sequence.\n  $profile = $factory->sequence_profile($query);\n\n  %scores = ();\n  # Then use a loop to run a database of sequences against the\n  # profile to obtain a table of alignment scores\n  $dbseq = Bio::SeqIO(-file => 'dbseq.fa', -format => 'fasta');\n  while (defined($seq = $dbseq->next_seq)) {\n      $scores{$seq->id} = $factory->pairwise_alignment_score($profile, $seq);\n  }\n\n=head1 DESCRIPTION\n\nDynamic Programming approach is considered to be the most sensitive\nway to align two biological sequences. There are currently three major\ntypes of dynamic programming algorithms: Global Alignment, Local\nAlignment and Ends-free Alignment.\n\nGlobal Alignment compares two sequences in their entirety.  By\ninserting gaps in the two sequences, it aligns two sequences to\nminimize the edit distance as defined by the gap cost function and the\nsubstitution matrix. Global Alignment is generally applied to two\nsequences that are very similar in length and content.\n\nLocal Alignment instead attempts to find out the subsequences that has\nthe minimal edit distance among all possible subsequences.  It is good\nfor sequences that has a stretch of subsequences that are similar to\neach other.\n\nEnds-free Alignment is a special case of Global Alignment. There are\nno gap penalty imposed for the gaps that extended from the end points\nof two sequences. Therefore it will be a good application when you\nthink one sequence is contained by the other or when you think two\nsequences overlap each other.\n\nDynamic Programming was first introduced by Needleman-Wunsch (1970) to\nglobally align two sequences. The idea of local alignment was later\nintroduced by Smith-Waterman (1981). Gotoh (1982) improved both\nalgorithms by introducing auxillary arrays that reduced the time\ncomplexity of the algorithms to O(m*n).  Miller-Myers (1988) exploits\nthe divide-and-conquer idea introduced by Hirschberg (1975) to solve\nthe affine gap cost dynamic programming using only linear space. At\nthe time of this writing, it is accepted that Miller-Myers is the\nfastest single CPU implementation and using the least memory that is\ntruly equivalent to original algorithm introduced by\nNeedleman-Wunsch. According to Aaron Mackey, Phil Green's SWAT\nimplemention introduced a heuristic that does not consider paths\nthrought the matrix where the score would be less than the gap opening\npenalty, yielding a 1.5-2X speedup on most comparisons. to skip the\ncalculation of some cells. However, his approach is only good for\ncalculating the minimum edit distance and find out the corresponding\nsubsequences (aka search phase). Bill Pearson's popular dynamic\nprogramming alignment program SSEARCH uses Phil Green's algorithm to\nfind the subsequences and then Miller-Myers's algorithm to find the\nactual alignment. (aka alignment phase)\n\nThe current implementation supports local alignment of either DNA\nsequences or protein sequences. It allows you to specify either the\nMiller-Myers Global Alignment (DPALIGN_GLOBAL_MILLER_MYERS) or\nMiller-Myers Local Alignment (DPALIGN_LOCAL_MILLER_MYERS). For DNA\nalignment, you can specify the scores for match, mismatch, gap opening\ncost and gap extension cost. For protein alignment, it is using\nBLOSUM62 by default. Currently the substitution matrix is not\nconfigurable.\n\nNote: If you supply LocatableSeq objects to pairwise_alignment,\npairwise_alignment_score, align_and_show or sequence_profile and\nthe sequence supplied contains gaps, these functions will treat \nthese sequences as if they are without gaps.\n\n=head1 DEPENDENCIES\n\nThis package comes with the main bioperl distribution. You also need\nto install the lastest bioperl-ext package which contains the XS code\nthat implements the algorithms. This package won't work if you haven't\ncompiled the bioperl-ext package.\n\n=head1 TO-DO\n\n\n=over 3\n\n* 1.\n\nBasic support for IUPAC code for DNA sequence is now implemented. \nX will mismatch any character. T will match U. For others, whenever\nthere is a possibility for match, it is considered a full match, for\nexample, W will match B.\n\n* 2.\n\nAllow custom substitution matrix for DNA. Note that for proteins, you\ncan now use your own subsitution matirx.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n        This implementation was written by Yee Man Chan (ymc@yahoo.com).\n        Copyright (c) 2003 Yee Man Chan. All rights reserved. This program\n        is free software; you can redistribute it and/or modify it under\n        the same terms as Perl itself. Special thanks to Aaron Mackey\n        and WIlliam Pearson for the helpful discussions. [The portion\n        of code inside pgreen subdirectory was borrowed from ssearch. It\n        should be distributed in the same terms as ssearch.]\n\n\npackage Bio::Tools::dpAlign;\n\nuse Bio::SimpleAlign;\n\nuse base qw(Bio::Tools::AlignFactory);\n\n# Gotoh algorithm as defined in J. Mol. Biol. (1982) 162, 705-708\n# use constant DSW_GOTOH => 1;\n# Hirschberg's algorithm as defined in Myers & Miller in \n# CABIOS, Vol 4, No. 1, 1988, p 11-17\n# This algorithm is used in both the search phase and the\n# alignment phase.\nuse constant DPALIGN_LOCAL_MILLER_MYERS => 1;\nuse constant DPALIGN_GLOBAL_MILLER_MYERS => 2;\nuse constant DPALIGN_ENDSFREE_MILLER_MYERS => 3;\n# my toy algorithm that tries to do SW as fast as possible\n# use constant DSW_FSW => 3; \n# Phil Green's approximation to Smith-Waterman. It avoid calculations\n# that might result in a score less than the opening gap penalty.\n# This is the algorithm used by ssearch. Phil Green's algorithm is\n# used in the search phase while Miller-Myers algorithm is used in\n# the alignment phase\n#use constant DPALIGN_LOCAL_GREEN => 2; \n\nBEGIN {\n    eval {\n        require Bio::Ext::Align;\n    };\n    if ( $@ ) {\n        die(\"\\nThe C-compiled engine for Smith Waterman alignments (Align) has not been installed.\\n Please read the install the bioperl-ext package\\n\\n\");\n        exit(1);\n    }\n}\n\nsub new {\n   my ($class, @args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   my ($match, $mismatch, $gap, $ext, $alg, $matrix) = $self->_rearrange([qw(MATCH\n\t\t\t\t\t\t\t\tMISMATCH\n\t\t\t\t\t\t\t\tGAP\n\t\t\t\t\t\t\t\tEXT\n\t\t\t\t\t\t\t\tALG\n\t\t\t\t\t\t\t\tMATRIX\t\n\t\t\t\t\t\t\t)], @args);\n\n   $self->match(3) unless defined $match;\n   $self->mismatch(-1) unless defined $mismatch;\n   $self->gap(3) unless defined $gap;\n   $self->ext(1) unless defined $ext;\n   $self->alg(DPALIGN_LOCAL_MILLER_MYERS) unless defined $alg;\n\n   if (defined $match) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->match($match);\n\t}\n\telse {\n\t    $self->throw(\"Match score must be a number, not [$match]\");\n\t}\n    }\n\n    if (defined $mismatch) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->mismatch($mismatch);\n\t}\n\telse {\n\t    $self->throw(\"Mismatch penalty must be a number, not [$mismatch]\");\n\t}\n    }\n\n    if (defined $gap) {\n\tif ($gap =~ /^\\d+$/) {\n\t    $self->gap($gap);\n\t}\n\telse {\n\t    $self->throw(\"Gap penalty must be a number, not [$gap]\");\n\t}\n    }\n\n    if (defined $ext) {\n\tif ($ext =~ /^\\d+$/) {\n\t    $self->ext($ext);\n\t}\n\telse {\n\t    $self->throw(\"Extension penalty must be a number, not [$ext]\");\n\t}\n    }\n\n    if (defined $alg) {\n\tif ($alg == DPALIGN_LOCAL_MILLER_MYERS or $alg == DPALIGN_GLOBAL_MILLER_MYERS or $alg == DPALIGN_ENDSFREE_MILLER_MYERS) {\n\t    $self->alg($alg);\n\t}\n\telse {\n\t    $self->throw(\"Algorithm must be either 1, 2 or 3\");\n\t}\n    }\n\n    if (defined $matrix and $matrix->isa('Bio::Matrix::MatrixI')) {\n        $self->{'matrix'} = Bio::Ext::Align::ScoringMatrix->new(join(\"\", $matrix->row_names), $self->gap, $self->ext);\n        foreach $rowname ($matrix->row_names) {\n            foreach $colname ($matrix->column_names) {\n                Bio::Ext::Align::ScoringMatrix->set_entry($self->{'matrix'}, $rowname, $colname, $matrix->entry($rowname, $colname));\n            }\n        }\n    }\n    else {\n        $self->{'matrix'} = 0;\n    }\n\n    return $self;\n}\n\n=head2 sequence_profile\n\n Title   : sequence_profile\n Usage   : $prof = $factory->sequence_profile($seq1)\n Function: Makes a dpAlign_SequenceProfile object from one sequence\n Returns : A dpAlign_SequenceProfile object\n Args    : The lone argument is a Bio::PrimarySeqI that we want to \n\t   build a profile for. Usually, this would be the Query sequence","label":"sequence_profile($self,$seq1)"},"line":331,"range":{"end":{"character":9999,"line":362},"start":{"line":331,"character":0}},"kind":12,"definition":"sub","detail":"($self,$seq1)","children":[{"line":332,"name":"$self","localvar":"my","containerName":"sequence_profile","kind":13,"definition":"my"},{"name":"$seq1","containerName":"sequence_profile","kind":13,"line":332},{"line":334,"name":"$seq1","containerName":"sequence_profile","kind":13},{"name":"$seq1","kind":13,"containerName":"sequence_profile","line":334},{"line":334,"name":"isa","kind":12,"containerName":"sequence_profile"},{"name":"$self","containerName":"sequence_profile","kind":13,"line":335},{"name":"warn","kind":12,"containerName":"sequence_profile","line":335},{"line":340,"name":"$seq1","kind":13,"containerName":"sequence_profile"},{"line":340,"name":"length","kind":12,"containerName":"sequence_profile"},{"name":"$self","containerName":"sequence_profile","kind":13,"line":341},{"kind":12,"containerName":"sequence_profile","name":"warn","line":341},{"line":344,"name":"$seq1","containerName":"sequence_profile","kind":13},{"line":344,"name":"isa","containerName":"sequence_profile","kind":12},{"definition":"my","line":345,"name":"$seqstr","containerName":"sequence_profile","localvar":"my","kind":13},{"kind":13,"containerName":"sequence_profile","name":"$seq1","line":345},{"line":345,"containerName":"sequence_profile","kind":12,"name":"seq"},{"line":346,"containerName":"sequence_profile","kind":13,"name":"$seqstr"},{"line":347,"containerName":"sequence_profile","kind":13,"name":"$seq1"},{"containerName":"sequence_profile","kind":12,"name":"new","line":347},{"name":"$seq1","kind":13,"containerName":"sequence_profile","line":347},{"name":"id","kind":12,"containerName":"sequence_profile","line":347},{"line":347,"name":"$seqstr","kind":13,"containerName":"sequence_profile"},{"line":347,"name":"$seq1","containerName":"sequence_profile","kind":13},{"name":"alphabet","containerName":"sequence_profile","kind":12,"line":347},{"line":350,"kind":13,"containerName":"sequence_profile","name":"$seq1"},{"line":350,"name":"display_id","containerName":"sequence_profile","kind":12},{"line":350,"name":"$seq1","containerName":"sequence_profile","kind":13},{"name":"id","containerName":"sequence_profile","kind":12,"line":350},{"kind":13,"containerName":"sequence_profile","name":"$seq1","line":352},{"line":352,"kind":12,"containerName":"sequence_profile","name":"alphabet"},{"containerName":"sequence_profile","kind":12,"name":"dna_new","line":353},{"line":353,"kind":13,"containerName":"sequence_profile","name":"$seq1"},{"name":"seq","containerName":"sequence_profile","kind":12,"line":353},{"containerName":"sequence_profile","kind":13,"name":"$self","line":353},{"kind":13,"containerName":"sequence_profile","name":"$self","line":353},{"line":353,"name":"$self","containerName":"sequence_profile","kind":13},{"line":353,"kind":13,"containerName":"sequence_profile","name":"$self"},{"containerName":"sequence_profile","kind":13,"name":"$seq1","line":355},{"line":355,"name":"alphabet","containerName":"sequence_profile","kind":12},{"name":"protein_new","kind":12,"containerName":"sequence_profile","line":356},{"line":356,"kind":13,"containerName":"sequence_profile","name":"$seq1"},{"line":356,"name":"seq","kind":12,"containerName":"sequence_profile"},{"kind":13,"containerName":"sequence_profile","name":"$self","line":356}],"name":"sequence_profile","containerName":"main::"},{"line":347,"containerName":"Seq","kind":12,"name":"Bio"},{"line":353,"containerName":"Ext::Align::SequenceProfile","kind":12,"name":"Bio"},{"line":356,"kind":12,"containerName":"Ext::Align::SequenceProfile","name":"Bio"},{"kind":12,"name":"croak","line":359},{"detail":"($self,$prof,$seq2)","definition":"sub","containerName":"main::","name":"pairwise_alignment_score","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"pairwise_alignment_score","line":381},{"containerName":"pairwise_alignment_score","kind":13,"name":"$prof","line":381},{"line":381,"name":"$seq2","containerName":"pairwise_alignment_score","kind":13},{"name":"$prof","kind":13,"containerName":"pairwise_alignment_score","line":383},{"kind":13,"containerName":"pairwise_alignment_score","name":"$prof","line":383},{"kind":12,"containerName":"pairwise_alignment_score","name":"isa","line":383},{"containerName":"pairwise_alignment_score","kind":13,"name":"$seq2","line":384},{"name":"$seq2","containerName":"pairwise_alignment_score","kind":13,"line":384},{"line":384,"name":"isa","containerName":"pairwise_alignment_score","kind":12},{"containerName":"pairwise_alignment_score","kind":13,"name":"$self","line":385},{"name":"warn","kind":12,"containerName":"pairwise_alignment_score","line":385},{"containerName":"pairwise_alignment_score","kind":13,"name":"$seq2","line":389},{"name":"length","containerName":"pairwise_alignment_score","kind":12,"line":389},{"kind":13,"containerName":"pairwise_alignment_score","name":"$self","line":390},{"line":390,"name":"warn","kind":12,"containerName":"pairwise_alignment_score"},{"name":"$seq2","containerName":"pairwise_alignment_score","kind":13,"line":393},{"name":"isa","kind":12,"containerName":"pairwise_alignment_score","line":393},{"definition":"my","name":"$seqstr","kind":13,"localvar":"my","containerName":"pairwise_alignment_score","line":394},{"line":394,"name":"$seq2","containerName":"pairwise_alignment_score","kind":13},{"line":394,"name":"seq","kind":12,"containerName":"pairwise_alignment_score"},{"containerName":"pairwise_alignment_score","kind":13,"name":"$seqstr","line":395},{"line":396,"containerName":"pairwise_alignment_score","kind":13,"name":"$seq2"},{"line":396,"kind":12,"containerName":"pairwise_alignment_score","name":"new"},{"name":"$seq2","kind":13,"containerName":"pairwise_alignment_score","line":396},{"name":"id","containerName":"pairwise_alignment_score","kind":12,"line":396},{"containerName":"pairwise_alignment_score","kind":13,"name":"$seqstr","line":396},{"name":"$seq2","containerName":"pairwise_alignment_score","kind":13,"line":396},{"name":"alphabet","containerName":"pairwise_alignment_score","kind":12,"line":396},{"name":"$self","kind":13,"containerName":"pairwise_alignment_score","line":398},{"name":"set_memory_and_report","containerName":"pairwise_alignment_score","kind":12,"line":398},{"line":400,"containerName":"pairwise_alignment_score","kind":13,"name":"$seq2"},{"name":"display_id","kind":12,"containerName":"pairwise_alignment_score","line":400},{"name":"$seq2","kind":13,"containerName":"pairwise_alignment_score","line":400},{"containerName":"pairwise_alignment_score","kind":12,"name":"id","line":400},{"line":402,"name":"$prof","kind":13,"containerName":"pairwise_alignment_score"},{"line":402,"kind":12,"containerName":"pairwise_alignment_score","name":"alphabet"},{"name":"$seq2","kind":13,"containerName":"pairwise_alignment_score","line":402},{"name":"alphabet","containerName":"pairwise_alignment_score","kind":12,"line":402},{"name":"$prof","kind":13,"containerName":"pairwise_alignment_score","line":403},{"name":"$seq2","containerName":"pairwise_alignment_score","kind":13,"line":403},{"line":403,"containerName":"pairwise_alignment_score","kind":12,"name":"seq"},{"line":405,"containerName":"pairwise_alignment_score","kind":13,"name":"$prof"},{"containerName":"pairwise_alignment_score","kind":12,"name":"alphabet","line":405},{"line":405,"containerName":"pairwise_alignment_score","kind":13,"name":"$seq2"},{"line":405,"name":"alphabet","containerName":"pairwise_alignment_score","kind":12},{"containerName":"pairwise_alignment_score","kind":13,"name":"$prof","line":406},{"line":406,"name":"$seq2","containerName":"pairwise_alignment_score","kind":13},{"line":406,"name":"seq","kind":12,"containerName":"pairwise_alignment_score"}],"signature":{"documentation":"1;\n## $Id: dpAlign.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n# BioPerl module for Bio::Tools::dpAlign\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Yee Man Chan <ymc@yahoo.com>\n#\n# Copyright Yee Man Chan\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::dpAlign - Perl extension to do pairwise dynamic programming sequence alignment\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::dpAlign;\n  use Bio::SeqIO;\n  use Bio::SimpleAlign;\n  use Bio::AlignIO;\n  use Bio::Matrix::IO;\n\n  $seq1 = Bio::SeqIO->new(-file => $ARGV[0], -format => 'fasta');\n  $seq2 = Bio::SeqIO->new(-file => $ARGV[1], -format => 'fasta');\n\n  # create a dpAlign object\n  # to do global alignment, specify DPALIGN_GLOBAL_MILLER_MYERS\n  # to do ends-free alignment, specify DPALIGN_ENDSFREE_MILLER_MYERS\n  $factory = new dpAlign(-match => 3,\n                     -mismatch => -1,\n                     -gap => 3,\n                     -ext => 1,\n                     -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLER_MYERS);\n\n  # actually do the alignment\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout = Bio::AlignIO->new(-format => 'pfam', -fh => \\*STDOUT);\n  $alnout->write_aln($out);\n\n  # To do protein alignment, set the sequence type to protein\n  # By default all protein alignments are using BLOSUM62 matrix\n  # the gap opening cost is 7 and gap extension is 1. These\n  # values are from ssearch. To use your own custom substitution \n  # matrix, you can create a Bio::Matrix::MatrixI object.\n\n  $parser = Bio::Matrix::IO->new(-format => 'scoring', -file => 'blosum50.mat');\n  $matrix = $parser->next_matrix;\n  $factory = Bio::Tools::dpAlign->new(-matrix => $matrix, -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLERMYERS);\n  $seq1->alphabet('protein');\n  $seq2->alphabet('protein');\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout->write_aln($out);\n\n  # use the factory to make some output\n\n  $factory->align_and_show($seq1, $seq2, STDOUT);\n\n  # use Phil Green's algorithm to calculate the optimal local\n  # alignment score between two sequences quickly. It is very\n  # useful when you are searching a query sequence in a database\n  # of sequences. Since finding a alignment is more costly \n  # than just calculating scores, you can save time if you only \n  # align sequences that have a high alignment score.\n\n  # To use this feature, first you call the sequence_profile function\n  # to obtain the profile of the query sequence.\n  $profile = $factory->sequence_profile($query);\n\n  %scores = ();\n  # Then use a loop to run a database of sequences against the\n  # profile to obtain a table of alignment scores\n  $dbseq = Bio::SeqIO(-file => 'dbseq.fa', -format => 'fasta');\n  while (defined($seq = $dbseq->next_seq)) {\n      $scores{$seq->id} = $factory->pairwise_alignment_score($profile, $seq);\n  }\n\n=head1 DESCRIPTION\n\nDynamic Programming approach is considered to be the most sensitive\nway to align two biological sequences. There are currently three major\ntypes of dynamic programming algorithms: Global Alignment, Local\nAlignment and Ends-free Alignment.\n\nGlobal Alignment compares two sequences in their entirety.  By\ninserting gaps in the two sequences, it aligns two sequences to\nminimize the edit distance as defined by the gap cost function and the\nsubstitution matrix. Global Alignment is generally applied to two\nsequences that are very similar in length and content.\n\nLocal Alignment instead attempts to find out the subsequences that has\nthe minimal edit distance among all possible subsequences.  It is good\nfor sequences that has a stretch of subsequences that are similar to\neach other.\n\nEnds-free Alignment is a special case of Global Alignment. There are\nno gap penalty imposed for the gaps that extended from the end points\nof two sequences. Therefore it will be a good application when you\nthink one sequence is contained by the other or when you think two\nsequences overlap each other.\n\nDynamic Programming was first introduced by Needleman-Wunsch (1970) to\nglobally align two sequences. The idea of local alignment was later\nintroduced by Smith-Waterman (1981). Gotoh (1982) improved both\nalgorithms by introducing auxillary arrays that reduced the time\ncomplexity of the algorithms to O(m*n).  Miller-Myers (1988) exploits\nthe divide-and-conquer idea introduced by Hirschberg (1975) to solve\nthe affine gap cost dynamic programming using only linear space. At\nthe time of this writing, it is accepted that Miller-Myers is the\nfastest single CPU implementation and using the least memory that is\ntruly equivalent to original algorithm introduced by\nNeedleman-Wunsch. According to Aaron Mackey, Phil Green's SWAT\nimplemention introduced a heuristic that does not consider paths\nthrought the matrix where the score would be less than the gap opening\npenalty, yielding a 1.5-2X speedup on most comparisons. to skip the\ncalculation of some cells. However, his approach is only good for\ncalculating the minimum edit distance and find out the corresponding\nsubsequences (aka search phase). Bill Pearson's popular dynamic\nprogramming alignment program SSEARCH uses Phil Green's algorithm to\nfind the subsequences and then Miller-Myers's algorithm to find the\nactual alignment. (aka alignment phase)\n\nThe current implementation supports local alignment of either DNA\nsequences or protein sequences. It allows you to specify either the\nMiller-Myers Global Alignment (DPALIGN_GLOBAL_MILLER_MYERS) or\nMiller-Myers Local Alignment (DPALIGN_LOCAL_MILLER_MYERS). For DNA\nalignment, you can specify the scores for match, mismatch, gap opening\ncost and gap extension cost. For protein alignment, it is using\nBLOSUM62 by default. Currently the substitution matrix is not\nconfigurable.\n\nNote: If you supply LocatableSeq objects to pairwise_alignment,\npairwise_alignment_score, align_and_show or sequence_profile and\nthe sequence supplied contains gaps, these functions will treat \nthese sequences as if they are without gaps.\n\n=head1 DEPENDENCIES\n\nThis package comes with the main bioperl distribution. You also need\nto install the lastest bioperl-ext package which contains the XS code\nthat implements the algorithms. This package won't work if you haven't\ncompiled the bioperl-ext package.\n\n=head1 TO-DO\n\n\n=over 3\n\n* 1.\n\nBasic support for IUPAC code for DNA sequence is now implemented. \nX will mismatch any character. T will match U. For others, whenever\nthere is a possibility for match, it is considered a full match, for\nexample, W will match B.\n\n* 2.\n\nAllow custom substitution matrix for DNA. Note that for proteins, you\ncan now use your own subsitution matirx.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n        This implementation was written by Yee Man Chan (ymc@yahoo.com).\n        Copyright (c) 2003 Yee Man Chan. All rights reserved. This program\n        is free software; you can redistribute it and/or modify it under\n        the same terms as Perl itself. Special thanks to Aaron Mackey\n        and WIlliam Pearson for the helpful discussions. [The portion\n        of code inside pgreen subdirectory was borrowed from ssearch. It\n        should be distributed in the same terms as ssearch.]\n\n\npackage Bio::Tools::dpAlign;\n\nuse Bio::SimpleAlign;\n\nuse base qw(Bio::Tools::AlignFactory);\n\n# Gotoh algorithm as defined in J. Mol. Biol. (1982) 162, 705-708\n# use constant DSW_GOTOH => 1;\n# Hirschberg's algorithm as defined in Myers & Miller in \n# CABIOS, Vol 4, No. 1, 1988, p 11-17\n# This algorithm is used in both the search phase and the\n# alignment phase.\nuse constant DPALIGN_LOCAL_MILLER_MYERS => 1;\nuse constant DPALIGN_GLOBAL_MILLER_MYERS => 2;\nuse constant DPALIGN_ENDSFREE_MILLER_MYERS => 3;\n# my toy algorithm that tries to do SW as fast as possible\n# use constant DSW_FSW => 3; \n# Phil Green's approximation to Smith-Waterman. It avoid calculations\n# that might result in a score less than the opening gap penalty.\n# This is the algorithm used by ssearch. Phil Green's algorithm is\n# used in the search phase while Miller-Myers algorithm is used in\n# the alignment phase\n#use constant DPALIGN_LOCAL_GREEN => 2; \n\nBEGIN {\n    eval {\n        require Bio::Ext::Align;\n    };\n    if ( $@ ) {\n        die(\"\\nThe C-compiled engine for Smith Waterman alignments (Align) has not been installed.\\n Please read the install the bioperl-ext package\\n\\n\");\n        exit(1);\n    }\n}\n\nsub new {\n   my ($class, @args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   my ($match, $mismatch, $gap, $ext, $alg, $matrix) = $self->_rearrange([qw(MATCH\n\t\t\t\t\t\t\t\tMISMATCH\n\t\t\t\t\t\t\t\tGAP\n\t\t\t\t\t\t\t\tEXT\n\t\t\t\t\t\t\t\tALG\n\t\t\t\t\t\t\t\tMATRIX\t\n\t\t\t\t\t\t\t)], @args);\n\n   $self->match(3) unless defined $match;\n   $self->mismatch(-1) unless defined $mismatch;\n   $self->gap(3) unless defined $gap;\n   $self->ext(1) unless defined $ext;\n   $self->alg(DPALIGN_LOCAL_MILLER_MYERS) unless defined $alg;\n\n   if (defined $match) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->match($match);\n\t}\n\telse {\n\t    $self->throw(\"Match score must be a number, not [$match]\");\n\t}\n    }\n\n    if (defined $mismatch) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->mismatch($mismatch);\n\t}\n\telse {\n\t    $self->throw(\"Mismatch penalty must be a number, not [$mismatch]\");\n\t}\n    }\n\n    if (defined $gap) {\n\tif ($gap =~ /^\\d+$/) {\n\t    $self->gap($gap);\n\t}\n\telse {\n\t    $self->throw(\"Gap penalty must be a number, not [$gap]\");\n\t}\n    }\n\n    if (defined $ext) {\n\tif ($ext =~ /^\\d+$/) {\n\t    $self->ext($ext);\n\t}\n\telse {\n\t    $self->throw(\"Extension penalty must be a number, not [$ext]\");\n\t}\n    }\n\n    if (defined $alg) {\n\tif ($alg == DPALIGN_LOCAL_MILLER_MYERS or $alg == DPALIGN_GLOBAL_MILLER_MYERS or $alg == DPALIGN_ENDSFREE_MILLER_MYERS) {\n\t    $self->alg($alg);\n\t}\n\telse {\n\t    $self->throw(\"Algorithm must be either 1, 2 or 3\");\n\t}\n    }\n\n    if (defined $matrix and $matrix->isa('Bio::Matrix::MatrixI')) {\n        $self->{'matrix'} = Bio::Ext::Align::ScoringMatrix->new(join(\"\", $matrix->row_names), $self->gap, $self->ext);\n        foreach $rowname ($matrix->row_names) {\n            foreach $colname ($matrix->column_names) {\n                Bio::Ext::Align::ScoringMatrix->set_entry($self->{'matrix'}, $rowname, $colname, $matrix->entry($rowname, $colname));\n            }\n        }\n    }\n    else {\n        $self->{'matrix'} = 0;\n    }\n\n    return $self;\n}\n\n=head2 sequence_profile\n\n Title   : sequence_profile\n Usage   : $prof = $factory->sequence_profile($seq1)\n Function: Makes a dpAlign_SequenceProfile object from one sequence\n Returns : A dpAlign_SequenceProfile object\n Args    : The lone argument is a Bio::PrimarySeqI that we want to \n\t   build a profile for. Usually, this would be the Query sequence\n\n\nsub sequence_profile {\n    my ($self, $seq1) = @_;\n\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI')) {\n        $self->warn(\"Cannot call sequence_profilewithout specifing one sequence (Bio::PrimarySeqI object)\");\n        return;\n    }\n\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2) {\n        $self->warn(\"cannot create sequence profile with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n\n    if ($seq1->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::SequenceProfile->dna_new($seq1->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'});\n    }\n    elsif ($seq1->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::SequenceProfile->protein_new($seq1->seq, $self->{'matrix'}); \n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment_score\n\n Title   : pairwise_alignment_score\n Usage   : $score = $factory->pairwise_alignment_score($prof,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : An integer that is the score of the optimal alignment.\n Args    : The first argument is the sequence profile obtained from a\n\t   call to the sequence_profile function. The second argument \n\t   is a Bio::PrimarySeqI object to be aligned. The second argument\n\t   is usually a sequence in the database sequence. Note\n\t   that this function only uses Phil Green's algorithm and \n\t   therefore theoretically may not always give you the optimal\n\t   score.","parameters":[{"label":"$self"},{"label":"$prof"},{"label":"$seq2"}],"label":"pairwise_alignment_score($self,$prof,$seq2)"},"kind":12,"range":{"start":{"character":0,"line":380},"end":{"line":412,"character":9999}},"line":380},{"name":"Bio","containerName":"Seq","kind":12,"line":396},{"containerName":"Ext::Align::Score_DNA_Sequences","kind":12,"name":"Bio","line":403},{"kind":12,"containerName":"Ext::Align::Score_Protein_Sequences","name":"Bio","line":406},{"kind":12,"name":"croak","line":409},{"signature":{"label":"pairwise_alignment($self,$seq1,$seq2)","documentation":"1;\n## $Id: dpAlign.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n# BioPerl module for Bio::Tools::dpAlign\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Yee Man Chan <ymc@yahoo.com>\n#\n# Copyright Yee Man Chan\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::dpAlign - Perl extension to do pairwise dynamic programming sequence alignment\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::dpAlign;\n  use Bio::SeqIO;\n  use Bio::SimpleAlign;\n  use Bio::AlignIO;\n  use Bio::Matrix::IO;\n\n  $seq1 = Bio::SeqIO->new(-file => $ARGV[0], -format => 'fasta');\n  $seq2 = Bio::SeqIO->new(-file => $ARGV[1], -format => 'fasta');\n\n  # create a dpAlign object\n  # to do global alignment, specify DPALIGN_GLOBAL_MILLER_MYERS\n  # to do ends-free alignment, specify DPALIGN_ENDSFREE_MILLER_MYERS\n  $factory = new dpAlign(-match => 3,\n                     -mismatch => -1,\n                     -gap => 3,\n                     -ext => 1,\n                     -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLER_MYERS);\n\n  # actually do the alignment\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout = Bio::AlignIO->new(-format => 'pfam', -fh => \\*STDOUT);\n  $alnout->write_aln($out);\n\n  # To do protein alignment, set the sequence type to protein\n  # By default all protein alignments are using BLOSUM62 matrix\n  # the gap opening cost is 7 and gap extension is 1. These\n  # values are from ssearch. To use your own custom substitution \n  # matrix, you can create a Bio::Matrix::MatrixI object.\n\n  $parser = Bio::Matrix::IO->new(-format => 'scoring', -file => 'blosum50.mat');\n  $matrix = $parser->next_matrix;\n  $factory = Bio::Tools::dpAlign->new(-matrix => $matrix, -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLERMYERS);\n  $seq1->alphabet('protein');\n  $seq2->alphabet('protein');\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout->write_aln($out);\n\n  # use the factory to make some output\n\n  $factory->align_and_show($seq1, $seq2, STDOUT);\n\n  # use Phil Green's algorithm to calculate the optimal local\n  # alignment score between two sequences quickly. It is very\n  # useful when you are searching a query sequence in a database\n  # of sequences. Since finding a alignment is more costly \n  # than just calculating scores, you can save time if you only \n  # align sequences that have a high alignment score.\n\n  # To use this feature, first you call the sequence_profile function\n  # to obtain the profile of the query sequence.\n  $profile = $factory->sequence_profile($query);\n\n  %scores = ();\n  # Then use a loop to run a database of sequences against the\n  # profile to obtain a table of alignment scores\n  $dbseq = Bio::SeqIO(-file => 'dbseq.fa', -format => 'fasta');\n  while (defined($seq = $dbseq->next_seq)) {\n      $scores{$seq->id} = $factory->pairwise_alignment_score($profile, $seq);\n  }\n\n=head1 DESCRIPTION\n\nDynamic Programming approach is considered to be the most sensitive\nway to align two biological sequences. There are currently three major\ntypes of dynamic programming algorithms: Global Alignment, Local\nAlignment and Ends-free Alignment.\n\nGlobal Alignment compares two sequences in their entirety.  By\ninserting gaps in the two sequences, it aligns two sequences to\nminimize the edit distance as defined by the gap cost function and the\nsubstitution matrix. Global Alignment is generally applied to two\nsequences that are very similar in length and content.\n\nLocal Alignment instead attempts to find out the subsequences that has\nthe minimal edit distance among all possible subsequences.  It is good\nfor sequences that has a stretch of subsequences that are similar to\neach other.\n\nEnds-free Alignment is a special case of Global Alignment. There are\nno gap penalty imposed for the gaps that extended from the end points\nof two sequences. Therefore it will be a good application when you\nthink one sequence is contained by the other or when you think two\nsequences overlap each other.\n\nDynamic Programming was first introduced by Needleman-Wunsch (1970) to\nglobally align two sequences. The idea of local alignment was later\nintroduced by Smith-Waterman (1981). Gotoh (1982) improved both\nalgorithms by introducing auxillary arrays that reduced the time\ncomplexity of the algorithms to O(m*n).  Miller-Myers (1988) exploits\nthe divide-and-conquer idea introduced by Hirschberg (1975) to solve\nthe affine gap cost dynamic programming using only linear space. At\nthe time of this writing, it is accepted that Miller-Myers is the\nfastest single CPU implementation and using the least memory that is\ntruly equivalent to original algorithm introduced by\nNeedleman-Wunsch. According to Aaron Mackey, Phil Green's SWAT\nimplemention introduced a heuristic that does not consider paths\nthrought the matrix where the score would be less than the gap opening\npenalty, yielding a 1.5-2X speedup on most comparisons. to skip the\ncalculation of some cells. However, his approach is only good for\ncalculating the minimum edit distance and find out the corresponding\nsubsequences (aka search phase). Bill Pearson's popular dynamic\nprogramming alignment program SSEARCH uses Phil Green's algorithm to\nfind the subsequences and then Miller-Myers's algorithm to find the\nactual alignment. (aka alignment phase)\n\nThe current implementation supports local alignment of either DNA\nsequences or protein sequences. It allows you to specify either the\nMiller-Myers Global Alignment (DPALIGN_GLOBAL_MILLER_MYERS) or\nMiller-Myers Local Alignment (DPALIGN_LOCAL_MILLER_MYERS). For DNA\nalignment, you can specify the scores for match, mismatch, gap opening\ncost and gap extension cost. For protein alignment, it is using\nBLOSUM62 by default. Currently the substitution matrix is not\nconfigurable.\n\nNote: If you supply LocatableSeq objects to pairwise_alignment,\npairwise_alignment_score, align_and_show or sequence_profile and\nthe sequence supplied contains gaps, these functions will treat \nthese sequences as if they are without gaps.\n\n=head1 DEPENDENCIES\n\nThis package comes with the main bioperl distribution. You also need\nto install the lastest bioperl-ext package which contains the XS code\nthat implements the algorithms. This package won't work if you haven't\ncompiled the bioperl-ext package.\n\n=head1 TO-DO\n\n\n=over 3\n\n* 1.\n\nBasic support for IUPAC code for DNA sequence is now implemented. \nX will mismatch any character. T will match U. For others, whenever\nthere is a possibility for match, it is considered a full match, for\nexample, W will match B.\n\n* 2.\n\nAllow custom substitution matrix for DNA. Note that for proteins, you\ncan now use your own subsitution matirx.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n        This implementation was written by Yee Man Chan (ymc@yahoo.com).\n        Copyright (c) 2003 Yee Man Chan. All rights reserved. This program\n        is free software; you can redistribute it and/or modify it under\n        the same terms as Perl itself. Special thanks to Aaron Mackey\n        and WIlliam Pearson for the helpful discussions. [The portion\n        of code inside pgreen subdirectory was borrowed from ssearch. It\n        should be distributed in the same terms as ssearch.]\n\n\npackage Bio::Tools::dpAlign;\n\nuse Bio::SimpleAlign;\n\nuse base qw(Bio::Tools::AlignFactory);\n\n# Gotoh algorithm as defined in J. Mol. Biol. (1982) 162, 705-708\n# use constant DSW_GOTOH => 1;\n# Hirschberg's algorithm as defined in Myers & Miller in \n# CABIOS, Vol 4, No. 1, 1988, p 11-17\n# This algorithm is used in both the search phase and the\n# alignment phase.\nuse constant DPALIGN_LOCAL_MILLER_MYERS => 1;\nuse constant DPALIGN_GLOBAL_MILLER_MYERS => 2;\nuse constant DPALIGN_ENDSFREE_MILLER_MYERS => 3;\n# my toy algorithm that tries to do SW as fast as possible\n# use constant DSW_FSW => 3; \n# Phil Green's approximation to Smith-Waterman. It avoid calculations\n# that might result in a score less than the opening gap penalty.\n# This is the algorithm used by ssearch. Phil Green's algorithm is\n# used in the search phase while Miller-Myers algorithm is used in\n# the alignment phase\n#use constant DPALIGN_LOCAL_GREEN => 2; \n\nBEGIN {\n    eval {\n        require Bio::Ext::Align;\n    };\n    if ( $@ ) {\n        die(\"\\nThe C-compiled engine for Smith Waterman alignments (Align) has not been installed.\\n Please read the install the bioperl-ext package\\n\\n\");\n        exit(1);\n    }\n}\n\nsub new {\n   my ($class, @args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   my ($match, $mismatch, $gap, $ext, $alg, $matrix) = $self->_rearrange([qw(MATCH\n\t\t\t\t\t\t\t\tMISMATCH\n\t\t\t\t\t\t\t\tGAP\n\t\t\t\t\t\t\t\tEXT\n\t\t\t\t\t\t\t\tALG\n\t\t\t\t\t\t\t\tMATRIX\t\n\t\t\t\t\t\t\t)], @args);\n\n   $self->match(3) unless defined $match;\n   $self->mismatch(-1) unless defined $mismatch;\n   $self->gap(3) unless defined $gap;\n   $self->ext(1) unless defined $ext;\n   $self->alg(DPALIGN_LOCAL_MILLER_MYERS) unless defined $alg;\n\n   if (defined $match) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->match($match);\n\t}\n\telse {\n\t    $self->throw(\"Match score must be a number, not [$match]\");\n\t}\n    }\n\n    if (defined $mismatch) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->mismatch($mismatch);\n\t}\n\telse {\n\t    $self->throw(\"Mismatch penalty must be a number, not [$mismatch]\");\n\t}\n    }\n\n    if (defined $gap) {\n\tif ($gap =~ /^\\d+$/) {\n\t    $self->gap($gap);\n\t}\n\telse {\n\t    $self->throw(\"Gap penalty must be a number, not [$gap]\");\n\t}\n    }\n\n    if (defined $ext) {\n\tif ($ext =~ /^\\d+$/) {\n\t    $self->ext($ext);\n\t}\n\telse {\n\t    $self->throw(\"Extension penalty must be a number, not [$ext]\");\n\t}\n    }\n\n    if (defined $alg) {\n\tif ($alg == DPALIGN_LOCAL_MILLER_MYERS or $alg == DPALIGN_GLOBAL_MILLER_MYERS or $alg == DPALIGN_ENDSFREE_MILLER_MYERS) {\n\t    $self->alg($alg);\n\t}\n\telse {\n\t    $self->throw(\"Algorithm must be either 1, 2 or 3\");\n\t}\n    }\n\n    if (defined $matrix and $matrix->isa('Bio::Matrix::MatrixI')) {\n        $self->{'matrix'} = Bio::Ext::Align::ScoringMatrix->new(join(\"\", $matrix->row_names), $self->gap, $self->ext);\n        foreach $rowname ($matrix->row_names) {\n            foreach $colname ($matrix->column_names) {\n                Bio::Ext::Align::ScoringMatrix->set_entry($self->{'matrix'}, $rowname, $colname, $matrix->entry($rowname, $colname));\n            }\n        }\n    }\n    else {\n        $self->{'matrix'} = 0;\n    }\n\n    return $self;\n}\n\n=head2 sequence_profile\n\n Title   : sequence_profile\n Usage   : $prof = $factory->sequence_profile($seq1)\n Function: Makes a dpAlign_SequenceProfile object from one sequence\n Returns : A dpAlign_SequenceProfile object\n Args    : The lone argument is a Bio::PrimarySeqI that we want to \n\t   build a profile for. Usually, this would be the Query sequence\n\n\nsub sequence_profile {\n    my ($self, $seq1) = @_;\n\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI')) {\n        $self->warn(\"Cannot call sequence_profilewithout specifing one sequence (Bio::PrimarySeqI object)\");\n        return;\n    }\n\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2) {\n        $self->warn(\"cannot create sequence profile with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n\n    if ($seq1->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::SequenceProfile->dna_new($seq1->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'});\n    }\n    elsif ($seq1->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::SequenceProfile->protein_new($seq1->seq, $self->{'matrix'}); \n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment_score\n\n Title   : pairwise_alignment_score\n Usage   : $score = $factory->pairwise_alignment_score($prof,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : An integer that is the score of the optimal alignment.\n Args    : The first argument is the sequence profile obtained from a\n\t   call to the sequence_profile function. The second argument \n\t   is a Bio::PrimarySeqI object to be aligned. The second argument\n\t   is usually a sequence in the database sequence. Note\n\t   that this function only uses Phil Green's algorithm and \n\t   therefore theoretically may not always give you the optimal\n\t   score.\n\n\nsub pairwise_alignment_score {\n    my ($self, $prof, $seq2) = @_;\n\n    if( ! defined $prof || ! $prof->isa('Bio::Ext::Align::SequenceProfile') || \n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment_score without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq2->length() < 2) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($prof->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::Score_DNA_Sequences($prof, $seq2->seq);\n    }\n    elsif ($prof->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::Score_Protein_Sequences($prof, $seq2->seq);\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment\n\n Title   : pairwise_alignment\n Usage   : $aln = $factory->pairwise_alignment($seq1,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : A SimpleAlign object if there is an alignment with positive\n\t   score. Otherwise, return undef.\n Args    : The first and second arguments are both Bio::PrimarySeqI\n\t   objects that are to be aligned.","parameters":[{"label":"$self"},{"label":"$seq1"},{"label":"$seq2"}]},"line":426,"range":{"start":{"line":426,"character":0},"end":{"line":484,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$seq1,$seq2)","children":[{"containerName":"pairwise_alignment","localvar":"my","kind":13,"name":"$self","line":427,"definition":"my"},{"kind":13,"containerName":"pairwise_alignment","name":"$seq1","line":427},{"line":427,"kind":13,"containerName":"pairwise_alignment","name":"$seq2"},{"definition":"my","line":428,"name":"$aln","kind":13,"localvar":"my","containerName":"pairwise_alignment"},{"kind":13,"containerName":"pairwise_alignment","name":"$out","line":428},{"line":430,"containerName":"pairwise_alignment","kind":13,"name":"$seq1"},{"line":430,"kind":13,"containerName":"pairwise_alignment","name":"$seq1"},{"name":"isa","kind":12,"containerName":"pairwise_alignment","line":430},{"name":"$seq2","kind":13,"containerName":"pairwise_alignment","line":431},{"line":431,"kind":13,"containerName":"pairwise_alignment","name":"$seq2"},{"line":431,"containerName":"pairwise_alignment","kind":12,"name":"isa"},{"line":432,"containerName":"pairwise_alignment","kind":13,"name":"$self"},{"name":"warn","containerName":"pairwise_alignment","kind":12,"line":432},{"containerName":"pairwise_alignment","kind":13,"name":"$seq1","line":436},{"line":436,"name":"length","kind":12,"containerName":"pairwise_alignment"},{"line":437,"containerName":"pairwise_alignment","kind":13,"name":"$seq2"},{"name":"length","containerName":"pairwise_alignment","kind":12,"line":437},{"name":"$self","kind":13,"containerName":"pairwise_alignment","line":438},{"line":438,"kind":12,"containerName":"pairwise_alignment","name":"warn"},{"containerName":"pairwise_alignment","kind":13,"name":"$seq1","line":441},{"name":"isa","kind":12,"containerName":"pairwise_alignment","line":441},{"line":442,"kind":13,"localvar":"my","containerName":"pairwise_alignment","name":"$seqstr","definition":"my"},{"name":"$seq1","containerName":"pairwise_alignment","kind":13,"line":442},{"line":442,"name":"seq","kind":12,"containerName":"pairwise_alignment"},{"line":443,"containerName":"pairwise_alignment","kind":13,"name":"$seqstr"},{"name":"$seq1","containerName":"pairwise_alignment","kind":13,"line":444},{"line":444,"kind":12,"containerName":"pairwise_alignment","name":"new"},{"line":444,"kind":13,"containerName":"pairwise_alignment","name":"$seq1"},{"name":"id","kind":12,"containerName":"pairwise_alignment","line":444},{"line":444,"name":"$seqstr","containerName":"pairwise_alignment","kind":13},{"containerName":"pairwise_alignment","kind":13,"name":"$seq1","line":444},{"line":444,"kind":12,"containerName":"pairwise_alignment","name":"alphabet"},{"containerName":"pairwise_alignment","kind":13,"name":"$seq2","line":446},{"kind":12,"containerName":"pairwise_alignment","name":"isa","line":446},{"definition":"my","line":447,"name":"$seqstr","localvar":"my","containerName":"pairwise_alignment","kind":13},{"kind":13,"containerName":"pairwise_alignment","name":"$seq2","line":447},{"name":"seq","kind":12,"containerName":"pairwise_alignment","line":447},{"line":448,"name":"$seqstr","containerName":"pairwise_alignment","kind":13},{"name":"$seq2","kind":13,"containerName":"pairwise_alignment","line":449},{"line":449,"name":"new","containerName":"pairwise_alignment","kind":12},{"line":449,"name":"$seq2","kind":13,"containerName":"pairwise_alignment"},{"name":"id","containerName":"pairwise_alignment","kind":12,"line":449},{"kind":13,"containerName":"pairwise_alignment","name":"$seqstr","line":449},{"containerName":"pairwise_alignment","kind":13,"name":"$seq2","line":449},{"line":449,"kind":12,"containerName":"pairwise_alignment","name":"alphabet"},{"containerName":"pairwise_alignment","kind":13,"name":"$self","line":451},{"line":451,"name":"set_memory_and_report","containerName":"pairwise_alignment","kind":12},{"kind":13,"containerName":"pairwise_alignment","name":"$seq1","line":453},{"name":"display_id","kind":12,"containerName":"pairwise_alignment","line":453},{"name":"$seq1","containerName":"pairwise_alignment","kind":13,"line":453},{"line":453,"kind":12,"containerName":"pairwise_alignment","name":"id"},{"line":454,"kind":13,"containerName":"pairwise_alignment","name":"$seq2"},{"name":"display_id","kind":12,"containerName":"pairwise_alignment","line":454},{"containerName":"pairwise_alignment","kind":13,"name":"$seq2","line":454},{"containerName":"pairwise_alignment","kind":12,"name":"id","line":454},{"name":"$seq1","kind":13,"containerName":"pairwise_alignment","line":456},{"line":456,"containerName":"pairwise_alignment","kind":12,"name":"alphabet"},{"line":456,"name":"$seq2","kind":13,"containerName":"pairwise_alignment"},{"line":456,"kind":12,"containerName":"pairwise_alignment","name":"alphabet"},{"name":"$aln","containerName":"pairwise_alignment","kind":13,"line":457},{"name":"$seq1","kind":13,"containerName":"pairwise_alignment","line":457},{"name":"seq","kind":12,"containerName":"pairwise_alignment","line":457},{"line":457,"kind":13,"containerName":"pairwise_alignment","name":"$seq2"},{"line":457,"name":"seq","kind":12,"containerName":"pairwise_alignment"},{"line":457,"containerName":"pairwise_alignment","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"pairwise_alignment","line":457},{"kind":13,"containerName":"pairwise_alignment","name":"$self","line":457},{"line":457,"kind":13,"containerName":"pairwise_alignment","name":"$self"},{"line":457,"kind":13,"containerName":"pairwise_alignment","name":"$self"},{"containerName":"pairwise_alignment","kind":13,"name":"$seq1","line":459},{"containerName":"pairwise_alignment","kind":12,"name":"alphabet","line":459},{"name":"$seq2","containerName":"pairwise_alignment","kind":13,"line":459},{"line":459,"containerName":"pairwise_alignment","kind":12,"name":"alphabet"},{"name":"$aln","kind":13,"containerName":"pairwise_alignment","line":460},{"line":460,"containerName":"pairwise_alignment","kind":13,"name":"$seq1"},{"name":"seq","kind":12,"containerName":"pairwise_alignment","line":460},{"line":460,"kind":13,"containerName":"pairwise_alignment","name":"$seq2"},{"name":"seq","containerName":"pairwise_alignment","kind":12,"line":460},{"kind":13,"containerName":"pairwise_alignment","name":"$self","line":460},{"line":460,"name":"$self","kind":13,"containerName":"pairwise_alignment"},{"name":"$aln","kind":13,"containerName":"pairwise_alignment","line":467},{"containerName":"pairwise_alignment","kind":13,"name":"$aln","line":467},{"line":471,"name":"$out","kind":13,"containerName":"pairwise_alignment"},{"name":"new","containerName":"pairwise_alignment","kind":12,"line":471},{"name":"$out","containerName":"pairwise_alignment","kind":13,"line":473},{"name":"add_seq","kind":12,"containerName":"pairwise_alignment","line":473},{"line":473,"name":"new","kind":12,"containerName":"pairwise_alignment"},{"containerName":"pairwise_alignment","kind":13,"name":"$aln","line":473},{"name":"aln1","containerName":"pairwise_alignment","kind":12,"line":473},{"line":474,"kind":13,"containerName":"pairwise_alignment","name":"$aln"},{"containerName":"pairwise_alignment","kind":12,"name":"start1","line":474},{"line":475,"kind":13,"containerName":"pairwise_alignment","name":"$aln"},{"containerName":"pairwise_alignment","kind":12,"name":"end1","line":475},{"line":476,"containerName":"pairwise_alignment","kind":13,"name":"$seq1"},{"name":"id","kind":12,"containerName":"pairwise_alignment","line":476},{"line":478,"name":"$out","kind":13,"containerName":"pairwise_alignment"},{"line":478,"containerName":"pairwise_alignment","kind":12,"name":"add_seq"},{"name":"new","containerName":"pairwise_alignment","kind":12,"line":478},{"name":"$aln","containerName":"pairwise_alignment","kind":13,"line":478},{"kind":12,"containerName":"pairwise_alignment","name":"aln2","line":478},{"line":479,"containerName":"pairwise_alignment","kind":13,"name":"$aln"},{"name":"start2","kind":12,"containerName":"pairwise_alignment","line":479},{"line":480,"name":"$aln","containerName":"pairwise_alignment","kind":13},{"line":480,"name":"end2","kind":12,"containerName":"pairwise_alignment"},{"line":481,"containerName":"pairwise_alignment","kind":13,"name":"$seq2"},{"line":481,"containerName":"pairwise_alignment","kind":12,"name":"id"},{"kind":13,"containerName":"pairwise_alignment","name":"$out","line":482},{"name":"score","kind":12,"containerName":"pairwise_alignment","line":482},{"line":482,"name":"$aln","containerName":"pairwise_alignment","kind":13},{"line":482,"kind":12,"containerName":"pairwise_alignment","name":"score"},{"name":"$out","kind":13,"containerName":"pairwise_alignment","line":483}],"containerName":"main::","name":"pairwise_alignment"},{"line":444,"containerName":"Seq","kind":12,"name":"Bio"},{"containerName":"Seq","kind":12,"name":"Bio","line":449},{"line":457,"name":"Bio","kind":12,"containerName":"Ext::Align::Align_DNA_Sequences"},{"line":460,"containerName":"Ext::Align::Align_Protein_Sequences","kind":12,"name":"Bio"},{"kind":12,"name":"croak","line":463},{"line":471,"name":"Bio","containerName":"SimpleAlign","kind":12},{"kind":12,"containerName":"LocatableSeq","name":"Bio","line":473},{"kind":12,"containerName":"LocatableSeq","name":"Bio","line":478},{"line":493,"range":{"end":{"character":9999,"line":595},"start":{"line":493,"character":0}},"kind":12,"signature":{"label":"align_and_show($self,$seq1,$seq2,$fh)","documentation":"1;\n## $Id: dpAlign.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n# BioPerl module for Bio::Tools::dpAlign\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Yee Man Chan <ymc@yahoo.com>\n#\n# Copyright Yee Man Chan\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::dpAlign - Perl extension to do pairwise dynamic programming sequence alignment\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::dpAlign;\n  use Bio::SeqIO;\n  use Bio::SimpleAlign;\n  use Bio::AlignIO;\n  use Bio::Matrix::IO;\n\n  $seq1 = Bio::SeqIO->new(-file => $ARGV[0], -format => 'fasta');\n  $seq2 = Bio::SeqIO->new(-file => $ARGV[1], -format => 'fasta');\n\n  # create a dpAlign object\n  # to do global alignment, specify DPALIGN_GLOBAL_MILLER_MYERS\n  # to do ends-free alignment, specify DPALIGN_ENDSFREE_MILLER_MYERS\n  $factory = new dpAlign(-match => 3,\n                     -mismatch => -1,\n                     -gap => 3,\n                     -ext => 1,\n                     -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLER_MYERS);\n\n  # actually do the alignment\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout = Bio::AlignIO->new(-format => 'pfam', -fh => \\*STDOUT);\n  $alnout->write_aln($out);\n\n  # To do protein alignment, set the sequence type to protein\n  # By default all protein alignments are using BLOSUM62 matrix\n  # the gap opening cost is 7 and gap extension is 1. These\n  # values are from ssearch. To use your own custom substitution \n  # matrix, you can create a Bio::Matrix::MatrixI object.\n\n  $parser = Bio::Matrix::IO->new(-format => 'scoring', -file => 'blosum50.mat');\n  $matrix = $parser->next_matrix;\n  $factory = Bio::Tools::dpAlign->new(-matrix => $matrix, -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLERMYERS);\n  $seq1->alphabet('protein');\n  $seq2->alphabet('protein');\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout->write_aln($out);\n\n  # use the factory to make some output\n\n  $factory->align_and_show($seq1, $seq2, STDOUT);\n\n  # use Phil Green's algorithm to calculate the optimal local\n  # alignment score between two sequences quickly. It is very\n  # useful when you are searching a query sequence in a database\n  # of sequences. Since finding a alignment is more costly \n  # than just calculating scores, you can save time if you only \n  # align sequences that have a high alignment score.\n\n  # To use this feature, first you call the sequence_profile function\n  # to obtain the profile of the query sequence.\n  $profile = $factory->sequence_profile($query);\n\n  %scores = ();\n  # Then use a loop to run a database of sequences against the\n  # profile to obtain a table of alignment scores\n  $dbseq = Bio::SeqIO(-file => 'dbseq.fa', -format => 'fasta');\n  while (defined($seq = $dbseq->next_seq)) {\n      $scores{$seq->id} = $factory->pairwise_alignment_score($profile, $seq);\n  }\n\n=head1 DESCRIPTION\n\nDynamic Programming approach is considered to be the most sensitive\nway to align two biological sequences. There are currently three major\ntypes of dynamic programming algorithms: Global Alignment, Local\nAlignment and Ends-free Alignment.\n\nGlobal Alignment compares two sequences in their entirety.  By\ninserting gaps in the two sequences, it aligns two sequences to\nminimize the edit distance as defined by the gap cost function and the\nsubstitution matrix. Global Alignment is generally applied to two\nsequences that are very similar in length and content.\n\nLocal Alignment instead attempts to find out the subsequences that has\nthe minimal edit distance among all possible subsequences.  It is good\nfor sequences that has a stretch of subsequences that are similar to\neach other.\n\nEnds-free Alignment is a special case of Global Alignment. There are\nno gap penalty imposed for the gaps that extended from the end points\nof two sequences. Therefore it will be a good application when you\nthink one sequence is contained by the other or when you think two\nsequences overlap each other.\n\nDynamic Programming was first introduced by Needleman-Wunsch (1970) to\nglobally align two sequences. The idea of local alignment was later\nintroduced by Smith-Waterman (1981). Gotoh (1982) improved both\nalgorithms by introducing auxillary arrays that reduced the time\ncomplexity of the algorithms to O(m*n).  Miller-Myers (1988) exploits\nthe divide-and-conquer idea introduced by Hirschberg (1975) to solve\nthe affine gap cost dynamic programming using only linear space. At\nthe time of this writing, it is accepted that Miller-Myers is the\nfastest single CPU implementation and using the least memory that is\ntruly equivalent to original algorithm introduced by\nNeedleman-Wunsch. According to Aaron Mackey, Phil Green's SWAT\nimplemention introduced a heuristic that does not consider paths\nthrought the matrix where the score would be less than the gap opening\npenalty, yielding a 1.5-2X speedup on most comparisons. to skip the\ncalculation of some cells. However, his approach is only good for\ncalculating the minimum edit distance and find out the corresponding\nsubsequences (aka search phase). Bill Pearson's popular dynamic\nprogramming alignment program SSEARCH uses Phil Green's algorithm to\nfind the subsequences and then Miller-Myers's algorithm to find the\nactual alignment. (aka alignment phase)\n\nThe current implementation supports local alignment of either DNA\nsequences or protein sequences. It allows you to specify either the\nMiller-Myers Global Alignment (DPALIGN_GLOBAL_MILLER_MYERS) or\nMiller-Myers Local Alignment (DPALIGN_LOCAL_MILLER_MYERS). For DNA\nalignment, you can specify the scores for match, mismatch, gap opening\ncost and gap extension cost. For protein alignment, it is using\nBLOSUM62 by default. Currently the substitution matrix is not\nconfigurable.\n\nNote: If you supply LocatableSeq objects to pairwise_alignment,\npairwise_alignment_score, align_and_show or sequence_profile and\nthe sequence supplied contains gaps, these functions will treat \nthese sequences as if they are without gaps.\n\n=head1 DEPENDENCIES\n\nThis package comes with the main bioperl distribution. You also need\nto install the lastest bioperl-ext package which contains the XS code\nthat implements the algorithms. This package won't work if you haven't\ncompiled the bioperl-ext package.\n\n=head1 TO-DO\n\n\n=over 3\n\n* 1.\n\nBasic support for IUPAC code for DNA sequence is now implemented. \nX will mismatch any character. T will match U. For others, whenever\nthere is a possibility for match, it is considered a full match, for\nexample, W will match B.\n\n* 2.\n\nAllow custom substitution matrix for DNA. Note that for proteins, you\ncan now use your own subsitution matirx.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n        This implementation was written by Yee Man Chan (ymc@yahoo.com).\n        Copyright (c) 2003 Yee Man Chan. All rights reserved. This program\n        is free software; you can redistribute it and/or modify it under\n        the same terms as Perl itself. Special thanks to Aaron Mackey\n        and WIlliam Pearson for the helpful discussions. [The portion\n        of code inside pgreen subdirectory was borrowed from ssearch. It\n        should be distributed in the same terms as ssearch.]\n\n\npackage Bio::Tools::dpAlign;\n\nuse Bio::SimpleAlign;\n\nuse base qw(Bio::Tools::AlignFactory);\n\n# Gotoh algorithm as defined in J. Mol. Biol. (1982) 162, 705-708\n# use constant DSW_GOTOH => 1;\n# Hirschberg's algorithm as defined in Myers & Miller in \n# CABIOS, Vol 4, No. 1, 1988, p 11-17\n# This algorithm is used in both the search phase and the\n# alignment phase.\nuse constant DPALIGN_LOCAL_MILLER_MYERS => 1;\nuse constant DPALIGN_GLOBAL_MILLER_MYERS => 2;\nuse constant DPALIGN_ENDSFREE_MILLER_MYERS => 3;\n# my toy algorithm that tries to do SW as fast as possible\n# use constant DSW_FSW => 3; \n# Phil Green's approximation to Smith-Waterman. It avoid calculations\n# that might result in a score less than the opening gap penalty.\n# This is the algorithm used by ssearch. Phil Green's algorithm is\n# used in the search phase while Miller-Myers algorithm is used in\n# the alignment phase\n#use constant DPALIGN_LOCAL_GREEN => 2; \n\nBEGIN {\n    eval {\n        require Bio::Ext::Align;\n    };\n    if ( $@ ) {\n        die(\"\\nThe C-compiled engine for Smith Waterman alignments (Align) has not been installed.\\n Please read the install the bioperl-ext package\\n\\n\");\n        exit(1);\n    }\n}\n\nsub new {\n   my ($class, @args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   my ($match, $mismatch, $gap, $ext, $alg, $matrix) = $self->_rearrange([qw(MATCH\n\t\t\t\t\t\t\t\tMISMATCH\n\t\t\t\t\t\t\t\tGAP\n\t\t\t\t\t\t\t\tEXT\n\t\t\t\t\t\t\t\tALG\n\t\t\t\t\t\t\t\tMATRIX\t\n\t\t\t\t\t\t\t)], @args);\n\n   $self->match(3) unless defined $match;\n   $self->mismatch(-1) unless defined $mismatch;\n   $self->gap(3) unless defined $gap;\n   $self->ext(1) unless defined $ext;\n   $self->alg(DPALIGN_LOCAL_MILLER_MYERS) unless defined $alg;\n\n   if (defined $match) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->match($match);\n\t}\n\telse {\n\t    $self->throw(\"Match score must be a number, not [$match]\");\n\t}\n    }\n\n    if (defined $mismatch) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->mismatch($mismatch);\n\t}\n\telse {\n\t    $self->throw(\"Mismatch penalty must be a number, not [$mismatch]\");\n\t}\n    }\n\n    if (defined $gap) {\n\tif ($gap =~ /^\\d+$/) {\n\t    $self->gap($gap);\n\t}\n\telse {\n\t    $self->throw(\"Gap penalty must be a number, not [$gap]\");\n\t}\n    }\n\n    if (defined $ext) {\n\tif ($ext =~ /^\\d+$/) {\n\t    $self->ext($ext);\n\t}\n\telse {\n\t    $self->throw(\"Extension penalty must be a number, not [$ext]\");\n\t}\n    }\n\n    if (defined $alg) {\n\tif ($alg == DPALIGN_LOCAL_MILLER_MYERS or $alg == DPALIGN_GLOBAL_MILLER_MYERS or $alg == DPALIGN_ENDSFREE_MILLER_MYERS) {\n\t    $self->alg($alg);\n\t}\n\telse {\n\t    $self->throw(\"Algorithm must be either 1, 2 or 3\");\n\t}\n    }\n\n    if (defined $matrix and $matrix->isa('Bio::Matrix::MatrixI')) {\n        $self->{'matrix'} = Bio::Ext::Align::ScoringMatrix->new(join(\"\", $matrix->row_names), $self->gap, $self->ext);\n        foreach $rowname ($matrix->row_names) {\n            foreach $colname ($matrix->column_names) {\n                Bio::Ext::Align::ScoringMatrix->set_entry($self->{'matrix'}, $rowname, $colname, $matrix->entry($rowname, $colname));\n            }\n        }\n    }\n    else {\n        $self->{'matrix'} = 0;\n    }\n\n    return $self;\n}\n\n=head2 sequence_profile\n\n Title   : sequence_profile\n Usage   : $prof = $factory->sequence_profile($seq1)\n Function: Makes a dpAlign_SequenceProfile object from one sequence\n Returns : A dpAlign_SequenceProfile object\n Args    : The lone argument is a Bio::PrimarySeqI that we want to \n\t   build a profile for. Usually, this would be the Query sequence\n\n\nsub sequence_profile {\n    my ($self, $seq1) = @_;\n\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI')) {\n        $self->warn(\"Cannot call sequence_profilewithout specifing one sequence (Bio::PrimarySeqI object)\");\n        return;\n    }\n\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2) {\n        $self->warn(\"cannot create sequence profile with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n\n    if ($seq1->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::SequenceProfile->dna_new($seq1->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'});\n    }\n    elsif ($seq1->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::SequenceProfile->protein_new($seq1->seq, $self->{'matrix'}); \n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment_score\n\n Title   : pairwise_alignment_score\n Usage   : $score = $factory->pairwise_alignment_score($prof,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : An integer that is the score of the optimal alignment.\n Args    : The first argument is the sequence profile obtained from a\n\t   call to the sequence_profile function. The second argument \n\t   is a Bio::PrimarySeqI object to be aligned. The second argument\n\t   is usually a sequence in the database sequence. Note\n\t   that this function only uses Phil Green's algorithm and \n\t   therefore theoretically may not always give you the optimal\n\t   score.\n\n\nsub pairwise_alignment_score {\n    my ($self, $prof, $seq2) = @_;\n\n    if( ! defined $prof || ! $prof->isa('Bio::Ext::Align::SequenceProfile') || \n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment_score without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq2->length() < 2) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($prof->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::Score_DNA_Sequences($prof, $seq2->seq);\n    }\n    elsif ($prof->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::Score_Protein_Sequences($prof, $seq2->seq);\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment\n\n Title   : pairwise_alignment\n Usage   : $aln = $factory->pairwise_alignment($seq1,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : A SimpleAlign object if there is an alignment with positive\n\t   score. Otherwise, return undef.\n Args    : The first and second arguments are both Bio::PrimarySeqI\n\t   objects that are to be aligned.\n\n\nsub pairwise_alignment {\n    my ($self, $seq1, $seq2) = @_;\n    my ($aln, $out);\n\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 ||\n        $seq2->length() < 2 ) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($seq1->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\t$aln = Bio::Ext::Align::Align_DNA_Sequences($seq1->seq, $seq2->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'}, $self->{'alg'});\n    }\n    elsif ($seq1->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\t$aln = Bio::Ext::Align::Align_Protein_Sequences($seq1->seq, $seq2->seq, $self->{'matrix'}, $self->{'alg'});\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n\n    if (not defined $aln or $aln == 0) {\n\treturn;\n    }\n\n    $out = Bio::SimpleAlign->new();\n\n    $out->add_seq(Bio::LocatableSeq->new(-seq => $aln->aln1,\n\t\t\t\t\t -start => $aln->start1,\n\t\t\t\t\t -end => $aln->end1,\n\t\t\t\t\t -id => $seq1->id));\n    \n    $out->add_seq(Bio::LocatableSeq->new(-seq => $aln->aln2,\n\t\t\t\t\t -start => $aln->start2,\n\t\t\t\t\t -end => $aln->end2,\n\t\t\t\t\t -id => $seq2->id));\n    $out->score($aln->score);\n    return $out;\n}\n\n=head2 align_and_show\n\n Title   : align_and_show\n Usage   : $factory->align_and_show($seq1,$seq2,STDOUT)","parameters":[{"label":"$self"},{"label":"$seq1"},{"label":"$seq2"},{"label":"$fh"}]},"children":[{"definition":"my","containerName":"align_and_show","localvar":"my","kind":13,"name":"$self","line":494},{"line":494,"name":"$seq1","containerName":"align_and_show","kind":13},{"kind":13,"containerName":"align_and_show","name":"$seq2","line":494},{"kind":13,"containerName":"align_and_show","name":"$fh","line":494},{"definition":"my","kind":13,"localvar":"my","containerName":"align_and_show","name":"$aln","line":495},{"line":495,"containerName":"align_and_show","kind":13,"name":"$out"},{"name":"$fh","kind":13,"containerName":"align_and_show","line":497},{"kind":13,"containerName":"align_and_show","name":"$fh","line":498},{"line":500,"kind":13,"containerName":"align_and_show","name":"$seq1"},{"kind":13,"containerName":"align_and_show","name":"$seq1","line":500},{"containerName":"align_and_show","kind":12,"name":"isa","line":500},{"name":"$seq2","containerName":"align_and_show","kind":13,"line":501},{"line":501,"containerName":"align_and_show","kind":13,"name":"$seq2"},{"containerName":"align_and_show","kind":12,"name":"isa","line":501},{"line":502,"name":"$self","kind":13,"containerName":"align_and_show"},{"containerName":"align_and_show","kind":12,"name":"warn","line":502},{"name":"$seq1","containerName":"align_and_show","kind":13,"line":506},{"kind":12,"containerName":"align_and_show","name":"length","line":506},{"line":507,"kind":13,"containerName":"align_and_show","name":"$seq2"},{"name":"length","containerName":"align_and_show","kind":12,"line":507},{"line":508,"kind":13,"containerName":"align_and_show","name":"$self"},{"line":508,"kind":12,"containerName":"align_and_show","name":"warn"},{"kind":13,"containerName":"align_and_show","name":"$seq1","line":511},{"line":511,"name":"isa","containerName":"align_and_show","kind":12},{"definition":"my","localvar":"my","kind":13,"containerName":"align_and_show","name":"$seqstr","line":512},{"line":512,"name":"$seq1","containerName":"align_and_show","kind":13},{"name":"seq","containerName":"align_and_show","kind":12,"line":512},{"line":513,"name":"$seqstr","kind":13,"containerName":"align_and_show"},{"name":"$seq1","kind":13,"containerName":"align_and_show","line":514},{"name":"new","kind":12,"containerName":"align_and_show","line":514},{"name":"$seq1","containerName":"align_and_show","kind":13,"line":514},{"line":514,"name":"id","containerName":"align_and_show","kind":12},{"name":"$seqstr","kind":13,"containerName":"align_and_show","line":514},{"name":"$seq1","kind":13,"containerName":"align_and_show","line":514},{"line":514,"name":"alphabet","kind":12,"containerName":"align_and_show"},{"line":516,"name":"$seq2","containerName":"align_and_show","kind":13},{"line":516,"name":"isa","containerName":"align_and_show","kind":12},{"line":517,"name":"$seqstr","containerName":"align_and_show","localvar":"my","kind":13,"definition":"my"},{"name":"$seq2","containerName":"align_and_show","kind":13,"line":517},{"line":517,"kind":12,"containerName":"align_and_show","name":"seq"},{"name":"$seqstr","kind":13,"containerName":"align_and_show","line":518},{"line":519,"containerName":"align_and_show","kind":13,"name":"$seq2"},{"line":519,"name":"new","kind":12,"containerName":"align_and_show"},{"line":519,"kind":13,"containerName":"align_and_show","name":"$seq2"},{"containerName":"align_and_show","kind":12,"name":"id","line":519},{"line":519,"containerName":"align_and_show","kind":13,"name":"$seqstr"},{"line":519,"name":"$seq2","kind":13,"containerName":"align_and_show"},{"name":"alphabet","containerName":"align_and_show","kind":12,"line":519},{"containerName":"align_and_show","kind":13,"name":"$self","line":521},{"kind":12,"containerName":"align_and_show","name":"set_memory_and_report","line":521},{"line":523,"containerName":"align_and_show","kind":13,"name":"$seq1"},{"name":"display_id","containerName":"align_and_show","kind":12,"line":523},{"line":523,"kind":13,"containerName":"align_and_show","name":"$seq1"},{"line":523,"kind":12,"containerName":"align_and_show","name":"id"},{"name":"$seq2","kind":13,"containerName":"align_and_show","line":524},{"line":524,"containerName":"align_and_show","kind":12,"name":"display_id"},{"name":"$seq2","kind":13,"containerName":"align_and_show","line":524},{"name":"id","kind":12,"containerName":"align_and_show","line":524},{"name":"$seq1","containerName":"align_and_show","kind":13,"line":526},{"name":"alphabet","containerName":"align_and_show","kind":12,"line":526},{"containerName":"align_and_show","kind":13,"name":"$seq2","line":526},{"line":526,"name":"alphabet","kind":12,"containerName":"align_and_show"},{"kind":13,"containerName":"align_and_show","name":"$aln","line":527},{"line":527,"kind":13,"containerName":"align_and_show","name":"$seq1"},{"name":"seq","containerName":"align_and_show","kind":12,"line":527},{"line":527,"kind":13,"containerName":"align_and_show","name":"$seq2"},{"name":"seq","kind":12,"containerName":"align_and_show","line":527},{"line":527,"kind":13,"containerName":"align_and_show","name":"$self"},{"name":"$self","kind":13,"containerName":"align_and_show","line":527},{"name":"$self","containerName":"align_and_show","kind":13,"line":527},{"line":527,"name":"$self","containerName":"align_and_show","kind":13},{"name":"$self","containerName":"align_and_show","kind":13,"line":527},{"name":"$seq1","containerName":"align_and_show","kind":13,"line":529},{"name":"alphabet","kind":12,"containerName":"align_and_show","line":529},{"containerName":"align_and_show","kind":13,"name":"$seq2","line":529},{"line":529,"containerName":"align_and_show","kind":12,"name":"alphabet"},{"line":530,"name":"$aln","kind":13,"containerName":"align_and_show"},{"name":"$seq1","containerName":"align_and_show","kind":13,"line":530},{"line":530,"name":"seq","kind":12,"containerName":"align_and_show"},{"line":530,"name":"$seq2","kind":13,"containerName":"align_and_show"},{"name":"seq","kind":12,"containerName":"align_and_show","line":530},{"containerName":"align_and_show","kind":13,"name":"$self","line":530},{"kind":13,"containerName":"align_and_show","name":"$self","line":530},{"line":536,"name":"$out","containerName":"align_and_show","kind":13},{"containerName":"align_and_show","kind":12,"name":"new","line":536},{"definition":"my","name":"$s1","kind":13,"localvar":"my","containerName":"align_and_show","line":537},{"kind":12,"containerName":"align_and_show","name":"new","line":537},{"definition":"my","line":538,"localvar":"my","containerName":"align_and_show","kind":13,"name":"$s2"},{"line":538,"kind":12,"containerName":"align_and_show","name":"new"},{"localvar":"my","kind":13,"containerName":"align_and_show","name":"$a1","line":539,"definition":"my"},{"line":539,"name":"$aln","containerName":"align_and_show","kind":13},{"line":539,"name":"aln1","containerName":"align_and_show","kind":12},{"definition":"my","name":"$a2","localvar":"my","kind":13,"containerName":"align_and_show","line":540},{"name":"$aln","kind":13,"containerName":"align_and_show","line":540},{"kind":12,"containerName":"align_and_show","name":"aln2","line":540},{"line":541,"name":"$first_col","localvar":"my","containerName":"align_and_show","kind":13,"definition":"my"},{"definition":"my","line":542,"name":"$last_col","kind":13,"localvar":"my","containerName":"align_and_show"},{"line":543,"localvar":"my","containerName":"align_and_show","kind":13,"name":"$col","definition":"my"},{"definition":"my","name":"$alu1","localvar":"my","kind":13,"containerName":"align_and_show","line":544},{"definition":"my","name":"$alu2","containerName":"align_and_show","localvar":"my","kind":13,"line":545},{"name":"$g1","localvar":"my","containerName":"align_and_show","kind":13,"line":546,"definition":"my"},{"kind":13,"localvar":"my","containerName":"align_and_show","name":"$g2","line":547,"definition":"my"},{"definition":"my","line":550,"name":"$i","localvar":"my","kind":13,"containerName":"align_and_show"},{"name":"$i","kind":13,"containerName":"align_and_show","line":550},{"name":"$a1","kind":13,"containerName":"align_and_show","line":550},{"containerName":"align_and_show","kind":13,"name":"$i","line":550},{"line":551,"name":"$col","containerName":"align_and_show","kind":13},{"name":"new","kind":12,"containerName":"align_and_show","line":551},{"kind":13,"containerName":"align_and_show","name":"$alu1","line":552},{"kind":12,"containerName":"align_and_show","name":"new","line":552},{"containerName":"align_and_show","kind":13,"name":"$alu2","line":553},{"line":553,"kind":12,"containerName":"align_and_show","name":"new"},{"name":"$first_col","kind":13,"containerName":"align_and_show","line":554},{"kind":13,"containerName":"align_and_show","name":"$col","line":554},{"containerName":"align_and_show","kind":13,"name":"$first_col","line":554},{"line":555,"name":"$last_col","containerName":"align_and_show","kind":13},{"line":555,"containerName":"align_and_show","kind":13,"name":"$col"},{"line":555,"kind":13,"containerName":"align_and_show","name":"$last_col"},{"line":557,"containerName":"align_and_show","kind":13,"name":"$a1"},{"containerName":"align_and_show","kind":13,"name":"$i","line":557},{"line":558,"name":"$alu1","kind":13,"containerName":"align_and_show"},{"name":"$alu2","kind":13,"containerName":"align_and_show","line":559},{"kind":13,"containerName":"align_and_show","name":"$g1","line":560},{"kind":13,"containerName":"align_and_show","name":"$a2","line":562},{"name":"$i","containerName":"align_and_show","kind":13,"line":562},{"line":563,"name":"$alu1","containerName":"align_and_show","kind":13},{"containerName":"align_and_show","kind":13,"name":"$alu2","line":564},{"line":565,"kind":13,"containerName":"align_and_show","name":"$g2"},{"line":568,"kind":13,"containerName":"align_and_show","name":"$alu1"},{"line":569,"containerName":"align_and_show","kind":13,"name":"$alu2"},{"line":572,"name":"$alu1","kind":13,"containerName":"align_and_show"},{"line":572,"kind":13,"containerName":"align_and_show","name":"$aln"},{"line":572,"kind":12,"containerName":"align_and_show","name":"start1"},{"containerName":"align_and_show","kind":13,"name":"$i","line":572},{"line":572,"containerName":"align_and_show","kind":13,"name":"$g1"},{"name":"$alu1","kind":13,"containerName":"align_and_show","line":573},{"line":573,"containerName":"align_and_show","kind":13,"name":"$aln"},{"line":573,"kind":12,"containerName":"align_and_show","name":"start1"},{"name":"$i","kind":13,"containerName":"align_and_show","line":573},{"containerName":"align_and_show","kind":13,"name":"$g1","line":573},{"line":574,"kind":13,"containerName":"align_and_show","name":"$alu2"},{"kind":13,"containerName":"align_and_show","name":"$aln","line":574},{"line":574,"containerName":"align_and_show","kind":12,"name":"start2"},{"line":574,"containerName":"align_and_show","kind":13,"name":"$i"},{"name":"$g2","kind":13,"containerName":"align_and_show","line":574},{"line":575,"name":"$alu2","containerName":"align_and_show","kind":13},{"name":"$aln","kind":13,"containerName":"align_and_show","line":575},{"containerName":"align_and_show","kind":12,"name":"start2","line":575},{"containerName":"align_and_show","kind":13,"name":"$i","line":575},{"name":"$g2","kind":13,"containerName":"align_and_show","line":575},{"line":576,"kind":13,"containerName":"align_and_show","name":"$col"},{"line":576,"containerName":"align_and_show","kind":13,"name":"$alu1"},{"line":577,"kind":13,"containerName":"align_and_show","name":"$col"},{"containerName":"align_and_show","kind":13,"name":"$alu2","line":577},{"name":"$last_col","containerName":"align_and_show","kind":13,"line":578},{"containerName":"align_and_show","kind":13,"name":"$col","line":578},{"name":"$out","kind":13,"containerName":"align_and_show","line":580},{"line":580,"name":"$first_col","kind":13,"containerName":"align_and_show"},{"name":"$col","kind":13,"containerName":"align_and_show","line":581},{"name":"new","kind":12,"containerName":"align_and_show","line":581},{"line":582,"name":"$alu1","kind":13,"containerName":"align_and_show"},{"line":582,"name":"new","kind":12,"containerName":"align_and_show"},{"containerName":"align_and_show","kind":13,"name":"$alu2","line":583},{"name":"new","containerName":"align_and_show","kind":12,"line":583},{"name":"$alu1","kind":13,"containerName":"align_and_show","line":584},{"line":584,"containerName":"align_and_show","kind":13,"name":"$aln"},{"containerName":"align_and_show","kind":12,"name":"end1","line":584},{"kind":13,"containerName":"align_and_show","name":"$alu1","line":585},{"line":585,"name":"$aln","containerName":"align_and_show","kind":13},{"name":"end1","kind":12,"containerName":"align_and_show","line":585},{"kind":13,"containerName":"align_and_show","name":"$alu1","line":586},{"name":"$alu2","kind":13,"containerName":"align_and_show","line":587},{"line":587,"containerName":"align_and_show","kind":13,"name":"$aln"},{"line":587,"containerName":"align_and_show","kind":12,"name":"end2"},{"line":588,"name":"$alu2","kind":13,"containerName":"align_and_show"},{"line":588,"kind":13,"containerName":"align_and_show","name":"$aln"},{"kind":12,"containerName":"align_and_show","name":"end2","line":588},{"line":589,"name":"$alu2","containerName":"align_and_show","kind":13},{"kind":13,"containerName":"align_and_show","name":"$col","line":590},{"kind":13,"containerName":"align_and_show","name":"$alu1","line":590},{"line":591,"containerName":"align_and_show","kind":13,"name":"$col"},{"line":591,"containerName":"align_and_show","kind":13,"name":"$alu2"},{"line":592,"kind":13,"containerName":"align_and_show","name":"$last_col"},{"line":592,"containerName":"align_and_show","kind":13,"name":"$col"},{"kind":13,"containerName":"align_and_show","name":"$out","line":594},{"line":594,"name":"$seq1","containerName":"align_and_show","kind":13},{"containerName":"align_and_show","kind":12,"name":"id","line":594},{"line":594,"name":"$seq1","kind":13,"containerName":"align_and_show"},{"kind":12,"containerName":"align_and_show","name":"seq","line":594},{"name":"$seq2","containerName":"align_and_show","kind":13,"line":594},{"containerName":"align_and_show","kind":12,"name":"id","line":594},{"line":594,"kind":13,"containerName":"align_and_show","name":"$seq2"},{"line":594,"containerName":"align_and_show","kind":12,"name":"seq"},{"containerName":"align_and_show","kind":13,"name":"$fh","line":594}],"containerName":"main::","name":"align_and_show","definition":"sub","detail":"($self,$seq1,$seq2,$fh)"},{"kind":12,"containerName":"Seq","name":"Bio","line":514},{"containerName":"Seq","kind":12,"name":"Bio","line":519},{"line":527,"kind":12,"containerName":"Ext::Align::Align_DNA_Sequences","name":"Bio"},{"name":"Bio","kind":12,"containerName":"Ext::Align::Align_Protein_Sequences","line":530},{"line":533,"kind":12,"name":"croak"},{"name":"Bio","containerName":"Ext::Align::AlnBlock","kind":12,"line":536},{"name":"Bio","kind":12,"containerName":"Ext::Align::AlnSequence","line":537},{"kind":12,"containerName":"Ext::Align::AlnSequence","name":"Bio","line":538},{"containerName":"Ext::Align::AlnColumn","kind":12,"name":"Bio","line":551},{"line":552,"name":"Bio","kind":12,"containerName":"Ext::Align::AlnUnit"},{"kind":12,"containerName":"Ext::Align::AlnUnit","name":"Bio","line":553},{"line":555,"name":"Bio","containerName":"Ext::Align::AlnColumn::set_next","kind":12},{"name":"Bio","kind":12,"containerName":"Ext::Align::AlnUnit::set_text_label","line":558},{"line":559,"containerName":"Ext::Align::AlnUnit::set_text_label","kind":12,"name":"Bio"},{"line":563,"kind":12,"containerName":"Ext::Align::AlnUnit::set_text_label","name":"Bio"},{"line":564,"name":"Bio","containerName":"Ext::Align::AlnUnit::set_text_label","kind":12},{"line":568,"name":"Bio","kind":12,"containerName":"Ext::Align::AlnUnit::set_text_label"},{"name":"Bio","kind":12,"containerName":"Ext::Align::AlnUnit::set_text_label","line":569},{"line":572,"name":"Bio","containerName":"Ext::Align::AlnUnit::set_start","kind":12},{"name":"Bio","containerName":"Ext::Align::AlnUnit::set_end","kind":12,"line":573},{"line":574,"containerName":"Ext::Align::AlnUnit::set_start","kind":12,"name":"Bio"},{"line":575,"name":"Bio","containerName":"Ext::Align::AlnUnit::set_end","kind":12},{"line":576,"name":"Bio","kind":12,"containerName":"Ext::Align::AlnColumn::add_alu"},{"kind":12,"containerName":"Ext::Align::AlnColumn::add_alu","name":"Bio","line":577},{"line":580,"name":"Bio","kind":12,"containerName":"Ext::Align::AlnBlock::set_start"},{"name":"Bio","containerName":"Ext::Align::AlnColumn","kind":12,"line":581},{"line":582,"name":"Bio","kind":12,"containerName":"Ext::Align::AlnUnit"},{"line":583,"containerName":"Ext::Align::AlnUnit","kind":12,"name":"Bio"},{"name":"Bio","containerName":"Ext::Align::AlnUnit::set_start","kind":12,"line":584},{"kind":12,"containerName":"Ext::Align::AlnUnit::set_end","name":"Bio","line":585},{"name":"Bio","kind":12,"containerName":"Ext::Align::AlnUnit::set_text_label","line":586},{"line":587,"name":"Bio","containerName":"Ext::Align::AlnUnit::set_start","kind":12},{"name":"Bio","containerName":"Ext::Align::AlnUnit::set_end","kind":12,"line":588},{"name":"Bio","kind":12,"containerName":"Ext::Align::AlnUnit::set_text_label","line":589},{"name":"Bio","containerName":"Ext::Align::AlnColumn::add_alu","kind":12,"line":590},{"kind":12,"containerName":"Ext::Align::AlnColumn::add_alu","name":"Bio","line":591},{"containerName":"Ext::Align::AlnColumn::set_next","kind":12,"name":"Bio","line":592},{"kind":12,"containerName":"Ext::Align::write_pretty_str_align","name":"Bio","line":594},{"detail":"($self,$val)","definition":"sub","containerName":"main::","name":"match","children":[{"definition":"my","line":610,"name":"$self","containerName":"match","localvar":"my","kind":13},{"line":610,"kind":13,"containerName":"match","name":"$val"},{"line":613,"name":"$val","containerName":"match","kind":13},{"name":"$val","containerName":"match","kind":13,"line":614},{"line":615,"name":"$self","containerName":"match","kind":13},{"line":615,"name":"throw","kind":12,"containerName":"match"},{"line":617,"name":"$self","kind":13,"containerName":"match"},{"line":617,"name":"$val","kind":13,"containerName":"match"},{"line":619,"name":"$self","kind":13,"containerName":"match"}],"signature":{"documentation":"1;\n## $Id: dpAlign.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n# BioPerl module for Bio::Tools::dpAlign\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Yee Man Chan <ymc@yahoo.com>\n#\n# Copyright Yee Man Chan\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::dpAlign - Perl extension to do pairwise dynamic programming sequence alignment\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::dpAlign;\n  use Bio::SeqIO;\n  use Bio::SimpleAlign;\n  use Bio::AlignIO;\n  use Bio::Matrix::IO;\n\n  $seq1 = Bio::SeqIO->new(-file => $ARGV[0], -format => 'fasta');\n  $seq2 = Bio::SeqIO->new(-file => $ARGV[1], -format => 'fasta');\n\n  # create a dpAlign object\n  # to do global alignment, specify DPALIGN_GLOBAL_MILLER_MYERS\n  # to do ends-free alignment, specify DPALIGN_ENDSFREE_MILLER_MYERS\n  $factory = new dpAlign(-match => 3,\n                     -mismatch => -1,\n                     -gap => 3,\n                     -ext => 1,\n                     -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLER_MYERS);\n\n  # actually do the alignment\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout = Bio::AlignIO->new(-format => 'pfam', -fh => \\*STDOUT);\n  $alnout->write_aln($out);\n\n  # To do protein alignment, set the sequence type to protein\n  # By default all protein alignments are using BLOSUM62 matrix\n  # the gap opening cost is 7 and gap extension is 1. These\n  # values are from ssearch. To use your own custom substitution \n  # matrix, you can create a Bio::Matrix::MatrixI object.\n\n  $parser = Bio::Matrix::IO->new(-format => 'scoring', -file => 'blosum50.mat');\n  $matrix = $parser->next_matrix;\n  $factory = Bio::Tools::dpAlign->new(-matrix => $matrix, -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLERMYERS);\n  $seq1->alphabet('protein');\n  $seq2->alphabet('protein');\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout->write_aln($out);\n\n  # use the factory to make some output\n\n  $factory->align_and_show($seq1, $seq2, STDOUT);\n\n  # use Phil Green's algorithm to calculate the optimal local\n  # alignment score between two sequences quickly. It is very\n  # useful when you are searching a query sequence in a database\n  # of sequences. Since finding a alignment is more costly \n  # than just calculating scores, you can save time if you only \n  # align sequences that have a high alignment score.\n\n  # To use this feature, first you call the sequence_profile function\n  # to obtain the profile of the query sequence.\n  $profile = $factory->sequence_profile($query);\n\n  %scores = ();\n  # Then use a loop to run a database of sequences against the\n  # profile to obtain a table of alignment scores\n  $dbseq = Bio::SeqIO(-file => 'dbseq.fa', -format => 'fasta');\n  while (defined($seq = $dbseq->next_seq)) {\n      $scores{$seq->id} = $factory->pairwise_alignment_score($profile, $seq);\n  }\n\n=head1 DESCRIPTION\n\nDynamic Programming approach is considered to be the most sensitive\nway to align two biological sequences. There are currently three major\ntypes of dynamic programming algorithms: Global Alignment, Local\nAlignment and Ends-free Alignment.\n\nGlobal Alignment compares two sequences in their entirety.  By\ninserting gaps in the two sequences, it aligns two sequences to\nminimize the edit distance as defined by the gap cost function and the\nsubstitution matrix. Global Alignment is generally applied to two\nsequences that are very similar in length and content.\n\nLocal Alignment instead attempts to find out the subsequences that has\nthe minimal edit distance among all possible subsequences.  It is good\nfor sequences that has a stretch of subsequences that are similar to\neach other.\n\nEnds-free Alignment is a special case of Global Alignment. There are\nno gap penalty imposed for the gaps that extended from the end points\nof two sequences. Therefore it will be a good application when you\nthink one sequence is contained by the other or when you think two\nsequences overlap each other.\n\nDynamic Programming was first introduced by Needleman-Wunsch (1970) to\nglobally align two sequences. The idea of local alignment was later\nintroduced by Smith-Waterman (1981). Gotoh (1982) improved both\nalgorithms by introducing auxillary arrays that reduced the time\ncomplexity of the algorithms to O(m*n).  Miller-Myers (1988) exploits\nthe divide-and-conquer idea introduced by Hirschberg (1975) to solve\nthe affine gap cost dynamic programming using only linear space. At\nthe time of this writing, it is accepted that Miller-Myers is the\nfastest single CPU implementation and using the least memory that is\ntruly equivalent to original algorithm introduced by\nNeedleman-Wunsch. According to Aaron Mackey, Phil Green's SWAT\nimplemention introduced a heuristic that does not consider paths\nthrought the matrix where the score would be less than the gap opening\npenalty, yielding a 1.5-2X speedup on most comparisons. to skip the\ncalculation of some cells. However, his approach is only good for\ncalculating the minimum edit distance and find out the corresponding\nsubsequences (aka search phase). Bill Pearson's popular dynamic\nprogramming alignment program SSEARCH uses Phil Green's algorithm to\nfind the subsequences and then Miller-Myers's algorithm to find the\nactual alignment. (aka alignment phase)\n\nThe current implementation supports local alignment of either DNA\nsequences or protein sequences. It allows you to specify either the\nMiller-Myers Global Alignment (DPALIGN_GLOBAL_MILLER_MYERS) or\nMiller-Myers Local Alignment (DPALIGN_LOCAL_MILLER_MYERS). For DNA\nalignment, you can specify the scores for match, mismatch, gap opening\ncost and gap extension cost. For protein alignment, it is using\nBLOSUM62 by default. Currently the substitution matrix is not\nconfigurable.\n\nNote: If you supply LocatableSeq objects to pairwise_alignment,\npairwise_alignment_score, align_and_show or sequence_profile and\nthe sequence supplied contains gaps, these functions will treat \nthese sequences as if they are without gaps.\n\n=head1 DEPENDENCIES\n\nThis package comes with the main bioperl distribution. You also need\nto install the lastest bioperl-ext package which contains the XS code\nthat implements the algorithms. This package won't work if you haven't\ncompiled the bioperl-ext package.\n\n=head1 TO-DO\n\n\n=over 3\n\n* 1.\n\nBasic support for IUPAC code for DNA sequence is now implemented. \nX will mismatch any character. T will match U. For others, whenever\nthere is a possibility for match, it is considered a full match, for\nexample, W will match B.\n\n* 2.\n\nAllow custom substitution matrix for DNA. Note that for proteins, you\ncan now use your own subsitution matirx.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n        This implementation was written by Yee Man Chan (ymc@yahoo.com).\n        Copyright (c) 2003 Yee Man Chan. All rights reserved. This program\n        is free software; you can redistribute it and/or modify it under\n        the same terms as Perl itself. Special thanks to Aaron Mackey\n        and WIlliam Pearson for the helpful discussions. [The portion\n        of code inside pgreen subdirectory was borrowed from ssearch. It\n        should be distributed in the same terms as ssearch.]\n\n\npackage Bio::Tools::dpAlign;\n\nuse Bio::SimpleAlign;\n\nuse base qw(Bio::Tools::AlignFactory);\n\n# Gotoh algorithm as defined in J. Mol. Biol. (1982) 162, 705-708\n# use constant DSW_GOTOH => 1;\n# Hirschberg's algorithm as defined in Myers & Miller in \n# CABIOS, Vol 4, No. 1, 1988, p 11-17\n# This algorithm is used in both the search phase and the\n# alignment phase.\nuse constant DPALIGN_LOCAL_MILLER_MYERS => 1;\nuse constant DPALIGN_GLOBAL_MILLER_MYERS => 2;\nuse constant DPALIGN_ENDSFREE_MILLER_MYERS => 3;\n# my toy algorithm that tries to do SW as fast as possible\n# use constant DSW_FSW => 3; \n# Phil Green's approximation to Smith-Waterman. It avoid calculations\n# that might result in a score less than the opening gap penalty.\n# This is the algorithm used by ssearch. Phil Green's algorithm is\n# used in the search phase while Miller-Myers algorithm is used in\n# the alignment phase\n#use constant DPALIGN_LOCAL_GREEN => 2; \n\nBEGIN {\n    eval {\n        require Bio::Ext::Align;\n    };\n    if ( $@ ) {\n        die(\"\\nThe C-compiled engine for Smith Waterman alignments (Align) has not been installed.\\n Please read the install the bioperl-ext package\\n\\n\");\n        exit(1);\n    }\n}\n\nsub new {\n   my ($class, @args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   my ($match, $mismatch, $gap, $ext, $alg, $matrix) = $self->_rearrange([qw(MATCH\n\t\t\t\t\t\t\t\tMISMATCH\n\t\t\t\t\t\t\t\tGAP\n\t\t\t\t\t\t\t\tEXT\n\t\t\t\t\t\t\t\tALG\n\t\t\t\t\t\t\t\tMATRIX\t\n\t\t\t\t\t\t\t)], @args);\n\n   $self->match(3) unless defined $match;\n   $self->mismatch(-1) unless defined $mismatch;\n   $self->gap(3) unless defined $gap;\n   $self->ext(1) unless defined $ext;\n   $self->alg(DPALIGN_LOCAL_MILLER_MYERS) unless defined $alg;\n\n   if (defined $match) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->match($match);\n\t}\n\telse {\n\t    $self->throw(\"Match score must be a number, not [$match]\");\n\t}\n    }\n\n    if (defined $mismatch) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->mismatch($mismatch);\n\t}\n\telse {\n\t    $self->throw(\"Mismatch penalty must be a number, not [$mismatch]\");\n\t}\n    }\n\n    if (defined $gap) {\n\tif ($gap =~ /^\\d+$/) {\n\t    $self->gap($gap);\n\t}\n\telse {\n\t    $self->throw(\"Gap penalty must be a number, not [$gap]\");\n\t}\n    }\n\n    if (defined $ext) {\n\tif ($ext =~ /^\\d+$/) {\n\t    $self->ext($ext);\n\t}\n\telse {\n\t    $self->throw(\"Extension penalty must be a number, not [$ext]\");\n\t}\n    }\n\n    if (defined $alg) {\n\tif ($alg == DPALIGN_LOCAL_MILLER_MYERS or $alg == DPALIGN_GLOBAL_MILLER_MYERS or $alg == DPALIGN_ENDSFREE_MILLER_MYERS) {\n\t    $self->alg($alg);\n\t}\n\telse {\n\t    $self->throw(\"Algorithm must be either 1, 2 or 3\");\n\t}\n    }\n\n    if (defined $matrix and $matrix->isa('Bio::Matrix::MatrixI')) {\n        $self->{'matrix'} = Bio::Ext::Align::ScoringMatrix->new(join(\"\", $matrix->row_names), $self->gap, $self->ext);\n        foreach $rowname ($matrix->row_names) {\n            foreach $colname ($matrix->column_names) {\n                Bio::Ext::Align::ScoringMatrix->set_entry($self->{'matrix'}, $rowname, $colname, $matrix->entry($rowname, $colname));\n            }\n        }\n    }\n    else {\n        $self->{'matrix'} = 0;\n    }\n\n    return $self;\n}\n\n=head2 sequence_profile\n\n Title   : sequence_profile\n Usage   : $prof = $factory->sequence_profile($seq1)\n Function: Makes a dpAlign_SequenceProfile object from one sequence\n Returns : A dpAlign_SequenceProfile object\n Args    : The lone argument is a Bio::PrimarySeqI that we want to \n\t   build a profile for. Usually, this would be the Query sequence\n\n\nsub sequence_profile {\n    my ($self, $seq1) = @_;\n\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI')) {\n        $self->warn(\"Cannot call sequence_profilewithout specifing one sequence (Bio::PrimarySeqI object)\");\n        return;\n    }\n\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2) {\n        $self->warn(\"cannot create sequence profile with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n\n    if ($seq1->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::SequenceProfile->dna_new($seq1->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'});\n    }\n    elsif ($seq1->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::SequenceProfile->protein_new($seq1->seq, $self->{'matrix'}); \n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment_score\n\n Title   : pairwise_alignment_score\n Usage   : $score = $factory->pairwise_alignment_score($prof,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : An integer that is the score of the optimal alignment.\n Args    : The first argument is the sequence profile obtained from a\n\t   call to the sequence_profile function. The second argument \n\t   is a Bio::PrimarySeqI object to be aligned. The second argument\n\t   is usually a sequence in the database sequence. Note\n\t   that this function only uses Phil Green's algorithm and \n\t   therefore theoretically may not always give you the optimal\n\t   score.\n\n\nsub pairwise_alignment_score {\n    my ($self, $prof, $seq2) = @_;\n\n    if( ! defined $prof || ! $prof->isa('Bio::Ext::Align::SequenceProfile') || \n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment_score without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq2->length() < 2) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($prof->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::Score_DNA_Sequences($prof, $seq2->seq);\n    }\n    elsif ($prof->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::Score_Protein_Sequences($prof, $seq2->seq);\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment\n\n Title   : pairwise_alignment\n Usage   : $aln = $factory->pairwise_alignment($seq1,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : A SimpleAlign object if there is an alignment with positive\n\t   score. Otherwise, return undef.\n Args    : The first and second arguments are both Bio::PrimarySeqI\n\t   objects that are to be aligned.\n\n\nsub pairwise_alignment {\n    my ($self, $seq1, $seq2) = @_;\n    my ($aln, $out);\n\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 ||\n        $seq2->length() < 2 ) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($seq1->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\t$aln = Bio::Ext::Align::Align_DNA_Sequences($seq1->seq, $seq2->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'}, $self->{'alg'});\n    }\n    elsif ($seq1->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\t$aln = Bio::Ext::Align::Align_Protein_Sequences($seq1->seq, $seq2->seq, $self->{'matrix'}, $self->{'alg'});\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n\n    if (not defined $aln or $aln == 0) {\n\treturn;\n    }\n\n    $out = Bio::SimpleAlign->new();\n\n    $out->add_seq(Bio::LocatableSeq->new(-seq => $aln->aln1,\n\t\t\t\t\t -start => $aln->start1,\n\t\t\t\t\t -end => $aln->end1,\n\t\t\t\t\t -id => $seq1->id));\n    \n    $out->add_seq(Bio::LocatableSeq->new(-seq => $aln->aln2,\n\t\t\t\t\t -start => $aln->start2,\n\t\t\t\t\t -end => $aln->end2,\n\t\t\t\t\t -id => $seq2->id));\n    $out->score($aln->score);\n    return $out;\n}\n\n=head2 align_and_show\n\n Title   : align_and_show\n Usage   : $factory->align_and_show($seq1,$seq2,STDOUT)\n\n\nsub align_and_show {\n    my ($self, $seq1, $seq2, $fh) = @_;\n    my ($aln, $out);\n\n    if (! defined $fh) {\n\t$fh = \\*STDOUT;\n    }\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 ||\n        $seq2->length() < 2 ) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($seq1->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\t$aln = Bio::Ext::Align::Align_DNA_Sequences($seq1->seq, $seq2->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'}, $self->{'alg'});\n    }\n    elsif ($seq1->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\t$aln = Bio::Ext::Align::Align_Protein_Sequences($seq1->seq, $seq2->seq, $self->{'matrix'}, $self->{'alg'});\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n    }\n\n    $out = Bio::Ext::Align::AlnBlock->new();\n    my $s1 = Bio::Ext::Align::AlnSequence->new();\n    my $s2 = Bio::Ext::Align::AlnSequence->new();\n    my $a1 = $aln->aln1;\n    my $a2 = $aln->aln2;\n    my $first_col = undef;\n    my $last_col = undef;\n    my $col;\n    my $alu1;\n    my $alu2;\n    my $g1 = 0;\n    my $g2 = 0;\n\n# construct AlnBlock\n    for (my $i = 0; $i < length($a1); ++$i) {\n\t$col = Bio::Ext::Align::AlnColumn->new();\n\t$alu1 = Bio::Ext::Align::AlnUnit->new();\n\t$alu2 = Bio::Ext::Align::AlnUnit->new();\n\t$first_col = $col unless defined $first_col;\n\tBio::Ext::Align::AlnColumn::set_next($last_col, $col) if defined $last_col;\n\t\n\tif (substr($a1, $i, 1) eq \"-\") {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"INSERT\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"SEQUENCE\");\n\t    ++$g1;\n\t}\n\telsif (substr($a2, $i, 1) eq \"-\") {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"SEQUENCE\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"INSERT\");\n\t    ++$g2;\n\t}\n\telse {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"SEQUENCE\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"SEQUENCE\");\n\t}\n\n\tBio::Ext::Align::AlnUnit::set_start($alu1, $aln->start1+$i-$g1-2);\n\tBio::Ext::Align::AlnUnit::set_end($alu1, $aln->start1+$i-$g1-2);\n\tBio::Ext::Align::AlnUnit::set_start($alu2, $aln->start2+$i-$g2-2);\n\tBio::Ext::Align::AlnUnit::set_end($alu2, $aln->start2+$i-$g2-2);\n\tBio::Ext::Align::AlnColumn::add_alu($col, $alu1);\n\tBio::Ext::Align::AlnColumn::add_alu($col, $alu2);\n\t$last_col = $col;\n    }\n    Bio::Ext::Align::AlnBlock::set_start($out, $first_col);\n    $col = Bio::Ext::Align::AlnColumn->new();\n    $alu1 = Bio::Ext::Align::AlnUnit->new();\n    $alu2 = Bio::Ext::Align::AlnUnit->new();\n    Bio::Ext::Align::AlnUnit::set_start($alu1, $aln->end1);\n    Bio::Ext::Align::AlnUnit::set_end($alu1, $aln->end1);\n    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"END\");\n    Bio::Ext::Align::AlnUnit::set_start($alu2, $aln->end2);\n    Bio::Ext::Align::AlnUnit::set_end($alu2, $aln->end2);\n    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"END\");\n    Bio::Ext::Align::AlnColumn::add_alu($col, $alu1);\n    Bio::Ext::Align::AlnColumn::add_alu($col, $alu2);\n    Bio::Ext::Align::AlnColumn::set_next($last_col, $col);\n\n    &Bio::Ext::Align::write_pretty_str_align($out,$seq1->id,$seq1->seq,$seq2->id,$seq2->seq,12,50,$fh);\n}\n\n=head2 match\n\n Title     : match \n Usage     : $match = $factory->match() #get\n           : $factory->match($value) #set\n Function  : the set get for the match score\n Example   :\n Returns   : match value\n Arguments : new value","parameters":[{"label":"$self"},{"label":"$val"}],"label":"match($self,$val)"},"kind":12,"range":{"start":{"line":609,"character":0},"end":{"character":9999,"line":620}},"line":609},{"children":[{"line":635,"kind":13,"localvar":"my","containerName":"mismatch","name":"$self","definition":"my"},{"line":635,"name":"$val","kind":13,"containerName":"mismatch"},{"name":"$val","kind":13,"containerName":"mismatch","line":638},{"name":"$val","containerName":"mismatch","kind":13,"line":639},{"containerName":"mismatch","kind":13,"name":"$self","line":640},{"line":640,"name":"throw","kind":12,"containerName":"mismatch"},{"name":"$self","kind":13,"containerName":"mismatch","line":642},{"containerName":"mismatch","kind":13,"name":"$val","line":642},{"kind":13,"containerName":"mismatch","name":"$self","line":644}],"containerName":"main::","name":"mismatch","definition":"sub","detail":"($self,$val)","line":634,"kind":12,"range":{"end":{"character":9999,"line":645},"start":{"character":0,"line":634}},"signature":{"label":"mismatch($self,$val)","parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n## $Id: dpAlign.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n# BioPerl module for Bio::Tools::dpAlign\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Yee Man Chan <ymc@yahoo.com>\n#\n# Copyright Yee Man Chan\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::dpAlign - Perl extension to do pairwise dynamic programming sequence alignment\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::dpAlign;\n  use Bio::SeqIO;\n  use Bio::SimpleAlign;\n  use Bio::AlignIO;\n  use Bio::Matrix::IO;\n\n  $seq1 = Bio::SeqIO->new(-file => $ARGV[0], -format => 'fasta');\n  $seq2 = Bio::SeqIO->new(-file => $ARGV[1], -format => 'fasta');\n\n  # create a dpAlign object\n  # to do global alignment, specify DPALIGN_GLOBAL_MILLER_MYERS\n  # to do ends-free alignment, specify DPALIGN_ENDSFREE_MILLER_MYERS\n  $factory = new dpAlign(-match => 3,\n                     -mismatch => -1,\n                     -gap => 3,\n                     -ext => 1,\n                     -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLER_MYERS);\n\n  # actually do the alignment\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout = Bio::AlignIO->new(-format => 'pfam', -fh => \\*STDOUT);\n  $alnout->write_aln($out);\n\n  # To do protein alignment, set the sequence type to protein\n  # By default all protein alignments are using BLOSUM62 matrix\n  # the gap opening cost is 7 and gap extension is 1. These\n  # values are from ssearch. To use your own custom substitution \n  # matrix, you can create a Bio::Matrix::MatrixI object.\n\n  $parser = Bio::Matrix::IO->new(-format => 'scoring', -file => 'blosum50.mat');\n  $matrix = $parser->next_matrix;\n  $factory = Bio::Tools::dpAlign->new(-matrix => $matrix, -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLERMYERS);\n  $seq1->alphabet('protein');\n  $seq2->alphabet('protein');\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout->write_aln($out);\n\n  # use the factory to make some output\n\n  $factory->align_and_show($seq1, $seq2, STDOUT);\n\n  # use Phil Green's algorithm to calculate the optimal local\n  # alignment score between two sequences quickly. It is very\n  # useful when you are searching a query sequence in a database\n  # of sequences. Since finding a alignment is more costly \n  # than just calculating scores, you can save time if you only \n  # align sequences that have a high alignment score.\n\n  # To use this feature, first you call the sequence_profile function\n  # to obtain the profile of the query sequence.\n  $profile = $factory->sequence_profile($query);\n\n  %scores = ();\n  # Then use a loop to run a database of sequences against the\n  # profile to obtain a table of alignment scores\n  $dbseq = Bio::SeqIO(-file => 'dbseq.fa', -format => 'fasta');\n  while (defined($seq = $dbseq->next_seq)) {\n      $scores{$seq->id} = $factory->pairwise_alignment_score($profile, $seq);\n  }\n\n=head1 DESCRIPTION\n\nDynamic Programming approach is considered to be the most sensitive\nway to align two biological sequences. There are currently three major\ntypes of dynamic programming algorithms: Global Alignment, Local\nAlignment and Ends-free Alignment.\n\nGlobal Alignment compares two sequences in their entirety.  By\ninserting gaps in the two sequences, it aligns two sequences to\nminimize the edit distance as defined by the gap cost function and the\nsubstitution matrix. Global Alignment is generally applied to two\nsequences that are very similar in length and content.\n\nLocal Alignment instead attempts to find out the subsequences that has\nthe minimal edit distance among all possible subsequences.  It is good\nfor sequences that has a stretch of subsequences that are similar to\neach other.\n\nEnds-free Alignment is a special case of Global Alignment. There are\nno gap penalty imposed for the gaps that extended from the end points\nof two sequences. Therefore it will be a good application when you\nthink one sequence is contained by the other or when you think two\nsequences overlap each other.\n\nDynamic Programming was first introduced by Needleman-Wunsch (1970) to\nglobally align two sequences. The idea of local alignment was later\nintroduced by Smith-Waterman (1981). Gotoh (1982) improved both\nalgorithms by introducing auxillary arrays that reduced the time\ncomplexity of the algorithms to O(m*n).  Miller-Myers (1988) exploits\nthe divide-and-conquer idea introduced by Hirschberg (1975) to solve\nthe affine gap cost dynamic programming using only linear space. At\nthe time of this writing, it is accepted that Miller-Myers is the\nfastest single CPU implementation and using the least memory that is\ntruly equivalent to original algorithm introduced by\nNeedleman-Wunsch. According to Aaron Mackey, Phil Green's SWAT\nimplemention introduced a heuristic that does not consider paths\nthrought the matrix where the score would be less than the gap opening\npenalty, yielding a 1.5-2X speedup on most comparisons. to skip the\ncalculation of some cells. However, his approach is only good for\ncalculating the minimum edit distance and find out the corresponding\nsubsequences (aka search phase). Bill Pearson's popular dynamic\nprogramming alignment program SSEARCH uses Phil Green's algorithm to\nfind the subsequences and then Miller-Myers's algorithm to find the\nactual alignment. (aka alignment phase)\n\nThe current implementation supports local alignment of either DNA\nsequences or protein sequences. It allows you to specify either the\nMiller-Myers Global Alignment (DPALIGN_GLOBAL_MILLER_MYERS) or\nMiller-Myers Local Alignment (DPALIGN_LOCAL_MILLER_MYERS). For DNA\nalignment, you can specify the scores for match, mismatch, gap opening\ncost and gap extension cost. For protein alignment, it is using\nBLOSUM62 by default. Currently the substitution matrix is not\nconfigurable.\n\nNote: If you supply LocatableSeq objects to pairwise_alignment,\npairwise_alignment_score, align_and_show or sequence_profile and\nthe sequence supplied contains gaps, these functions will treat \nthese sequences as if they are without gaps.\n\n=head1 DEPENDENCIES\n\nThis package comes with the main bioperl distribution. You also need\nto install the lastest bioperl-ext package which contains the XS code\nthat implements the algorithms. This package won't work if you haven't\ncompiled the bioperl-ext package.\n\n=head1 TO-DO\n\n\n=over 3\n\n* 1.\n\nBasic support for IUPAC code for DNA sequence is now implemented. \nX will mismatch any character. T will match U. For others, whenever\nthere is a possibility for match, it is considered a full match, for\nexample, W will match B.\n\n* 2.\n\nAllow custom substitution matrix for DNA. Note that for proteins, you\ncan now use your own subsitution matirx.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n        This implementation was written by Yee Man Chan (ymc@yahoo.com).\n        Copyright (c) 2003 Yee Man Chan. All rights reserved. This program\n        is free software; you can redistribute it and/or modify it under\n        the same terms as Perl itself. Special thanks to Aaron Mackey\n        and WIlliam Pearson for the helpful discussions. [The portion\n        of code inside pgreen subdirectory was borrowed from ssearch. It\n        should be distributed in the same terms as ssearch.]\n\n\npackage Bio::Tools::dpAlign;\n\nuse Bio::SimpleAlign;\n\nuse base qw(Bio::Tools::AlignFactory);\n\n# Gotoh algorithm as defined in J. Mol. Biol. (1982) 162, 705-708\n# use constant DSW_GOTOH => 1;\n# Hirschberg's algorithm as defined in Myers & Miller in \n# CABIOS, Vol 4, No. 1, 1988, p 11-17\n# This algorithm is used in both the search phase and the\n# alignment phase.\nuse constant DPALIGN_LOCAL_MILLER_MYERS => 1;\nuse constant DPALIGN_GLOBAL_MILLER_MYERS => 2;\nuse constant DPALIGN_ENDSFREE_MILLER_MYERS => 3;\n# my toy algorithm that tries to do SW as fast as possible\n# use constant DSW_FSW => 3; \n# Phil Green's approximation to Smith-Waterman. It avoid calculations\n# that might result in a score less than the opening gap penalty.\n# This is the algorithm used by ssearch. Phil Green's algorithm is\n# used in the search phase while Miller-Myers algorithm is used in\n# the alignment phase\n#use constant DPALIGN_LOCAL_GREEN => 2; \n\nBEGIN {\n    eval {\n        require Bio::Ext::Align;\n    };\n    if ( $@ ) {\n        die(\"\\nThe C-compiled engine for Smith Waterman alignments (Align) has not been installed.\\n Please read the install the bioperl-ext package\\n\\n\");\n        exit(1);\n    }\n}\n\nsub new {\n   my ($class, @args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   my ($match, $mismatch, $gap, $ext, $alg, $matrix) = $self->_rearrange([qw(MATCH\n\t\t\t\t\t\t\t\tMISMATCH\n\t\t\t\t\t\t\t\tGAP\n\t\t\t\t\t\t\t\tEXT\n\t\t\t\t\t\t\t\tALG\n\t\t\t\t\t\t\t\tMATRIX\t\n\t\t\t\t\t\t\t)], @args);\n\n   $self->match(3) unless defined $match;\n   $self->mismatch(-1) unless defined $mismatch;\n   $self->gap(3) unless defined $gap;\n   $self->ext(1) unless defined $ext;\n   $self->alg(DPALIGN_LOCAL_MILLER_MYERS) unless defined $alg;\n\n   if (defined $match) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->match($match);\n\t}\n\telse {\n\t    $self->throw(\"Match score must be a number, not [$match]\");\n\t}\n    }\n\n    if (defined $mismatch) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->mismatch($mismatch);\n\t}\n\telse {\n\t    $self->throw(\"Mismatch penalty must be a number, not [$mismatch]\");\n\t}\n    }\n\n    if (defined $gap) {\n\tif ($gap =~ /^\\d+$/) {\n\t    $self->gap($gap);\n\t}\n\telse {\n\t    $self->throw(\"Gap penalty must be a number, not [$gap]\");\n\t}\n    }\n\n    if (defined $ext) {\n\tif ($ext =~ /^\\d+$/) {\n\t    $self->ext($ext);\n\t}\n\telse {\n\t    $self->throw(\"Extension penalty must be a number, not [$ext]\");\n\t}\n    }\n\n    if (defined $alg) {\n\tif ($alg == DPALIGN_LOCAL_MILLER_MYERS or $alg == DPALIGN_GLOBAL_MILLER_MYERS or $alg == DPALIGN_ENDSFREE_MILLER_MYERS) {\n\t    $self->alg($alg);\n\t}\n\telse {\n\t    $self->throw(\"Algorithm must be either 1, 2 or 3\");\n\t}\n    }\n\n    if (defined $matrix and $matrix->isa('Bio::Matrix::MatrixI')) {\n        $self->{'matrix'} = Bio::Ext::Align::ScoringMatrix->new(join(\"\", $matrix->row_names), $self->gap, $self->ext);\n        foreach $rowname ($matrix->row_names) {\n            foreach $colname ($matrix->column_names) {\n                Bio::Ext::Align::ScoringMatrix->set_entry($self->{'matrix'}, $rowname, $colname, $matrix->entry($rowname, $colname));\n            }\n        }\n    }\n    else {\n        $self->{'matrix'} = 0;\n    }\n\n    return $self;\n}\n\n=head2 sequence_profile\n\n Title   : sequence_profile\n Usage   : $prof = $factory->sequence_profile($seq1)\n Function: Makes a dpAlign_SequenceProfile object from one sequence\n Returns : A dpAlign_SequenceProfile object\n Args    : The lone argument is a Bio::PrimarySeqI that we want to \n\t   build a profile for. Usually, this would be the Query sequence\n\n\nsub sequence_profile {\n    my ($self, $seq1) = @_;\n\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI')) {\n        $self->warn(\"Cannot call sequence_profilewithout specifing one sequence (Bio::PrimarySeqI object)\");\n        return;\n    }\n\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2) {\n        $self->warn(\"cannot create sequence profile with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n\n    if ($seq1->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::SequenceProfile->dna_new($seq1->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'});\n    }\n    elsif ($seq1->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::SequenceProfile->protein_new($seq1->seq, $self->{'matrix'}); \n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment_score\n\n Title   : pairwise_alignment_score\n Usage   : $score = $factory->pairwise_alignment_score($prof,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : An integer that is the score of the optimal alignment.\n Args    : The first argument is the sequence profile obtained from a\n\t   call to the sequence_profile function. The second argument \n\t   is a Bio::PrimarySeqI object to be aligned. The second argument\n\t   is usually a sequence in the database sequence. Note\n\t   that this function only uses Phil Green's algorithm and \n\t   therefore theoretically may not always give you the optimal\n\t   score.\n\n\nsub pairwise_alignment_score {\n    my ($self, $prof, $seq2) = @_;\n\n    if( ! defined $prof || ! $prof->isa('Bio::Ext::Align::SequenceProfile') || \n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment_score without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq2->length() < 2) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($prof->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::Score_DNA_Sequences($prof, $seq2->seq);\n    }\n    elsif ($prof->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::Score_Protein_Sequences($prof, $seq2->seq);\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment\n\n Title   : pairwise_alignment\n Usage   : $aln = $factory->pairwise_alignment($seq1,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : A SimpleAlign object if there is an alignment with positive\n\t   score. Otherwise, return undef.\n Args    : The first and second arguments are both Bio::PrimarySeqI\n\t   objects that are to be aligned.\n\n\nsub pairwise_alignment {\n    my ($self, $seq1, $seq2) = @_;\n    my ($aln, $out);\n\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 ||\n        $seq2->length() < 2 ) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($seq1->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\t$aln = Bio::Ext::Align::Align_DNA_Sequences($seq1->seq, $seq2->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'}, $self->{'alg'});\n    }\n    elsif ($seq1->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\t$aln = Bio::Ext::Align::Align_Protein_Sequences($seq1->seq, $seq2->seq, $self->{'matrix'}, $self->{'alg'});\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n\n    if (not defined $aln or $aln == 0) {\n\treturn;\n    }\n\n    $out = Bio::SimpleAlign->new();\n\n    $out->add_seq(Bio::LocatableSeq->new(-seq => $aln->aln1,\n\t\t\t\t\t -start => $aln->start1,\n\t\t\t\t\t -end => $aln->end1,\n\t\t\t\t\t -id => $seq1->id));\n    \n    $out->add_seq(Bio::LocatableSeq->new(-seq => $aln->aln2,\n\t\t\t\t\t -start => $aln->start2,\n\t\t\t\t\t -end => $aln->end2,\n\t\t\t\t\t -id => $seq2->id));\n    $out->score($aln->score);\n    return $out;\n}\n\n=head2 align_and_show\n\n Title   : align_and_show\n Usage   : $factory->align_and_show($seq1,$seq2,STDOUT)\n\n\nsub align_and_show {\n    my ($self, $seq1, $seq2, $fh) = @_;\n    my ($aln, $out);\n\n    if (! defined $fh) {\n\t$fh = \\*STDOUT;\n    }\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 ||\n        $seq2->length() < 2 ) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($seq1->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\t$aln = Bio::Ext::Align::Align_DNA_Sequences($seq1->seq, $seq2->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'}, $self->{'alg'});\n    }\n    elsif ($seq1->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\t$aln = Bio::Ext::Align::Align_Protein_Sequences($seq1->seq, $seq2->seq, $self->{'matrix'}, $self->{'alg'});\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n    }\n\n    $out = Bio::Ext::Align::AlnBlock->new();\n    my $s1 = Bio::Ext::Align::AlnSequence->new();\n    my $s2 = Bio::Ext::Align::AlnSequence->new();\n    my $a1 = $aln->aln1;\n    my $a2 = $aln->aln2;\n    my $first_col = undef;\n    my $last_col = undef;\n    my $col;\n    my $alu1;\n    my $alu2;\n    my $g1 = 0;\n    my $g2 = 0;\n\n# construct AlnBlock\n    for (my $i = 0; $i < length($a1); ++$i) {\n\t$col = Bio::Ext::Align::AlnColumn->new();\n\t$alu1 = Bio::Ext::Align::AlnUnit->new();\n\t$alu2 = Bio::Ext::Align::AlnUnit->new();\n\t$first_col = $col unless defined $first_col;\n\tBio::Ext::Align::AlnColumn::set_next($last_col, $col) if defined $last_col;\n\t\n\tif (substr($a1, $i, 1) eq \"-\") {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"INSERT\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"SEQUENCE\");\n\t    ++$g1;\n\t}\n\telsif (substr($a2, $i, 1) eq \"-\") {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"SEQUENCE\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"INSERT\");\n\t    ++$g2;\n\t}\n\telse {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"SEQUENCE\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"SEQUENCE\");\n\t}\n\n\tBio::Ext::Align::AlnUnit::set_start($alu1, $aln->start1+$i-$g1-2);\n\tBio::Ext::Align::AlnUnit::set_end($alu1, $aln->start1+$i-$g1-2);\n\tBio::Ext::Align::AlnUnit::set_start($alu2, $aln->start2+$i-$g2-2);\n\tBio::Ext::Align::AlnUnit::set_end($alu2, $aln->start2+$i-$g2-2);\n\tBio::Ext::Align::AlnColumn::add_alu($col, $alu1);\n\tBio::Ext::Align::AlnColumn::add_alu($col, $alu2);\n\t$last_col = $col;\n    }\n    Bio::Ext::Align::AlnBlock::set_start($out, $first_col);\n    $col = Bio::Ext::Align::AlnColumn->new();\n    $alu1 = Bio::Ext::Align::AlnUnit->new();\n    $alu2 = Bio::Ext::Align::AlnUnit->new();\n    Bio::Ext::Align::AlnUnit::set_start($alu1, $aln->end1);\n    Bio::Ext::Align::AlnUnit::set_end($alu1, $aln->end1);\n    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"END\");\n    Bio::Ext::Align::AlnUnit::set_start($alu2, $aln->end2);\n    Bio::Ext::Align::AlnUnit::set_end($alu2, $aln->end2);\n    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"END\");\n    Bio::Ext::Align::AlnColumn::add_alu($col, $alu1);\n    Bio::Ext::Align::AlnColumn::add_alu($col, $alu2);\n    Bio::Ext::Align::AlnColumn::set_next($last_col, $col);\n\n    &Bio::Ext::Align::write_pretty_str_align($out,$seq1->id,$seq1->seq,$seq2->id,$seq2->seq,12,50,$fh);\n}\n\n=head2 match\n\n Title     : match \n Usage     : $match = $factory->match() #get\n           : $factory->match($value) #set\n Function  : the set get for the match score\n Example   :\n Returns   : match value\n Arguments : new value\n\n\nsub match {\n    my ($self,$val) = @_;\n\n\n    if( defined $val ) {\n        if( $val < 0 ) {    # Fixed so that match==0 is allowed /AE\n            $self->throw(\"Can't have a match score less than 0\");\n        }\n        $self->{'match'} = $val;\n    }\n    return $self->{'match'};\n}\n\n=head2 mismatch\n\n Title     : mismatch \n Usage     : $mismatch = $factory->mismatch() #get\n           : $factory->mismatch($value) #set\n Function  : the set get for the mismatch penalty\n Example   :\n Returns   : mismatch value\n Arguments : new value"}},{"signature":{"label":"gap($self,$val)","parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n## $Id: dpAlign.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n# BioPerl module for Bio::Tools::dpAlign\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Yee Man Chan <ymc@yahoo.com>\n#\n# Copyright Yee Man Chan\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::dpAlign - Perl extension to do pairwise dynamic programming sequence alignment\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::dpAlign;\n  use Bio::SeqIO;\n  use Bio::SimpleAlign;\n  use Bio::AlignIO;\n  use Bio::Matrix::IO;\n\n  $seq1 = Bio::SeqIO->new(-file => $ARGV[0], -format => 'fasta');\n  $seq2 = Bio::SeqIO->new(-file => $ARGV[1], -format => 'fasta');\n\n  # create a dpAlign object\n  # to do global alignment, specify DPALIGN_GLOBAL_MILLER_MYERS\n  # to do ends-free alignment, specify DPALIGN_ENDSFREE_MILLER_MYERS\n  $factory = new dpAlign(-match => 3,\n                     -mismatch => -1,\n                     -gap => 3,\n                     -ext => 1,\n                     -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLER_MYERS);\n\n  # actually do the alignment\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout = Bio::AlignIO->new(-format => 'pfam', -fh => \\*STDOUT);\n  $alnout->write_aln($out);\n\n  # To do protein alignment, set the sequence type to protein\n  # By default all protein alignments are using BLOSUM62 matrix\n  # the gap opening cost is 7 and gap extension is 1. These\n  # values are from ssearch. To use your own custom substitution \n  # matrix, you can create a Bio::Matrix::MatrixI object.\n\n  $parser = Bio::Matrix::IO->new(-format => 'scoring', -file => 'blosum50.mat');\n  $matrix = $parser->next_matrix;\n  $factory = Bio::Tools::dpAlign->new(-matrix => $matrix, -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLERMYERS);\n  $seq1->alphabet('protein');\n  $seq2->alphabet('protein');\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout->write_aln($out);\n\n  # use the factory to make some output\n\n  $factory->align_and_show($seq1, $seq2, STDOUT);\n\n  # use Phil Green's algorithm to calculate the optimal local\n  # alignment score between two sequences quickly. It is very\n  # useful when you are searching a query sequence in a database\n  # of sequences. Since finding a alignment is more costly \n  # than just calculating scores, you can save time if you only \n  # align sequences that have a high alignment score.\n\n  # To use this feature, first you call the sequence_profile function\n  # to obtain the profile of the query sequence.\n  $profile = $factory->sequence_profile($query);\n\n  %scores = ();\n  # Then use a loop to run a database of sequences against the\n  # profile to obtain a table of alignment scores\n  $dbseq = Bio::SeqIO(-file => 'dbseq.fa', -format => 'fasta');\n  while (defined($seq = $dbseq->next_seq)) {\n      $scores{$seq->id} = $factory->pairwise_alignment_score($profile, $seq);\n  }\n\n=head1 DESCRIPTION\n\nDynamic Programming approach is considered to be the most sensitive\nway to align two biological sequences. There are currently three major\ntypes of dynamic programming algorithms: Global Alignment, Local\nAlignment and Ends-free Alignment.\n\nGlobal Alignment compares two sequences in their entirety.  By\ninserting gaps in the two sequences, it aligns two sequences to\nminimize the edit distance as defined by the gap cost function and the\nsubstitution matrix. Global Alignment is generally applied to two\nsequences that are very similar in length and content.\n\nLocal Alignment instead attempts to find out the subsequences that has\nthe minimal edit distance among all possible subsequences.  It is good\nfor sequences that has a stretch of subsequences that are similar to\neach other.\n\nEnds-free Alignment is a special case of Global Alignment. There are\nno gap penalty imposed for the gaps that extended from the end points\nof two sequences. Therefore it will be a good application when you\nthink one sequence is contained by the other or when you think two\nsequences overlap each other.\n\nDynamic Programming was first introduced by Needleman-Wunsch (1970) to\nglobally align two sequences. The idea of local alignment was later\nintroduced by Smith-Waterman (1981). Gotoh (1982) improved both\nalgorithms by introducing auxillary arrays that reduced the time\ncomplexity of the algorithms to O(m*n).  Miller-Myers (1988) exploits\nthe divide-and-conquer idea introduced by Hirschberg (1975) to solve\nthe affine gap cost dynamic programming using only linear space. At\nthe time of this writing, it is accepted that Miller-Myers is the\nfastest single CPU implementation and using the least memory that is\ntruly equivalent to original algorithm introduced by\nNeedleman-Wunsch. According to Aaron Mackey, Phil Green's SWAT\nimplemention introduced a heuristic that does not consider paths\nthrought the matrix where the score would be less than the gap opening\npenalty, yielding a 1.5-2X speedup on most comparisons. to skip the\ncalculation of some cells. However, his approach is only good for\ncalculating the minimum edit distance and find out the corresponding\nsubsequences (aka search phase). Bill Pearson's popular dynamic\nprogramming alignment program SSEARCH uses Phil Green's algorithm to\nfind the subsequences and then Miller-Myers's algorithm to find the\nactual alignment. (aka alignment phase)\n\nThe current implementation supports local alignment of either DNA\nsequences or protein sequences. It allows you to specify either the\nMiller-Myers Global Alignment (DPALIGN_GLOBAL_MILLER_MYERS) or\nMiller-Myers Local Alignment (DPALIGN_LOCAL_MILLER_MYERS). For DNA\nalignment, you can specify the scores for match, mismatch, gap opening\ncost and gap extension cost. For protein alignment, it is using\nBLOSUM62 by default. Currently the substitution matrix is not\nconfigurable.\n\nNote: If you supply LocatableSeq objects to pairwise_alignment,\npairwise_alignment_score, align_and_show or sequence_profile and\nthe sequence supplied contains gaps, these functions will treat \nthese sequences as if they are without gaps.\n\n=head1 DEPENDENCIES\n\nThis package comes with the main bioperl distribution. You also need\nto install the lastest bioperl-ext package which contains the XS code\nthat implements the algorithms. This package won't work if you haven't\ncompiled the bioperl-ext package.\n\n=head1 TO-DO\n\n\n=over 3\n\n* 1.\n\nBasic support for IUPAC code for DNA sequence is now implemented. \nX will mismatch any character. T will match U. For others, whenever\nthere is a possibility for match, it is considered a full match, for\nexample, W will match B.\n\n* 2.\n\nAllow custom substitution matrix for DNA. Note that for proteins, you\ncan now use your own subsitution matirx.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n        This implementation was written by Yee Man Chan (ymc@yahoo.com).\n        Copyright (c) 2003 Yee Man Chan. All rights reserved. This program\n        is free software; you can redistribute it and/or modify it under\n        the same terms as Perl itself. Special thanks to Aaron Mackey\n        and WIlliam Pearson for the helpful discussions. [The portion\n        of code inside pgreen subdirectory was borrowed from ssearch. It\n        should be distributed in the same terms as ssearch.]\n\n\npackage Bio::Tools::dpAlign;\n\nuse Bio::SimpleAlign;\n\nuse base qw(Bio::Tools::AlignFactory);\n\n# Gotoh algorithm as defined in J. Mol. Biol. (1982) 162, 705-708\n# use constant DSW_GOTOH => 1;\n# Hirschberg's algorithm as defined in Myers & Miller in \n# CABIOS, Vol 4, No. 1, 1988, p 11-17\n# This algorithm is used in both the search phase and the\n# alignment phase.\nuse constant DPALIGN_LOCAL_MILLER_MYERS => 1;\nuse constant DPALIGN_GLOBAL_MILLER_MYERS => 2;\nuse constant DPALIGN_ENDSFREE_MILLER_MYERS => 3;\n# my toy algorithm that tries to do SW as fast as possible\n# use constant DSW_FSW => 3; \n# Phil Green's approximation to Smith-Waterman. It avoid calculations\n# that might result in a score less than the opening gap penalty.\n# This is the algorithm used by ssearch. Phil Green's algorithm is\n# used in the search phase while Miller-Myers algorithm is used in\n# the alignment phase\n#use constant DPALIGN_LOCAL_GREEN => 2; \n\nBEGIN {\n    eval {\n        require Bio::Ext::Align;\n    };\n    if ( $@ ) {\n        die(\"\\nThe C-compiled engine for Smith Waterman alignments (Align) has not been installed.\\n Please read the install the bioperl-ext package\\n\\n\");\n        exit(1);\n    }\n}\n\nsub new {\n   my ($class, @args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   my ($match, $mismatch, $gap, $ext, $alg, $matrix) = $self->_rearrange([qw(MATCH\n\t\t\t\t\t\t\t\tMISMATCH\n\t\t\t\t\t\t\t\tGAP\n\t\t\t\t\t\t\t\tEXT\n\t\t\t\t\t\t\t\tALG\n\t\t\t\t\t\t\t\tMATRIX\t\n\t\t\t\t\t\t\t)], @args);\n\n   $self->match(3) unless defined $match;\n   $self->mismatch(-1) unless defined $mismatch;\n   $self->gap(3) unless defined $gap;\n   $self->ext(1) unless defined $ext;\n   $self->alg(DPALIGN_LOCAL_MILLER_MYERS) unless defined $alg;\n\n   if (defined $match) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->match($match);\n\t}\n\telse {\n\t    $self->throw(\"Match score must be a number, not [$match]\");\n\t}\n    }\n\n    if (defined $mismatch) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->mismatch($mismatch);\n\t}\n\telse {\n\t    $self->throw(\"Mismatch penalty must be a number, not [$mismatch]\");\n\t}\n    }\n\n    if (defined $gap) {\n\tif ($gap =~ /^\\d+$/) {\n\t    $self->gap($gap);\n\t}\n\telse {\n\t    $self->throw(\"Gap penalty must be a number, not [$gap]\");\n\t}\n    }\n\n    if (defined $ext) {\n\tif ($ext =~ /^\\d+$/) {\n\t    $self->ext($ext);\n\t}\n\telse {\n\t    $self->throw(\"Extension penalty must be a number, not [$ext]\");\n\t}\n    }\n\n    if (defined $alg) {\n\tif ($alg == DPALIGN_LOCAL_MILLER_MYERS or $alg == DPALIGN_GLOBAL_MILLER_MYERS or $alg == DPALIGN_ENDSFREE_MILLER_MYERS) {\n\t    $self->alg($alg);\n\t}\n\telse {\n\t    $self->throw(\"Algorithm must be either 1, 2 or 3\");\n\t}\n    }\n\n    if (defined $matrix and $matrix->isa('Bio::Matrix::MatrixI')) {\n        $self->{'matrix'} = Bio::Ext::Align::ScoringMatrix->new(join(\"\", $matrix->row_names), $self->gap, $self->ext);\n        foreach $rowname ($matrix->row_names) {\n            foreach $colname ($matrix->column_names) {\n                Bio::Ext::Align::ScoringMatrix->set_entry($self->{'matrix'}, $rowname, $colname, $matrix->entry($rowname, $colname));\n            }\n        }\n    }\n    else {\n        $self->{'matrix'} = 0;\n    }\n\n    return $self;\n}\n\n=head2 sequence_profile\n\n Title   : sequence_profile\n Usage   : $prof = $factory->sequence_profile($seq1)\n Function: Makes a dpAlign_SequenceProfile object from one sequence\n Returns : A dpAlign_SequenceProfile object\n Args    : The lone argument is a Bio::PrimarySeqI that we want to \n\t   build a profile for. Usually, this would be the Query sequence\n\n\nsub sequence_profile {\n    my ($self, $seq1) = @_;\n\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI')) {\n        $self->warn(\"Cannot call sequence_profilewithout specifing one sequence (Bio::PrimarySeqI object)\");\n        return;\n    }\n\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2) {\n        $self->warn(\"cannot create sequence profile with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n\n    if ($seq1->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::SequenceProfile->dna_new($seq1->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'});\n    }\n    elsif ($seq1->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::SequenceProfile->protein_new($seq1->seq, $self->{'matrix'}); \n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment_score\n\n Title   : pairwise_alignment_score\n Usage   : $score = $factory->pairwise_alignment_score($prof,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : An integer that is the score of the optimal alignment.\n Args    : The first argument is the sequence profile obtained from a\n\t   call to the sequence_profile function. The second argument \n\t   is a Bio::PrimarySeqI object to be aligned. The second argument\n\t   is usually a sequence in the database sequence. Note\n\t   that this function only uses Phil Green's algorithm and \n\t   therefore theoretically may not always give you the optimal\n\t   score.\n\n\nsub pairwise_alignment_score {\n    my ($self, $prof, $seq2) = @_;\n\n    if( ! defined $prof || ! $prof->isa('Bio::Ext::Align::SequenceProfile') || \n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment_score without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq2->length() < 2) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($prof->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::Score_DNA_Sequences($prof, $seq2->seq);\n    }\n    elsif ($prof->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::Score_Protein_Sequences($prof, $seq2->seq);\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment\n\n Title   : pairwise_alignment\n Usage   : $aln = $factory->pairwise_alignment($seq1,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : A SimpleAlign object if there is an alignment with positive\n\t   score. Otherwise, return undef.\n Args    : The first and second arguments are both Bio::PrimarySeqI\n\t   objects that are to be aligned.\n\n\nsub pairwise_alignment {\n    my ($self, $seq1, $seq2) = @_;\n    my ($aln, $out);\n\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 ||\n        $seq2->length() < 2 ) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($seq1->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\t$aln = Bio::Ext::Align::Align_DNA_Sequences($seq1->seq, $seq2->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'}, $self->{'alg'});\n    }\n    elsif ($seq1->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\t$aln = Bio::Ext::Align::Align_Protein_Sequences($seq1->seq, $seq2->seq, $self->{'matrix'}, $self->{'alg'});\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n\n    if (not defined $aln or $aln == 0) {\n\treturn;\n    }\n\n    $out = Bio::SimpleAlign->new();\n\n    $out->add_seq(Bio::LocatableSeq->new(-seq => $aln->aln1,\n\t\t\t\t\t -start => $aln->start1,\n\t\t\t\t\t -end => $aln->end1,\n\t\t\t\t\t -id => $seq1->id));\n    \n    $out->add_seq(Bio::LocatableSeq->new(-seq => $aln->aln2,\n\t\t\t\t\t -start => $aln->start2,\n\t\t\t\t\t -end => $aln->end2,\n\t\t\t\t\t -id => $seq2->id));\n    $out->score($aln->score);\n    return $out;\n}\n\n=head2 align_and_show\n\n Title   : align_and_show\n Usage   : $factory->align_and_show($seq1,$seq2,STDOUT)\n\n\nsub align_and_show {\n    my ($self, $seq1, $seq2, $fh) = @_;\n    my ($aln, $out);\n\n    if (! defined $fh) {\n\t$fh = \\*STDOUT;\n    }\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 ||\n        $seq2->length() < 2 ) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($seq1->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\t$aln = Bio::Ext::Align::Align_DNA_Sequences($seq1->seq, $seq2->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'}, $self->{'alg'});\n    }\n    elsif ($seq1->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\t$aln = Bio::Ext::Align::Align_Protein_Sequences($seq1->seq, $seq2->seq, $self->{'matrix'}, $self->{'alg'});\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n    }\n\n    $out = Bio::Ext::Align::AlnBlock->new();\n    my $s1 = Bio::Ext::Align::AlnSequence->new();\n    my $s2 = Bio::Ext::Align::AlnSequence->new();\n    my $a1 = $aln->aln1;\n    my $a2 = $aln->aln2;\n    my $first_col = undef;\n    my $last_col = undef;\n    my $col;\n    my $alu1;\n    my $alu2;\n    my $g1 = 0;\n    my $g2 = 0;\n\n# construct AlnBlock\n    for (my $i = 0; $i < length($a1); ++$i) {\n\t$col = Bio::Ext::Align::AlnColumn->new();\n\t$alu1 = Bio::Ext::Align::AlnUnit->new();\n\t$alu2 = Bio::Ext::Align::AlnUnit->new();\n\t$first_col = $col unless defined $first_col;\n\tBio::Ext::Align::AlnColumn::set_next($last_col, $col) if defined $last_col;\n\t\n\tif (substr($a1, $i, 1) eq \"-\") {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"INSERT\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"SEQUENCE\");\n\t    ++$g1;\n\t}\n\telsif (substr($a2, $i, 1) eq \"-\") {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"SEQUENCE\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"INSERT\");\n\t    ++$g2;\n\t}\n\telse {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"SEQUENCE\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"SEQUENCE\");\n\t}\n\n\tBio::Ext::Align::AlnUnit::set_start($alu1, $aln->start1+$i-$g1-2);\n\tBio::Ext::Align::AlnUnit::set_end($alu1, $aln->start1+$i-$g1-2);\n\tBio::Ext::Align::AlnUnit::set_start($alu2, $aln->start2+$i-$g2-2);\n\tBio::Ext::Align::AlnUnit::set_end($alu2, $aln->start2+$i-$g2-2);\n\tBio::Ext::Align::AlnColumn::add_alu($col, $alu1);\n\tBio::Ext::Align::AlnColumn::add_alu($col, $alu2);\n\t$last_col = $col;\n    }\n    Bio::Ext::Align::AlnBlock::set_start($out, $first_col);\n    $col = Bio::Ext::Align::AlnColumn->new();\n    $alu1 = Bio::Ext::Align::AlnUnit->new();\n    $alu2 = Bio::Ext::Align::AlnUnit->new();\n    Bio::Ext::Align::AlnUnit::set_start($alu1, $aln->end1);\n    Bio::Ext::Align::AlnUnit::set_end($alu1, $aln->end1);\n    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"END\");\n    Bio::Ext::Align::AlnUnit::set_start($alu2, $aln->end2);\n    Bio::Ext::Align::AlnUnit::set_end($alu2, $aln->end2);\n    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"END\");\n    Bio::Ext::Align::AlnColumn::add_alu($col, $alu1);\n    Bio::Ext::Align::AlnColumn::add_alu($col, $alu2);\n    Bio::Ext::Align::AlnColumn::set_next($last_col, $col);\n\n    &Bio::Ext::Align::write_pretty_str_align($out,$seq1->id,$seq1->seq,$seq2->id,$seq2->seq,12,50,$fh);\n}\n\n=head2 match\n\n Title     : match \n Usage     : $match = $factory->match() #get\n           : $factory->match($value) #set\n Function  : the set get for the match score\n Example   :\n Returns   : match value\n Arguments : new value\n\n\nsub match {\n    my ($self,$val) = @_;\n\n\n    if( defined $val ) {\n        if( $val < 0 ) {    # Fixed so that match==0 is allowed /AE\n            $self->throw(\"Can't have a match score less than 0\");\n        }\n        $self->{'match'} = $val;\n    }\n    return $self->{'match'};\n}\n\n=head2 mismatch\n\n Title     : mismatch \n Usage     : $mismatch = $factory->mismatch() #get\n           : $factory->mismatch($value) #set\n Function  : the set get for the mismatch penalty\n Example   :\n Returns   : mismatch value\n Arguments : new value\n\n\nsub mismatch {\n    my ($self,$val) = @_;\n\n\n    if( defined $val ) {\n        if( $val > 0 ) {    # Fixed so that mismatch==0 is allowed /AE\n            $self->throw(\"Can't have a mismatch penalty greater than 0\");\n        }\n        $self->{'mismatch'} = $val;\n    }\n    return $self->{'mismatch'};\n}\n\n\n=head2 gap\n\n Title     : gap\n Usage     : $gap = $factory->gap() #get\n           : $factory->gap($value) #set\n Function  : the set get for the gap penalty\n Example   :\n Returns   : gap value\n Arguments : new value"},"line":660,"range":{"end":{"character":9999,"line":671},"start":{"character":0,"line":660}},"kind":12,"definition":"sub","detail":"($self,$val)","children":[{"definition":"my","line":661,"containerName":"gap","localvar":"my","kind":13,"name":"$self"},{"line":661,"name":"$val","containerName":"gap","kind":13},{"name":"$val","containerName":"gap","kind":13,"line":664},{"kind":13,"containerName":"gap","name":"$val","line":665},{"line":666,"kind":13,"containerName":"gap","name":"$self"},{"line":666,"name":"throw","containerName":"gap","kind":12},{"line":668,"kind":13,"containerName":"gap","name":"$self"},{"kind":13,"containerName":"gap","name":"$val","line":668},{"name":"$self","containerName":"gap","kind":13,"line":670}],"name":"gap","containerName":"main::"},{"detail":"($self,$val)","definition":"sub","name":"ext","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"ext","kind":13,"name":"$self","line":686},{"line":686,"containerName":"ext","kind":13,"name":"$val"},{"line":688,"containerName":"ext","kind":13,"name":"$val"},{"line":689,"name":"$val","containerName":"ext","kind":13},{"line":690,"name":"$self","kind":13,"containerName":"ext"},{"line":690,"containerName":"ext","kind":12,"name":"throw"},{"name":"$self","kind":13,"containerName":"ext","line":692},{"name":"$val","containerName":"ext","kind":13,"line":692},{"name":"$self","containerName":"ext","kind":13,"line":694}],"signature":{"parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n## $Id: dpAlign.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n# BioPerl module for Bio::Tools::dpAlign\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Yee Man Chan <ymc@yahoo.com>\n#\n# Copyright Yee Man Chan\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::dpAlign - Perl extension to do pairwise dynamic programming sequence alignment\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::dpAlign;\n  use Bio::SeqIO;\n  use Bio::SimpleAlign;\n  use Bio::AlignIO;\n  use Bio::Matrix::IO;\n\n  $seq1 = Bio::SeqIO->new(-file => $ARGV[0], -format => 'fasta');\n  $seq2 = Bio::SeqIO->new(-file => $ARGV[1], -format => 'fasta');\n\n  # create a dpAlign object\n  # to do global alignment, specify DPALIGN_GLOBAL_MILLER_MYERS\n  # to do ends-free alignment, specify DPALIGN_ENDSFREE_MILLER_MYERS\n  $factory = new dpAlign(-match => 3,\n                     -mismatch => -1,\n                     -gap => 3,\n                     -ext => 1,\n                     -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLER_MYERS);\n\n  # actually do the alignment\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout = Bio::AlignIO->new(-format => 'pfam', -fh => \\*STDOUT);\n  $alnout->write_aln($out);\n\n  # To do protein alignment, set the sequence type to protein\n  # By default all protein alignments are using BLOSUM62 matrix\n  # the gap opening cost is 7 and gap extension is 1. These\n  # values are from ssearch. To use your own custom substitution \n  # matrix, you can create a Bio::Matrix::MatrixI object.\n\n  $parser = Bio::Matrix::IO->new(-format => 'scoring', -file => 'blosum50.mat');\n  $matrix = $parser->next_matrix;\n  $factory = Bio::Tools::dpAlign->new(-matrix => $matrix, -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLERMYERS);\n  $seq1->alphabet('protein');\n  $seq2->alphabet('protein');\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout->write_aln($out);\n\n  # use the factory to make some output\n\n  $factory->align_and_show($seq1, $seq2, STDOUT);\n\n  # use Phil Green's algorithm to calculate the optimal local\n  # alignment score between two sequences quickly. It is very\n  # useful when you are searching a query sequence in a database\n  # of sequences. Since finding a alignment is more costly \n  # than just calculating scores, you can save time if you only \n  # align sequences that have a high alignment score.\n\n  # To use this feature, first you call the sequence_profile function\n  # to obtain the profile of the query sequence.\n  $profile = $factory->sequence_profile($query);\n\n  %scores = ();\n  # Then use a loop to run a database of sequences against the\n  # profile to obtain a table of alignment scores\n  $dbseq = Bio::SeqIO(-file => 'dbseq.fa', -format => 'fasta');\n  while (defined($seq = $dbseq->next_seq)) {\n      $scores{$seq->id} = $factory->pairwise_alignment_score($profile, $seq);\n  }\n\n=head1 DESCRIPTION\n\nDynamic Programming approach is considered to be the most sensitive\nway to align two biological sequences. There are currently three major\ntypes of dynamic programming algorithms: Global Alignment, Local\nAlignment and Ends-free Alignment.\n\nGlobal Alignment compares two sequences in their entirety.  By\ninserting gaps in the two sequences, it aligns two sequences to\nminimize the edit distance as defined by the gap cost function and the\nsubstitution matrix. Global Alignment is generally applied to two\nsequences that are very similar in length and content.\n\nLocal Alignment instead attempts to find out the subsequences that has\nthe minimal edit distance among all possible subsequences.  It is good\nfor sequences that has a stretch of subsequences that are similar to\neach other.\n\nEnds-free Alignment is a special case of Global Alignment. There are\nno gap penalty imposed for the gaps that extended from the end points\nof two sequences. Therefore it will be a good application when you\nthink one sequence is contained by the other or when you think two\nsequences overlap each other.\n\nDynamic Programming was first introduced by Needleman-Wunsch (1970) to\nglobally align two sequences. The idea of local alignment was later\nintroduced by Smith-Waterman (1981). Gotoh (1982) improved both\nalgorithms by introducing auxillary arrays that reduced the time\ncomplexity of the algorithms to O(m*n).  Miller-Myers (1988) exploits\nthe divide-and-conquer idea introduced by Hirschberg (1975) to solve\nthe affine gap cost dynamic programming using only linear space. At\nthe time of this writing, it is accepted that Miller-Myers is the\nfastest single CPU implementation and using the least memory that is\ntruly equivalent to original algorithm introduced by\nNeedleman-Wunsch. According to Aaron Mackey, Phil Green's SWAT\nimplemention introduced a heuristic that does not consider paths\nthrought the matrix where the score would be less than the gap opening\npenalty, yielding a 1.5-2X speedup on most comparisons. to skip the\ncalculation of some cells. However, his approach is only good for\ncalculating the minimum edit distance and find out the corresponding\nsubsequences (aka search phase). Bill Pearson's popular dynamic\nprogramming alignment program SSEARCH uses Phil Green's algorithm to\nfind the subsequences and then Miller-Myers's algorithm to find the\nactual alignment. (aka alignment phase)\n\nThe current implementation supports local alignment of either DNA\nsequences or protein sequences. It allows you to specify either the\nMiller-Myers Global Alignment (DPALIGN_GLOBAL_MILLER_MYERS) or\nMiller-Myers Local Alignment (DPALIGN_LOCAL_MILLER_MYERS). For DNA\nalignment, you can specify the scores for match, mismatch, gap opening\ncost and gap extension cost. For protein alignment, it is using\nBLOSUM62 by default. Currently the substitution matrix is not\nconfigurable.\n\nNote: If you supply LocatableSeq objects to pairwise_alignment,\npairwise_alignment_score, align_and_show or sequence_profile and\nthe sequence supplied contains gaps, these functions will treat \nthese sequences as if they are without gaps.\n\n=head1 DEPENDENCIES\n\nThis package comes with the main bioperl distribution. You also need\nto install the lastest bioperl-ext package which contains the XS code\nthat implements the algorithms. This package won't work if you haven't\ncompiled the bioperl-ext package.\n\n=head1 TO-DO\n\n\n=over 3\n\n* 1.\n\nBasic support for IUPAC code for DNA sequence is now implemented. \nX will mismatch any character. T will match U. For others, whenever\nthere is a possibility for match, it is considered a full match, for\nexample, W will match B.\n\n* 2.\n\nAllow custom substitution matrix for DNA. Note that for proteins, you\ncan now use your own subsitution matirx.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n        This implementation was written by Yee Man Chan (ymc@yahoo.com).\n        Copyright (c) 2003 Yee Man Chan. All rights reserved. This program\n        is free software; you can redistribute it and/or modify it under\n        the same terms as Perl itself. Special thanks to Aaron Mackey\n        and WIlliam Pearson for the helpful discussions. [The portion\n        of code inside pgreen subdirectory was borrowed from ssearch. It\n        should be distributed in the same terms as ssearch.]\n\n\npackage Bio::Tools::dpAlign;\n\nuse Bio::SimpleAlign;\n\nuse base qw(Bio::Tools::AlignFactory);\n\n# Gotoh algorithm as defined in J. Mol. Biol. (1982) 162, 705-708\n# use constant DSW_GOTOH => 1;\n# Hirschberg's algorithm as defined in Myers & Miller in \n# CABIOS, Vol 4, No. 1, 1988, p 11-17\n# This algorithm is used in both the search phase and the\n# alignment phase.\nuse constant DPALIGN_LOCAL_MILLER_MYERS => 1;\nuse constant DPALIGN_GLOBAL_MILLER_MYERS => 2;\nuse constant DPALIGN_ENDSFREE_MILLER_MYERS => 3;\n# my toy algorithm that tries to do SW as fast as possible\n# use constant DSW_FSW => 3; \n# Phil Green's approximation to Smith-Waterman. It avoid calculations\n# that might result in a score less than the opening gap penalty.\n# This is the algorithm used by ssearch. Phil Green's algorithm is\n# used in the search phase while Miller-Myers algorithm is used in\n# the alignment phase\n#use constant DPALIGN_LOCAL_GREEN => 2; \n\nBEGIN {\n    eval {\n        require Bio::Ext::Align;\n    };\n    if ( $@ ) {\n        die(\"\\nThe C-compiled engine for Smith Waterman alignments (Align) has not been installed.\\n Please read the install the bioperl-ext package\\n\\n\");\n        exit(1);\n    }\n}\n\nsub new {\n   my ($class, @args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   my ($match, $mismatch, $gap, $ext, $alg, $matrix) = $self->_rearrange([qw(MATCH\n\t\t\t\t\t\t\t\tMISMATCH\n\t\t\t\t\t\t\t\tGAP\n\t\t\t\t\t\t\t\tEXT\n\t\t\t\t\t\t\t\tALG\n\t\t\t\t\t\t\t\tMATRIX\t\n\t\t\t\t\t\t\t)], @args);\n\n   $self->match(3) unless defined $match;\n   $self->mismatch(-1) unless defined $mismatch;\n   $self->gap(3) unless defined $gap;\n   $self->ext(1) unless defined $ext;\n   $self->alg(DPALIGN_LOCAL_MILLER_MYERS) unless defined $alg;\n\n   if (defined $match) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->match($match);\n\t}\n\telse {\n\t    $self->throw(\"Match score must be a number, not [$match]\");\n\t}\n    }\n\n    if (defined $mismatch) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->mismatch($mismatch);\n\t}\n\telse {\n\t    $self->throw(\"Mismatch penalty must be a number, not [$mismatch]\");\n\t}\n    }\n\n    if (defined $gap) {\n\tif ($gap =~ /^\\d+$/) {\n\t    $self->gap($gap);\n\t}\n\telse {\n\t    $self->throw(\"Gap penalty must be a number, not [$gap]\");\n\t}\n    }\n\n    if (defined $ext) {\n\tif ($ext =~ /^\\d+$/) {\n\t    $self->ext($ext);\n\t}\n\telse {\n\t    $self->throw(\"Extension penalty must be a number, not [$ext]\");\n\t}\n    }\n\n    if (defined $alg) {\n\tif ($alg == DPALIGN_LOCAL_MILLER_MYERS or $alg == DPALIGN_GLOBAL_MILLER_MYERS or $alg == DPALIGN_ENDSFREE_MILLER_MYERS) {\n\t    $self->alg($alg);\n\t}\n\telse {\n\t    $self->throw(\"Algorithm must be either 1, 2 or 3\");\n\t}\n    }\n\n    if (defined $matrix and $matrix->isa('Bio::Matrix::MatrixI')) {\n        $self->{'matrix'} = Bio::Ext::Align::ScoringMatrix->new(join(\"\", $matrix->row_names), $self->gap, $self->ext);\n        foreach $rowname ($matrix->row_names) {\n            foreach $colname ($matrix->column_names) {\n                Bio::Ext::Align::ScoringMatrix->set_entry($self->{'matrix'}, $rowname, $colname, $matrix->entry($rowname, $colname));\n            }\n        }\n    }\n    else {\n        $self->{'matrix'} = 0;\n    }\n\n    return $self;\n}\n\n=head2 sequence_profile\n\n Title   : sequence_profile\n Usage   : $prof = $factory->sequence_profile($seq1)\n Function: Makes a dpAlign_SequenceProfile object from one sequence\n Returns : A dpAlign_SequenceProfile object\n Args    : The lone argument is a Bio::PrimarySeqI that we want to \n\t   build a profile for. Usually, this would be the Query sequence\n\n\nsub sequence_profile {\n    my ($self, $seq1) = @_;\n\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI')) {\n        $self->warn(\"Cannot call sequence_profilewithout specifing one sequence (Bio::PrimarySeqI object)\");\n        return;\n    }\n\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2) {\n        $self->warn(\"cannot create sequence profile with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n\n    if ($seq1->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::SequenceProfile->dna_new($seq1->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'});\n    }\n    elsif ($seq1->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::SequenceProfile->protein_new($seq1->seq, $self->{'matrix'}); \n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment_score\n\n Title   : pairwise_alignment_score\n Usage   : $score = $factory->pairwise_alignment_score($prof,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : An integer that is the score of the optimal alignment.\n Args    : The first argument is the sequence profile obtained from a\n\t   call to the sequence_profile function. The second argument \n\t   is a Bio::PrimarySeqI object to be aligned. The second argument\n\t   is usually a sequence in the database sequence. Note\n\t   that this function only uses Phil Green's algorithm and \n\t   therefore theoretically may not always give you the optimal\n\t   score.\n\n\nsub pairwise_alignment_score {\n    my ($self, $prof, $seq2) = @_;\n\n    if( ! defined $prof || ! $prof->isa('Bio::Ext::Align::SequenceProfile') || \n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment_score without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq2->length() < 2) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($prof->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::Score_DNA_Sequences($prof, $seq2->seq);\n    }\n    elsif ($prof->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::Score_Protein_Sequences($prof, $seq2->seq);\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment\n\n Title   : pairwise_alignment\n Usage   : $aln = $factory->pairwise_alignment($seq1,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : A SimpleAlign object if there is an alignment with positive\n\t   score. Otherwise, return undef.\n Args    : The first and second arguments are both Bio::PrimarySeqI\n\t   objects that are to be aligned.\n\n\nsub pairwise_alignment {\n    my ($self, $seq1, $seq2) = @_;\n    my ($aln, $out);\n\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 ||\n        $seq2->length() < 2 ) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($seq1->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\t$aln = Bio::Ext::Align::Align_DNA_Sequences($seq1->seq, $seq2->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'}, $self->{'alg'});\n    }\n    elsif ($seq1->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\t$aln = Bio::Ext::Align::Align_Protein_Sequences($seq1->seq, $seq2->seq, $self->{'matrix'}, $self->{'alg'});\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n\n    if (not defined $aln or $aln == 0) {\n\treturn;\n    }\n\n    $out = Bio::SimpleAlign->new();\n\n    $out->add_seq(Bio::LocatableSeq->new(-seq => $aln->aln1,\n\t\t\t\t\t -start => $aln->start1,\n\t\t\t\t\t -end => $aln->end1,\n\t\t\t\t\t -id => $seq1->id));\n    \n    $out->add_seq(Bio::LocatableSeq->new(-seq => $aln->aln2,\n\t\t\t\t\t -start => $aln->start2,\n\t\t\t\t\t -end => $aln->end2,\n\t\t\t\t\t -id => $seq2->id));\n    $out->score($aln->score);\n    return $out;\n}\n\n=head2 align_and_show\n\n Title   : align_and_show\n Usage   : $factory->align_and_show($seq1,$seq2,STDOUT)\n\n\nsub align_and_show {\n    my ($self, $seq1, $seq2, $fh) = @_;\n    my ($aln, $out);\n\n    if (! defined $fh) {\n\t$fh = \\*STDOUT;\n    }\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 ||\n        $seq2->length() < 2 ) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($seq1->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\t$aln = Bio::Ext::Align::Align_DNA_Sequences($seq1->seq, $seq2->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'}, $self->{'alg'});\n    }\n    elsif ($seq1->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\t$aln = Bio::Ext::Align::Align_Protein_Sequences($seq1->seq, $seq2->seq, $self->{'matrix'}, $self->{'alg'});\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n    }\n\n    $out = Bio::Ext::Align::AlnBlock->new();\n    my $s1 = Bio::Ext::Align::AlnSequence->new();\n    my $s2 = Bio::Ext::Align::AlnSequence->new();\n    my $a1 = $aln->aln1;\n    my $a2 = $aln->aln2;\n    my $first_col = undef;\n    my $last_col = undef;\n    my $col;\n    my $alu1;\n    my $alu2;\n    my $g1 = 0;\n    my $g2 = 0;\n\n# construct AlnBlock\n    for (my $i = 0; $i < length($a1); ++$i) {\n\t$col = Bio::Ext::Align::AlnColumn->new();\n\t$alu1 = Bio::Ext::Align::AlnUnit->new();\n\t$alu2 = Bio::Ext::Align::AlnUnit->new();\n\t$first_col = $col unless defined $first_col;\n\tBio::Ext::Align::AlnColumn::set_next($last_col, $col) if defined $last_col;\n\t\n\tif (substr($a1, $i, 1) eq \"-\") {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"INSERT\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"SEQUENCE\");\n\t    ++$g1;\n\t}\n\telsif (substr($a2, $i, 1) eq \"-\") {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"SEQUENCE\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"INSERT\");\n\t    ++$g2;\n\t}\n\telse {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"SEQUENCE\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"SEQUENCE\");\n\t}\n\n\tBio::Ext::Align::AlnUnit::set_start($alu1, $aln->start1+$i-$g1-2);\n\tBio::Ext::Align::AlnUnit::set_end($alu1, $aln->start1+$i-$g1-2);\n\tBio::Ext::Align::AlnUnit::set_start($alu2, $aln->start2+$i-$g2-2);\n\tBio::Ext::Align::AlnUnit::set_end($alu2, $aln->start2+$i-$g2-2);\n\tBio::Ext::Align::AlnColumn::add_alu($col, $alu1);\n\tBio::Ext::Align::AlnColumn::add_alu($col, $alu2);\n\t$last_col = $col;\n    }\n    Bio::Ext::Align::AlnBlock::set_start($out, $first_col);\n    $col = Bio::Ext::Align::AlnColumn->new();\n    $alu1 = Bio::Ext::Align::AlnUnit->new();\n    $alu2 = Bio::Ext::Align::AlnUnit->new();\n    Bio::Ext::Align::AlnUnit::set_start($alu1, $aln->end1);\n    Bio::Ext::Align::AlnUnit::set_end($alu1, $aln->end1);\n    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"END\");\n    Bio::Ext::Align::AlnUnit::set_start($alu2, $aln->end2);\n    Bio::Ext::Align::AlnUnit::set_end($alu2, $aln->end2);\n    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"END\");\n    Bio::Ext::Align::AlnColumn::add_alu($col, $alu1);\n    Bio::Ext::Align::AlnColumn::add_alu($col, $alu2);\n    Bio::Ext::Align::AlnColumn::set_next($last_col, $col);\n\n    &Bio::Ext::Align::write_pretty_str_align($out,$seq1->id,$seq1->seq,$seq2->id,$seq2->seq,12,50,$fh);\n}\n\n=head2 match\n\n Title     : match \n Usage     : $match = $factory->match() #get\n           : $factory->match($value) #set\n Function  : the set get for the match score\n Example   :\n Returns   : match value\n Arguments : new value\n\n\nsub match {\n    my ($self,$val) = @_;\n\n\n    if( defined $val ) {\n        if( $val < 0 ) {    # Fixed so that match==0 is allowed /AE\n            $self->throw(\"Can't have a match score less than 0\");\n        }\n        $self->{'match'} = $val;\n    }\n    return $self->{'match'};\n}\n\n=head2 mismatch\n\n Title     : mismatch \n Usage     : $mismatch = $factory->mismatch() #get\n           : $factory->mismatch($value) #set\n Function  : the set get for the mismatch penalty\n Example   :\n Returns   : mismatch value\n Arguments : new value\n\n\nsub mismatch {\n    my ($self,$val) = @_;\n\n\n    if( defined $val ) {\n        if( $val > 0 ) {    # Fixed so that mismatch==0 is allowed /AE\n            $self->throw(\"Can't have a mismatch penalty greater than 0\");\n        }\n        $self->{'mismatch'} = $val;\n    }\n    return $self->{'mismatch'};\n}\n\n\n=head2 gap\n\n Title     : gap\n Usage     : $gap = $factory->gap() #get\n           : $factory->gap($value) #set\n Function  : the set get for the gap penalty\n Example   :\n Returns   : gap value\n Arguments : new value\n\n\nsub gap {\n    my ($self,$val) = @_;\n\n\n    if( defined $val ) {\n        if( $val < 0 ) {    # Fixed so that gap==0 is allowed /AE\n            $self->throw(\"Can't have a gap penalty less than 0\");\n        }\n        $self->{'gap'} = $val;\n    }\n    return $self->{'gap'};\n}\n\n=head2 ext\n\n Title     : ext\n Usage     : $ext = $factory->ext() #get\n           : $factory->ext($value) #set\n Function  : the set get for the ext penalty\n Example   :\n Returns   : ext value\n Arguments : new value","label":"ext($self,$val)"},"kind":12,"range":{"end":{"character":9999,"line":695},"start":{"character":0,"line":685}},"line":685},{"signature":{"label":"alg($self,$val)","documentation":"1;\n## $Id: dpAlign.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n# BioPerl module for Bio::Tools::dpAlign\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Yee Man Chan <ymc@yahoo.com>\n#\n# Copyright Yee Man Chan\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::dpAlign - Perl extension to do pairwise dynamic programming sequence alignment\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::dpAlign;\n  use Bio::SeqIO;\n  use Bio::SimpleAlign;\n  use Bio::AlignIO;\n  use Bio::Matrix::IO;\n\n  $seq1 = Bio::SeqIO->new(-file => $ARGV[0], -format => 'fasta');\n  $seq2 = Bio::SeqIO->new(-file => $ARGV[1], -format => 'fasta');\n\n  # create a dpAlign object\n  # to do global alignment, specify DPALIGN_GLOBAL_MILLER_MYERS\n  # to do ends-free alignment, specify DPALIGN_ENDSFREE_MILLER_MYERS\n  $factory = new dpAlign(-match => 3,\n                     -mismatch => -1,\n                     -gap => 3,\n                     -ext => 1,\n                     -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLER_MYERS);\n\n  # actually do the alignment\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout = Bio::AlignIO->new(-format => 'pfam', -fh => \\*STDOUT);\n  $alnout->write_aln($out);\n\n  # To do protein alignment, set the sequence type to protein\n  # By default all protein alignments are using BLOSUM62 matrix\n  # the gap opening cost is 7 and gap extension is 1. These\n  # values are from ssearch. To use your own custom substitution \n  # matrix, you can create a Bio::Matrix::MatrixI object.\n\n  $parser = Bio::Matrix::IO->new(-format => 'scoring', -file => 'blosum50.mat');\n  $matrix = $parser->next_matrix;\n  $factory = Bio::Tools::dpAlign->new(-matrix => $matrix, -alg => Bio::Tools::dpAlign::DPALIGN_LOCAL_MILLERMYERS);\n  $seq1->alphabet('protein');\n  $seq2->alphabet('protein');\n  $out = $factory->pairwise_alignment($seq1->next_seq, $seq2->next_seq);\n  $alnout->write_aln($out);\n\n  # use the factory to make some output\n\n  $factory->align_and_show($seq1, $seq2, STDOUT);\n\n  # use Phil Green's algorithm to calculate the optimal local\n  # alignment score between two sequences quickly. It is very\n  # useful when you are searching a query sequence in a database\n  # of sequences. Since finding a alignment is more costly \n  # than just calculating scores, you can save time if you only \n  # align sequences that have a high alignment score.\n\n  # To use this feature, first you call the sequence_profile function\n  # to obtain the profile of the query sequence.\n  $profile = $factory->sequence_profile($query);\n\n  %scores = ();\n  # Then use a loop to run a database of sequences against the\n  # profile to obtain a table of alignment scores\n  $dbseq = Bio::SeqIO(-file => 'dbseq.fa', -format => 'fasta');\n  while (defined($seq = $dbseq->next_seq)) {\n      $scores{$seq->id} = $factory->pairwise_alignment_score($profile, $seq);\n  }\n\n=head1 DESCRIPTION\n\nDynamic Programming approach is considered to be the most sensitive\nway to align two biological sequences. There are currently three major\ntypes of dynamic programming algorithms: Global Alignment, Local\nAlignment and Ends-free Alignment.\n\nGlobal Alignment compares two sequences in their entirety.  By\ninserting gaps in the two sequences, it aligns two sequences to\nminimize the edit distance as defined by the gap cost function and the\nsubstitution matrix. Global Alignment is generally applied to two\nsequences that are very similar in length and content.\n\nLocal Alignment instead attempts to find out the subsequences that has\nthe minimal edit distance among all possible subsequences.  It is good\nfor sequences that has a stretch of subsequences that are similar to\neach other.\n\nEnds-free Alignment is a special case of Global Alignment. There are\nno gap penalty imposed for the gaps that extended from the end points\nof two sequences. Therefore it will be a good application when you\nthink one sequence is contained by the other or when you think two\nsequences overlap each other.\n\nDynamic Programming was first introduced by Needleman-Wunsch (1970) to\nglobally align two sequences. The idea of local alignment was later\nintroduced by Smith-Waterman (1981). Gotoh (1982) improved both\nalgorithms by introducing auxillary arrays that reduced the time\ncomplexity of the algorithms to O(m*n).  Miller-Myers (1988) exploits\nthe divide-and-conquer idea introduced by Hirschberg (1975) to solve\nthe affine gap cost dynamic programming using only linear space. At\nthe time of this writing, it is accepted that Miller-Myers is the\nfastest single CPU implementation and using the least memory that is\ntruly equivalent to original algorithm introduced by\nNeedleman-Wunsch. According to Aaron Mackey, Phil Green's SWAT\nimplemention introduced a heuristic that does not consider paths\nthrought the matrix where the score would be less than the gap opening\npenalty, yielding a 1.5-2X speedup on most comparisons. to skip the\ncalculation of some cells. However, his approach is only good for\ncalculating the minimum edit distance and find out the corresponding\nsubsequences (aka search phase). Bill Pearson's popular dynamic\nprogramming alignment program SSEARCH uses Phil Green's algorithm to\nfind the subsequences and then Miller-Myers's algorithm to find the\nactual alignment. (aka alignment phase)\n\nThe current implementation supports local alignment of either DNA\nsequences or protein sequences. It allows you to specify either the\nMiller-Myers Global Alignment (DPALIGN_GLOBAL_MILLER_MYERS) or\nMiller-Myers Local Alignment (DPALIGN_LOCAL_MILLER_MYERS). For DNA\nalignment, you can specify the scores for match, mismatch, gap opening\ncost and gap extension cost. For protein alignment, it is using\nBLOSUM62 by default. Currently the substitution matrix is not\nconfigurable.\n\nNote: If you supply LocatableSeq objects to pairwise_alignment,\npairwise_alignment_score, align_and_show or sequence_profile and\nthe sequence supplied contains gaps, these functions will treat \nthese sequences as if they are without gaps.\n\n=head1 DEPENDENCIES\n\nThis package comes with the main bioperl distribution. You also need\nto install the lastest bioperl-ext package which contains the XS code\nthat implements the algorithms. This package won't work if you haven't\ncompiled the bioperl-ext package.\n\n=head1 TO-DO\n\n\n=over 3\n\n* 1.\n\nBasic support for IUPAC code for DNA sequence is now implemented. \nX will mismatch any character. T will match U. For others, whenever\nthere is a possibility for match, it is considered a full match, for\nexample, W will match B.\n\n* 2.\n\nAllow custom substitution matrix for DNA. Note that for proteins, you\ncan now use your own subsitution matirx.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules.  Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n        This implementation was written by Yee Man Chan (ymc@yahoo.com).\n        Copyright (c) 2003 Yee Man Chan. All rights reserved. This program\n        is free software; you can redistribute it and/or modify it under\n        the same terms as Perl itself. Special thanks to Aaron Mackey\n        and WIlliam Pearson for the helpful discussions. [The portion\n        of code inside pgreen subdirectory was borrowed from ssearch. It\n        should be distributed in the same terms as ssearch.]\n\n\npackage Bio::Tools::dpAlign;\n\nuse Bio::SimpleAlign;\n\nuse base qw(Bio::Tools::AlignFactory);\n\n# Gotoh algorithm as defined in J. Mol. Biol. (1982) 162, 705-708\n# use constant DSW_GOTOH => 1;\n# Hirschberg's algorithm as defined in Myers & Miller in \n# CABIOS, Vol 4, No. 1, 1988, p 11-17\n# This algorithm is used in both the search phase and the\n# alignment phase.\nuse constant DPALIGN_LOCAL_MILLER_MYERS => 1;\nuse constant DPALIGN_GLOBAL_MILLER_MYERS => 2;\nuse constant DPALIGN_ENDSFREE_MILLER_MYERS => 3;\n# my toy algorithm that tries to do SW as fast as possible\n# use constant DSW_FSW => 3; \n# Phil Green's approximation to Smith-Waterman. It avoid calculations\n# that might result in a score less than the opening gap penalty.\n# This is the algorithm used by ssearch. Phil Green's algorithm is\n# used in the search phase while Miller-Myers algorithm is used in\n# the alignment phase\n#use constant DPALIGN_LOCAL_GREEN => 2; \n\nBEGIN {\n    eval {\n        require Bio::Ext::Align;\n    };\n    if ( $@ ) {\n        die(\"\\nThe C-compiled engine for Smith Waterman alignments (Align) has not been installed.\\n Please read the install the bioperl-ext package\\n\\n\");\n        exit(1);\n    }\n}\n\nsub new {\n   my ($class, @args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   my ($match, $mismatch, $gap, $ext, $alg, $matrix) = $self->_rearrange([qw(MATCH\n\t\t\t\t\t\t\t\tMISMATCH\n\t\t\t\t\t\t\t\tGAP\n\t\t\t\t\t\t\t\tEXT\n\t\t\t\t\t\t\t\tALG\n\t\t\t\t\t\t\t\tMATRIX\t\n\t\t\t\t\t\t\t)], @args);\n\n   $self->match(3) unless defined $match;\n   $self->mismatch(-1) unless defined $mismatch;\n   $self->gap(3) unless defined $gap;\n   $self->ext(1) unless defined $ext;\n   $self->alg(DPALIGN_LOCAL_MILLER_MYERS) unless defined $alg;\n\n   if (defined $match) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->match($match);\n\t}\n\telse {\n\t    $self->throw(\"Match score must be a number, not [$match]\");\n\t}\n    }\n\n    if (defined $mismatch) {\n\tif ($match =~ /^\\d+$/) {\n\t    $self->mismatch($mismatch);\n\t}\n\telse {\n\t    $self->throw(\"Mismatch penalty must be a number, not [$mismatch]\");\n\t}\n    }\n\n    if (defined $gap) {\n\tif ($gap =~ /^\\d+$/) {\n\t    $self->gap($gap);\n\t}\n\telse {\n\t    $self->throw(\"Gap penalty must be a number, not [$gap]\");\n\t}\n    }\n\n    if (defined $ext) {\n\tif ($ext =~ /^\\d+$/) {\n\t    $self->ext($ext);\n\t}\n\telse {\n\t    $self->throw(\"Extension penalty must be a number, not [$ext]\");\n\t}\n    }\n\n    if (defined $alg) {\n\tif ($alg == DPALIGN_LOCAL_MILLER_MYERS or $alg == DPALIGN_GLOBAL_MILLER_MYERS or $alg == DPALIGN_ENDSFREE_MILLER_MYERS) {\n\t    $self->alg($alg);\n\t}\n\telse {\n\t    $self->throw(\"Algorithm must be either 1, 2 or 3\");\n\t}\n    }\n\n    if (defined $matrix and $matrix->isa('Bio::Matrix::MatrixI')) {\n        $self->{'matrix'} = Bio::Ext::Align::ScoringMatrix->new(join(\"\", $matrix->row_names), $self->gap, $self->ext);\n        foreach $rowname ($matrix->row_names) {\n            foreach $colname ($matrix->column_names) {\n                Bio::Ext::Align::ScoringMatrix->set_entry($self->{'matrix'}, $rowname, $colname, $matrix->entry($rowname, $colname));\n            }\n        }\n    }\n    else {\n        $self->{'matrix'} = 0;\n    }\n\n    return $self;\n}\n\n=head2 sequence_profile\n\n Title   : sequence_profile\n Usage   : $prof = $factory->sequence_profile($seq1)\n Function: Makes a dpAlign_SequenceProfile object from one sequence\n Returns : A dpAlign_SequenceProfile object\n Args    : The lone argument is a Bio::PrimarySeqI that we want to \n\t   build a profile for. Usually, this would be the Query sequence\n\n\nsub sequence_profile {\n    my ($self, $seq1) = @_;\n\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI')) {\n        $self->warn(\"Cannot call sequence_profilewithout specifing one sequence (Bio::PrimarySeqI object)\");\n        return;\n    }\n\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2) {\n        $self->warn(\"cannot create sequence profile with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n\n    if ($seq1->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::SequenceProfile->dna_new($seq1->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'});\n    }\n    elsif ($seq1->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::SequenceProfile->protein_new($seq1->seq, $self->{'matrix'}); \n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment_score\n\n Title   : pairwise_alignment_score\n Usage   : $score = $factory->pairwise_alignment_score($prof,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : An integer that is the score of the optimal alignment.\n Args    : The first argument is the sequence profile obtained from a\n\t   call to the sequence_profile function. The second argument \n\t   is a Bio::PrimarySeqI object to be aligned. The second argument\n\t   is usually a sequence in the database sequence. Note\n\t   that this function only uses Phil Green's algorithm and \n\t   therefore theoretically may not always give you the optimal\n\t   score.\n\n\nsub pairwise_alignment_score {\n    my ($self, $prof, $seq2) = @_;\n\n    if( ! defined $prof || ! $prof->isa('Bio::Ext::Align::SequenceProfile') || \n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment_score without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq2->length() < 2) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($prof->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\treturn Bio::Ext::Align::Score_DNA_Sequences($prof, $seq2->seq);\n    }\n    elsif ($prof->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\treturn Bio::Ext::Align::Score_Protein_Sequences($prof, $seq2->seq);\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n}\n\n=head2 pairwise_alignment\n\n Title   : pairwise_alignment\n Usage   : $aln = $factory->pairwise_alignment($seq1,$seq2)\n Function: Makes a SimpleAlign object from two sequences\n Returns : A SimpleAlign object if there is an alignment with positive\n\t   score. Otherwise, return undef.\n Args    : The first and second arguments are both Bio::PrimarySeqI\n\t   objects that are to be aligned.\n\n\nsub pairwise_alignment {\n    my ($self, $seq1, $seq2) = @_;\n    my ($aln, $out);\n\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 ||\n        $seq2->length() < 2 ) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($seq1->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\t$aln = Bio::Ext::Align::Align_DNA_Sequences($seq1->seq, $seq2->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'}, $self->{'alg'});\n    }\n    elsif ($seq1->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\t$aln = Bio::Ext::Align::Align_Protein_Sequences($seq1->seq, $seq2->seq, $self->{'matrix'}, $self->{'alg'});\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n\treturn;\n    }\n\n    if (not defined $aln or $aln == 0) {\n\treturn;\n    }\n\n    $out = Bio::SimpleAlign->new();\n\n    $out->add_seq(Bio::LocatableSeq->new(-seq => $aln->aln1,\n\t\t\t\t\t -start => $aln->start1,\n\t\t\t\t\t -end => $aln->end1,\n\t\t\t\t\t -id => $seq1->id));\n    \n    $out->add_seq(Bio::LocatableSeq->new(-seq => $aln->aln2,\n\t\t\t\t\t -start => $aln->start2,\n\t\t\t\t\t -end => $aln->end2,\n\t\t\t\t\t -id => $seq2->id));\n    $out->score($aln->score);\n    return $out;\n}\n\n=head2 align_and_show\n\n Title   : align_and_show\n Usage   : $factory->align_and_show($seq1,$seq2,STDOUT)\n\n\nsub align_and_show {\n    my ($self, $seq1, $seq2, $fh) = @_;\n    my ($aln, $out);\n\n    if (! defined $fh) {\n\t$fh = \\*STDOUT;\n    }\n    if( ! defined $seq1 || ! $seq1->isa('Bio::PrimarySeqI') ||\n        ! defined $seq2 || ! $seq2->isa('Bio::PrimarySeqI') ) {\n        $self->warn(\"Cannot call pairwise_alignment without specifing 2 sequences (Bio::PrimarySeqI objects)\");\n        return;\n    }\n    # fix Jitterbug #1044\n    if( $seq1->length() < 2 ||\n        $seq2->length() < 2 ) {\n        $self->warn(\"cannot align sequences with length less than 2\");\n        return;\n    }\n    if ($seq1->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq1->seq;\n       $seqstr =~ s/\\-//g;\n       $seq1 = Bio::Seq->new(-id => $seq1->id, -seq => $seqstr, -alphabet => $seq1->alphabet);\n    }\n    if ($seq2->isa('Bio::LocatableSeq')) {\n       my $seqstr = $seq2->seq;\n       $seqstr =~ s/\\-//g;\n       $seq2 = Bio::Seq->new(-id => $seq2->id, -seq => $seqstr, -alphabet => $seq2->alphabet);\n    }\n    $self->set_memory_and_report();\n    # create engine objects\n    $seq1->display_id('seq1') unless ( defined $seq1->id() );\n    $seq2->display_id('seq2') unless ( defined $seq2->id() );\n\n    if ($seq1->alphabet eq 'dna' and $seq2->alphabet eq 'dna') {\n\t$aln = Bio::Ext::Align::Align_DNA_Sequences($seq1->seq, $seq2->seq, $self->{'match'}, $self->{'mismatch'}, $self->{'gap'}, $self->{'ext'}, $self->{'alg'});\n    }\n    elsif ($seq1->alphabet eq 'protein' and $seq2->alphabet eq 'protein') {\n\t$aln = Bio::Ext::Align::Align_Protein_Sequences($seq1->seq, $seq2->seq, $self->{'matrix'}, $self->{'alg'});\n    }\n    else {\n\tcroak(\"There is currently no support for the types of sequences you want to align!\\n\");\n    }\n\n    $out = Bio::Ext::Align::AlnBlock->new();\n    my $s1 = Bio::Ext::Align::AlnSequence->new();\n    my $s2 = Bio::Ext::Align::AlnSequence->new();\n    my $a1 = $aln->aln1;\n    my $a2 = $aln->aln2;\n    my $first_col = undef;\n    my $last_col = undef;\n    my $col;\n    my $alu1;\n    my $alu2;\n    my $g1 = 0;\n    my $g2 = 0;\n\n# construct AlnBlock\n    for (my $i = 0; $i < length($a1); ++$i) {\n\t$col = Bio::Ext::Align::AlnColumn->new();\n\t$alu1 = Bio::Ext::Align::AlnUnit->new();\n\t$alu2 = Bio::Ext::Align::AlnUnit->new();\n\t$first_col = $col unless defined $first_col;\n\tBio::Ext::Align::AlnColumn::set_next($last_col, $col) if defined $last_col;\n\t\n\tif (substr($a1, $i, 1) eq \"-\") {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"INSERT\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"SEQUENCE\");\n\t    ++$g1;\n\t}\n\telsif (substr($a2, $i, 1) eq \"-\") {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"SEQUENCE\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"INSERT\");\n\t    ++$g2;\n\t}\n\telse {\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"SEQUENCE\");\n\t    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"SEQUENCE\");\n\t}\n\n\tBio::Ext::Align::AlnUnit::set_start($alu1, $aln->start1+$i-$g1-2);\n\tBio::Ext::Align::AlnUnit::set_end($alu1, $aln->start1+$i-$g1-2);\n\tBio::Ext::Align::AlnUnit::set_start($alu2, $aln->start2+$i-$g2-2);\n\tBio::Ext::Align::AlnUnit::set_end($alu2, $aln->start2+$i-$g2-2);\n\tBio::Ext::Align::AlnColumn::add_alu($col, $alu1);\n\tBio::Ext::Align::AlnColumn::add_alu($col, $alu2);\n\t$last_col = $col;\n    }\n    Bio::Ext::Align::AlnBlock::set_start($out, $first_col);\n    $col = Bio::Ext::Align::AlnColumn->new();\n    $alu1 = Bio::Ext::Align::AlnUnit->new();\n    $alu2 = Bio::Ext::Align::AlnUnit->new();\n    Bio::Ext::Align::AlnUnit::set_start($alu1, $aln->end1);\n    Bio::Ext::Align::AlnUnit::set_end($alu1, $aln->end1);\n    Bio::Ext::Align::AlnUnit::set_text_label($alu1, \"END\");\n    Bio::Ext::Align::AlnUnit::set_start($alu2, $aln->end2);\n    Bio::Ext::Align::AlnUnit::set_end($alu2, $aln->end2);\n    Bio::Ext::Align::AlnUnit::set_text_label($alu2, \"END\");\n    Bio::Ext::Align::AlnColumn::add_alu($col, $alu1);\n    Bio::Ext::Align::AlnColumn::add_alu($col, $alu2);\n    Bio::Ext::Align::AlnColumn::set_next($last_col, $col);\n\n    &Bio::Ext::Align::write_pretty_str_align($out,$seq1->id,$seq1->seq,$seq2->id,$seq2->seq,12,50,$fh);\n}\n\n=head2 match\n\n Title     : match \n Usage     : $match = $factory->match() #get\n           : $factory->match($value) #set\n Function  : the set get for the match score\n Example   :\n Returns   : match value\n Arguments : new value\n\n\nsub match {\n    my ($self,$val) = @_;\n\n\n    if( defined $val ) {\n        if( $val < 0 ) {    # Fixed so that match==0 is allowed /AE\n            $self->throw(\"Can't have a match score less than 0\");\n        }\n        $self->{'match'} = $val;\n    }\n    return $self->{'match'};\n}\n\n=head2 mismatch\n\n Title     : mismatch \n Usage     : $mismatch = $factory->mismatch() #get\n           : $factory->mismatch($value) #set\n Function  : the set get for the mismatch penalty\n Example   :\n Returns   : mismatch value\n Arguments : new value\n\n\nsub mismatch {\n    my ($self,$val) = @_;\n\n\n    if( defined $val ) {\n        if( $val > 0 ) {    # Fixed so that mismatch==0 is allowed /AE\n            $self->throw(\"Can't have a mismatch penalty greater than 0\");\n        }\n        $self->{'mismatch'} = $val;\n    }\n    return $self->{'mismatch'};\n}\n\n\n=head2 gap\n\n Title     : gap\n Usage     : $gap = $factory->gap() #get\n           : $factory->gap($value) #set\n Function  : the set get for the gap penalty\n Example   :\n Returns   : gap value\n Arguments : new value\n\n\nsub gap {\n    my ($self,$val) = @_;\n\n\n    if( defined $val ) {\n        if( $val < 0 ) {    # Fixed so that gap==0 is allowed /AE\n            $self->throw(\"Can't have a gap penalty less than 0\");\n        }\n        $self->{'gap'} = $val;\n    }\n    return $self->{'gap'};\n}\n\n=head2 ext\n\n Title     : ext\n Usage     : $ext = $factory->ext() #get\n           : $factory->ext($value) #set\n Function  : the set get for the ext penalty\n Example   :\n Returns   : ext value\n Arguments : new value\n\n\nsub ext {\n    my ($self,$val) = @_;\n\n    if( defined $val ) {\n        if( $val < 0 ) {    # Fixed so that ext==0 is allowed /AE\n            $self->throw(\"Can't have a extension penalty less than 0\");\n        }\n        $self->{'ext'} = $val;\n    }\n    return $self->{'ext'};\n}\n\n=head2 alg\n\n Title     : alg\n Usage     : $alg = $factory->alg() #get\n           : $factory->alg($value) #set\n Function  : the set get for the algorithm\n Example   :\n Returns   : alg value\n Arguments : new value","parameters":[{"label":"$self"},{"label":"$val"}]},"range":{"start":{"line":709,"character":0},"end":{"character":9999,"line":719}},"kind":12,"line":709,"detail":"($self,$val)","definition":"sub","containerName":"main::","name":"alg","children":[{"line":710,"name":"$self","containerName":"alg","localvar":"my","kind":13,"definition":"my"},{"containerName":"alg","kind":13,"name":"$val","line":710},{"line":712,"kind":13,"containerName":"alg","name":"$val"},{"name":"$val","containerName":"alg","kind":13,"line":713},{"line":713,"name":"$val","containerName":"alg","kind":13},{"line":713,"containerName":"alg","kind":13,"name":"$val"},{"line":714,"name":"$self","kind":13,"containerName":"alg"},{"name":"throw","kind":12,"containerName":"alg","line":714},{"kind":13,"containerName":"alg","name":"$self","line":716},{"line":716,"name":"$val","kind":13,"containerName":"alg"},{"line":718,"containerName":"alg","kind":13,"name":"$self"}]},{"name":"DPALIGN_LOCAL_MILLER_MYERS","kind":12,"line":713},{"name":"DPALIGN_GLOBAL_MILLER_MYERS","kind":12,"line":713},{"name":"DPALIGN_ENDSFREE_MILLER_MYERS","kind":12,"line":713}]}