{"vars":[{"name":"base","kind":2,"containerName":"","line":88},{"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Tmhmm.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Tmhmm\n#\n# Original copyright Balamurugan Kumarasamy\n# Re-written cleanly by Torsten Seemann, Sep 2006\n#\n# Copyright:\n# You may distribute this module under the same terms as Perl itself\n\n=head1 NAME\n\nBio::Tools::Tmhmm - parse TMHMM output (TransMembrane HMM)\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Tmhmm;\n  my $parser = Bio::Tools::Tmhmm->new(-fh => $filehandle );\n  while ( my $tmhmm_feat = $parser->next_result ) {\n     # do something, e.g.\n     push @tmhmm_feat, $tmhmm_feat;\n  }\n\n=head1 DESCRIPTION\n\nTMHMM is software for the prediction of transmembrane helices in proteins.\nSee  L<http://www.cbs.dtu.dk/services/TMHMM/> for more details.\n\nThis module parses the \"long output\" format of TMHMM 2.0 and\ncreates a Bio:SeqFeature::Generic object for each C<TMHelix> feature found\nfrom lines like this:\n\n  my_sequence_id  TMHMM2.0  TMhelix     54    76\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Torsten Seemann\n\nEmail torsten.seemann AT infotech.monash.edu.au\n\n=head1 CONTRIBUTOR - Bala\n\nEmail savikalpa@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::Tmhmm;\n\nuse strict;\n\nuse Bio::Tools::AnalysisResult;\nuse Bio::Root::Root;\nuse Bio::Root::IO;\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::Tools::AnalysisResult);\n\nuse Bio::SeqFeature::Generic;\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Tmhmm->new();\n Function: Builds a new Bio::Tools::Tmhmm object\n Returns : Bio::Tools::Tmhmm\n Args    : Either of the following as per L<Bio::Root::IO> interface\n             -fh   => $filehandle \n             -file => $filename"},"range":{"end":{"character":9999,"line":110},"start":{"character":0,"line":105}},"kind":12,"line":105,"detail":"($class,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"definition":"my","line":106,"localvar":"my","kind":13,"containerName":"new","name":"$class"},{"line":106,"kind":13,"containerName":"new","name":"@args"},{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"$self","line":107},{"line":107,"name":"$class","containerName":"new","kind":13},{"name":"@args","containerName":"new","kind":13,"line":107},{"kind":13,"containerName":"new","name":"$self","line":108},{"line":108,"name":"_initialize_io","containerName":"new","kind":12},{"containerName":"new","kind":13,"name":"@args","line":108},{"kind":13,"containerName":"new","name":"$self","line":109}]},{"line":106,"name":"Generic","kind":2,"containerName":"Bio::SeqFeature"},{"name":"SUPER","containerName":"new","kind":12,"line":107},{"definition":"sub","containerName":"main::","name":"next_result","children":[{"definition":"my","line":124,"kind":13,"localvar":"my","containerName":"next_result","name":"$self"},{"definition":"my","name":"$line","localvar":"my","containerName":"next_result","kind":13,"line":131},{"containerName":"next_result","kind":13,"name":"$self","line":131},{"name":"_readline","containerName":"next_result","kind":12,"line":131},{"line":132,"name":"$line","containerName":"next_result","kind":13},{"line":133,"kind":12,"containerName":"next_result","name":"new"}],"range":{"start":{"character":0,"line":123},"end":{"character":9999,"line":142}},"kind":12,"line":123},{"name":"Bio","kind":12,"containerName":"SeqFeature::Generic","line":133}],"version":5}