{"version":5,"vars":[{"containerName":"","kind":2,"name":"base","line":129},{"line":140,"kind":12,"range":{"start":{"character":0,"line":140},"end":{"line":147,"character":9999}},"signature":{"parameters":[{"label":"$proto"},{"label":"%args"}],"documentation":"1;\n# BioPerl module for Bio::Tools::SiRNA::Ruleset::saigo\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Bristol-Myers Squibb\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::SiRNA::Ruleset::saigo - Perl object implementing the Saigo\ngroup's rules for designing small inhibitory RNAs\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Instead, use Bio::Tools::SiRNA and\nspecify the saigo ruleset:\n\n  use Bio::Tools::SiRNA;\n\n  my $sirna_designer = Bio::Tools::SiRNA->new( -target => $bio_seq,\n                                               -rules  => 'saigo'\n    );\n  my @pairs = $sirna_designer->design;\n\n  foreach $pair (@pairs) {\n      my $sense_oligo_sequence = $pair->sense->seq;\n      my $antisense_oligo_sequence = $pair->antisense->seq;\n\n      # print out results\n      print join (\"\\t\", $pair->start, $pair->end, $pair->rank,\n                  $sense_oligo_sequence, $antisense_oligo_sequence), \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis package implements the rules for designing siRNA reagents\npublished by Ui-Tei et al (2004).  The rules are:\n\n=over 5\n\n* 1.\n\nThe first base in the sense strand of the duplex must be a G or C\n\n* 2.\n\nThe first base in the antisense strand of the duplex must be an A or U\n\n* 3.\n\nThe first 7 nucleotides in the antisense strand of the duplex must be\nA or U\n\n* 4.\n\nThere cannot be more than 9 consecutive G or C nucleotides\n\n* 5.\n\nThe first 12 nucleotides in the sense strand of the duplex should have\n33-66% GC\n\n\nThe module inherits from Bio::Tools::SiRNA.  See the documentation for\nthat module for information on how to specify the target and recover\nthe SiRNA duplex information.\n\n=head2 EXPORT\n\nNone.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::SiRNA>, \nL<Bio::SeqFeature::SiRNA::Pair>,\nL<Bio::SeqFeature::SiRNA::Oligo>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDonald Jackson (donald.jackson@bms.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::SiRNA::Ruleset::saigo;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Tools::SiRNA);\n\n=head2 new\n\n  Title\t: new\n  Usage  : Do not call directly - use Bio::Tools::SiRNA->new instead.\n  Returns : Bio::Tools::SiRNA::Ruleset::saigo object\n  Args\t: none","label":"new($proto,%args)"},"children":[{"definition":"my","name":"$proto","containerName":"new","localvar":"my","kind":13,"line":141},{"line":141,"name":"%args","kind":13,"containerName":"new"},{"line":142,"localvar":"my","kind":13,"containerName":"new","name":"$class","definition":"my"},{"line":142,"kind":13,"containerName":"new","name":"$proto"},{"line":142,"containerName":"new","kind":13,"name":"$proto"},{"kind":13,"containerName":"new","name":"$args","line":144},{"line":146,"kind":13,"containerName":"new","name":"$class"},{"containerName":"new","kind":13,"name":"%args","line":146}],"name":"new","containerName":"main::","definition":"sub","detail":"($proto,%args)"},{"line":146,"containerName":"new","kind":12,"name":"SUPER"},{"containerName":"main::","name":"_get_oligos","children":[{"definition":"my","containerName":"_get_oligos","localvar":"my","kind":13,"name":"$self","line":150},{"name":"$targseq","containerName":"_get_oligos","localvar":"my","kind":13,"line":152,"definition":"my"},{"line":152,"containerName":"_get_oligos","kind":13,"name":"$targstart"},{"kind":13,"containerName":"_get_oligos","name":"$self","line":152},{"containerName":"_get_oligos","kind":12,"name":"_get_targetregion","line":152},{"line":154,"containerName":"_get_oligos","localvar":"my","kind":13,"name":"$i","definition":"my"},{"name":"$targseq","kind":13,"containerName":"_get_oligos","line":154},{"localvar":"my","containerName":"_get_oligos","kind":13,"name":"$testseq","line":155,"definition":"my"},{"line":155,"name":"$targseq","containerName":"_get_oligos","kind":13},{"name":"$i","containerName":"_get_oligos","kind":13,"line":155},{"kind":13,"containerName":"_get_oligos","name":"$self","line":156},{"containerName":"_get_oligos","kind":12,"name":"add_oligos","line":156},{"line":156,"name":"$testseq","kind":13,"containerName":"_get_oligos"},{"line":156,"containerName":"_get_oligos","kind":13,"name":"$targstart"},{"line":156,"name":"$i","kind":13,"containerName":"_get_oligos"},{"containerName":"_get_oligos","kind":13,"name":"$self","line":156},{"name":"_oligo_ok","kind":12,"containerName":"_get_oligos","line":156},{"line":156,"name":"$testseq","kind":13,"containerName":"_get_oligos"}],"detail":"($self)","definition":"sub","range":{"end":{"character":9999,"line":158},"start":{"character":0,"line":149}},"kind":12,"line":149,"signature":{"label":"_get_oligos($self)","parameters":[{"label":"$self"}],"documentation":""}},{"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$target"}],"label":"_get_sense($self,$target)"},"range":{"start":{"line":161,"character":0},"end":{"line":169,"character":9999}},"kind":12,"line":161,"detail":"($self,$target)","definition":"sub","name":"_get_sense","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"_get_sense","kind":13,"line":162,"definition":"my"},{"containerName":"_get_sense","kind":13,"name":"$target","line":162},{"name":"$target","kind":13,"containerName":"_get_sense","line":164},{"line":166,"name":"$target","kind":13,"containerName":"_get_sense"},{"line":168,"name":"$target","kind":13,"containerName":"_get_sense"}]},{"name":"_get_anti","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_get_anti","line":172},{"line":172,"name":"$target","containerName":"_get_anti","kind":13},{"definition":"my","line":173,"name":"@target","kind":13,"localvar":"my","containerName":"_get_anti"},{"name":"$target","kind":13,"containerName":"_get_anti","line":173},{"localvar":"my","containerName":"_get_anti","kind":13,"name":"$nt","line":174,"definition":"my"},{"line":174,"name":"@antitarget","kind":13,"containerName":"_get_anti"},{"line":176,"containerName":"_get_anti","kind":13,"name":"$nt"},{"containerName":"_get_anti","kind":13,"name":"@target","line":176},{"name":"@antitarget","containerName":"_get_anti","kind":13,"line":177},{"containerName":"_get_anti","kind":13,"name":"$self","line":177},{"line":177,"name":"_comp","kind":12,"containerName":"_get_anti"},{"name":"$nt","kind":13,"containerName":"_get_anti","line":177},{"line":179,"name":"$anti","kind":13,"localvar":"my","containerName":"_get_anti","definition":"my"},{"name":"@antitarget","containerName":"_get_anti","kind":13,"line":179},{"line":181,"name":"$anti","kind":13,"containerName":"_get_anti"},{"line":183,"name":"$anti","containerName":"_get_anti","kind":13},{"name":"$anti","kind":13,"containerName":"_get_anti","line":185}],"detail":"($self,$target)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":171},"end":{"line":186,"character":9999}},"line":171,"signature":{"label":"_get_anti($self,$target)","documentation":"","parameters":[{"label":"$self"},{"label":"$target"}]}},{"children":[{"localvar":"my","kind":13,"containerName":"_oligo_ok","name":"$self","line":189,"definition":"my"},{"line":189,"containerName":"_oligo_ok","kind":13,"name":"$testseq"},{"containerName":"_oligo_ok","kind":13,"name":"$self","line":191},{"kind":12,"containerName":"_oligo_ok","name":"debug","line":191},{"definition":"my","line":193,"kind":13,"localvar":"my","containerName":"_oligo_ok","name":"@testseq"},{"name":"$testseq","containerName":"_oligo_ok","kind":13,"line":193},{"name":"$testseq","kind":13,"containerName":"_oligo_ok","line":195},{"name":"$self","containerName":"_oligo_ok","kind":13,"line":196},{"line":196,"containerName":"_oligo_ok","kind":12,"name":"debug"},{"name":"$testseq","containerName":"_oligo_ok","kind":13,"line":200},{"line":201,"name":"$self","containerName":"_oligo_ok","kind":13},{"name":"debug","kind":12,"containerName":"_oligo_ok","line":201},{"line":206,"name":"$atcount_3p","localvar":"my","kind":13,"containerName":"_oligo_ok","definition":"my"},{"containerName":"_oligo_ok","kind":13,"name":"@testseq","line":206},{"line":207,"kind":13,"containerName":"_oligo_ok","name":"$atcount_3p"},{"line":208,"kind":13,"containerName":"_oligo_ok","name":"$self"},{"name":"debug","kind":12,"containerName":"_oligo_ok","line":208},{"definition":"my","line":212,"containerName":"_oligo_ok","localvar":"my","kind":13,"name":"$gccount_5p"},{"containerName":"_oligo_ok","kind":13,"name":"@testseq","line":212},{"name":"$gccount_5p","kind":13,"containerName":"_oligo_ok","line":213},{"name":"$self","containerName":"_oligo_ok","kind":13,"line":214},{"line":214,"name":"debug","containerName":"_oligo_ok","kind":12},{"line":217,"kind":13,"containerName":"_oligo_ok","name":"$gccount_5p"},{"name":"$self","kind":13,"containerName":"_oligo_ok","line":218},{"name":"debug","containerName":"_oligo_ok","kind":12,"line":218},{"line":223,"name":"$testseq","containerName":"_oligo_ok","kind":13},{"name":"$self","containerName":"_oligo_ok","kind":13,"line":224},{"kind":12,"containerName":"_oligo_ok","name":"debug","line":224},{"line":228,"containerName":"_oligo_ok","kind":13,"name":"$self"},{"line":228,"name":"debug","containerName":"_oligo_ok","kind":12}],"name":"_oligo_ok","containerName":"main::","definition":"sub","detail":"($self,$testseq)","line":188,"kind":12,"range":{"start":{"line":188,"character":0},"end":{"line":230,"character":9999}},"signature":{"label":"_oligo_ok($self,$testseq)","documentation":"","parameters":[{"label":"$self"},{"label":"$testseq"}]}}]}