{"version":5,"vars":[{"containerName":"","kind":2,"name":"base","line":99},{"line":112,"kind":12,"range":{"start":{"character":0,"line":112},"end":{"line":122,"character":9999}},"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Promoterwise.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::Tools::Promoterwise\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Promoterwise - parser for Promoterwise tab format output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Promoterwise;\n\n  my $pw = Bio::Tools::Promoterwise->new(-file=>\"out\",\n                                         -query1_seq=>$seq1,\n                                         -query2_seq=>$seq2);\n  while (my $fp = $pw->next_result){\n    print \"Hit Length: \".$fp->feature1->length.\"\\n\";\n    print \"Hit Start: \".$fp->feature1->start.\"\\n\";\n    print \"Hit End: \".$fp->feature1->end.\"\\n\";\n    print \"Hsps: \\n\";\n    my @first_hsp = $fp->feature1->sub_SeqFeature;\n    my @second_hsp = $fp->feature2->sub_SeqFeature;\n    foreach my $i (0..$#first_hsp){\n      print $first_hsp[$i]->start. \" \".$first_hsp[$i]->end.\" \".\n            $second_hsp[$i]->start. \" \".$second_hsp[$i]->end.\"\\n\";\n    }\n  }\n\n=head1 DESCRIPTION\n\nPromoteriwise is an alignment algorithm that relaxes the constraint\nthat local alignments have to be co-linear. Otherwise it provides a\nsimilar model to DBA, which is designed for promoter sequence\nalignments.  Promoterwise is written by Ewan Birney.  It is part of\nthe wise2 package available at\nL<ftp://ftp.ebi.ac.uk/pub/software/unix/wise2/>\n\nThis module is the parser for the Promoterwise output in tab format.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Promoterwise;\nuse strict;\n\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Promoterwise->new();\n Function: Builds a new Bio::Tools::Promoterwise object\n Returns : L<Bio::Tools::Promoterwise>\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO"},"children":[{"definition":"my","localvar":"my","containerName":"new","kind":13,"name":"$class","line":113},{"name":"@args","containerName":"new","kind":13,"line":113},{"definition":"my","line":115,"containerName":"new","localvar":"my","kind":13,"name":"$self"},{"line":115,"name":"$class","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"@args","line":115},{"name":"$self","containerName":"new","kind":13,"line":116},{"line":116,"kind":12,"containerName":"new","name":"_initialize_io"},{"name":"@args","kind":13,"containerName":"new","line":116},{"definition":"my","name":"$query1","kind":13,"localvar":"my","containerName":"new","line":117},{"containerName":"new","kind":13,"name":"$query2","line":117},{"line":117,"name":"$self","containerName":"new","kind":13},{"line":117,"name":"_rearrange","containerName":"new","kind":12},{"line":117,"containerName":"new","kind":13,"name":"@args"},{"name":"$self","containerName":"new","kind":13,"line":118},{"containerName":"new","kind":12,"name":"query1_seq","line":118},{"line":118,"containerName":"new","kind":13,"name":"$query1"},{"containerName":"new","kind":13,"name":"$query1","line":118},{"line":119,"kind":13,"containerName":"new","name":"$self"},{"name":"query2_seq","kind":12,"containerName":"new","line":119},{"line":119,"kind":13,"containerName":"new","name":"$query2"},{"line":119,"containerName":"new","kind":13,"name":"$query2"},{"line":121,"containerName":"new","kind":13,"name":"$self"}],"containerName":"main::","name":"new","definition":"sub","detail":"($class,@args)"},{"line":115,"kind":12,"containerName":"new","name":"SUPER"},{"children":[{"line":136,"name":"$self","localvar":"my","kind":13,"containerName":"next_result","definition":"my"},{"name":"$self","kind":13,"containerName":"next_result","line":137},{"line":137,"name":"_parse","kind":12,"containerName":"next_result"},{"line":137,"containerName":"next_result","kind":13,"name":"$self"},{"containerName":"next_result","kind":12,"name":"_parsed","line":137},{"containerName":"next_result","kind":13,"name":"$self","line":138},{"line":138,"kind":12,"containerName":"next_result","name":"_next_result"}],"containerName":"main::","name":"next_result","definition":"sub","detail":"($self)","line":135,"kind":12,"range":{"start":{"character":0,"line":135},"end":{"line":139,"character":9999}},"signature":{"label":"next_result($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Promoterwise.pm 16123 2009-09-17 12:57:27Z cjfields $\n# BioPerl module for Bio::Tools::Promoterwise\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Promoterwise - parser for Promoterwise tab format output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Promoterwise;\n\n  my $pw = Bio::Tools::Promoterwise->new(-file=>\"out\",\n                                         -query1_seq=>$seq1,\n                                         -query2_seq=>$seq2);\n  while (my $fp = $pw->next_result){\n    print \"Hit Length: \".$fp->feature1->length.\"\\n\";\n    print \"Hit Start: \".$fp->feature1->start.\"\\n\";\n    print \"Hit End: \".$fp->feature1->end.\"\\n\";\n    print \"Hsps: \\n\";\n    my @first_hsp = $fp->feature1->sub_SeqFeature;\n    my @second_hsp = $fp->feature2->sub_SeqFeature;\n    foreach my $i (0..$#first_hsp){\n      print $first_hsp[$i]->start. \" \".$first_hsp[$i]->end.\" \".\n            $second_hsp[$i]->start. \" \".$second_hsp[$i]->end.\"\\n\";\n    }\n  }\n\n=head1 DESCRIPTION\n\nPromoteriwise is an alignment algorithm that relaxes the constraint\nthat local alignments have to be co-linear. Otherwise it provides a\nsimilar model to DBA, which is designed for promoter sequence\nalignments.  Promoterwise is written by Ewan Birney.  It is part of\nthe wise2 package available at\nL<ftp://ftp.ebi.ac.uk/pub/software/unix/wise2/>\n\nThis module is the parser for the Promoterwise output in tab format.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Promoterwise;\nuse strict;\n\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Promoterwise->new();\n Function: Builds a new Bio::Tools::Promoterwise object\n Returns : L<Bio::Tools::Promoterwise>\n Args    : -fh/-file => $val, # for initing input, see Bio::Root::IO\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->_initialize_io(@args);\n  my ($query1,$query2) = $self->_rearrange([qw(QUERY1_SEQ QUERY2_SEQ)],@args);\n  $self->query1_seq($query1) if ($query1);\n  $self->query2_seq($query2) if ($query2);\n\n  return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $r = $rpt_masker->next_result\n Function: Get the next result set from parser data\n Returns : an  L<Bio::SeqFeature::FeaturePair>\n Args    : none"}},{"containerName":"main::","name":"_parse","children":[{"definition":"my","line":142,"kind":13,"localvar":"my","containerName":"_parse","name":"$self"},{"containerName":"_parse","localvar":"my","kind":13,"name":"%hash","line":143,"definition":"my"},{"line":143,"name":"@fp","kind":13,"containerName":"_parse"},{"line":144,"containerName":"_parse","kind":13,"name":"$self"},{"line":144,"name":"_readline","containerName":"_parse","kind":12},{"definition":"my","localvar":"my","kind":13,"containerName":"_parse","name":"@array","line":146},{"name":"$hash","kind":13,"containerName":"_parse","line":147},{"name":"$array","kind":13,"containerName":"_parse","line":147},{"line":147,"kind":13,"containerName":"_parse","name":"@array"}],"detail":"($self)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":141},"end":{"character":9999,"line":148}},"line":141,"signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"_parse($self)"}},{"containerName":null,"localvar":"my","kind":13,"name":"$key","line":149,"definition":"my"},{"line":149,"name":"%hash","containerName":null,"kind":13},{"line":150,"name":"$sf1","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"line":150,"containerName":"SeqFeature::Generic","kind":12,"name":"Bio"},{"containerName":"main::","kind":12,"name":"new","line":150},{"line":152,"name":"$sf1","kind":13,"containerName":null},{"line":152,"kind":12,"containerName":"main::","name":"attach_seq"},{"line":152,"name":"$self","kind":13,"containerName":null},{"containerName":"main::","kind":12,"name":"query1_seq","line":152},{"line":152,"name":"$self","containerName":null,"kind":13},{"name":"query1_seq","kind":12,"containerName":"main::","line":152},{"definition":"my","line":153,"containerName":null,"localvar":"my","kind":13,"name":"$sf2"},{"name":"Bio","kind":12,"containerName":"SeqFeature::Generic","line":153},{"kind":12,"containerName":"main::","name":"new","line":153},{"containerName":null,"kind":13,"name":"$sf2","line":155},{"line":155,"containerName":"main::","kind":12,"name":"attach_seq"},{"line":155,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"containerName":"main::","name":"query2_seq","line":155},{"kind":13,"containerName":null,"name":"$self","line":155},{"line":155,"name":"query2_seq","kind":12,"containerName":"main::"},{"line":156,"localvar":"my","containerName":null,"kind":13,"name":"$info","definition":"my"},{"name":"%hash","containerName":null,"kind":13,"line":156},{"containerName":null,"kind":13,"name":"%key","line":156},{"localvar":"my","kind":13,"containerName":null,"name":"$score","line":158,"definition":"my"},{"line":158,"kind":13,"containerName":null,"name":"$id1"},{"line":158,"containerName":null,"kind":13,"name":"$start_1"},{"kind":13,"containerName":null,"name":"$end_1","line":158},{"containerName":null,"kind":13,"name":"$strand_1","line":158},{"kind":13,"containerName":null,"name":"$s1_len","line":158},{"containerName":null,"kind":13,"name":"$id2","line":159},{"line":159,"containerName":null,"kind":13,"name":"$start_2"},{"kind":13,"containerName":null,"name":"$end_2","line":159},{"line":159,"name":"$strand_2","kind":13,"containerName":null},{"line":159,"name":"$s2_len","kind":13,"containerName":null},{"line":159,"containerName":null,"kind":13,"name":"$group"},{"line":160,"kind":13,"containerName":null,"name":"%info"},{"containerName":null,"kind":13,"name":"$score","line":161},{"name":"$id1","containerName":null,"kind":13,"line":161},{"line":161,"name":"$start_1","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$end_1","line":161},{"line":161,"name":"$strand_1","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$s1_len","line":161},{"name":"$id2","containerName":null,"kind":13,"line":162},{"line":162,"containerName":null,"kind":13,"name":"$start_2"},{"line":162,"containerName":null,"kind":13,"name":"$end_2"},{"line":162,"name":"$strand_2","kind":13,"containerName":null},{"name":"$s2_len","kind":13,"containerName":null,"line":162},{"line":162,"containerName":null,"kind":13,"name":"$group"},{"name":"$info","containerName":null,"kind":13,"line":162},{"line":163,"name":"%info","containerName":null,"kind":13},{"name":"$score","kind":13,"containerName":null,"line":164},{"kind":13,"containerName":null,"name":"$id1","line":164},{"name":"$start_1","containerName":null,"kind":13,"line":164},{"name":"$end_1","containerName":null,"kind":13,"line":164},{"line":164,"name":"$strand_1","kind":13,"containerName":null},{"line":165,"containerName":null,"kind":13,"name":"$id2"},{"line":165,"name":"$start_2","kind":13,"containerName":null},{"line":165,"kind":13,"containerName":null,"name":"$end_2"},{"name":"$s2_len","kind":13,"containerName":null,"line":165},{"line":165,"name":"$group","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%info","line":165},{"containerName":null,"kind":13,"name":"$self","line":167},{"line":167,"containerName":"main::","kind":12,"name":"throw"},{"kind":13,"containerName":null,"name":"$info","line":167},{"line":170,"containerName":null,"kind":13,"name":"$sf1"},{"line":170,"containerName":"main::","kind":12,"name":"strand"},{"kind":13,"containerName":null,"name":"$sf2","line":170},{"name":"strand","kind":12,"containerName":"main::","line":170},{"line":171,"kind":13,"containerName":null,"name":"$sf1"},{"name":"strand","containerName":"main::","kind":12,"line":171},{"containerName":null,"kind":13,"name":"$strand_1","line":171},{"kind":13,"containerName":null,"name":"$sf2","line":172},{"line":172,"name":"strand","containerName":"main::","kind":12},{"name":"$strand_2","kind":13,"containerName":null,"line":172},{"line":173,"kind":13,"containerName":null,"name":"$sf1"},{"kind":12,"containerName":"main::","name":"seq_id","line":173},{"name":"$id1","containerName":null,"kind":13,"line":173},{"name":"$sf2","containerName":null,"kind":13,"line":174},{"line":174,"name":"seq_id","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"$id2","line":174},{"line":175,"name":"$sf1","kind":13,"containerName":null},{"line":175,"name":"score","kind":12,"containerName":"main::"},{"containerName":null,"kind":13,"name":"$score","line":175},{"name":"$sf2","containerName":null,"kind":13,"line":176},{"containerName":"main::","kind":12,"name":"score","line":176},{"containerName":null,"kind":13,"name":"$score","line":176},{"definition":"my","line":179,"name":"$sub1","localvar":"my","kind":13,"containerName":null},{"name":"Bio","kind":12,"containerName":"SeqFeature::Generic","line":179},{"name":"new","containerName":"main::","kind":12,"line":179},{"name":"$start_1","kind":13,"containerName":null,"line":179},{"line":180,"containerName":null,"kind":13,"name":"$id1"},{"kind":13,"containerName":null,"name":"$end_1","line":181},{"containerName":null,"kind":13,"name":"$strand_1","line":182},{"line":185,"containerName":null,"kind":13,"name":"$score"},{"kind":13,"containerName":null,"name":"$sub1","line":186},{"name":"attach_seq","kind":12,"containerName":"main::","line":186},{"name":"$self","kind":13,"containerName":null,"line":186},{"containerName":"main::","kind":12,"name":"query1_seq","line":186},{"line":186,"name":"$self","kind":13,"containerName":null},{"line":186,"name":"query1_seq","containerName":"main::","kind":12},{"containerName":null,"localvar":"my","kind":13,"name":"$sub2","line":188,"definition":"my"},{"name":"Bio","containerName":"SeqFeature::Generic","kind":12,"line":188},{"line":188,"name":"new","containerName":"main::","kind":12},{"line":188,"name":"$start_2","kind":13,"containerName":null},{"name":"$id2","containerName":null,"kind":13,"line":189},{"containerName":null,"kind":13,"name":"$end_2","line":190},{"name":"$strand_2","containerName":null,"kind":13,"line":191},{"line":194,"kind":13,"containerName":null,"name":"$score"},{"line":195,"kind":13,"containerName":null,"name":"$sub2"},{"containerName":"main::","kind":12,"name":"attach_seq","line":195},{"name":"$self","containerName":null,"kind":13,"line":195},{"containerName":"main::","kind":12,"name":"query2_seq","line":195},{"line":195,"name":"$self","kind":13,"containerName":null},{"name":"query2_seq","kind":12,"containerName":"main::","line":195},{"line":196,"name":"$sf1","containerName":null,"kind":13},{"line":196,"name":"add_SeqFeature","containerName":"main::","kind":12},{"kind":13,"containerName":null,"name":"$sub1","line":196},{"line":197,"name":"$sf2","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"add_SeqFeature","line":197},{"line":197,"name":"$sub2","kind":13,"containerName":null},{"localvar":"my","kind":13,"containerName":null,"name":"$fp","line":200,"definition":"my"},{"name":"Bio","kind":12,"containerName":"SeqFeature::FeaturePair","line":200},{"containerName":"main::","kind":12,"name":"new","line":200},{"name":"$sf1","containerName":null,"kind":13,"line":200},{"kind":13,"containerName":null,"name":"$sf2","line":201},{"line":202,"name":"@fp","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$fp","line":202},{"line":204,"kind":13,"containerName":null,"name":"$self"},{"line":204,"kind":12,"containerName":"main::","name":"_feature_pairs"},{"line":204,"kind":13,"containerName":null,"name":"@fp"},{"name":"$self","containerName":null,"kind":13,"line":205},{"line":205,"containerName":"main::","kind":12,"name":"_parsed"},{"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_feature_pairs","line":210,"definition":"my"},{"line":210,"name":"$fp","kind":13,"containerName":"_feature_pairs"},{"kind":13,"containerName":"_feature_pairs","name":"$fp","line":211},{"name":"$self","kind":13,"containerName":"_feature_pairs","line":212},{"line":212,"containerName":"_feature_pairs","kind":13,"name":"$fp"},{"containerName":"_feature_pairs","kind":13,"name":"$self","line":214}],"containerName":"main::","name":"_feature_pairs","definition":"sub","detail":"($self,$fp)","line":209,"range":{"start":{"character":0,"line":209},"end":{"line":215,"character":9999}},"kind":12,"signature":{"label":"_feature_pairs($self,$fp)","documentation":"","parameters":[{"label":"$self"},{"label":"$fp"}]}},{"signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"_next_result($self)"},"range":{"start":{"line":217,"character":0},"end":{"line":219,"character":9999}},"kind":12,"line":217,"detail":"($self)","definition":"sub","name":"_next_result","containerName":"main::","children":[{"line":218,"localvar":"my","kind":13,"containerName":"_next_result","name":"$self","definition":"my"},{"name":"$self","kind":13,"containerName":"_next_result","line":219},{"line":219,"name":"$self","containerName":"_next_result","kind":13}]},{"name":"%self","containerName":null,"kind":13,"line":220},{"line":222,"range":{"end":{"character":9999,"line":228},"start":{"line":222,"character":0}},"kind":12,"signature":{"label":"_parsed($self,$flag)","parameters":[{"label":"$self"},{"label":"$flag"}],"documentation":""},"children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_parsed","name":"$self","line":223},{"name":"$flag","kind":13,"containerName":"_parsed","line":223},{"name":"$flag","containerName":"_parsed","kind":13,"line":224},{"kind":13,"containerName":"_parsed","name":"$self","line":225},{"line":227,"containerName":"_parsed","kind":13,"name":"$self"}],"name":"_parsed","containerName":"main::","definition":"sub","detail":"($self,$flag)"},{"signature":{"parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"","label":"query1_seq($self,$val)"},"range":{"end":{"line":236,"character":9999},"start":{"character":0,"line":230}},"kind":12,"line":230,"detail":"($self,$val)","definition":"sub","containerName":"main::","name":"query1_seq","children":[{"kind":13,"localvar":"my","containerName":"query1_seq","name":"$self","line":231,"definition":"my"},{"line":231,"containerName":"query1_seq","kind":13,"name":"$val"},{"name":"$val","kind":13,"containerName":"query1_seq","line":232},{"name":"$self","containerName":"query1_seq","kind":13,"line":233},{"line":233,"name":"$val","containerName":"query1_seq","kind":13},{"line":235,"kind":13,"containerName":"query1_seq","name":"$self"}]},{"definition":"sub","detail":"($self,$val)","children":[{"definition":"my","localvar":"my","containerName":"query2_seq","kind":13,"name":"$self","line":238},{"line":238,"name":"$val","kind":13,"containerName":"query2_seq"},{"name":"$val","containerName":"query2_seq","kind":13,"line":239},{"line":240,"name":"$self","kind":13,"containerName":"query2_seq"},{"containerName":"query2_seq","kind":13,"name":"$val","line":240},{"kind":13,"containerName":"query2_seq","name":"$self","line":242}],"containerName":"main::","name":"query2_seq","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$val"}],"label":"query2_seq($self,$val)"},"line":237,"range":{"start":{"line":237,"character":0},"end":{"line":243,"character":9999}},"kind":12}]}