{"vars":[{"line":77,"name":"base","kind":2,"containerName":""},{"kind":12,"range":{"end":{"character":9999,"line":98},"start":{"line":91,"character":0}},"line":91,"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Prints.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Prints\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by  Balamurugan Kumarasamy\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::Tools::Prints - Parser for FingerPRINTScanII program \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Prints;\n  my $prints_parser = Bio::Tools::Prints->new(-fh =>$filehandle );\n  while( my $prints_feat = $prints_parser->next_result ) {\n        push @prints_feat, $prints_feat;\n  }\n\n=head1 DESCRIPTION\n\n PRINTScan II is a PRINTS fingerprint identification algorithm.\n Copyright (C) 1998,1999  Phil Scordis\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n User feedback is an integral part of the evolution of this and other\n Bioperl modules. Send your comments and suggestions preferably to\n the Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\n Report bugs to the Bioperl bug tracking system to help us keep track\n of the bugs and their resolution. Bug reports can be submitted via\n the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Balamurugan Kumarasamy\n\n bala@tll.org.sg\n juguang@tll.org.sg\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\n\npackage Bio::Tools::Prints;\nuse strict;\n\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Generic;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Prints->new(-fh=>$filehandle);\n Function: Builds a new Bio::Tools::Prints object\n Returns : Bio::Tools::Prints\n Args    : -filename\n           -fh (filehandle)"},"name":"new","containerName":"main::","children":[{"line":92,"localvar":"my","kind":13,"containerName":"new","name":"$class","definition":"my"},{"containerName":"new","kind":13,"name":"@args","line":92},{"name":"$self","containerName":"new","localvar":"my","kind":13,"line":94,"definition":"my"},{"line":94,"kind":13,"containerName":"new","name":"$class"},{"kind":13,"containerName":"new","name":"@args","line":94},{"line":95,"containerName":"new","kind":13,"name":"$self"},{"name":"_initialize_io","containerName":"new","kind":12,"line":95},{"line":95,"name":"@args","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$self","line":97}],"detail":"($class,@args)","definition":"sub"},{"containerName":"new","kind":12,"name":"SUPER","line":94},{"signature":{"label":"next_result($self)","documentation":"1;\n# $Id: Prints.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Prints\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by  Balamurugan Kumarasamy\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::Tools::Prints - Parser for FingerPRINTScanII program \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Prints;\n  my $prints_parser = Bio::Tools::Prints->new(-fh =>$filehandle );\n  while( my $prints_feat = $prints_parser->next_result ) {\n        push @prints_feat, $prints_feat;\n  }\n\n=head1 DESCRIPTION\n\n PRINTScan II is a PRINTS fingerprint identification algorithm.\n Copyright (C) 1998,1999  Phil Scordis\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n User feedback is an integral part of the evolution of this and other\n Bioperl modules. Send your comments and suggestions preferably to\n the Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\n Report bugs to the Bioperl bug tracking system to help us keep track\n of the bugs and their resolution. Bug reports can be submitted via\n the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Balamurugan Kumarasamy\n\n bala@tll.org.sg\n juguang@tll.org.sg\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\n\npackage Bio::Tools::Prints;\nuse strict;\n\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Generic;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Prints->new(-fh=>$filehandle);\n Function: Builds a new Bio::Tools::Prints object\n Returns : Bio::Tools::Prints\n Args    : -filename\n           -fh (filehandle)\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $feat = $prints_parser->next_result\n Function: Get the next result set from parser data\n Returns : L<Bio::SeqFeature::Generic>\n Args    : none","parameters":[{"label":"$self"}]},"kind":12,"range":{"end":{"line":166,"character":9999},"start":{"character":0,"line":111}},"line":111,"detail":"($self)","definition":"sub","containerName":"main::","name":"next_result","children":[{"definition":"my","line":112,"name":"$self","localvar":"my","kind":13,"containerName":"next_result"},{"definition":"my","line":113,"name":"%printsac","localvar":"my","containerName":"next_result","kind":13},{"name":"@features","kind":13,"localvar":"my","containerName":"next_result","line":114,"definition":"my"},{"definition":"my","name":"$line","containerName":"next_result","localvar":"my","kind":13,"line":115},{"definition":"my","localvar":"my","containerName":"next_result","kind":13,"name":"$sequenceId","line":116},{"line":118,"kind":13,"containerName":"next_result","name":"$self"},{"name":"_readline","kind":12,"containerName":"next_result","line":118},{"line":120,"name":"$line","containerName":"next_result","kind":13},{"line":121,"name":"$line","kind":13,"containerName":"next_result"},{"name":"$line","containerName":"next_result","kind":13,"line":123},{"name":"$sequenceId","containerName":"next_result","kind":13,"line":125},{"containerName":"next_result","kind":13,"name":"$line","line":125},{"name":"$self","kind":13,"containerName":"next_result","line":126},{"containerName":"next_result","kind":12,"name":"seqname","line":126},{"containerName":"next_result","kind":13,"name":"$sequenceId","line":126},{"line":130,"containerName":"next_result","kind":13,"name":"$line"},{"line":131,"containerName":"next_result","localvar":"my","kind":13,"name":"$id","definition":"my"},{"name":"$line","containerName":"next_result","kind":13,"line":131},{"definition":"my","localvar":"my","kind":13,"containerName":"next_result","name":"$ac","line":132},{"line":132,"name":"$line","kind":13,"containerName":"next_result"},{"line":133,"kind":13,"containerName":"next_result","name":"$printsac"},{"line":133,"containerName":"next_result","kind":13,"name":"$id"},{"kind":13,"containerName":"next_result","name":"$ac","line":133},{"line":134,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"containerName":"next_result","name":"print_sac","line":134},{"name":"%printsac","kind":13,"containerName":"next_result","line":134},{"line":138,"name":"$line","containerName":"next_result","kind":13},{"line":140,"kind":13,"containerName":"next_result","name":"$line"},{"line":141,"kind":13,"localvar":"my","containerName":"next_result","name":"$num","definition":"my"},{"containerName":"next_result","kind":13,"name":"$line","line":142},{"definition":"my","line":144,"containerName":"next_result","localvar":"my","kind":13,"name":"@elements"},{"line":144,"containerName":"next_result","kind":13,"name":"$line"},{"line":146,"localvar":"my","kind":13,"containerName":"next_result","name":"$fingerprintName","definition":"my"},{"line":146,"containerName":"next_result","kind":13,"name":"$motifNumber"},{"name":"$temp","containerName":"next_result","kind":13,"line":146},{"line":146,"name":"$tot","containerName":"next_result","kind":13},{"name":"$percentageIdentity","kind":13,"containerName":"next_result","line":146},{"kind":13,"containerName":"next_result","name":"$profileScore","line":146},{"line":146,"kind":13,"containerName":"next_result","name":"$pvalue"},{"line":146,"containerName":"next_result","kind":13,"name":"$subsequence"},{"line":146,"containerName":"next_result","kind":13,"name":"$motifLength"},{"line":146,"kind":13,"containerName":"next_result","name":"$lowestMotifPosition"},{"line":146,"name":"$matchPosition","containerName":"next_result","kind":13},{"line":146,"name":"$highestMotifPosition","kind":13,"containerName":"next_result"},{"line":146,"name":"@elements","kind":13,"containerName":"next_result"},{"definition":"my","line":148,"localvar":"my","containerName":"next_result","kind":13,"name":"$start"},{"containerName":"next_result","kind":13,"name":"$matchPosition","line":148},{"line":149,"name":"$end","localvar":"my","kind":13,"containerName":"next_result","definition":"my"},{"name":"$matchPosition","containerName":"next_result","kind":13,"line":149},{"line":149,"name":"$motifLength","containerName":"next_result","kind":13},{"definition":"my","line":150,"name":"$print_sac","kind":13,"localvar":"my","containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$self","line":150},{"line":150,"name":"print_sac","kind":12,"containerName":"next_result"},{"name":"%printsac","localvar":"my","containerName":"next_result","kind":13,"line":152,"definition":"my"},{"line":152,"name":"$print_sac","kind":13,"containerName":"next_result"},{"line":153,"name":"$print","localvar":"my","kind":13,"containerName":"next_result","definition":"my"},{"line":153,"name":"$printsac","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$fingerprintName","line":153},{"definition":"my","containerName":"next_result","localvar":"my","kind":13,"name":"$seqname","line":154},{"line":154,"name":"$self","kind":13,"containerName":"next_result"},{"name":"seqname","containerName":"next_result","kind":12,"line":154},{"name":"$feat","localvar":"my","kind":13,"containerName":"next_result","line":155,"definition":"my"},{"definition":"my","line":156,"localvar":"my","containerName":"next_result","kind":13,"name":"$new_feat"},{"line":156,"kind":13,"containerName":"next_result","name":"$self"},{"line":156,"containerName":"next_result","kind":12,"name":"create_feature"},{"line":156,"containerName":"next_result","kind":13,"name":"$feat"},{"line":156,"name":"$seqname","containerName":"next_result","kind":13},{"line":157,"name":"$new_feat","containerName":"next_result","kind":13},{"line":159,"name":"$line","kind":13,"containerName":"next_result"}]},{"signature":{"label":"create_feature($self,$feat,$sequenceId)","documentation":"1;\n# $Id: Prints.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Prints\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by  Balamurugan Kumarasamy\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::Tools::Prints - Parser for FingerPRINTScanII program \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Prints;\n  my $prints_parser = Bio::Tools::Prints->new(-fh =>$filehandle );\n  while( my $prints_feat = $prints_parser->next_result ) {\n        push @prints_feat, $prints_feat;\n  }\n\n=head1 DESCRIPTION\n\n PRINTScan II is a PRINTS fingerprint identification algorithm.\n Copyright (C) 1998,1999  Phil Scordis\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n User feedback is an integral part of the evolution of this and other\n Bioperl modules. Send your comments and suggestions preferably to\n the Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\n Report bugs to the Bioperl bug tracking system to help us keep track\n of the bugs and their resolution. Bug reports can be submitted via\n the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Balamurugan Kumarasamy\n\n bala@tll.org.sg\n juguang@tll.org.sg\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\n\npackage Bio::Tools::Prints;\nuse strict;\n\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Generic;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Prints->new(-fh=>$filehandle);\n Function: Builds a new Bio::Tools::Prints object\n Returns : Bio::Tools::Prints\n Args    : -filename\n           -fh (filehandle)\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $feat = $prints_parser->next_result\n Function: Get the next result set from parser data\n Returns : L<Bio::SeqFeature::Generic>\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my %printsac;\n    my @features;\n    my $line;\n    my $sequenceId;\n     \n    while ($_=$self->_readline()) {\n      \n           $line = $_;\n           chomp $line;\n\n           if ($line =~ s/^Sn;//) { # We have identified a Sn; line so there should be the following:\n\n              ($sequenceId) = $line =~ /^\\s*(\\w+)/;\n              $self->seqname($sequenceId);\n              next;\n           }\n              \n           if ($line =~ s/^1TBH//) {\n               my  ($id) = $line =~ /^\\s*(\\w+)/;\n               my ($ac) = $line =~ /(PR\\w+)\\s*$/;\n               $printsac{$id} = $ac;\n               $self->print_sac(\\%printsac);\n               next;\n           }\n             \n           if ($line =~ s/^3TB//) {\n              \n              if ($line =~ s/^[HN]//) {\n                   my($num)=\"\";\n                   $line =~ s/^\\s+//;\n\n                   my @elements = split /\\s+/, $line;\n\n                   my ($fingerprintName,$motifNumber,$temp,$tot,$percentageIdentity,$profileScore,$pvalue,$subsequence,$motifLength,$lowestMotifPosition,$matchPosition,$highestMotifPosition) = @elements;\n    \n                   my $start = $matchPosition;\n                   my $end = $matchPosition + $motifLength - 1;\n                   my $print_sac = $self->print_sac;\n                   \n                   my %printsac =  %{$print_sac};\n                   my $print =  $printsac{$fingerprintName};\n                   my $seqname=$self->seqname;\n                   my $feat = \"$print,$start,$end,$percentageIdentity,$profileScore,$pvalue\";\n                   my $new_feat =  $self->create_feature($feat,$seqname);\n                   return $new_feat;\n               }\n               if ($line =~ s/^F//) {\n                   return;  \n               }\n                   next;                                                       \n               }\n            next;         \n \n      }\n\n}\n\n=head2 create_feature\n\n Title   : create_feature\n Usage   : my $feat=$prints_parser->create_feature($feature,$seqname)\n Function: creates a SeqFeature Generic object\n Returns : L<Bio::SeqFeature::FeaturePair>\n Args    :","parameters":[{"label":"$self"},{"label":"$feat"},{"label":"$sequenceId"}]},"line":181,"range":{"start":{"character":0,"line":181},"end":{"line":208,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$feat,$sequenceId)","children":[{"definition":"my","line":182,"name":"$self","containerName":"create_feature","localvar":"my","kind":13},{"name":"$feat","kind":13,"containerName":"create_feature","line":182},{"name":"$sequenceId","containerName":"create_feature","kind":13,"line":182},{"containerName":"create_feature","localvar":"my","kind":13,"name":"@f","line":184,"definition":"my"},{"name":"$feat","kind":13,"containerName":"create_feature","line":184},{"localvar":"my","kind":13,"containerName":"create_feature","name":"$feature","line":186,"definition":"my"},{"kind":12,"containerName":"create_feature","name":"new","line":186},{"line":187,"name":"$sequenceId","containerName":"create_feature","kind":13},{"kind":13,"containerName":"create_feature","name":"$f","line":188},{"line":189,"containerName":"create_feature","kind":13,"name":"$f"},{"line":190,"containerName":"create_feature","kind":13,"name":"$f"},{"containerName":"create_feature","kind":13,"name":"$f","line":192},{"name":"$feature","containerName":"create_feature","kind":13,"line":195},{"name":"add_tag_value","kind":12,"containerName":"create_feature","line":195},{"name":"$f","kind":13,"containerName":"create_feature","line":195},{"line":196,"kind":13,"containerName":"create_feature","name":"$feature"},{"name":"add_tag_value","containerName":"create_feature","kind":12,"line":196},{"name":"$f","containerName":"create_feature","kind":13,"line":196},{"line":198,"localvar":"my","kind":13,"containerName":"create_feature","name":"$feature2","definition":"my"},{"line":198,"name":"new","kind":12,"containerName":"create_feature"},{"line":199,"name":"$f","containerName":"create_feature","kind":13},{"definition":"my","line":203,"name":"$fp","localvar":"my","containerName":"create_feature","kind":13},{"line":203,"containerName":"create_feature","kind":12,"name":"new"},{"name":"$feature","containerName":"create_feature","kind":13,"line":204},{"line":206,"name":"$feature2","kind":13,"containerName":"create_feature"},{"line":207,"containerName":"create_feature","kind":13,"name":"$fp"}],"name":"create_feature","containerName":"main::"},{"line":186,"name":"Bio","containerName":"SeqFeature::Generic","kind":12},{"kind":12,"containerName":"SeqFeature::Generic","name":"Bio","line":198},{"name":"Bio","kind":12,"containerName":"SeqFeature::FeaturePair","line":203},{"children":[{"name":"$self","containerName":"print_sac","localvar":"my","kind":13,"line":222,"definition":"my"},{"line":223,"name":"$self","containerName":"print_sac","kind":13},{"containerName":"print_sac","kind":13,"name":"$self","line":224}],"name":"print_sac","containerName":"main::","definition":"sub","line":221,"kind":12,"range":{"end":{"character":9999,"line":225},"start":{"character":0,"line":221}}},{"kind":12,"range":{"start":{"line":238,"character":0},"end":{"character":9999,"line":242}},"line":238,"signature":{"label":"seqname($self,$seqname)","documentation":"1;\n# $Id: Prints.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Prints\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by  Balamurugan Kumarasamy\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n#\n\n=head1 NAME\n\nBio::Tools::Prints - Parser for FingerPRINTScanII program \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Prints;\n  my $prints_parser = Bio::Tools::Prints->new(-fh =>$filehandle );\n  while( my $prints_feat = $prints_parser->next_result ) {\n        push @prints_feat, $prints_feat;\n  }\n\n=head1 DESCRIPTION\n\n PRINTScan II is a PRINTS fingerprint identification algorithm.\n Copyright (C) 1998,1999  Phil Scordis\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\n User feedback is an integral part of the evolution of this and other\n Bioperl modules. Send your comments and suggestions preferably to\n the Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\n Report bugs to the Bioperl bug tracking system to help us keep track\n of the bugs and their resolution. Bug reports can be submitted via\n the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Balamurugan Kumarasamy\n\n bala@tll.org.sg\n juguang@tll.org.sg\n\n=head1 APPENDIX\n\n The rest of the documentation details each of the object methods.\n Internal methods are usually preceded with a _\n\n\n\npackage Bio::Tools::Prints;\nuse strict;\n\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Generic;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Prints->new(-fh=>$filehandle);\n Function: Builds a new Bio::Tools::Prints object\n Returns : Bio::Tools::Prints\n Args    : -filename\n           -fh (filehandle)\n\n\nsub new {\n      my($class,@args) = @_;\n\n      my $self = $class->SUPER::new(@args);\n      $self->_initialize_io(@args);\n\n      return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $feat = $prints_parser->next_result\n Function: Get the next result set from parser data\n Returns : L<Bio::SeqFeature::Generic>\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my %printsac;\n    my @features;\n    my $line;\n    my $sequenceId;\n     \n    while ($_=$self->_readline()) {\n      \n           $line = $_;\n           chomp $line;\n\n           if ($line =~ s/^Sn;//) { # We have identified a Sn; line so there should be the following:\n\n              ($sequenceId) = $line =~ /^\\s*(\\w+)/;\n              $self->seqname($sequenceId);\n              next;\n           }\n              \n           if ($line =~ s/^1TBH//) {\n               my  ($id) = $line =~ /^\\s*(\\w+)/;\n               my ($ac) = $line =~ /(PR\\w+)\\s*$/;\n               $printsac{$id} = $ac;\n               $self->print_sac(\\%printsac);\n               next;\n           }\n             \n           if ($line =~ s/^3TB//) {\n              \n              if ($line =~ s/^[HN]//) {\n                   my($num)=\"\";\n                   $line =~ s/^\\s+//;\n\n                   my @elements = split /\\s+/, $line;\n\n                   my ($fingerprintName,$motifNumber,$temp,$tot,$percentageIdentity,$profileScore,$pvalue,$subsequence,$motifLength,$lowestMotifPosition,$matchPosition,$highestMotifPosition) = @elements;\n    \n                   my $start = $matchPosition;\n                   my $end = $matchPosition + $motifLength - 1;\n                   my $print_sac = $self->print_sac;\n                   \n                   my %printsac =  %{$print_sac};\n                   my $print =  $printsac{$fingerprintName};\n                   my $seqname=$self->seqname;\n                   my $feat = \"$print,$start,$end,$percentageIdentity,$profileScore,$pvalue\";\n                   my $new_feat =  $self->create_feature($feat,$seqname);\n                   return $new_feat;\n               }\n               if ($line =~ s/^F//) {\n                   return;  \n               }\n                   next;                                                       \n               }\n            next;         \n \n      }\n\n}\n\n=head2 create_feature\n\n Title   : create_feature\n Usage   : my $feat=$prints_parser->create_feature($feature,$seqname)\n Function: creates a SeqFeature Generic object\n Returns : L<Bio::SeqFeature::FeaturePair>\n Args    :\n\n\n\nsub create_feature {\n    my ($self, $feat,$sequenceId) = @_;\n\n    my @f = split (/,/,$feat);\n    # create feature object\n    my $feature= Bio::SeqFeature::Generic->new(\n        -seq_id    =>$sequenceId,\n        -start=>$f[1],\n        -end  => $f[2],\n        -score      => $f[4],\n        -source     => \"PRINTS\",\n        -primary    =>$f[0],\n        -logic_name => \"PRINTS\",\n    );\n    $feature->add_tag_value('evalue',$f[5]);\n    $feature->add_tag_value('percent_id',$f[3]);\n        \n    my $feature2 = Bio::SeqFeature::Generic->new(\n        -seq_id => $f[0],\n        -start => 0,\n        -end => 0,\n    );\n    my $fp = Bio::SeqFeature::FeaturePair->new(\n        -feature1 => $feature,\n        -feature2 => $feature2\n    );\n    return  $fp; \n}\n\n=head2 print_sac\n\n Title   : print_sac\n Usage   : $prints_parser->print_sac($print_sac)\n Function: get/set for print_sac\n Returns :\n Args    :\n\n\n\nsub print_sac {\n    my $self = shift;\n    return $self->{'print_sac'} = shift if @_;\n    return $self->{'print_sac'};\n}\n\n=head2 seqname \n\n Title   : seqname\n Usage   : $prints_parser->seqname($seqname)\n Function: get/set for seqname\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"$seqname"}]},"name":"seqname","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"seqname","line":239},{"kind":13,"containerName":"seqname","name":"$seqname","line":239},{"containerName":"seqname","kind":13,"name":"$self","line":240},{"containerName":"seqname","kind":13,"name":"$seqname","line":240},{"line":240,"name":"$seqname","containerName":"seqname","kind":13},{"name":"$self","kind":13,"containerName":"seqname","line":241}],"detail":"($self,$seqname)","definition":"sub"}],"version":5}