{"vars":[{"line":196,"name":"vars","kind":2,"containerName":""},{"containerName":"","kind":2,"name":"base","line":202},{"line":205,"name":"$RSTFILENAME","containerName":null,"kind":13},{"line":233,"range":{"start":{"character":0,"line":233},"end":{"line":242,"character":9999}},"kind":12,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: PAML.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Phylo::PAML\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich, Aaron J Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::PAML - Parses output from the PAML programs codeml,\nbaseml, basemlg, codemlsites and yn00\n\n=head1 SYNOPSIS\n\n  #!/usr/bin/perl -Tw\n  use strict;\n\n  use Bio::Tools::Phylo::PAML;\n\n  # need to specify the output file name (or a fh) (defaults to\n  # -file => \"codeml.mlc\"); also, optionally, the directory in which\n  # the other result files (rst, 2ML.dS, etc) may be found (defaults\n  # to \"./\")\n  my $parser = Bio::Tools::Phylo::PAML->new\n    (-file => \"./results/mlc\", -dir => \"./results/\");\n\n  # get the first/next result; a Bio::Tools::Phylo::PAML::Result object,\n  # which isa Bio::SeqAnalysisResultI object.\n  my $result = $parser->next_result();\n\n  # get the sequences used in the analysis; returns Bio::PrimarySeq\n  # objects (OTU = Operational Taxonomic Unit).\n  my @otus = $result->get_seqs();\n\n  # codon summary: codon usage of each sequence [ arrayref of {\n  # hashref of counts for each codon } for each sequence and the\n  # overall sum ], and positional nucleotide distribution [ arrayref\n  # of { hashref of frequencies for each nucleotide } for each\n  # sequence and overall frequencies ]:\n  my ($codonusage, $ntdist) = $result->get_codon_summary();\n\n  # example manipulations of $codonusage and $ntdist:\n  printf \"There were %d %s codons in the first seq (%s)\\n\",\n    $codonusage->[0]->{AAA}, 'AAA', $otus[0]->id();\n  printf \"There were %d %s codons used in all the sequences\\n\",\n    $codonusage->[$#{$codonusage}]->{AAA}, 'AAA';\n  printf \"Nucleotide %c was present %g of the time in seq %s\\n\",\n    'A', $ntdist->[1]->{A}, $otus[1]->id();\n\n  # get Nei & Gojobori dN/dS matrix:\n  my $NGmatrix = $result->get_NGmatrix();\n\n  # get ML-estimated dN/dS matrix, if calculated; this corresponds to\n  # the runmode = -2, pairwise comparison usage of codeml\n  my $MLmatrix = $result->get_MLmatrix();\n\n  # These matrices are length(@otu) x length(@otu) \"strict lower\n  # triangle\" 2D-matrices, which means that the diagonal and\n  # everything above it is undefined.  Each of the defined cells is a\n  # hashref of estimates for \"dN\", \"dS\", \"omega\" (dN/dS ratio), \"t\",\n  # \"S\" and \"N\".  If a ML matrix, \"lnL\" and \"kappa\" will also be defined.\n  printf \"The omega ratio for sequences %s vs %s was: %g\\n\",\n    $otus[0]->id, $otus[1]->id, $MLmatrix->[0]->[1]->{omega};\n\n  # with a little work, these matrices could also be passed to\n  # Bio::Tools::Run::Phylip::Neighbor, or other similar tree-building\n  # method that accepts a matrix of \"distances\" (using the LOWTRI\n  # option):\n  my $distmat = [ map { [ map { $$_{omega} } @$_ ] } @$MLmatrix ];\n\n  # for runmode's other than -2, get tree topology with estimated\n  # branch lengths; returns a Bio::Tree::TreeI-based tree object with\n  # added PAML parameters at each node\n  my ($tree) = $result->get_trees();\n  for my $node ($tree->get_nodes()) {\n     # inspect the tree: the \"t\" (time) parameter is available via\n     # $node->branch_length(); all other branch-specific parameters\n     # (\"omega\", \"dN\", etc.) are available via \n     # ($omega) = $node->get_tag_values('omega');\n  }\n\n  # if you are using model based Codeml then trees are stored in each \n  # modelresult object\n  for my $modelresult ( $result->get_NSSite_results ) {\n    # model M0, M1, etc\n    print \"model is \", $modelresult->model_num, \"\\n\";\n    my ($tree) = $modelresult->get_trees();\n    for my $node ($tree->get_nodes()) {\n     # inspect the tree: the \"t\" (time) parameter is available via\n     # $node->branch_length(); all other branch-specific parameters\n     # (\"omega\", \"dN\", etc.) are available via \n     # ($omega) = $node->get_tag_values('omega');\n   }\n  }\n\n  # get any general model parameters: kappa (the\n  # transition/transversion ratio), NSsites model parameters (\"p0\",\n  # \"p1\", \"w0\", \"w1\", etc.), etc.\n  my $params = $result->get_model_params();\n  printf \"M1 params: p0 = %g\\tp1 = %g\\n\", $params->{p0}, $params->{p1};\n\n  # parse AAML result files\n  my $aamat = $result->get_AADistMatrix();\n  my $aaMLmat = $result->get_AAMLDistMatrix();\n\n=head1 DESCRIPTION\n\nThis module is used to parse the output from the PAML programs codeml,\nbaseml, basemlg, codemlsites and yn00.  You can use the\nBio::Tools::Run::Phylo::PAML::* modules to actually run some of the\nPAML programs, but this module is only useful to parse the output.\n\n=head1 TO DO\n\nImplement get_posteriors(). For NSsites models, obtain arrayrefs of \nposterior probabilities for membership in each class for every \nposition; probabilities correspond to classes w0, w1, ... etc.\n\n  my @probs = $result->get_posteriors();\n\n  # find, say, positively selected sites!\n  if ($params->{w2} > 1) {\n    for (my $i = 0; $i < @probs ; $i++) {\n      if ($probs[$i]->[2] > 0.5) {\n         # assumes model M1: three w's, w0, w1 and w2 (positive selection)\n         printf \"position %d: (%g prob, %g omega, %g mean w)\\n\",\n           $i, $probs[$i]->[2], $params->{w2}, $probs[$i]->[3];\n      }\n    }\n  } else { print \"No positive selection found!\\n\"; }\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\nEmail amackey-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nAlbert Vilella avilella-AT-gmail-DOT-com\nSendu Bala     bix@sendu.me.uk\n\n=head1 TODO\n\nRST parsing -- done, Avilella contributions bugzilla#1506, added by jason 1.29\n            -- still need to parse in joint probability and non-syn changes \n               at site table\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Phylo::PAML;\nuse vars qw($RSTFILENAME);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::AnalysisParserI);\n\nBEGIN {\n  $RSTFILENAME = 'rst'; # where to get the RST data from\n}\n\n# other objects used:\nuse IO::String;\nuse File::Spec;\nuse Bio::TreeIO;\nuse Bio::Tools::Phylo::PAML::Result;\nuse Bio::LocatableSeq;\nuse Bio::PrimarySeq;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::Phylo::PAML::ModelResult;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::PAML->new(%args);\n Function: Builds a new Bio::Tools::Phylo::PAML object\n Returns : Bio::Tools::Phylo::PAML\n Args    : Hash of options: -file, -fh, -dir\n           -file (or -fh) should contain the contents of the PAML\n                 outfile; \n           -dir is the (optional) name of the directory in\n                which the PAML program was run (and includes other\n                PAML-generated files from which we can try to gather data)","label":"new($class,@args)"},"children":[{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$class","line":235},{"name":"@args","containerName":"new","kind":13,"line":235},{"name":"$self","localvar":"my","containerName":"new","kind":13,"line":237,"definition":"my"},{"name":"$class","kind":13,"containerName":"new","line":237},{"line":237,"name":"@args","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$self","line":238},{"name":"_initialize_io","containerName":"new","kind":12,"line":238},{"kind":13,"containerName":"new","name":"@args","line":238},{"kind":13,"localvar":"my","containerName":"new","name":"$dir","line":239,"definition":"my"},{"kind":13,"containerName":"new","name":"$self","line":239},{"containerName":"new","kind":12,"name":"_rearrange","line":239},{"containerName":"new","kind":13,"name":"@args","line":239},{"containerName":"new","kind":13,"name":"$self","line":240},{"kind":13,"containerName":"new","name":"$dir","line":240},{"line":240,"containerName":"new","kind":13,"name":"$dir"},{"name":"$self","containerName":"new","kind":13,"line":241}],"containerName":"main::","name":"new","definition":"sub","detail":"($class,@args)"},{"line":235,"name":"ModelResult","containerName":"IO::String::File::Spec::Bio::TreeIO::Bio::Tools::Phylo::PAML::Result::Bio::LocatableSeq::Bio::PrimarySeq::Bio::Matrix::PhylipDist::Bio::Tools::Phylo::PAML","kind":2},{"line":237,"kind":12,"containerName":"new","name":"SUPER"},{"line":240,"name":"_dir","kind":12},{"children":[{"definition":"my","localvar":"my","containerName":"next_result","kind":13,"name":"$self","line":262},{"localvar":"my","containerName":"next_result","kind":13,"name":"%data","line":263,"definition":"my"},{"line":266,"name":"$self","containerName":"next_result","kind":13},{"name":"_parse_rst","containerName":"next_result","kind":12,"line":266},{"definition":"my","line":267,"containerName":"next_result","localvar":"my","kind":13,"name":"$idlookup"},{"containerName":"next_result","kind":13,"name":"$self","line":269},{"line":270,"containerName":"next_result","kind":12,"name":"_parse_summary"},{"kind":13,"containerName":"next_result","name":"$self","line":270},{"line":270,"containerName":"next_result","kind":13,"name":"$self"},{"line":272,"localvar":"my","containerName":"next_result","kind":13,"name":"$seqtype","definition":"my"},{"name":"$self","containerName":"next_result","kind":13,"line":272},{"line":273,"kind":13,"containerName":"next_result","name":"$seqtype"},{"line":273,"name":"$seqtype","kind":13,"containerName":"next_result"},{"definition":"my","name":"$has_model_line","localvar":"my","kind":13,"containerName":"next_result","line":274},{"kind":13,"containerName":"next_result","name":"$self","line":275},{"name":"_readline","containerName":"next_result","kind":12,"line":275},{"line":276,"name":"$seqtype","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"$self","line":279},{"line":279,"containerName":"next_result","kind":12,"name":"debug"},{"line":280,"kind":13,"containerName":"next_result","name":"$self"},{"line":280,"containerName":"next_result","kind":12,"name":"_pushback"},{"line":281,"name":"%data","kind":13,"containerName":"next_result"},{"line":281,"name":"$self","containerName":"next_result","kind":13},{"line":281,"name":"_parse_PairwiseCodon","kind":12,"containerName":"next_result"},{"line":283,"name":"$seqtype","containerName":"next_result","kind":13},{"containerName":"next_result","kind":13,"name":"$self","line":284},{"name":"_pushback","containerName":"next_result","kind":12,"line":284},{"containerName":"next_result","kind":13,"name":"%data","line":286},{"kind":13,"containerName":"next_result","name":"$self","line":286},{"line":286,"containerName":"next_result","kind":12,"name":"_parse_aa_dists"},{"containerName":"next_result","kind":13,"name":"$has_model_line","line":291},{"line":292,"name":"$seqtype","containerName":"next_result","kind":13},{"name":"$self","kind":13,"containerName":"next_result","line":293},{"name":"_pushback","containerName":"next_result","kind":12,"line":293},{"definition":"my","line":294,"kind":13,"localvar":"my","containerName":"next_result","name":"$model"},{"name":"$self","containerName":"next_result","kind":13,"line":294},{"kind":12,"containerName":"next_result","name":"_parse_NSsitesBatch","line":294},{"line":295,"kind":13,"containerName":"next_result","name":"$data"},{"name":"$model","containerName":"next_result","kind":13,"line":295},{"name":"$has_model_line","kind":13,"containerName":"next_result","line":296},{"definition":"my","kind":13,"localvar":"my","containerName":"next_result","name":"%branch_dnds","line":298},{"line":298,"name":"$self","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":12,"name":"_parse_branch_dnds","line":298},{"line":299,"name":"$data","containerName":"next_result","kind":13},{"line":300,"containerName":"next_result","kind":13,"name":"$self"},{"line":300,"name":"warn","kind":12,"containerName":"next_result"},{"definition":"my","kind":13,"localvar":"my","containerName":"next_result","name":"$tree","line":303},{"line":303,"containerName":"next_result","kind":13,"name":"$data"},{"name":"$tree","containerName":"next_result","kind":13,"line":304},{"containerName":"next_result","kind":13,"name":"$tree","line":304},{"kind":13,"containerName":"next_result","name":"$tree","line":305},{"line":305,"containerName":"next_result","kind":12,"name":"isa"},{"kind":13,"containerName":"next_result","name":"$self","line":306},{"name":"warn","containerName":"next_result","kind":12,"line":306},{"line":310,"name":"$k","kind":13,"localvar":"my","containerName":"next_result","definition":"my"},{"line":310,"name":"$v","kind":13,"containerName":"next_result"},{"line":310,"containerName":"next_result","kind":13,"name":"%branch_dnds"},{"definition":"my","line":312,"localvar":"my","containerName":"next_result","kind":13,"name":"@nodes"},{"name":"$id","localvar":"my","containerName":"next_result","kind":13,"line":313,"definition":"my"},{"name":"$k","containerName":"next_result","kind":13,"line":313},{"line":314,"localvar":"my","kind":13,"containerName":"next_result","name":"@nodes_L","definition":"my"},{"containerName":"next_result","kind":13,"name":"$tree","line":314},{"line":314,"kind":12,"containerName":"next_result","name":"find_node"},{"line":314,"name":"$idlookup","containerName":"next_result","kind":13},{"line":314,"name":"$id","containerName":"next_result","kind":13},{"localvar":"my","containerName":"next_result","kind":13,"name":"$n","line":315,"definition":"my"},{"name":"@nodes_L","kind":13,"containerName":"next_result","line":315},{"line":315,"name":"@nodes_L","kind":13,"containerName":"next_result"},{"line":315,"kind":13,"containerName":"next_result","name":"$tree"},{"line":315,"name":"get_lca","containerName":"next_result","kind":12},{"line":315,"name":"@nodes_L","kind":13,"containerName":"next_result"},{"name":"$n","containerName":"next_result","kind":13,"line":316},{"line":317,"name":"$self","containerName":"next_result","kind":13},{"line":317,"name":"warn","containerName":"next_result","kind":12},{"name":"$n","containerName":"next_result","kind":13,"line":319},{"line":319,"name":"is_Leaf","kind":12,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$n","line":319},{"line":319,"kind":12,"containerName":"next_result","name":"id"},{"containerName":"next_result","kind":13,"name":"$n","line":320},{"line":320,"name":"id","kind":12,"containerName":"next_result"},{"name":"$id","containerName":"next_result","kind":13,"line":320},{"containerName":"next_result","kind":13,"name":"@nodes","line":322},{"name":"$n","containerName":"next_result","kind":13,"line":322},{"definition":"my","name":"$parent","containerName":"next_result","localvar":"my","kind":13,"line":324},{"line":324,"name":"$child","containerName":"next_result","kind":13},{"name":"@nodes","containerName":"next_result","kind":13,"line":324},{"containerName":"next_result","localvar":"my","kind":13,"name":"$kk","line":325,"definition":"my"},{"line":325,"containerName":"next_result","kind":13,"name":"$vv"},{"kind":13,"containerName":"next_result","name":"$v","line":325},{"line":326,"kind":13,"containerName":"next_result","name":"$child"},{"line":326,"name":"add_tag_value","containerName":"next_result","kind":12},{"line":326,"kind":13,"containerName":"next_result","name":"$kk"},{"line":326,"kind":13,"containerName":"next_result","name":"$vv"}],"name":"next_result","containerName":"main::","definition":"sub","detail":"($self)","line":260,"kind":12,"range":{"end":{"character":9999,"line":329},"start":{"line":260,"character":0}},"signature":{"label":"next_result($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PAML.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Phylo::PAML\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich, Aaron J Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Phylo::PAML - Parses output from the PAML programs codeml,\nbaseml, basemlg, codemlsites and yn00\n\n=head1 SYNOPSIS\n\n  #!/usr/bin/perl -Tw\n  use strict;\n\n  use Bio::Tools::Phylo::PAML;\n\n  # need to specify the output file name (or a fh) (defaults to\n  # -file => \"codeml.mlc\"); also, optionally, the directory in which\n  # the other result files (rst, 2ML.dS, etc) may be found (defaults\n  # to \"./\")\n  my $parser = Bio::Tools::Phylo::PAML->new\n    (-file => \"./results/mlc\", -dir => \"./results/\");\n\n  # get the first/next result; a Bio::Tools::Phylo::PAML::Result object,\n  # which isa Bio::SeqAnalysisResultI object.\n  my $result = $parser->next_result();\n\n  # get the sequences used in the analysis; returns Bio::PrimarySeq\n  # objects (OTU = Operational Taxonomic Unit).\n  my @otus = $result->get_seqs();\n\n  # codon summary: codon usage of each sequence [ arrayref of {\n  # hashref of counts for each codon } for each sequence and the\n  # overall sum ], and positional nucleotide distribution [ arrayref\n  # of { hashref of frequencies for each nucleotide } for each\n  # sequence and overall frequencies ]:\n  my ($codonusage, $ntdist) = $result->get_codon_summary();\n\n  # example manipulations of $codonusage and $ntdist:\n  printf \"There were %d %s codons in the first seq (%s)\\n\",\n    $codonusage->[0]->{AAA}, 'AAA', $otus[0]->id();\n  printf \"There were %d %s codons used in all the sequences\\n\",\n    $codonusage->[$#{$codonusage}]->{AAA}, 'AAA';\n  printf \"Nucleotide %c was present %g of the time in seq %s\\n\",\n    'A', $ntdist->[1]->{A}, $otus[1]->id();\n\n  # get Nei & Gojobori dN/dS matrix:\n  my $NGmatrix = $result->get_NGmatrix();\n\n  # get ML-estimated dN/dS matrix, if calculated; this corresponds to\n  # the runmode = -2, pairwise comparison usage of codeml\n  my $MLmatrix = $result->get_MLmatrix();\n\n  # These matrices are length(@otu) x length(@otu) \"strict lower\n  # triangle\" 2D-matrices, which means that the diagonal and\n  # everything above it is undefined.  Each of the defined cells is a\n  # hashref of estimates for \"dN\", \"dS\", \"omega\" (dN/dS ratio), \"t\",\n  # \"S\" and \"N\".  If a ML matrix, \"lnL\" and \"kappa\" will also be defined.\n  printf \"The omega ratio for sequences %s vs %s was: %g\\n\",\n    $otus[0]->id, $otus[1]->id, $MLmatrix->[0]->[1]->{omega};\n\n  # with a little work, these matrices could also be passed to\n  # Bio::Tools::Run::Phylip::Neighbor, or other similar tree-building\n  # method that accepts a matrix of \"distances\" (using the LOWTRI\n  # option):\n  my $distmat = [ map { [ map { $$_{omega} } @$_ ] } @$MLmatrix ];\n\n  # for runmode's other than -2, get tree topology with estimated\n  # branch lengths; returns a Bio::Tree::TreeI-based tree object with\n  # added PAML parameters at each node\n  my ($tree) = $result->get_trees();\n  for my $node ($tree->get_nodes()) {\n     # inspect the tree: the \"t\" (time) parameter is available via\n     # $node->branch_length(); all other branch-specific parameters\n     # (\"omega\", \"dN\", etc.) are available via \n     # ($omega) = $node->get_tag_values('omega');\n  }\n\n  # if you are using model based Codeml then trees are stored in each \n  # modelresult object\n  for my $modelresult ( $result->get_NSSite_results ) {\n    # model M0, M1, etc\n    print \"model is \", $modelresult->model_num, \"\\n\";\n    my ($tree) = $modelresult->get_trees();\n    for my $node ($tree->get_nodes()) {\n     # inspect the tree: the \"t\" (time) parameter is available via\n     # $node->branch_length(); all other branch-specific parameters\n     # (\"omega\", \"dN\", etc.) are available via \n     # ($omega) = $node->get_tag_values('omega');\n   }\n  }\n\n  # get any general model parameters: kappa (the\n  # transition/transversion ratio), NSsites model parameters (\"p0\",\n  # \"p1\", \"w0\", \"w1\", etc.), etc.\n  my $params = $result->get_model_params();\n  printf \"M1 params: p0 = %g\\tp1 = %g\\n\", $params->{p0}, $params->{p1};\n\n  # parse AAML result files\n  my $aamat = $result->get_AADistMatrix();\n  my $aaMLmat = $result->get_AAMLDistMatrix();\n\n=head1 DESCRIPTION\n\nThis module is used to parse the output from the PAML programs codeml,\nbaseml, basemlg, codemlsites and yn00.  You can use the\nBio::Tools::Run::Phylo::PAML::* modules to actually run some of the\nPAML programs, but this module is only useful to parse the output.\n\n=head1 TO DO\n\nImplement get_posteriors(). For NSsites models, obtain arrayrefs of \nposterior probabilities for membership in each class for every \nposition; probabilities correspond to classes w0, w1, ... etc.\n\n  my @probs = $result->get_posteriors();\n\n  # find, say, positively selected sites!\n  if ($params->{w2} > 1) {\n    for (my $i = 0; $i < @probs ; $i++) {\n      if ($probs[$i]->[2] > 0.5) {\n         # assumes model M1: three w's, w0, w1 and w2 (positive selection)\n         printf \"position %d: (%g prob, %g omega, %g mean w)\\n\",\n           $i, $probs[$i]->[2], $params->{w2}, $probs[$i]->[3];\n      }\n    }\n  } else { print \"No positive selection found!\\n\"; }\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Aaron Mackey\n\nEmail jason-at-bioperl.org\nEmail amackey-at-virginia.edu\n\n=head1 CONTRIBUTORS\n\nAlbert Vilella avilella-AT-gmail-DOT-com\nSendu Bala     bix@sendu.me.uk\n\n=head1 TODO\n\nRST parsing -- done, Avilella contributions bugzilla#1506, added by jason 1.29\n            -- still need to parse in joint probability and non-syn changes \n               at site table\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Phylo::PAML;\nuse vars qw($RSTFILENAME);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Root::IO Bio::AnalysisParserI);\n\nBEGIN {\n  $RSTFILENAME = 'rst'; # where to get the RST data from\n}\n\n# other objects used:\nuse IO::String;\nuse File::Spec;\nuse Bio::TreeIO;\nuse Bio::Tools::Phylo::PAML::Result;\nuse Bio::LocatableSeq;\nuse Bio::PrimarySeq;\nuse Bio::Matrix::PhylipDist;\nuse Bio::Tools::Phylo::PAML::ModelResult;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Phylo::PAML->new(%args);\n Function: Builds a new Bio::Tools::Phylo::PAML object\n Returns : Bio::Tools::Phylo::PAML\n Args    : Hash of options: -file, -fh, -dir\n           -file (or -fh) should contain the contents of the PAML\n                 outfile; \n           -dir is the (optional) name of the directory in\n                which the PAML program was run (and includes other\n                PAML-generated files from which we can try to gather data)\n\n\nsub new {\n\n  my ($class, @args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->_initialize_io(@args);\n  my ($dir) = $self->_rearrange([qw(DIR)], @args);\n  $self->{_dir} = $dir if defined $dir;\n  return $self;\n}\n\n=head2 Implement Bio::AnalysisParserI interface\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : $result = $obj->next_result();\n Function: Returns the next result available from the input, or\n           undef if there are no more results.\n Example :\n Returns : a Bio::Tools::Phylo::PAML::Result object\n Args    : none"}},{"containerName":null,"kind":13,"name":"$self","line":331},{"kind":12,"containerName":"main::","name":"_pushback","line":331},{"name":"%data","kind":13,"containerName":null,"line":332},{"kind":13,"containerName":null,"name":"$idlookup","line":332},{"name":"$self","kind":13,"containerName":null,"line":332},{"containerName":"main::","kind":12,"name":"_parse_Forestry","line":332},{"containerName":null,"kind":13,"name":"$self","line":336},{"line":336,"name":"throw","containerName":"main::","kind":12},{"name":"$self","kind":13,"containerName":null,"line":347},{"kind":12,"containerName":"main::","name":"throw","line":347},{"line":358,"name":"$self","kind":13,"containerName":null},{"line":358,"name":"throw","containerName":"main::","kind":12},{"line":362,"containerName":null,"kind":13,"name":"$self"},{"line":362,"name":"_pushback","containerName":"main::","kind":12},{"line":363,"name":"%data","kind":13,"containerName":null},{"name":"$self","containerName":null,"kind":13,"line":363},{"kind":12,"containerName":"main::","name":"_parse_StarDecomposition","line":363},{"containerName":null,"kind":13,"name":"%seqtype","line":367},{"name":"$self","kind":13,"containerName":null,"line":368},{"line":368,"kind":12,"containerName":"main::","name":"_readline"},{"name":"$self","kind":13,"containerName":null,"line":370},{"name":"_pushback","containerName":"main::","kind":12,"line":370},{"definition":"my","name":"$kappa","localvar":"my","containerName":null,"kind":13,"line":371},{"line":371,"containerName":null,"kind":13,"name":"$alpha"},{"name":"$self","containerName":null,"kind":13,"line":371},{"name":"_parse_nt_dists","containerName":"main::","kind":12,"line":371},{"name":"%data","kind":13,"containerName":null,"line":372},{"name":"$kappa","containerName":null,"kind":13,"line":372},{"containerName":null,"kind":13,"name":"%alpha","line":374},{"line":376,"name":"$self","kind":13,"containerName":null},{"containerName":"main::","kind":12,"name":"_pushback","line":376},{"line":377,"containerName":null,"kind":13,"name":"%data"},{"containerName":null,"kind":13,"name":"$idlookup","line":377},{"containerName":null,"kind":13,"name":"$self","line":377},{"name":"_parse_Forestry","kind":12,"containerName":"main::","line":377},{"line":380,"name":"%seqtype","kind":13,"containerName":null},{"line":381,"name":"$self","kind":13,"containerName":null},{"name":"_readline","containerName":"main::","kind":12,"line":381},{"kind":13,"containerName":null,"name":"$self","line":383},{"containerName":"main::","kind":12,"name":"_pushback","line":383},{"line":384,"name":"%data","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$self","line":384},{"line":384,"containerName":"main::","kind":12,"name":"_parse_YN_Pairwise"},{"kind":13,"containerName":null,"name":"%data","line":389},{"line":390,"containerName":null,"kind":13,"name":"%data"},{"kind":13,"containerName":null,"name":"%self","line":390},{"line":391,"name":"%data","containerName":null,"kind":13},{"line":391,"kind":13,"containerName":null,"name":"%self"},{"line":392,"name":"%data","containerName":null,"kind":13},{"line":392,"containerName":null,"kind":13,"name":"%self"},{"name":"%data","containerName":null,"kind":13,"line":393},{"name":"%self","containerName":null,"kind":13,"line":393},{"kind":13,"containerName":null,"name":"%data","line":394},{"name":"%self","containerName":null,"kind":13,"line":394},{"containerName":null,"kind":13,"name":"%data","line":395},{"containerName":null,"kind":13,"name":"%self","line":395},{"kind":13,"containerName":null,"name":"%data","line":396},{"containerName":null,"kind":13,"name":"%self","line":396},{"line":397,"kind":13,"containerName":null,"name":"%data"},{"line":397,"name":"%self","kind":13,"containerName":null},{"line":398,"name":"%data","containerName":null,"kind":13},{"name":"%self","kind":13,"containerName":null,"line":398},{"kind":13,"containerName":null,"name":"%data","line":399},{"containerName":null,"kind":13,"name":"%self","line":399},{"kind":13,"containerName":null,"name":"%data","line":400},{"line":400,"kind":13,"containerName":null,"name":"%self"},{"line":401,"name":"%data","kind":13,"containerName":null},{"line":401,"kind":13,"containerName":null,"name":"%self"},{"containerName":null,"kind":13,"name":"%data","line":402},{"containerName":null,"kind":13,"name":"%self","line":402},{"line":403,"name":"%data","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%self","line":403},{"name":"%data","kind":13,"containerName":null,"line":404},{"line":404,"name":"%self","kind":13,"containerName":null},{"name":"%data","containerName":null,"kind":13,"line":405},{"name":"%self","containerName":null,"kind":13,"line":405},{"name":"Bio","containerName":"Tools::Phylo::PAML::Result","kind":12,"line":406},{"kind":12,"containerName":"main::","name":"new","line":406},{"line":406,"containerName":null,"kind":13,"name":"%data"},{"range":{"end":{"character":9999,"line":458},"start":{"line":413,"character":0}},"kind":12,"line":413,"signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"_parse_summary($self)"},"name":"_parse_summary","containerName":"main::","children":[{"line":414,"kind":13,"localvar":"my","containerName":"_parse_summary","name":"$self","definition":"my"},{"definition":"my","name":"$SEQTYPES","localvar":"my","containerName":"_parse_summary","kind":13,"line":428},{"name":"$line","containerName":"_parse_summary","localvar":"my","kind":13,"line":429,"definition":"my"},{"containerName":"_parse_summary","kind":13,"name":"$self","line":430},{"line":430,"containerName":"_parse_summary","kind":13,"name":"$self"},{"definition":"my","localvar":"my","kind":13,"containerName":"_parse_summary","name":"@lines","line":431},{"name":"$self","containerName":"_parse_summary","kind":13,"line":432},{"name":"_readline","containerName":"_parse_summary","kind":12,"line":432},{"line":433,"containerName":"_parse_summary","kind":13,"name":"@lines"},{"line":441,"kind":13,"containerName":"_parse_summary","name":"$self"},{"name":"$self","kind":13,"containerName":"_parse_summary","line":443},{"name":"$self","kind":13,"containerName":"_parse_summary","line":444},{"containerName":"_parse_summary","kind":13,"name":"$self","line":445},{"line":445,"name":"_pushback","kind":12,"containerName":"_parse_summary"},{"name":"$self","containerName":"_parse_summary","kind":13,"line":445},{"line":448,"name":"$self","containerName":"_parse_summary","kind":13},{"line":449,"name":"$self","containerName":"_parse_summary","kind":13},{"definition":"my","containerName":"_parse_summary","localvar":"my","kind":13,"name":"$phylip_header","line":451},{"line":451,"name":"$self","containerName":"_parse_summary","kind":13},{"kind":12,"containerName":"_parse_summary","name":"_readline","line":451},{"line":452,"containerName":"_parse_summary","kind":13,"name":"$self"},{"kind":12,"containerName":"_parse_summary","name":"_parse_seqs","line":452},{"containerName":"_parse_summary","kind":13,"name":"@lines","line":453},{"name":"$self","containerName":"_parse_summary","kind":13,"line":453},{"containerName":"_parse_summary","kind":13,"name":"$self","line":454},{"kind":12,"containerName":"_parse_summary","name":"_parse_seqs","line":454},{"line":456,"name":"$self","containerName":"_parse_summary","kind":13},{"containerName":"_parse_summary","kind":12,"name":"_parse_patterns","line":456}],"detail":"($self)","definition":"sub"},{"line":460,"name":"%self","containerName":null,"kind":13},{"line":461,"containerName":null,"kind":13,"name":"$self"},{"line":461,"containerName":"main::","kind":12,"name":"throw"},{"localvar":"my","containerName":null,"kind":13,"name":"$seqtype","line":464,"definition":"my"},{"line":464,"containerName":null,"kind":13,"name":"%self"},{"line":465,"name":"%seqtype","containerName":null,"kind":13},{"line":466,"name":"$self","kind":13,"containerName":null},{"line":466,"kind":12,"containerName":"main::","name":"_parse_inputparams"},{"line":468,"name":"$self","kind":13,"containerName":null},{"kind":12,"containerName":"main::","name":"_parse_patterns","line":468},{"containerName":null,"kind":13,"name":"$self","line":469},{"kind":12,"containerName":"main::","name":"_parse_seqs","line":469},{"name":"$self","containerName":null,"kind":13,"line":470},{"line":470,"name":"_parse_codoncts","containerName":"main::","kind":12},{"containerName":null,"kind":13,"name":"$self","line":472},{"line":472,"containerName":"main::","kind":12,"name":"_parse_codon_freqs"},{"line":473,"name":"$self","kind":13,"containerName":null},{"line":473,"containerName":"main::","kind":12,"name":"_parse_distmat"},{"line":474,"name":"%seqtype","kind":13,"containerName":null},{"line":475,"containerName":null,"kind":13,"name":"$self"},{"containerName":"main::","kind":12,"name":"_parse_inputparams","line":475},{"line":476,"name":"$self","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"_parse_patterns","line":476},{"line":477,"containerName":null,"kind":13,"name":"$self"},{"name":"_parse_seqs","kind":12,"containerName":"main::","line":477},{"containerName":null,"kind":13,"name":"$self","line":478},{"line":478,"kind":12,"containerName":"main::","name":"_parse_aa_freqs"},{"line":480,"containerName":null,"kind":13,"name":"%self"},{"name":"$self","kind":13,"containerName":null,"line":480},{"kind":12,"containerName":"main::","name":"_parse_aa_dists","line":480},{"line":482,"containerName":null,"kind":13,"name":"%seqtype"},{"containerName":null,"kind":13,"name":"$self","line":483},{"containerName":"main::","kind":12,"name":"throw","line":483},{"line":485,"containerName":null,"kind":13,"name":"%seqtype"},{"line":486,"name":"$self","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"_parse_patterns","line":486},{"containerName":null,"kind":13,"name":"$self","line":487},{"name":"_parse_seqs","containerName":"main::","kind":12,"line":487},{"line":488,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","kind":12,"name":"_parse_nt_freqs","line":488},{"name":"%seqtype","containerName":null,"kind":13,"line":490},{"line":491,"name":"$self","containerName":null,"kind":13},{"line":491,"containerName":"main::","kind":12,"name":"_parse_codon_freqs"},{"line":492,"kind":13,"containerName":null,"name":"$self"},{"name":"_parse_codoncts","kind":12,"containerName":"main::","line":492},{"line":493,"name":"$self","kind":13,"containerName":null},{"containerName":"main::","kind":12,"name":"_parse_distmat","line":493},{"name":"$self","kind":13,"containerName":null,"line":495},{"containerName":"main::","kind":12,"name":"throw","line":495},{"line":498,"name":"$seqtype","containerName":null,"kind":13},{"detail":"($self)","definition":"sub","name":"_parse_inputparams","containerName":"main::","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_parse_inputparams","name":"$self","line":504},{"line":505,"containerName":"_parse_inputparams","kind":13,"name":"$self"},{"line":505,"containerName":"_parse_inputparams","kind":12,"name":"_readline"},{"localvar":"my","kind":13,"containerName":"_parse_inputparams","name":"$param","line":507,"definition":"my"},{"name":"$val","containerName":"_parse_inputparams","kind":13,"line":507},{"line":508,"containerName":"_parse_inputparams","kind":13,"name":"$self"},{"line":508,"name":"$param","containerName":"_parse_inputparams","kind":13},{"containerName":"_parse_inputparams","kind":13,"name":"$val","line":508},{"line":512,"name":"$self","containerName":"_parse_inputparams","kind":13},{"name":"_pushback","containerName":"_parse_inputparams","kind":12,"line":512}],"signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"_parse_inputparams($self)"},"range":{"end":{"line":516,"character":9999},"start":{"character":0,"line":503}},"kind":12,"line":503},{"name":"_parse_codon_freqs","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_parse_codon_freqs","line":519},{"line":520,"name":"$okay","localvar":"my","containerName":"_parse_codon_freqs","kind":13,"definition":"my"},{"containerName":"_parse_codon_freqs","kind":13,"name":"$done","line":520},{"line":522,"name":"$self","containerName":"_parse_codon_freqs","kind":13},{"kind":12,"containerName":"_parse_codon_freqs","name":"_readline","line":522},{"containerName":"_parse_codon_freqs","kind":13,"name":"$self","line":523},{"kind":12,"containerName":"_parse_codon_freqs","name":"_pushback","line":523},{"name":"$done","containerName":"_parse_codon_freqs","kind":13,"line":524},{"containerName":"_parse_codon_freqs","kind":13,"name":"$okay","line":526},{"containerName":"_parse_codon_freqs","kind":13,"name":"$okay","line":527},{"name":"$pos","localvar":"my","kind":13,"containerName":"_parse_codon_freqs","line":529,"definition":"my"},{"definition":"my","containerName":"_parse_codon_freqs","localvar":"my","kind":13,"name":"@bases","line":531},{"line":532,"containerName":"_parse_codon_freqs","localvar":"my","kind":13,"name":"$str","definition":"my"},{"name":"@bases","containerName":"_parse_codon_freqs","kind":13,"line":532},{"kind":13,"localvar":"my","containerName":"_parse_codon_freqs","name":"$base","line":533,"definition":"my"},{"line":533,"containerName":"_parse_codon_freqs","kind":13,"name":"$freq"},{"line":533,"containerName":"_parse_codon_freqs","kind":13,"name":"$str"},{"containerName":"_parse_codon_freqs","kind":13,"name":"$self","line":534},{"line":534,"name":"$pos","kind":13,"containerName":"_parse_codon_freqs"},{"line":534,"name":"$base","containerName":"_parse_codon_freqs","kind":13},{"line":534,"containerName":"_parse_codon_freqs","kind":13,"name":"$freq"},{"name":"$done","kind":13,"containerName":"_parse_codon_freqs","line":536},{"containerName":"_parse_codon_freqs","kind":13,"name":"$pos","line":536},{"name":"$done","containerName":"_parse_codon_freqs","kind":13,"line":539},{"line":540,"name":"$self","kind":13,"containerName":"_parse_codon_freqs"},{"name":"_readline","containerName":"_parse_codon_freqs","kind":12,"line":540},{"name":"$self","containerName":"_parse_codon_freqs","kind":13,"line":541},{"containerName":"_parse_codon_freqs","kind":12,"name":"_pushback","line":541},{"line":542,"name":"$done","containerName":"_parse_codon_freqs","kind":13},{"name":"$self","containerName":"_parse_codon_freqs","kind":13,"line":544},{"line":544,"kind":12,"containerName":"_parse_codon_freqs","name":"_readline"},{"line":548,"kind":13,"containerName":"_parse_codon_freqs","name":"$self"},{"line":550,"name":"$done","kind":13,"containerName":"_parse_codon_freqs"}],"detail":"($self)","definition":"sub","kind":12,"range":{"end":{"line":552,"character":9999},"start":{"character":0,"line":518}},"line":518,"signature":{"label":"_parse_codon_freqs($self)","documentation":"","parameters":[{"label":"$self"}]}},{"definition":"sub","detail":"($self)","children":[{"line":556,"localvar":"my","kind":13,"containerName":"_parse_aa_freqs","name":"$self","definition":"my"},{"localvar":"my","containerName":"_parse_aa_freqs","kind":13,"name":"$okay","line":557,"definition":"my"},{"name":"$done","containerName":"_parse_aa_freqs","kind":13,"line":557},{"line":557,"containerName":"_parse_aa_freqs","kind":13,"name":"$header"},{"definition":"my","localvar":"my","kind":13,"containerName":"_parse_aa_freqs","name":"@bases","line":558},{"containerName":"_parse_aa_freqs","localvar":"my","kind":13,"name":"$numseqs","line":559,"definition":"my"},{"containerName":"_parse_aa_freqs","kind":13,"name":"$self","line":559}],"containerName":"main::","name":"_parse_aa_freqs","signature":{"label":"_parse_aa_freqs($self)","documentation":"","parameters":[{"label":"$self"}]},"line":555,"range":{"start":{"character":0,"line":555},"end":{"character":9999,"line":559}},"kind":12},{"containerName":null,"kind":13,"name":"$self","line":560},{"line":560,"containerName":"main::","kind":12,"name":"_readline"},{"line":562,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","kind":12,"name":"_pushback","line":562},{"name":"%done","kind":13,"containerName":null,"line":564},{"name":"$okay","containerName":null,"kind":13,"line":567},{"line":568,"name":"%okay","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%header","line":570},{"name":"@bases","containerName":null,"kind":13,"line":572},{"kind":13,"containerName":null,"name":"$header","line":573},{"line":574,"name":"%self","containerName":null,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":579},{"line":580,"containerName":null,"kind":13,"name":"%self"},{"containerName":null,"kind":13,"name":"%self","line":582},{"line":583,"kind":13,"containerName":null,"name":"%done"},{"line":585,"containerName":null,"localvar":"my","kind":13,"name":"$seqname","definition":"my"},{"line":585,"name":"@freqs","containerName":null,"kind":13},{"name":"$basect","containerName":null,"localvar":"my","kind":13,"line":586,"definition":"my"},{"line":587,"containerName":null,"localvar":"my","kind":13,"name":"$f","definition":"my"},{"name":"@freqs","containerName":null,"kind":13,"line":587},{"line":589,"name":"%self","containerName":null,"kind":13},{"name":"%seqname","containerName":null,"kind":13,"line":589},{"line":589,"containerName":null,"kind":13,"name":"@bases"},{"containerName":null,"kind":13,"name":"$basect","line":589},{"line":589,"containerName":null,"kind":13,"name":"$f"},{"signature":{"parameters":[{"label":"$self"}],"documentation":" This is for parsing the automatic tree output","label":"_parse_StarDecomposition($self)"},"line":598,"range":{"start":{"line":598,"character":0},"end":{"line":603,"character":9999}},"kind":12,"definition":"sub","detail":"($self)","children":[{"definition":"my","line":599,"kind":13,"localvar":"my","containerName":"_parse_StarDecomposition","name":"$self"},{"definition":"my","name":"%data","localvar":"my","kind":13,"containerName":"_parse_StarDecomposition","line":600},{"line":602,"name":"%data","containerName":"_parse_StarDecomposition","kind":13}],"name":"_parse_StarDecomposition","containerName":"main::"},{"signature":{"label":"_parse_aa_dists($self)","parameters":[{"label":"$self"}],"documentation":""},"line":605,"range":{"start":{"character":0,"line":605},"end":{"character":9999,"line":609}},"kind":12,"definition":"sub","detail":"($self)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"_parse_aa_dists","line":606},{"definition":"my","line":607,"kind":13,"localvar":"my","containerName":"_parse_aa_dists","name":"$okay"},{"line":607,"name":"$seen","kind":13,"containerName":"_parse_aa_dists"},{"line":607,"name":"$done","kind":13,"containerName":"_parse_aa_dists"},{"line":608,"name":"%matrix","localvar":"my","containerName":"_parse_aa_dists","kind":13,"definition":"my"},{"line":608,"name":"@names","containerName":"_parse_aa_dists","kind":13},{"name":"@values","kind":13,"containerName":"_parse_aa_dists","line":608},{"line":609,"localvar":"my","containerName":"_parse_aa_dists","kind":13,"name":"$numseqs","definition":"my"},{"containerName":"_parse_aa_dists","kind":13,"name":"$self","line":609}],"containerName":"main::","name":"_parse_aa_dists"},{"name":"$type","containerName":null,"localvar":"my","kind":13,"line":610,"definition":"my"},{"line":611,"name":"$self","containerName":null,"kind":13},{"name":"_readline","containerName":"main::","kind":12,"line":611},{"kind":13,"containerName":null,"name":"%done","line":612},{"containerName":null,"kind":13,"name":"$self","line":613},{"containerName":"main::","kind":12,"name":"_pushback","line":613},{"name":"%seen","kind":13,"containerName":null,"line":615},{"kind":13,"containerName":null,"name":"$okay","line":619},{"line":620,"kind":13,"containerName":null,"name":"$type"},{"name":"%okay","kind":13,"containerName":null,"line":624},{"localvar":"my","containerName":null,"kind":13,"name":"$seqname","line":625,"definition":"my"},{"line":625,"kind":13,"containerName":null,"name":"@vl"},{"line":626,"kind":13,"containerName":null,"name":"$seen"},{"line":627,"localvar":"my","containerName":null,"kind":13,"name":"$i","definition":"my"},{"name":"$type","containerName":null,"kind":13,"line":629},{"line":630,"name":"@names","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"@vl","line":631},{"kind":13,"containerName":null,"name":"@names","line":632},{"line":632,"name":"%self","kind":13,"containerName":null},{"line":632,"containerName":"main::","kind":12,"name":"display_id"},{"definition":"my","line":634,"localvar":"my","kind":13,"containerName":null,"name":"$s"},{"line":634,"name":"@names","containerName":null,"kind":13},{"name":"@vl","containerName":null,"kind":13,"line":635},{"name":"%matrix","kind":13,"containerName":null,"line":636},{"name":"%seqname","kind":13,"containerName":null,"line":636},{"line":636,"containerName":null,"kind":13,"name":"$s"},{"line":637,"kind":13,"containerName":null,"name":"%matrix"},{"name":"%s","containerName":null,"kind":13,"line":637},{"name":"$seqname","containerName":null,"kind":13,"line":637},{"line":637,"name":"@vl","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"@names","line":639},{"name":"$seqname","kind":13,"containerName":null,"line":639},{"line":641,"kind":13,"containerName":null,"name":"%matrix"},{"kind":13,"containerName":null,"name":"%seqname","line":641},{"line":641,"name":"$seqname","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$done","line":643},{"line":643,"kind":13,"containerName":null,"name":"@names"},{"kind":13,"containerName":null,"name":"$numseqs","line":643},{"definition":"my","name":"%dist","kind":13,"localvar":"my","containerName":null,"line":645},{"definition":"my","name":"$i","containerName":null,"localvar":"my","kind":13,"line":646},{"kind":13,"containerName":null,"name":"@values","line":647},{"line":648,"name":"$lname","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"line":648,"kind":13,"containerName":null,"name":"@names"},{"kind":13,"localvar":"my","containerName":null,"name":"@row","line":649,"definition":"my"},{"containerName":null,"localvar":"my","kind":13,"name":"$j","line":650,"definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$rname","line":651},{"line":651,"kind":13,"containerName":null,"name":"@names"},{"definition":"my","name":"$v","localvar":"my","containerName":null,"kind":13,"line":652},{"containerName":null,"kind":13,"name":"%matrix","line":652},{"name":"%lname","kind":13,"containerName":null,"line":652},{"line":652,"name":"$rname","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$v","line":653},{"line":653,"containerName":null,"kind":13,"name":"%matrix"},{"containerName":null,"kind":13,"name":"%rname","line":653},{"kind":13,"containerName":null,"name":"$lname","line":653},{"line":653,"name":"$v","containerName":null,"kind":13},{"line":654,"containerName":null,"kind":13,"name":"@row"},{"line":654,"name":"$v","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%dist","line":655},{"line":655,"name":"%lname","containerName":null,"kind":13},{"line":655,"name":"@rname","kind":13,"containerName":null},{"line":655,"kind":13,"containerName":null,"name":"$i"},{"kind":13,"containerName":null,"name":"$j","line":655},{"name":"$i","kind":13,"containerName":null,"line":657},{"line":658,"containerName":null,"kind":13,"name":"@values"},{"line":658,"name":"@row","containerName":null,"kind":13},{"line":661,"kind":12,"containerName":"Matrix::PhylipDist","name":"Bio"},{"kind":13,"containerName":null,"name":"%self","line":661},{"line":662,"name":"%dist","containerName":null,"kind":13},{"name":"@names","containerName":null,"kind":13,"line":663},{"name":"@values","containerName":null,"kind":13,"line":664},{"kind":12,"range":{"start":{"character":0,"line":667},"end":{"line":691,"character":9999}},"line":667,"signature":{"label":"_parse_patterns($self)","parameters":[{"label":"$self"}],"documentation":""},"containerName":"main::","name":"_parse_patterns","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_parse_patterns","line":668},{"line":669,"name":"$patternct","containerName":"_parse_patterns","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"_parse_patterns","name":"@patterns","line":669},{"line":669,"containerName":"_parse_patterns","kind":13,"name":"$ns"},{"kind":13,"containerName":"_parse_patterns","name":"$ls","line":669},{"line":670,"name":"$self","containerName":"_parse_patterns","kind":13},{"containerName":"_parse_patterns","kind":13,"name":"$self","line":671},{"name":"_readline","containerName":"_parse_patterns","kind":12,"line":671},{"containerName":"_parse_patterns","kind":13,"name":"$self","line":673},{"name":"_pushback","kind":12,"containerName":"_parse_patterns","line":673},{"line":675,"kind":13,"containerName":"_parse_patterns","name":"$patternct"},{"line":679,"name":"@patterns","kind":13,"containerName":"_parse_patterns"},{"containerName":"_parse_patterns","kind":13,"name":"$ns","line":681},{"line":681,"name":"$ls","containerName":"_parse_patterns","kind":13},{"kind":13,"containerName":"_parse_patterns","name":"$patternct","line":683},{"kind":13,"containerName":"_parse_patterns","name":"$self","line":688},{"name":"@patterns","kind":13,"containerName":"_parse_patterns","line":688},{"name":"$ns","kind":13,"containerName":"_parse_patterns","line":689},{"line":690,"name":"$ls","containerName":"_parse_patterns","kind":13}],"detail":"($self)","definition":"sub"},{"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_parse_seqs","line":696,"definition":"my"},{"line":700,"containerName":"_parse_seqs","kind":13,"name":"$self"},{"localvar":"my","containerName":"_parse_seqs","kind":13,"name":"@firstseq","line":701,"definition":"my"},{"line":701,"kind":13,"containerName":"_parse_seqs","name":"@seqs"},{"line":702,"name":"$self","kind":13,"containerName":"_parse_seqs"},{"line":702,"name":"_readline","kind":12,"containerName":"_parse_seqs"},{"name":"$self","kind":13,"containerName":"_parse_seqs","line":704},{"name":"_pushback","containerName":"_parse_seqs","kind":12,"line":704},{"line":706,"kind":13,"containerName":"_parse_seqs","name":"@seqs"},{"localvar":"my","kind":13,"containerName":"_parse_seqs","name":"$name","line":711,"definition":"my"},{"kind":13,"containerName":"_parse_seqs","name":"$seqstr","line":711},{"line":712,"name":"$seqstr","kind":13,"containerName":"_parse_seqs"},{"line":713,"kind":13,"containerName":"_parse_seqs","name":"@firstseq"},{"name":"@firstseq","containerName":"_parse_seqs","kind":13,"line":714},{"line":714,"name":"$seqstr","kind":13,"containerName":"_parse_seqs"},{"line":715,"containerName":"_parse_seqs","kind":13,"name":"@seqs"},{"containerName":"_parse_seqs","kind":12,"name":"new","line":715},{"kind":13,"containerName":"_parse_seqs","name":"$name","line":715},{"name":"$seqstr","containerName":"_parse_seqs","kind":13,"line":716},{"line":719,"localvar":"my","kind":13,"containerName":"_parse_seqs","name":"$i","definition":"my"},{"line":720,"name":"$v","localvar":"my","kind":13,"containerName":"_parse_seqs","definition":"my"},{"name":"$v","containerName":"_parse_seqs","kind":13,"line":721},{"containerName":"_parse_seqs","kind":13,"name":"$seqstr","line":721},{"line":721,"name":"$i","kind":13,"containerName":"_parse_seqs"},{"containerName":"_parse_seqs","kind":13,"name":"$i","line":721},{"line":723,"name":"$seqstr","kind":13,"containerName":"_parse_seqs"},{"line":723,"containerName":"_parse_seqs","kind":13,"name":"$v"},{"line":723,"name":"$firstseq","containerName":"_parse_seqs","kind":13},{"name":"$v","containerName":"_parse_seqs","kind":13,"line":723},{"name":"$i","kind":13,"containerName":"_parse_seqs","line":724},{"line":724,"name":"$v","kind":13,"containerName":"_parse_seqs"},{"containerName":"_parse_seqs","kind":13,"name":"@seqs","line":726},{"name":"new","containerName":"_parse_seqs","kind":12,"line":726},{"kind":13,"containerName":"_parse_seqs","name":"$name","line":726},{"name":"$seqstr","kind":13,"containerName":"_parse_seqs","line":727},{"line":730,"name":"@seqs","containerName":"_parse_seqs","kind":13},{"kind":13,"containerName":"_parse_seqs","name":"$self","line":731},{"containerName":"_parse_seqs","kind":13,"name":"@seqs","line":731},{"containerName":"_parse_seqs","kind":13,"name":"$self","line":732}],"containerName":"main::","name":"_parse_seqs","definition":"sub","detail":"($self)","line":693,"kind":12,"range":{"end":{"character":9999,"line":735},"start":{"line":693,"character":0}},"signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"_parse_seqs($self)"}},{"line":715,"name":"Bio","kind":12,"containerName":"LocatableSeq"},{"containerName":"LocatableSeq","kind":12,"name":"Bio","line":726},{"children":[],"name":"_parse_codoncts","containerName":"main::","definition":"sub","line":737,"range":{"end":{"character":9999,"line":737},"start":{"character":0,"line":737}},"kind":12},{"name":"_parse_distmat","containerName":"main::","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"_parse_distmat","line":740,"definition":"my"},{"definition":"my","line":741,"containerName":"_parse_distmat","localvar":"my","kind":13,"name":"@results"},{"definition":"my","line":742,"name":"$ver","localvar":"my","containerName":"_parse_distmat","kind":13},{"containerName":"_parse_distmat","kind":13,"name":"$self","line":744},{"kind":12,"containerName":"_parse_distmat","name":"_readline","line":744},{"line":748,"kind":13,"containerName":"_parse_distmat","name":"$ver"},{"line":749,"containerName":"_parse_distmat","kind":13,"name":"$self"},{"containerName":"_parse_distmat","kind":12,"name":"_readline","line":749},{"containerName":"_parse_distmat","kind":13,"name":"$self","line":750},{"kind":12,"containerName":"_parse_distmat","name":"_readline","line":750},{"kind":13,"containerName":"_parse_distmat","name":"$self","line":751},{"name":"_readline","kind":12,"containerName":"_parse_distmat","line":751},{"name":"$self","kind":13,"containerName":"_parse_distmat","line":752},{"containerName":"_parse_distmat","kind":12,"name":"_readline","line":752},{"kind":13,"containerName":"_parse_distmat","name":"$self","line":759},{"line":759,"kind":12,"containerName":"_parse_distmat","name":"_readline"},{"line":759,"containerName":"_parse_distmat","kind":13,"name":"$ver"},{"kind":13,"containerName":"_parse_distmat","name":"$self","line":762},{"name":"$self","kind":13,"containerName":"_parse_distmat","line":763},{"line":763,"kind":12,"containerName":"_parse_distmat","name":"_readline"},{"line":764,"kind":13,"containerName":"_parse_distmat","name":"$self"},{"name":"_readline","kind":12,"containerName":"_parse_distmat","line":764},{"name":"$self","kind":13,"containerName":"_parse_distmat","line":765},{"line":765,"containerName":"_parse_distmat","kind":12,"name":"_readline"},{"definition":"my","line":767,"name":"$seqct","localvar":"my","containerName":"_parse_distmat","kind":13},{"name":"@seqs","containerName":"_parse_distmat","localvar":"my","kind":13,"line":768,"definition":"my"},{"line":769,"kind":13,"containerName":"_parse_distmat","name":"$self"},{"line":769,"name":"_readline","containerName":"_parse_distmat","kind":12},{"containerName":"_parse_distmat","kind":13,"name":"$self","line":770},{"line":773,"name":"$seq","localvar":"my","containerName":"_parse_distmat","kind":13,"definition":"my"},{"line":773,"name":"$rest","kind":13,"containerName":"_parse_distmat"},{"containerName":"_parse_distmat","kind":13,"name":"$rest","line":774},{"line":774,"kind":13,"containerName":"_parse_distmat","name":"$rest"},{"line":775,"name":"$j","localvar":"my","containerName":"_parse_distmat","kind":13,"definition":"my"},{"line":776,"name":"$self","containerName":"_parse_distmat","kind":13},{"line":777,"name":"@seqs","containerName":"_parse_distmat","kind":13},{"line":777,"name":"new","kind":12,"containerName":"_parse_distmat"},{"name":"$seq","kind":13,"containerName":"_parse_distmat","line":777},{"line":779,"containerName":"_parse_distmat","kind":13,"name":"$rest"},{"line":779,"containerName":"_parse_distmat","kind":13,"name":"$rest"},{"name":"$self","containerName":"_parse_distmat","kind":13,"line":781},{"line":781,"kind":13,"containerName":"_parse_distmat","name":"$j"},{"name":"$seqct","kind":13,"containerName":"_parse_distmat","line":781},{"name":"$seqct","containerName":"_parse_distmat","kind":13,"line":786},{"name":"$self","kind":13,"containerName":"_parse_distmat","line":788},{"kind":13,"containerName":"_parse_distmat","name":"@seqs","line":788},{"line":789,"kind":13,"containerName":"_parse_distmat","name":"$self"},{"line":789,"name":"@seqs","containerName":"_parse_distmat","kind":13}],"detail":"($self)","definition":"sub","range":{"end":{"character":9999,"line":793},"start":{"character":0,"line":739}},"kind":12,"line":739,"signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"_parse_distmat($self)"}},{"containerName":"PrimarySeq","kind":12,"name":"Bio","line":777},{"detail":"($self)","definition":"sub","name":"_parse_PairwiseCodon","containerName":"main::","children":[{"line":797,"name":"$self","localvar":"my","containerName":"_parse_PairwiseCodon","kind":13,"definition":"my"},{"definition":"my","localvar":"my","containerName":"_parse_PairwiseCodon","kind":13,"name":"@result","line":798},{"definition":"my","name":"$a","containerName":"_parse_PairwiseCodon","localvar":"my","kind":13,"line":799},{"name":"$b","containerName":"_parse_PairwiseCodon","kind":13,"line":799},{"containerName":"_parse_PairwiseCodon","kind":13,"name":"$log","line":799},{"line":799,"name":"$model","containerName":"_parse_PairwiseCodon","kind":13},{"kind":13,"containerName":"_parse_PairwiseCodon","name":"$t","line":799},{"kind":13,"containerName":"_parse_PairwiseCodon","name":"$kappa","line":799},{"containerName":"_parse_PairwiseCodon","kind":13,"name":"$omega","line":799},{"containerName":"_parse_PairwiseCodon","kind":13,"name":"$self","line":800},{"name":"_readline","containerName":"_parse_PairwiseCodon","kind":12,"line":800},{"name":"$model","kind":13,"containerName":"_parse_PairwiseCodon","line":802},{"line":804,"kind":13,"containerName":"_parse_PairwiseCodon","name":"$a"},{"name":"$b","kind":13,"containerName":"_parse_PairwiseCodon","line":804},{"line":806,"name":"$log","kind":13,"containerName":"_parse_PairwiseCodon"},{"containerName":"_parse_PairwiseCodon","kind":13,"name":"$self","line":807},{"name":"_readline","kind":12,"containerName":"_parse_PairwiseCodon","line":807},{"line":809,"name":"$t","kind":13,"containerName":"_parse_PairwiseCodon"},{"name":"$kappa","containerName":"_parse_PairwiseCodon","kind":13,"line":809},{"kind":13,"containerName":"_parse_PairwiseCodon","name":"$omega","line":809},{"name":"$result","kind":13,"containerName":"_parse_PairwiseCodon","line":817},{"kind":13,"containerName":"_parse_PairwiseCodon","name":"$b","line":817},{"name":"$a","kind":13,"containerName":"_parse_PairwiseCodon","line":817},{"line":818,"kind":13,"containerName":"_parse_PairwiseCodon","name":"$log"},{"name":"$t","kind":13,"containerName":"_parse_PairwiseCodon","line":819},{"name":"$t","containerName":"_parse_PairwiseCodon","kind":13,"line":819},{"name":"$t","containerName":"_parse_PairwiseCodon","kind":13,"line":819},{"name":"$kappa","kind":13,"containerName":"_parse_PairwiseCodon","line":822},{"name":"$omega","kind":13,"containerName":"_parse_PairwiseCodon","line":823},{"line":823,"name":"$omega","containerName":"_parse_PairwiseCodon","kind":13},{"name":"$omega","containerName":"_parse_PairwiseCodon","kind":13,"line":823},{"name":"$self","containerName":"_parse_PairwiseCodon","kind":13,"line":830},{"line":830,"containerName":"_parse_PairwiseCodon","kind":12,"name":"debug"},{"line":833,"name":"@result","containerName":"_parse_PairwiseCodon","kind":13}],"signature":{"label":"_parse_PairwiseCodon($self)","parameters":[{"label":"$self"}],"documentation":""},"range":{"end":{"character":9999,"line":834},"start":{"line":796,"character":0}},"kind":12,"line":796},{"signature":{"label":"_parse_YN_Pairwise($self)","documentation":"","parameters":[{"label":"$self"}]},"range":{"end":{"line":878,"character":9999},"start":{"character":0,"line":836}},"kind":12,"line":836,"detail":"($self)","definition":"sub","containerName":"main::","name":"_parse_YN_Pairwise","children":[{"definition":"my","line":837,"containerName":"_parse_YN_Pairwise","localvar":"my","kind":13,"name":"$self"},{"definition":"my","name":"@result","containerName":"_parse_YN_Pairwise","localvar":"my","kind":13,"line":838},{"kind":13,"containerName":"_parse_YN_Pairwise","name":"$self","line":839},{"kind":12,"containerName":"_parse_YN_Pairwise","name":"_readline","line":839},{"line":842,"name":"$self","kind":13,"containerName":"_parse_YN_Pairwise"},{"name":"_readline","containerName":"_parse_YN_Pairwise","kind":12,"line":842},{"containerName":"_parse_YN_Pairwise","kind":13,"name":"$result","line":859},{"line":873,"name":"$self","kind":13,"containerName":"_parse_YN_Pairwise"},{"line":873,"containerName":"_parse_YN_Pairwise","kind":12,"name":"_pushback"},{"containerName":"_parse_YN_Pairwise","kind":13,"name":"@result","line":877}]},{"detail":"($self)","definition":"sub","name":"_parse_Forestry","containerName":"main::","children":[{"line":881,"kind":13,"localvar":"my","containerName":"_parse_Forestry","name":"$self","definition":"my"},{"definition":"my","name":"$instancecount","kind":13,"localvar":"my","containerName":"_parse_Forestry","line":882},{"name":"$num_param","containerName":"_parse_Forestry","kind":13,"line":882},{"line":883,"containerName":"_parse_Forestry","kind":13,"name":"$loglikelihood"},{"name":"$score","containerName":"_parse_Forestry","kind":13,"line":883},{"line":883,"name":"$done","containerName":"_parse_Forestry","kind":13},{"line":883,"kind":13,"containerName":"_parse_Forestry","name":"$treelength"},{"definition":"my","line":884,"localvar":"my","containerName":"_parse_Forestry","kind":13,"name":"$okay"},{"definition":"my","line":885,"localvar":"my","kind":13,"containerName":"_parse_Forestry","name":"@ids"},{"line":885,"kind":13,"containerName":"_parse_Forestry","name":"%match"},{"line":885,"containerName":"_parse_Forestry","kind":13,"name":"@branches"},{"name":"@trees","kind":13,"containerName":"_parse_Forestry","line":885},{"name":"$self","kind":13,"containerName":"_parse_Forestry","line":886},{"name":"_readline","kind":12,"containerName":"_parse_Forestry","line":886},{"name":"$done","kind":13,"containerName":"_parse_Forestry","line":887},{"line":889,"name":"$score","kind":13,"containerName":"_parse_Forestry"},{"line":890,"name":"@ids","kind":13,"containerName":"_parse_Forestry"},{"name":"$self","containerName":"_parse_Forestry","kind":13,"line":893},{"line":893,"name":"_pushback","containerName":"_parse_Forestry","kind":12},{"line":894,"containerName":"_parse_Forestry","kind":13,"name":"$done"},{"line":897,"kind":13,"containerName":"_parse_Forestry","name":"$treelength"},{"line":902,"containerName":"_parse_Forestry","kind":13,"name":"$num_param"},{"line":902,"containerName":"_parse_Forestry","kind":13,"name":"$loglikelihood"},{"line":905,"localvar":"my","containerName":"_parse_Forestry","kind":13,"name":"$treestr","definition":"my"},{"definition":"my","name":"$treeio","containerName":"_parse_Forestry","localvar":"my","kind":13,"line":906},{"name":"new","kind":12,"containerName":"_parse_Forestry","line":906},{"containerName":"_parse_Forestry","kind":13,"name":"$treestr","line":906},{"containerName":"_parse_Forestry","localvar":"my","kind":13,"name":"$tree","line":908,"definition":"my"},{"name":"$treeio","kind":13,"containerName":"_parse_Forestry","line":908},{"name":"next_tree","containerName":"_parse_Forestry","kind":12,"line":908},{"kind":13,"containerName":"_parse_Forestry","name":"$tree","line":909},{"name":"$tree","kind":13,"containerName":"_parse_Forestry","line":910},{"kind":12,"containerName":"_parse_Forestry","name":"score","line":910},{"kind":13,"containerName":"_parse_Forestry","name":"$loglikelihood","line":910},{"name":"$tree","containerName":"_parse_Forestry","kind":13,"line":911},{"line":911,"name":"id","containerName":"_parse_Forestry","kind":12},{"line":912,"name":"$okay","kind":13,"containerName":"_parse_Forestry"},{"line":914,"name":"%match","kind":13,"containerName":"_parse_Forestry"},{"line":914,"containerName":"_parse_Forestry","kind":13,"name":"@ids"},{"line":915,"localvar":"my","containerName":"_parse_Forestry","kind":13,"name":"$i","definition":"my"},{"line":916,"localvar":"my","kind":13,"containerName":"_parse_Forestry","name":"$m","definition":"my"},{"name":"$match","kind":13,"containerName":"_parse_Forestry","line":917},{"line":917,"kind":13,"containerName":"_parse_Forestry","name":"@ids"},{"containerName":"_parse_Forestry","kind":13,"name":"$m","line":917},{"definition":"my","line":919,"name":"%grp","containerName":"_parse_Forestry","localvar":"my","kind":13},{"name":"$br","containerName":"_parse_Forestry","localvar":"my","kind":13,"line":920,"definition":"my"},{"name":"@branches","containerName":"_parse_Forestry","kind":13,"line":920},{"localvar":"my","containerName":"_parse_Forestry","kind":13,"name":"$parent","line":921,"definition":"my"},{"name":"$child","kind":13,"containerName":"_parse_Forestry","line":921},{"containerName":"_parse_Forestry","kind":13,"name":"$br","line":921},{"line":922,"name":"$match","containerName":"_parse_Forestry","kind":13},{"line":922,"containerName":"_parse_Forestry","kind":13,"name":"$child"},{"kind":13,"containerName":"_parse_Forestry","name":"$match","line":923},{"line":923,"kind":13,"containerName":"_parse_Forestry","name":"$parent"},{"line":923,"containerName":"_parse_Forestry","kind":13,"name":"$match"},{"line":923,"containerName":"_parse_Forestry","kind":13,"name":"$child"},{"line":925,"name":"@branches","containerName":"_parse_Forestry","kind":13},{"containerName":"_parse_Forestry","kind":13,"name":"$br","line":925},{"line":928,"name":"$self","kind":13,"containerName":"_parse_Forestry"},{"name":"verbose","containerName":"_parse_Forestry","kind":12,"line":928},{"definition":"my","containerName":"_parse_Forestry","localvar":"my","kind":13,"name":"$k","line":929},{"containerName":"_parse_Forestry","kind":13,"name":"$a","line":929},{"name":"$b","kind":13,"containerName":"_parse_Forestry","line":929},{"line":929,"containerName":"_parse_Forestry","kind":13,"name":"%match"},{"name":"$self","kind":13,"containerName":"_parse_Forestry","line":930},{"kind":12,"containerName":"_parse_Forestry","name":"debug","line":930},{"line":931,"kind":13,"containerName":"_parse_Forestry","name":"$match"},{"kind":13,"containerName":"_parse_Forestry","name":"$k","line":931},{"line":936,"kind":13,"containerName":"_parse_Forestry","name":"$self"},{"definition":"my","name":"@SEs","localvar":"my","kind":13,"containerName":"_parse_Forestry","line":937},{"containerName":"_parse_Forestry","kind":13,"name":"$self","line":937},{"line":938,"name":"$i","containerName":"_parse_Forestry","localvar":"my","kind":13,"definition":"my"},{"definition":"my","name":"$parent_id","localvar":"my","containerName":"_parse_Forestry","kind":13,"line":939},{"containerName":"_parse_Forestry","kind":13,"name":"$self","line":939},{"line":940,"containerName":"_parse_Forestry","localvar":"my","kind":13,"name":"@nodes","definition":"my"},{"definition":"my","line":941,"containerName":"_parse_Forestry","localvar":"my","kind":13,"name":"@node_ids"},{"line":941,"kind":13,"containerName":"_parse_Forestry","name":"$match"},{"line":941,"kind":13,"containerName":"_parse_Forestry","name":"$parent_id"},{"definition":"my","localvar":"my","containerName":"_parse_Forestry","kind":13,"name":"@nodes_L","line":942},{"kind":13,"containerName":"_parse_Forestry","name":"$tree","line":942},{"line":942,"kind":12,"containerName":"_parse_Forestry","name":"find_node"},{"name":"@node_ids","containerName":"_parse_Forestry","kind":13,"line":942},{"line":943,"name":"$n","kind":13,"localvar":"my","containerName":"_parse_Forestry","definition":"my"},{"name":"@nodes_L","kind":13,"containerName":"_parse_Forestry","line":943},{"kind":13,"containerName":"_parse_Forestry","name":"@nodes_L","line":943},{"containerName":"_parse_Forestry","kind":13,"name":"$tree","line":943},{"line":943,"name":"get_lca","containerName":"_parse_Forestry","kind":12},{"kind":13,"containerName":"_parse_Forestry","name":"@nodes_L","line":943},{"name":"$n","kind":13,"containerName":"_parse_Forestry","line":944},{"line":945,"containerName":"_parse_Forestry","kind":13,"name":"$self"},{"name":"warn","containerName":"_parse_Forestry","kind":12,"line":945},{"line":947,"name":"$n","containerName":"_parse_Forestry","kind":13},{"line":947,"name":"add_tag_value","kind":12,"containerName":"_parse_Forestry"},{"name":"$SEs","containerName":"_parse_Forestry","kind":13,"line":947},{"line":947,"name":"$i","kind":13,"containerName":"_parse_Forestry"},{"name":"$i","kind":13,"containerName":"_parse_Forestry","line":948},{"name":"@trees","containerName":"_parse_Forestry","kind":13,"line":951},{"name":"$tree","containerName":"_parse_Forestry","kind":13,"line":951}],"signature":{"label":"_parse_Forestry($self)","parameters":[{"label":"$self"}],"documentation":""},"kind":12,"range":{"start":{"line":880,"character":0},"end":{"line":952,"character":9999}},"line":880},{"line":905,"name":"IO","kind":12,"containerName":"String"},{"name":"Bio","kind":12,"containerName":"TreeIO","line":906},{"kind":12,"name":"_SEs","line":936},{"name":"_SEs","kind":12,"line":937},{"line":939,"name":"_branch_ids","kind":12},{"line":954,"name":"%okay","kind":13,"containerName":null},{"line":956,"name":"$se_line","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"name":"$self","containerName":null,"kind":13,"line":956},{"line":956,"containerName":"main::","kind":12,"name":"_readline"},{"name":"$se_line","containerName":null,"kind":13,"line":957},{"line":958,"kind":13,"containerName":null,"name":"%self"},{"name":"_SEs","kind":12,"line":958},{"line":958,"containerName":null,"kind":13,"name":"%se_line"},{"name":"@branches","containerName":null,"kind":13,"line":960},{"containerName":null,"localvar":"my","kind":13,"name":"$ids","line":961,"definition":"my"},{"line":961,"kind":13,"containerName":null,"name":"$ids"},{"containerName":null,"kind":13,"name":"%self","line":962},{"name":"_branch_ids","kind":12,"line":962},{"name":"$ids","containerName":null,"kind":13,"line":962},{"line":965,"containerName":null,"kind":13,"name":"@trees"},{"line":965,"containerName":null,"kind":13,"name":"%match"},{"children":[{"definition":"my","line":969,"containerName":"_parse_NSsitesBatch","localvar":"my","kind":13,"name":"$self"},{"name":"%data","containerName":"_parse_NSsitesBatch","localvar":"my","kind":13,"line":970,"definition":"my"},{"name":"$idlookup","containerName":"_parse_NSsitesBatch","kind":13,"line":970},{"definition":"my","line":971,"kind":13,"localvar":"my","containerName":"_parse_NSsitesBatch","name":"$okay"},{"kind":13,"containerName":"_parse_NSsitesBatch","name":"$done","line":971},{"line":972,"kind":13,"containerName":"_parse_NSsitesBatch","name":"$self"},{"name":"_readline","kind":12,"containerName":"_parse_NSsitesBatch","line":972},{"kind":13,"containerName":"_parse_NSsitesBatch","name":"$done","line":973},{"line":975,"containerName":"_parse_NSsitesBatch","kind":13,"name":"$okay"},{"line":978,"containerName":"_parse_NSsitesBatch","kind":13,"name":"$okay"},{"line":981,"name":"$self","containerName":"_parse_NSsitesBatch","kind":13},{"kind":12,"containerName":"_parse_NSsitesBatch","name":"_pushback","line":981},{"line":982,"containerName":"_parse_NSsitesBatch","kind":13,"name":"$done"},{"line":985,"name":"$data","containerName":"_parse_NSsitesBatch","kind":13},{"line":986,"containerName":"_parse_NSsitesBatch","kind":13,"name":"$data"},{"line":987,"containerName":"_parse_NSsitesBatch","kind":13,"name":"$okay"},{"line":990,"kind":13,"containerName":"_parse_NSsitesBatch","name":"$data"},{"containerName":"_parse_NSsitesBatch","kind":13,"name":"$done","line":991},{"line":993,"kind":13,"containerName":"_parse_NSsitesBatch","name":"$data"},{"name":"$self","kind":13,"containerName":"_parse_NSsitesBatch","line":995},{"line":995,"kind":12,"containerName":"_parse_NSsitesBatch","name":"_pushback"},{"line":996,"containerName":"_parse_NSsitesBatch","kind":13,"name":"$data"},{"name":"$idlookup","containerName":"_parse_NSsitesBatch","kind":13,"line":996},{"line":996,"kind":13,"containerName":"_parse_NSsitesBatch","name":"$self"},{"line":996,"kind":12,"containerName":"_parse_NSsitesBatch","name":"_parse_Forestry"},{"line":997,"containerName":"_parse_NSsitesBatch","kind":13,"name":"$data"},{"kind":13,"containerName":"_parse_NSsitesBatch","name":"$data","line":998},{"name":"$data","kind":13,"containerName":"_parse_NSsitesBatch","line":999},{"kind":13,"containerName":"_parse_NSsitesBatch","name":"$data","line":999},{"name":"score","kind":12,"containerName":"_parse_NSsitesBatch","line":999},{"name":"$okay","containerName":"_parse_NSsitesBatch","kind":13,"line":1001},{"definition":"my","containerName":"_parse_NSsitesBatch","localvar":"my","kind":13,"name":"@p","line":1006},{"localvar":"my","kind":13,"containerName":"_parse_NSsitesBatch","name":"@w","line":1007,"definition":"my"},{"containerName":"_parse_NSsitesBatch","kind":13,"name":"$data","line":1008},{"line":1008,"containerName":"_parse_NSsitesBatch","kind":13,"name":"@p"},{"name":"@w","kind":13,"containerName":"_parse_NSsitesBatch","line":1009},{"containerName":"_parse_NSsitesBatch","kind":13,"name":"$data","line":1011},{"kind":13,"containerName":"_parse_NSsitesBatch","name":"$self","line":1013},{"kind":12,"containerName":"_parse_NSsitesBatch","name":"_pushback","line":1013},{"definition":"my","line":1014,"name":"$sites","localvar":"my","containerName":"_parse_NSsitesBatch","kind":13},{"line":1014,"name":"$neb","kind":13,"containerName":"_parse_NSsitesBatch"},{"containerName":"_parse_NSsitesBatch","kind":13,"name":"$beb","line":1014},{"line":1014,"name":"$self","kind":13,"containerName":"_parse_NSsitesBatch"},{"line":1014,"containerName":"_parse_NSsitesBatch","kind":12,"name":"_parse_Pos_selected_sites"},{"name":"$data","containerName":"_parse_NSsitesBatch","kind":13,"line":1015},{"name":"$sites","containerName":"_parse_NSsitesBatch","kind":13,"line":1015},{"line":1016,"name":"$data","kind":13,"containerName":"_parse_NSsitesBatch"},{"line":1016,"containerName":"_parse_NSsitesBatch","kind":13,"name":"$neb"},{"containerName":"_parse_NSsitesBatch","kind":13,"name":"$data","line":1017},{"containerName":"_parse_NSsitesBatch","kind":13,"name":"$beb","line":1017},{"kind":13,"containerName":"_parse_NSsitesBatch","name":"$data","line":1020},{"line":1021,"kind":13,"containerName":"_parse_NSsitesBatch","name":"$self"},{"containerName":"_parse_NSsitesBatch","kind":12,"name":"_readline","line":1021},{"containerName":"_parse_NSsitesBatch","kind":13,"name":"$self","line":1023},{"name":"_pushback","containerName":"_parse_NSsitesBatch","kind":12,"line":1023},{"line":1028,"name":"$self","containerName":"_parse_NSsitesBatch","kind":13},{"name":"_readline","kind":12,"containerName":"_parse_NSsitesBatch","line":1028},{"definition":"my","localvar":"my","containerName":"_parse_NSsitesBatch","kind":13,"name":"$tmp","line":1029},{"line":1029,"name":"$self","kind":13,"containerName":"_parse_NSsitesBatch"},{"line":1029,"containerName":"_parse_NSsitesBatch","kind":12,"name":"_readline"},{"definition":"my","name":"@p","localvar":"my","kind":13,"containerName":"_parse_NSsitesBatch","line":1030},{"line":1030,"kind":13,"containerName":"_parse_NSsitesBatch","name":"$tmp"},{"name":"$tmp","kind":13,"containerName":"_parse_NSsitesBatch","line":1031},{"line":1031,"kind":13,"containerName":"_parse_NSsitesBatch","name":"$self"},{"kind":12,"containerName":"_parse_NSsitesBatch","name":"_readline","line":1031},{"definition":"my","line":1032,"name":"@b_w","kind":13,"localvar":"my","containerName":"_parse_NSsitesBatch"},{"line":1032,"name":"$tmp","containerName":"_parse_NSsitesBatch","kind":13},{"line":1033,"name":"$tmp","containerName":"_parse_NSsitesBatch","kind":13},{"line":1033,"containerName":"_parse_NSsitesBatch","kind":13,"name":"$self"},{"line":1033,"kind":12,"containerName":"_parse_NSsitesBatch","name":"_readline"},{"name":"@f_w","localvar":"my","containerName":"_parse_NSsitesBatch","kind":13,"line":1034,"definition":"my"},{"containerName":"_parse_NSsitesBatch","kind":13,"name":"$tmp","line":1034},{"line":1035,"containerName":"_parse_NSsitesBatch","localvar":"my","kind":13,"name":"@w","definition":"my"},{"definition":"my","containerName":"_parse_NSsitesBatch","localvar":"my","kind":13,"name":"$i","line":1036},{"name":"@w","kind":13,"containerName":"_parse_NSsitesBatch","line":1037},{"line":1037,"kind":13,"containerName":"_parse_NSsitesBatch","name":"$b_w"},{"line":1037,"containerName":"_parse_NSsitesBatch","kind":13,"name":"$i"},{"containerName":"_parse_NSsitesBatch","kind":13,"name":"$f_w","line":1038},{"kind":13,"containerName":"_parse_NSsitesBatch","name":"$i","line":1038},{"kind":13,"containerName":"_parse_NSsitesBatch","name":"$data","line":1040},{"line":1040,"name":"@p","containerName":"_parse_NSsitesBatch","kind":13},{"line":1041,"kind":13,"containerName":"_parse_NSsitesBatch","name":"@w"},{"definition":"my","name":"$tmp","kind":13,"localvar":"my","containerName":"_parse_NSsitesBatch","line":1043},{"line":1043,"kind":13,"containerName":"_parse_NSsitesBatch","name":"$self"},{"line":1043,"name":"_readline","containerName":"_parse_NSsitesBatch","kind":12},{"definition":"my","name":"@p","containerName":"_parse_NSsitesBatch","localvar":"my","kind":13,"line":1044},{"line":1044,"name":"$tmp","kind":13,"containerName":"_parse_NSsitesBatch"},{"line":1045,"containerName":"_parse_NSsitesBatch","kind":13,"name":"$tmp"},{"line":1045,"containerName":"_parse_NSsitesBatch","kind":13,"name":"$self"},{"line":1045,"containerName":"_parse_NSsitesBatch","kind":12,"name":"_readline"},{"name":"@w","localvar":"my","kind":13,"containerName":"_parse_NSsitesBatch","line":1046,"definition":"my"},{"name":"$tmp","kind":13,"containerName":"_parse_NSsitesBatch","line":1046},{"kind":13,"containerName":"_parse_NSsitesBatch","name":"$data","line":1047},{"name":"@p","containerName":"_parse_NSsitesBatch","kind":13,"line":1047},{"containerName":"_parse_NSsitesBatch","kind":13,"name":"@w","line":1048},{"line":1051,"localvar":"my","kind":13,"containerName":"_parse_NSsitesBatch","name":"%branch_dnds","definition":"my"},{"name":"$self","kind":13,"containerName":"_parse_NSsitesBatch","line":1051},{"containerName":"_parse_NSsitesBatch","kind":12,"name":"_parse_branch_dnds","line":1051},{"line":1052,"name":"$data","containerName":"_parse_NSsitesBatch","kind":13},{"line":1053,"containerName":"_parse_NSsitesBatch","kind":13,"name":"$self"},{"line":1053,"kind":12,"containerName":"_parse_NSsitesBatch","name":"warn"},{"line":1056,"name":"$tree","localvar":"my","containerName":"_parse_NSsitesBatch","kind":13,"definition":"my"},{"line":1056,"containerName":"_parse_NSsitesBatch","kind":13,"name":"$data"},{"line":1057,"kind":13,"containerName":"_parse_NSsitesBatch","name":"$tree"},{"line":1057,"name":"$tree","kind":13,"containerName":"_parse_NSsitesBatch"},{"line":1058,"name":"$tree","containerName":"_parse_NSsitesBatch","kind":13},{"name":"isa","containerName":"_parse_NSsitesBatch","kind":12,"line":1058},{"line":1059,"name":"$self","containerName":"_parse_NSsitesBatch","kind":13},{"name":"warn","containerName":"_parse_NSsitesBatch","kind":12,"line":1059},{"line":1063,"localvar":"my","kind":13,"containerName":"_parse_NSsitesBatch","name":"$k","definition":"my"},{"containerName":"_parse_NSsitesBatch","kind":13,"name":"$v","line":1063},{"name":"%branch_dnds","kind":13,"containerName":"_parse_NSsitesBatch","line":1063},{"containerName":"_parse_NSsitesBatch","localvar":"my","kind":13,"name":"@nodes","line":1065,"definition":"my"},{"line":1066,"name":"$id","containerName":"_parse_NSsitesBatch","localvar":"my","kind":13,"definition":"my"},{"line":1066,"name":"$k","kind":13,"containerName":"_parse_NSsitesBatch"},{"kind":13,"localvar":"my","containerName":"_parse_NSsitesBatch","name":"@nodes_L","line":1067,"definition":"my"},{"line":1067,"name":"$tree","kind":13,"containerName":"_parse_NSsitesBatch"},{"kind":12,"containerName":"_parse_NSsitesBatch","name":"find_node","line":1067},{"name":"$idlookup","containerName":"_parse_NSsitesBatch","kind":13,"line":1067},{"name":"$id","containerName":"_parse_NSsitesBatch","kind":13,"line":1067},{"definition":"my","name":"$n","containerName":"_parse_NSsitesBatch","localvar":"my","kind":13,"line":1068},{"line":1068,"name":"@nodes_L","containerName":"_parse_NSsitesBatch","kind":13},{"containerName":"_parse_NSsitesBatch","kind":13,"name":"@nodes_L","line":1068},{"line":1068,"containerName":"_parse_NSsitesBatch","kind":13,"name":"$tree"},{"containerName":"_parse_NSsitesBatch","kind":12,"name":"get_lca","line":1068},{"line":1068,"name":"@nodes_L","kind":13,"containerName":"_parse_NSsitesBatch"},{"name":"$n","containerName":"_parse_NSsitesBatch","kind":13,"line":1069},{"kind":13,"containerName":"_parse_NSsitesBatch","name":"$self","line":1070},{"name":"warn","kind":12,"containerName":"_parse_NSsitesBatch","line":1070},{"name":"$n","kind":13,"containerName":"_parse_NSsitesBatch","line":1072},{"line":1072,"name":"is_Leaf","containerName":"_parse_NSsitesBatch","kind":12},{"line":1072,"containerName":"_parse_NSsitesBatch","kind":13,"name":"$n"},{"kind":12,"containerName":"_parse_NSsitesBatch","name":"id","line":1072},{"name":"$n","kind":13,"containerName":"_parse_NSsitesBatch","line":1073},{"name":"id","containerName":"_parse_NSsitesBatch","kind":12,"line":1073},{"name":"$id","kind":13,"containerName":"_parse_NSsitesBatch","line":1073},{"line":1075,"kind":13,"containerName":"_parse_NSsitesBatch","name":"@nodes"},{"line":1075,"kind":13,"containerName":"_parse_NSsitesBatch","name":"$n"},{"line":1077,"localvar":"my","kind":13,"containerName":"_parse_NSsitesBatch","name":"$parent","definition":"my"},{"containerName":"_parse_NSsitesBatch","kind":13,"name":"$child","line":1077},{"kind":13,"containerName":"_parse_NSsitesBatch","name":"@nodes","line":1077},{"definition":"my","line":1078,"name":"$kk","localvar":"my","kind":13,"containerName":"_parse_NSsitesBatch"},{"line":1078,"name":"$vv","containerName":"_parse_NSsitesBatch","kind":13},{"line":1078,"name":"$v","containerName":"_parse_NSsitesBatch","kind":13},{"kind":13,"containerName":"_parse_NSsitesBatch","name":"$child","line":1079},{"line":1079,"containerName":"_parse_NSsitesBatch","kind":12,"name":"add_tag_value"},{"kind":13,"containerName":"_parse_NSsitesBatch","name":"$kk","line":1079},{"kind":13,"containerName":"_parse_NSsitesBatch","name":"$vv","line":1079}],"name":"_parse_NSsitesBatch","containerName":"main::","definition":"sub","line":968,"range":{"start":{"character":0,"line":968},"end":{"character":9999,"line":1082}},"kind":12},{"line":1036,"name":"b_w","kind":12},{"line":1084,"containerName":null,"kind":13,"name":"$self"},{"line":1084,"kind":12,"containerName":"main::","name":"_readline"},{"line":1086,"name":"%data","containerName":null,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":1091},{"line":1091,"name":"warn","containerName":"main::","kind":12},{"name":"$self","kind":13,"containerName":null,"line":1097},{"line":1097,"containerName":"main::","kind":12,"name":"_readline"},{"definition":"my","name":"$p0","localvar":"my","containerName":null,"kind":13,"line":1098},{"line":1098,"kind":13,"containerName":null,"name":"$p"},{"kind":13,"containerName":null,"name":"$q","line":1098},{"line":1098,"name":"$p1","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%w","line":1098},{"containerName":null,"kind":13,"name":"$p0","line":1100},{"line":1100,"containerName":null,"kind":13,"name":"$p"},{"line":1100,"name":"%q","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$self","line":1102},{"containerName":"main::","kind":12,"name":"warn","line":1102},{"kind":13,"containerName":null,"name":"$self","line":1104},{"name":"_readline","containerName":"main::","kind":12,"line":1104},{"name":"$p1","kind":13,"containerName":null,"line":1106},{"line":1106,"containerName":null,"kind":13,"name":"$w"},{"kind":13,"containerName":null,"name":"%data","line":1107},{"line":1109,"name":"$p0","kind":13,"containerName":null},{"name":"$p","kind":13,"containerName":null,"line":1110},{"name":"$q","kind":13,"containerName":null,"line":1111},{"line":1112,"kind":13,"containerName":null,"name":"$p1"},{"name":"%w","kind":13,"containerName":null,"line":1113},{"line":1115,"name":"$self","containerName":null,"kind":13},{"line":1115,"containerName":"main::","kind":12,"name":"warn"},{"name":"$gamma","kind":13,"localvar":"my","containerName":null,"line":1118,"definition":"my"},{"kind":13,"containerName":null,"name":"$self","line":1119},{"line":1119,"kind":12,"containerName":"main::","name":"_readline"},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"@r","line":1120},{"line":1120,"name":"@f","kind":13,"containerName":null},{"line":1122,"kind":13,"containerName":null,"name":"@r"},{"name":"$self","containerName":null,"kind":13,"line":1124},{"containerName":"main::","kind":12,"name":"_readline","line":1124},{"line":1126,"name":"@f","containerName":null,"kind":13},{"line":1128,"name":"%data","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$gamma","line":1130},{"line":1131,"containerName":null,"kind":13,"name":"@r"},{"kind":13,"containerName":null,"name":"@f","line":1132},{"line":1135,"name":"Bio","containerName":"Tools::Phylo::PAML::ModelResult","kind":12},{"line":1135,"containerName":null,"kind":13,"name":"%data"},{"line":1138,"range":{"end":{"line":1165,"character":9999},"start":{"character":0,"line":1138}},"kind":12,"definition":"sub","children":[{"line":1139,"name":"$self","containerName":"_parse_Pos_selected_sites","localvar":"my","kind":13,"definition":"my"},{"definition":"my","name":"$okay","localvar":"my","kind":13,"containerName":"_parse_Pos_selected_sites","line":1140},{"line":1141,"name":"%sites","localvar":"my","kind":13,"containerName":"_parse_Pos_selected_sites","definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":"_parse_Pos_selected_sites","name":"$type","line":1144},{"line":1145,"name":"$self","containerName":"_parse_Pos_selected_sites","kind":13},{"line":1145,"name":"_readline","kind":12,"containerName":"_parse_Pos_selected_sites"},{"name":"$self","kind":13,"containerName":"_parse_Pos_selected_sites","line":1148},{"kind":12,"containerName":"_parse_Pos_selected_sites","name":"_pushback","line":1148},{"name":"$type","containerName":"_parse_Pos_selected_sites","kind":13,"line":1152},{"line":1154,"name":"$type","kind":13,"containerName":"_parse_Pos_selected_sites"},{"name":"$okay","kind":13,"containerName":"_parse_Pos_selected_sites","line":1156},{"line":1157,"containerName":"_parse_Pos_selected_sites","kind":13,"name":"$okay"},{"definition":"my","name":"$signif","localvar":"my","kind":13,"containerName":"_parse_Pos_selected_sites","line":1158},{"line":1159,"containerName":"_parse_Pos_selected_sites","kind":13,"name":"$signif"},{"name":"$signif","containerName":"_parse_Pos_selected_sites","kind":13,"line":1159},{"line":1160,"name":"$sites","kind":13,"containerName":"_parse_Pos_selected_sites"},{"line":1160,"name":"$type","containerName":"_parse_Pos_selected_sites","kind":13},{"name":"$signif","containerName":"_parse_Pos_selected_sites","kind":13,"line":1160},{"line":1161,"name":"$okay","containerName":"_parse_Pos_selected_sites","kind":13},{"kind":13,"localvar":"my","containerName":"_parse_Pos_selected_sites","name":"$signif","line":1162,"definition":"my"},{"line":1163,"name":"$signif","containerName":"_parse_Pos_selected_sites","kind":13},{"name":"$signif","containerName":"_parse_Pos_selected_sites","kind":13,"line":1163},{"containerName":"_parse_Pos_selected_sites","kind":13,"name":"$sites","line":1164},{"line":1164,"containerName":"_parse_Pos_selected_sites","kind":13,"name":"$type"},{"line":1164,"name":"$signif","kind":13,"containerName":"_parse_Pos_selected_sites"}],"containerName":"main::","name":"_parse_Pos_selected_sites"},{"line":1165,"containerName":null,"kind":13,"name":"%okay"},{"localvar":"my","kind":13,"containerName":null,"name":"$signif","line":1166,"definition":"my"},{"line":1167,"kind":13,"containerName":null,"name":"$signif"},{"kind":13,"containerName":null,"name":"$signif","line":1167},{"name":"%sites","kind":13,"containerName":null,"line":1168},{"line":1168,"kind":13,"containerName":null,"name":"@type"},{"kind":13,"containerName":null,"name":"$signif","line":1168},{"kind":13,"containerName":null,"name":"%sites","line":1171},{"name":"%sites","containerName":null,"kind":13,"line":1171},{"line":1171,"name":"%sites","containerName":null,"kind":13},{"line":1174,"kind":12,"range":{"start":{"line":1174,"character":0},"end":{"character":9999,"line":1201}},"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_parse_branch_dnds","line":1175,"definition":"my"},{"definition":"my","line":1176,"name":"$okay","kind":13,"localvar":"my","containerName":"_parse_branch_dnds"},{"definition":"my","name":"%branch_dnds","kind":13,"localvar":"my","containerName":"_parse_branch_dnds","line":1177},{"line":1178,"name":"@header","localvar":"my","containerName":"_parse_branch_dnds","kind":13,"definition":"my"},{"containerName":"_parse_branch_dnds","kind":13,"name":"$self","line":1179},{"line":1179,"containerName":"_parse_branch_dnds","kind":12,"name":"_readline"},{"name":"$okay","containerName":"_parse_branch_dnds","kind":13,"line":1181},{"containerName":"_parse_branch_dnds","kind":13,"name":"@header","line":1184},{"line":1185,"name":"$okay","kind":13,"containerName":"_parse_branch_dnds"},{"definition":"my","line":1187,"name":"$branch","localvar":"my","containerName":"_parse_branch_dnds","kind":13},{"name":"$i","kind":13,"localvar":"my","containerName":"_parse_branch_dnds","line":1189,"definition":"my"},{"line":1194,"name":"$branch_dnds","kind":13,"containerName":"_parse_branch_dnds"},{"kind":13,"containerName":"_parse_branch_dnds","name":"$branch","line":1194},{"line":1194,"kind":13,"containerName":"_parse_branch_dnds","name":"$header"},{"line":1194,"kind":13,"containerName":"_parse_branch_dnds","name":"$i"},{"containerName":"_parse_branch_dnds","kind":13,"name":"$self","line":1196},{"line":1196,"name":"_pushback","kind":12,"containerName":"_parse_branch_dnds"},{"containerName":"_parse_branch_dnds","kind":13,"name":"%branch_dnds","line":1200}],"containerName":"main::","name":"_parse_branch_dnds","definition":"sub"},{"line":1205,"range":{"end":{"character":9999,"line":1209},"start":{"line":1205,"character":0}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"baseml stuff","label":"_parse_nt_freqs($self)"},"children":[{"definition":"my","name":"$self","containerName":"_parse_nt_freqs","localvar":"my","kind":13,"line":1206},{"name":"$okay","localvar":"my","kind":13,"containerName":"_parse_nt_freqs","line":1207,"definition":"my"},{"kind":13,"containerName":"_parse_nt_freqs","name":"$done","line":1207},{"name":"$header","kind":13,"containerName":"_parse_nt_freqs","line":1207},{"definition":"my","name":"@bases","kind":13,"localvar":"my","containerName":"_parse_nt_freqs","line":1208},{"name":"$numseqs","localvar":"my","kind":13,"containerName":"_parse_nt_freqs","line":1209,"definition":"my"},{"name":"$self","kind":13,"containerName":"_parse_nt_freqs","line":1209}],"containerName":"main::","name":"_parse_nt_freqs","definition":"sub","detail":"($self)"},{"line":1210,"name":"$self","containerName":null,"kind":13},{"line":1210,"kind":12,"containerName":"main::","name":"_readline"},{"line":1211,"containerName":null,"kind":13,"name":"$self"},{"line":1211,"containerName":"main::","kind":12,"name":"_pushback"},{"containerName":null,"kind":13,"name":"%done","line":1212},{"kind":13,"containerName":null,"name":"$okay","line":1215},{"line":1216,"name":"%okay","kind":13,"containerName":null},{"line":1218,"containerName":null,"kind":13,"name":"%header"},{"line":1220,"name":"@bases","kind":13,"containerName":null},{"line":1221,"kind":13,"containerName":null,"name":"$header"},{"line":1222,"containerName":null,"kind":13,"name":"%self"},{"line":1227,"containerName":null,"kind":13,"name":"%self"},{"containerName":null,"kind":13,"name":"%self","line":1228},{"name":"%self","kind":13,"containerName":null,"line":1230},{"line":1231,"kind":13,"containerName":null,"name":"%done"},{"line":1233,"name":"$seqname","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"containerName":null,"kind":13,"name":"@freqs","line":1233},{"name":"$basect","kind":13,"localvar":"my","containerName":null,"line":1234,"definition":"my"},{"definition":"my","name":"$f","containerName":null,"localvar":"my","kind":13,"line":1235},{"containerName":null,"kind":13,"name":"@freqs","line":1235},{"line":1237,"name":"%self","kind":13,"containerName":null},{"name":"%seqname","containerName":null,"kind":13,"line":1237},{"name":"@bases","kind":13,"containerName":null,"line":1237},{"line":1237,"containerName":null,"kind":13,"name":"$basect"},{"name":"$f","kind":13,"containerName":null,"line":1237},{"name":"_parse_nt_dists","containerName":"main::","children":[{"line":1244,"name":"$self","kind":13,"localvar":"my","containerName":"_parse_nt_dists","definition":"my"},{"definition":"my","line":1245,"name":"$okay","localvar":"my","containerName":"_parse_nt_dists","kind":13},{"kind":13,"containerName":"_parse_nt_dists","name":"$seen","line":1245},{"line":1245,"kind":13,"containerName":"_parse_nt_dists","name":"$done"},{"localvar":"my","kind":13,"containerName":"_parse_nt_dists","name":"%matrix","line":1246,"definition":"my"},{"line":1246,"containerName":"_parse_nt_dists","kind":13,"name":"@names"},{"definition":"my","name":"$numseqs","kind":13,"localvar":"my","containerName":"_parse_nt_dists","line":1247},{"containerName":"_parse_nt_dists","kind":13,"name":"$self","line":1247}],"detail":"($self)","definition":"sub","kind":12,"range":{"start":{"line":1243,"character":0},"end":{"line":1247,"character":9999}},"line":1243,"signature":{"label":"_parse_nt_dists($self)","parameters":[{"label":"$self"}],"documentation":""}},{"line":1248,"name":"$type","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"line":1249,"containerName":null,"kind":13,"name":"$self"},{"line":1249,"name":"_readline","containerName":"main::","kind":12},{"name":"$self","kind":13,"containerName":null,"line":1250},{"line":1250,"name":"_pushback","kind":12,"containerName":"main::"},{"line":1251,"containerName":null,"kind":13,"name":"%done"},{"name":"%seen","kind":13,"containerName":null,"line":1254},{"name":"$okay","containerName":null,"kind":13,"line":1258},{"line":1259,"kind":13,"containerName":null,"name":"$type"},{"containerName":null,"kind":13,"name":"%okay","line":1263},{"definition":"my","line":1264,"kind":13,"localvar":"my","containerName":null,"name":"$seqname"},{"name":"$vl","kind":13,"containerName":null,"line":1264},{"line":1265,"kind":13,"containerName":null,"name":"$seen"},{"definition":"my","name":"$i","localvar":"my","kind":13,"containerName":null,"line":1266},{"line":1267,"kind":13,"containerName":null,"name":"%vl"},{"line":1268,"name":"%vl","kind":13,"containerName":null},{"line":1269,"name":"$kappa","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"kind":13,"containerName":null,"name":"$alpha","line":1269},{"line":1270,"containerName":null,"kind":13,"name":"%matrix"},{"line":1270,"kind":13,"containerName":null,"name":"%seqname"},{"line":1270,"name":"@names","containerName":null,"kind":13},{"line":1270,"containerName":null,"kind":13,"name":"$i"},{"name":"%matrix","containerName":null,"kind":13,"line":1271},{"line":1271,"name":"@names","kind":13,"containerName":null},{"line":1271,"name":"%i","kind":13,"containerName":null},{"line":1271,"name":"@seqname","containerName":null,"kind":13},{"line":1271,"name":"$kappa","kind":13,"containerName":null},{"line":1271,"containerName":null,"kind":13,"name":"$alpha"},{"kind":13,"containerName":null,"name":"$i","line":1273},{"line":1275,"containerName":null,"kind":13,"name":"%i"},{"line":1276,"kind":13,"containerName":null,"name":"$self"},{"line":1276,"kind":12,"containerName":"main::","name":"warn"},{"name":"@names","containerName":null,"kind":13,"line":1279},{"containerName":null,"kind":13,"name":"$seqname","line":1279},{"line":1280,"containerName":null,"kind":13,"name":"%matrix"},{"kind":13,"containerName":null,"name":"%seqname","line":1280},{"line":1280,"name":"@seqname","containerName":null,"kind":13},{"line":1282,"name":"$done","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"@names","line":1282},{"line":1282,"name":"$numseqs","containerName":null,"kind":13},{"definition":"my","name":"%dist","kind":13,"localvar":"my","containerName":null,"line":1284},{"line":1285,"localvar":"my","kind":13,"containerName":null,"name":"$i","definition":"my"},{"containerName":null,"localvar":"my","kind":13,"name":"@kvalues","line":1286,"definition":"my"},{"line":1286,"kind":13,"containerName":null,"name":"@avalues"},{"definition":"my","line":1287,"localvar":"my","containerName":null,"kind":13,"name":"$lname"},{"line":1287,"containerName":null,"kind":13,"name":"@names"},{"localvar":"my","containerName":null,"kind":13,"name":"@arow","line":1288,"definition":"my"},{"kind":13,"containerName":null,"name":"@krow","line":1288},{"name":"$j","kind":13,"localvar":"my","containerName":null,"line":1289,"definition":"my"},{"definition":"my","line":1290,"name":"$rname","localvar":"my","containerName":null,"kind":13},{"name":"@names","kind":13,"containerName":null,"line":1290},{"line":1291,"localvar":"my","kind":13,"containerName":null,"name":"$v","definition":"my"},{"name":"%matrix","containerName":null,"kind":13,"line":1291},{"name":"%lname","kind":13,"containerName":null,"line":1291},{"containerName":null,"kind":13,"name":"$rname","line":1291},{"line":1293,"containerName":null,"kind":13,"name":"@krow"},{"line":1293,"name":"@v","kind":13,"containerName":null},{"name":"@arow","kind":13,"containerName":null,"line":1294},{"line":1294,"name":"@v","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%dist","line":1295},{"name":"%lname","containerName":null,"kind":13,"line":1295},{"line":1295,"kind":13,"containerName":null,"name":"@rname"},{"name":"$i","containerName":null,"kind":13,"line":1295},{"kind":13,"containerName":null,"name":"$j","line":1295},{"kind":13,"containerName":null,"name":"$i","line":1297},{"line":1298,"name":"@kvalues","kind":13,"containerName":null},{"line":1298,"kind":13,"containerName":null,"name":"@krow"},{"kind":13,"containerName":null,"name":"@avalues","line":1299},{"name":"@arow","containerName":null,"kind":13,"line":1299},{"name":"Bio","kind":12,"containerName":"Matrix::PhylipDist","line":1302},{"line":1303,"kind":12,"containerName":"main::","name":"new"},{"name":"%self","kind":13,"containerName":null,"line":1303},{"line":1304,"containerName":null,"kind":13,"name":"%dist"},{"kind":13,"containerName":null,"name":"@names","line":1305},{"containerName":null,"kind":13,"name":"@kvalues","line":1306},{"line":1307,"kind":12,"containerName":"Matrix::PhylipDist","name":"Bio"},{"name":"new","containerName":"main::","kind":12,"line":1308},{"line":1308,"name":"%self","containerName":null,"kind":13},{"line":1309,"name":"%dist","containerName":null,"kind":13},{"line":1310,"name":"@names","kind":13,"containerName":null},{"name":"@avalues","kind":13,"containerName":null,"line":1311},{"line":1316,"kind":12,"range":{"start":{"line":1316,"character":0},"end":{"line":1348,"character":9999}},"children":[{"definition":"my","containerName":"_parse_rate_parametes","localvar":"my","kind":13,"name":"$self","line":1317},{"definition":"my","name":"%rate_parameters","containerName":"_parse_rate_parametes","localvar":"my","kind":13,"line":1318},{"line":1319,"kind":13,"containerName":"_parse_rate_parametes","name":"$self"},{"containerName":"_parse_rate_parametes","kind":12,"name":"_readline","line":1319},{"containerName":"_parse_rate_parametes","kind":13,"name":"$rate_parameters","line":1322},{"name":"$rate_parameters","containerName":"_parse_rate_parametes","kind":13,"line":1325},{"line":1328,"name":"$rate_parameters","kind":13,"containerName":"_parse_rate_parametes"},{"line":1329,"containerName":"_parse_rate_parametes","kind":13,"name":"$self"},{"kind":12,"containerName":"_parse_rate_parametes","name":"_readline","line":1329},{"line":1333,"name":"$self","containerName":"_parse_rate_parametes","kind":13},{"name":"_pushback","containerName":"_parse_rate_parametes","kind":12,"line":1333},{"kind":13,"containerName":"_parse_rate_parametes","name":"$rate_parameters","line":1338},{"name":"$rate_parameters","kind":13,"containerName":"_parse_rate_parametes","line":1341},{"kind":13,"containerName":"_parse_rate_parametes","name":"$rate_parameters","line":1342},{"definition":"my","name":"$p","localvar":"my","containerName":"_parse_rate_parametes","kind":13,"line":1344},{"line":1346,"kind":13,"containerName":"_parse_rate_parametes","name":"$rate_parameters"},{"kind":13,"containerName":"_parse_rate_parametes","name":"$p","line":1346}],"containerName":"main::","name":"_parse_rate_parametes","definition":"sub"},{"signature":{"documentation":" RST parsing","parameters":[{"label":"$self"}],"label":"_parse_rst($self)"},"kind":12,"range":{"start":{"character":0,"line":1353},"end":{"character":9999,"line":1523}},"line":1353,"detail":"($self)","definition":"sub","name":"_parse_rst","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"_parse_rst","name":"$self","line":1354,"definition":"my"},{"line":1355,"kind":13,"containerName":"_parse_rst","name":"$self"},{"line":1355,"name":"$self","containerName":"_parse_rst","kind":13},{"name":"$self","containerName":"_parse_rst","kind":13,"line":1355},{"definition":"my","localvar":"my","kind":13,"containerName":"_parse_rst","name":"$rstfile","line":1357},{"kind":12,"containerName":"_parse_rst","name":"catfile","line":1357},{"kind":13,"containerName":"_parse_rst","name":"$self","line":1357},{"name":"$RSTFILENAME","containerName":"_parse_rst","kind":13,"line":1357},{"line":1358,"kind":13,"containerName":"_parse_rst","name":"$rstfile"},{"line":1358,"name":"$rstfile","containerName":"_parse_rst","kind":13},{"definition":"my","localvar":"my","kind":13,"containerName":"_parse_rst","name":"$rstio","line":1359},{"line":1359,"kind":12,"containerName":"_parse_rst","name":"new"},{"line":1359,"kind":13,"containerName":"_parse_rst","name":"$rstfile"},{"definition":"my","line":1364,"kind":13,"localvar":"my","containerName":"_parse_rst","name":"@firstseq"},{"line":1364,"containerName":"_parse_rst","kind":13,"name":"@seqs"},{"line":1364,"name":"@trees","kind":13,"containerName":"_parse_rst"},{"name":"@per_site_prob","kind":13,"containerName":"_parse_rst","line":1364},{"line":1365,"name":"$count","kind":13,"localvar":"my","containerName":"_parse_rst","definition":"my"},{"containerName":"_parse_rst","kind":13,"name":"$rstio","line":1366},{"line":1366,"kind":12,"containerName":"_parse_rst","name":"_readline"},{"line":1369,"kind":13,"containerName":"_parse_rst","name":"$rstio"},{"line":1369,"name":"_readline","containerName":"_parse_rst","kind":12},{"definition":"my","localvar":"my","kind":13,"containerName":"_parse_rst","name":"$tree","line":1371},{"line":1371,"containerName":"_parse_rst","kind":12,"name":"new"},{"line":1372,"name":"$rstio","kind":13,"containerName":"_parse_rst"},{"line":1372,"containerName":"_parse_rst","kind":12,"name":"_fh"},{"name":"next_tree","kind":12,"containerName":"_parse_rst","line":1373},{"definition":"my","line":1375,"name":"$n","kind":13,"localvar":"my","containerName":"_parse_rst"},{"kind":13,"containerName":"_parse_rst","name":"$tree","line":1375},{"name":"get_nodes","containerName":"_parse_rst","kind":12,"line":1375},{"line":1376,"localvar":"my","kind":13,"containerName":"_parse_rst","name":"$id","definition":"my"},{"containerName":"_parse_rst","kind":13,"name":"$n","line":1376},{"name":"id","containerName":"_parse_rst","kind":12,"line":1376},{"line":1377,"name":"$id","containerName":"_parse_rst","kind":13},{"name":"$id","kind":13,"containerName":"_parse_rst","line":1377},{"name":"$n","containerName":"_parse_rst","kind":13,"line":1378},{"line":1378,"name":"id","kind":12,"containerName":"_parse_rst"},{"name":"$id","kind":13,"containerName":"_parse_rst","line":1378},{"line":1379,"name":"$blen","kind":13,"localvar":"my","containerName":"_parse_rst","definition":"my"},{"kind":13,"containerName":"_parse_rst","name":"$n","line":1379},{"line":1379,"name":"branch_length","kind":12,"containerName":"_parse_rst"},{"name":"$blen","kind":13,"containerName":"_parse_rst","line":1380},{"kind":13,"containerName":"_parse_rst","name":"$blen","line":1380},{"name":"$n","containerName":"_parse_rst","kind":13,"line":1381},{"line":1381,"name":"branch_length","containerName":"_parse_rst","kind":12},{"name":"$blen","kind":13,"containerName":"_parse_rst","line":1381},{"containerName":"_parse_rst","kind":13,"name":"@trees","line":1384},{"line":1384,"name":"$tree","containerName":"_parse_rst","kind":13},{"name":"$self","containerName":"_parse_rst","kind":13,"line":1389},{"line":1390,"name":"$rstio","containerName":"_parse_rst","kind":13},{"line":1390,"kind":12,"containerName":"_parse_rst","name":"_readline"},{"line":1393,"name":"$sitenum","localvar":"my","kind":13,"containerName":"_parse_rst","definition":"my"},{"kind":13,"containerName":"_parse_rst","name":"$freq","line":1393},{"name":"$extant","kind":13,"containerName":"_parse_rst","line":1393},{"name":"$ancestral","containerName":"_parse_rst","kind":13,"line":1393},{"line":1394,"containerName":"_parse_rst","localvar":"my","kind":13,"name":"@anc_site","definition":"my"},{"name":"@extant_site","containerName":"_parse_rst","kind":13,"line":1394},{"line":1395,"name":"@extant_site","containerName":"_parse_rst","kind":13},{"line":1396,"kind":13,"containerName":"_parse_rst","name":"$extant"},{"name":"@extant_site","kind":13,"containerName":"_parse_rst","line":1397},{"line":1399,"name":"$ancestral","containerName":"_parse_rst","kind":13},{"line":1403,"name":"@anc_site","kind":13,"containerName":"_parse_rst"},{"line":1410,"containerName":"_parse_rst","kind":13,"name":"$self"},{"name":"$sitenum","kind":13,"containerName":"_parse_rst","line":1410},{"line":1410,"name":"@extant_site","containerName":"_parse_rst","kind":13},{"line":1411,"name":"@anc_site","kind":13,"containerName":"_parse_rst"},{"definition":"my","line":1418,"name":"@branches","kind":13,"localvar":"my","containerName":"_parse_rst"},{"line":1418,"kind":13,"containerName":"_parse_rst","name":"@branch2node"},{"line":1418,"kind":13,"containerName":"_parse_rst","name":"$branch"},{"containerName":"_parse_rst","kind":13,"name":"$node","line":1418},{"definition":"my","kind":13,"localvar":"my","containerName":"_parse_rst","name":"$tree","line":1419},{"line":1419,"name":"$trees","kind":13,"containerName":"_parse_rst"},{"line":1420,"kind":13,"containerName":"_parse_rst","name":"$tree"},{"name":"$self","containerName":"_parse_rst","kind":13,"line":1421},{"line":1421,"name":"warn","kind":12,"containerName":"_parse_rst"},{"definition":"my","localvar":"my","kind":13,"containerName":"_parse_rst","name":"@nodes","line":1424},{"name":"$a","kind":13,"containerName":"_parse_rst","line":1425},{"line":1425,"name":"$b","containerName":"_parse_rst","kind":13},{"name":"id","kind":12,"containerName":"_parse_rst","line":1426},{"line":1426,"containerName":"_parse_rst","kind":13,"name":"$tree"},{"line":1426,"name":"get_nodes","kind":12,"containerName":"_parse_rst"},{"line":1427,"name":"@nodes","containerName":"_parse_rst","kind":13},{"name":"$rstio","kind":13,"containerName":"_parse_rst","line":1428},{"line":1428,"kind":12,"containerName":"_parse_rst","name":"_readline"},{"line":1431,"name":"$rstio","kind":13,"containerName":"_parse_rst"},{"line":1431,"kind":12,"containerName":"_parse_rst","name":"_pushback"},{"line":1434,"name":"$left","containerName":"_parse_rst","localvar":"my","kind":13,"definition":"my"},{"containerName":"_parse_rst","kind":13,"name":"$right","line":1434},{"line":1435,"name":"$branch","containerName":"_parse_rst","kind":13},{"name":"$left","containerName":"_parse_rst","kind":13,"line":1435},{"line":1435,"containerName":"_parse_rst","kind":13,"name":"$right"},{"line":1436,"kind":13,"containerName":"_parse_rst","name":"$node"},{"line":1436,"containerName":"_parse_rst","kind":13,"name":"$nodes"},{"name":"$right","kind":13,"containerName":"_parse_rst","line":1436},{"line":1437,"name":"$node","kind":13,"containerName":"_parse_rst"},{"line":1438,"kind":13,"containerName":"_parse_rst","name":"$self"},{"line":1438,"kind":12,"containerName":"_parse_rst","name":"warn"},{"name":"$node","kind":13,"containerName":"_parse_rst","line":1442},{"kind":12,"containerName":"_parse_rst","name":"add_tag_value","line":1442},{"kind":13,"containerName":"_parse_rst","name":"$node","line":1443},{"name":"add_tag_value","kind":12,"containerName":"_parse_rst","line":1443},{"line":1445,"name":"$branch2node","containerName":"_parse_rst","kind":13},{"name":"$branch","containerName":"_parse_rst","kind":13,"line":1445},{"kind":13,"containerName":"_parse_rst","name":"$right","line":1445},{"definition":"my","line":1447,"localvar":"my","containerName":"_parse_rst","kind":13,"name":"$site"},{"line":1447,"containerName":"_parse_rst","kind":13,"name":"$anc"},{"containerName":"_parse_rst","kind":13,"name":"$aprob","line":1447},{"line":1447,"kind":13,"containerName":"_parse_rst","name":"$derived"},{"line":1447,"name":"$dprob","kind":13,"containerName":"_parse_rst"},{"line":1448,"containerName":"_parse_rst","kind":13,"name":"$node"},{"line":1449,"name":"$self","kind":13,"containerName":"_parse_rst"},{"line":1449,"name":"warn","kind":12,"containerName":"_parse_rst"},{"definition":"my","localvar":"my","containerName":"_parse_rst","kind":13,"name":"%c","line":1452},{"name":"$site","kind":13,"containerName":"_parse_rst","line":1452},{"name":"$anc","containerName":"_parse_rst","kind":13,"line":1453},{"line":1454,"name":"$aprob","containerName":"_parse_rst","kind":13},{"line":1455,"kind":13,"containerName":"_parse_rst","name":"$derived"},{"line":1457,"kind":13,"containerName":"_parse_rst","name":"$c"},{"line":1457,"name":"$dprob","containerName":"_parse_rst","kind":13},{"line":1457,"name":"$dprob","kind":13,"containerName":"_parse_rst"},{"line":1458,"name":"$node","containerName":"_parse_rst","kind":13},{"name":"add_tag_value","kind":12,"containerName":"_parse_rst","line":1458},{"line":1458,"name":"%c","containerName":"_parse_rst","kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":"_parse_rst","name":"$line","line":1463},{"name":"$rstio","kind":13,"containerName":"_parse_rst","line":1463},{"line":1463,"name":"_readline","kind":12,"containerName":"_parse_rst"},{"kind":13,"containerName":"_parse_rst","name":"$line","line":1464},{"containerName":"_parse_rst","kind":13,"name":"$line","line":1464},{"definition":"my","line":1465,"kind":13,"localvar":"my","containerName":"_parse_rst","name":"@overall_site"},{"line":1465,"kind":13,"containerName":"_parse_rst","name":"$line"},{"line":1468,"name":"$line","kind":13,"containerName":"_parse_rst"},{"line":1468,"containerName":"_parse_rst","kind":13,"name":"$rstio"},{"line":1468,"kind":12,"containerName":"_parse_rst","name":"_readline"},{"line":1470,"kind":13,"containerName":"_parse_rst","name":"$line"},{"line":1470,"name":"$line","containerName":"_parse_rst","kind":13},{"line":1471,"localvar":"my","kind":13,"containerName":"_parse_rst","name":"@overall_seq","definition":"my"},{"line":1471,"name":"$line","kind":13,"containerName":"_parse_rst"},{"containerName":"_parse_rst","kind":13,"name":"@overall_seq","line":1472},{"kind":13,"containerName":"_parse_rst","name":"@overall_site","line":1472},{"name":"@overall_seq","containerName":"_parse_rst","kind":13,"line":1473},{"line":1473,"kind":13,"containerName":"_parse_rst","name":"@seqs"},{"name":"$self","kind":13,"containerName":"_parse_rst","line":1474},{"line":1474,"name":"warn","kind":12,"containerName":"_parse_rst"},{"kind":13,"containerName":"_parse_rst","name":"$self","line":1475},{"line":1475,"containerName":"_parse_rst","kind":12,"name":"warn"},{"kind":13,"containerName":"_parse_rst","name":"@seqs","line":1477},{"name":"description","containerName":"_parse_rst","kind":12,"line":1478},{"containerName":"_parse_rst","kind":13,"name":"@overall_site","line":1479},{"name":"@overall_seq","containerName":"_parse_rst","kind":13,"line":1480},{"name":"$seqcount","containerName":"_parse_rst","localvar":"my","kind":13,"line":1483,"definition":"my"},{"containerName":"_parse_rst","kind":13,"name":"$rstio","line":1484},{"kind":12,"containerName":"_parse_rst","name":"_readline","line":1484},{"kind":13,"containerName":"_parse_rst","name":"$seqcount","line":1487},{"line":1487,"name":"$seqcount","kind":13,"containerName":"_parse_rst"},{"kind":13,"containerName":"_parse_rst","name":"@seqs","line":1487},{"line":1490,"kind":13,"containerName":"_parse_rst","name":"$seqcount"},{"definition":"my","kind":13,"localvar":"my","containerName":"_parse_rst","name":"$name","line":1495},{"line":1495,"kind":13,"containerName":"_parse_rst","name":"$num"},{"containerName":"_parse_rst","kind":13,"name":"$seqstr","line":1495},{"containerName":"_parse_rst","kind":13,"name":"$name","line":1496},{"line":1496,"kind":13,"containerName":"_parse_rst","name":"$num"},{"containerName":"_parse_rst","kind":13,"name":"$seqstr","line":1497},{"line":1498,"name":"@firstseq","containerName":"_parse_rst","kind":13},{"line":1499,"name":"@firstseq","containerName":"_parse_rst","kind":13},{"line":1499,"name":"$seqstr","containerName":"_parse_rst","kind":13},{"line":1500,"kind":13,"containerName":"_parse_rst","name":"@seqs"},{"line":1500,"name":"new","containerName":"_parse_rst","kind":12},{"name":"$name","kind":13,"containerName":"_parse_rst","line":1500},{"line":1501,"name":"$seqstr","kind":13,"containerName":"_parse_rst"},{"definition":"my","line":1503,"localvar":"my","containerName":"_parse_rst","kind":13,"name":"$i"},{"line":1504,"localvar":"my","kind":13,"containerName":"_parse_rst","name":"$v","definition":"my"},{"name":"$v","containerName":"_parse_rst","kind":13,"line":1505},{"line":1505,"name":"$seqstr","kind":13,"containerName":"_parse_rst"},{"kind":13,"containerName":"_parse_rst","name":"$i","line":1505},{"name":"$i","containerName":"_parse_rst","kind":13,"line":1505},{"line":1507,"kind":13,"containerName":"_parse_rst","name":"$seqstr"},{"line":1507,"name":"$v","containerName":"_parse_rst","kind":13},{"line":1507,"kind":13,"containerName":"_parse_rst","name":"$firstseq"},{"line":1507,"containerName":"_parse_rst","kind":13,"name":"$v"},{"line":1508,"name":"$i","kind":13,"containerName":"_parse_rst"},{"line":1508,"name":"$v","kind":13,"containerName":"_parse_rst"},{"kind":13,"containerName":"_parse_rst","name":"$self","line":1510},{"line":1510,"kind":12,"containerName":"_parse_rst","name":"debug"},{"name":"@seqs","kind":13,"containerName":"_parse_rst","line":1511},{"line":1512,"name":"new","kind":12,"containerName":"_parse_rst"},{"name":"$name","kind":13,"containerName":"_parse_rst","line":1512},{"kind":13,"containerName":"_parse_rst","name":"$seqstr","line":1513},{"line":1517,"name":"$self","kind":13,"containerName":"_parse_rst"},{"name":"@seqs","containerName":"_parse_rst","kind":13,"line":1517},{"line":1521,"kind":13,"containerName":"_parse_rst","name":"$self"},{"kind":13,"containerName":"_parse_rst","name":"@trees","line":1521}]},{"containerName":"Spec","kind":12,"name":"File","line":1357},{"name":"Bio","kind":12,"containerName":"Root::IO","line":1359},{"line":1371,"kind":12,"containerName":"TreeIO","name":"Bio"},{"line":1500,"name":"Bio","kind":12,"containerName":"LocatableSeq"},{"line":1511,"name":"Bio","containerName":"LocatableSeq","kind":12}],"version":5}