{"vars":[{"line":148,"name":"vars","containerName":"","kind":2},{"containerName":null,"kind":13,"name":"%IUB","line":151},{"line":169,"name":"%REV_IUB","containerName":null,"kind":13},{"line":173,"name":"AC","kind":12},{"kind":12,"name":"AG","line":174},{"line":175,"name":"AT","kind":12},{"line":176,"kind":12,"name":"CG"},{"name":"CT","kind":12,"line":177},{"line":179,"kind":12,"name":"ACG"},{"line":180,"kind":12,"name":"ACT"},{"name":"AGT","kind":12,"line":181},{"line":182,"name":"CGT","kind":12},{"kind":12,"name":"ACGT","line":183},{"name":"%IUP","containerName":null,"kind":13,"line":188},{"line":218,"name":"base","containerName":"","kind":2},{"line":233,"range":{"start":{"line":233,"character":0},"end":{"line":257,"character":9999}},"kind":12,"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: IUPAC.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for IUPAC\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey <amackey@virginia.edu>\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::IUPAC - Generates unique Seq objects from an ambiguous Seq object\n\n=head1 SYNOPSIS\n\n use Bio::Seq;\n use Bio::Tools::IUPAC;\n\n my $ambiseq = Bio::Seq->new(-seq => 'ARTCGUTGR', -alphabet => 'dna');\n my $stream  = Bio::Tools::IUPAC->new(-seq => $ambiseq);\n\n while ($uniqueseq = $stream->next_seq()) {\n     # process the unique Seq object.\n }\n\n=head1 DESCRIPTION\n\nIUPAC is a tool that produces a stream of unique, \"strict\"-satisfying Seq\nobjects from an ambiquous Seq object (containing non-standard characters given\nthe meaning shown below)\n\n        Extended DNA / RNA alphabet :\n        (includes symbols for nucleotide ambiguity)\n        ------------------------------------------\n        Symbol       Meaning      Nucleic Acid\n        ------------------------------------------\n         A            A           Adenine\n         C            C           Cytosine\n         G            G           Guanine\n         T            T           Thymine\n         U            U           Uracil\n         M          A or C\n         R          A or G\n         W          A or T\n         S          C or G\n         Y          C or T\n         K          G or T\n         V        A or C or G\n         H        A or C or T\n         D        A or G or T\n         B        C or G or T\n         X      G or A or T or C\n         N      G or A or T or C\n\n        IUPAC-IUB SYMBOLS FOR NUCLEOTIDE NOMENCLATURE:\n          Cornish-Bowden (1985) Nucl. Acids Res. 13: 3021-3030.\n\n-----------------------------------\n\n       Amino Acid alphabet:\n        ------------------------------------------\n        Symbol           Meaning\n        ------------------------------------------\n        A        Alanine\n        B        Aspartic Acid, Asparagine\n        C        Cystine\n        D        Aspartic Acid\n        E        Glutamic Acid\n        F        Phenylalanine\n        G        Glycine\n        H        Histidine\n        I        Isoleucine\n        J        Isoleucine/Leucine\n        K        Lysine\n        L        Leucine\n        M        Methionine\n        N        Asparagine\n        O        Pyrrolysine\n        P        Proline\n        Q        Glutamine\n        R        Arginine\n        S        Serine\n        T        Threonine\n        U        Selenocysteine\n        V        Valine\n        W        Tryptophan\n        X        Unknown\n        Y        Tyrosine\n        Z        Glutamic Acid, Glutamine\n        *        Terminator\n\n\n        IUPAC-IUP AMINO ACID SYMBOLS:\n          Biochem J. 1984 Apr 15; 219(2): 345-373\n          Eur J Biochem. 1993 Apr 1; 213(1): 2\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey\n\nEmail amackey-at-virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tools::IUPAC;\n\nuse strict;\nuse vars qw(%IUP %IUB %REV_IUB $AUTOLOAD);\n\nBEGIN {\n    %IUB = ( A => [qw(A)],\n\t     C => [qw(C)],\n\t     G => [qw(G)],\n\t     T => [qw(T)],\n\t     U => [qw(U)],\n\t     M => [qw(A C)],\n\t     R => [qw(A G)],\n\t     W => [qw(A T)],\n\t     S => [qw(C G)],\n\t     Y => [qw(C T)],\n\t     K => [qw(G T)],\n\t     V => [qw(A C G)],\n\t     H => [qw(A C T)],\n\t     D => [qw(A G T)],\n\t     B => [qw(C G T)],\n\t     X => [qw(G A T C)],\n\t     N => [qw(G A T C)]\n\t     );\n\t%REV_IUB = (A\t=> 'A',\n\t\t\t\tT\t=> 'T',\n\t\t\t\tC\t=> 'C',\n\t\t\t\tG \t=> 'G',\n\t\t\t\tAC\t=> 'M',\n\t\t\t\tAG\t=> 'R',\n\t\t\t\tAT\t=> 'W',\n\t\t\t\tCG\t=> 'S',\n\t\t\t\tCT\t=> 'Y',\n\t\t\t\t'GT'\t=> 'K',\n\t\t\t\tACG\t=> 'V',\n\t\t\t\tACT\t=> 'H',\n\t\t\t\tAGT\t=> 'D',\n\t\t\t\tCGT\t=> 'B',\n\t\t\t\tACGT=> 'N',\n\t\t\t\tN\t=> 'N'\n\t\t\t\t);\n\n\n    %IUP = (A => [qw(A)],\n\t    B => [qw(D N)],\n\t    C => [qw(C)],\n\t    D => [qw(D)],\n\t    E => [qw(E)],\n\t    F => [qw(F)],\n\t    G => [qw(G)],\n\t    H => [qw(H)],\n\t    I => [qw(I)],\n        J => [qw(I L)],\n\t    K => [qw(K)],\n\t    L => [qw(L)],\n\t    M => [qw(M)],\n\t    N => [qw(N)],\n        O => [qw(O)],\n\t    P => [qw(P)],\n\t    Q => [qw(Q)],\n\t    R => [qw(R)],\n\t    S => [qw(S)],\n\t    T => [qw(T)],\n\t    U => [qw(U)],\n\t    V => [qw(V)],\n\t    W => [qw(W)],\n\t    X => [qw(X)],\n\t    Y => [qw(Y)],\n\t    Z => [qw(E Q)],\n\t    '*' => ['*']\n\t    );\n\n}\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : Bio::Tools::IUPAC->new( $seq)\n Function: returns a new seq stream (akin to SeqIO)\n Returns : a Bio::Tools::IUPAC stream object that will produce unique\n           Seq objects on demand.\n Args    : an ambiguously coded Seq.pm object that has a specified 'alphabet'"},"children":[{"line":234,"name":"$class","containerName":"new","localvar":"my","kind":13,"definition":"my"},{"line":234,"containerName":"new","kind":13,"name":"@args"},{"localvar":"my","kind":13,"containerName":"new","name":"$self","line":235,"definition":"my"},{"containerName":"new","kind":13,"name":"$class","line":235},{"line":235,"name":"@args","containerName":"new","kind":13},{"line":237,"name":"$seq","kind":13,"localvar":"my","containerName":"new","definition":"my"},{"containerName":"new","kind":13,"name":"$self","line":237},{"name":"_rearrange","containerName":"new","kind":12,"line":237},{"line":237,"name":"@args","kind":13,"containerName":"new"},{"line":238,"kind":13,"containerName":"new","name":"$seq"},{"containerName":"new","kind":13,"name":"@args","line":238},{"line":238,"name":"$args","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$seq","line":240},{"containerName":"new","kind":13,"name":"$args","line":240},{"line":242,"containerName":"new","kind":13,"name":"$seq"},{"kind":12,"containerName":"new","name":"isa","line":242},{"line":243,"name":"$self","kind":13,"containerName":"new"},{"line":243,"name":"throw","containerName":"new","kind":12},{"line":244,"kind":13,"containerName":"new","name":"$self"},{"line":244,"name":"$seq","containerName":"new","kind":13},{"line":245,"name":"$self","kind":13,"containerName":"new"},{"line":245,"kind":12,"containerName":"new","name":"alphabet"},{"line":247,"name":"$self","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$IUB","line":247},{"line":248,"name":"$self","containerName":"new","kind":13},{"name":"seq","containerName":"new","kind":12,"line":248},{"kind":13,"containerName":"new","name":"$self","line":249},{"line":249,"containerName":"new","kind":12,"name":"alphabet"},{"line":251,"name":"$self","containerName":"new","kind":13},{"line":251,"name":"$IUP","kind":13,"containerName":"new"},{"line":252,"name":"$self","kind":13,"containerName":"new"},{"line":252,"kind":12,"containerName":"new","name":"seq"},{"line":254,"kind":13,"containerName":"new","name":"$self"},{"line":254,"name":"throw","kind":12,"containerName":"new"},{"line":256,"containerName":"new","kind":13,"name":"$self"},{"line":256,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"containerName":"new","name":"seq","line":256},{"kind":13,"containerName":"new","name":"$self","line":257}],"containerName":"main::","name":"new","definition":"sub","detail":"($class,@args)"},{"containerName":"new","kind":12,"name":"SUPER","line":235},{"line":257,"name":"$self","kind":13,"containerName":null},{"name":"throw","kind":12,"containerName":"main::","line":257},{"name":"%self","kind":13,"containerName":null,"line":258},{"line":259,"name":"$self","containerName":null,"kind":13},{"detail":"($self)","definition":"sub","containerName":"main::","name":"next_seq","children":[{"line":274,"kind":13,"localvar":"my","containerName":"next_seq","name":"$self","definition":"my"},{"line":276,"name":"$i","localvar":"my","kind":13,"containerName":"next_seq","definition":"my"},{"line":276,"containerName":"next_seq","kind":13,"name":"$self"}],"signature":{"label":"next_seq($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: IUPAC.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for IUPAC\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey <amackey@virginia.edu>\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::IUPAC - Generates unique Seq objects from an ambiguous Seq object\n\n=head1 SYNOPSIS\n\n use Bio::Seq;\n use Bio::Tools::IUPAC;\n\n my $ambiseq = Bio::Seq->new(-seq => 'ARTCGUTGR', -alphabet => 'dna');\n my $stream  = Bio::Tools::IUPAC->new(-seq => $ambiseq);\n\n while ($uniqueseq = $stream->next_seq()) {\n     # process the unique Seq object.\n }\n\n=head1 DESCRIPTION\n\nIUPAC is a tool that produces a stream of unique, \"strict\"-satisfying Seq\nobjects from an ambiquous Seq object (containing non-standard characters given\nthe meaning shown below)\n\n        Extended DNA / RNA alphabet :\n        (includes symbols for nucleotide ambiguity)\n        ------------------------------------------\n        Symbol       Meaning      Nucleic Acid\n        ------------------------------------------\n         A            A           Adenine\n         C            C           Cytosine\n         G            G           Guanine\n         T            T           Thymine\n         U            U           Uracil\n         M          A or C\n         R          A or G\n         W          A or T\n         S          C or G\n         Y          C or T\n         K          G or T\n         V        A or C or G\n         H        A or C or T\n         D        A or G or T\n         B        C or G or T\n         X      G or A or T or C\n         N      G or A or T or C\n\n        IUPAC-IUB SYMBOLS FOR NUCLEOTIDE NOMENCLATURE:\n          Cornish-Bowden (1985) Nucl. Acids Res. 13: 3021-3030.\n\n-----------------------------------\n\n       Amino Acid alphabet:\n        ------------------------------------------\n        Symbol           Meaning\n        ------------------------------------------\n        A        Alanine\n        B        Aspartic Acid, Asparagine\n        C        Cystine\n        D        Aspartic Acid\n        E        Glutamic Acid\n        F        Phenylalanine\n        G        Glycine\n        H        Histidine\n        I        Isoleucine\n        J        Isoleucine/Leucine\n        K        Lysine\n        L        Leucine\n        M        Methionine\n        N        Asparagine\n        O        Pyrrolysine\n        P        Proline\n        Q        Glutamine\n        R        Arginine\n        S        Serine\n        T        Threonine\n        U        Selenocysteine\n        V        Valine\n        W        Tryptophan\n        X        Unknown\n        Y        Tyrosine\n        Z        Glutamic Acid, Glutamine\n        *        Terminator\n\n\n        IUPAC-IUP AMINO ACID SYMBOLS:\n          Biochem J. 1984 Apr 15; 219(2): 345-373\n          Eur J Biochem. 1993 Apr 1; 213(1): 2\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey\n\nEmail amackey-at-virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tools::IUPAC;\n\nuse strict;\nuse vars qw(%IUP %IUB %REV_IUB $AUTOLOAD);\n\nBEGIN {\n    %IUB = ( A => [qw(A)],\n\t     C => [qw(C)],\n\t     G => [qw(G)],\n\t     T => [qw(T)],\n\t     U => [qw(U)],\n\t     M => [qw(A C)],\n\t     R => [qw(A G)],\n\t     W => [qw(A T)],\n\t     S => [qw(C G)],\n\t     Y => [qw(C T)],\n\t     K => [qw(G T)],\n\t     V => [qw(A C G)],\n\t     H => [qw(A C T)],\n\t     D => [qw(A G T)],\n\t     B => [qw(C G T)],\n\t     X => [qw(G A T C)],\n\t     N => [qw(G A T C)]\n\t     );\n\t%REV_IUB = (A\t=> 'A',\n\t\t\t\tT\t=> 'T',\n\t\t\t\tC\t=> 'C',\n\t\t\t\tG \t=> 'G',\n\t\t\t\tAC\t=> 'M',\n\t\t\t\tAG\t=> 'R',\n\t\t\t\tAT\t=> 'W',\n\t\t\t\tCG\t=> 'S',\n\t\t\t\tCT\t=> 'Y',\n\t\t\t\t'GT'\t=> 'K',\n\t\t\t\tACG\t=> 'V',\n\t\t\t\tACT\t=> 'H',\n\t\t\t\tAGT\t=> 'D',\n\t\t\t\tCGT\t=> 'B',\n\t\t\t\tACGT=> 'N',\n\t\t\t\tN\t=> 'N'\n\t\t\t\t);\n\n\n    %IUP = (A => [qw(A)],\n\t    B => [qw(D N)],\n\t    C => [qw(C)],\n\t    D => [qw(D)],\n\t    E => [qw(E)],\n\t    F => [qw(F)],\n\t    G => [qw(G)],\n\t    H => [qw(H)],\n\t    I => [qw(I)],\n        J => [qw(I L)],\n\t    K => [qw(K)],\n\t    L => [qw(L)],\n\t    M => [qw(M)],\n\t    N => [qw(N)],\n        O => [qw(O)],\n\t    P => [qw(P)],\n\t    Q => [qw(Q)],\n\t    R => [qw(R)],\n\t    S => [qw(S)],\n\t    T => [qw(T)],\n\t    U => [qw(U)],\n\t    V => [qw(V)],\n\t    W => [qw(W)],\n\t    X => [qw(X)],\n\t    Y => [qw(Y)],\n\t    Z => [qw(E Q)],\n\t    '*' => ['*']\n\t    );\n\n}\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : Bio::Tools::IUPAC->new( $seq)\n Function: returns a new seq stream (akin to SeqIO)\n Returns : a Bio::Tools::IUPAC stream object that will produce unique\n           Seq objects on demand.\n Args    : an ambiguously coded Seq.pm object that has a specified 'alphabet'\n\n\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my ($seq) = $self->_rearrange([qw(SEQ)],@args);\n    if((! defined($seq)) && @args && ref($args[0])) {\n\t# parameter not passed as named parameter?\n\t$seq = $args[0];\n    }\n    $seq->isa('Bio::Seq') or\n\t$self->throw(\"Must supply a Seq.pm object to IUPAC!\");\n    $self->{'_SeqObj'} = $seq;\n    if ($self->{'_SeqObj'}->alphabet() =~ m/^[dr]na$/i ) {\n        # nucleotide seq object\n\t$self->{'_alpha'} = [ map { $IUB{uc($_)} }\n\t\t\t      split('', $self->{'_SeqObj'}->seq()) ];\n    } elsif ($self->{'_SeqObj'}->alphabet() =~ m/^protein$/i ) {\n        # amino acid seq object\n\t$self->{'_alpha'} = [ map { $IUP{uc($_)} }\n\t\t\t       split('', $self->{'_SeqObj'}->seq()) ];\n    } else { # unknown type: we could make a guess, but let's not.\n\t$self->throw(\"You must specify the 'type' of sequence provided to IUPAC\");\n    }\n    $self->{'_string'} = [(0) x length($self->{'_SeqObj'}->seq())];\n    scalar @{$self->{'_string'}} or $self->throw(\"Sequence has zero-length!\");\n    $self->{'_string'}->[0] = -1;\n    return $self;\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $iupac->next_seq()\n Function: returns the next unique Seq object\n Returns : a Seq.pm object\n Args    : none."},"range":{"start":{"line":273,"character":0},"end":{"character":9999,"line":276}},"kind":12,"line":273},{"containerName":null,"kind":13,"name":"%self","line":277},{"containerName":null,"kind":13,"name":"$i","line":277},{"name":"%self","kind":13,"containerName":null,"line":277},{"line":277,"name":"$i","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%self","line":278},{"line":278,"name":"$i","kind":13,"containerName":null},{"line":278,"containerName":null,"kind":13,"name":"%self"},{"kind":13,"containerName":null,"name":"%i","line":278},{"name":"$i","kind":13,"containerName":null,"line":279},{"name":"%self","containerName":null,"kind":13,"line":279},{"kind":13,"containerName":null,"name":"%self","line":282},{"line":282,"name":"%i","containerName":null,"kind":13},{"line":286,"name":"%self","containerName":null,"kind":13},{"line":286,"name":"$i","containerName":null,"kind":13},{"containerName":null,"localvar":"my","kind":13,"name":"$j","line":287,"definition":"my"},{"name":"%self","kind":13,"containerName":null,"line":288},{"name":"seq","containerName":"main::","kind":12,"line":288},{"line":288,"containerName":null,"kind":13,"name":"$j"},{"kind":13,"containerName":null,"name":"%self","line":288},{"line":288,"kind":13,"containerName":null,"name":"@j"},{"name":"%self","containerName":null,"kind":13,"line":288},{"definition":"my","line":289,"kind":13,"localvar":"my","containerName":null,"name":"$desc"},{"line":289,"name":"%self","containerName":null,"kind":13},{"name":"desc","containerName":"main::","kind":12,"line":289},{"kind":13,"containerName":null,"name":"%desc","line":290},{"line":290,"name":"$desc","kind":13,"containerName":null},{"name":"%self","kind":13,"containerName":null,"line":292},{"name":"%self","kind":13,"containerName":null,"line":293},{"kind":13,"containerName":null,"name":"$desc","line":294},{"kind":13,"containerName":null,"name":"%self","line":295},{"line":295,"name":"desc","kind":12,"containerName":"main::"},{"line":295,"name":"$desc","kind":13,"containerName":null},{"name":"%self","kind":13,"containerName":null,"line":296},{"line":297,"containerName":null,"kind":13,"name":"%self"},{"range":{"start":{"line":312,"character":0},"end":{"line":315,"character":9999}},"kind":12,"line":312,"containerName":"main::","name":"iupac_iup","children":[{"line":313,"name":"%IUP","containerName":"iupac_iup","kind":13}],"definition":"sub"},{"range":{"end":{"character":9999,"line":329},"start":{"character":0,"line":327}},"kind":12,"line":327,"containerName":"main::","name":"iupac_iub","children":[{"line":328,"name":"%IUB","kind":13,"containerName":"iupac_iub"}],"definition":"sub"},{"line":342,"range":{"end":{"line":344,"character":9999},"start":{"character":0,"line":342}},"kind":12,"children":[{"line":343,"containerName":"iupac_rev_iub","kind":13,"name":"%REV_IUB"}],"name":"iupac_rev_iub","containerName":"main::","definition":"sub"},{"kind":12,"range":{"end":{"line":361,"character":9999},"start":{"character":0,"line":357}},"line":357,"signature":{"documentation":"1;\n# $Id: IUPAC.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for IUPAC\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Aaron Mackey <amackey@virginia.edu>\n#\n# Copyright Aaron Mackey\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::IUPAC - Generates unique Seq objects from an ambiguous Seq object\n\n=head1 SYNOPSIS\n\n use Bio::Seq;\n use Bio::Tools::IUPAC;\n\n my $ambiseq = Bio::Seq->new(-seq => 'ARTCGUTGR', -alphabet => 'dna');\n my $stream  = Bio::Tools::IUPAC->new(-seq => $ambiseq);\n\n while ($uniqueseq = $stream->next_seq()) {\n     # process the unique Seq object.\n }\n\n=head1 DESCRIPTION\n\nIUPAC is a tool that produces a stream of unique, \"strict\"-satisfying Seq\nobjects from an ambiquous Seq object (containing non-standard characters given\nthe meaning shown below)\n\n        Extended DNA / RNA alphabet :\n        (includes symbols for nucleotide ambiguity)\n        ------------------------------------------\n        Symbol       Meaning      Nucleic Acid\n        ------------------------------------------\n         A            A           Adenine\n         C            C           Cytosine\n         G            G           Guanine\n         T            T           Thymine\n         U            U           Uracil\n         M          A or C\n         R          A or G\n         W          A or T\n         S          C or G\n         Y          C or T\n         K          G or T\n         V        A or C or G\n         H        A or C or T\n         D        A or G or T\n         B        C or G or T\n         X      G or A or T or C\n         N      G or A or T or C\n\n        IUPAC-IUB SYMBOLS FOR NUCLEOTIDE NOMENCLATURE:\n          Cornish-Bowden (1985) Nucl. Acids Res. 13: 3021-3030.\n\n-----------------------------------\n\n       Amino Acid alphabet:\n        ------------------------------------------\n        Symbol           Meaning\n        ------------------------------------------\n        A        Alanine\n        B        Aspartic Acid, Asparagine\n        C        Cystine\n        D        Aspartic Acid\n        E        Glutamic Acid\n        F        Phenylalanine\n        G        Glycine\n        H        Histidine\n        I        Isoleucine\n        J        Isoleucine/Leucine\n        K        Lysine\n        L        Leucine\n        M        Methionine\n        N        Asparagine\n        O        Pyrrolysine\n        P        Proline\n        Q        Glutamine\n        R        Arginine\n        S        Serine\n        T        Threonine\n        U        Selenocysteine\n        V        Valine\n        W        Tryptophan\n        X        Unknown\n        Y        Tyrosine\n        Z        Glutamic Acid, Glutamine\n        *        Terminator\n\n\n        IUPAC-IUP AMINO ACID SYMBOLS:\n          Biochem J. 1984 Apr 15; 219(2): 345-373\n          Eur J Biochem. 1993 Apr 1; 213(1): 2\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey\n\nEmail amackey-at-virginia.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tools::IUPAC;\n\nuse strict;\nuse vars qw(%IUP %IUB %REV_IUB $AUTOLOAD);\n\nBEGIN {\n    %IUB = ( A => [qw(A)],\n\t     C => [qw(C)],\n\t     G => [qw(G)],\n\t     T => [qw(T)],\n\t     U => [qw(U)],\n\t     M => [qw(A C)],\n\t     R => [qw(A G)],\n\t     W => [qw(A T)],\n\t     S => [qw(C G)],\n\t     Y => [qw(C T)],\n\t     K => [qw(G T)],\n\t     V => [qw(A C G)],\n\t     H => [qw(A C T)],\n\t     D => [qw(A G T)],\n\t     B => [qw(C G T)],\n\t     X => [qw(G A T C)],\n\t     N => [qw(G A T C)]\n\t     );\n\t%REV_IUB = (A\t=> 'A',\n\t\t\t\tT\t=> 'T',\n\t\t\t\tC\t=> 'C',\n\t\t\t\tG \t=> 'G',\n\t\t\t\tAC\t=> 'M',\n\t\t\t\tAG\t=> 'R',\n\t\t\t\tAT\t=> 'W',\n\t\t\t\tCG\t=> 'S',\n\t\t\t\tCT\t=> 'Y',\n\t\t\t\t'GT'\t=> 'K',\n\t\t\t\tACG\t=> 'V',\n\t\t\t\tACT\t=> 'H',\n\t\t\t\tAGT\t=> 'D',\n\t\t\t\tCGT\t=> 'B',\n\t\t\t\tACGT=> 'N',\n\t\t\t\tN\t=> 'N'\n\t\t\t\t);\n\n\n    %IUP = (A => [qw(A)],\n\t    B => [qw(D N)],\n\t    C => [qw(C)],\n\t    D => [qw(D)],\n\t    E => [qw(E)],\n\t    F => [qw(F)],\n\t    G => [qw(G)],\n\t    H => [qw(H)],\n\t    I => [qw(I)],\n        J => [qw(I L)],\n\t    K => [qw(K)],\n\t    L => [qw(L)],\n\t    M => [qw(M)],\n\t    N => [qw(N)],\n        O => [qw(O)],\n\t    P => [qw(P)],\n\t    Q => [qw(Q)],\n\t    R => [qw(R)],\n\t    S => [qw(S)],\n\t    T => [qw(T)],\n\t    U => [qw(U)],\n\t    V => [qw(V)],\n\t    W => [qw(W)],\n\t    X => [qw(X)],\n\t    Y => [qw(Y)],\n\t    Z => [qw(E Q)],\n\t    '*' => ['*']\n\t    );\n\n}\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : Bio::Tools::IUPAC->new( $seq)\n Function: returns a new seq stream (akin to SeqIO)\n Returns : a Bio::Tools::IUPAC stream object that will produce unique\n           Seq objects on demand.\n Args    : an ambiguously coded Seq.pm object that has a specified 'alphabet'\n\n\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my ($seq) = $self->_rearrange([qw(SEQ)],@args);\n    if((! defined($seq)) && @args && ref($args[0])) {\n\t# parameter not passed as named parameter?\n\t$seq = $args[0];\n    }\n    $seq->isa('Bio::Seq') or\n\t$self->throw(\"Must supply a Seq.pm object to IUPAC!\");\n    $self->{'_SeqObj'} = $seq;\n    if ($self->{'_SeqObj'}->alphabet() =~ m/^[dr]na$/i ) {\n        # nucleotide seq object\n\t$self->{'_alpha'} = [ map { $IUB{uc($_)} }\n\t\t\t      split('', $self->{'_SeqObj'}->seq()) ];\n    } elsif ($self->{'_SeqObj'}->alphabet() =~ m/^protein$/i ) {\n        # amino acid seq object\n\t$self->{'_alpha'} = [ map { $IUP{uc($_)} }\n\t\t\t       split('', $self->{'_SeqObj'}->seq()) ];\n    } else { # unknown type: we could make a guess, but let's not.\n\t$self->throw(\"You must specify the 'type' of sequence provided to IUPAC\");\n    }\n    $self->{'_string'} = [(0) x length($self->{'_SeqObj'}->seq())];\n    scalar @{$self->{'_string'}} or $self->throw(\"Sequence has zero-length!\");\n    $self->{'_string'}->[0] = -1;\n    return $self;\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $iupac->next_seq()\n Function: returns the next unique Seq object\n Returns : a Seq.pm object\n Args    : none.\n\n\n\nsub next_seq{\n    my ($self) = @_;\n\n    for my $i ( 0 .. $#{$self->{'_string'}} ) {\n\tnext unless $self->{'_string'}->[$i] || @{$self->{'_alpha'}->[$i]} > 1;\n\tif ( $self->{'_string'}->[$i] == $#{$self->{'_alpha'}->[$i]} ) { # rollover\n\t    if ( $i == $#{$self->{'_string'}} ) { # end of possibilities\n\t\treturn;\n\t    } else {\n\t\t$self->{'_string'}->[$i] = 0;\n\t\tnext;\n\t    }\n\t} else {\n\t    $self->{'_string'}->[$i]++;\n\t    my $j = -1;\n\t    $self->{'_SeqObj'}->seq(join('', map { $j++; $self->{'_alpha'}->[$j]->[$_]; } @{$self->{'_string'}}));\n\t    my $desc = $self->{'_SeqObj'}->desc();\n\t    if ( !defined $desc ) { $desc = \"\"; }\n\n\t    $self->{'_num'}++;\n\t    1 while $self->{'_num'} =~ s/(\\d)(\\d\\d\\d)(?!\\d)/$1,$2/;\n\t    $desc =~ s/( \\[Bio::Tools::IUPAC-generated\\sunique sequence # [^\\]]*\\])|$/ \\[Bio::Tools::IUPAC-generated unique sequence # $self->{'_num'}\\]/;\n\t    $self->{'_SeqObj'}->desc($desc);\n\t    $self->{'_num'} =~ s/,//g;\n\t    return $self->{'_SeqObj'};\n\t}\n    }\n}\n\n=head2 iupac_iup\n\n Title   : iupac_iup\n Usage   : my %aasymbols = $iupac->iupac_iup\n Function: Returns a hash of PROTEIN symbols -> symbol components\n Returns : Hash\n Args    : none\n\n\nsub iupac_iup{\n   return %IUP;\n\n}\n\n=head2 iupac_iub\n\n Title   : iupac_iub\n Usage   : my %dnasymbols = $iupac->iupac_iub\n Function: Returns a hash of DNA symbols -> symbol components\n Returns : Hash\n Args    : none\n\n\nsub iupac_iub{\n   return %IUB;\n}\n\n=head2 iupac_rev_iub\n\n Title   : iupac_rev_iub\n Usage   : my %dnasymbols = $iupac->iupac_rev_iub\n Function: Returns a hash of nucleotide combinations -> IUPAC code\n           (a reverse of the iupac_iub hash).\n Returns : Hash\n Args    : none\n\n\nsub iupac_rev_iub{\n   return %REV_IUB;\n}\n\n=head2 count\n\n Title   : count\n Usage   : my $total = $iupac->count();\n Function: Calculates the number of unique, unambiguous sequences that\n           this ambiguous sequence could generate\n Return  : int\n Args    : none","parameters":[{"label":"$self"}],"label":"count($self)"},"name":"count","containerName":"main::","children":[{"containerName":"count","localvar":"my","kind":13,"name":"$self","line":358,"definition":"my"},{"definition":"my","name":"$count","localvar":"my","containerName":"count","kind":13,"line":360},{"line":361,"name":"$count","containerName":"count","kind":13},{"line":361,"containerName":"count","kind":13,"name":"$_"},{"line":361,"name":"$self","kind":13,"containerName":"count"}],"detail":"($self)","definition":"sub"},{"kind":13,"containerName":null,"name":"$count","line":362},{"children":[{"line":368,"name":"$self","localvar":"my","kind":13,"containerName":"AUTOLOAD","definition":"my"},{"line":369,"localvar":"my","kind":13,"containerName":"AUTOLOAD","name":"$method","definition":"my"},{"line":369,"name":"$AUTOLOAD","kind":13,"containerName":"AUTOLOAD"},{"line":370,"kind":13,"containerName":"AUTOLOAD","name":"$method"},{"line":371,"kind":13,"containerName":"AUTOLOAD","name":"$self"},{"line":371,"name":"$method","kind":13,"containerName":"AUTOLOAD"},{"kind":13,"containerName":"AUTOLOAD","name":"$method","line":372}],"containerName":"main::","name":"AUTOLOAD","definition":"sub","line":366,"range":{"start":{"character":0,"line":366},"end":{"character":9999,"line":373}},"kind":12}],"version":5}