{"version":5,"vars":[{"kind":2,"containerName":"","name":"base","line":136},{"children":[{"definition":"my","name":"$self","localvar":"my","containerName":"_initialize_state","kind":13,"line":139},{"name":"@args","kind":13,"containerName":"_initialize_state","line":139},{"name":"$make","containerName":"_initialize_state","localvar":"my","kind":13,"line":142,"definition":"my"},{"line":142,"containerName":"_initialize_state","kind":13,"name":"$self"},{"name":"@args","kind":13,"containerName":"_initialize_state","line":142},{"line":144,"kind":13,"containerName":"_initialize_state","name":"$self"},{"line":146,"name":"$self","kind":13,"containerName":"_initialize_state"}],"containerName":"main::","name":"_initialize_state","definition":"sub","detail":"($self,@args)","line":138,"range":{"start":{"line":138,"character":0},"end":{"line":147,"character":9999}},"kind":12,"signature":{"label":"_initialize_state($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":""}},{"name":"SUPER","containerName":"_initialize_state","kind":12,"line":142},{"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Glimmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Glimmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Glimmer - parser for Glimmer 2.X/3.X prokaryotic and \nGlimmerM/GlimmerHMM eukaryotic gene predictions\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Glimmer;\n\n   # file\n   my $parser = Bio::Tools::Glimmer->new(-file => $file);\n   # filehandle:\n   $parser = Bio::Tools::Glimmer->new( -fh  => \\*INPUT );\n   # provide a sequence identifier (Glimmer 2.X)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -seqname => seqname);\n   # force format (override automatic detection)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -format => 'GlimmerM');\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $glimmer->next_feature() is the same\n\n   while(my $gene = $parser->next_prediction()) {\n       # For eukaryotic input (GlimmerM/GlimmerHMM), $gene will be an instance\n       # of Bio::Tools::Prediction::Gene, which inherits off\n       # Bio::SeqFeature::Gene::Transcript, and $gene->exons() will return an\n       # array of Bio::Tools::Prediction::Exon objects.\n       # For prokaryotic input (Glimmer2.X/Glimmer3.X), $gene will be an\n       # instance of Bio::SeqFeature::Generic\n\n       # all exons (eukaryotic only):\n       @exon_arr = $gene->exons();\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n   }\n\n=head1 DESCRIPTION\n\nThis is a module for parsing Glimmer, GlimmerM and GlimmerHMM predictions.  \nIt will create gene objects from the prediction report which can \nbe attached to a sequence using Bioperl objects, or output as GFF \nsuitable for loading into Bio::DB::GFF for use with Gbrowse.\n\nGlimmer is open source and available at\nL<http://www.cbcb.umd.edu/software/glimmer/>.\n\nGlimmerM is open source and available at \nL<http://www.tigr.org/software/glimmerm/>.\n\nGlimmerHMM is open source and available at\nL<http://www.cbcb.umd.edu/software/GlimmerHMM/>.\n\nNote that Glimmer 2.X will only process the first\nsequence in a fasta file, and the prediction report does not contain any\nsort of sequence identifier\n\nNote that Glimmer 3.X produces two output files.  This module only parses\nthe .predict file.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann\n\nMark Johnson\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Glimmer;\nuse strict;\n\nuse Bio::Factory::FTLocationFactory;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    $self->{'_preds_parsed'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Glimmer->new();\n Function: Builds a new Bio::Tools::Glimmer object \n Returns : an instance of Bio::Tools::Glimmer\n Args    : format ('Glimmer', 'GlimmerM', 'GlimmerHMM'), seqname","label":"new($class,@args)"},"range":{"start":{"character":0,"line":160},"end":{"character":9999,"line":189}},"kind":12,"line":160,"detail":"($class,@args)","definition":"sub","containerName":"main::","name":"new","children":[{"definition":"my","line":161,"name":"$class","localvar":"my","kind":13,"containerName":"new"},{"name":"@args","kind":13,"containerName":"new","line":161},{"line":163,"name":"$self","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"name":"$class","containerName":"new","kind":13,"line":163},{"line":163,"name":"@args","containerName":"new","kind":13},{"definition":"my","line":165,"containerName":"new","localvar":"my","kind":13,"name":"$format"},{"line":165,"name":"$seqname","containerName":"new","kind":13},{"line":165,"kind":13,"containerName":"new","name":"$seqlength"},{"name":"$detail","kind":13,"containerName":"new","line":165},{"line":166,"name":"$self","kind":13,"containerName":"new"},{"line":166,"containerName":"new","kind":12,"name":"_rearrange"},{"line":166,"containerName":"new","kind":13,"name":"@args"},{"line":169,"name":"$format","containerName":"new","kind":13},{"line":170,"name":"$format","kind":13,"containerName":"new"},{"line":171,"name":"$format","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$format","line":172},{"containerName":"new","kind":13,"name":"$self","line":174},{"line":174,"containerName":"new","kind":12,"name":"_format"},{"name":"$format","kind":13,"containerName":"new","line":174},{"name":"$detail","kind":13,"containerName":"new","line":177},{"line":178,"name":"$self","kind":13,"containerName":"new"},{"containerName":"new","kind":12,"name":"_format","line":178},{"name":"$self","kind":13,"containerName":"new","line":179},{"line":179,"name":"_detail_file","containerName":"new","kind":12},{"line":179,"name":"$detail","containerName":"new","kind":13},{"line":183,"containerName":"new","kind":13,"name":"$self"},{"line":183,"name":"_seqname","containerName":"new","kind":12},{"name":"$seqname","kind":13,"containerName":"new","line":183},{"line":183,"name":"$seqname","containerName":"new","kind":13},{"line":186,"name":"$self","containerName":"new","kind":13},{"line":186,"kind":12,"containerName":"new","name":"_seqlength"},{"containerName":"new","kind":13,"name":"$seqlength","line":186},{"line":186,"containerName":"new","kind":13,"name":"$seqlength"},{"kind":13,"containerName":"new","name":"$self","line":188}]},{"name":"SUPER","kind":12,"containerName":"new","line":163},{"detail":"($self,$method)","definition":"sub","containerName":"main::","name":"analysis_method","children":[{"line":204,"kind":13,"localvar":"my","containerName":"analysis_method","name":"$self","definition":"my"},{"line":204,"name":"$method","kind":13,"containerName":"analysis_method"},{"line":205,"name":"$method","kind":13,"containerName":"analysis_method"},{"kind":13,"containerName":"analysis_method","name":"$method","line":205},{"line":206,"containerName":"analysis_method","kind":13,"name":"$self"},{"line":206,"containerName":"analysis_method","kind":12,"name":"throw"},{"containerName":"analysis_method","kind":13,"name":"$self","line":206},{"containerName":"analysis_method","kind":13,"name":"$self","line":208},{"line":208,"name":"$method","containerName":"analysis_method","kind":13}],"signature":{"parameters":[{"label":"$self"},{"label":"$method"}],"documentation":"1;\n# $Id: Glimmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Glimmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Glimmer - parser for Glimmer 2.X/3.X prokaryotic and \nGlimmerM/GlimmerHMM eukaryotic gene predictions\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Glimmer;\n\n   # file\n   my $parser = Bio::Tools::Glimmer->new(-file => $file);\n   # filehandle:\n   $parser = Bio::Tools::Glimmer->new( -fh  => \\*INPUT );\n   # provide a sequence identifier (Glimmer 2.X)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -seqname => seqname);\n   # force format (override automatic detection)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -format => 'GlimmerM');\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $glimmer->next_feature() is the same\n\n   while(my $gene = $parser->next_prediction()) {\n       # For eukaryotic input (GlimmerM/GlimmerHMM), $gene will be an instance\n       # of Bio::Tools::Prediction::Gene, which inherits off\n       # Bio::SeqFeature::Gene::Transcript, and $gene->exons() will return an\n       # array of Bio::Tools::Prediction::Exon objects.\n       # For prokaryotic input (Glimmer2.X/Glimmer3.X), $gene will be an\n       # instance of Bio::SeqFeature::Generic\n\n       # all exons (eukaryotic only):\n       @exon_arr = $gene->exons();\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n   }\n\n=head1 DESCRIPTION\n\nThis is a module for parsing Glimmer, GlimmerM and GlimmerHMM predictions.  \nIt will create gene objects from the prediction report which can \nbe attached to a sequence using Bioperl objects, or output as GFF \nsuitable for loading into Bio::DB::GFF for use with Gbrowse.\n\nGlimmer is open source and available at\nL<http://www.cbcb.umd.edu/software/glimmer/>.\n\nGlimmerM is open source and available at \nL<http://www.tigr.org/software/glimmerm/>.\n\nGlimmerHMM is open source and available at\nL<http://www.cbcb.umd.edu/software/GlimmerHMM/>.\n\nNote that Glimmer 2.X will only process the first\nsequence in a fasta file, and the prediction report does not contain any\nsort of sequence identifier\n\nNote that Glimmer 3.X produces two output files.  This module only parses\nthe .predict file.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann\n\nMark Johnson\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Glimmer;\nuse strict;\n\nuse Bio::Factory::FTLocationFactory;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    $self->{'_preds_parsed'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Glimmer->new();\n Function: Builds a new Bio::Tools::Glimmer object \n Returns : an instance of Bio::Tools::Glimmer\n Args    : format ('Glimmer', 'GlimmerM', 'GlimmerHMM'), seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($format, $seqname, $seqlength, $detail) =\n      $self->_rearrange([qw(FORMAT SEQNAME SEQLENGTH DETAIL)], @args);\n\n  # override automagic format detection\n  if (defined($format) &&\n      (($format eq 'Glimmer')  ||\n       ($format eq 'GlimmerM') ||\n       ($format eq 'GlimmerHMM'))\n  ) {\n      $self->_format($format);\n  }\n  \n  if (defined($detail)) {\n      $self->_format('Glimmer');\n      $self->_detail_file($detail);\n  }\n  \n  # hardwire seq_id when creating gene and exon objects (Glimmer 2.X)\n  $self->_seqname($seqname) if defined($seqname);\n  \n  # store the length of the input sequence (Glimmer 2.X)\n  $self->_seqlength($seqlength) if defined($seqlength);\n  \n  return $self;\n}\n\n=head2 analysis_method\n\n Usage     : $glimmer->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /glimmer/i.\n Returns   : String\n Argument  : n/a","label":"analysis_method($self,$method)"},"kind":12,"range":{"start":{"character":0,"line":202},"end":{"line":209,"character":9999}},"line":202},{"name":"SUPER","kind":12,"containerName":"analysis_method","line":208},{"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","line":232,"name":"$self","localvar":"my","containerName":"next_feature","kind":13},{"line":232,"name":"@args","kind":13,"containerName":"next_feature"},{"name":"$self","kind":13,"containerName":"next_feature","line":236},{"kind":12,"containerName":"next_feature","name":"next_prediction","line":236},{"line":236,"name":"@args","containerName":"next_feature","kind":13}],"name":"next_feature","containerName":"main::","signature":{"label":"next_feature($self,@args)","documentation":"1;\n# $Id: Glimmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Glimmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Glimmer - parser for Glimmer 2.X/3.X prokaryotic and \nGlimmerM/GlimmerHMM eukaryotic gene predictions\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Glimmer;\n\n   # file\n   my $parser = Bio::Tools::Glimmer->new(-file => $file);\n   # filehandle:\n   $parser = Bio::Tools::Glimmer->new( -fh  => \\*INPUT );\n   # provide a sequence identifier (Glimmer 2.X)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -seqname => seqname);\n   # force format (override automatic detection)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -format => 'GlimmerM');\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $glimmer->next_feature() is the same\n\n   while(my $gene = $parser->next_prediction()) {\n       # For eukaryotic input (GlimmerM/GlimmerHMM), $gene will be an instance\n       # of Bio::Tools::Prediction::Gene, which inherits off\n       # Bio::SeqFeature::Gene::Transcript, and $gene->exons() will return an\n       # array of Bio::Tools::Prediction::Exon objects.\n       # For prokaryotic input (Glimmer2.X/Glimmer3.X), $gene will be an\n       # instance of Bio::SeqFeature::Generic\n\n       # all exons (eukaryotic only):\n       @exon_arr = $gene->exons();\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n   }\n\n=head1 DESCRIPTION\n\nThis is a module for parsing Glimmer, GlimmerM and GlimmerHMM predictions.  \nIt will create gene objects from the prediction report which can \nbe attached to a sequence using Bioperl objects, or output as GFF \nsuitable for loading into Bio::DB::GFF for use with Gbrowse.\n\nGlimmer is open source and available at\nL<http://www.cbcb.umd.edu/software/glimmer/>.\n\nGlimmerM is open source and available at \nL<http://www.tigr.org/software/glimmerm/>.\n\nGlimmerHMM is open source and available at\nL<http://www.cbcb.umd.edu/software/GlimmerHMM/>.\n\nNote that Glimmer 2.X will only process the first\nsequence in a fasta file, and the prediction report does not contain any\nsort of sequence identifier\n\nNote that Glimmer 3.X produces two output files.  This module only parses\nthe .predict file.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann\n\nMark Johnson\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Glimmer;\nuse strict;\n\nuse Bio::Factory::FTLocationFactory;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    $self->{'_preds_parsed'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Glimmer->new();\n Function: Builds a new Bio::Tools::Glimmer object \n Returns : an instance of Bio::Tools::Glimmer\n Args    : format ('Glimmer', 'GlimmerM', 'GlimmerHMM'), seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($format, $seqname, $seqlength, $detail) =\n      $self->_rearrange([qw(FORMAT SEQNAME SEQLENGTH DETAIL)], @args);\n\n  # override automagic format detection\n  if (defined($format) &&\n      (($format eq 'Glimmer')  ||\n       ($format eq 'GlimmerM') ||\n       ($format eq 'GlimmerHMM'))\n  ) {\n      $self->_format($format);\n  }\n  \n  if (defined($detail)) {\n      $self->_format('Glimmer');\n      $self->_detail_file($detail);\n  }\n  \n  # hardwire seq_id when creating gene and exon objects (Glimmer 2.X)\n  $self->_seqname($seqname) if defined($seqname);\n  \n  # store the length of the input sequence (Glimmer 2.X)\n  $self->_seqlength($seqlength) if defined($seqlength);\n  \n  return $self;\n}\n\n=head2 analysis_method\n\n Usage     : $glimmer->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /glimmer/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /glimmer/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $glimmer->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :","parameters":[{"label":"$self"},{"label":"@args"}]},"line":231,"range":{"start":{"line":231,"character":0},"end":{"character":9999,"line":237}},"kind":12},{"children":[{"definition":"my","name":"$self","containerName":"next_prediction","localvar":"my","kind":13,"line":255},{"definition":"my","containerName":"next_prediction","localvar":"my","kind":13,"name":"$gene","line":256},{"name":"$self","kind":13,"containerName":"next_prediction","line":259},{"line":259,"name":"_parse_predictions","containerName":"next_prediction","kind":12},{"line":259,"kind":13,"containerName":"next_prediction","name":"$self"},{"line":259,"name":"_predictions_parsed","containerName":"next_prediction","kind":12},{"name":"$gene","kind":13,"containerName":"next_prediction","line":262},{"line":262,"kind":13,"containerName":"next_prediction","name":"$self"},{"name":"_prediction","containerName":"next_prediction","kind":12,"line":262},{"line":263,"name":"$gene","kind":13,"containerName":"next_prediction"}],"containerName":"main::","name":"next_prediction","definition":"sub","detail":"($self)","line":254,"range":{"end":{"line":264,"character":9999},"start":{"line":254,"character":0}},"kind":12,"signature":{"label":"next_prediction($self)","documentation":"1;\n# $Id: Glimmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Glimmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Glimmer - parser for Glimmer 2.X/3.X prokaryotic and \nGlimmerM/GlimmerHMM eukaryotic gene predictions\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Glimmer;\n\n   # file\n   my $parser = Bio::Tools::Glimmer->new(-file => $file);\n   # filehandle:\n   $parser = Bio::Tools::Glimmer->new( -fh  => \\*INPUT );\n   # provide a sequence identifier (Glimmer 2.X)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -seqname => seqname);\n   # force format (override automatic detection)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -format => 'GlimmerM');\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $glimmer->next_feature() is the same\n\n   while(my $gene = $parser->next_prediction()) {\n       # For eukaryotic input (GlimmerM/GlimmerHMM), $gene will be an instance\n       # of Bio::Tools::Prediction::Gene, which inherits off\n       # Bio::SeqFeature::Gene::Transcript, and $gene->exons() will return an\n       # array of Bio::Tools::Prediction::Exon objects.\n       # For prokaryotic input (Glimmer2.X/Glimmer3.X), $gene will be an\n       # instance of Bio::SeqFeature::Generic\n\n       # all exons (eukaryotic only):\n       @exon_arr = $gene->exons();\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n   }\n\n=head1 DESCRIPTION\n\nThis is a module for parsing Glimmer, GlimmerM and GlimmerHMM predictions.  \nIt will create gene objects from the prediction report which can \nbe attached to a sequence using Bioperl objects, or output as GFF \nsuitable for loading into Bio::DB::GFF for use with Gbrowse.\n\nGlimmer is open source and available at\nL<http://www.cbcb.umd.edu/software/glimmer/>.\n\nGlimmerM is open source and available at \nL<http://www.tigr.org/software/glimmerm/>.\n\nGlimmerHMM is open source and available at\nL<http://www.cbcb.umd.edu/software/GlimmerHMM/>.\n\nNote that Glimmer 2.X will only process the first\nsequence in a fasta file, and the prediction report does not contain any\nsort of sequence identifier\n\nNote that Glimmer 3.X produces two output files.  This module only parses\nthe .predict file.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann\n\nMark Johnson\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Glimmer;\nuse strict;\n\nuse Bio::Factory::FTLocationFactory;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    $self->{'_preds_parsed'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Glimmer->new();\n Function: Builds a new Bio::Tools::Glimmer object \n Returns : an instance of Bio::Tools::Glimmer\n Args    : format ('Glimmer', 'GlimmerM', 'GlimmerHMM'), seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($format, $seqname, $seqlength, $detail) =\n      $self->_rearrange([qw(FORMAT SEQNAME SEQLENGTH DETAIL)], @args);\n\n  # override automagic format detection\n  if (defined($format) &&\n      (($format eq 'Glimmer')  ||\n       ($format eq 'GlimmerM') ||\n       ($format eq 'GlimmerHMM'))\n  ) {\n      $self->_format($format);\n  }\n  \n  if (defined($detail)) {\n      $self->_format('Glimmer');\n      $self->_detail_file($detail);\n  }\n  \n  # hardwire seq_id when creating gene and exon objects (Glimmer 2.X)\n  $self->_seqname($seqname) if defined($seqname);\n  \n  # store the length of the input sequence (Glimmer 2.X)\n  $self->_seqlength($seqlength) if defined($seqlength);\n  \n  return $self;\n}\n\n=head2 analysis_method\n\n Usage     : $glimmer->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /glimmer/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /glimmer/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $glimmer->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $glimmer->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :","parameters":[{"label":"$self"}]}},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Glimmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Glimmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Glimmer - parser for Glimmer 2.X/3.X prokaryotic and \nGlimmerM/GlimmerHMM eukaryotic gene predictions\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Glimmer;\n\n   # file\n   my $parser = Bio::Tools::Glimmer->new(-file => $file);\n   # filehandle:\n   $parser = Bio::Tools::Glimmer->new( -fh  => \\*INPUT );\n   # provide a sequence identifier (Glimmer 2.X)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -seqname => seqname);\n   # force format (override automatic detection)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -format => 'GlimmerM');\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $glimmer->next_feature() is the same\n\n   while(my $gene = $parser->next_prediction()) {\n       # For eukaryotic input (GlimmerM/GlimmerHMM), $gene will be an instance\n       # of Bio::Tools::Prediction::Gene, which inherits off\n       # Bio::SeqFeature::Gene::Transcript, and $gene->exons() will return an\n       # array of Bio::Tools::Prediction::Exon objects.\n       # For prokaryotic input (Glimmer2.X/Glimmer3.X), $gene will be an\n       # instance of Bio::SeqFeature::Generic\n\n       # all exons (eukaryotic only):\n       @exon_arr = $gene->exons();\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n   }\n\n=head1 DESCRIPTION\n\nThis is a module for parsing Glimmer, GlimmerM and GlimmerHMM predictions.  \nIt will create gene objects from the prediction report which can \nbe attached to a sequence using Bioperl objects, or output as GFF \nsuitable for loading into Bio::DB::GFF for use with Gbrowse.\n\nGlimmer is open source and available at\nL<http://www.cbcb.umd.edu/software/glimmer/>.\n\nGlimmerM is open source and available at \nL<http://www.tigr.org/software/glimmerm/>.\n\nGlimmerHMM is open source and available at\nL<http://www.cbcb.umd.edu/software/GlimmerHMM/>.\n\nNote that Glimmer 2.X will only process the first\nsequence in a fasta file, and the prediction report does not contain any\nsort of sequence identifier\n\nNote that Glimmer 3.X produces two output files.  This module only parses\nthe .predict file.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann\n\nMark Johnson\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Glimmer;\nuse strict;\n\nuse Bio::Factory::FTLocationFactory;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    $self->{'_preds_parsed'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Glimmer->new();\n Function: Builds a new Bio::Tools::Glimmer object \n Returns : an instance of Bio::Tools::Glimmer\n Args    : format ('Glimmer', 'GlimmerM', 'GlimmerHMM'), seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($format, $seqname, $seqlength, $detail) =\n      $self->_rearrange([qw(FORMAT SEQNAME SEQLENGTH DETAIL)], @args);\n\n  # override automagic format detection\n  if (defined($format) &&\n      (($format eq 'Glimmer')  ||\n       ($format eq 'GlimmerM') ||\n       ($format eq 'GlimmerHMM'))\n  ) {\n      $self->_format($format);\n  }\n  \n  if (defined($detail)) {\n      $self->_format('Glimmer');\n      $self->_detail_file($detail);\n  }\n  \n  # hardwire seq_id when creating gene and exon objects (Glimmer 2.X)\n  $self->_seqname($seqname) if defined($seqname);\n  \n  # store the length of the input sequence (Glimmer 2.X)\n  $self->_seqlength($seqlength) if defined($seqlength);\n  \n  return $self;\n}\n\n=head2 analysis_method\n\n Usage     : $glimmer->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /glimmer/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /glimmer/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $glimmer->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $glimmer->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n    \n    # get next gene structure\n    $gene = $self->_prediction();\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : ","label":"_parse_predictions($self)"},"range":{"end":{"line":325,"character":9999},"start":{"character":0,"line":277}},"kind":12,"line":277,"detail":"($self)","definition":"sub","name":"_parse_predictions","containerName":"main::","children":[{"line":279,"localvar":"my","containerName":"_parse_predictions","kind":13,"name":"$self","definition":"my"},{"name":"%method","kind":13,"localvar":"my","containerName":"_parse_predictions","line":282,"definition":"my"},{"definition":"my","name":"$format","containerName":"_parse_predictions","localvar":"my","kind":13,"line":289},{"line":289,"name":"$self","containerName":"_parse_predictions","kind":13},{"kind":12,"containerName":"_parse_predictions","name":"_format","line":289},{"line":291,"containerName":"_parse_predictions","kind":13,"name":"$format"},{"localvar":"my","kind":13,"containerName":"_parse_predictions","name":"$line","line":293,"definition":"my"},{"name":"$self","kind":13,"containerName":"_parse_predictions","line":293},{"line":293,"containerName":"_parse_predictions","kind":12,"name":"_readline"},{"name":"$line","containerName":"_parse_predictions","kind":13,"line":295},{"containerName":"_parse_predictions","kind":13,"name":"$format","line":296},{"line":297,"name":"$self","containerName":"_parse_predictions","kind":13},{"line":297,"containerName":"_parse_predictions","kind":12,"name":"_pushback"},{"line":297,"name":"$line","containerName":"_parse_predictions","kind":13},{"line":300,"kind":13,"containerName":"_parse_predictions","name":"$line"},{"line":301,"name":"$format","kind":13,"containerName":"_parse_predictions"},{"line":302,"kind":13,"containerName":"_parse_predictions","name":"$self"},{"line":302,"kind":12,"containerName":"_parse_predictions","name":"_pushback"},{"name":"$line","containerName":"_parse_predictions","kind":13,"line":302},{"line":305,"kind":13,"containerName":"_parse_predictions","name":"$line"},{"line":306,"containerName":"_parse_predictions","kind":13,"name":"$format"},{"name":"$self","kind":13,"containerName":"_parse_predictions","line":307},{"line":307,"kind":12,"containerName":"_parse_predictions","name":"_pushback"},{"kind":13,"containerName":"_parse_predictions","name":"$line","line":307},{"kind":13,"containerName":"_parse_predictions","name":"$line","line":310},{"name":"$format","kind":13,"containerName":"_parse_predictions","line":311},{"line":312,"name":"$self","kind":13,"containerName":"_parse_predictions"},{"line":312,"name":"_pushback","containerName":"_parse_predictions","kind":12},{"name":"$line","containerName":"_parse_predictions","kind":13,"line":312},{"containerName":"_parse_predictions","localvar":"my","kind":13,"name":"$method","line":320,"definition":"my"},{"line":321,"name":"$method","containerName":"_parse_predictions","kind":13},{"line":321,"containerName":"_parse_predictions","kind":13,"name":"$format"},{"line":321,"containerName":"_parse_predictions","kind":13,"name":"$method"},{"containerName":"_parse_predictions","kind":13,"name":"$format","line":321},{"line":321,"containerName":"_parse_predictions","kind":13,"name":"$method"},{"name":"$self","containerName":"_parse_predictions","kind":13,"line":323},{"containerName":"_parse_predictions","kind":13,"name":"$method","line":323}]},{"signature":{"label":"_parse_eukaryotic($self)","documentation":"1;\n# $Id: Glimmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Glimmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Glimmer - parser for Glimmer 2.X/3.X prokaryotic and \nGlimmerM/GlimmerHMM eukaryotic gene predictions\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Glimmer;\n\n   # file\n   my $parser = Bio::Tools::Glimmer->new(-file => $file);\n   # filehandle:\n   $parser = Bio::Tools::Glimmer->new( -fh  => \\*INPUT );\n   # provide a sequence identifier (Glimmer 2.X)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -seqname => seqname);\n   # force format (override automatic detection)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -format => 'GlimmerM');\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $glimmer->next_feature() is the same\n\n   while(my $gene = $parser->next_prediction()) {\n       # For eukaryotic input (GlimmerM/GlimmerHMM), $gene will be an instance\n       # of Bio::Tools::Prediction::Gene, which inherits off\n       # Bio::SeqFeature::Gene::Transcript, and $gene->exons() will return an\n       # array of Bio::Tools::Prediction::Exon objects.\n       # For prokaryotic input (Glimmer2.X/Glimmer3.X), $gene will be an\n       # instance of Bio::SeqFeature::Generic\n\n       # all exons (eukaryotic only):\n       @exon_arr = $gene->exons();\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n   }\n\n=head1 DESCRIPTION\n\nThis is a module for parsing Glimmer, GlimmerM and GlimmerHMM predictions.  \nIt will create gene objects from the prediction report which can \nbe attached to a sequence using Bioperl objects, or output as GFF \nsuitable for loading into Bio::DB::GFF for use with Gbrowse.\n\nGlimmer is open source and available at\nL<http://www.cbcb.umd.edu/software/glimmer/>.\n\nGlimmerM is open source and available at \nL<http://www.tigr.org/software/glimmerm/>.\n\nGlimmerHMM is open source and available at\nL<http://www.cbcb.umd.edu/software/GlimmerHMM/>.\n\nNote that Glimmer 2.X will only process the first\nsequence in a fasta file, and the prediction report does not contain any\nsort of sequence identifier\n\nNote that Glimmer 3.X produces two output files.  This module only parses\nthe .predict file.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann\n\nMark Johnson\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Glimmer;\nuse strict;\n\nuse Bio::Factory::FTLocationFactory;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    $self->{'_preds_parsed'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Glimmer->new();\n Function: Builds a new Bio::Tools::Glimmer object \n Returns : an instance of Bio::Tools::Glimmer\n Args    : format ('Glimmer', 'GlimmerM', 'GlimmerHMM'), seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($format, $seqname, $seqlength, $detail) =\n      $self->_rearrange([qw(FORMAT SEQNAME SEQLENGTH DETAIL)], @args);\n\n  # override automagic format detection\n  if (defined($format) &&\n      (($format eq 'Glimmer')  ||\n       ($format eq 'GlimmerM') ||\n       ($format eq 'GlimmerHMM'))\n  ) {\n      $self->_format($format);\n  }\n  \n  if (defined($detail)) {\n      $self->_format('Glimmer');\n      $self->_detail_file($detail);\n  }\n  \n  # hardwire seq_id when creating gene and exon objects (Glimmer 2.X)\n  $self->_seqname($seqname) if defined($seqname);\n  \n  # store the length of the input sequence (Glimmer 2.X)\n  $self->_seqlength($seqlength) if defined($seqlength);\n  \n  return $self;\n}\n\n=head2 analysis_method\n\n Usage     : $glimmer->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /glimmer/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /glimmer/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $glimmer->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $glimmer->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n    \n    # get next gene structure\n    $gene = $self->_prediction();\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n\n    my ($self) = @_;\n\n    \n    my %method = (\n                  'Glimmer'    => '_parse_prokaryotic',\n                  'GlimmerM'   => '_parse_eukaryotic',\n                  'GlimmerHMM' => '_parse_eukaryotic',\n                  '_DEFAULT_'  => '_parse_eukaryotic',\n              );\n    \n    my $format = $self->_format();\n    \n    if (!$format) {\n        \n        while (my $line = $self->_readline()) {\n\n            if ( $line =~ /^Glimmer\\S*\\s+\\(Version\\s*\\S+\\)/ ) {\n                $format = 'GlimmerM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ( $line =~ /^Glimmer\\S*$/ ) {\n                $format = 'GlimmerHMM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^Putative Genes:$/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^>(\\S+)/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            \n        }\n        \n    }\n\n    my $method =\n        (exists($method{$format})) ? $method{$format} : $method{'_DEFAULT_'};\n\n    return $self->$method();\n    \n}\n\n\n=head2 _parse_eukaryotic\n\n Title   : _parse_eukaryotic()\n Usage   : $obj->_parse_eukaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : ","parameters":[{"label":"$self"}]},"kind":12,"range":{"end":{"character":9999,"line":395},"start":{"line":339,"character":0}},"line":339,"detail":"($self)","definition":"sub","containerName":"main::","name":"_parse_eukaryotic","children":[{"line":340,"name":"$self","containerName":"_parse_eukaryotic","localvar":"my","kind":13,"definition":"my"},{"name":"$gene","containerName":"_parse_eukaryotic","localvar":"my","kind":13,"line":342,"definition":"my"},{"line":342,"name":"$seqname","containerName":"_parse_eukaryotic","kind":13},{"name":"$seqlen","kind":13,"containerName":"_parse_eukaryotic","line":342},{"name":"$source","kind":13,"containerName":"_parse_eukaryotic","line":342},{"line":342,"containerName":"_parse_eukaryotic","kind":13,"name":"$lastgenenum"},{"line":344,"kind":13,"containerName":"_parse_eukaryotic","name":"$self"},{"containerName":"_parse_eukaryotic","kind":12,"name":"_readline","line":344},{"line":346,"name":"$source","containerName":"_parse_eukaryotic","kind":13},{"name":"$source","containerName":"_parse_eukaryotic","kind":13,"line":349},{"name":"$seqname","kind":13,"containerName":"_parse_eukaryotic","line":352},{"kind":13,"containerName":"_parse_eukaryotic","name":"$seqlen","line":355},{"definition":"my","line":368,"name":"$genenum","containerName":"_parse_eukaryotic","localvar":"my","kind":13},{"line":368,"kind":13,"containerName":"_parse_eukaryotic","name":"$exonnum"},{"line":368,"containerName":"_parse_eukaryotic","kind":13,"name":"$strand"},{"line":368,"name":"$type","kind":13,"containerName":"_parse_eukaryotic"},{"line":368,"name":"$start","kind":13,"containerName":"_parse_eukaryotic"},{"line":368,"name":"$end","containerName":"_parse_eukaryotic","kind":13},{"line":368,"name":"$len","kind":13,"containerName":"_parse_eukaryotic"},{"name":"$lastgenenum","containerName":"_parse_eukaryotic","kind":13,"line":370},{"line":370,"name":"$lastgenenum","kind":13,"containerName":"_parse_eukaryotic"},{"line":370,"name":"$genenum","containerName":"_parse_eukaryotic","kind":13},{"kind":13,"containerName":"_parse_eukaryotic","name":"$self","line":371},{"containerName":"_parse_eukaryotic","kind":12,"name":"_add_prediction","line":371},{"kind":13,"containerName":"_parse_eukaryotic","name":"$gene","line":371},{"line":371,"name":"$gene","containerName":"_parse_eukaryotic","kind":13},{"containerName":"_parse_eukaryotic","kind":13,"name":"$gene","line":372},{"line":373,"kind":12,"containerName":"_parse_eukaryotic","name":"new"},{"name":"$seqname","kind":13,"containerName":"_parse_eukaryotic","line":374},{"name":"$source","kind":13,"containerName":"_parse_eukaryotic","line":376},{"definition":"my","localvar":"my","containerName":"_parse_eukaryotic","kind":13,"name":"$exon","line":380},{"line":381,"containerName":"_parse_eukaryotic","kind":12,"name":"new"},{"line":381,"kind":13,"containerName":"_parse_eukaryotic","name":"$seqname"},{"line":382,"kind":13,"containerName":"_parse_eukaryotic","name":"$start"},{"line":383,"name":"$end","kind":13,"containerName":"_parse_eukaryotic"},{"name":"$strand","kind":13,"containerName":"_parse_eukaryotic","line":384},{"name":"$source","containerName":"_parse_eukaryotic","kind":13,"line":385},{"kind":13,"containerName":"_parse_eukaryotic","name":"$gene","line":389},{"line":389,"kind":12,"containerName":"_parse_eukaryotic","name":"add_exon"},{"line":389,"kind":13,"containerName":"_parse_eukaryotic","name":"$exon"},{"name":"$type","containerName":"_parse_eukaryotic","kind":13,"line":389},{"name":"$lastgenenum","kind":13,"containerName":"_parse_eukaryotic","line":390},{"containerName":"_parse_eukaryotic","kind":13,"name":"$genenum","line":390},{"name":"$self","kind":13,"containerName":"_parse_eukaryotic","line":393},{"line":393,"kind":12,"containerName":"_parse_eukaryotic","name":"_add_prediction"},{"line":393,"kind":13,"containerName":"_parse_eukaryotic","name":"$gene"},{"name":"$gene","containerName":"_parse_eukaryotic","kind":13,"line":393},{"name":"$self","containerName":"_parse_eukaryotic","kind":13,"line":394},{"line":394,"kind":12,"containerName":"_parse_eukaryotic","name":"_predictions_parsed"}]},{"line":372,"name":"Bio","containerName":"Tools::Prediction::Gene","kind":12},{"containerName":"Tools::Prediction::Exon","kind":12,"name":"Bio","line":380},{"children":[{"line":409,"localvar":"my","kind":13,"containerName":"_parse_prokaryotic","name":"$self","definition":"my"},{"line":412,"localvar":"my","kind":13,"containerName":"_parse_prokaryotic","name":"$source","definition":"my"},{"localvar":"my","kind":13,"containerName":"_parse_prokaryotic","name":"%seqlength","line":417,"definition":"my"},{"line":428,"localvar":"my","kind":13,"containerName":"_parse_prokaryotic","name":"$seqname","definition":"my"},{"name":"$self","kind":13,"containerName":"_parse_prokaryotic","line":428},{"line":428,"name":"_seqname","kind":12,"containerName":"_parse_prokaryotic"},{"definition":"my","containerName":"_parse_prokaryotic","localvar":"my","kind":13,"name":"$seqlength","line":429},{"line":429,"containerName":"_parse_prokaryotic","kind":13,"name":"$self"},{"name":"_seqlength","containerName":"_parse_prokaryotic","kind":12,"line":429},{"containerName":"_parse_prokaryotic","kind":13,"name":"$seqlength","line":431},{"line":432,"name":"$seqlength","kind":13,"containerName":"_parse_prokaryotic"},{"name":"$seqname","kind":13,"containerName":"_parse_prokaryotic","line":432},{"containerName":"_parse_prokaryotic","kind":13,"name":"$seqlength","line":433},{"line":436,"kind":13,"localvar":"my","containerName":"_parse_prokaryotic","name":"$detail_file","definition":"my"},{"line":436,"name":"$self","containerName":"_parse_prokaryotic","kind":13},{"name":"_detail_file","kind":12,"containerName":"_parse_prokaryotic","line":436},{"kind":13,"containerName":"_parse_prokaryotic","name":"$detail_file","line":438},{"line":440,"name":"$io","containerName":"_parse_prokaryotic","localvar":"my","kind":13,"definition":"my"},{"line":440,"kind":12,"containerName":"_parse_prokaryotic","name":"new"},{"line":440,"name":"$detail_file","containerName":"_parse_prokaryotic","kind":13},{"line":441,"localvar":"my","kind":13,"containerName":"_parse_prokaryotic","name":"$seqname","definition":"my"},{"line":443,"name":"$io","kind":13,"containerName":"_parse_prokaryotic"},{"kind":12,"containerName":"_parse_prokaryotic","name":"_readline","line":443},{"line":445,"kind":13,"containerName":"_parse_prokaryotic","name":"$seqname"},{"containerName":"_parse_prokaryotic","kind":13,"name":"$seqname","line":449},{"line":450,"name":"$seqlength","kind":13,"containerName":"_parse_prokaryotic"},{"line":450,"name":"$seqname","kind":13,"containerName":"_parse_prokaryotic"},{"localvar":"my","containerName":"_parse_prokaryotic","kind":13,"name":"$location_factory","line":456,"definition":"my"},{"name":"new","containerName":"_parse_prokaryotic","kind":12,"line":456},{"line":458,"name":"$self","containerName":"_parse_prokaryotic","kind":13},{"line":458,"kind":12,"containerName":"_parse_prokaryotic","name":"_readline"},{"name":"$source","containerName":"_parse_prokaryotic","kind":13,"line":463},{"line":468,"name":"$seqname","containerName":"_parse_prokaryotic","kind":13},{"name":"$seqlength","containerName":"_parse_prokaryotic","kind":13,"line":469},{"line":469,"name":"$seqlength","kind":13,"containerName":"_parse_prokaryotic"},{"line":469,"containerName":"_parse_prokaryotic","kind":13,"name":"$seqname"},{"name":"$source","containerName":"_parse_prokaryotic","kind":13,"line":470},{"kind":13,"localvar":"my","containerName":"_parse_prokaryotic","name":"$genenum","line":485,"definition":"my"},{"line":485,"name":"$start","kind":13,"containerName":"_parse_prokaryotic"},{"line":485,"name":"$end","kind":13,"containerName":"_parse_prokaryotic"},{"kind":13,"containerName":"_parse_prokaryotic","name":"$strand","line":485},{"line":485,"containerName":"_parse_prokaryotic","kind":13,"name":"$frame"},{"name":"$score","kind":13,"containerName":"_parse_prokaryotic","line":485},{"definition":"my","line":488,"name":"$circular_prediction","localvar":"my","kind":13,"containerName":"_parse_prokaryotic"},{"kind":13,"containerName":"_parse_prokaryotic","name":"$strand","line":492},{"line":493,"containerName":"_parse_prokaryotic","kind":13,"name":"$start"},{"line":493,"containerName":"_parse_prokaryotic","kind":13,"name":"$end"},{"line":494,"containerName":"_parse_prokaryotic","kind":13,"name":"$circular_prediction"},{"kind":13,"containerName":"_parse_prokaryotic","name":"$start","line":498},{"line":498,"containerName":"_parse_prokaryotic","kind":13,"name":"$end"},{"containerName":"_parse_prokaryotic","kind":13,"name":"$circular_prediction","line":499},{"name":"$circular_prediction","containerName":"_parse_prokaryotic","kind":13,"line":503},{"line":504,"containerName":"_parse_prokaryotic","kind":13,"name":"$seqlength"},{"kind":13,"containerName":"_parse_prokaryotic","name":"$self","line":505},{"line":505,"containerName":"_parse_prokaryotic","kind":12,"name":"throw"},{"kind":13,"containerName":"_parse_prokaryotic","name":"$source","line":514},{"name":"$strand","containerName":"_parse_prokaryotic","kind":13,"line":515},{"name":"$end","kind":13,"containerName":"_parse_prokaryotic","line":516},{"line":519,"name":"$end","containerName":"_parse_prokaryotic","kind":13},{"definition":"my","line":528,"name":"$fst","kind":13,"localvar":"my","containerName":"_parse_prokaryotic"},{"line":528,"containerName":"_parse_prokaryotic","kind":13,"name":"$fend"},{"definition":"my","name":"$coord","localvar":"my","kind":13,"containerName":"_parse_prokaryotic","line":529},{"containerName":"_parse_prokaryotic","kind":13,"name":"$start","line":529},{"line":529,"containerName":"_parse_prokaryotic","kind":13,"name":"$end"},{"line":530,"kind":13,"containerName":"_parse_prokaryotic","name":"$coord"},{"line":531,"kind":13,"containerName":"_parse_prokaryotic","name":"$coord"},{"containerName":"_parse_prokaryotic","kind":13,"name":"$fst","line":532},{"line":533,"kind":13,"containerName":"_parse_prokaryotic","name":"$seqlength"},{"name":"$coord","kind":13,"containerName":"_parse_prokaryotic","line":533},{"containerName":"_parse_prokaryotic","kind":13,"name":"$seqlength","line":533},{"line":534,"name":"$coord","kind":13,"containerName":"_parse_prokaryotic"},{"name":"$fend","kind":13,"containerName":"_parse_prokaryotic","line":535},{"definition":"my","name":"$location_string","containerName":"_parse_prokaryotic","localvar":"my","kind":13,"line":539},{"line":541,"name":"$circular_prediction","containerName":"_parse_prokaryotic","kind":13},{"kind":13,"containerName":"_parse_prokaryotic","name":"$strand","line":542},{"name":"$location_string","containerName":"_parse_prokaryotic","kind":13,"line":543},{"kind":13,"containerName":"_parse_prokaryotic","name":"$location_string","line":546},{"containerName":"_parse_prokaryotic","kind":13,"name":"$strand","line":551},{"name":"$fst","kind":13,"containerName":"_parse_prokaryotic","line":551},{"kind":13,"containerName":"_parse_prokaryotic","name":"$fend","line":551},{"kind":13,"containerName":"_parse_prokaryotic","name":"$start","line":551},{"name":"$end","containerName":"_parse_prokaryotic","kind":13,"line":551},{"name":"$start","kind":13,"containerName":"_parse_prokaryotic","line":552},{"line":552,"kind":13,"containerName":"_parse_prokaryotic","name":"$end"},{"containerName":"_parse_prokaryotic","kind":13,"name":"$end","line":552},{"containerName":"_parse_prokaryotic","kind":13,"name":"$start","line":552},{"name":"$location_string","containerName":"_parse_prokaryotic","kind":13,"line":554},{"localvar":"my","containerName":"_parse_prokaryotic","kind":13,"name":"$location_object","line":557,"definition":"my"},{"line":558,"kind":13,"containerName":"_parse_prokaryotic","name":"$location_factory"},{"line":558,"containerName":"_parse_prokaryotic","kind":12,"name":"from_string"},{"line":558,"name":"$location_string","containerName":"_parse_prokaryotic","kind":13},{"containerName":"_parse_prokaryotic","kind":13,"name":"$frame","line":561},{"name":"$gene","localvar":"my","kind":13,"containerName":"_parse_prokaryotic","line":563,"definition":"my"},{"line":564,"name":"new","kind":12,"containerName":"_parse_prokaryotic"},{"kind":13,"containerName":"_parse_prokaryotic","name":"$seqname","line":565},{"line":566,"name":"$location_object","kind":13,"containerName":"_parse_prokaryotic"},{"line":567,"kind":13,"containerName":"_parse_prokaryotic","name":"$strand"},{"name":"$frame","kind":13,"containerName":"_parse_prokaryotic","line":568},{"name":"$source","containerName":"_parse_prokaryotic","kind":13,"line":569},{"line":573,"name":"$score","kind":13,"containerName":"_parse_prokaryotic"},{"kind":13,"containerName":"_parse_prokaryotic","name":"$self","line":576},{"name":"_add_prediction","containerName":"_parse_prokaryotic","kind":12,"line":576},{"line":576,"name":"$gene","kind":13,"containerName":"_parse_prokaryotic"},{"containerName":"_parse_prokaryotic","kind":13,"name":"$self","line":580},{"name":"_predictions_parsed","containerName":"_parse_prokaryotic","kind":12,"line":580}],"containerName":"main::","name":"_parse_prokaryotic","definition":"sub","detail":"($self)","line":408,"range":{"end":{"character":9999,"line":581},"start":{"line":408,"character":0}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Glimmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Glimmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Glimmer - parser for Glimmer 2.X/3.X prokaryotic and \nGlimmerM/GlimmerHMM eukaryotic gene predictions\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Glimmer;\n\n   # file\n   my $parser = Bio::Tools::Glimmer->new(-file => $file);\n   # filehandle:\n   $parser = Bio::Tools::Glimmer->new( -fh  => \\*INPUT );\n   # provide a sequence identifier (Glimmer 2.X)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -seqname => seqname);\n   # force format (override automatic detection)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -format => 'GlimmerM');\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $glimmer->next_feature() is the same\n\n   while(my $gene = $parser->next_prediction()) {\n       # For eukaryotic input (GlimmerM/GlimmerHMM), $gene will be an instance\n       # of Bio::Tools::Prediction::Gene, which inherits off\n       # Bio::SeqFeature::Gene::Transcript, and $gene->exons() will return an\n       # array of Bio::Tools::Prediction::Exon objects.\n       # For prokaryotic input (Glimmer2.X/Glimmer3.X), $gene will be an\n       # instance of Bio::SeqFeature::Generic\n\n       # all exons (eukaryotic only):\n       @exon_arr = $gene->exons();\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n   }\n\n=head1 DESCRIPTION\n\nThis is a module for parsing Glimmer, GlimmerM and GlimmerHMM predictions.  \nIt will create gene objects from the prediction report which can \nbe attached to a sequence using Bioperl objects, or output as GFF \nsuitable for loading into Bio::DB::GFF for use with Gbrowse.\n\nGlimmer is open source and available at\nL<http://www.cbcb.umd.edu/software/glimmer/>.\n\nGlimmerM is open source and available at \nL<http://www.tigr.org/software/glimmerm/>.\n\nGlimmerHMM is open source and available at\nL<http://www.cbcb.umd.edu/software/GlimmerHMM/>.\n\nNote that Glimmer 2.X will only process the first\nsequence in a fasta file, and the prediction report does not contain any\nsort of sequence identifier\n\nNote that Glimmer 3.X produces two output files.  This module only parses\nthe .predict file.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann\n\nMark Johnson\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Glimmer;\nuse strict;\n\nuse Bio::Factory::FTLocationFactory;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    $self->{'_preds_parsed'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Glimmer->new();\n Function: Builds a new Bio::Tools::Glimmer object \n Returns : an instance of Bio::Tools::Glimmer\n Args    : format ('Glimmer', 'GlimmerM', 'GlimmerHMM'), seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($format, $seqname, $seqlength, $detail) =\n      $self->_rearrange([qw(FORMAT SEQNAME SEQLENGTH DETAIL)], @args);\n\n  # override automagic format detection\n  if (defined($format) &&\n      (($format eq 'Glimmer')  ||\n       ($format eq 'GlimmerM') ||\n       ($format eq 'GlimmerHMM'))\n  ) {\n      $self->_format($format);\n  }\n  \n  if (defined($detail)) {\n      $self->_format('Glimmer');\n      $self->_detail_file($detail);\n  }\n  \n  # hardwire seq_id when creating gene and exon objects (Glimmer 2.X)\n  $self->_seqname($seqname) if defined($seqname);\n  \n  # store the length of the input sequence (Glimmer 2.X)\n  $self->_seqlength($seqlength) if defined($seqlength);\n  \n  return $self;\n}\n\n=head2 analysis_method\n\n Usage     : $glimmer->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /glimmer/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /glimmer/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $glimmer->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $glimmer->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n    \n    # get next gene structure\n    $gene = $self->_prediction();\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n\n    my ($self) = @_;\n\n    \n    my %method = (\n                  'Glimmer'    => '_parse_prokaryotic',\n                  'GlimmerM'   => '_parse_eukaryotic',\n                  'GlimmerHMM' => '_parse_eukaryotic',\n                  '_DEFAULT_'  => '_parse_eukaryotic',\n              );\n    \n    my $format = $self->_format();\n    \n    if (!$format) {\n        \n        while (my $line = $self->_readline()) {\n\n            if ( $line =~ /^Glimmer\\S*\\s+\\(Version\\s*\\S+\\)/ ) {\n                $format = 'GlimmerM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ( $line =~ /^Glimmer\\S*$/ ) {\n                $format = 'GlimmerHMM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^Putative Genes:$/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^>(\\S+)/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            \n        }\n        \n    }\n\n    my $method =\n        (exists($method{$format})) ? $method{$format} : $method{'_DEFAULT_'};\n\n    return $self->$method();\n    \n}\n\n\n=head2 _parse_eukaryotic\n\n Title   : _parse_eukaryotic()\n Usage   : $obj->_parse_eukaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_eukaryotic {\n    my ($self) = @_;\n\n    my ($gene,$seqname,$seqlen,$source,$lastgenenum);\n    \n    while(defined($_ = $self->_readline())) {\n\tif( /^(Glimmer\\S*)\\s+\\(Version\\s*(\\S+)\\)/ ) {\n\t    $source = \"$1_$2\";\n\t    next;\n\t} elsif( /^(GlimmerHMM\\S*)$/ ) { # GlimmerHMM has no version\n\t    $source = $1;\n\t    next;\n\t} elsif(/^Sequence name:\\s+(.+)$/ ) {\n\t    $seqname = $1;\n\t    next;\n\t} elsif( /^Sequence length:\\s+(\\S+)/ ) {\n\t    $seqlen = $1;\n\t    next;\n\t} elsif( m/^(Predicted genes)|(Gene)|\\s+\\#/ || /^\\s+$/ ) { \n\t    next;\n\t    \n\t} elsif( # GlimmerM/HMM gene-exon prediction line\n\t\t /^\\s+(\\d+)\\s+ # gene num\n\t\t (\\d+)\\s+      # exon num\n\t\t ([\\+\\-])\\s+   # strand\n\t\t (\\S+)\\s+      # exon type\n\t\t (\\d+)\\s+(\\d+) # exon start, end\n\t\t \\s+(\\d+)      # exon length\t\t \n\t\t /ox ) {\n\t    my ($genenum,$exonnum,$strand,$type,$start,$end,$len) = \n\t\t( $1,$2,$3,$4,$5,$6,$7);\n\t    if( ! $lastgenenum || $lastgenenum != $genenum) {\t\t\n\t\t$self->_add_prediction($gene) if ( $gene );\n\t\t$gene = Bio::Tools::Prediction::Gene->new\n\t\t    (\n\t\t     '-seq_id'      => $seqname,\n\t\t     '-primary_tag' => \"gene\",\n\t\t     '-source_tag'  => $source,\n\t\t     '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t     );\n\t    }\n\t    my $exon = Bio::Tools::Prediction::Exon->new\n\t\t('-seq_id'     => $seqname,\n\t\t '-start'      => $start,\n\t\t '-end'        => $end,\n\t\t '-strand'     => $strand eq '-' ? '-1' : '1',\n\t\t '-source_tag' => $source,\n\t\t '-primary_tag'=> 'exon',\n\t\t '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t );\n\t    $gene->add_exon($exon,lc($type));\n\t    $lastgenenum = $genenum;\n\t}\n    }\n    $self->_add_prediction($gene) if( $gene );\n    $self->_predictions_parsed(1);\n}\n\n=head2 _parse_prokaryotic\n\n Title   : _parse_prokaryotic()\n Usage   : $obj->_parse_prokaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : ","label":"_parse_prokaryotic($self)"}},{"containerName":"Root::IO","kind":12,"name":"Bio","line":440},{"line":456,"name":"Bio","containerName":"Factory::FTLocationFactory","kind":12},{"name":"Bio","containerName":"SeqFeature::Generic","kind":12,"line":563},{"signature":{"label":"_prediction($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Glimmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Glimmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Glimmer - parser for Glimmer 2.X/3.X prokaryotic and \nGlimmerM/GlimmerHMM eukaryotic gene predictions\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Glimmer;\n\n   # file\n   my $parser = Bio::Tools::Glimmer->new(-file => $file);\n   # filehandle:\n   $parser = Bio::Tools::Glimmer->new( -fh  => \\*INPUT );\n   # provide a sequence identifier (Glimmer 2.X)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -seqname => seqname);\n   # force format (override automatic detection)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -format => 'GlimmerM');\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $glimmer->next_feature() is the same\n\n   while(my $gene = $parser->next_prediction()) {\n       # For eukaryotic input (GlimmerM/GlimmerHMM), $gene will be an instance\n       # of Bio::Tools::Prediction::Gene, which inherits off\n       # Bio::SeqFeature::Gene::Transcript, and $gene->exons() will return an\n       # array of Bio::Tools::Prediction::Exon objects.\n       # For prokaryotic input (Glimmer2.X/Glimmer3.X), $gene will be an\n       # instance of Bio::SeqFeature::Generic\n\n       # all exons (eukaryotic only):\n       @exon_arr = $gene->exons();\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n   }\n\n=head1 DESCRIPTION\n\nThis is a module for parsing Glimmer, GlimmerM and GlimmerHMM predictions.  \nIt will create gene objects from the prediction report which can \nbe attached to a sequence using Bioperl objects, or output as GFF \nsuitable for loading into Bio::DB::GFF for use with Gbrowse.\n\nGlimmer is open source and available at\nL<http://www.cbcb.umd.edu/software/glimmer/>.\n\nGlimmerM is open source and available at \nL<http://www.tigr.org/software/glimmerm/>.\n\nGlimmerHMM is open source and available at\nL<http://www.cbcb.umd.edu/software/GlimmerHMM/>.\n\nNote that Glimmer 2.X will only process the first\nsequence in a fasta file, and the prediction report does not contain any\nsort of sequence identifier\n\nNote that Glimmer 3.X produces two output files.  This module only parses\nthe .predict file.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann\n\nMark Johnson\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Glimmer;\nuse strict;\n\nuse Bio::Factory::FTLocationFactory;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    $self->{'_preds_parsed'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Glimmer->new();\n Function: Builds a new Bio::Tools::Glimmer object \n Returns : an instance of Bio::Tools::Glimmer\n Args    : format ('Glimmer', 'GlimmerM', 'GlimmerHMM'), seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($format, $seqname, $seqlength, $detail) =\n      $self->_rearrange([qw(FORMAT SEQNAME SEQLENGTH DETAIL)], @args);\n\n  # override automagic format detection\n  if (defined($format) &&\n      (($format eq 'Glimmer')  ||\n       ($format eq 'GlimmerM') ||\n       ($format eq 'GlimmerHMM'))\n  ) {\n      $self->_format($format);\n  }\n  \n  if (defined($detail)) {\n      $self->_format('Glimmer');\n      $self->_detail_file($detail);\n  }\n  \n  # hardwire seq_id when creating gene and exon objects (Glimmer 2.X)\n  $self->_seqname($seqname) if defined($seqname);\n  \n  # store the length of the input sequence (Glimmer 2.X)\n  $self->_seqlength($seqlength) if defined($seqlength);\n  \n  return $self;\n}\n\n=head2 analysis_method\n\n Usage     : $glimmer->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /glimmer/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /glimmer/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $glimmer->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $glimmer->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n    \n    # get next gene structure\n    $gene = $self->_prediction();\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n\n    my ($self) = @_;\n\n    \n    my %method = (\n                  'Glimmer'    => '_parse_prokaryotic',\n                  'GlimmerM'   => '_parse_eukaryotic',\n                  'GlimmerHMM' => '_parse_eukaryotic',\n                  '_DEFAULT_'  => '_parse_eukaryotic',\n              );\n    \n    my $format = $self->_format();\n    \n    if (!$format) {\n        \n        while (my $line = $self->_readline()) {\n\n            if ( $line =~ /^Glimmer\\S*\\s+\\(Version\\s*\\S+\\)/ ) {\n                $format = 'GlimmerM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ( $line =~ /^Glimmer\\S*$/ ) {\n                $format = 'GlimmerHMM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^Putative Genes:$/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^>(\\S+)/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            \n        }\n        \n    }\n\n    my $method =\n        (exists($method{$format})) ? $method{$format} : $method{'_DEFAULT_'};\n\n    return $self->$method();\n    \n}\n\n\n=head2 _parse_eukaryotic\n\n Title   : _parse_eukaryotic()\n Usage   : $obj->_parse_eukaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_eukaryotic {\n    my ($self) = @_;\n\n    my ($gene,$seqname,$seqlen,$source,$lastgenenum);\n    \n    while(defined($_ = $self->_readline())) {\n\tif( /^(Glimmer\\S*)\\s+\\(Version\\s*(\\S+)\\)/ ) {\n\t    $source = \"$1_$2\";\n\t    next;\n\t} elsif( /^(GlimmerHMM\\S*)$/ ) { # GlimmerHMM has no version\n\t    $source = $1;\n\t    next;\n\t} elsif(/^Sequence name:\\s+(.+)$/ ) {\n\t    $seqname = $1;\n\t    next;\n\t} elsif( /^Sequence length:\\s+(\\S+)/ ) {\n\t    $seqlen = $1;\n\t    next;\n\t} elsif( m/^(Predicted genes)|(Gene)|\\s+\\#/ || /^\\s+$/ ) { \n\t    next;\n\t    \n\t} elsif( # GlimmerM/HMM gene-exon prediction line\n\t\t /^\\s+(\\d+)\\s+ # gene num\n\t\t (\\d+)\\s+      # exon num\n\t\t ([\\+\\-])\\s+   # strand\n\t\t (\\S+)\\s+      # exon type\n\t\t (\\d+)\\s+(\\d+) # exon start, end\n\t\t \\s+(\\d+)      # exon length\t\t \n\t\t /ox ) {\n\t    my ($genenum,$exonnum,$strand,$type,$start,$end,$len) = \n\t\t( $1,$2,$3,$4,$5,$6,$7);\n\t    if( ! $lastgenenum || $lastgenenum != $genenum) {\t\t\n\t\t$self->_add_prediction($gene) if ( $gene );\n\t\t$gene = Bio::Tools::Prediction::Gene->new\n\t\t    (\n\t\t     '-seq_id'      => $seqname,\n\t\t     '-primary_tag' => \"gene\",\n\t\t     '-source_tag'  => $source,\n\t\t     '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t     );\n\t    }\n\t    my $exon = Bio::Tools::Prediction::Exon->new\n\t\t('-seq_id'     => $seqname,\n\t\t '-start'      => $start,\n\t\t '-end'        => $end,\n\t\t '-strand'     => $strand eq '-' ? '-1' : '1',\n\t\t '-source_tag' => $source,\n\t\t '-primary_tag'=> 'exon',\n\t\t '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t );\n\t    $gene->add_exon($exon,lc($type));\n\t    $lastgenenum = $genenum;\n\t}\n    }\n    $self->_add_prediction($gene) if( $gene );\n    $self->_predictions_parsed(1);\n}\n\n=head2 _parse_prokaryotic\n\n Title   : _parse_prokaryotic()\n Usage   : $obj->_parse_prokaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_prokaryotic {\n    my ($self) = @_;\n\n    # default value, possibly overriden later\n    my $source = 'Glimmer';\n\n    # Store the sequence length(s) here, either from the\n    # seqlength arg to the constructor, or from the\n    # Glimmer 3.X detail file\n    my %seqlength = ( );\n    \n    # Glimmer 2.X does not provide a sequence identifer\n    # in the prediction report (will default to unknown\n    # if not specified in the seqname arg to the\n    # constructor\n    #\n    # Glimmer 2.X does not report the length of the\n    # input sequence, either (will default to undef\n    # if not specified in the seqlength arg to the\n    # constructor\n    my $seqname = $self->_seqname();\n    my $seqlength = $self->_seqlength();\n\n    if (defined($seqlength)) {\n        $seqlength{$seqname} = $seqlength\n    }\n\n    # Parse the detail file, if we have one (Glimmer 3.X)\n    my $detail_file = $self->_detail_file();\n    \n    if (defined($detail_file)) {\n\n        my $io = Bio::Root::IO->new(-file => $detail_file);\n        my $seqname;\n        \n        while (defined($_ = $io->_readline())) {\n            if ($_ =~ /^>(\\S+)/) {\n                $seqname = $1;\n                next;\n            }\n\n            if (defined($seqname) && ($_ =~ /^Sequence length = (\\d+)$/)) {\n                $seqlength{$seqname} = $1;\n                next;\n            }\n        }\n    }\n    \n    my $location_factory = Bio::Factory::FTLocationFactory->new();\n    \n    while(defined($_ = $self->_readline())) {\n        # Glimmer 3.X does provide a sequence identifier -\n        # beware whitespace at the end (comes through from\n        # the fasta file)\n        if ($_ =~ /^Putative Genes:$/) {\n            $source = 'Glimmer_2.X';\n            next;\n        }\n        # Glimmer 3.X sequence identifier\n        elsif ($_ =~ /^>(\\S+)/) {\n            $seqname = $1;\n            $seqlength = $seqlength{$seqname};\n            $source = 'Glimmer_3.X';\n            next;\n        }        \n        elsif (\n               # Glimmer 2.X prediction \n               (/^\\s+(\\d+)\\s+      # gene num\n                (\\d+)\\s+(\\d+)\\s+   # start, end\n                \\[([\\+\\-])(\\d{1})\\s+ # strand, frame\n                /ox ) ||\n               # Glimmer 3.X prediction\n               (/^[^\\d]+(\\d+)\\s+    # orf (numeric portion)\n                (\\d+)\\s+(\\d+)\\s+   # start, end\n                ([\\+\\-])(\\d{1})\\s+   # strand, frame\n                ([\\d\\.]+)          # score\n                /ox)) {\n\t    my ($genenum,$start,$end,$strand,$frame,$score) = \n\t\t( $1,$2,$3,$4,$5,$6 );\n\n            my $circular_prediction = 0;\n\n            # Check for a circular prediction before we\n            # start fiddling with the coordinates\n            if ($strand eq '+') {\n                if ($start > $end) {\n                    $circular_prediction = 1;\n                }\n            }\n            else {\n                if ($start < $end) {\n                    $circular_prediction = 1;\n                }\n            }\n\n            if ($circular_prediction) {\n                unless (defined($seqlength)) {\n                    $self->throw(\"need to know the sequence length to handle wraparound genes\");\n                }\n            }\n            \n            # Glimmer 2.X predictions do not include\n            # the stop codon - this might extend the\n            # prediction off either end of the sequence.\n            # This works fine even on circular/wraparound\n            # predictions.  \n            if ($source eq 'Glimmer_2.X') {\n                if ($strand eq '+') { \n                    $end += 3;\n                }\n                else {\n                    $end -= 3;\n                }\n            }\n\n            # We might have extended a Glimmer 2.X prediction\n            # beyond the boundaries of the input sequence.\n            # Also, Glimmer 3.X (with -X) will output predictions\n            # with coordinates less than 1 or greater than the\n            # length of the sequence.\n            my ($fst, $fend);\n            foreach my $coord ($start, $end) {\n                if ($coord < 1) {\n                    $coord = '<1';\n                    $fst++;\n                } elsif (defined($seqlength) && ($coord > $seqlength)) {\n                    $coord = \">$seqlength\";\n                    $fend++;\n                }\n            }\n            \n            my $location_string;\n\n            if ($circular_prediction) {\n                if ($strand eq '+') {\n                    $location_string = \"join($start..$seqlength,1..$end)\";\n                }\n                else {\n                    $location_string = \"join($start..1,$seqlength..$end)\";\n                }\n                }\n            else {\n                # start must always be less than end for gene locations\n                if ($strand eq '-' && !$fst && !$fend && $start > $end) {\n                    ($start, $end) = ($end, $start);\n                }\n                $location_string = \"$start..$end\";\n            }\n            \n            my $location_object =\n                $location_factory->from_string($location_string);\n            \n            # convert glimmer's frame range from 1-3 to SeqFeature's 0-2.\n            $frame--;\n            \n            my $gene = Bio::SeqFeature::Generic->new\n                (\n                 '-seq_id'      => $seqname,\n                 '-location'   => $location_object,\n                 '-strand'     => $strand eq '-' ? '-1' : '1',\n                 '-frame'\t\t=> $frame,\n                 '-source_tag'  => $source,\n                 '-display_name' => \"orf$genenum\",\n                 '-primary_tag'=> 'gene',\n                 '-tag'         => { 'Group' => \"GenePrediction_$genenum\"},\n                 '-score'       => $score || undef\n             );\n            \n            $self->_add_prediction($gene) \n\t}\n    }\n    \n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : "},"range":{"end":{"line":596,"character":9999},"start":{"line":593,"character":0}},"kind":12,"line":593,"detail":"($self)","definition":"sub","name":"_prediction","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"_prediction","kind":13,"line":594,"definition":"my"},{"kind":13,"containerName":"_prediction","name":"$self","line":596},{"line":596,"name":"$self","containerName":"_prediction","kind":13}]},{"line":597,"kind":13,"containerName":null,"name":"%self"},{"name":"_add_prediction","containerName":"main::","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_add_prediction","name":"$self","line":611},{"name":"$gene","kind":13,"containerName":"_add_prediction","line":611},{"line":613,"kind":13,"containerName":"_add_prediction","name":"$self"},{"name":"$self","containerName":"_add_prediction","kind":13,"line":614},{"kind":13,"containerName":"_add_prediction","name":"$self","line":616}],"detail":"($self,$gene)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":610},"end":{"line":616,"character":9999}},"line":610,"signature":{"label":"_add_prediction($self,$gene)","documentation":"1;\n# $Id: Glimmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Glimmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Glimmer - parser for Glimmer 2.X/3.X prokaryotic and \nGlimmerM/GlimmerHMM eukaryotic gene predictions\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Glimmer;\n\n   # file\n   my $parser = Bio::Tools::Glimmer->new(-file => $file);\n   # filehandle:\n   $parser = Bio::Tools::Glimmer->new( -fh  => \\*INPUT );\n   # provide a sequence identifier (Glimmer 2.X)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -seqname => seqname);\n   # force format (override automatic detection)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -format => 'GlimmerM');\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $glimmer->next_feature() is the same\n\n   while(my $gene = $parser->next_prediction()) {\n       # For eukaryotic input (GlimmerM/GlimmerHMM), $gene will be an instance\n       # of Bio::Tools::Prediction::Gene, which inherits off\n       # Bio::SeqFeature::Gene::Transcript, and $gene->exons() will return an\n       # array of Bio::Tools::Prediction::Exon objects.\n       # For prokaryotic input (Glimmer2.X/Glimmer3.X), $gene will be an\n       # instance of Bio::SeqFeature::Generic\n\n       # all exons (eukaryotic only):\n       @exon_arr = $gene->exons();\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n   }\n\n=head1 DESCRIPTION\n\nThis is a module for parsing Glimmer, GlimmerM and GlimmerHMM predictions.  \nIt will create gene objects from the prediction report which can \nbe attached to a sequence using Bioperl objects, or output as GFF \nsuitable for loading into Bio::DB::GFF for use with Gbrowse.\n\nGlimmer is open source and available at\nL<http://www.cbcb.umd.edu/software/glimmer/>.\n\nGlimmerM is open source and available at \nL<http://www.tigr.org/software/glimmerm/>.\n\nGlimmerHMM is open source and available at\nL<http://www.cbcb.umd.edu/software/GlimmerHMM/>.\n\nNote that Glimmer 2.X will only process the first\nsequence in a fasta file, and the prediction report does not contain any\nsort of sequence identifier\n\nNote that Glimmer 3.X produces two output files.  This module only parses\nthe .predict file.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann\n\nMark Johnson\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Glimmer;\nuse strict;\n\nuse Bio::Factory::FTLocationFactory;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    $self->{'_preds_parsed'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Glimmer->new();\n Function: Builds a new Bio::Tools::Glimmer object \n Returns : an instance of Bio::Tools::Glimmer\n Args    : format ('Glimmer', 'GlimmerM', 'GlimmerHMM'), seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($format, $seqname, $seqlength, $detail) =\n      $self->_rearrange([qw(FORMAT SEQNAME SEQLENGTH DETAIL)], @args);\n\n  # override automagic format detection\n  if (defined($format) &&\n      (($format eq 'Glimmer')  ||\n       ($format eq 'GlimmerM') ||\n       ($format eq 'GlimmerHMM'))\n  ) {\n      $self->_format($format);\n  }\n  \n  if (defined($detail)) {\n      $self->_format('Glimmer');\n      $self->_detail_file($detail);\n  }\n  \n  # hardwire seq_id when creating gene and exon objects (Glimmer 2.X)\n  $self->_seqname($seqname) if defined($seqname);\n  \n  # store the length of the input sequence (Glimmer 2.X)\n  $self->_seqlength($seqlength) if defined($seqlength);\n  \n  return $self;\n}\n\n=head2 analysis_method\n\n Usage     : $glimmer->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /glimmer/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /glimmer/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $glimmer->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $glimmer->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n    \n    # get next gene structure\n    $gene = $self->_prediction();\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n\n    my ($self) = @_;\n\n    \n    my %method = (\n                  'Glimmer'    => '_parse_prokaryotic',\n                  'GlimmerM'   => '_parse_eukaryotic',\n                  'GlimmerHMM' => '_parse_eukaryotic',\n                  '_DEFAULT_'  => '_parse_eukaryotic',\n              );\n    \n    my $format = $self->_format();\n    \n    if (!$format) {\n        \n        while (my $line = $self->_readline()) {\n\n            if ( $line =~ /^Glimmer\\S*\\s+\\(Version\\s*\\S+\\)/ ) {\n                $format = 'GlimmerM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ( $line =~ /^Glimmer\\S*$/ ) {\n                $format = 'GlimmerHMM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^Putative Genes:$/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^>(\\S+)/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            \n        }\n        \n    }\n\n    my $method =\n        (exists($method{$format})) ? $method{$format} : $method{'_DEFAULT_'};\n\n    return $self->$method();\n    \n}\n\n\n=head2 _parse_eukaryotic\n\n Title   : _parse_eukaryotic()\n Usage   : $obj->_parse_eukaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_eukaryotic {\n    my ($self) = @_;\n\n    my ($gene,$seqname,$seqlen,$source,$lastgenenum);\n    \n    while(defined($_ = $self->_readline())) {\n\tif( /^(Glimmer\\S*)\\s+\\(Version\\s*(\\S+)\\)/ ) {\n\t    $source = \"$1_$2\";\n\t    next;\n\t} elsif( /^(GlimmerHMM\\S*)$/ ) { # GlimmerHMM has no version\n\t    $source = $1;\n\t    next;\n\t} elsif(/^Sequence name:\\s+(.+)$/ ) {\n\t    $seqname = $1;\n\t    next;\n\t} elsif( /^Sequence length:\\s+(\\S+)/ ) {\n\t    $seqlen = $1;\n\t    next;\n\t} elsif( m/^(Predicted genes)|(Gene)|\\s+\\#/ || /^\\s+$/ ) { \n\t    next;\n\t    \n\t} elsif( # GlimmerM/HMM gene-exon prediction line\n\t\t /^\\s+(\\d+)\\s+ # gene num\n\t\t (\\d+)\\s+      # exon num\n\t\t ([\\+\\-])\\s+   # strand\n\t\t (\\S+)\\s+      # exon type\n\t\t (\\d+)\\s+(\\d+) # exon start, end\n\t\t \\s+(\\d+)      # exon length\t\t \n\t\t /ox ) {\n\t    my ($genenum,$exonnum,$strand,$type,$start,$end,$len) = \n\t\t( $1,$2,$3,$4,$5,$6,$7);\n\t    if( ! $lastgenenum || $lastgenenum != $genenum) {\t\t\n\t\t$self->_add_prediction($gene) if ( $gene );\n\t\t$gene = Bio::Tools::Prediction::Gene->new\n\t\t    (\n\t\t     '-seq_id'      => $seqname,\n\t\t     '-primary_tag' => \"gene\",\n\t\t     '-source_tag'  => $source,\n\t\t     '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t     );\n\t    }\n\t    my $exon = Bio::Tools::Prediction::Exon->new\n\t\t('-seq_id'     => $seqname,\n\t\t '-start'      => $start,\n\t\t '-end'        => $end,\n\t\t '-strand'     => $strand eq '-' ? '-1' : '1',\n\t\t '-source_tag' => $source,\n\t\t '-primary_tag'=> 'exon',\n\t\t '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t );\n\t    $gene->add_exon($exon,lc($type));\n\t    $lastgenenum = $genenum;\n\t}\n    }\n    $self->_add_prediction($gene) if( $gene );\n    $self->_predictions_parsed(1);\n}\n\n=head2 _parse_prokaryotic\n\n Title   : _parse_prokaryotic()\n Usage   : $obj->_parse_prokaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_prokaryotic {\n    my ($self) = @_;\n\n    # default value, possibly overriden later\n    my $source = 'Glimmer';\n\n    # Store the sequence length(s) here, either from the\n    # seqlength arg to the constructor, or from the\n    # Glimmer 3.X detail file\n    my %seqlength = ( );\n    \n    # Glimmer 2.X does not provide a sequence identifer\n    # in the prediction report (will default to unknown\n    # if not specified in the seqname arg to the\n    # constructor\n    #\n    # Glimmer 2.X does not report the length of the\n    # input sequence, either (will default to undef\n    # if not specified in the seqlength arg to the\n    # constructor\n    my $seqname = $self->_seqname();\n    my $seqlength = $self->_seqlength();\n\n    if (defined($seqlength)) {\n        $seqlength{$seqname} = $seqlength\n    }\n\n    # Parse the detail file, if we have one (Glimmer 3.X)\n    my $detail_file = $self->_detail_file();\n    \n    if (defined($detail_file)) {\n\n        my $io = Bio::Root::IO->new(-file => $detail_file);\n        my $seqname;\n        \n        while (defined($_ = $io->_readline())) {\n            if ($_ =~ /^>(\\S+)/) {\n                $seqname = $1;\n                next;\n            }\n\n            if (defined($seqname) && ($_ =~ /^Sequence length = (\\d+)$/)) {\n                $seqlength{$seqname} = $1;\n                next;\n            }\n        }\n    }\n    \n    my $location_factory = Bio::Factory::FTLocationFactory->new();\n    \n    while(defined($_ = $self->_readline())) {\n        # Glimmer 3.X does provide a sequence identifier -\n        # beware whitespace at the end (comes through from\n        # the fasta file)\n        if ($_ =~ /^Putative Genes:$/) {\n            $source = 'Glimmer_2.X';\n            next;\n        }\n        # Glimmer 3.X sequence identifier\n        elsif ($_ =~ /^>(\\S+)/) {\n            $seqname = $1;\n            $seqlength = $seqlength{$seqname};\n            $source = 'Glimmer_3.X';\n            next;\n        }        \n        elsif (\n               # Glimmer 2.X prediction \n               (/^\\s+(\\d+)\\s+      # gene num\n                (\\d+)\\s+(\\d+)\\s+   # start, end\n                \\[([\\+\\-])(\\d{1})\\s+ # strand, frame\n                /ox ) ||\n               # Glimmer 3.X prediction\n               (/^[^\\d]+(\\d+)\\s+    # orf (numeric portion)\n                (\\d+)\\s+(\\d+)\\s+   # start, end\n                ([\\+\\-])(\\d{1})\\s+   # strand, frame\n                ([\\d\\.]+)          # score\n                /ox)) {\n\t    my ($genenum,$start,$end,$strand,$frame,$score) = \n\t\t( $1,$2,$3,$4,$5,$6 );\n\n            my $circular_prediction = 0;\n\n            # Check for a circular prediction before we\n            # start fiddling with the coordinates\n            if ($strand eq '+') {\n                if ($start > $end) {\n                    $circular_prediction = 1;\n                }\n            }\n            else {\n                if ($start < $end) {\n                    $circular_prediction = 1;\n                }\n            }\n\n            if ($circular_prediction) {\n                unless (defined($seqlength)) {\n                    $self->throw(\"need to know the sequence length to handle wraparound genes\");\n                }\n            }\n            \n            # Glimmer 2.X predictions do not include\n            # the stop codon - this might extend the\n            # prediction off either end of the sequence.\n            # This works fine even on circular/wraparound\n            # predictions.  \n            if ($source eq 'Glimmer_2.X') {\n                if ($strand eq '+') { \n                    $end += 3;\n                }\n                else {\n                    $end -= 3;\n                }\n            }\n\n            # We might have extended a Glimmer 2.X prediction\n            # beyond the boundaries of the input sequence.\n            # Also, Glimmer 3.X (with -X) will output predictions\n            # with coordinates less than 1 or greater than the\n            # length of the sequence.\n            my ($fst, $fend);\n            foreach my $coord ($start, $end) {\n                if ($coord < 1) {\n                    $coord = '<1';\n                    $fst++;\n                } elsif (defined($seqlength) && ($coord > $seqlength)) {\n                    $coord = \">$seqlength\";\n                    $fend++;\n                }\n            }\n            \n            my $location_string;\n\n            if ($circular_prediction) {\n                if ($strand eq '+') {\n                    $location_string = \"join($start..$seqlength,1..$end)\";\n                }\n                else {\n                    $location_string = \"join($start..1,$seqlength..$end)\";\n                }\n                }\n            else {\n                # start must always be less than end for gene locations\n                if ($strand eq '-' && !$fst && !$fend && $start > $end) {\n                    ($start, $end) = ($end, $start);\n                }\n                $location_string = \"$start..$end\";\n            }\n            \n            my $location_object =\n                $location_factory->from_string($location_string);\n            \n            # convert glimmer's frame range from 1-3 to SeqFeature's 0-2.\n            $frame--;\n            \n            my $gene = Bio::SeqFeature::Generic->new\n                (\n                 '-seq_id'      => $seqname,\n                 '-location'   => $location_object,\n                 '-strand'     => $strand eq '-' ? '-1' : '1',\n                 '-frame'\t\t=> $frame,\n                 '-source_tag'  => $source,\n                 '-display_name' => \"orf$genenum\",\n                 '-primary_tag'=> 'gene',\n                 '-tag'         => { 'Group' => \"GenePrediction_$genenum\"},\n                 '-score'       => $score || undef\n             );\n            \n            $self->_add_prediction($gene) \n\t}\n    }\n    \n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : \n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_preds'}) && @{$self->{'_preds'}});\n    return shift(@{$self->{'_preds'}});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns : ","parameters":[{"label":"$self"},{"label":"$gene"}]}},{"line":616,"name":"$gene","kind":13,"containerName":null},{"signature":{"label":"_predictions_parsed($self,$val)","documentation":"1;\n# $Id: Glimmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Glimmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Glimmer - parser for Glimmer 2.X/3.X prokaryotic and \nGlimmerM/GlimmerHMM eukaryotic gene predictions\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Glimmer;\n\n   # file\n   my $parser = Bio::Tools::Glimmer->new(-file => $file);\n   # filehandle:\n   $parser = Bio::Tools::Glimmer->new( -fh  => \\*INPUT );\n   # provide a sequence identifier (Glimmer 2.X)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -seqname => seqname);\n   # force format (override automatic detection)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -format => 'GlimmerM');\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $glimmer->next_feature() is the same\n\n   while(my $gene = $parser->next_prediction()) {\n       # For eukaryotic input (GlimmerM/GlimmerHMM), $gene will be an instance\n       # of Bio::Tools::Prediction::Gene, which inherits off\n       # Bio::SeqFeature::Gene::Transcript, and $gene->exons() will return an\n       # array of Bio::Tools::Prediction::Exon objects.\n       # For prokaryotic input (Glimmer2.X/Glimmer3.X), $gene will be an\n       # instance of Bio::SeqFeature::Generic\n\n       # all exons (eukaryotic only):\n       @exon_arr = $gene->exons();\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n   }\n\n=head1 DESCRIPTION\n\nThis is a module for parsing Glimmer, GlimmerM and GlimmerHMM predictions.  \nIt will create gene objects from the prediction report which can \nbe attached to a sequence using Bioperl objects, or output as GFF \nsuitable for loading into Bio::DB::GFF for use with Gbrowse.\n\nGlimmer is open source and available at\nL<http://www.cbcb.umd.edu/software/glimmer/>.\n\nGlimmerM is open source and available at \nL<http://www.tigr.org/software/glimmerm/>.\n\nGlimmerHMM is open source and available at\nL<http://www.cbcb.umd.edu/software/GlimmerHMM/>.\n\nNote that Glimmer 2.X will only process the first\nsequence in a fasta file, and the prediction report does not contain any\nsort of sequence identifier\n\nNote that Glimmer 3.X produces two output files.  This module only parses\nthe .predict file.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann\n\nMark Johnson\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Glimmer;\nuse strict;\n\nuse Bio::Factory::FTLocationFactory;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    $self->{'_preds_parsed'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Glimmer->new();\n Function: Builds a new Bio::Tools::Glimmer object \n Returns : an instance of Bio::Tools::Glimmer\n Args    : format ('Glimmer', 'GlimmerM', 'GlimmerHMM'), seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($format, $seqname, $seqlength, $detail) =\n      $self->_rearrange([qw(FORMAT SEQNAME SEQLENGTH DETAIL)], @args);\n\n  # override automagic format detection\n  if (defined($format) &&\n      (($format eq 'Glimmer')  ||\n       ($format eq 'GlimmerM') ||\n       ($format eq 'GlimmerHMM'))\n  ) {\n      $self->_format($format);\n  }\n  \n  if (defined($detail)) {\n      $self->_format('Glimmer');\n      $self->_detail_file($detail);\n  }\n  \n  # hardwire seq_id when creating gene and exon objects (Glimmer 2.X)\n  $self->_seqname($seqname) if defined($seqname);\n  \n  # store the length of the input sequence (Glimmer 2.X)\n  $self->_seqlength($seqlength) if defined($seqlength);\n  \n  return $self;\n}\n\n=head2 analysis_method\n\n Usage     : $glimmer->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /glimmer/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /glimmer/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $glimmer->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $glimmer->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n    \n    # get next gene structure\n    $gene = $self->_prediction();\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n\n    my ($self) = @_;\n\n    \n    my %method = (\n                  'Glimmer'    => '_parse_prokaryotic',\n                  'GlimmerM'   => '_parse_eukaryotic',\n                  'GlimmerHMM' => '_parse_eukaryotic',\n                  '_DEFAULT_'  => '_parse_eukaryotic',\n              );\n    \n    my $format = $self->_format();\n    \n    if (!$format) {\n        \n        while (my $line = $self->_readline()) {\n\n            if ( $line =~ /^Glimmer\\S*\\s+\\(Version\\s*\\S+\\)/ ) {\n                $format = 'GlimmerM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ( $line =~ /^Glimmer\\S*$/ ) {\n                $format = 'GlimmerHMM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^Putative Genes:$/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^>(\\S+)/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            \n        }\n        \n    }\n\n    my $method =\n        (exists($method{$format})) ? $method{$format} : $method{'_DEFAULT_'};\n\n    return $self->$method();\n    \n}\n\n\n=head2 _parse_eukaryotic\n\n Title   : _parse_eukaryotic()\n Usage   : $obj->_parse_eukaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_eukaryotic {\n    my ($self) = @_;\n\n    my ($gene,$seqname,$seqlen,$source,$lastgenenum);\n    \n    while(defined($_ = $self->_readline())) {\n\tif( /^(Glimmer\\S*)\\s+\\(Version\\s*(\\S+)\\)/ ) {\n\t    $source = \"$1_$2\";\n\t    next;\n\t} elsif( /^(GlimmerHMM\\S*)$/ ) { # GlimmerHMM has no version\n\t    $source = $1;\n\t    next;\n\t} elsif(/^Sequence name:\\s+(.+)$/ ) {\n\t    $seqname = $1;\n\t    next;\n\t} elsif( /^Sequence length:\\s+(\\S+)/ ) {\n\t    $seqlen = $1;\n\t    next;\n\t} elsif( m/^(Predicted genes)|(Gene)|\\s+\\#/ || /^\\s+$/ ) { \n\t    next;\n\t    \n\t} elsif( # GlimmerM/HMM gene-exon prediction line\n\t\t /^\\s+(\\d+)\\s+ # gene num\n\t\t (\\d+)\\s+      # exon num\n\t\t ([\\+\\-])\\s+   # strand\n\t\t (\\S+)\\s+      # exon type\n\t\t (\\d+)\\s+(\\d+) # exon start, end\n\t\t \\s+(\\d+)      # exon length\t\t \n\t\t /ox ) {\n\t    my ($genenum,$exonnum,$strand,$type,$start,$end,$len) = \n\t\t( $1,$2,$3,$4,$5,$6,$7);\n\t    if( ! $lastgenenum || $lastgenenum != $genenum) {\t\t\n\t\t$self->_add_prediction($gene) if ( $gene );\n\t\t$gene = Bio::Tools::Prediction::Gene->new\n\t\t    (\n\t\t     '-seq_id'      => $seqname,\n\t\t     '-primary_tag' => \"gene\",\n\t\t     '-source_tag'  => $source,\n\t\t     '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t     );\n\t    }\n\t    my $exon = Bio::Tools::Prediction::Exon->new\n\t\t('-seq_id'     => $seqname,\n\t\t '-start'      => $start,\n\t\t '-end'        => $end,\n\t\t '-strand'     => $strand eq '-' ? '-1' : '1',\n\t\t '-source_tag' => $source,\n\t\t '-primary_tag'=> 'exon',\n\t\t '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t );\n\t    $gene->add_exon($exon,lc($type));\n\t    $lastgenenum = $genenum;\n\t}\n    }\n    $self->_add_prediction($gene) if( $gene );\n    $self->_predictions_parsed(1);\n}\n\n=head2 _parse_prokaryotic\n\n Title   : _parse_prokaryotic()\n Usage   : $obj->_parse_prokaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_prokaryotic {\n    my ($self) = @_;\n\n    # default value, possibly overriden later\n    my $source = 'Glimmer';\n\n    # Store the sequence length(s) here, either from the\n    # seqlength arg to the constructor, or from the\n    # Glimmer 3.X detail file\n    my %seqlength = ( );\n    \n    # Glimmer 2.X does not provide a sequence identifer\n    # in the prediction report (will default to unknown\n    # if not specified in the seqname arg to the\n    # constructor\n    #\n    # Glimmer 2.X does not report the length of the\n    # input sequence, either (will default to undef\n    # if not specified in the seqlength arg to the\n    # constructor\n    my $seqname = $self->_seqname();\n    my $seqlength = $self->_seqlength();\n\n    if (defined($seqlength)) {\n        $seqlength{$seqname} = $seqlength\n    }\n\n    # Parse the detail file, if we have one (Glimmer 3.X)\n    my $detail_file = $self->_detail_file();\n    \n    if (defined($detail_file)) {\n\n        my $io = Bio::Root::IO->new(-file => $detail_file);\n        my $seqname;\n        \n        while (defined($_ = $io->_readline())) {\n            if ($_ =~ /^>(\\S+)/) {\n                $seqname = $1;\n                next;\n            }\n\n            if (defined($seqname) && ($_ =~ /^Sequence length = (\\d+)$/)) {\n                $seqlength{$seqname} = $1;\n                next;\n            }\n        }\n    }\n    \n    my $location_factory = Bio::Factory::FTLocationFactory->new();\n    \n    while(defined($_ = $self->_readline())) {\n        # Glimmer 3.X does provide a sequence identifier -\n        # beware whitespace at the end (comes through from\n        # the fasta file)\n        if ($_ =~ /^Putative Genes:$/) {\n            $source = 'Glimmer_2.X';\n            next;\n        }\n        # Glimmer 3.X sequence identifier\n        elsif ($_ =~ /^>(\\S+)/) {\n            $seqname = $1;\n            $seqlength = $seqlength{$seqname};\n            $source = 'Glimmer_3.X';\n            next;\n        }        \n        elsif (\n               # Glimmer 2.X prediction \n               (/^\\s+(\\d+)\\s+      # gene num\n                (\\d+)\\s+(\\d+)\\s+   # start, end\n                \\[([\\+\\-])(\\d{1})\\s+ # strand, frame\n                /ox ) ||\n               # Glimmer 3.X prediction\n               (/^[^\\d]+(\\d+)\\s+    # orf (numeric portion)\n                (\\d+)\\s+(\\d+)\\s+   # start, end\n                ([\\+\\-])(\\d{1})\\s+   # strand, frame\n                ([\\d\\.]+)          # score\n                /ox)) {\n\t    my ($genenum,$start,$end,$strand,$frame,$score) = \n\t\t( $1,$2,$3,$4,$5,$6 );\n\n            my $circular_prediction = 0;\n\n            # Check for a circular prediction before we\n            # start fiddling with the coordinates\n            if ($strand eq '+') {\n                if ($start > $end) {\n                    $circular_prediction = 1;\n                }\n            }\n            else {\n                if ($start < $end) {\n                    $circular_prediction = 1;\n                }\n            }\n\n            if ($circular_prediction) {\n                unless (defined($seqlength)) {\n                    $self->throw(\"need to know the sequence length to handle wraparound genes\");\n                }\n            }\n            \n            # Glimmer 2.X predictions do not include\n            # the stop codon - this might extend the\n            # prediction off either end of the sequence.\n            # This works fine even on circular/wraparound\n            # predictions.  \n            if ($source eq 'Glimmer_2.X') {\n                if ($strand eq '+') { \n                    $end += 3;\n                }\n                else {\n                    $end -= 3;\n                }\n            }\n\n            # We might have extended a Glimmer 2.X prediction\n            # beyond the boundaries of the input sequence.\n            # Also, Glimmer 3.X (with -X) will output predictions\n            # with coordinates less than 1 or greater than the\n            # length of the sequence.\n            my ($fst, $fend);\n            foreach my $coord ($start, $end) {\n                if ($coord < 1) {\n                    $coord = '<1';\n                    $fst++;\n                } elsif (defined($seqlength) && ($coord > $seqlength)) {\n                    $coord = \">$seqlength\";\n                    $fend++;\n                }\n            }\n            \n            my $location_string;\n\n            if ($circular_prediction) {\n                if ($strand eq '+') {\n                    $location_string = \"join($start..$seqlength,1..$end)\";\n                }\n                else {\n                    $location_string = \"join($start..1,$seqlength..$end)\";\n                }\n                }\n            else {\n                # start must always be less than end for gene locations\n                if ($strand eq '-' && !$fst && !$fend && $start > $end) {\n                    ($start, $end) = ($end, $start);\n                }\n                $location_string = \"$start..$end\";\n            }\n            \n            my $location_object =\n                $location_factory->from_string($location_string);\n            \n            # convert glimmer's frame range from 1-3 to SeqFeature's 0-2.\n            $frame--;\n            \n            my $gene = Bio::SeqFeature::Generic->new\n                (\n                 '-seq_id'      => $seqname,\n                 '-location'   => $location_object,\n                 '-strand'     => $strand eq '-' ? '-1' : '1',\n                 '-frame'\t\t=> $frame,\n                 '-source_tag'  => $source,\n                 '-display_name' => \"orf$genenum\",\n                 '-primary_tag'=> 'gene',\n                 '-tag'         => { 'Group' => \"GenePrediction_$genenum\"},\n                 '-score'       => $score || undef\n             );\n            \n            $self->_add_prediction($gene) \n\t}\n    }\n    \n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : \n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_preds'}) && @{$self->{'_preds'}});\n    return shift(@{$self->{'_preds'}});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns : \n\n\nsub _add_prediction {\n    my ($self, $gene) = @_;\n\n    if(! exists($self->{'_preds'})) {\n\t$self->{'_preds'} = [];\n    }\n    push(@{$self->{'_preds'}}, $gene);\n}\n\n=head2 _predictions_parsed\n\n Title   : _predictions_parsed\n Usage   : $obj->_predictions_parsed\n Function: internal\n Example :\n Returns : TRUE or FALSE","parameters":[{"label":"$self"},{"label":"$val"}]},"kind":12,"range":{"end":{"line":637,"character":9999},"start":{"character":0,"line":629}},"line":629,"detail":"($self,$val)","definition":"sub","name":"_predictions_parsed","containerName":"main::","children":[{"line":630,"name":"$self","localvar":"my","kind":13,"containerName":"_predictions_parsed","definition":"my"},{"name":"$val","kind":13,"containerName":"_predictions_parsed","line":630},{"name":"$self","containerName":"_predictions_parsed","kind":13,"line":632},{"line":632,"name":"$val","kind":13,"containerName":"_predictions_parsed"},{"line":632,"name":"$val","kind":13,"containerName":"_predictions_parsed"},{"line":633,"name":"$self","kind":13,"containerName":"_predictions_parsed"},{"name":"$self","kind":13,"containerName":"_predictions_parsed","line":634},{"containerName":"_predictions_parsed","kind":13,"name":"$self","line":636}]},{"name":"_seqname","containerName":"main::","children":[{"line":650,"containerName":"_seqname","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":650,"containerName":"_seqname","kind":13,"name":"$val"},{"line":652,"kind":13,"containerName":"_seqname","name":"$self"},{"name":"$val","containerName":"_seqname","kind":13,"line":652},{"line":652,"name":"$val","kind":13,"containerName":"_seqname"},{"name":"$self","containerName":"_seqname","kind":13,"line":653},{"line":654,"name":"$self","containerName":"_seqname","kind":13},{"containerName":"_seqname","kind":13,"name":"$self","line":656}],"detail":"($self,$val)","definition":"sub","range":{"end":{"character":9999,"line":657},"start":{"line":649,"character":0}},"kind":12,"line":649,"signature":{"documentation":"1;\n# $Id: Glimmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Glimmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Glimmer - parser for Glimmer 2.X/3.X prokaryotic and \nGlimmerM/GlimmerHMM eukaryotic gene predictions\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Glimmer;\n\n   # file\n   my $parser = Bio::Tools::Glimmer->new(-file => $file);\n   # filehandle:\n   $parser = Bio::Tools::Glimmer->new( -fh  => \\*INPUT );\n   # provide a sequence identifier (Glimmer 2.X)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -seqname => seqname);\n   # force format (override automatic detection)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -format => 'GlimmerM');\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $glimmer->next_feature() is the same\n\n   while(my $gene = $parser->next_prediction()) {\n       # For eukaryotic input (GlimmerM/GlimmerHMM), $gene will be an instance\n       # of Bio::Tools::Prediction::Gene, which inherits off\n       # Bio::SeqFeature::Gene::Transcript, and $gene->exons() will return an\n       # array of Bio::Tools::Prediction::Exon objects.\n       # For prokaryotic input (Glimmer2.X/Glimmer3.X), $gene will be an\n       # instance of Bio::SeqFeature::Generic\n\n       # all exons (eukaryotic only):\n       @exon_arr = $gene->exons();\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n   }\n\n=head1 DESCRIPTION\n\nThis is a module for parsing Glimmer, GlimmerM and GlimmerHMM predictions.  \nIt will create gene objects from the prediction report which can \nbe attached to a sequence using Bioperl objects, or output as GFF \nsuitable for loading into Bio::DB::GFF for use with Gbrowse.\n\nGlimmer is open source and available at\nL<http://www.cbcb.umd.edu/software/glimmer/>.\n\nGlimmerM is open source and available at \nL<http://www.tigr.org/software/glimmerm/>.\n\nGlimmerHMM is open source and available at\nL<http://www.cbcb.umd.edu/software/GlimmerHMM/>.\n\nNote that Glimmer 2.X will only process the first\nsequence in a fasta file, and the prediction report does not contain any\nsort of sequence identifier\n\nNote that Glimmer 3.X produces two output files.  This module only parses\nthe .predict file.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann\n\nMark Johnson\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Glimmer;\nuse strict;\n\nuse Bio::Factory::FTLocationFactory;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    $self->{'_preds_parsed'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Glimmer->new();\n Function: Builds a new Bio::Tools::Glimmer object \n Returns : an instance of Bio::Tools::Glimmer\n Args    : format ('Glimmer', 'GlimmerM', 'GlimmerHMM'), seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($format, $seqname, $seqlength, $detail) =\n      $self->_rearrange([qw(FORMAT SEQNAME SEQLENGTH DETAIL)], @args);\n\n  # override automagic format detection\n  if (defined($format) &&\n      (($format eq 'Glimmer')  ||\n       ($format eq 'GlimmerM') ||\n       ($format eq 'GlimmerHMM'))\n  ) {\n      $self->_format($format);\n  }\n  \n  if (defined($detail)) {\n      $self->_format('Glimmer');\n      $self->_detail_file($detail);\n  }\n  \n  # hardwire seq_id when creating gene and exon objects (Glimmer 2.X)\n  $self->_seqname($seqname) if defined($seqname);\n  \n  # store the length of the input sequence (Glimmer 2.X)\n  $self->_seqlength($seqlength) if defined($seqlength);\n  \n  return $self;\n}\n\n=head2 analysis_method\n\n Usage     : $glimmer->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /glimmer/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /glimmer/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $glimmer->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $glimmer->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n    \n    # get next gene structure\n    $gene = $self->_prediction();\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n\n    my ($self) = @_;\n\n    \n    my %method = (\n                  'Glimmer'    => '_parse_prokaryotic',\n                  'GlimmerM'   => '_parse_eukaryotic',\n                  'GlimmerHMM' => '_parse_eukaryotic',\n                  '_DEFAULT_'  => '_parse_eukaryotic',\n              );\n    \n    my $format = $self->_format();\n    \n    if (!$format) {\n        \n        while (my $line = $self->_readline()) {\n\n            if ( $line =~ /^Glimmer\\S*\\s+\\(Version\\s*\\S+\\)/ ) {\n                $format = 'GlimmerM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ( $line =~ /^Glimmer\\S*$/ ) {\n                $format = 'GlimmerHMM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^Putative Genes:$/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^>(\\S+)/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            \n        }\n        \n    }\n\n    my $method =\n        (exists($method{$format})) ? $method{$format} : $method{'_DEFAULT_'};\n\n    return $self->$method();\n    \n}\n\n\n=head2 _parse_eukaryotic\n\n Title   : _parse_eukaryotic()\n Usage   : $obj->_parse_eukaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_eukaryotic {\n    my ($self) = @_;\n\n    my ($gene,$seqname,$seqlen,$source,$lastgenenum);\n    \n    while(defined($_ = $self->_readline())) {\n\tif( /^(Glimmer\\S*)\\s+\\(Version\\s*(\\S+)\\)/ ) {\n\t    $source = \"$1_$2\";\n\t    next;\n\t} elsif( /^(GlimmerHMM\\S*)$/ ) { # GlimmerHMM has no version\n\t    $source = $1;\n\t    next;\n\t} elsif(/^Sequence name:\\s+(.+)$/ ) {\n\t    $seqname = $1;\n\t    next;\n\t} elsif( /^Sequence length:\\s+(\\S+)/ ) {\n\t    $seqlen = $1;\n\t    next;\n\t} elsif( m/^(Predicted genes)|(Gene)|\\s+\\#/ || /^\\s+$/ ) { \n\t    next;\n\t    \n\t} elsif( # GlimmerM/HMM gene-exon prediction line\n\t\t /^\\s+(\\d+)\\s+ # gene num\n\t\t (\\d+)\\s+      # exon num\n\t\t ([\\+\\-])\\s+   # strand\n\t\t (\\S+)\\s+      # exon type\n\t\t (\\d+)\\s+(\\d+) # exon start, end\n\t\t \\s+(\\d+)      # exon length\t\t \n\t\t /ox ) {\n\t    my ($genenum,$exonnum,$strand,$type,$start,$end,$len) = \n\t\t( $1,$2,$3,$4,$5,$6,$7);\n\t    if( ! $lastgenenum || $lastgenenum != $genenum) {\t\t\n\t\t$self->_add_prediction($gene) if ( $gene );\n\t\t$gene = Bio::Tools::Prediction::Gene->new\n\t\t    (\n\t\t     '-seq_id'      => $seqname,\n\t\t     '-primary_tag' => \"gene\",\n\t\t     '-source_tag'  => $source,\n\t\t     '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t     );\n\t    }\n\t    my $exon = Bio::Tools::Prediction::Exon->new\n\t\t('-seq_id'     => $seqname,\n\t\t '-start'      => $start,\n\t\t '-end'        => $end,\n\t\t '-strand'     => $strand eq '-' ? '-1' : '1',\n\t\t '-source_tag' => $source,\n\t\t '-primary_tag'=> 'exon',\n\t\t '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t );\n\t    $gene->add_exon($exon,lc($type));\n\t    $lastgenenum = $genenum;\n\t}\n    }\n    $self->_add_prediction($gene) if( $gene );\n    $self->_predictions_parsed(1);\n}\n\n=head2 _parse_prokaryotic\n\n Title   : _parse_prokaryotic()\n Usage   : $obj->_parse_prokaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_prokaryotic {\n    my ($self) = @_;\n\n    # default value, possibly overriden later\n    my $source = 'Glimmer';\n\n    # Store the sequence length(s) here, either from the\n    # seqlength arg to the constructor, or from the\n    # Glimmer 3.X detail file\n    my %seqlength = ( );\n    \n    # Glimmer 2.X does not provide a sequence identifer\n    # in the prediction report (will default to unknown\n    # if not specified in the seqname arg to the\n    # constructor\n    #\n    # Glimmer 2.X does not report the length of the\n    # input sequence, either (will default to undef\n    # if not specified in the seqlength arg to the\n    # constructor\n    my $seqname = $self->_seqname();\n    my $seqlength = $self->_seqlength();\n\n    if (defined($seqlength)) {\n        $seqlength{$seqname} = $seqlength\n    }\n\n    # Parse the detail file, if we have one (Glimmer 3.X)\n    my $detail_file = $self->_detail_file();\n    \n    if (defined($detail_file)) {\n\n        my $io = Bio::Root::IO->new(-file => $detail_file);\n        my $seqname;\n        \n        while (defined($_ = $io->_readline())) {\n            if ($_ =~ /^>(\\S+)/) {\n                $seqname = $1;\n                next;\n            }\n\n            if (defined($seqname) && ($_ =~ /^Sequence length = (\\d+)$/)) {\n                $seqlength{$seqname} = $1;\n                next;\n            }\n        }\n    }\n    \n    my $location_factory = Bio::Factory::FTLocationFactory->new();\n    \n    while(defined($_ = $self->_readline())) {\n        # Glimmer 3.X does provide a sequence identifier -\n        # beware whitespace at the end (comes through from\n        # the fasta file)\n        if ($_ =~ /^Putative Genes:$/) {\n            $source = 'Glimmer_2.X';\n            next;\n        }\n        # Glimmer 3.X sequence identifier\n        elsif ($_ =~ /^>(\\S+)/) {\n            $seqname = $1;\n            $seqlength = $seqlength{$seqname};\n            $source = 'Glimmer_3.X';\n            next;\n        }        \n        elsif (\n               # Glimmer 2.X prediction \n               (/^\\s+(\\d+)\\s+      # gene num\n                (\\d+)\\s+(\\d+)\\s+   # start, end\n                \\[([\\+\\-])(\\d{1})\\s+ # strand, frame\n                /ox ) ||\n               # Glimmer 3.X prediction\n               (/^[^\\d]+(\\d+)\\s+    # orf (numeric portion)\n                (\\d+)\\s+(\\d+)\\s+   # start, end\n                ([\\+\\-])(\\d{1})\\s+   # strand, frame\n                ([\\d\\.]+)          # score\n                /ox)) {\n\t    my ($genenum,$start,$end,$strand,$frame,$score) = \n\t\t( $1,$2,$3,$4,$5,$6 );\n\n            my $circular_prediction = 0;\n\n            # Check for a circular prediction before we\n            # start fiddling with the coordinates\n            if ($strand eq '+') {\n                if ($start > $end) {\n                    $circular_prediction = 1;\n                }\n            }\n            else {\n                if ($start < $end) {\n                    $circular_prediction = 1;\n                }\n            }\n\n            if ($circular_prediction) {\n                unless (defined($seqlength)) {\n                    $self->throw(\"need to know the sequence length to handle wraparound genes\");\n                }\n            }\n            \n            # Glimmer 2.X predictions do not include\n            # the stop codon - this might extend the\n            # prediction off either end of the sequence.\n            # This works fine even on circular/wraparound\n            # predictions.  \n            if ($source eq 'Glimmer_2.X') {\n                if ($strand eq '+') { \n                    $end += 3;\n                }\n                else {\n                    $end -= 3;\n                }\n            }\n\n            # We might have extended a Glimmer 2.X prediction\n            # beyond the boundaries of the input sequence.\n            # Also, Glimmer 3.X (with -X) will output predictions\n            # with coordinates less than 1 or greater than the\n            # length of the sequence.\n            my ($fst, $fend);\n            foreach my $coord ($start, $end) {\n                if ($coord < 1) {\n                    $coord = '<1';\n                    $fst++;\n                } elsif (defined($seqlength) && ($coord > $seqlength)) {\n                    $coord = \">$seqlength\";\n                    $fend++;\n                }\n            }\n            \n            my $location_string;\n\n            if ($circular_prediction) {\n                if ($strand eq '+') {\n                    $location_string = \"join($start..$seqlength,1..$end)\";\n                }\n                else {\n                    $location_string = \"join($start..1,$seqlength..$end)\";\n                }\n                }\n            else {\n                # start must always be less than end for gene locations\n                if ($strand eq '-' && !$fst && !$fend && $start > $end) {\n                    ($start, $end) = ($end, $start);\n                }\n                $location_string = \"$start..$end\";\n            }\n            \n            my $location_object =\n                $location_factory->from_string($location_string);\n            \n            # convert glimmer's frame range from 1-3 to SeqFeature's 0-2.\n            $frame--;\n            \n            my $gene = Bio::SeqFeature::Generic->new\n                (\n                 '-seq_id'      => $seqname,\n                 '-location'   => $location_object,\n                 '-strand'     => $strand eq '-' ? '-1' : '1',\n                 '-frame'\t\t=> $frame,\n                 '-source_tag'  => $source,\n                 '-display_name' => \"orf$genenum\",\n                 '-primary_tag'=> 'gene',\n                 '-tag'         => { 'Group' => \"GenePrediction_$genenum\"},\n                 '-score'       => $score || undef\n             );\n            \n            $self->_add_prediction($gene) \n\t}\n    }\n    \n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : \n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_preds'}) && @{$self->{'_preds'}});\n    return shift(@{$self->{'_preds'}});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns : \n\n\nsub _add_prediction {\n    my ($self, $gene) = @_;\n\n    if(! exists($self->{'_preds'})) {\n\t$self->{'_preds'} = [];\n    }\n    push(@{$self->{'_preds'}}, $gene);\n}\n\n=head2 _predictions_parsed\n\n Title   : _predictions_parsed\n Usage   : $obj->_predictions_parsed\n Function: internal\n Example :\n Returns : TRUE or FALSE\n\n\nsub _predictions_parsed {\n    my ($self, $val) = @_;\n\n    $self->{'_preds_parsed'} = $val if $val;\n    if(! exists($self->{'_preds_parsed'})) {\n\t$self->{'_preds_parsed'} = 0;\n    }\n    return $self->{'_preds_parsed'};\n}\n\n=head2 _seqname\n\n Title   : _seqname\n Usage   : $obj->_seqname($seqname)\n Function: internal (for Glimmer 2.X)\n Example :\n Returns : String","parameters":[{"label":"$self"},{"label":"$val"}],"label":"_seqname($self,$val)"}},{"name":"_seqlength","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"_seqlength","kind":13,"name":"$self","line":670},{"line":670,"containerName":"_seqlength","kind":13,"name":"$val"},{"name":"$self","kind":13,"containerName":"_seqlength","line":672},{"containerName":"_seqlength","kind":13,"name":"$val","line":672},{"line":672,"name":"$val","kind":13,"containerName":"_seqlength"},{"kind":13,"containerName":"_seqlength","name":"$self","line":673}],"detail":"($self,$val)","definition":"sub","kind":12,"range":{"end":{"line":674,"character":9999},"start":{"line":669,"character":0}},"line":669,"signature":{"label":"_seqlength($self,$val)","parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: Glimmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Glimmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Glimmer - parser for Glimmer 2.X/3.X prokaryotic and \nGlimmerM/GlimmerHMM eukaryotic gene predictions\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Glimmer;\n\n   # file\n   my $parser = Bio::Tools::Glimmer->new(-file => $file);\n   # filehandle:\n   $parser = Bio::Tools::Glimmer->new( -fh  => \\*INPUT );\n   # provide a sequence identifier (Glimmer 2.X)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -seqname => seqname);\n   # force format (override automatic detection)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -format => 'GlimmerM');\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $glimmer->next_feature() is the same\n\n   while(my $gene = $parser->next_prediction()) {\n       # For eukaryotic input (GlimmerM/GlimmerHMM), $gene will be an instance\n       # of Bio::Tools::Prediction::Gene, which inherits off\n       # Bio::SeqFeature::Gene::Transcript, and $gene->exons() will return an\n       # array of Bio::Tools::Prediction::Exon objects.\n       # For prokaryotic input (Glimmer2.X/Glimmer3.X), $gene will be an\n       # instance of Bio::SeqFeature::Generic\n\n       # all exons (eukaryotic only):\n       @exon_arr = $gene->exons();\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n   }\n\n=head1 DESCRIPTION\n\nThis is a module for parsing Glimmer, GlimmerM and GlimmerHMM predictions.  \nIt will create gene objects from the prediction report which can \nbe attached to a sequence using Bioperl objects, or output as GFF \nsuitable for loading into Bio::DB::GFF for use with Gbrowse.\n\nGlimmer is open source and available at\nL<http://www.cbcb.umd.edu/software/glimmer/>.\n\nGlimmerM is open source and available at \nL<http://www.tigr.org/software/glimmerm/>.\n\nGlimmerHMM is open source and available at\nL<http://www.cbcb.umd.edu/software/GlimmerHMM/>.\n\nNote that Glimmer 2.X will only process the first\nsequence in a fasta file, and the prediction report does not contain any\nsort of sequence identifier\n\nNote that Glimmer 3.X produces two output files.  This module only parses\nthe .predict file.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann\n\nMark Johnson\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Glimmer;\nuse strict;\n\nuse Bio::Factory::FTLocationFactory;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    $self->{'_preds_parsed'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Glimmer->new();\n Function: Builds a new Bio::Tools::Glimmer object \n Returns : an instance of Bio::Tools::Glimmer\n Args    : format ('Glimmer', 'GlimmerM', 'GlimmerHMM'), seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($format, $seqname, $seqlength, $detail) =\n      $self->_rearrange([qw(FORMAT SEQNAME SEQLENGTH DETAIL)], @args);\n\n  # override automagic format detection\n  if (defined($format) &&\n      (($format eq 'Glimmer')  ||\n       ($format eq 'GlimmerM') ||\n       ($format eq 'GlimmerHMM'))\n  ) {\n      $self->_format($format);\n  }\n  \n  if (defined($detail)) {\n      $self->_format('Glimmer');\n      $self->_detail_file($detail);\n  }\n  \n  # hardwire seq_id when creating gene and exon objects (Glimmer 2.X)\n  $self->_seqname($seqname) if defined($seqname);\n  \n  # store the length of the input sequence (Glimmer 2.X)\n  $self->_seqlength($seqlength) if defined($seqlength);\n  \n  return $self;\n}\n\n=head2 analysis_method\n\n Usage     : $glimmer->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /glimmer/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /glimmer/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $glimmer->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $glimmer->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n    \n    # get next gene structure\n    $gene = $self->_prediction();\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n\n    my ($self) = @_;\n\n    \n    my %method = (\n                  'Glimmer'    => '_parse_prokaryotic',\n                  'GlimmerM'   => '_parse_eukaryotic',\n                  'GlimmerHMM' => '_parse_eukaryotic',\n                  '_DEFAULT_'  => '_parse_eukaryotic',\n              );\n    \n    my $format = $self->_format();\n    \n    if (!$format) {\n        \n        while (my $line = $self->_readline()) {\n\n            if ( $line =~ /^Glimmer\\S*\\s+\\(Version\\s*\\S+\\)/ ) {\n                $format = 'GlimmerM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ( $line =~ /^Glimmer\\S*$/ ) {\n                $format = 'GlimmerHMM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^Putative Genes:$/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^>(\\S+)/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            \n        }\n        \n    }\n\n    my $method =\n        (exists($method{$format})) ? $method{$format} : $method{'_DEFAULT_'};\n\n    return $self->$method();\n    \n}\n\n\n=head2 _parse_eukaryotic\n\n Title   : _parse_eukaryotic()\n Usage   : $obj->_parse_eukaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_eukaryotic {\n    my ($self) = @_;\n\n    my ($gene,$seqname,$seqlen,$source,$lastgenenum);\n    \n    while(defined($_ = $self->_readline())) {\n\tif( /^(Glimmer\\S*)\\s+\\(Version\\s*(\\S+)\\)/ ) {\n\t    $source = \"$1_$2\";\n\t    next;\n\t} elsif( /^(GlimmerHMM\\S*)$/ ) { # GlimmerHMM has no version\n\t    $source = $1;\n\t    next;\n\t} elsif(/^Sequence name:\\s+(.+)$/ ) {\n\t    $seqname = $1;\n\t    next;\n\t} elsif( /^Sequence length:\\s+(\\S+)/ ) {\n\t    $seqlen = $1;\n\t    next;\n\t} elsif( m/^(Predicted genes)|(Gene)|\\s+\\#/ || /^\\s+$/ ) { \n\t    next;\n\t    \n\t} elsif( # GlimmerM/HMM gene-exon prediction line\n\t\t /^\\s+(\\d+)\\s+ # gene num\n\t\t (\\d+)\\s+      # exon num\n\t\t ([\\+\\-])\\s+   # strand\n\t\t (\\S+)\\s+      # exon type\n\t\t (\\d+)\\s+(\\d+) # exon start, end\n\t\t \\s+(\\d+)      # exon length\t\t \n\t\t /ox ) {\n\t    my ($genenum,$exonnum,$strand,$type,$start,$end,$len) = \n\t\t( $1,$2,$3,$4,$5,$6,$7);\n\t    if( ! $lastgenenum || $lastgenenum != $genenum) {\t\t\n\t\t$self->_add_prediction($gene) if ( $gene );\n\t\t$gene = Bio::Tools::Prediction::Gene->new\n\t\t    (\n\t\t     '-seq_id'      => $seqname,\n\t\t     '-primary_tag' => \"gene\",\n\t\t     '-source_tag'  => $source,\n\t\t     '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t     );\n\t    }\n\t    my $exon = Bio::Tools::Prediction::Exon->new\n\t\t('-seq_id'     => $seqname,\n\t\t '-start'      => $start,\n\t\t '-end'        => $end,\n\t\t '-strand'     => $strand eq '-' ? '-1' : '1',\n\t\t '-source_tag' => $source,\n\t\t '-primary_tag'=> 'exon',\n\t\t '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t );\n\t    $gene->add_exon($exon,lc($type));\n\t    $lastgenenum = $genenum;\n\t}\n    }\n    $self->_add_prediction($gene) if( $gene );\n    $self->_predictions_parsed(1);\n}\n\n=head2 _parse_prokaryotic\n\n Title   : _parse_prokaryotic()\n Usage   : $obj->_parse_prokaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_prokaryotic {\n    my ($self) = @_;\n\n    # default value, possibly overriden later\n    my $source = 'Glimmer';\n\n    # Store the sequence length(s) here, either from the\n    # seqlength arg to the constructor, or from the\n    # Glimmer 3.X detail file\n    my %seqlength = ( );\n    \n    # Glimmer 2.X does not provide a sequence identifer\n    # in the prediction report (will default to unknown\n    # if not specified in the seqname arg to the\n    # constructor\n    #\n    # Glimmer 2.X does not report the length of the\n    # input sequence, either (will default to undef\n    # if not specified in the seqlength arg to the\n    # constructor\n    my $seqname = $self->_seqname();\n    my $seqlength = $self->_seqlength();\n\n    if (defined($seqlength)) {\n        $seqlength{$seqname} = $seqlength\n    }\n\n    # Parse the detail file, if we have one (Glimmer 3.X)\n    my $detail_file = $self->_detail_file();\n    \n    if (defined($detail_file)) {\n\n        my $io = Bio::Root::IO->new(-file => $detail_file);\n        my $seqname;\n        \n        while (defined($_ = $io->_readline())) {\n            if ($_ =~ /^>(\\S+)/) {\n                $seqname = $1;\n                next;\n            }\n\n            if (defined($seqname) && ($_ =~ /^Sequence length = (\\d+)$/)) {\n                $seqlength{$seqname} = $1;\n                next;\n            }\n        }\n    }\n    \n    my $location_factory = Bio::Factory::FTLocationFactory->new();\n    \n    while(defined($_ = $self->_readline())) {\n        # Glimmer 3.X does provide a sequence identifier -\n        # beware whitespace at the end (comes through from\n        # the fasta file)\n        if ($_ =~ /^Putative Genes:$/) {\n            $source = 'Glimmer_2.X';\n            next;\n        }\n        # Glimmer 3.X sequence identifier\n        elsif ($_ =~ /^>(\\S+)/) {\n            $seqname = $1;\n            $seqlength = $seqlength{$seqname};\n            $source = 'Glimmer_3.X';\n            next;\n        }        \n        elsif (\n               # Glimmer 2.X prediction \n               (/^\\s+(\\d+)\\s+      # gene num\n                (\\d+)\\s+(\\d+)\\s+   # start, end\n                \\[([\\+\\-])(\\d{1})\\s+ # strand, frame\n                /ox ) ||\n               # Glimmer 3.X prediction\n               (/^[^\\d]+(\\d+)\\s+    # orf (numeric portion)\n                (\\d+)\\s+(\\d+)\\s+   # start, end\n                ([\\+\\-])(\\d{1})\\s+   # strand, frame\n                ([\\d\\.]+)          # score\n                /ox)) {\n\t    my ($genenum,$start,$end,$strand,$frame,$score) = \n\t\t( $1,$2,$3,$4,$5,$6 );\n\n            my $circular_prediction = 0;\n\n            # Check for a circular prediction before we\n            # start fiddling with the coordinates\n            if ($strand eq '+') {\n                if ($start > $end) {\n                    $circular_prediction = 1;\n                }\n            }\n            else {\n                if ($start < $end) {\n                    $circular_prediction = 1;\n                }\n            }\n\n            if ($circular_prediction) {\n                unless (defined($seqlength)) {\n                    $self->throw(\"need to know the sequence length to handle wraparound genes\");\n                }\n            }\n            \n            # Glimmer 2.X predictions do not include\n            # the stop codon - this might extend the\n            # prediction off either end of the sequence.\n            # This works fine even on circular/wraparound\n            # predictions.  \n            if ($source eq 'Glimmer_2.X') {\n                if ($strand eq '+') { \n                    $end += 3;\n                }\n                else {\n                    $end -= 3;\n                }\n            }\n\n            # We might have extended a Glimmer 2.X prediction\n            # beyond the boundaries of the input sequence.\n            # Also, Glimmer 3.X (with -X) will output predictions\n            # with coordinates less than 1 or greater than the\n            # length of the sequence.\n            my ($fst, $fend);\n            foreach my $coord ($start, $end) {\n                if ($coord < 1) {\n                    $coord = '<1';\n                    $fst++;\n                } elsif (defined($seqlength) && ($coord > $seqlength)) {\n                    $coord = \">$seqlength\";\n                    $fend++;\n                }\n            }\n            \n            my $location_string;\n\n            if ($circular_prediction) {\n                if ($strand eq '+') {\n                    $location_string = \"join($start..$seqlength,1..$end)\";\n                }\n                else {\n                    $location_string = \"join($start..1,$seqlength..$end)\";\n                }\n                }\n            else {\n                # start must always be less than end for gene locations\n                if ($strand eq '-' && !$fst && !$fend && $start > $end) {\n                    ($start, $end) = ($end, $start);\n                }\n                $location_string = \"$start..$end\";\n            }\n            \n            my $location_object =\n                $location_factory->from_string($location_string);\n            \n            # convert glimmer's frame range from 1-3 to SeqFeature's 0-2.\n            $frame--;\n            \n            my $gene = Bio::SeqFeature::Generic->new\n                (\n                 '-seq_id'      => $seqname,\n                 '-location'   => $location_object,\n                 '-strand'     => $strand eq '-' ? '-1' : '1',\n                 '-frame'\t\t=> $frame,\n                 '-source_tag'  => $source,\n                 '-display_name' => \"orf$genenum\",\n                 '-primary_tag'=> 'gene',\n                 '-tag'         => { 'Group' => \"GenePrediction_$genenum\"},\n                 '-score'       => $score || undef\n             );\n            \n            $self->_add_prediction($gene) \n\t}\n    }\n    \n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : \n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_preds'}) && @{$self->{'_preds'}});\n    return shift(@{$self->{'_preds'}});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns : \n\n\nsub _add_prediction {\n    my ($self, $gene) = @_;\n\n    if(! exists($self->{'_preds'})) {\n\t$self->{'_preds'} = [];\n    }\n    push(@{$self->{'_preds'}}, $gene);\n}\n\n=head2 _predictions_parsed\n\n Title   : _predictions_parsed\n Usage   : $obj->_predictions_parsed\n Function: internal\n Example :\n Returns : TRUE or FALSE\n\n\nsub _predictions_parsed {\n    my ($self, $val) = @_;\n\n    $self->{'_preds_parsed'} = $val if $val;\n    if(! exists($self->{'_preds_parsed'})) {\n\t$self->{'_preds_parsed'} = 0;\n    }\n    return $self->{'_preds_parsed'};\n}\n\n=head2 _seqname\n\n Title   : _seqname\n Usage   : $obj->_seqname($seqname)\n Function: internal (for Glimmer 2.X)\n Example :\n Returns : String\n\n\nsub _seqname {\n    my ($self, $val) = @_;\n\n    $self->{'_seqname'} = $val if $val;\n    if(! exists($self->{'_seqname'})) {\n\t$self->{'_seqname'} = 'unknown';\n    }\n    return $self->{'_seqname'};\n}\n\n=head2 _seqlength\n\n Title   : _seqlength\n Usage   : $obj->_seqlength($seqlength)\n Function: internal (for Glimmer 2.X)\n Example :\n Returns : String"}},{"signature":{"label":"_format($self,$val)","parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: Glimmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Glimmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Glimmer - parser for Glimmer 2.X/3.X prokaryotic and \nGlimmerM/GlimmerHMM eukaryotic gene predictions\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Glimmer;\n\n   # file\n   my $parser = Bio::Tools::Glimmer->new(-file => $file);\n   # filehandle:\n   $parser = Bio::Tools::Glimmer->new( -fh  => \\*INPUT );\n   # provide a sequence identifier (Glimmer 2.X)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -seqname => seqname);\n   # force format (override automatic detection)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -format => 'GlimmerM');\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $glimmer->next_feature() is the same\n\n   while(my $gene = $parser->next_prediction()) {\n       # For eukaryotic input (GlimmerM/GlimmerHMM), $gene will be an instance\n       # of Bio::Tools::Prediction::Gene, which inherits off\n       # Bio::SeqFeature::Gene::Transcript, and $gene->exons() will return an\n       # array of Bio::Tools::Prediction::Exon objects.\n       # For prokaryotic input (Glimmer2.X/Glimmer3.X), $gene will be an\n       # instance of Bio::SeqFeature::Generic\n\n       # all exons (eukaryotic only):\n       @exon_arr = $gene->exons();\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n   }\n\n=head1 DESCRIPTION\n\nThis is a module for parsing Glimmer, GlimmerM and GlimmerHMM predictions.  \nIt will create gene objects from the prediction report which can \nbe attached to a sequence using Bioperl objects, or output as GFF \nsuitable for loading into Bio::DB::GFF for use with Gbrowse.\n\nGlimmer is open source and available at\nL<http://www.cbcb.umd.edu/software/glimmer/>.\n\nGlimmerM is open source and available at \nL<http://www.tigr.org/software/glimmerm/>.\n\nGlimmerHMM is open source and available at\nL<http://www.cbcb.umd.edu/software/GlimmerHMM/>.\n\nNote that Glimmer 2.X will only process the first\nsequence in a fasta file, and the prediction report does not contain any\nsort of sequence identifier\n\nNote that Glimmer 3.X produces two output files.  This module only parses\nthe .predict file.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann\n\nMark Johnson\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Glimmer;\nuse strict;\n\nuse Bio::Factory::FTLocationFactory;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    $self->{'_preds_parsed'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Glimmer->new();\n Function: Builds a new Bio::Tools::Glimmer object \n Returns : an instance of Bio::Tools::Glimmer\n Args    : format ('Glimmer', 'GlimmerM', 'GlimmerHMM'), seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($format, $seqname, $seqlength, $detail) =\n      $self->_rearrange([qw(FORMAT SEQNAME SEQLENGTH DETAIL)], @args);\n\n  # override automagic format detection\n  if (defined($format) &&\n      (($format eq 'Glimmer')  ||\n       ($format eq 'GlimmerM') ||\n       ($format eq 'GlimmerHMM'))\n  ) {\n      $self->_format($format);\n  }\n  \n  if (defined($detail)) {\n      $self->_format('Glimmer');\n      $self->_detail_file($detail);\n  }\n  \n  # hardwire seq_id when creating gene and exon objects (Glimmer 2.X)\n  $self->_seqname($seqname) if defined($seqname);\n  \n  # store the length of the input sequence (Glimmer 2.X)\n  $self->_seqlength($seqlength) if defined($seqlength);\n  \n  return $self;\n}\n\n=head2 analysis_method\n\n Usage     : $glimmer->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /glimmer/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /glimmer/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $glimmer->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $glimmer->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n    \n    # get next gene structure\n    $gene = $self->_prediction();\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n\n    my ($self) = @_;\n\n    \n    my %method = (\n                  'Glimmer'    => '_parse_prokaryotic',\n                  'GlimmerM'   => '_parse_eukaryotic',\n                  'GlimmerHMM' => '_parse_eukaryotic',\n                  '_DEFAULT_'  => '_parse_eukaryotic',\n              );\n    \n    my $format = $self->_format();\n    \n    if (!$format) {\n        \n        while (my $line = $self->_readline()) {\n\n            if ( $line =~ /^Glimmer\\S*\\s+\\(Version\\s*\\S+\\)/ ) {\n                $format = 'GlimmerM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ( $line =~ /^Glimmer\\S*$/ ) {\n                $format = 'GlimmerHMM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^Putative Genes:$/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^>(\\S+)/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            \n        }\n        \n    }\n\n    my $method =\n        (exists($method{$format})) ? $method{$format} : $method{'_DEFAULT_'};\n\n    return $self->$method();\n    \n}\n\n\n=head2 _parse_eukaryotic\n\n Title   : _parse_eukaryotic()\n Usage   : $obj->_parse_eukaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_eukaryotic {\n    my ($self) = @_;\n\n    my ($gene,$seqname,$seqlen,$source,$lastgenenum);\n    \n    while(defined($_ = $self->_readline())) {\n\tif( /^(Glimmer\\S*)\\s+\\(Version\\s*(\\S+)\\)/ ) {\n\t    $source = \"$1_$2\";\n\t    next;\n\t} elsif( /^(GlimmerHMM\\S*)$/ ) { # GlimmerHMM has no version\n\t    $source = $1;\n\t    next;\n\t} elsif(/^Sequence name:\\s+(.+)$/ ) {\n\t    $seqname = $1;\n\t    next;\n\t} elsif( /^Sequence length:\\s+(\\S+)/ ) {\n\t    $seqlen = $1;\n\t    next;\n\t} elsif( m/^(Predicted genes)|(Gene)|\\s+\\#/ || /^\\s+$/ ) { \n\t    next;\n\t    \n\t} elsif( # GlimmerM/HMM gene-exon prediction line\n\t\t /^\\s+(\\d+)\\s+ # gene num\n\t\t (\\d+)\\s+      # exon num\n\t\t ([\\+\\-])\\s+   # strand\n\t\t (\\S+)\\s+      # exon type\n\t\t (\\d+)\\s+(\\d+) # exon start, end\n\t\t \\s+(\\d+)      # exon length\t\t \n\t\t /ox ) {\n\t    my ($genenum,$exonnum,$strand,$type,$start,$end,$len) = \n\t\t( $1,$2,$3,$4,$5,$6,$7);\n\t    if( ! $lastgenenum || $lastgenenum != $genenum) {\t\t\n\t\t$self->_add_prediction($gene) if ( $gene );\n\t\t$gene = Bio::Tools::Prediction::Gene->new\n\t\t    (\n\t\t     '-seq_id'      => $seqname,\n\t\t     '-primary_tag' => \"gene\",\n\t\t     '-source_tag'  => $source,\n\t\t     '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t     );\n\t    }\n\t    my $exon = Bio::Tools::Prediction::Exon->new\n\t\t('-seq_id'     => $seqname,\n\t\t '-start'      => $start,\n\t\t '-end'        => $end,\n\t\t '-strand'     => $strand eq '-' ? '-1' : '1',\n\t\t '-source_tag' => $source,\n\t\t '-primary_tag'=> 'exon',\n\t\t '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t );\n\t    $gene->add_exon($exon,lc($type));\n\t    $lastgenenum = $genenum;\n\t}\n    }\n    $self->_add_prediction($gene) if( $gene );\n    $self->_predictions_parsed(1);\n}\n\n=head2 _parse_prokaryotic\n\n Title   : _parse_prokaryotic()\n Usage   : $obj->_parse_prokaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_prokaryotic {\n    my ($self) = @_;\n\n    # default value, possibly overriden later\n    my $source = 'Glimmer';\n\n    # Store the sequence length(s) here, either from the\n    # seqlength arg to the constructor, or from the\n    # Glimmer 3.X detail file\n    my %seqlength = ( );\n    \n    # Glimmer 2.X does not provide a sequence identifer\n    # in the prediction report (will default to unknown\n    # if not specified in the seqname arg to the\n    # constructor\n    #\n    # Glimmer 2.X does not report the length of the\n    # input sequence, either (will default to undef\n    # if not specified in the seqlength arg to the\n    # constructor\n    my $seqname = $self->_seqname();\n    my $seqlength = $self->_seqlength();\n\n    if (defined($seqlength)) {\n        $seqlength{$seqname} = $seqlength\n    }\n\n    # Parse the detail file, if we have one (Glimmer 3.X)\n    my $detail_file = $self->_detail_file();\n    \n    if (defined($detail_file)) {\n\n        my $io = Bio::Root::IO->new(-file => $detail_file);\n        my $seqname;\n        \n        while (defined($_ = $io->_readline())) {\n            if ($_ =~ /^>(\\S+)/) {\n                $seqname = $1;\n                next;\n            }\n\n            if (defined($seqname) && ($_ =~ /^Sequence length = (\\d+)$/)) {\n                $seqlength{$seqname} = $1;\n                next;\n            }\n        }\n    }\n    \n    my $location_factory = Bio::Factory::FTLocationFactory->new();\n    \n    while(defined($_ = $self->_readline())) {\n        # Glimmer 3.X does provide a sequence identifier -\n        # beware whitespace at the end (comes through from\n        # the fasta file)\n        if ($_ =~ /^Putative Genes:$/) {\n            $source = 'Glimmer_2.X';\n            next;\n        }\n        # Glimmer 3.X sequence identifier\n        elsif ($_ =~ /^>(\\S+)/) {\n            $seqname = $1;\n            $seqlength = $seqlength{$seqname};\n            $source = 'Glimmer_3.X';\n            next;\n        }        \n        elsif (\n               # Glimmer 2.X prediction \n               (/^\\s+(\\d+)\\s+      # gene num\n                (\\d+)\\s+(\\d+)\\s+   # start, end\n                \\[([\\+\\-])(\\d{1})\\s+ # strand, frame\n                /ox ) ||\n               # Glimmer 3.X prediction\n               (/^[^\\d]+(\\d+)\\s+    # orf (numeric portion)\n                (\\d+)\\s+(\\d+)\\s+   # start, end\n                ([\\+\\-])(\\d{1})\\s+   # strand, frame\n                ([\\d\\.]+)          # score\n                /ox)) {\n\t    my ($genenum,$start,$end,$strand,$frame,$score) = \n\t\t( $1,$2,$3,$4,$5,$6 );\n\n            my $circular_prediction = 0;\n\n            # Check for a circular prediction before we\n            # start fiddling with the coordinates\n            if ($strand eq '+') {\n                if ($start > $end) {\n                    $circular_prediction = 1;\n                }\n            }\n            else {\n                if ($start < $end) {\n                    $circular_prediction = 1;\n                }\n            }\n\n            if ($circular_prediction) {\n                unless (defined($seqlength)) {\n                    $self->throw(\"need to know the sequence length to handle wraparound genes\");\n                }\n            }\n            \n            # Glimmer 2.X predictions do not include\n            # the stop codon - this might extend the\n            # prediction off either end of the sequence.\n            # This works fine even on circular/wraparound\n            # predictions.  \n            if ($source eq 'Glimmer_2.X') {\n                if ($strand eq '+') { \n                    $end += 3;\n                }\n                else {\n                    $end -= 3;\n                }\n            }\n\n            # We might have extended a Glimmer 2.X prediction\n            # beyond the boundaries of the input sequence.\n            # Also, Glimmer 3.X (with -X) will output predictions\n            # with coordinates less than 1 or greater than the\n            # length of the sequence.\n            my ($fst, $fend);\n            foreach my $coord ($start, $end) {\n                if ($coord < 1) {\n                    $coord = '<1';\n                    $fst++;\n                } elsif (defined($seqlength) && ($coord > $seqlength)) {\n                    $coord = \">$seqlength\";\n                    $fend++;\n                }\n            }\n            \n            my $location_string;\n\n            if ($circular_prediction) {\n                if ($strand eq '+') {\n                    $location_string = \"join($start..$seqlength,1..$end)\";\n                }\n                else {\n                    $location_string = \"join($start..1,$seqlength..$end)\";\n                }\n                }\n            else {\n                # start must always be less than end for gene locations\n                if ($strand eq '-' && !$fst && !$fend && $start > $end) {\n                    ($start, $end) = ($end, $start);\n                }\n                $location_string = \"$start..$end\";\n            }\n            \n            my $location_object =\n                $location_factory->from_string($location_string);\n            \n            # convert glimmer's frame range from 1-3 to SeqFeature's 0-2.\n            $frame--;\n            \n            my $gene = Bio::SeqFeature::Generic->new\n                (\n                 '-seq_id'      => $seqname,\n                 '-location'   => $location_object,\n                 '-strand'     => $strand eq '-' ? '-1' : '1',\n                 '-frame'\t\t=> $frame,\n                 '-source_tag'  => $source,\n                 '-display_name' => \"orf$genenum\",\n                 '-primary_tag'=> 'gene',\n                 '-tag'         => { 'Group' => \"GenePrediction_$genenum\"},\n                 '-score'       => $score || undef\n             );\n            \n            $self->_add_prediction($gene) \n\t}\n    }\n    \n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : \n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_preds'}) && @{$self->{'_preds'}});\n    return shift(@{$self->{'_preds'}});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns : \n\n\nsub _add_prediction {\n    my ($self, $gene) = @_;\n\n    if(! exists($self->{'_preds'})) {\n\t$self->{'_preds'} = [];\n    }\n    push(@{$self->{'_preds'}}, $gene);\n}\n\n=head2 _predictions_parsed\n\n Title   : _predictions_parsed\n Usage   : $obj->_predictions_parsed\n Function: internal\n Example :\n Returns : TRUE or FALSE\n\n\nsub _predictions_parsed {\n    my ($self, $val) = @_;\n\n    $self->{'_preds_parsed'} = $val if $val;\n    if(! exists($self->{'_preds_parsed'})) {\n\t$self->{'_preds_parsed'} = 0;\n    }\n    return $self->{'_preds_parsed'};\n}\n\n=head2 _seqname\n\n Title   : _seqname\n Usage   : $obj->_seqname($seqname)\n Function: internal (for Glimmer 2.X)\n Example :\n Returns : String\n\n\nsub _seqname {\n    my ($self, $val) = @_;\n\n    $self->{'_seqname'} = $val if $val;\n    if(! exists($self->{'_seqname'})) {\n\t$self->{'_seqname'} = 'unknown';\n    }\n    return $self->{'_seqname'};\n}\n\n=head2 _seqlength\n\n Title   : _seqlength\n Usage   : $obj->_seqlength($seqlength)\n Function: internal (for Glimmer 2.X)\n Example :\n Returns : String\n\n\nsub _seqlength {\n    my ($self, $val) = @_;\n\n    $self->{'_seqlength'} = $val if $val;\n    return $self->{'_seqlength'};\n}\n\n=head2 _format\n\n Title   : _format\n Usage   : $obj->_format($format)\n Function: internal\n Example :\n Returns : String"},"line":686,"range":{"start":{"character":0,"line":686},"end":{"line":692,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$val)","children":[{"line":687,"kind":13,"localvar":"my","containerName":"_format","name":"$self","definition":"my"},{"containerName":"_format","kind":13,"name":"$val","line":687},{"kind":13,"containerName":"_format","name":"$self","line":689},{"containerName":"_format","kind":13,"name":"$val","line":689},{"name":"$val","kind":13,"containerName":"_format","line":689},{"kind":13,"containerName":"_format","name":"$self","line":691}],"name":"_format","containerName":"main::"},{"definition":"sub","detail":"($self,$val)","children":[{"definition":"my","line":705,"name":"$self","localvar":"my","containerName":"_detail_file","kind":13},{"kind":13,"containerName":"_detail_file","name":"$val","line":705},{"name":"$self","kind":13,"containerName":"_detail_file","line":707},{"line":707,"name":"$val","containerName":"_detail_file","kind":13},{"kind":13,"containerName":"_detail_file","name":"$val","line":707},{"line":708,"kind":13,"containerName":"_detail_file","name":"$self"}],"name":"_detail_file","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: Glimmer.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Glimmer\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Glimmer - parser for Glimmer 2.X/3.X prokaryotic and \nGlimmerM/GlimmerHMM eukaryotic gene predictions\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Glimmer;\n\n   # file\n   my $parser = Bio::Tools::Glimmer->new(-file => $file);\n   # filehandle:\n   $parser = Bio::Tools::Glimmer->new( -fh  => \\*INPUT );\n   # provide a sequence identifier (Glimmer 2.X)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -seqname => seqname);\n   # force format (override automatic detection)\n   my $parser = Bio::Tools::Glimmer->new(-file => $file, -format => 'GlimmerM');\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $glimmer->next_feature() is the same\n\n   while(my $gene = $parser->next_prediction()) {\n       # For eukaryotic input (GlimmerM/GlimmerHMM), $gene will be an instance\n       # of Bio::Tools::Prediction::Gene, which inherits off\n       # Bio::SeqFeature::Gene::Transcript, and $gene->exons() will return an\n       # array of Bio::Tools::Prediction::Exon objects.\n       # For prokaryotic input (Glimmer2.X/Glimmer3.X), $gene will be an\n       # instance of Bio::SeqFeature::Generic\n\n       # all exons (eukaryotic only):\n       @exon_arr = $gene->exons();\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n   }\n\n=head1 DESCRIPTION\n\nThis is a module for parsing Glimmer, GlimmerM and GlimmerHMM predictions.  \nIt will create gene objects from the prediction report which can \nbe attached to a sequence using Bioperl objects, or output as GFF \nsuitable for loading into Bio::DB::GFF for use with Gbrowse.\n\nGlimmer is open source and available at\nL<http://www.cbcb.umd.edu/software/glimmer/>.\n\nGlimmerM is open source and available at \nL<http://www.tigr.org/software/glimmerm/>.\n\nGlimmerHMM is open source and available at\nL<http://www.cbcb.umd.edu/software/GlimmerHMM/>.\n\nNote that Glimmer 2.X will only process the first\nsequence in a fasta file, and the prediction report does not contain any\nsort of sequence identifier\n\nNote that Glimmer 3.X produces two output files.  This module only parses\nthe .predict file.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nTorsten Seemann\n\nMark Johnson\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Glimmer;\nuse strict;\n\nuse Bio::Factory::FTLocationFactory;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    $self->{'_preds_parsed'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Glimmer->new();\n Function: Builds a new Bio::Tools::Glimmer object \n Returns : an instance of Bio::Tools::Glimmer\n Args    : format ('Glimmer', 'GlimmerM', 'GlimmerHMM'), seqname\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($format, $seqname, $seqlength, $detail) =\n      $self->_rearrange([qw(FORMAT SEQNAME SEQLENGTH DETAIL)], @args);\n\n  # override automagic format detection\n  if (defined($format) &&\n      (($format eq 'Glimmer')  ||\n       ($format eq 'GlimmerM') ||\n       ($format eq 'GlimmerHMM'))\n  ) {\n      $self->_format($format);\n  }\n  \n  if (defined($detail)) {\n      $self->_format('Glimmer');\n      $self->_detail_file($detail);\n  }\n  \n  # hardwire seq_id when creating gene and exon objects (Glimmer 2.X)\n  $self->_seqname($seqname) if defined($seqname);\n  \n  # store the length of the input sequence (Glimmer 2.X)\n  $self->_seqlength($seqlength) if defined($seqlength);\n  \n  return $self;\n}\n\n=head2 analysis_method\n\n Usage     : $glimmer->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /glimmer/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /glimmer/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $glimmer->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $glimmer->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Glimmer result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n    \n    # get next gene structure\n    $gene = $self->_prediction();\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n\n    my ($self) = @_;\n\n    \n    my %method = (\n                  'Glimmer'    => '_parse_prokaryotic',\n                  'GlimmerM'   => '_parse_eukaryotic',\n                  'GlimmerHMM' => '_parse_eukaryotic',\n                  '_DEFAULT_'  => '_parse_eukaryotic',\n              );\n    \n    my $format = $self->_format();\n    \n    if (!$format) {\n        \n        while (my $line = $self->_readline()) {\n\n            if ( $line =~ /^Glimmer\\S*\\s+\\(Version\\s*\\S+\\)/ ) {\n                $format = 'GlimmerM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ( $line =~ /^Glimmer\\S*$/ ) {\n                $format = 'GlimmerHMM';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^Putative Genes:$/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            elsif ($line =~ /^>(\\S+)/) {\n                $format = 'Glimmer';\n                $self->_pushback($line);\n                last;\n            }\n            \n        }\n        \n    }\n\n    my $method =\n        (exists($method{$format})) ? $method{$format} : $method{'_DEFAULT_'};\n\n    return $self->$method();\n    \n}\n\n\n=head2 _parse_eukaryotic\n\n Title   : _parse_eukaryotic()\n Usage   : $obj->_parse_eukaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_eukaryotic {\n    my ($self) = @_;\n\n    my ($gene,$seqname,$seqlen,$source,$lastgenenum);\n    \n    while(defined($_ = $self->_readline())) {\n\tif( /^(Glimmer\\S*)\\s+\\(Version\\s*(\\S+)\\)/ ) {\n\t    $source = \"$1_$2\";\n\t    next;\n\t} elsif( /^(GlimmerHMM\\S*)$/ ) { # GlimmerHMM has no version\n\t    $source = $1;\n\t    next;\n\t} elsif(/^Sequence name:\\s+(.+)$/ ) {\n\t    $seqname = $1;\n\t    next;\n\t} elsif( /^Sequence length:\\s+(\\S+)/ ) {\n\t    $seqlen = $1;\n\t    next;\n\t} elsif( m/^(Predicted genes)|(Gene)|\\s+\\#/ || /^\\s+$/ ) { \n\t    next;\n\t    \n\t} elsif( # GlimmerM/HMM gene-exon prediction line\n\t\t /^\\s+(\\d+)\\s+ # gene num\n\t\t (\\d+)\\s+      # exon num\n\t\t ([\\+\\-])\\s+   # strand\n\t\t (\\S+)\\s+      # exon type\n\t\t (\\d+)\\s+(\\d+) # exon start, end\n\t\t \\s+(\\d+)      # exon length\t\t \n\t\t /ox ) {\n\t    my ($genenum,$exonnum,$strand,$type,$start,$end,$len) = \n\t\t( $1,$2,$3,$4,$5,$6,$7);\n\t    if( ! $lastgenenum || $lastgenenum != $genenum) {\t\t\n\t\t$self->_add_prediction($gene) if ( $gene );\n\t\t$gene = Bio::Tools::Prediction::Gene->new\n\t\t    (\n\t\t     '-seq_id'      => $seqname,\n\t\t     '-primary_tag' => \"gene\",\n\t\t     '-source_tag'  => $source,\n\t\t     '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t     );\n\t    }\n\t    my $exon = Bio::Tools::Prediction::Exon->new\n\t\t('-seq_id'     => $seqname,\n\t\t '-start'      => $start,\n\t\t '-end'        => $end,\n\t\t '-strand'     => $strand eq '-' ? '-1' : '1',\n\t\t '-source_tag' => $source,\n\t\t '-primary_tag'=> 'exon',\n\t\t '-tag'         => { 'Group' => \"GenePrediction$genenum\"},\n\t\t );\n\t    $gene->add_exon($exon,lc($type));\n\t    $lastgenenum = $genenum;\n\t}\n    }\n    $self->_add_prediction($gene) if( $gene );\n    $self->_predictions_parsed(1);\n}\n\n=head2 _parse_prokaryotic\n\n Title   : _parse_prokaryotic()\n Usage   : $obj->_parse_prokaryotic()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_prokaryotic {\n    my ($self) = @_;\n\n    # default value, possibly overriden later\n    my $source = 'Glimmer';\n\n    # Store the sequence length(s) here, either from the\n    # seqlength arg to the constructor, or from the\n    # Glimmer 3.X detail file\n    my %seqlength = ( );\n    \n    # Glimmer 2.X does not provide a sequence identifer\n    # in the prediction report (will default to unknown\n    # if not specified in the seqname arg to the\n    # constructor\n    #\n    # Glimmer 2.X does not report the length of the\n    # input sequence, either (will default to undef\n    # if not specified in the seqlength arg to the\n    # constructor\n    my $seqname = $self->_seqname();\n    my $seqlength = $self->_seqlength();\n\n    if (defined($seqlength)) {\n        $seqlength{$seqname} = $seqlength\n    }\n\n    # Parse the detail file, if we have one (Glimmer 3.X)\n    my $detail_file = $self->_detail_file();\n    \n    if (defined($detail_file)) {\n\n        my $io = Bio::Root::IO->new(-file => $detail_file);\n        my $seqname;\n        \n        while (defined($_ = $io->_readline())) {\n            if ($_ =~ /^>(\\S+)/) {\n                $seqname = $1;\n                next;\n            }\n\n            if (defined($seqname) && ($_ =~ /^Sequence length = (\\d+)$/)) {\n                $seqlength{$seqname} = $1;\n                next;\n            }\n        }\n    }\n    \n    my $location_factory = Bio::Factory::FTLocationFactory->new();\n    \n    while(defined($_ = $self->_readline())) {\n        # Glimmer 3.X does provide a sequence identifier -\n        # beware whitespace at the end (comes through from\n        # the fasta file)\n        if ($_ =~ /^Putative Genes:$/) {\n            $source = 'Glimmer_2.X';\n            next;\n        }\n        # Glimmer 3.X sequence identifier\n        elsif ($_ =~ /^>(\\S+)/) {\n            $seqname = $1;\n            $seqlength = $seqlength{$seqname};\n            $source = 'Glimmer_3.X';\n            next;\n        }        \n        elsif (\n               # Glimmer 2.X prediction \n               (/^\\s+(\\d+)\\s+      # gene num\n                (\\d+)\\s+(\\d+)\\s+   # start, end\n                \\[([\\+\\-])(\\d{1})\\s+ # strand, frame\n                /ox ) ||\n               # Glimmer 3.X prediction\n               (/^[^\\d]+(\\d+)\\s+    # orf (numeric portion)\n                (\\d+)\\s+(\\d+)\\s+   # start, end\n                ([\\+\\-])(\\d{1})\\s+   # strand, frame\n                ([\\d\\.]+)          # score\n                /ox)) {\n\t    my ($genenum,$start,$end,$strand,$frame,$score) = \n\t\t( $1,$2,$3,$4,$5,$6 );\n\n            my $circular_prediction = 0;\n\n            # Check for a circular prediction before we\n            # start fiddling with the coordinates\n            if ($strand eq '+') {\n                if ($start > $end) {\n                    $circular_prediction = 1;\n                }\n            }\n            else {\n                if ($start < $end) {\n                    $circular_prediction = 1;\n                }\n            }\n\n            if ($circular_prediction) {\n                unless (defined($seqlength)) {\n                    $self->throw(\"need to know the sequence length to handle wraparound genes\");\n                }\n            }\n            \n            # Glimmer 2.X predictions do not include\n            # the stop codon - this might extend the\n            # prediction off either end of the sequence.\n            # This works fine even on circular/wraparound\n            # predictions.  \n            if ($source eq 'Glimmer_2.X') {\n                if ($strand eq '+') { \n                    $end += 3;\n                }\n                else {\n                    $end -= 3;\n                }\n            }\n\n            # We might have extended a Glimmer 2.X prediction\n            # beyond the boundaries of the input sequence.\n            # Also, Glimmer 3.X (with -X) will output predictions\n            # with coordinates less than 1 or greater than the\n            # length of the sequence.\n            my ($fst, $fend);\n            foreach my $coord ($start, $end) {\n                if ($coord < 1) {\n                    $coord = '<1';\n                    $fst++;\n                } elsif (defined($seqlength) && ($coord > $seqlength)) {\n                    $coord = \">$seqlength\";\n                    $fend++;\n                }\n            }\n            \n            my $location_string;\n\n            if ($circular_prediction) {\n                if ($strand eq '+') {\n                    $location_string = \"join($start..$seqlength,1..$end)\";\n                }\n                else {\n                    $location_string = \"join($start..1,$seqlength..$end)\";\n                }\n                }\n            else {\n                # start must always be less than end for gene locations\n                if ($strand eq '-' && !$fst && !$fend && $start > $end) {\n                    ($start, $end) = ($end, $start);\n                }\n                $location_string = \"$start..$end\";\n            }\n            \n            my $location_object =\n                $location_factory->from_string($location_string);\n            \n            # convert glimmer's frame range from 1-3 to SeqFeature's 0-2.\n            $frame--;\n            \n            my $gene = Bio::SeqFeature::Generic->new\n                (\n                 '-seq_id'      => $seqname,\n                 '-location'   => $location_object,\n                 '-strand'     => $strand eq '-' ? '-1' : '1',\n                 '-frame'\t\t=> $frame,\n                 '-source_tag'  => $source,\n                 '-display_name' => \"orf$genenum\",\n                 '-primary_tag'=> 'gene',\n                 '-tag'         => { 'Group' => \"GenePrediction_$genenum\"},\n                 '-score'       => $score || undef\n             );\n            \n            $self->_add_prediction($gene) \n\t}\n    }\n    \n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : \n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_preds'}) && @{$self->{'_preds'}});\n    return shift(@{$self->{'_preds'}});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns : \n\n\nsub _add_prediction {\n    my ($self, $gene) = @_;\n\n    if(! exists($self->{'_preds'})) {\n\t$self->{'_preds'} = [];\n    }\n    push(@{$self->{'_preds'}}, $gene);\n}\n\n=head2 _predictions_parsed\n\n Title   : _predictions_parsed\n Usage   : $obj->_predictions_parsed\n Function: internal\n Example :\n Returns : TRUE or FALSE\n\n\nsub _predictions_parsed {\n    my ($self, $val) = @_;\n\n    $self->{'_preds_parsed'} = $val if $val;\n    if(! exists($self->{'_preds_parsed'})) {\n\t$self->{'_preds_parsed'} = 0;\n    }\n    return $self->{'_preds_parsed'};\n}\n\n=head2 _seqname\n\n Title   : _seqname\n Usage   : $obj->_seqname($seqname)\n Function: internal (for Glimmer 2.X)\n Example :\n Returns : String\n\n\nsub _seqname {\n    my ($self, $val) = @_;\n\n    $self->{'_seqname'} = $val if $val;\n    if(! exists($self->{'_seqname'})) {\n\t$self->{'_seqname'} = 'unknown';\n    }\n    return $self->{'_seqname'};\n}\n\n=head2 _seqlength\n\n Title   : _seqlength\n Usage   : $obj->_seqlength($seqlength)\n Function: internal (for Glimmer 2.X)\n Example :\n Returns : String\n\n\nsub _seqlength {\n    my ($self, $val) = @_;\n\n    $self->{'_seqlength'} = $val if $val;\n    return $self->{'_seqlength'};\n}\n\n=head2 _format\n\n Title   : _format\n Usage   : $obj->_format($format)\n Function: internal\n Example :\n Returns : String\n\n\nsub _format {\n    my ($self, $val) = @_;\n\n    $self->{'_format'} = $val if $val;\n\n    return $self->{'_format'};\n}\n\n=head2 _detail_file\n\n Title   : _detail_file\n Usage   : $obj->_detail_file($filename)\n Function: internal (for Glimmer 3.X)\n Example :\n Returns : String","label":"_detail_file($self,$val)"},"line":704,"kind":12,"range":{"start":{"line":704,"character":0},"end":{"line":709,"character":9999}}}]}