{"version":5,"vars":[{"name":"base","kind":2,"containerName":"","line":113},{"localvar":"my","containerName":null,"kind":13,"name":"%ExonTags","line":115,"definition":"my"},{"line":120,"kind":12,"range":{"end":{"line":133,"character":9999},"start":{"character":0,"line":120}},"signature":{"label":"_initialize_state($self,@args)","documentation":"","parameters":[{"label":"$self"},{"label":"@args"}]},"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_initialize_state","name":"$self","line":121},{"line":121,"name":"@args","kind":13,"containerName":"_initialize_state"},{"line":124,"containerName":"_initialize_state","kind":13,"name":"$self"},{"line":124,"containerName":"_initialize_state","kind":13,"name":"@args"},{"containerName":"_initialize_state","kind":13,"name":"$self","line":127},{"line":128,"containerName":"_initialize_state","kind":13,"name":"$self"},{"line":130,"name":"$self","kind":13,"containerName":"_initialize_state"},{"line":132,"name":"$self","kind":13,"containerName":"_initialize_state"}],"name":"_initialize_state","containerName":"main::","definition":"sub","detail":"($self,@args)"},{"containerName":"_initialize_state","kind":12,"name":"SUPER","line":124},{"children":[{"line":148,"name":"$self","localvar":"my","containerName":"analysis_method","kind":13,"definition":"my"},{"line":148,"containerName":"analysis_method","kind":13,"name":"$method"},{"line":149,"kind":13,"containerName":"analysis_method","name":"$method"},{"line":149,"kind":13,"containerName":"analysis_method","name":"$method"},{"name":"$self","kind":13,"containerName":"analysis_method","line":150},{"line":150,"name":"throw","containerName":"analysis_method","kind":12},{"line":150,"name":"$self","containerName":"analysis_method","kind":13},{"name":"$self","kind":13,"containerName":"analysis_method","line":152},{"line":152,"containerName":"analysis_method","kind":13,"name":"$method"}],"containerName":"main::","name":"analysis_method","definition":"sub","detail":"($self,$method)","line":146,"range":{"end":{"line":153,"character":9999},"start":{"line":146,"character":0}},"kind":12,"signature":{"label":"analysis_method($self,$method)","parameters":[{"label":"$self"},{"label":"$method"}],"documentation":"1;\n# $Id: Genscan.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genscan\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genscan - Results of one Genscan run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Genscan;\n\n   $genscan = Bio::Tools::Genscan->new(-file => 'result.genscan');\n   # filehandle:\n   $genscan = Bio::Tools::Genscan->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $genscan->next_feature() is the same\n   while($gene = $genscan->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons: \n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $genscan->close();\n\n=head1 DESCRIPTION\n\nThe Genscan module provides a parser for Genscan gene structure prediction\noutput. It parses one gene prediction into a Bio::SeqFeature::Gene::Transcript-\nderived object.\n\nThis module also implements the Bio::SeqAnalysisParserI interface, and thus\ncan be used wherever such an object fits. See L<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genscan;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nmy %ExonTags = ('Init' => 'Initial',\n\t\t'Intr' => 'Internal',\n\t\t'Term' => 'Terminal',\n\t\t'Sngl' => '');\n    \nsub _initialize_state {\n    my ($self,@args) = @_;\n    \n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /genscan/i.\n Returns   : String\n Argument  : n/a"}},{"line":152,"name":"SUPER","containerName":"analysis_method","kind":12},{"detail":"($self,@args)","definition":"sub","name":"next_feature","containerName":"main::","children":[{"definition":"my","line":176,"name":"$self","containerName":"next_feature","localvar":"my","kind":13},{"line":176,"name":"@args","containerName":"next_feature","kind":13},{"line":180,"containerName":"next_feature","kind":13,"name":"$self"},{"kind":12,"containerName":"next_feature","name":"next_prediction","line":180},{"containerName":"next_feature","kind":13,"name":"@args","line":180}],"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Genscan.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genscan\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genscan - Results of one Genscan run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Genscan;\n\n   $genscan = Bio::Tools::Genscan->new(-file => 'result.genscan');\n   # filehandle:\n   $genscan = Bio::Tools::Genscan->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $genscan->next_feature() is the same\n   while($gene = $genscan->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons: \n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $genscan->close();\n\n=head1 DESCRIPTION\n\nThe Genscan module provides a parser for Genscan gene structure prediction\noutput. It parses one gene prediction into a Bio::SeqFeature::Gene::Transcript-\nderived object.\n\nThis module also implements the Bio::SeqAnalysisParserI interface, and thus\ncan be used wherever such an object fits. See L<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genscan;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nmy %ExonTags = ('Init' => 'Initial',\n\t\t'Intr' => 'Internal',\n\t\t'Term' => 'Terminal',\n\t\t'Sngl' => '');\n    \nsub _initialize_state {\n    my ($self,@args) = @_;\n    \n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /genscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /genscan/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $genscan->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :","label":"next_feature($self,@args)"},"range":{"end":{"character":9999,"line":181},"start":{"character":0,"line":175}},"kind":12,"line":175},{"detail":"($self)","definition":"sub","name":"next_prediction","containerName":"main::","children":[{"definition":"my","line":199,"localvar":"my","containerName":"next_prediction","kind":13,"name":"$self"},{"line":200,"kind":13,"localvar":"my","containerName":"next_prediction","name":"$gene","definition":"my"},{"line":203,"containerName":"next_prediction","kind":13,"name":"$self"},{"line":203,"name":"_parse_predictions","kind":12,"containerName":"next_prediction"},{"name":"$self","containerName":"next_prediction","kind":13,"line":203},{"name":"_predictions_parsed","containerName":"next_prediction","kind":12,"line":203},{"name":"$gene","kind":13,"containerName":"next_prediction","line":206},{"kind":13,"containerName":"next_prediction","name":"$self","line":206},{"kind":12,"containerName":"next_prediction","name":"_prediction","line":206},{"line":208,"kind":13,"containerName":"next_prediction","name":"$gene"},{"line":211,"name":"$id","localvar":"my","containerName":"next_prediction","kind":13,"definition":"my"},{"line":211,"containerName":"next_prediction","kind":13,"name":"$seq"},{"definition":"my","name":"$seqobj","containerName":"next_prediction","localvar":"my","kind":13,"line":213},{"name":"$self","containerName":"next_prediction","kind":13,"line":213},{"line":214,"name":"$seqobj","kind":13,"containerName":"next_prediction"},{"line":216,"name":"$id","containerName":"next_prediction","kind":13},{"line":216,"containerName":"next_prediction","kind":13,"name":"$seq"},{"line":216,"name":"$self","kind":13,"containerName":"next_prediction"},{"name":"_read_fasta_seq","kind":12,"containerName":"next_prediction","line":216},{"containerName":"next_prediction","kind":13,"name":"$id","line":218},{"kind":13,"containerName":"next_prediction","name":"$seq","line":218},{"line":219,"containerName":"next_prediction","kind":13,"name":"$seqobj"},{"line":219,"kind":12,"containerName":"next_prediction","name":"new"},{"line":219,"containerName":"next_prediction","kind":13,"name":"$seq"},{"line":220,"name":"$id","containerName":"next_prediction","kind":13},{"line":224,"name":"$seqobj","kind":13,"containerName":"next_prediction"},{"line":229,"kind":13,"containerName":"next_prediction","name":"$gene"},{"containerName":"next_prediction","kind":12,"name":"primary_tag","line":229},{"name":"$prednr","containerName":"next_prediction","localvar":"my","kind":13,"line":230,"definition":"my"},{"name":"$seqobj","kind":13,"containerName":"next_prediction","line":231},{"line":231,"name":"display_id","kind":12,"containerName":"next_prediction"},{"line":233,"kind":13,"containerName":"next_prediction","name":"$self"},{"line":233,"containerName":"next_prediction","kind":13,"name":"$seqobj"},{"kind":13,"containerName":"next_prediction","name":"$gene","line":235},{"line":235,"name":"predicted_protein","kind":12,"containerName":"next_prediction"},{"kind":13,"containerName":"next_prediction","name":"$seqobj","line":235},{"name":"$self","kind":13,"containerName":"next_prediction","line":237},{"name":"_has_cds","kind":12,"containerName":"next_prediction","line":237},{"kind":13,"containerName":"next_prediction","name":"$id","line":238},{"kind":13,"containerName":"next_prediction","name":"$seq","line":238},{"line":238,"name":"$self","containerName":"next_prediction","kind":13},{"name":"_read_fasta_seq","kind":12,"containerName":"next_prediction","line":238},{"line":239,"containerName":"next_prediction","kind":13,"name":"$seqobj"},{"line":239,"kind":12,"containerName":"next_prediction","name":"new"},{"line":239,"name":"$seq","kind":13,"containerName":"next_prediction"},{"line":240,"containerName":"next_prediction","kind":13,"name":"$id"},{"line":242,"kind":13,"containerName":"next_prediction","name":"$gene"},{"containerName":"next_prediction","kind":12,"name":"predicted_cds","line":242},{"containerName":"next_prediction","kind":13,"name":"$seqobj","line":242}],"signature":{"label":"next_prediction($self)","documentation":"1;\n# $Id: Genscan.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genscan\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genscan - Results of one Genscan run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Genscan;\n\n   $genscan = Bio::Tools::Genscan->new(-file => 'result.genscan');\n   # filehandle:\n   $genscan = Bio::Tools::Genscan->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $genscan->next_feature() is the same\n   while($gene = $genscan->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons: \n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $genscan->close();\n\n=head1 DESCRIPTION\n\nThe Genscan module provides a parser for Genscan gene structure prediction\noutput. It parses one gene prediction into a Bio::SeqFeature::Gene::Transcript-\nderived object.\n\nThis module also implements the Bio::SeqAnalysisParserI interface, and thus\ncan be used wherever such an object fits. See L<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genscan;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nmy %ExonTags = ('Init' => 'Initial',\n\t\t'Intr' => 'Internal',\n\t\t'Term' => 'Terminal',\n\t\t'Sngl' => '');\n    \nsub _initialize_state {\n    my ($self,@args) = @_;\n    \n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /genscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /genscan/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $genscan->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $genscan->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :","parameters":[{"label":"$self"}]},"range":{"start":{"character":0,"line":198},"end":{"character":9999,"line":245}},"kind":12,"line":198},{"line":219,"name":"Bio","kind":12,"containerName":"PrimarySeq"},{"kind":12,"containerName":"PrimarySeq","name":"Bio","line":239},{"line":248,"containerName":null,"kind":13,"name":"$gene"},{"definition":"sub","detail":"($self)","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_parse_predictions","name":"$self","line":263},{"definition":"my","line":264,"kind":13,"localvar":"my","containerName":"_parse_predictions","name":"$gene"},{"line":265,"localvar":"my","kind":13,"containerName":"_parse_predictions","name":"$seqname","definition":"my"},{"kind":13,"containerName":"_parse_predictions","name":"$self","line":267},{"line":267,"containerName":"_parse_predictions","kind":12,"name":"_readline"},{"definition":"my","line":270,"name":"$prednr","containerName":"_parse_predictions","localvar":"my","kind":13},{"line":271,"name":"$signalnr","kind":13,"localvar":"my","containerName":"_parse_predictions","definition":"my"},{"name":"$gene","kind":13,"containerName":"_parse_predictions","line":272},{"name":"$gene","containerName":"_parse_predictions","kind":13,"line":273},{"containerName":"_parse_predictions","kind":12,"name":"new","line":273},{"definition":"my","name":"@flds","containerName":"_parse_predictions","localvar":"my","kind":13,"line":279},{"definition":"my","name":"$predobj","containerName":"_parse_predictions","localvar":"my","kind":13,"line":281},{"definition":"my","name":"$is_exon","localvar":"my","containerName":"_parse_predictions","kind":13,"line":282},{"kind":13,"containerName":"_parse_predictions","name":"$flds","line":282},{"line":282,"kind":13,"containerName":"_parse_predictions","name":"%ExonTags"},{"line":283,"name":"$is_exon","containerName":"_parse_predictions","kind":13},{"name":"$predobj","kind":13,"containerName":"_parse_predictions","line":284},{"name":"new","kind":12,"containerName":"_parse_predictions","line":284},{"kind":13,"containerName":"_parse_predictions","name":"$predobj","line":287},{"line":287,"kind":12,"containerName":"_parse_predictions","name":"new"},{"kind":13,"containerName":"_parse_predictions","name":"$predobj","line":290},{"kind":12,"containerName":"_parse_predictions","name":"source_tag","line":290},{"name":"$predobj","kind":13,"containerName":"_parse_predictions","line":291},{"name":"score","containerName":"_parse_predictions","kind":12,"line":291},{"name":"$flds","kind":13,"containerName":"_parse_predictions","line":291},{"kind":13,"containerName":"_parse_predictions","name":"$predobj","line":292},{"line":292,"name":"strand","kind":12,"containerName":"_parse_predictions"},{"line":292,"kind":13,"containerName":"_parse_predictions","name":"$flds"},{"definition":"my","localvar":"my","containerName":"_parse_predictions","kind":13,"name":"$start","line":293},{"name":"$end","kind":13,"containerName":"_parse_predictions","line":293},{"line":293,"name":"@flds","kind":13,"containerName":"_parse_predictions"},{"name":"$predobj","containerName":"_parse_predictions","kind":13,"line":294},{"line":294,"kind":12,"containerName":"_parse_predictions","name":"strand"},{"line":295,"kind":13,"containerName":"_parse_predictions","name":"$predobj"},{"kind":12,"containerName":"_parse_predictions","name":"start","line":295},{"containerName":"_parse_predictions","kind":13,"name":"$start","line":295},{"containerName":"_parse_predictions","kind":13,"name":"$predobj","line":296},{"line":296,"name":"end","containerName":"_parse_predictions","kind":12},{"line":296,"name":"$end","containerName":"_parse_predictions","kind":13},{"line":298,"kind":13,"containerName":"_parse_predictions","name":"$predobj"},{"name":"end","kind":12,"containerName":"_parse_predictions","line":298},{"containerName":"_parse_predictions","kind":13,"name":"$start","line":298},{"containerName":"_parse_predictions","kind":13,"name":"$predobj","line":299},{"line":299,"name":"start","containerName":"_parse_predictions","kind":12},{"line":299,"name":"$end","kind":13,"containerName":"_parse_predictions"},{"line":303,"containerName":"_parse_predictions","kind":13,"name":"$is_exon"},{"name":"$predobj","kind":13,"containerName":"_parse_predictions","line":305},{"line":305,"name":"start_signal_score","kind":12,"containerName":"_parse_predictions"},{"line":305,"name":"$flds","containerName":"_parse_predictions","kind":13},{"line":306,"containerName":"_parse_predictions","kind":13,"name":"$predobj"},{"containerName":"_parse_predictions","kind":12,"name":"end_signal_score","line":306},{"name":"$flds","containerName":"_parse_predictions","kind":13,"line":306},{"kind":13,"containerName":"_parse_predictions","name":"$predobj","line":307},{"line":307,"kind":12,"containerName":"_parse_predictions","name":"coding_signal_score"},{"line":307,"name":"$flds","kind":13,"containerName":"_parse_predictions"},{"name":"$predobj","kind":13,"containerName":"_parse_predictions","line":308},{"line":308,"kind":12,"containerName":"_parse_predictions","name":"significance"},{"line":308,"name":"$flds","containerName":"_parse_predictions","kind":13},{"name":"$predobj","kind":13,"containerName":"_parse_predictions","line":309},{"name":"primary_tag","containerName":"_parse_predictions","kind":12,"line":309},{"line":309,"name":"$ExonTags","containerName":"_parse_predictions","kind":13},{"name":"$flds","kind":13,"containerName":"_parse_predictions","line":309},{"kind":13,"containerName":"_parse_predictions","name":"$predobj","line":310},{"line":310,"name":"is_coding","kind":12,"containerName":"_parse_predictions"},{"definition":"my","localvar":"my","kind":13,"containerName":"_parse_predictions","name":"$cod_offset","line":317},{"line":318,"name":"$predobj","containerName":"_parse_predictions","kind":13},{"name":"strand","containerName":"_parse_predictions","kind":12,"line":318},{"line":319,"name":"$cod_offset","containerName":"_parse_predictions","kind":13},{"line":319,"name":"$flds","kind":13,"containerName":"_parse_predictions"},{"line":319,"name":"$predobj","containerName":"_parse_predictions","kind":13},{"line":319,"name":"start","kind":12,"containerName":"_parse_predictions"},{"line":322,"name":"$cod_offset","containerName":"_parse_predictions","kind":13},{"line":322,"containerName":"_parse_predictions","kind":13,"name":"$cod_offset"},{"line":328,"name":"$cod_offset","kind":13,"containerName":"_parse_predictions"},{"line":328,"kind":13,"containerName":"_parse_predictions","name":"$flds"},{"name":"$predobj","containerName":"_parse_predictions","kind":13,"line":328},{"kind":12,"containerName":"_parse_predictions","name":"end","line":328},{"line":332,"containerName":"_parse_predictions","kind":13,"name":"$cod_offset"},{"name":"$cod_offset","kind":13,"containerName":"_parse_predictions","line":332},{"line":333,"kind":13,"containerName":"_parse_predictions","name":"$cod_offset"},{"containerName":"_parse_predictions","kind":13,"name":"$cod_offset","line":333},{"kind":13,"containerName":"_parse_predictions","name":"$predobj","line":338},{"name":"frame","kind":12,"containerName":"_parse_predictions","line":338},{"kind":13,"containerName":"_parse_predictions","name":"$cod_offset","line":338},{"line":340,"name":"$gene","kind":13,"containerName":"_parse_predictions"},{"line":340,"containerName":"_parse_predictions","kind":12,"name":"add_exon"},{"line":340,"kind":13,"containerName":"_parse_predictions","name":"$predobj"},{"line":340,"kind":13,"containerName":"_parse_predictions","name":"$ExonTags"},{"kind":13,"containerName":"_parse_predictions","name":"$flds","line":340},{"line":341,"name":"$flds","kind":13,"containerName":"_parse_predictions"},{"line":342,"name":"$predobj","containerName":"_parse_predictions","kind":13},{"line":342,"name":"primary_tag","containerName":"_parse_predictions","kind":12},{"line":343,"name":"$gene","kind":13,"containerName":"_parse_predictions"},{"kind":12,"containerName":"_parse_predictions","name":"poly_A_site","line":343},{"line":343,"containerName":"_parse_predictions","kind":13,"name":"$predobj"},{"kind":13,"containerName":"_parse_predictions","name":"$flds","line":344},{"line":345,"name":"$predobj","kind":13,"containerName":"_parse_predictions"},{"name":"primary_tag","kind":12,"containerName":"_parse_predictions","line":345},{"name":"$gene","containerName":"_parse_predictions","kind":13,"line":346},{"containerName":"_parse_predictions","kind":12,"name":"add_promoter","line":346},{"name":"$predobj","containerName":"_parse_predictions","kind":13,"line":346},{"containerName":"_parse_predictions","kind":13,"name":"$gene","line":350},{"line":352,"name":"$gene","kind":13,"containerName":"_parse_predictions"},{"kind":12,"containerName":"_parse_predictions","name":"seq_id","line":352},{"containerName":"_parse_predictions","kind":13,"name":"$seqname","line":352},{"containerName":"_parse_predictions","kind":13,"name":"$self","line":353},{"line":353,"name":"_add_prediction","containerName":"_parse_predictions","kind":12},{"kind":13,"containerName":"_parse_predictions","name":"$gene","line":353},{"name":"$gene","containerName":"_parse_predictions","kind":13,"line":354},{"name":"$self","kind":13,"containerName":"_parse_predictions","line":358},{"line":358,"name":"analysis_method","kind":12,"containerName":"_parse_predictions"},{"name":"$self","containerName":"_parse_predictions","kind":13,"line":359},{"line":359,"name":"analysis_method_version","containerName":"_parse_predictions","kind":12},{"containerName":"_parse_predictions","kind":13,"name":"$seqname","line":363},{"containerName":"_parse_predictions","kind":13,"name":"$self","line":368},{"line":368,"kind":12,"containerName":"_parse_predictions","name":"analysis_subject"},{"name":"$self","kind":13,"containerName":"_parse_predictions","line":373},{"name":"_has_cds","kind":12,"containerName":"_parse_predictions","line":373},{"line":478,"kind":13,"localvar":"my","containerName":"_parse_predictions","name":"$entry","definition":"my"},{"name":"$self","containerName":"_parse_predictions","kind":13,"line":478},{"line":478,"kind":12,"containerName":"_parse_predictions","name":"_readline"},{"line":479,"name":"$entry","containerName":"_parse_predictions","kind":13},{"containerName":"_parse_predictions","kind":13,"name":"$entry","line":480},{"name":"$entry","kind":13,"containerName":"_parse_predictions","line":482},{"name":"$self","kind":13,"containerName":"_parse_predictions","line":483},{"line":483,"name":"_readline","kind":12,"containerName":"_parse_predictions"},{"line":484,"name":"$entry","kind":13,"containerName":"_parse_predictions"},{"line":488,"containerName":"_parse_predictions","kind":13,"name":"$entry"},{"line":490,"name":"$entry","containerName":"_parse_predictions","kind":13},{"line":491,"name":"$id","containerName":"_parse_predictions","kind":13},{"containerName":"_parse_predictions","kind":13,"name":"$seq","line":492},{"line":494,"name":"$self","kind":13,"containerName":"_parse_predictions"},{"line":494,"name":"throw","containerName":"_parse_predictions","kind":12},{"kind":13,"containerName":"_parse_predictions","name":"$seq","line":496},{"line":498,"name":"$id","containerName":"_parse_predictions","kind":13},{"containerName":"_parse_predictions","kind":13,"name":"$seq","line":498}],"containerName":"main::","name":"_parse_predictions","signature":{"label":"_parse_predictions($self)","documentation":"1;\n# $Id: Genscan.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genscan\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genscan - Results of one Genscan run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Genscan;\n\n   $genscan = Bio::Tools::Genscan->new(-file => 'result.genscan');\n   # filehandle:\n   $genscan = Bio::Tools::Genscan->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $genscan->next_feature() is the same\n   while($gene = $genscan->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons: \n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $genscan->close();\n\n=head1 DESCRIPTION\n\nThe Genscan module provides a parser for Genscan gene structure prediction\noutput. It parses one gene prediction into a Bio::SeqFeature::Gene::Transcript-\nderived object.\n\nThis module also implements the Bio::SeqAnalysisParserI interface, and thus\ncan be used wherever such an object fits. See L<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genscan;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nmy %ExonTags = ('Init' => 'Initial',\n\t\t'Intr' => 'Internal',\n\t\t'Term' => 'Terminal',\n\t\t'Sngl' => '');\n    \nsub _initialize_state {\n    my ($self,@args) = @_;\n    \n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /genscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /genscan/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $genscan->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $genscan->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # get next gene structure\n    $gene = $self->_prediction();\n\n    if($gene) {\n\t# fill in predicted protein, and if available the predicted CDS\n\t#\n\tmy ($id, $seq);\n\t# use the seq stack if there's a seq on it\n\tmy $seqobj = pop(@{$self->{'_seqstack'}});\n\tif(! $seqobj) {\n\t    # otherwise read from input stream\n\t    ($id, $seq) = $self->_read_fasta_seq();\n\t    # there may be no sequence at all, or none any more\n\t    if($id && $seq) {\n\t\t$seqobj = Bio::PrimarySeq->new('-seq' => $seq,\n\t\t\t\t\t       '-display_id' => $id,\n\t\t\t\t\t       '-alphabet' => \"protein\");\n\t    }\n\t}\n\tif($seqobj) {\n\t    # check that prediction number matches the prediction number\n\t    # indicated in the sequence id (there may be incomplete gene\n\t    # predictions that contain only signals with no associated protein\n\t    # and CDS, like promoters, poly-A sites etc)\n\t    $gene->primary_tag() =~ /[^0-9]([0-9]+)$/;\n\t    my $prednr = $1;\n\t    if($seqobj->display_id() !~ /_predicted_\\w+_$prednr\\|/) {\n\t\t# this is not our sequence, so push back for next prediction\n\t\tpush(@{$self->{'_seqstack'}}, $seqobj);\n\t    } else {\n\t\t$gene->predicted_protein($seqobj);\n\t\t# CDS prediction, too?\n\t\tif($self->_has_cds()) {\n\t\t    ($id, $seq) = $self->_read_fasta_seq();\n\t\t    $seqobj = Bio::PrimarySeq->new('-seq' => $seq,\n\t\t\t\t\t\t   '-display_id' => $id,\n\t\t\t\t\t\t   '-alphabet' => \"dna\");\n\t\t    $gene->predicted_cds($seqobj);\n\t\t}\n\t    }\n\t}\n    }\n\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : ","parameters":[{"label":"$self"}]},"line":262,"range":{"start":{}},"kind":12},{"name":"Bio","containerName":"Tools::Prediction::Gene","kind":12,"line":273},{"containerName":"Tools::Prediction::Exon","kind":12,"name":"Bio","line":284},{"line":287,"name":"Bio","containerName":"SeqFeature::Generic","kind":12},{"line":291,"kind":12,"name":"flds"}]}