{"vars":[{"line":83,"name":"vars","containerName":"","kind":2},{"line":93,"containerName":"","kind":2,"name":"base"},{"containerName":null,"kind":13,"name":"$Srctag","line":95},{"children":[{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$class","line":109},{"line":109,"containerName":"new","kind":13,"name":"@args"},{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$self","line":110},{"line":110,"name":"$class","containerName":"new","kind":13},{"line":110,"name":"@args","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$self","line":111}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)","line":108,"range":{"start":{"character":0,"line":108},"end":{"line":112,"character":9999}},"kind":12,"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: Genomewise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genomewise\n#\n# Copyright Jason Stajich <jason-at-bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genomewise - Results of one Genomewise run\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Genomewise;\n  my $gw = Bio::Tools::Genomewise(-file=>\"genomewise.out\");\n\n  while (my $gene = $gw->next_prediction){\n      my @transcripts = $gene->transcripts;\n      foreach my $t(@transcripts){\n        my @exons =  $t->exons;\n        foreach my $e(@exons){\n            print $e->start.\" \".$e->end.\"\\n\";\n        }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the parser for the output of Genewise. It takes either a file\nhandle or a file name and returns a\nBio::SeqFeature::Gene::GeneStructure object.  You will need to specify\nthe proper target sequence id on the object with the\n$feature-E<gt>seq_id($seqid).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Fugu Team, Jason Stajich \n\n Email: fugui-at-worf.fugu-sg.org\n        jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genomewise;\nuse vars qw($Srctag);\nuse strict;\n\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::GeneStructure;\n\nuse base qw(Bio::Tools::Genewise);\n\n$Srctag = 'genomewise';\n\n=head2 new\n\n Title   : new\n Usage   : $obj->new(-file=>\"genewise.out\");\n           $obj->new(-fh=>\\*GW);\n Function: Constructor for genomewise wrapper. Takes either a file or filehandle\n Example :\n Returns : L<Bio::Tools::Genomewise>","parameters":[{"label":"$class"},{"label":"@args"}]}},{"kind":12,"containerName":"new","name":"SUPER","line":110},{"detail":"($self)","definition":"sub","containerName":"main::","name":"next_prediction","children":[{"definition":"my","line":172,"name":"$self","containerName":"next_prediction","localvar":"my","kind":13},{"line":174,"name":"$genes","kind":13,"localvar":"my","containerName":"next_prediction","definition":"my"},{"line":175,"name":"$self","containerName":"next_prediction","kind":13},{"line":175,"name":"_readline","kind":12,"containerName":"next_prediction"},{"line":176,"name":"$self","kind":13,"containerName":"next_prediction"},{"line":176,"kind":12,"containerName":"next_prediction","name":"debug"},{"containerName":"next_prediction","kind":13,"name":"$genes","line":180},{"line":181,"kind":12,"containerName":"next_prediction","name":"new"},{"line":181,"name":"$Srctag","containerName":"next_prediction","kind":13},{"line":182,"name":"$self","containerName":"next_prediction","kind":13},{"line":182,"name":"_target_id","containerName":"next_prediction","kind":12},{"line":184,"containerName":"next_prediction","kind":13,"name":"$self"},{"name":"_readline","kind":12,"containerName":"next_prediction","line":184},{"line":185,"kind":13,"containerName":"next_prediction","name":"$self"},{"name":"debug","containerName":"next_prediction","kind":12,"line":185},{"kind":13,"containerName":"next_prediction","name":"$self","line":188},{"name":"warn","kind":12,"containerName":"next_prediction","line":188},{"definition":"my","line":191,"name":"$transcript","localvar":"my","kind":13,"containerName":"next_prediction"},{"name":"new","kind":12,"containerName":"next_prediction","line":192},{"containerName":"next_prediction","kind":13,"name":"$Srctag","line":192},{"line":193,"name":"$self","kind":13,"containerName":"next_prediction"},{"name":"_target_id","kind":12,"containerName":"next_prediction","line":193},{"name":"$nbr","kind":13,"localvar":"my","containerName":"next_prediction","line":197,"definition":"my"},{"name":"$self","containerName":"next_prediction","kind":13,"line":198},{"line":198,"kind":12,"containerName":"next_prediction","name":"_readline"},{"kind":13,"containerName":"next_prediction","name":"$self","line":199},{"line":199,"containerName":"next_prediction","kind":12,"name":"debug"},{"containerName":"next_prediction","kind":13,"name":"$self","line":202},{"name":"_pushback","containerName":"next_prediction","kind":12,"line":202},{"name":"$e_start","localvar":"my","containerName":"next_prediction","kind":13,"line":205,"definition":"my"},{"line":205,"kind":13,"containerName":"next_prediction","name":"$e_end"},{"name":"$phase","kind":13,"containerName":"next_prediction","line":205},{"line":205,"kind":13,"containerName":"next_prediction","name":"$e_strand"},{"line":207,"containerName":"next_prediction","kind":13,"name":"$e_start"},{"line":207,"containerName":"next_prediction","kind":13,"name":"$e_end"},{"line":207,"containerName":"next_prediction","kind":13,"name":"$e_strand"},{"name":"$self","containerName":"next_prediction","kind":13,"line":207},{"name":"_get_strand","kind":12,"containerName":"next_prediction","line":207},{"containerName":"next_prediction","kind":13,"name":"$e_start","line":207},{"containerName":"next_prediction","kind":13,"name":"$e_end","line":208},{"kind":13,"containerName":"next_prediction","name":"$transcript","line":209},{"containerName":"next_prediction","kind":12,"name":"strand","line":209},{"kind":13,"containerName":"next_prediction","name":"$e_strand","line":209},{"name":"$transcript","kind":13,"containerName":"next_prediction","line":209},{"line":209,"kind":12,"containerName":"next_prediction","name":"strand"},{"definition":"my","line":211,"name":"$exon","kind":13,"localvar":"my","containerName":"next_prediction"},{"name":"new","kind":12,"containerName":"next_prediction","line":211},{"line":212,"name":"$self","kind":13,"containerName":"next_prediction"},{"line":212,"containerName":"next_prediction","kind":12,"name":"_target_id"},{"line":213,"kind":13,"containerName":"next_prediction","name":"$Srctag"},{"name":"$e_start","kind":13,"containerName":"next_prediction","line":214},{"line":215,"containerName":"next_prediction","kind":13,"name":"$e_end"},{"name":"$phase","containerName":"next_prediction","kind":13,"line":216},{"line":217,"name":"$e_strand","containerName":"next_prediction","kind":13},{"name":"$exon","containerName":"next_prediction","kind":13,"line":218},{"containerName":"next_prediction","kind":12,"name":"add_tag_value","line":218},{"line":218,"kind":13,"containerName":"next_prediction","name":"$nbr"},{"line":219,"kind":13,"containerName":"next_prediction","name":"$exon"},{"kind":12,"containerName":"next_prediction","name":"add_tag_value","line":219},{"line":219,"name":"$phase","containerName":"next_prediction","kind":13},{"line":220,"name":"$transcript","kind":13,"containerName":"next_prediction"},{"line":220,"name":"add_exon","kind":12,"containerName":"next_prediction"},{"kind":13,"containerName":"next_prediction","name":"$exon","line":220},{"containerName":"next_prediction","kind":13,"name":"$genes","line":222},{"containerName":"next_prediction","kind":12,"name":"add_transcript","line":222},{"kind":13,"containerName":"next_prediction","name":"$transcript","line":222},{"name":"$genes","containerName":"next_prediction","kind":13,"line":226}],"signature":{"documentation":"1;\n# $Id: Genomewise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Genomewise\n#\n# Copyright Jason Stajich <jason-at-bioperl.org>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Genomewise - Results of one Genomewise run\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Genomewise;\n  my $gw = Bio::Tools::Genomewise(-file=>\"genomewise.out\");\n\n  while (my $gene = $gw->next_prediction){\n      my @transcripts = $gene->transcripts;\n      foreach my $t(@transcripts){\n        my @exons =  $t->exons;\n        foreach my $e(@exons){\n            print $e->start.\" \".$e->end.\"\\n\";\n        }\n      }\n  }\n\n=head1 DESCRIPTION\n\nThis is the parser for the output of Genewise. It takes either a file\nhandle or a file name and returns a\nBio::SeqFeature::Gene::GeneStructure object.  You will need to specify\nthe proper target sequence id on the object with the\n$feature-E<gt>seq_id($seqid).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Fugu Team, Jason Stajich \n\n Email: fugui-at-worf.fugu-sg.org\n        jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Genomewise;\nuse vars qw($Srctag);\nuse strict;\n\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Bio::SeqFeature::Gene::Exon;\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Gene::Transcript;\nuse Bio::SeqFeature::Gene::GeneStructure;\n\nuse base qw(Bio::Tools::Genewise);\n\n$Srctag = 'genomewise';\n\n=head2 new\n\n Title   : new\n Usage   : $obj->new(-file=>\"genewise.out\");\n           $obj->new(-fh=>\\*GW);\n Function: Constructor for genomewise wrapper. Takes either a file or filehandle\n Example :\n Returns : L<Bio::Tools::Genomewise>\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  return $self;\n}\n\n=head2 _get_strand\n\n Title   : _get_strand\n Usage   : $obj->_get_strand\n Function: takes start and end values, swap them if start>end and returns end\n Example :\n Returns :$start,$end,$strand\n\n\n=head2 score\n\n Title   : score\n Usage   : $obj->score\n Function: get/set for score info\n Example :\n Returns : a score value\n\n\n=head2 _prot_id\n\n Title   : _prot_id\n Usage   : $obj->_prot_id\n Function: get/set for protein id \n Example :\n Returns :a protein id\n\n\n=head2 _target_id\n\n Title   : _target_id\n Usage   : $obj->_target_id\n Function: get/set for genomic sequence id\n Example :\n Returns :a target id\n\n\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $genewise->next_prediction()) {\n                  # do something\n           }\n Function: Returns the gene structure prediction of the Genomewise result\n           file. Call this method repeatedly until FALSE is returned.\n\n Example :\n Returns : a Bio::SeqFeature::Gene::GeneStructure object\n Args    :","parameters":[{"label":"$self"}],"label":"next_prediction($self)"},"kind":12,"range":{"end":{"character":9999,"line":227},"start":{"character":0,"line":171}},"line":171},{"line":180,"name":"Bio","containerName":"SeqFeature::Gene::GeneStructure","kind":12},{"containerName":"SeqFeature::Gene::Transcript","kind":12,"name":"Bio","line":191},{"containerName":"SeqFeature::Gene::Exon","kind":12,"name":"Bio","line":211}],"version":5}