{"version":5,"vars":[{"line":113,"name":"base","kind":2,"containerName":""},{"line":115,"localvar":"my","kind":13,"containerName":null,"name":"%ExonTags","definition":"my"},{"children":[{"definition":"my","name":"$self","containerName":"_initialize_state","localvar":"my","kind":13,"line":121},{"line":121,"containerName":"_initialize_state","kind":13,"name":"@args"},{"name":"$self","kind":13,"containerName":"_initialize_state","line":124},{"line":124,"containerName":"_initialize_state","kind":13,"name":"@args"},{"line":127,"containerName":"_initialize_state","kind":13,"name":"$self"},{"name":"$self","containerName":"_initialize_state","kind":13,"line":128},{"containerName":"_initialize_state","kind":13,"name":"$self","line":130},{"line":132,"name":"$self","kind":13,"containerName":"_initialize_state"}],"containerName":"main::","name":"_initialize_state","definition":"sub","detail":"($self,@args)","line":120,"kind":12,"range":{"end":{"character":9999,"line":133},"start":{"character":0,"line":120}},"signature":{"label":"_initialize_state($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":""}},{"kind":12,"containerName":"_initialize_state","name":"SUPER","line":124},{"signature":{"documentation":"1;\n# $Id: Fgenesh.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Fgenesh\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christopher Dwan (chris@dwan.org)\n#\n# Copied, lock stock & barrel from Genscan.pm\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Fgenesh - parse results of one Fgenesh run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Fgenesh;\n\n   $fgenesh = Bio::Tools::Fgenesh->new(-file => 'result.fgenesh');\n   # filehandle:\n   $fgenesh = Bio::Tools::Fgenesh->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $fgensh->next_feature() is the same\n   while($gene = $fgenesh->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons: \n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $fgenesh->close();\n\n=head1 DESCRIPTION\n\nThe Fgenesh module provides a parser for Fgenesh (version 2) gene structure \nprediction output. It parses one gene prediction into a \nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module also implements the L<Bio::SeqAnalysisParserI> interface, and thus\ncan be used wherever such an object fits. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Dwan\n\nEmail chris-at-dwan.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Fgenesh;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nmy %ExonTags = ('CDSf' => 'Initial',\n\t\t'CDSi' => 'Internal',\n\t\t'CDSl' => 'Terminal',\n\t\t'CDSo' => 'Singleton');\n    \nsub _initialize_state {\n    my ($self,@args) = @_;\n    \n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /genscan/i.\n Returns   : String\n Argument  : n/a","parameters":[{"label":"$self"},{"label":"$method"}],"label":"analysis_method($self,$method)"},"line":146,"kind":12,"range":{"start":{"character":0,"line":146},"end":{"character":9999,"line":153}},"definition":"sub","detail":"($self,$method)","children":[{"definition":"my","line":148,"kind":13,"localvar":"my","containerName":"analysis_method","name":"$self"},{"containerName":"analysis_method","kind":13,"name":"$method","line":148},{"name":"$method","containerName":"analysis_method","kind":13,"line":149},{"name":"$method","containerName":"analysis_method","kind":13,"line":149},{"kind":13,"containerName":"analysis_method","name":"$self","line":150},{"line":150,"name":"throw","containerName":"analysis_method","kind":12},{"line":150,"containerName":"analysis_method","kind":13,"name":"$self"},{"line":152,"name":"$self","containerName":"analysis_method","kind":13},{"line":152,"name":"$method","kind":13,"containerName":"analysis_method"}],"containerName":"main::","name":"analysis_method"},{"containerName":"analysis_method","kind":12,"name":"SUPER","line":152},{"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","line":176,"name":"$self","localvar":"my","kind":13,"containerName":"next_feature"},{"containerName":"next_feature","kind":13,"name":"@args","line":176},{"line":180,"name":"$self","containerName":"next_feature","kind":13},{"containerName":"next_feature","kind":12,"name":"next_prediction","line":180},{"line":180,"kind":13,"containerName":"next_feature","name":"@args"}],"containerName":"main::","name":"next_feature","signature":{"label":"next_feature($self,@args)","documentation":"1;\n# $Id: Fgenesh.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Fgenesh\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christopher Dwan (chris@dwan.org)\n#\n# Copied, lock stock & barrel from Genscan.pm\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Fgenesh - parse results of one Fgenesh run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Fgenesh;\n\n   $fgenesh = Bio::Tools::Fgenesh->new(-file => 'result.fgenesh');\n   # filehandle:\n   $fgenesh = Bio::Tools::Fgenesh->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $fgensh->next_feature() is the same\n   while($gene = $fgenesh->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons: \n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $fgenesh->close();\n\n=head1 DESCRIPTION\n\nThe Fgenesh module provides a parser for Fgenesh (version 2) gene structure \nprediction output. It parses one gene prediction into a \nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module also implements the L<Bio::SeqAnalysisParserI> interface, and thus\ncan be used wherever such an object fits. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Dwan\n\nEmail chris-at-dwan.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Fgenesh;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nmy %ExonTags = ('CDSf' => 'Initial',\n\t\t'CDSi' => 'Internal',\n\t\t'CDSl' => 'Terminal',\n\t\t'CDSo' => 'Singleton');\n    \nsub _initialize_state {\n    my ($self,@args) = @_;\n    \n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /genscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /fgenesh/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $fgenesh->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Fgenesh result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :","parameters":[{"label":"$self"},{"label":"@args"}]},"line":175,"kind":12,"range":{"end":{"line":181,"character":9999},"start":{"character":0,"line":175}}},{"signature":{"label":"next_prediction($self)","documentation":"1;\n# $Id: Fgenesh.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Fgenesh\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christopher Dwan (chris@dwan.org)\n#\n# Copied, lock stock & barrel from Genscan.pm\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Fgenesh - parse results of one Fgenesh run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Fgenesh;\n\n   $fgenesh = Bio::Tools::Fgenesh->new(-file => 'result.fgenesh');\n   # filehandle:\n   $fgenesh = Bio::Tools::Fgenesh->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $fgensh->next_feature() is the same\n   while($gene = $fgenesh->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons: \n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $fgenesh->close();\n\n=head1 DESCRIPTION\n\nThe Fgenesh module provides a parser for Fgenesh (version 2) gene structure \nprediction output. It parses one gene prediction into a \nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module also implements the L<Bio::SeqAnalysisParserI> interface, and thus\ncan be used wherever such an object fits. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Dwan\n\nEmail chris-at-dwan.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Fgenesh;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nmy %ExonTags = ('CDSf' => 'Initial',\n\t\t'CDSi' => 'Internal',\n\t\t'CDSl' => 'Terminal',\n\t\t'CDSo' => 'Singleton');\n    \nsub _initialize_state {\n    my ($self,@args) = @_;\n    \n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /genscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /fgenesh/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $fgenesh->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Fgenesh result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $fgenesh->next_prediction()) { ... }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :","parameters":[{"label":"$self"}]},"line":195,"range":{"start":{"character":0,"line":195},"end":{"line":252,"character":9999}},"kind":12,"definition":"sub","detail":"($self)","children":[{"definition":"my","line":196,"localvar":"my","containerName":"next_prediction","kind":13,"name":"$self"},{"line":197,"localvar":"my","kind":13,"containerName":"next_prediction","name":"$gene","definition":"my"},{"name":"$self","containerName":"next_prediction","kind":13,"line":200},{"name":"_parse_predictions","containerName":"next_prediction","kind":12,"line":200},{"line":200,"name":"$self","containerName":"next_prediction","kind":13},{"line":200,"name":"_predictions_parsed","kind":12,"containerName":"next_prediction"},{"name":"$gene","containerName":"next_prediction","kind":13,"line":203},{"name":"$self","containerName":"next_prediction","kind":13,"line":203},{"line":203,"name":"_prediction","containerName":"next_prediction","kind":12},{"containerName":"next_prediction","kind":13,"name":"$gene","line":205},{"line":210,"name":"$seqobj","containerName":"next_prediction","localvar":"my","kind":13,"definition":"my"},{"line":210,"containerName":"next_prediction","kind":13,"name":"$self"},{"definition":"my","localvar":"my","kind":13,"containerName":"next_prediction","name":"$id","line":211},{"line":211,"containerName":"next_prediction","kind":13,"name":"$seq"},{"name":"$seqobj","containerName":"next_prediction","kind":13,"line":212},{"line":213,"containerName":"next_prediction","kind":13,"name":"$id"},{"line":213,"name":"$seq","containerName":"next_prediction","kind":13},{"name":"$self","containerName":"next_prediction","kind":13,"line":213},{"line":213,"containerName":"next_prediction","kind":12,"name":"_read_fasta_seq"},{"definition":"my","name":"$alphabet","kind":13,"localvar":"my","containerName":"next_prediction","line":214},{"name":"$id","containerName":"next_prediction","kind":13,"line":215},{"line":215,"containerName":"next_prediction","kind":13,"name":"$id"},{"name":"$alphabet","containerName":"next_prediction","kind":13,"line":215},{"kind":13,"containerName":"next_prediction","name":"$alphabet","line":216},{"containerName":"next_prediction","kind":13,"name":"$seqobj","line":217},{"name":"new","containerName":"next_prediction","kind":12,"line":217},{"name":"$seq","containerName":"next_prediction","kind":13,"line":217},{"line":218,"name":"$id","containerName":"next_prediction","kind":13},{"kind":13,"containerName":"next_prediction","name":"$alphabet","line":219},{"name":"$seqobj","containerName":"next_prediction","kind":13,"line":221},{"name":"$gene","containerName":"next_prediction","kind":13,"line":228},{"kind":12,"containerName":"next_prediction","name":"primary_tag","line":228},{"definition":"my","line":229,"name":"$prednr","containerName":"next_prediction","localvar":"my","kind":13},{"name":"$id","containerName":"next_prediction","kind":13,"line":230},{"line":232,"kind":13,"containerName":"next_prediction","name":"$self"},{"line":232,"containerName":"next_prediction","kind":13,"name":"$seqobj"},{"line":235,"kind":13,"containerName":"next_prediction","name":"$gene"},{"line":235,"name":"predicted_protein","kind":12,"containerName":"next_prediction"},{"containerName":"next_prediction","kind":13,"name":"$seqobj","line":235},{"containerName":"next_prediction","kind":13,"name":"$self","line":237},{"containerName":"next_prediction","kind":12,"name":"_has_cds","line":237},{"line":238,"containerName":"next_prediction","kind":13,"name":"$gene"},{"line":238,"containerName":"next_prediction","kind":12,"name":"predicted_cds"},{"line":238,"name":"$seqobj","kind":13,"containerName":"next_prediction"},{"name":"$id","kind":13,"containerName":"next_prediction","line":241},{"line":241,"name":"$seq","kind":13,"containerName":"next_prediction"},{"name":"$self","kind":13,"containerName":"next_prediction","line":241},{"line":241,"name":"_read_fasta_seq","kind":12,"containerName":"next_prediction"},{"line":242,"containerName":"next_prediction","kind":13,"name":"$id"},{"kind":13,"containerName":"next_prediction","name":"$id","line":243},{"line":243,"containerName":"next_prediction","kind":13,"name":"$seq"},{"line":243,"name":"$self","kind":13,"containerName":"next_prediction"},{"line":243,"containerName":"next_prediction","kind":12,"name":"_read_fasta_seq"},{"name":"$seqobj","kind":13,"containerName":"next_prediction","line":246},{"containerName":"next_prediction","kind":12,"name":"new","line":246},{"line":246,"name":"$seq","kind":13,"containerName":"next_prediction"},{"line":247,"kind":13,"containerName":"next_prediction","name":"$id"},{"line":249,"name":"$gene","kind":13,"containerName":"next_prediction"},{"line":249,"name":"predicted_protein","kind":12,"containerName":"next_prediction"},{"line":249,"name":"$seqobj","containerName":"next_prediction","kind":13}],"containerName":"main::","name":"next_prediction"},{"name":"Bio","containerName":"PrimarySeq","kind":12,"line":217},{"kind":12,"containerName":"PrimarySeq","name":"Bio","line":246},{"line":255,"containerName":null,"kind":13,"name":"$gene"},{"containerName":"main::","name":"_parse_predictions","children":[{"line":270,"localvar":"my","kind":13,"containerName":"_parse_predictions","name":"$self","definition":"my"},{"definition":"my","line":271,"name":"$gene","localvar":"my","kind":13,"containerName":"_parse_predictions"},{"line":272,"name":"$seqname","localvar":"my","kind":13,"containerName":"_parse_predictions","definition":"my"},{"line":274,"containerName":"_parse_predictions","kind":13,"name":"$self"},{"line":274,"name":"_readline","containerName":"_parse_predictions","kind":12},{"definition":"my","name":"$line","localvar":"my","containerName":"_parse_predictions","kind":13,"line":277},{"definition":"my","name":"$prednr","localvar":"my","containerName":"_parse_predictions","kind":13,"line":280},{"kind":13,"localvar":"my","containerName":"_parse_predictions","name":"$strand","line":281,"definition":"my"},{"line":283,"name":"$gene","containerName":"_parse_predictions","kind":13},{"name":"$gene","containerName":"_parse_predictions","kind":13,"line":284},{"name":"new","kind":12,"containerName":"_parse_predictions","line":284},{"definition":"my","line":290,"name":"@flds","localvar":"my","containerName":"_parse_predictions","kind":13},{"line":290,"containerName":"_parse_predictions","kind":13,"name":"$line"},{"line":297,"name":"$predobj","localvar":"my","containerName":"_parse_predictions","kind":13,"definition":"my"},{"definition":"my","line":298,"name":"$is_exon","localvar":"my","kind":13,"containerName":"_parse_predictions"},{"containerName":"_parse_predictions","kind":13,"name":"$line","line":298},{"kind":13,"containerName":"_parse_predictions","name":"%ExonTags","line":298},{"definition":"my","line":299,"name":"$start","containerName":"_parse_predictions","localvar":"my","kind":13},{"line":299,"name":"$end","kind":13,"containerName":"_parse_predictions"},{"line":300,"name":"$is_exon","containerName":"_parse_predictions","kind":13},{"line":301,"name":"$predobj","containerName":"_parse_predictions","kind":13},{"line":301,"name":"new","containerName":"_parse_predictions","kind":12},{"containerName":"_parse_predictions","kind":13,"name":"$predobj","line":302},{"line":302,"name":"score","containerName":"_parse_predictions","kind":12},{"name":"$flds","kind":13,"containerName":"_parse_predictions","line":302},{"containerName":"_parse_predictions","kind":13,"name":"$start","line":303},{"line":303,"kind":13,"containerName":"_parse_predictions","name":"$flds"},{"line":304,"kind":13,"containerName":"_parse_predictions","name":"$end"},{"name":"$flds","containerName":"_parse_predictions","kind":13,"line":304},{"line":307,"kind":13,"containerName":"_parse_predictions","name":"$predobj"},{"containerName":"_parse_predictions","kind":12,"name":"new","line":307},{"line":308,"kind":13,"containerName":"_parse_predictions","name":"$predobj"},{"line":308,"name":"score","kind":12,"containerName":"_parse_predictions"},{"name":"$flds","kind":13,"containerName":"_parse_predictions","line":308},{"line":309,"name":"$start","containerName":"_parse_predictions","kind":13},{"line":309,"containerName":"_parse_predictions","kind":13,"name":"$flds"},{"name":"$end","containerName":"_parse_predictions","kind":13,"line":310},{"name":"$flds","kind":13,"containerName":"_parse_predictions","line":310},{"name":"$predobj","kind":13,"containerName":"_parse_predictions","line":313},{"line":313,"containerName":"_parse_predictions","kind":12,"name":"source_tag"},{"containerName":"_parse_predictions","kind":13,"name":"$predobj","line":314},{"name":"strand","kind":12,"containerName":"_parse_predictions","line":314},{"name":"$strand","containerName":"_parse_predictions","kind":13,"line":314},{"line":323,"name":"$predobj","containerName":"_parse_predictions","kind":13},{"kind":12,"containerName":"_parse_predictions","name":"start","line":323},{"name":"$start","kind":13,"containerName":"_parse_predictions","line":323},{"line":324,"name":"$predobj","containerName":"_parse_predictions","kind":13},{"line":324,"containerName":"_parse_predictions","kind":12,"name":"end"},{"line":324,"kind":13,"containerName":"_parse_predictions","name":"$end"},{"containerName":"_parse_predictions","kind":13,"name":"$is_exon","line":333},{"name":"$predobj","kind":13,"containerName":"_parse_predictions","line":335},{"containerName":"_parse_predictions","kind":12,"name":"primary_tag","line":335},{"containerName":"_parse_predictions","kind":13,"name":"$ExonTags","line":335},{"name":"$flds","kind":13,"containerName":"_parse_predictions","line":335},{"line":336,"containerName":"_parse_predictions","kind":13,"name":"$predobj"},{"line":336,"name":"is_coding","kind":12,"containerName":"_parse_predictions"},{"line":337,"name":"$cod_offset","localvar":"my","containerName":"_parse_predictions","kind":13,"definition":"my"},{"line":338,"name":"$predobj","containerName":"_parse_predictions","kind":13},{"containerName":"_parse_predictions","kind":12,"name":"strand","line":338},{"name":"$cod_offset","containerName":"_parse_predictions","kind":13,"line":339},{"containerName":"_parse_predictions","kind":13,"name":"$flds","line":339},{"line":339,"name":"$predobj","containerName":"_parse_predictions","kind":13},{"name":"start","kind":12,"containerName":"_parse_predictions","line":339},{"kind":13,"containerName":"_parse_predictions","name":"$cod_offset","line":342},{"line":342,"name":"$cod_offset","containerName":"_parse_predictions","kind":13},{"containerName":"_parse_predictions","kind":13,"name":"$cod_offset","line":348},{"name":"$flds","containerName":"_parse_predictions","kind":13,"line":348},{"line":348,"kind":13,"containerName":"_parse_predictions","name":"$predobj"},{"line":348,"name":"end","containerName":"_parse_predictions","kind":12},{"line":352,"name":"$cod_offset","containerName":"_parse_predictions","kind":13},{"containerName":"_parse_predictions","kind":13,"name":"$cod_offset","line":352},{"line":353,"name":"$cod_offset","containerName":"_parse_predictions","kind":13},{"line":353,"containerName":"_parse_predictions","kind":13,"name":"$cod_offset"},{"kind":13,"containerName":"_parse_predictions","name":"$predobj","line":358},{"line":358,"name":"frame","containerName":"_parse_predictions","kind":12},{"name":"$cod_offset","containerName":"_parse_predictions","kind":13,"line":358},{"line":361,"kind":13,"containerName":"_parse_predictions","name":"$gene"},{"name":"add_exon","containerName":"_parse_predictions","kind":12,"line":361},{"line":361,"kind":13,"containerName":"_parse_predictions","name":"$predobj"},{"kind":13,"containerName":"_parse_predictions","name":"$ExonTags","line":361},{"containerName":"_parse_predictions","kind":13,"name":"$flds","line":361},{"line":362,"name":"$flds","containerName":"_parse_predictions","kind":13},{"name":"$predobj","kind":13,"containerName":"_parse_predictions","line":363},{"name":"primary_tag","containerName":"_parse_predictions","kind":12,"line":363},{"line":364,"containerName":"_parse_predictions","kind":13,"name":"$gene"},{"line":364,"containerName":"_parse_predictions","kind":12,"name":"poly_A_site"},{"name":"$predobj","kind":13,"containerName":"_parse_predictions","line":364},{"line":365,"containerName":"_parse_predictions","kind":13,"name":"$flds"},{"name":"$predobj","kind":13,"containerName":"_parse_predictions","line":366},{"kind":12,"containerName":"_parse_predictions","name":"primary_tag","line":366},{"name":"$gene","containerName":"_parse_predictions","kind":13,"line":367},{"name":"add_promoter","kind":12,"containerName":"_parse_predictions","line":367},{"kind":13,"containerName":"_parse_predictions","name":"$predobj","line":367},{"name":"$self","containerName":"_parse_predictions","kind":13,"line":374},{"name":"throw","kind":12,"containerName":"_parse_predictions","line":374},{"name":"$line","kind":13,"containerName":"_parse_predictions","line":374},{"line":379,"kind":13,"containerName":"_parse_predictions","name":"$gene"},{"line":381,"name":"$gene","containerName":"_parse_predictions","kind":13},{"line":381,"containerName":"_parse_predictions","kind":12,"name":"seq_id"},{"name":"$seqname","containerName":"_parse_predictions","kind":13,"line":381},{"line":382,"name":"$self","kind":13,"containerName":"_parse_predictions"},{"line":382,"kind":12,"containerName":"_parse_predictions","name":"_add_prediction"},{"name":"$gene","containerName":"_parse_predictions","kind":13,"line":382},{"line":383,"containerName":"_parse_predictions","kind":13,"name":"$gene"},{"line":388,"name":"$self","kind":13,"containerName":"_parse_predictions"},{"line":388,"containerName":"_parse_predictions","kind":12,"name":"analysis_method"},{"line":389,"containerName":"_parse_predictions","kind":13,"name":"$self"},{"line":389,"name":"analysis_method_version","kind":12,"containerName":"_parse_predictions"},{"kind":13,"containerName":"_parse_predictions","name":"$self","line":391},{"name":"analysis_subject","containerName":"_parse_predictions","kind":12,"line":391},{"name":"$seqname","containerName":"_parse_predictions","kind":13,"line":397},{"line":403,"kind":13,"containerName":"_parse_predictions","name":"$self"},{"name":"_pushback","containerName":"_parse_predictions","kind":12,"line":403},{"line":408,"kind":13,"containerName":"_parse_predictions","name":"$self"},{"name":"_predictions_parsed","containerName":"_parse_predictions","kind":12,"line":408}],"detail":"($self)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":409},"start":{"character":0,"line":269}},"line":269,"signature":{"label":"_parse_predictions($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Fgenesh.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Fgenesh\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christopher Dwan (chris@dwan.org)\n#\n# Copied, lock stock & barrel from Genscan.pm\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Fgenesh - parse results of one Fgenesh run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Fgenesh;\n\n   $fgenesh = Bio::Tools::Fgenesh->new(-file => 'result.fgenesh');\n   # filehandle:\n   $fgenesh = Bio::Tools::Fgenesh->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $fgensh->next_feature() is the same\n   while($gene = $fgenesh->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons: \n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $fgenesh->close();\n\n=head1 DESCRIPTION\n\nThe Fgenesh module provides a parser for Fgenesh (version 2) gene structure \nprediction output. It parses one gene prediction into a \nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module also implements the L<Bio::SeqAnalysisParserI> interface, and thus\ncan be used wherever such an object fits. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Dwan\n\nEmail chris-at-dwan.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Fgenesh;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nmy %ExonTags = ('CDSf' => 'Initial',\n\t\t'CDSi' => 'Internal',\n\t\t'CDSl' => 'Terminal',\n\t\t'CDSo' => 'Singleton');\n    \nsub _initialize_state {\n    my ($self,@args) = @_;\n    \n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /genscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /fgenesh/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $fgenesh->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Fgenesh result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $fgenesh->next_prediction()) { ... }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # get next gene structure\n    $gene = $self->_prediction();\n\n    if($gene) {\n\t# fill in predicted protein, and if available the predicted CDS\n\t#\n\n\t# use the seq stack if there's a seq on it\n\tmy $seqobj = pop(@{$self->{'_seqstack'}});\n        my ($id, $seq);\n\tunless ($seqobj) {\n\t   ($id, $seq) = $self->_read_fasta_seq();\n           my $alphabet;\n           if (($id =~ /mrna/) || ($id =~ /cds/)) { $alphabet = 'dna'; }\n           else { $alphabet = 'protein'; }\n           $seqobj = Bio::PrimarySeq->new('-seq'        => $seq,\n                                          '-display_id' => $id,\n                                          '-alphabet'   => $alphabet); \n        }\n\tif ($seqobj) {\n\n\t    # check that prediction number matches the prediction number\n\t    # indicated in the sequence id (there may be incomplete gene\n\t    # predictions that contain only signals with no associated protein\n            # prediction.\n\n\t    $gene->primary_tag() =~ /[^0-9]([0-9]+)$/;\n\t    my $prednr = $1;\n\t    if ($id !~ /_predicted_(\\w+)_$prednr/) {\n\t\t# this is not our sequence, so push back for next prediction\n\t\tpush(@{$self->{'_seqstack'}}, $seqobj);\n\t    } else {\n                if ($1 eq \"protein\") {\n\t\t  $gene->predicted_protein($seqobj);\n                } elsif (($1 eq \"mrna\") || ($1 eq \"cds\")) {\n                  $self->_has_cds(1);\n                  $gene->predicted_cds($seqobj);\n                  \n                  # Have to go back in and get the protein...\n                  ($id, $seq) = $self->_read_fasta_seq();\n                  if ($id =~ /_cds_/) { \n                    ($id, $seq) = $self->_read_fasta_seq(); \n                  }\n \n\t\t  $seqobj = Bio::PrimarySeq->new('-seq' => $seq,\n\t\t\t    \t\t         '-display_id' => $id,\n\t\t\t\t\t\t '-alphabet' => \"protein\");\n\t\t  $gene->predicted_protein($seqobj);\n\t\t}\n\t    }\n\t}\n    }\n\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : "}},{"line":284,"containerName":"Tools::Prediction::Gene","kind":12,"name":"Bio"},{"kind":12,"containerName":"Tools::Prediction::Exon","name":"Bio","line":301},{"kind":12,"containerName":"SeqFeature::Generic","name":"Bio","line":307},{"line":401,"name":"Predicted","kind":12},{"name":"protein","kind":12,"line":401},{"containerName":"main::","name":"_prediction","children":[{"definition":"my","name":"$self","containerName":"_prediction","localvar":"my","kind":13,"line":422},{"containerName":"_prediction","kind":13,"name":"$self","line":424},{"containerName":"_prediction","kind":13,"name":"$self","line":424}],"detail":"($self)","definition":"sub","kind":12,"range":{"start":{"line":421,"character":0},"end":{"character":9999,"line":424}},"line":421,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Fgenesh.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Fgenesh\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christopher Dwan (chris@dwan.org)\n#\n# Copied, lock stock & barrel from Genscan.pm\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Fgenesh - parse results of one Fgenesh run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Fgenesh;\n\n   $fgenesh = Bio::Tools::Fgenesh->new(-file => 'result.fgenesh');\n   # filehandle:\n   $fgenesh = Bio::Tools::Fgenesh->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $fgensh->next_feature() is the same\n   while($gene = $fgenesh->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons: \n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $fgenesh->close();\n\n=head1 DESCRIPTION\n\nThe Fgenesh module provides a parser for Fgenesh (version 2) gene structure \nprediction output. It parses one gene prediction into a \nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module also implements the L<Bio::SeqAnalysisParserI> interface, and thus\ncan be used wherever such an object fits. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Dwan\n\nEmail chris-at-dwan.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Fgenesh;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nmy %ExonTags = ('CDSf' => 'Initial',\n\t\t'CDSi' => 'Internal',\n\t\t'CDSl' => 'Terminal',\n\t\t'CDSo' => 'Singleton');\n    \nsub _initialize_state {\n    my ($self,@args) = @_;\n    \n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /genscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /fgenesh/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $fgenesh->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Fgenesh result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $fgenesh->next_prediction()) { ... }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # get next gene structure\n    $gene = $self->_prediction();\n\n    if($gene) {\n\t# fill in predicted protein, and if available the predicted CDS\n\t#\n\n\t# use the seq stack if there's a seq on it\n\tmy $seqobj = pop(@{$self->{'_seqstack'}});\n        my ($id, $seq);\n\tunless ($seqobj) {\n\t   ($id, $seq) = $self->_read_fasta_seq();\n           my $alphabet;\n           if (($id =~ /mrna/) || ($id =~ /cds/)) { $alphabet = 'dna'; }\n           else { $alphabet = 'protein'; }\n           $seqobj = Bio::PrimarySeq->new('-seq'        => $seq,\n                                          '-display_id' => $id,\n                                          '-alphabet'   => $alphabet); \n        }\n\tif ($seqobj) {\n\n\t    # check that prediction number matches the prediction number\n\t    # indicated in the sequence id (there may be incomplete gene\n\t    # predictions that contain only signals with no associated protein\n            # prediction.\n\n\t    $gene->primary_tag() =~ /[^0-9]([0-9]+)$/;\n\t    my $prednr = $1;\n\t    if ($id !~ /_predicted_(\\w+)_$prednr/) {\n\t\t# this is not our sequence, so push back for next prediction\n\t\tpush(@{$self->{'_seqstack'}}, $seqobj);\n\t    } else {\n                if ($1 eq \"protein\") {\n\t\t  $gene->predicted_protein($seqobj);\n                } elsif (($1 eq \"mrna\") || ($1 eq \"cds\")) {\n                  $self->_has_cds(1);\n                  $gene->predicted_cds($seqobj);\n                  \n                  # Have to go back in and get the protein...\n                  ($id, $seq) = $self->_read_fasta_seq();\n                  if ($id =~ /_cds_/) { \n                    ($id, $seq) = $self->_read_fasta_seq(); \n                  }\n \n\t\t  $seqobj = Bio::PrimarySeq->new('-seq' => $seq,\n\t\t\t    \t\t         '-display_id' => $id,\n\t\t\t\t\t\t '-alphabet' => \"protein\");\n\t\t  $gene->predicted_protein($seqobj);\n\t\t}\n\t    }\n\t}\n    }\n\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n    my ($self) = @_;\n    my $gene;\n    my $seqname;\n\n    while(defined($_ = $self->_readline())) {\n\n\tif(/^\\s*(\\d+)\\s+([+\\-])/) {\n            my $line = $_;\n\n\t    # exon or signal\n\t    my $prednr = $1;\n            my $strand = ($2 eq '+') ? 1 : -1;\n\n\t    if(! defined($gene)) {\n\t\t$gene = Bio::Tools::Prediction::Gene->new(\n                                       '-primary' => \"GenePrediction$prednr\",\n\t\t\t\t       '-source' => 'Fgenesh');\n\t    }\n\t    # split into fields\n\t    chomp();\n\t    my @flds = split(/\\s+/, ' ' . $line);\n\t    ## NB - the above adds leading whitespace before the gene\n\t    ## number in case there was none (as quick patch to code\n\t    ## below which expects it but it is not present after 999\n\t    ## predictions!) This allows >999 predictions to be parsed.\n\n\t    # create the feature object depending on the type of signal\n\t    my $predobj;\n\t    my $is_exon = grep {$line =~ $_} keys(%ExonTags);\n            my ($start, $end);\n\t    if($is_exon) {\n\t\t$predobj = Bio::Tools::Prediction::Exon->new();\n                $predobj->score($flds[8]);\n                $start   = $flds[5];\n                $end     = $flds[7];\n\t    } else {\n\t\t# PolyA site, or TSS \n\t\t$predobj = Bio::SeqFeature::Generic->new();\n                $predobj->score($flds[5]);\n                $start   = $flds[4];\n                $end     = $flds[4];\n\t    }\n\t    # set common fields\n\t    $predobj->source_tag('Fgenesh');\n\t    $predobj->strand($strand);\n\n# Following tactical commenting-out made by\n# malcolm.cook@stowers-institute.org since coordinate reversal is\n# apparently vestigial copy/paste detritus from Genscan.pm origins of\n# this module and this is NOT needed for fgenesh (at least in v\n# 2.1.4).\n\n#\t    if($predobj->strand() == 1) {\n\t\t$predobj->start($start);\n\t\t$predobj->end($end);\n#\t    } else {\n#\t\t$predobj->end($start);\n#\t\t$predobj->start($end);\n#\t    }\n\n            # print STDERR \"start $start end $end\\n\";\n\t    # add to gene structure (should be done only when start and end\n\t    # are set, in order to allow for proper expansion of the range)\n\t    if($is_exon) {\n\t\t# first, set fields unique to exons\n\t\t$predobj->primary_tag($ExonTags{$flds[4]} . 'Exon');\n\t\t$predobj->is_coding(1);\n\t\tmy $cod_offset;\n\t\tif($predobj->strand() == 1) {\n\t\t    $cod_offset = ($flds[9] - $predobj->start()) % 3;\n\t\t    # Possible values are -2, -1, 0, 1, 2. -1 and -2 correspond\n\t\t    # to offsets 2 and 1, resp. Offset 3 is the same as 0.\n\t\t    $cod_offset += 3 if($cod_offset < 1);\t\t    \n\t\t} else {\n\t\t    # On the reverse strand the Genscan frame also refers to\n\t\t    # the first base of the first complete codon, but viewed\n\t\t    # from forward, which is the third base viewed from\n\t\t    # reverse.\n\t\t    $cod_offset = ($flds[11] - $predobj->end()) % 3;\n\t\t    # Possible values are -2, -1, 0, 1, 2. Due to the reverse\n\t\t    # situation, {2,-1} and {1,-2} correspond to offsets\n\t\t    # 1 and 2, resp. Offset 3 is the same as 0.\n\t\t    $cod_offset -= 3 if($cod_offset >= 0);\n\t\t    $cod_offset = -$cod_offset;\n\t\t}\n\t\t# Offsets 2 and 1 correspond to frame 1 and 2 (frame of exon\n\t\t# is the frame of the first base relative to the exon, or the\n\t\t# number of bases the first codon is missing).\n\t\t$predobj->frame(3 - $cod_offset);\n                # print STDERR \"  frame is \" . $predobj->frame() . \"\\n\";\n\t\t# then add to gene structure object\n\t\t$gene->add_exon($predobj, $ExonTags{$flds[1]});\t\t\n\t    } elsif($flds[3] eq 'PolA') {\n\t\t$predobj->primary_tag(\"PolyAsite\");\n\t\t$gene->poly_A_site($predobj);\n\t    } elsif($flds[3] eq 'TSS') {\n\t        $predobj->primary_tag(\"Promoter\"); # (hey! a TSS is NOT a promoter... what's going on here?...\n\t\t$gene->add_promoter($predobj);\n                #I'd like to do this (for now):\n\t\t#$predobj->primary_tag(\"TSS\"); #this is not the right model, but, it IS a feature at least.\n                #but the followg errs out\n\t\t#$gene->add_SeqFeature($predobj); #err: MSG: start is undefined when bounds at Bio::SeqFeature::Generic::add_SeqFeature 671 check since gene has no start yet\n\t    }\n\t    else {\n\t      $self->throw(\"unrecognized prediction line: \" . $line);\n\t    }\n\t    next;\n\t}\n\n\tif(/^\\s*$/ && defined($gene)) {\n\t    # current gene is completed\n\t    $gene->seq_id($seqname);\n\t    $self->_add_prediction($gene);\n\t    $gene = undef;\n\t    next;\n\t}\n\n\tif(/^(FGENESH)\\s+([\\d\\.]+)/) {\n\t    $self->analysis_method($1);\n\t    $self->analysis_method_version($2);\n            if (/\\s(\\S+)\\sgenomic DNA/) {\n              $self->analysis_subject($1);\n            }\n\t    next;\n\t}\n\n\tif(/^\\s*Seq name:\\s+(\\S+)/) {\n\t    $seqname = $1;\n\t    next;\n\t}\n        \n\t/^Predicted protein/ && do {\n\t    # section of predicted sequences\n\t    $self->_pushback($_);\n\t    last;\n\t};\n    }\n\n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : ","label":"_prediction($self)"}},{"name":"%self","containerName":null,"kind":13,"line":425},{"range":{"end":{"character":9999,"line":444},"start":{"character":0,"line":438}},"kind":12,"line":438,"signature":{"label":"_add_prediction($self,$gene)","parameters":[{"label":"$self"},{"label":"$gene"}],"documentation":"1;\n# $Id: Fgenesh.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Fgenesh\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christopher Dwan (chris@dwan.org)\n#\n# Copied, lock stock & barrel from Genscan.pm\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Fgenesh - parse results of one Fgenesh run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Fgenesh;\n\n   $fgenesh = Bio::Tools::Fgenesh->new(-file => 'result.fgenesh');\n   # filehandle:\n   $fgenesh = Bio::Tools::Fgenesh->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $fgensh->next_feature() is the same\n   while($gene = $fgenesh->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons: \n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $fgenesh->close();\n\n=head1 DESCRIPTION\n\nThe Fgenesh module provides a parser for Fgenesh (version 2) gene structure \nprediction output. It parses one gene prediction into a \nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module also implements the L<Bio::SeqAnalysisParserI> interface, and thus\ncan be used wherever such an object fits. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Dwan\n\nEmail chris-at-dwan.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Fgenesh;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nmy %ExonTags = ('CDSf' => 'Initial',\n\t\t'CDSi' => 'Internal',\n\t\t'CDSl' => 'Terminal',\n\t\t'CDSo' => 'Singleton');\n    \nsub _initialize_state {\n    my ($self,@args) = @_;\n    \n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /genscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /fgenesh/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $fgenesh->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Fgenesh result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $fgenesh->next_prediction()) { ... }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # get next gene structure\n    $gene = $self->_prediction();\n\n    if($gene) {\n\t# fill in predicted protein, and if available the predicted CDS\n\t#\n\n\t# use the seq stack if there's a seq on it\n\tmy $seqobj = pop(@{$self->{'_seqstack'}});\n        my ($id, $seq);\n\tunless ($seqobj) {\n\t   ($id, $seq) = $self->_read_fasta_seq();\n           my $alphabet;\n           if (($id =~ /mrna/) || ($id =~ /cds/)) { $alphabet = 'dna'; }\n           else { $alphabet = 'protein'; }\n           $seqobj = Bio::PrimarySeq->new('-seq'        => $seq,\n                                          '-display_id' => $id,\n                                          '-alphabet'   => $alphabet); \n        }\n\tif ($seqobj) {\n\n\t    # check that prediction number matches the prediction number\n\t    # indicated in the sequence id (there may be incomplete gene\n\t    # predictions that contain only signals with no associated protein\n            # prediction.\n\n\t    $gene->primary_tag() =~ /[^0-9]([0-9]+)$/;\n\t    my $prednr = $1;\n\t    if ($id !~ /_predicted_(\\w+)_$prednr/) {\n\t\t# this is not our sequence, so push back for next prediction\n\t\tpush(@{$self->{'_seqstack'}}, $seqobj);\n\t    } else {\n                if ($1 eq \"protein\") {\n\t\t  $gene->predicted_protein($seqobj);\n                } elsif (($1 eq \"mrna\") || ($1 eq \"cds\")) {\n                  $self->_has_cds(1);\n                  $gene->predicted_cds($seqobj);\n                  \n                  # Have to go back in and get the protein...\n                  ($id, $seq) = $self->_read_fasta_seq();\n                  if ($id =~ /_cds_/) { \n                    ($id, $seq) = $self->_read_fasta_seq(); \n                  }\n \n\t\t  $seqobj = Bio::PrimarySeq->new('-seq' => $seq,\n\t\t\t    \t\t         '-display_id' => $id,\n\t\t\t\t\t\t '-alphabet' => \"protein\");\n\t\t  $gene->predicted_protein($seqobj);\n\t\t}\n\t    }\n\t}\n    }\n\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n    my ($self) = @_;\n    my $gene;\n    my $seqname;\n\n    while(defined($_ = $self->_readline())) {\n\n\tif(/^\\s*(\\d+)\\s+([+\\-])/) {\n            my $line = $_;\n\n\t    # exon or signal\n\t    my $prednr = $1;\n            my $strand = ($2 eq '+') ? 1 : -1;\n\n\t    if(! defined($gene)) {\n\t\t$gene = Bio::Tools::Prediction::Gene->new(\n                                       '-primary' => \"GenePrediction$prednr\",\n\t\t\t\t       '-source' => 'Fgenesh');\n\t    }\n\t    # split into fields\n\t    chomp();\n\t    my @flds = split(/\\s+/, ' ' . $line);\n\t    ## NB - the above adds leading whitespace before the gene\n\t    ## number in case there was none (as quick patch to code\n\t    ## below which expects it but it is not present after 999\n\t    ## predictions!) This allows >999 predictions to be parsed.\n\n\t    # create the feature object depending on the type of signal\n\t    my $predobj;\n\t    my $is_exon = grep {$line =~ $_} keys(%ExonTags);\n            my ($start, $end);\n\t    if($is_exon) {\n\t\t$predobj = Bio::Tools::Prediction::Exon->new();\n                $predobj->score($flds[8]);\n                $start   = $flds[5];\n                $end     = $flds[7];\n\t    } else {\n\t\t# PolyA site, or TSS \n\t\t$predobj = Bio::SeqFeature::Generic->new();\n                $predobj->score($flds[5]);\n                $start   = $flds[4];\n                $end     = $flds[4];\n\t    }\n\t    # set common fields\n\t    $predobj->source_tag('Fgenesh');\n\t    $predobj->strand($strand);\n\n# Following tactical commenting-out made by\n# malcolm.cook@stowers-institute.org since coordinate reversal is\n# apparently vestigial copy/paste detritus from Genscan.pm origins of\n# this module and this is NOT needed for fgenesh (at least in v\n# 2.1.4).\n\n#\t    if($predobj->strand() == 1) {\n\t\t$predobj->start($start);\n\t\t$predobj->end($end);\n#\t    } else {\n#\t\t$predobj->end($start);\n#\t\t$predobj->start($end);\n#\t    }\n\n            # print STDERR \"start $start end $end\\n\";\n\t    # add to gene structure (should be done only when start and end\n\t    # are set, in order to allow for proper expansion of the range)\n\t    if($is_exon) {\n\t\t# first, set fields unique to exons\n\t\t$predobj->primary_tag($ExonTags{$flds[4]} . 'Exon');\n\t\t$predobj->is_coding(1);\n\t\tmy $cod_offset;\n\t\tif($predobj->strand() == 1) {\n\t\t    $cod_offset = ($flds[9] - $predobj->start()) % 3;\n\t\t    # Possible values are -2, -1, 0, 1, 2. -1 and -2 correspond\n\t\t    # to offsets 2 and 1, resp. Offset 3 is the same as 0.\n\t\t    $cod_offset += 3 if($cod_offset < 1);\t\t    \n\t\t} else {\n\t\t    # On the reverse strand the Genscan frame also refers to\n\t\t    # the first base of the first complete codon, but viewed\n\t\t    # from forward, which is the third base viewed from\n\t\t    # reverse.\n\t\t    $cod_offset = ($flds[11] - $predobj->end()) % 3;\n\t\t    # Possible values are -2, -1, 0, 1, 2. Due to the reverse\n\t\t    # situation, {2,-1} and {1,-2} correspond to offsets\n\t\t    # 1 and 2, resp. Offset 3 is the same as 0.\n\t\t    $cod_offset -= 3 if($cod_offset >= 0);\n\t\t    $cod_offset = -$cod_offset;\n\t\t}\n\t\t# Offsets 2 and 1 correspond to frame 1 and 2 (frame of exon\n\t\t# is the frame of the first base relative to the exon, or the\n\t\t# number of bases the first codon is missing).\n\t\t$predobj->frame(3 - $cod_offset);\n                # print STDERR \"  frame is \" . $predobj->frame() . \"\\n\";\n\t\t# then add to gene structure object\n\t\t$gene->add_exon($predobj, $ExonTags{$flds[1]});\t\t\n\t    } elsif($flds[3] eq 'PolA') {\n\t\t$predobj->primary_tag(\"PolyAsite\");\n\t\t$gene->poly_A_site($predobj);\n\t    } elsif($flds[3] eq 'TSS') {\n\t        $predobj->primary_tag(\"Promoter\"); # (hey! a TSS is NOT a promoter... what's going on here?...\n\t\t$gene->add_promoter($predobj);\n                #I'd like to do this (for now):\n\t\t#$predobj->primary_tag(\"TSS\"); #this is not the right model, but, it IS a feature at least.\n                #but the followg errs out\n\t\t#$gene->add_SeqFeature($predobj); #err: MSG: start is undefined when bounds at Bio::SeqFeature::Generic::add_SeqFeature 671 check since gene has no start yet\n\t    }\n\t    else {\n\t      $self->throw(\"unrecognized prediction line: \" . $line);\n\t    }\n\t    next;\n\t}\n\n\tif(/^\\s*$/ && defined($gene)) {\n\t    # current gene is completed\n\t    $gene->seq_id($seqname);\n\t    $self->_add_prediction($gene);\n\t    $gene = undef;\n\t    next;\n\t}\n\n\tif(/^(FGENESH)\\s+([\\d\\.]+)/) {\n\t    $self->analysis_method($1);\n\t    $self->analysis_method_version($2);\n            if (/\\s(\\S+)\\sgenomic DNA/) {\n              $self->analysis_subject($1);\n            }\n\t    next;\n\t}\n\n\tif(/^\\s*Seq name:\\s+(\\S+)/) {\n\t    $seqname = $1;\n\t    next;\n\t}\n        \n\t/^Predicted protein/ && do {\n\t    # section of predicted sequences\n\t    $self->_pushback($_);\n\t    last;\n\t};\n    }\n\n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : \n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_preds'}) && @{$self->{'_preds'}});\n    return shift(@{$self->{'_preds'}});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns : "},"containerName":"main::","name":"_add_prediction","children":[{"name":"$self","localvar":"my","containerName":"_add_prediction","kind":13,"line":439,"definition":"my"},{"line":439,"containerName":"_add_prediction","kind":13,"name":"$gene"},{"line":441,"containerName":"_add_prediction","kind":13,"name":"$self"},{"line":442,"containerName":"_add_prediction","kind":13,"name":"$self"},{"line":444,"name":"$self","kind":13,"containerName":"_add_prediction"}],"detail":"($self,$gene)","definition":"sub"},{"line":444,"containerName":null,"kind":13,"name":"$gene"},{"containerName":"main::","name":"_predictions_parsed","children":[{"containerName":"_predictions_parsed","localvar":"my","kind":13,"name":"$self","line":458,"definition":"my"},{"line":458,"kind":13,"containerName":"_predictions_parsed","name":"$val"},{"line":460,"containerName":"_predictions_parsed","kind":13,"name":"$self"},{"name":"$val","containerName":"_predictions_parsed","kind":13,"line":460},{"kind":13,"containerName":"_predictions_parsed","name":"$val","line":460},{"line":461,"kind":13,"containerName":"_predictions_parsed","name":"$self"},{"line":462,"kind":13,"containerName":"_predictions_parsed","name":"$self"},{"line":464,"kind":13,"containerName":"_predictions_parsed","name":"$self"}],"detail":"($self,$val)","definition":"sub","range":{"end":{"character":9999,"line":465},"start":{"character":0,"line":457}},"kind":12,"line":457,"signature":{"parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: Fgenesh.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Fgenesh\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christopher Dwan (chris@dwan.org)\n#\n# Copied, lock stock & barrel from Genscan.pm\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Fgenesh - parse results of one Fgenesh run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Fgenesh;\n\n   $fgenesh = Bio::Tools::Fgenesh->new(-file => 'result.fgenesh');\n   # filehandle:\n   $fgenesh = Bio::Tools::Fgenesh->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $fgensh->next_feature() is the same\n   while($gene = $fgenesh->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons: \n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $fgenesh->close();\n\n=head1 DESCRIPTION\n\nThe Fgenesh module provides a parser for Fgenesh (version 2) gene structure \nprediction output. It parses one gene prediction into a \nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module also implements the L<Bio::SeqAnalysisParserI> interface, and thus\ncan be used wherever such an object fits. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Dwan\n\nEmail chris-at-dwan.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Fgenesh;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nmy %ExonTags = ('CDSf' => 'Initial',\n\t\t'CDSi' => 'Internal',\n\t\t'CDSl' => 'Terminal',\n\t\t'CDSo' => 'Singleton');\n    \nsub _initialize_state {\n    my ($self,@args) = @_;\n    \n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /genscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /fgenesh/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $fgenesh->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Fgenesh result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $fgenesh->next_prediction()) { ... }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # get next gene structure\n    $gene = $self->_prediction();\n\n    if($gene) {\n\t# fill in predicted protein, and if available the predicted CDS\n\t#\n\n\t# use the seq stack if there's a seq on it\n\tmy $seqobj = pop(@{$self->{'_seqstack'}});\n        my ($id, $seq);\n\tunless ($seqobj) {\n\t   ($id, $seq) = $self->_read_fasta_seq();\n           my $alphabet;\n           if (($id =~ /mrna/) || ($id =~ /cds/)) { $alphabet = 'dna'; }\n           else { $alphabet = 'protein'; }\n           $seqobj = Bio::PrimarySeq->new('-seq'        => $seq,\n                                          '-display_id' => $id,\n                                          '-alphabet'   => $alphabet); \n        }\n\tif ($seqobj) {\n\n\t    # check that prediction number matches the prediction number\n\t    # indicated in the sequence id (there may be incomplete gene\n\t    # predictions that contain only signals with no associated protein\n            # prediction.\n\n\t    $gene->primary_tag() =~ /[^0-9]([0-9]+)$/;\n\t    my $prednr = $1;\n\t    if ($id !~ /_predicted_(\\w+)_$prednr/) {\n\t\t# this is not our sequence, so push back for next prediction\n\t\tpush(@{$self->{'_seqstack'}}, $seqobj);\n\t    } else {\n                if ($1 eq \"protein\") {\n\t\t  $gene->predicted_protein($seqobj);\n                } elsif (($1 eq \"mrna\") || ($1 eq \"cds\")) {\n                  $self->_has_cds(1);\n                  $gene->predicted_cds($seqobj);\n                  \n                  # Have to go back in and get the protein...\n                  ($id, $seq) = $self->_read_fasta_seq();\n                  if ($id =~ /_cds_/) { \n                    ($id, $seq) = $self->_read_fasta_seq(); \n                  }\n \n\t\t  $seqobj = Bio::PrimarySeq->new('-seq' => $seq,\n\t\t\t    \t\t         '-display_id' => $id,\n\t\t\t\t\t\t '-alphabet' => \"protein\");\n\t\t  $gene->predicted_protein($seqobj);\n\t\t}\n\t    }\n\t}\n    }\n\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n    my ($self) = @_;\n    my $gene;\n    my $seqname;\n\n    while(defined($_ = $self->_readline())) {\n\n\tif(/^\\s*(\\d+)\\s+([+\\-])/) {\n            my $line = $_;\n\n\t    # exon or signal\n\t    my $prednr = $1;\n            my $strand = ($2 eq '+') ? 1 : -1;\n\n\t    if(! defined($gene)) {\n\t\t$gene = Bio::Tools::Prediction::Gene->new(\n                                       '-primary' => \"GenePrediction$prednr\",\n\t\t\t\t       '-source' => 'Fgenesh');\n\t    }\n\t    # split into fields\n\t    chomp();\n\t    my @flds = split(/\\s+/, ' ' . $line);\n\t    ## NB - the above adds leading whitespace before the gene\n\t    ## number in case there was none (as quick patch to code\n\t    ## below which expects it but it is not present after 999\n\t    ## predictions!) This allows >999 predictions to be parsed.\n\n\t    # create the feature object depending on the type of signal\n\t    my $predobj;\n\t    my $is_exon = grep {$line =~ $_} keys(%ExonTags);\n            my ($start, $end);\n\t    if($is_exon) {\n\t\t$predobj = Bio::Tools::Prediction::Exon->new();\n                $predobj->score($flds[8]);\n                $start   = $flds[5];\n                $end     = $flds[7];\n\t    } else {\n\t\t# PolyA site, or TSS \n\t\t$predobj = Bio::SeqFeature::Generic->new();\n                $predobj->score($flds[5]);\n                $start   = $flds[4];\n                $end     = $flds[4];\n\t    }\n\t    # set common fields\n\t    $predobj->source_tag('Fgenesh');\n\t    $predobj->strand($strand);\n\n# Following tactical commenting-out made by\n# malcolm.cook@stowers-institute.org since coordinate reversal is\n# apparently vestigial copy/paste detritus from Genscan.pm origins of\n# this module and this is NOT needed for fgenesh (at least in v\n# 2.1.4).\n\n#\t    if($predobj->strand() == 1) {\n\t\t$predobj->start($start);\n\t\t$predobj->end($end);\n#\t    } else {\n#\t\t$predobj->end($start);\n#\t\t$predobj->start($end);\n#\t    }\n\n            # print STDERR \"start $start end $end\\n\";\n\t    # add to gene structure (should be done only when start and end\n\t    # are set, in order to allow for proper expansion of the range)\n\t    if($is_exon) {\n\t\t# first, set fields unique to exons\n\t\t$predobj->primary_tag($ExonTags{$flds[4]} . 'Exon');\n\t\t$predobj->is_coding(1);\n\t\tmy $cod_offset;\n\t\tif($predobj->strand() == 1) {\n\t\t    $cod_offset = ($flds[9] - $predobj->start()) % 3;\n\t\t    # Possible values are -2, -1, 0, 1, 2. -1 and -2 correspond\n\t\t    # to offsets 2 and 1, resp. Offset 3 is the same as 0.\n\t\t    $cod_offset += 3 if($cod_offset < 1);\t\t    \n\t\t} else {\n\t\t    # On the reverse strand the Genscan frame also refers to\n\t\t    # the first base of the first complete codon, but viewed\n\t\t    # from forward, which is the third base viewed from\n\t\t    # reverse.\n\t\t    $cod_offset = ($flds[11] - $predobj->end()) % 3;\n\t\t    # Possible values are -2, -1, 0, 1, 2. Due to the reverse\n\t\t    # situation, {2,-1} and {1,-2} correspond to offsets\n\t\t    # 1 and 2, resp. Offset 3 is the same as 0.\n\t\t    $cod_offset -= 3 if($cod_offset >= 0);\n\t\t    $cod_offset = -$cod_offset;\n\t\t}\n\t\t# Offsets 2 and 1 correspond to frame 1 and 2 (frame of exon\n\t\t# is the frame of the first base relative to the exon, or the\n\t\t# number of bases the first codon is missing).\n\t\t$predobj->frame(3 - $cod_offset);\n                # print STDERR \"  frame is \" . $predobj->frame() . \"\\n\";\n\t\t# then add to gene structure object\n\t\t$gene->add_exon($predobj, $ExonTags{$flds[1]});\t\t\n\t    } elsif($flds[3] eq 'PolA') {\n\t\t$predobj->primary_tag(\"PolyAsite\");\n\t\t$gene->poly_A_site($predobj);\n\t    } elsif($flds[3] eq 'TSS') {\n\t        $predobj->primary_tag(\"Promoter\"); # (hey! a TSS is NOT a promoter... what's going on here?...\n\t\t$gene->add_promoter($predobj);\n                #I'd like to do this (for now):\n\t\t#$predobj->primary_tag(\"TSS\"); #this is not the right model, but, it IS a feature at least.\n                #but the followg errs out\n\t\t#$gene->add_SeqFeature($predobj); #err: MSG: start is undefined when bounds at Bio::SeqFeature::Generic::add_SeqFeature 671 check since gene has no start yet\n\t    }\n\t    else {\n\t      $self->throw(\"unrecognized prediction line: \" . $line);\n\t    }\n\t    next;\n\t}\n\n\tif(/^\\s*$/ && defined($gene)) {\n\t    # current gene is completed\n\t    $gene->seq_id($seqname);\n\t    $self->_add_prediction($gene);\n\t    $gene = undef;\n\t    next;\n\t}\n\n\tif(/^(FGENESH)\\s+([\\d\\.]+)/) {\n\t    $self->analysis_method($1);\n\t    $self->analysis_method_version($2);\n            if (/\\s(\\S+)\\sgenomic DNA/) {\n              $self->analysis_subject($1);\n            }\n\t    next;\n\t}\n\n\tif(/^\\s*Seq name:\\s+(\\S+)/) {\n\t    $seqname = $1;\n\t    next;\n\t}\n        \n\t/^Predicted protein/ && do {\n\t    # section of predicted sequences\n\t    $self->_pushback($_);\n\t    last;\n\t};\n    }\n\n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : \n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_preds'}) && @{$self->{'_preds'}});\n    return shift(@{$self->{'_preds'}});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns : \n\n\nsub _add_prediction {\n    my ($self, $gene) = @_;\n\n    if(! exists($self->{'_preds'})) {\n\t$self->{'_preds'} = [];\n    }\n    push(@{$self->{'_preds'}}, $gene);\n}\n\n=head2 _predictions_parsed\n\n Title   : _predictions_parsed\n Usage   : $obj->_predictions_parsed\n Function: internal\n Example :\n Returns : TRUE or FALSE","label":"_predictions_parsed($self,$val)"}},{"definition":"sub","detail":"($self,$val)","children":[{"definition":"my","line":478,"name":"$self","kind":13,"localvar":"my","containerName":"_has_cds"},{"line":478,"name":"$val","containerName":"_has_cds","kind":13},{"containerName":"_has_cds","kind":13,"name":"$self","line":480},{"line":480,"containerName":"_has_cds","kind":13,"name":"$val"},{"line":480,"name":"$val","containerName":"_has_cds","kind":13},{"line":481,"kind":13,"containerName":"_has_cds","name":"$self"},{"line":482,"name":"$self","kind":13,"containerName":"_has_cds"},{"line":484,"containerName":"_has_cds","kind":13,"name":"$self"}],"name":"_has_cds","containerName":"main::","signature":{"documentation":"1;\n# $Id: Fgenesh.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Fgenesh\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christopher Dwan (chris@dwan.org)\n#\n# Copied, lock stock & barrel from Genscan.pm\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Fgenesh - parse results of one Fgenesh run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Fgenesh;\n\n   $fgenesh = Bio::Tools::Fgenesh->new(-file => 'result.fgenesh');\n   # filehandle:\n   $fgenesh = Bio::Tools::Fgenesh->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $fgensh->next_feature() is the same\n   while($gene = $fgenesh->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons: \n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $fgenesh->close();\n\n=head1 DESCRIPTION\n\nThe Fgenesh module provides a parser for Fgenesh (version 2) gene structure \nprediction output. It parses one gene prediction into a \nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module also implements the L<Bio::SeqAnalysisParserI> interface, and thus\ncan be used wherever such an object fits. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Dwan\n\nEmail chris-at-dwan.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Fgenesh;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nmy %ExonTags = ('CDSf' => 'Initial',\n\t\t'CDSi' => 'Internal',\n\t\t'CDSl' => 'Terminal',\n\t\t'CDSo' => 'Singleton');\n    \nsub _initialize_state {\n    my ($self,@args) = @_;\n    \n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /genscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /fgenesh/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $fgenesh->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Fgenesh result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $fgenesh->next_prediction()) { ... }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # get next gene structure\n    $gene = $self->_prediction();\n\n    if($gene) {\n\t# fill in predicted protein, and if available the predicted CDS\n\t#\n\n\t# use the seq stack if there's a seq on it\n\tmy $seqobj = pop(@{$self->{'_seqstack'}});\n        my ($id, $seq);\n\tunless ($seqobj) {\n\t   ($id, $seq) = $self->_read_fasta_seq();\n           my $alphabet;\n           if (($id =~ /mrna/) || ($id =~ /cds/)) { $alphabet = 'dna'; }\n           else { $alphabet = 'protein'; }\n           $seqobj = Bio::PrimarySeq->new('-seq'        => $seq,\n                                          '-display_id' => $id,\n                                          '-alphabet'   => $alphabet); \n        }\n\tif ($seqobj) {\n\n\t    # check that prediction number matches the prediction number\n\t    # indicated in the sequence id (there may be incomplete gene\n\t    # predictions that contain only signals with no associated protein\n            # prediction.\n\n\t    $gene->primary_tag() =~ /[^0-9]([0-9]+)$/;\n\t    my $prednr = $1;\n\t    if ($id !~ /_predicted_(\\w+)_$prednr/) {\n\t\t# this is not our sequence, so push back for next prediction\n\t\tpush(@{$self->{'_seqstack'}}, $seqobj);\n\t    } else {\n                if ($1 eq \"protein\") {\n\t\t  $gene->predicted_protein($seqobj);\n                } elsif (($1 eq \"mrna\") || ($1 eq \"cds\")) {\n                  $self->_has_cds(1);\n                  $gene->predicted_cds($seqobj);\n                  \n                  # Have to go back in and get the protein...\n                  ($id, $seq) = $self->_read_fasta_seq();\n                  if ($id =~ /_cds_/) { \n                    ($id, $seq) = $self->_read_fasta_seq(); \n                  }\n \n\t\t  $seqobj = Bio::PrimarySeq->new('-seq' => $seq,\n\t\t\t    \t\t         '-display_id' => $id,\n\t\t\t\t\t\t '-alphabet' => \"protein\");\n\t\t  $gene->predicted_protein($seqobj);\n\t\t}\n\t    }\n\t}\n    }\n\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n    my ($self) = @_;\n    my $gene;\n    my $seqname;\n\n    while(defined($_ = $self->_readline())) {\n\n\tif(/^\\s*(\\d+)\\s+([+\\-])/) {\n            my $line = $_;\n\n\t    # exon or signal\n\t    my $prednr = $1;\n            my $strand = ($2 eq '+') ? 1 : -1;\n\n\t    if(! defined($gene)) {\n\t\t$gene = Bio::Tools::Prediction::Gene->new(\n                                       '-primary' => \"GenePrediction$prednr\",\n\t\t\t\t       '-source' => 'Fgenesh');\n\t    }\n\t    # split into fields\n\t    chomp();\n\t    my @flds = split(/\\s+/, ' ' . $line);\n\t    ## NB - the above adds leading whitespace before the gene\n\t    ## number in case there was none (as quick patch to code\n\t    ## below which expects it but it is not present after 999\n\t    ## predictions!) This allows >999 predictions to be parsed.\n\n\t    # create the feature object depending on the type of signal\n\t    my $predobj;\n\t    my $is_exon = grep {$line =~ $_} keys(%ExonTags);\n            my ($start, $end);\n\t    if($is_exon) {\n\t\t$predobj = Bio::Tools::Prediction::Exon->new();\n                $predobj->score($flds[8]);\n                $start   = $flds[5];\n                $end     = $flds[7];\n\t    } else {\n\t\t# PolyA site, or TSS \n\t\t$predobj = Bio::SeqFeature::Generic->new();\n                $predobj->score($flds[5]);\n                $start   = $flds[4];\n                $end     = $flds[4];\n\t    }\n\t    # set common fields\n\t    $predobj->source_tag('Fgenesh');\n\t    $predobj->strand($strand);\n\n# Following tactical commenting-out made by\n# malcolm.cook@stowers-institute.org since coordinate reversal is\n# apparently vestigial copy/paste detritus from Genscan.pm origins of\n# this module and this is NOT needed for fgenesh (at least in v\n# 2.1.4).\n\n#\t    if($predobj->strand() == 1) {\n\t\t$predobj->start($start);\n\t\t$predobj->end($end);\n#\t    } else {\n#\t\t$predobj->end($start);\n#\t\t$predobj->start($end);\n#\t    }\n\n            # print STDERR \"start $start end $end\\n\";\n\t    # add to gene structure (should be done only when start and end\n\t    # are set, in order to allow for proper expansion of the range)\n\t    if($is_exon) {\n\t\t# first, set fields unique to exons\n\t\t$predobj->primary_tag($ExonTags{$flds[4]} . 'Exon');\n\t\t$predobj->is_coding(1);\n\t\tmy $cod_offset;\n\t\tif($predobj->strand() == 1) {\n\t\t    $cod_offset = ($flds[9] - $predobj->start()) % 3;\n\t\t    # Possible values are -2, -1, 0, 1, 2. -1 and -2 correspond\n\t\t    # to offsets 2 and 1, resp. Offset 3 is the same as 0.\n\t\t    $cod_offset += 3 if($cod_offset < 1);\t\t    \n\t\t} else {\n\t\t    # On the reverse strand the Genscan frame also refers to\n\t\t    # the first base of the first complete codon, but viewed\n\t\t    # from forward, which is the third base viewed from\n\t\t    # reverse.\n\t\t    $cod_offset = ($flds[11] - $predobj->end()) % 3;\n\t\t    # Possible values are -2, -1, 0, 1, 2. Due to the reverse\n\t\t    # situation, {2,-1} and {1,-2} correspond to offsets\n\t\t    # 1 and 2, resp. Offset 3 is the same as 0.\n\t\t    $cod_offset -= 3 if($cod_offset >= 0);\n\t\t    $cod_offset = -$cod_offset;\n\t\t}\n\t\t# Offsets 2 and 1 correspond to frame 1 and 2 (frame of exon\n\t\t# is the frame of the first base relative to the exon, or the\n\t\t# number of bases the first codon is missing).\n\t\t$predobj->frame(3 - $cod_offset);\n                # print STDERR \"  frame is \" . $predobj->frame() . \"\\n\";\n\t\t# then add to gene structure object\n\t\t$gene->add_exon($predobj, $ExonTags{$flds[1]});\t\t\n\t    } elsif($flds[3] eq 'PolA') {\n\t\t$predobj->primary_tag(\"PolyAsite\");\n\t\t$gene->poly_A_site($predobj);\n\t    } elsif($flds[3] eq 'TSS') {\n\t        $predobj->primary_tag(\"Promoter\"); # (hey! a TSS is NOT a promoter... what's going on here?...\n\t\t$gene->add_promoter($predobj);\n                #I'd like to do this (for now):\n\t\t#$predobj->primary_tag(\"TSS\"); #this is not the right model, but, it IS a feature at least.\n                #but the followg errs out\n\t\t#$gene->add_SeqFeature($predobj); #err: MSG: start is undefined when bounds at Bio::SeqFeature::Generic::add_SeqFeature 671 check since gene has no start yet\n\t    }\n\t    else {\n\t      $self->throw(\"unrecognized prediction line: \" . $line);\n\t    }\n\t    next;\n\t}\n\n\tif(/^\\s*$/ && defined($gene)) {\n\t    # current gene is completed\n\t    $gene->seq_id($seqname);\n\t    $self->_add_prediction($gene);\n\t    $gene = undef;\n\t    next;\n\t}\n\n\tif(/^(FGENESH)\\s+([\\d\\.]+)/) {\n\t    $self->analysis_method($1);\n\t    $self->analysis_method_version($2);\n            if (/\\s(\\S+)\\sgenomic DNA/) {\n              $self->analysis_subject($1);\n            }\n\t    next;\n\t}\n\n\tif(/^\\s*Seq name:\\s+(\\S+)/) {\n\t    $seqname = $1;\n\t    next;\n\t}\n        \n\t/^Predicted protein/ && do {\n\t    # section of predicted sequences\n\t    $self->_pushback($_);\n\t    last;\n\t};\n    }\n\n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : \n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_preds'}) && @{$self->{'_preds'}});\n    return shift(@{$self->{'_preds'}});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns : \n\n\nsub _add_prediction {\n    my ($self, $gene) = @_;\n\n    if(! exists($self->{'_preds'})) {\n\t$self->{'_preds'} = [];\n    }\n    push(@{$self->{'_preds'}}, $gene);\n}\n\n=head2 _predictions_parsed\n\n Title   : _predictions_parsed\n Usage   : $obj->_predictions_parsed\n Function: internal\n Example :\n Returns : TRUE or FALSE\n\n\nsub _predictions_parsed {\n    my ($self, $val) = @_;\n\n    $self->{'_preds_parsed'} = $val if $val;\n    if(! exists($self->{'_preds_parsed'})) {\n\t$self->{'_preds_parsed'} = 0;\n    }\n    return $self->{'_preds_parsed'};\n}\n\n=head2 _has_cds\n\n Title   : _has_cds()\n Usage   : $obj->_has_cds()\n Function: Whether or not the result contains the predicted CDSs, too.\n Example :\n Returns : TRUE or FALSE","parameters":[{"label":"$self"},{"label":"$val"}],"label":"_has_cds($self,$val)"},"line":477,"range":{"start":{"character":0,"line":477},"end":{"character":9999,"line":485}},"kind":12},{"signature":{"label":"_read_fasta_seq($self)","documentation":"1;\n# $Id: Fgenesh.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Fgenesh\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christopher Dwan (chris@dwan.org)\n#\n# Copied, lock stock & barrel from Genscan.pm\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Fgenesh - parse results of one Fgenesh run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::Fgenesh;\n\n   $fgenesh = Bio::Tools::Fgenesh->new(-file => 'result.fgenesh');\n   # filehandle:\n   $fgenesh = Bio::Tools::Fgenesh->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $fgensh->next_feature() is the same\n   while($gene = $fgenesh->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene, which inherits\n       # off Bio::SeqFeature::Gene::Transcript.\n       #\n       # $gene->exons() returns an array of \n       # Bio::Tools::Prediction::Exon objects\n       # all exons:\n       @exon_arr = $gene->exons();\n\n       # initial exons only\n       @init_exons = $gene->exons('Initial');\n       # internal exons only\n       @intrl_exons = $gene->exons('Internal');\n       # terminal exons only\n       @term_exons = $gene->exons('Terminal');\n       # singleton exons: \n       ($single_exon) = $gene->exons();\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $fgenesh->close();\n\n=head1 DESCRIPTION\n\nThe Fgenesh module provides a parser for Fgenesh (version 2) gene structure \nprediction output. It parses one gene prediction into a \nBio::SeqFeature::Gene::Transcript- derived object.\n\nThis module also implements the L<Bio::SeqAnalysisParserI> interface, and thus\ncan be used wherever such an object fits. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Dwan\n\nEmail chris-at-dwan.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Fgenesh;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Gene;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nmy %ExonTags = ('CDSf' => 'Initial',\n\t\t'CDSi' => 'Internal',\n\t\t'CDSl' => 'Terminal',\n\t\t'CDSo' => 'Singleton');\n    \nsub _initialize_state {\n    my ($self,@args) = @_;\n    \n    # first call the inherited method!\n    $self->SUPER::_initialize_state(@args);\n\n    # our private state variables\n    $self->{'_preds_parsed'} = 0;\n    $self->{'_has_cds'} = 0;\n    # array of pre-parsed predictions\n    $self->{'_preds'} = [];\n    # seq stack\n    $self->{'_seqstack'} = [];\n}\n\n=head2 analysis_method\n\n Usage     : $genscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /genscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /fgenesh/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $fgenesh->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the Fgenesh result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $fgenesh->next_prediction()) { ... }\n Function: Returns the next gene structure prediction of the Genscan result\n           file. Call this method repeatedly until FALSE is returned.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my $gene;\n\n    # if the prediction section hasn't been parsed yet, we do this now\n    $self->_parse_predictions() unless $self->_predictions_parsed();\n\n    # get next gene structure\n    $gene = $self->_prediction();\n\n    if($gene) {\n\t# fill in predicted protein, and if available the predicted CDS\n\t#\n\n\t# use the seq stack if there's a seq on it\n\tmy $seqobj = pop(@{$self->{'_seqstack'}});\n        my ($id, $seq);\n\tunless ($seqobj) {\n\t   ($id, $seq) = $self->_read_fasta_seq();\n           my $alphabet;\n           if (($id =~ /mrna/) || ($id =~ /cds/)) { $alphabet = 'dna'; }\n           else { $alphabet = 'protein'; }\n           $seqobj = Bio::PrimarySeq->new('-seq'        => $seq,\n                                          '-display_id' => $id,\n                                          '-alphabet'   => $alphabet); \n        }\n\tif ($seqobj) {\n\n\t    # check that prediction number matches the prediction number\n\t    # indicated in the sequence id (there may be incomplete gene\n\t    # predictions that contain only signals with no associated protein\n            # prediction.\n\n\t    $gene->primary_tag() =~ /[^0-9]([0-9]+)$/;\n\t    my $prednr = $1;\n\t    if ($id !~ /_predicted_(\\w+)_$prednr/) {\n\t\t# this is not our sequence, so push back for next prediction\n\t\tpush(@{$self->{'_seqstack'}}, $seqobj);\n\t    } else {\n                if ($1 eq \"protein\") {\n\t\t  $gene->predicted_protein($seqobj);\n                } elsif (($1 eq \"mrna\") || ($1 eq \"cds\")) {\n                  $self->_has_cds(1);\n                  $gene->predicted_cds($seqobj);\n                  \n                  # Have to go back in and get the protein...\n                  ($id, $seq) = $self->_read_fasta_seq();\n                  if ($id =~ /_cds_/) { \n                    ($id, $seq) = $self->_read_fasta_seq(); \n                  }\n \n\t\t  $seqobj = Bio::PrimarySeq->new('-seq' => $seq,\n\t\t\t    \t\t         '-display_id' => $id,\n\t\t\t\t\t\t '-alphabet' => \"protein\");\n\t\t  $gene->predicted_protein($seqobj);\n\t\t}\n\t    }\n\t}\n    }\n\n    return $gene;\n}\n\n=head2 _parse_predictions\n\n Title   : _parse_predictions()\n Usage   : $obj->_parse_predictions()\n Function: Parses the prediction section. Automatically called by\n           next_prediction() if not yet done.\n Example :\n Returns : \n\n\nsub _parse_predictions {\n    my ($self) = @_;\n    my $gene;\n    my $seqname;\n\n    while(defined($_ = $self->_readline())) {\n\n\tif(/^\\s*(\\d+)\\s+([+\\-])/) {\n            my $line = $_;\n\n\t    # exon or signal\n\t    my $prednr = $1;\n            my $strand = ($2 eq '+') ? 1 : -1;\n\n\t    if(! defined($gene)) {\n\t\t$gene = Bio::Tools::Prediction::Gene->new(\n                                       '-primary' => \"GenePrediction$prednr\",\n\t\t\t\t       '-source' => 'Fgenesh');\n\t    }\n\t    # split into fields\n\t    chomp();\n\t    my @flds = split(/\\s+/, ' ' . $line);\n\t    ## NB - the above adds leading whitespace before the gene\n\t    ## number in case there was none (as quick patch to code\n\t    ## below which expects it but it is not present after 999\n\t    ## predictions!) This allows >999 predictions to be parsed.\n\n\t    # create the feature object depending on the type of signal\n\t    my $predobj;\n\t    my $is_exon = grep {$line =~ $_} keys(%ExonTags);\n            my ($start, $end);\n\t    if($is_exon) {\n\t\t$predobj = Bio::Tools::Prediction::Exon->new();\n                $predobj->score($flds[8]);\n                $start   = $flds[5];\n                $end     = $flds[7];\n\t    } else {\n\t\t# PolyA site, or TSS \n\t\t$predobj = Bio::SeqFeature::Generic->new();\n                $predobj->score($flds[5]);\n                $start   = $flds[4];\n                $end     = $flds[4];\n\t    }\n\t    # set common fields\n\t    $predobj->source_tag('Fgenesh');\n\t    $predobj->strand($strand);\n\n# Following tactical commenting-out made by\n# malcolm.cook@stowers-institute.org since coordinate reversal is\n# apparently vestigial copy/paste detritus from Genscan.pm origins of\n# this module and this is NOT needed for fgenesh (at least in v\n# 2.1.4).\n\n#\t    if($predobj->strand() == 1) {\n\t\t$predobj->start($start);\n\t\t$predobj->end($end);\n#\t    } else {\n#\t\t$predobj->end($start);\n#\t\t$predobj->start($end);\n#\t    }\n\n            # print STDERR \"start $start end $end\\n\";\n\t    # add to gene structure (should be done only when start and end\n\t    # are set, in order to allow for proper expansion of the range)\n\t    if($is_exon) {\n\t\t# first, set fields unique to exons\n\t\t$predobj->primary_tag($ExonTags{$flds[4]} . 'Exon');\n\t\t$predobj->is_coding(1);\n\t\tmy $cod_offset;\n\t\tif($predobj->strand() == 1) {\n\t\t    $cod_offset = ($flds[9] - $predobj->start()) % 3;\n\t\t    # Possible values are -2, -1, 0, 1, 2. -1 and -2 correspond\n\t\t    # to offsets 2 and 1, resp. Offset 3 is the same as 0.\n\t\t    $cod_offset += 3 if($cod_offset < 1);\t\t    \n\t\t} else {\n\t\t    # On the reverse strand the Genscan frame also refers to\n\t\t    # the first base of the first complete codon, but viewed\n\t\t    # from forward, which is the third base viewed from\n\t\t    # reverse.\n\t\t    $cod_offset = ($flds[11] - $predobj->end()) % 3;\n\t\t    # Possible values are -2, -1, 0, 1, 2. Due to the reverse\n\t\t    # situation, {2,-1} and {1,-2} correspond to offsets\n\t\t    # 1 and 2, resp. Offset 3 is the same as 0.\n\t\t    $cod_offset -= 3 if($cod_offset >= 0);\n\t\t    $cod_offset = -$cod_offset;\n\t\t}\n\t\t# Offsets 2 and 1 correspond to frame 1 and 2 (frame of exon\n\t\t# is the frame of the first base relative to the exon, or the\n\t\t# number of bases the first codon is missing).\n\t\t$predobj->frame(3 - $cod_offset);\n                # print STDERR \"  frame is \" . $predobj->frame() . \"\\n\";\n\t\t# then add to gene structure object\n\t\t$gene->add_exon($predobj, $ExonTags{$flds[1]});\t\t\n\t    } elsif($flds[3] eq 'PolA') {\n\t\t$predobj->primary_tag(\"PolyAsite\");\n\t\t$gene->poly_A_site($predobj);\n\t    } elsif($flds[3] eq 'TSS') {\n\t        $predobj->primary_tag(\"Promoter\"); # (hey! a TSS is NOT a promoter... what's going on here?...\n\t\t$gene->add_promoter($predobj);\n                #I'd like to do this (for now):\n\t\t#$predobj->primary_tag(\"TSS\"); #this is not the right model, but, it IS a feature at least.\n                #but the followg errs out\n\t\t#$gene->add_SeqFeature($predobj); #err: MSG: start is undefined when bounds at Bio::SeqFeature::Generic::add_SeqFeature 671 check since gene has no start yet\n\t    }\n\t    else {\n\t      $self->throw(\"unrecognized prediction line: \" . $line);\n\t    }\n\t    next;\n\t}\n\n\tif(/^\\s*$/ && defined($gene)) {\n\t    # current gene is completed\n\t    $gene->seq_id($seqname);\n\t    $self->_add_prediction($gene);\n\t    $gene = undef;\n\t    next;\n\t}\n\n\tif(/^(FGENESH)\\s+([\\d\\.]+)/) {\n\t    $self->analysis_method($1);\n\t    $self->analysis_method_version($2);\n            if (/\\s(\\S+)\\sgenomic DNA/) {\n              $self->analysis_subject($1);\n            }\n\t    next;\n\t}\n\n\tif(/^\\s*Seq name:\\s+(\\S+)/) {\n\t    $seqname = $1;\n\t    next;\n\t}\n        \n\t/^Predicted protein/ && do {\n\t    # section of predicted sequences\n\t    $self->_pushback($_);\n\t    last;\n\t};\n    }\n\n    $self->_predictions_parsed(1);\n}\n\n=head2 _prediction\n\n Title   : _prediction()\n Usage   : $gene = $obj->_prediction()\n Function: internal\n Example :\n Returns : \n\n\nsub _prediction {\n    my ($self) = @_;\n\n    return unless(exists($self->{'_preds'}) && @{$self->{'_preds'}});\n    return shift(@{$self->{'_preds'}});\n}\n\n=head2 _add_prediction\n\n Title   : _add_prediction()\n Usage   : $obj->_add_prediction($gene)\n Function: internal\n Example :\n Returns : \n\n\nsub _add_prediction {\n    my ($self, $gene) = @_;\n\n    if(! exists($self->{'_preds'})) {\n\t$self->{'_preds'} = [];\n    }\n    push(@{$self->{'_preds'}}, $gene);\n}\n\n=head2 _predictions_parsed\n\n Title   : _predictions_parsed\n Usage   : $obj->_predictions_parsed\n Function: internal\n Example :\n Returns : TRUE or FALSE\n\n\nsub _predictions_parsed {\n    my ($self, $val) = @_;\n\n    $self->{'_preds_parsed'} = $val if $val;\n    if(! exists($self->{'_preds_parsed'})) {\n\t$self->{'_preds_parsed'} = 0;\n    }\n    return $self->{'_preds_parsed'};\n}\n\n=head2 _has_cds\n\n Title   : _has_cds()\n Usage   : $obj->_has_cds()\n Function: Whether or not the result contains the predicted CDSs, too.\n Example :\n Returns : TRUE or FALSE\n\n\nsub _has_cds {\n    my ($self, $val) = @_;\n\n    $self->{'_has_cds'} = $val if $val;\n    if(! exists($self->{'_has_cds'})) {\n\t$self->{'_has_cds'} = 0;\n    }\n    return $self->{'_has_cds'};\n}\n\n=head2 _read_fasta_seq\n\n Title   : _read_fasta_seq()\n Usage   : ($id,$seqstr) = $obj->_read_fasta_seq();\n Function: Simple but specialised FASTA format sequence reader. Uses\n           $self->_readline() to retrieve input, and is able to strip off\n           the traling description lines.\n Example :\n Returns : An array of two elements: fasta_id & sequence","parameters":[{"label":"$self"}]},"range":{"start":{"character":0,"line":499},"end":{"line":546,"character":9999}},"kind":12,"line":499,"detail":"($self)","definition":"sub","containerName":"main::","name":"_read_fasta_seq","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_read_fasta_seq","name":"$self","line":500},{"line":501,"kind":13,"localvar":"my","containerName":"_read_fasta_seq","name":"$id","definition":"my"},{"containerName":"_read_fasta_seq","kind":13,"name":"$seq","line":501},{"definition":"my","line":504,"name":"$entry","localvar":"my","kind":13,"containerName":"_read_fasta_seq"},{"line":504,"containerName":"_read_fasta_seq","kind":13,"name":"$self"},{"line":504,"name":"_readline","kind":12,"containerName":"_read_fasta_seq"},{"line":506,"name":"$entry","containerName":"_read_fasta_seq","kind":13},{"kind":13,"containerName":"_read_fasta_seq","name":"$entry","line":507},{"line":507,"kind":13,"containerName":"_read_fasta_seq","name":"$self"},{"line":507,"name":"_readline","containerName":"_read_fasta_seq","kind":12},{"line":507,"name":"$entry","containerName":"_read_fasta_seq","kind":13},{"containerName":"_read_fasta_seq","kind":13,"name":"$entry","line":511},{"name":"$entry","kind":13,"containerName":"_read_fasta_seq","line":512},{"kind":13,"containerName":"_read_fasta_seq","name":"$id","line":514},{"line":515,"name":"$entry","containerName":"_read_fasta_seq","kind":13},{"containerName":"_read_fasta_seq","kind":13,"name":"$id","line":517},{"containerName":"_read_fasta_seq","kind":13,"name":"$entry","line":518},{"line":519,"containerName":"_read_fasta_seq","kind":13,"name":"$id"},{"line":521,"containerName":"_read_fasta_seq","kind":13,"name":"$seq"},{"kind":13,"containerName":"_read_fasta_seq","name":"$entry","line":522},{"name":"$self","containerName":"_read_fasta_seq","kind":13,"line":522},{"name":"_readline","containerName":"_read_fasta_seq","kind":12,"line":522},{"definition":"my","containerName":"_read_fasta_seq","localvar":"my","kind":13,"name":"$done","line":525},{"line":526,"containerName":"_read_fasta_seq","kind":13,"name":"$done"},{"line":528,"kind":13,"containerName":"_read_fasta_seq","name":"$entry"},{"name":"$id","containerName":"_read_fasta_seq","kind":13,"line":528},{"containerName":"_read_fasta_seq","kind":13,"name":"$entry","line":530},{"line":530,"name":"$self","containerName":"_read_fasta_seq","kind":13},{"line":530,"name":"_readline","kind":12,"containerName":"_read_fasta_seq"},{"kind":13,"containerName":"_read_fasta_seq","name":"$seq","line":532},{"line":532,"containerName":"_read_fasta_seq","kind":13,"name":"$entry"},{"name":"$entry","containerName":"_read_fasta_seq","kind":13,"line":536},{"line":536,"containerName":"_read_fasta_seq","kind":13,"name":"$self"},{"line":536,"name":"_readline","kind":12,"containerName":"_read_fasta_seq"},{"kind":13,"containerName":"_read_fasta_seq","name":"$entry","line":537},{"line":538,"kind":13,"containerName":"_read_fasta_seq","name":"$entry"},{"line":538,"name":"$id","containerName":"_read_fasta_seq","kind":13},{"name":"$self","containerName":"_read_fasta_seq","kind":13,"line":539},{"name":"_pushback","kind":12,"containerName":"_read_fasta_seq","line":539},{"line":539,"name":"$entry","kind":13,"containerName":"_read_fasta_seq"},{"line":544,"kind":13,"containerName":"_read_fasta_seq","name":"$seq"},{"containerName":"_read_fasta_seq","kind":13,"name":"$id","line":545},{"line":545,"containerName":"_read_fasta_seq","kind":13,"name":"$seq"}]}]}