{"version":5,"vars":[{"line":95,"kind":2,"containerName":"","name":"base"},{"line":109,"kind":12,"range":{"start":{"character":0,"line":109},"end":{"character":9999,"line":118}},"signature":{"label":"next_Item($self,$request)","parameters":[{"label":"$self"},{"label":"$request"}],"documentation":"1;\n# $Id: ItemContainerI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EUtilities::Summary::ItemContainerI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# Part of the EUtilities BioPerl package\n\n=head1 NAME\n\nBio::Tools::EUtilities::Summary::ItemContainerI - abtract interface methods\nfor accessing Item information from any Item-containing class.  This pertains\nto either DocSums or to Items themselves (which can be layered)\n\n=head1 SYNOPSIS\n\n  # Implement ItemContainerI\n\n  # $foo is any ItemContainerI (current implementations are DocSum and Item itself)\n  \n  while (my $item = $foo->next_Item) { # iterate through contained Items\n     # do stuff here\n  }\n  \n  @items = $foo->get_Items;  # all Items in the container (hierarchy intact)\n  @items = $foo->get_all_Items;  # all Items in the container (flattened)\n  @items = $foo->get_Items_by_name('bar'); # Specifically named Items\n  ($content) = $foo->get_contents_by_name('bar'); # content from specific Items\n  ($type) = $foo->get_type_by_name('bar'); # data type from specific Items\n\n=head1 DESCRIPTION\n\nDocSum data, as returned from esummary, normally is a simple list of\nitem-content-content_type groups. However, items can also contain nested data to\nrepresent more complex data (such as structural data). This interface describes\nthe basic methods to generically retrieve the next layer of Item data. For\nconvenience classes may describe more specific methods, but they should be\ndefined in terms of this interface and it's methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the\nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\npackage Bio::Tools::EUtilities::Summary::ItemContainerI;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Tools::EUtilities::EUtilDataI);\n\n=head2 next_Item\n\n Title    : next_Item\n Usage    : while (my $item = $docsum->next_Item) {...}\n Function : iterates through Items (nested layer of Item)\n Returns  : single Item\n Args     : [optional] single arg (string)\n            'flatten' - iterates through a flattened list ala\n                          get_all_DocSum_Items()"},"children":[{"definition":"my","localvar":"my","kind":13,"containerName":"next_Item","name":"$self","line":110},{"line":110,"kind":13,"containerName":"next_Item","name":"$request"},{"line":111,"name":"$self","kind":13,"containerName":"next_Item"},{"line":112,"localvar":"my","containerName":"next_Item","kind":13,"name":"@items","definition":"my"},{"line":112,"name":"$request","containerName":"next_Item","kind":13},{"line":112,"name":"$request","containerName":"next_Item","kind":13},{"kind":13,"containerName":"next_Item","name":"$self","line":113},{"containerName":"next_Item","kind":12,"name":"get_all_Items","line":113},{"line":114,"kind":13,"containerName":"next_Item","name":"$self"},{"line":114,"containerName":"next_Item","kind":12,"name":"get_Items"},{"name":"$self","kind":13,"containerName":"next_Item","line":115},{"line":115,"containerName":"next_Item","kind":13,"name":"@items"},{"kind":13,"containerName":"next_Item","name":"$self","line":117}],"containerName":"main::","name":"next_Item","definition":"sub","detail":"($self,$request)"},{"name":"get_Items","containerName":"main::","children":[{"definition":"my","line":131,"name":"$self","kind":13,"localvar":"my","containerName":"get_Items"},{"line":132,"kind":13,"containerName":"get_Items","name":"$self"},{"name":"$self","containerName":"get_Items","kind":13,"line":132}],"definition":"sub","range":{"end":{"character":9999,"line":132},"start":{"character":0,"line":130}},"kind":12,"line":130},{"children":[{"definition":"my","containerName":"get_all_Items","localvar":"my","kind":13,"name":"$self","line":158},{"line":159,"name":"$self","containerName":"get_all_Items","kind":13},{"name":"$item","localvar":"my","kind":13,"containerName":"get_all_Items","line":160,"definition":"my"},{"line":160,"kind":13,"containerName":"get_all_Items","name":"$self"},{"line":160,"name":"get_Items","kind":12,"containerName":"get_all_Items"},{"kind":13,"containerName":"get_all_Items","name":"$self","line":161},{"line":161,"kind":13,"containerName":"get_all_Items","name":"$item"},{"line":162,"name":"$ls","kind":13,"localvar":"my","containerName":"get_all_Items","definition":"my"},{"kind":13,"containerName":"get_all_Items","name":"$item","line":162},{"line":162,"name":"get_ListItems","kind":12,"containerName":"get_all_Items"},{"containerName":"get_all_Items","kind":13,"name":"$self","line":163},{"kind":13,"containerName":"get_all_Items","name":"$ls","line":163},{"localvar":"my","kind":13,"containerName":"get_all_Items","name":"$st","line":164,"definition":"my"},{"line":164,"kind":13,"containerName":"get_all_Items","name":"$ls"},{"name":"get_StructureItems","kind":12,"containerName":"get_all_Items","line":164},{"kind":13,"containerName":"get_all_Items","name":"$self","line":165},{"line":165,"kind":13,"containerName":"get_all_Items","name":"$st"}],"containerName":"main::","name":"get_all_Items","definition":"sub","line":157,"range":{"start":{"character":0,"line":157},"end":{"character":9999,"line":167}},"kind":12},{"line":170,"containerName":null,"kind":13,"name":"%self"},{"kind":12,"range":{"end":{"character":9999,"line":189},"start":{"line":183,"character":0}},"line":183,"signature":{"label":"get_all_names($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: ItemContainerI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EUtilities::Summary::ItemContainerI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# Part of the EUtilities BioPerl package\n\n=head1 NAME\n\nBio::Tools::EUtilities::Summary::ItemContainerI - abtract interface methods\nfor accessing Item information from any Item-containing class.  This pertains\nto either DocSums or to Items themselves (which can be layered)\n\n=head1 SYNOPSIS\n\n  # Implement ItemContainerI\n\n  # $foo is any ItemContainerI (current implementations are DocSum and Item itself)\n  \n  while (my $item = $foo->next_Item) { # iterate through contained Items\n     # do stuff here\n  }\n  \n  @items = $foo->get_Items;  # all Items in the container (hierarchy intact)\n  @items = $foo->get_all_Items;  # all Items in the container (flattened)\n  @items = $foo->get_Items_by_name('bar'); # Specifically named Items\n  ($content) = $foo->get_contents_by_name('bar'); # content from specific Items\n  ($type) = $foo->get_type_by_name('bar'); # data type from specific Items\n\n=head1 DESCRIPTION\n\nDocSum data, as returned from esummary, normally is a simple list of\nitem-content-content_type groups. However, items can also contain nested data to\nrepresent more complex data (such as structural data). This interface describes\nthe basic methods to generically retrieve the next layer of Item data. For\nconvenience classes may describe more specific methods, but they should be\ndefined in terms of this interface and it's methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the\nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\npackage Bio::Tools::EUtilities::Summary::ItemContainerI;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Tools::EUtilities::EUtilDataI);\n\n=head2 next_Item\n\n Title    : next_Item\n Usage    : while (my $item = $docsum->next_Item) {...}\n Function : iterates through Items (nested layer of Item)\n Returns  : single Item\n Args     : [optional] single arg (string)\n            'flatten' - iterates through a flattened list ala\n                          get_all_DocSum_Items()\n\n\nsub next_Item {\n    my ($self, $request) = @_;\n    unless ($self->{\"_items_it\"}) {\n        my @items = ($request && $request eq 'flatten') ?\n                    $self->get_all_Items :\n                    $self->get_Items ;\n        $self->{\"_items_it\"} = sub {return shift @items}\n    }\n    $self->{'_items_it'}->();\n}\n\n=head2 get_Items\n\n Title    : get_Items\n Usage    : my @items = $docsum->get_Items\n Function : returns list of, well, Items\n Returns  : array of Items\n Args     : none\n\n\nsub get_Items {\n    my $self = shift;\n    return ref $self->{'_items'} ? @{ $self->{'_items'} } : return ();\n}\n\n=head2 get_all_Items\n\n Title    : get_all_Items\n Usage    : my @items = $docsum->get_all_Items\n Function : returns flattened list of all Item objects (Items, ListItems,\n            StructureItems)\n Returns  : array of Items\n Args     : none\n Note     : items are added top-down (similar order to using nested calls)\n            in original list order.\n\n             1         2        7        8\n           Item  -   Item  -  Item  -  Item ...\n                     |\n                    | 3        6\n                 ListItem - ListItem\n                   |\n                  | 4          5\n               Structure - Structure\n\n\nsub get_all_Items {\n    my $self = shift;\n    unless ($self->{'_ordered_items'}) {\n        for my $item ($self->get_Items) {\n            push @{$self->{'_ordered_items'}}, $item;\n            for my $ls ($item->get_ListItems) {\n                push @{$self->{'_ordered_items'}}, $ls;\n                for my $st ($ls->get_StructureItems) {\n                    push @{$self->{'_ordered_items'}}, $st;                \n                } \n            }\n        }\n    }\n    return @{$self->{'_ordered_items'}};\n}\n\n=head2 get_all_names\n\n Title    : get_all_names\n Usage    : my @names = get_all_names()\n Function : Returns an array of names for all Item(s) in DocSum.\n Returns  : array of unique strings\n Args     : none"},"containerName":"main::","name":"get_all_names","children":[{"line":184,"name":"$self","containerName":"get_all_names","localvar":"my","kind":13,"definition":"my"},{"definition":"my","line":185,"name":"%tmp","kind":13,"localvar":"my","containerName":"get_all_names"},{"name":"@data","containerName":"get_all_names","localvar":"my","kind":13,"line":186,"definition":"my"},{"line":186,"kind":13,"containerName":"get_all_names","name":"$tmp"},{"name":"get_name","kind":12,"containerName":"get_all_names","line":187},{"name":"$self","containerName":"get_all_names","kind":13,"line":187},{"kind":12,"containerName":"get_all_names","name":"get_all_Items","line":187},{"line":188,"kind":13,"containerName":"get_all_names","name":"@data"}],"detail":"($self)","definition":"sub"},{"signature":{"label":"get_Items_by_name($self,$key)","parameters":[{"label":"$self"},{"label":"$key"}],"documentation":"1;\n# $Id: ItemContainerI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EUtilities::Summary::ItemContainerI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# Part of the EUtilities BioPerl package\n\n=head1 NAME\n\nBio::Tools::EUtilities::Summary::ItemContainerI - abtract interface methods\nfor accessing Item information from any Item-containing class.  This pertains\nto either DocSums or to Items themselves (which can be layered)\n\n=head1 SYNOPSIS\n\n  # Implement ItemContainerI\n\n  # $foo is any ItemContainerI (current implementations are DocSum and Item itself)\n  \n  while (my $item = $foo->next_Item) { # iterate through contained Items\n     # do stuff here\n  }\n  \n  @items = $foo->get_Items;  # all Items in the container (hierarchy intact)\n  @items = $foo->get_all_Items;  # all Items in the container (flattened)\n  @items = $foo->get_Items_by_name('bar'); # Specifically named Items\n  ($content) = $foo->get_contents_by_name('bar'); # content from specific Items\n  ($type) = $foo->get_type_by_name('bar'); # data type from specific Items\n\n=head1 DESCRIPTION\n\nDocSum data, as returned from esummary, normally is a simple list of\nitem-content-content_type groups. However, items can also contain nested data to\nrepresent more complex data (such as structural data). This interface describes\nthe basic methods to generically retrieve the next layer of Item data. For\nconvenience classes may describe more specific methods, but they should be\ndefined in terms of this interface and it's methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the\nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\npackage Bio::Tools::EUtilities::Summary::ItemContainerI;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Tools::EUtilities::EUtilDataI);\n\n=head2 next_Item\n\n Title    : next_Item\n Usage    : while (my $item = $docsum->next_Item) {...}\n Function : iterates through Items (nested layer of Item)\n Returns  : single Item\n Args     : [optional] single arg (string)\n            'flatten' - iterates through a flattened list ala\n                          get_all_DocSum_Items()\n\n\nsub next_Item {\n    my ($self, $request) = @_;\n    unless ($self->{\"_items_it\"}) {\n        my @items = ($request && $request eq 'flatten') ?\n                    $self->get_all_Items :\n                    $self->get_Items ;\n        $self->{\"_items_it\"} = sub {return shift @items}\n    }\n    $self->{'_items_it'}->();\n}\n\n=head2 get_Items\n\n Title    : get_Items\n Usage    : my @items = $docsum->get_Items\n Function : returns list of, well, Items\n Returns  : array of Items\n Args     : none\n\n\nsub get_Items {\n    my $self = shift;\n    return ref $self->{'_items'} ? @{ $self->{'_items'} } : return ();\n}\n\n=head2 get_all_Items\n\n Title    : get_all_Items\n Usage    : my @items = $docsum->get_all_Items\n Function : returns flattened list of all Item objects (Items, ListItems,\n            StructureItems)\n Returns  : array of Items\n Args     : none\n Note     : items are added top-down (similar order to using nested calls)\n            in original list order.\n\n             1         2        7        8\n           Item  -   Item  -  Item  -  Item ...\n                     |\n                    | 3        6\n                 ListItem - ListItem\n                   |\n                  | 4          5\n               Structure - Structure\n\n\nsub get_all_Items {\n    my $self = shift;\n    unless ($self->{'_ordered_items'}) {\n        for my $item ($self->get_Items) {\n            push @{$self->{'_ordered_items'}}, $item;\n            for my $ls ($item->get_ListItems) {\n                push @{$self->{'_ordered_items'}}, $ls;\n                for my $st ($ls->get_StructureItems) {\n                    push @{$self->{'_ordered_items'}}, $st;                \n                } \n            }\n        }\n    }\n    return @{$self->{'_ordered_items'}};\n}\n\n=head2 get_all_names\n\n Title    : get_all_names\n Usage    : my @names = get_all_names()\n Function : Returns an array of names for all Item(s) in DocSum.\n Returns  : array of unique strings\n Args     : none\n\n\nsub get_all_names {\n    my ($self) = @_;\n    my %tmp;\n    my @data = grep {!$tmp{$_}++}\n        map {$_->get_name} $self->get_all_Items;\n    return @data;\n}\n\n=head2 get_Items_by_name\n\n Title    : get_Items_by_name\n Usage    : my @items = get_Items_by_name('CreateDate')\n Function : Returns named Item(s) in DocSum (indicated by passed argument)\n Returns  : array of Item objects\n Args     : string (Item name)"},"line":201,"range":{"start":{"character":0,"line":201},"end":{"character":9999,"line":207}},"kind":12,"definition":"sub","detail":"($self,$key)","children":[{"definition":"my","line":202,"localvar":"my","kind":13,"containerName":"get_Items_by_name","name":"$self"},{"name":"$key","kind":13,"containerName":"get_Items_by_name","line":202},{"name":"$key","containerName":"get_Items_by_name","kind":13,"line":203},{"name":"@data","localvar":"my","kind":13,"containerName":"get_Items_by_name","line":204,"definition":"my"},{"containerName":"get_Items_by_name","kind":12,"name":"get_name","line":204},{"line":204,"name":"$key","containerName":"get_Items_by_name","kind":13},{"line":205,"name":"$self","containerName":"get_Items_by_name","kind":13},{"name":"get_all_Items","kind":12,"containerName":"get_Items_by_name","line":205},{"containerName":"get_Items_by_name","kind":13,"name":"@data","line":206}],"name":"get_Items_by_name","containerName":"main::"},{"children":[{"localvar":"my","kind":13,"containerName":"get_contents_by_name","name":"$self","line":221,"definition":"my"},{"containerName":"get_contents_by_name","kind":13,"name":"$key","line":221},{"line":222,"name":"$key","containerName":"get_contents_by_name","kind":13},{"containerName":"get_contents_by_name","localvar":"my","kind":13,"name":"@data","line":223,"definition":"my"},{"name":"get_content","kind":12,"containerName":"get_contents_by_name","line":223},{"line":224,"name":"get_name","containerName":"get_contents_by_name","kind":12},{"kind":13,"containerName":"get_contents_by_name","name":"$key","line":224},{"name":"$self","containerName":"get_contents_by_name","kind":13,"line":225},{"line":225,"containerName":"get_contents_by_name","kind":12,"name":"get_all_Items"},{"line":226,"containerName":"get_contents_by_name","kind":13,"name":"@data"}],"name":"get_contents_by_name","containerName":"main::","definition":"sub","detail":"($self,$key)","line":220,"kind":12,"range":{"end":{"character":9999,"line":227},"start":{"character":0,"line":220}},"signature":{"documentation":"1;\n# $Id: ItemContainerI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EUtilities::Summary::ItemContainerI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# Part of the EUtilities BioPerl package\n\n=head1 NAME\n\nBio::Tools::EUtilities::Summary::ItemContainerI - abtract interface methods\nfor accessing Item information from any Item-containing class.  This pertains\nto either DocSums or to Items themselves (which can be layered)\n\n=head1 SYNOPSIS\n\n  # Implement ItemContainerI\n\n  # $foo is any ItemContainerI (current implementations are DocSum and Item itself)\n  \n  while (my $item = $foo->next_Item) { # iterate through contained Items\n     # do stuff here\n  }\n  \n  @items = $foo->get_Items;  # all Items in the container (hierarchy intact)\n  @items = $foo->get_all_Items;  # all Items in the container (flattened)\n  @items = $foo->get_Items_by_name('bar'); # Specifically named Items\n  ($content) = $foo->get_contents_by_name('bar'); # content from specific Items\n  ($type) = $foo->get_type_by_name('bar'); # data type from specific Items\n\n=head1 DESCRIPTION\n\nDocSum data, as returned from esummary, normally is a simple list of\nitem-content-content_type groups. However, items can also contain nested data to\nrepresent more complex data (such as structural data). This interface describes\nthe basic methods to generically retrieve the next layer of Item data. For\nconvenience classes may describe more specific methods, but they should be\ndefined in terms of this interface and it's methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the\nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\npackage Bio::Tools::EUtilities::Summary::ItemContainerI;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Tools::EUtilities::EUtilDataI);\n\n=head2 next_Item\n\n Title    : next_Item\n Usage    : while (my $item = $docsum->next_Item) {...}\n Function : iterates through Items (nested layer of Item)\n Returns  : single Item\n Args     : [optional] single arg (string)\n            'flatten' - iterates through a flattened list ala\n                          get_all_DocSum_Items()\n\n\nsub next_Item {\n    my ($self, $request) = @_;\n    unless ($self->{\"_items_it\"}) {\n        my @items = ($request && $request eq 'flatten') ?\n                    $self->get_all_Items :\n                    $self->get_Items ;\n        $self->{\"_items_it\"} = sub {return shift @items}\n    }\n    $self->{'_items_it'}->();\n}\n\n=head2 get_Items\n\n Title    : get_Items\n Usage    : my @items = $docsum->get_Items\n Function : returns list of, well, Items\n Returns  : array of Items\n Args     : none\n\n\nsub get_Items {\n    my $self = shift;\n    return ref $self->{'_items'} ? @{ $self->{'_items'} } : return ();\n}\n\n=head2 get_all_Items\n\n Title    : get_all_Items\n Usage    : my @items = $docsum->get_all_Items\n Function : returns flattened list of all Item objects (Items, ListItems,\n            StructureItems)\n Returns  : array of Items\n Args     : none\n Note     : items are added top-down (similar order to using nested calls)\n            in original list order.\n\n             1         2        7        8\n           Item  -   Item  -  Item  -  Item ...\n                     |\n                    | 3        6\n                 ListItem - ListItem\n                   |\n                  | 4          5\n               Structure - Structure\n\n\nsub get_all_Items {\n    my $self = shift;\n    unless ($self->{'_ordered_items'}) {\n        for my $item ($self->get_Items) {\n            push @{$self->{'_ordered_items'}}, $item;\n            for my $ls ($item->get_ListItems) {\n                push @{$self->{'_ordered_items'}}, $ls;\n                for my $st ($ls->get_StructureItems) {\n                    push @{$self->{'_ordered_items'}}, $st;                \n                } \n            }\n        }\n    }\n    return @{$self->{'_ordered_items'}};\n}\n\n=head2 get_all_names\n\n Title    : get_all_names\n Usage    : my @names = get_all_names()\n Function : Returns an array of names for all Item(s) in DocSum.\n Returns  : array of unique strings\n Args     : none\n\n\nsub get_all_names {\n    my ($self) = @_;\n    my %tmp;\n    my @data = grep {!$tmp{$_}++}\n        map {$_->get_name} $self->get_all_Items;\n    return @data;\n}\n\n=head2 get_Items_by_name\n\n Title    : get_Items_by_name\n Usage    : my @items = get_Items_by_name('CreateDate')\n Function : Returns named Item(s) in DocSum (indicated by passed argument)\n Returns  : array of Item objects\n Args     : string (Item name)\n\n\nsub get_Items_by_name {\n    my ($self, $key) = @_;\n    return unless $key;\n    my @data = grep {$_->get_name eq $key}\n        $self->get_all_Items;\n    return @data;\n}\n\n=head2 get_contents_by_name\n\n Title    : get_contents_by_name\n Usage    : my ($data) = get_contents_by_name('CreateDate')\n Function : Returns content for named Item(s) in DocSum (indicated by\n            passed argument)\n Returns  : array of values (type varies per Item)\n Args     : string (Item name)","parameters":[{"label":"$self"},{"label":"$key"}],"label":"get_contents_by_name($self,$key)"}},{"line":240,"kind":12,"range":{"end":{"character":9999,"line":245},"start":{"line":240,"character":0}},"signature":{"label":"get_type_by_name($self,$key)","parameters":[{"label":"$self"},{"label":"$key"}],"documentation":"1;\n# $Id: ItemContainerI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EUtilities::Summary::ItemContainerI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# Part of the EUtilities BioPerl package\n\n=head1 NAME\n\nBio::Tools::EUtilities::Summary::ItemContainerI - abtract interface methods\nfor accessing Item information from any Item-containing class.  This pertains\nto either DocSums or to Items themselves (which can be layered)\n\n=head1 SYNOPSIS\n\n  # Implement ItemContainerI\n\n  # $foo is any ItemContainerI (current implementations are DocSum and Item itself)\n  \n  while (my $item = $foo->next_Item) { # iterate through contained Items\n     # do stuff here\n  }\n  \n  @items = $foo->get_Items;  # all Items in the container (hierarchy intact)\n  @items = $foo->get_all_Items;  # all Items in the container (flattened)\n  @items = $foo->get_Items_by_name('bar'); # Specifically named Items\n  ($content) = $foo->get_contents_by_name('bar'); # content from specific Items\n  ($type) = $foo->get_type_by_name('bar'); # data type from specific Items\n\n=head1 DESCRIPTION\n\nDocSum data, as returned from esummary, normally is a simple list of\nitem-content-content_type groups. However, items can also contain nested data to\nrepresent more complex data (such as structural data). This interface describes\nthe basic methods to generically retrieve the next layer of Item data. For\nconvenience classes may describe more specific methods, but they should be\ndefined in terms of this interface and it's methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the\nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\npackage Bio::Tools::EUtilities::Summary::ItemContainerI;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Tools::EUtilities::EUtilDataI);\n\n=head2 next_Item\n\n Title    : next_Item\n Usage    : while (my $item = $docsum->next_Item) {...}\n Function : iterates through Items (nested layer of Item)\n Returns  : single Item\n Args     : [optional] single arg (string)\n            'flatten' - iterates through a flattened list ala\n                          get_all_DocSum_Items()\n\n\nsub next_Item {\n    my ($self, $request) = @_;\n    unless ($self->{\"_items_it\"}) {\n        my @items = ($request && $request eq 'flatten') ?\n                    $self->get_all_Items :\n                    $self->get_Items ;\n        $self->{\"_items_it\"} = sub {return shift @items}\n    }\n    $self->{'_items_it'}->();\n}\n\n=head2 get_Items\n\n Title    : get_Items\n Usage    : my @items = $docsum->get_Items\n Function : returns list of, well, Items\n Returns  : array of Items\n Args     : none\n\n\nsub get_Items {\n    my $self = shift;\n    return ref $self->{'_items'} ? @{ $self->{'_items'} } : return ();\n}\n\n=head2 get_all_Items\n\n Title    : get_all_Items\n Usage    : my @items = $docsum->get_all_Items\n Function : returns flattened list of all Item objects (Items, ListItems,\n            StructureItems)\n Returns  : array of Items\n Args     : none\n Note     : items are added top-down (similar order to using nested calls)\n            in original list order.\n\n             1         2        7        8\n           Item  -   Item  -  Item  -  Item ...\n                     |\n                    | 3        6\n                 ListItem - ListItem\n                   |\n                  | 4          5\n               Structure - Structure\n\n\nsub get_all_Items {\n    my $self = shift;\n    unless ($self->{'_ordered_items'}) {\n        for my $item ($self->get_Items) {\n            push @{$self->{'_ordered_items'}}, $item;\n            for my $ls ($item->get_ListItems) {\n                push @{$self->{'_ordered_items'}}, $ls;\n                for my $st ($ls->get_StructureItems) {\n                    push @{$self->{'_ordered_items'}}, $st;                \n                } \n            }\n        }\n    }\n    return @{$self->{'_ordered_items'}};\n}\n\n=head2 get_all_names\n\n Title    : get_all_names\n Usage    : my @names = get_all_names()\n Function : Returns an array of names for all Item(s) in DocSum.\n Returns  : array of unique strings\n Args     : none\n\n\nsub get_all_names {\n    my ($self) = @_;\n    my %tmp;\n    my @data = grep {!$tmp{$_}++}\n        map {$_->get_name} $self->get_all_Items;\n    return @data;\n}\n\n=head2 get_Items_by_name\n\n Title    : get_Items_by_name\n Usage    : my @items = get_Items_by_name('CreateDate')\n Function : Returns named Item(s) in DocSum (indicated by passed argument)\n Returns  : array of Item objects\n Args     : string (Item name)\n\n\nsub get_Items_by_name {\n    my ($self, $key) = @_;\n    return unless $key;\n    my @data = grep {$_->get_name eq $key}\n        $self->get_all_Items;\n    return @data;\n}\n\n=head2 get_contents_by_name\n\n Title    : get_contents_by_name\n Usage    : my ($data) = get_contents_by_name('CreateDate')\n Function : Returns content for named Item(s) in DocSum (indicated by\n            passed argument)\n Returns  : array of values (type varies per Item)\n Args     : string (Item name)\n\n\nsub get_contents_by_name {\n    my ($self, $key) = @_;\n    return unless $key;\n    my @data = map {$_->get_content} \n        grep {$_->get_name eq $key}\n        $self->get_all_Items;\n    return @data;\n}\n\n=head2 get_type_by_name\n\n Title    : get_type_by_name\n Usage    : my $data = get_type_by_name('CreateDate')\n Function : Returns data type for named Item in DocSum (indicated by\n            passed argument)\n Returns  : scalar value (string) if present\n Args     : string (Item name)"},"children":[{"definition":"my","line":241,"containerName":"get_type_by_name","localvar":"my","kind":13,"name":"$self"},{"line":241,"name":"$key","kind":13,"containerName":"get_type_by_name"},{"containerName":"get_type_by_name","kind":13,"name":"$key","line":242},{"definition":"my","line":243,"kind":13,"localvar":"my","containerName":"get_type_by_name","name":"$it"},{"containerName":"get_type_by_name","kind":12,"name":"get_name","line":243},{"kind":13,"containerName":"get_type_by_name","name":"$key","line":243},{"line":243,"containerName":"get_type_by_name","kind":13,"name":"$self"},{"line":243,"kind":12,"containerName":"get_type_by_name","name":"get_all_Items"},{"name":"$it","containerName":"get_type_by_name","kind":13,"line":244},{"containerName":"get_type_by_name","kind":12,"name":"get_type","line":244}],"name":"get_type_by_name","containerName":"main::","definition":"sub","detail":"($self,$key)"}]}