{"version":5,"vars":[{"line":111,"name":"base","kind":2,"containerName":""},{"definition":"our","name":"$MotifTag","kind":13,"containerName":"main::","line":113},{"containerName":null,"kind":13,"name":"$SrcTag","line":113},{"name":"$DescTag","kind":13,"containerName":null,"line":113},{"signature":{"documentation":"1;\n# $Id: ERPIN.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ERPIN\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::ERPIN -  a parser for ERPIN output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::ERPIN;\n  my $parser = Bio::Tools::ERPIN->new( -file => $rna_output,\n                                      -motiftag => 'protein_bind'\n                                      -desctag => 'TRAP_binding');\n  #parse the results\n  while( my $motif = $parser->next_prediction) {\n    # do something here\n  }\n\n=head1 DESCRIPTION\n\nParses raw ERPIN output.\n\nThis module is not currently complete.  As is, it will parse raw\nERPIN long format output and pack information into\nBio::SeqFeature::Generic objects.  \n\nSeveral values have also been added in the 'tag' hash.  These can be\naccessed using the following syntax:\n\n  my ($entry) = $feature->get_Annotations('SecStructure');\n\nAdded tags are : \n   tset         - training set used for the sequence\n   tsetdesc     - training set description line\n   cutoff       - cutoff value used\n   database     - name of database\n   dbdesc       - description of database\n   dbratios     - nucleotide ratios of database (used to calculate evalue)\n   descline     - entire description line (in case the regex used for\n                  sequence ID doesn't adequately catch the name\n   accession    - accession number of sequence (if present)\n   logodds      - logodds score value\n   sequence     - sequence from hit, separated based on training set\n\nSee t/ERPIN.t for example usage.\n\nAt some point a more complicated feature object may be used to support\nthis data rather than forcing most of the information into tag/value\npairs in a SeqFeature::Generic.  This will hopefully allow for more\nflexible analysis of data (specifically RNA secondary structural\ndata).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::ERPIN;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nour($MotifTag,$SrcTag,$DescTag) = qw(misc_binding ERPIN erpin);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::ERPIN->new();\n Function: Builds a new Bio::Tools::ERPIN object \n Returns : an instance of Bio::Tools::ERPIN\n Args    : -fh/-file for input filename\n           -motiftag => primary tag used in gene features (default 'misc_binding')\n           -desctag => tag used for display_name name (default 'erpin')\n           -srctag  => source tag used in all features (default 'ERPIN')","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_initialize($self,@args)"},"line":128,"range":{"start":{"line":128,"character":0},"end":{"character":9999,"line":144}},"kind":12,"definition":"sub","detail":"($self,@args)","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"_initialize","line":129,"definition":"my"},{"line":129,"name":"@args","kind":13,"containerName":"_initialize"},{"containerName":"_initialize","kind":13,"name":"$self","line":130},{"kind":12,"containerName":"_initialize","name":"warn","line":130},{"containerName":"_initialize","kind":13,"name":"$self","line":131},{"line":131,"name":"@args","kind":13,"containerName":"_initialize"},{"localvar":"my","containerName":"_initialize","kind":13,"name":"$motiftag","line":132,"definition":"my"},{"name":"$desctag","containerName":"_initialize","kind":13,"line":132},{"name":"$srctag","containerName":"_initialize","kind":13,"line":132},{"name":"$self","containerName":"_initialize","kind":13,"line":132},{"containerName":"_initialize","kind":13,"name":"@args","line":136},{"kind":13,"containerName":"_initialize","name":"$self","line":137},{"containerName":"_initialize","kind":12,"name":"motif_tag","line":137},{"name":"$motiftag","kind":13,"containerName":"_initialize","line":137},{"line":137,"kind":13,"containerName":"_initialize","name":"$motiftag"},{"line":137,"name":"$MotifTag","containerName":"_initialize","kind":13},{"name":"$self","kind":13,"containerName":"_initialize","line":138},{"line":138,"name":"source_tag","kind":12,"containerName":"_initialize"},{"containerName":"_initialize","kind":13,"name":"$srctag","line":138},{"name":"$srctag","kind":13,"containerName":"_initialize","line":138},{"name":"$SrcTag","containerName":"_initialize","kind":13,"line":138},{"name":"$self","kind":13,"containerName":"_initialize","line":139},{"kind":12,"containerName":"_initialize","name":"desc_tag","line":139},{"name":"$desctag","containerName":"_initialize","kind":13,"line":139},{"containerName":"_initialize","kind":13,"name":"$desctag","line":139},{"line":139,"containerName":"_initialize","kind":13,"name":"$DescTag"},{"line":142,"name":"$self","kind":13,"containerName":"_initialize"}],"name":"_initialize","containerName":"main::"},{"line":131,"kind":12,"containerName":"_initialize","name":"SUPER"},{"line":132,"kind":12,"containerName":"_rearrange","name":"SUPER"},{"kind":12,"range":{"start":{"character":0,"line":165},"end":{"character":9999,"line":170}},"line":165,"definition":"sub","containerName":"main::","name":"motif_tag","children":[{"definition":"my","line":166,"name":"$self","localvar":"my","containerName":"motif_tag","kind":13},{"kind":13,"containerName":"motif_tag","name":"$self","line":168},{"name":"$self","kind":13,"containerName":"motif_tag","line":169}]},{"kind":12,"range":{"start":{"line":184,"character":0},"end":{"line":189,"character":9999}},"line":184,"containerName":"main::","name":"source_tag","children":[{"definition":"my","line":185,"name":"$self","localvar":"my","containerName":"source_tag","kind":13},{"line":187,"name":"$self","kind":13,"containerName":"source_tag"},{"name":"$self","kind":13,"containerName":"source_tag","line":188}],"definition":"sub"},{"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"desc_tag","line":207},{"line":209,"kind":13,"containerName":"desc_tag","name":"$self"},{"name":"$self","kind":13,"containerName":"desc_tag","line":210}],"containerName":"main::","name":"desc_tag","definition":"sub","line":206,"range":{"end":{"line":211,"character":9999},"start":{"character":0,"line":206}},"kind":12},{"signature":{"label":"analysis_method($self,$method)","documentation":"1;\n# $Id: ERPIN.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ERPIN\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::ERPIN -  a parser for ERPIN output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::ERPIN;\n  my $parser = Bio::Tools::ERPIN->new( -file => $rna_output,\n                                      -motiftag => 'protein_bind'\n                                      -desctag => 'TRAP_binding');\n  #parse the results\n  while( my $motif = $parser->next_prediction) {\n    # do something here\n  }\n\n=head1 DESCRIPTION\n\nParses raw ERPIN output.\n\nThis module is not currently complete.  As is, it will parse raw\nERPIN long format output and pack information into\nBio::SeqFeature::Generic objects.  \n\nSeveral values have also been added in the 'tag' hash.  These can be\naccessed using the following syntax:\n\n  my ($entry) = $feature->get_Annotations('SecStructure');\n\nAdded tags are : \n   tset         - training set used for the sequence\n   tsetdesc     - training set description line\n   cutoff       - cutoff value used\n   database     - name of database\n   dbdesc       - description of database\n   dbratios     - nucleotide ratios of database (used to calculate evalue)\n   descline     - entire description line (in case the regex used for\n                  sequence ID doesn't adequately catch the name\n   accession    - accession number of sequence (if present)\n   logodds      - logodds score value\n   sequence     - sequence from hit, separated based on training set\n\nSee t/ERPIN.t for example usage.\n\nAt some point a more complicated feature object may be used to support\nthis data rather than forcing most of the information into tag/value\npairs in a SeqFeature::Generic.  This will hopefully allow for more\nflexible analysis of data (specifically RNA secondary structural\ndata).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::ERPIN;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nour($MotifTag,$SrcTag,$DescTag) = qw(misc_binding ERPIN erpin);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::ERPIN->new();\n Function: Builds a new Bio::Tools::ERPIN object \n Returns : an instance of Bio::Tools::ERPIN\n Args    : -fh/-file for input filename\n           -motiftag => primary tag used in gene features (default 'misc_binding')\n           -desctag => tag used for display_name name (default 'erpin')\n           -srctag  => source tag used in all features (default 'ERPIN')\n\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->warn('Use of this module is deprecated.  Use Bio::SearchIO::erpin instead');    \n    $self->SUPER::_initialize(@args);\n    my ($motiftag,$desctag,$srctag) =  $self->SUPER::_rearrange([qw(MOTIFTAG\n                                                                    DESCTAG\n                                                                    SRCTAG\n                                   )],\n                                    @args);\n    $self->motif_tag(defined $motiftag ? $motiftag : $MotifTag);\n    $self->source_tag(defined $srctag ? $srctag : $SrcTag);\n    $self->desc_tag(defined $desctag ? $desctag : $DescTag);\n    foreach (qw(_tset _tset_desc _cutoff _db _db_desc\n               _db_ratios _eval_cutoff _seqid _secacc _seqdesc )) {\n        $self->{$_}='';\n    }\n}\n\n=head2 motif_tag\n\n Title   : motiftag\n Usage   : $obj->motiftag($newval)\n Function: Get/Set the value used for 'motif_tag', which is used for setting the\n           primary_tag.\n           Default is 'misc_binding' as set by the global $MotifTag.\n           'misc_binding' is used here because a conserved RNA motif is capable\n           of binding proteins (regulatory proteins), antisense RNA (siRNA),\n           small molecules (riboswitches), or nothing at all (tRNA,\n           terminators, etc.).  It is recommended that this be changed to other\n           tags ('misc_RNA', 'protein_binding', 'tRNA', etc.) where appropriate.\n           For more information, see:\n           http://www.ncbi.nlm.nih.gov/collab/FT/index.html\n Returns : value of motif_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub motif_tag{\n    my $self = shift;\n\n    return $self->{'motif_tag'} = shift if @_;\n    return $self->{'motif_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $obj->source_tag($newval)\n Function: Get/Set the value used for the 'source_tag'.\n           Default is 'ERPIN' as set by the global $SrcTag\n Returns : value of source_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub source_tag{\n    my $self = shift;\n\n    return $self->{'source_tag'} = shift if @_;\n    return $self->{'source_tag'};\n}\n\n=head2 desc_tag\n\n Title   : desc_tag\n Usage   : $obj->desc_tag($newval)\n Function: Get/Set the value used for the query motif.  This will be placed in\n           the tag '-display_name'.  Default is 'erpin' as set by the global\n           $DescTag.  Use this to manually set the descriptor (motif searched for).\n           Since there is no way for this module to tell what the motif is from the\n           name of the descriptor file or the ERPIN output, this should\n           be set every time an ERPIN object is instantiated for clarity\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub desc_tag{\n    my $self = shift;\n\n    return $self->{'desc_tag'} = shift if @_;\n    return $self->{'desc_tag'};\n}\n\n=head2 analysis_method\n\n Usage     : $obj->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /ERPIN/i.\n Returns   : String\n Argument  : n/a","parameters":[{"label":"$self"},{"label":"$method"}]},"range":{"start":{"character":0,"line":224},"end":{"line":231,"character":9999}},"kind":12,"line":224,"detail":"($self,$method)","definition":"sub","containerName":"main::","name":"analysis_method","children":[{"definition":"my","line":226,"name":"$self","localvar":"my","containerName":"analysis_method","kind":13},{"line":226,"name":"$method","containerName":"analysis_method","kind":13},{"containerName":"analysis_method","kind":13,"name":"$method","line":227},{"name":"$method","kind":13,"containerName":"analysis_method","line":227},{"name":"$self","kind":13,"containerName":"analysis_method","line":228},{"containerName":"analysis_method","kind":12,"name":"throw","line":228},{"name":"$self","kind":13,"containerName":"analysis_method","line":228},{"line":230,"kind":13,"containerName":"analysis_method","name":"$self"},{"line":230,"name":"$method","containerName":"analysis_method","kind":13}]},{"line":230,"name":"SUPER","containerName":"analysis_method","kind":12},{"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"next_feature","children":[{"line":251,"name":"$self","kind":13,"localvar":"my","containerName":"next_feature","definition":"my"},{"name":"@args","containerName":"next_feature","kind":13,"line":251},{"line":255,"containerName":"next_feature","kind":13,"name":"$self"},{"kind":12,"containerName":"next_feature","name":"next_prediction","line":255},{"containerName":"next_feature","kind":13,"name":"@args","line":255}],"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: ERPIN.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ERPIN\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::ERPIN -  a parser for ERPIN output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::ERPIN;\n  my $parser = Bio::Tools::ERPIN->new( -file => $rna_output,\n                                      -motiftag => 'protein_bind'\n                                      -desctag => 'TRAP_binding');\n  #parse the results\n  while( my $motif = $parser->next_prediction) {\n    # do something here\n  }\n\n=head1 DESCRIPTION\n\nParses raw ERPIN output.\n\nThis module is not currently complete.  As is, it will parse raw\nERPIN long format output and pack information into\nBio::SeqFeature::Generic objects.  \n\nSeveral values have also been added in the 'tag' hash.  These can be\naccessed using the following syntax:\n\n  my ($entry) = $feature->get_Annotations('SecStructure');\n\nAdded tags are : \n   tset         - training set used for the sequence\n   tsetdesc     - training set description line\n   cutoff       - cutoff value used\n   database     - name of database\n   dbdesc       - description of database\n   dbratios     - nucleotide ratios of database (used to calculate evalue)\n   descline     - entire description line (in case the regex used for\n                  sequence ID doesn't adequately catch the name\n   accession    - accession number of sequence (if present)\n   logodds      - logodds score value\n   sequence     - sequence from hit, separated based on training set\n\nSee t/ERPIN.t for example usage.\n\nAt some point a more complicated feature object may be used to support\nthis data rather than forcing most of the information into tag/value\npairs in a SeqFeature::Generic.  This will hopefully allow for more\nflexible analysis of data (specifically RNA secondary structural\ndata).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::ERPIN;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nour($MotifTag,$SrcTag,$DescTag) = qw(misc_binding ERPIN erpin);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::ERPIN->new();\n Function: Builds a new Bio::Tools::ERPIN object \n Returns : an instance of Bio::Tools::ERPIN\n Args    : -fh/-file for input filename\n           -motiftag => primary tag used in gene features (default 'misc_binding')\n           -desctag => tag used for display_name name (default 'erpin')\n           -srctag  => source tag used in all features (default 'ERPIN')\n\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->warn('Use of this module is deprecated.  Use Bio::SearchIO::erpin instead');    \n    $self->SUPER::_initialize(@args);\n    my ($motiftag,$desctag,$srctag) =  $self->SUPER::_rearrange([qw(MOTIFTAG\n                                                                    DESCTAG\n                                                                    SRCTAG\n                                   )],\n                                    @args);\n    $self->motif_tag(defined $motiftag ? $motiftag : $MotifTag);\n    $self->source_tag(defined $srctag ? $srctag : $SrcTag);\n    $self->desc_tag(defined $desctag ? $desctag : $DescTag);\n    foreach (qw(_tset _tset_desc _cutoff _db _db_desc\n               _db_ratios _eval_cutoff _seqid _secacc _seqdesc )) {\n        $self->{$_}='';\n    }\n}\n\n=head2 motif_tag\n\n Title   : motiftag\n Usage   : $obj->motiftag($newval)\n Function: Get/Set the value used for 'motif_tag', which is used for setting the\n           primary_tag.\n           Default is 'misc_binding' as set by the global $MotifTag.\n           'misc_binding' is used here because a conserved RNA motif is capable\n           of binding proteins (regulatory proteins), antisense RNA (siRNA),\n           small molecules (riboswitches), or nothing at all (tRNA,\n           terminators, etc.).  It is recommended that this be changed to other\n           tags ('misc_RNA', 'protein_binding', 'tRNA', etc.) where appropriate.\n           For more information, see:\n           http://www.ncbi.nlm.nih.gov/collab/FT/index.html\n Returns : value of motif_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub motif_tag{\n    my $self = shift;\n\n    return $self->{'motif_tag'} = shift if @_;\n    return $self->{'motif_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $obj->source_tag($newval)\n Function: Get/Set the value used for the 'source_tag'.\n           Default is 'ERPIN' as set by the global $SrcTag\n Returns : value of source_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub source_tag{\n    my $self = shift;\n\n    return $self->{'source_tag'} = shift if @_;\n    return $self->{'source_tag'};\n}\n\n=head2 desc_tag\n\n Title   : desc_tag\n Usage   : $obj->desc_tag($newval)\n Function: Get/Set the value used for the query motif.  This will be placed in\n           the tag '-display_name'.  Default is 'erpin' as set by the global\n           $DescTag.  Use this to manually set the descriptor (motif searched for).\n           Since there is no way for this module to tell what the motif is from the\n           name of the descriptor file or the ERPIN output, this should\n           be set every time an ERPIN object is instantiated for clarity\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub desc_tag{\n    my $self = shift;\n\n    return $self->{'desc_tag'} = shift if @_;\n    return $self->{'desc_tag'};\n}\n\n=head2 analysis_method\n\n Usage     : $obj->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /ERPIN/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /ERPIN/i)) {\n    $self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $obj->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the ERPIN result\n           file. Call this method repeatedly until FALSE is returned.\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    : None (at present)","label":"next_feature($self,@args)"},"kind":12,"range":{"end":{"character":9999,"line":256},"start":{"line":250,"character":0}},"line":250},{"line":271,"kind":12,"range":{"start":{"line":271,"character":0},"end":{"character":9999,"line":348}},"signature":{"documentation":"1;\n# $Id: ERPIN.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ERPIN\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::ERPIN -  a parser for ERPIN output\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::ERPIN;\n  my $parser = Bio::Tools::ERPIN->new( -file => $rna_output,\n                                      -motiftag => 'protein_bind'\n                                      -desctag => 'TRAP_binding');\n  #parse the results\n  while( my $motif = $parser->next_prediction) {\n    # do something here\n  }\n\n=head1 DESCRIPTION\n\nParses raw ERPIN output.\n\nThis module is not currently complete.  As is, it will parse raw\nERPIN long format output and pack information into\nBio::SeqFeature::Generic objects.  \n\nSeveral values have also been added in the 'tag' hash.  These can be\naccessed using the following syntax:\n\n  my ($entry) = $feature->get_Annotations('SecStructure');\n\nAdded tags are : \n   tset         - training set used for the sequence\n   tsetdesc     - training set description line\n   cutoff       - cutoff value used\n   database     - name of database\n   dbdesc       - description of database\n   dbratios     - nucleotide ratios of database (used to calculate evalue)\n   descline     - entire description line (in case the regex used for\n                  sequence ID doesn't adequately catch the name\n   accession    - accession number of sequence (if present)\n   logodds      - logodds score value\n   sequence     - sequence from hit, separated based on training set\n\nSee t/ERPIN.t for example usage.\n\nAt some point a more complicated feature object may be used to support\nthis data rather than forcing most of the information into tag/value\npairs in a SeqFeature::Generic.  This will hopefully allow for more\nflexible analysis of data (specifically RNA secondary structural\ndata).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::ERPIN;\nuse strict;\n\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nour($MotifTag,$SrcTag,$DescTag) = qw(misc_binding ERPIN erpin);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::ERPIN->new();\n Function: Builds a new Bio::Tools::ERPIN object \n Returns : an instance of Bio::Tools::ERPIN\n Args    : -fh/-file for input filename\n           -motiftag => primary tag used in gene features (default 'misc_binding')\n           -desctag => tag used for display_name name (default 'erpin')\n           -srctag  => source tag used in all features (default 'ERPIN')\n\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->warn('Use of this module is deprecated.  Use Bio::SearchIO::erpin instead');    \n    $self->SUPER::_initialize(@args);\n    my ($motiftag,$desctag,$srctag) =  $self->SUPER::_rearrange([qw(MOTIFTAG\n                                                                    DESCTAG\n                                                                    SRCTAG\n                                   )],\n                                    @args);\n    $self->motif_tag(defined $motiftag ? $motiftag : $MotifTag);\n    $self->source_tag(defined $srctag ? $srctag : $SrcTag);\n    $self->desc_tag(defined $desctag ? $desctag : $DescTag);\n    foreach (qw(_tset _tset_desc _cutoff _db _db_desc\n               _db_ratios _eval_cutoff _seqid _secacc _seqdesc )) {\n        $self->{$_}='';\n    }\n}\n\n=head2 motif_tag\n\n Title   : motiftag\n Usage   : $obj->motiftag($newval)\n Function: Get/Set the value used for 'motif_tag', which is used for setting the\n           primary_tag.\n           Default is 'misc_binding' as set by the global $MotifTag.\n           'misc_binding' is used here because a conserved RNA motif is capable\n           of binding proteins (regulatory proteins), antisense RNA (siRNA),\n           small molecules (riboswitches), or nothing at all (tRNA,\n           terminators, etc.).  It is recommended that this be changed to other\n           tags ('misc_RNA', 'protein_binding', 'tRNA', etc.) where appropriate.\n           For more information, see:\n           http://www.ncbi.nlm.nih.gov/collab/FT/index.html\n Returns : value of motif_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub motif_tag{\n    my $self = shift;\n\n    return $self->{'motif_tag'} = shift if @_;\n    return $self->{'motif_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $obj->source_tag($newval)\n Function: Get/Set the value used for the 'source_tag'.\n           Default is 'ERPIN' as set by the global $SrcTag\n Returns : value of source_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub source_tag{\n    my $self = shift;\n\n    return $self->{'source_tag'} = shift if @_;\n    return $self->{'source_tag'};\n}\n\n=head2 desc_tag\n\n Title   : desc_tag\n Usage   : $obj->desc_tag($newval)\n Function: Get/Set the value used for the query motif.  This will be placed in\n           the tag '-display_name'.  Default is 'erpin' as set by the global\n           $DescTag.  Use this to manually set the descriptor (motif searched for).\n           Since there is no way for this module to tell what the motif is from the\n           name of the descriptor file or the ERPIN output, this should\n           be set every time an ERPIN object is instantiated for clarity\n Returns : value of exon_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub desc_tag{\n    my $self = shift;\n\n    return $self->{'desc_tag'} = shift if @_;\n    return $self->{'desc_tag'};\n}\n\n=head2 analysis_method\n\n Usage     : $obj->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /ERPIN/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /ERPIN/i)) {\n    $self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($gene = $obj->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the ERPIN result\n           file. Call this method repeatedly until FALSE is returned.\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    : None (at present)\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $obj->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the ERPIN result\n           file. Call this method repeatedly until FALSE is returned.\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    : None (at present)","parameters":[{"label":"$self"}],"label":"next_prediction($self)"},"children":[{"line":272,"name":"$self","localvar":"my","containerName":"next_prediction","kind":13,"definition":"my"},{"definition":"my","name":"$motiftag","kind":13,"localvar":"my","containerName":"next_prediction","line":273},{"line":273,"name":"$srctag","kind":13,"containerName":"next_prediction"},{"line":273,"kind":13,"containerName":"next_prediction","name":"$desctag"},{"kind":13,"containerName":"next_prediction","name":"$self","line":273},{"line":273,"kind":12,"containerName":"next_prediction","name":"motif_tag"},{"containerName":"next_prediction","kind":13,"name":"$self","line":274},{"line":274,"name":"source_tag","containerName":"next_prediction","kind":12},{"kind":13,"containerName":"next_prediction","name":"$self","line":275},{"line":275,"containerName":"next_prediction","kind":12,"name":"desc_tag"},{"name":"$strand","containerName":"next_prediction","localvar":"my","kind":13,"line":277,"definition":"my"},{"containerName":"next_prediction","kind":13,"name":"$start","line":277},{"line":277,"kind":13,"containerName":"next_prediction","name":"$end"},{"line":277,"name":"$sequence","containerName":"next_prediction","kind":13},{"name":"$logodds","kind":13,"containerName":"next_prediction","line":277},{"kind":13,"containerName":"next_prediction","name":"$score","line":277},{"name":"$self","containerName":"next_prediction","kind":13,"line":278},{"containerName":"next_prediction","kind":12,"name":"_readline","line":278},{"name":"$self","kind":13,"containerName":"next_prediction","line":284},{"line":287,"kind":13,"containerName":"next_prediction","name":"$self"},{"name":"$self","kind":13,"containerName":"next_prediction","line":290},{"containerName":"next_prediction","kind":13,"name":"$self","line":293},{"line":296,"name":"$self","kind":13,"containerName":"next_prediction"},{"definition":"my","line":299,"localvar":"my","containerName":"next_prediction","kind":13,"name":"$atgc"},{"containerName":"next_prediction","kind":13,"name":"$self","line":300},{"name":"$atgc","kind":13,"containerName":"next_prediction","line":300},{"kind":13,"containerName":"next_prediction","name":"$self","line":303},{"line":307,"kind":13,"containerName":"next_prediction","name":"$self"},{"line":308,"name":"$self","containerName":"next_prediction","kind":13},{"name":"$self","kind":13,"containerName":"next_prediction","line":310},{"line":311,"name":"$self","containerName":"next_prediction","kind":13},{"containerName":"next_prediction","kind":13,"name":"$self","line":313},{"line":313,"name":"$self","containerName":"next_prediction","kind":13},{"name":"$self","containerName":"next_prediction","kind":13,"line":314},{"name":"$strand","kind":13,"containerName":"next_prediction","line":319},{"kind":13,"containerName":"next_prediction","name":"$start","line":319},{"line":319,"name":"$end","kind":13,"containerName":"next_prediction"},{"line":319,"name":"$logodds","containerName":"next_prediction","kind":13},{"line":319,"kind":13,"containerName":"next_prediction","name":"$score"},{"name":"$score","containerName":"next_prediction","kind":13,"line":320},{"name":"$sequence","kind":13,"containerName":"next_prediction","line":321},{"containerName":"next_prediction","kind":13,"name":"$self","line":321},{"line":321,"kind":12,"containerName":"next_prediction","name":"_readline"},{"definition":"my","kind":13,"localvar":"my","containerName":"next_prediction","name":"$gene","line":322},{"kind":12,"containerName":"next_prediction","name":"new","line":322},{"containerName":"next_prediction","kind":13,"name":"$self","line":322},{"line":323,"kind":13,"containerName":"next_prediction","name":"$start"},{"line":324,"name":"$end","containerName":"next_prediction","kind":13},{"line":325,"name":"$strand","containerName":"next_prediction","kind":13},{"line":326,"name":"$score","kind":13,"containerName":"next_prediction"},{"line":327,"containerName":"next_prediction","kind":13,"name":"$motiftag"},{"name":"$srctag","kind":13,"containerName":"next_prediction","line":328},{"line":329,"name":"$desctag","containerName":"next_prediction","kind":13},{"containerName":"next_prediction","kind":13,"name":"$self","line":331},{"containerName":"next_prediction","kind":13,"name":"$self","line":332},{"line":333,"containerName":"next_prediction","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"next_prediction","line":334},{"name":"$self","containerName":"next_prediction","kind":13,"line":335},{"containerName":"next_prediction","kind":13,"name":"$self","line":336},{"name":"$self","kind":13,"containerName":"next_prediction","line":337},{"line":338,"kind":13,"containerName":"next_prediction","name":"$self"},{"line":339,"kind":13,"containerName":"next_prediction","name":"$logodds"},{"line":340,"kind":13,"containerName":"next_prediction","name":"$sequence"},{"line":342,"name":"$gene","kind":13,"containerName":"next_prediction"}],"name":"next_prediction","containerName":"main::","definition":"sub","detail":"($self)"},{"line":307,"name":"_seq_desc","kind":12},{"line":308,"name":"_seq_desc","kind":12},{"name":"_seqid","kind":12,"line":310},{"kind":12,"name":"_seq_acc","line":311},{"name":"_seqid","kind":12,"line":313},{"line":313,"name":"_seq_desc","kind":12},{"kind":12,"name":"_seq_acc","line":314},{"line":322,"name":"Bio","containerName":"SeqFeature::Generic","kind":12},{"line":322,"kind":12,"name":"_seqid"},{"line":331,"name":"_tset","kind":12},{"name":"_tset_descr","kind":12,"line":332},{"name":"_cutoff","kind":12,"line":333},{"kind":12,"name":"_db","line":334},{"kind":12,"name":"_db_desc","line":335},{"line":336,"kind":12,"name":"_db_ratios"},{"line":337,"name":"_seq_desc","kind":12},{"name":"_seq_acc","kind":12,"line":338}]}