{"version":5,"vars":[{"line":92,"containerName":"","kind":2,"name":"vars"},{"name":"base","kind":2,"containerName":"","line":98},{"line":99,"kind":13,"containerName":null,"name":"$DEFAULT_SOURCETAG"},{"line":123,"range":{"start":{"line":123,"character":0},"end":{"line":186,"character":9999}},"kind":12,"signature":{"label":"next_seq($self)","documentation":"1;\n# $Id: Palindrome.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EMBOSS::Palindrome\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::EMBOSS::Palindrome - parse EMBOSS palindrome output\n\n=head1 SYNOPSIS\n\n  # a simple script to turn palindrome output into GFF3\n  use Bio::Tools::EMBOSS::Palindrome;\n  use Bio::Tools::GFF;\n\n  my $parser = Bio::Tools::EMBOSS::Palindrome->new(-file => $filename);\n  my $out    = Bio::Tools::GFF->new(-gff_version => 3,\n                                   -file => \">$filename.gff\");\n  while( my $seq = $parser->next_seq ) {\n     for my $feat ( $seq->get_SeqFeatures ) {\n        $out->write_feature($feat);\n     }\n  }\n\n=head1 DESCRIPTION\n\nThis is a parser for the EMBOSS tool 'palindrome'.  It will produce a\nL<Bio::Seq> object for each sequence analyzed.  The sequence will be\nempty (but will be of the correct length) and will have attached to it\nL<Bio::SeqFeature::FeaturePair> objects which wil\n\n\n=head2 FUTURE WORK\n\nIt may be consolidated into another framework at a later time, but for\nthe time being it will stay a separate modules.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::EMBOSS::Palindrome;\nuse vars qw($DEFAULT_SOURCETAG);\nuse strict;\n\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::IO);\n$DEFAULT_SOURCETAG = 'palindrome';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::EMBOSS::Palindrome->new();\n Function: Builds a new Bio::Tools::EMBOSS::Palindrome object \n Returns : an instance of Bio::Tools::EMBOSS::Palindrome\n Args    : -file/-fh  => a filename or filehandle for\n                         initializing the parser\n\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : my $seq = $parser->next_seq;\n Function: Get the next feature set from the \n Returns : L<Bio::SeqI> object\n Args    : none","parameters":[{"label":"$self"}]},"children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"next_seq","line":124},{"definition":"my","localvar":"my","kind":13,"containerName":"next_seq","name":"%searching","line":125},{"line":125,"kind":13,"containerName":"next_seq","name":"$seq"},{"kind":13,"containerName":"next_seq","name":"$state","line":125},{"definition":"my","name":"$source","containerName":"next_seq","localvar":"my","kind":13,"line":126},{"name":"$self","kind":13,"containerName":"next_seq","line":126},{"name":"source_tag","kind":12,"containerName":"next_seq","line":126},{"line":127,"kind":13,"containerName":"next_seq","name":"$state"},{"line":128,"name":"$self","kind":13,"containerName":"next_seq"},{"name":"_readline","kind":12,"containerName":"next_seq","line":128},{"kind":13,"containerName":"next_seq","name":"$state","line":132},{"kind":13,"containerName":"next_seq","name":"$seq","line":133},{"line":134,"kind":13,"containerName":"next_seq","name":"$self"},{"name":"_pushback","containerName":"next_seq","kind":12,"line":134},{"name":"$seq","kind":13,"containerName":"next_seq","line":135},{"line":137,"containerName":"next_seq","kind":13,"name":"$seq"},{"name":"new","kind":12,"containerName":"next_seq","line":137},{"line":139,"name":"$searching","containerName":"next_seq","kind":13},{"name":"$seq","containerName":"next_seq","kind":13,"line":141},{"line":141,"name":"length","kind":12,"containerName":"next_seq"},{"containerName":"next_seq","kind":13,"name":"$searching","line":142},{"name":"$searching","kind":13,"containerName":"next_seq","line":144},{"line":147,"name":"$searching","containerName":"next_seq","kind":13},{"line":149,"kind":13,"containerName":"next_seq","name":"$searching"},{"name":"$searching","kind":13,"containerName":"next_seq","line":152},{"name":"$state","kind":13,"containerName":"next_seq","line":154},{"name":"$state","containerName":"next_seq","kind":13,"line":155},{"line":156,"name":"$feature","localvar":"my","containerName":"next_seq","kind":13,"definition":"my"},{"name":"new","containerName":"next_seq","kind":12,"line":157},{"name":"$source","containerName":"next_seq","kind":13,"line":158},{"definition":"my","kind":13,"localvar":"my","containerName":"next_seq","name":"$i","line":159},{"line":159,"kind":13,"containerName":"next_seq","name":"$i"},{"containerName":"next_seq","kind":13,"name":"$i","line":159},{"name":"$i","containerName":"next_seq","kind":13,"line":160},{"definition":"my","name":"$start","containerName":"next_seq","localvar":"my","kind":13,"line":162},{"line":162,"kind":13,"containerName":"next_seq","name":"$match"},{"line":162,"kind":13,"containerName":"next_seq","name":"$end"},{"definition":"my","name":"$type","kind":13,"localvar":"my","containerName":"next_seq","line":163},{"line":163,"name":"$i","containerName":"next_seq","kind":13},{"containerName":"next_seq","kind":13,"name":"$start","line":164},{"line":164,"kind":13,"containerName":"next_seq","name":"$end"},{"name":"$a","kind":13,"containerName":"next_seq","line":164},{"line":164,"name":"$b","kind":13,"containerName":"next_seq"},{"line":164,"name":"$start","containerName":"next_seq","kind":13},{"name":"$end","containerName":"next_seq","kind":13,"line":164},{"containerName":"next_seq","kind":13,"name":"$feature","line":165},{"line":165,"name":"$type","containerName":"next_seq","kind":13},{"line":167,"name":"new","containerName":"next_seq","kind":12},{"name":"%searching","containerName":"next_seq","kind":13,"line":167},{"line":168,"containerName":"next_seq","kind":13,"name":"$start"},{"line":169,"kind":13,"containerName":"next_seq","name":"$end"},{"line":170,"name":"$i","kind":13,"containerName":"next_seq"},{"containerName":"next_seq","kind":13,"name":"$source","line":172},{"name":"$self","kind":13,"containerName":"next_seq","line":180},{"kind":12,"containerName":"next_seq","name":"_readline","line":180},{"line":182,"kind":13,"containerName":"next_seq","name":"$seq"},{"line":182,"kind":12,"containerName":"next_seq","name":"add_SeqFeature"},{"line":182,"name":"$feature","containerName":"next_seq","kind":13},{"line":185,"kind":13,"containerName":"next_seq","name":"$seq"}],"containerName":"main::","name":"next_seq","definition":"sub","detail":"($self)"},{"name":"Bio","kind":12,"containerName":"Seq","line":137},{"line":156,"name":"Bio","kind":12,"containerName":"SeqFeature::FeaturePair"},{"line":166,"name":"Bio","kind":12,"containerName":"SeqFeature::Generic"},{"line":199,"kind":12,"range":{"start":{"line":199,"character":0},"end":{"line":204,"character":9999}},"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"source_tag","line":200,"definition":"my"},{"line":202,"kind":13,"containerName":"source_tag","name":"$self"},{"kind":13,"containerName":"source_tag","name":"$self","line":203},{"name":"$DEFAULT_SOURCETAG","kind":13,"containerName":"source_tag","line":203}],"containerName":"main::","name":"source_tag","definition":"sub"}]}