{"version":5,"vars":[{"kind":2,"containerName":"","name":"vars","line":159},{"line":163,"name":"Common","containerName":"strict::IO::String::Bio::SeqIO::HTTP::Request","kind":2},{"name":"base","kind":2,"containerName":"","line":166},{"line":168,"kind":13,"containerName":null,"name":"$FLOAT"},{"line":169,"kind":13,"containerName":null,"name":"@STRINGENCY"},{"line":170,"name":"$URL","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"localvar":"my","containerName":null,"kind":13,"name":"%ANALYSIS_SPEC","line":173,"definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"@INPUT_SPEC","line":183},{"definition":"my","line":204,"name":"%RESULT_SPEC","localvar":"my","containerName":null,"kind":13},{"signature":{"label":"result($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Scansite.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::Scansite\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams <richard.adams@ed.ac.uk>\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Analysis::Protein::Scansite - a wrapper around the Scansite server\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Analysis::Protein::Scansite;\n\n  my $seq; # a Bio::PrimarySeqI object\n\n  my $tool = Bio::Tools::Analysis::Protein::Scansite->new\n     ( -seq => $seq->primary_seq ); \n\n  # run Scansite prediction on a sequence\n  $tool->run();\n\n  # alternatively you can say\n  $tool->seq($seq->primary_seq)->run;\n\n  die \"Could not get a result\" unless $tool->status =~ /^COMPLETED/;\n\n  print $tool->result;     # print raw prediction to STDOUT\n\n  foreach my $feat ( $tool->result('Bio::SeqFeatureI') ) {\n\n      # do something to SeqFeature\n      # e.g. print as GFF\n      print $feat->gff_string, \"\\n\";\n      # or store within the sequence - if it is a Bio::RichSeqI\n      $seq->add_SeqFeature($feat);\n\n }\n\n=head1 DESCRIPTION\n\nThis class is a wrapper around the Scansite 2.0 server which produces\npredictions for serine, threonine and tyrosine phosphorylation sites\nin eukaryotic proteins. At present this is a basic wrapper for the\n\"Scan protein by input sequence\" functionality, which takes a sequence\nand searches for motifs, with the option to select the search\nstringency. At present, searches for specific phosphorylation\nsites are not supported; all predicted sites are returned.\n\n=head2 Return formats\n\nThe Scansite results can be obtained in several formats:\n\n=over 3\n\n* 1.\n\nBy calling\n\n  my $res = $tool->result('');\n\n$res holds a string of the predicted sites in tabular format.\n\n* 2.\n\nBy calling \n\n  my $data_ref = $tool->result('value')\n\n$data_ref is a reference to an array of hashes. Each element in the\narray represents a predicted phosphorylation site. The hash keys are\nthe names of the data fields,i.e.,\n\n    'motif'      => 'Casn_Kin1'       # name of kinase\n    'percentile' => 0.155             # see Scansite docs\n    'position'   => 9                 # position in protein\n    'protein'    => 'A1'              # protein id\n    'score'      => 0.3696            # see Scansite docs\n    'sequence'   => 'ASYFDTASYFSADAT' # sequence surrounding site\n    'site'       => 'S9'              # phosphorylated residue\n    'zscore'     => '-3.110'          # see Scansite docs\n\n* 3.\n\nBy calling\n\n  my @fts = $tool->Result('Bio::SeqFeatureI');\n\nwhich returns an array of L<Bio::SeqFeatureI> compliant objects with\nprimary tag value 'Site' and tag names of 'motif', 'score',\n'sequence', 'zscore' as above.\n\n\nSee L<http://scansite.mit.edu/>.\n\nThis inherits Bio::SimpleAnalysisI which hopefully makes it easier to\nwrite wrappers on various services. This class uses a web resource and\ntherefore inherits from L<Bio::WebAgent>.\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>, \nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk, \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Analysis::Protein::Scansite;\nuse vars qw($FLOAT @STRINGENCY);\nuse strict;\nuse IO::String;\nuse Bio::SeqIO;\nuse HTTP::Request::Common qw(POST);\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n\n$FLOAT = '[+-]?\\d*\\.\\d*';\n@STRINGENCY = qw(High Medium Low);\nmy $URL = 'http://scansite.mit.edu/cgi-bin/motifscan_seq';\n\n\n    my $ANALYSIS_SPEC =\n        {\n         'name'        => 'Scansite',\n         'type'        => 'Protein',\n         'version'     => '2.0',\n         'supplier'    => 'Massachusetts Institute of Technology',\n         'description' => 'Prediction of serine, threonine and tyrosine\n                             phosphorylation sites in eukaryotic proteins',\n        };\n\n    my $INPUT_SPEC =\n        [\n         {\n          'mandatory' => 'true',\n          'type'      => 'Bio::PrimarySeqI',\n          'name'      => 'seq',\n         },\n         {\n          'mandatory' => 'false',\n          'type'      => 'text',\n          'name'      => 'protein_id',\n          'default'   => 'unnamed',\n         },\n         {\n          'mandatory' => 'false',\n          'type'      => 'text',\n          'name'      => 'stringency',\n          'default'   => 'High',\n         },\n        ];\n\n    my $RESULT_SPEC =\n        {\n         ''                 => 'bulk',  # same as undef\n         'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeature::Generic',\n         'raw'              => 'Array of {motif=>, percentile=>, position=>,\n\t\t\t\t\t  protein=>, score=>, site=>, zscore=>\n                                          sequence=>\n\t     \t\t\t\t }',\n        };\n\n\n=head2 result\n\n Name    : result\n Usage   : $job->result (...)\n Returns : a result created by running an analysis\n Args    : none (but an implementation may choose\n           to add arguments for instructions how to process\n           the raw result)\n\nThe method returns a scalar representing a result of an executed\njob. If the job was terminated by an error, the result may contain \nan error message instead of the real data.\n\nThis implementation returns differently processed data depending on\nargument:\n\n=over 3\n\n* undef\n\nReturns the raw ASCII data stream but without HTML tags\n\n* 'Bio::SeqFeatureI'\n\nThe argument string defined the type of bioperl objects returned in an\narray.  The objects are L<Bio::SeqFeature::Generic>.\n\n* 'parsed'\n\nReturns a reference to an array of hashes containing the data of one\nphosphorylation site prediction. Key values are:\n\nmotif, percentile, position, protein, score, site, zscore,  sequence."},"line":255,"kind":12,"range":{"end":{"character":9999,"line":286},"start":{"line":255,"character":0}},"definition":"sub","detail":"($self,$value)","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"result","line":256,"definition":"my"},{"name":"$value","containerName":"result","kind":13,"line":256},{"line":257,"name":"$self","containerName":"result","kind":13},{"line":257,"name":"$self","containerName":"result","kind":13},{"name":"status","containerName":"result","kind":12,"line":257},{"line":258,"name":"$self","kind":13,"containerName":"result"},{"line":258,"kind":12,"containerName":"result","name":"throw"},{"line":260,"kind":13,"localvar":"my","containerName":"result","name":"@fts","definition":"my"},{"name":"$value","kind":13,"containerName":"result","line":262},{"line":263,"name":"$value","containerName":"result","kind":13},{"definition":"my","containerName":"result","localvar":"my","kind":13,"name":"$hit","line":264},{"name":"$self","containerName":"result","kind":13,"line":264},{"line":265,"kind":13,"containerName":"result","name":"@fts"},{"line":265,"name":"new","kind":12,"containerName":"result"},{"line":266,"name":"$hit","kind":13,"containerName":"result"},{"name":"$hit","kind":13,"containerName":"result","line":267},{"line":271,"kind":13,"containerName":"result","name":"$hit"},{"name":"$hit","containerName":"result","kind":13,"line":272},{"name":"$hit","containerName":"result","kind":13,"line":273},{"name":"$hit","kind":13,"containerName":"result","line":274},{"name":"$hit","containerName":"result","kind":13,"line":275},{"line":279,"kind":13,"containerName":"result","name":"@fts"},{"line":281,"containerName":"result","kind":13,"name":"$value"},{"line":282,"kind":13,"containerName":"result","name":"$self"},{"line":282,"name":"throw","containerName":"result","kind":12},{"name":"$self","containerName":"result","kind":13,"line":285}],"containerName":"main::","name":"result"},{"name":"Bio","containerName":"SeqFeature::Generic","kind":12,"line":265},{"line":271,"kind":12,"name":"score"},{"line":272,"name":"zscore","kind":12},{"kind":12,"name":"motif","line":273},{"line":274,"kind":12,"name":"site"},{"line":275,"name":"sequence","kind":12},{"name":"%self","containerName":null,"kind":13,"line":288},{"signature":{"documentation":"1;\n# $Id: Scansite.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::Scansite\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams <richard.adams@ed.ac.uk>\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Analysis::Protein::Scansite - a wrapper around the Scansite server\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Analysis::Protein::Scansite;\n\n  my $seq; # a Bio::PrimarySeqI object\n\n  my $tool = Bio::Tools::Analysis::Protein::Scansite->new\n     ( -seq => $seq->primary_seq ); \n\n  # run Scansite prediction on a sequence\n  $tool->run();\n\n  # alternatively you can say\n  $tool->seq($seq->primary_seq)->run;\n\n  die \"Could not get a result\" unless $tool->status =~ /^COMPLETED/;\n\n  print $tool->result;     # print raw prediction to STDOUT\n\n  foreach my $feat ( $tool->result('Bio::SeqFeatureI') ) {\n\n      # do something to SeqFeature\n      # e.g. print as GFF\n      print $feat->gff_string, \"\\n\";\n      # or store within the sequence - if it is a Bio::RichSeqI\n      $seq->add_SeqFeature($feat);\n\n }\n\n=head1 DESCRIPTION\n\nThis class is a wrapper around the Scansite 2.0 server which produces\npredictions for serine, threonine and tyrosine phosphorylation sites\nin eukaryotic proteins. At present this is a basic wrapper for the\n\"Scan protein by input sequence\" functionality, which takes a sequence\nand searches for motifs, with the option to select the search\nstringency. At present, searches for specific phosphorylation\nsites are not supported; all predicted sites are returned.\n\n=head2 Return formats\n\nThe Scansite results can be obtained in several formats:\n\n=over 3\n\n* 1.\n\nBy calling\n\n  my $res = $tool->result('');\n\n$res holds a string of the predicted sites in tabular format.\n\n* 2.\n\nBy calling \n\n  my $data_ref = $tool->result('value')\n\n$data_ref is a reference to an array of hashes. Each element in the\narray represents a predicted phosphorylation site. The hash keys are\nthe names of the data fields,i.e.,\n\n    'motif'      => 'Casn_Kin1'       # name of kinase\n    'percentile' => 0.155             # see Scansite docs\n    'position'   => 9                 # position in protein\n    'protein'    => 'A1'              # protein id\n    'score'      => 0.3696            # see Scansite docs\n    'sequence'   => 'ASYFDTASYFSADAT' # sequence surrounding site\n    'site'       => 'S9'              # phosphorylated residue\n    'zscore'     => '-3.110'          # see Scansite docs\n\n* 3.\n\nBy calling\n\n  my @fts = $tool->Result('Bio::SeqFeatureI');\n\nwhich returns an array of L<Bio::SeqFeatureI> compliant objects with\nprimary tag value 'Site' and tag names of 'motif', 'score',\n'sequence', 'zscore' as above.\n\n\nSee L<http://scansite.mit.edu/>.\n\nThis inherits Bio::SimpleAnalysisI which hopefully makes it easier to\nwrite wrappers on various services. This class uses a web resource and\ntherefore inherits from L<Bio::WebAgent>.\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>, \nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk, \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Analysis::Protein::Scansite;\nuse vars qw($FLOAT @STRINGENCY);\nuse strict;\nuse IO::String;\nuse Bio::SeqIO;\nuse HTTP::Request::Common qw(POST);\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n\n$FLOAT = '[+-]?\\d*\\.\\d*';\n@STRINGENCY = qw(High Medium Low);\nmy $URL = 'http://scansite.mit.edu/cgi-bin/motifscan_seq';\n\n\n    my $ANALYSIS_SPEC =\n        {\n         'name'        => 'Scansite',\n         'type'        => 'Protein',\n         'version'     => '2.0',\n         'supplier'    => 'Massachusetts Institute of Technology',\n         'description' => 'Prediction of serine, threonine and tyrosine\n                             phosphorylation sites in eukaryotic proteins',\n        };\n\n    my $INPUT_SPEC =\n        [\n         {\n          'mandatory' => 'true',\n          'type'      => 'Bio::PrimarySeqI',\n          'name'      => 'seq',\n         },\n         {\n          'mandatory' => 'false',\n          'type'      => 'text',\n          'name'      => 'protein_id',\n          'default'   => 'unnamed',\n         },\n         {\n          'mandatory' => 'false',\n          'type'      => 'text',\n          'name'      => 'stringency',\n          'default'   => 'High',\n         },\n        ];\n\n    my $RESULT_SPEC =\n        {\n         ''                 => 'bulk',  # same as undef\n         'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeature::Generic',\n         'raw'              => 'Array of {motif=>, percentile=>, position=>,\n\t\t\t\t\t  protein=>, score=>, site=>, zscore=>\n                                          sequence=>\n\t     \t\t\t\t }',\n        };\n\n\n=head2 result\n\n Name    : result\n Usage   : $job->result (...)\n Returns : a result created by running an analysis\n Args    : none (but an implementation may choose\n           to add arguments for instructions how to process\n           the raw result)\n\nThe method returns a scalar representing a result of an executed\njob. If the job was terminated by an error, the result may contain \nan error message instead of the real data.\n\nThis implementation returns differently processed data depending on\nargument:\n\n=over 3\n\n* undef\n\nReturns the raw ASCII data stream but without HTML tags\n\n* 'Bio::SeqFeatureI'\n\nThe argument string defined the type of bioperl objects returned in an\narray.  The objects are L<Bio::SeqFeature::Generic>.\n\n* 'parsed'\n\nReturns a reference to an array of hashes containing the data of one\nphosphorylation site prediction. Key values are:\n\nmotif, percentile, position, protein, score, site, zscore,  sequence.\n\n\n\n\n\nsub result {\n    my ($self,$value) = @_;\n\tif( !exists($self->{'_result'}) || $self->status ne 'COMPLETED'){\n\t\t$self->throw(\"Cannot get results, analysis not run!\");\n\t\t}\t\n    my @fts;\n\n    if ($value ) {\n\t\tif ($value eq 'Bio::SeqFeatureI') {\n\t\t\tfor my $hit (@{$self->{'_parsed'}}) {\n\t\t\t\tpush @fts, Bio::SeqFeature::Generic->new(\n\t\t\t\t\t-start       => $hit->{'position'},\n\t\t\t\t\t-end         => $hit->{'position'},\n\t\t\t\t    -primary_tag => 'Site',\n\t\t\t\t\t-source      => 'Scansite',\n\t\t\t\t\t-tag => {\n\t\t\t\t\t\tscore     => $hit->{'score'},\n\t\t\t\t\t\tzscore    => $hit->{'zscore'},\n\t\t\t\t\t\tmotif     => $hit->{'motif'},\n\t\t\t\t\t\tsite      => $hit->{'site'},\n\t\t\t\t\t\tsequence  => $hit->{'sequence'},\n\t\t\t\t\t\t\t},\n\t\t\t\t);\n\t\t\t}\n\t\t\treturn @fts;\n\t\t}\n\t\telsif ($value eq 'meta') {\n\t\t\t$self->throw(\"No meta sequences available in this analysis!\");\n\t\t\t}\n\t\t## else get here\n\t\treturn $self->{'_parsed'};\n    }\n\n    return $self->{'_result'};\n}\n\n=head2  stringency\n\n Usage    : $job->stringency(...)\n Returns  : The significance stringency of a prediction\n Args     : None (retrieves value) or 'High', 'Medium' or 'Low'.\n Purpose  : Get/setter of the stringency to be sumitted for analysis.","parameters":[{"label":"$self"},{"label":"$value"}],"label":"stringency($self,$value)"},"line":300,"range":{"end":{"character":9999,"line":312},"start":{"character":0,"line":300}},"kind":12,"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"stringency","name":"$self","line":301},{"name":"$value","kind":13,"containerName":"stringency","line":301},{"kind":13,"containerName":"stringency","name":"$value","line":302},{"kind":13,"containerName":"stringency","name":"@STRINGENCY","line":303},{"line":304,"name":"$self","kind":13,"containerName":"stringency"},{"line":304,"containerName":"stringency","kind":12,"name":"throw"},{"name":"@STRINGENCY","containerName":"stringency","kind":13,"line":305},{"containerName":"stringency","kind":13,"name":"$self","line":308},{"name":"$value","containerName":"stringency","kind":13,"line":308},{"name":"$self","kind":13,"containerName":"stringency","line":309},{"line":311,"kind":13,"containerName":"stringency","name":"$self"},{"containerName":"stringency","kind":13,"name":"$self","line":311},{"kind":12,"containerName":"stringency","name":"input_spec","line":311}],"containerName":"main::","name":"stringency"},{"definition":"sub","containerName":"main::","name":"protein_id","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"protein_id","line":325},{"name":"$self","containerName":"protein_id","kind":13,"line":326},{"line":326,"name":"seq","containerName":"protein_id","kind":12},{"containerName":"protein_id","kind":13,"name":"$self","line":326},{"line":326,"kind":12,"containerName":"protein_id","name":"seq"},{"line":326,"containerName":"protein_id","kind":12,"name":"display_id"},{"line":327,"name":"$self","kind":13,"containerName":"protein_id"},{"containerName":"protein_id","kind":12,"name":"input_spec","line":327}],"kind":12,"range":{"end":{"line":328,"character":9999},"start":{"line":324,"character":0}},"line":324},{"line":330,"range":{"end":{"character":9999,"line":339},"start":{"line":330,"character":0}},"kind":12,"definition":"sub","children":[{"line":332,"containerName":"_init","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":333,"containerName":"_init","kind":13,"name":"$self"},{"containerName":"_init","kind":12,"name":"url","line":333},{"containerName":"_init","kind":13,"name":"$URL","line":333},{"line":334,"kind":13,"containerName":"_init","name":"$self"},{"name":"$ANALYSIS_SPEC","kind":13,"containerName":"_init","line":334},{"line":335,"name":"$self","containerName":"_init","kind":13},{"kind":13,"containerName":"_init","name":"$INPUT_SPEC","line":335},{"name":"$self","containerName":"_init","kind":13,"line":336},{"name":"$RESULT_SPEC","kind":13,"containerName":"_init","line":336},{"line":337,"containerName":"_init","kind":13,"name":"$self"},{"line":337,"name":"$ANALYSIS_SPEC","kind":13,"containerName":"_init"},{"name":"$self","kind":13,"containerName":"_init","line":338}],"containerName":"main::","name":"_init"},{"definition":"sub","children":[{"definition":"my","line":342,"name":"$self","containerName":"_run","localvar":"my","kind":13},{"containerName":"_run","kind":13,"name":"$self","line":345},{"line":345,"containerName":"_run","kind":12,"name":"delay"},{"name":"$self","kind":13,"containerName":"_run","line":347},{"line":347,"kind":12,"containerName":"_run","name":"sleep"},{"line":349,"name":"$self","containerName":"_run","kind":13},{"name":"status","containerName":"_run","kind":12,"line":349},{"name":"$request","localvar":"my","kind":13,"containerName":"_run","line":351,"definition":"my"},{"line":351,"name":"$self","kind":13,"containerName":"_run"},{"name":"url","kind":12,"containerName":"_run","line":351},{"name":"$self","containerName":"_run","kind":13,"line":352},{"line":352,"name":"seq","containerName":"_run","kind":12},{"line":352,"name":"seq","kind":12,"containerName":"_run"},{"line":353,"name":"$self","containerName":"_run","kind":13},{"line":353,"name":"protein_id","kind":12,"containerName":"_run"},{"name":"$self","containerName":"_run","kind":13,"line":357},{"name":"stringency","containerName":"_run","kind":12,"line":357},{"line":362,"name":"$content","localvar":"my","containerName":"_run","kind":13,"definition":"my"},{"containerName":"_run","kind":13,"name":"$self","line":362},{"line":362,"name":"request","containerName":"_run","kind":12},{"name":"$request","kind":13,"containerName":"_run","line":362},{"line":363,"kind":13,"localvar":"my","containerName":"_run","name":"$text","definition":"my"},{"name":"$content","kind":13,"containerName":"_run","line":363},{"line":363,"name":"content","containerName":"_run","kind":12},{"definition":"my","line":366,"containerName":"_run","localvar":"my","kind":13,"name":"@parsed_Results"},{"localvar":"my","containerName":"_run","kind":13,"name":"@unwantedParams","line":367,"definition":"my"},{"line":368,"containerName":"_run","localvar":"my","kind":13,"name":"@results","definition":"my"},{"name":"$text","kind":13,"containerName":"_run","line":368},{"line":369,"name":"@results","kind":13,"containerName":"_run"},{"definition":"my","name":"$hit","localvar":"my","kind":13,"containerName":"_run","line":374},{"name":"@results","kind":13,"containerName":"_run","line":374},{"localvar":"my","containerName":"_run","kind":13,"name":"$res","line":376,"definition":"my"},{"line":376,"kind":13,"containerName":"_run","name":"$hit"},{"definition":"my","line":379,"name":"%params","containerName":"_run","localvar":"my","kind":13},{"line":379,"containerName":"_run","kind":13,"name":"$res"},{"line":382,"name":"$params","kind":13,"containerName":"_run"},{"name":"@unwantedParams","kind":13,"containerName":"_run","line":382},{"containerName":"_run","kind":13,"name":"@parsed_Results","line":383},{"line":383,"name":"%params","kind":13,"containerName":"_run"},{"definition":"my","kind":13,"localvar":"my","containerName":"_run","name":"$out_Str","line":387},{"name":"$out_Str","kind":13,"containerName":"_run","line":388},{"kind":13,"containerName":"_run","name":"$self","line":388},{"containerName":"_run","kind":12,"name":"_make_header","line":388},{"kind":13,"containerName":"_run","name":"@parsed_Results","line":388},{"name":"$out_Str","kind":13,"containerName":"_run","line":389},{"line":389,"name":"$self","containerName":"_run","kind":13},{"line":389,"name":"_add_data","containerName":"_run","kind":12},{"line":389,"kind":13,"containerName":"_run","name":"@parsed_Results"},{"line":392,"name":"$self","containerName":"_run","kind":13},{"name":"$out_Str","containerName":"_run","kind":13,"line":392},{"line":393,"name":"$self","kind":13,"containerName":"_run"},{"kind":13,"containerName":"_run","name":"@parsed_Results","line":393},{"line":397,"kind":13,"containerName":"_run","name":"$self"},{"line":397,"containerName":"_run","kind":12,"name":"status"},{"line":397,"kind":13,"containerName":"_run","name":"$text"},{"line":398,"name":"@results","containerName":"_run","kind":13},{"line":399,"name":"@results","containerName":"_run","kind":13},{"line":399,"kind":13,"containerName":"_run","name":"$text"},{"line":400,"kind":13,"containerName":"_run","name":"$text"},{"name":"$self","containerName":"_run","kind":13,"line":401},{"line":401,"name":"warn","containerName":"_run","kind":12},{"kind":13,"containerName":"_run","name":"$self","line":402},{"line":402,"name":"warn","containerName":"_run","kind":12},{"name":"$text","kind":13,"containerName":"_run","line":402}],"containerName":"main::","name":"_run","line":341,"range":{"end":{"line":405,"character":9999},"start":{"line":341,"character":0}},"kind":12},{"line":351,"name":"POST","kind":12},{"line":352,"kind":12,"name":"Content"},{"line":352,"name":"sequence","kind":12},{"line":353,"kind":12,"name":"protein_id"},{"line":354,"kind":12,"name":"motif_option"},{"kind":12,"name":"motifs","line":355},{"name":"motif_groups","kind":12,"line":356},{"name":"stringency","kind":12,"line":357},{"line":358,"name":"domain_flag","kind":12},{"line":359,"kind":12,"name":"submit"},{"children":[{"line":411,"localvar":"my","kind":13,"containerName":"_process_arguments","name":"$self","definition":"my"},{"containerName":"_process_arguments","kind":13,"name":"$args","line":411},{"kind":13,"containerName":"_process_arguments","name":"$self","line":413},{"line":413,"name":"$args","kind":13,"containerName":"_process_arguments"},{"line":416,"kind":13,"containerName":"_process_arguments","name":"$self"},{"name":"throw","containerName":"_process_arguments","kind":12,"line":416},{"name":"$self","containerName":"_process_arguments","kind":13,"line":417},{"line":417,"name":"seq","kind":12,"containerName":"_process_arguments"},{"line":417,"name":"length","containerName":"_process_arguments","kind":12},{"line":418,"containerName":"_process_arguments","kind":13,"name":"$self"},{"name":"throw","containerName":"_process_arguments","kind":12,"line":418},{"line":419,"name":"$self","kind":13,"containerName":"_process_arguments"},{"name":"seq","kind":12,"containerName":"_process_arguments","line":419},{"line":419,"name":"alphabet","kind":12,"containerName":"_process_arguments"}],"containerName":"main::","name":"_process_arguments","definition":"sub","detail":"($self,$args)","line":407,"kind":12,"range":{"end":{"character":9999,"line":420},"start":{"character":0,"line":407}},"signature":{"label":"_process_arguments($self,$args)","parameters":[{"label":"$self"},{"label":"$args"}],"documentation":""}},{"line":413,"name":"SUPER","kind":12,"containerName":"_process_arguments"},{"detail":"($self,$res)","definition":"sub","name":"_make_header","containerName":"main::","children":[{"line":423,"localvar":"my","kind":13,"containerName":"_make_header","name":"$self","definition":"my"},{"name":"$res","containerName":"_make_header","kind":13,"line":423},{"containerName":"_make_header","localvar":"my","kind":13,"name":"$header","line":424,"definition":"my"},{"localvar":"my","kind":13,"containerName":"_make_header","name":"$k","line":425,"definition":"my"},{"name":"$res","containerName":"_make_header","kind":13,"line":425}],"signature":{"parameters":[{"label":"$self"},{"label":"$res"}],"documentation":"","label":"_make_header($self,$res)"},"range":{"start":{"line":422,"character":0},"end":{"line":425,"character":9999}},"kind":12,"line":422},{"containerName":null,"kind":13,"name":"$k","line":426},{"containerName":null,"kind":13,"name":"$header","line":427},{"line":427,"name":"$k","containerName":null,"kind":13},{"line":428,"kind":13,"containerName":null,"name":"$header"},{"kind":13,"containerName":null,"name":"$k","line":428},{"line":430,"kind":13,"containerName":null,"name":"$header"},{"line":431,"name":"$header","kind":13,"containerName":null},{"definition":"sub","detail":"($self,$res)","children":[{"definition":"my","line":435,"localvar":"my","containerName":"_add_data","kind":13,"name":"$self"},{"line":435,"containerName":"_add_data","kind":13,"name":"$res"},{"definition":"my","line":436,"name":"$outstr","localvar":"my","kind":13,"containerName":"_add_data"},{"line":437,"kind":13,"localvar":"my","containerName":"_add_data","name":"$hit","definition":"my"},{"containerName":"_add_data","kind":13,"name":"$res","line":437},{"containerName":"_add_data","localvar":"my","kind":13,"name":"$k","line":438,"definition":"my"},{"line":438,"name":"$hit","containerName":"_add_data","kind":13},{"line":439,"containerName":"_add_data","kind":13,"name":"$k"},{"line":440,"name":"$outstr","containerName":"_add_data","kind":13},{"kind":13,"containerName":"_add_data","name":"$hit","line":440},{"containerName":"_add_data","kind":13,"name":"$k","line":440},{"name":"$outstr","containerName":"_add_data","kind":13,"line":441},{"containerName":"_add_data","kind":13,"name":"$hit","line":441},{"line":441,"kind":13,"containerName":"_add_data","name":"$k"},{"name":"$outstr","kind":13,"containerName":"_add_data","line":443},{"line":443,"containerName":"_add_data","kind":13,"name":"$hit"},{"line":443,"name":"$hit","containerName":"_add_data","kind":13},{"line":445,"name":"$outstr","containerName":"_add_data","kind":13}],"name":"_add_data","containerName":"main::","signature":{"label":"_add_data($self,$res)","documentation":"","parameters":[{"label":"$self"},{"label":"$res"}]},"line":434,"range":{"start":{"line":434,"character":0},"end":{"line":448,"character":9999}},"kind":12}]}