{"vars":[{"line":137,"name":"vars","kind":2,"containerName":""},{"containerName":"strict::IO::String::Bio::SeqIO::HTTP::Request","kind":2,"name":"Common","line":142},{"containerName":"","kind":2,"name":"base","line":145},{"name":"$FLOAT","kind":13,"containerName":null,"line":146},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$URL","line":148},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"%STATUS","line":151},{"localvar":"my","kind":13,"containerName":null,"name":"$MIN_LEN","line":153,"definition":"my"},{"name":"$ANALYSIS_NAME","localvar":"my","kind":13,"containerName":null,"line":154,"definition":"my"},{"definition":"my","line":156,"name":"%ANALYSIS_SPEC","localvar":"my","containerName":null,"kind":13},{"name":"@INPUT_SPEC","containerName":null,"localvar":"my","kind":13,"line":165,"definition":"my"},{"definition":"my","name":"%RESULT_SPEC","containerName":null,"localvar":"my","kind":13,"line":174},{"signature":{"label":"result($self,$value)","documentation":"1;\n# $Id: Mitoprot.pm,\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::Mitoprot\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Analysis::Protein::Mitoprot - a wrapper around Mitoprot\nserver\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Analysis::Protein::Mitoprot;\n\n  use Bio::PrimarySeq;\n  my $seq = Bio::PrimarySeq->new\n    (-seq=>'IKLCVHHJHJHJHJHJHJHNLAILAKAHLIELALAL',\n     -primary_id=>'test'); # a Bio::PrimarySeqI object\n\n  my $mitoprot = Bio::Tools::Analysis::Protein::Mitoprot->new\n     ( -seq => $seq\n     ); # sequence must be  >!5aa long and start with an M.\n\n  # run Mitoprot prediction on a DNA sequence\n  my $mitoprot->run();\n\n\n  die \"Could not get a result\" unless $mitoprot->status =~ /^COMPLETED/;\n\n  print $mitoprot->result;     # print raw prediction to STDOUT\n\n  foreach my $feat ( $mitoprot->result('Bio::SeqFeatureI') ) {\n\n      # do something to SeqFeature\n      # e.g. print as GFF\n      print $feat->gff_string, \"\\n\";\n      # or store within the sequence - if it is a Bio::RichSeqI\n      $seq->add_SeqFeature($feat);\n\n }\n\n=head1 DESCRIPTION\n\nThis class is a wrapper around the Mitoprot web server which\ncalculates the probability of a sequence containing a mitochondrial\ntargetting peptide. See http://mips.gsf.de/cgi-bin/proj/medgen/mitofilter\nfor more details.\n\nThe results can be obtained in 3 formats:\n\n=over 3\n\n* 1\n\nThe raw text of the program output\n\n  my $rawdata = $analysis_object->result;\n\n* 2\n\nAn reference to a hash of  scores :\n\n  my $data_ref = $analysis_object->result('parsed'); print \"predicted\n  export prob is $data_ref->{'export_prob'}\\n\"; #\n\nkey values of returned hash are input_length, basic_aas, acidic_aas,\nexport_prob, charge, cleavage_site.\n\n* 3\n\nA Bio::SeqFeature::Generic object\n\n  my $ft = $analysis_object->result(Bio::SeqFeatureI);\n  print \"export prob is \", ($ft->each_tag_value('export_prob'))[0]  ,\"\\n\";\n\n\nThis the second implentation of Bio::SimpleAnalysisI which hopefully\nwill make it easier to write wrappers on various services. This class\nuses a web resource and therefore inherits from Bio::WebAgent.\n\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>,\nL<Bio::Tools::Analysis::SimpleAnalysisBase>,\nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk,\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Analysis::Protein::Mitoprot;\nuse vars qw($FLOAT);\nuse strict;\n\nuse IO::String;\nuse Bio::SeqIO;\nuse HTTP::Request::Common qw(GET);\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n$FLOAT = '[+-]?\\d*\\.\\d*';\n\nmy $URL = 'http://ihg.gsf.de/cgi-bin/paolo/mitofilter?';\n\n\nmy %STATUS =  map { $_ => 1 } qw(CREATED COMPLETED TERMINATED_BY_ERROR);\n\nmy $MIN_LEN = 60;               #min len for protein analysis\nmy $ANALYSIS_NAME = \"Mitoprot\";\n\nmy $ANALYSIS_SPEC =\n    {\n     'name'        => 'Mitoprot',\n     'type'        => 'Protein',\n     'version'     => '1.0a4',\n     'supplier'    => 'Munich Information Center for ProteinSequences',\n     'description' => 'mitochondrial sig seq prediction',\n    };\n\nmy $INPUT_SPEC =\n    [\n     {\n      'mandatory' => 'true',\n      'type'      => 'Bio::PrimarySeqI',\n      'name'      => 'seq',          #value must be name of method used to set value\n     },\n    ];\n\nmy $RESULT_SPEC =\n    {\n     '' => 'raw text results',  # same as undef\n     'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeature::Generic',\n     'all' => 'hash of results',\n    };\n\n\n\n### unique to this module ##\n\n=head2 result\n\n Usage   : $job->result (...)\n Returns : a result created by running an analysis\n Args    : various\n\nThe method returns a result of an executed job. If the job was\nterminated by an error the result may contain an error message instead\nof the real data.\n\nThis implementation returns differently processed data depending on\nargument:\n\n=over 3\n\n* undef\n\nReturns the raw ASCII data stream but without HTML tags\n\n* 'Bio::SeqFeatureI'\n\nThe argument string defines the type of bioperl objects returned in an\narray.  The objects are L<Bio::SeqFeature::Generic>.  Feature primary\ntag is \"SigSeq\".  Feature tags are input_length , basic_aas,\nacidic_aas, export_prob, charge, cleavage_site, method.\n\n* 'parsed'\n\nhash references of parsed results { input_length =E<gt>, basic_aas=E<gt>,\nacidic_aas=E<gt>, export_prob=E<gt>, charge=E<gt>, cleavage_site=E<gt>}.","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"range":{"start":{"character":0,"line":221},"end":{"line":279,"character":9999}},"line":221,"detail":"($self,$value)","definition":"sub","name":"result","containerName":"main::","children":[{"definition":"my","line":222,"name":"$self","localvar":"my","containerName":"result","kind":13},{"line":222,"name":"$value","containerName":"result","kind":13},{"definition":"my","containerName":"result","localvar":"my","kind":13,"name":"@sig_pdctns","line":225},{"definition":"my","containerName":"result","localvar":"my","kind":13,"name":"@fts","line":226},{"name":"$value","containerName":"result","kind":13,"line":228},{"definition":"my","line":229,"name":"$result","localvar":"my","containerName":"result","kind":13},{"name":"new","kind":12,"containerName":"result","line":229},{"line":229,"name":"$self","kind":13,"containerName":"result"},{"definition":"my","name":"%results","kind":13,"localvar":"my","containerName":"result","line":230},{"definition":"my","line":231,"name":"$line","localvar":"my","kind":13,"containerName":"result"},{"containerName":"result","kind":13,"name":"$result","line":231},{"containerName":"result","kind":13,"name":"$line","line":233},{"containerName":"result","kind":13,"name":"$line","line":233},{"line":234,"name":"$line","containerName":"result","kind":13},{"containerName":"result","kind":13,"name":"$results","line":237},{"name":"$line","containerName":"result","kind":13,"line":238},{"containerName":"result","kind":13,"name":"$results","line":239},{"containerName":"result","kind":13,"name":"$line","line":240},{"kind":13,"containerName":"result","name":"$results","line":241},{"line":242,"name":"$line","kind":13,"containerName":"result"},{"containerName":"result","kind":13,"name":"$results","line":243},{"line":244,"containerName":"result","kind":13,"name":"$line"},{"line":245,"name":"$results","kind":13,"containerName":"result"},{"line":246,"name":"$line","containerName":"result","kind":13},{"kind":13,"containerName":"result","name":"$results","line":247},{"kind":13,"containerName":"result","name":"$line","line":248},{"name":"$results","kind":13,"containerName":"result","line":249},{"kind":13,"containerName":"result","name":"$value","line":253},{"line":254,"name":"@fts","kind":13,"containerName":"result"},{"line":255,"name":"new","containerName":"result","kind":12},{"line":257,"kind":13,"containerName":"result","name":"$results"},{"line":258,"kind":13,"containerName":"result","name":"$results"},{"containerName":"result","kind":13,"name":"$self","line":258},{"line":258,"kind":12,"containerName":"result","name":"seq"},{"name":"length","kind":12,"containerName":"result","line":258},{"name":"$results","kind":13,"containerName":"result","line":262},{"kind":13,"containerName":"result","name":"$results","line":263},{"line":264,"name":"$results","kind":13,"containerName":"result"},{"name":"$results","kind":13,"containerName":"result","line":265},{"name":"$results","containerName":"result","kind":13,"line":268},{"line":271,"name":"@fts","kind":13,"containerName":"result"},{"line":275,"containerName":"result","kind":13,"name":"%results"},{"line":278,"containerName":"result","kind":13,"name":"$self"}]},{"line":229,"name":"IO","containerName":"String","kind":12},{"name":"Bio","kind":12,"containerName":"SeqFeature::Generic","line":254},{"kind":12,"name":"export_prob","line":262},{"name":"charge","kind":12,"line":263},{"line":264,"name":"basic_aas","kind":12},{"kind":12,"name":"acid_aas","line":265},{"line":266,"kind":12,"name":"region_name"},{"name":"method","kind":12,"line":267},{"line":268,"name":"cleavage_site","kind":12},{"line":281,"kind":12,"range":{"end":{"character":9999,"line":289},"start":{"character":0,"line":281}},"definition":"sub","children":[{"localvar":"my","kind":13,"containerName":"_init","name":"$self","line":282,"definition":"my"},{"line":283,"containerName":"_init","kind":13,"name":"$self"},{"kind":12,"containerName":"_init","name":"url","line":283},{"line":283,"containerName":"_init","kind":13,"name":"$URL"},{"name":"$self","kind":13,"containerName":"_init","line":284},{"name":"$ANALYSIS_SPEC","containerName":"_init","kind":13,"line":284},{"name":"$self","containerName":"_init","kind":13,"line":285},{"kind":13,"containerName":"_init","name":"$INPUT_SPEC","line":285},{"line":286,"containerName":"_init","kind":13,"name":"$self"},{"kind":13,"containerName":"_init","name":"$RESULT_SPEC","line":286},{"kind":13,"containerName":"_init","name":"$self","line":287},{"containerName":"_init","kind":13,"name":"$ANALYSIS_SPEC","line":287},{"kind":13,"containerName":"_init","name":"$self","line":288}],"name":"_init","containerName":"main::"},{"detail":"($self,$args)","definition":"sub","containerName":"main::","name":"_process_arguments","children":[{"line":294,"localvar":"my","containerName":"_process_arguments","kind":13,"name":"$self","definition":"my"},{"containerName":"_process_arguments","kind":13,"name":"$args","line":294},{"kind":13,"containerName":"_process_arguments","name":"$self","line":296},{"line":296,"containerName":"_process_arguments","kind":13,"name":"$args"},{"containerName":"_process_arguments","kind":13,"name":"$self","line":299},{"containerName":"_process_arguments","kind":12,"name":"throw","line":299},{"line":299,"name":"$self","containerName":"_process_arguments","kind":13},{"line":299,"containerName":"_process_arguments","kind":12,"name":"seq"},{"name":"subseq","containerName":"_process_arguments","kind":12,"line":299},{"containerName":"_process_arguments","kind":13,"name":"$self","line":300},{"line":300,"containerName":"_process_arguments","kind":12,"name":"throw"},{"line":300,"name":"$self","kind":13,"containerName":"_process_arguments"},{"line":300,"name":"seq","kind":12,"containerName":"_process_arguments"},{"containerName":"_process_arguments","kind":12,"name":"length","line":300}],"signature":{"label":"_process_arguments($self,$args)","documentation":"","parameters":[{"label":"$self"},{"label":"$args"}]},"kind":12,"range":{"start":{"line":291,"character":0},"end":{"line":302,"character":9999}},"line":291},{"name":"SUPER","containerName":"_process_arguments","kind":12,"line":296},{"containerName":"main::","name":"_run","children":[{"definition":"my","line":308,"name":"$self","localvar":"my","kind":13,"containerName":"_run"},{"name":"$self","containerName":"_run","kind":13,"line":309},{"line":309,"name":"delay","containerName":"_run","kind":12},{"name":"$self","containerName":"_run","kind":13,"line":310},{"line":310,"name":"sleep","containerName":"_run","kind":12},{"line":312,"name":"$self","containerName":"_run","kind":13},{"line":312,"name":"status","containerName":"_run","kind":12},{"name":"$url","localvar":"my","kind":13,"containerName":"_run","line":313,"definition":"my"},{"kind":13,"containerName":"_run","name":"$self","line":313},{"kind":12,"containerName":"_run","name":"url","line":313},{"line":313,"name":"$self","containerName":"_run","kind":13},{"kind":12,"containerName":"_run","name":"seq","line":313},{"name":"seq","kind":12,"containerName":"_run","line":313},{"definition":"my","name":"$request","localvar":"my","containerName":"_run","kind":13,"line":314},{"line":314,"containerName":"_run","kind":13,"name":"$url"},{"definition":"my","localvar":"my","kind":13,"containerName":"_run","name":"$content","line":315},{"name":"$self","kind":13,"containerName":"_run","line":315},{"containerName":"_run","kind":12,"name":"request","line":315},{"line":315,"name":"$request","containerName":"_run","kind":13},{"definition":"my","containerName":"_run","localvar":"my","kind":13,"name":"$text","line":316},{"line":316,"name":"$content","kind":13,"containerName":"_run"},{"line":316,"name":"content","containerName":"_run","kind":12},{"containerName":"_run","kind":13,"name":"$text","line":319},{"line":320,"name":"$text","kind":13,"containerName":"_run"},{"name":"$self","containerName":"_run","kind":13,"line":322},{"line":322,"kind":12,"containerName":"_run","name":"status"},{"containerName":"_run","kind":13,"name":"$text","line":322},{"containerName":"_run","kind":13,"name":"$self","line":322},{"line":322,"name":"seq","kind":12,"containerName":"_run"},{"line":322,"kind":12,"containerName":"_run","name":"length"},{"line":322,"name":"$MIN_LEN","containerName":"_run","kind":13},{"kind":13,"containerName":"_run","name":"$self","line":323},{"kind":13,"containerName":"_run","name":"$text","line":323}],"definition":"sub","kind":12,"range":{"start":{"character":0,"line":306},"end":{"line":325,"character":9999}},"line":306},{"line":314,"kind":12,"name":"GET"}],"version":5}