{"vars":[{"line":114,"containerName":"","kind":2,"name":"Dumpvalue"},{"name":"base","kind":2,"containerName":"","line":118},{"definition":"our","line":120,"containerName":"main::","kind":13,"name":"%DEFAULTS"},{"line":142,"kind":12,"range":{"start":{"line":142,"character":0},"end":{"line":165,"character":9999}},"signature":{"parameters":[{"label":"$class"},{"label":"%args"}],"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).","label":"new($class,%args)"},"children":[{"definition":"my","localvar":"my","kind":13,"containerName":"new","name":"$class","line":143},{"line":143,"name":"%args","containerName":"new","kind":13},{"kind":13,"localvar":"my","containerName":"new","name":"$self","line":144,"definition":"my"},{"line":144,"name":"$class","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"%args","line":144},{"line":146,"name":"$self","containerName":"new","kind":13},{"name":"$args","kind":13,"containerName":"new","line":146},{"name":"$self","containerName":"new","kind":13,"line":156},{"line":156,"containerName":"new","kind":12,"name":"splitpath"},{"line":156,"kind":13,"containerName":"new","name":"$self"},{"line":158,"kind":13,"containerName":"new","name":"$self"},{"line":158,"name":"_initialize_io","containerName":"new","kind":12},{"line":158,"name":"$self","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$self","line":159},{"line":159,"name":"new","kind":12,"containerName":"new"},{"name":"$self","kind":13,"containerName":"new","line":159},{"line":159,"containerName":"new","kind":12,"name":"verbose"},{"line":160,"kind":13,"containerName":"new","name":"$self"},{"name":"set_forward_designator","kind":12,"containerName":"new","line":160},{"line":160,"name":"$DEFAULTS","kind":13,"containerName":"new"},{"name":"$self","kind":13,"containerName":"new","line":161},{"containerName":"new","kind":12,"name":"set_reverse_designator","line":161},{"line":161,"name":"$DEFAULTS","containerName":"new","kind":13},{"line":163,"kind":13,"containerName":"new","name":"$self"},{"line":163,"kind":12,"containerName":"new","name":"_read_file"},{"kind":13,"containerName":"new","name":"$self","line":164}],"containerName":"main::","name":"new","definition":"sub","detail":"($class,%args)"},{"line":144,"kind":12,"containerName":"new","name":"SUPER"},{"name":"File","kind":12,"containerName":"Spec","line":156},{"line":159,"name":"Bio","kind":12,"containerName":"Tools::Alignment::Trim"},{"name":"set_verbose","containerName":"main::","children":[{"line":191,"kind":12,"containerName":"set_verbose","name":"verbose"}],"definition":"sub","range":{"end":{"line":191,"character":9999},"start":{"character":0,"line":191}},"kind":12,"line":191},{"range":{"start":{"character":0,"line":205},"end":{"line":208,"character":9999}},"kind":12,"line":205,"definition":"sub","containerName":"main::","name":"get_filename","children":[{"definition":"my","line":206,"containerName":"get_filename","localvar":"my","kind":13,"name":"$self"},{"line":207,"containerName":"get_filename","kind":13,"name":"$self"}]},{"range":{"end":{"character":9999,"line":252},"start":{"character":0,"line":232}},"kind":12,"line":232,"containerName":"main::","name":"count_sequences_with_grep","children":[{"definition":"my","line":233,"name":"$self","localvar":"my","containerName":"count_sequences_with_grep","kind":13},{"definition":"my","line":234,"containerName":"count_sequences_with_grep","localvar":"my","kind":13,"name":"$working_dir"},{"kind":13,"containerName":"count_sequences_with_grep","name":"$grep_cli","line":234},{"name":"@total_grep_sequences","kind":13,"containerName":"count_sequences_with_grep","line":234},{"line":239,"kind":13,"localvar":"my","containerName":"count_sequences_with_grep","name":"$FILE","definition":"my"},{"line":239,"kind":13,"containerName":"count_sequences_with_grep","name":"$self"},{"line":239,"name":"$self","containerName":"count_sequences_with_grep","kind":13},{"name":"warn","kind":12,"containerName":"count_sequences_with_grep","line":239},{"kind":13,"containerName":"count_sequences_with_grep","name":"$self","line":239},{"line":240,"name":"$counter","containerName":"count_sequences_with_grep","localvar":"my","kind":13,"definition":"my"},{"containerName":"count_sequences_with_grep","kind":13,"name":"$FILE","line":241},{"kind":13,"containerName":"count_sequences_with_grep","name":"$counter","line":241},{"kind":13,"containerName":"count_sequences_with_grep","name":"$FILE","line":243},{"definition":"my","localvar":"my","containerName":"count_sequences_with_grep","kind":13,"name":"$SINGLETS","line":244},{"kind":13,"containerName":"count_sequences_with_grep","name":"$self","line":244},{"definition":"my","line":245,"name":"$f","kind":13,"localvar":"my","containerName":"count_sequences_with_grep"},{"name":"$SINGLETS","containerName":"count_sequences_with_grep","kind":13,"line":245},{"kind":13,"containerName":"count_sequences_with_grep","name":"$f","line":246},{"localvar":"my","kind":13,"containerName":"count_sequences_with_grep","name":"$FILE","line":247,"definition":"my"},{"containerName":"count_sequences_with_grep","kind":12,"name":"catfile","line":247},{"line":247,"name":"$self","containerName":"count_sequences_with_grep","kind":13},{"line":247,"name":"$f","containerName":"count_sequences_with_grep","kind":13},{"line":247,"name":"$self","containerName":"count_sequences_with_grep","kind":13},{"name":"warn","containerName":"count_sequences_with_grep","kind":12,"line":247},{"line":247,"name":"catfile","containerName":"count_sequences_with_grep","kind":12},{"containerName":"count_sequences_with_grep","kind":13,"name":"$self","line":247},{"line":247,"containerName":"count_sequences_with_grep","kind":13,"name":"$f"},{"line":248,"name":"$FILE","containerName":"count_sequences_with_grep","kind":13},{"line":248,"name":"$counter","containerName":"count_sequences_with_grep","kind":13},{"kind":13,"containerName":"count_sequences_with_grep","name":"$FILE","line":249},{"name":"$counter","containerName":"count_sequences_with_grep","kind":13,"line":251}],"definition":"sub"},{"line":247,"containerName":"Spec","kind":12,"name":"File"},{"line":247,"name":"File","containerName":"Spec","kind":12},{"children":[{"name":"$self","containerName":"get_path","localvar":"my","kind":13,"line":265,"definition":"my"},{"line":266,"name":"$self","kind":13,"containerName":"get_path"}],"name":"get_path","containerName":"main::","definition":"sub","line":264,"kind":12,"range":{"end":{"character":9999,"line":267},"start":{"character":0,"line":264}}},{"range":{"start":{"line":284,"character":0},"end":{"character":9999,"line":286}},"kind":12,"line":284,"signature":{"parameters":[{"label":"$self"},{"label":"$contig"}],"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...","label":"get_contigs($self,$contig)"},"name":"get_contigs","containerName":"main::","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"get_contigs","name":"$self","line":285},{"line":285,"name":"$contig","kind":13,"containerName":"get_contigs"},{"definition":"my","line":286,"localvar":"my","containerName":"get_contigs","kind":13,"name":"@contigs"},{"name":"$self","containerName":"get_contigs","kind":13,"line":286}],"detail":"($self,$contig)","definition":"sub"},{"line":287,"containerName":null,"kind":13,"name":"@contigs"},{"detail":"($self,$contig)","definition":"sub","containerName":"main::","name":"get_class","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"get_class","line":302,"definition":"my"},{"line":302,"containerName":"get_class","kind":13,"name":"$contig"},{"name":"$self","containerName":"get_class","kind":13,"line":303},{"line":303,"kind":13,"containerName":"get_class","name":"$contig"}],"signature":{"parameters":[{"label":"$self"},{"label":"$contig"}],"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : ","label":"get_class($self,$contig)"},"kind":12,"range":{"start":{"line":301,"character":0},"end":{"character":9999,"line":304}},"line":301},{"line":303,"kind":12,"name":"contigs"},{"name":"class","kind":12,"line":303},{"range":{"end":{"character":9999,"line":329},"start":{"line":326,"character":0}},"kind":12,"line":326,"signature":{"label":"get_quality_array($self,$contig)","parameters":[{"label":"$self"},{"label":"$contig"}],"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>"},"containerName":"main::","name":"get_quality_array","children":[{"definition":"my","localvar":"my","containerName":"get_quality_array","kind":13,"name":"$self","line":327},{"line":327,"name":"$contig","kind":13,"containerName":"get_quality_array"},{"line":328,"name":"$self","containerName":"get_quality_array","kind":13},{"line":328,"containerName":"get_quality_array","kind":13,"name":"$contig"}],"detail":"($self,$contig)","definition":"sub"},{"name":"contigs","kind":12,"line":328},{"kind":12,"name":"quality","line":328},{"name":"get_quality_scalar","containerName":"main::","children":[{"line":352,"name":"$self","localvar":"my","containerName":"get_quality_scalar","kind":13,"definition":"my"},{"name":"$contig","containerName":"get_quality_scalar","kind":13,"line":352},{"line":353,"name":"$self","containerName":"get_quality_scalar","kind":13},{"containerName":"get_quality_scalar","kind":13,"name":"$contig","line":353}],"detail":"($self,$contig)","definition":"sub","range":{"start":{"line":351,"character":0},"end":{"line":354,"character":9999}},"kind":12,"line":351,"signature":{"label":"get_quality_scalar($self,$contig)","documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n'","parameters":[{"label":"$self"},{"label":"$contig"}]}},{"kind":12,"range":{"start":{"line":375,"character":0},"end":{"character":9999,"line":394}},"line":375,"definition":"sub","name":"freeze_hash","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"freeze_hash","kind":13,"line":376},{"name":"$self","containerName":"freeze_hash","kind":13,"line":377},{"kind":12,"containerName":"freeze_hash","name":"warn","line":377},{"line":380,"kind":13,"containerName":"freeze_hash","name":"$self"},{"name":"debug","containerName":"freeze_hash","kind":12,"line":380},{"definition":"my","line":382,"containerName":"freeze_hash","localvar":"my","kind":13,"name":"$filename"},{"line":382,"containerName":"freeze_hash","kind":13,"name":"$self"},{"definition":"my","line":383,"name":"%contigs","containerName":"freeze_hash","localvar":"my","kind":13},{"name":"$self","containerName":"freeze_hash","kind":13,"line":383},{"line":384,"containerName":"freeze_hash","localvar":"my","kind":13,"name":"$frozen","definition":"my"},{"name":"%contigs","kind":13,"containerName":"freeze_hash","line":384},{"line":386,"name":"$FREEZE","localvar":"my","kind":13,"containerName":"freeze_hash","definition":"my"},{"name":"$self","containerName":"freeze_hash","kind":13,"line":387},{"containerName":"freeze_hash","kind":12,"name":"warn","line":387},{"name":"$FREEZE","containerName":"freeze_hash","kind":13,"line":392},{"name":"$frozen","kind":13,"containerName":"freeze_hash","line":392}]},{"name":"freeze","kind":12,"line":384},{"children":[{"line":411,"name":"$self","kind":13,"localvar":"my","containerName":"get_members","definition":"my"},{"name":"$contig","kind":13,"containerName":"get_members","line":411},{"name":"$contig","kind":13,"containerName":"get_members","line":412},{"kind":13,"containerName":"get_members","name":"$self","line":413},{"name":"warn","containerName":"get_members","kind":12,"line":413},{"line":417,"containerName":"get_members","kind":13,"name":"$self"},{"line":417,"name":"$contig","containerName":"get_members","kind":13}],"containerName":"main::","name":"get_members","definition":"sub","detail":"($self,$contig)","line":410,"range":{"start":{"line":410,"character":0},"end":{"line":417,"character":9999}},"kind":12,"signature":{"label":"get_members($self,$contig)","parameters":[{"label":"$self"},{"label":"$contig"}],"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>"}},{"detail":"($self,$name)","definition":"sub","name":"get_members_by_name","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"get_members_by_name","kind":13,"name":"$self","line":437},{"line":437,"kind":13,"containerName":"get_members_by_name","name":"$name"},{"definition":"my","line":439,"name":"@contigs_with_that_name","localvar":"my","kind":13,"containerName":"get_members_by_name"},{"name":"$currkey","localvar":"my","kind":13,"containerName":"get_members_by_name","line":440,"definition":"my"},{"line":440,"kind":13,"containerName":"get_members_by_name","name":"$self"}],"signature":{"label":"get_members_by_name($self,$name)","documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>","parameters":[{"label":"$self"},{"label":"$name"}]},"range":{"end":{"character":9999,"line":440},"start":{"line":436,"character":0}},"kind":12,"line":436},{"name":"%self","kind":13,"containerName":null,"line":441},{"line":441,"name":"%currkey","containerName":null,"kind":13},{"name":"%self","kind":13,"containerName":null,"line":442},{"name":"%currkey","containerName":null,"kind":13,"line":442},{"kind":13,"containerName":null,"name":"@contigs_with_that_name","line":443},{"name":"$currkey","containerName":null,"kind":13,"line":443},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$count","line":446},{"line":446,"name":"@contigs_with_that_name","containerName":null,"kind":13},{"line":447,"name":"%count","containerName":null,"kind":13},{"line":448,"localvar":"my","kind":13,"containerName":null,"name":"$contig_num","definition":"my"},{"line":448,"kind":13,"containerName":null,"name":"@contigs_with_that_name"},{"line":449,"name":"%self","containerName":null,"kind":13},{"line":449,"name":"%contig_num","containerName":null,"kind":13},{"kind":12,"range":{"end":{"line":470,"character":9999},"start":{"character":0,"line":468}},"line":468,"signature":{"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>","parameters":[{"label":"$self"},{"label":"$name"}],"label":"get_contig_number_by_name($self,$name)"},"containerName":"main::","name":"get_contig_number_by_name","children":[{"line":469,"name":"$self","localvar":"my","containerName":"get_contig_number_by_name","kind":13,"definition":"my"},{"line":469,"name":"$name","containerName":"get_contig_number_by_name","kind":13},{"line":470,"name":"$currkey","localvar":"my","containerName":"get_contig_number_by_name","kind":13,"definition":"my"},{"name":"$self","containerName":"get_contig_number_by_name","kind":13,"line":470}],"detail":"($self,$name)","definition":"sub"},{"line":471,"containerName":null,"kind":13,"name":"%self"},{"name":"%currkey","kind":13,"containerName":null,"line":471},{"line":472,"containerName":null,"kind":13,"name":"%self"},{"line":472,"name":"%currkey","kind":13,"containerName":null},{"name":"$currkey","containerName":null,"kind":13,"line":473},{"name":"get_sequence","containerName":"main::","children":[{"name":"$self","containerName":"get_sequence","localvar":"my","kind":13,"line":492,"definition":"my"},{"containerName":"get_sequence","kind":13,"name":"$contig","line":492},{"containerName":"get_sequence","kind":13,"name":"$self","line":493},{"line":493,"name":"$contig","kind":13,"containerName":"get_sequence"}],"detail":"($self,$contig)","definition":"sub","kind":12,"range":{"end":{"line":494,"character":9999},"start":{"character":0,"line":491}},"line":491,"signature":{"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>","parameters":[{"label":"$self"},{"label":"$contig"}],"label":"get_sequence($self,$contig)"}},{"detail":"($self,$name,$sequence)","definition":"sub","containerName":"main::","name":"set_final_sequence","children":[{"localvar":"my","containerName":"set_final_sequence","kind":13,"name":"$self","line":511,"definition":"my"},{"line":511,"kind":13,"containerName":"set_final_sequence","name":"$name"},{"kind":13,"containerName":"set_final_sequence","name":"$sequence","line":511},{"line":512,"kind":13,"containerName":"set_final_sequence","name":"$self"},{"line":512,"kind":13,"containerName":"set_final_sequence","name":"$name"},{"line":513,"name":"$self","containerName":"set_final_sequence","kind":13},{"kind":12,"containerName":"set_final_sequence","name":"warn","line":513},{"containerName":"set_final_sequence","kind":13,"name":"$self","line":518},{"name":"$name","kind":13,"containerName":"set_final_sequence","line":518},{"name":"$sequence","containerName":"set_final_sequence","kind":13,"line":518}],"signature":{"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.","parameters":[{"label":"$self"},{"label":"$name"},{"label":"$sequence"}],"label":"set_final_sequence($self,$name,$sequence)"},"range":{"start":{"line":510,"character":0},"end":{"line":521,"character":9999}},"kind":12,"line":510},{"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_read_file","name":"$self","line":538},{"line":539,"name":"$line","localvar":"my","containerName":"_read_file","kind":13,"definition":"my"},{"name":"$in_contig","kind":13,"containerName":"_read_file","line":539},{"kind":13,"containerName":"_read_file","name":"$in_quality","line":539},{"name":"$contig_number","kind":13,"containerName":"_read_file","line":539},{"containerName":"_read_file","kind":13,"name":"$top","line":539},{"line":541,"kind":13,"containerName":"_read_file","name":"$line"},{"line":541,"name":"$self","kind":13,"containerName":"_read_file"},{"containerName":"_read_file","kind":12,"name":"_readline","line":541},{"name":"$line","kind":13,"containerName":"_read_file","line":542},{"name":"$line","containerName":"_read_file","kind":13,"line":545},{"name":"$in_contig","kind":13,"containerName":"_read_file","line":548},{"name":"$in_quality","containerName":"_read_file","kind":13,"line":549},{"line":552,"name":"$in_contig","kind":13,"containerName":"_read_file"},{"name":"$in_contig","containerName":"_read_file","kind":13,"line":553},{"name":"$self","containerName":"_read_file","kind":13,"line":554},{"line":554,"containerName":"_read_file","kind":12,"name":"debug"},{"line":555,"kind":13,"containerName":"_read_file","name":"$self"},{"name":"$contig_number","containerName":"_read_file","kind":13,"line":555},{"name":"$line","containerName":"_read_file","kind":13,"line":555},{"line":558,"kind":13,"containerName":"_read_file","name":"$in_quality"},{"name":"$line","containerName":"_read_file","kind":13,"line":559},{"line":560,"containerName":"_read_file","kind":13,"name":"$in_quality"},{"line":571,"containerName":"_read_file","kind":13,"name":"$self"},{"name":"$contig_number","kind":13,"containerName":"_read_file","line":571},{"containerName":"_read_file","kind":13,"name":"$self","line":572},{"line":572,"name":"$contig_number","containerName":"_read_file","kind":13},{"line":573,"name":"$self","kind":13,"containerName":"_read_file"},{"containerName":"_read_file","kind":13,"name":"$contig_number","line":573},{"line":575,"name":"$self","kind":13,"containerName":"_read_file"},{"line":575,"containerName":"_read_file","kind":13,"name":"$contig_number"},{"line":575,"name":"$line","kind":13,"containerName":"_read_file"},{"line":578,"containerName":"_read_file","kind":13,"name":"$line"},{"line":579,"kind":13,"containerName":"_read_file","name":"$in_quality"},{"name":"$line","kind":13,"containerName":"_read_file","line":592},{"line":593,"containerName":"_read_file","kind":13,"name":"$line"},{"line":594,"name":"$contig_number","containerName":"_read_file","kind":13},{"line":596,"kind":13,"containerName":"_read_file","name":"$self"},{"kind":12,"containerName":"_read_file","name":"debug","line":596},{"line":598,"name":"$self","containerName":"_read_file","kind":13},{"line":598,"name":"$contig_number","kind":13,"containerName":"_read_file"},{"name":"$self","kind":13,"containerName":"_read_file","line":599},{"line":599,"name":"$contig_number","containerName":"_read_file","kind":13},{"containerName":"_read_file","kind":13,"name":"$in_contig","line":600},{"name":"$line","kind":13,"containerName":"_read_file","line":607},{"line":608,"name":"$line","kind":13,"containerName":"_read_file"},{"kind":13,"localvar":"my","containerName":"_read_file","name":"$member","line":609,"definition":"my"},{"line":610,"name":"$self","containerName":"_read_file","kind":13},{"line":610,"name":"$contig_number","containerName":"_read_file","kind":13},{"name":"$member","kind":13,"containerName":"_read_file","line":610},{"name":"$line","containerName":"_read_file","kind":13,"line":613},{"line":614,"kind":13,"containerName":"_read_file","name":"$self"},{"name":"debug","kind":12,"containerName":"_read_file","line":614},{"kind":13,"containerName":"_read_file","name":"$line","line":615},{"line":618,"name":"$self","containerName":"_read_file","kind":13},{"line":618,"name":"$contig_number","kind":13,"containerName":"_read_file"},{"name":"$top","containerName":"_read_file","kind":13,"line":621},{"line":622,"name":"$self","containerName":"_read_file","kind":13},{"name":"debug","containerName":"_read_file","kind":12,"line":622},{"line":623,"name":"$self","containerName":"_read_file","kind":13},{"name":"$contig_number","containerName":"_read_file","kind":13,"line":623},{"line":624,"containerName":"_read_file","kind":13,"name":"$self"},{"line":624,"kind":12,"containerName":"_read_file","name":"debug"},{"containerName":"_read_file","kind":13,"name":"$self","line":628},{"name":"$contig_number","containerName":"_read_file","kind":13,"line":628},{"line":629,"name":"$self","kind":13,"containerName":"_read_file"},{"line":629,"name":"$contig_number","kind":13,"containerName":"_read_file"},{"line":630,"name":"$self","kind":13,"containerName":"_read_file"},{"line":630,"containerName":"_read_file","kind":13,"name":"$contig_number"},{"name":"$self","kind":13,"containerName":"_read_file","line":633},{"line":633,"kind":12,"containerName":"_read_file","name":"debug"},{"containerName":"_read_file","kind":13,"name":"$self","line":637},{"kind":13,"containerName":"_read_file","name":"$contig_number","line":637},{"line":638,"name":"$self","containerName":"_read_file","kind":13},{"kind":13,"containerName":"_read_file","name":"$contig_number","line":638},{"line":639,"name":"$self","containerName":"_read_file","kind":13},{"line":639,"kind":13,"containerName":"_read_file","name":"$contig_number"},{"line":641,"containerName":"_read_file","kind":13,"name":"$top"},{"name":"$self","containerName":"_read_file","kind":13,"line":648},{"line":648,"name":"$contig_number","containerName":"_read_file","kind":13},{"line":649,"name":"$self","kind":13,"containerName":"_read_file"},{"line":649,"containerName":"_read_file","kind":12,"name":"debug"},{"line":650,"name":"$self","containerName":"_read_file","kind":13},{"kind":13,"containerName":"_read_file","name":"$contig_number","line":650},{"containerName":"_read_file","kind":13,"name":"$self","line":651},{"line":651,"name":"$contig_number","containerName":"_read_file","kind":13},{"line":652,"containerName":"_read_file","kind":13,"name":"$self"},{"line":652,"kind":13,"containerName":"_read_file","name":"$contig_number"},{"line":655,"containerName":"_read_file","kind":13,"name":"$self"},{"line":655,"name":"debug","containerName":"_read_file","kind":12},{"name":"$self","kind":13,"containerName":"_read_file","line":656},{"name":"$contig_number","containerName":"_read_file","kind":13,"line":656},{"line":657,"name":"$self","kind":13,"containerName":"_read_file"},{"containerName":"_read_file","kind":13,"name":"$contig_number","line":657},{"name":"$self","kind":13,"containerName":"_read_file","line":658},{"line":658,"containerName":"_read_file","kind":13,"name":"$contig_number"},{"kind":13,"containerName":"_read_file","name":"$top","line":660}],"name":"_read_file","containerName":"main::","definition":"sub","detail":"($self)","line":537,"kind":12,"range":{"start":{"character":0,"line":537},"end":{"line":663,"character":9999}},"signature":{"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}","parameters":[{"label":"$self"}],"label":"_read_file($self)"}},{"signature":{"parameters":[{"label":"$self"},{"label":"$reverse_designator"}],"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>","label":"set_reverse_designator($self,$reverse_designator)"},"range":{"start":{"character":0,"line":682},"end":{"character":9999,"line":687}},"kind":12,"line":682,"detail":"($self,$reverse_designator)","definition":"sub","name":"set_reverse_designator","containerName":"main::","children":[{"name":"$self","containerName":"set_reverse_designator","localvar":"my","kind":13,"line":683,"definition":"my"},{"line":683,"name":"$reverse_designator","kind":13,"containerName":"set_reverse_designator"},{"name":"$self","containerName":"set_reverse_designator","kind":13,"line":684},{"line":684,"kind":13,"containerName":"set_reverse_designator","name":"$reverse_designator"},{"line":685,"kind":13,"containerName":"set_reverse_designator","name":"$self"},{"line":685,"name":"set_reverse_designator","kind":12,"containerName":"set_reverse_designator"},{"line":685,"name":"$reverse_designator","kind":13,"containerName":"set_reverse_designator"},{"line":686,"name":"$self","containerName":"set_reverse_designator","kind":13}]},{"signature":{"label":"set_forward_designator($self,$forward_designator)","parameters":[{"label":"$self"},{"label":"$forward_designator"}],"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_reverse_designator {\n    my ($self,$reverse_designator) = @_;\n    $self->{'reverse_designator'} = $reverse_designator;\n    $self->{'o_trim'}->set_reverse_designator($reverse_designator);\n    return $self->{'reverse_designator'};\n}\t\t\t\t# end set_reverse_designator\n\n=head2 set_forward_designator($some_string)\n\n Title   : set_forward_designator($some_string)\n Usage   : $o_consed->set_forward_designator($some_string);\n Function: Set the designator for the forward read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{forward_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>"},"line":704,"range":{"end":{"character":9999,"line":709},"start":{"character":0,"line":704}},"kind":12,"definition":"sub","detail":"($self,$forward_designator)","children":[{"definition":"my","name":"$self","containerName":"set_forward_designator","localvar":"my","kind":13,"line":705},{"line":705,"kind":13,"containerName":"set_forward_designator","name":"$forward_designator"},{"containerName":"set_forward_designator","kind":13,"name":"$self","line":706},{"line":706,"containerName":"set_forward_designator","kind":13,"name":"$forward_designator"},{"containerName":"set_forward_designator","kind":13,"name":"$self","line":707},{"line":707,"name":"set_forward_designator","containerName":"set_forward_designator","kind":12},{"line":707,"name":"$forward_designator","containerName":"set_forward_designator","kind":13},{"name":"$self","kind":13,"containerName":"set_forward_designator","line":708}],"containerName":"main::","name":"set_forward_designator"},{"detail":"($self,$ignore_case)","definition":"sub","containerName":"main::","name":"set_designator_ignore_case","children":[{"definition":"my","line":724,"kind":13,"localvar":"my","containerName":"set_designator_ignore_case","name":"$self"},{"kind":13,"containerName":"set_designator_ignore_case","name":"$ignore_case","line":724},{"line":725,"name":"$ignore_case","containerName":"set_designator_ignore_case","kind":13},{"line":726,"kind":13,"containerName":"set_designator_ignore_case","name":"$self"},{"line":728,"name":"$self","containerName":"set_designator_ignore_case","kind":13}],"signature":{"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_reverse_designator {\n    my ($self,$reverse_designator) = @_;\n    $self->{'reverse_designator'} = $reverse_designator;\n    $self->{'o_trim'}->set_reverse_designator($reverse_designator);\n    return $self->{'reverse_designator'};\n}\t\t\t\t# end set_reverse_designator\n\n=head2 set_forward_designator($some_string)\n\n Title   : set_forward_designator($some_string)\n Usage   : $o_consed->set_forward_designator($some_string);\n Function: Set the designator for the forward read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{forward_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_forward_designator {\n    my ($self,$forward_designator) = @_;\n    $self->{'forward_designator'} = $forward_designator;\n    $self->{'o_trim'}->set_forward_designator($forward_designator);\n    return $self->{'forward_designator'};\n}\t\t\t\t# end set_forward_designator\n\n=head2 set_designator_ignore_case(\"yes\")\n\n Title   : set_designator_ignore_case(\"yes\")\n Usage   : $o_consed->set_designator_ignore_case(\"yes\");\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n\nDeprecated. Really. Trust me.","parameters":[{"label":"$self"},{"label":"$ignore_case"}],"label":"set_designator_ignore_case($self,$ignore_case)"},"range":{"end":{"line":729,"character":9999},"start":{"character":0,"line":723}},"kind":12,"line":723},{"definition":"sub","detail":"($self)","children":[{"name":"$self","containerName":"set_trim_points_singlets_and_singletons","localvar":"my","kind":13,"line":754,"definition":"my"},{"line":755,"kind":13,"containerName":"set_trim_points_singlets_and_singletons","name":"$self"},{"line":755,"name":"debug","kind":12,"containerName":"set_trim_points_singlets_and_singletons"},{"name":"@points","localvar":"my","kind":13,"containerName":"set_trim_points_singlets_and_singletons","line":756,"definition":"my"},{"line":756,"name":"$trimmed_sequence","kind":13,"containerName":"set_trim_points_singlets_and_singletons"},{"line":757,"name":"$self","kind":13,"containerName":"set_trim_points_singlets_and_singletons"},{"name":"$self","kind":13,"containerName":"set_trim_points_singlets_and_singletons","line":758},{"line":758,"name":"debug","kind":12,"containerName":"set_trim_points_singlets_and_singletons"},{"name":"$self","containerName":"set_trim_points_singlets_and_singletons","kind":13,"line":760},{"name":"set_doublets","kind":12,"containerName":"set_trim_points_singlets_and_singletons","line":760},{"line":762,"containerName":"set_trim_points_singlets_and_singletons","kind":13,"name":"$self"}],"containerName":"main::","name":"set_trim_points_singlets_and_singletons","signature":{"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_reverse_designator {\n    my ($self,$reverse_designator) = @_;\n    $self->{'reverse_designator'} = $reverse_designator;\n    $self->{'o_trim'}->set_reverse_designator($reverse_designator);\n    return $self->{'reverse_designator'};\n}\t\t\t\t# end set_reverse_designator\n\n=head2 set_forward_designator($some_string)\n\n Title   : set_forward_designator($some_string)\n Usage   : $o_consed->set_forward_designator($some_string);\n Function: Set the designator for the forward read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{forward_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_forward_designator {\n    my ($self,$forward_designator) = @_;\n    $self->{'forward_designator'} = $forward_designator;\n    $self->{'o_trim'}->set_forward_designator($forward_designator);\n    return $self->{'forward_designator'};\n}\t\t\t\t# end set_forward_designator\n\n=head2 set_designator_ignore_case(\"yes\")\n\n Title   : set_designator_ignore_case(\"yes\")\n Usage   : $o_consed->set_designator_ignore_case(\"yes\");\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n\nDeprecated. Really. Trust me.\n\n\nsub set_designator_ignore_case {\n    my ($self,$ignore_case) = @_;\n    if ($ignore_case eq \"yes\") {\n\t$self->{'designator_ignore_case'} = 1;\n    }\n    return $self->{'designator_ignore_case'};\n}\t\t\t\t# end set_designator_ignore_case\n\n=head2 set_trim_points_singlets_and_singletons()\n\n Title   : set_trim_points_singlets_and_singletons()\n Usage   : $o_consed->set_trim_points_singlets_and_singletons();\n Function: Set the trim points for singlets and singletons based on\n\t   quality.  Uses the Bio::Tools::Alignment::Trim object. Use\n\t   at your own risk because the Bio::Tools::Alignment::Trim\n\t   object was designed specifically for me and is mysterious\n\t   in its ways. Every time somebody other then me uses it a\n\t   swarm of locusts decends on a small Central American\n\t   village so do not say you weren't warned.\n Returns : Nothing.\n Args    : None.\n\nWorking on exceptions and warnings here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n' to make my emacs happy","parameters":[{"label":"$self"}],"label":"set_trim_points_singlets_and_singletons($self)"},"line":753,"kind":12,"range":{"end":{"line":762,"character":9999},"start":{"line":753,"character":0}}},{"line":763,"name":"%self","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$self","line":764},{"kind":12,"containerName":"main::","name":"debug","line":764},{"localvar":"my","containerName":null,"kind":13,"name":"$sequence","line":770,"definition":"my"},{"containerName":null,"kind":13,"name":"$quality","line":770},{"kind":13,"containerName":null,"name":"$name","line":770},{"name":"$class","containerName":null,"kind":13,"line":770},{"line":771,"name":"$sequence","containerName":null,"kind":13},{"line":771,"containerName":null,"kind":13,"name":"%self"},{"line":772,"kind":13,"containerName":null,"name":"%self"},{"name":"%quality","kind":13,"containerName":null,"line":772},{"line":773,"kind":13,"containerName":null,"name":"$quality"},{"line":773,"containerName":null,"kind":13,"name":"%self"},{"line":774,"containerName":null,"kind":13,"name":"$name"},{"line":774,"name":"%self","containerName":null,"kind":13},{"line":775,"containerName":null,"kind":13,"name":"$class"},{"line":775,"containerName":null,"kind":13,"name":"%self"},{"line":776,"containerName":null,"kind":13,"name":"@points"},{"name":"%self","kind":13,"containerName":null,"line":776},{"line":776,"containerName":"main::","kind":12,"name":"trim_singlet"},{"line":776,"containerName":null,"kind":13,"name":"$sequence"},{"line":776,"kind":13,"containerName":null,"name":"$quality"},{"line":776,"kind":13,"containerName":null,"name":"$name"},{"line":776,"name":"$class","containerName":null,"kind":13},{"line":777,"name":"%self","kind":13,"containerName":null},{"line":777,"name":"@points","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%self","line":778},{"line":778,"kind":13,"containerName":null,"name":"@points"},{"name":"%self","containerName":null,"kind":13,"line":779},{"name":"%self","kind":13,"containerName":null,"line":780},{"line":780,"name":"contigs","kind":12},{"line":780,"name":"@points","kind":13,"containerName":null},{"line":780,"name":"@points","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"@points","line":780},{"line":783,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"containerName":"main::","name":"debug","line":783},{"definition":"sub","name":"set_trim_points_doublets","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"set_trim_points_doublets","localvar":"my","kind":13,"line":807},{"localvar":"my","containerName":"set_trim_points_doublets","kind":13,"name":"@points","line":808,"definition":"my"},{"line":809,"containerName":"set_trim_points_doublets","kind":13,"name":"$self"},{"line":809,"name":"debug","containerName":"set_trim_points_doublets","kind":12},{"line":812,"name":"$self","containerName":"set_trim_points_doublets","kind":13},{"name":"debug","kind":12,"containerName":"set_trim_points_doublets","line":812},{"kind":13,"containerName":"set_trim_points_doublets","name":"$self","line":814}],"kind":12,"range":{"start":{"line":806,"character":0},"end":{"character":9999,"line":814}},"line":806},{"line":815,"name":"%self","kind":13,"containerName":null},{"name":"@quals","containerName":null,"localvar":"my","kind":13,"line":817,"definition":"my"},{"kind":13,"containerName":null,"name":"%self","line":817},{"line":819,"kind":13,"containerName":null,"name":"@points"},{"line":819,"kind":13,"containerName":null,"name":"%self"},{"line":819,"name":"o_trim","kind":12},{"line":820,"name":"trim_doublet","containerName":"main::","kind":12},{"kind":13,"containerName":null,"name":"%self","line":820},{"line":821,"name":"%self","kind":13,"containerName":null},{"name":"%self","kind":13,"containerName":null,"line":822},{"line":822,"name":"name","kind":12},{"name":"%self","kind":13,"containerName":null,"line":823},{"line":824,"name":"%self","containerName":null,"kind":13},{"line":824,"kind":13,"containerName":null,"name":"@points"},{"line":825,"name":"%self","containerName":null,"kind":13},{"name":"@points","containerName":null,"kind":13,"line":825},{"kind":13,"containerName":null,"name":"%self","line":827},{"name":"%self","kind":13,"containerName":null,"line":828},{"line":828,"kind":12,"name":"contigs"},{"line":829,"containerName":null,"kind":13,"name":"@points"},{"line":829,"containerName":null,"kind":13,"name":"@points"},{"containerName":null,"kind":13,"name":"@points","line":829},{"kind":13,"containerName":null,"name":"$self","line":833},{"line":833,"containerName":"main::","kind":12,"name":"debug"},{"definition":"sub","detail":"($self,$name)","children":[{"definition":"my","line":850,"kind":13,"localvar":"my","containerName":"get_trimmed_sequence_by_name","name":"$self"},{"line":850,"kind":13,"containerName":"get_trimmed_sequence_by_name","name":"$name"},{"containerName":"get_trimmed_sequence_by_name","localvar":"my","kind":13,"name":"$trimmed_sequence","line":851,"definition":"my"},{"line":852,"kind":13,"localvar":"my","containerName":"get_trimmed_sequence_by_name","name":"$contigname","definition":"my"},{"line":852,"containerName":"get_trimmed_sequence_by_name","kind":13,"name":"$self"},{"line":852,"name":"$name","containerName":"get_trimmed_sequence_by_name","kind":13},{"definition":"my","line":853,"containerName":"get_trimmed_sequence_by_name","localvar":"my","kind":13,"name":"$class"},{"line":853,"containerName":"get_trimmed_sequence_by_name","kind":13,"name":"$self"},{"line":853,"containerName":"get_trimmed_sequence_by_name","kind":13,"name":"$contigname"},{"line":861,"containerName":"get_trimmed_sequence_by_name","kind":13,"name":"$self"},{"line":861,"name":"$contigname","kind":13,"containerName":"get_trimmed_sequence_by_name"}],"name":"get_trimmed_sequence_by_name","containerName":"main::","signature":{"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_reverse_designator {\n    my ($self,$reverse_designator) = @_;\n    $self->{'reverse_designator'} = $reverse_designator;\n    $self->{'o_trim'}->set_reverse_designator($reverse_designator);\n    return $self->{'reverse_designator'};\n}\t\t\t\t# end set_reverse_designator\n\n=head2 set_forward_designator($some_string)\n\n Title   : set_forward_designator($some_string)\n Usage   : $o_consed->set_forward_designator($some_string);\n Function: Set the designator for the forward read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{forward_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_forward_designator {\n    my ($self,$forward_designator) = @_;\n    $self->{'forward_designator'} = $forward_designator;\n    $self->{'o_trim'}->set_forward_designator($forward_designator);\n    return $self->{'forward_designator'};\n}\t\t\t\t# end set_forward_designator\n\n=head2 set_designator_ignore_case(\"yes\")\n\n Title   : set_designator_ignore_case(\"yes\")\n Usage   : $o_consed->set_designator_ignore_case(\"yes\");\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n\nDeprecated. Really. Trust me.\n\n\nsub set_designator_ignore_case {\n    my ($self,$ignore_case) = @_;\n    if ($ignore_case eq \"yes\") {\n\t$self->{'designator_ignore_case'} = 1;\n    }\n    return $self->{'designator_ignore_case'};\n}\t\t\t\t# end set_designator_ignore_case\n\n=head2 set_trim_points_singlets_and_singletons()\n\n Title   : set_trim_points_singlets_and_singletons()\n Usage   : $o_consed->set_trim_points_singlets_and_singletons();\n Function: Set the trim points for singlets and singletons based on\n\t   quality.  Uses the Bio::Tools::Alignment::Trim object. Use\n\t   at your own risk because the Bio::Tools::Alignment::Trim\n\t   object was designed specifically for me and is mysterious\n\t   in its ways. Every time somebody other then me uses it a\n\t   swarm of locusts decends on a small Central American\n\t   village so do not say you weren't warned.\n Returns : Nothing.\n Args    : None.\n\nWorking on exceptions and warnings here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\n#' to make my emacs happy\n\nsub set_trim_points_singlets_and_singletons {\n    my ($self) = @_;\n    $self->debug(\"Consed.pm : \\$self is $self\\n\");\n    my (@points,$trimmed_sequence);\n    if (!$self->{'doublets_set'}) {\n        $self->debug(\"You need to set the doublets before you use \".\n                     \"set_trim_points_singlets_and_doublets. Doing that now.\");\n\t$self->set_doublets();\n    }\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"singlet\") {\n\t    $self->debug(\"Singlet $_\\n\");\n\t    # this is what Warehouse wants\n\t    #         my ($self,$sequence,$quality,$name) = @_;\n\t    # this is what Bio::Tools::Alignment::Trim::trim_singlet wants:\n\t    # my ($self,$sequence,$quality,$name,$class) = @_;\n\t    # the following several lines are to make the parameter passing legible.\n\t    my ($sequence,$quality,$name,$class);\n\t    $sequence = $self->{'contigs'}->{$_}->{'consensus'};\n\t    if (!$self->{'contigs'}->{$_}->{'quality'}) { $quality = \"unset\"; }\n\t    else { $quality = $self->{'contigs'}->{$_}->{'quality'}; }\n\t    $name = $self->{'contigs'}->{$_}->{'name'};\n\t    $class = $self->{'contigs'}->{$_}->{'class'};\n\t    @points = @{$self->{'o_trim'}->trim_singlet($sequence,$quality,$name,$class)};\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} = \n                substr($self->{contigs}->{$_}->{'consensus'},$points[0],$points[1]-$points[0]);\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_singlets\".\n                 \"_and_singletons: Done setting the quality trimpoints.\\n\");\n    return;\n}  # end set_trim_points_singlet\n\n=head2 set_trim_points_doublets()\n\n Title   : set_trim_points_doublets()\n Usage   : $o_consed->set_trim_points_doublets();\n Function: Set the trim points for doublets based on quality. Uses the\n\t   Bio::Tools::Alignment::Trim object. Use at your own risk because\n           the Bio::Tools::Alignment::Trim object was designed specifically\n           for me and is mysterious in its ways. Every time somebody other\n           then me uses it you risk a biblical plague being loosed on your\n           city.\n Returns : Nothing.\n Args    : None.\n Notes   : Working on exceptions here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\nsub set_trim_points_doublets {\n    my $self = shift;\n    my @points;\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Restoring zeros for doublets.\\n\");\n    # &show_missing_sequence($self);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Setting doublet trim points.\\n\");\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            # my ($self,$sequence,$quality,$name,$class) = @_;\n            my @quals = split(' ',$self->{'contigs'}->{$_}->{'quality'});\n\n\t    @points = $self->{o_trim}->trim_doublet\n                ($self->{'contigs'}->{$_}->{'consensus'},\n                 $self->{'contigs'}->{$_}->{'quality'},\n                 $self->{'contigs'}->{$_}->{name},\n                 $self->{'contigs'}->{$_}->{'class'});\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n            # now set this\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} =\n                substr($self->{contigs}->{$_}->{'consensus'},\n                       $points[0],$points[1]-$points[0]);\n\t    # 010102 the deprecated way to do things:\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Done setting doublet trim points.\\n\"); \n    return;\n} # end set_trim_points_doublets\n\n=head2 get_trimmed_sequence_by_name($name)\n\n Title   : get_trimmed_sequence_by_name($name)\n Usage   : $o_consed->get_trimmed_sequence_by_name($name);\n Function: Returns the trimmed_sequence of a contig with {name} eq $name.\n Returns : A scalar- the trimmed sequence.\n Args    : The {name} of a contig.\n Notes   : ","parameters":[{"label":"$self"},{"label":"$name"}],"label":"get_trimmed_sequence_by_name($self,$name)"},"line":849,"kind":12,"range":{"end":{"character":9999,"line":862},"start":{"line":849,"character":0}}},{"kind":12,"range":{"end":{"line":884,"character":9999},"start":{"line":875,"character":0}},"line":875,"signature":{"parameters":[{"label":"$self"},{"label":"$dash_present"}],"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_reverse_designator {\n    my ($self,$reverse_designator) = @_;\n    $self->{'reverse_designator'} = $reverse_designator;\n    $self->{'o_trim'}->set_reverse_designator($reverse_designator);\n    return $self->{'reverse_designator'};\n}\t\t\t\t# end set_reverse_designator\n\n=head2 set_forward_designator($some_string)\n\n Title   : set_forward_designator($some_string)\n Usage   : $o_consed->set_forward_designator($some_string);\n Function: Set the designator for the forward read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{forward_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_forward_designator {\n    my ($self,$forward_designator) = @_;\n    $self->{'forward_designator'} = $forward_designator;\n    $self->{'o_trim'}->set_forward_designator($forward_designator);\n    return $self->{'forward_designator'};\n}\t\t\t\t# end set_forward_designator\n\n=head2 set_designator_ignore_case(\"yes\")\n\n Title   : set_designator_ignore_case(\"yes\")\n Usage   : $o_consed->set_designator_ignore_case(\"yes\");\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n\nDeprecated. Really. Trust me.\n\n\nsub set_designator_ignore_case {\n    my ($self,$ignore_case) = @_;\n    if ($ignore_case eq \"yes\") {\n\t$self->{'designator_ignore_case'} = 1;\n    }\n    return $self->{'designator_ignore_case'};\n}\t\t\t\t# end set_designator_ignore_case\n\n=head2 set_trim_points_singlets_and_singletons()\n\n Title   : set_trim_points_singlets_and_singletons()\n Usage   : $o_consed->set_trim_points_singlets_and_singletons();\n Function: Set the trim points for singlets and singletons based on\n\t   quality.  Uses the Bio::Tools::Alignment::Trim object. Use\n\t   at your own risk because the Bio::Tools::Alignment::Trim\n\t   object was designed specifically for me and is mysterious\n\t   in its ways. Every time somebody other then me uses it a\n\t   swarm of locusts decends on a small Central American\n\t   village so do not say you weren't warned.\n Returns : Nothing.\n Args    : None.\n\nWorking on exceptions and warnings here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\n#' to make my emacs happy\n\nsub set_trim_points_singlets_and_singletons {\n    my ($self) = @_;\n    $self->debug(\"Consed.pm : \\$self is $self\\n\");\n    my (@points,$trimmed_sequence);\n    if (!$self->{'doublets_set'}) {\n        $self->debug(\"You need to set the doublets before you use \".\n                     \"set_trim_points_singlets_and_doublets. Doing that now.\");\n\t$self->set_doublets();\n    }\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"singlet\") {\n\t    $self->debug(\"Singlet $_\\n\");\n\t    # this is what Warehouse wants\n\t    #         my ($self,$sequence,$quality,$name) = @_;\n\t    # this is what Bio::Tools::Alignment::Trim::trim_singlet wants:\n\t    # my ($self,$sequence,$quality,$name,$class) = @_;\n\t    # the following several lines are to make the parameter passing legible.\n\t    my ($sequence,$quality,$name,$class);\n\t    $sequence = $self->{'contigs'}->{$_}->{'consensus'};\n\t    if (!$self->{'contigs'}->{$_}->{'quality'}) { $quality = \"unset\"; }\n\t    else { $quality = $self->{'contigs'}->{$_}->{'quality'}; }\n\t    $name = $self->{'contigs'}->{$_}->{'name'};\n\t    $class = $self->{'contigs'}->{$_}->{'class'};\n\t    @points = @{$self->{'o_trim'}->trim_singlet($sequence,$quality,$name,$class)};\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} = \n                substr($self->{contigs}->{$_}->{'consensus'},$points[0],$points[1]-$points[0]);\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_singlets\".\n                 \"_and_singletons: Done setting the quality trimpoints.\\n\");\n    return;\n}  # end set_trim_points_singlet\n\n=head2 set_trim_points_doublets()\n\n Title   : set_trim_points_doublets()\n Usage   : $o_consed->set_trim_points_doublets();\n Function: Set the trim points for doublets based on quality. Uses the\n\t   Bio::Tools::Alignment::Trim object. Use at your own risk because\n           the Bio::Tools::Alignment::Trim object was designed specifically\n           for me and is mysterious in its ways. Every time somebody other\n           then me uses it you risk a biblical plague being loosed on your\n           city.\n Returns : Nothing.\n Args    : None.\n Notes   : Working on exceptions here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\nsub set_trim_points_doublets {\n    my $self = shift;\n    my @points;\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Restoring zeros for doublets.\\n\");\n    # &show_missing_sequence($self);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Setting doublet trim points.\\n\");\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            # my ($self,$sequence,$quality,$name,$class) = @_;\n            my @quals = split(' ',$self->{'contigs'}->{$_}->{'quality'});\n\n\t    @points = $self->{o_trim}->trim_doublet\n                ($self->{'contigs'}->{$_}->{'consensus'},\n                 $self->{'contigs'}->{$_}->{'quality'},\n                 $self->{'contigs'}->{$_}->{name},\n                 $self->{'contigs'}->{$_}->{'class'});\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n            # now set this\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} =\n                substr($self->{contigs}->{$_}->{'consensus'},\n                       $points[0],$points[1]-$points[0]);\n\t    # 010102 the deprecated way to do things:\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Done setting doublet trim points.\\n\"); \n    return;\n} # end set_trim_points_doublets\n\n=head2 get_trimmed_sequence_by_name($name)\n\n Title   : get_trimmed_sequence_by_name($name)\n Usage   : $o_consed->get_trimmed_sequence_by_name($name);\n Function: Returns the trimmed_sequence of a contig with {name} eq $name.\n Returns : A scalar- the trimmed sequence.\n Args    : The {name} of a contig.\n Notes   : \n\n\nsub get_trimmed_sequence_by_name {\n    my ($self,$name) = @_;\n    my $trimmed_sequence;\n    my $contigname = &get_contig_number_by_name($self,$name);\n    my $class = $self->{'contigs'}->{$contigname}->{'class'};\n    # what is this business and who was smoking crack while writing this?\n    # if ($class eq \"singlet\") {\n    # send the sequence, the quality, and the name\n    # $trimmed_sequence = $self->{o_trim}->trim_singlet\n    #  ($self->{'contigs'}->{$contigname}->{consensus},\n    #   $self->{'contigs'}->{$contigname}->{'quality'},$name);\n    # }\n    return $self->{'contigs'}->{$contigname}->{'sequence_trimmed'};\n}\n\n=head2 set_dash_present_in_sequence_name(\"yes\")\n\n Title   : set_dash_present_in_sequence_name(\"yes\")\n Usage   : $o_consed->set_dash_present_in_sequence_name(\"yes\");\n Function: Deprecated. Part of an uncompleted thought. (\"Oooh! Shiny!\")\n Returns : Nothing.\n Args    : \"yes\" to set {dash_present_in_sequence_name} to 1\n Notes   : ","label":"set_dash_present_in_sequence_name($self,$dash_present)"},"containerName":"main::","name":"set_dash_present_in_sequence_name","children":[{"definition":"my","containerName":"set_dash_present_in_sequence_name","localvar":"my","kind":13,"name":"$self","line":876},{"line":876,"kind":13,"containerName":"set_dash_present_in_sequence_name","name":"$dash_present"},{"line":877,"name":"$dash_present","containerName":"set_dash_present_in_sequence_name","kind":13},{"line":878,"kind":13,"containerName":"set_dash_present_in_sequence_name","name":"$self"},{"name":"$self","containerName":"set_dash_present_in_sequence_name","kind":13,"line":881},{"line":883,"name":"$self","kind":13,"containerName":"set_dash_present_in_sequence_name"}],"detail":"($self,$dash_present)","definition":"sub"},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_reverse_designator {\n    my ($self,$reverse_designator) = @_;\n    $self->{'reverse_designator'} = $reverse_designator;\n    $self->{'o_trim'}->set_reverse_designator($reverse_designator);\n    return $self->{'reverse_designator'};\n}\t\t\t\t# end set_reverse_designator\n\n=head2 set_forward_designator($some_string)\n\n Title   : set_forward_designator($some_string)\n Usage   : $o_consed->set_forward_designator($some_string);\n Function: Set the designator for the forward read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{forward_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_forward_designator {\n    my ($self,$forward_designator) = @_;\n    $self->{'forward_designator'} = $forward_designator;\n    $self->{'o_trim'}->set_forward_designator($forward_designator);\n    return $self->{'forward_designator'};\n}\t\t\t\t# end set_forward_designator\n\n=head2 set_designator_ignore_case(\"yes\")\n\n Title   : set_designator_ignore_case(\"yes\")\n Usage   : $o_consed->set_designator_ignore_case(\"yes\");\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n\nDeprecated. Really. Trust me.\n\n\nsub set_designator_ignore_case {\n    my ($self,$ignore_case) = @_;\n    if ($ignore_case eq \"yes\") {\n\t$self->{'designator_ignore_case'} = 1;\n    }\n    return $self->{'designator_ignore_case'};\n}\t\t\t\t# end set_designator_ignore_case\n\n=head2 set_trim_points_singlets_and_singletons()\n\n Title   : set_trim_points_singlets_and_singletons()\n Usage   : $o_consed->set_trim_points_singlets_and_singletons();\n Function: Set the trim points for singlets and singletons based on\n\t   quality.  Uses the Bio::Tools::Alignment::Trim object. Use\n\t   at your own risk because the Bio::Tools::Alignment::Trim\n\t   object was designed specifically for me and is mysterious\n\t   in its ways. Every time somebody other then me uses it a\n\t   swarm of locusts decends on a small Central American\n\t   village so do not say you weren't warned.\n Returns : Nothing.\n Args    : None.\n\nWorking on exceptions and warnings here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\n#' to make my emacs happy\n\nsub set_trim_points_singlets_and_singletons {\n    my ($self) = @_;\n    $self->debug(\"Consed.pm : \\$self is $self\\n\");\n    my (@points,$trimmed_sequence);\n    if (!$self->{'doublets_set'}) {\n        $self->debug(\"You need to set the doublets before you use \".\n                     \"set_trim_points_singlets_and_doublets. Doing that now.\");\n\t$self->set_doublets();\n    }\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"singlet\") {\n\t    $self->debug(\"Singlet $_\\n\");\n\t    # this is what Warehouse wants\n\t    #         my ($self,$sequence,$quality,$name) = @_;\n\t    # this is what Bio::Tools::Alignment::Trim::trim_singlet wants:\n\t    # my ($self,$sequence,$quality,$name,$class) = @_;\n\t    # the following several lines are to make the parameter passing legible.\n\t    my ($sequence,$quality,$name,$class);\n\t    $sequence = $self->{'contigs'}->{$_}->{'consensus'};\n\t    if (!$self->{'contigs'}->{$_}->{'quality'}) { $quality = \"unset\"; }\n\t    else { $quality = $self->{'contigs'}->{$_}->{'quality'}; }\n\t    $name = $self->{'contigs'}->{$_}->{'name'};\n\t    $class = $self->{'contigs'}->{$_}->{'class'};\n\t    @points = @{$self->{'o_trim'}->trim_singlet($sequence,$quality,$name,$class)};\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} = \n                substr($self->{contigs}->{$_}->{'consensus'},$points[0],$points[1]-$points[0]);\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_singlets\".\n                 \"_and_singletons: Done setting the quality trimpoints.\\n\");\n    return;\n}  # end set_trim_points_singlet\n\n=head2 set_trim_points_doublets()\n\n Title   : set_trim_points_doublets()\n Usage   : $o_consed->set_trim_points_doublets();\n Function: Set the trim points for doublets based on quality. Uses the\n\t   Bio::Tools::Alignment::Trim object. Use at your own risk because\n           the Bio::Tools::Alignment::Trim object was designed specifically\n           for me and is mysterious in its ways. Every time somebody other\n           then me uses it you risk a biblical plague being loosed on your\n           city.\n Returns : Nothing.\n Args    : None.\n Notes   : Working on exceptions here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\nsub set_trim_points_doublets {\n    my $self = shift;\n    my @points;\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Restoring zeros for doublets.\\n\");\n    # &show_missing_sequence($self);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Setting doublet trim points.\\n\");\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            # my ($self,$sequence,$quality,$name,$class) = @_;\n            my @quals = split(' ',$self->{'contigs'}->{$_}->{'quality'});\n\n\t    @points = $self->{o_trim}->trim_doublet\n                ($self->{'contigs'}->{$_}->{'consensus'},\n                 $self->{'contigs'}->{$_}->{'quality'},\n                 $self->{'contigs'}->{$_}->{name},\n                 $self->{'contigs'}->{$_}->{'class'});\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n            # now set this\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} =\n                substr($self->{contigs}->{$_}->{'consensus'},\n                       $points[0],$points[1]-$points[0]);\n\t    # 010102 the deprecated way to do things:\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Done setting doublet trim points.\\n\"); \n    return;\n} # end set_trim_points_doublets\n\n=head2 get_trimmed_sequence_by_name($name)\n\n Title   : get_trimmed_sequence_by_name($name)\n Usage   : $o_consed->get_trimmed_sequence_by_name($name);\n Function: Returns the trimmed_sequence of a contig with {name} eq $name.\n Returns : A scalar- the trimmed sequence.\n Args    : The {name} of a contig.\n Notes   : \n\n\nsub get_trimmed_sequence_by_name {\n    my ($self,$name) = @_;\n    my $trimmed_sequence;\n    my $contigname = &get_contig_number_by_name($self,$name);\n    my $class = $self->{'contigs'}->{$contigname}->{'class'};\n    # what is this business and who was smoking crack while writing this?\n    # if ($class eq \"singlet\") {\n    # send the sequence, the quality, and the name\n    # $trimmed_sequence = $self->{o_trim}->trim_singlet\n    #  ($self->{'contigs'}->{$contigname}->{consensus},\n    #   $self->{'contigs'}->{$contigname}->{'quality'},$name);\n    # }\n    return $self->{'contigs'}->{$contigname}->{'sequence_trimmed'};\n}\n\n=head2 set_dash_present_in_sequence_name(\"yes\")\n\n Title   : set_dash_present_in_sequence_name(\"yes\")\n Usage   : $o_consed->set_dash_present_in_sequence_name(\"yes\");\n Function: Deprecated. Part of an uncompleted thought. (\"Oooh! Shiny!\")\n Returns : Nothing.\n Args    : \"yes\" to set {dash_present_in_sequence_name} to 1\n Notes   : \n\n\nsub set_dash_present_in_sequence_name {\n    my ($self,$dash_present) = @_;\n    if ($dash_present eq \"yes\") {\n\t$self->{'dash_present_in_sequence_name'} = 1;\n    }\n    else {\n\t$self->{'dash_present_in_sequence_name'} = 0;\n    }\n    return $self->{'dash_present_in_sequence_name'};\n} # end set_dash_present_in_sequence_name\n\n=head2 set_doublets()\n\n Title   : set_doublets()\n Usage   : $o_consed->set_doublets();\n Function: Find pairs that have similar names and mark them as doublets\n\t   and set the {name}.\n Returns : 0 or 1.\n Args    : None.\n\nA complicated subroutine that iterates over the\nBio::Tools::Alignment::Consed looking for contigs of 2. If the forward\nand reverse designator are removed from each of the reads in\n{'member_array'} and the remaining reads are the same, {name} is set\nto that name and the contig's class is set as \"doublet\".  If any of\nthose cases fail the contig is marked as a \"pair\".\n\n' make my emacs happy","label":"set_doublets($self)"},"range":{"end":{"character":9999,"line":912},"start":{"line":906,"character":0}},"kind":12,"line":906,"detail":"($self)","definition":"sub","containerName":"main::","name":"set_doublets","children":[{"line":907,"containerName":"set_doublets","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":910,"name":"$self","containerName":"set_doublets","kind":13},{"name":"set_designators","kind":12,"containerName":"set_doublets","line":910},{"name":"$self","kind":13,"containerName":"set_doublets","line":910},{"kind":13,"containerName":"set_doublets","name":"$self","line":911},{"name":"$key_contig","kind":13,"localvar":"my","containerName":"set_doublets","line":912,"definition":"my"},{"containerName":"set_doublets","kind":13,"name":"$self","line":912}]},{"line":916,"name":"%self","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%key_contig","line":916},{"line":922,"containerName":null,"kind":13,"name":"%self"},{"line":922,"containerName":null,"kind":13,"name":"%key_contig"},{"line":923,"name":"%self","kind":13,"containerName":null},{"line":923,"containerName":null,"kind":13,"name":"%key_contig"},{"name":"$self","kind":13,"containerName":null,"line":924},{"name":"debug","kind":12,"containerName":"main::","line":924},{"kind":13,"localvar":"my","containerName":null,"name":"$name","line":925,"definition":"my"},{"name":"_get_contig_name","kind":12,"line":925},{"kind":13,"containerName":null,"name":"$self","line":925},{"line":925,"containerName":null,"kind":13,"name":"%self"},{"name":"%key_contig","kind":13,"containerName":null,"line":925},{"line":926,"name":"$self","kind":13,"containerName":null},{"line":926,"kind":12,"containerName":"main::","name":"debug"},{"containerName":null,"kind":13,"name":"$name","line":926},{"line":927,"containerName":null,"kind":13,"name":"%name"},{"name":"%self","containerName":null,"kind":13,"line":928},{"line":928,"name":"%key_contig","containerName":null,"kind":13},{"line":928,"kind":13,"containerName":null,"name":"$name"},{"line":929,"name":"%self","containerName":null,"kind":13},{"line":929,"name":"%key_contig","containerName":null,"kind":13},{"line":931,"name":"$self","kind":13,"containerName":null},{"line":931,"kind":12,"containerName":"main::","name":"debug"},{"name":"%self","containerName":null,"kind":13,"line":932},{"line":932,"kind":13,"containerName":null,"name":"%key_contig"},{"kind":13,"containerName":null,"name":"%self","line":937},{"name":"%key_contig","kind":13,"containerName":null,"line":937},{"line":939,"containerName":null,"kind":13,"name":"%self"},{"name":"%key_contig","kind":13,"containerName":null,"line":939},{"name":"name","kind":12,"line":939},{"name":"%self","containerName":null,"kind":13,"line":939},{"line":939,"containerName":null,"kind":13,"name":"%key_contig"},{"containerName":null,"kind":13,"name":"%self","line":941},{"containerName":null,"kind":13,"name":"%key_contig","line":941},{"line":941,"kind":12,"name":"num_members"},{"name":"%self","containerName":null,"kind":13,"line":945},{"containerName":null,"kind":13,"name":"%key_contig","line":945},{"name":"%self","containerName":null,"kind":13,"line":946},{"name":"%key_contig","kind":13,"containerName":null,"line":946},{"containerName":null,"kind":13,"name":"%self","line":950},{"name":"%key_contig","kind":13,"containerName":null,"line":950},{"line":951,"containerName":null,"kind":13,"name":"%self"},{"line":951,"name":"%key_contig","kind":13,"containerName":null},{"name":"%self","containerName":null,"kind":13,"line":951},{"kind":13,"containerName":null,"name":"%key_contig","line":951},{"line":952,"name":"%self","containerName":null,"kind":13},{"line":952,"containerName":null,"kind":13,"name":"%key_contig"},{"line":954,"containerName":null,"kind":13,"name":"%self"},{"line":954,"kind":13,"containerName":null,"name":"%key_contig"},{"line":954,"name":"%self","containerName":null,"kind":13},{"line":954,"name":"%key_contig","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%self","line":958},{"detail":"($self)","definition":"sub","name":"set_singlets","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"set_singlets","name":"$self","line":976,"definition":"my"},{"line":977,"kind":13,"containerName":"set_singlets","name":"$self"},{"line":977,"kind":12,"containerName":"set_singlets","name":"debug"},{"kind":13,"localvar":"my","containerName":"set_singlets","name":"$full_filename","line":978,"definition":"my"},{"line":978,"containerName":"set_singlets","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"set_singlets","line":979},{"line":979,"name":"debug","kind":12,"containerName":"set_singlets"},{"line":980,"name":"$full_filename","containerName":"set_singlets","kind":13},{"name":"$base_path","containerName":"set_singlets","localvar":"my","kind":13,"line":981,"definition":"my"},{"containerName":"set_singlets","kind":13,"name":"$filename","line":981},{"line":982,"kind":13,"containerName":"set_singlets","name":"$self"},{"name":"debug","kind":12,"containerName":"set_singlets","line":982},{"kind":13,"containerName":"set_singlets","name":"$filename","line":983},{"definition":"my","kind":13,"localvar":"my","containerName":"set_singlets","name":"$singletsfile","line":984},{"containerName":"set_singlets","kind":13,"name":"$base_path","line":984},{"kind":13,"containerName":"set_singlets","name":"$self","line":985},{"line":985,"name":"debug","kind":12,"containerName":"set_singlets"},{"line":986,"kind":13,"containerName":"set_singlets","name":"$singletsfile"},{"containerName":"set_singlets","kind":13,"name":"$self","line":988},{"containerName":"set_singlets","kind":13,"name":"$self","line":991},{"line":991,"containerName":"set_singlets","kind":12,"name":"debug"},{"containerName":"set_singlets","localvar":"my","kind":13,"name":"$singlets_fh","line":992,"definition":"my"},{"name":"new","kind":12,"containerName":"set_singlets","line":992},{"line":992,"name":"$singletsfile","containerName":"set_singlets","kind":13},{"name":"$sequence","localvar":"my","containerName":"set_singlets","kind":13,"line":993,"definition":"my"},{"line":993,"name":"$name","containerName":"set_singlets","kind":13},{"name":"$count","containerName":"set_singlets","kind":13,"line":993},{"line":994,"kind":13,"containerName":"set_singlets","name":"$singlets_fh"},{"kind":12,"containerName":"set_singlets","name":"_readline","line":994},{"kind":13,"containerName":"set_singlets","name":"$name","line":997},{"line":997,"name":"$sequence","kind":13,"containerName":"set_singlets"},{"line":998,"name":"$self","kind":13,"containerName":"set_singlets"},{"line":998,"name":"debug","kind":12,"containerName":"set_singlets"},{"name":"$self","kind":13,"containerName":"set_singlets","line":999},{"containerName":"set_singlets","kind":13,"name":"$name","line":999},{"name":"$name","containerName":"set_singlets","kind":13,"line":999},{"name":"$self","containerName":"set_singlets","kind":13,"line":1000},{"line":1000,"name":"$name","kind":13,"containerName":"set_singlets"},{"kind":13,"containerName":"set_singlets","name":"$sequence","line":1000},{"containerName":"set_singlets","kind":13,"name":"$self","line":1001},{"containerName":"set_singlets","kind":13,"name":"$name","line":1001},{"kind":13,"containerName":"set_singlets","name":"$name","line":1001},{"name":"$self","kind":13,"containerName":"set_singlets","line":1002},{"line":1002,"containerName":"set_singlets","kind":13,"name":"$name"},{"line":1003,"kind":13,"containerName":"set_singlets","name":"$self"},{"line":1003,"name":"$name","kind":13,"containerName":"set_singlets"},{"line":1005,"name":"$sequence","kind":13,"containerName":"set_singlets"},{"line":1005,"containerName":"set_singlets","kind":13,"name":"$name"},{"kind":13,"containerName":"set_singlets","name":"$count","line":1006},{"containerName":"set_singlets","kind":13,"name":"$name","line":1008},{"line":1009,"name":"$name","containerName":"set_singlets","kind":13},{"line":1011,"containerName":"set_singlets","kind":13,"name":"$name"},{"name":"$sequence","kind":13,"containerName":"set_singlets","line":1014}],"signature":{"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_reverse_designator {\n    my ($self,$reverse_designator) = @_;\n    $self->{'reverse_designator'} = $reverse_designator;\n    $self->{'o_trim'}->set_reverse_designator($reverse_designator);\n    return $self->{'reverse_designator'};\n}\t\t\t\t# end set_reverse_designator\n\n=head2 set_forward_designator($some_string)\n\n Title   : set_forward_designator($some_string)\n Usage   : $o_consed->set_forward_designator($some_string);\n Function: Set the designator for the forward read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{forward_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_forward_designator {\n    my ($self,$forward_designator) = @_;\n    $self->{'forward_designator'} = $forward_designator;\n    $self->{'o_trim'}->set_forward_designator($forward_designator);\n    return $self->{'forward_designator'};\n}\t\t\t\t# end set_forward_designator\n\n=head2 set_designator_ignore_case(\"yes\")\n\n Title   : set_designator_ignore_case(\"yes\")\n Usage   : $o_consed->set_designator_ignore_case(\"yes\");\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n\nDeprecated. Really. Trust me.\n\n\nsub set_designator_ignore_case {\n    my ($self,$ignore_case) = @_;\n    if ($ignore_case eq \"yes\") {\n\t$self->{'designator_ignore_case'} = 1;\n    }\n    return $self->{'designator_ignore_case'};\n}\t\t\t\t# end set_designator_ignore_case\n\n=head2 set_trim_points_singlets_and_singletons()\n\n Title   : set_trim_points_singlets_and_singletons()\n Usage   : $o_consed->set_trim_points_singlets_and_singletons();\n Function: Set the trim points for singlets and singletons based on\n\t   quality.  Uses the Bio::Tools::Alignment::Trim object. Use\n\t   at your own risk because the Bio::Tools::Alignment::Trim\n\t   object was designed specifically for me and is mysterious\n\t   in its ways. Every time somebody other then me uses it a\n\t   swarm of locusts decends on a small Central American\n\t   village so do not say you weren't warned.\n Returns : Nothing.\n Args    : None.\n\nWorking on exceptions and warnings here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\n#' to make my emacs happy\n\nsub set_trim_points_singlets_and_singletons {\n    my ($self) = @_;\n    $self->debug(\"Consed.pm : \\$self is $self\\n\");\n    my (@points,$trimmed_sequence);\n    if (!$self->{'doublets_set'}) {\n        $self->debug(\"You need to set the doublets before you use \".\n                     \"set_trim_points_singlets_and_doublets. Doing that now.\");\n\t$self->set_doublets();\n    }\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"singlet\") {\n\t    $self->debug(\"Singlet $_\\n\");\n\t    # this is what Warehouse wants\n\t    #         my ($self,$sequence,$quality,$name) = @_;\n\t    # this is what Bio::Tools::Alignment::Trim::trim_singlet wants:\n\t    # my ($self,$sequence,$quality,$name,$class) = @_;\n\t    # the following several lines are to make the parameter passing legible.\n\t    my ($sequence,$quality,$name,$class);\n\t    $sequence = $self->{'contigs'}->{$_}->{'consensus'};\n\t    if (!$self->{'contigs'}->{$_}->{'quality'}) { $quality = \"unset\"; }\n\t    else { $quality = $self->{'contigs'}->{$_}->{'quality'}; }\n\t    $name = $self->{'contigs'}->{$_}->{'name'};\n\t    $class = $self->{'contigs'}->{$_}->{'class'};\n\t    @points = @{$self->{'o_trim'}->trim_singlet($sequence,$quality,$name,$class)};\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} = \n                substr($self->{contigs}->{$_}->{'consensus'},$points[0],$points[1]-$points[0]);\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_singlets\".\n                 \"_and_singletons: Done setting the quality trimpoints.\\n\");\n    return;\n}  # end set_trim_points_singlet\n\n=head2 set_trim_points_doublets()\n\n Title   : set_trim_points_doublets()\n Usage   : $o_consed->set_trim_points_doublets();\n Function: Set the trim points for doublets based on quality. Uses the\n\t   Bio::Tools::Alignment::Trim object. Use at your own risk because\n           the Bio::Tools::Alignment::Trim object was designed specifically\n           for me and is mysterious in its ways. Every time somebody other\n           then me uses it you risk a biblical plague being loosed on your\n           city.\n Returns : Nothing.\n Args    : None.\n Notes   : Working on exceptions here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\nsub set_trim_points_doublets {\n    my $self = shift;\n    my @points;\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Restoring zeros for doublets.\\n\");\n    # &show_missing_sequence($self);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Setting doublet trim points.\\n\");\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            # my ($self,$sequence,$quality,$name,$class) = @_;\n            my @quals = split(' ',$self->{'contigs'}->{$_}->{'quality'});\n\n\t    @points = $self->{o_trim}->trim_doublet\n                ($self->{'contigs'}->{$_}->{'consensus'},\n                 $self->{'contigs'}->{$_}->{'quality'},\n                 $self->{'contigs'}->{$_}->{name},\n                 $self->{'contigs'}->{$_}->{'class'});\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n            # now set this\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} =\n                substr($self->{contigs}->{$_}->{'consensus'},\n                       $points[0],$points[1]-$points[0]);\n\t    # 010102 the deprecated way to do things:\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Done setting doublet trim points.\\n\"); \n    return;\n} # end set_trim_points_doublets\n\n=head2 get_trimmed_sequence_by_name($name)\n\n Title   : get_trimmed_sequence_by_name($name)\n Usage   : $o_consed->get_trimmed_sequence_by_name($name);\n Function: Returns the trimmed_sequence of a contig with {name} eq $name.\n Returns : A scalar- the trimmed sequence.\n Args    : The {name} of a contig.\n Notes   : \n\n\nsub get_trimmed_sequence_by_name {\n    my ($self,$name) = @_;\n    my $trimmed_sequence;\n    my $contigname = &get_contig_number_by_name($self,$name);\n    my $class = $self->{'contigs'}->{$contigname}->{'class'};\n    # what is this business and who was smoking crack while writing this?\n    # if ($class eq \"singlet\") {\n    # send the sequence, the quality, and the name\n    # $trimmed_sequence = $self->{o_trim}->trim_singlet\n    #  ($self->{'contigs'}->{$contigname}->{consensus},\n    #   $self->{'contigs'}->{$contigname}->{'quality'},$name);\n    # }\n    return $self->{'contigs'}->{$contigname}->{'sequence_trimmed'};\n}\n\n=head2 set_dash_present_in_sequence_name(\"yes\")\n\n Title   : set_dash_present_in_sequence_name(\"yes\")\n Usage   : $o_consed->set_dash_present_in_sequence_name(\"yes\");\n Function: Deprecated. Part of an uncompleted thought. (\"Oooh! Shiny!\")\n Returns : Nothing.\n Args    : \"yes\" to set {dash_present_in_sequence_name} to 1\n Notes   : \n\n\nsub set_dash_present_in_sequence_name {\n    my ($self,$dash_present) = @_;\n    if ($dash_present eq \"yes\") {\n\t$self->{'dash_present_in_sequence_name'} = 1;\n    }\n    else {\n\t$self->{'dash_present_in_sequence_name'} = 0;\n    }\n    return $self->{'dash_present_in_sequence_name'};\n} # end set_dash_present_in_sequence_name\n\n=head2 set_doublets()\n\n Title   : set_doublets()\n Usage   : $o_consed->set_doublets();\n Function: Find pairs that have similar names and mark them as doublets\n\t   and set the {name}.\n Returns : 0 or 1.\n Args    : None.\n\nA complicated subroutine that iterates over the\nBio::Tools::Alignment::Consed looking for contigs of 2. If the forward\nand reverse designator are removed from each of the reads in\n{'member_array'} and the remaining reads are the same, {name} is set\nto that name and the contig's class is set as \"doublet\".  If any of\nthose cases fail the contig is marked as a \"pair\".\n\n\n#' make my emacs happy\n\nsub set_doublets {\n    my ($self) = @_;\n    # set the designators in the Bio::Tools::Alignment::Trim object\n\n    $self->{'o_trim'}->set_designators($self->{'reverse_designator'},\n\t\t\t\t       $self->{'forward_designator'});\n    foreach my $key_contig (sort keys %{$self->{'contigs'}}) {\n\n\t# if there is a member array (why would there not be? This should be a die()able offence\n\t# but for now I will leave it\n\tif ($self->{'contigs'}->{$key_contig}->{'member_array'}) {\n\t    # if there are two reads in this contig \n\t    # i am pretty sure that this is wrong but i am keeping it for reference\n\t    # if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2 || !$self->{'contigs'}->{$key_contig}->{'class'}) {\n\t    # <seconds later>\n\t    # <nod> WRONG. Was I on crack?\n\t    if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = 2;\n\t\t$self->debug(\"\\tThere are 2 members! Looking for the contig name...\\n\");\n\t\tmy $name = _get_contig_name($self,$self->{'contigs'}->{$key_contig}->{'member_array'});\n\t\t$self->debug(\"The name is $name\\n\") if defined $name;\n\t\tif ($name) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'name'} = $name;\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"doublet\";\n\t\t} else {\n\t\t    $self->debug(\"$key_contig is a pair.\\n\");\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"pair\";\n\t\t}\n\t    }\n            # this is all fair and good but what about singlets?\n            # they have one reads in the member_array but certainly are not singletons\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 1) {\n\t\t# set the name to be the name of the read\n\t\t$self->{'contigs'}->{$key_contig}->{name} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}}[0];\n\t\t# set the number of members to be one\n\t\t$self->{'contigs'}->{$key_contig}->{num_members} = 1;\n\t\t# if this was a singlet, it would already belong to the class \"singlet\"\n\t\t# so leave it alone\n\t\t# if it is not a singlet, it is a singleton! lablel it appropriately\n\t\tunless ($self->{'contigs'}->{$key_contig}->{'class'}) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"singleton\";\n\t\t}\n\t    }\n            # set the multiplet characteristics\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} >= 3) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\t\t$self->{'contigs'}->{$key_contig}->{'class'} = \"multiplet\";\n\t    }\n\t    $self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\n\t}\n    }\n    $self->{'doublets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end set_doublets\n\n=head2 set_singlets\n\n Title   : set_singlets\n Usage   : $o_consed->set_singlets();\n Function: Read in a singlets file and place them into the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : Nothing.\n Args    : A scalar to turn on verbose parsing of the singlets file.\n Notes   : ","parameters":[{"label":"$self"}],"label":"set_singlets($self)"},"range":{"start":{"line":974,"character":0},"end":{"character":9999,"line":1015}},"kind":12,"line":974},{"line":992,"name":"Bio","containerName":"Root::IO","kind":12},{"line":1016,"containerName":null,"kind":13,"name":"$name"},{"line":1016,"name":"%sequence","kind":13,"containerName":null},{"name":"$self","kind":13,"containerName":null,"line":1017},{"line":1017,"kind":12,"containerName":"main::","name":"debug"},{"name":"%self","containerName":null,"kind":13,"line":1018},{"name":"%name","kind":13,"containerName":null,"line":1018},{"line":1018,"name":"$name","kind":13,"containerName":null},{"line":1019,"name":"%self","kind":13,"containerName":null},{"line":1019,"name":"%name","kind":13,"containerName":null},{"name":"$sequence","kind":13,"containerName":null,"line":1019},{"line":1020,"name":"%self","containerName":null,"kind":13},{"name":"%name","kind":13,"containerName":null,"line":1020},{"line":1020,"name":"$name","kind":13,"containerName":null},{"name":"%self","containerName":null,"kind":13,"line":1021},{"line":1021,"name":"%name","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%self","line":1022},{"line":1022,"name":"%name","containerName":null,"kind":13},{"line":1024,"kind":13,"containerName":null,"name":"$self"},{"line":1024,"kind":12,"containerName":"main::","name":"debug"},{"kind":13,"containerName":null,"name":"%self","line":1025},{"line":1041,"kind":12,"range":{"end":{"line":1051,"character":9999},"start":{"line":1041,"character":0}},"definition":"sub","children":[{"definition":"my","line":1044,"name":"$self","containerName":"get_singlets","localvar":"my","kind":13},{"kind":13,"containerName":"get_singlets","name":"$self","line":1045},{"kind":13,"containerName":"get_singlets","name":"$self","line":1046},{"line":1046,"containerName":"get_singlets","kind":12,"name":"debug"},{"line":1047,"name":"$self","containerName":"get_singlets","kind":13},{"line":1047,"containerName":"get_singlets","kind":12,"name":"set_singlets"},{"name":"@singlets","containerName":"get_singlets","localvar":"my","kind":13,"line":1050,"definition":"my"},{"line":1050,"name":"@array","containerName":"get_singlets","kind":13},{"definition":"my","localvar":"my","kind":13,"containerName":"get_singlets","name":"$key","line":1051},{"containerName":"get_singlets","kind":13,"name":"$self","line":1051}],"name":"get_singlets","containerName":"main::"},{"line":1045,"kind":12,"name":"singlets_set"},{"name":"%self","kind":13,"containerName":null,"line":1056},{"line":1056,"kind":13,"containerName":null,"name":"%key"},{"name":"%self","kind":13,"containerName":null,"line":1059},{"kind":13,"containerName":null,"name":"%key","line":1059},{"kind":13,"containerName":null,"name":"@singlets","line":1060},{"line":1060,"kind":13,"containerName":null,"name":"$key"},{"line":1063,"kind":13,"containerName":null,"name":"@singlets"},{"line":1078,"range":{"start":{"line":1078,"character":0},"end":{"line":1082,"character":9999}},"kind":12,"children":[{"definition":"my","line":1080,"name":"$self","containerName":"set_quality_by_name","localvar":"my","kind":13},{"line":1080,"kind":13,"containerName":"set_quality_by_name","name":"$name"},{"line":1080,"containerName":"set_quality_by_name","kind":13,"name":"$quality"},{"line":1081,"name":"$return","containerName":"set_quality_by_name","localvar":"my","kind":13,"definition":"my"},{"line":1082,"name":"$self","kind":13,"containerName":"set_quality_by_name"}],"containerName":"main::","name":"set_quality_by_name","definition":"sub"},{"line":1083,"kind":13,"containerName":null,"name":"%self"},{"name":"%self","containerName":null,"kind":13,"line":1083},{"kind":13,"containerName":null,"name":"%self","line":1084},{"line":1084,"name":"$quality","containerName":null,"kind":13},{"line":1085,"name":"$return","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%return","line":1088},{"line":1105,"range":{"start":{"line":1105,"character":0},"end":{"character":9999,"line":1136}},"kind":12,"children":[{"line":1106,"kind":13,"localvar":"my","containerName":"set_singlet_quality","name":"$self","definition":"my"},{"definition":"my","name":"$full_filename","kind":13,"localvar":"my","containerName":"set_singlet_quality","line":1107},{"kind":13,"containerName":"set_singlet_quality","name":"$self","line":1107},{"kind":13,"containerName":"set_singlet_quality","name":"$full_filename","line":1108},{"definition":"my","line":1109,"name":"$base_path","localvar":"my","kind":13,"containerName":"set_singlet_quality"},{"name":"$filename","containerName":"set_singlet_quality","kind":13,"line":1109},{"line":1110,"kind":13,"localvar":"my","containerName":"set_singlet_quality","name":"$singletsfile","definition":"my"},{"kind":13,"containerName":"set_singlet_quality","name":"$base_path","line":1110},{"containerName":"set_singlet_quality","kind":13,"name":"$filename","line":1110},{"line":1111,"containerName":"set_singlet_quality","kind":13,"name":"$singletsfile"},{"line":1115,"name":"$self","containerName":"set_singlet_quality","kind":13},{"line":1115,"containerName":"set_singlet_quality","kind":12,"name":"warn"},{"name":"$singlets_fh","containerName":"set_singlet_quality","localvar":"my","kind":13,"line":1118,"definition":"my"},{"line":1118,"containerName":"set_singlet_quality","kind":12,"name":"new"},{"line":1118,"containerName":"set_singlet_quality","kind":13,"name":"$singletsfile"},{"name":"$sequence","kind":13,"localvar":"my","containerName":"set_singlet_quality","line":1119,"definition":"my"},{"line":1119,"name":"$name","containerName":"set_singlet_quality","kind":13},{"name":"$count","containerName":"set_singlet_quality","kind":13,"line":1119},{"definition":"my","name":"$identity","localvar":"my","kind":13,"containerName":"set_singlet_quality","line":1120},{"line":1120,"name":"$line","kind":13,"containerName":"set_singlet_quality"},{"line":1120,"name":"$quality","kind":13,"containerName":"set_singlet_quality"},{"name":"@qline","kind":13,"containerName":"set_singlet_quality","line":1120},{"line":1121,"name":"$line","containerName":"set_singlet_quality","kind":13},{"line":1121,"name":"$singlets_fh","containerName":"set_singlet_quality","kind":13},{"line":1121,"kind":12,"containerName":"set_singlet_quality","name":"_readline"},{"kind":13,"containerName":"set_singlet_quality","name":"$line","line":1122},{"line":1123,"kind":13,"containerName":"set_singlet_quality","name":"$line"},{"line":1124,"name":"$quality","kind":13,"containerName":"set_singlet_quality"},{"kind":13,"containerName":"set_singlet_quality","name":"$line","line":1125},{"name":"$identity","containerName":"set_singlet_quality","kind":13,"line":1126},{"line":1129,"kind":13,"containerName":"set_singlet_quality","name":"$self"},{"kind":13,"containerName":"set_singlet_quality","name":"$identity","line":1129},{"line":1130,"kind":13,"containerName":"set_singlet_quality","name":"$self"},{"kind":13,"containerName":"set_singlet_quality","name":"$identity","line":1130}],"name":"set_singlet_quality","containerName":"main::","definition":"sub"},{"containerName":"Root::IO","kind":12,"name":"Bio","line":1118},{"containerName":"main::","name":"set_contig_quality","children":[{"line":1151,"name":"$self","localvar":"my","containerName":"set_contig_quality","kind":13,"definition":"my"},{"containerName":"set_contig_quality","kind":13,"name":"$self","line":1155},{"containerName":"set_contig_quality","kind":12,"name":"warn","line":1155},{"definition":"my","name":"$full_filename","localvar":"my","containerName":"set_contig_quality","kind":13,"line":1156},{"name":"$self","kind":13,"containerName":"set_contig_quality","line":1156},{"line":1159,"containerName":"set_contig_quality","kind":13,"name":"$full_filename"},{"definition":"my","name":"$base_path","kind":13,"localvar":"my","containerName":"set_contig_quality","line":1160},{"containerName":"set_contig_quality","kind":13,"name":"$filename","line":1160},{"line":1161,"localvar":"my","kind":13,"containerName":"set_contig_quality","name":"$singletsfile","definition":"my"},{"containerName":"set_contig_quality","kind":13,"name":"$base_path","line":1161},{"line":1161,"containerName":"set_contig_quality","kind":13,"name":"$filename"},{"kind":13,"containerName":"set_contig_quality","name":"$singletsfile","line":1162},{"line":1166,"name":"$self","containerName":"set_contig_quality","kind":13},{"kind":12,"containerName":"set_contig_quality","name":"warn","line":1166},{"kind":13,"localvar":"my","containerName":"set_contig_quality","name":"$contig_quality_fh","line":1169,"definition":"my"},{"line":1169,"name":"new","kind":12,"containerName":"set_contig_quality"},{"kind":13,"containerName":"set_contig_quality","name":"$singletsfile","line":1169},{"definition":"my","name":"$sequence","localvar":"my","kind":13,"containerName":"set_contig_quality","line":1171},{"line":1171,"name":"$name","kind":13,"containerName":"set_contig_quality"},{"name":"$count","containerName":"set_contig_quality","kind":13,"line":1171},{"line":1171,"containerName":"set_contig_quality","kind":13,"name":"$identity"},{"line":1171,"kind":13,"containerName":"set_contig_quality","name":"$line"},{"name":"$quality","containerName":"set_contig_quality","kind":13,"line":1171},{"line":1172,"kind":13,"containerName":"set_contig_quality","name":"$line"},{"line":1172,"containerName":"set_contig_quality","kind":13,"name":"$contig_quality_fh"},{"containerName":"set_contig_quality","kind":12,"name":"_readline","line":1172},{"line":1173,"kind":13,"containerName":"set_contig_quality","name":"$line"},{"line":1174,"containerName":"set_contig_quality","kind":13,"name":"$line"},{"kind":13,"containerName":"set_contig_quality","name":"$quality","line":1175},{"kind":13,"containerName":"set_contig_quality","name":"$line","line":1176},{"containerName":"set_contig_quality","kind":13,"name":"$identity","line":1177},{"line":1180,"name":"$self","kind":13,"containerName":"set_contig_quality"},{"containerName":"set_contig_quality","kind":13,"name":"$identity","line":1180},{"line":1181,"kind":13,"containerName":"set_contig_quality","name":"$self"},{"line":1181,"name":"$identity","kind":13,"containerName":"set_contig_quality"}],"definition":"sub","kind":12,"range":{"start":{"line":1149,"character":0},"end":{"character":9999,"line":1185}},"line":1149},{"kind":12,"containerName":"Root::IO","name":"Bio","line":1169},{"name":"get_multiplets","containerName":"main::","children":[{"line":1202,"localvar":"my","kind":13,"containerName":"get_multiplets","name":"$self","definition":"my"},{"definition":"my","name":"@multiplets","kind":13,"localvar":"my","containerName":"get_multiplets","line":1203},{"line":1203,"containerName":"get_multiplets","kind":13,"name":"@array"},{"definition":"my","containerName":"get_multiplets","localvar":"my","kind":13,"name":"$key","line":1204},{"line":1204,"kind":13,"containerName":"get_multiplets","name":"$self"}],"definition":"sub","range":{"start":{"character":0,"line":1199},"end":{"line":1204,"character":9999}},"kind":12,"line":1199},{"line":1205,"name":"%self","kind":13,"containerName":null},{"name":"%key","kind":13,"containerName":null,"line":1205},{"kind":13,"containerName":null,"name":"%self","line":1206},{"name":"%key","kind":13,"containerName":null,"line":1206},{"line":1207,"name":"@multiplets","kind":13,"containerName":null},{"line":1207,"name":"$key","containerName":null,"kind":13},{"line":1211,"containerName":null,"kind":13,"name":"@multiplets"},{"children":[{"line":1228,"name":"$self","localvar":"my","containerName":"get_all_members","kind":13,"definition":"my"},{"definition":"my","line":1229,"containerName":"get_all_members","localvar":"my","kind":13,"name":"@members"},{"definition":"my","line":1230,"containerName":"get_all_members","localvar":"my","kind":13,"name":"$key"},{"line":1230,"name":"$self","kind":13,"containerName":"get_all_members"}],"name":"get_all_members","containerName":"main::","definition":"sub","line":1227,"kind":12,"range":{"end":{"character":9999,"line":1230},"start":{"line":1227,"character":0}}},{"containerName":null,"kind":13,"name":"%key","line":1231},{"line":1232,"name":"@members","kind":13,"containerName":null},{"line":1232,"name":"%self","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%key","line":1232},{"line":1234,"name":"%self","kind":13,"containerName":null},{"name":"%key","containerName":null,"kind":13,"line":1234},{"line":1235,"name":"@members","containerName":null,"kind":13},{"name":"%self","kind":13,"containerName":null,"line":1235},{"containerName":null,"kind":13,"name":"%key","line":1235},{"line":1242,"name":"@members","containerName":null,"kind":13},{"signature":{"label":"sum_lets($self,$total_only)","parameters":[{"label":"$self"},{"label":"$total_only"}],"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_reverse_designator {\n    my ($self,$reverse_designator) = @_;\n    $self->{'reverse_designator'} = $reverse_designator;\n    $self->{'o_trim'}->set_reverse_designator($reverse_designator);\n    return $self->{'reverse_designator'};\n}\t\t\t\t# end set_reverse_designator\n\n=head2 set_forward_designator($some_string)\n\n Title   : set_forward_designator($some_string)\n Usage   : $o_consed->set_forward_designator($some_string);\n Function: Set the designator for the forward read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{forward_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_forward_designator {\n    my ($self,$forward_designator) = @_;\n    $self->{'forward_designator'} = $forward_designator;\n    $self->{'o_trim'}->set_forward_designator($forward_designator);\n    return $self->{'forward_designator'};\n}\t\t\t\t# end set_forward_designator\n\n=head2 set_designator_ignore_case(\"yes\")\n\n Title   : set_designator_ignore_case(\"yes\")\n Usage   : $o_consed->set_designator_ignore_case(\"yes\");\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n\nDeprecated. Really. Trust me.\n\n\nsub set_designator_ignore_case {\n    my ($self,$ignore_case) = @_;\n    if ($ignore_case eq \"yes\") {\n\t$self->{'designator_ignore_case'} = 1;\n    }\n    return $self->{'designator_ignore_case'};\n}\t\t\t\t# end set_designator_ignore_case\n\n=head2 set_trim_points_singlets_and_singletons()\n\n Title   : set_trim_points_singlets_and_singletons()\n Usage   : $o_consed->set_trim_points_singlets_and_singletons();\n Function: Set the trim points for singlets and singletons based on\n\t   quality.  Uses the Bio::Tools::Alignment::Trim object. Use\n\t   at your own risk because the Bio::Tools::Alignment::Trim\n\t   object was designed specifically for me and is mysterious\n\t   in its ways. Every time somebody other then me uses it a\n\t   swarm of locusts decends on a small Central American\n\t   village so do not say you weren't warned.\n Returns : Nothing.\n Args    : None.\n\nWorking on exceptions and warnings here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\n#' to make my emacs happy\n\nsub set_trim_points_singlets_and_singletons {\n    my ($self) = @_;\n    $self->debug(\"Consed.pm : \\$self is $self\\n\");\n    my (@points,$trimmed_sequence);\n    if (!$self->{'doublets_set'}) {\n        $self->debug(\"You need to set the doublets before you use \".\n                     \"set_trim_points_singlets_and_doublets. Doing that now.\");\n\t$self->set_doublets();\n    }\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"singlet\") {\n\t    $self->debug(\"Singlet $_\\n\");\n\t    # this is what Warehouse wants\n\t    #         my ($self,$sequence,$quality,$name) = @_;\n\t    # this is what Bio::Tools::Alignment::Trim::trim_singlet wants:\n\t    # my ($self,$sequence,$quality,$name,$class) = @_;\n\t    # the following several lines are to make the parameter passing legible.\n\t    my ($sequence,$quality,$name,$class);\n\t    $sequence = $self->{'contigs'}->{$_}->{'consensus'};\n\t    if (!$self->{'contigs'}->{$_}->{'quality'}) { $quality = \"unset\"; }\n\t    else { $quality = $self->{'contigs'}->{$_}->{'quality'}; }\n\t    $name = $self->{'contigs'}->{$_}->{'name'};\n\t    $class = $self->{'contigs'}->{$_}->{'class'};\n\t    @points = @{$self->{'o_trim'}->trim_singlet($sequence,$quality,$name,$class)};\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} = \n                substr($self->{contigs}->{$_}->{'consensus'},$points[0],$points[1]-$points[0]);\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_singlets\".\n                 \"_and_singletons: Done setting the quality trimpoints.\\n\");\n    return;\n}  # end set_trim_points_singlet\n\n=head2 set_trim_points_doublets()\n\n Title   : set_trim_points_doublets()\n Usage   : $o_consed->set_trim_points_doublets();\n Function: Set the trim points for doublets based on quality. Uses the\n\t   Bio::Tools::Alignment::Trim object. Use at your own risk because\n           the Bio::Tools::Alignment::Trim object was designed specifically\n           for me and is mysterious in its ways. Every time somebody other\n           then me uses it you risk a biblical plague being loosed on your\n           city.\n Returns : Nothing.\n Args    : None.\n Notes   : Working on exceptions here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\nsub set_trim_points_doublets {\n    my $self = shift;\n    my @points;\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Restoring zeros for doublets.\\n\");\n    # &show_missing_sequence($self);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Setting doublet trim points.\\n\");\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            # my ($self,$sequence,$quality,$name,$class) = @_;\n            my @quals = split(' ',$self->{'contigs'}->{$_}->{'quality'});\n\n\t    @points = $self->{o_trim}->trim_doublet\n                ($self->{'contigs'}->{$_}->{'consensus'},\n                 $self->{'contigs'}->{$_}->{'quality'},\n                 $self->{'contigs'}->{$_}->{name},\n                 $self->{'contigs'}->{$_}->{'class'});\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n            # now set this\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} =\n                substr($self->{contigs}->{$_}->{'consensus'},\n                       $points[0],$points[1]-$points[0]);\n\t    # 010102 the deprecated way to do things:\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Done setting doublet trim points.\\n\"); \n    return;\n} # end set_trim_points_doublets\n\n=head2 get_trimmed_sequence_by_name($name)\n\n Title   : get_trimmed_sequence_by_name($name)\n Usage   : $o_consed->get_trimmed_sequence_by_name($name);\n Function: Returns the trimmed_sequence of a contig with {name} eq $name.\n Returns : A scalar- the trimmed sequence.\n Args    : The {name} of a contig.\n Notes   : \n\n\nsub get_trimmed_sequence_by_name {\n    my ($self,$name) = @_;\n    my $trimmed_sequence;\n    my $contigname = &get_contig_number_by_name($self,$name);\n    my $class = $self->{'contigs'}->{$contigname}->{'class'};\n    # what is this business and who was smoking crack while writing this?\n    # if ($class eq \"singlet\") {\n    # send the sequence, the quality, and the name\n    # $trimmed_sequence = $self->{o_trim}->trim_singlet\n    #  ($self->{'contigs'}->{$contigname}->{consensus},\n    #   $self->{'contigs'}->{$contigname}->{'quality'},$name);\n    # }\n    return $self->{'contigs'}->{$contigname}->{'sequence_trimmed'};\n}\n\n=head2 set_dash_present_in_sequence_name(\"yes\")\n\n Title   : set_dash_present_in_sequence_name(\"yes\")\n Usage   : $o_consed->set_dash_present_in_sequence_name(\"yes\");\n Function: Deprecated. Part of an uncompleted thought. (\"Oooh! Shiny!\")\n Returns : Nothing.\n Args    : \"yes\" to set {dash_present_in_sequence_name} to 1\n Notes   : \n\n\nsub set_dash_present_in_sequence_name {\n    my ($self,$dash_present) = @_;\n    if ($dash_present eq \"yes\") {\n\t$self->{'dash_present_in_sequence_name'} = 1;\n    }\n    else {\n\t$self->{'dash_present_in_sequence_name'} = 0;\n    }\n    return $self->{'dash_present_in_sequence_name'};\n} # end set_dash_present_in_sequence_name\n\n=head2 set_doublets()\n\n Title   : set_doublets()\n Usage   : $o_consed->set_doublets();\n Function: Find pairs that have similar names and mark them as doublets\n\t   and set the {name}.\n Returns : 0 or 1.\n Args    : None.\n\nA complicated subroutine that iterates over the\nBio::Tools::Alignment::Consed looking for contigs of 2. If the forward\nand reverse designator are removed from each of the reads in\n{'member_array'} and the remaining reads are the same, {name} is set\nto that name and the contig's class is set as \"doublet\".  If any of\nthose cases fail the contig is marked as a \"pair\".\n\n\n#' make my emacs happy\n\nsub set_doublets {\n    my ($self) = @_;\n    # set the designators in the Bio::Tools::Alignment::Trim object\n\n    $self->{'o_trim'}->set_designators($self->{'reverse_designator'},\n\t\t\t\t       $self->{'forward_designator'});\n    foreach my $key_contig (sort keys %{$self->{'contigs'}}) {\n\n\t# if there is a member array (why would there not be? This should be a die()able offence\n\t# but for now I will leave it\n\tif ($self->{'contigs'}->{$key_contig}->{'member_array'}) {\n\t    # if there are two reads in this contig \n\t    # i am pretty sure that this is wrong but i am keeping it for reference\n\t    # if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2 || !$self->{'contigs'}->{$key_contig}->{'class'}) {\n\t    # <seconds later>\n\t    # <nod> WRONG. Was I on crack?\n\t    if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = 2;\n\t\t$self->debug(\"\\tThere are 2 members! Looking for the contig name...\\n\");\n\t\tmy $name = _get_contig_name($self,$self->{'contigs'}->{$key_contig}->{'member_array'});\n\t\t$self->debug(\"The name is $name\\n\") if defined $name;\n\t\tif ($name) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'name'} = $name;\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"doublet\";\n\t\t} else {\n\t\t    $self->debug(\"$key_contig is a pair.\\n\");\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"pair\";\n\t\t}\n\t    }\n            # this is all fair and good but what about singlets?\n            # they have one reads in the member_array but certainly are not singletons\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 1) {\n\t\t# set the name to be the name of the read\n\t\t$self->{'contigs'}->{$key_contig}->{name} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}}[0];\n\t\t# set the number of members to be one\n\t\t$self->{'contigs'}->{$key_contig}->{num_members} = 1;\n\t\t# if this was a singlet, it would already belong to the class \"singlet\"\n\t\t# so leave it alone\n\t\t# if it is not a singlet, it is a singleton! lablel it appropriately\n\t\tunless ($self->{'contigs'}->{$key_contig}->{'class'}) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"singleton\";\n\t\t}\n\t    }\n            # set the multiplet characteristics\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} >= 3) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\t\t$self->{'contigs'}->{$key_contig}->{'class'} = \"multiplet\";\n\t    }\n\t    $self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\n\t}\n    }\n    $self->{'doublets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end set_doublets\n\n=head2 set_singlets\n\n Title   : set_singlets\n Usage   : $o_consed->set_singlets();\n Function: Read in a singlets file and place them into the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : Nothing.\n Args    : A scalar to turn on verbose parsing of the singlets file.\n Notes   : \n\n\nsub set_singlets {\n    # parse out the contents of the singlets file\n    my ($self) = @_;\n    $self->debug(\"Bio::Tools::Alignment::Consed Adding singlets to the contig hash...\\n\"); \n    my $full_filename = $self->{'filename'};\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: \\$full_filename is $full_filename\\n\");\n    $full_filename =~ m/(.*\\/)(.*ace.*)$/; \t\t\t       \n    my ($base_path,$filename) = ($1,$2);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: singlets filename is $filename and \\$base_path is $base_path\\n\");\n    $filename =~ m/(.*)ace.*$/;\n    my $singletsfile = $base_path.$1.\"singlets\";\n    $self->debug(\"\\$singletsfile is $singletsfile\\n\");\n     if (!-f $singletsfile) {\n          # there is no singlets file.\n          $self->{'singlets_set'} = \"done\";\n          return;\n     }\n\t$self->debug(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    my $singlets_fh = Bio::Root::IO->new(-file => $singletsfile);\n    my ($sequence,$name,$count);\n    while ($_ = $singlets_fh->_readline()) {\n\tchomp $_;\n\tif (/\\>/) {\n\t    if ($name && $sequence) {\n\t\t$self->debug(\"Adding $name with sequence $sequence to hash...\\n\");\n\t\tpush @{$self->{'contigs'}->{$name}->{'member_array'}},$name;\n\t\t$self->{'contigs'}->{$name}->{'consensus'} = $sequence;\n\t\t$self->{'contigs'}->{$name}->{'name'} = $name;\n\t\t$self->{'contigs'}->{$name}->{\"singlet\"} = 1;\n\t\t$self->{'contigs'}->{$name}->{'class'} = \"singlet\";\n\t    }\n\t    $sequence = $name = undef;\n\t    $count++;\n\t    m/^\\>(.*)\\s\\sCHROMAT/;\n\t    $name = $1;\n\t    if (!$name) {\n\t\tm/\\>(\\S+)\\s/;\n\t\t$name = $1;\n\t    }\n\t}\n\telse { $sequence .= $_; }\t\n    }\n    if ($name && $sequence) {\n\t$self->debug(\"Pushing the last of the singlets ($name)\\n\");\n\t@{$self->{'contigs'}->{$name}->{'member_array'}} = $name;\n\t$self->{'contigs'}->{$name}->{'consensus'} = $sequence;\n\t$self->{'contigs'}->{$name}->{'name'} = $name;\n\t$self->{'contigs'}->{$name}->{\"singlet\"} = 1;\n\t$self->{'contigs'}->{$name}->{'class'} = \"singlet\";\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: Done adding singlets to the singlets hash.\\n\");\n    $self->{'singlets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end sub set_singlets\n\n=head2 get_singlets()\n\n Title   : get_singlets()\n Usage   : $o_consed->get_singlets();\n Function: Return the keynames of the singlets.\n Returns : An array containing the keynames of all \n           Bio::Tools::Alignment::Consed sequences in the class \"singlet\".\n Args    : None.\n Notes   : \n\n\nsub get_singlets {\n    # returns an array of singlet names\n    # singlets have \"singlet\"=1 in the hash\n    my $self = shift;\n    if (!$self->{singlets_set}) {\n\t$self->debug(\"You need to set the singlets before you get them. Doing that now.\");\n\t$self->set_singlets();\n    }\t\n\n    my (@singlets,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\t# @array = @{$Consed::contigs{$key}->{'member_array'}};\n\t# somethimes a user will try to get a list of singlets before the classes for the rest of the\n\t# contigs has been set (see t/test.t for how I figured this out. <bah>\t\t\t\n\t# so either way, just return class=singlets\n\tif (!$self->{'contigs'}->{$key}->{'class'}) {\n\t    # print(\"$key has no class. why?\\n\");\n\t}\n\telsif ($self->{'contigs'}->{$key}->{'class'} eq \"singlet\") {\n\t    push @singlets,$key;\n\t}\n    }\n    return @singlets;\n}\n\n=head2 set_quality_by_name($name,$quality)\n\n Title   : set_quality_by_name($name,$quality)\n Usage   : $o_consed->set_quality_by_name($name,$quality);\n Function: Deprecated. Make the contig with {name} have {'quality'} $quality.\n           Probably used for testing.\n Returns : Nothing.\n Args    : The name of a contig and a scalar for its quality.\n Notes   : Deprecated.\n\n\nsub set_quality_by_name {\n    # this is likely deprecated\n    my ($self,$name,$quality) = shift;\n    my $return;\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'} eq \"$name\" || $self->{'contigs'}->{'name'} eq \"$name\") {\n\t    $self->{'contigs'}->{'quality'} = $quality;\n\t    $return=1;\n\t}\n    }\n    if ($return) { return \"0\"; } else { return \"1\"; }\n}\t\t\t\t# end set quality by name\n\n=head2 set_singlet_quality()\n\n Title   : set_singlet_quality()\n Usage   : $o_consed->set_singlet_quality();\n Function: For each singlet, go to the appropriate file in phd_dir and read\n           in the phred quality for that read and place it into {'quality'}\n Returns : 0 or 1.\n Args    : None.\n Notes   : This is the next subroutine that will receive substantial revision\n           in the next little while. It really should eval the creation of\n           Bio::Tools::Alignment::Phred objects and go from there. \n\n\nsub set_singlet_quality {\n    my $self = shift;\n    my $full_filename = $self->{'filename'};\n    $full_filename =~ m/(.*\\/)(.*)ace.*$/;\n    my ($base_path,$filename) = ($1,\"$2\".\"qual\");\n    my $singletsfile = $base_path.$filename;\n    if (-f $singletsfile) {\n\t# print(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    }\n    else {\n\t$self->warn(\"$singletsfile is not a file. Sorry.\\n\");\n\treturn;\n    }\n\tmy $singlets_fh = Bio::Root::IO->new(-file => $singletsfile);\n\tmy ($sequence,$name,$count);\n    my ($identity,$line,$quality,@qline);\n    while ($line = $singlets_fh->_readline()) {\n\tchomp $line;\n\tif ($line =~ /^\\>/) {\n\t    $quality = undef;\n\t    $line =~ m/\\>(\\S*)\\s/;\n\t    $identity = $1;\n\t}\n\telse {\n\t    if ($self->{'contigs'}->{$identity}) {\n\t\t$self->{'contigs'}->{$identity}->{'quality'} .= \"$line \";\n\t    }\n\t}\n\n    }\n    return 0;\n}\n\n=head2 set_contig_quality()\n\n Title   : set_contig_quality()\n Usage   : $o_consed->set_contig_quality();\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n Notes   : Deprecated. Really. Trust me.\n\n\nsub set_contig_quality {\n    # note: contigs _include_ singletons but _not_ singlets\n    my ($self) = shift;\n          # the unexpected results I am referring to here are a doubling of quality values.\n          # the profanity I uttered on discovering this reminded me of the simpsons:\n          # Ned Flanders: \"That is the loudest profanity I have ever heard!\"\n     $self->warn(\"set_contig_quality is deprecated and will likely produce unexpected results\");\n    my $full_filename = $self->{'filename'};\n    # Run_SRC3700_2000-08-01_73+74.fasta.screen.contigs.qual\n    # from Consed.pm\n    $full_filename =~ m/(.*\\/)(.*)ace.*$/;\n    my ($base_path,$filename) = ($1,\"$2\".\"contigs.qual\");\n    my $singletsfile = $base_path.$filename;\n    if (-f $singletsfile) {\n\t# print(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    }\n    else {\n\t$self->warn(\"Bio::Tools::Alignment::Consed::set_contig_quality $singletsfile is not a file. Sorry.\\n\");\n\treturn;\n    }\n    my $contig_quality_fh = Bio::Root::IO->new(-file => $singletsfile);\n\n    my ($sequence,$name,$count,$identity,$line,$quality);\n    while ($line = $contig_quality_fh->_readline()) {\n\tchomp $line;\n\tif ($line =~ /^\\>/) {\n\t    $quality = undef;\n\t    $line =~ m/\\>.*Contig(\\d+)\\s/;\n\t    $identity = $1;\n\t}\n\telse {\n\t    if ($self->{'contigs'}->{$identity} ) {\n\t\t$self->{'contigs'}->{$identity}->{'quality'} .= \" $line\";\n\t    }\n\t}\n    }\n}\t\t\t\t# end set_contig_quality\n\n=head2 get_multiplets()\n\n Title   : get_multiplets()\n Usage   : $o_consed->get_multiplets();\n Function: Return the keynames of the multiplets.\n Returns : Returns an array containing the keynames of all \n           Bio::Tools::Alignment::Consed sequences in the class \"multiplet\".\n Args    : None.\n Notes   : \n\n\nsub get_multiplets {\n\t    # returns an array of multiplet names\n\t    # multiplets have # members > 2\n    my $self = shift;\n    my (@multiplets,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$key}->{'class'}) {\n\t    if ($self->{'contigs'}->{$key}->{'class'} eq \"multiplet\") {\n\t\tpush @multiplets,$key;\n\t    }\n\t}\n    }\n    return @multiplets;\n}\n\n=head2 get_all_members()\n\n  Title   : get_all_members()\n  Usage   : @all_members = $o_consed->get_all_members();\n  Function: Return a list of all of the read names in the \n            Bio::Tools::Alignment::Consed object.\n  Returns : An array containing all of the elements in all of the\n            {'member_array'}s.\n  Args    : None.\n  Notes   : \n\n\nsub get_all_members {\n    my $self = shift;\n    my @members;\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\tif ($key =~ /^singlet/) {\n\t    push @members,$self->{'contigs'}->{$key}->{'member_array'}[0];\n\t}\n\telsif ($self->{'contigs'}->{$key}->{'member_array'}) {\n\t    push @members,@{$self->{'contigs'}->{$key}->{'member_array'}};\n\t}\n\t# else {\n\t#\tprint(\"Bio::Tools::Alignment::Consed: $key is _not_ an array. Pushing $self->{'contigs'}->{$key}->{'member_array'} onto \\@members\\n\");\n\t#\tpush @members,$self->{'contigs'}->{$key}->{'member_array'};\n\t# }\n    }\n    return @members;\n}\n\n=head2 sum_lets($total_only)\n\n Title   : sum_lets($total_only)\n Usage   : $statistics = $o_consed->sum_lets($total_only);\n Function: Provide numbers for how many sequences were accounted for in the\n           Bio::Tools::Alignment::Consed object.\n Returns : If a scalar is present, returns the total number of\n           sequences accounted for in all classes. If no scalar passed\n           then returns a string that looks like this:\n           Singt/singn/doub/pair/mult/total : 2,0,1(2),0(0),0(0),4\n           This example means the following: There were 1 singlets.\n           There were 0 singletons.  There were 1 doublets for a total\n           of 2 sequences in this class.  There were 0 pairs for a\n           total of 0 sequences in this class.  There were 0\n           multiplets for a total of 0 sequences in this class.  There\n           were a total of 4 sequences accounted for in the\n           Bio::Tools::Alignment::Consed object.   \n Args : A scalar is optional to change the way the numbers are returned.  \n Notes:"},"line":1267,"kind":12,"range":{"start":{"line":1267,"character":0},"end":{"line":1289,"character":9999}},"definition":"sub","detail":"($self,$total_only)","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"sum_lets","line":1268},{"line":1268,"containerName":"sum_lets","kind":13,"name":"$total_only"},{"definition":"my","name":"$count","localvar":"my","containerName":"sum_lets","kind":13,"line":1269},{"line":1269,"name":"$count_multiplets","containerName":"sum_lets","kind":13},{"name":"$multiplet_count","kind":13,"containerName":"sum_lets","line":1269},{"definition":"my","name":"$singlets","containerName":"sum_lets","localvar":"my","kind":13,"line":1270},{"name":"$self","containerName":"sum_lets","kind":13,"line":1270},{"line":1270,"name":"$count","containerName":"sum_lets","kind":13},{"line":1270,"name":"$singlets","kind":13,"containerName":"sum_lets"},{"definition":"my","name":"$doublets","localvar":"my","containerName":"sum_lets","kind":13,"line":1271},{"line":1271,"kind":13,"containerName":"sum_lets","name":"$self"},{"line":1271,"containerName":"sum_lets","kind":13,"name":"$count"},{"line":1271,"containerName":"sum_lets","kind":13,"name":"$doublets"},{"definition":"my","kind":13,"localvar":"my","containerName":"sum_lets","name":"$pairs","line":1272},{"line":1272,"containerName":"sum_lets","kind":13,"name":"$self"},{"line":1272,"kind":13,"containerName":"sum_lets","name":"$count"},{"line":1272,"name":"$pairs","kind":13,"containerName":"sum_lets"},{"definition":"my","name":"$singletons","kind":13,"localvar":"my","containerName":"sum_lets","line":1273},{"line":1273,"containerName":"sum_lets","kind":13,"name":"$self"},{"line":1273,"name":"$count","containerName":"sum_lets","kind":13},{"name":"$singletons","kind":13,"containerName":"sum_lets","line":1273},{"name":"@multiplets","localvar":"my","containerName":"sum_lets","kind":13,"line":1274,"definition":"my"},{"containerName":"sum_lets","kind":13,"name":"$self","line":1274},{"line":1275,"kind":13,"containerName":"sum_lets","name":"$count_multiplets"},{"name":"@multiplets","containerName":"sum_lets","kind":13,"line":1275},{"definition":"my","line":1276,"kind":13,"localvar":"my","containerName":"sum_lets","name":"$return_string"},{"line":1277,"kind":13,"containerName":"sum_lets","name":"@multiplets"},{"definition":"my","containerName":"sum_lets","localvar":"my","kind":13,"name":"$number_members","line":1278},{"line":1278,"containerName":"sum_lets","kind":13,"name":"$self"},{"line":1279,"kind":13,"containerName":"sum_lets","name":"$multiplet_count"},{"line":1279,"name":"$number_members","containerName":"sum_lets","kind":13},{"line":1281,"name":"$multiplet_count","containerName":"sum_lets","kind":13},{"containerName":"sum_lets","kind":13,"name":"$count","line":1282},{"line":1282,"containerName":"sum_lets","kind":13,"name":"$multiplet_count"}],"containerName":"main::","name":"sum_lets"},{"name":"get_doublets","kind":12,"line":1271},{"name":"get_pairs","kind":12,"line":1272},{"line":1273,"name":"get_singletons","kind":12},{"line":1278,"kind":12,"name":"num_members"},{"line":1286,"name":"strict","kind":12},{"kind":13,"containerName":null,"name":"%multiplet_count","line":1291},{"name":"$multiplet_count","containerName":null,"kind":13,"line":1291},{"containerName":null,"kind":13,"name":"%total_only","line":1292},{"name":"$count","containerName":null,"kind":13,"line":1293},{"containerName":null,"kind":13,"name":"$return_string","line":1295},{"containerName":null,"kind":13,"name":"$doublets","line":1297},{"line":1297,"kind":13,"containerName":null,"name":"$pairs"},{"containerName":null,"kind":13,"name":"$return_string","line":1299},{"line":1322,"range":{"end":{"character":9999,"line":1335},"start":{"line":1322,"character":0}},"kind":12,"definition":"sub","children":[{"definition":"my","name":"$self","containerName":"write_stats","localvar":"my","kind":13,"line":1325},{"definition":"my","localvar":"my","kind":13,"containerName":"write_stats","name":"$stats_filename","line":1326},{"name":"$self","containerName":"write_stats","kind":13,"line":1326},{"containerName":"write_stats","localvar":"my","kind":13,"name":"$statistics_raw","line":1327,"definition":"my"},{"name":"$self","kind":13,"containerName":"write_stats","line":1327},{"kind":12,"containerName":"write_stats","name":"sum_lets","line":1327},{"containerName":"write_stats","localvar":"my","kind":13,"name":"$statsfilecontents","line":1328,"definition":"my"},{"containerName":"write_stats","kind":13,"name":"$statistics_raw","line":1328},{"definition":"my","name":"$fh","localvar":"my","containerName":"write_stats","kind":13,"line":1330},{"line":1330,"name":"new","containerName":"write_stats","kind":12},{"name":"$fh","containerName":"write_stats","kind":13,"line":1332},{"name":"_print","kind":12,"containerName":"write_stats","line":1332},{"line":1334,"name":"$fh","containerName":"write_stats","kind":13},{"name":"close","kind":12,"containerName":"write_stats","line":1334}],"containerName":"main::","name":"write_stats"},{"name":"Bio","containerName":"Root::IO","kind":12,"line":1330},{"kind":12,"range":{"start":{"character":0,"line":1349},"end":{"line":1354,"character":9999}},"line":1349,"definition":"sub","name":"get_singletons","containerName":"main::","children":[{"definition":"my","line":1352,"localvar":"my","kind":13,"containerName":"get_singletons","name":"$self"},{"definition":"my","line":1353,"containerName":"get_singletons","localvar":"my","kind":13,"name":"@singletons"},{"name":"@array","kind":13,"containerName":"get_singletons","line":1353},{"containerName":"get_singletons","localvar":"my","kind":13,"name":"$key","line":1354,"definition":"my"},{"name":"$self","kind":13,"containerName":"get_singletons","line":1354}]},{"name":"%self","containerName":null,"kind":13,"line":1355},{"line":1355,"name":"%key","kind":13,"containerName":null},{"line":1361,"containerName":null,"kind":13,"name":"%self"},{"containerName":null,"kind":13,"name":"%key","line":1361},{"containerName":null,"kind":13,"name":"@array","line":1362},{"name":"%self","kind":13,"containerName":null,"line":1362},{"line":1362,"containerName":null,"kind":13,"name":"%key"},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$num_array_elem","line":1364},{"name":"@array","kind":13,"containerName":null,"line":1364},{"line":1365,"containerName":null,"kind":13,"name":"$num_array_elem"},{"line":1365,"name":"%self","kind":13,"containerName":null},{"line":1365,"name":"%key","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%self","line":1365},{"line":1365,"name":"%key","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"@singletons","line":1365},{"containerName":null,"kind":13,"name":"$key","line":1365},{"kind":13,"containerName":null,"name":"@singletons","line":1367},{"name":"get_pairs","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"get_pairs","name":"$self","line":1385,"definition":"my"},{"kind":13,"localvar":"my","containerName":"get_pairs","name":"@pairs","line":1386,"definition":"my"},{"name":"@array","kind":13,"containerName":"get_pairs","line":1386},{"definition":"my","line":1387,"kind":13,"localvar":"my","containerName":"get_pairs","name":"$key"},{"containerName":"get_pairs","kind":13,"name":"$self","line":1387}],"definition":"sub","range":{"start":{"character":0,"line":1382},"end":{"character":9999,"line":1387}},"kind":12,"line":1382},{"line":1388,"kind":13,"containerName":null,"name":"%self"},{"name":"%key","kind":13,"containerName":null,"line":1388},{"name":"%self","containerName":null,"kind":13,"line":1389},{"line":1389,"kind":13,"containerName":null,"name":"%key"},{"line":1390,"name":"%self","containerName":null,"kind":13},{"line":1390,"name":"%key","kind":13,"containerName":null},{"line":1391,"name":"@pairs","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$key","line":1391},{"name":"@pairs","containerName":null,"kind":13,"line":1395},{"definition":"sub","detail":"($self,$contig)","children":[{"definition":"my","line":1410,"containerName":"get_name","localvar":"my","kind":13,"name":"$self"},{"name":"$contig","kind":13,"containerName":"get_name","line":1410},{"line":1411,"name":"$self","containerName":"get_name","kind":13},{"line":1411,"containerName":"get_name","kind":13,"name":"$contig"}],"containerName":"main::","name":"get_name","signature":{"label":"get_name($self,$contig)","documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_reverse_designator {\n    my ($self,$reverse_designator) = @_;\n    $self->{'reverse_designator'} = $reverse_designator;\n    $self->{'o_trim'}->set_reverse_designator($reverse_designator);\n    return $self->{'reverse_designator'};\n}\t\t\t\t# end set_reverse_designator\n\n=head2 set_forward_designator($some_string)\n\n Title   : set_forward_designator($some_string)\n Usage   : $o_consed->set_forward_designator($some_string);\n Function: Set the designator for the forward read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{forward_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_forward_designator {\n    my ($self,$forward_designator) = @_;\n    $self->{'forward_designator'} = $forward_designator;\n    $self->{'o_trim'}->set_forward_designator($forward_designator);\n    return $self->{'forward_designator'};\n}\t\t\t\t# end set_forward_designator\n\n=head2 set_designator_ignore_case(\"yes\")\n\n Title   : set_designator_ignore_case(\"yes\")\n Usage   : $o_consed->set_designator_ignore_case(\"yes\");\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n\nDeprecated. Really. Trust me.\n\n\nsub set_designator_ignore_case {\n    my ($self,$ignore_case) = @_;\n    if ($ignore_case eq \"yes\") {\n\t$self->{'designator_ignore_case'} = 1;\n    }\n    return $self->{'designator_ignore_case'};\n}\t\t\t\t# end set_designator_ignore_case\n\n=head2 set_trim_points_singlets_and_singletons()\n\n Title   : set_trim_points_singlets_and_singletons()\n Usage   : $o_consed->set_trim_points_singlets_and_singletons();\n Function: Set the trim points for singlets and singletons based on\n\t   quality.  Uses the Bio::Tools::Alignment::Trim object. Use\n\t   at your own risk because the Bio::Tools::Alignment::Trim\n\t   object was designed specifically for me and is mysterious\n\t   in its ways. Every time somebody other then me uses it a\n\t   swarm of locusts decends on a small Central American\n\t   village so do not say you weren't warned.\n Returns : Nothing.\n Args    : None.\n\nWorking on exceptions and warnings here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\n#' to make my emacs happy\n\nsub set_trim_points_singlets_and_singletons {\n    my ($self) = @_;\n    $self->debug(\"Consed.pm : \\$self is $self\\n\");\n    my (@points,$trimmed_sequence);\n    if (!$self->{'doublets_set'}) {\n        $self->debug(\"You need to set the doublets before you use \".\n                     \"set_trim_points_singlets_and_doublets. Doing that now.\");\n\t$self->set_doublets();\n    }\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"singlet\") {\n\t    $self->debug(\"Singlet $_\\n\");\n\t    # this is what Warehouse wants\n\t    #         my ($self,$sequence,$quality,$name) = @_;\n\t    # this is what Bio::Tools::Alignment::Trim::trim_singlet wants:\n\t    # my ($self,$sequence,$quality,$name,$class) = @_;\n\t    # the following several lines are to make the parameter passing legible.\n\t    my ($sequence,$quality,$name,$class);\n\t    $sequence = $self->{'contigs'}->{$_}->{'consensus'};\n\t    if (!$self->{'contigs'}->{$_}->{'quality'}) { $quality = \"unset\"; }\n\t    else { $quality = $self->{'contigs'}->{$_}->{'quality'}; }\n\t    $name = $self->{'contigs'}->{$_}->{'name'};\n\t    $class = $self->{'contigs'}->{$_}->{'class'};\n\t    @points = @{$self->{'o_trim'}->trim_singlet($sequence,$quality,$name,$class)};\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} = \n                substr($self->{contigs}->{$_}->{'consensus'},$points[0],$points[1]-$points[0]);\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_singlets\".\n                 \"_and_singletons: Done setting the quality trimpoints.\\n\");\n    return;\n}  # end set_trim_points_singlet\n\n=head2 set_trim_points_doublets()\n\n Title   : set_trim_points_doublets()\n Usage   : $o_consed->set_trim_points_doublets();\n Function: Set the trim points for doublets based on quality. Uses the\n\t   Bio::Tools::Alignment::Trim object. Use at your own risk because\n           the Bio::Tools::Alignment::Trim object was designed specifically\n           for me and is mysterious in its ways. Every time somebody other\n           then me uses it you risk a biblical plague being loosed on your\n           city.\n Returns : Nothing.\n Args    : None.\n Notes   : Working on exceptions here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\nsub set_trim_points_doublets {\n    my $self = shift;\n    my @points;\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Restoring zeros for doublets.\\n\");\n    # &show_missing_sequence($self);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Setting doublet trim points.\\n\");\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            # my ($self,$sequence,$quality,$name,$class) = @_;\n            my @quals = split(' ',$self->{'contigs'}->{$_}->{'quality'});\n\n\t    @points = $self->{o_trim}->trim_doublet\n                ($self->{'contigs'}->{$_}->{'consensus'},\n                 $self->{'contigs'}->{$_}->{'quality'},\n                 $self->{'contigs'}->{$_}->{name},\n                 $self->{'contigs'}->{$_}->{'class'});\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n            # now set this\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} =\n                substr($self->{contigs}->{$_}->{'consensus'},\n                       $points[0],$points[1]-$points[0]);\n\t    # 010102 the deprecated way to do things:\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Done setting doublet trim points.\\n\"); \n    return;\n} # end set_trim_points_doublets\n\n=head2 get_trimmed_sequence_by_name($name)\n\n Title   : get_trimmed_sequence_by_name($name)\n Usage   : $o_consed->get_trimmed_sequence_by_name($name);\n Function: Returns the trimmed_sequence of a contig with {name} eq $name.\n Returns : A scalar- the trimmed sequence.\n Args    : The {name} of a contig.\n Notes   : \n\n\nsub get_trimmed_sequence_by_name {\n    my ($self,$name) = @_;\n    my $trimmed_sequence;\n    my $contigname = &get_contig_number_by_name($self,$name);\n    my $class = $self->{'contigs'}->{$contigname}->{'class'};\n    # what is this business and who was smoking crack while writing this?\n    # if ($class eq \"singlet\") {\n    # send the sequence, the quality, and the name\n    # $trimmed_sequence = $self->{o_trim}->trim_singlet\n    #  ($self->{'contigs'}->{$contigname}->{consensus},\n    #   $self->{'contigs'}->{$contigname}->{'quality'},$name);\n    # }\n    return $self->{'contigs'}->{$contigname}->{'sequence_trimmed'};\n}\n\n=head2 set_dash_present_in_sequence_name(\"yes\")\n\n Title   : set_dash_present_in_sequence_name(\"yes\")\n Usage   : $o_consed->set_dash_present_in_sequence_name(\"yes\");\n Function: Deprecated. Part of an uncompleted thought. (\"Oooh! Shiny!\")\n Returns : Nothing.\n Args    : \"yes\" to set {dash_present_in_sequence_name} to 1\n Notes   : \n\n\nsub set_dash_present_in_sequence_name {\n    my ($self,$dash_present) = @_;\n    if ($dash_present eq \"yes\") {\n\t$self->{'dash_present_in_sequence_name'} = 1;\n    }\n    else {\n\t$self->{'dash_present_in_sequence_name'} = 0;\n    }\n    return $self->{'dash_present_in_sequence_name'};\n} # end set_dash_present_in_sequence_name\n\n=head2 set_doublets()\n\n Title   : set_doublets()\n Usage   : $o_consed->set_doublets();\n Function: Find pairs that have similar names and mark them as doublets\n\t   and set the {name}.\n Returns : 0 or 1.\n Args    : None.\n\nA complicated subroutine that iterates over the\nBio::Tools::Alignment::Consed looking for contigs of 2. If the forward\nand reverse designator are removed from each of the reads in\n{'member_array'} and the remaining reads are the same, {name} is set\nto that name and the contig's class is set as \"doublet\".  If any of\nthose cases fail the contig is marked as a \"pair\".\n\n\n#' make my emacs happy\n\nsub set_doublets {\n    my ($self) = @_;\n    # set the designators in the Bio::Tools::Alignment::Trim object\n\n    $self->{'o_trim'}->set_designators($self->{'reverse_designator'},\n\t\t\t\t       $self->{'forward_designator'});\n    foreach my $key_contig (sort keys %{$self->{'contigs'}}) {\n\n\t# if there is a member array (why would there not be? This should be a die()able offence\n\t# but for now I will leave it\n\tif ($self->{'contigs'}->{$key_contig}->{'member_array'}) {\n\t    # if there are two reads in this contig \n\t    # i am pretty sure that this is wrong but i am keeping it for reference\n\t    # if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2 || !$self->{'contigs'}->{$key_contig}->{'class'}) {\n\t    # <seconds later>\n\t    # <nod> WRONG. Was I on crack?\n\t    if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = 2;\n\t\t$self->debug(\"\\tThere are 2 members! Looking for the contig name...\\n\");\n\t\tmy $name = _get_contig_name($self,$self->{'contigs'}->{$key_contig}->{'member_array'});\n\t\t$self->debug(\"The name is $name\\n\") if defined $name;\n\t\tif ($name) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'name'} = $name;\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"doublet\";\n\t\t} else {\n\t\t    $self->debug(\"$key_contig is a pair.\\n\");\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"pair\";\n\t\t}\n\t    }\n            # this is all fair and good but what about singlets?\n            # they have one reads in the member_array but certainly are not singletons\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 1) {\n\t\t# set the name to be the name of the read\n\t\t$self->{'contigs'}->{$key_contig}->{name} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}}[0];\n\t\t# set the number of members to be one\n\t\t$self->{'contigs'}->{$key_contig}->{num_members} = 1;\n\t\t# if this was a singlet, it would already belong to the class \"singlet\"\n\t\t# so leave it alone\n\t\t# if it is not a singlet, it is a singleton! lablel it appropriately\n\t\tunless ($self->{'contigs'}->{$key_contig}->{'class'}) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"singleton\";\n\t\t}\n\t    }\n            # set the multiplet characteristics\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} >= 3) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\t\t$self->{'contigs'}->{$key_contig}->{'class'} = \"multiplet\";\n\t    }\n\t    $self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\n\t}\n    }\n    $self->{'doublets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end set_doublets\n\n=head2 set_singlets\n\n Title   : set_singlets\n Usage   : $o_consed->set_singlets();\n Function: Read in a singlets file and place them into the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : Nothing.\n Args    : A scalar to turn on verbose parsing of the singlets file.\n Notes   : \n\n\nsub set_singlets {\n    # parse out the contents of the singlets file\n    my ($self) = @_;\n    $self->debug(\"Bio::Tools::Alignment::Consed Adding singlets to the contig hash...\\n\"); \n    my $full_filename = $self->{'filename'};\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: \\$full_filename is $full_filename\\n\");\n    $full_filename =~ m/(.*\\/)(.*ace.*)$/; \t\t\t       \n    my ($base_path,$filename) = ($1,$2);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: singlets filename is $filename and \\$base_path is $base_path\\n\");\n    $filename =~ m/(.*)ace.*$/;\n    my $singletsfile = $base_path.$1.\"singlets\";\n    $self->debug(\"\\$singletsfile is $singletsfile\\n\");\n     if (!-f $singletsfile) {\n          # there is no singlets file.\n          $self->{'singlets_set'} = \"done\";\n          return;\n     }\n\t$self->debug(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    my $singlets_fh = Bio::Root::IO->new(-file => $singletsfile);\n    my ($sequence,$name,$count);\n    while ($_ = $singlets_fh->_readline()) {\n\tchomp $_;\n\tif (/\\>/) {\n\t    if ($name && $sequence) {\n\t\t$self->debug(\"Adding $name with sequence $sequence to hash...\\n\");\n\t\tpush @{$self->{'contigs'}->{$name}->{'member_array'}},$name;\n\t\t$self->{'contigs'}->{$name}->{'consensus'} = $sequence;\n\t\t$self->{'contigs'}->{$name}->{'name'} = $name;\n\t\t$self->{'contigs'}->{$name}->{\"singlet\"} = 1;\n\t\t$self->{'contigs'}->{$name}->{'class'} = \"singlet\";\n\t    }\n\t    $sequence = $name = undef;\n\t    $count++;\n\t    m/^\\>(.*)\\s\\sCHROMAT/;\n\t    $name = $1;\n\t    if (!$name) {\n\t\tm/\\>(\\S+)\\s/;\n\t\t$name = $1;\n\t    }\n\t}\n\telse { $sequence .= $_; }\t\n    }\n    if ($name && $sequence) {\n\t$self->debug(\"Pushing the last of the singlets ($name)\\n\");\n\t@{$self->{'contigs'}->{$name}->{'member_array'}} = $name;\n\t$self->{'contigs'}->{$name}->{'consensus'} = $sequence;\n\t$self->{'contigs'}->{$name}->{'name'} = $name;\n\t$self->{'contigs'}->{$name}->{\"singlet\"} = 1;\n\t$self->{'contigs'}->{$name}->{'class'} = \"singlet\";\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: Done adding singlets to the singlets hash.\\n\");\n    $self->{'singlets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end sub set_singlets\n\n=head2 get_singlets()\n\n Title   : get_singlets()\n Usage   : $o_consed->get_singlets();\n Function: Return the keynames of the singlets.\n Returns : An array containing the keynames of all \n           Bio::Tools::Alignment::Consed sequences in the class \"singlet\".\n Args    : None.\n Notes   : \n\n\nsub get_singlets {\n    # returns an array of singlet names\n    # singlets have \"singlet\"=1 in the hash\n    my $self = shift;\n    if (!$self->{singlets_set}) {\n\t$self->debug(\"You need to set the singlets before you get them. Doing that now.\");\n\t$self->set_singlets();\n    }\t\n\n    my (@singlets,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\t# @array = @{$Consed::contigs{$key}->{'member_array'}};\n\t# somethimes a user will try to get a list of singlets before the classes for the rest of the\n\t# contigs has been set (see t/test.t for how I figured this out. <bah>\t\t\t\n\t# so either way, just return class=singlets\n\tif (!$self->{'contigs'}->{$key}->{'class'}) {\n\t    # print(\"$key has no class. why?\\n\");\n\t}\n\telsif ($self->{'contigs'}->{$key}->{'class'} eq \"singlet\") {\n\t    push @singlets,$key;\n\t}\n    }\n    return @singlets;\n}\n\n=head2 set_quality_by_name($name,$quality)\n\n Title   : set_quality_by_name($name,$quality)\n Usage   : $o_consed->set_quality_by_name($name,$quality);\n Function: Deprecated. Make the contig with {name} have {'quality'} $quality.\n           Probably used for testing.\n Returns : Nothing.\n Args    : The name of a contig and a scalar for its quality.\n Notes   : Deprecated.\n\n\nsub set_quality_by_name {\n    # this is likely deprecated\n    my ($self,$name,$quality) = shift;\n    my $return;\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'} eq \"$name\" || $self->{'contigs'}->{'name'} eq \"$name\") {\n\t    $self->{'contigs'}->{'quality'} = $quality;\n\t    $return=1;\n\t}\n    }\n    if ($return) { return \"0\"; } else { return \"1\"; }\n}\t\t\t\t# end set quality by name\n\n=head2 set_singlet_quality()\n\n Title   : set_singlet_quality()\n Usage   : $o_consed->set_singlet_quality();\n Function: For each singlet, go to the appropriate file in phd_dir and read\n           in the phred quality for that read and place it into {'quality'}\n Returns : 0 or 1.\n Args    : None.\n Notes   : This is the next subroutine that will receive substantial revision\n           in the next little while. It really should eval the creation of\n           Bio::Tools::Alignment::Phred objects and go from there. \n\n\nsub set_singlet_quality {\n    my $self = shift;\n    my $full_filename = $self->{'filename'};\n    $full_filename =~ m/(.*\\/)(.*)ace.*$/;\n    my ($base_path,$filename) = ($1,\"$2\".\"qual\");\n    my $singletsfile = $base_path.$filename;\n    if (-f $singletsfile) {\n\t# print(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    }\n    else {\n\t$self->warn(\"$singletsfile is not a file. Sorry.\\n\");\n\treturn;\n    }\n\tmy $singlets_fh = Bio::Root::IO->new(-file => $singletsfile);\n\tmy ($sequence,$name,$count);\n    my ($identity,$line,$quality,@qline);\n    while ($line = $singlets_fh->_readline()) {\n\tchomp $line;\n\tif ($line =~ /^\\>/) {\n\t    $quality = undef;\n\t    $line =~ m/\\>(\\S*)\\s/;\n\t    $identity = $1;\n\t}\n\telse {\n\t    if ($self->{'contigs'}->{$identity}) {\n\t\t$self->{'contigs'}->{$identity}->{'quality'} .= \"$line \";\n\t    }\n\t}\n\n    }\n    return 0;\n}\n\n=head2 set_contig_quality()\n\n Title   : set_contig_quality()\n Usage   : $o_consed->set_contig_quality();\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n Notes   : Deprecated. Really. Trust me.\n\n\nsub set_contig_quality {\n    # note: contigs _include_ singletons but _not_ singlets\n    my ($self) = shift;\n          # the unexpected results I am referring to here are a doubling of quality values.\n          # the profanity I uttered on discovering this reminded me of the simpsons:\n          # Ned Flanders: \"That is the loudest profanity I have ever heard!\"\n     $self->warn(\"set_contig_quality is deprecated and will likely produce unexpected results\");\n    my $full_filename = $self->{'filename'};\n    # Run_SRC3700_2000-08-01_73+74.fasta.screen.contigs.qual\n    # from Consed.pm\n    $full_filename =~ m/(.*\\/)(.*)ace.*$/;\n    my ($base_path,$filename) = ($1,\"$2\".\"contigs.qual\");\n    my $singletsfile = $base_path.$filename;\n    if (-f $singletsfile) {\n\t# print(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    }\n    else {\n\t$self->warn(\"Bio::Tools::Alignment::Consed::set_contig_quality $singletsfile is not a file. Sorry.\\n\");\n\treturn;\n    }\n    my $contig_quality_fh = Bio::Root::IO->new(-file => $singletsfile);\n\n    my ($sequence,$name,$count,$identity,$line,$quality);\n    while ($line = $contig_quality_fh->_readline()) {\n\tchomp $line;\n\tif ($line =~ /^\\>/) {\n\t    $quality = undef;\n\t    $line =~ m/\\>.*Contig(\\d+)\\s/;\n\t    $identity = $1;\n\t}\n\telse {\n\t    if ($self->{'contigs'}->{$identity} ) {\n\t\t$self->{'contigs'}->{$identity}->{'quality'} .= \" $line\";\n\t    }\n\t}\n    }\n}\t\t\t\t# end set_contig_quality\n\n=head2 get_multiplets()\n\n Title   : get_multiplets()\n Usage   : $o_consed->get_multiplets();\n Function: Return the keynames of the multiplets.\n Returns : Returns an array containing the keynames of all \n           Bio::Tools::Alignment::Consed sequences in the class \"multiplet\".\n Args    : None.\n Notes   : \n\n\nsub get_multiplets {\n\t    # returns an array of multiplet names\n\t    # multiplets have # members > 2\n    my $self = shift;\n    my (@multiplets,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$key}->{'class'}) {\n\t    if ($self->{'contigs'}->{$key}->{'class'} eq \"multiplet\") {\n\t\tpush @multiplets,$key;\n\t    }\n\t}\n    }\n    return @multiplets;\n}\n\n=head2 get_all_members()\n\n  Title   : get_all_members()\n  Usage   : @all_members = $o_consed->get_all_members();\n  Function: Return a list of all of the read names in the \n            Bio::Tools::Alignment::Consed object.\n  Returns : An array containing all of the elements in all of the\n            {'member_array'}s.\n  Args    : None.\n  Notes   : \n\n\nsub get_all_members {\n    my $self = shift;\n    my @members;\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\tif ($key =~ /^singlet/) {\n\t    push @members,$self->{'contigs'}->{$key}->{'member_array'}[0];\n\t}\n\telsif ($self->{'contigs'}->{$key}->{'member_array'}) {\n\t    push @members,@{$self->{'contigs'}->{$key}->{'member_array'}};\n\t}\n\t# else {\n\t#\tprint(\"Bio::Tools::Alignment::Consed: $key is _not_ an array. Pushing $self->{'contigs'}->{$key}->{'member_array'} onto \\@members\\n\");\n\t#\tpush @members,$self->{'contigs'}->{$key}->{'member_array'};\n\t# }\n    }\n    return @members;\n}\n\n=head2 sum_lets($total_only)\n\n Title   : sum_lets($total_only)\n Usage   : $statistics = $o_consed->sum_lets($total_only);\n Function: Provide numbers for how many sequences were accounted for in the\n           Bio::Tools::Alignment::Consed object.\n Returns : If a scalar is present, returns the total number of\n           sequences accounted for in all classes. If no scalar passed\n           then returns a string that looks like this:\n           Singt/singn/doub/pair/mult/total : 2,0,1(2),0(0),0(0),4\n           This example means the following: There were 1 singlets.\n           There were 0 singletons.  There were 1 doublets for a total\n           of 2 sequences in this class.  There were 0 pairs for a\n           total of 0 sequences in this class.  There were 0\n           multiplets for a total of 0 sequences in this class.  There\n           were a total of 4 sequences accounted for in the\n           Bio::Tools::Alignment::Consed object.   \n Args : A scalar is optional to change the way the numbers are returned.  \n Notes:\n\n\nsub sum_lets {\n    my ($self,$total_only) = @_;\n    my ($count,$count_multiplets,$multiplet_count);\n    my $singlets = &get_singlets($self); $count += $singlets;\n    my $doublets = &get_doublets($self); $count += ($doublets * 2);\n    my $pairs = &get_pairs($self); $count += ($pairs * 2);\n    my $singletons = &get_singletons($self); $count += $singletons;\n    my @multiplets = &get_multiplets($self);\n    $count_multiplets = @multiplets;\n    my $return_string;\n    foreach (@multiplets) {\n\tmy $number_members = $self->{'contigs'}->{$_}->{num_members};\t\n\t$multiplet_count += $number_members;\n    }\n    if ($multiplet_count) {\n\t$count += $multiplet_count;\n    }\n    foreach (qw(multiplet_count singlets doublets pairs singletons\n                multiplets count_multiplets)) {\n\tno strict 'refs';\t# renege for the block\n\tif (!${$_}) {\n            ${$_} = 0;\n\t}\n    }\n    if (!$multiplet_count) { $multiplet_count = 0; }\n    if ($total_only) {\n        return $count;\n    }\n    $return_string = \"Singt/singn/doub/pair/mult/total : \".\n        \"$singlets,$singletons,$doublets(\".\n         ($doublets*2).\"),$pairs(\".($pairs*2).\n        \"),$count_multiplets($multiplet_count),$count\";\n    return $return_string;\n}\n\n=head2 write_stats()\n\n Title   : write_stats()\n Usage   : $o_consed->write_stats();\n Function: Write a file called \"statistics\" containing numbers similar to\n\t   those provided in sum_lets().\n Returns : Nothing. Write a file in $o_consed->{path} containing something\n\t   like this:\n\n           0,0,50(100),0(0),0(0),100\n\n           Where the numbers provided are in the format described in the\n\t   documentation for sum_lets().\n Args    : None.\n Notes   : This might break platform independence, I do not know.\n\nSee L<sum_lets()|sum_lets>\n\n\nsub write_stats {\n    # worry about platform dependence here?\n    # oh shucksdarn.\n    my $self = shift;\n    my $stats_filename = $self->{'path'}.\"statistics\";\n    my $statistics_raw = $self->sum_lets;\n    my ($statsfilecontents) = $statistics_raw =~ s/.*\\ \\:\\ //g;\n    umask 0001;\n    my $fh = Bio::Root::IO->new(-file=>\"$stats_filename\");\n    # open(STATSFILE,\">$stats_filename\") or print(\"Could not open the statsfile: $!\\n\");\n    $fh->_print(\"$statsfilecontents\");\n    # close STATSFILE;\n    $fh->close();\n}\n\n=head2 get_singletons()\n\n Title   : get_singletons()\n Usage   : @singletons = $o_consed->get_singletons();\n Function: Return the keynames of the singletons.\n Returns : Returns an array containing the keynames of all\n\t   Bio::Tools::Alignment::Consed sequences in the class \"singleton\".\n Args    : None.\n Notes   : \n\n\nsub get_singletons {\n\t\t# returns an array of singleton names\n\t\t# singletons are contigs with one member (see consed documentation)\n\tmy $self = shift;\n\tmy (@singletons,@array);\n\tforeach my $key (sort keys %{$self->{'contigs'}}) {\n\t\tif ($self->{'contigs'}->{$key}->{'class'}) {\n\t\t    # print (\"$key class: $self->{'contigs'}->{$key}->{'class'}\\n\");\n\t\t}\n\t\telse {\n\t\t    # print(\"$key belongs to no class. why?\\n\");\n\t\t}\n\t\tif ($self->{'contigs'}->{$key}->{'member_array'}) {\n\t\t\t@array = @{$self->{'contigs'}->{$key}->{'member_array'}};\n\t\t}\n\t\tmy $num_array_elem = @array;\n\t\tif ($num_array_elem == 1 && $self->{'contigs'}->{$key}->{'class'} && $self->{'contigs'}->{$key}->{'class'} eq \"singleton\") { push @singletons,$key; }\n\t}\n\treturn @singletons;\n}\n\n=head2 get_pairs()\n\n Title   : get_pairs()\n Usage   : @pairs = $o_consed->get_pairs();\n Function: Return the keynames of the pairs.\n Returns : Returns an array containing the keynames of all\n           Bio::Tools::Alignment::Consed sequences in the class \"pair\".\n Args    : None.\n Notes   : \n\n\nsub get_pairs {\n    # returns an array of pair contig names\n    # a pair is a contig of two where the names do not match\n    my $self = shift;\n    my (@pairs,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n        if ($self->{'contigs'}->{$key}->{'member_array'}) {\n            if (@{$self->{'contigs'}->{$key}->{'member_array'}} == 2 &&\n                $self->{'contigs'}->{$key}->{'class'} eq \"pair\") {\n                push @pairs,$key;\n            }\n        }\n    }\n    return @pairs;\n}\n\n=head2 get_name($contig_keyname)\n\n Title   : get_name($contig_keyname)\n Usage   : $name = $o_consed->get_name($contig_keyname);\n Function: Return the {name} for $contig_keyname.\n Returns : A string. ({name})\n Args    : A contig keyname.\n Notes   : ","parameters":[{"label":"$self"},{"label":"$contig"}]},"line":1409,"kind":12,"range":{"start":{"line":1409,"character":0},"end":{"line":1412,"character":9999}}},{"signature":{"label":"_get_contig_name($self,$r_array)","documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_reverse_designator {\n    my ($self,$reverse_designator) = @_;\n    $self->{'reverse_designator'} = $reverse_designator;\n    $self->{'o_trim'}->set_reverse_designator($reverse_designator);\n    return $self->{'reverse_designator'};\n}\t\t\t\t# end set_reverse_designator\n\n=head2 set_forward_designator($some_string)\n\n Title   : set_forward_designator($some_string)\n Usage   : $o_consed->set_forward_designator($some_string);\n Function: Set the designator for the forward read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{forward_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_forward_designator {\n    my ($self,$forward_designator) = @_;\n    $self->{'forward_designator'} = $forward_designator;\n    $self->{'o_trim'}->set_forward_designator($forward_designator);\n    return $self->{'forward_designator'};\n}\t\t\t\t# end set_forward_designator\n\n=head2 set_designator_ignore_case(\"yes\")\n\n Title   : set_designator_ignore_case(\"yes\")\n Usage   : $o_consed->set_designator_ignore_case(\"yes\");\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n\nDeprecated. Really. Trust me.\n\n\nsub set_designator_ignore_case {\n    my ($self,$ignore_case) = @_;\n    if ($ignore_case eq \"yes\") {\n\t$self->{'designator_ignore_case'} = 1;\n    }\n    return $self->{'designator_ignore_case'};\n}\t\t\t\t# end set_designator_ignore_case\n\n=head2 set_trim_points_singlets_and_singletons()\n\n Title   : set_trim_points_singlets_and_singletons()\n Usage   : $o_consed->set_trim_points_singlets_and_singletons();\n Function: Set the trim points for singlets and singletons based on\n\t   quality.  Uses the Bio::Tools::Alignment::Trim object. Use\n\t   at your own risk because the Bio::Tools::Alignment::Trim\n\t   object was designed specifically for me and is mysterious\n\t   in its ways. Every time somebody other then me uses it a\n\t   swarm of locusts decends on a small Central American\n\t   village so do not say you weren't warned.\n Returns : Nothing.\n Args    : None.\n\nWorking on exceptions and warnings here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\n#' to make my emacs happy\n\nsub set_trim_points_singlets_and_singletons {\n    my ($self) = @_;\n    $self->debug(\"Consed.pm : \\$self is $self\\n\");\n    my (@points,$trimmed_sequence);\n    if (!$self->{'doublets_set'}) {\n        $self->debug(\"You need to set the doublets before you use \".\n                     \"set_trim_points_singlets_and_doublets. Doing that now.\");\n\t$self->set_doublets();\n    }\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"singlet\") {\n\t    $self->debug(\"Singlet $_\\n\");\n\t    # this is what Warehouse wants\n\t    #         my ($self,$sequence,$quality,$name) = @_;\n\t    # this is what Bio::Tools::Alignment::Trim::trim_singlet wants:\n\t    # my ($self,$sequence,$quality,$name,$class) = @_;\n\t    # the following several lines are to make the parameter passing legible.\n\t    my ($sequence,$quality,$name,$class);\n\t    $sequence = $self->{'contigs'}->{$_}->{'consensus'};\n\t    if (!$self->{'contigs'}->{$_}->{'quality'}) { $quality = \"unset\"; }\n\t    else { $quality = $self->{'contigs'}->{$_}->{'quality'}; }\n\t    $name = $self->{'contigs'}->{$_}->{'name'};\n\t    $class = $self->{'contigs'}->{$_}->{'class'};\n\t    @points = @{$self->{'o_trim'}->trim_singlet($sequence,$quality,$name,$class)};\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} = \n                substr($self->{contigs}->{$_}->{'consensus'},$points[0],$points[1]-$points[0]);\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_singlets\".\n                 \"_and_singletons: Done setting the quality trimpoints.\\n\");\n    return;\n}  # end set_trim_points_singlet\n\n=head2 set_trim_points_doublets()\n\n Title   : set_trim_points_doublets()\n Usage   : $o_consed->set_trim_points_doublets();\n Function: Set the trim points for doublets based on quality. Uses the\n\t   Bio::Tools::Alignment::Trim object. Use at your own risk because\n           the Bio::Tools::Alignment::Trim object was designed specifically\n           for me and is mysterious in its ways. Every time somebody other\n           then me uses it you risk a biblical plague being loosed on your\n           city.\n Returns : Nothing.\n Args    : None.\n Notes   : Working on exceptions here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\nsub set_trim_points_doublets {\n    my $self = shift;\n    my @points;\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Restoring zeros for doublets.\\n\");\n    # &show_missing_sequence($self);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Setting doublet trim points.\\n\");\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            # my ($self,$sequence,$quality,$name,$class) = @_;\n            my @quals = split(' ',$self->{'contigs'}->{$_}->{'quality'});\n\n\t    @points = $self->{o_trim}->trim_doublet\n                ($self->{'contigs'}->{$_}->{'consensus'},\n                 $self->{'contigs'}->{$_}->{'quality'},\n                 $self->{'contigs'}->{$_}->{name},\n                 $self->{'contigs'}->{$_}->{'class'});\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n            # now set this\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} =\n                substr($self->{contigs}->{$_}->{'consensus'},\n                       $points[0],$points[1]-$points[0]);\n\t    # 010102 the deprecated way to do things:\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Done setting doublet trim points.\\n\"); \n    return;\n} # end set_trim_points_doublets\n\n=head2 get_trimmed_sequence_by_name($name)\n\n Title   : get_trimmed_sequence_by_name($name)\n Usage   : $o_consed->get_trimmed_sequence_by_name($name);\n Function: Returns the trimmed_sequence of a contig with {name} eq $name.\n Returns : A scalar- the trimmed sequence.\n Args    : The {name} of a contig.\n Notes   : \n\n\nsub get_trimmed_sequence_by_name {\n    my ($self,$name) = @_;\n    my $trimmed_sequence;\n    my $contigname = &get_contig_number_by_name($self,$name);\n    my $class = $self->{'contigs'}->{$contigname}->{'class'};\n    # what is this business and who was smoking crack while writing this?\n    # if ($class eq \"singlet\") {\n    # send the sequence, the quality, and the name\n    # $trimmed_sequence = $self->{o_trim}->trim_singlet\n    #  ($self->{'contigs'}->{$contigname}->{consensus},\n    #   $self->{'contigs'}->{$contigname}->{'quality'},$name);\n    # }\n    return $self->{'contigs'}->{$contigname}->{'sequence_trimmed'};\n}\n\n=head2 set_dash_present_in_sequence_name(\"yes\")\n\n Title   : set_dash_present_in_sequence_name(\"yes\")\n Usage   : $o_consed->set_dash_present_in_sequence_name(\"yes\");\n Function: Deprecated. Part of an uncompleted thought. (\"Oooh! Shiny!\")\n Returns : Nothing.\n Args    : \"yes\" to set {dash_present_in_sequence_name} to 1\n Notes   : \n\n\nsub set_dash_present_in_sequence_name {\n    my ($self,$dash_present) = @_;\n    if ($dash_present eq \"yes\") {\n\t$self->{'dash_present_in_sequence_name'} = 1;\n    }\n    else {\n\t$self->{'dash_present_in_sequence_name'} = 0;\n    }\n    return $self->{'dash_present_in_sequence_name'};\n} # end set_dash_present_in_sequence_name\n\n=head2 set_doublets()\n\n Title   : set_doublets()\n Usage   : $o_consed->set_doublets();\n Function: Find pairs that have similar names and mark them as doublets\n\t   and set the {name}.\n Returns : 0 or 1.\n Args    : None.\n\nA complicated subroutine that iterates over the\nBio::Tools::Alignment::Consed looking for contigs of 2. If the forward\nand reverse designator are removed from each of the reads in\n{'member_array'} and the remaining reads are the same, {name} is set\nto that name and the contig's class is set as \"doublet\".  If any of\nthose cases fail the contig is marked as a \"pair\".\n\n\n#' make my emacs happy\n\nsub set_doublets {\n    my ($self) = @_;\n    # set the designators in the Bio::Tools::Alignment::Trim object\n\n    $self->{'o_trim'}->set_designators($self->{'reverse_designator'},\n\t\t\t\t       $self->{'forward_designator'});\n    foreach my $key_contig (sort keys %{$self->{'contigs'}}) {\n\n\t# if there is a member array (why would there not be? This should be a die()able offence\n\t# but for now I will leave it\n\tif ($self->{'contigs'}->{$key_contig}->{'member_array'}) {\n\t    # if there are two reads in this contig \n\t    # i am pretty sure that this is wrong but i am keeping it for reference\n\t    # if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2 || !$self->{'contigs'}->{$key_contig}->{'class'}) {\n\t    # <seconds later>\n\t    # <nod> WRONG. Was I on crack?\n\t    if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = 2;\n\t\t$self->debug(\"\\tThere are 2 members! Looking for the contig name...\\n\");\n\t\tmy $name = _get_contig_name($self,$self->{'contigs'}->{$key_contig}->{'member_array'});\n\t\t$self->debug(\"The name is $name\\n\") if defined $name;\n\t\tif ($name) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'name'} = $name;\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"doublet\";\n\t\t} else {\n\t\t    $self->debug(\"$key_contig is a pair.\\n\");\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"pair\";\n\t\t}\n\t    }\n            # this is all fair and good but what about singlets?\n            # they have one reads in the member_array but certainly are not singletons\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 1) {\n\t\t# set the name to be the name of the read\n\t\t$self->{'contigs'}->{$key_contig}->{name} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}}[0];\n\t\t# set the number of members to be one\n\t\t$self->{'contigs'}->{$key_contig}->{num_members} = 1;\n\t\t# if this was a singlet, it would already belong to the class \"singlet\"\n\t\t# so leave it alone\n\t\t# if it is not a singlet, it is a singleton! lablel it appropriately\n\t\tunless ($self->{'contigs'}->{$key_contig}->{'class'}) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"singleton\";\n\t\t}\n\t    }\n            # set the multiplet characteristics\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} >= 3) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\t\t$self->{'contigs'}->{$key_contig}->{'class'} = \"multiplet\";\n\t    }\n\t    $self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\n\t}\n    }\n    $self->{'doublets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end set_doublets\n\n=head2 set_singlets\n\n Title   : set_singlets\n Usage   : $o_consed->set_singlets();\n Function: Read in a singlets file and place them into the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : Nothing.\n Args    : A scalar to turn on verbose parsing of the singlets file.\n Notes   : \n\n\nsub set_singlets {\n    # parse out the contents of the singlets file\n    my ($self) = @_;\n    $self->debug(\"Bio::Tools::Alignment::Consed Adding singlets to the contig hash...\\n\"); \n    my $full_filename = $self->{'filename'};\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: \\$full_filename is $full_filename\\n\");\n    $full_filename =~ m/(.*\\/)(.*ace.*)$/; \t\t\t       \n    my ($base_path,$filename) = ($1,$2);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: singlets filename is $filename and \\$base_path is $base_path\\n\");\n    $filename =~ m/(.*)ace.*$/;\n    my $singletsfile = $base_path.$1.\"singlets\";\n    $self->debug(\"\\$singletsfile is $singletsfile\\n\");\n     if (!-f $singletsfile) {\n          # there is no singlets file.\n          $self->{'singlets_set'} = \"done\";\n          return;\n     }\n\t$self->debug(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    my $singlets_fh = Bio::Root::IO->new(-file => $singletsfile);\n    my ($sequence,$name,$count);\n    while ($_ = $singlets_fh->_readline()) {\n\tchomp $_;\n\tif (/\\>/) {\n\t    if ($name && $sequence) {\n\t\t$self->debug(\"Adding $name with sequence $sequence to hash...\\n\");\n\t\tpush @{$self->{'contigs'}->{$name}->{'member_array'}},$name;\n\t\t$self->{'contigs'}->{$name}->{'consensus'} = $sequence;\n\t\t$self->{'contigs'}->{$name}->{'name'} = $name;\n\t\t$self->{'contigs'}->{$name}->{\"singlet\"} = 1;\n\t\t$self->{'contigs'}->{$name}->{'class'} = \"singlet\";\n\t    }\n\t    $sequence = $name = undef;\n\t    $count++;\n\t    m/^\\>(.*)\\s\\sCHROMAT/;\n\t    $name = $1;\n\t    if (!$name) {\n\t\tm/\\>(\\S+)\\s/;\n\t\t$name = $1;\n\t    }\n\t}\n\telse { $sequence .= $_; }\t\n    }\n    if ($name && $sequence) {\n\t$self->debug(\"Pushing the last of the singlets ($name)\\n\");\n\t@{$self->{'contigs'}->{$name}->{'member_array'}} = $name;\n\t$self->{'contigs'}->{$name}->{'consensus'} = $sequence;\n\t$self->{'contigs'}->{$name}->{'name'} = $name;\n\t$self->{'contigs'}->{$name}->{\"singlet\"} = 1;\n\t$self->{'contigs'}->{$name}->{'class'} = \"singlet\";\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: Done adding singlets to the singlets hash.\\n\");\n    $self->{'singlets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end sub set_singlets\n\n=head2 get_singlets()\n\n Title   : get_singlets()\n Usage   : $o_consed->get_singlets();\n Function: Return the keynames of the singlets.\n Returns : An array containing the keynames of all \n           Bio::Tools::Alignment::Consed sequences in the class \"singlet\".\n Args    : None.\n Notes   : \n\n\nsub get_singlets {\n    # returns an array of singlet names\n    # singlets have \"singlet\"=1 in the hash\n    my $self = shift;\n    if (!$self->{singlets_set}) {\n\t$self->debug(\"You need to set the singlets before you get them. Doing that now.\");\n\t$self->set_singlets();\n    }\t\n\n    my (@singlets,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\t# @array = @{$Consed::contigs{$key}->{'member_array'}};\n\t# somethimes a user will try to get a list of singlets before the classes for the rest of the\n\t# contigs has been set (see t/test.t for how I figured this out. <bah>\t\t\t\n\t# so either way, just return class=singlets\n\tif (!$self->{'contigs'}->{$key}->{'class'}) {\n\t    # print(\"$key has no class. why?\\n\");\n\t}\n\telsif ($self->{'contigs'}->{$key}->{'class'} eq \"singlet\") {\n\t    push @singlets,$key;\n\t}\n    }\n    return @singlets;\n}\n\n=head2 set_quality_by_name($name,$quality)\n\n Title   : set_quality_by_name($name,$quality)\n Usage   : $o_consed->set_quality_by_name($name,$quality);\n Function: Deprecated. Make the contig with {name} have {'quality'} $quality.\n           Probably used for testing.\n Returns : Nothing.\n Args    : The name of a contig and a scalar for its quality.\n Notes   : Deprecated.\n\n\nsub set_quality_by_name {\n    # this is likely deprecated\n    my ($self,$name,$quality) = shift;\n    my $return;\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'} eq \"$name\" || $self->{'contigs'}->{'name'} eq \"$name\") {\n\t    $self->{'contigs'}->{'quality'} = $quality;\n\t    $return=1;\n\t}\n    }\n    if ($return) { return \"0\"; } else { return \"1\"; }\n}\t\t\t\t# end set quality by name\n\n=head2 set_singlet_quality()\n\n Title   : set_singlet_quality()\n Usage   : $o_consed->set_singlet_quality();\n Function: For each singlet, go to the appropriate file in phd_dir and read\n           in the phred quality for that read and place it into {'quality'}\n Returns : 0 or 1.\n Args    : None.\n Notes   : This is the next subroutine that will receive substantial revision\n           in the next little while. It really should eval the creation of\n           Bio::Tools::Alignment::Phred objects and go from there. \n\n\nsub set_singlet_quality {\n    my $self = shift;\n    my $full_filename = $self->{'filename'};\n    $full_filename =~ m/(.*\\/)(.*)ace.*$/;\n    my ($base_path,$filename) = ($1,\"$2\".\"qual\");\n    my $singletsfile = $base_path.$filename;\n    if (-f $singletsfile) {\n\t# print(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    }\n    else {\n\t$self->warn(\"$singletsfile is not a file. Sorry.\\n\");\n\treturn;\n    }\n\tmy $singlets_fh = Bio::Root::IO->new(-file => $singletsfile);\n\tmy ($sequence,$name,$count);\n    my ($identity,$line,$quality,@qline);\n    while ($line = $singlets_fh->_readline()) {\n\tchomp $line;\n\tif ($line =~ /^\\>/) {\n\t    $quality = undef;\n\t    $line =~ m/\\>(\\S*)\\s/;\n\t    $identity = $1;\n\t}\n\telse {\n\t    if ($self->{'contigs'}->{$identity}) {\n\t\t$self->{'contigs'}->{$identity}->{'quality'} .= \"$line \";\n\t    }\n\t}\n\n    }\n    return 0;\n}\n\n=head2 set_contig_quality()\n\n Title   : set_contig_quality()\n Usage   : $o_consed->set_contig_quality();\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n Notes   : Deprecated. Really. Trust me.\n\n\nsub set_contig_quality {\n    # note: contigs _include_ singletons but _not_ singlets\n    my ($self) = shift;\n          # the unexpected results I am referring to here are a doubling of quality values.\n          # the profanity I uttered on discovering this reminded me of the simpsons:\n          # Ned Flanders: \"That is the loudest profanity I have ever heard!\"\n     $self->warn(\"set_contig_quality is deprecated and will likely produce unexpected results\");\n    my $full_filename = $self->{'filename'};\n    # Run_SRC3700_2000-08-01_73+74.fasta.screen.contigs.qual\n    # from Consed.pm\n    $full_filename =~ m/(.*\\/)(.*)ace.*$/;\n    my ($base_path,$filename) = ($1,\"$2\".\"contigs.qual\");\n    my $singletsfile = $base_path.$filename;\n    if (-f $singletsfile) {\n\t# print(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    }\n    else {\n\t$self->warn(\"Bio::Tools::Alignment::Consed::set_contig_quality $singletsfile is not a file. Sorry.\\n\");\n\treturn;\n    }\n    my $contig_quality_fh = Bio::Root::IO->new(-file => $singletsfile);\n\n    my ($sequence,$name,$count,$identity,$line,$quality);\n    while ($line = $contig_quality_fh->_readline()) {\n\tchomp $line;\n\tif ($line =~ /^\\>/) {\n\t    $quality = undef;\n\t    $line =~ m/\\>.*Contig(\\d+)\\s/;\n\t    $identity = $1;\n\t}\n\telse {\n\t    if ($self->{'contigs'}->{$identity} ) {\n\t\t$self->{'contigs'}->{$identity}->{'quality'} .= \" $line\";\n\t    }\n\t}\n    }\n}\t\t\t\t# end set_contig_quality\n\n=head2 get_multiplets()\n\n Title   : get_multiplets()\n Usage   : $o_consed->get_multiplets();\n Function: Return the keynames of the multiplets.\n Returns : Returns an array containing the keynames of all \n           Bio::Tools::Alignment::Consed sequences in the class \"multiplet\".\n Args    : None.\n Notes   : \n\n\nsub get_multiplets {\n\t    # returns an array of multiplet names\n\t    # multiplets have # members > 2\n    my $self = shift;\n    my (@multiplets,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$key}->{'class'}) {\n\t    if ($self->{'contigs'}->{$key}->{'class'} eq \"multiplet\") {\n\t\tpush @multiplets,$key;\n\t    }\n\t}\n    }\n    return @multiplets;\n}\n\n=head2 get_all_members()\n\n  Title   : get_all_members()\n  Usage   : @all_members = $o_consed->get_all_members();\n  Function: Return a list of all of the read names in the \n            Bio::Tools::Alignment::Consed object.\n  Returns : An array containing all of the elements in all of the\n            {'member_array'}s.\n  Args    : None.\n  Notes   : \n\n\nsub get_all_members {\n    my $self = shift;\n    my @members;\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\tif ($key =~ /^singlet/) {\n\t    push @members,$self->{'contigs'}->{$key}->{'member_array'}[0];\n\t}\n\telsif ($self->{'contigs'}->{$key}->{'member_array'}) {\n\t    push @members,@{$self->{'contigs'}->{$key}->{'member_array'}};\n\t}\n\t# else {\n\t#\tprint(\"Bio::Tools::Alignment::Consed: $key is _not_ an array. Pushing $self->{'contigs'}->{$key}->{'member_array'} onto \\@members\\n\");\n\t#\tpush @members,$self->{'contigs'}->{$key}->{'member_array'};\n\t# }\n    }\n    return @members;\n}\n\n=head2 sum_lets($total_only)\n\n Title   : sum_lets($total_only)\n Usage   : $statistics = $o_consed->sum_lets($total_only);\n Function: Provide numbers for how many sequences were accounted for in the\n           Bio::Tools::Alignment::Consed object.\n Returns : If a scalar is present, returns the total number of\n           sequences accounted for in all classes. If no scalar passed\n           then returns a string that looks like this:\n           Singt/singn/doub/pair/mult/total : 2,0,1(2),0(0),0(0),4\n           This example means the following: There were 1 singlets.\n           There were 0 singletons.  There were 1 doublets for a total\n           of 2 sequences in this class.  There were 0 pairs for a\n           total of 0 sequences in this class.  There were 0\n           multiplets for a total of 0 sequences in this class.  There\n           were a total of 4 sequences accounted for in the\n           Bio::Tools::Alignment::Consed object.   \n Args : A scalar is optional to change the way the numbers are returned.  \n Notes:\n\n\nsub sum_lets {\n    my ($self,$total_only) = @_;\n    my ($count,$count_multiplets,$multiplet_count);\n    my $singlets = &get_singlets($self); $count += $singlets;\n    my $doublets = &get_doublets($self); $count += ($doublets * 2);\n    my $pairs = &get_pairs($self); $count += ($pairs * 2);\n    my $singletons = &get_singletons($self); $count += $singletons;\n    my @multiplets = &get_multiplets($self);\n    $count_multiplets = @multiplets;\n    my $return_string;\n    foreach (@multiplets) {\n\tmy $number_members = $self->{'contigs'}->{$_}->{num_members};\t\n\t$multiplet_count += $number_members;\n    }\n    if ($multiplet_count) {\n\t$count += $multiplet_count;\n    }\n    foreach (qw(multiplet_count singlets doublets pairs singletons\n                multiplets count_multiplets)) {\n\tno strict 'refs';\t# renege for the block\n\tif (!${$_}) {\n            ${$_} = 0;\n\t}\n    }\n    if (!$multiplet_count) { $multiplet_count = 0; }\n    if ($total_only) {\n        return $count;\n    }\n    $return_string = \"Singt/singn/doub/pair/mult/total : \".\n        \"$singlets,$singletons,$doublets(\".\n         ($doublets*2).\"),$pairs(\".($pairs*2).\n        \"),$count_multiplets($multiplet_count),$count\";\n    return $return_string;\n}\n\n=head2 write_stats()\n\n Title   : write_stats()\n Usage   : $o_consed->write_stats();\n Function: Write a file called \"statistics\" containing numbers similar to\n\t   those provided in sum_lets().\n Returns : Nothing. Write a file in $o_consed->{path} containing something\n\t   like this:\n\n           0,0,50(100),0(0),0(0),100\n\n           Where the numbers provided are in the format described in the\n\t   documentation for sum_lets().\n Args    : None.\n Notes   : This might break platform independence, I do not know.\n\nSee L<sum_lets()|sum_lets>\n\n\nsub write_stats {\n    # worry about platform dependence here?\n    # oh shucksdarn.\n    my $self = shift;\n    my $stats_filename = $self->{'path'}.\"statistics\";\n    my $statistics_raw = $self->sum_lets;\n    my ($statsfilecontents) = $statistics_raw =~ s/.*\\ \\:\\ //g;\n    umask 0001;\n    my $fh = Bio::Root::IO->new(-file=>\"$stats_filename\");\n    # open(STATSFILE,\">$stats_filename\") or print(\"Could not open the statsfile: $!\\n\");\n    $fh->_print(\"$statsfilecontents\");\n    # close STATSFILE;\n    $fh->close();\n}\n\n=head2 get_singletons()\n\n Title   : get_singletons()\n Usage   : @singletons = $o_consed->get_singletons();\n Function: Return the keynames of the singletons.\n Returns : Returns an array containing the keynames of all\n\t   Bio::Tools::Alignment::Consed sequences in the class \"singleton\".\n Args    : None.\n Notes   : \n\n\nsub get_singletons {\n\t\t# returns an array of singleton names\n\t\t# singletons are contigs with one member (see consed documentation)\n\tmy $self = shift;\n\tmy (@singletons,@array);\n\tforeach my $key (sort keys %{$self->{'contigs'}}) {\n\t\tif ($self->{'contigs'}->{$key}->{'class'}) {\n\t\t    # print (\"$key class: $self->{'contigs'}->{$key}->{'class'}\\n\");\n\t\t}\n\t\telse {\n\t\t    # print(\"$key belongs to no class. why?\\n\");\n\t\t}\n\t\tif ($self->{'contigs'}->{$key}->{'member_array'}) {\n\t\t\t@array = @{$self->{'contigs'}->{$key}->{'member_array'}};\n\t\t}\n\t\tmy $num_array_elem = @array;\n\t\tif ($num_array_elem == 1 && $self->{'contigs'}->{$key}->{'class'} && $self->{'contigs'}->{$key}->{'class'} eq \"singleton\") { push @singletons,$key; }\n\t}\n\treturn @singletons;\n}\n\n=head2 get_pairs()\n\n Title   : get_pairs()\n Usage   : @pairs = $o_consed->get_pairs();\n Function: Return the keynames of the pairs.\n Returns : Returns an array containing the keynames of all\n           Bio::Tools::Alignment::Consed sequences in the class \"pair\".\n Args    : None.\n Notes   : \n\n\nsub get_pairs {\n    # returns an array of pair contig names\n    # a pair is a contig of two where the names do not match\n    my $self = shift;\n    my (@pairs,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n        if ($self->{'contigs'}->{$key}->{'member_array'}) {\n            if (@{$self->{'contigs'}->{$key}->{'member_array'}} == 2 &&\n                $self->{'contigs'}->{$key}->{'class'} eq \"pair\") {\n                push @pairs,$key;\n            }\n        }\n    }\n    return @pairs;\n}\n\n=head2 get_name($contig_keyname)\n\n Title   : get_name($contig_keyname)\n Usage   : $name = $o_consed->get_name($contig_keyname);\n Function: Return the {name} for $contig_keyname.\n Returns : A string. ({name})\n Args    : A contig keyname.\n Notes   : \n\n\nsub get_name {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'name'};\n}\n\n=head2 _get_contig_name(\\@array_containing_reads)\n\n Title   : _get_contig_name(\\@array_containing_reads)\n Usage   : $o_consed->_get_contig_name(\\@array_containing_reads);\n Function: The logic for the set_doublets subroutine.\n Returns : The name for this contig.\n Args    : A reference to an array containing read names.\n Notes   : Depends on reverse_designator. Be sure this is set the way you\n\t   intend.","parameters":[{"label":"$self"},{"label":"$r_array"}]},"range":{"start":{"line":1426,"character":0},"end":{"line":1468,"character":9999}},"kind":12,"line":1426,"detail":"($self,$r_array)","definition":"sub","name":"_get_contig_name","containerName":"main::","children":[{"line":1427,"containerName":"_get_contig_name","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":1427,"kind":13,"containerName":"_get_contig_name","name":"$r_array"},{"line":1428,"name":"@contig_members","kind":13,"localvar":"my","containerName":"_get_contig_name","definition":"my"},{"line":1428,"kind":13,"containerName":"_get_contig_name","name":"$r_array"},{"containerName":"_get_contig_name","localvar":"my","kind":13,"name":"@name_nodir","line":1429,"definition":"my"},{"line":1430,"name":"@contig_members","kind":13,"containerName":"_get_contig_name"},{"definition":"my","localvar":"my","containerName":"_get_contig_name","kind":13,"name":"$forward_designator","line":1434},{"containerName":"_get_contig_name","kind":13,"name":"$self","line":1434},{"definition":"my","name":"$reverse_designator","localvar":"my","containerName":"_get_contig_name","kind":13,"line":1435},{"containerName":"_get_contig_name","kind":13,"name":"$self","line":1435},{"line":1436,"name":"$any_hits","kind":13,"localvar":"my","containerName":"_get_contig_name","definition":"my"},{"name":"$name","localvar":"my","containerName":"_get_contig_name","kind":13,"line":1437,"definition":"my"},{"line":1438,"localvar":"my","kind":13,"containerName":"_get_contig_name","name":"$suffix","definition":"my"},{"name":"$name","kind":13,"containerName":"_get_contig_name","line":1439},{"kind":13,"containerName":"_get_contig_name","name":"$suffix","line":1442},{"line":1446,"name":"$suffix","kind":13,"containerName":"_get_contig_name"},{"line":1447,"containerName":"_get_contig_name","kind":13,"name":"$suffix"},{"kind":13,"containerName":"_get_contig_name","name":"$suffix","line":1447},{"line":1448,"kind":13,"containerName":"_get_contig_name","name":"@name_nodir"},{"name":"$name","kind":13,"containerName":"_get_contig_name","line":1448},{"line":1452,"kind":13,"containerName":"_get_contig_name","name":"@name_nodir"},{"line":1457,"name":"$mismatch","localvar":"my","containerName":"_get_contig_name","kind":13,"definition":"my"},{"line":1458,"localvar":"my","kind":13,"containerName":"_get_contig_name","name":"$counter","definition":"my"},{"kind":13,"containerName":"_get_contig_name","name":"$counter","line":1458},{"line":1458,"name":"@name_nodir","containerName":"_get_contig_name","kind":13},{"name":"$counter","kind":13,"containerName":"_get_contig_name","line":1458},{"kind":13,"containerName":"_get_contig_name","name":"$name_nodir","line":1459},{"name":"$name_nodir","containerName":"_get_contig_name","kind":13,"line":1459},{"line":1459,"name":"$counter","containerName":"_get_contig_name","kind":13},{"line":1460,"kind":13,"containerName":"_get_contig_name","name":"$mismatch"},{"containerName":"_get_contig_name","kind":13,"name":"$mismatch","line":1462},{"line":1464,"containerName":"_get_contig_name","kind":13,"name":"$name_nodir"}]},{"definition":"sub","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"get_doublets","kind":13,"line":1483},{"line":1484,"name":"$self","kind":13,"containerName":"get_doublets"},{"line":1485,"name":"$self","containerName":"get_doublets","kind":13},{"containerName":"get_doublets","kind":12,"name":"warn","line":1485},{"line":1486,"containerName":"get_doublets","kind":13,"name":"$self"},{"name":"set_doublets","kind":12,"containerName":"get_doublets","line":1486},{"definition":"my","line":1488,"localvar":"my","kind":13,"containerName":"get_doublets","name":"@doublets"},{"line":1489,"name":"$self","containerName":"get_doublets","kind":13}],"name":"get_doublets","containerName":"main::","line":1482,"range":{"end":{"line":1489,"character":9999},"start":{"character":0,"line":1482}},"kind":12},{"kind":12,"name":"doublets_set","line":1484},{"kind":13,"containerName":null,"name":"%self","line":1490},{"name":"name","kind":12,"line":1490},{"line":1490,"name":"%self","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"@doublets","line":1491},{"name":"@doublets","kind":13,"containerName":null,"line":1494},{"range":{"end":{"character":9999,"line":1515},"start":{"character":0,"line":1509}},"kind":12,"line":1509,"containerName":"main::","name":"dump_hash","children":[{"line":1510,"containerName":"dump_hash","localvar":"my","kind":13,"name":"$self","definition":"my"},{"definition":"my","name":"$dumper","containerName":"dump_hash","localvar":"my","kind":13,"line":1511},{"line":1512,"kind":13,"containerName":"dump_hash","name":"$self"},{"line":1512,"kind":12,"containerName":"dump_hash","name":"debug"},{"kind":13,"containerName":"dump_hash","name":"$dumper","line":1514},{"line":1514,"name":"dumpValue","containerName":"dump_hash","kind":12},{"kind":13,"containerName":"dump_hash","name":"$self","line":1514}],"definition":"sub"},{"name":"Dumpvalue","kind":12,"line":1511},{"definition":"sub","detail":"($self,$sequence)","children":[{"name":"$self","localvar":"my","containerName":"dump_hash_compact","kind":13,"line":1531,"definition":"my"},{"line":1531,"kind":13,"containerName":"dump_hash_compact","name":"$sequence"},{"name":"@singlets","localvar":"my","kind":13,"containerName":"dump_hash_compact","line":1533,"definition":"my"},{"name":"$self","containerName":"dump_hash_compact","kind":13,"line":1533},{"line":1533,"name":"get_singlets","kind":12,"containerName":"dump_hash_compact"},{"name":"@singletons","localvar":"my","containerName":"dump_hash_compact","kind":13,"line":1534,"definition":"my"},{"line":1534,"containerName":"dump_hash_compact","kind":13,"name":"$self"},{"kind":12,"containerName":"dump_hash_compact","name":"get_singletons","line":1534},{"definition":"my","name":"@doublets","kind":13,"localvar":"my","containerName":"dump_hash_compact","line":1535},{"line":1535,"kind":13,"containerName":"dump_hash_compact","name":"$self"},{"name":"get_doublets","kind":12,"containerName":"dump_hash_compact","line":1535},{"name":"@pairs","containerName":"dump_hash_compact","localvar":"my","kind":13,"line":1536,"definition":"my"},{"line":1536,"name":"$self","kind":13,"containerName":"dump_hash_compact"},{"line":1536,"name":"get_pairs","containerName":"dump_hash_compact","kind":12},{"definition":"my","localvar":"my","kind":13,"containerName":"dump_hash_compact","name":"@multiplets","line":1537},{"line":1537,"name":"$self","containerName":"dump_hash_compact","kind":13},{"name":"get_multiplets","containerName":"dump_hash_compact","kind":12,"line":1537},{"line":1539,"containerName":"dump_hash_compact","kind":13,"name":"@singlets"},{"definition":"my","line":1540,"kind":13,"localvar":"my","containerName":"dump_hash_compact","name":"@members"},{"line":1540,"containerName":"dump_hash_compact","kind":13,"name":"$self"},{"line":1540,"name":"get_members","kind":12,"containerName":"dump_hash_compact"},{"line":1541,"containerName":"dump_hash_compact","kind":13,"name":"$self"},{"containerName":"dump_hash_compact","kind":12,"name":"get_name","line":1541},{"line":1541,"containerName":"dump_hash_compact","kind":13,"name":"@members"},{"name":"$self","containerName":"dump_hash_compact","kind":13,"line":1542},{"name":"@singletons","containerName":"dump_hash_compact","kind":13,"line":1549},{"definition":"my","name":"@members","localvar":"my","kind":13,"containerName":"dump_hash_compact","line":1550},{"line":1550,"name":"$self","kind":13,"containerName":"dump_hash_compact"},{"line":1550,"name":"get_members","containerName":"dump_hash_compact","kind":12},{"line":1551,"name":"$self","containerName":"dump_hash_compact","kind":13},{"name":"get_name","kind":12,"containerName":"dump_hash_compact","line":1551},{"kind":13,"containerName":"dump_hash_compact","name":"@members","line":1551},{"line":1552,"containerName":"dump_hash_compact","kind":13,"name":"$self"},{"localvar":"my","kind":13,"containerName":"dump_hash_compact","name":"$pair","line":1558,"definition":"my"},{"name":"@pairs","containerName":"dump_hash_compact","kind":13,"line":1558},{"line":1559,"name":"@members","kind":13,"localvar":"my","containerName":"dump_hash_compact","definition":"my"},{"kind":13,"containerName":"dump_hash_compact","name":"$self","line":1559},{"line":1559,"containerName":"dump_hash_compact","kind":12,"name":"get_members"},{"line":1559,"name":"$pair","containerName":"dump_hash_compact","kind":13},{"line":1560,"name":"$name","localvar":"my","kind":13,"containerName":"dump_hash_compact","definition":"my"},{"line":1561,"kind":13,"containerName":"dump_hash_compact","name":"$self"},{"line":1561,"kind":12,"containerName":"dump_hash_compact","name":"get_name"},{"kind":13,"containerName":"dump_hash_compact","name":"$pair","line":1561},{"containerName":"dump_hash_compact","kind":13,"name":"$name","line":1562},{"line":1564,"name":"$name","containerName":"dump_hash_compact","kind":13},{"line":1564,"name":"$self","containerName":"dump_hash_compact","kind":13},{"name":"get_name","containerName":"dump_hash_compact","kind":12,"line":1564},{"name":"$pair","containerName":"dump_hash_compact","kind":13,"line":1564},{"line":1566,"name":"@members","containerName":"dump_hash_compact","kind":13},{"kind":13,"containerName":"dump_hash_compact","name":"@doublets","line":1568},{"definition":"my","line":1569,"name":"@members","localvar":"my","containerName":"dump_hash_compact","kind":13},{"containerName":"dump_hash_compact","kind":13,"name":"$self","line":1569},{"kind":12,"containerName":"dump_hash_compact","name":"get_members_by_name","line":1569},{"line":1570,"name":"@members","containerName":"dump_hash_compact","kind":13},{"definition":"my","line":1571,"kind":13,"localvar":"my","containerName":"dump_hash_compact","name":"$contig_number"},{"line":1571,"containerName":"dump_hash_compact","kind":13,"name":"$self"},{"line":1572,"name":"$self","containerName":"dump_hash_compact","kind":13},{"line":1572,"name":"$contig_number","kind":13,"containerName":"dump_hash_compact"},{"line":1579,"containerName":"dump_hash_compact","kind":13,"name":"@multiplets"},{"definition":"my","localvar":"my","containerName":"dump_hash_compact","kind":13,"name":"@members","line":1580},{"line":1580,"name":"$self","kind":13,"containerName":"dump_hash_compact"},{"name":"get_members","kind":12,"containerName":"dump_hash_compact","line":1580},{"kind":13,"containerName":"dump_hash_compact","name":"@members","line":1581}],"name":"dump_hash_compact","containerName":"main::","signature":{"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_reverse_designator {\n    my ($self,$reverse_designator) = @_;\n    $self->{'reverse_designator'} = $reverse_designator;\n    $self->{'o_trim'}->set_reverse_designator($reverse_designator);\n    return $self->{'reverse_designator'};\n}\t\t\t\t# end set_reverse_designator\n\n=head2 set_forward_designator($some_string)\n\n Title   : set_forward_designator($some_string)\n Usage   : $o_consed->set_forward_designator($some_string);\n Function: Set the designator for the forward read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{forward_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_forward_designator {\n    my ($self,$forward_designator) = @_;\n    $self->{'forward_designator'} = $forward_designator;\n    $self->{'o_trim'}->set_forward_designator($forward_designator);\n    return $self->{'forward_designator'};\n}\t\t\t\t# end set_forward_designator\n\n=head2 set_designator_ignore_case(\"yes\")\n\n Title   : set_designator_ignore_case(\"yes\")\n Usage   : $o_consed->set_designator_ignore_case(\"yes\");\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n\nDeprecated. Really. Trust me.\n\n\nsub set_designator_ignore_case {\n    my ($self,$ignore_case) = @_;\n    if ($ignore_case eq \"yes\") {\n\t$self->{'designator_ignore_case'} = 1;\n    }\n    return $self->{'designator_ignore_case'};\n}\t\t\t\t# end set_designator_ignore_case\n\n=head2 set_trim_points_singlets_and_singletons()\n\n Title   : set_trim_points_singlets_and_singletons()\n Usage   : $o_consed->set_trim_points_singlets_and_singletons();\n Function: Set the trim points for singlets and singletons based on\n\t   quality.  Uses the Bio::Tools::Alignment::Trim object. Use\n\t   at your own risk because the Bio::Tools::Alignment::Trim\n\t   object was designed specifically for me and is mysterious\n\t   in its ways. Every time somebody other then me uses it a\n\t   swarm of locusts decends on a small Central American\n\t   village so do not say you weren't warned.\n Returns : Nothing.\n Args    : None.\n\nWorking on exceptions and warnings here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\n#' to make my emacs happy\n\nsub set_trim_points_singlets_and_singletons {\n    my ($self) = @_;\n    $self->debug(\"Consed.pm : \\$self is $self\\n\");\n    my (@points,$trimmed_sequence);\n    if (!$self->{'doublets_set'}) {\n        $self->debug(\"You need to set the doublets before you use \".\n                     \"set_trim_points_singlets_and_doublets. Doing that now.\");\n\t$self->set_doublets();\n    }\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"singlet\") {\n\t    $self->debug(\"Singlet $_\\n\");\n\t    # this is what Warehouse wants\n\t    #         my ($self,$sequence,$quality,$name) = @_;\n\t    # this is what Bio::Tools::Alignment::Trim::trim_singlet wants:\n\t    # my ($self,$sequence,$quality,$name,$class) = @_;\n\t    # the following several lines are to make the parameter passing legible.\n\t    my ($sequence,$quality,$name,$class);\n\t    $sequence = $self->{'contigs'}->{$_}->{'consensus'};\n\t    if (!$self->{'contigs'}->{$_}->{'quality'}) { $quality = \"unset\"; }\n\t    else { $quality = $self->{'contigs'}->{$_}->{'quality'}; }\n\t    $name = $self->{'contigs'}->{$_}->{'name'};\n\t    $class = $self->{'contigs'}->{$_}->{'class'};\n\t    @points = @{$self->{'o_trim'}->trim_singlet($sequence,$quality,$name,$class)};\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} = \n                substr($self->{contigs}->{$_}->{'consensus'},$points[0],$points[1]-$points[0]);\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_singlets\".\n                 \"_and_singletons: Done setting the quality trimpoints.\\n\");\n    return;\n}  # end set_trim_points_singlet\n\n=head2 set_trim_points_doublets()\n\n Title   : set_trim_points_doublets()\n Usage   : $o_consed->set_trim_points_doublets();\n Function: Set the trim points for doublets based on quality. Uses the\n\t   Bio::Tools::Alignment::Trim object. Use at your own risk because\n           the Bio::Tools::Alignment::Trim object was designed specifically\n           for me and is mysterious in its ways. Every time somebody other\n           then me uses it you risk a biblical plague being loosed on your\n           city.\n Returns : Nothing.\n Args    : None.\n Notes   : Working on exceptions here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\nsub set_trim_points_doublets {\n    my $self = shift;\n    my @points;\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Restoring zeros for doublets.\\n\");\n    # &show_missing_sequence($self);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Setting doublet trim points.\\n\");\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            # my ($self,$sequence,$quality,$name,$class) = @_;\n            my @quals = split(' ',$self->{'contigs'}->{$_}->{'quality'});\n\n\t    @points = $self->{o_trim}->trim_doublet\n                ($self->{'contigs'}->{$_}->{'consensus'},\n                 $self->{'contigs'}->{$_}->{'quality'},\n                 $self->{'contigs'}->{$_}->{name},\n                 $self->{'contigs'}->{$_}->{'class'});\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n            # now set this\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} =\n                substr($self->{contigs}->{$_}->{'consensus'},\n                       $points[0],$points[1]-$points[0]);\n\t    # 010102 the deprecated way to do things:\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Done setting doublet trim points.\\n\"); \n    return;\n} # end set_trim_points_doublets\n\n=head2 get_trimmed_sequence_by_name($name)\n\n Title   : get_trimmed_sequence_by_name($name)\n Usage   : $o_consed->get_trimmed_sequence_by_name($name);\n Function: Returns the trimmed_sequence of a contig with {name} eq $name.\n Returns : A scalar- the trimmed sequence.\n Args    : The {name} of a contig.\n Notes   : \n\n\nsub get_trimmed_sequence_by_name {\n    my ($self,$name) = @_;\n    my $trimmed_sequence;\n    my $contigname = &get_contig_number_by_name($self,$name);\n    my $class = $self->{'contigs'}->{$contigname}->{'class'};\n    # what is this business and who was smoking crack while writing this?\n    # if ($class eq \"singlet\") {\n    # send the sequence, the quality, and the name\n    # $trimmed_sequence = $self->{o_trim}->trim_singlet\n    #  ($self->{'contigs'}->{$contigname}->{consensus},\n    #   $self->{'contigs'}->{$contigname}->{'quality'},$name);\n    # }\n    return $self->{'contigs'}->{$contigname}->{'sequence_trimmed'};\n}\n\n=head2 set_dash_present_in_sequence_name(\"yes\")\n\n Title   : set_dash_present_in_sequence_name(\"yes\")\n Usage   : $o_consed->set_dash_present_in_sequence_name(\"yes\");\n Function: Deprecated. Part of an uncompleted thought. (\"Oooh! Shiny!\")\n Returns : Nothing.\n Args    : \"yes\" to set {dash_present_in_sequence_name} to 1\n Notes   : \n\n\nsub set_dash_present_in_sequence_name {\n    my ($self,$dash_present) = @_;\n    if ($dash_present eq \"yes\") {\n\t$self->{'dash_present_in_sequence_name'} = 1;\n    }\n    else {\n\t$self->{'dash_present_in_sequence_name'} = 0;\n    }\n    return $self->{'dash_present_in_sequence_name'};\n} # end set_dash_present_in_sequence_name\n\n=head2 set_doublets()\n\n Title   : set_doublets()\n Usage   : $o_consed->set_doublets();\n Function: Find pairs that have similar names and mark them as doublets\n\t   and set the {name}.\n Returns : 0 or 1.\n Args    : None.\n\nA complicated subroutine that iterates over the\nBio::Tools::Alignment::Consed looking for contigs of 2. If the forward\nand reverse designator are removed from each of the reads in\n{'member_array'} and the remaining reads are the same, {name} is set\nto that name and the contig's class is set as \"doublet\".  If any of\nthose cases fail the contig is marked as a \"pair\".\n\n\n#' make my emacs happy\n\nsub set_doublets {\n    my ($self) = @_;\n    # set the designators in the Bio::Tools::Alignment::Trim object\n\n    $self->{'o_trim'}->set_designators($self->{'reverse_designator'},\n\t\t\t\t       $self->{'forward_designator'});\n    foreach my $key_contig (sort keys %{$self->{'contigs'}}) {\n\n\t# if there is a member array (why would there not be? This should be a die()able offence\n\t# but for now I will leave it\n\tif ($self->{'contigs'}->{$key_contig}->{'member_array'}) {\n\t    # if there are two reads in this contig \n\t    # i am pretty sure that this is wrong but i am keeping it for reference\n\t    # if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2 || !$self->{'contigs'}->{$key_contig}->{'class'}) {\n\t    # <seconds later>\n\t    # <nod> WRONG. Was I on crack?\n\t    if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = 2;\n\t\t$self->debug(\"\\tThere are 2 members! Looking for the contig name...\\n\");\n\t\tmy $name = _get_contig_name($self,$self->{'contigs'}->{$key_contig}->{'member_array'});\n\t\t$self->debug(\"The name is $name\\n\") if defined $name;\n\t\tif ($name) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'name'} = $name;\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"doublet\";\n\t\t} else {\n\t\t    $self->debug(\"$key_contig is a pair.\\n\");\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"pair\";\n\t\t}\n\t    }\n            # this is all fair and good but what about singlets?\n            # they have one reads in the member_array but certainly are not singletons\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 1) {\n\t\t# set the name to be the name of the read\n\t\t$self->{'contigs'}->{$key_contig}->{name} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}}[0];\n\t\t# set the number of members to be one\n\t\t$self->{'contigs'}->{$key_contig}->{num_members} = 1;\n\t\t# if this was a singlet, it would already belong to the class \"singlet\"\n\t\t# so leave it alone\n\t\t# if it is not a singlet, it is a singleton! lablel it appropriately\n\t\tunless ($self->{'contigs'}->{$key_contig}->{'class'}) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"singleton\";\n\t\t}\n\t    }\n            # set the multiplet characteristics\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} >= 3) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\t\t$self->{'contigs'}->{$key_contig}->{'class'} = \"multiplet\";\n\t    }\n\t    $self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\n\t}\n    }\n    $self->{'doublets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end set_doublets\n\n=head2 set_singlets\n\n Title   : set_singlets\n Usage   : $o_consed->set_singlets();\n Function: Read in a singlets file and place them into the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : Nothing.\n Args    : A scalar to turn on verbose parsing of the singlets file.\n Notes   : \n\n\nsub set_singlets {\n    # parse out the contents of the singlets file\n    my ($self) = @_;\n    $self->debug(\"Bio::Tools::Alignment::Consed Adding singlets to the contig hash...\\n\"); \n    my $full_filename = $self->{'filename'};\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: \\$full_filename is $full_filename\\n\");\n    $full_filename =~ m/(.*\\/)(.*ace.*)$/; \t\t\t       \n    my ($base_path,$filename) = ($1,$2);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: singlets filename is $filename and \\$base_path is $base_path\\n\");\n    $filename =~ m/(.*)ace.*$/;\n    my $singletsfile = $base_path.$1.\"singlets\";\n    $self->debug(\"\\$singletsfile is $singletsfile\\n\");\n     if (!-f $singletsfile) {\n          # there is no singlets file.\n          $self->{'singlets_set'} = \"done\";\n          return;\n     }\n\t$self->debug(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    my $singlets_fh = Bio::Root::IO->new(-file => $singletsfile);\n    my ($sequence,$name,$count);\n    while ($_ = $singlets_fh->_readline()) {\n\tchomp $_;\n\tif (/\\>/) {\n\t    if ($name && $sequence) {\n\t\t$self->debug(\"Adding $name with sequence $sequence to hash...\\n\");\n\t\tpush @{$self->{'contigs'}->{$name}->{'member_array'}},$name;\n\t\t$self->{'contigs'}->{$name}->{'consensus'} = $sequence;\n\t\t$self->{'contigs'}->{$name}->{'name'} = $name;\n\t\t$self->{'contigs'}->{$name}->{\"singlet\"} = 1;\n\t\t$self->{'contigs'}->{$name}->{'class'} = \"singlet\";\n\t    }\n\t    $sequence = $name = undef;\n\t    $count++;\n\t    m/^\\>(.*)\\s\\sCHROMAT/;\n\t    $name = $1;\n\t    if (!$name) {\n\t\tm/\\>(\\S+)\\s/;\n\t\t$name = $1;\n\t    }\n\t}\n\telse { $sequence .= $_; }\t\n    }\n    if ($name && $sequence) {\n\t$self->debug(\"Pushing the last of the singlets ($name)\\n\");\n\t@{$self->{'contigs'}->{$name}->{'member_array'}} = $name;\n\t$self->{'contigs'}->{$name}->{'consensus'} = $sequence;\n\t$self->{'contigs'}->{$name}->{'name'} = $name;\n\t$self->{'contigs'}->{$name}->{\"singlet\"} = 1;\n\t$self->{'contigs'}->{$name}->{'class'} = \"singlet\";\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: Done adding singlets to the singlets hash.\\n\");\n    $self->{'singlets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end sub set_singlets\n\n=head2 get_singlets()\n\n Title   : get_singlets()\n Usage   : $o_consed->get_singlets();\n Function: Return the keynames of the singlets.\n Returns : An array containing the keynames of all \n           Bio::Tools::Alignment::Consed sequences in the class \"singlet\".\n Args    : None.\n Notes   : \n\n\nsub get_singlets {\n    # returns an array of singlet names\n    # singlets have \"singlet\"=1 in the hash\n    my $self = shift;\n    if (!$self->{singlets_set}) {\n\t$self->debug(\"You need to set the singlets before you get them. Doing that now.\");\n\t$self->set_singlets();\n    }\t\n\n    my (@singlets,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\t# @array = @{$Consed::contigs{$key}->{'member_array'}};\n\t# somethimes a user will try to get a list of singlets before the classes for the rest of the\n\t# contigs has been set (see t/test.t for how I figured this out. <bah>\t\t\t\n\t# so either way, just return class=singlets\n\tif (!$self->{'contigs'}->{$key}->{'class'}) {\n\t    # print(\"$key has no class. why?\\n\");\n\t}\n\telsif ($self->{'contigs'}->{$key}->{'class'} eq \"singlet\") {\n\t    push @singlets,$key;\n\t}\n    }\n    return @singlets;\n}\n\n=head2 set_quality_by_name($name,$quality)\n\n Title   : set_quality_by_name($name,$quality)\n Usage   : $o_consed->set_quality_by_name($name,$quality);\n Function: Deprecated. Make the contig with {name} have {'quality'} $quality.\n           Probably used for testing.\n Returns : Nothing.\n Args    : The name of a contig and a scalar for its quality.\n Notes   : Deprecated.\n\n\nsub set_quality_by_name {\n    # this is likely deprecated\n    my ($self,$name,$quality) = shift;\n    my $return;\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'} eq \"$name\" || $self->{'contigs'}->{'name'} eq \"$name\") {\n\t    $self->{'contigs'}->{'quality'} = $quality;\n\t    $return=1;\n\t}\n    }\n    if ($return) { return \"0\"; } else { return \"1\"; }\n}\t\t\t\t# end set quality by name\n\n=head2 set_singlet_quality()\n\n Title   : set_singlet_quality()\n Usage   : $o_consed->set_singlet_quality();\n Function: For each singlet, go to the appropriate file in phd_dir and read\n           in the phred quality for that read and place it into {'quality'}\n Returns : 0 or 1.\n Args    : None.\n Notes   : This is the next subroutine that will receive substantial revision\n           in the next little while. It really should eval the creation of\n           Bio::Tools::Alignment::Phred objects and go from there. \n\n\nsub set_singlet_quality {\n    my $self = shift;\n    my $full_filename = $self->{'filename'};\n    $full_filename =~ m/(.*\\/)(.*)ace.*$/;\n    my ($base_path,$filename) = ($1,\"$2\".\"qual\");\n    my $singletsfile = $base_path.$filename;\n    if (-f $singletsfile) {\n\t# print(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    }\n    else {\n\t$self->warn(\"$singletsfile is not a file. Sorry.\\n\");\n\treturn;\n    }\n\tmy $singlets_fh = Bio::Root::IO->new(-file => $singletsfile);\n\tmy ($sequence,$name,$count);\n    my ($identity,$line,$quality,@qline);\n    while ($line = $singlets_fh->_readline()) {\n\tchomp $line;\n\tif ($line =~ /^\\>/) {\n\t    $quality = undef;\n\t    $line =~ m/\\>(\\S*)\\s/;\n\t    $identity = $1;\n\t}\n\telse {\n\t    if ($self->{'contigs'}->{$identity}) {\n\t\t$self->{'contigs'}->{$identity}->{'quality'} .= \"$line \";\n\t    }\n\t}\n\n    }\n    return 0;\n}\n\n=head2 set_contig_quality()\n\n Title   : set_contig_quality()\n Usage   : $o_consed->set_contig_quality();\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n Notes   : Deprecated. Really. Trust me.\n\n\nsub set_contig_quality {\n    # note: contigs _include_ singletons but _not_ singlets\n    my ($self) = shift;\n          # the unexpected results I am referring to here are a doubling of quality values.\n          # the profanity I uttered on discovering this reminded me of the simpsons:\n          # Ned Flanders: \"That is the loudest profanity I have ever heard!\"\n     $self->warn(\"set_contig_quality is deprecated and will likely produce unexpected results\");\n    my $full_filename = $self->{'filename'};\n    # Run_SRC3700_2000-08-01_73+74.fasta.screen.contigs.qual\n    # from Consed.pm\n    $full_filename =~ m/(.*\\/)(.*)ace.*$/;\n    my ($base_path,$filename) = ($1,\"$2\".\"contigs.qual\");\n    my $singletsfile = $base_path.$filename;\n    if (-f $singletsfile) {\n\t# print(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    }\n    else {\n\t$self->warn(\"Bio::Tools::Alignment::Consed::set_contig_quality $singletsfile is not a file. Sorry.\\n\");\n\treturn;\n    }\n    my $contig_quality_fh = Bio::Root::IO->new(-file => $singletsfile);\n\n    my ($sequence,$name,$count,$identity,$line,$quality);\n    while ($line = $contig_quality_fh->_readline()) {\n\tchomp $line;\n\tif ($line =~ /^\\>/) {\n\t    $quality = undef;\n\t    $line =~ m/\\>.*Contig(\\d+)\\s/;\n\t    $identity = $1;\n\t}\n\telse {\n\t    if ($self->{'contigs'}->{$identity} ) {\n\t\t$self->{'contigs'}->{$identity}->{'quality'} .= \" $line\";\n\t    }\n\t}\n    }\n}\t\t\t\t# end set_contig_quality\n\n=head2 get_multiplets()\n\n Title   : get_multiplets()\n Usage   : $o_consed->get_multiplets();\n Function: Return the keynames of the multiplets.\n Returns : Returns an array containing the keynames of all \n           Bio::Tools::Alignment::Consed sequences in the class \"multiplet\".\n Args    : None.\n Notes   : \n\n\nsub get_multiplets {\n\t    # returns an array of multiplet names\n\t    # multiplets have # members > 2\n    my $self = shift;\n    my (@multiplets,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$key}->{'class'}) {\n\t    if ($self->{'contigs'}->{$key}->{'class'} eq \"multiplet\") {\n\t\tpush @multiplets,$key;\n\t    }\n\t}\n    }\n    return @multiplets;\n}\n\n=head2 get_all_members()\n\n  Title   : get_all_members()\n  Usage   : @all_members = $o_consed->get_all_members();\n  Function: Return a list of all of the read names in the \n            Bio::Tools::Alignment::Consed object.\n  Returns : An array containing all of the elements in all of the\n            {'member_array'}s.\n  Args    : None.\n  Notes   : \n\n\nsub get_all_members {\n    my $self = shift;\n    my @members;\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\tif ($key =~ /^singlet/) {\n\t    push @members,$self->{'contigs'}->{$key}->{'member_array'}[0];\n\t}\n\telsif ($self->{'contigs'}->{$key}->{'member_array'}) {\n\t    push @members,@{$self->{'contigs'}->{$key}->{'member_array'}};\n\t}\n\t# else {\n\t#\tprint(\"Bio::Tools::Alignment::Consed: $key is _not_ an array. Pushing $self->{'contigs'}->{$key}->{'member_array'} onto \\@members\\n\");\n\t#\tpush @members,$self->{'contigs'}->{$key}->{'member_array'};\n\t# }\n    }\n    return @members;\n}\n\n=head2 sum_lets($total_only)\n\n Title   : sum_lets($total_only)\n Usage   : $statistics = $o_consed->sum_lets($total_only);\n Function: Provide numbers for how many sequences were accounted for in the\n           Bio::Tools::Alignment::Consed object.\n Returns : If a scalar is present, returns the total number of\n           sequences accounted for in all classes. If no scalar passed\n           then returns a string that looks like this:\n           Singt/singn/doub/pair/mult/total : 2,0,1(2),0(0),0(0),4\n           This example means the following: There were 1 singlets.\n           There were 0 singletons.  There were 1 doublets for a total\n           of 2 sequences in this class.  There were 0 pairs for a\n           total of 0 sequences in this class.  There were 0\n           multiplets for a total of 0 sequences in this class.  There\n           were a total of 4 sequences accounted for in the\n           Bio::Tools::Alignment::Consed object.   \n Args : A scalar is optional to change the way the numbers are returned.  \n Notes:\n\n\nsub sum_lets {\n    my ($self,$total_only) = @_;\n    my ($count,$count_multiplets,$multiplet_count);\n    my $singlets = &get_singlets($self); $count += $singlets;\n    my $doublets = &get_doublets($self); $count += ($doublets * 2);\n    my $pairs = &get_pairs($self); $count += ($pairs * 2);\n    my $singletons = &get_singletons($self); $count += $singletons;\n    my @multiplets = &get_multiplets($self);\n    $count_multiplets = @multiplets;\n    my $return_string;\n    foreach (@multiplets) {\n\tmy $number_members = $self->{'contigs'}->{$_}->{num_members};\t\n\t$multiplet_count += $number_members;\n    }\n    if ($multiplet_count) {\n\t$count += $multiplet_count;\n    }\n    foreach (qw(multiplet_count singlets doublets pairs singletons\n                multiplets count_multiplets)) {\n\tno strict 'refs';\t# renege for the block\n\tif (!${$_}) {\n            ${$_} = 0;\n\t}\n    }\n    if (!$multiplet_count) { $multiplet_count = 0; }\n    if ($total_only) {\n        return $count;\n    }\n    $return_string = \"Singt/singn/doub/pair/mult/total : \".\n        \"$singlets,$singletons,$doublets(\".\n         ($doublets*2).\"),$pairs(\".($pairs*2).\n        \"),$count_multiplets($multiplet_count),$count\";\n    return $return_string;\n}\n\n=head2 write_stats()\n\n Title   : write_stats()\n Usage   : $o_consed->write_stats();\n Function: Write a file called \"statistics\" containing numbers similar to\n\t   those provided in sum_lets().\n Returns : Nothing. Write a file in $o_consed->{path} containing something\n\t   like this:\n\n           0,0,50(100),0(0),0(0),100\n\n           Where the numbers provided are in the format described in the\n\t   documentation for sum_lets().\n Args    : None.\n Notes   : This might break platform independence, I do not know.\n\nSee L<sum_lets()|sum_lets>\n\n\nsub write_stats {\n    # worry about platform dependence here?\n    # oh shucksdarn.\n    my $self = shift;\n    my $stats_filename = $self->{'path'}.\"statistics\";\n    my $statistics_raw = $self->sum_lets;\n    my ($statsfilecontents) = $statistics_raw =~ s/.*\\ \\:\\ //g;\n    umask 0001;\n    my $fh = Bio::Root::IO->new(-file=>\"$stats_filename\");\n    # open(STATSFILE,\">$stats_filename\") or print(\"Could not open the statsfile: $!\\n\");\n    $fh->_print(\"$statsfilecontents\");\n    # close STATSFILE;\n    $fh->close();\n}\n\n=head2 get_singletons()\n\n Title   : get_singletons()\n Usage   : @singletons = $o_consed->get_singletons();\n Function: Return the keynames of the singletons.\n Returns : Returns an array containing the keynames of all\n\t   Bio::Tools::Alignment::Consed sequences in the class \"singleton\".\n Args    : None.\n Notes   : \n\n\nsub get_singletons {\n\t\t# returns an array of singleton names\n\t\t# singletons are contigs with one member (see consed documentation)\n\tmy $self = shift;\n\tmy (@singletons,@array);\n\tforeach my $key (sort keys %{$self->{'contigs'}}) {\n\t\tif ($self->{'contigs'}->{$key}->{'class'}) {\n\t\t    # print (\"$key class: $self->{'contigs'}->{$key}->{'class'}\\n\");\n\t\t}\n\t\telse {\n\t\t    # print(\"$key belongs to no class. why?\\n\");\n\t\t}\n\t\tif ($self->{'contigs'}->{$key}->{'member_array'}) {\n\t\t\t@array = @{$self->{'contigs'}->{$key}->{'member_array'}};\n\t\t}\n\t\tmy $num_array_elem = @array;\n\t\tif ($num_array_elem == 1 && $self->{'contigs'}->{$key}->{'class'} && $self->{'contigs'}->{$key}->{'class'} eq \"singleton\") { push @singletons,$key; }\n\t}\n\treturn @singletons;\n}\n\n=head2 get_pairs()\n\n Title   : get_pairs()\n Usage   : @pairs = $o_consed->get_pairs();\n Function: Return the keynames of the pairs.\n Returns : Returns an array containing the keynames of all\n           Bio::Tools::Alignment::Consed sequences in the class \"pair\".\n Args    : None.\n Notes   : \n\n\nsub get_pairs {\n    # returns an array of pair contig names\n    # a pair is a contig of two where the names do not match\n    my $self = shift;\n    my (@pairs,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n        if ($self->{'contigs'}->{$key}->{'member_array'}) {\n            if (@{$self->{'contigs'}->{$key}->{'member_array'}} == 2 &&\n                $self->{'contigs'}->{$key}->{'class'} eq \"pair\") {\n                push @pairs,$key;\n            }\n        }\n    }\n    return @pairs;\n}\n\n=head2 get_name($contig_keyname)\n\n Title   : get_name($contig_keyname)\n Usage   : $name = $o_consed->get_name($contig_keyname);\n Function: Return the {name} for $contig_keyname.\n Returns : A string. ({name})\n Args    : A contig keyname.\n Notes   : \n\n\nsub get_name {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'name'};\n}\n\n=head2 _get_contig_name(\\@array_containing_reads)\n\n Title   : _get_contig_name(\\@array_containing_reads)\n Usage   : $o_consed->_get_contig_name(\\@array_containing_reads);\n Function: The logic for the set_doublets subroutine.\n Returns : The name for this contig.\n Args    : A reference to an array containing read names.\n Notes   : Depends on reverse_designator. Be sure this is set the way you\n\t   intend.\n\n\nsub _get_contig_name {\n    my ($self,$r_array) = @_;\n    my @contig_members = @$r_array;\n    my @name_nodir;\n    foreach (@contig_members) {\n        # how can I distinguish the clone name from the direction label?\n        # look for $Consed::reverse_designator and $Consed::forward_designator\n        # what if you do not find _any_ of those?\n        my $forward_designator = $self->{'forward_designator'} || \"f\";\n        my $reverse_designator = $self->{'reverse_designator'} || \"r\";\n        my $any_hits = /(.+)($forward_designator.*)/ || /(.+)($reverse_designator.*)/||/(.+)(_.+)/;\n        my $name = $1;\n        my $suffix = $2;\n        if ($name) {\n            # print(\"\\t\\$name is $name \");\n        }\n        if ($suffix) {\n            # print(\"and \\$suffix is $suffix.\\n\");\n        }\n                                # Jee, I hope we get a naming convention soon\n        if ($suffix) {\n            if ($suffix =~ /^$forward_designator/ || $suffix =~ /^$reverse_designator/) {\n                push @name_nodir,$name;\n            }\n\t\t\t\t# bugwatch here! should this be unnested?\n            else {\n                push @name_nodir,\"$name$suffix\";\n            }\n        }\n    }\n    # print(\"\\@name_nodir: @name_nodir\\n\");\n    my $mismatch = 0;\n    for (my $counter=0; $counter<@name_nodir;$counter++) {\n        next if ($name_nodir[0] eq $name_nodir[$counter]);\n        $mismatch = 1;\n    }\n    if ($mismatch == 0) {\n        # print(\"\\tYou have a cohesive contig named $name_nodir[0].\\n\\n\");\n        return $name_nodir[0];\n    } else {\n        # print(\"\\tYou have mixed names in this contig.\\n\\n\");\n    }\n}                               # end _get_contig_name\n\n=head2 get_doublets()\n\n Title   : get_doublets()\n Usage   : @doublets = $o_consed->get_doublets();\n Function: Return the keynames of the doublets.\n Returns : Returns an array containing the keynames of all\n           Bio::Tools::Alignment::Consed sequences in the class \"doublet\".\n Args    : None.\n Notes   : \n\n\nsub get_doublets {\n    my $self = shift;\n    if (!$self->{doublets_set}) {\n        $self->warn(\"You need to set the doublets before you can get them. Doing that now.\");\n        $self->set_doublets();\n    }\n    my @doublets;\n    foreach (sort keys %{$self->{'contigs'}}) {\n        if ($self->{'contigs'}->{$_}->{name} && $self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            push @doublets,$_;\n        }\n    }\n    return @doublets;\n}                               # end get_doublets\n\n=head2 dump_hash()\n\n Title   : dump_hash()\n Usage   : $o_consed->dump_hash();\n Function: Use dumpvar.pl to dump out the Bio::Tools::Alignment::Consed\n           object to STDOUT.\n Returns : Nothing.\n Args    : None.\n Notes   : I used this a lot in debugging.\n\n\nsub dump_hash {\n    my $self = shift;\n    my $dumper = new Dumpvalue;\n    $self->debug( \"Bio::Tools::Alignment::Consed::dump_hash - \".\n                  \"The following is the contents of the contig hash...\\n\");\n    $dumper->dumpValue($self->{'contigs'});\n}\n\n=head2 dump_hash_compact()\n\n Title   : dump_hash_compact()\n Usage   : $o_consed->dump_hash_compact();\n Function: Dump out the Bio::Tools::Alignment::Consed object in a compact way.\n Returns : Nothing.\n Args    : Nothing.\n Notes   : Cleaner then dumpValue(), dumpHash(). I used this a lot in\n           debugging.","parameters":[{"label":"$self"},{"label":"$sequence"}],"label":"dump_hash_compact($self,$sequence)"},"line":1529,"kind":12,"range":{"end":{"line":1583,"character":9999},"start":{"line":1529,"character":0}}},{"kind":12,"name":"strict","line":1530},{"definition":"sub","children":[{"definition":"my","name":"$self","containerName":"get_phreds","localvar":"my","kind":13,"line":1608},{"name":"$current_contig","localvar":"my","kind":13,"containerName":"get_phreds","line":1609,"definition":"my"},{"name":"$current_contig","kind":13,"containerName":"get_phreds","line":1610},{"line":1610,"containerName":"get_phreds","kind":13,"name":"$self"}],"name":"get_phreds","containerName":"main::","line":1606,"kind":12,"range":{"end":{"line":1610,"character":9999},"start":{"line":1606,"character":0}}},{"name":"%self","kind":13,"containerName":null,"line":1611},{"line":1611,"name":"%current_contig","kind":13,"containerName":null},{"line":1612,"name":"$self","containerName":null,"kind":13},{"line":1612,"kind":12,"containerName":"main::","name":"debug"},{"definition":"my","name":"$r_phreds_top","localvar":"my","containerName":null,"kind":13,"line":1613},{"kind":12,"name":"parse_phd","line":1613},{"containerName":null,"kind":13,"name":"$self","line":1613},{"line":1613,"name":"%self","containerName":null,"kind":13},{"line":1613,"name":"%current_contig","containerName":null,"kind":13},{"line":1614,"localvar":"my","kind":13,"containerName":null,"name":"$r_phreds_bottom","definition":"my"},{"name":"parse_phd","kind":12,"line":1614},{"kind":13,"containerName":null,"name":"$self","line":1614},{"name":"%self","containerName":null,"kind":13,"line":1614},{"containerName":null,"kind":13,"name":"%current_contig","line":1614},{"line":1615,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"containerName":null,"name":"%current_contig","line":1615},{"line":1617,"containerName":null,"kind":13,"name":"$r_phreds_top"},{"line":1617,"kind":12,"name":"reverse_and_complement"},{"line":1617,"name":"$r_phreds_top","kind":13,"containerName":null},{"name":"%self","containerName":null,"kind":13,"line":1619},{"line":1619,"containerName":null,"kind":13,"name":"%current_contig"},{"kind":13,"containerName":null,"name":"$r_phreds_bottom","line":1620},{"line":1620,"kind":12,"name":"reverse_and_complement"},{"line":1620,"kind":13,"containerName":null,"name":"$r_phreds_bottom"},{"kind":13,"containerName":null,"name":"%self","line":1622},{"containerName":null,"kind":13,"name":"%current_contig","line":1622},{"line":1622,"containerName":null,"kind":13,"name":"$r_phreds_top"},{"line":1623,"name":"%self","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%current_contig","line":1623},{"line":1623,"name":"$r_phreds_bottom","kind":13,"containerName":null},{"children":[{"localvar":"my","kind":13,"containerName":"parse_phd","name":"$self","line":1646,"definition":"my"},{"kind":13,"containerName":"parse_phd","name":"$sequence_name","line":1646},{"line":1647,"kind":13,"containerName":"parse_phd","name":"$self"},{"name":"debug","kind":12,"containerName":"parse_phd","line":1647},{"definition":"my","localvar":"my","containerName":"parse_phd","kind":13,"name":"$in_dna","line":1648},{"line":1649,"kind":13,"localvar":"my","containerName":"parse_phd","name":"$base_number","definition":"my"},{"line":1650,"localvar":"my","containerName":"parse_phd","kind":13,"name":"@bases","definition":"my"},{"line":1650,"kind":13,"containerName":"parse_phd","name":"@current_line"},{"definition":"my","line":1652,"name":"$fh","localvar":"my","kind":13,"containerName":"parse_phd"},{"line":1653,"name":"new","containerName":"parse_phd","kind":12},{"line":1654,"containerName":"parse_phd","kind":13,"name":"$fh"},{"line":1654,"name":"_readline","kind":12,"containerName":"parse_phd"},{"containerName":"parse_phd","kind":13,"name":"$in_dna","line":1657},{"containerName":"parse_phd","kind":13,"name":"$in_dna","line":1659},{"containerName":"parse_phd","kind":13,"name":"@bases","line":1660},{"kind":13,"containerName":"parse_phd","name":"@bases","line":1662}],"containerName":"main::","name":"parse_phd","definition":"sub","detail":"($self,$sequence_name)","line":1645,"range":{"start":{"line":1645,"character":0},"end":{"character":9999,"line":1663}},"kind":12,"signature":{"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_reverse_designator {\n    my ($self,$reverse_designator) = @_;\n    $self->{'reverse_designator'} = $reverse_designator;\n    $self->{'o_trim'}->set_reverse_designator($reverse_designator);\n    return $self->{'reverse_designator'};\n}\t\t\t\t# end set_reverse_designator\n\n=head2 set_forward_designator($some_string)\n\n Title   : set_forward_designator($some_string)\n Usage   : $o_consed->set_forward_designator($some_string);\n Function: Set the designator for the forward read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{forward_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_forward_designator {\n    my ($self,$forward_designator) = @_;\n    $self->{'forward_designator'} = $forward_designator;\n    $self->{'o_trim'}->set_forward_designator($forward_designator);\n    return $self->{'forward_designator'};\n}\t\t\t\t# end set_forward_designator\n\n=head2 set_designator_ignore_case(\"yes\")\n\n Title   : set_designator_ignore_case(\"yes\")\n Usage   : $o_consed->set_designator_ignore_case(\"yes\");\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n\nDeprecated. Really. Trust me.\n\n\nsub set_designator_ignore_case {\n    my ($self,$ignore_case) = @_;\n    if ($ignore_case eq \"yes\") {\n\t$self->{'designator_ignore_case'} = 1;\n    }\n    return $self->{'designator_ignore_case'};\n}\t\t\t\t# end set_designator_ignore_case\n\n=head2 set_trim_points_singlets_and_singletons()\n\n Title   : set_trim_points_singlets_and_singletons()\n Usage   : $o_consed->set_trim_points_singlets_and_singletons();\n Function: Set the trim points for singlets and singletons based on\n\t   quality.  Uses the Bio::Tools::Alignment::Trim object. Use\n\t   at your own risk because the Bio::Tools::Alignment::Trim\n\t   object was designed specifically for me and is mysterious\n\t   in its ways. Every time somebody other then me uses it a\n\t   swarm of locusts decends on a small Central American\n\t   village so do not say you weren't warned.\n Returns : Nothing.\n Args    : None.\n\nWorking on exceptions and warnings here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\n#' to make my emacs happy\n\nsub set_trim_points_singlets_and_singletons {\n    my ($self) = @_;\n    $self->debug(\"Consed.pm : \\$self is $self\\n\");\n    my (@points,$trimmed_sequence);\n    if (!$self->{'doublets_set'}) {\n        $self->debug(\"You need to set the doublets before you use \".\n                     \"set_trim_points_singlets_and_doublets. Doing that now.\");\n\t$self->set_doublets();\n    }\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"singlet\") {\n\t    $self->debug(\"Singlet $_\\n\");\n\t    # this is what Warehouse wants\n\t    #         my ($self,$sequence,$quality,$name) = @_;\n\t    # this is what Bio::Tools::Alignment::Trim::trim_singlet wants:\n\t    # my ($self,$sequence,$quality,$name,$class) = @_;\n\t    # the following several lines are to make the parameter passing legible.\n\t    my ($sequence,$quality,$name,$class);\n\t    $sequence = $self->{'contigs'}->{$_}->{'consensus'};\n\t    if (!$self->{'contigs'}->{$_}->{'quality'}) { $quality = \"unset\"; }\n\t    else { $quality = $self->{'contigs'}->{$_}->{'quality'}; }\n\t    $name = $self->{'contigs'}->{$_}->{'name'};\n\t    $class = $self->{'contigs'}->{$_}->{'class'};\n\t    @points = @{$self->{'o_trim'}->trim_singlet($sequence,$quality,$name,$class)};\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} = \n                substr($self->{contigs}->{$_}->{'consensus'},$points[0],$points[1]-$points[0]);\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_singlets\".\n                 \"_and_singletons: Done setting the quality trimpoints.\\n\");\n    return;\n}  # end set_trim_points_singlet\n\n=head2 set_trim_points_doublets()\n\n Title   : set_trim_points_doublets()\n Usage   : $o_consed->set_trim_points_doublets();\n Function: Set the trim points for doublets based on quality. Uses the\n\t   Bio::Tools::Alignment::Trim object. Use at your own risk because\n           the Bio::Tools::Alignment::Trim object was designed specifically\n           for me and is mysterious in its ways. Every time somebody other\n           then me uses it you risk a biblical plague being loosed on your\n           city.\n Returns : Nothing.\n Args    : None.\n Notes   : Working on exceptions here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\nsub set_trim_points_doublets {\n    my $self = shift;\n    my @points;\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Restoring zeros for doublets.\\n\");\n    # &show_missing_sequence($self);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Setting doublet trim points.\\n\");\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            # my ($self,$sequence,$quality,$name,$class) = @_;\n            my @quals = split(' ',$self->{'contigs'}->{$_}->{'quality'});\n\n\t    @points = $self->{o_trim}->trim_doublet\n                ($self->{'contigs'}->{$_}->{'consensus'},\n                 $self->{'contigs'}->{$_}->{'quality'},\n                 $self->{'contigs'}->{$_}->{name},\n                 $self->{'contigs'}->{$_}->{'class'});\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n            # now set this\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} =\n                substr($self->{contigs}->{$_}->{'consensus'},\n                       $points[0],$points[1]-$points[0]);\n\t    # 010102 the deprecated way to do things:\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Done setting doublet trim points.\\n\"); \n    return;\n} # end set_trim_points_doublets\n\n=head2 get_trimmed_sequence_by_name($name)\n\n Title   : get_trimmed_sequence_by_name($name)\n Usage   : $o_consed->get_trimmed_sequence_by_name($name);\n Function: Returns the trimmed_sequence of a contig with {name} eq $name.\n Returns : A scalar- the trimmed sequence.\n Args    : The {name} of a contig.\n Notes   : \n\n\nsub get_trimmed_sequence_by_name {\n    my ($self,$name) = @_;\n    my $trimmed_sequence;\n    my $contigname = &get_contig_number_by_name($self,$name);\n    my $class = $self->{'contigs'}->{$contigname}->{'class'};\n    # what is this business and who was smoking crack while writing this?\n    # if ($class eq \"singlet\") {\n    # send the sequence, the quality, and the name\n    # $trimmed_sequence = $self->{o_trim}->trim_singlet\n    #  ($self->{'contigs'}->{$contigname}->{consensus},\n    #   $self->{'contigs'}->{$contigname}->{'quality'},$name);\n    # }\n    return $self->{'contigs'}->{$contigname}->{'sequence_trimmed'};\n}\n\n=head2 set_dash_present_in_sequence_name(\"yes\")\n\n Title   : set_dash_present_in_sequence_name(\"yes\")\n Usage   : $o_consed->set_dash_present_in_sequence_name(\"yes\");\n Function: Deprecated. Part of an uncompleted thought. (\"Oooh! Shiny!\")\n Returns : Nothing.\n Args    : \"yes\" to set {dash_present_in_sequence_name} to 1\n Notes   : \n\n\nsub set_dash_present_in_sequence_name {\n    my ($self,$dash_present) = @_;\n    if ($dash_present eq \"yes\") {\n\t$self->{'dash_present_in_sequence_name'} = 1;\n    }\n    else {\n\t$self->{'dash_present_in_sequence_name'} = 0;\n    }\n    return $self->{'dash_present_in_sequence_name'};\n} # end set_dash_present_in_sequence_name\n\n=head2 set_doublets()\n\n Title   : set_doublets()\n Usage   : $o_consed->set_doublets();\n Function: Find pairs that have similar names and mark them as doublets\n\t   and set the {name}.\n Returns : 0 or 1.\n Args    : None.\n\nA complicated subroutine that iterates over the\nBio::Tools::Alignment::Consed looking for contigs of 2. If the forward\nand reverse designator are removed from each of the reads in\n{'member_array'} and the remaining reads are the same, {name} is set\nto that name and the contig's class is set as \"doublet\".  If any of\nthose cases fail the contig is marked as a \"pair\".\n\n\n#' make my emacs happy\n\nsub set_doublets {\n    my ($self) = @_;\n    # set the designators in the Bio::Tools::Alignment::Trim object\n\n    $self->{'o_trim'}->set_designators($self->{'reverse_designator'},\n\t\t\t\t       $self->{'forward_designator'});\n    foreach my $key_contig (sort keys %{$self->{'contigs'}}) {\n\n\t# if there is a member array (why would there not be? This should be a die()able offence\n\t# but for now I will leave it\n\tif ($self->{'contigs'}->{$key_contig}->{'member_array'}) {\n\t    # if there are two reads in this contig \n\t    # i am pretty sure that this is wrong but i am keeping it for reference\n\t    # if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2 || !$self->{'contigs'}->{$key_contig}->{'class'}) {\n\t    # <seconds later>\n\t    # <nod> WRONG. Was I on crack?\n\t    if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = 2;\n\t\t$self->debug(\"\\tThere are 2 members! Looking for the contig name...\\n\");\n\t\tmy $name = _get_contig_name($self,$self->{'contigs'}->{$key_contig}->{'member_array'});\n\t\t$self->debug(\"The name is $name\\n\") if defined $name;\n\t\tif ($name) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'name'} = $name;\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"doublet\";\n\t\t} else {\n\t\t    $self->debug(\"$key_contig is a pair.\\n\");\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"pair\";\n\t\t}\n\t    }\n            # this is all fair and good but what about singlets?\n            # they have one reads in the member_array but certainly are not singletons\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 1) {\n\t\t# set the name to be the name of the read\n\t\t$self->{'contigs'}->{$key_contig}->{name} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}}[0];\n\t\t# set the number of members to be one\n\t\t$self->{'contigs'}->{$key_contig}->{num_members} = 1;\n\t\t# if this was a singlet, it would already belong to the class \"singlet\"\n\t\t# so leave it alone\n\t\t# if it is not a singlet, it is a singleton! lablel it appropriately\n\t\tunless ($self->{'contigs'}->{$key_contig}->{'class'}) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"singleton\";\n\t\t}\n\t    }\n            # set the multiplet characteristics\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} >= 3) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\t\t$self->{'contigs'}->{$key_contig}->{'class'} = \"multiplet\";\n\t    }\n\t    $self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\n\t}\n    }\n    $self->{'doublets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end set_doublets\n\n=head2 set_singlets\n\n Title   : set_singlets\n Usage   : $o_consed->set_singlets();\n Function: Read in a singlets file and place them into the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : Nothing.\n Args    : A scalar to turn on verbose parsing of the singlets file.\n Notes   : \n\n\nsub set_singlets {\n    # parse out the contents of the singlets file\n    my ($self) = @_;\n    $self->debug(\"Bio::Tools::Alignment::Consed Adding singlets to the contig hash...\\n\"); \n    my $full_filename = $self->{'filename'};\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: \\$full_filename is $full_filename\\n\");\n    $full_filename =~ m/(.*\\/)(.*ace.*)$/; \t\t\t       \n    my ($base_path,$filename) = ($1,$2);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: singlets filename is $filename and \\$base_path is $base_path\\n\");\n    $filename =~ m/(.*)ace.*$/;\n    my $singletsfile = $base_path.$1.\"singlets\";\n    $self->debug(\"\\$singletsfile is $singletsfile\\n\");\n     if (!-f $singletsfile) {\n          # there is no singlets file.\n          $self->{'singlets_set'} = \"done\";\n          return;\n     }\n\t$self->debug(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    my $singlets_fh = Bio::Root::IO->new(-file => $singletsfile);\n    my ($sequence,$name,$count);\n    while ($_ = $singlets_fh->_readline()) {\n\tchomp $_;\n\tif (/\\>/) {\n\t    if ($name && $sequence) {\n\t\t$self->debug(\"Adding $name with sequence $sequence to hash...\\n\");\n\t\tpush @{$self->{'contigs'}->{$name}->{'member_array'}},$name;\n\t\t$self->{'contigs'}->{$name}->{'consensus'} = $sequence;\n\t\t$self->{'contigs'}->{$name}->{'name'} = $name;\n\t\t$self->{'contigs'}->{$name}->{\"singlet\"} = 1;\n\t\t$self->{'contigs'}->{$name}->{'class'} = \"singlet\";\n\t    }\n\t    $sequence = $name = undef;\n\t    $count++;\n\t    m/^\\>(.*)\\s\\sCHROMAT/;\n\t    $name = $1;\n\t    if (!$name) {\n\t\tm/\\>(\\S+)\\s/;\n\t\t$name = $1;\n\t    }\n\t}\n\telse { $sequence .= $_; }\t\n    }\n    if ($name && $sequence) {\n\t$self->debug(\"Pushing the last of the singlets ($name)\\n\");\n\t@{$self->{'contigs'}->{$name}->{'member_array'}} = $name;\n\t$self->{'contigs'}->{$name}->{'consensus'} = $sequence;\n\t$self->{'contigs'}->{$name}->{'name'} = $name;\n\t$self->{'contigs'}->{$name}->{\"singlet\"} = 1;\n\t$self->{'contigs'}->{$name}->{'class'} = \"singlet\";\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: Done adding singlets to the singlets hash.\\n\");\n    $self->{'singlets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end sub set_singlets\n\n=head2 get_singlets()\n\n Title   : get_singlets()\n Usage   : $o_consed->get_singlets();\n Function: Return the keynames of the singlets.\n Returns : An array containing the keynames of all \n           Bio::Tools::Alignment::Consed sequences in the class \"singlet\".\n Args    : None.\n Notes   : \n\n\nsub get_singlets {\n    # returns an array of singlet names\n    # singlets have \"singlet\"=1 in the hash\n    my $self = shift;\n    if (!$self->{singlets_set}) {\n\t$self->debug(\"You need to set the singlets before you get them. Doing that now.\");\n\t$self->set_singlets();\n    }\t\n\n    my (@singlets,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\t# @array = @{$Consed::contigs{$key}->{'member_array'}};\n\t# somethimes a user will try to get a list of singlets before the classes for the rest of the\n\t# contigs has been set (see t/test.t for how I figured this out. <bah>\t\t\t\n\t# so either way, just return class=singlets\n\tif (!$self->{'contigs'}->{$key}->{'class'}) {\n\t    # print(\"$key has no class. why?\\n\");\n\t}\n\telsif ($self->{'contigs'}->{$key}->{'class'} eq \"singlet\") {\n\t    push @singlets,$key;\n\t}\n    }\n    return @singlets;\n}\n\n=head2 set_quality_by_name($name,$quality)\n\n Title   : set_quality_by_name($name,$quality)\n Usage   : $o_consed->set_quality_by_name($name,$quality);\n Function: Deprecated. Make the contig with {name} have {'quality'} $quality.\n           Probably used for testing.\n Returns : Nothing.\n Args    : The name of a contig and a scalar for its quality.\n Notes   : Deprecated.\n\n\nsub set_quality_by_name {\n    # this is likely deprecated\n    my ($self,$name,$quality) = shift;\n    my $return;\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'} eq \"$name\" || $self->{'contigs'}->{'name'} eq \"$name\") {\n\t    $self->{'contigs'}->{'quality'} = $quality;\n\t    $return=1;\n\t}\n    }\n    if ($return) { return \"0\"; } else { return \"1\"; }\n}\t\t\t\t# end set quality by name\n\n=head2 set_singlet_quality()\n\n Title   : set_singlet_quality()\n Usage   : $o_consed->set_singlet_quality();\n Function: For each singlet, go to the appropriate file in phd_dir and read\n           in the phred quality for that read and place it into {'quality'}\n Returns : 0 or 1.\n Args    : None.\n Notes   : This is the next subroutine that will receive substantial revision\n           in the next little while. It really should eval the creation of\n           Bio::Tools::Alignment::Phred objects and go from there. \n\n\nsub set_singlet_quality {\n    my $self = shift;\n    my $full_filename = $self->{'filename'};\n    $full_filename =~ m/(.*\\/)(.*)ace.*$/;\n    my ($base_path,$filename) = ($1,\"$2\".\"qual\");\n    my $singletsfile = $base_path.$filename;\n    if (-f $singletsfile) {\n\t# print(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    }\n    else {\n\t$self->warn(\"$singletsfile is not a file. Sorry.\\n\");\n\treturn;\n    }\n\tmy $singlets_fh = Bio::Root::IO->new(-file => $singletsfile);\n\tmy ($sequence,$name,$count);\n    my ($identity,$line,$quality,@qline);\n    while ($line = $singlets_fh->_readline()) {\n\tchomp $line;\n\tif ($line =~ /^\\>/) {\n\t    $quality = undef;\n\t    $line =~ m/\\>(\\S*)\\s/;\n\t    $identity = $1;\n\t}\n\telse {\n\t    if ($self->{'contigs'}->{$identity}) {\n\t\t$self->{'contigs'}->{$identity}->{'quality'} .= \"$line \";\n\t    }\n\t}\n\n    }\n    return 0;\n}\n\n=head2 set_contig_quality()\n\n Title   : set_contig_quality()\n Usage   : $o_consed->set_contig_quality();\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n Notes   : Deprecated. Really. Trust me.\n\n\nsub set_contig_quality {\n    # note: contigs _include_ singletons but _not_ singlets\n    my ($self) = shift;\n          # the unexpected results I am referring to here are a doubling of quality values.\n          # the profanity I uttered on discovering this reminded me of the simpsons:\n          # Ned Flanders: \"That is the loudest profanity I have ever heard!\"\n     $self->warn(\"set_contig_quality is deprecated and will likely produce unexpected results\");\n    my $full_filename = $self->{'filename'};\n    # Run_SRC3700_2000-08-01_73+74.fasta.screen.contigs.qual\n    # from Consed.pm\n    $full_filename =~ m/(.*\\/)(.*)ace.*$/;\n    my ($base_path,$filename) = ($1,\"$2\".\"contigs.qual\");\n    my $singletsfile = $base_path.$filename;\n    if (-f $singletsfile) {\n\t# print(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    }\n    else {\n\t$self->warn(\"Bio::Tools::Alignment::Consed::set_contig_quality $singletsfile is not a file. Sorry.\\n\");\n\treturn;\n    }\n    my $contig_quality_fh = Bio::Root::IO->new(-file => $singletsfile);\n\n    my ($sequence,$name,$count,$identity,$line,$quality);\n    while ($line = $contig_quality_fh->_readline()) {\n\tchomp $line;\n\tif ($line =~ /^\\>/) {\n\t    $quality = undef;\n\t    $line =~ m/\\>.*Contig(\\d+)\\s/;\n\t    $identity = $1;\n\t}\n\telse {\n\t    if ($self->{'contigs'}->{$identity} ) {\n\t\t$self->{'contigs'}->{$identity}->{'quality'} .= \" $line\";\n\t    }\n\t}\n    }\n}\t\t\t\t# end set_contig_quality\n\n=head2 get_multiplets()\n\n Title   : get_multiplets()\n Usage   : $o_consed->get_multiplets();\n Function: Return the keynames of the multiplets.\n Returns : Returns an array containing the keynames of all \n           Bio::Tools::Alignment::Consed sequences in the class \"multiplet\".\n Args    : None.\n Notes   : \n\n\nsub get_multiplets {\n\t    # returns an array of multiplet names\n\t    # multiplets have # members > 2\n    my $self = shift;\n    my (@multiplets,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$key}->{'class'}) {\n\t    if ($self->{'contigs'}->{$key}->{'class'} eq \"multiplet\") {\n\t\tpush @multiplets,$key;\n\t    }\n\t}\n    }\n    return @multiplets;\n}\n\n=head2 get_all_members()\n\n  Title   : get_all_members()\n  Usage   : @all_members = $o_consed->get_all_members();\n  Function: Return a list of all of the read names in the \n            Bio::Tools::Alignment::Consed object.\n  Returns : An array containing all of the elements in all of the\n            {'member_array'}s.\n  Args    : None.\n  Notes   : \n\n\nsub get_all_members {\n    my $self = shift;\n    my @members;\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\tif ($key =~ /^singlet/) {\n\t    push @members,$self->{'contigs'}->{$key}->{'member_array'}[0];\n\t}\n\telsif ($self->{'contigs'}->{$key}->{'member_array'}) {\n\t    push @members,@{$self->{'contigs'}->{$key}->{'member_array'}};\n\t}\n\t# else {\n\t#\tprint(\"Bio::Tools::Alignment::Consed: $key is _not_ an array. Pushing $self->{'contigs'}->{$key}->{'member_array'} onto \\@members\\n\");\n\t#\tpush @members,$self->{'contigs'}->{$key}->{'member_array'};\n\t# }\n    }\n    return @members;\n}\n\n=head2 sum_lets($total_only)\n\n Title   : sum_lets($total_only)\n Usage   : $statistics = $o_consed->sum_lets($total_only);\n Function: Provide numbers for how many sequences were accounted for in the\n           Bio::Tools::Alignment::Consed object.\n Returns : If a scalar is present, returns the total number of\n           sequences accounted for in all classes. If no scalar passed\n           then returns a string that looks like this:\n           Singt/singn/doub/pair/mult/total : 2,0,1(2),0(0),0(0),4\n           This example means the following: There were 1 singlets.\n           There were 0 singletons.  There were 1 doublets for a total\n           of 2 sequences in this class.  There were 0 pairs for a\n           total of 0 sequences in this class.  There were 0\n           multiplets for a total of 0 sequences in this class.  There\n           were a total of 4 sequences accounted for in the\n           Bio::Tools::Alignment::Consed object.   \n Args : A scalar is optional to change the way the numbers are returned.  \n Notes:\n\n\nsub sum_lets {\n    my ($self,$total_only) = @_;\n    my ($count,$count_multiplets,$multiplet_count);\n    my $singlets = &get_singlets($self); $count += $singlets;\n    my $doublets = &get_doublets($self); $count += ($doublets * 2);\n    my $pairs = &get_pairs($self); $count += ($pairs * 2);\n    my $singletons = &get_singletons($self); $count += $singletons;\n    my @multiplets = &get_multiplets($self);\n    $count_multiplets = @multiplets;\n    my $return_string;\n    foreach (@multiplets) {\n\tmy $number_members = $self->{'contigs'}->{$_}->{num_members};\t\n\t$multiplet_count += $number_members;\n    }\n    if ($multiplet_count) {\n\t$count += $multiplet_count;\n    }\n    foreach (qw(multiplet_count singlets doublets pairs singletons\n                multiplets count_multiplets)) {\n\tno strict 'refs';\t# renege for the block\n\tif (!${$_}) {\n            ${$_} = 0;\n\t}\n    }\n    if (!$multiplet_count) { $multiplet_count = 0; }\n    if ($total_only) {\n        return $count;\n    }\n    $return_string = \"Singt/singn/doub/pair/mult/total : \".\n        \"$singlets,$singletons,$doublets(\".\n         ($doublets*2).\"),$pairs(\".($pairs*2).\n        \"),$count_multiplets($multiplet_count),$count\";\n    return $return_string;\n}\n\n=head2 write_stats()\n\n Title   : write_stats()\n Usage   : $o_consed->write_stats();\n Function: Write a file called \"statistics\" containing numbers similar to\n\t   those provided in sum_lets().\n Returns : Nothing. Write a file in $o_consed->{path} containing something\n\t   like this:\n\n           0,0,50(100),0(0),0(0),100\n\n           Where the numbers provided are in the format described in the\n\t   documentation for sum_lets().\n Args    : None.\n Notes   : This might break platform independence, I do not know.\n\nSee L<sum_lets()|sum_lets>\n\n\nsub write_stats {\n    # worry about platform dependence here?\n    # oh shucksdarn.\n    my $self = shift;\n    my $stats_filename = $self->{'path'}.\"statistics\";\n    my $statistics_raw = $self->sum_lets;\n    my ($statsfilecontents) = $statistics_raw =~ s/.*\\ \\:\\ //g;\n    umask 0001;\n    my $fh = Bio::Root::IO->new(-file=>\"$stats_filename\");\n    # open(STATSFILE,\">$stats_filename\") or print(\"Could not open the statsfile: $!\\n\");\n    $fh->_print(\"$statsfilecontents\");\n    # close STATSFILE;\n    $fh->close();\n}\n\n=head2 get_singletons()\n\n Title   : get_singletons()\n Usage   : @singletons = $o_consed->get_singletons();\n Function: Return the keynames of the singletons.\n Returns : Returns an array containing the keynames of all\n\t   Bio::Tools::Alignment::Consed sequences in the class \"singleton\".\n Args    : None.\n Notes   : \n\n\nsub get_singletons {\n\t\t# returns an array of singleton names\n\t\t# singletons are contigs with one member (see consed documentation)\n\tmy $self = shift;\n\tmy (@singletons,@array);\n\tforeach my $key (sort keys %{$self->{'contigs'}}) {\n\t\tif ($self->{'contigs'}->{$key}->{'class'}) {\n\t\t    # print (\"$key class: $self->{'contigs'}->{$key}->{'class'}\\n\");\n\t\t}\n\t\telse {\n\t\t    # print(\"$key belongs to no class. why?\\n\");\n\t\t}\n\t\tif ($self->{'contigs'}->{$key}->{'member_array'}) {\n\t\t\t@array = @{$self->{'contigs'}->{$key}->{'member_array'}};\n\t\t}\n\t\tmy $num_array_elem = @array;\n\t\tif ($num_array_elem == 1 && $self->{'contigs'}->{$key}->{'class'} && $self->{'contigs'}->{$key}->{'class'} eq \"singleton\") { push @singletons,$key; }\n\t}\n\treturn @singletons;\n}\n\n=head2 get_pairs()\n\n Title   : get_pairs()\n Usage   : @pairs = $o_consed->get_pairs();\n Function: Return the keynames of the pairs.\n Returns : Returns an array containing the keynames of all\n           Bio::Tools::Alignment::Consed sequences in the class \"pair\".\n Args    : None.\n Notes   : \n\n\nsub get_pairs {\n    # returns an array of pair contig names\n    # a pair is a contig of two where the names do not match\n    my $self = shift;\n    my (@pairs,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n        if ($self->{'contigs'}->{$key}->{'member_array'}) {\n            if (@{$self->{'contigs'}->{$key}->{'member_array'}} == 2 &&\n                $self->{'contigs'}->{$key}->{'class'} eq \"pair\") {\n                push @pairs,$key;\n            }\n        }\n    }\n    return @pairs;\n}\n\n=head2 get_name($contig_keyname)\n\n Title   : get_name($contig_keyname)\n Usage   : $name = $o_consed->get_name($contig_keyname);\n Function: Return the {name} for $contig_keyname.\n Returns : A string. ({name})\n Args    : A contig keyname.\n Notes   : \n\n\nsub get_name {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'name'};\n}\n\n=head2 _get_contig_name(\\@array_containing_reads)\n\n Title   : _get_contig_name(\\@array_containing_reads)\n Usage   : $o_consed->_get_contig_name(\\@array_containing_reads);\n Function: The logic for the set_doublets subroutine.\n Returns : The name for this contig.\n Args    : A reference to an array containing read names.\n Notes   : Depends on reverse_designator. Be sure this is set the way you\n\t   intend.\n\n\nsub _get_contig_name {\n    my ($self,$r_array) = @_;\n    my @contig_members = @$r_array;\n    my @name_nodir;\n    foreach (@contig_members) {\n        # how can I distinguish the clone name from the direction label?\n        # look for $Consed::reverse_designator and $Consed::forward_designator\n        # what if you do not find _any_ of those?\n        my $forward_designator = $self->{'forward_designator'} || \"f\";\n        my $reverse_designator = $self->{'reverse_designator'} || \"r\";\n        my $any_hits = /(.+)($forward_designator.*)/ || /(.+)($reverse_designator.*)/||/(.+)(_.+)/;\n        my $name = $1;\n        my $suffix = $2;\n        if ($name) {\n            # print(\"\\t\\$name is $name \");\n        }\n        if ($suffix) {\n            # print(\"and \\$suffix is $suffix.\\n\");\n        }\n                                # Jee, I hope we get a naming convention soon\n        if ($suffix) {\n            if ($suffix =~ /^$forward_designator/ || $suffix =~ /^$reverse_designator/) {\n                push @name_nodir,$name;\n            }\n\t\t\t\t# bugwatch here! should this be unnested?\n            else {\n                push @name_nodir,\"$name$suffix\";\n            }\n        }\n    }\n    # print(\"\\@name_nodir: @name_nodir\\n\");\n    my $mismatch = 0;\n    for (my $counter=0; $counter<@name_nodir;$counter++) {\n        next if ($name_nodir[0] eq $name_nodir[$counter]);\n        $mismatch = 1;\n    }\n    if ($mismatch == 0) {\n        # print(\"\\tYou have a cohesive contig named $name_nodir[0].\\n\\n\");\n        return $name_nodir[0];\n    } else {\n        # print(\"\\tYou have mixed names in this contig.\\n\\n\");\n    }\n}                               # end _get_contig_name\n\n=head2 get_doublets()\n\n Title   : get_doublets()\n Usage   : @doublets = $o_consed->get_doublets();\n Function: Return the keynames of the doublets.\n Returns : Returns an array containing the keynames of all\n           Bio::Tools::Alignment::Consed sequences in the class \"doublet\".\n Args    : None.\n Notes   : \n\n\nsub get_doublets {\n    my $self = shift;\n    if (!$self->{doublets_set}) {\n        $self->warn(\"You need to set the doublets before you can get them. Doing that now.\");\n        $self->set_doublets();\n    }\n    my @doublets;\n    foreach (sort keys %{$self->{'contigs'}}) {\n        if ($self->{'contigs'}->{$_}->{name} && $self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            push @doublets,$_;\n        }\n    }\n    return @doublets;\n}                               # end get_doublets\n\n=head2 dump_hash()\n\n Title   : dump_hash()\n Usage   : $o_consed->dump_hash();\n Function: Use dumpvar.pl to dump out the Bio::Tools::Alignment::Consed\n           object to STDOUT.\n Returns : Nothing.\n Args    : None.\n Notes   : I used this a lot in debugging.\n\n\nsub dump_hash {\n    my $self = shift;\n    my $dumper = new Dumpvalue;\n    $self->debug( \"Bio::Tools::Alignment::Consed::dump_hash - \".\n                  \"The following is the contents of the contig hash...\\n\");\n    $dumper->dumpValue($self->{'contigs'});\n}\n\n=head2 dump_hash_compact()\n\n Title   : dump_hash_compact()\n Usage   : $o_consed->dump_hash_compact();\n Function: Dump out the Bio::Tools::Alignment::Consed object in a compact way.\n Returns : Nothing.\n Args    : Nothing.\n Notes   : Cleaner then dumpValue(), dumpHash(). I used this a lot in\n           debugging.\n\n\nsub dump_hash_compact {\n    no strict 'refs';           # renege for the block\n    my ($self,$sequence) = @_;\n    # get the classes\n    my @singlets = $self->get_singlets();\n    my @singletons = $self->get_singletons();\n    my @doublets = $self->get_doublets();\n    my @pairs = $self->get_pairs();\n    my @multiplets = $self->get_multiplets();\n    print(\"Name\\tClass\\tMembers\\tQuality?\\n\");\n    foreach (@singlets) {\n        my @members = $self->get_members($_);\n        print($self->get_name($_).\"\\tsinglets\\t\".(join',',@members).\"\\t\");\n        if ($self->{'contigs'}->{$_}->{'quality'}) {\n            print(\"qualities found here\\n\");\n        } else {\n            print(\"no qualities found here\\n\");\n        }\n\n    }\n    foreach (@singletons) {\n        my @members = $self->get_members($_);\n        print($self->get_name($_).\"\\tsingletons\\t\".(join',',@members).\"\\t\");\n        if ($self->{'contigs'}->{$_}->{'quality'}) {\n            print(\"qualities found here\\n\");\n        } else {\n            print(\"no qualities found here\\n\");\n        }\n    }\n    foreach my $pair (@pairs) {\n        my @members = $self->get_members($pair);\n        my $name;\n        if (!$self->get_name($pair)) {\n            $name = \"BLANK\";\n        } else {\n            $name = $self->get_name($pair);\n        }\n        print(\"$name\\tpairs\\t\".(join',',@members).\"\\n\");\n    }\n    foreach (@doublets) {\n        my @members = $self->get_members_by_name($_);\n        print(\"$_\\tdoublets\\t\".(join',',@members).\"\\t\");\n        my $contig_number = &get_contig_number_by_name($self,$_);\n        if ($self->{'contigs'}->{$contig_number}->{'quality'}) {\n            print(\"qualities found here\\n\");\n        } else {\n            print(\"no qualities found here\\n\");\n        }\n        # print($_.\"\\tdoublets\\t\".(join',',@members).\"\\n\");\n    }\n    foreach (@multiplets) {\n        my @members = $self->get_members($_);\n        print(\"Contig $_\".\"\\tmultiplets\\t\".(join',',@members).\"\\n\");\n    }\n}                               # end dump_hash_compact\n\n=head2 get_phreds()\n\n Title   : get_phreds()\n Usage   : @phreds = $o_consed->get_phreds();\n Function: For each doublet in the Bio::Tools::Alignment::Consed hash, go\n           and get the phreds for the top and bottom reads. Place them into\n           {top_phreds} and {bottom_phreds}.\n Returns : Nothing.\n Args    : Nothing.\n\nRequires parse_phd() and reverse_and_complement(). I realize that it\nwould be much more elegant to pull qualities as required but there\nwere certain \"features\" in the acefile that required a bit more\ndetailed work be done to get the qualities for certain parts of the\nconsensus sequence. In order to make _sure_ that this was done\nproperly I wrote things to do all steps and then I used dump_hash()\nand checked each one to ensure expected bahavior. I have never changed\nthis, so there you are.\n\n\nsub get_phreds {\n    # this subroutine is the target of a rewrite to use the Bio::Tools::Alignment::Phred object.\n    my $self = shift;    \n    my $current_contig;\n    foreach $current_contig (sort keys %{$self->{'contigs'}}) {\t\n\tif ($self->{'contigs'}->{$current_contig}->{'class'} eq \"doublet\") {\n\t    $self->debug(\"$current_contig is a doublet. Going to parse_phd for top($self->{'contigs'}->{$current_contig}->{'top_name'}) and bottom($self->{'contigs'}->{$current_contig}->{'bottom_name'})\\n\");\n\t    my $r_phreds_top = &parse_phd($self,$self->{'contigs'}->{$current_contig}->{'top_name'});\n\t    my $r_phreds_bottom = &parse_phd($self,$self->{'contigs'}->{$current_contig}->{'bottom_name'});\n\t    if ($self->{'contigs'}->{$current_contig}->{'top_complement'} eq \"C\") {\n\t\t# print(\"Reversing and complementing...\\n\");\n\t\t$r_phreds_top = &reverse_and_complement($r_phreds_top);\n\t    }\n\t    if ($self->{'contigs'}->{$current_contig}->{'bottom_complement'} eq \"C\") {\n\t\t$r_phreds_bottom = &reverse_and_complement($r_phreds_bottom);\n\t    }\n\t    $self->{'contigs'}->{$current_contig}->{'top_phreds'} = $r_phreds_top;\n\t    $self->{'contigs'}->{$current_contig}->{'bottom_phreds'} = $r_phreds_bottom;\n\t}\n    }\n}\n\n=head2 parse_phd($read_name)\n\n Title   : parse_phd($read_name)\n Usage   : $o_consed->parse_phd($read_name);\n Function: Suck in the contents of a .phd file.\n Returns : A reference to an array containing the quality values for the read.\n Args    : The name of a read.\n Notes   : This is a significantly weak subroutine because it was always\n\t   intended that these functions, along with the functions provided by\n\t   get_phreds() be put into the Bio::SeqIO:phd module. This is done\n           now but the Bio::Tools::Alignment::Consed module has not be\n           rewritten to reflect this change.\n\nSee L<Bio::SeqIO::phd> for more information.","parameters":[{"label":"$self"},{"label":"$sequence_name"}],"label":"parse_phd($self,$sequence_name)"}},{"name":"Bio","kind":12,"containerName":"Root::IO","line":1652},{"definition":"sub","children":[{"definition":"my","name":"$r_source","containerName":"reverse_and_complement","localvar":"my","kind":13,"line":1677},{"definition":"my","name":"$r_destination","containerName":"reverse_and_complement","localvar":"my","kind":13,"line":1678},{"line":1679,"name":"$r_destination","kind":13,"containerName":"reverse_and_complement"},{"line":1679,"name":"$r_source","containerName":"reverse_and_complement","kind":13},{"line":1679,"name":"$r_destination","kind":13,"containerName":"reverse_and_complement"},{"name":"$r_destination","kind":13,"containerName":"reverse_and_complement","line":1680}],"containerName":"main::","name":"reverse_and_complement","line":1676,"kind":12,"range":{"start":{"character":0,"line":1676},"end":{"character":9999,"line":1681}}},{"line":1679,"name":"reverse_recurse","kind":12},{"signature":{"label":"reverse_recurse($$)","parameters":[{"label":"$$"}],"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_reverse_designator {\n    my ($self,$reverse_designator) = @_;\n    $self->{'reverse_designator'} = $reverse_designator;\n    $self->{'o_trim'}->set_reverse_designator($reverse_designator);\n    return $self->{'reverse_designator'};\n}\t\t\t\t# end set_reverse_designator\n\n=head2 set_forward_designator($some_string)\n\n Title   : set_forward_designator($some_string)\n Usage   : $o_consed->set_forward_designator($some_string);\n Function: Set the designator for the forward read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{forward_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_forward_designator {\n    my ($self,$forward_designator) = @_;\n    $self->{'forward_designator'} = $forward_designator;\n    $self->{'o_trim'}->set_forward_designator($forward_designator);\n    return $self->{'forward_designator'};\n}\t\t\t\t# end set_forward_designator\n\n=head2 set_designator_ignore_case(\"yes\")\n\n Title   : set_designator_ignore_case(\"yes\")\n Usage   : $o_consed->set_designator_ignore_case(\"yes\");\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n\nDeprecated. Really. Trust me.\n\n\nsub set_designator_ignore_case {\n    my ($self,$ignore_case) = @_;\n    if ($ignore_case eq \"yes\") {\n\t$self->{'designator_ignore_case'} = 1;\n    }\n    return $self->{'designator_ignore_case'};\n}\t\t\t\t# end set_designator_ignore_case\n\n=head2 set_trim_points_singlets_and_singletons()\n\n Title   : set_trim_points_singlets_and_singletons()\n Usage   : $o_consed->set_trim_points_singlets_and_singletons();\n Function: Set the trim points for singlets and singletons based on\n\t   quality.  Uses the Bio::Tools::Alignment::Trim object. Use\n\t   at your own risk because the Bio::Tools::Alignment::Trim\n\t   object was designed specifically for me and is mysterious\n\t   in its ways. Every time somebody other then me uses it a\n\t   swarm of locusts decends on a small Central American\n\t   village so do not say you weren't warned.\n Returns : Nothing.\n Args    : None.\n\nWorking on exceptions and warnings here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\n#' to make my emacs happy\n\nsub set_trim_points_singlets_and_singletons {\n    my ($self) = @_;\n    $self->debug(\"Consed.pm : \\$self is $self\\n\");\n    my (@points,$trimmed_sequence);\n    if (!$self->{'doublets_set'}) {\n        $self->debug(\"You need to set the doublets before you use \".\n                     \"set_trim_points_singlets_and_doublets. Doing that now.\");\n\t$self->set_doublets();\n    }\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"singlet\") {\n\t    $self->debug(\"Singlet $_\\n\");\n\t    # this is what Warehouse wants\n\t    #         my ($self,$sequence,$quality,$name) = @_;\n\t    # this is what Bio::Tools::Alignment::Trim::trim_singlet wants:\n\t    # my ($self,$sequence,$quality,$name,$class) = @_;\n\t    # the following several lines are to make the parameter passing legible.\n\t    my ($sequence,$quality,$name,$class);\n\t    $sequence = $self->{'contigs'}->{$_}->{'consensus'};\n\t    if (!$self->{'contigs'}->{$_}->{'quality'}) { $quality = \"unset\"; }\n\t    else { $quality = $self->{'contigs'}->{$_}->{'quality'}; }\n\t    $name = $self->{'contigs'}->{$_}->{'name'};\n\t    $class = $self->{'contigs'}->{$_}->{'class'};\n\t    @points = @{$self->{'o_trim'}->trim_singlet($sequence,$quality,$name,$class)};\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} = \n                substr($self->{contigs}->{$_}->{'consensus'},$points[0],$points[1]-$points[0]);\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_singlets\".\n                 \"_and_singletons: Done setting the quality trimpoints.\\n\");\n    return;\n}  # end set_trim_points_singlet\n\n=head2 set_trim_points_doublets()\n\n Title   : set_trim_points_doublets()\n Usage   : $o_consed->set_trim_points_doublets();\n Function: Set the trim points for doublets based on quality. Uses the\n\t   Bio::Tools::Alignment::Trim object. Use at your own risk because\n           the Bio::Tools::Alignment::Trim object was designed specifically\n           for me and is mysterious in its ways. Every time somebody other\n           then me uses it you risk a biblical plague being loosed on your\n           city.\n Returns : Nothing.\n Args    : None.\n Notes   : Working on exceptions here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\nsub set_trim_points_doublets {\n    my $self = shift;\n    my @points;\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Restoring zeros for doublets.\\n\");\n    # &show_missing_sequence($self);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Setting doublet trim points.\\n\");\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            # my ($self,$sequence,$quality,$name,$class) = @_;\n            my @quals = split(' ',$self->{'contigs'}->{$_}->{'quality'});\n\n\t    @points = $self->{o_trim}->trim_doublet\n                ($self->{'contigs'}->{$_}->{'consensus'},\n                 $self->{'contigs'}->{$_}->{'quality'},\n                 $self->{'contigs'}->{$_}->{name},\n                 $self->{'contigs'}->{$_}->{'class'});\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n            # now set this\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} =\n                substr($self->{contigs}->{$_}->{'consensus'},\n                       $points[0],$points[1]-$points[0]);\n\t    # 010102 the deprecated way to do things:\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Done setting doublet trim points.\\n\"); \n    return;\n} # end set_trim_points_doublets\n\n=head2 get_trimmed_sequence_by_name($name)\n\n Title   : get_trimmed_sequence_by_name($name)\n Usage   : $o_consed->get_trimmed_sequence_by_name($name);\n Function: Returns the trimmed_sequence of a contig with {name} eq $name.\n Returns : A scalar- the trimmed sequence.\n Args    : The {name} of a contig.\n Notes   : \n\n\nsub get_trimmed_sequence_by_name {\n    my ($self,$name) = @_;\n    my $trimmed_sequence;\n    my $contigname = &get_contig_number_by_name($self,$name);\n    my $class = $self->{'contigs'}->{$contigname}->{'class'};\n    # what is this business and who was smoking crack while writing this?\n    # if ($class eq \"singlet\") {\n    # send the sequence, the quality, and the name\n    # $trimmed_sequence = $self->{o_trim}->trim_singlet\n    #  ($self->{'contigs'}->{$contigname}->{consensus},\n    #   $self->{'contigs'}->{$contigname}->{'quality'},$name);\n    # }\n    return $self->{'contigs'}->{$contigname}->{'sequence_trimmed'};\n}\n\n=head2 set_dash_present_in_sequence_name(\"yes\")\n\n Title   : set_dash_present_in_sequence_name(\"yes\")\n Usage   : $o_consed->set_dash_present_in_sequence_name(\"yes\");\n Function: Deprecated. Part of an uncompleted thought. (\"Oooh! Shiny!\")\n Returns : Nothing.\n Args    : \"yes\" to set {dash_present_in_sequence_name} to 1\n Notes   : \n\n\nsub set_dash_present_in_sequence_name {\n    my ($self,$dash_present) = @_;\n    if ($dash_present eq \"yes\") {\n\t$self->{'dash_present_in_sequence_name'} = 1;\n    }\n    else {\n\t$self->{'dash_present_in_sequence_name'} = 0;\n    }\n    return $self->{'dash_present_in_sequence_name'};\n} # end set_dash_present_in_sequence_name\n\n=head2 set_doublets()\n\n Title   : set_doublets()\n Usage   : $o_consed->set_doublets();\n Function: Find pairs that have similar names and mark them as doublets\n\t   and set the {name}.\n Returns : 0 or 1.\n Args    : None.\n\nA complicated subroutine that iterates over the\nBio::Tools::Alignment::Consed looking for contigs of 2. If the forward\nand reverse designator are removed from each of the reads in\n{'member_array'} and the remaining reads are the same, {name} is set\nto that name and the contig's class is set as \"doublet\".  If any of\nthose cases fail the contig is marked as a \"pair\".\n\n\n#' make my emacs happy\n\nsub set_doublets {\n    my ($self) = @_;\n    # set the designators in the Bio::Tools::Alignment::Trim object\n\n    $self->{'o_trim'}->set_designators($self->{'reverse_designator'},\n\t\t\t\t       $self->{'forward_designator'});\n    foreach my $key_contig (sort keys %{$self->{'contigs'}}) {\n\n\t# if there is a member array (why would there not be? This should be a die()able offence\n\t# but for now I will leave it\n\tif ($self->{'contigs'}->{$key_contig}->{'member_array'}) {\n\t    # if there are two reads in this contig \n\t    # i am pretty sure that this is wrong but i am keeping it for reference\n\t    # if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2 || !$self->{'contigs'}->{$key_contig}->{'class'}) {\n\t    # <seconds later>\n\t    # <nod> WRONG. Was I on crack?\n\t    if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = 2;\n\t\t$self->debug(\"\\tThere are 2 members! Looking for the contig name...\\n\");\n\t\tmy $name = _get_contig_name($self,$self->{'contigs'}->{$key_contig}->{'member_array'});\n\t\t$self->debug(\"The name is $name\\n\") if defined $name;\n\t\tif ($name) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'name'} = $name;\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"doublet\";\n\t\t} else {\n\t\t    $self->debug(\"$key_contig is a pair.\\n\");\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"pair\";\n\t\t}\n\t    }\n            # this is all fair and good but what about singlets?\n            # they have one reads in the member_array but certainly are not singletons\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 1) {\n\t\t# set the name to be the name of the read\n\t\t$self->{'contigs'}->{$key_contig}->{name} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}}[0];\n\t\t# set the number of members to be one\n\t\t$self->{'contigs'}->{$key_contig}->{num_members} = 1;\n\t\t# if this was a singlet, it would already belong to the class \"singlet\"\n\t\t# so leave it alone\n\t\t# if it is not a singlet, it is a singleton! lablel it appropriately\n\t\tunless ($self->{'contigs'}->{$key_contig}->{'class'}) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"singleton\";\n\t\t}\n\t    }\n            # set the multiplet characteristics\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} >= 3) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\t\t$self->{'contigs'}->{$key_contig}->{'class'} = \"multiplet\";\n\t    }\n\t    $self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\n\t}\n    }\n    $self->{'doublets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end set_doublets\n\n=head2 set_singlets\n\n Title   : set_singlets\n Usage   : $o_consed->set_singlets();\n Function: Read in a singlets file and place them into the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : Nothing.\n Args    : A scalar to turn on verbose parsing of the singlets file.\n Notes   : \n\n\nsub set_singlets {\n    # parse out the contents of the singlets file\n    my ($self) = @_;\n    $self->debug(\"Bio::Tools::Alignment::Consed Adding singlets to the contig hash...\\n\"); \n    my $full_filename = $self->{'filename'};\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: \\$full_filename is $full_filename\\n\");\n    $full_filename =~ m/(.*\\/)(.*ace.*)$/; \t\t\t       \n    my ($base_path,$filename) = ($1,$2);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: singlets filename is $filename and \\$base_path is $base_path\\n\");\n    $filename =~ m/(.*)ace.*$/;\n    my $singletsfile = $base_path.$1.\"singlets\";\n    $self->debug(\"\\$singletsfile is $singletsfile\\n\");\n     if (!-f $singletsfile) {\n          # there is no singlets file.\n          $self->{'singlets_set'} = \"done\";\n          return;\n     }\n\t$self->debug(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    my $singlets_fh = Bio::Root::IO->new(-file => $singletsfile);\n    my ($sequence,$name,$count);\n    while ($_ = $singlets_fh->_readline()) {\n\tchomp $_;\n\tif (/\\>/) {\n\t    if ($name && $sequence) {\n\t\t$self->debug(\"Adding $name with sequence $sequence to hash...\\n\");\n\t\tpush @{$self->{'contigs'}->{$name}->{'member_array'}},$name;\n\t\t$self->{'contigs'}->{$name}->{'consensus'} = $sequence;\n\t\t$self->{'contigs'}->{$name}->{'name'} = $name;\n\t\t$self->{'contigs'}->{$name}->{\"singlet\"} = 1;\n\t\t$self->{'contigs'}->{$name}->{'class'} = \"singlet\";\n\t    }\n\t    $sequence = $name = undef;\n\t    $count++;\n\t    m/^\\>(.*)\\s\\sCHROMAT/;\n\t    $name = $1;\n\t    if (!$name) {\n\t\tm/\\>(\\S+)\\s/;\n\t\t$name = $1;\n\t    }\n\t}\n\telse { $sequence .= $_; }\t\n    }\n    if ($name && $sequence) {\n\t$self->debug(\"Pushing the last of the singlets ($name)\\n\");\n\t@{$self->{'contigs'}->{$name}->{'member_array'}} = $name;\n\t$self->{'contigs'}->{$name}->{'consensus'} = $sequence;\n\t$self->{'contigs'}->{$name}->{'name'} = $name;\n\t$self->{'contigs'}->{$name}->{\"singlet\"} = 1;\n\t$self->{'contigs'}->{$name}->{'class'} = \"singlet\";\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: Done adding singlets to the singlets hash.\\n\");\n    $self->{'singlets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end sub set_singlets\n\n=head2 get_singlets()\n\n Title   : get_singlets()\n Usage   : $o_consed->get_singlets();\n Function: Return the keynames of the singlets.\n Returns : An array containing the keynames of all \n           Bio::Tools::Alignment::Consed sequences in the class \"singlet\".\n Args    : None.\n Notes   : \n\n\nsub get_singlets {\n    # returns an array of singlet names\n    # singlets have \"singlet\"=1 in the hash\n    my $self = shift;\n    if (!$self->{singlets_set}) {\n\t$self->debug(\"You need to set the singlets before you get them. Doing that now.\");\n\t$self->set_singlets();\n    }\t\n\n    my (@singlets,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\t# @array = @{$Consed::contigs{$key}->{'member_array'}};\n\t# somethimes a user will try to get a list of singlets before the classes for the rest of the\n\t# contigs has been set (see t/test.t for how I figured this out. <bah>\t\t\t\n\t# so either way, just return class=singlets\n\tif (!$self->{'contigs'}->{$key}->{'class'}) {\n\t    # print(\"$key has no class. why?\\n\");\n\t}\n\telsif ($self->{'contigs'}->{$key}->{'class'} eq \"singlet\") {\n\t    push @singlets,$key;\n\t}\n    }\n    return @singlets;\n}\n\n=head2 set_quality_by_name($name,$quality)\n\n Title   : set_quality_by_name($name,$quality)\n Usage   : $o_consed->set_quality_by_name($name,$quality);\n Function: Deprecated. Make the contig with {name} have {'quality'} $quality.\n           Probably used for testing.\n Returns : Nothing.\n Args    : The name of a contig and a scalar for its quality.\n Notes   : Deprecated.\n\n\nsub set_quality_by_name {\n    # this is likely deprecated\n    my ($self,$name,$quality) = shift;\n    my $return;\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'} eq \"$name\" || $self->{'contigs'}->{'name'} eq \"$name\") {\n\t    $self->{'contigs'}->{'quality'} = $quality;\n\t    $return=1;\n\t}\n    }\n    if ($return) { return \"0\"; } else { return \"1\"; }\n}\t\t\t\t# end set quality by name\n\n=head2 set_singlet_quality()\n\n Title   : set_singlet_quality()\n Usage   : $o_consed->set_singlet_quality();\n Function: For each singlet, go to the appropriate file in phd_dir and read\n           in the phred quality for that read and place it into {'quality'}\n Returns : 0 or 1.\n Args    : None.\n Notes   : This is the next subroutine that will receive substantial revision\n           in the next little while. It really should eval the creation of\n           Bio::Tools::Alignment::Phred objects and go from there. \n\n\nsub set_singlet_quality {\n    my $self = shift;\n    my $full_filename = $self->{'filename'};\n    $full_filename =~ m/(.*\\/)(.*)ace.*$/;\n    my ($base_path,$filename) = ($1,\"$2\".\"qual\");\n    my $singletsfile = $base_path.$filename;\n    if (-f $singletsfile) {\n\t# print(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    }\n    else {\n\t$self->warn(\"$singletsfile is not a file. Sorry.\\n\");\n\treturn;\n    }\n\tmy $singlets_fh = Bio::Root::IO->new(-file => $singletsfile);\n\tmy ($sequence,$name,$count);\n    my ($identity,$line,$quality,@qline);\n    while ($line = $singlets_fh->_readline()) {\n\tchomp $line;\n\tif ($line =~ /^\\>/) {\n\t    $quality = undef;\n\t    $line =~ m/\\>(\\S*)\\s/;\n\t    $identity = $1;\n\t}\n\telse {\n\t    if ($self->{'contigs'}->{$identity}) {\n\t\t$self->{'contigs'}->{$identity}->{'quality'} .= \"$line \";\n\t    }\n\t}\n\n    }\n    return 0;\n}\n\n=head2 set_contig_quality()\n\n Title   : set_contig_quality()\n Usage   : $o_consed->set_contig_quality();\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n Notes   : Deprecated. Really. Trust me.\n\n\nsub set_contig_quality {\n    # note: contigs _include_ singletons but _not_ singlets\n    my ($self) = shift;\n          # the unexpected results I am referring to here are a doubling of quality values.\n          # the profanity I uttered on discovering this reminded me of the simpsons:\n          # Ned Flanders: \"That is the loudest profanity I have ever heard!\"\n     $self->warn(\"set_contig_quality is deprecated and will likely produce unexpected results\");\n    my $full_filename = $self->{'filename'};\n    # Run_SRC3700_2000-08-01_73+74.fasta.screen.contigs.qual\n    # from Consed.pm\n    $full_filename =~ m/(.*\\/)(.*)ace.*$/;\n    my ($base_path,$filename) = ($1,\"$2\".\"contigs.qual\");\n    my $singletsfile = $base_path.$filename;\n    if (-f $singletsfile) {\n\t# print(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    }\n    else {\n\t$self->warn(\"Bio::Tools::Alignment::Consed::set_contig_quality $singletsfile is not a file. Sorry.\\n\");\n\treturn;\n    }\n    my $contig_quality_fh = Bio::Root::IO->new(-file => $singletsfile);\n\n    my ($sequence,$name,$count,$identity,$line,$quality);\n    while ($line = $contig_quality_fh->_readline()) {\n\tchomp $line;\n\tif ($line =~ /^\\>/) {\n\t    $quality = undef;\n\t    $line =~ m/\\>.*Contig(\\d+)\\s/;\n\t    $identity = $1;\n\t}\n\telse {\n\t    if ($self->{'contigs'}->{$identity} ) {\n\t\t$self->{'contigs'}->{$identity}->{'quality'} .= \" $line\";\n\t    }\n\t}\n    }\n}\t\t\t\t# end set_contig_quality\n\n=head2 get_multiplets()\n\n Title   : get_multiplets()\n Usage   : $o_consed->get_multiplets();\n Function: Return the keynames of the multiplets.\n Returns : Returns an array containing the keynames of all \n           Bio::Tools::Alignment::Consed sequences in the class \"multiplet\".\n Args    : None.\n Notes   : \n\n\nsub get_multiplets {\n\t    # returns an array of multiplet names\n\t    # multiplets have # members > 2\n    my $self = shift;\n    my (@multiplets,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$key}->{'class'}) {\n\t    if ($self->{'contigs'}->{$key}->{'class'} eq \"multiplet\") {\n\t\tpush @multiplets,$key;\n\t    }\n\t}\n    }\n    return @multiplets;\n}\n\n=head2 get_all_members()\n\n  Title   : get_all_members()\n  Usage   : @all_members = $o_consed->get_all_members();\n  Function: Return a list of all of the read names in the \n            Bio::Tools::Alignment::Consed object.\n  Returns : An array containing all of the elements in all of the\n            {'member_array'}s.\n  Args    : None.\n  Notes   : \n\n\nsub get_all_members {\n    my $self = shift;\n    my @members;\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\tif ($key =~ /^singlet/) {\n\t    push @members,$self->{'contigs'}->{$key}->{'member_array'}[0];\n\t}\n\telsif ($self->{'contigs'}->{$key}->{'member_array'}) {\n\t    push @members,@{$self->{'contigs'}->{$key}->{'member_array'}};\n\t}\n\t# else {\n\t#\tprint(\"Bio::Tools::Alignment::Consed: $key is _not_ an array. Pushing $self->{'contigs'}->{$key}->{'member_array'} onto \\@members\\n\");\n\t#\tpush @members,$self->{'contigs'}->{$key}->{'member_array'};\n\t# }\n    }\n    return @members;\n}\n\n=head2 sum_lets($total_only)\n\n Title   : sum_lets($total_only)\n Usage   : $statistics = $o_consed->sum_lets($total_only);\n Function: Provide numbers for how many sequences were accounted for in the\n           Bio::Tools::Alignment::Consed object.\n Returns : If a scalar is present, returns the total number of\n           sequences accounted for in all classes. If no scalar passed\n           then returns a string that looks like this:\n           Singt/singn/doub/pair/mult/total : 2,0,1(2),0(0),0(0),4\n           This example means the following: There were 1 singlets.\n           There were 0 singletons.  There were 1 doublets for a total\n           of 2 sequences in this class.  There were 0 pairs for a\n           total of 0 sequences in this class.  There were 0\n           multiplets for a total of 0 sequences in this class.  There\n           were a total of 4 sequences accounted for in the\n           Bio::Tools::Alignment::Consed object.   \n Args : A scalar is optional to change the way the numbers are returned.  \n Notes:\n\n\nsub sum_lets {\n    my ($self,$total_only) = @_;\n    my ($count,$count_multiplets,$multiplet_count);\n    my $singlets = &get_singlets($self); $count += $singlets;\n    my $doublets = &get_doublets($self); $count += ($doublets * 2);\n    my $pairs = &get_pairs($self); $count += ($pairs * 2);\n    my $singletons = &get_singletons($self); $count += $singletons;\n    my @multiplets = &get_multiplets($self);\n    $count_multiplets = @multiplets;\n    my $return_string;\n    foreach (@multiplets) {\n\tmy $number_members = $self->{'contigs'}->{$_}->{num_members};\t\n\t$multiplet_count += $number_members;\n    }\n    if ($multiplet_count) {\n\t$count += $multiplet_count;\n    }\n    foreach (qw(multiplet_count singlets doublets pairs singletons\n                multiplets count_multiplets)) {\n\tno strict 'refs';\t# renege for the block\n\tif (!${$_}) {\n            ${$_} = 0;\n\t}\n    }\n    if (!$multiplet_count) { $multiplet_count = 0; }\n    if ($total_only) {\n        return $count;\n    }\n    $return_string = \"Singt/singn/doub/pair/mult/total : \".\n        \"$singlets,$singletons,$doublets(\".\n         ($doublets*2).\"),$pairs(\".($pairs*2).\n        \"),$count_multiplets($multiplet_count),$count\";\n    return $return_string;\n}\n\n=head2 write_stats()\n\n Title   : write_stats()\n Usage   : $o_consed->write_stats();\n Function: Write a file called \"statistics\" containing numbers similar to\n\t   those provided in sum_lets().\n Returns : Nothing. Write a file in $o_consed->{path} containing something\n\t   like this:\n\n           0,0,50(100),0(0),0(0),100\n\n           Where the numbers provided are in the format described in the\n\t   documentation for sum_lets().\n Args    : None.\n Notes   : This might break platform independence, I do not know.\n\nSee L<sum_lets()|sum_lets>\n\n\nsub write_stats {\n    # worry about platform dependence here?\n    # oh shucksdarn.\n    my $self = shift;\n    my $stats_filename = $self->{'path'}.\"statistics\";\n    my $statistics_raw = $self->sum_lets;\n    my ($statsfilecontents) = $statistics_raw =~ s/.*\\ \\:\\ //g;\n    umask 0001;\n    my $fh = Bio::Root::IO->new(-file=>\"$stats_filename\");\n    # open(STATSFILE,\">$stats_filename\") or print(\"Could not open the statsfile: $!\\n\");\n    $fh->_print(\"$statsfilecontents\");\n    # close STATSFILE;\n    $fh->close();\n}\n\n=head2 get_singletons()\n\n Title   : get_singletons()\n Usage   : @singletons = $o_consed->get_singletons();\n Function: Return the keynames of the singletons.\n Returns : Returns an array containing the keynames of all\n\t   Bio::Tools::Alignment::Consed sequences in the class \"singleton\".\n Args    : None.\n Notes   : \n\n\nsub get_singletons {\n\t\t# returns an array of singleton names\n\t\t# singletons are contigs with one member (see consed documentation)\n\tmy $self = shift;\n\tmy (@singletons,@array);\n\tforeach my $key (sort keys %{$self->{'contigs'}}) {\n\t\tif ($self->{'contigs'}->{$key}->{'class'}) {\n\t\t    # print (\"$key class: $self->{'contigs'}->{$key}->{'class'}\\n\");\n\t\t}\n\t\telse {\n\t\t    # print(\"$key belongs to no class. why?\\n\");\n\t\t}\n\t\tif ($self->{'contigs'}->{$key}->{'member_array'}) {\n\t\t\t@array = @{$self->{'contigs'}->{$key}->{'member_array'}};\n\t\t}\n\t\tmy $num_array_elem = @array;\n\t\tif ($num_array_elem == 1 && $self->{'contigs'}->{$key}->{'class'} && $self->{'contigs'}->{$key}->{'class'} eq \"singleton\") { push @singletons,$key; }\n\t}\n\treturn @singletons;\n}\n\n=head2 get_pairs()\n\n Title   : get_pairs()\n Usage   : @pairs = $o_consed->get_pairs();\n Function: Return the keynames of the pairs.\n Returns : Returns an array containing the keynames of all\n           Bio::Tools::Alignment::Consed sequences in the class \"pair\".\n Args    : None.\n Notes   : \n\n\nsub get_pairs {\n    # returns an array of pair contig names\n    # a pair is a contig of two where the names do not match\n    my $self = shift;\n    my (@pairs,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n        if ($self->{'contigs'}->{$key}->{'member_array'}) {\n            if (@{$self->{'contigs'}->{$key}->{'member_array'}} == 2 &&\n                $self->{'contigs'}->{$key}->{'class'} eq \"pair\") {\n                push @pairs,$key;\n            }\n        }\n    }\n    return @pairs;\n}\n\n=head2 get_name($contig_keyname)\n\n Title   : get_name($contig_keyname)\n Usage   : $name = $o_consed->get_name($contig_keyname);\n Function: Return the {name} for $contig_keyname.\n Returns : A string. ({name})\n Args    : A contig keyname.\n Notes   : \n\n\nsub get_name {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'name'};\n}\n\n=head2 _get_contig_name(\\@array_containing_reads)\n\n Title   : _get_contig_name(\\@array_containing_reads)\n Usage   : $o_consed->_get_contig_name(\\@array_containing_reads);\n Function: The logic for the set_doublets subroutine.\n Returns : The name for this contig.\n Args    : A reference to an array containing read names.\n Notes   : Depends on reverse_designator. Be sure this is set the way you\n\t   intend.\n\n\nsub _get_contig_name {\n    my ($self,$r_array) = @_;\n    my @contig_members = @$r_array;\n    my @name_nodir;\n    foreach (@contig_members) {\n        # how can I distinguish the clone name from the direction label?\n        # look for $Consed::reverse_designator and $Consed::forward_designator\n        # what if you do not find _any_ of those?\n        my $forward_designator = $self->{'forward_designator'} || \"f\";\n        my $reverse_designator = $self->{'reverse_designator'} || \"r\";\n        my $any_hits = /(.+)($forward_designator.*)/ || /(.+)($reverse_designator.*)/||/(.+)(_.+)/;\n        my $name = $1;\n        my $suffix = $2;\n        if ($name) {\n            # print(\"\\t\\$name is $name \");\n        }\n        if ($suffix) {\n            # print(\"and \\$suffix is $suffix.\\n\");\n        }\n                                # Jee, I hope we get a naming convention soon\n        if ($suffix) {\n            if ($suffix =~ /^$forward_designator/ || $suffix =~ /^$reverse_designator/) {\n                push @name_nodir,$name;\n            }\n\t\t\t\t# bugwatch here! should this be unnested?\n            else {\n                push @name_nodir,\"$name$suffix\";\n            }\n        }\n    }\n    # print(\"\\@name_nodir: @name_nodir\\n\");\n    my $mismatch = 0;\n    for (my $counter=0; $counter<@name_nodir;$counter++) {\n        next if ($name_nodir[0] eq $name_nodir[$counter]);\n        $mismatch = 1;\n    }\n    if ($mismatch == 0) {\n        # print(\"\\tYou have a cohesive contig named $name_nodir[0].\\n\\n\");\n        return $name_nodir[0];\n    } else {\n        # print(\"\\tYou have mixed names in this contig.\\n\\n\");\n    }\n}                               # end _get_contig_name\n\n=head2 get_doublets()\n\n Title   : get_doublets()\n Usage   : @doublets = $o_consed->get_doublets();\n Function: Return the keynames of the doublets.\n Returns : Returns an array containing the keynames of all\n           Bio::Tools::Alignment::Consed sequences in the class \"doublet\".\n Args    : None.\n Notes   : \n\n\nsub get_doublets {\n    my $self = shift;\n    if (!$self->{doublets_set}) {\n        $self->warn(\"You need to set the doublets before you can get them. Doing that now.\");\n        $self->set_doublets();\n    }\n    my @doublets;\n    foreach (sort keys %{$self->{'contigs'}}) {\n        if ($self->{'contigs'}->{$_}->{name} && $self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            push @doublets,$_;\n        }\n    }\n    return @doublets;\n}                               # end get_doublets\n\n=head2 dump_hash()\n\n Title   : dump_hash()\n Usage   : $o_consed->dump_hash();\n Function: Use dumpvar.pl to dump out the Bio::Tools::Alignment::Consed\n           object to STDOUT.\n Returns : Nothing.\n Args    : None.\n Notes   : I used this a lot in debugging.\n\n\nsub dump_hash {\n    my $self = shift;\n    my $dumper = new Dumpvalue;\n    $self->debug( \"Bio::Tools::Alignment::Consed::dump_hash - \".\n                  \"The following is the contents of the contig hash...\\n\");\n    $dumper->dumpValue($self->{'contigs'});\n}\n\n=head2 dump_hash_compact()\n\n Title   : dump_hash_compact()\n Usage   : $o_consed->dump_hash_compact();\n Function: Dump out the Bio::Tools::Alignment::Consed object in a compact way.\n Returns : Nothing.\n Args    : Nothing.\n Notes   : Cleaner then dumpValue(), dumpHash(). I used this a lot in\n           debugging.\n\n\nsub dump_hash_compact {\n    no strict 'refs';           # renege for the block\n    my ($self,$sequence) = @_;\n    # get the classes\n    my @singlets = $self->get_singlets();\n    my @singletons = $self->get_singletons();\n    my @doublets = $self->get_doublets();\n    my @pairs = $self->get_pairs();\n    my @multiplets = $self->get_multiplets();\n    print(\"Name\\tClass\\tMembers\\tQuality?\\n\");\n    foreach (@singlets) {\n        my @members = $self->get_members($_);\n        print($self->get_name($_).\"\\tsinglets\\t\".(join',',@members).\"\\t\");\n        if ($self->{'contigs'}->{$_}->{'quality'}) {\n            print(\"qualities found here\\n\");\n        } else {\n            print(\"no qualities found here\\n\");\n        }\n\n    }\n    foreach (@singletons) {\n        my @members = $self->get_members($_);\n        print($self->get_name($_).\"\\tsingletons\\t\".(join',',@members).\"\\t\");\n        if ($self->{'contigs'}->{$_}->{'quality'}) {\n            print(\"qualities found here\\n\");\n        } else {\n            print(\"no qualities found here\\n\");\n        }\n    }\n    foreach my $pair (@pairs) {\n        my @members = $self->get_members($pair);\n        my $name;\n        if (!$self->get_name($pair)) {\n            $name = \"BLANK\";\n        } else {\n            $name = $self->get_name($pair);\n        }\n        print(\"$name\\tpairs\\t\".(join',',@members).\"\\n\");\n    }\n    foreach (@doublets) {\n        my @members = $self->get_members_by_name($_);\n        print(\"$_\\tdoublets\\t\".(join',',@members).\"\\t\");\n        my $contig_number = &get_contig_number_by_name($self,$_);\n        if ($self->{'contigs'}->{$contig_number}->{'quality'}) {\n            print(\"qualities found here\\n\");\n        } else {\n            print(\"no qualities found here\\n\");\n        }\n        # print($_.\"\\tdoublets\\t\".(join',',@members).\"\\n\");\n    }\n    foreach (@multiplets) {\n        my @members = $self->get_members($_);\n        print(\"Contig $_\".\"\\tmultiplets\\t\".(join',',@members).\"\\n\");\n    }\n}                               # end dump_hash_compact\n\n=head2 get_phreds()\n\n Title   : get_phreds()\n Usage   : @phreds = $o_consed->get_phreds();\n Function: For each doublet in the Bio::Tools::Alignment::Consed hash, go\n           and get the phreds for the top and bottom reads. Place them into\n           {top_phreds} and {bottom_phreds}.\n Returns : Nothing.\n Args    : Nothing.\n\nRequires parse_phd() and reverse_and_complement(). I realize that it\nwould be much more elegant to pull qualities as required but there\nwere certain \"features\" in the acefile that required a bit more\ndetailed work be done to get the qualities for certain parts of the\nconsensus sequence. In order to make _sure_ that this was done\nproperly I wrote things to do all steps and then I used dump_hash()\nand checked each one to ensure expected bahavior. I have never changed\nthis, so there you are.\n\n\nsub get_phreds {\n    # this subroutine is the target of a rewrite to use the Bio::Tools::Alignment::Phred object.\n    my $self = shift;    \n    my $current_contig;\n    foreach $current_contig (sort keys %{$self->{'contigs'}}) {\t\n\tif ($self->{'contigs'}->{$current_contig}->{'class'} eq \"doublet\") {\n\t    $self->debug(\"$current_contig is a doublet. Going to parse_phd for top($self->{'contigs'}->{$current_contig}->{'top_name'}) and bottom($self->{'contigs'}->{$current_contig}->{'bottom_name'})\\n\");\n\t    my $r_phreds_top = &parse_phd($self,$self->{'contigs'}->{$current_contig}->{'top_name'});\n\t    my $r_phreds_bottom = &parse_phd($self,$self->{'contigs'}->{$current_contig}->{'bottom_name'});\n\t    if ($self->{'contigs'}->{$current_contig}->{'top_complement'} eq \"C\") {\n\t\t# print(\"Reversing and complementing...\\n\");\n\t\t$r_phreds_top = &reverse_and_complement($r_phreds_top);\n\t    }\n\t    if ($self->{'contigs'}->{$current_contig}->{'bottom_complement'} eq \"C\") {\n\t\t$r_phreds_bottom = &reverse_and_complement($r_phreds_bottom);\n\t    }\n\t    $self->{'contigs'}->{$current_contig}->{'top_phreds'} = $r_phreds_top;\n\t    $self->{'contigs'}->{$current_contig}->{'bottom_phreds'} = $r_phreds_bottom;\n\t}\n    }\n}\n\n=head2 parse_phd($read_name)\n\n Title   : parse_phd($read_name)\n Usage   : $o_consed->parse_phd($read_name);\n Function: Suck in the contents of a .phd file.\n Returns : A reference to an array containing the quality values for the read.\n Args    : The name of a read.\n Notes   : This is a significantly weak subroutine because it was always\n\t   intended that these functions, along with the functions provided by\n\t   get_phreds() be put into the Bio::SeqIO:phd module. This is done\n           now but the Bio::Tools::Alignment::Consed module has not be\n           rewritten to reflect this change.\n\nSee L<Bio::SeqIO::phd> for more information.\n\n\nsub parse_phd {\n    my ($self,$sequence_name) = @_;\n    $self->debug(\"Parsing phd for $sequence_name\\n\");\n    my $in_dna = 0;\n    my $base_number = 0;\n    my (@bases,@current_line);\n    # print(\"parse_phd: $sequence_name\\n\");\n    my $fh = Bio::Root::IO->new\n        (-file=>\"$self->{path}/../phd_dir/$sequence_name.phd.1\");\n    while ($fh->_readline()) {\n\t# print(\"Reading a line from a phredfile!\\n\");\n\tchomp;\n\tif (/^BEGIN_DNA/) { $in_dna = 1; next}\n\tif (/^END_DNA/) { last; }\n\tif (!$in_dna) { next; }\n\tpush(@bases,$_);\n    }\n    return \\@bases;\n}\n\n=head2 reverse_and_complement(\\@source)\n\n Title   : reverse_and_complement(\\@source)\n Usage   : $reference_to_array = $o_consed->reverse_and_complement(\\@source);\n Function: A stub for the recursive routine reverse_recurse().\n Returns : A reference to a reversed and complemented array of phred data.\n Args    : A reference to an array of phred data.\n Notes   : \n\n\nsub reverse_and_complement {\n    my $r_source = shift;\n    my $r_destination;\n    $r_destination = &reverse_recurse($r_source,$r_destination);\n    return $r_destination;\n}\n\n=head2 reverse_recurse($r_source,$r_destination)\n\n Title   : reverse_recurse(\\@source,\\@destination)\n Usage   : $o_consed->reverse_recurse(\\@source,\\@destination);\n Function: A recursive routine to reverse and complement an array of\n           phred data.\n Returns : A reference to an array containing reversed phred data.\n Args    : A reference to a source array and a reverence to a destination\n\t   array.\n\nRecursion is kewl, but this sub should likely be _reverse_recurse."},"range":{"end":{"line":1707,"character":9999},"start":{"line":1698,"character":0}},"kind":12,"line":1698,"detail":"($$)","definition":"sub","containerName":"main::","name":"reverse_recurse","children":[{"line":1699,"name":"$r_source","localvar":"my","kind":13,"containerName":"reverse_recurse","definition":"my"},{"definition":"my","name":"$r_destination","kind":13,"localvar":"my","containerName":"reverse_recurse","line":1699},{"line":1700,"containerName":"reverse_recurse","kind":13,"name":"$r_source"},{"name":"$r_destination","containerName":"reverse_recurse","kind":13,"line":1701},{"line":1703,"name":"$r_source","kind":13,"containerName":"reverse_recurse"},{"name":"$r_destination","containerName":"reverse_recurse","kind":13,"line":1705},{"line":1706,"kind":13,"containerName":"reverse_recurse","name":"$r_source"},{"line":1706,"kind":13,"containerName":"reverse_recurse","name":"$r_destination"}]},{"line":1725,"kind":12,"range":{"end":{"line":1733,"character":9999},"start":{"line":1725,"character":0}},"signature":{"label":"show_missing_sequence()","parameters":[],"documentation":"1;\n# $Id: Consed.pm 16123 2009-09-17 12:57:27Z cjfields $\n# Bio::Tools::Alignment::Consed\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chad Matsalla\n#\n# Copyright Chad Matsalla\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Alignment::Consed - A module to work with objects from consed .ace files\n\n=head1 SYNOPSIS\n\n  # a report for sequencing stuff\n  my $o_consed = Bio::Tools::Alignment::Consed->new( \n      -acefile => \"/path/to/an/acefile.ace.1\",\n      -verbose => 1);\n  my $foo = $o_consed->set_reverse_designator(\"r\");\n  my $bar = $o_consed->set_forward_designator(\"f\");\n\n  # get the contig numbers\n  my @keys = $o_consed->get_contigs();\n\n  # construct the doublets\n  my $setter_doublets = $o_consed->choose_doublets();\n\n  # get the doublets\n  my @doublets = $o_consed->get_doublets();\n\n=head1 DESCRIPTION\n\nL<Bio::Tools::Alignment::Consed> provides methods and objects to deal\nwith the output from the Consed software suite. Specifically,\ntakes an C<.ace> file and provides objects for the results.\n\nA word about doublets: This module was written to accomodate a large\nEST sequencing operation. In this case, EST's were sequenced from the\n3' and from the 5' end of the EST. The objective was to find a\nconsensus sequence for these two reads.  Thus, a contig of two is what\nwe wanted, and this contig should consist of the forward and reverse\nreads of a getn clone. For example, for a forward designator of \"F\"\nand a reverse designator of \"R\", if the two reads chad1F and chad1R\nwere in a single contig (for example Contig 5) it will be determined\nthat the consensus sequence for Contig 5 will be the sequence for\nclone chad1.\n\nDoublets are good!\n\nThis module parses C<.ace> and related files. A detailed list of methods\ncan be found at the end of this document.\n\nI wrote a detailed rationale for design that may explain the reasons\nwhy some things were done the way they were done. That document is\nbeyond the scope of this pod and can probably be found in the\ndirectory from which this module was 'made' or at\nL<http://www.dieselwurks.com/bioinformatics/consedpm_documentation.pdf>.\n\nNote that the POD in that document might be old but the original\nrationale still stands.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail chad-at-dieselwurks.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n#' \n\npackage Bio::Tools::Alignment::Consed;\n\nuse strict;\n\nuse FileHandle;\nuse Dumpvalue qw(dumpValue);\nuse Bio::Tools::Alignment::Trim;\nuse File::Spec;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nour %DEFAULTS = ( 'f_designator' => 'f',\n\t\t  'r_designator' => 'r');\n\n=head2 new()\n\n Title   : new(-acefile => $path_to_some_acefile, -verbose => \"1\")\n Usage   : $o_consed = Bio::Tools::Alignment::Consed->\n              new(-acefile => $path_to_some_acefile, -verbose => \"1\");\n Function: Construct the Bio::Tools::Alignment::Consed object. Sets\n\t   verbosity for the following procedures, if necessary:\n\t   1. Construct a new Bio::Tools::Alignment::Trim object, to\n\t   handle quality trimming 2. Read in the acefile and parse it\n\n Returns : A reference to a Bio::Tools::Alignment::Consed object.\n Args    : A hash. (-acefile) is the filename of an acefile. If a full path\n\t   is not specified \"./\" is prepended to the filename and used from\n\t   instantiation until destruction. If you want \n           Bio::Tools::Alignment::Consed to be noisy during parsing of\n           the acefile, specify some value for (-verbose).\n\n\nsub new {\n    my ($class,%args) = @_;\n    my $self = $class->SUPER::new(%args);\n\n    $self->{'filename'} = $args{'-acefile'};\n\n    # this is special to UNIX and should probably use catfile : DONE!\n#    if (!($self->{'filename'} =~ m{/})) { \n#\t$self->{'filename'} = \"./\".$self->{'filename'}; \n#    } \n#    $self->{'filename'} =~ m/(.*\\/)(.*)ace.*$/;\n#    $self->{'path'} = $1;\n\n    # this is more generic and should work on most systems   \n    (undef, $self->{'path'}, undef) = File::Spec->splitpath($self->{'filename'});\n\n    $self->_initialize_io('-file'=>$self->{'filename'});\n    $self->{'o_trim'} = Bio::Tools::Alignment::Trim->new(-verbose => $self->verbose());\n    $self->set_forward_designator($DEFAULTS{'f_designator'});\n    $self->set_reverse_designator($DEFAULTS{'r_designator'});\n\n    $self->_read_file();\n    return $self;\n}\n\n=head2 set_verbose()\n\n Title   : set_verbose()\n Usage   : $o_consed->set_verbose(1);\n Function: Set the verbosity level for debugging messages. On instantiation\n\t   of the Bio::Tools::Alignment::Consed object the verbosity level\n           is set to 0 (quiet).\n Returns : 1 or 0.\n Args    : The verbosity levels are:\n\t      0 - quiet\n\t      1 - noisy\n\t      2 - noisier\n\t      3 - annoyingly noisy\n\nThis method for setting verbosity has largely been superseeded by a\nsub-by-sub way, where for every sub you can provide a (-verbose)\nswitch. I am doing converting this bit-by-bit so do not be surprised\nif some subs do not honour this.\n\n\n# from RootI\n\n# backwards compat\nsub set_verbose { (shift)->verbose(@_) }\n\n=head2 get_filename()\n\n Title   : get_filename()\n Usage   : $o_consed->get_filename();\n Function: Returns the name of the acefile being used by the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : A scalar containing the name of a file.\n Args    : None.\n\n\n\nsub get_filename {\n    my $self = shift;\n    return $self->{'filename'};\n}\n\n=head2 count_sequences_with_grep()\n\n Title   : count_sequences_with_grep()\n Usage   : $o_consed->count_sequences_with_grep();\n Function: Use /bin/grep to scan through the files in the ace project dir\n\t   and count sequences in those files. I used this method in the\n\t   development of this module to verify that I was getting all of the\n\t   sequences. It works, but it is (I think) unix-like platform\n\t   dependent.\n Returns : A scalar containing the number of sequences in the ace project\n\t   directory.\n Args    : None.\n\nIf you are on a non-UNIX platform, you really do not have to use\nthis. It is more of a debugging routine designed to address very\nspecific problems.\n\nThis method was reimplemented to be platform independent with a pure\nperl implementation.  The above note can be ignored.\n\n\nsub count_sequences_with_grep {\n    my $self = shift;\n    my ($working_dir,$grep_cli,@total_grep_sequences);\n    # this should be migrated to a pure perl implementation ala\n    # Tom Christiansen's 'tcgrep'\n    # http://www.cpan.org/modules/by-authors/id/TOMC/scripts/tcgrep.gz\n\n    open(my $FILE, $self->{'filename'}) or do { $self->warn(\"cannot open file \".$self->{'filename'}. \" for grepping\"); return}; \n    my $counter =0;\n    while(<$FILE>) { $counter++ if(/^AF/); }\n\n    close $FILE;\n    opendir(my $SINGLETS,$self->{'path'});\n    foreach my $f ( readdir($SINGLETS) ) {\n\tnext unless ($f =~ /\\.singlets$/); \n\topen(my $FILE, File::Spec->catfile($self->{'path'},$f)) or do{ $self->warn(\"cannot open file \".File::Spec->catfile($self->{'path'},$f)); next };\n\twhile(<$FILE>) { $counter++ if(/^>/) }\n\tclose $FILE;\n    }\n    return $counter;\n}\n\n=head2 get_path()\n\n Title   : get_path()\n Usage   : $o_consed->get_path();\n Function: Returns the path to the acefile this object is working with.\n Returns : Scalar. The path to the working acefile.\n Args    : None.\n\n\nsub get_path {\n    my $self = shift;\n    return $self->{'path'};\n}\n\n=head2 get_contigs()\n\n Title   : get_contigs()\n Usage   : $o_consed->get_contigs();\n Function: Return the keys to the Bio::Tools::Alignment::Consed object.\n Returns : An array containing the keynames in the\n           Bio::Tools::Alignment::Consed object.\n Args    : None.\n\nThis would normally be used to get the keynames for some sort of\niterator. These keys are worthless in general day-to-day use because\nin the Consed acefile they are simply Contig1, Contig2, ...\n\n\nsub get_contigs {\n    my ($self,$contig) = @_;\n    my @contigs = sort keys %{$self->{'contigs'}};\n    return @contigs;\n}\n\n=head2 get_class($contig_keyname)\n\n Title   : get_class($contig_keyname)\n Usage   : $o_consed->get_class($contig_keyname);\n Function: Return the class name for this contig\n Returns : A scalar representing the class of this contig.\n Args    : None.\n Notes   : \n\n\nsub get_class {\n    my ($self,$contig) = @_;\n    return $self->{contigs}->{$contig}->{class};\n}\n\n=head2 get_quality_array($contig_keyname)\n\n Title   : get_quality_array($contig_keyname)\n Usage   : $o_consed->get_quality_array($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as an array. See get_quality_scalar to get this as a scalar.\n Returns : An array containing the quality for the consensus sequence with\n\t   the given keyname.\n Args    : The keyname of a contig. Note: This is a keyname. The key would\n\t   normally come from get_contigs.\n\nReturns an array, not a reference. Is this a bug? I<thinking> No.\nWell, maybe.  Why was this developed like this? I was using FreezeThaw\nfor object persistence, and when it froze out these arrays it took a\nlong time to thaw it. Much better as a scalar.\n\nSee L<get_quality_scalar()|get_quality_scalar>\n\n\nsub get_quality_array {\n    my ($self,$contig) = @_;\n    return split ' ', $self->{contigs}->{$contig}->{quality};\n}\n\n=head2 get_quality_scalar($contig_keyname)\n\n Title   : get_quality_scalar($contig_keyname)\n Usage   : $o_consed->get_quality_scalar($contig_keyname);\n Function: Returns the quality for the consensus sequence for the given\n\t   contig as a scalar. See get_quality_array to get this as an array.\n Returns : An scalar containing the quality for the consensus sequence with\n           the given keyname.\n Args    : The keyname of a contig. Note this is a _keyname_. The key would\n\t   normally come from get_contigs.\n\nWhy was this developed like this? I was using FreezeThaw for object\npersistence, and when it froze out these arrays it took a coon's age\nto thaw it. Much better as a scalar.\n\nSee L<get_quality_array()|get_quality_array>\n\n\n#'\nsub get_quality_scalar {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'quality'};\n}\n\n=head2 freeze_hash()\n\n Title   : freeze_hash()\n Usage   : $o_consed->freeze_hash();\n\n Function: Use Ilya's FreezeThaw module to create a persistent data\n\t   object for this Bio::Tools::Alignment::Consed data\n\t   structure. In the case of AAFC, we use\n\t   Bio::Tools::Alignment::Consed to pre-process bunches of\n\t   sequences, freeze the structures, and send in a harvesting\n\t   robot later to do database stuff.\n Returns : 0 or 1;\n Args    : None.\n\nThis procedure was removed so Consed.pm won't require FreezeThaw.\n\n\n#'\nsub freeze_hash {\n    my $self = shift;\n    $self->warn(\"This method (freeze_hash) was removed \".\n                \"from the bioperl consed.pm. Sorry.\\n\");\n    if (1==2) {\n        $self->debug(\"Bio::Tools::Alignment::Consed::freeze_hash:\".\n                     \" \\$self->{path} is $self->{path}\\n\");\n        my $filename = $self->{'path'}.\"frozen\";\n        my %contigs = %{$self->{'contigs'}};\n        my $frozen = freeze(%contigs);\n        umask 0001;\n        open (my $FREEZE,\">$filename\") or do {\n            $self->warn( \"Bio::Tools::Alignment::Consed could not \".\n                         \"freeze the contig hash because the file \".\n                         \"($filename) could not be opened: $!\\n\");\n            return 1;\n        };\n        print $FREEZE $frozen;\n        return 0;\n    }\n}\n\n=head2 get_members($contig_keyname)\n\n Title   : get_members($contig_keyname)\n Usage   : $o_consed->get_members($contig_keyname);\n Function: Return the _names_ of the reads in this contig.\n Returns : An array containing the names of the reads in this contig.\n Args    : The keyname of a contig. Note this is a keyname. The keyname\n\t   would normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members {\n    my ($self,$contig) = @_;\n    if (!$contig) {\n\t$self->warn(\"You need to provide the name of a contig to \".\n                    \"use Bio::Tools::Alignment::Consed::get_members!\\n\");\n\treturn;\n    }\n    return @{$self->{'contigs'}->{$contig}->{'member_array'}};\n}\n\n=head2 get_members_by_name($some_arbitrary_name)\n\n Title   : get_members_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_members_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nHighly inefficient. use some other method if possible.\nSee L<get_contigs()|get_contigs>\n\n\nsub get_members_by_name {\n    my ($self,$name) = @_;\n    # build a list to try to screen for redundancy\n    my @contigs_with_that_name;\n    foreach my $currkey ( sort keys %{$self->{'contigs'}} ) {\n\tnext if (!$self->{'contigs'}->{$currkey}->{'name'});\n\tif ($self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    push @contigs_with_that_name,$currkey;\n\t}\n    }\n    my $count = @contigs_with_that_name;\n    if ($count == 1) {\n\tmy $contig_num = $contigs_with_that_name[0];\n\treturn @{$self->{'contigs'}->{$contig_num}->{'member_array'}};\n    }\n}\n\n=head2 get_contig_number_by_name($some_arbitrary_name)\n\n Title   : get_contig_number_by_name($some_arbitrary_name)\n Usage   : $o_consed->get_contig_number_by_name($some_arbitrary_name);\n Function: Return the names of the reads in a contig. This is the name given\n\t   to $contig{key} based on what is in the contig. This is different\n\t   from the keys retrieved through get_contigs().\n Returns : An array containing the names of the reads in the contig with this\n\t   name.\n Args    : The name of a contig. Not a key, but a name.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_contig_number_by_name {\n    my ($self,$name) = @_;\n    foreach my $currkey (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$currkey}->{'name'} && \n\t    $self->{'contigs'}->{$currkey}->{'name'} eq \"$name\") {\n\t    return $currkey;\n\t}\n    }\n}\t\n\n=head2 get_sequence($contig_keyname)\n\n Title   : get_sequence($contig_keyname)\n Usage   : $o_consed->get_sequence($contig_keyname); \n Function: Returns the consensus sequence for a given contig.\n Returns : A scalar containing a sequence.\n Args    : The keyname of a contig. Note this is a key. The key would\n\t   normally come from get_contigs.\n\nSee L<get_contigs()|get_contigs>\n\n\nsub get_sequence {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'consensus'};\n}\n\n=head2 set_final_sequence($some_sequence)\n\n Title   : set_final_sequence($name,$some_sequence)\n Usage   : $o_consed->set_final_sequence($name,$some_sequence);\n Function: Provides a manual way to set the sequence for a given key in the\n\t   contig hash. Rarely used.\n Returns : 0 or 1;\n Args    : The name (not the keyname) of a contig and an arbitrary string.\n\nA method with a questionable and somewhat mysterious origin. May raise\nthe dead or something like that.\n\n\nsub set_final_sequence {\n    my ($self,$name,$sequence) = @_;\n    if (!$self->{'contigs'}->{$name}) {\n\t$self->warn(\"You cannot set the final sequence for \".\n                    \"$name because it doesn't exist!\\n\");\n\treturn 1;\n    }\n    else {\n\t$self->{'contigs'}->{$name}->{'final_sequence'} = $sequence;\n    }\n    return 0;\n}\n\n=head2  _read_file()\n\n Title   : _read_file();\n Usage   : _read_file();\n Function: An internal subroutine used to read in an acefile and parse it\n\t   into a Bio::Tools::Alignment::Consed object.\n Returns : 0 or 1.\n Args    : Nothing.\n\nThis routine creates and saves the filhandle for reading the files in\n{fh}\n\n\nsub _read_file {\n    my ($self) = @_;\n    my ($line,$in_contig,$in_quality,$contig_number,$top);\n    # make it easier to type $fhl\n    while (defined($line=$self->_readline()) ) {\n\tchomp $line;\n\t# check if there is anything on this line\n\t# if not, you can stop gathering consensus sequence\n\tif (!$line) {\n\t    # if the line is blank you are no longer to gather consensus \n\t    # sequence or quality values\n\t    $in_contig = 0;\n\t    $in_quality = 0;\n\t}\n\t# you are currently gathering consensus sequence\n\telsif ($in_contig) {\n\t    if ($in_contig == 1) {\n\t\t$self->debug(\"Adding $line to consensus of contig number $contig_number.\\n\");\n\t\t$self->{'contigs'}->{$contig_number}->{'consensus'} .= $line;\n\t    }\n\t}\n\telsif ($in_quality) {\n\t    if (!$line) {\n\t\t$in_quality = undef;\n\t    }\n\t    else {\n\n\t\t# I wrote this in here because acefiles produced by\n\t\t# cap3 do not have a leading space like the acefiles\n\t\t# produced by phrap and there is the potential to have\n\t\t# concatenated quality values like this: 2020 rather\n\t\t# then 20 20 whre lines collide. Thanks Andrew for\n\t\t# noticing.\n\n\t\tif ($self->{'contigs'}->{$contig_number}->{'quality'} &&\n                    !($self->{'contigs'}->{$contig_number}->{'quality'} =~ m/\\ $/)) {\n\t\t    $self->{'contigs'}->{$contig_number}->{'quality'} .= \" \";\n\t\t}\n\t\t$self->{'contigs'}->{$contig_number}->{'quality'} .= $line;\n\t    }\n\t}\n\telsif ($line =~ /^BQ/) {\n\t    $in_quality = 1;\n\t}\n\n\t# the line /^CO/ like this:\n\t# CO Contig1 796 1 1 U\n\t# can be broken down as follows:\n\t# CO - Contig!\n\t# Contig1 - the name of this contig\n\t# 796 - Number of bases in this contig\n\t# 1 - Number of reads in this contig\n\t# 1 - number of base segments in this contig\n\t# U - Uncomplemented\n\n\telsif ($line =~ /^CO/) {\n\t    $line =~ m/^CO\\ Contig(\\d+)\\ \\d+\\ \\d+\\ \\d+\\ (\\w)/;\n\t    $contig_number = $1;\n\t    if ($2 eq \"C\") {\n\t\t$self->debug(\"Contig $contig_number is complemented!\\n\");\n\t    }\n\t    $self->{'contigs'}->{$contig_number}->{'member_array'} = [];\n\t    $self->{'contigs'}->{$contig_number}->{'contig_direction'} = \"$2\";\n\t    $in_contig = 1;\n\t}\n\n\t# 000713\n\t# this BS is deprecated, I think.\n\t# haha, I am really witty. <ew>\n\n\telsif ($line =~ /^BSDEPRECATED/) {\n\t    $line =~ m/^BS\\s+\\d+\\s+\\d+\\s+(.+)/;\n\t    my $member = $1;\n\t    $self->{'contigs'}->{$contig_number}->{$member}++;\n\t}\n\t# the members of the contigs are determined by the AF line in the ace file\n\telsif ($line =~ /^AF/) {\n\t    $self->debug(\"I see an AF line here.\\n\");\n\t    $line =~ /^AF\\ (\\S+)\\ (\\w)\\ (\\S+)/;\n\n            # push the name of the current read onto the member array for this contig\n\t    push @{$self->{'contigs'}->{$contig_number}->{'member_array'}},$1;\n\n            # the first read in the contig will be named the \"top\" read\n\t    if (!$top) {\n\t\t$self->debug(\"\\$top is not set.\\n\");\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The bottom will be $1\\n\");\n\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. \".\n                                 \"The top_name will be $1\\n\");\n\t\t    # if the contig sequence is marked as the\n\t\t    # complement, the top becomes the bottom and$\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\t$top = 1;\n\t    }\n\t    else {\n\n\t\t# if the contig sequence is marked as the complement,\n\t\t# the top becomes the bottom and the bottom becomes\n\t\t# the top\n\t\tif ($self->{'contigs'}->{$contig_number}->{'contig_direction'} eq \"C\") {\n\t\t    $self->debug(\"Reversing the order of the reads. The top will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'top_start'} = $3;\n\t\t}\n\t\telse {\n\t\t    $self->debug(\"NOT reversing the order of the reads. The bottom will be $1\\n\");\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_name'} = $1;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_complement'} = $2;\n\t\t    $self->{'contigs'}->{$contig_number}->{'bottom_start'} = $3;\n\t\t}\n\t\t$top = undef;\n\t    }\n\t}\n    }\n    return 0;\n}\n\n=head2 set_reverse_designator($some_string)\n\n Title   : set_reverse_designator($some_string)\n Usage   : $o_consed->set_reverse_designator($some_string);\n Function: Set the designator for the reverse read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{reverse_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_reverse_designator {\n    my ($self,$reverse_designator) = @_;\n    $self->{'reverse_designator'} = $reverse_designator;\n    $self->{'o_trim'}->set_reverse_designator($reverse_designator);\n    return $self->{'reverse_designator'};\n}\t\t\t\t# end set_reverse_designator\n\n=head2 set_forward_designator($some_string)\n\n Title   : set_forward_designator($some_string)\n Usage   : $o_consed->set_forward_designator($some_string);\n Function: Set the designator for the forward read of contigs in this\n\t   Bio::Tools::Alignment::Consed object. Used to determine if\n           contigs containing two reads can be named.\n Returns : The value of $o_consed->{forward_designator} so you can check\n\t   to see that it was set properly.\n Args    : An arbitrary string.\n\nMay be useful only to me. I<shrug>\n\n\nsub set_forward_designator {\n    my ($self,$forward_designator) = @_;\n    $self->{'forward_designator'} = $forward_designator;\n    $self->{'o_trim'}->set_forward_designator($forward_designator);\n    return $self->{'forward_designator'};\n}\t\t\t\t# end set_forward_designator\n\n=head2 set_designator_ignore_case(\"yes\")\n\n Title   : set_designator_ignore_case(\"yes\")\n Usage   : $o_consed->set_designator_ignore_case(\"yes\");\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n\nDeprecated. Really. Trust me.\n\n\nsub set_designator_ignore_case {\n    my ($self,$ignore_case) = @_;\n    if ($ignore_case eq \"yes\") {\n\t$self->{'designator_ignore_case'} = 1;\n    }\n    return $self->{'designator_ignore_case'};\n}\t\t\t\t# end set_designator_ignore_case\n\n=head2 set_trim_points_singlets_and_singletons()\n\n Title   : set_trim_points_singlets_and_singletons()\n Usage   : $o_consed->set_trim_points_singlets_and_singletons();\n Function: Set the trim points for singlets and singletons based on\n\t   quality.  Uses the Bio::Tools::Alignment::Trim object. Use\n\t   at your own risk because the Bio::Tools::Alignment::Trim\n\t   object was designed specifically for me and is mysterious\n\t   in its ways. Every time somebody other then me uses it a\n\t   swarm of locusts decends on a small Central American\n\t   village so do not say you weren't warned.\n Returns : Nothing.\n Args    : None.\n\nWorking on exceptions and warnings here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\n#' to make my emacs happy\n\nsub set_trim_points_singlets_and_singletons {\n    my ($self) = @_;\n    $self->debug(\"Consed.pm : \\$self is $self\\n\");\n    my (@points,$trimmed_sequence);\n    if (!$self->{'doublets_set'}) {\n        $self->debug(\"You need to set the doublets before you use \".\n                     \"set_trim_points_singlets_and_doublets. Doing that now.\");\n\t$self->set_doublets();\n    }\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"singlet\") {\n\t    $self->debug(\"Singlet $_\\n\");\n\t    # this is what Warehouse wants\n\t    #         my ($self,$sequence,$quality,$name) = @_;\n\t    # this is what Bio::Tools::Alignment::Trim::trim_singlet wants:\n\t    # my ($self,$sequence,$quality,$name,$class) = @_;\n\t    # the following several lines are to make the parameter passing legible.\n\t    my ($sequence,$quality,$name,$class);\n\t    $sequence = $self->{'contigs'}->{$_}->{'consensus'};\n\t    if (!$self->{'contigs'}->{$_}->{'quality'}) { $quality = \"unset\"; }\n\t    else { $quality = $self->{'contigs'}->{$_}->{'quality'}; }\n\t    $name = $self->{'contigs'}->{$_}->{'name'};\n\t    $class = $self->{'contigs'}->{$_}->{'class'};\n\t    @points = @{$self->{'o_trim'}->trim_singlet($sequence,$quality,$name,$class)};\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} = \n                substr($self->{contigs}->{$_}->{'consensus'},$points[0],$points[1]-$points[0]);\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_singlets\".\n                 \"_and_singletons: Done setting the quality trimpoints.\\n\");\n    return;\n}  # end set_trim_points_singlet\n\n=head2 set_trim_points_doublets()\n\n Title   : set_trim_points_doublets()\n Usage   : $o_consed->set_trim_points_doublets();\n Function: Set the trim points for doublets based on quality. Uses the\n\t   Bio::Tools::Alignment::Trim object. Use at your own risk because\n           the Bio::Tools::Alignment::Trim object was designed specifically\n           for me and is mysterious in its ways. Every time somebody other\n           then me uses it you risk a biblical plague being loosed on your\n           city.\n Returns : Nothing.\n Args    : None.\n Notes   : Working on exceptions here.\n\nSee L<Bio::Tools::Alignment::Trim> for more information\n\n\nsub set_trim_points_doublets {\n    my $self = shift;\n    my @points;\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Restoring zeros for doublets.\\n\");\n    # &show_missing_sequence($self);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Setting doublet trim points.\\n\");\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            # my ($self,$sequence,$quality,$name,$class) = @_;\n            my @quals = split(' ',$self->{'contigs'}->{$_}->{'quality'});\n\n\t    @points = $self->{o_trim}->trim_doublet\n                ($self->{'contigs'}->{$_}->{'consensus'},\n                 $self->{'contigs'}->{$_}->{'quality'},\n                 $self->{'contigs'}->{$_}->{name},\n                 $self->{'contigs'}->{$_}->{'class'});\n\t    $self->{'contigs'}->{$_}->{'start_point'} = $points[0];\n\t    $self->{'contigs'}->{$_}->{'end_point'} = $points[1];\n            # now set this\n\t    $self->{'contigs'}->{$_}->{'sequence_trimmed'} =\n                substr($self->{contigs}->{$_}->{'consensus'},\n                       $points[0],$points[1]-$points[0]);\n\t    # 010102 the deprecated way to do things:\n\t}\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_trim_points_doublets:\".\n                 \" Done setting doublet trim points.\\n\"); \n    return;\n} # end set_trim_points_doublets\n\n=head2 get_trimmed_sequence_by_name($name)\n\n Title   : get_trimmed_sequence_by_name($name)\n Usage   : $o_consed->get_trimmed_sequence_by_name($name);\n Function: Returns the trimmed_sequence of a contig with {name} eq $name.\n Returns : A scalar- the trimmed sequence.\n Args    : The {name} of a contig.\n Notes   : \n\n\nsub get_trimmed_sequence_by_name {\n    my ($self,$name) = @_;\n    my $trimmed_sequence;\n    my $contigname = &get_contig_number_by_name($self,$name);\n    my $class = $self->{'contigs'}->{$contigname}->{'class'};\n    # what is this business and who was smoking crack while writing this?\n    # if ($class eq \"singlet\") {\n    # send the sequence, the quality, and the name\n    # $trimmed_sequence = $self->{o_trim}->trim_singlet\n    #  ($self->{'contigs'}->{$contigname}->{consensus},\n    #   $self->{'contigs'}->{$contigname}->{'quality'},$name);\n    # }\n    return $self->{'contigs'}->{$contigname}->{'sequence_trimmed'};\n}\n\n=head2 set_dash_present_in_sequence_name(\"yes\")\n\n Title   : set_dash_present_in_sequence_name(\"yes\")\n Usage   : $o_consed->set_dash_present_in_sequence_name(\"yes\");\n Function: Deprecated. Part of an uncompleted thought. (\"Oooh! Shiny!\")\n Returns : Nothing.\n Args    : \"yes\" to set {dash_present_in_sequence_name} to 1\n Notes   : \n\n\nsub set_dash_present_in_sequence_name {\n    my ($self,$dash_present) = @_;\n    if ($dash_present eq \"yes\") {\n\t$self->{'dash_present_in_sequence_name'} = 1;\n    }\n    else {\n\t$self->{'dash_present_in_sequence_name'} = 0;\n    }\n    return $self->{'dash_present_in_sequence_name'};\n} # end set_dash_present_in_sequence_name\n\n=head2 set_doublets()\n\n Title   : set_doublets()\n Usage   : $o_consed->set_doublets();\n Function: Find pairs that have similar names and mark them as doublets\n\t   and set the {name}.\n Returns : 0 or 1.\n Args    : None.\n\nA complicated subroutine that iterates over the\nBio::Tools::Alignment::Consed looking for contigs of 2. If the forward\nand reverse designator are removed from each of the reads in\n{'member_array'} and the remaining reads are the same, {name} is set\nto that name and the contig's class is set as \"doublet\".  If any of\nthose cases fail the contig is marked as a \"pair\".\n\n\n#' make my emacs happy\n\nsub set_doublets {\n    my ($self) = @_;\n    # set the designators in the Bio::Tools::Alignment::Trim object\n\n    $self->{'o_trim'}->set_designators($self->{'reverse_designator'},\n\t\t\t\t       $self->{'forward_designator'});\n    foreach my $key_contig (sort keys %{$self->{'contigs'}}) {\n\n\t# if there is a member array (why would there not be? This should be a die()able offence\n\t# but for now I will leave it\n\tif ($self->{'contigs'}->{$key_contig}->{'member_array'}) {\n\t    # if there are two reads in this contig \n\t    # i am pretty sure that this is wrong but i am keeping it for reference\n\t    # if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2 || !$self->{'contigs'}->{$key_contig}->{'class'}) {\n\t    # <seconds later>\n\t    # <nod> WRONG. Was I on crack?\n\t    if (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 2) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = 2;\n\t\t$self->debug(\"\\tThere are 2 members! Looking for the contig name...\\n\");\n\t\tmy $name = _get_contig_name($self,$self->{'contigs'}->{$key_contig}->{'member_array'});\n\t\t$self->debug(\"The name is $name\\n\") if defined $name;\n\t\tif ($name) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'name'} = $name;\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"doublet\";\n\t\t} else {\n\t\t    $self->debug(\"$key_contig is a pair.\\n\");\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"pair\";\n\t\t}\n\t    }\n            # this is all fair and good but what about singlets?\n            # they have one reads in the member_array but certainly are not singletons\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} == 1) {\n\t\t# set the name to be the name of the read\n\t\t$self->{'contigs'}->{$key_contig}->{name} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}}[0];\n\t\t# set the number of members to be one\n\t\t$self->{'contigs'}->{$key_contig}->{num_members} = 1;\n\t\t# if this was a singlet, it would already belong to the class \"singlet\"\n\t\t# so leave it alone\n\t\t# if it is not a singlet, it is a singleton! lablel it appropriately\n\t\tunless ($self->{'contigs'}->{$key_contig}->{'class'}) {\n\t\t    $self->{'contigs'}->{$key_contig}->{'class'} = \"singleton\";\n\t\t}\n\t    }\n            # set the multiplet characteristics\n\t    elsif (@{$self->{'contigs'}->{$key_contig}->{'member_array'}} >= 3) {\n\t\t$self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\t\t$self->{'contigs'}->{$key_contig}->{'class'} = \"multiplet\";\n\t    }\n\t    $self->{'contigs'}->{$key_contig}->{'num_members'} = @{$self->{'contigs'}->{$key_contig}->{'member_array'}};\n\n\t}\n    }\n    $self->{'doublets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end set_doublets\n\n=head2 set_singlets\n\n Title   : set_singlets\n Usage   : $o_consed->set_singlets();\n Function: Read in a singlets file and place them into the\n\t   Bio::Tools::Alignment::Consed object.\n Returns : Nothing.\n Args    : A scalar to turn on verbose parsing of the singlets file.\n Notes   : \n\n\nsub set_singlets {\n    # parse out the contents of the singlets file\n    my ($self) = @_;\n    $self->debug(\"Bio::Tools::Alignment::Consed Adding singlets to the contig hash...\\n\"); \n    my $full_filename = $self->{'filename'};\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: \\$full_filename is $full_filename\\n\");\n    $full_filename =~ m/(.*\\/)(.*ace.*)$/; \t\t\t       \n    my ($base_path,$filename) = ($1,$2);\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: singlets filename is $filename and \\$base_path is $base_path\\n\");\n    $filename =~ m/(.*)ace.*$/;\n    my $singletsfile = $base_path.$1.\"singlets\";\n    $self->debug(\"\\$singletsfile is $singletsfile\\n\");\n     if (!-f $singletsfile) {\n          # there is no singlets file.\n          $self->{'singlets_set'} = \"done\";\n          return;\n     }\n\t$self->debug(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    my $singlets_fh = Bio::Root::IO->new(-file => $singletsfile);\n    my ($sequence,$name,$count);\n    while ($_ = $singlets_fh->_readline()) {\n\tchomp $_;\n\tif (/\\>/) {\n\t    if ($name && $sequence) {\n\t\t$self->debug(\"Adding $name with sequence $sequence to hash...\\n\");\n\t\tpush @{$self->{'contigs'}->{$name}->{'member_array'}},$name;\n\t\t$self->{'contigs'}->{$name}->{'consensus'} = $sequence;\n\t\t$self->{'contigs'}->{$name}->{'name'} = $name;\n\t\t$self->{'contigs'}->{$name}->{\"singlet\"} = 1;\n\t\t$self->{'contigs'}->{$name}->{'class'} = \"singlet\";\n\t    }\n\t    $sequence = $name = undef;\n\t    $count++;\n\t    m/^\\>(.*)\\s\\sCHROMAT/;\n\t    $name = $1;\n\t    if (!$name) {\n\t\tm/\\>(\\S+)\\s/;\n\t\t$name = $1;\n\t    }\n\t}\n\telse { $sequence .= $_; }\t\n    }\n    if ($name && $sequence) {\n\t$self->debug(\"Pushing the last of the singlets ($name)\\n\");\n\t@{$self->{'contigs'}->{$name}->{'member_array'}} = $name;\n\t$self->{'contigs'}->{$name}->{'consensus'} = $sequence;\n\t$self->{'contigs'}->{$name}->{'name'} = $name;\n\t$self->{'contigs'}->{$name}->{\"singlet\"} = 1;\n\t$self->{'contigs'}->{$name}->{'class'} = \"singlet\";\n    }\n    $self->debug(\"Bio::Tools::Alignment::Consed::set_singlets: Done adding singlets to the singlets hash.\\n\");\n    $self->{'singlets_set'} = \"done\";\n    return 0;\n}\t\t\t\t# end sub set_singlets\n\n=head2 get_singlets()\n\n Title   : get_singlets()\n Usage   : $o_consed->get_singlets();\n Function: Return the keynames of the singlets.\n Returns : An array containing the keynames of all \n           Bio::Tools::Alignment::Consed sequences in the class \"singlet\".\n Args    : None.\n Notes   : \n\n\nsub get_singlets {\n    # returns an array of singlet names\n    # singlets have \"singlet\"=1 in the hash\n    my $self = shift;\n    if (!$self->{singlets_set}) {\n\t$self->debug(\"You need to set the singlets before you get them. Doing that now.\");\n\t$self->set_singlets();\n    }\t\n\n    my (@singlets,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\t# @array = @{$Consed::contigs{$key}->{'member_array'}};\n\t# somethimes a user will try to get a list of singlets before the classes for the rest of the\n\t# contigs has been set (see t/test.t for how I figured this out. <bah>\t\t\t\n\t# so either way, just return class=singlets\n\tif (!$self->{'contigs'}->{$key}->{'class'}) {\n\t    # print(\"$key has no class. why?\\n\");\n\t}\n\telsif ($self->{'contigs'}->{$key}->{'class'} eq \"singlet\") {\n\t    push @singlets,$key;\n\t}\n    }\n    return @singlets;\n}\n\n=head2 set_quality_by_name($name,$quality)\n\n Title   : set_quality_by_name($name,$quality)\n Usage   : $o_consed->set_quality_by_name($name,$quality);\n Function: Deprecated. Make the contig with {name} have {'quality'} $quality.\n           Probably used for testing.\n Returns : Nothing.\n Args    : The name of a contig and a scalar for its quality.\n Notes   : Deprecated.\n\n\nsub set_quality_by_name {\n    # this is likely deprecated\n    my ($self,$name,$quality) = shift;\n    my $return;\n    foreach (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'} eq \"$name\" || $self->{'contigs'}->{'name'} eq \"$name\") {\n\t    $self->{'contigs'}->{'quality'} = $quality;\n\t    $return=1;\n\t}\n    }\n    if ($return) { return \"0\"; } else { return \"1\"; }\n}\t\t\t\t# end set quality by name\n\n=head2 set_singlet_quality()\n\n Title   : set_singlet_quality()\n Usage   : $o_consed->set_singlet_quality();\n Function: For each singlet, go to the appropriate file in phd_dir and read\n           in the phred quality for that read and place it into {'quality'}\n Returns : 0 or 1.\n Args    : None.\n Notes   : This is the next subroutine that will receive substantial revision\n           in the next little while. It really should eval the creation of\n           Bio::Tools::Alignment::Phred objects and go from there. \n\n\nsub set_singlet_quality {\n    my $self = shift;\n    my $full_filename = $self->{'filename'};\n    $full_filename =~ m/(.*\\/)(.*)ace.*$/;\n    my ($base_path,$filename) = ($1,\"$2\".\"qual\");\n    my $singletsfile = $base_path.$filename;\n    if (-f $singletsfile) {\n\t# print(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    }\n    else {\n\t$self->warn(\"$singletsfile is not a file. Sorry.\\n\");\n\treturn;\n    }\n\tmy $singlets_fh = Bio::Root::IO->new(-file => $singletsfile);\n\tmy ($sequence,$name,$count);\n    my ($identity,$line,$quality,@qline);\n    while ($line = $singlets_fh->_readline()) {\n\tchomp $line;\n\tif ($line =~ /^\\>/) {\n\t    $quality = undef;\n\t    $line =~ m/\\>(\\S*)\\s/;\n\t    $identity = $1;\n\t}\n\telse {\n\t    if ($self->{'contigs'}->{$identity}) {\n\t\t$self->{'contigs'}->{$identity}->{'quality'} .= \"$line \";\n\t    }\n\t}\n\n    }\n    return 0;\n}\n\n=head2 set_contig_quality()\n\n Title   : set_contig_quality()\n Usage   : $o_consed->set_contig_quality();\n Function: Deprecated.\n Returns : Deprecated.\n Args    : Deprecated.\n Notes   : Deprecated. Really. Trust me.\n\n\nsub set_contig_quality {\n    # note: contigs _include_ singletons but _not_ singlets\n    my ($self) = shift;\n          # the unexpected results I am referring to here are a doubling of quality values.\n          # the profanity I uttered on discovering this reminded me of the simpsons:\n          # Ned Flanders: \"That is the loudest profanity I have ever heard!\"\n     $self->warn(\"set_contig_quality is deprecated and will likely produce unexpected results\");\n    my $full_filename = $self->{'filename'};\n    # Run_SRC3700_2000-08-01_73+74.fasta.screen.contigs.qual\n    # from Consed.pm\n    $full_filename =~ m/(.*\\/)(.*)ace.*$/;\n    my ($base_path,$filename) = ($1,\"$2\".\"contigs.qual\");\n    my $singletsfile = $base_path.$filename;\n    if (-f $singletsfile) {\n\t# print(\"$singletsfile is indeed a file. Trying to open it...\\n\");\n    }\n    else {\n\t$self->warn(\"Bio::Tools::Alignment::Consed::set_contig_quality $singletsfile is not a file. Sorry.\\n\");\n\treturn;\n    }\n    my $contig_quality_fh = Bio::Root::IO->new(-file => $singletsfile);\n\n    my ($sequence,$name,$count,$identity,$line,$quality);\n    while ($line = $contig_quality_fh->_readline()) {\n\tchomp $line;\n\tif ($line =~ /^\\>/) {\n\t    $quality = undef;\n\t    $line =~ m/\\>.*Contig(\\d+)\\s/;\n\t    $identity = $1;\n\t}\n\telse {\n\t    if ($self->{'contigs'}->{$identity} ) {\n\t\t$self->{'contigs'}->{$identity}->{'quality'} .= \" $line\";\n\t    }\n\t}\n    }\n}\t\t\t\t# end set_contig_quality\n\n=head2 get_multiplets()\n\n Title   : get_multiplets()\n Usage   : $o_consed->get_multiplets();\n Function: Return the keynames of the multiplets.\n Returns : Returns an array containing the keynames of all \n           Bio::Tools::Alignment::Consed sequences in the class \"multiplet\".\n Args    : None.\n Notes   : \n\n\nsub get_multiplets {\n\t    # returns an array of multiplet names\n\t    # multiplets have # members > 2\n    my $self = shift;\n    my (@multiplets,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\tif ($self->{'contigs'}->{$key}->{'class'}) {\n\t    if ($self->{'contigs'}->{$key}->{'class'} eq \"multiplet\") {\n\t\tpush @multiplets,$key;\n\t    }\n\t}\n    }\n    return @multiplets;\n}\n\n=head2 get_all_members()\n\n  Title   : get_all_members()\n  Usage   : @all_members = $o_consed->get_all_members();\n  Function: Return a list of all of the read names in the \n            Bio::Tools::Alignment::Consed object.\n  Returns : An array containing all of the elements in all of the\n            {'member_array'}s.\n  Args    : None.\n  Notes   : \n\n\nsub get_all_members {\n    my $self = shift;\n    my @members;\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n\tif ($key =~ /^singlet/) {\n\t    push @members,$self->{'contigs'}->{$key}->{'member_array'}[0];\n\t}\n\telsif ($self->{'contigs'}->{$key}->{'member_array'}) {\n\t    push @members,@{$self->{'contigs'}->{$key}->{'member_array'}};\n\t}\n\t# else {\n\t#\tprint(\"Bio::Tools::Alignment::Consed: $key is _not_ an array. Pushing $self->{'contigs'}->{$key}->{'member_array'} onto \\@members\\n\");\n\t#\tpush @members,$self->{'contigs'}->{$key}->{'member_array'};\n\t# }\n    }\n    return @members;\n}\n\n=head2 sum_lets($total_only)\n\n Title   : sum_lets($total_only)\n Usage   : $statistics = $o_consed->sum_lets($total_only);\n Function: Provide numbers for how many sequences were accounted for in the\n           Bio::Tools::Alignment::Consed object.\n Returns : If a scalar is present, returns the total number of\n           sequences accounted for in all classes. If no scalar passed\n           then returns a string that looks like this:\n           Singt/singn/doub/pair/mult/total : 2,0,1(2),0(0),0(0),4\n           This example means the following: There were 1 singlets.\n           There were 0 singletons.  There were 1 doublets for a total\n           of 2 sequences in this class.  There were 0 pairs for a\n           total of 0 sequences in this class.  There were 0\n           multiplets for a total of 0 sequences in this class.  There\n           were a total of 4 sequences accounted for in the\n           Bio::Tools::Alignment::Consed object.   \n Args : A scalar is optional to change the way the numbers are returned.  \n Notes:\n\n\nsub sum_lets {\n    my ($self,$total_only) = @_;\n    my ($count,$count_multiplets,$multiplet_count);\n    my $singlets = &get_singlets($self); $count += $singlets;\n    my $doublets = &get_doublets($self); $count += ($doublets * 2);\n    my $pairs = &get_pairs($self); $count += ($pairs * 2);\n    my $singletons = &get_singletons($self); $count += $singletons;\n    my @multiplets = &get_multiplets($self);\n    $count_multiplets = @multiplets;\n    my $return_string;\n    foreach (@multiplets) {\n\tmy $number_members = $self->{'contigs'}->{$_}->{num_members};\t\n\t$multiplet_count += $number_members;\n    }\n    if ($multiplet_count) {\n\t$count += $multiplet_count;\n    }\n    foreach (qw(multiplet_count singlets doublets pairs singletons\n                multiplets count_multiplets)) {\n\tno strict 'refs';\t# renege for the block\n\tif (!${$_}) {\n            ${$_} = 0;\n\t}\n    }\n    if (!$multiplet_count) { $multiplet_count = 0; }\n    if ($total_only) {\n        return $count;\n    }\n    $return_string = \"Singt/singn/doub/pair/mult/total : \".\n        \"$singlets,$singletons,$doublets(\".\n         ($doublets*2).\"),$pairs(\".($pairs*2).\n        \"),$count_multiplets($multiplet_count),$count\";\n    return $return_string;\n}\n\n=head2 write_stats()\n\n Title   : write_stats()\n Usage   : $o_consed->write_stats();\n Function: Write a file called \"statistics\" containing numbers similar to\n\t   those provided in sum_lets().\n Returns : Nothing. Write a file in $o_consed->{path} containing something\n\t   like this:\n\n           0,0,50(100),0(0),0(0),100\n\n           Where the numbers provided are in the format described in the\n\t   documentation for sum_lets().\n Args    : None.\n Notes   : This might break platform independence, I do not know.\n\nSee L<sum_lets()|sum_lets>\n\n\nsub write_stats {\n    # worry about platform dependence here?\n    # oh shucksdarn.\n    my $self = shift;\n    my $stats_filename = $self->{'path'}.\"statistics\";\n    my $statistics_raw = $self->sum_lets;\n    my ($statsfilecontents) = $statistics_raw =~ s/.*\\ \\:\\ //g;\n    umask 0001;\n    my $fh = Bio::Root::IO->new(-file=>\"$stats_filename\");\n    # open(STATSFILE,\">$stats_filename\") or print(\"Could not open the statsfile: $!\\n\");\n    $fh->_print(\"$statsfilecontents\");\n    # close STATSFILE;\n    $fh->close();\n}\n\n=head2 get_singletons()\n\n Title   : get_singletons()\n Usage   : @singletons = $o_consed->get_singletons();\n Function: Return the keynames of the singletons.\n Returns : Returns an array containing the keynames of all\n\t   Bio::Tools::Alignment::Consed sequences in the class \"singleton\".\n Args    : None.\n Notes   : \n\n\nsub get_singletons {\n\t\t# returns an array of singleton names\n\t\t# singletons are contigs with one member (see consed documentation)\n\tmy $self = shift;\n\tmy (@singletons,@array);\n\tforeach my $key (sort keys %{$self->{'contigs'}}) {\n\t\tif ($self->{'contigs'}->{$key}->{'class'}) {\n\t\t    # print (\"$key class: $self->{'contigs'}->{$key}->{'class'}\\n\");\n\t\t}\n\t\telse {\n\t\t    # print(\"$key belongs to no class. why?\\n\");\n\t\t}\n\t\tif ($self->{'contigs'}->{$key}->{'member_array'}) {\n\t\t\t@array = @{$self->{'contigs'}->{$key}->{'member_array'}};\n\t\t}\n\t\tmy $num_array_elem = @array;\n\t\tif ($num_array_elem == 1 && $self->{'contigs'}->{$key}->{'class'} && $self->{'contigs'}->{$key}->{'class'} eq \"singleton\") { push @singletons,$key; }\n\t}\n\treturn @singletons;\n}\n\n=head2 get_pairs()\n\n Title   : get_pairs()\n Usage   : @pairs = $o_consed->get_pairs();\n Function: Return the keynames of the pairs.\n Returns : Returns an array containing the keynames of all\n           Bio::Tools::Alignment::Consed sequences in the class \"pair\".\n Args    : None.\n Notes   : \n\n\nsub get_pairs {\n    # returns an array of pair contig names\n    # a pair is a contig of two where the names do not match\n    my $self = shift;\n    my (@pairs,@array);\n    foreach my $key (sort keys %{$self->{'contigs'}}) {\n        if ($self->{'contigs'}->{$key}->{'member_array'}) {\n            if (@{$self->{'contigs'}->{$key}->{'member_array'}} == 2 &&\n                $self->{'contigs'}->{$key}->{'class'} eq \"pair\") {\n                push @pairs,$key;\n            }\n        }\n    }\n    return @pairs;\n}\n\n=head2 get_name($contig_keyname)\n\n Title   : get_name($contig_keyname)\n Usage   : $name = $o_consed->get_name($contig_keyname);\n Function: Return the {name} for $contig_keyname.\n Returns : A string. ({name})\n Args    : A contig keyname.\n Notes   : \n\n\nsub get_name {\n    my ($self,$contig) = @_;\n    return $self->{'contigs'}->{$contig}->{'name'};\n}\n\n=head2 _get_contig_name(\\@array_containing_reads)\n\n Title   : _get_contig_name(\\@array_containing_reads)\n Usage   : $o_consed->_get_contig_name(\\@array_containing_reads);\n Function: The logic for the set_doublets subroutine.\n Returns : The name for this contig.\n Args    : A reference to an array containing read names.\n Notes   : Depends on reverse_designator. Be sure this is set the way you\n\t   intend.\n\n\nsub _get_contig_name {\n    my ($self,$r_array) = @_;\n    my @contig_members = @$r_array;\n    my @name_nodir;\n    foreach (@contig_members) {\n        # how can I distinguish the clone name from the direction label?\n        # look for $Consed::reverse_designator and $Consed::forward_designator\n        # what if you do not find _any_ of those?\n        my $forward_designator = $self->{'forward_designator'} || \"f\";\n        my $reverse_designator = $self->{'reverse_designator'} || \"r\";\n        my $any_hits = /(.+)($forward_designator.*)/ || /(.+)($reverse_designator.*)/||/(.+)(_.+)/;\n        my $name = $1;\n        my $suffix = $2;\n        if ($name) {\n            # print(\"\\t\\$name is $name \");\n        }\n        if ($suffix) {\n            # print(\"and \\$suffix is $suffix.\\n\");\n        }\n                                # Jee, I hope we get a naming convention soon\n        if ($suffix) {\n            if ($suffix =~ /^$forward_designator/ || $suffix =~ /^$reverse_designator/) {\n                push @name_nodir,$name;\n            }\n\t\t\t\t# bugwatch here! should this be unnested?\n            else {\n                push @name_nodir,\"$name$suffix\";\n            }\n        }\n    }\n    # print(\"\\@name_nodir: @name_nodir\\n\");\n    my $mismatch = 0;\n    for (my $counter=0; $counter<@name_nodir;$counter++) {\n        next if ($name_nodir[0] eq $name_nodir[$counter]);\n        $mismatch = 1;\n    }\n    if ($mismatch == 0) {\n        # print(\"\\tYou have a cohesive contig named $name_nodir[0].\\n\\n\");\n        return $name_nodir[0];\n    } else {\n        # print(\"\\tYou have mixed names in this contig.\\n\\n\");\n    }\n}                               # end _get_contig_name\n\n=head2 get_doublets()\n\n Title   : get_doublets()\n Usage   : @doublets = $o_consed->get_doublets();\n Function: Return the keynames of the doublets.\n Returns : Returns an array containing the keynames of all\n           Bio::Tools::Alignment::Consed sequences in the class \"doublet\".\n Args    : None.\n Notes   : \n\n\nsub get_doublets {\n    my $self = shift;\n    if (!$self->{doublets_set}) {\n        $self->warn(\"You need to set the doublets before you can get them. Doing that now.\");\n        $self->set_doublets();\n    }\n    my @doublets;\n    foreach (sort keys %{$self->{'contigs'}}) {\n        if ($self->{'contigs'}->{$_}->{name} && $self->{'contigs'}->{$_}->{'class'} eq \"doublet\") {\n            push @doublets,$_;\n        }\n    }\n    return @doublets;\n}                               # end get_doublets\n\n=head2 dump_hash()\n\n Title   : dump_hash()\n Usage   : $o_consed->dump_hash();\n Function: Use dumpvar.pl to dump out the Bio::Tools::Alignment::Consed\n           object to STDOUT.\n Returns : Nothing.\n Args    : None.\n Notes   : I used this a lot in debugging.\n\n\nsub dump_hash {\n    my $self = shift;\n    my $dumper = new Dumpvalue;\n    $self->debug( \"Bio::Tools::Alignment::Consed::dump_hash - \".\n                  \"The following is the contents of the contig hash...\\n\");\n    $dumper->dumpValue($self->{'contigs'});\n}\n\n=head2 dump_hash_compact()\n\n Title   : dump_hash_compact()\n Usage   : $o_consed->dump_hash_compact();\n Function: Dump out the Bio::Tools::Alignment::Consed object in a compact way.\n Returns : Nothing.\n Args    : Nothing.\n Notes   : Cleaner then dumpValue(), dumpHash(). I used this a lot in\n           debugging.\n\n\nsub dump_hash_compact {\n    no strict 'refs';           # renege for the block\n    my ($self,$sequence) = @_;\n    # get the classes\n    my @singlets = $self->get_singlets();\n    my @singletons = $self->get_singletons();\n    my @doublets = $self->get_doublets();\n    my @pairs = $self->get_pairs();\n    my @multiplets = $self->get_multiplets();\n    print(\"Name\\tClass\\tMembers\\tQuality?\\n\");\n    foreach (@singlets) {\n        my @members = $self->get_members($_);\n        print($self->get_name($_).\"\\tsinglets\\t\".(join',',@members).\"\\t\");\n        if ($self->{'contigs'}->{$_}->{'quality'}) {\n            print(\"qualities found here\\n\");\n        } else {\n            print(\"no qualities found here\\n\");\n        }\n\n    }\n    foreach (@singletons) {\n        my @members = $self->get_members($_);\n        print($self->get_name($_).\"\\tsingletons\\t\".(join',',@members).\"\\t\");\n        if ($self->{'contigs'}->{$_}->{'quality'}) {\n            print(\"qualities found here\\n\");\n        } else {\n            print(\"no qualities found here\\n\");\n        }\n    }\n    foreach my $pair (@pairs) {\n        my @members = $self->get_members($pair);\n        my $name;\n        if (!$self->get_name($pair)) {\n            $name = \"BLANK\";\n        } else {\n            $name = $self->get_name($pair);\n        }\n        print(\"$name\\tpairs\\t\".(join',',@members).\"\\n\");\n    }\n    foreach (@doublets) {\n        my @members = $self->get_members_by_name($_);\n        print(\"$_\\tdoublets\\t\".(join',',@members).\"\\t\");\n        my $contig_number = &get_contig_number_by_name($self,$_);\n        if ($self->{'contigs'}->{$contig_number}->{'quality'}) {\n            print(\"qualities found here\\n\");\n        } else {\n            print(\"no qualities found here\\n\");\n        }\n        # print($_.\"\\tdoublets\\t\".(join',',@members).\"\\n\");\n    }\n    foreach (@multiplets) {\n        my @members = $self->get_members($_);\n        print(\"Contig $_\".\"\\tmultiplets\\t\".(join',',@members).\"\\n\");\n    }\n}                               # end dump_hash_compact\n\n=head2 get_phreds()\n\n Title   : get_phreds()\n Usage   : @phreds = $o_consed->get_phreds();\n Function: For each doublet in the Bio::Tools::Alignment::Consed hash, go\n           and get the phreds for the top and bottom reads. Place them into\n           {top_phreds} and {bottom_phreds}.\n Returns : Nothing.\n Args    : Nothing.\n\nRequires parse_phd() and reverse_and_complement(). I realize that it\nwould be much more elegant to pull qualities as required but there\nwere certain \"features\" in the acefile that required a bit more\ndetailed work be done to get the qualities for certain parts of the\nconsensus sequence. In order to make _sure_ that this was done\nproperly I wrote things to do all steps and then I used dump_hash()\nand checked each one to ensure expected bahavior. I have never changed\nthis, so there you are.\n\n\nsub get_phreds {\n    # this subroutine is the target of a rewrite to use the Bio::Tools::Alignment::Phred object.\n    my $self = shift;    \n    my $current_contig;\n    foreach $current_contig (sort keys %{$self->{'contigs'}}) {\t\n\tif ($self->{'contigs'}->{$current_contig}->{'class'} eq \"doublet\") {\n\t    $self->debug(\"$current_contig is a doublet. Going to parse_phd for top($self->{'contigs'}->{$current_contig}->{'top_name'}) and bottom($self->{'contigs'}->{$current_contig}->{'bottom_name'})\\n\");\n\t    my $r_phreds_top = &parse_phd($self,$self->{'contigs'}->{$current_contig}->{'top_name'});\n\t    my $r_phreds_bottom = &parse_phd($self,$self->{'contigs'}->{$current_contig}->{'bottom_name'});\n\t    if ($self->{'contigs'}->{$current_contig}->{'top_complement'} eq \"C\") {\n\t\t# print(\"Reversing and complementing...\\n\");\n\t\t$r_phreds_top = &reverse_and_complement($r_phreds_top);\n\t    }\n\t    if ($self->{'contigs'}->{$current_contig}->{'bottom_complement'} eq \"C\") {\n\t\t$r_phreds_bottom = &reverse_and_complement($r_phreds_bottom);\n\t    }\n\t    $self->{'contigs'}->{$current_contig}->{'top_phreds'} = $r_phreds_top;\n\t    $self->{'contigs'}->{$current_contig}->{'bottom_phreds'} = $r_phreds_bottom;\n\t}\n    }\n}\n\n=head2 parse_phd($read_name)\n\n Title   : parse_phd($read_name)\n Usage   : $o_consed->parse_phd($read_name);\n Function: Suck in the contents of a .phd file.\n Returns : A reference to an array containing the quality values for the read.\n Args    : The name of a read.\n Notes   : This is a significantly weak subroutine because it was always\n\t   intended that these functions, along with the functions provided by\n\t   get_phreds() be put into the Bio::SeqIO:phd module. This is done\n           now but the Bio::Tools::Alignment::Consed module has not be\n           rewritten to reflect this change.\n\nSee L<Bio::SeqIO::phd> for more information.\n\n\nsub parse_phd {\n    my ($self,$sequence_name) = @_;\n    $self->debug(\"Parsing phd for $sequence_name\\n\");\n    my $in_dna = 0;\n    my $base_number = 0;\n    my (@bases,@current_line);\n    # print(\"parse_phd: $sequence_name\\n\");\n    my $fh = Bio::Root::IO->new\n        (-file=>\"$self->{path}/../phd_dir/$sequence_name.phd.1\");\n    while ($fh->_readline()) {\n\t# print(\"Reading a line from a phredfile!\\n\");\n\tchomp;\n\tif (/^BEGIN_DNA/) { $in_dna = 1; next}\n\tif (/^END_DNA/) { last; }\n\tif (!$in_dna) { next; }\n\tpush(@bases,$_);\n    }\n    return \\@bases;\n}\n\n=head2 reverse_and_complement(\\@source)\n\n Title   : reverse_and_complement(\\@source)\n Usage   : $reference_to_array = $o_consed->reverse_and_complement(\\@source);\n Function: A stub for the recursive routine reverse_recurse().\n Returns : A reference to a reversed and complemented array of phred data.\n Args    : A reference to an array of phred data.\n Notes   : \n\n\nsub reverse_and_complement {\n    my $r_source = shift;\n    my $r_destination;\n    $r_destination = &reverse_recurse($r_source,$r_destination);\n    return $r_destination;\n}\n\n=head2 reverse_recurse($r_source,$r_destination)\n\n Title   : reverse_recurse(\\@source,\\@destination)\n Usage   : $o_consed->reverse_recurse(\\@source,\\@destination);\n Function: A recursive routine to reverse and complement an array of\n           phred data.\n Returns : A reference to an array containing reversed phred data.\n Args    : A reference to a source array and a reverence to a destination\n\t   array.\n\nRecursion is kewl, but this sub should likely be _reverse_recurse.\n\n\n\nsub reverse_recurse($$) {\n    my ($r_source,my $r_destination) = @_;\n    if (!@$r_source) {\n        return $r_destination;\n    }\n    $_=pop(@$r_source);\n    s/c/g/ || s/g/c/ || s/a/t/ || s/t/a/;\n    push(@$r_destination,$_);\n    &reverse_recurse($r_source,$r_destination);\n}\n\n=head2 show_missing_sequence()\n\n Title   : show_missing_sequence();\n Usage   : $o_consed->show_missing_sequence();\n Function: Used by set_trim_points_doublets() to fill in quality values where\n\t   consed (phrap?) set them to 0 at the beginning and/or end of the\n\t   consensus sequences.\n Returns : Nothing.\n Args    : None.\n\nActs on doublets only. Really very somewhat quite ugly. A disgusting\nkludge. I<insert pride here> It was written stepwise with no real plan\nbecause it was not really evident why consed (phrap?)  was doing this."},"children":[{"line":1730,"localvar":"my","kind":13,"containerName":"show_missing_sequence","name":"$self","definition":"my"},{"containerName":"show_missing_sequence","kind":13,"name":"$self","line":1731},{"line":1732,"name":"$current_contig","localvar":"my","kind":13,"containerName":"show_missing_sequence","definition":"my"},{"name":"@qualities","kind":13,"containerName":"show_missing_sequence","line":1732},{"name":"$current_contig","kind":13,"containerName":"show_missing_sequence","line":1733},{"line":1733,"name":"$self","kind":13,"containerName":"show_missing_sequence"}],"name":"show_missing_sequence","containerName":"main::","definition":"sub","detail":"()"},{"name":"%self","containerName":null,"kind":13,"line":1734},{"name":"%current_contig","containerName":null,"kind":13,"line":1734},{"line":1735,"localvar":"my","kind":13,"containerName":null,"name":"$number_leading_xs","definition":"my"},{"line":1736,"name":"$number_trailing_xs","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"localvar":"my","kind":13,"containerName":null,"name":"$measurer","line":1737,"definition":"my"},{"line":1737,"containerName":null,"kind":13,"name":"%self"},{"name":"%current_contig","containerName":null,"kind":13,"line":1737},{"line":1738,"name":"%measurer","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$number_leading_xs","line":1739},{"name":"%measurer","containerName":null,"kind":13,"line":1741},{"line":1742,"kind":13,"containerName":null,"name":"$number_trailing_xs"},{"line":1744,"name":"@qualities","containerName":null,"kind":13},{"line":1744,"name":"%self","containerName":null,"kind":13},{"line":1744,"name":"%current_contig","containerName":null,"kind":13},{"definition":"my","line":1745,"name":"$in_initial_zeros","localvar":"my","kind":13,"containerName":null},{"definition":"my","name":"$count","localvar":"my","containerName":null,"kind":13,"line":1746},{"line":1746,"containerName":null,"kind":13,"name":"$count"},{"containerName":null,"kind":13,"name":"@qualities","line":1746},{"line":1746,"containerName":null,"kind":13,"name":"%count"},{"line":1747,"name":"@qualities","containerName":null,"kind":13},{"name":"%count","containerName":null,"kind":13,"line":1747},{"containerName":null,"localvar":"my","kind":13,"name":"$quality","line":1748,"definition":"my"},{"kind":13,"containerName":null,"name":"$top_phred_position","line":1748},{"kind":13,"containerName":null,"name":"$bottom_phred_position","line":1748},{"line":1748,"name":"$top_phred_data","kind":13,"containerName":null},{"line":1748,"name":"$bottom_phred_data","containerName":null,"kind":13},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$top_quality_here","line":1752},{"line":1752,"name":"%self","containerName":null,"kind":13},{"name":"%current_contig","kind":13,"containerName":null,"line":1752},{"line":1752,"name":"%self","kind":13,"containerName":null},{"name":"%current_contig","containerName":null,"kind":13,"line":1752},{"line":1752,"name":"$count","containerName":null,"kind":13},{"definition":"my","name":"$bottom_quality_here","kind":13,"localvar":"my","containerName":null,"line":1753},{"name":"%self","containerName":null,"kind":13,"line":1753},{"name":"%current_contig","containerName":null,"kind":13,"line":1753},{"kind":13,"containerName":null,"name":"%self","line":1753},{"name":"%current_contig","containerName":null,"kind":13,"line":1753},{"line":1753,"name":"$count","kind":13,"containerName":null},{"name":"$bottom_quality_here","containerName":null,"kind":13,"line":1754},{"line":1754,"name":"%self","kind":13,"containerName":null},{"line":1754,"containerName":null,"kind":13,"name":"%current_contig"},{"name":"%count","containerName":null,"kind":13,"line":1754},{"line":1755,"name":"$bottom_quality_here","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%top_quality_here","line":1757},{"name":"$top_quality_here","kind":13,"containerName":null,"line":1758},{"kind":13,"containerName":null,"name":"$count","line":1761},{"line":1761,"containerName":null,"kind":13,"name":"%number_leading_xs"},{"definition":"my","name":"$quality","containerName":null,"localvar":"my","kind":13,"line":1764},{"containerName":null,"kind":13,"name":"$top_quality_here","line":1764},{"line":1765,"containerName":null,"kind":13,"name":"$quality"},{"name":"$quality","kind":13,"containerName":null,"line":1766},{"containerName":null,"kind":13,"name":"@qualities","line":1769},{"line":1769,"kind":13,"containerName":null,"name":"$count"},{"line":1769,"name":"%quality","kind":13,"containerName":null},{"line":1790,"name":"%bottom_quality_here","kind":13,"containerName":null},{"line":1795,"name":"$top_quality_here","containerName":null,"kind":13},{"name":"$quality","containerName":null,"kind":13,"line":1796},{"kind":13,"containerName":null,"name":"%top_quality_here","line":1797},{"line":1802,"containerName":null,"kind":13,"name":"$bottom_quality_here"},{"line":1803,"name":"%quality","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$top_quality_here","line":1811},{"name":"$top_quality","localvar":"my","kind":13,"containerName":null,"line":1812,"definition":"my"},{"name":"$bottom_quality_here","containerName":null,"kind":13,"line":1814},{"localvar":"my","containerName":null,"kind":13,"name":"$bottom_quality","line":1815,"definition":"my"},{"kind":13,"containerName":null,"name":"$bottom_quality","line":1818},{"containerName":null,"kind":13,"name":"%top_quality","line":1818},{"kind":13,"containerName":null,"name":"$quality","line":1820},{"line":1820,"containerName":null,"kind":13,"name":"%bottom_quality"},{"line":1823,"name":"$quality","containerName":null,"kind":13},{"line":1823,"name":"$top_quality","containerName":null,"kind":13},{"line":1826,"name":"%quality","kind":13,"containerName":null},{"line":1831,"containerName":null,"kind":13,"name":"@qualities"},{"line":1831,"containerName":null,"kind":13,"name":"$count"},{"line":1831,"containerName":null,"kind":13,"name":"$quality"},{"name":"@qualities","containerName":null,"kind":13,"line":1837},{"line":1838,"containerName":null,"kind":13,"name":"%self"},{"name":"%current_contig","containerName":null,"kind":13,"line":1838},{"containerName":null,"kind":13,"name":"@qualities","line":1838},{"line":1840,"name":"%self","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%current_contig","line":1840},{"name":"%self","kind":13,"containerName":null,"line":1841},{"line":1841,"name":"%current_contig","kind":13,"containerName":null},{"definition":"my","line":1842,"kind":13,"localvar":"my","containerName":null,"name":"$count"}],"version":5}