{"vars":[{"line":124,"kind":2,"containerName":"","name":"vars"},{"kind":2,"containerName":"","name":"base","line":126},{"line":139,"kind":12,"range":{"end":{"character":9999,"line":151},"start":{"line":139,"character":0}},"signature":{"documentation":"1;\n# $Id: Tree.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from Bio::Tree::Tree by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Tree - An Organism Level Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon in combination with\n    # Bio::Tree::Tree instead\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n    my @leaves = $tree->get_leaves;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Taxonomic Nodes which make up a tree.\n\n=head1 EXAMPLES\n\n  use Bio::Species;\n  use Bio::Taxonomy::Tree;\n\n  my $human=Bio::Species->new();\n  my $chimp=Bio::Species->new();\n  my $bonobo=Bio::Species->new();\n\n  $human->classification(qw( sapiens Homo Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $chimp->classification(qw( troglodytes Pan Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $bonobo->classification(qw( paniscus Pan Hominidae\n                              Catarrhini Primates Eutheria\n                              Mammalia Euteleostomi Vertebrata \n                              Craniata Chordata\n                              Metazoa Eukaryota ));\n\n  # ranks passed to $taxonomy match ranks of species\n  my @ranks = ('superkingdom','kingdom','phylum','subphylum',\n               'no rank 1','no rank 2','class','no rank 3','order',\n               'suborder','family','genus','species');\n\n  my $taxonomy=Bio::Taxonomy->new(-ranks => \\@ranks,\n                                 -method => 'trust',\n                                 -order => -1);\n\n\n  my $tree1=Bio::Taxonomy::Tree->new();\n  my $tree2=Bio::Taxonomy::Tree->new();\n\n  $tree1->make_species_branch($human,$taxonomy);\n  $tree2->make_species_branch($chimp,$taxonomy);\n\n  my ($homo_sapiens)=$tree1->get_leaves;\n\n  $tree1->splice($tree2);\n\n  $tree1->add_species($bonobo,$taxonomy);\n\n  my @taxa;\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n  @taxa=();\n  $tree1->remove_branch($homo_sapiens);\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n=head1 FEEDBACK\n\nSee AUTHOR\n\n=head1 AUTHOR - Dan Kortschak\n\nEmail kortschak@rsbs.anu.edu.au\n\n=head1 CONTRIBUTORS\n\nMainly Jason Stajich\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Code begins...\n\n\npackage Bio::Taxonomy::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Taxonomy::Taxon;\n\n# Import rank information from Bio::Taxonomy.pm\nuse vars qw(@RANK %RANK);\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Tree->new();\n Function: Builds a new Bio::Taxonomy::Tree object \n Returns : Bio::Taxonomy::Tree\n Args    : ","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"children":[{"definition":"my","line":140,"kind":13,"localvar":"my","containerName":"new","name":"$class"},{"containerName":"new","kind":13,"name":"@args","line":140},{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"$self","line":142},{"name":"$class","containerName":"new","kind":13,"line":142},{"kind":13,"containerName":"new","name":"@args","line":142},{"line":143,"name":"$self","kind":13,"containerName":"new"},{"name":"warn","containerName":"new","kind":12,"line":143},{"line":145,"name":"$self","kind":13,"containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":146},{"name":"$root","localvar":"my","containerName":"new","kind":13,"line":148,"definition":"my"},{"line":148,"name":"$self","kind":13,"containerName":"new"},{"containerName":"new","kind":12,"name":"_rearrange","line":148},{"line":148,"name":"@args","kind":13,"containerName":"new"},{"line":149,"containerName":"new","kind":13,"name":"$root"},{"name":"$self","containerName":"new","kind":13,"line":149},{"name":"set_root_node","kind":12,"containerName":"new","line":149},{"name":"$root","kind":13,"containerName":"new","line":149},{"line":150,"name":"$self","kind":13,"containerName":"new"}],"containerName":"main::","name":"new","definition":"sub","detail":"($class,@args)"},{"line":142,"name":"SUPER","kind":12,"containerName":"new"},{"containerName":"main::","name":"get_nodes","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"get_nodes","name":"$self","line":166},{"line":166,"name":"@args","containerName":"get_nodes","kind":13},{"name":"$order","containerName":"get_nodes","localvar":"my","kind":13,"line":168,"definition":"my"},{"name":"$sortby","kind":13,"containerName":"get_nodes","line":168},{"kind":13,"containerName":"get_nodes","name":"$self","line":168},{"line":168,"name":"_rearrange","containerName":"get_nodes","kind":12},{"name":"@args","kind":13,"containerName":"get_nodes","line":168},{"name":"$order","containerName":"get_nodes","kind":13,"line":169},{"kind":13,"containerName":"get_nodes","name":"$sortby","line":170},{"line":172,"name":"$order","kind":13,"containerName":"get_nodes"},{"line":173,"name":"$node","localvar":"my","containerName":"get_nodes","kind":13,"definition":"my"},{"line":173,"name":"$self","containerName":"get_nodes","kind":13},{"kind":12,"containerName":"get_nodes","name":"get_root_node","line":173},{"definition":"my","localvar":"my","kind":13,"containerName":"get_nodes","name":"@children","line":174},{"line":174,"name":"$node","kind":13,"containerName":"get_nodes"},{"name":"@children","containerName":"get_nodes","kind":13,"line":175},{"kind":13,"containerName":"get_nodes","name":"@children","line":176},{"name":"each_Descendent","kind":12,"containerName":"get_nodes","line":176},{"line":176,"name":"$sortby","containerName":"get_nodes","kind":13},{"line":178,"name":"@children","kind":13,"containerName":"get_nodes"},{"line":181,"name":"$order","containerName":"get_nodes","kind":13},{"name":"$node","kind":13,"localvar":"my","containerName":"get_nodes","line":183,"definition":"my"},{"name":"$self","kind":13,"containerName":"get_nodes","line":183},{"kind":12,"containerName":"get_nodes","name":"get_root_node","line":183},{"name":"@children","localvar":"my","containerName":"get_nodes","kind":13,"line":184,"definition":"my"},{"kind":13,"containerName":"get_nodes","name":"$node","line":184},{"line":184,"containerName":"get_nodes","kind":13,"name":"$node"},{"name":"get_Descendents","kind":12,"containerName":"get_nodes","line":184},{"name":"$sortby","kind":13,"containerName":"get_nodes","line":184},{"kind":13,"containerName":"get_nodes","name":"@children","line":185}],"detail":"($self,@args)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":187},"start":{"line":165,"character":0}},"line":165,"signature":{"documentation":"1;\n# $Id: Tree.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from Bio::Tree::Tree by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Tree - An Organism Level Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon in combination with\n    # Bio::Tree::Tree instead\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n    my @leaves = $tree->get_leaves;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Taxonomic Nodes which make up a tree.\n\n=head1 EXAMPLES\n\n  use Bio::Species;\n  use Bio::Taxonomy::Tree;\n\n  my $human=Bio::Species->new();\n  my $chimp=Bio::Species->new();\n  my $bonobo=Bio::Species->new();\n\n  $human->classification(qw( sapiens Homo Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $chimp->classification(qw( troglodytes Pan Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $bonobo->classification(qw( paniscus Pan Hominidae\n                              Catarrhini Primates Eutheria\n                              Mammalia Euteleostomi Vertebrata \n                              Craniata Chordata\n                              Metazoa Eukaryota ));\n\n  # ranks passed to $taxonomy match ranks of species\n  my @ranks = ('superkingdom','kingdom','phylum','subphylum',\n               'no rank 1','no rank 2','class','no rank 3','order',\n               'suborder','family','genus','species');\n\n  my $taxonomy=Bio::Taxonomy->new(-ranks => \\@ranks,\n                                 -method => 'trust',\n                                 -order => -1);\n\n\n  my $tree1=Bio::Taxonomy::Tree->new();\n  my $tree2=Bio::Taxonomy::Tree->new();\n\n  $tree1->make_species_branch($human,$taxonomy);\n  $tree2->make_species_branch($chimp,$taxonomy);\n\n  my ($homo_sapiens)=$tree1->get_leaves;\n\n  $tree1->splice($tree2);\n\n  $tree1->add_species($bonobo,$taxonomy);\n\n  my @taxa;\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n  @taxa=();\n  $tree1->remove_branch($homo_sapiens);\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n=head1 FEEDBACK\n\nSee AUTHOR\n\n=head1 AUTHOR - Dan Kortschak\n\nEmail kortschak@rsbs.anu.edu.au\n\n=head1 CONTRIBUTORS\n\nMainly Jason Stajich\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Code begins...\n\n\npackage Bio::Taxonomy::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Taxonomy::Taxon;\n\n# Import rank information from Bio::Taxonomy.pm\nuse vars qw(@RANK %RANK);\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Tree->new();\n Function: Builds a new Bio::Taxonomy::Tree object \n Returns : Bio::Taxonomy::Tree\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Tree is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n  \n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n\n  my ($root)= $self->_rearrange([qw(ROOT)], @args);\n  if( $root ) { $self->set_root_node($root); }\n  return $self;\n}\n\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order","parameters":[{"label":"$self"},{"label":"@args"}],"label":"get_nodes($self,@args)"}},{"containerName":"main::","name":"get_root_node","children":[{"definition":"my","line":202,"name":"$self","kind":13,"localvar":"my","containerName":"get_root_node"},{"line":203,"kind":13,"containerName":"get_root_node","name":"$self"}],"detail":"($self)","definition":"sub","range":{"start":{"character":0,"line":201},"end":{"character":9999,"line":204}},"kind":12,"line":201,"signature":{"label":"get_root_node($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Tree.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from Bio::Tree::Tree by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Tree - An Organism Level Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon in combination with\n    # Bio::Tree::Tree instead\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n    my @leaves = $tree->get_leaves;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Taxonomic Nodes which make up a tree.\n\n=head1 EXAMPLES\n\n  use Bio::Species;\n  use Bio::Taxonomy::Tree;\n\n  my $human=Bio::Species->new();\n  my $chimp=Bio::Species->new();\n  my $bonobo=Bio::Species->new();\n\n  $human->classification(qw( sapiens Homo Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $chimp->classification(qw( troglodytes Pan Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $bonobo->classification(qw( paniscus Pan Hominidae\n                              Catarrhini Primates Eutheria\n                              Mammalia Euteleostomi Vertebrata \n                              Craniata Chordata\n                              Metazoa Eukaryota ));\n\n  # ranks passed to $taxonomy match ranks of species\n  my @ranks = ('superkingdom','kingdom','phylum','subphylum',\n               'no rank 1','no rank 2','class','no rank 3','order',\n               'suborder','family','genus','species');\n\n  my $taxonomy=Bio::Taxonomy->new(-ranks => \\@ranks,\n                                 -method => 'trust',\n                                 -order => -1);\n\n\n  my $tree1=Bio::Taxonomy::Tree->new();\n  my $tree2=Bio::Taxonomy::Tree->new();\n\n  $tree1->make_species_branch($human,$taxonomy);\n  $tree2->make_species_branch($chimp,$taxonomy);\n\n  my ($homo_sapiens)=$tree1->get_leaves;\n\n  $tree1->splice($tree2);\n\n  $tree1->add_species($bonobo,$taxonomy);\n\n  my @taxa;\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n  @taxa=();\n  $tree1->remove_branch($homo_sapiens);\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n=head1 FEEDBACK\n\nSee AUTHOR\n\n=head1 AUTHOR - Dan Kortschak\n\nEmail kortschak@rsbs.anu.edu.au\n\n=head1 CONTRIBUTORS\n\nMainly Jason Stajich\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Code begins...\n\n\npackage Bio::Taxonomy::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Taxonomy::Taxon;\n\n# Import rank information from Bio::Taxonomy.pm\nuse vars qw(@RANK %RANK);\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Tree->new();\n Function: Builds a new Bio::Taxonomy::Tree object \n Returns : Bio::Taxonomy::Tree\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Tree is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n  \n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n\n  my ($root)= $self->_rearrange([qw(ROOT)], @args);\n  if( $root ) { $self->set_root_node($root); }\n  return $self;\n}\n\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'height';\n\n   if ($order =~ m/^b|(breadth)$/oi) {\n      my $node = $self->get_root_node;\n      my @children = ($node);\n      for (@children) {\n\t   push @children, $_->each_Descendent($sortby);\n      }\n      return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my $node = $self->get_root_node;\n       my @children = ($node,$node->get_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Taxonomy::Taxon object\n Args    : none"}},{"signature":{"label":"set_root_node($self,$value)","documentation":"1;\n# $Id: Tree.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from Bio::Tree::Tree by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Tree - An Organism Level Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon in combination with\n    # Bio::Tree::Tree instead\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n    my @leaves = $tree->get_leaves;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Taxonomic Nodes which make up a tree.\n\n=head1 EXAMPLES\n\n  use Bio::Species;\n  use Bio::Taxonomy::Tree;\n\n  my $human=Bio::Species->new();\n  my $chimp=Bio::Species->new();\n  my $bonobo=Bio::Species->new();\n\n  $human->classification(qw( sapiens Homo Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $chimp->classification(qw( troglodytes Pan Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $bonobo->classification(qw( paniscus Pan Hominidae\n                              Catarrhini Primates Eutheria\n                              Mammalia Euteleostomi Vertebrata \n                              Craniata Chordata\n                              Metazoa Eukaryota ));\n\n  # ranks passed to $taxonomy match ranks of species\n  my @ranks = ('superkingdom','kingdom','phylum','subphylum',\n               'no rank 1','no rank 2','class','no rank 3','order',\n               'suborder','family','genus','species');\n\n  my $taxonomy=Bio::Taxonomy->new(-ranks => \\@ranks,\n                                 -method => 'trust',\n                                 -order => -1);\n\n\n  my $tree1=Bio::Taxonomy::Tree->new();\n  my $tree2=Bio::Taxonomy::Tree->new();\n\n  $tree1->make_species_branch($human,$taxonomy);\n  $tree2->make_species_branch($chimp,$taxonomy);\n\n  my ($homo_sapiens)=$tree1->get_leaves;\n\n  $tree1->splice($tree2);\n\n  $tree1->add_species($bonobo,$taxonomy);\n\n  my @taxa;\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n  @taxa=();\n  $tree1->remove_branch($homo_sapiens);\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n=head1 FEEDBACK\n\nSee AUTHOR\n\n=head1 AUTHOR - Dan Kortschak\n\nEmail kortschak@rsbs.anu.edu.au\n\n=head1 CONTRIBUTORS\n\nMainly Jason Stajich\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Code begins...\n\n\npackage Bio::Taxonomy::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Taxonomy::Taxon;\n\n# Import rank information from Bio::Taxonomy.pm\nuse vars qw(@RANK %RANK);\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Tree->new();\n Function: Builds a new Bio::Taxonomy::Tree object \n Returns : Bio::Taxonomy::Tree\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Tree is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n  \n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n\n  my ($root)= $self->_rearrange([qw(ROOT)], @args);\n  if( $root ) { $self->set_root_node($root); }\n  return $self;\n}\n\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'height';\n\n   if ($order =~ m/^b|(breadth)$/oi) {\n      my $node = $self->get_root_node;\n      my @children = ($node);\n      for (@children) {\n\t   push @children, $_->each_Descendent($sortby);\n      }\n      return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my $node = $self->get_root_node;\n       my @children = ($node,$node->get_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Taxonomy::Taxon object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Taxonomy::Taxon\n Args    : Bio::Taxonomy::Taxon","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"range":{"start":{"character":0,"line":217},"end":{"line":227,"character":9999}},"line":217,"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"set_root_node","children":[{"line":218,"name":"$self","localvar":"my","kind":13,"containerName":"set_root_node","definition":"my"},{"line":218,"kind":13,"containerName":"set_root_node","name":"$value"},{"name":"$value","kind":13,"containerName":"set_root_node","line":219},{"line":220,"kind":13,"containerName":"set_root_node","name":"$value"},{"line":220,"containerName":"set_root_node","kind":12,"name":"isa"},{"line":221,"containerName":"set_root_node","kind":13,"name":"$self"},{"line":221,"containerName":"set_root_node","kind":12,"name":"warn"},{"kind":13,"containerName":"set_root_node","name":"$self","line":222},{"name":"get_root_node","kind":12,"containerName":"set_root_node","line":222},{"kind":13,"containerName":"set_root_node","name":"$self","line":224},{"name":"$value","kind":13,"containerName":"set_root_node","line":224},{"line":226,"name":"$self","containerName":"set_root_node","kind":13},{"name":"get_root_node","containerName":"set_root_node","kind":12,"line":226}]},{"detail":"($self)","definition":"sub","containerName":"main::","name":"get_leaves","children":[{"name":"$self","containerName":"get_leaves","localvar":"my","kind":13,"line":242,"definition":"my"},{"kind":13,"localvar":"my","containerName":"get_leaves","name":"$node","line":244,"definition":"my"},{"line":244,"name":"$self","kind":13,"containerName":"get_leaves"},{"line":244,"name":"get_root_node","containerName":"get_leaves","kind":12},{"containerName":"get_leaves","localvar":"my","kind":13,"name":"@leaves","line":245,"definition":"my"},{"localvar":"my","kind":13,"containerName":"get_leaves","name":"@children","line":246,"definition":"my"},{"name":"$node","containerName":"get_leaves","kind":13,"line":246},{"line":247,"containerName":"get_leaves","kind":13,"name":"@children"},{"line":248,"containerName":"get_leaves","kind":13,"name":"@children"},{"kind":12,"containerName":"get_leaves","name":"each_Descendent","line":248},{"line":250,"containerName":"get_leaves","kind":13,"name":"@children"},{"line":251,"kind":13,"containerName":"get_leaves","name":"@leaves"},{"line":251,"kind":12,"containerName":"get_leaves","name":"is_Leaf"},{"name":"@leaves","containerName":"get_leaves","kind":13,"line":253}],"signature":{"label":"get_leaves($self)","documentation":"1;\n# $Id: Tree.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from Bio::Tree::Tree by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Tree - An Organism Level Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon in combination with\n    # Bio::Tree::Tree instead\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n    my @leaves = $tree->get_leaves;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Taxonomic Nodes which make up a tree.\n\n=head1 EXAMPLES\n\n  use Bio::Species;\n  use Bio::Taxonomy::Tree;\n\n  my $human=Bio::Species->new();\n  my $chimp=Bio::Species->new();\n  my $bonobo=Bio::Species->new();\n\n  $human->classification(qw( sapiens Homo Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $chimp->classification(qw( troglodytes Pan Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $bonobo->classification(qw( paniscus Pan Hominidae\n                              Catarrhini Primates Eutheria\n                              Mammalia Euteleostomi Vertebrata \n                              Craniata Chordata\n                              Metazoa Eukaryota ));\n\n  # ranks passed to $taxonomy match ranks of species\n  my @ranks = ('superkingdom','kingdom','phylum','subphylum',\n               'no rank 1','no rank 2','class','no rank 3','order',\n               'suborder','family','genus','species');\n\n  my $taxonomy=Bio::Taxonomy->new(-ranks => \\@ranks,\n                                 -method => 'trust',\n                                 -order => -1);\n\n\n  my $tree1=Bio::Taxonomy::Tree->new();\n  my $tree2=Bio::Taxonomy::Tree->new();\n\n  $tree1->make_species_branch($human,$taxonomy);\n  $tree2->make_species_branch($chimp,$taxonomy);\n\n  my ($homo_sapiens)=$tree1->get_leaves;\n\n  $tree1->splice($tree2);\n\n  $tree1->add_species($bonobo,$taxonomy);\n\n  my @taxa;\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n  @taxa=();\n  $tree1->remove_branch($homo_sapiens);\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n=head1 FEEDBACK\n\nSee AUTHOR\n\n=head1 AUTHOR - Dan Kortschak\n\nEmail kortschak@rsbs.anu.edu.au\n\n=head1 CONTRIBUTORS\n\nMainly Jason Stajich\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Code begins...\n\n\npackage Bio::Taxonomy::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Taxonomy::Taxon;\n\n# Import rank information from Bio::Taxonomy.pm\nuse vars qw(@RANK %RANK);\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Tree->new();\n Function: Builds a new Bio::Taxonomy::Tree object \n Returns : Bio::Taxonomy::Tree\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Tree is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n  \n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n\n  my ($root)= $self->_rearrange([qw(ROOT)], @args);\n  if( $root ) { $self->set_root_node($root); }\n  return $self;\n}\n\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'height';\n\n   if ($order =~ m/^b|(breadth)$/oi) {\n      my $node = $self->get_root_node;\n      my @children = ($node);\n      for (@children) {\n\t   push @children, $_->each_Descendent($sortby);\n      }\n      return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my $node = $self->get_root_node;\n       my @children = ($node,$node->get_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Taxonomy::Taxon object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Taxonomy::Taxon\n Args    : Bio::Taxonomy::Taxon\n\n\n\nsub set_root_node{\n   my ($self,$value) = @_;\n   if( defined $value ) { \n      if( ! $value->isa('Bio::Taxonomy::Taxon') ) { \n\t   $self->warn(\"Trying to set the root node to $value which is not a Bio::Taxonomy::Taxon\");\n\t   return $self->get_root_node;\n      }\n      $self->{'_rootnode'} = $value;\n   }\n   return $self->get_root_node;\n}\n\n\n=head2 get_leaves\n\n Title   : get_leaves\n Usage   : my @nodes = $tree->get_leaves()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : ","parameters":[{"label":"$self"}]},"kind":12,"range":{"start":{"line":241,"character":0},"end":{"line":254,"character":9999}},"line":241},{"line":269,"range":{"end":{"line":301,"character":9999},"start":{"character":0,"line":269}},"kind":12,"signature":{"documentation":"1;\n# $Id: Tree.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from Bio::Tree::Tree by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Tree - An Organism Level Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon in combination with\n    # Bio::Tree::Tree instead\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n    my @leaves = $tree->get_leaves;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Taxonomic Nodes which make up a tree.\n\n=head1 EXAMPLES\n\n  use Bio::Species;\n  use Bio::Taxonomy::Tree;\n\n  my $human=Bio::Species->new();\n  my $chimp=Bio::Species->new();\n  my $bonobo=Bio::Species->new();\n\n  $human->classification(qw( sapiens Homo Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $chimp->classification(qw( troglodytes Pan Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $bonobo->classification(qw( paniscus Pan Hominidae\n                              Catarrhini Primates Eutheria\n                              Mammalia Euteleostomi Vertebrata \n                              Craniata Chordata\n                              Metazoa Eukaryota ));\n\n  # ranks passed to $taxonomy match ranks of species\n  my @ranks = ('superkingdom','kingdom','phylum','subphylum',\n               'no rank 1','no rank 2','class','no rank 3','order',\n               'suborder','family','genus','species');\n\n  my $taxonomy=Bio::Taxonomy->new(-ranks => \\@ranks,\n                                 -method => 'trust',\n                                 -order => -1);\n\n\n  my $tree1=Bio::Taxonomy::Tree->new();\n  my $tree2=Bio::Taxonomy::Tree->new();\n\n  $tree1->make_species_branch($human,$taxonomy);\n  $tree2->make_species_branch($chimp,$taxonomy);\n\n  my ($homo_sapiens)=$tree1->get_leaves;\n\n  $tree1->splice($tree2);\n\n  $tree1->add_species($bonobo,$taxonomy);\n\n  my @taxa;\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n  @taxa=();\n  $tree1->remove_branch($homo_sapiens);\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n=head1 FEEDBACK\n\nSee AUTHOR\n\n=head1 AUTHOR - Dan Kortschak\n\nEmail kortschak@rsbs.anu.edu.au\n\n=head1 CONTRIBUTORS\n\nMainly Jason Stajich\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Code begins...\n\n\npackage Bio::Taxonomy::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Taxonomy::Taxon;\n\n# Import rank information from Bio::Taxonomy.pm\nuse vars qw(@RANK %RANK);\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Tree->new();\n Function: Builds a new Bio::Taxonomy::Tree object \n Returns : Bio::Taxonomy::Tree\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Tree is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n  \n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n\n  my ($root)= $self->_rearrange([qw(ROOT)], @args);\n  if( $root ) { $self->set_root_node($root); }\n  return $self;\n}\n\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'height';\n\n   if ($order =~ m/^b|(breadth)$/oi) {\n      my $node = $self->get_root_node;\n      my @children = ($node);\n      for (@children) {\n\t   push @children, $_->each_Descendent($sortby);\n      }\n      return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my $node = $self->get_root_node;\n       my @children = ($node,$node->get_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Taxonomy::Taxon object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Taxonomy::Taxon\n Args    : Bio::Taxonomy::Taxon\n\n\n\nsub set_root_node{\n   my ($self,$value) = @_;\n   if( defined $value ) { \n      if( ! $value->isa('Bio::Taxonomy::Taxon') ) { \n\t   $self->warn(\"Trying to set the root node to $value which is not a Bio::Taxonomy::Taxon\");\n\t   return $self->get_root_node;\n      }\n      $self->{'_rootnode'} = $value;\n   }\n   return $self->get_root_node;\n}\n\n\n=head2 get_leaves\n\n Title   : get_leaves\n Usage   : my @nodes = $tree->get_leaves()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : \n\n\n\nsub get_leaves{\n   my ($self) = @_;\n   \n   my $node = $self->get_root_node;\n   my @leaves;\n   my @children = ($node);\n   for (@children) {\n      push @children, $_->each_Descendent();\n   }\n   for (@children) {\n      push @leaves, $_ if $_->is_Leaf;\n   }\n   return @leaves;\n}\n\n=head2 make_species_branch\n\n Title   : make_species_branch\n Usage   : @nodes = $tree->make_species_branch($species,$taxonomy)\n Function: Return list of Bio::Taxonomy::Taxon objects based on a Bio::Species object\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : Bio::Species and Bio::Taxonomy objects\n\n I'm not happy that make_species_branch and make_branch are seperate routines\n should be able to just make_branch and have it sort things out","parameters":[{"label":"$self"},{"label":"$species"},{"label":"$taxonomy"}],"label":"make_species_branch($self,$species,$taxonomy)"},"children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"make_species_branch","line":270},{"line":270,"containerName":"make_species_branch","kind":13,"name":"$species"},{"line":270,"name":"$taxonomy","kind":13,"containerName":"make_species_branch"},{"kind":13,"containerName":"make_species_branch","name":"$species","line":272},{"kind":12,"containerName":"make_species_branch","name":"isa","line":272},{"name":"$self","containerName":"make_species_branch","kind":13,"line":273},{"line":273,"name":"throw","containerName":"make_species_branch","kind":12},{"line":275,"kind":13,"containerName":"make_species_branch","name":"$taxonomy"},{"line":275,"name":"isa","containerName":"make_species_branch","kind":12},{"name":"$self","kind":13,"containerName":"make_species_branch","line":276},{"name":"throw","kind":12,"containerName":"make_species_branch","line":276},{"containerName":"make_species_branch","kind":13,"name":"$self","line":280},{"name":"get_root_node","kind":12,"containerName":"make_species_branch","line":280},{"name":"$self","containerName":"make_species_branch","kind":13,"line":281},{"kind":12,"containerName":"make_species_branch","name":"get_root_node","line":281},{"kind":12,"containerName":"make_species_branch","name":"remove_all_Descendents","line":281},{"name":"@nodes","kind":13,"localvar":"my","containerName":"make_species_branch","line":284,"definition":"my"},{"line":287,"kind":13,"localvar":"my","containerName":"make_species_branch","name":"@taxa","definition":"my"},{"line":287,"name":"$taxonomy","containerName":"make_species_branch","kind":13},{"line":287,"kind":12,"containerName":"make_species_branch","name":"classify"},{"line":287,"kind":13,"containerName":"make_species_branch","name":"$species"},{"name":"$i","kind":13,"localvar":"my","containerName":"make_species_branch","line":289,"definition":"my"},{"line":289,"name":"$i","kind":13,"containerName":"make_species_branch"},{"name":"@taxa","containerName":"make_species_branch","kind":13,"line":289},{"name":"$i","kind":13,"containerName":"make_species_branch","line":289},{"kind":13,"containerName":"make_species_branch","name":"$nodes","line":290},{"line":290,"name":"$i","kind":13,"containerName":"make_species_branch"},{"line":290,"kind":12,"containerName":"make_species_branch","name":"new"},{"line":290,"name":"$taxa","kind":13,"containerName":"make_species_branch"},{"name":"$i","containerName":"make_species_branch","kind":13,"line":290},{"name":"$taxa","containerName":"make_species_branch","kind":13,"line":291},{"line":291,"name":"$i","containerName":"make_species_branch","kind":13},{"line":294,"name":"$i","localvar":"my","containerName":"make_species_branch","kind":13,"definition":"my"},{"line":294,"containerName":"make_species_branch","kind":13,"name":"$i"},{"line":294,"kind":13,"containerName":"make_species_branch","name":"@taxa"},{"line":294,"name":"$i","kind":13,"containerName":"make_species_branch"},{"line":295,"name":"$nodes","kind":13,"containerName":"make_species_branch"},{"name":"$i","containerName":"make_species_branch","kind":13,"line":295},{"kind":12,"containerName":"make_species_branch","name":"add_Descendent","line":295},{"line":295,"containerName":"make_species_branch","kind":13,"name":"$nodes"},{"line":295,"containerName":"make_species_branch","kind":13,"name":"$i"},{"name":"$self","kind":13,"containerName":"make_species_branch","line":298},{"line":298,"name":"set_root_node","kind":12,"containerName":"make_species_branch"},{"name":"$nodes","containerName":"make_species_branch","kind":13,"line":298},{"line":300,"containerName":"make_species_branch","kind":13,"name":"@nodes"}],"name":"make_species_branch","containerName":"main::","definition":"sub","detail":"($self,$species,$taxonomy)"},{"name":"Bio","containerName":"Taxonomy::Taxon","kind":12,"line":290},{"line":315,"kind":12,"range":{"start":{"line":315,"character":0},"end":{"character":9999,"line":327}},"signature":{"label":"make_branch($self,$node)","parameters":[{"label":"$self"},{"label":"$node"}],"documentation":"1;\n# $Id: Tree.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from Bio::Tree::Tree by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Tree - An Organism Level Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon in combination with\n    # Bio::Tree::Tree instead\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n    my @leaves = $tree->get_leaves;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Taxonomic Nodes which make up a tree.\n\n=head1 EXAMPLES\n\n  use Bio::Species;\n  use Bio::Taxonomy::Tree;\n\n  my $human=Bio::Species->new();\n  my $chimp=Bio::Species->new();\n  my $bonobo=Bio::Species->new();\n\n  $human->classification(qw( sapiens Homo Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $chimp->classification(qw( troglodytes Pan Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $bonobo->classification(qw( paniscus Pan Hominidae\n                              Catarrhini Primates Eutheria\n                              Mammalia Euteleostomi Vertebrata \n                              Craniata Chordata\n                              Metazoa Eukaryota ));\n\n  # ranks passed to $taxonomy match ranks of species\n  my @ranks = ('superkingdom','kingdom','phylum','subphylum',\n               'no rank 1','no rank 2','class','no rank 3','order',\n               'suborder','family','genus','species');\n\n  my $taxonomy=Bio::Taxonomy->new(-ranks => \\@ranks,\n                                 -method => 'trust',\n                                 -order => -1);\n\n\n  my $tree1=Bio::Taxonomy::Tree->new();\n  my $tree2=Bio::Taxonomy::Tree->new();\n\n  $tree1->make_species_branch($human,$taxonomy);\n  $tree2->make_species_branch($chimp,$taxonomy);\n\n  my ($homo_sapiens)=$tree1->get_leaves;\n\n  $tree1->splice($tree2);\n\n  $tree1->add_species($bonobo,$taxonomy);\n\n  my @taxa;\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n  @taxa=();\n  $tree1->remove_branch($homo_sapiens);\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n=head1 FEEDBACK\n\nSee AUTHOR\n\n=head1 AUTHOR - Dan Kortschak\n\nEmail kortschak@rsbs.anu.edu.au\n\n=head1 CONTRIBUTORS\n\nMainly Jason Stajich\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Code begins...\n\n\npackage Bio::Taxonomy::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Taxonomy::Taxon;\n\n# Import rank information from Bio::Taxonomy.pm\nuse vars qw(@RANK %RANK);\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Tree->new();\n Function: Builds a new Bio::Taxonomy::Tree object \n Returns : Bio::Taxonomy::Tree\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Tree is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n  \n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n\n  my ($root)= $self->_rearrange([qw(ROOT)], @args);\n  if( $root ) { $self->set_root_node($root); }\n  return $self;\n}\n\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'height';\n\n   if ($order =~ m/^b|(breadth)$/oi) {\n      my $node = $self->get_root_node;\n      my @children = ($node);\n      for (@children) {\n\t   push @children, $_->each_Descendent($sortby);\n      }\n      return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my $node = $self->get_root_node;\n       my @children = ($node,$node->get_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Taxonomy::Taxon object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Taxonomy::Taxon\n Args    : Bio::Taxonomy::Taxon\n\n\n\nsub set_root_node{\n   my ($self,$value) = @_;\n   if( defined $value ) { \n      if( ! $value->isa('Bio::Taxonomy::Taxon') ) { \n\t   $self->warn(\"Trying to set the root node to $value which is not a Bio::Taxonomy::Taxon\");\n\t   return $self->get_root_node;\n      }\n      $self->{'_rootnode'} = $value;\n   }\n   return $self->get_root_node;\n}\n\n\n=head2 get_leaves\n\n Title   : get_leaves\n Usage   : my @nodes = $tree->get_leaves()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : \n\n\n\nsub get_leaves{\n   my ($self) = @_;\n   \n   my $node = $self->get_root_node;\n   my @leaves;\n   my @children = ($node);\n   for (@children) {\n      push @children, $_->each_Descendent();\n   }\n   for (@children) {\n      push @leaves, $_ if $_->is_Leaf;\n   }\n   return @leaves;\n}\n\n=head2 make_species_branch\n\n Title   : make_species_branch\n Usage   : @nodes = $tree->make_species_branch($species,$taxonomy)\n Function: Return list of Bio::Taxonomy::Taxon objects based on a Bio::Species object\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : Bio::Species and Bio::Taxonomy objects\n\n\n# I'm not happy that make_species_branch and make_branch are seperate routines\n# should be able to just make_branch and have it sort things out\n\nsub make_species_branch{\n   my ($self,$species,$taxonomy) = @_;\n   \n   if (! $species->isa('Bio::Species') ) {\n      $self->throw(\"Trying to classify $species which is not a Bio::Species object\");\n   }\n   if (! $taxonomy->isa('Bio::Taxonomy') ) {\n      $self->throw(\"Trying to classify with $taxonomy which is not a Bio::Taxonomy object\");\n   }\n\n   # this is done to make sure we aren't duplicating a path (let God sort them out)\n   if (defined $self->get_root_node) {\n      $self->get_root_node->remove_all_Descendents;\n   }\n\n   my @nodes;\n\n   # nb taxa in [i][0] and ranks in [i][1]\n   my @taxa=$taxonomy->classify($species);\n\n   for (my $i = 0; $i < @taxa; $i++) {\n      $nodes[$i]=Bio::Taxonomy::Taxon->new(-taxon => $taxa[$i][0],\n                                           -rank  => $taxa[$i][1]);\n   }\n\n   for (my $i = 0; $i < @taxa-1; $i++) {\n      $nodes[$i]->add_Descendent($nodes[$i+1]);\n   }\n\n   $self->set_root_node($nodes[0]);\n\n   return @nodes;\n}\n\n\n=head2 make_branch\n\n Title   : make_branch\n Usage   : $tree->make_branch($node)\n Function: Make a linear Bio::Taxonomy::Tree object from a leafish node\n Returns :\n Args    : Bio::Taxonomy::Taxon object"},"children":[{"line":316,"kind":13,"localvar":"my","containerName":"make_branch","name":"$self","definition":"my"},{"containerName":"make_branch","kind":13,"name":"$node","line":316},{"line":321,"name":"$self","containerName":"make_branch","kind":13},{"line":321,"containerName":"make_branch","kind":12,"name":"get_root_node"},{"line":321,"kind":12,"containerName":"make_branch","name":"remove_all_Descendents"},{"name":"$node","containerName":"make_branch","kind":13,"line":323},{"line":323,"name":"ancestor","containerName":"make_branch","kind":12},{"line":324,"containerName":"make_branch","kind":13,"name":"$self"},{"line":324,"name":"set_root_node","kind":12,"containerName":"make_branch"},{"line":324,"kind":13,"containerName":"make_branch","name":"$node"},{"line":325,"kind":13,"containerName":"make_branch","name":"$node"},{"line":325,"kind":13,"containerName":"make_branch","name":"$node"},{"containerName":"make_branch","kind":12,"name":"ancestor","line":325}],"name":"make_branch","containerName":"main::","definition":"sub","detail":"($self,$node)"},{"kind":12,"range":{"start":{"character":0,"line":341},"end":{"line":352,"character":9999}},"line":341,"signature":{"documentation":"1;\n# $Id: Tree.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from Bio::Tree::Tree by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Tree - An Organism Level Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon in combination with\n    # Bio::Tree::Tree instead\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n    my @leaves = $tree->get_leaves;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Taxonomic Nodes which make up a tree.\n\n=head1 EXAMPLES\n\n  use Bio::Species;\n  use Bio::Taxonomy::Tree;\n\n  my $human=Bio::Species->new();\n  my $chimp=Bio::Species->new();\n  my $bonobo=Bio::Species->new();\n\n  $human->classification(qw( sapiens Homo Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $chimp->classification(qw( troglodytes Pan Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $bonobo->classification(qw( paniscus Pan Hominidae\n                              Catarrhini Primates Eutheria\n                              Mammalia Euteleostomi Vertebrata \n                              Craniata Chordata\n                              Metazoa Eukaryota ));\n\n  # ranks passed to $taxonomy match ranks of species\n  my @ranks = ('superkingdom','kingdom','phylum','subphylum',\n               'no rank 1','no rank 2','class','no rank 3','order',\n               'suborder','family','genus','species');\n\n  my $taxonomy=Bio::Taxonomy->new(-ranks => \\@ranks,\n                                 -method => 'trust',\n                                 -order => -1);\n\n\n  my $tree1=Bio::Taxonomy::Tree->new();\n  my $tree2=Bio::Taxonomy::Tree->new();\n\n  $tree1->make_species_branch($human,$taxonomy);\n  $tree2->make_species_branch($chimp,$taxonomy);\n\n  my ($homo_sapiens)=$tree1->get_leaves;\n\n  $tree1->splice($tree2);\n\n  $tree1->add_species($bonobo,$taxonomy);\n\n  my @taxa;\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n  @taxa=();\n  $tree1->remove_branch($homo_sapiens);\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n=head1 FEEDBACK\n\nSee AUTHOR\n\n=head1 AUTHOR - Dan Kortschak\n\nEmail kortschak@rsbs.anu.edu.au\n\n=head1 CONTRIBUTORS\n\nMainly Jason Stajich\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Code begins...\n\n\npackage Bio::Taxonomy::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Taxonomy::Taxon;\n\n# Import rank information from Bio::Taxonomy.pm\nuse vars qw(@RANK %RANK);\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Tree->new();\n Function: Builds a new Bio::Taxonomy::Tree object \n Returns : Bio::Taxonomy::Tree\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Tree is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n  \n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n\n  my ($root)= $self->_rearrange([qw(ROOT)], @args);\n  if( $root ) { $self->set_root_node($root); }\n  return $self;\n}\n\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'height';\n\n   if ($order =~ m/^b|(breadth)$/oi) {\n      my $node = $self->get_root_node;\n      my @children = ($node);\n      for (@children) {\n\t   push @children, $_->each_Descendent($sortby);\n      }\n      return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my $node = $self->get_root_node;\n       my @children = ($node,$node->get_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Taxonomy::Taxon object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Taxonomy::Taxon\n Args    : Bio::Taxonomy::Taxon\n\n\n\nsub set_root_node{\n   my ($self,$value) = @_;\n   if( defined $value ) { \n      if( ! $value->isa('Bio::Taxonomy::Taxon') ) { \n\t   $self->warn(\"Trying to set the root node to $value which is not a Bio::Taxonomy::Taxon\");\n\t   return $self->get_root_node;\n      }\n      $self->{'_rootnode'} = $value;\n   }\n   return $self->get_root_node;\n}\n\n\n=head2 get_leaves\n\n Title   : get_leaves\n Usage   : my @nodes = $tree->get_leaves()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : \n\n\n\nsub get_leaves{\n   my ($self) = @_;\n   \n   my $node = $self->get_root_node;\n   my @leaves;\n   my @children = ($node);\n   for (@children) {\n      push @children, $_->each_Descendent();\n   }\n   for (@children) {\n      push @leaves, $_ if $_->is_Leaf;\n   }\n   return @leaves;\n}\n\n=head2 make_species_branch\n\n Title   : make_species_branch\n Usage   : @nodes = $tree->make_species_branch($species,$taxonomy)\n Function: Return list of Bio::Taxonomy::Taxon objects based on a Bio::Species object\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : Bio::Species and Bio::Taxonomy objects\n\n\n# I'm not happy that make_species_branch and make_branch are seperate routines\n# should be able to just make_branch and have it sort things out\n\nsub make_species_branch{\n   my ($self,$species,$taxonomy) = @_;\n   \n   if (! $species->isa('Bio::Species') ) {\n      $self->throw(\"Trying to classify $species which is not a Bio::Species object\");\n   }\n   if (! $taxonomy->isa('Bio::Taxonomy') ) {\n      $self->throw(\"Trying to classify with $taxonomy which is not a Bio::Taxonomy object\");\n   }\n\n   # this is done to make sure we aren't duplicating a path (let God sort them out)\n   if (defined $self->get_root_node) {\n      $self->get_root_node->remove_all_Descendents;\n   }\n\n   my @nodes;\n\n   # nb taxa in [i][0] and ranks in [i][1]\n   my @taxa=$taxonomy->classify($species);\n\n   for (my $i = 0; $i < @taxa; $i++) {\n      $nodes[$i]=Bio::Taxonomy::Taxon->new(-taxon => $taxa[$i][0],\n                                           -rank  => $taxa[$i][1]);\n   }\n\n   for (my $i = 0; $i < @taxa-1; $i++) {\n      $nodes[$i]->add_Descendent($nodes[$i+1]);\n   }\n\n   $self->set_root_node($nodes[0]);\n\n   return @nodes;\n}\n\n\n=head2 make_branch\n\n Title   : make_branch\n Usage   : $tree->make_branch($node)\n Function: Make a linear Bio::Taxonomy::Tree object from a leafish node\n Returns :\n Args    : Bio::Taxonomy::Taxon object\n\n\n\nsub make_branch{\n   my ($self,$node) = @_;\n\n   # this is done to make sure we aren't duplicating a path (let God sort them out)\n   # note that if you are using a linked set of node which include node \n   # already in the tree, this will break\n   $self->get_root_node->remove_all_Descendents;\n   \n   while (defined $node->ancestor) {\n      $self->set_root_node($node);\n      $node=$node->ancestor;\n   }\n}\n\n\n=head2 splice\n\n Title   : splice\n Usage   : @nodes = $tree->splice($tree)\n Function: Return a of Bio::Taxonomy::Tree object that is a fusion of two\n Returns : array of Bio::Taxonomy::Taxon added to tree\n Args    : Bio::Taxonomy::Tree object","parameters":[{"label":"$self"},{"label":"$tree"}],"label":"splice($self,$tree)"},"name":"splice","containerName":"main::","children":[{"name":"$self","containerName":"splice","localvar":"my","kind":13,"line":342,"definition":"my"},{"kind":13,"containerName":"splice","name":"$tree","line":342},{"line":344,"name":"@nodes","kind":13,"localvar":"my","containerName":"splice","definition":"my"},{"line":346,"kind":13,"localvar":"my","containerName":"splice","name":"@newleaves","definition":"my"},{"line":346,"name":"$tree","kind":13,"containerName":"splice"},{"line":346,"kind":12,"containerName":"splice","name":"get_leaves"},{"definition":"my","localvar":"my","containerName":"splice","kind":13,"name":"$leaf","line":347},{"containerName":"splice","kind":13,"name":"@newleaves","line":347},{"kind":13,"containerName":"splice","name":"@nodes","line":348},{"name":"$self","containerName":"splice","kind":13,"line":348},{"line":348,"kind":12,"containerName":"splice","name":"add_branch"},{"line":348,"name":"$leaf","containerName":"splice","kind":13},{"line":351,"name":"@nodes","kind":13,"containerName":"splice"}],"detail":"($self,$tree)","definition":"sub"},{"signature":{"label":"add_species($self,$species,$taxonomy)","documentation":"1;\n# $Id: Tree.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from Bio::Tree::Tree by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Tree - An Organism Level Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon in combination with\n    # Bio::Tree::Tree instead\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n    my @leaves = $tree->get_leaves;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Taxonomic Nodes which make up a tree.\n\n=head1 EXAMPLES\n\n  use Bio::Species;\n  use Bio::Taxonomy::Tree;\n\n  my $human=Bio::Species->new();\n  my $chimp=Bio::Species->new();\n  my $bonobo=Bio::Species->new();\n\n  $human->classification(qw( sapiens Homo Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $chimp->classification(qw( troglodytes Pan Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $bonobo->classification(qw( paniscus Pan Hominidae\n                              Catarrhini Primates Eutheria\n                              Mammalia Euteleostomi Vertebrata \n                              Craniata Chordata\n                              Metazoa Eukaryota ));\n\n  # ranks passed to $taxonomy match ranks of species\n  my @ranks = ('superkingdom','kingdom','phylum','subphylum',\n               'no rank 1','no rank 2','class','no rank 3','order',\n               'suborder','family','genus','species');\n\n  my $taxonomy=Bio::Taxonomy->new(-ranks => \\@ranks,\n                                 -method => 'trust',\n                                 -order => -1);\n\n\n  my $tree1=Bio::Taxonomy::Tree->new();\n  my $tree2=Bio::Taxonomy::Tree->new();\n\n  $tree1->make_species_branch($human,$taxonomy);\n  $tree2->make_species_branch($chimp,$taxonomy);\n\n  my ($homo_sapiens)=$tree1->get_leaves;\n\n  $tree1->splice($tree2);\n\n  $tree1->add_species($bonobo,$taxonomy);\n\n  my @taxa;\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n  @taxa=();\n  $tree1->remove_branch($homo_sapiens);\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n=head1 FEEDBACK\n\nSee AUTHOR\n\n=head1 AUTHOR - Dan Kortschak\n\nEmail kortschak@rsbs.anu.edu.au\n\n=head1 CONTRIBUTORS\n\nMainly Jason Stajich\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Code begins...\n\n\npackage Bio::Taxonomy::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Taxonomy::Taxon;\n\n# Import rank information from Bio::Taxonomy.pm\nuse vars qw(@RANK %RANK);\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Tree->new();\n Function: Builds a new Bio::Taxonomy::Tree object \n Returns : Bio::Taxonomy::Tree\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Tree is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n  \n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n\n  my ($root)= $self->_rearrange([qw(ROOT)], @args);\n  if( $root ) { $self->set_root_node($root); }\n  return $self;\n}\n\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'height';\n\n   if ($order =~ m/^b|(breadth)$/oi) {\n      my $node = $self->get_root_node;\n      my @children = ($node);\n      for (@children) {\n\t   push @children, $_->each_Descendent($sortby);\n      }\n      return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my $node = $self->get_root_node;\n       my @children = ($node,$node->get_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Taxonomy::Taxon object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Taxonomy::Taxon\n Args    : Bio::Taxonomy::Taxon\n\n\n\nsub set_root_node{\n   my ($self,$value) = @_;\n   if( defined $value ) { \n      if( ! $value->isa('Bio::Taxonomy::Taxon') ) { \n\t   $self->warn(\"Trying to set the root node to $value which is not a Bio::Taxonomy::Taxon\");\n\t   return $self->get_root_node;\n      }\n      $self->{'_rootnode'} = $value;\n   }\n   return $self->get_root_node;\n}\n\n\n=head2 get_leaves\n\n Title   : get_leaves\n Usage   : my @nodes = $tree->get_leaves()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : \n\n\n\nsub get_leaves{\n   my ($self) = @_;\n   \n   my $node = $self->get_root_node;\n   my @leaves;\n   my @children = ($node);\n   for (@children) {\n      push @children, $_->each_Descendent();\n   }\n   for (@children) {\n      push @leaves, $_ if $_->is_Leaf;\n   }\n   return @leaves;\n}\n\n=head2 make_species_branch\n\n Title   : make_species_branch\n Usage   : @nodes = $tree->make_species_branch($species,$taxonomy)\n Function: Return list of Bio::Taxonomy::Taxon objects based on a Bio::Species object\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : Bio::Species and Bio::Taxonomy objects\n\n\n# I'm not happy that make_species_branch and make_branch are seperate routines\n# should be able to just make_branch and have it sort things out\n\nsub make_species_branch{\n   my ($self,$species,$taxonomy) = @_;\n   \n   if (! $species->isa('Bio::Species') ) {\n      $self->throw(\"Trying to classify $species which is not a Bio::Species object\");\n   }\n   if (! $taxonomy->isa('Bio::Taxonomy') ) {\n      $self->throw(\"Trying to classify with $taxonomy which is not a Bio::Taxonomy object\");\n   }\n\n   # this is done to make sure we aren't duplicating a path (let God sort them out)\n   if (defined $self->get_root_node) {\n      $self->get_root_node->remove_all_Descendents;\n   }\n\n   my @nodes;\n\n   # nb taxa in [i][0] and ranks in [i][1]\n   my @taxa=$taxonomy->classify($species);\n\n   for (my $i = 0; $i < @taxa; $i++) {\n      $nodes[$i]=Bio::Taxonomy::Taxon->new(-taxon => $taxa[$i][0],\n                                           -rank  => $taxa[$i][1]);\n   }\n\n   for (my $i = 0; $i < @taxa-1; $i++) {\n      $nodes[$i]->add_Descendent($nodes[$i+1]);\n   }\n\n   $self->set_root_node($nodes[0]);\n\n   return @nodes;\n}\n\n\n=head2 make_branch\n\n Title   : make_branch\n Usage   : $tree->make_branch($node)\n Function: Make a linear Bio::Taxonomy::Tree object from a leafish node\n Returns :\n Args    : Bio::Taxonomy::Taxon object\n\n\n\nsub make_branch{\n   my ($self,$node) = @_;\n\n   # this is done to make sure we aren't duplicating a path (let God sort them out)\n   # note that if you are using a linked set of node which include node \n   # already in the tree, this will break\n   $self->get_root_node->remove_all_Descendents;\n   \n   while (defined $node->ancestor) {\n      $self->set_root_node($node);\n      $node=$node->ancestor;\n   }\n}\n\n\n=head2 splice\n\n Title   : splice\n Usage   : @nodes = $tree->splice($tree)\n Function: Return a of Bio::Taxonomy::Tree object that is a fusion of two\n Returns : array of Bio::Taxonomy::Taxon added to tree\n Args    : Bio::Taxonomy::Tree object\n\n\n\nsub splice{\n   my ($self,$tree) = @_;\n\n   my @nodes;\n\n   my @newleaves = $tree->get_leaves;\n   foreach my $leaf (@newleaves) {\n      push @nodes,$self->add_branch($leaf);\n   }\n\n   return @nodes;\n}\n\n=head2 add_species\n\n Title   : add_species\n Usage   : @nodes = $tree->add_species($species,$taxonomy)\n Function: Return a of Bio::Taxonomy::Tree object with a new species added\n Returns : array of Bio::Taxonomy::Taxon added to tree\n Args    : Bio::Species object","parameters":[{"label":"$self"},{"label":"$species"},{"label":"$taxonomy"}]},"line":365,"range":{"end":{"character":9999,"line":374},"start":{"character":0,"line":365}},"kind":12,"definition":"sub","detail":"($self,$species,$taxonomy)","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"add_species","name":"$self","line":366},{"line":366,"name":"$species","kind":13,"containerName":"add_species"},{"name":"$taxonomy","containerName":"add_species","kind":13,"line":366},{"line":368,"name":"$branch","localvar":"my","containerName":"add_species","kind":13,"definition":"my"},{"kind":12,"containerName":"add_species","name":"new","line":368},{"definition":"my","localvar":"my","containerName":"add_species","kind":13,"name":"@nodes","line":369},{"line":369,"containerName":"add_species","kind":13,"name":"$branch"},{"kind":12,"containerName":"add_species","name":"make_species_branch","line":369},{"name":"$species","kind":13,"containerName":"add_species","line":369},{"line":369,"name":"$taxonomy","containerName":"add_species","kind":13},{"definition":"my","line":371,"name":"$newleaf","localvar":"my","kind":13,"containerName":"add_species"},{"name":"$branch","kind":13,"containerName":"add_species","line":371},{"containerName":"add_species","kind":12,"name":"get_leaves","line":371},{"containerName":"add_species","kind":13,"name":"$self","line":373},{"name":"add_branch","kind":12,"containerName":"add_species","line":373},{"containerName":"add_species","kind":13,"name":"$newleaf","line":373}],"containerName":"main::","name":"add_species"},{"kind":12,"containerName":"Taxonomy::Tree","name":"Bio","line":368},{"containerName":"main::","name":"add_branch","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"add_branch","line":390},{"line":390,"name":"$node","kind":13,"containerName":"add_branch"},{"name":"$force","kind":13,"containerName":"add_branch","line":390},{"containerName":"add_branch","localvar":"my","kind":13,"name":"$best_node_level","line":392,"definition":"my"},{"line":393,"name":"$best_node","localvar":"my","kind":13,"containerName":"add_branch","definition":"my"},{"kind":13,"containerName":"add_branch","name":"@nodes","line":393},{"line":393,"name":"$common","kind":13,"containerName":"add_branch"},{"definition":"my","name":"@leaves","containerName":"add_branch","localvar":"my","kind":13,"line":395},{"line":395,"name":"$self","kind":13,"containerName":"add_branch"},{"containerName":"add_branch","kind":12,"name":"get_leaves","line":395},{"line":396,"localvar":"my","containerName":"add_branch","kind":13,"name":"$leaf","definition":"my"},{"name":"@leaves","kind":13,"containerName":"add_branch","line":396},{"kind":13,"containerName":"add_branch","name":"$common","line":397},{"line":397,"name":"$node","containerName":"add_branch","kind":13},{"line":397,"containerName":"add_branch","kind":12,"name":"recent_common_ancestor"},{"line":397,"name":"$leaf","containerName":"add_branch","kind":13},{"kind":13,"containerName":"add_branch","name":"$common","line":398},{"name":"$common","containerName":"add_branch","kind":13,"line":398},{"line":398,"containerName":"add_branch","kind":12,"name":"distance_to_root"},{"kind":13,"containerName":"add_branch","name":"$best_node_level","line":398},{"line":399,"containerName":"add_branch","kind":13,"name":"$best_node_level"},{"line":399,"name":"$common","kind":13,"containerName":"add_branch"},{"line":399,"kind":12,"containerName":"add_branch","name":"distance_to_root"},{"line":400,"kind":13,"containerName":"add_branch","name":"$best_node"},{"name":"$common","containerName":"add_branch","kind":13,"line":400},{"containerName":"add_branch","kind":13,"name":"$best_node","line":404},{"name":"@nodes","kind":13,"containerName":"add_branch","line":406},{"name":"$self","kind":13,"containerName":"add_branch","line":406},{"line":406,"kind":12,"containerName":"add_branch","name":"get_root_node"},{"kind":13,"containerName":"add_branch","name":"$self","line":406},{"kind":12,"containerName":"add_branch","name":"get_root_node","line":406},{"line":406,"kind":12,"containerName":"add_branch","name":"get_Descendents"},{"definition":"my","name":"$node","localvar":"my","kind":13,"containerName":"add_branch","line":407},{"kind":13,"containerName":"add_branch","name":"@nodes","line":407},{"name":"$best_node","containerName":"add_branch","kind":13,"line":408},{"name":"id","kind":12,"containerName":"add_branch","line":408},{"line":408,"name":"$best_node","kind":13,"containerName":"add_branch"},{"line":408,"containerName":"add_branch","kind":12,"name":"id"},{"line":408,"name":"$node","kind":13,"containerName":"add_branch"},{"containerName":"add_branch","kind":12,"name":"id","line":408},{"line":409,"kind":13,"containerName":"add_branch","name":"$best_node"},{"name":"rank","kind":12,"containerName":"add_branch","line":409},{"line":409,"name":"$node","containerName":"add_branch","kind":13},{"containerName":"add_branch","kind":12,"name":"rank","line":409},{"line":409,"name":"$best_node","kind":13,"containerName":"add_branch"},{"line":409,"kind":12,"containerName":"add_branch","name":"taxon"},{"line":409,"name":"$node","kind":13,"containerName":"add_branch"},{"name":"taxon","containerName":"add_branch","kind":12,"line":409},{"name":"$best_node","kind":13,"containerName":"add_branch","line":410},{"line":410,"kind":12,"containerName":"add_branch","name":"rank"},{"definition":"my","localvar":"my","kind":13,"containerName":"add_branch","name":"$descendent","line":411},{"line":411,"containerName":"add_branch","kind":13,"name":"$common"},{"kind":12,"containerName":"add_branch","name":"each_Descendent","line":411},{"line":412,"kind":13,"containerName":"add_branch","name":"$node"},{"line":412,"name":"add_Descendent","containerName":"add_branch","kind":12},{"name":"$descendent","containerName":"add_branch","kind":13,"line":412},{"containerName":"add_branch","kind":13,"name":"$force","line":412},{"line":416,"containerName":"add_branch","kind":13,"name":"$self"},{"kind":12,"containerName":"add_branch","name":"set_root_node","line":416},{"line":416,"name":"$node","kind":13,"containerName":"add_branch"},{"line":416,"name":"$node","kind":13,"containerName":"add_branch"},{"name":"distance_to_root","containerName":"add_branch","kind":12,"line":416},{"kind":13,"containerName":"add_branch","name":"$common","line":419},{"name":"get_Descendents","kind":12,"containerName":"add_branch","line":419}],"detail":"($self,$node,$force)","definition":"sub","range":{"end":{"line":420,"character":9999},"start":{"character":0,"line":389}},"kind":12,"line":389,"signature":{"documentation":"1;\n# $Id: Tree.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from Bio::Tree::Tree by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Tree - An Organism Level Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon in combination with\n    # Bio::Tree::Tree instead\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n    my @leaves = $tree->get_leaves;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Taxonomic Nodes which make up a tree.\n\n=head1 EXAMPLES\n\n  use Bio::Species;\n  use Bio::Taxonomy::Tree;\n\n  my $human=Bio::Species->new();\n  my $chimp=Bio::Species->new();\n  my $bonobo=Bio::Species->new();\n\n  $human->classification(qw( sapiens Homo Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $chimp->classification(qw( troglodytes Pan Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $bonobo->classification(qw( paniscus Pan Hominidae\n                              Catarrhini Primates Eutheria\n                              Mammalia Euteleostomi Vertebrata \n                              Craniata Chordata\n                              Metazoa Eukaryota ));\n\n  # ranks passed to $taxonomy match ranks of species\n  my @ranks = ('superkingdom','kingdom','phylum','subphylum',\n               'no rank 1','no rank 2','class','no rank 3','order',\n               'suborder','family','genus','species');\n\n  my $taxonomy=Bio::Taxonomy->new(-ranks => \\@ranks,\n                                 -method => 'trust',\n                                 -order => -1);\n\n\n  my $tree1=Bio::Taxonomy::Tree->new();\n  my $tree2=Bio::Taxonomy::Tree->new();\n\n  $tree1->make_species_branch($human,$taxonomy);\n  $tree2->make_species_branch($chimp,$taxonomy);\n\n  my ($homo_sapiens)=$tree1->get_leaves;\n\n  $tree1->splice($tree2);\n\n  $tree1->add_species($bonobo,$taxonomy);\n\n  my @taxa;\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n  @taxa=();\n  $tree1->remove_branch($homo_sapiens);\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n=head1 FEEDBACK\n\nSee AUTHOR\n\n=head1 AUTHOR - Dan Kortschak\n\nEmail kortschak@rsbs.anu.edu.au\n\n=head1 CONTRIBUTORS\n\nMainly Jason Stajich\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Code begins...\n\n\npackage Bio::Taxonomy::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Taxonomy::Taxon;\n\n# Import rank information from Bio::Taxonomy.pm\nuse vars qw(@RANK %RANK);\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Tree->new();\n Function: Builds a new Bio::Taxonomy::Tree object \n Returns : Bio::Taxonomy::Tree\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Tree is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n  \n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n\n  my ($root)= $self->_rearrange([qw(ROOT)], @args);\n  if( $root ) { $self->set_root_node($root); }\n  return $self;\n}\n\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'height';\n\n   if ($order =~ m/^b|(breadth)$/oi) {\n      my $node = $self->get_root_node;\n      my @children = ($node);\n      for (@children) {\n\t   push @children, $_->each_Descendent($sortby);\n      }\n      return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my $node = $self->get_root_node;\n       my @children = ($node,$node->get_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Taxonomy::Taxon object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Taxonomy::Taxon\n Args    : Bio::Taxonomy::Taxon\n\n\n\nsub set_root_node{\n   my ($self,$value) = @_;\n   if( defined $value ) { \n      if( ! $value->isa('Bio::Taxonomy::Taxon') ) { \n\t   $self->warn(\"Trying to set the root node to $value which is not a Bio::Taxonomy::Taxon\");\n\t   return $self->get_root_node;\n      }\n      $self->{'_rootnode'} = $value;\n   }\n   return $self->get_root_node;\n}\n\n\n=head2 get_leaves\n\n Title   : get_leaves\n Usage   : my @nodes = $tree->get_leaves()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : \n\n\n\nsub get_leaves{\n   my ($self) = @_;\n   \n   my $node = $self->get_root_node;\n   my @leaves;\n   my @children = ($node);\n   for (@children) {\n      push @children, $_->each_Descendent();\n   }\n   for (@children) {\n      push @leaves, $_ if $_->is_Leaf;\n   }\n   return @leaves;\n}\n\n=head2 make_species_branch\n\n Title   : make_species_branch\n Usage   : @nodes = $tree->make_species_branch($species,$taxonomy)\n Function: Return list of Bio::Taxonomy::Taxon objects based on a Bio::Species object\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : Bio::Species and Bio::Taxonomy objects\n\n\n# I'm not happy that make_species_branch and make_branch are seperate routines\n# should be able to just make_branch and have it sort things out\n\nsub make_species_branch{\n   my ($self,$species,$taxonomy) = @_;\n   \n   if (! $species->isa('Bio::Species') ) {\n      $self->throw(\"Trying to classify $species which is not a Bio::Species object\");\n   }\n   if (! $taxonomy->isa('Bio::Taxonomy') ) {\n      $self->throw(\"Trying to classify with $taxonomy which is not a Bio::Taxonomy object\");\n   }\n\n   # this is done to make sure we aren't duplicating a path (let God sort them out)\n   if (defined $self->get_root_node) {\n      $self->get_root_node->remove_all_Descendents;\n   }\n\n   my @nodes;\n\n   # nb taxa in [i][0] and ranks in [i][1]\n   my @taxa=$taxonomy->classify($species);\n\n   for (my $i = 0; $i < @taxa; $i++) {\n      $nodes[$i]=Bio::Taxonomy::Taxon->new(-taxon => $taxa[$i][0],\n                                           -rank  => $taxa[$i][1]);\n   }\n\n   for (my $i = 0; $i < @taxa-1; $i++) {\n      $nodes[$i]->add_Descendent($nodes[$i+1]);\n   }\n\n   $self->set_root_node($nodes[0]);\n\n   return @nodes;\n}\n\n\n=head2 make_branch\n\n Title   : make_branch\n Usage   : $tree->make_branch($node)\n Function: Make a linear Bio::Taxonomy::Tree object from a leafish node\n Returns :\n Args    : Bio::Taxonomy::Taxon object\n\n\n\nsub make_branch{\n   my ($self,$node) = @_;\n\n   # this is done to make sure we aren't duplicating a path (let God sort them out)\n   # note that if you are using a linked set of node which include node \n   # already in the tree, this will break\n   $self->get_root_node->remove_all_Descendents;\n   \n   while (defined $node->ancestor) {\n      $self->set_root_node($node);\n      $node=$node->ancestor;\n   }\n}\n\n\n=head2 splice\n\n Title   : splice\n Usage   : @nodes = $tree->splice($tree)\n Function: Return a of Bio::Taxonomy::Tree object that is a fusion of two\n Returns : array of Bio::Taxonomy::Taxon added to tree\n Args    : Bio::Taxonomy::Tree object\n\n\n\nsub splice{\n   my ($self,$tree) = @_;\n\n   my @nodes;\n\n   my @newleaves = $tree->get_leaves;\n   foreach my $leaf (@newleaves) {\n      push @nodes,$self->add_branch($leaf);\n   }\n\n   return @nodes;\n}\n\n=head2 add_species\n\n Title   : add_species\n Usage   : @nodes = $tree->add_species($species,$taxonomy)\n Function: Return a of Bio::Taxonomy::Tree object with a new species added\n Returns : array of Bio::Taxonomy::Taxon added to tree\n Args    : Bio::Species object\n\n\n\nsub add_species{\n   my ($self,$species,$taxonomy) = @_;\n\n   my $branch=Bio::Taxonomy::Tree->new;\n   my @nodes=$branch->make_species_branch($species,$taxonomy);\n\n   my ($newleaf)=$branch->get_leaves;\n  \n   return $self->add_branch($newleaf);\n}\n\n=head2 add_branch\n\n Title   : add_branch\n Usage   : $tree->add_branch($node,boolean)\n Function: Return a of Bio::Taxonomy::Tree object with a new branch added\n Returns : array of Bio::Taxonomy::Taxon objects of the resulting tree\n Args    : Bio::Taxonomy::Taxon object\n           boolean flag to force overwrite of descendent\n             (see Bio::Node->add_Descendent)","parameters":[{"label":"$self"},{"label":"$node"},{"label":"$force"}],"label":"add_branch($self,$node,$force)"}},{"signature":{"label":"remove_branch($self,$node)","parameters":[{"label":"$self"},{"label":"$node"}],"documentation":"1;\n# $Id: Tree.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy::Tree\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Dan Kortschak but pilfered extensively from Bio::Tree::Tree by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy::Tree - An Organism Level Implementation of TreeI interface.\n\n=head1 SYNOPSIS\n\n    # NB: This module is deprecated. Use Bio::Taxon in combination with\n    # Bio::Tree::Tree instead\n\n    # like from a TreeIO\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -file => 'treefile.dnd');\n    my $tree = $treeio->next_tree;\n    my @nodes = $tree->get_nodes;\n    my $root = $tree->get_root_node;\n    my @leaves = $tree->get_leaves;\n\n\n=head1 DESCRIPTION\n\nThis object holds handles to Taxonomic Nodes which make up a tree.\n\n=head1 EXAMPLES\n\n  use Bio::Species;\n  use Bio::Taxonomy::Tree;\n\n  my $human=Bio::Species->new();\n  my $chimp=Bio::Species->new();\n  my $bonobo=Bio::Species->new();\n\n  $human->classification(qw( sapiens Homo Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $chimp->classification(qw( troglodytes Pan Hominidae\n                             Catarrhini Primates Eutheria\n                             Mammalia Euteleostomi Vertebrata \n                             Craniata Chordata\n                             Metazoa Eukaryota ));\n  $bonobo->classification(qw( paniscus Pan Hominidae\n                              Catarrhini Primates Eutheria\n                              Mammalia Euteleostomi Vertebrata \n                              Craniata Chordata\n                              Metazoa Eukaryota ));\n\n  # ranks passed to $taxonomy match ranks of species\n  my @ranks = ('superkingdom','kingdom','phylum','subphylum',\n               'no rank 1','no rank 2','class','no rank 3','order',\n               'suborder','family','genus','species');\n\n  my $taxonomy=Bio::Taxonomy->new(-ranks => \\@ranks,\n                                 -method => 'trust',\n                                 -order => -1);\n\n\n  my $tree1=Bio::Taxonomy::Tree->new();\n  my $tree2=Bio::Taxonomy::Tree->new();\n\n  $tree1->make_species_branch($human,$taxonomy);\n  $tree2->make_species_branch($chimp,$taxonomy);\n\n  my ($homo_sapiens)=$tree1->get_leaves;\n\n  $tree1->splice($tree2);\n\n  $tree1->add_species($bonobo,$taxonomy);\n\n  my @taxa;\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n  @taxa=();\n  $tree1->remove_branch($homo_sapiens);\n  foreach my $leaf ($tree1->get_leaves) {\n     push @taxa,$leaf->taxon;\n  }\n  print join(\", \",@taxa).\"\\n\";\n\n=head1 FEEDBACK\n\nSee AUTHOR\n\n=head1 AUTHOR - Dan Kortschak\n\nEmail kortschak@rsbs.anu.edu.au\n\n=head1 CONTRIBUTORS\n\nMainly Jason Stajich\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Code begins...\n\n\npackage Bio::Taxonomy::Tree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Taxonomy::Taxon;\n\n# Import rank information from Bio::Taxonomy.pm\nuse vars qw(@RANK %RANK);\n\nuse base qw(Bio::Root::Root Bio::Tree::TreeI Bio::Tree::TreeFunctionsI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Tree->new();\n Function: Builds a new Bio::Taxonomy::Tree object \n Returns : Bio::Taxonomy::Tree\n Args    : \n\n\n\nsub new {\n  my($class,@args) = @_;\n  \n  my $self = $class->SUPER::new(@args);\n  $self->warn(\"Bio::Taxonomy::Tree is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n  \n  $self->{'_rootnode'} = undef;\n  $self->{'_maxbranchlen'} = 0;\n\n  my ($root)= $self->_rearrange([qw(ROOT)], @args);\n  if( $root ) { $self->set_root_node($root); }\n  return $self;\n}\n\n\n=head2 get_nodes\n\n Title   : get_nodes\n Usage   : my @nodes = $tree->get_nodes()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : (named values) hash with one value \n           order => 'b|breadth' first order or 'd|depth' first order\n\n\nsub get_nodes{\n   my ($self, @args) = @_;\n   \n   my ($order, $sortby) = $self->_rearrange([qw(ORDER SORTBY)],@args);\n   $order ||= 'depth';\n   $sortby ||= 'height';\n\n   if ($order =~ m/^b|(breadth)$/oi) {\n      my $node = $self->get_root_node;\n      my @children = ($node);\n      for (@children) {\n\t   push @children, $_->each_Descendent($sortby);\n      }\n      return @children;\n   }\n\n   if ($order =~ m/^d|(depth)$/oi) {\n       # this is depth-first search I believe\n       my $node = $self->get_root_node;\n       my @children = ($node,$node->get_Descendents($sortby));\n       return @children;\n   }\n}\n\n=head2 get_root_node\n\n Title   : get_root_node\n Usage   : my $node = $tree->get_root_node();\n Function: Get the Top Node in the tree, in this implementation\n           Trees only have one top node.\n Returns : Bio::Taxonomy::Taxon object\n Args    : none\n\n\n\nsub get_root_node{\n   my ($self) = @_;\n   return $self->{'_rootnode'};\n}\n\n=head2 set_root_node\n\n Title   : set_root_node\n Usage   : $tree->set_root_node($node)\n Function: Set the Root Node for the Tree\n Returns : Bio::Taxonomy::Taxon\n Args    : Bio::Taxonomy::Taxon\n\n\n\nsub set_root_node{\n   my ($self,$value) = @_;\n   if( defined $value ) { \n      if( ! $value->isa('Bio::Taxonomy::Taxon') ) { \n\t   $self->warn(\"Trying to set the root node to $value which is not a Bio::Taxonomy::Taxon\");\n\t   return $self->get_root_node;\n      }\n      $self->{'_rootnode'} = $value;\n   }\n   return $self->get_root_node;\n}\n\n\n=head2 get_leaves\n\n Title   : get_leaves\n Usage   : my @nodes = $tree->get_leaves()\n Function: Return list of Bio::Taxonomy::Taxon objects\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : \n\n\n\nsub get_leaves{\n   my ($self) = @_;\n   \n   my $node = $self->get_root_node;\n   my @leaves;\n   my @children = ($node);\n   for (@children) {\n      push @children, $_->each_Descendent();\n   }\n   for (@children) {\n      push @leaves, $_ if $_->is_Leaf;\n   }\n   return @leaves;\n}\n\n=head2 make_species_branch\n\n Title   : make_species_branch\n Usage   : @nodes = $tree->make_species_branch($species,$taxonomy)\n Function: Return list of Bio::Taxonomy::Taxon objects based on a Bio::Species object\n Returns : array of Bio::Taxonomy::Taxon objects\n Args    : Bio::Species and Bio::Taxonomy objects\n\n\n# I'm not happy that make_species_branch and make_branch are seperate routines\n# should be able to just make_branch and have it sort things out\n\nsub make_species_branch{\n   my ($self,$species,$taxonomy) = @_;\n   \n   if (! $species->isa('Bio::Species') ) {\n      $self->throw(\"Trying to classify $species which is not a Bio::Species object\");\n   }\n   if (! $taxonomy->isa('Bio::Taxonomy') ) {\n      $self->throw(\"Trying to classify with $taxonomy which is not a Bio::Taxonomy object\");\n   }\n\n   # this is done to make sure we aren't duplicating a path (let God sort them out)\n   if (defined $self->get_root_node) {\n      $self->get_root_node->remove_all_Descendents;\n   }\n\n   my @nodes;\n\n   # nb taxa in [i][0] and ranks in [i][1]\n   my @taxa=$taxonomy->classify($species);\n\n   for (my $i = 0; $i < @taxa; $i++) {\n      $nodes[$i]=Bio::Taxonomy::Taxon->new(-taxon => $taxa[$i][0],\n                                           -rank  => $taxa[$i][1]);\n   }\n\n   for (my $i = 0; $i < @taxa-1; $i++) {\n      $nodes[$i]->add_Descendent($nodes[$i+1]);\n   }\n\n   $self->set_root_node($nodes[0]);\n\n   return @nodes;\n}\n\n\n=head2 make_branch\n\n Title   : make_branch\n Usage   : $tree->make_branch($node)\n Function: Make a linear Bio::Taxonomy::Tree object from a leafish node\n Returns :\n Args    : Bio::Taxonomy::Taxon object\n\n\n\nsub make_branch{\n   my ($self,$node) = @_;\n\n   # this is done to make sure we aren't duplicating a path (let God sort them out)\n   # note that if you are using a linked set of node which include node \n   # already in the tree, this will break\n   $self->get_root_node->remove_all_Descendents;\n   \n   while (defined $node->ancestor) {\n      $self->set_root_node($node);\n      $node=$node->ancestor;\n   }\n}\n\n\n=head2 splice\n\n Title   : splice\n Usage   : @nodes = $tree->splice($tree)\n Function: Return a of Bio::Taxonomy::Tree object that is a fusion of two\n Returns : array of Bio::Taxonomy::Taxon added to tree\n Args    : Bio::Taxonomy::Tree object\n\n\n\nsub splice{\n   my ($self,$tree) = @_;\n\n   my @nodes;\n\n   my @newleaves = $tree->get_leaves;\n   foreach my $leaf (@newleaves) {\n      push @nodes,$self->add_branch($leaf);\n   }\n\n   return @nodes;\n}\n\n=head2 add_species\n\n Title   : add_species\n Usage   : @nodes = $tree->add_species($species,$taxonomy)\n Function: Return a of Bio::Taxonomy::Tree object with a new species added\n Returns : array of Bio::Taxonomy::Taxon added to tree\n Args    : Bio::Species object\n\n\n\nsub add_species{\n   my ($self,$species,$taxonomy) = @_;\n\n   my $branch=Bio::Taxonomy::Tree->new;\n   my @nodes=$branch->make_species_branch($species,$taxonomy);\n\n   my ($newleaf)=$branch->get_leaves;\n  \n   return $self->add_branch($newleaf);\n}\n\n=head2 add_branch\n\n Title   : add_branch\n Usage   : $tree->add_branch($node,boolean)\n Function: Return a of Bio::Taxonomy::Tree object with a new branch added\n Returns : array of Bio::Taxonomy::Taxon objects of the resulting tree\n Args    : Bio::Taxonomy::Taxon object\n           boolean flag to force overwrite of descendent\n             (see Bio::Node->add_Descendent)\n\n\n\nsub add_branch {\n   my ($self,$node,$force) = @_;\n\n   my $best_node_level=0;\n   my ($best_node,@nodes,$common);\n\n   my @leaves=$self->get_leaves;\n   foreach my $leaf (@leaves) {\n      $common=$node->recent_common_ancestor($leaf); # the root of the part to add\n      if (defined $common && ($common->distance_to_root > $best_node_level)) {\n         $best_node_level = $common->distance_to_root;\n         $best_node = $common;\n      }\n   }\n\n   return unless defined $best_node;\n\n   push @nodes,($self->get_root_node,$self->get_root_node->get_Descendents);\n   foreach my $node (@nodes) {\n      if ((defined $best_node->id && $best_node->id == $node->id) ||\n         ($best_node->rank eq $node->rank && $best_node->taxon eq $node->taxon) &&\n         ($best_node->rank ne 'no rank')) {\n         foreach my $descendent ($common->each_Descendent) {\n            $node->add_Descendent($descendent,$force);\n         }\n      }\n\n      $self->set_root_node($node) if $node->distance_to_root==0;\n   }\n\n   return ($common->get_Descendents);\n}\n\n=head2 remove_branch\n\n Title   : remove_branch\n Usage   : $tree->remove_branch($node)\n Function: remove a branch up to the next multifurcation\n Returns :\n Args    : Bio::Taxonomy::Taxon object"},"line":433,"kind":12,"range":{"end":{"character":9999,"line":447},"start":{"character":0,"line":433}},"definition":"sub","detail":"($self,$node)","children":[{"definition":"my","line":434,"localvar":"my","kind":13,"containerName":"remove_branch","name":"$self"},{"kind":13,"containerName":"remove_branch","name":"$node","line":434},{"line":438,"kind":13,"containerName":"remove_branch","name":"$node"},{"name":"ancestor","kind":12,"containerName":"remove_branch","line":438},{"containerName":"remove_branch","kind":13,"name":"$node","line":439},{"name":"ancestor","containerName":"remove_branch","kind":12,"line":439},{"containerName":"remove_branch","kind":12,"name":"each_Descendent","line":439},{"line":440,"kind":13,"containerName":"remove_branch","name":"$node"},{"line":440,"name":"$node","containerName":"remove_branch","kind":13},{"containerName":"remove_branch","kind":12,"name":"ancestor","line":440},{"kind":13,"containerName":"remove_branch","name":"$node","line":442},{"line":442,"containerName":"remove_branch","kind":12,"name":"remove_all_Descendents"},{"line":446,"name":"$node","kind":13,"containerName":"remove_branch"},{"line":446,"name":"ancestor","kind":12,"containerName":"remove_branch"},{"line":446,"name":"remove_Descendent","kind":12,"containerName":"remove_branch"},{"line":446,"containerName":"remove_branch","kind":13,"name":"$node"}],"name":"remove_branch","containerName":"main::"}],"version":5}