{"version":5,"vars":[{"line":167,"name":"base","kind":2,"containerName":""},{"children":[{"line":184,"kind":13,"localvar":"my","containerName":"new","name":"$class","definition":"my"},{"line":184,"containerName":"new","kind":13,"name":"@args"},{"definition":"my","name":"$self","localvar":"my","containerName":"new","kind":13,"line":186},{"line":186,"kind":13,"containerName":"new","name":"$class"},{"line":186,"name":"@args","containerName":"new","kind":13},{"line":187,"name":"$self","containerName":"new","kind":13},{"name":"warn","containerName":"new","kind":12,"line":187},{"kind":13,"containerName":"new","name":"$self","line":189},{"line":190,"containerName":"new","kind":13,"name":"$self"},{"containerName":"new","kind":13,"name":"$self","line":191},{"containerName":"new","kind":13,"name":"$self","line":192},{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$method","line":193},{"line":193,"name":"$ranks","kind":13,"containerName":"new"},{"line":193,"kind":13,"containerName":"new","name":"$order"},{"line":193,"kind":13,"containerName":"new","name":"$self"},{"name":"_rearrange","containerName":"new","kind":12,"line":193},{"kind":13,"containerName":"new","name":"@args","line":193},{"kind":13,"containerName":"new","name":"$method","line":195},{"line":196,"containerName":"new","kind":13,"name":"$self"},{"line":196,"name":"method","containerName":"new","kind":12},{"line":196,"name":"$method","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$ranks","line":199},{"containerName":"new","kind":13,"name":"$ranks","line":200},{"line":201,"name":"$self","kind":13,"containerName":"new"},{"line":201,"name":"ranks","kind":12,"containerName":"new"},{"name":"$ranks","kind":13,"containerName":"new","line":201},{"line":209,"containerName":"new","kind":13,"name":"$self"},{"line":209,"name":"ranks","kind":12,"containerName":"new"},{"line":221,"containerName":"new","kind":13,"name":"$self"}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)","line":183,"kind":12,"range":{"end":{"character":9999,"line":222},"start":{"character":0,"line":183}},"signature":{"documentation":"1;\n# $Id: Taxonomy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Juguang Xiao\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy - representing Taxonomy.\n\n=head1 SYNOPSIS\n\n  # NB: This module is deprecated. Use Bio::Taxon in combination with\n  # Bio::Tree::Tree methods instead.\n\n  use Bio::Taxonomy;\n\n  # CREATION: You can either create an instance by assigning it,\n  # or fetch it through factory.\n\n  # Create the nodes first. See Bio::Taxonomy::Node for details.\n  my $node_species_sapiens = Bio::Taxonomy::Node->new(\n      -object_id => 9606, # or -ncbi_taxid. Requird tag\n      -names => {\n          'scientific' => ['sapiens'],\n          'common_name' => ['human']\n      },\n      -rank => 'species'  # Required tag\n  );\n  my $node_genus_Homo = Bio::Taxonomy::Node->new(\n      -object_id => 9605,\n      -names => { 'scientific' => ['Homo'] },\n      -rank => 'genus'\n  );\n  my $node_class_Mammalia = Bio::Taxonomy::Node->new(\n      -object_id => 40674,\n      -names => {\n          'scientific' => ['Mammalia'],\n          'common' => ['mammals']\n      },\n      -rank => 'class'\n  );\n  my $taxonomy = Bio::Taxonomy->new;\n  $taxonomy->add_node($node_class_Mammalia);\n  $taxonomy->add_node($node_species_sapiens);\n  $taxonomy->add_node($node_genus_Homo);\n\n  # OR you can fetch it through a factory implementing\n  # Bio::Taxonomy::FactoryI\n  my $factory;\n\n  my $taxonomy = $factory->fetch_by_ncbi_taxid(40674);\n\n  # USAGE\n\n  # In this case, binomial returns a defined value.\n  my $binomial = $taxonomy->binomial;\n\n  # 'common_names' refers to the lowest-rank node's common names, in\n  # array.\n  my @common_names = $taxonomy->common_names;\n\n  # 'get_node', will return undef if the rank is no defined in\n  # taxonomy object.  It will throw error if the rank string is not\n  # defined, say 'species lah'.\n  my $node = $taxonomy->get_node('class');\n  my @nodes = $taxonomy->get_all_nodes;\n\n  # Also, you can search for parent and children nodes, if taxonomy\n  # comes with factory.\n\n  my $parent_taxonomy = $taxonomy->get_parent\n\n=head1 DESCRIPTION\n\nBio::Taxonomy object represents any rank-level in taxonomy system,\nrather than Bio::Species which is able to represent only\nspecies-level.\n\nThere are two ways to create Taxonomy object, e.g.\n1) instantiate an object and assign all nodes on your own code; and\n2) fetch an object by factory.\n\n=head2 Creation by instantiation\n\nThe abstraction of Taxonomy is actually a hash in data structure\nterm. The keys of the hash are the rank names, such as 'genus' and\n'species', and the values are the instances of Bio::Taxonomy::Node.\n\n=head2 Creation by Factory fetching\n\nNCBI Taxonomy system is well accepted as the standard. The Taxonomy\nFactories in bioperl access this system, through HTTP to NCBI Entrez,\ndump file, and advanced biosql database.\n\nBio::Taxonomy::FactoryI defines all methods that all implementations\nmust obey.\n\n$factory-E<gt>fetch is a general method to fetch Taxonomy by either\nNCBI taxid or any types of names.\n\n$factory-E<gt>fetch_parent($taxonomy), returns a Taxonomy that is\none-step higher rank of the taxonomy specified as argument.\n\n$factory-E<gt>fetch_children($taxonomy), reports an array of Taxonomy\nthose are one-step lower rank of the taxonomy specified as the\nargument.\n\n=head2 Usage of Taxonomy object\n\n##\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 CONTACT\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# code begins...\n\n\npackage Bio::Taxonomy;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy->new();\n Function: Builds a new Bio::Taxonomy object\n Returns : Bio::Taxonomy\n Args    : -method  -> method used to decide classification\n                       (none|trust|lookup)\n           -ranks   -> what ranks are there","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"}},{"line":186,"kind":12,"containerName":"new","name":"SUPER"},{"line":192,"name":"_hierarchy","kind":12},{"signature":{"label":"method($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Taxonomy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Juguang Xiao\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy - representing Taxonomy.\n\n=head1 SYNOPSIS\n\n  # NB: This module is deprecated. Use Bio::Taxon in combination with\n  # Bio::Tree::Tree methods instead.\n\n  use Bio::Taxonomy;\n\n  # CREATION: You can either create an instance by assigning it,\n  # or fetch it through factory.\n\n  # Create the nodes first. See Bio::Taxonomy::Node for details.\n  my $node_species_sapiens = Bio::Taxonomy::Node->new(\n      -object_id => 9606, # or -ncbi_taxid. Requird tag\n      -names => {\n          'scientific' => ['sapiens'],\n          'common_name' => ['human']\n      },\n      -rank => 'species'  # Required tag\n  );\n  my $node_genus_Homo = Bio::Taxonomy::Node->new(\n      -object_id => 9605,\n      -names => { 'scientific' => ['Homo'] },\n      -rank => 'genus'\n  );\n  my $node_class_Mammalia = Bio::Taxonomy::Node->new(\n      -object_id => 40674,\n      -names => {\n          'scientific' => ['Mammalia'],\n          'common' => ['mammals']\n      },\n      -rank => 'class'\n  );\n  my $taxonomy = Bio::Taxonomy->new;\n  $taxonomy->add_node($node_class_Mammalia);\n  $taxonomy->add_node($node_species_sapiens);\n  $taxonomy->add_node($node_genus_Homo);\n\n  # OR you can fetch it through a factory implementing\n  # Bio::Taxonomy::FactoryI\n  my $factory;\n\n  my $taxonomy = $factory->fetch_by_ncbi_taxid(40674);\n\n  # USAGE\n\n  # In this case, binomial returns a defined value.\n  my $binomial = $taxonomy->binomial;\n\n  # 'common_names' refers to the lowest-rank node's common names, in\n  # array.\n  my @common_names = $taxonomy->common_names;\n\n  # 'get_node', will return undef if the rank is no defined in\n  # taxonomy object.  It will throw error if the rank string is not\n  # defined, say 'species lah'.\n  my $node = $taxonomy->get_node('class');\n  my @nodes = $taxonomy->get_all_nodes;\n\n  # Also, you can search for parent and children nodes, if taxonomy\n  # comes with factory.\n\n  my $parent_taxonomy = $taxonomy->get_parent\n\n=head1 DESCRIPTION\n\nBio::Taxonomy object represents any rank-level in taxonomy system,\nrather than Bio::Species which is able to represent only\nspecies-level.\n\nThere are two ways to create Taxonomy object, e.g.\n1) instantiate an object and assign all nodes on your own code; and\n2) fetch an object by factory.\n\n=head2 Creation by instantiation\n\nThe abstraction of Taxonomy is actually a hash in data structure\nterm. The keys of the hash are the rank names, such as 'genus' and\n'species', and the values are the instances of Bio::Taxonomy::Node.\n\n=head2 Creation by Factory fetching\n\nNCBI Taxonomy system is well accepted as the standard. The Taxonomy\nFactories in bioperl access this system, through HTTP to NCBI Entrez,\ndump file, and advanced biosql database.\n\nBio::Taxonomy::FactoryI defines all methods that all implementations\nmust obey.\n\n$factory-E<gt>fetch is a general method to fetch Taxonomy by either\nNCBI taxid or any types of names.\n\n$factory-E<gt>fetch_parent($taxonomy), returns a Taxonomy that is\none-step higher rank of the taxonomy specified as argument.\n\n$factory-E<gt>fetch_children($taxonomy), reports an array of Taxonomy\nthose are one-step lower rank of the taxonomy specified as the\nargument.\n\n=head2 Usage of Taxonomy object\n\n##\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 CONTACT\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# code begins...\n\n\npackage Bio::Taxonomy;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy->new();\n Function: Builds a new Bio::Taxonomy object\n Returns : Bio::Taxonomy\n Args    : -method  -> method used to decide classification\n                       (none|trust|lookup)\n           -ranks   -> what ranks are there\n\n\n\nsub new {\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n   $self->warn(\"Bio::Taxonomy is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n\n   $self->{'_method'}='none';\n   $self->{'_ranks'}=[];\n   $self->{'_rank_hash'}={};\n    $self->{_hierarchy} = {}; # used to store the nodes, with ranks as keys.\n   my ($method,$ranks,$order) = $self->_rearrange([qw(METHOD RANKS ORDER)], @args);\n\n   if ($method) {\n      $self->method($method);\n   }\n\n   if (defined $ranks &&\n      (ref($ranks) eq \"ARRAY\") ) {\n      $self->ranks(@$ranks);\n   } else {\n      # default ranks\n      # I think these are in the right order, but not sure:\n      # some parvorder|suborder and varietas|subspecies seem\n      # to be at the same level - any taxonomists?\n      # I don't expect that these will actually be used except as a way\n      # to find what ranks there are in taxonomic use\n      $self->ranks(('root',\n        'superkingdom', 'kingdom',\n        'superphylum', 'phylum', 'subphylum',\n        'superclass', 'class', 'subclass', 'infraclass',\n        'superorder', 'order', 'suborder', 'parvorder', 'infraorder',\n        'superfamily', 'family', 'subfamily',\n        'tribe', 'subtribe',\n        'genus', 'subgenus',\n        'species group', 'species subgroup', 'species', 'subspecies',\n        'varietas', 'forma', 'no rank'));\n   }\n\n   return $self;\n}\n\n\n=head2 method\n\n Title   : method\n Usage   : $obj = taxonomy->method($method);\n Function: set or return the method used to decide classification\n Returns : $obj\n Args    : $obj"},"kind":12,"range":{"start":{"line":236,"character":0},"end":{"character":9999,"line":242}},"line":236,"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"method","children":[{"line":237,"localvar":"my","containerName":"method","kind":13,"name":"$self","definition":"my"},{"name":"$value","containerName":"method","kind":13,"line":237},{"name":"$value","containerName":"method","kind":13,"line":238},{"kind":13,"containerName":"method","name":"$value","line":238},{"kind":13,"containerName":"method","name":"$self","line":239},{"name":"$value","kind":13,"containerName":"method","line":239},{"line":241,"name":"$self","containerName":"method","kind":13}]},{"definition":"sub","detail":"($self,$value)","children":[{"line":257,"name":"$self","localvar":"my","containerName":"classify","kind":13,"definition":"my"},{"name":"$value","kind":13,"containerName":"classify","line":257},{"line":258,"containerName":"classify","localvar":"my","kind":13,"name":"@ranks","definition":"my"},{"name":"$value","kind":13,"containerName":"classify","line":260},{"line":260,"name":"isa","kind":12,"containerName":"classify"},{"name":"$self","containerName":"classify","kind":13,"line":261},{"line":261,"containerName":"classify","kind":12,"name":"throw"},{"definition":"my","line":264,"localvar":"my","kind":13,"containerName":"classify","name":"@classes"},{"line":264,"containerName":"classify","kind":13,"name":"$value"},{"containerName":"classify","kind":12,"name":"classification","line":264},{"line":266,"name":"$self","kind":13,"containerName":"classify"},{"name":"method","containerName":"classify","kind":12,"line":266},{"containerName":"classify","localvar":"my","kind":13,"name":"$i","line":267,"definition":"my"},{"name":"$i","kind":13,"containerName":"classify","line":267},{"name":"@classes","containerName":"classify","kind":13,"line":267},{"kind":13,"containerName":"classify","name":"$i","line":267},{"containerName":"classify","kind":13,"name":"$ranks","line":268},{"line":268,"name":"$i","kind":13,"containerName":"classify"},{"kind":13,"containerName":"classify","name":"$ranks","line":268},{"line":268,"containerName":"classify","kind":13,"name":"$i"},{"line":268,"kind":13,"containerName":"classify","name":"$classes"},{"line":268,"name":"$i","kind":13,"containerName":"classify"},{"line":270,"containerName":"classify","kind":13,"name":"@ranks"},{"line":270,"kind":13,"containerName":"classify","name":"$classes"},{"name":"@ranks","kind":13,"containerName":"classify","line":271},{"line":271,"kind":13,"containerName":"classify","name":"$value"},{"name":"binomial","kind":12,"containerName":"classify","line":271},{"containerName":"classify","kind":13,"name":"$self","line":272},{"line":272,"containerName":"classify","kind":12,"name":"method"},{"containerName":"classify","kind":13,"name":"@classes","line":273},{"name":"$self","containerName":"classify","kind":13,"line":273},{"line":273,"name":"ranks","containerName":"classify","kind":12},{"line":274,"name":"$i","kind":13,"localvar":"my","containerName":"classify","definition":"my"},{"kind":13,"containerName":"classify","name":"$i","line":274},{"name":"@classes","containerName":"classify","kind":13,"line":274},{"line":274,"name":"$i","containerName":"classify","kind":13},{"name":"$self","kind":13,"containerName":"classify","line":275},{"kind":12,"containerName":"classify","name":"rank_of_number","line":275},{"name":"$i","containerName":"classify","kind":13,"line":275},{"line":276,"kind":13,"containerName":"classify","name":"@ranks"},{"line":276,"name":"$value","containerName":"classify","kind":13},{"containerName":"classify","kind":12,"name":"binomial","line":276},{"line":276,"kind":13,"containerName":"classify","name":"$self"},{"line":276,"name":"rank_of_number","containerName":"classify","kind":12},{"name":"$i","containerName":"classify","kind":13,"line":276},{"name":"@ranks","kind":13,"containerName":"classify","line":278},{"line":278,"containerName":"classify","kind":13,"name":"$classes"},{"line":278,"kind":13,"containerName":"classify","name":"$i"},{"line":278,"name":"$self","containerName":"classify","kind":13},{"line":278,"containerName":"classify","kind":12,"name":"rank_of_number"},{"containerName":"classify","kind":13,"name":"$i","line":278},{"line":282,"kind":13,"containerName":"classify","name":"$self"},{"kind":12,"containerName":"classify","name":"throw","line":282},{"containerName":"classify","kind":13,"name":"$self","line":284},{"line":284,"containerName":"classify","kind":12,"name":"method"},{"containerName":"classify","kind":13,"name":"$self","line":290},{"line":290,"name":"throw_not_implemented","containerName":"classify","kind":12},{"name":"@ranks","containerName":"classify","kind":13,"line":293}],"containerName":"main::","name":"classify","signature":{"documentation":"1;\n# $Id: Taxonomy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Juguang Xiao\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy - representing Taxonomy.\n\n=head1 SYNOPSIS\n\n  # NB: This module is deprecated. Use Bio::Taxon in combination with\n  # Bio::Tree::Tree methods instead.\n\n  use Bio::Taxonomy;\n\n  # CREATION: You can either create an instance by assigning it,\n  # or fetch it through factory.\n\n  # Create the nodes first. See Bio::Taxonomy::Node for details.\n  my $node_species_sapiens = Bio::Taxonomy::Node->new(\n      -object_id => 9606, # or -ncbi_taxid. Requird tag\n      -names => {\n          'scientific' => ['sapiens'],\n          'common_name' => ['human']\n      },\n      -rank => 'species'  # Required tag\n  );\n  my $node_genus_Homo = Bio::Taxonomy::Node->new(\n      -object_id => 9605,\n      -names => { 'scientific' => ['Homo'] },\n      -rank => 'genus'\n  );\n  my $node_class_Mammalia = Bio::Taxonomy::Node->new(\n      -object_id => 40674,\n      -names => {\n          'scientific' => ['Mammalia'],\n          'common' => ['mammals']\n      },\n      -rank => 'class'\n  );\n  my $taxonomy = Bio::Taxonomy->new;\n  $taxonomy->add_node($node_class_Mammalia);\n  $taxonomy->add_node($node_species_sapiens);\n  $taxonomy->add_node($node_genus_Homo);\n\n  # OR you can fetch it through a factory implementing\n  # Bio::Taxonomy::FactoryI\n  my $factory;\n\n  my $taxonomy = $factory->fetch_by_ncbi_taxid(40674);\n\n  # USAGE\n\n  # In this case, binomial returns a defined value.\n  my $binomial = $taxonomy->binomial;\n\n  # 'common_names' refers to the lowest-rank node's common names, in\n  # array.\n  my @common_names = $taxonomy->common_names;\n\n  # 'get_node', will return undef if the rank is no defined in\n  # taxonomy object.  It will throw error if the rank string is not\n  # defined, say 'species lah'.\n  my $node = $taxonomy->get_node('class');\n  my @nodes = $taxonomy->get_all_nodes;\n\n  # Also, you can search for parent and children nodes, if taxonomy\n  # comes with factory.\n\n  my $parent_taxonomy = $taxonomy->get_parent\n\n=head1 DESCRIPTION\n\nBio::Taxonomy object represents any rank-level in taxonomy system,\nrather than Bio::Species which is able to represent only\nspecies-level.\n\nThere are two ways to create Taxonomy object, e.g.\n1) instantiate an object and assign all nodes on your own code; and\n2) fetch an object by factory.\n\n=head2 Creation by instantiation\n\nThe abstraction of Taxonomy is actually a hash in data structure\nterm. The keys of the hash are the rank names, such as 'genus' and\n'species', and the values are the instances of Bio::Taxonomy::Node.\n\n=head2 Creation by Factory fetching\n\nNCBI Taxonomy system is well accepted as the standard. The Taxonomy\nFactories in bioperl access this system, through HTTP to NCBI Entrez,\ndump file, and advanced biosql database.\n\nBio::Taxonomy::FactoryI defines all methods that all implementations\nmust obey.\n\n$factory-E<gt>fetch is a general method to fetch Taxonomy by either\nNCBI taxid or any types of names.\n\n$factory-E<gt>fetch_parent($taxonomy), returns a Taxonomy that is\none-step higher rank of the taxonomy specified as argument.\n\n$factory-E<gt>fetch_children($taxonomy), reports an array of Taxonomy\nthose are one-step lower rank of the taxonomy specified as the\nargument.\n\n=head2 Usage of Taxonomy object\n\n##\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 CONTACT\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# code begins...\n\n\npackage Bio::Taxonomy;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy->new();\n Function: Builds a new Bio::Taxonomy object\n Returns : Bio::Taxonomy\n Args    : -method  -> method used to decide classification\n                       (none|trust|lookup)\n           -ranks   -> what ranks are there\n\n\n\nsub new {\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n   $self->warn(\"Bio::Taxonomy is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n\n   $self->{'_method'}='none';\n   $self->{'_ranks'}=[];\n   $self->{'_rank_hash'}={};\n    $self->{_hierarchy} = {}; # used to store the nodes, with ranks as keys.\n   my ($method,$ranks,$order) = $self->_rearrange([qw(METHOD RANKS ORDER)], @args);\n\n   if ($method) {\n      $self->method($method);\n   }\n\n   if (defined $ranks &&\n      (ref($ranks) eq \"ARRAY\") ) {\n      $self->ranks(@$ranks);\n   } else {\n      # default ranks\n      # I think these are in the right order, but not sure:\n      # some parvorder|suborder and varietas|subspecies seem\n      # to be at the same level - any taxonomists?\n      # I don't expect that these will actually be used except as a way\n      # to find what ranks there are in taxonomic use\n      $self->ranks(('root',\n        'superkingdom', 'kingdom',\n        'superphylum', 'phylum', 'subphylum',\n        'superclass', 'class', 'subclass', 'infraclass',\n        'superorder', 'order', 'suborder', 'parvorder', 'infraorder',\n        'superfamily', 'family', 'subfamily',\n        'tribe', 'subtribe',\n        'genus', 'subgenus',\n        'species group', 'species subgroup', 'species', 'subspecies',\n        'varietas', 'forma', 'no rank'));\n   }\n\n   return $self;\n}\n\n\n=head2 method\n\n Title   : method\n Usage   : $obj = taxonomy->method($method);\n Function: set or return the method used to decide classification\n Returns : $obj\n Args    : $obj\n\n\n\nsub method {\n   my ($self,$value) = @_;\n   if (defined $value && $value=~/none|trust|lookup/) {\n       $self->{'_method'} = $value;\n   }\n   return $self->{'_method'};\n}\n\n\n=head2 classify\n\n Title   : classify\n Usage   : @obj[][0-1] = taxonomy->classify($species);\n Function: return a ranked classification\n Returns : @obj of taxa and ranks as word pairs separated by \"@\"\n Args    : Bio::Species object","parameters":[{"label":"$self"},{"label":"$value"}],"label":"classify($self,$value)"},"line":256,"kind":12,"range":{"start":{"character":0,"line":256},"end":{"line":294,"character":9999}}},{"definition":"sub","detail":"($self,$value)","children":[{"line":309,"kind":13,"localvar":"my","containerName":"level_of","name":"$self","definition":"my"},{"line":309,"name":"$value","containerName":"level_of","kind":13},{"name":"$self","containerName":"level_of","kind":13,"line":311},{"line":311,"name":"$value","kind":13,"containerName":"level_of"}],"name":"level_of","containerName":"main::","signature":{"label":"level_of($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Taxonomy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Juguang Xiao\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy - representing Taxonomy.\n\n=head1 SYNOPSIS\n\n  # NB: This module is deprecated. Use Bio::Taxon in combination with\n  # Bio::Tree::Tree methods instead.\n\n  use Bio::Taxonomy;\n\n  # CREATION: You can either create an instance by assigning it,\n  # or fetch it through factory.\n\n  # Create the nodes first. See Bio::Taxonomy::Node for details.\n  my $node_species_sapiens = Bio::Taxonomy::Node->new(\n      -object_id => 9606, # or -ncbi_taxid. Requird tag\n      -names => {\n          'scientific' => ['sapiens'],\n          'common_name' => ['human']\n      },\n      -rank => 'species'  # Required tag\n  );\n  my $node_genus_Homo = Bio::Taxonomy::Node->new(\n      -object_id => 9605,\n      -names => { 'scientific' => ['Homo'] },\n      -rank => 'genus'\n  );\n  my $node_class_Mammalia = Bio::Taxonomy::Node->new(\n      -object_id => 40674,\n      -names => {\n          'scientific' => ['Mammalia'],\n          'common' => ['mammals']\n      },\n      -rank => 'class'\n  );\n  my $taxonomy = Bio::Taxonomy->new;\n  $taxonomy->add_node($node_class_Mammalia);\n  $taxonomy->add_node($node_species_sapiens);\n  $taxonomy->add_node($node_genus_Homo);\n\n  # OR you can fetch it through a factory implementing\n  # Bio::Taxonomy::FactoryI\n  my $factory;\n\n  my $taxonomy = $factory->fetch_by_ncbi_taxid(40674);\n\n  # USAGE\n\n  # In this case, binomial returns a defined value.\n  my $binomial = $taxonomy->binomial;\n\n  # 'common_names' refers to the lowest-rank node's common names, in\n  # array.\n  my @common_names = $taxonomy->common_names;\n\n  # 'get_node', will return undef if the rank is no defined in\n  # taxonomy object.  It will throw error if the rank string is not\n  # defined, say 'species lah'.\n  my $node = $taxonomy->get_node('class');\n  my @nodes = $taxonomy->get_all_nodes;\n\n  # Also, you can search for parent and children nodes, if taxonomy\n  # comes with factory.\n\n  my $parent_taxonomy = $taxonomy->get_parent\n\n=head1 DESCRIPTION\n\nBio::Taxonomy object represents any rank-level in taxonomy system,\nrather than Bio::Species which is able to represent only\nspecies-level.\n\nThere are two ways to create Taxonomy object, e.g.\n1) instantiate an object and assign all nodes on your own code; and\n2) fetch an object by factory.\n\n=head2 Creation by instantiation\n\nThe abstraction of Taxonomy is actually a hash in data structure\nterm. The keys of the hash are the rank names, such as 'genus' and\n'species', and the values are the instances of Bio::Taxonomy::Node.\n\n=head2 Creation by Factory fetching\n\nNCBI Taxonomy system is well accepted as the standard. The Taxonomy\nFactories in bioperl access this system, through HTTP to NCBI Entrez,\ndump file, and advanced biosql database.\n\nBio::Taxonomy::FactoryI defines all methods that all implementations\nmust obey.\n\n$factory-E<gt>fetch is a general method to fetch Taxonomy by either\nNCBI taxid or any types of names.\n\n$factory-E<gt>fetch_parent($taxonomy), returns a Taxonomy that is\none-step higher rank of the taxonomy specified as argument.\n\n$factory-E<gt>fetch_children($taxonomy), reports an array of Taxonomy\nthose are one-step lower rank of the taxonomy specified as the\nargument.\n\n=head2 Usage of Taxonomy object\n\n##\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 CONTACT\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# code begins...\n\n\npackage Bio::Taxonomy;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy->new();\n Function: Builds a new Bio::Taxonomy object\n Returns : Bio::Taxonomy\n Args    : -method  -> method used to decide classification\n                       (none|trust|lookup)\n           -ranks   -> what ranks are there\n\n\n\nsub new {\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n   $self->warn(\"Bio::Taxonomy is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n\n   $self->{'_method'}='none';\n   $self->{'_ranks'}=[];\n   $self->{'_rank_hash'}={};\n    $self->{_hierarchy} = {}; # used to store the nodes, with ranks as keys.\n   my ($method,$ranks,$order) = $self->_rearrange([qw(METHOD RANKS ORDER)], @args);\n\n   if ($method) {\n      $self->method($method);\n   }\n\n   if (defined $ranks &&\n      (ref($ranks) eq \"ARRAY\") ) {\n      $self->ranks(@$ranks);\n   } else {\n      # default ranks\n      # I think these are in the right order, but not sure:\n      # some parvorder|suborder and varietas|subspecies seem\n      # to be at the same level - any taxonomists?\n      # I don't expect that these will actually be used except as a way\n      # to find what ranks there are in taxonomic use\n      $self->ranks(('root',\n        'superkingdom', 'kingdom',\n        'superphylum', 'phylum', 'subphylum',\n        'superclass', 'class', 'subclass', 'infraclass',\n        'superorder', 'order', 'suborder', 'parvorder', 'infraorder',\n        'superfamily', 'family', 'subfamily',\n        'tribe', 'subtribe',\n        'genus', 'subgenus',\n        'species group', 'species subgroup', 'species', 'subspecies',\n        'varietas', 'forma', 'no rank'));\n   }\n\n   return $self;\n}\n\n\n=head2 method\n\n Title   : method\n Usage   : $obj = taxonomy->method($method);\n Function: set or return the method used to decide classification\n Returns : $obj\n Args    : $obj\n\n\n\nsub method {\n   my ($self,$value) = @_;\n   if (defined $value && $value=~/none|trust|lookup/) {\n       $self->{'_method'} = $value;\n   }\n   return $self->{'_method'};\n}\n\n\n=head2 classify\n\n Title   : classify\n Usage   : @obj[][0-1] = taxonomy->classify($species);\n Function: return a ranked classification\n Returns : @obj of taxa and ranks as word pairs separated by \"@\"\n Args    : Bio::Species object\n\n\n\nsub classify {\n   my ($self,$value) = @_;\n   my @ranks;\n\n   if (! $value->isa('Bio::Species') ) {\n      $self->throw(\"Trying to classify $value which is not a Bio::Species object\");\n   }\n\n   my @classes=reverse($value->classification);\n\n   if ($self->method eq 'none') {\n      for (my $i=0; $i < @classes-2; $i++) {\n         ($ranks[$i][0],$ranks[$i][1])=($classes[$i],'no rank');\n      }\n      push @ranks,[$classes[-2],'genus'];\n      push @ranks,[$value->binomial,'species'];\n   } elsif ($self->method eq 'trust') {\n      if (scalar(@classes)==scalar($self->ranks)) {\n         for (my $i=0; $i < @classes; $i++) {\n            if ($self->rank_of_number($i) eq 'species') {\n               push @ranks,[$value->binomial,$self->rank_of_number($i)];\n            } else {\n               push @ranks,[$classes[$i],$self->rank_of_number($i)];\n            }\n         }\n      } else {\n         $self->throw(\"Species object and taxonomy object cannot be reconciled\");\n      }\n   } elsif ($self->method eq 'lookup') {\n      # this will lookup a DB for the rank of a taxon name\n      # I imagine that some kind of Bio::DB class will be need to\n      # be given to the taxonomy object to act as an DB interface\n      # (I'm not sure how useful this is though - if you have a DB of\n      # taxonomy - why would you be doing things this way?)\n      $self->throw_not_implemented();\n   }\n\n   return @ranks;\n}\n\n\n=head2 level_of_rank\n\n Title   : level_of_rank\n Usage   : $obj = taxonomy->level_of_rank($obj);\n Function: returns the level of a rank name\n Returns : $obj\n Args    : $obj"},"line":308,"kind":12,"range":{"start":{"character":0,"line":308},"end":{"character":9999,"line":312}}},{"containerName":"main::","name":"rank_of_number","children":[{"definition":"my","line":327,"name":"$self","containerName":"rank_of_number","localvar":"my","kind":13},{"containerName":"rank_of_number","kind":13,"name":"$value","line":327},{"line":329,"kind":13,"containerName":"rank_of_number","name":"$self"}],"detail":"($self,$value)","definition":"sub","range":{"end":{"character":9999,"line":329},"start":{"line":326,"character":0}},"kind":12,"line":326,"signature":{"label":"rank_of_number($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Taxonomy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Juguang Xiao\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy - representing Taxonomy.\n\n=head1 SYNOPSIS\n\n  # NB: This module is deprecated. Use Bio::Taxon in combination with\n  # Bio::Tree::Tree methods instead.\n\n  use Bio::Taxonomy;\n\n  # CREATION: You can either create an instance by assigning it,\n  # or fetch it through factory.\n\n  # Create the nodes first. See Bio::Taxonomy::Node for details.\n  my $node_species_sapiens = Bio::Taxonomy::Node->new(\n      -object_id => 9606, # or -ncbi_taxid. Requird tag\n      -names => {\n          'scientific' => ['sapiens'],\n          'common_name' => ['human']\n      },\n      -rank => 'species'  # Required tag\n  );\n  my $node_genus_Homo = Bio::Taxonomy::Node->new(\n      -object_id => 9605,\n      -names => { 'scientific' => ['Homo'] },\n      -rank => 'genus'\n  );\n  my $node_class_Mammalia = Bio::Taxonomy::Node->new(\n      -object_id => 40674,\n      -names => {\n          'scientific' => ['Mammalia'],\n          'common' => ['mammals']\n      },\n      -rank => 'class'\n  );\n  my $taxonomy = Bio::Taxonomy->new;\n  $taxonomy->add_node($node_class_Mammalia);\n  $taxonomy->add_node($node_species_sapiens);\n  $taxonomy->add_node($node_genus_Homo);\n\n  # OR you can fetch it through a factory implementing\n  # Bio::Taxonomy::FactoryI\n  my $factory;\n\n  my $taxonomy = $factory->fetch_by_ncbi_taxid(40674);\n\n  # USAGE\n\n  # In this case, binomial returns a defined value.\n  my $binomial = $taxonomy->binomial;\n\n  # 'common_names' refers to the lowest-rank node's common names, in\n  # array.\n  my @common_names = $taxonomy->common_names;\n\n  # 'get_node', will return undef if the rank is no defined in\n  # taxonomy object.  It will throw error if the rank string is not\n  # defined, say 'species lah'.\n  my $node = $taxonomy->get_node('class');\n  my @nodes = $taxonomy->get_all_nodes;\n\n  # Also, you can search for parent and children nodes, if taxonomy\n  # comes with factory.\n\n  my $parent_taxonomy = $taxonomy->get_parent\n\n=head1 DESCRIPTION\n\nBio::Taxonomy object represents any rank-level in taxonomy system,\nrather than Bio::Species which is able to represent only\nspecies-level.\n\nThere are two ways to create Taxonomy object, e.g.\n1) instantiate an object and assign all nodes on your own code; and\n2) fetch an object by factory.\n\n=head2 Creation by instantiation\n\nThe abstraction of Taxonomy is actually a hash in data structure\nterm. The keys of the hash are the rank names, such as 'genus' and\n'species', and the values are the instances of Bio::Taxonomy::Node.\n\n=head2 Creation by Factory fetching\n\nNCBI Taxonomy system is well accepted as the standard. The Taxonomy\nFactories in bioperl access this system, through HTTP to NCBI Entrez,\ndump file, and advanced biosql database.\n\nBio::Taxonomy::FactoryI defines all methods that all implementations\nmust obey.\n\n$factory-E<gt>fetch is a general method to fetch Taxonomy by either\nNCBI taxid or any types of names.\n\n$factory-E<gt>fetch_parent($taxonomy), returns a Taxonomy that is\none-step higher rank of the taxonomy specified as argument.\n\n$factory-E<gt>fetch_children($taxonomy), reports an array of Taxonomy\nthose are one-step lower rank of the taxonomy specified as the\nargument.\n\n=head2 Usage of Taxonomy object\n\n##\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 CONTACT\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# code begins...\n\n\npackage Bio::Taxonomy;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy->new();\n Function: Builds a new Bio::Taxonomy object\n Returns : Bio::Taxonomy\n Args    : -method  -> method used to decide classification\n                       (none|trust|lookup)\n           -ranks   -> what ranks are there\n\n\n\nsub new {\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n   $self->warn(\"Bio::Taxonomy is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n\n   $self->{'_method'}='none';\n   $self->{'_ranks'}=[];\n   $self->{'_rank_hash'}={};\n    $self->{_hierarchy} = {}; # used to store the nodes, with ranks as keys.\n   my ($method,$ranks,$order) = $self->_rearrange([qw(METHOD RANKS ORDER)], @args);\n\n   if ($method) {\n      $self->method($method);\n   }\n\n   if (defined $ranks &&\n      (ref($ranks) eq \"ARRAY\") ) {\n      $self->ranks(@$ranks);\n   } else {\n      # default ranks\n      # I think these are in the right order, but not sure:\n      # some parvorder|suborder and varietas|subspecies seem\n      # to be at the same level - any taxonomists?\n      # I don't expect that these will actually be used except as a way\n      # to find what ranks there are in taxonomic use\n      $self->ranks(('root',\n        'superkingdom', 'kingdom',\n        'superphylum', 'phylum', 'subphylum',\n        'superclass', 'class', 'subclass', 'infraclass',\n        'superorder', 'order', 'suborder', 'parvorder', 'infraorder',\n        'superfamily', 'family', 'subfamily',\n        'tribe', 'subtribe',\n        'genus', 'subgenus',\n        'species group', 'species subgroup', 'species', 'subspecies',\n        'varietas', 'forma', 'no rank'));\n   }\n\n   return $self;\n}\n\n\n=head2 method\n\n Title   : method\n Usage   : $obj = taxonomy->method($method);\n Function: set or return the method used to decide classification\n Returns : $obj\n Args    : $obj\n\n\n\nsub method {\n   my ($self,$value) = @_;\n   if (defined $value && $value=~/none|trust|lookup/) {\n       $self->{'_method'} = $value;\n   }\n   return $self->{'_method'};\n}\n\n\n=head2 classify\n\n Title   : classify\n Usage   : @obj[][0-1] = taxonomy->classify($species);\n Function: return a ranked classification\n Returns : @obj of taxa and ranks as word pairs separated by \"@\"\n Args    : Bio::Species object\n\n\n\nsub classify {\n   my ($self,$value) = @_;\n   my @ranks;\n\n   if (! $value->isa('Bio::Species') ) {\n      $self->throw(\"Trying to classify $value which is not a Bio::Species object\");\n   }\n\n   my @classes=reverse($value->classification);\n\n   if ($self->method eq 'none') {\n      for (my $i=0; $i < @classes-2; $i++) {\n         ($ranks[$i][0],$ranks[$i][1])=($classes[$i],'no rank');\n      }\n      push @ranks,[$classes[-2],'genus'];\n      push @ranks,[$value->binomial,'species'];\n   } elsif ($self->method eq 'trust') {\n      if (scalar(@classes)==scalar($self->ranks)) {\n         for (my $i=0; $i < @classes; $i++) {\n            if ($self->rank_of_number($i) eq 'species') {\n               push @ranks,[$value->binomial,$self->rank_of_number($i)];\n            } else {\n               push @ranks,[$classes[$i],$self->rank_of_number($i)];\n            }\n         }\n      } else {\n         $self->throw(\"Species object and taxonomy object cannot be reconciled\");\n      }\n   } elsif ($self->method eq 'lookup') {\n      # this will lookup a DB for the rank of a taxon name\n      # I imagine that some kind of Bio::DB class will be need to\n      # be given to the taxonomy object to act as an DB interface\n      # (I'm not sure how useful this is though - if you have a DB of\n      # taxonomy - why would you be doing things this way?)\n      $self->throw_not_implemented();\n   }\n\n   return @ranks;\n}\n\n\n=head2 level_of_rank\n\n Title   : level_of_rank\n Usage   : $obj = taxonomy->level_of_rank($obj);\n Function: returns the level of a rank name\n Returns : $obj\n Args    : $obj\n\n\n\nsub level_of {\n   my ($self,$value) = @_;\n\n   return $self->{'_rank_hash'}{$value};\n}\n\n\n=head2 rank_of_number\n\n Title   : rank_of_number\n Usage   : $obj = taxonomy->rank_of_number($obj);\n Function: returns the rank name of a rank level\n Returns : $obj\n Args    : $obj"}},{"line":329,"name":"$value","containerName":null,"kind":13},{"signature":{"documentation":"1;\n# $Id: Taxonomy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Juguang Xiao\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy - representing Taxonomy.\n\n=head1 SYNOPSIS\n\n  # NB: This module is deprecated. Use Bio::Taxon in combination with\n  # Bio::Tree::Tree methods instead.\n\n  use Bio::Taxonomy;\n\n  # CREATION: You can either create an instance by assigning it,\n  # or fetch it through factory.\n\n  # Create the nodes first. See Bio::Taxonomy::Node for details.\n  my $node_species_sapiens = Bio::Taxonomy::Node->new(\n      -object_id => 9606, # or -ncbi_taxid. Requird tag\n      -names => {\n          'scientific' => ['sapiens'],\n          'common_name' => ['human']\n      },\n      -rank => 'species'  # Required tag\n  );\n  my $node_genus_Homo = Bio::Taxonomy::Node->new(\n      -object_id => 9605,\n      -names => { 'scientific' => ['Homo'] },\n      -rank => 'genus'\n  );\n  my $node_class_Mammalia = Bio::Taxonomy::Node->new(\n      -object_id => 40674,\n      -names => {\n          'scientific' => ['Mammalia'],\n          'common' => ['mammals']\n      },\n      -rank => 'class'\n  );\n  my $taxonomy = Bio::Taxonomy->new;\n  $taxonomy->add_node($node_class_Mammalia);\n  $taxonomy->add_node($node_species_sapiens);\n  $taxonomy->add_node($node_genus_Homo);\n\n  # OR you can fetch it through a factory implementing\n  # Bio::Taxonomy::FactoryI\n  my $factory;\n\n  my $taxonomy = $factory->fetch_by_ncbi_taxid(40674);\n\n  # USAGE\n\n  # In this case, binomial returns a defined value.\n  my $binomial = $taxonomy->binomial;\n\n  # 'common_names' refers to the lowest-rank node's common names, in\n  # array.\n  my @common_names = $taxonomy->common_names;\n\n  # 'get_node', will return undef if the rank is no defined in\n  # taxonomy object.  It will throw error if the rank string is not\n  # defined, say 'species lah'.\n  my $node = $taxonomy->get_node('class');\n  my @nodes = $taxonomy->get_all_nodes;\n\n  # Also, you can search for parent and children nodes, if taxonomy\n  # comes with factory.\n\n  my $parent_taxonomy = $taxonomy->get_parent\n\n=head1 DESCRIPTION\n\nBio::Taxonomy object represents any rank-level in taxonomy system,\nrather than Bio::Species which is able to represent only\nspecies-level.\n\nThere are two ways to create Taxonomy object, e.g.\n1) instantiate an object and assign all nodes on your own code; and\n2) fetch an object by factory.\n\n=head2 Creation by instantiation\n\nThe abstraction of Taxonomy is actually a hash in data structure\nterm. The keys of the hash are the rank names, such as 'genus' and\n'species', and the values are the instances of Bio::Taxonomy::Node.\n\n=head2 Creation by Factory fetching\n\nNCBI Taxonomy system is well accepted as the standard. The Taxonomy\nFactories in bioperl access this system, through HTTP to NCBI Entrez,\ndump file, and advanced biosql database.\n\nBio::Taxonomy::FactoryI defines all methods that all implementations\nmust obey.\n\n$factory-E<gt>fetch is a general method to fetch Taxonomy by either\nNCBI taxid or any types of names.\n\n$factory-E<gt>fetch_parent($taxonomy), returns a Taxonomy that is\none-step higher rank of the taxonomy specified as argument.\n\n$factory-E<gt>fetch_children($taxonomy), reports an array of Taxonomy\nthose are one-step lower rank of the taxonomy specified as the\nargument.\n\n=head2 Usage of Taxonomy object\n\n##\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 CONTACT\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# code begins...\n\n\npackage Bio::Taxonomy;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy->new();\n Function: Builds a new Bio::Taxonomy object\n Returns : Bio::Taxonomy\n Args    : -method  -> method used to decide classification\n                       (none|trust|lookup)\n           -ranks   -> what ranks are there\n\n\n\nsub new {\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n   $self->warn(\"Bio::Taxonomy is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n\n   $self->{'_method'}='none';\n   $self->{'_ranks'}=[];\n   $self->{'_rank_hash'}={};\n    $self->{_hierarchy} = {}; # used to store the nodes, with ranks as keys.\n   my ($method,$ranks,$order) = $self->_rearrange([qw(METHOD RANKS ORDER)], @args);\n\n   if ($method) {\n      $self->method($method);\n   }\n\n   if (defined $ranks &&\n      (ref($ranks) eq \"ARRAY\") ) {\n      $self->ranks(@$ranks);\n   } else {\n      # default ranks\n      # I think these are in the right order, but not sure:\n      # some parvorder|suborder and varietas|subspecies seem\n      # to be at the same level - any taxonomists?\n      # I don't expect that these will actually be used except as a way\n      # to find what ranks there are in taxonomic use\n      $self->ranks(('root',\n        'superkingdom', 'kingdom',\n        'superphylum', 'phylum', 'subphylum',\n        'superclass', 'class', 'subclass', 'infraclass',\n        'superorder', 'order', 'suborder', 'parvorder', 'infraorder',\n        'superfamily', 'family', 'subfamily',\n        'tribe', 'subtribe',\n        'genus', 'subgenus',\n        'species group', 'species subgroup', 'species', 'subspecies',\n        'varietas', 'forma', 'no rank'));\n   }\n\n   return $self;\n}\n\n\n=head2 method\n\n Title   : method\n Usage   : $obj = taxonomy->method($method);\n Function: set or return the method used to decide classification\n Returns : $obj\n Args    : $obj\n\n\n\nsub method {\n   my ($self,$value) = @_;\n   if (defined $value && $value=~/none|trust|lookup/) {\n       $self->{'_method'} = $value;\n   }\n   return $self->{'_method'};\n}\n\n\n=head2 classify\n\n Title   : classify\n Usage   : @obj[][0-1] = taxonomy->classify($species);\n Function: return a ranked classification\n Returns : @obj of taxa and ranks as word pairs separated by \"@\"\n Args    : Bio::Species object\n\n\n\nsub classify {\n   my ($self,$value) = @_;\n   my @ranks;\n\n   if (! $value->isa('Bio::Species') ) {\n      $self->throw(\"Trying to classify $value which is not a Bio::Species object\");\n   }\n\n   my @classes=reverse($value->classification);\n\n   if ($self->method eq 'none') {\n      for (my $i=0; $i < @classes-2; $i++) {\n         ($ranks[$i][0],$ranks[$i][1])=($classes[$i],'no rank');\n      }\n      push @ranks,[$classes[-2],'genus'];\n      push @ranks,[$value->binomial,'species'];\n   } elsif ($self->method eq 'trust') {\n      if (scalar(@classes)==scalar($self->ranks)) {\n         for (my $i=0; $i < @classes; $i++) {\n            if ($self->rank_of_number($i) eq 'species') {\n               push @ranks,[$value->binomial,$self->rank_of_number($i)];\n            } else {\n               push @ranks,[$classes[$i],$self->rank_of_number($i)];\n            }\n         }\n      } else {\n         $self->throw(\"Species object and taxonomy object cannot be reconciled\");\n      }\n   } elsif ($self->method eq 'lookup') {\n      # this will lookup a DB for the rank of a taxon name\n      # I imagine that some kind of Bio::DB class will be need to\n      # be given to the taxonomy object to act as an DB interface\n      # (I'm not sure how useful this is though - if you have a DB of\n      # taxonomy - why would you be doing things this way?)\n      $self->throw_not_implemented();\n   }\n\n   return @ranks;\n}\n\n\n=head2 level_of_rank\n\n Title   : level_of_rank\n Usage   : $obj = taxonomy->level_of_rank($obj);\n Function: returns the level of a rank name\n Returns : $obj\n Args    : $obj\n\n\n\nsub level_of {\n   my ($self,$value) = @_;\n\n   return $self->{'_rank_hash'}{$value};\n}\n\n\n=head2 rank_of_number\n\n Title   : rank_of_number\n Usage   : $obj = taxonomy->rank_of_number($obj);\n Function: returns the rank name of a rank level\n Returns : $obj\n Args    : $obj\n\n\n\nsub rank_of_number {\n   my ($self,$value) = @_;\n\n   return ${$self->{'_ranks'}}[$value];\n}\n\n\n=head2 ranks\n\n Title   : ranks\n Usage   : @obj = taxonomy->ranks(@obj);\n Function: set or return all ranks\n Returns : @obj\n Args    : @obj","parameters":[{"label":"$self"},{"label":"@value"}],"label":"ranks($self,@value)"},"line":344,"range":{"end":{"character":9999,"line":356},"start":{"line":344,"character":0}},"kind":12,"definition":"sub","detail":"($self,@value)","children":[{"definition":"my","containerName":"ranks","localvar":"my","kind":13,"name":"$self","line":345},{"line":345,"name":"@value","kind":13,"containerName":"ranks"},{"name":"@value","kind":13,"containerName":"ranks","line":352},{"containerName":"ranks","kind":13,"name":"$self","line":353},{"containerName":"ranks","kind":13,"name":"@value","line":353},{"definition":"my","line":356,"localvar":"my","containerName":"ranks","kind":13,"name":"$i"},{"line":356,"name":"$i","kind":13,"containerName":"ranks"},{"line":356,"containerName":"ranks","kind":13,"name":"$self"}],"name":"ranks","containerName":"main::"},{"line":356,"name":"%i","kind":13,"containerName":null},{"name":"%self","kind":13,"containerName":null,"line":357},{"line":357,"kind":13,"containerName":null,"name":"%self"},{"line":357,"name":"$i","containerName":null,"kind":13},{"name":"$i","containerName":null,"kind":13,"line":357},{"line":357,"name":"%self","kind":13,"containerName":null},{"name":"$i","kind":13,"containerName":null,"line":357},{"line":360,"name":"%self","kind":13,"containerName":null},{"detail":"($self,@nodes)","definition":"sub","containerName":"main::","name":"add_node","children":[{"line":374,"kind":13,"localvar":"my","containerName":"add_node","name":"$self","definition":"my"},{"containerName":"add_node","kind":13,"name":"@nodes","line":374},{"name":"@nodes","kind":13,"containerName":"add_node","line":375},{"containerName":"add_node","kind":13,"name":"$self","line":376},{"line":376,"name":"throw","containerName":"add_node","kind":12},{"line":377,"kind":12,"containerName":"add_node","name":"isa"},{"definition":"my","line":378,"localvar":"my","containerName":"add_node","kind":13,"name":"$node"},{"line":378,"kind":13,"containerName":"add_node","name":"$rank"},{"line":378,"containerName":"add_node","kind":12,"name":"rank"},{"containerName":"add_node","kind":13,"name":"$self","line":379},{"kind":13,"containerName":"add_node","name":"$rank","line":379},{"line":384,"containerName":"add_node","kind":13,"name":"$self"},{"line":384,"kind":13,"containerName":"add_node","name":"$rank"},{"line":384,"kind":13,"containerName":"add_node","name":"$node"}],"signature":{"label":"add_node($self,@nodes)","parameters":[{"label":"$self"},{"label":"@nodes"}],"documentation":"1;\n# $Id: Taxonomy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Juguang Xiao\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy - representing Taxonomy.\n\n=head1 SYNOPSIS\n\n  # NB: This module is deprecated. Use Bio::Taxon in combination with\n  # Bio::Tree::Tree methods instead.\n\n  use Bio::Taxonomy;\n\n  # CREATION: You can either create an instance by assigning it,\n  # or fetch it through factory.\n\n  # Create the nodes first. See Bio::Taxonomy::Node for details.\n  my $node_species_sapiens = Bio::Taxonomy::Node->new(\n      -object_id => 9606, # or -ncbi_taxid. Requird tag\n      -names => {\n          'scientific' => ['sapiens'],\n          'common_name' => ['human']\n      },\n      -rank => 'species'  # Required tag\n  );\n  my $node_genus_Homo = Bio::Taxonomy::Node->new(\n      -object_id => 9605,\n      -names => { 'scientific' => ['Homo'] },\n      -rank => 'genus'\n  );\n  my $node_class_Mammalia = Bio::Taxonomy::Node->new(\n      -object_id => 40674,\n      -names => {\n          'scientific' => ['Mammalia'],\n          'common' => ['mammals']\n      },\n      -rank => 'class'\n  );\n  my $taxonomy = Bio::Taxonomy->new;\n  $taxonomy->add_node($node_class_Mammalia);\n  $taxonomy->add_node($node_species_sapiens);\n  $taxonomy->add_node($node_genus_Homo);\n\n  # OR you can fetch it through a factory implementing\n  # Bio::Taxonomy::FactoryI\n  my $factory;\n\n  my $taxonomy = $factory->fetch_by_ncbi_taxid(40674);\n\n  # USAGE\n\n  # In this case, binomial returns a defined value.\n  my $binomial = $taxonomy->binomial;\n\n  # 'common_names' refers to the lowest-rank node's common names, in\n  # array.\n  my @common_names = $taxonomy->common_names;\n\n  # 'get_node', will return undef if the rank is no defined in\n  # taxonomy object.  It will throw error if the rank string is not\n  # defined, say 'species lah'.\n  my $node = $taxonomy->get_node('class');\n  my @nodes = $taxonomy->get_all_nodes;\n\n  # Also, you can search for parent and children nodes, if taxonomy\n  # comes with factory.\n\n  my $parent_taxonomy = $taxonomy->get_parent\n\n=head1 DESCRIPTION\n\nBio::Taxonomy object represents any rank-level in taxonomy system,\nrather than Bio::Species which is able to represent only\nspecies-level.\n\nThere are two ways to create Taxonomy object, e.g.\n1) instantiate an object and assign all nodes on your own code; and\n2) fetch an object by factory.\n\n=head2 Creation by instantiation\n\nThe abstraction of Taxonomy is actually a hash in data structure\nterm. The keys of the hash are the rank names, such as 'genus' and\n'species', and the values are the instances of Bio::Taxonomy::Node.\n\n=head2 Creation by Factory fetching\n\nNCBI Taxonomy system is well accepted as the standard. The Taxonomy\nFactories in bioperl access this system, through HTTP to NCBI Entrez,\ndump file, and advanced biosql database.\n\nBio::Taxonomy::FactoryI defines all methods that all implementations\nmust obey.\n\n$factory-E<gt>fetch is a general method to fetch Taxonomy by either\nNCBI taxid or any types of names.\n\n$factory-E<gt>fetch_parent($taxonomy), returns a Taxonomy that is\none-step higher rank of the taxonomy specified as argument.\n\n$factory-E<gt>fetch_children($taxonomy), reports an array of Taxonomy\nthose are one-step lower rank of the taxonomy specified as the\nargument.\n\n=head2 Usage of Taxonomy object\n\n##\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 CONTACT\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# code begins...\n\n\npackage Bio::Taxonomy;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy->new();\n Function: Builds a new Bio::Taxonomy object\n Returns : Bio::Taxonomy\n Args    : -method  -> method used to decide classification\n                       (none|trust|lookup)\n           -ranks   -> what ranks are there\n\n\n\nsub new {\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n   $self->warn(\"Bio::Taxonomy is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n\n   $self->{'_method'}='none';\n   $self->{'_ranks'}=[];\n   $self->{'_rank_hash'}={};\n    $self->{_hierarchy} = {}; # used to store the nodes, with ranks as keys.\n   my ($method,$ranks,$order) = $self->_rearrange([qw(METHOD RANKS ORDER)], @args);\n\n   if ($method) {\n      $self->method($method);\n   }\n\n   if (defined $ranks &&\n      (ref($ranks) eq \"ARRAY\") ) {\n      $self->ranks(@$ranks);\n   } else {\n      # default ranks\n      # I think these are in the right order, but not sure:\n      # some parvorder|suborder and varietas|subspecies seem\n      # to be at the same level - any taxonomists?\n      # I don't expect that these will actually be used except as a way\n      # to find what ranks there are in taxonomic use\n      $self->ranks(('root',\n        'superkingdom', 'kingdom',\n        'superphylum', 'phylum', 'subphylum',\n        'superclass', 'class', 'subclass', 'infraclass',\n        'superorder', 'order', 'suborder', 'parvorder', 'infraorder',\n        'superfamily', 'family', 'subfamily',\n        'tribe', 'subtribe',\n        'genus', 'subgenus',\n        'species group', 'species subgroup', 'species', 'subspecies',\n        'varietas', 'forma', 'no rank'));\n   }\n\n   return $self;\n}\n\n\n=head2 method\n\n Title   : method\n Usage   : $obj = taxonomy->method($method);\n Function: set or return the method used to decide classification\n Returns : $obj\n Args    : $obj\n\n\n\nsub method {\n   my ($self,$value) = @_;\n   if (defined $value && $value=~/none|trust|lookup/) {\n       $self->{'_method'} = $value;\n   }\n   return $self->{'_method'};\n}\n\n\n=head2 classify\n\n Title   : classify\n Usage   : @obj[][0-1] = taxonomy->classify($species);\n Function: return a ranked classification\n Returns : @obj of taxa and ranks as word pairs separated by \"@\"\n Args    : Bio::Species object\n\n\n\nsub classify {\n   my ($self,$value) = @_;\n   my @ranks;\n\n   if (! $value->isa('Bio::Species') ) {\n      $self->throw(\"Trying to classify $value which is not a Bio::Species object\");\n   }\n\n   my @classes=reverse($value->classification);\n\n   if ($self->method eq 'none') {\n      for (my $i=0; $i < @classes-2; $i++) {\n         ($ranks[$i][0],$ranks[$i][1])=($classes[$i],'no rank');\n      }\n      push @ranks,[$classes[-2],'genus'];\n      push @ranks,[$value->binomial,'species'];\n   } elsif ($self->method eq 'trust') {\n      if (scalar(@classes)==scalar($self->ranks)) {\n         for (my $i=0; $i < @classes; $i++) {\n            if ($self->rank_of_number($i) eq 'species') {\n               push @ranks,[$value->binomial,$self->rank_of_number($i)];\n            } else {\n               push @ranks,[$classes[$i],$self->rank_of_number($i)];\n            }\n         }\n      } else {\n         $self->throw(\"Species object and taxonomy object cannot be reconciled\");\n      }\n   } elsif ($self->method eq 'lookup') {\n      # this will lookup a DB for the rank of a taxon name\n      # I imagine that some kind of Bio::DB class will be need to\n      # be given to the taxonomy object to act as an DB interface\n      # (I'm not sure how useful this is though - if you have a DB of\n      # taxonomy - why would you be doing things this way?)\n      $self->throw_not_implemented();\n   }\n\n   return @ranks;\n}\n\n\n=head2 level_of_rank\n\n Title   : level_of_rank\n Usage   : $obj = taxonomy->level_of_rank($obj);\n Function: returns the level of a rank name\n Returns : $obj\n Args    : $obj\n\n\n\nsub level_of {\n   my ($self,$value) = @_;\n\n   return $self->{'_rank_hash'}{$value};\n}\n\n\n=head2 rank_of_number\n\n Title   : rank_of_number\n Usage   : $obj = taxonomy->rank_of_number($obj);\n Function: returns the rank name of a rank level\n Returns : $obj\n Args    : $obj\n\n\n\nsub rank_of_number {\n   my ($self,$value) = @_;\n\n   return ${$self->{'_ranks'}}[$value];\n}\n\n\n=head2 ranks\n\n Title   : ranks\n Usage   : @obj = taxonomy->ranks(@obj);\n Function: set or return all ranks\n Returns : @obj\n Args    : @obj\n\n\n\nsub ranks {\n   my ($self,@value) = @_;\n\n   # currently this makes no uniqueness sanity check (this should be done)\n   # I am think that adding a way of converting multiple 'no rank' ranks\n   # to unique 'no rank #' ranks so that the level of a 'no rank' is\n   # abstracted way from the user - I'm not sure of the value of this\n\n   if (@value) {\n      $self->{'_ranks'}=\\@value;\n   }\n\n   for (my $i=0; $i <= @{$self->{'_ranks'}}-1; $i++) {\n      $self->{'_rank_hash'}{$self->{'_ranks'}[$i]}=$i unless $self->{'_ranks'}[$i] eq 'no rank';\n   }\n\n   return @{$self->{'_ranks'}};\n}\n\n=head2 add_node\n\n  Title:    add_node\n  Usage:    $obj->add_node($node[, $node2, ...]);\n  Function: add one or more Bio::Taxonomy::Node objects\n  Returns:  None\n  Args:     any number of Bio::Taxonomy::Node(s)"},"range":{"start":{"character":0,"line":373},"end":{"line":386,"character":9999}},"kind":12,"line":373},{"line":379,"kind":12,"name":"_hierarchy"},{"kind":12,"name":"_hierarchy","line":384},{"line":399,"kind":12,"range":{"start":{"character":0,"line":399},"end":{"character":9999,"line":405}},"children":[{"definition":"my","line":400,"kind":13,"localvar":"my","containerName":"binomial","name":"$self"},{"line":401,"name":"$self","kind":13,"containerName":"binomial"},{"kind":12,"containerName":"binomial","name":"get_node","line":401},{"line":401,"name":"scientific_name","kind":12,"containerName":"binomial"},{"line":402,"name":"$genus","localvar":"my","containerName":"binomial","kind":13,"definition":"my"},{"name":"$self","kind":13,"containerName":"binomial","line":402},{"line":402,"name":"get_node","kind":12,"containerName":"binomial"},{"line":403,"localvar":"my","containerName":"binomial","kind":13,"name":"$species","definition":"my"},{"line":403,"name":"$self","containerName":"binomial","kind":13},{"containerName":"binomial","kind":12,"name":"get_node","line":403},{"line":404,"containerName":"binomial","kind":13,"name":"$species"},{"line":404,"kind":13,"containerName":"binomial","name":"$genus"}],"containerName":"main::","name":"binomial","definition":"sub"},{"signature":{"label":"get_node($self,$rank)","documentation":"1;\n# $Id: Taxonomy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Juguang Xiao\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy - representing Taxonomy.\n\n=head1 SYNOPSIS\n\n  # NB: This module is deprecated. Use Bio::Taxon in combination with\n  # Bio::Tree::Tree methods instead.\n\n  use Bio::Taxonomy;\n\n  # CREATION: You can either create an instance by assigning it,\n  # or fetch it through factory.\n\n  # Create the nodes first. See Bio::Taxonomy::Node for details.\n  my $node_species_sapiens = Bio::Taxonomy::Node->new(\n      -object_id => 9606, # or -ncbi_taxid. Requird tag\n      -names => {\n          'scientific' => ['sapiens'],\n          'common_name' => ['human']\n      },\n      -rank => 'species'  # Required tag\n  );\n  my $node_genus_Homo = Bio::Taxonomy::Node->new(\n      -object_id => 9605,\n      -names => { 'scientific' => ['Homo'] },\n      -rank => 'genus'\n  );\n  my $node_class_Mammalia = Bio::Taxonomy::Node->new(\n      -object_id => 40674,\n      -names => {\n          'scientific' => ['Mammalia'],\n          'common' => ['mammals']\n      },\n      -rank => 'class'\n  );\n  my $taxonomy = Bio::Taxonomy->new;\n  $taxonomy->add_node($node_class_Mammalia);\n  $taxonomy->add_node($node_species_sapiens);\n  $taxonomy->add_node($node_genus_Homo);\n\n  # OR you can fetch it through a factory implementing\n  # Bio::Taxonomy::FactoryI\n  my $factory;\n\n  my $taxonomy = $factory->fetch_by_ncbi_taxid(40674);\n\n  # USAGE\n\n  # In this case, binomial returns a defined value.\n  my $binomial = $taxonomy->binomial;\n\n  # 'common_names' refers to the lowest-rank node's common names, in\n  # array.\n  my @common_names = $taxonomy->common_names;\n\n  # 'get_node', will return undef if the rank is no defined in\n  # taxonomy object.  It will throw error if the rank string is not\n  # defined, say 'species lah'.\n  my $node = $taxonomy->get_node('class');\n  my @nodes = $taxonomy->get_all_nodes;\n\n  # Also, you can search for parent and children nodes, if taxonomy\n  # comes with factory.\n\n  my $parent_taxonomy = $taxonomy->get_parent\n\n=head1 DESCRIPTION\n\nBio::Taxonomy object represents any rank-level in taxonomy system,\nrather than Bio::Species which is able to represent only\nspecies-level.\n\nThere are two ways to create Taxonomy object, e.g.\n1) instantiate an object and assign all nodes on your own code; and\n2) fetch an object by factory.\n\n=head2 Creation by instantiation\n\nThe abstraction of Taxonomy is actually a hash in data structure\nterm. The keys of the hash are the rank names, such as 'genus' and\n'species', and the values are the instances of Bio::Taxonomy::Node.\n\n=head2 Creation by Factory fetching\n\nNCBI Taxonomy system is well accepted as the standard. The Taxonomy\nFactories in bioperl access this system, through HTTP to NCBI Entrez,\ndump file, and advanced biosql database.\n\nBio::Taxonomy::FactoryI defines all methods that all implementations\nmust obey.\n\n$factory-E<gt>fetch is a general method to fetch Taxonomy by either\nNCBI taxid or any types of names.\n\n$factory-E<gt>fetch_parent($taxonomy), returns a Taxonomy that is\none-step higher rank of the taxonomy specified as argument.\n\n$factory-E<gt>fetch_children($taxonomy), reports an array of Taxonomy\nthose are one-step lower rank of the taxonomy specified as the\nargument.\n\n=head2 Usage of Taxonomy object\n\n##\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 CONTACT\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# code begins...\n\n\npackage Bio::Taxonomy;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy->new();\n Function: Builds a new Bio::Taxonomy object\n Returns : Bio::Taxonomy\n Args    : -method  -> method used to decide classification\n                       (none|trust|lookup)\n           -ranks   -> what ranks are there\n\n\n\nsub new {\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n   $self->warn(\"Bio::Taxonomy is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n\n   $self->{'_method'}='none';\n   $self->{'_ranks'}=[];\n   $self->{'_rank_hash'}={};\n    $self->{_hierarchy} = {}; # used to store the nodes, with ranks as keys.\n   my ($method,$ranks,$order) = $self->_rearrange([qw(METHOD RANKS ORDER)], @args);\n\n   if ($method) {\n      $self->method($method);\n   }\n\n   if (defined $ranks &&\n      (ref($ranks) eq \"ARRAY\") ) {\n      $self->ranks(@$ranks);\n   } else {\n      # default ranks\n      # I think these are in the right order, but not sure:\n      # some parvorder|suborder and varietas|subspecies seem\n      # to be at the same level - any taxonomists?\n      # I don't expect that these will actually be used except as a way\n      # to find what ranks there are in taxonomic use\n      $self->ranks(('root',\n        'superkingdom', 'kingdom',\n        'superphylum', 'phylum', 'subphylum',\n        'superclass', 'class', 'subclass', 'infraclass',\n        'superorder', 'order', 'suborder', 'parvorder', 'infraorder',\n        'superfamily', 'family', 'subfamily',\n        'tribe', 'subtribe',\n        'genus', 'subgenus',\n        'species group', 'species subgroup', 'species', 'subspecies',\n        'varietas', 'forma', 'no rank'));\n   }\n\n   return $self;\n}\n\n\n=head2 method\n\n Title   : method\n Usage   : $obj = taxonomy->method($method);\n Function: set or return the method used to decide classification\n Returns : $obj\n Args    : $obj\n\n\n\nsub method {\n   my ($self,$value) = @_;\n   if (defined $value && $value=~/none|trust|lookup/) {\n       $self->{'_method'} = $value;\n   }\n   return $self->{'_method'};\n}\n\n\n=head2 classify\n\n Title   : classify\n Usage   : @obj[][0-1] = taxonomy->classify($species);\n Function: return a ranked classification\n Returns : @obj of taxa and ranks as word pairs separated by \"@\"\n Args    : Bio::Species object\n\n\n\nsub classify {\n   my ($self,$value) = @_;\n   my @ranks;\n\n   if (! $value->isa('Bio::Species') ) {\n      $self->throw(\"Trying to classify $value which is not a Bio::Species object\");\n   }\n\n   my @classes=reverse($value->classification);\n\n   if ($self->method eq 'none') {\n      for (my $i=0; $i < @classes-2; $i++) {\n         ($ranks[$i][0],$ranks[$i][1])=($classes[$i],'no rank');\n      }\n      push @ranks,[$classes[-2],'genus'];\n      push @ranks,[$value->binomial,'species'];\n   } elsif ($self->method eq 'trust') {\n      if (scalar(@classes)==scalar($self->ranks)) {\n         for (my $i=0; $i < @classes; $i++) {\n            if ($self->rank_of_number($i) eq 'species') {\n               push @ranks,[$value->binomial,$self->rank_of_number($i)];\n            } else {\n               push @ranks,[$classes[$i],$self->rank_of_number($i)];\n            }\n         }\n      } else {\n         $self->throw(\"Species object and taxonomy object cannot be reconciled\");\n      }\n   } elsif ($self->method eq 'lookup') {\n      # this will lookup a DB for the rank of a taxon name\n      # I imagine that some kind of Bio::DB class will be need to\n      # be given to the taxonomy object to act as an DB interface\n      # (I'm not sure how useful this is though - if you have a DB of\n      # taxonomy - why would you be doing things this way?)\n      $self->throw_not_implemented();\n   }\n\n   return @ranks;\n}\n\n\n=head2 level_of_rank\n\n Title   : level_of_rank\n Usage   : $obj = taxonomy->level_of_rank($obj);\n Function: returns the level of a rank name\n Returns : $obj\n Args    : $obj\n\n\n\nsub level_of {\n   my ($self,$value) = @_;\n\n   return $self->{'_rank_hash'}{$value};\n}\n\n\n=head2 rank_of_number\n\n Title   : rank_of_number\n Usage   : $obj = taxonomy->rank_of_number($obj);\n Function: returns the rank name of a rank level\n Returns : $obj\n Args    : $obj\n\n\n\nsub rank_of_number {\n   my ($self,$value) = @_;\n\n   return ${$self->{'_ranks'}}[$value];\n}\n\n\n=head2 ranks\n\n Title   : ranks\n Usage   : @obj = taxonomy->ranks(@obj);\n Function: set or return all ranks\n Returns : @obj\n Args    : @obj\n\n\n\nsub ranks {\n   my ($self,@value) = @_;\n\n   # currently this makes no uniqueness sanity check (this should be done)\n   # I am think that adding a way of converting multiple 'no rank' ranks\n   # to unique 'no rank #' ranks so that the level of a 'no rank' is\n   # abstracted way from the user - I'm not sure of the value of this\n\n   if (@value) {\n      $self->{'_ranks'}=\\@value;\n   }\n\n   for (my $i=0; $i <= @{$self->{'_ranks'}}-1; $i++) {\n      $self->{'_rank_hash'}{$self->{'_ranks'}[$i]}=$i unless $self->{'_ranks'}[$i] eq 'no rank';\n   }\n\n   return @{$self->{'_ranks'}};\n}\n\n=head2 add_node\n\n  Title:    add_node\n  Usage:    $obj->add_node($node[, $node2, ...]);\n  Function: add one or more Bio::Taxonomy::Node objects\n  Returns:  None\n  Args:     any number of Bio::Taxonomy::Node(s)\n\n\nsub add_node {\n    my ($self, @nodes) = @_;\n    foreach(@nodes){\n        $self->throw(\"A Bio::Taxonomy::Node object needed\")\n            unless($_->isa('Bio::Taxonomy::Node'));\n        my ($node, $rank) = ($_, $_->rank);\n        if(exists $self->{_hierarchy}->{$rank}){\n#            $self->throw(\"$rank has been defined\");\n#            print STDERR \"RANK:$rank\\n\";\n#            return;\n        }\n        $self->{_hierarchy}->{$rank} = $node;\n    }\n}\n\n=head2 binomial\n\n  Title   : binomial\n  Usage   : my $val = $obj->binomial;\n  Function: returns the binomial name if this taxonomy reachs species level\n  Returns : the binomial name\n            OR undef if taxonmy does not reach species level\n  Args    : [No arguments]\n\n\nsub binomial {\n    my $self = shift;\n    return $self->get_node('species')->scientific_name;\n    my $genus = $self->get_node('genus');\n    my $species = $self->get_node('species');\n    return ($species && $genus) ? \"$species $genus\" : undef;\n}\n\n=head2 get_node\n\n  Title   : get_node\n  Usage   : $node = $taxonomy->get_node('species');\n  Function: get a Bio::Taxonomy::Node object according to rank name\n  Returns : a Bio::Taxonomy::Node object or undef if null\n  Args    : a vaild rank name","parameters":[{"label":"$self"},{"label":"$rank"}]},"line":417,"kind":12,"range":{"start":{"line":417,"character":0},"end":{"character":9999,"line":419}},"definition":"sub","detail":"($self,$rank)","children":[{"name":"$self","localvar":"my","containerName":"get_node","kind":13,"line":418,"definition":"my"},{"containerName":"get_node","kind":13,"name":"$rank","line":418},{"name":"$self","containerName":"get_node","kind":13,"line":419}],"containerName":"main::","name":"get_node"},{"kind":12,"name":"_hierarchy","line":419},{"line":420,"containerName":null,"kind":13,"name":"$self"},{"name":"throw","kind":12,"containerName":"main::","line":420},{"kind":13,"containerName":null,"name":"%self","line":422},{"line":422,"kind":12,"name":"_hierarchy"},{"line":422,"name":"$rank","kind":13,"containerName":null},{"line":423,"containerName":null,"kind":13,"name":"%self"},{"line":423,"name":"_hierarchy","kind":12},{"line":423,"kind":13,"containerName":null,"name":"$rank"},{"definition":"sub","containerName":"main::","name":"classification","children":[{"line":437,"name":"$self","localvar":"my","kind":13,"containerName":"classification","definition":"my"},{"definition":"my","name":"%rank_hash","kind":13,"localvar":"my","containerName":"classification","line":438},{"line":438,"containerName":"classification","kind":13,"name":"$self"}],"kind":12,"range":{"start":{"character":0,"line":436},"end":{"line":438,"character":9999}},"line":436},{"line":438,"name":"_rank_hash","kind":12},{"line":439,"name":"%hierarchy","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"name":"%self","kind":13,"containerName":null,"line":439},{"line":439,"name":"_hierarchy","kind":12},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"@ordered_nodes","line":440},{"line":441,"containerName":null,"kind":13,"name":"%rank_hash"},{"line":441,"kind":13,"containerName":null,"name":"$a"},{"line":441,"name":"%rank_hash","containerName":null,"kind":13},{"line":441,"containerName":null,"kind":13,"name":"$b"},{"kind":13,"containerName":null,"name":"%hierarchy","line":442},{"line":443,"kind":13,"containerName":null,"name":"%hierarchy"},{"line":443,"name":"scientific_name","containerName":"main::","kind":12},{"name":"@ordered_nodes","containerName":null,"kind":13,"line":443}]}