{"version":5,"vars":[{"line":100,"containerName":"","kind":2,"name":"base"},{"children":[{"definition":"my","line":117,"name":"$class","kind":13,"localvar":"my","containerName":"new"},{"line":117,"name":"@args","containerName":"new","kind":13},{"definition":"my","line":118,"localvar":"my","kind":13,"containerName":"new","name":"$self"},{"line":118,"containerName":"new","kind":13,"name":"$class"},{"line":118,"name":"@args","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$self","line":119},{"line":121,"name":"$name","localvar":"my","kind":13,"containerName":"new","definition":"my"},{"kind":13,"containerName":"new","name":"$token","line":121},{"line":121,"containerName":"new","kind":13,"name":"$symbols"},{"kind":13,"containerName":"new","name":"$matches","line":122},{"name":"$self","containerName":"new","kind":13,"line":122},{"line":122,"kind":12,"containerName":"new","name":"_rearrange"},{"containerName":"new","kind":13,"name":"@args","line":124},{"name":"$token","kind":13,"containerName":"new","line":125},{"line":125,"name":"$self","containerName":"new","kind":13},{"name":"token","containerName":"new","kind":12,"line":125},{"name":"$token","kind":13,"containerName":"new","line":125},{"line":126,"kind":13,"containerName":"new","name":"$name"},{"name":"$self","containerName":"new","kind":13,"line":126},{"containerName":"new","kind":12,"name":"name","line":126},{"name":"$name","kind":13,"containerName":"new","line":126},{"line":127,"name":"$symbols","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$symbols","line":127},{"line":127,"kind":13,"containerName":"new","name":"$self"},{"line":127,"name":"symbols","kind":12,"containerName":"new"},{"line":127,"name":"$symbols","containerName":"new","kind":13},{"name":"$matches","containerName":"new","kind":13,"line":128},{"name":"$self","kind":13,"containerName":"new","line":128},{"kind":12,"containerName":"new","name":"matches","line":128},{"line":128,"containerName":"new","kind":13,"name":"$matches"},{"kind":13,"containerName":"new","name":"$self","line":129}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)","line":116,"kind":12,"range":{"end":{"character":9999,"line":130},"start":{"character":0,"line":116}},"signature":{"documentation":"1;\n# $Id: Symbol.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::Symbol\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::Symbol - A biological symbol\n\n=head1 SYNOPSIS\n\n    use Bio::Symbol::Symbol;\n    my $thymine = Bio::Symbol::Symbol->new(-name => 'Thy',\n\t\t\t\t\t  -token=> 'T');\n    my $a = Bio::Symbol::Symbol->new(-token => 'A' );\n    my $u = Bio::Symbol::Symbol->new(-token => 'U' );\n    my $g = Bio::Symbol::Symbol->new(-token => 'G' );\n\n    my $M = Bio::Symbol::Symbol->new(-name  => 'Met',\n\t\t\t\t    -token => 'M',\n\t\t\t\t    -symbols => [ $a, $u, $g ]);\n\n    my ($name,$token) = ($a->name, $a->token);\n    my @symbols       = $a->symbols;\n    my $matches       = $a->matches;\n\n=head1 DESCRIPTION\n\nSymbol represents a single token in the sequence. Symbol can have\nmultiple synonyms or matches within the same Alphabet, which\nmakes possible to represent ambiguity codes and gaps.\n\nSymbols can be also composed from ordered list other symbols. For\nexample, codons can be represented by single Symbol using a\ncompound Alphabet made from three DNA Alphabets.\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Symbol::Symbol;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Symbol::Alphabet;\n\nuse base qw(Bio::Root::Root Bio::Symbol::SymbolI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Symbol::Symbol->new();\n Function: Builds a new Bio::Symbol::Symbol object \n Returns : Bio::Symbol::Symbol\n Args    : -name    => descriptive name (string) [e.g. Met]\n           -token   => Shorthand token (string)  [e.g. M]\n           -symbols => Symbols that make up this symbol (array) [e.g. AUG]\n           -matches => Alphabet in the event symbol is an ambiguity\n                       code.","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"}},{"containerName":"new","kind":12,"name":"SUPER","line":118},{"children":[{"line":143,"localvar":"my","containerName":"name","kind":13,"name":"$self","definition":"my"},{"name":"$value","containerName":"name","kind":13,"line":143},{"line":144,"name":"$value","kind":13,"containerName":"name"},{"line":145,"name":"$self","containerName":"name","kind":13},{"containerName":"name","kind":13,"name":"$value","line":145},{"containerName":"name","kind":13,"name":"$self","line":147}],"name":"name","containerName":"main::","definition":"sub","detail":"($self,$value)","line":142,"range":{"start":{"line":142,"character":0},"end":{"line":148,"character":9999}},"kind":12,"signature":{"documentation":"1;\n# $Id: Symbol.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::Symbol\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::Symbol - A biological symbol\n\n=head1 SYNOPSIS\n\n    use Bio::Symbol::Symbol;\n    my $thymine = Bio::Symbol::Symbol->new(-name => 'Thy',\n\t\t\t\t\t  -token=> 'T');\n    my $a = Bio::Symbol::Symbol->new(-token => 'A' );\n    my $u = Bio::Symbol::Symbol->new(-token => 'U' );\n    my $g = Bio::Symbol::Symbol->new(-token => 'G' );\n\n    my $M = Bio::Symbol::Symbol->new(-name  => 'Met',\n\t\t\t\t    -token => 'M',\n\t\t\t\t    -symbols => [ $a, $u, $g ]);\n\n    my ($name,$token) = ($a->name, $a->token);\n    my @symbols       = $a->symbols;\n    my $matches       = $a->matches;\n\n=head1 DESCRIPTION\n\nSymbol represents a single token in the sequence. Symbol can have\nmultiple synonyms or matches within the same Alphabet, which\nmakes possible to represent ambiguity codes and gaps.\n\nSymbols can be also composed from ordered list other symbols. For\nexample, codons can be represented by single Symbol using a\ncompound Alphabet made from three DNA Alphabets.\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Symbol::Symbol;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Symbol::Alphabet;\n\nuse base qw(Bio::Root::Root Bio::Symbol::SymbolI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Symbol::Symbol->new();\n Function: Builds a new Bio::Symbol::Symbol object \n Returns : Bio::Symbol::Symbol\n Args    : -name    => descriptive name (string) [e.g. Met]\n           -token   => Shorthand token (string)  [e.g. M]\n           -symbols => Symbols that make up this symbol (array) [e.g. AUG]\n           -matches => Alphabet in the event symbol is an ambiguity\n                       code.\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  $self->{'_symbols'} = [];\n\n  my ($name, $token, $symbols,\n      $matches) = $self->_rearrange([qw(NAME TOKEN SYMBOLS \n\t\t\t\t\tMATCHES)],\n\t\t\t\t    @args);\n  $token && $self->token($token);\n  $name && $self->name($name);\n  $symbols && ref($symbols) =~ /array/i && $self->symbols(@$symbols);\n  $matches && $self->matches($matches); \n  return $self;\n}\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $symbol->name();\n Function: Get/Set Descriptive name for Symbol\n Returns : string\n Args    : (optional) string","parameters":[{"label":"$self"},{"label":"$value"}],"label":"name($self,$value)"}},{"definition":"sub","detail":"($self,$value)","children":[{"line":162,"localvar":"my","containerName":"token","kind":13,"name":"$self","definition":"my"},{"line":162,"containerName":"token","kind":13,"name":"$value"},{"kind":13,"containerName":"token","name":"$value","line":163},{"containerName":"token","kind":13,"name":"$self","line":164},{"containerName":"token","kind":13,"name":"$value","line":164},{"line":166,"name":"$self","kind":13,"containerName":"token"}],"name":"token","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Symbol.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::Symbol\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::Symbol - A biological symbol\n\n=head1 SYNOPSIS\n\n    use Bio::Symbol::Symbol;\n    my $thymine = Bio::Symbol::Symbol->new(-name => 'Thy',\n\t\t\t\t\t  -token=> 'T');\n    my $a = Bio::Symbol::Symbol->new(-token => 'A' );\n    my $u = Bio::Symbol::Symbol->new(-token => 'U' );\n    my $g = Bio::Symbol::Symbol->new(-token => 'G' );\n\n    my $M = Bio::Symbol::Symbol->new(-name  => 'Met',\n\t\t\t\t    -token => 'M',\n\t\t\t\t    -symbols => [ $a, $u, $g ]);\n\n    my ($name,$token) = ($a->name, $a->token);\n    my @symbols       = $a->symbols;\n    my $matches       = $a->matches;\n\n=head1 DESCRIPTION\n\nSymbol represents a single token in the sequence. Symbol can have\nmultiple synonyms or matches within the same Alphabet, which\nmakes possible to represent ambiguity codes and gaps.\n\nSymbols can be also composed from ordered list other symbols. For\nexample, codons can be represented by single Symbol using a\ncompound Alphabet made from three DNA Alphabets.\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Symbol::Symbol;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Symbol::Alphabet;\n\nuse base qw(Bio::Root::Root Bio::Symbol::SymbolI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Symbol::Symbol->new();\n Function: Builds a new Bio::Symbol::Symbol object \n Returns : Bio::Symbol::Symbol\n Args    : -name    => descriptive name (string) [e.g. Met]\n           -token   => Shorthand token (string)  [e.g. M]\n           -symbols => Symbols that make up this symbol (array) [e.g. AUG]\n           -matches => Alphabet in the event symbol is an ambiguity\n                       code.\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  $self->{'_symbols'} = [];\n\n  my ($name, $token, $symbols,\n      $matches) = $self->_rearrange([qw(NAME TOKEN SYMBOLS \n\t\t\t\t\tMATCHES)],\n\t\t\t\t    @args);\n  $token && $self->token($token);\n  $name && $self->name($name);\n  $symbols && ref($symbols) =~ /array/i && $self->symbols(@$symbols);\n  $matches && $self->matches($matches); \n  return $self;\n}\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $symbol->name();\n Function: Get/Set Descriptive name for Symbol\n Returns : string\n Args    : (optional) string\n\n\nsub name {\n   my ($self,$value) = @_;\n   if( $value ) {\n       $self->{'_name'} = $value;\n   }\n   return $self->{'_name'} || '';\n}\n\n=head2 token\n\n Title   : token\n Usage   : my $token = $self->token();\n Function: Get/Set token for this symbol\n Example : Letter A,C,G,or T for a DNA alphabet Symbol\n Returns : string\n Args    : (optional) string","label":"token($self,$value)"},"line":161,"range":{"end":{"character":9999,"line":167},"start":{"line":161,"character":0}},"kind":12},{"containerName":"main::","name":"symbols","children":[{"definition":"my","localvar":"my","containerName":"symbols","kind":13,"name":"$self","line":182},{"name":"@args","containerName":"symbols","kind":13,"line":182},{"containerName":"symbols","kind":13,"name":"@args","line":183},{"name":"$self","kind":13,"containerName":"symbols","line":184},{"line":184,"containerName":"symbols","kind":13,"name":"@args"},{"kind":13,"containerName":"symbols","name":"$self","line":186}],"detail":"($self,@args)","definition":"sub","range":{"start":{"line":181,"character":0},"end":{"line":186,"character":9999}},"kind":12,"line":181,"signature":{"label":"symbols($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Symbol.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::Symbol\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::Symbol - A biological symbol\n\n=head1 SYNOPSIS\n\n    use Bio::Symbol::Symbol;\n    my $thymine = Bio::Symbol::Symbol->new(-name => 'Thy',\n\t\t\t\t\t  -token=> 'T');\n    my $a = Bio::Symbol::Symbol->new(-token => 'A' );\n    my $u = Bio::Symbol::Symbol->new(-token => 'U' );\n    my $g = Bio::Symbol::Symbol->new(-token => 'G' );\n\n    my $M = Bio::Symbol::Symbol->new(-name  => 'Met',\n\t\t\t\t    -token => 'M',\n\t\t\t\t    -symbols => [ $a, $u, $g ]);\n\n    my ($name,$token) = ($a->name, $a->token);\n    my @symbols       = $a->symbols;\n    my $matches       = $a->matches;\n\n=head1 DESCRIPTION\n\nSymbol represents a single token in the sequence. Symbol can have\nmultiple synonyms or matches within the same Alphabet, which\nmakes possible to represent ambiguity codes and gaps.\n\nSymbols can be also composed from ordered list other symbols. For\nexample, codons can be represented by single Symbol using a\ncompound Alphabet made from three DNA Alphabets.\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Symbol::Symbol;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Symbol::Alphabet;\n\nuse base qw(Bio::Root::Root Bio::Symbol::SymbolI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Symbol::Symbol->new();\n Function: Builds a new Bio::Symbol::Symbol object \n Returns : Bio::Symbol::Symbol\n Args    : -name    => descriptive name (string) [e.g. Met]\n           -token   => Shorthand token (string)  [e.g. M]\n           -symbols => Symbols that make up this symbol (array) [e.g. AUG]\n           -matches => Alphabet in the event symbol is an ambiguity\n                       code.\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  $self->{'_symbols'} = [];\n\n  my ($name, $token, $symbols,\n      $matches) = $self->_rearrange([qw(NAME TOKEN SYMBOLS \n\t\t\t\t\tMATCHES)],\n\t\t\t\t    @args);\n  $token && $self->token($token);\n  $name && $self->name($name);\n  $symbols && ref($symbols) =~ /array/i && $self->symbols(@$symbols);\n  $matches && $self->matches($matches); \n  return $self;\n}\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $symbol->name();\n Function: Get/Set Descriptive name for Symbol\n Returns : string\n Args    : (optional) string\n\n\nsub name {\n   my ($self,$value) = @_;\n   if( $value ) {\n       $self->{'_name'} = $value;\n   }\n   return $self->{'_name'} || '';\n}\n\n=head2 token\n\n Title   : token\n Usage   : my $token = $self->token();\n Function: Get/Set token for this symbol\n Example : Letter A,C,G,or T for a DNA alphabet Symbol\n Returns : string\n Args    : (optional) string\n\n\nsub token{\n   my ($self,$value) = @_;\n   if( $value ) {\n       $self->{'_token'} = $value;\n   }\n   return $self->{'_token'} || '';\n}\n\n=head2 symbols\n\n Title   : symbols\n Usage   : my @symbols = $self->symbols();\n Function: Get/Set Symbols this Symbol is composed from\n Example : Ambiguity symbols are made up > 1 base symbol\n Returns : Array of Bio::Symbol::SymbolI objects\n Args    : (optional) Array of Bio::Symbol::SymbolI objects"}},{"kind":12,"range":{"end":{"character":9999,"line":214},"start":{"character":0,"line":202}},"line":202,"signature":{"label":"matches($self,$matches)","documentation":"1;\n# $Id: Symbol.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::Symbol\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::Symbol - A biological symbol\n\n=head1 SYNOPSIS\n\n    use Bio::Symbol::Symbol;\n    my $thymine = Bio::Symbol::Symbol->new(-name => 'Thy',\n\t\t\t\t\t  -token=> 'T');\n    my $a = Bio::Symbol::Symbol->new(-token => 'A' );\n    my $u = Bio::Symbol::Symbol->new(-token => 'U' );\n    my $g = Bio::Symbol::Symbol->new(-token => 'G' );\n\n    my $M = Bio::Symbol::Symbol->new(-name  => 'Met',\n\t\t\t\t    -token => 'M',\n\t\t\t\t    -symbols => [ $a, $u, $g ]);\n\n    my ($name,$token) = ($a->name, $a->token);\n    my @symbols       = $a->symbols;\n    my $matches       = $a->matches;\n\n=head1 DESCRIPTION\n\nSymbol represents a single token in the sequence. Symbol can have\nmultiple synonyms or matches within the same Alphabet, which\nmakes possible to represent ambiguity codes and gaps.\n\nSymbols can be also composed from ordered list other symbols. For\nexample, codons can be represented by single Symbol using a\ncompound Alphabet made from three DNA Alphabets.\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Symbol::Symbol;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Symbol::Alphabet;\n\nuse base qw(Bio::Root::Root Bio::Symbol::SymbolI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Symbol::Symbol->new();\n Function: Builds a new Bio::Symbol::Symbol object \n Returns : Bio::Symbol::Symbol\n Args    : -name    => descriptive name (string) [e.g. Met]\n           -token   => Shorthand token (string)  [e.g. M]\n           -symbols => Symbols that make up this symbol (array) [e.g. AUG]\n           -matches => Alphabet in the event symbol is an ambiguity\n                       code.\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  $self->{'_symbols'} = [];\n\n  my ($name, $token, $symbols,\n      $matches) = $self->_rearrange([qw(NAME TOKEN SYMBOLS \n\t\t\t\t\tMATCHES)],\n\t\t\t\t    @args);\n  $token && $self->token($token);\n  $name && $self->name($name);\n  $symbols && ref($symbols) =~ /array/i && $self->symbols(@$symbols);\n  $matches && $self->matches($matches); \n  return $self;\n}\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $symbol->name();\n Function: Get/Set Descriptive name for Symbol\n Returns : string\n Args    : (optional) string\n\n\nsub name {\n   my ($self,$value) = @_;\n   if( $value ) {\n       $self->{'_name'} = $value;\n   }\n   return $self->{'_name'} || '';\n}\n\n=head2 token\n\n Title   : token\n Usage   : my $token = $self->token();\n Function: Get/Set token for this symbol\n Example : Letter A,C,G,or T for a DNA alphabet Symbol\n Returns : string\n Args    : (optional) string\n\n\nsub token{\n   my ($self,$value) = @_;\n   if( $value ) {\n       $self->{'_token'} = $value;\n   }\n   return $self->{'_token'} || '';\n}\n\n=head2 symbols\n\n Title   : symbols\n Usage   : my @symbols = $self->symbols();\n Function: Get/Set Symbols this Symbol is composed from\n Example : Ambiguity symbols are made up > 1 base symbol\n Returns : Array of Bio::Symbol::SymbolI objects\n Args    : (optional) Array of Bio::Symbol::SymbolI objects\n\n\n\nsub symbols{\n   my ($self,@args) = @_;\n   if( @args ) {\n       $self->{'_symbols'} = [@args];\n   } \n   return @{$self->{'_symbols'}};\n}\n\n=head2 matches\n\n Title   : matches\n Usage   : my $matchalphabet = $symbol->matches();\n Function: Get/Set (Sub) alphabet of symbols matched by this symbol\n           including the symbol itself (i.e. if symbol is DNA\n           ambiguity code W then the matches contains symbols for W\n           and T)\n Returns : Bio::Symbol::AlphabetI\n Args    : (optional) Bio::Symbol::AlphabetI","parameters":[{"label":"$self"},{"label":"$matches"}]},"name":"matches","containerName":"main::","children":[{"definition":"my","line":203,"name":"$self","localvar":"my","containerName":"matches","kind":13},{"line":203,"kind":13,"containerName":"matches","name":"$matches"},{"line":205,"name":"$matches","kind":13,"containerName":"matches"},{"containerName":"matches","kind":13,"name":"$matches","line":206},{"kind":12,"containerName":"matches","name":"isa","line":206},{"name":"$self","containerName":"matches","kind":13,"line":207},{"name":"warn","containerName":"matches","kind":12,"line":207},{"line":210,"name":"$self","kind":13,"containerName":"matches"},{"containerName":"matches","kind":13,"name":"$matches","line":210},{"name":"$self","containerName":"matches","kind":13,"line":213}],"detail":"($self,$matches)","definition":"sub"},{"children":[{"definition":"my","line":227,"localvar":"my","containerName":"equals","kind":13,"name":"$self"},{"name":"$symbol2","containerName":"equals","kind":13,"line":227},{"name":"$self","kind":13,"containerName":"equals","line":230},{"line":230,"name":"token","containerName":"equals","kind":12},{"kind":13,"containerName":"equals","name":"$symbol2","line":230},{"name":"token","containerName":"equals","kind":12,"line":230}],"containerName":"main::","name":"equals","definition":"sub","detail":"($self,$symbol2)","line":226,"kind":12,"range":{"end":{"character":9999,"line":231},"start":{"line":226,"character":0}},"signature":{"parameters":[{"label":"$self"},{"label":"$symbol2"}],"documentation":"1;\n# $Id: Symbol.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::Symbol\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::Symbol - A biological symbol\n\n=head1 SYNOPSIS\n\n    use Bio::Symbol::Symbol;\n    my $thymine = Bio::Symbol::Symbol->new(-name => 'Thy',\n\t\t\t\t\t  -token=> 'T');\n    my $a = Bio::Symbol::Symbol->new(-token => 'A' );\n    my $u = Bio::Symbol::Symbol->new(-token => 'U' );\n    my $g = Bio::Symbol::Symbol->new(-token => 'G' );\n\n    my $M = Bio::Symbol::Symbol->new(-name  => 'Met',\n\t\t\t\t    -token => 'M',\n\t\t\t\t    -symbols => [ $a, $u, $g ]);\n\n    my ($name,$token) = ($a->name, $a->token);\n    my @symbols       = $a->symbols;\n    my $matches       = $a->matches;\n\n=head1 DESCRIPTION\n\nSymbol represents a single token in the sequence. Symbol can have\nmultiple synonyms or matches within the same Alphabet, which\nmakes possible to represent ambiguity codes and gaps.\n\nSymbols can be also composed from ordered list other symbols. For\nexample, codons can be represented by single Symbol using a\ncompound Alphabet made from three DNA Alphabets.\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Symbol::Symbol;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Symbol::Alphabet;\n\nuse base qw(Bio::Root::Root Bio::Symbol::SymbolI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Symbol::Symbol->new();\n Function: Builds a new Bio::Symbol::Symbol object \n Returns : Bio::Symbol::Symbol\n Args    : -name    => descriptive name (string) [e.g. Met]\n           -token   => Shorthand token (string)  [e.g. M]\n           -symbols => Symbols that make up this symbol (array) [e.g. AUG]\n           -matches => Alphabet in the event symbol is an ambiguity\n                       code.\n\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  $self->{'_symbols'} = [];\n\n  my ($name, $token, $symbols,\n      $matches) = $self->_rearrange([qw(NAME TOKEN SYMBOLS \n\t\t\t\t\tMATCHES)],\n\t\t\t\t    @args);\n  $token && $self->token($token);\n  $name && $self->name($name);\n  $symbols && ref($symbols) =~ /array/i && $self->symbols(@$symbols);\n  $matches && $self->matches($matches); \n  return $self;\n}\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $symbol->name();\n Function: Get/Set Descriptive name for Symbol\n Returns : string\n Args    : (optional) string\n\n\nsub name {\n   my ($self,$value) = @_;\n   if( $value ) {\n       $self->{'_name'} = $value;\n   }\n   return $self->{'_name'} || '';\n}\n\n=head2 token\n\n Title   : token\n Usage   : my $token = $self->token();\n Function: Get/Set token for this symbol\n Example : Letter A,C,G,or T for a DNA alphabet Symbol\n Returns : string\n Args    : (optional) string\n\n\nsub token{\n   my ($self,$value) = @_;\n   if( $value ) {\n       $self->{'_token'} = $value;\n   }\n   return $self->{'_token'} || '';\n}\n\n=head2 symbols\n\n Title   : symbols\n Usage   : my @symbols = $self->symbols();\n Function: Get/Set Symbols this Symbol is composed from\n Example : Ambiguity symbols are made up > 1 base symbol\n Returns : Array of Bio::Symbol::SymbolI objects\n Args    : (optional) Array of Bio::Symbol::SymbolI objects\n\n\n\nsub symbols{\n   my ($self,@args) = @_;\n   if( @args ) {\n       $self->{'_symbols'} = [@args];\n   } \n   return @{$self->{'_symbols'}};\n}\n\n=head2 matches\n\n Title   : matches\n Usage   : my $matchalphabet = $symbol->matches();\n Function: Get/Set (Sub) alphabet of symbols matched by this symbol\n           including the symbol itself (i.e. if symbol is DNA\n           ambiguity code W then the matches contains symbols for W\n           and T)\n Returns : Bio::Symbol::AlphabetI\n Args    : (optional) Bio::Symbol::AlphabetI\n\n\nsub matches{\n   my ($self,$matches) = @_;\n   \n   if( $matches ) {\n       if( ! $matches->isa('Bio::Symbol::AlphabetI') ) {\n\t   $self->warn(\"Must pass in a Bio::Symbol::AlphabetI object to matches function\");\n\t   # stick with previous value\n       } else { \n\t   $self->{'_matches'} = $matches;\n       }\n   }\n   return $self->{'_matches'};\n}\n\n=head2 equals\n\n Title   : equals\n Usage   : if( $symbol->equals($symbol2) ) { }\n Function: Tests if a symbol is equal to another \n Returns : Boolean\n Args    : Bio::Symbol::SymbolI","label":"equals($self,$symbol2)"}}]}