{"version":5,"vars":[{"line":98,"kind":12,"range":{"end":{"line":101,"character":9999},"start":{"character":0,"line":98}},"signature":{"documentation":"1;\n# $Id: AlphabetI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::AlphabetI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::AlphabetI - A Symbol Alphabet\n\n=head1 SYNOPSIS\n\n    # get a Bio::Symbol::AlphabetI object somehow\n    my @symbols = $alphabet->symbols;\n    my @subalphas = $alphabet->alphabets;\n    if( $alphabet->contains($symbol) ) {\n\t# do something\n    }\n\n=head1 DESCRIPTION\n\nAlphabet contains set of symbols, which can be concatenated to form\nsymbol lists. Sequence string, for example, is stringified\nrepresentation of the symbol list (tokens of symbols).\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Symbol::AlphabetI;\nuse strict;\nuse Bio::Root::RootI;\n\n=head2 AlphabetI Interface methods\n\n\n=head2 symbols\n\n Title   : symbols\n Usage   : my @symbols = $alphabet->symbols();\n Function: Get/Set Symbol list for an alphabet\n           List of symbols, which make up this alphabet.\n Returns : Array of L<Bio::Symbol::SymbolI> objects\n Args    : (optional) Array of L<Bio::Symbol::SymbolI> objects","parameters":[{"label":"$self"},{"label":"@args"}],"label":"symbols($self,@args)"},"children":[{"localvar":"my","kind":13,"containerName":"symbols","name":"$self","line":99,"definition":"my"},{"line":99,"containerName":"symbols","kind":13,"name":"@args"},{"name":"$self","containerName":"symbols","kind":13,"line":100},{"name":"throw_not_implemented","kind":12,"containerName":"symbols","line":100}],"name":"symbols","containerName":"main::","definition":"sub","detail":"($self,@args)"},{"line":99,"kind":2,"containerName":"strict::Bio::Root","name":"RootI"},{"children":[{"line":115,"name":"$self","localvar":"my","kind":13,"containerName":"alphabets","definition":"my"},{"line":115,"name":"@args","containerName":"alphabets","kind":13},{"name":"$self","containerName":"alphabets","kind":13,"line":116},{"line":116,"name":"throw_not_implemented","containerName":"alphabets","kind":12}],"name":"alphabets","containerName":"main::","definition":"sub","detail":"($self,@args)","line":114,"kind":12,"range":{"end":{"line":117,"character":9999},"start":{"line":114,"character":0}},"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: AlphabetI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::AlphabetI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::AlphabetI - A Symbol Alphabet\n\n=head1 SYNOPSIS\n\n    # get a Bio::Symbol::AlphabetI object somehow\n    my @symbols = $alphabet->symbols;\n    my @subalphas = $alphabet->alphabets;\n    if( $alphabet->contains($symbol) ) {\n\t# do something\n    }\n\n=head1 DESCRIPTION\n\nAlphabet contains set of symbols, which can be concatenated to form\nsymbol lists. Sequence string, for example, is stringified\nrepresentation of the symbol list (tokens of symbols).\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Symbol::AlphabetI;\nuse strict;\nuse Bio::Root::RootI;\n\n=head2 AlphabetI Interface methods\n\n\n=head2 symbols\n\n Title   : symbols\n Usage   : my @symbols = $alphabet->symbols();\n Function: Get/Set Symbol list for an alphabet\n           List of symbols, which make up this alphabet.\n Returns : Array of L<Bio::Symbol::SymbolI> objects\n Args    : (optional) Array of L<Bio::Symbol::SymbolI> objects\n\n\nsub symbols{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 alphabets\n\n Title   : alphabets\n Usage   : my @alphabets = $alphabet->alphabets();\n Function: Get/Set Sub Alphabet list for an alphabet \n           Sub-alphabets. E.g. codons made from DNAxDNAxDNA alphabets\n Returns : Array of L<Bio::Symbol::AlphabetI> objects\n Args    : (optional) Array of L<Bio::Symbol::AlphabetI> objects","label":"alphabets($self,@args)"}},{"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","containerName":"contains","localvar":"my","kind":13,"name":"$self","line":130},{"kind":13,"containerName":"contains","name":"@args","line":130},{"name":"$self","containerName":"contains","kind":13,"line":131},{"line":131,"containerName":"contains","kind":12,"name":"throw_not_implemented"}],"name":"contains","containerName":"main::","signature":{"documentation":"1;\n# $Id: AlphabetI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::AlphabetI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::AlphabetI - A Symbol Alphabet\n\n=head1 SYNOPSIS\n\n    # get a Bio::Symbol::AlphabetI object somehow\n    my @symbols = $alphabet->symbols;\n    my @subalphas = $alphabet->alphabets;\n    if( $alphabet->contains($symbol) ) {\n\t# do something\n    }\n\n=head1 DESCRIPTION\n\nAlphabet contains set of symbols, which can be concatenated to form\nsymbol lists. Sequence string, for example, is stringified\nrepresentation of the symbol list (tokens of symbols).\n\nThis module was implemented for the purposes of meeting the\nBSANE/BioCORBA spec 0.3 only.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Symbol::AlphabetI;\nuse strict;\nuse Bio::Root::RootI;\n\n=head2 AlphabetI Interface methods\n\n\n=head2 symbols\n\n Title   : symbols\n Usage   : my @symbols = $alphabet->symbols();\n Function: Get/Set Symbol list for an alphabet\n           List of symbols, which make up this alphabet.\n Returns : Array of L<Bio::Symbol::SymbolI> objects\n Args    : (optional) Array of L<Bio::Symbol::SymbolI> objects\n\n\nsub symbols{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 alphabets\n\n Title   : alphabets\n Usage   : my @alphabets = $alphabet->alphabets();\n Function: Get/Set Sub Alphabet list for an alphabet \n           Sub-alphabets. E.g. codons made from DNAxDNAxDNA alphabets\n Returns : Array of L<Bio::Symbol::AlphabetI> objects\n Args    : (optional) Array of L<Bio::Symbol::AlphabetI> objects\n\n\nsub alphabets{\n    my ($self,@args) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 contains\n\n Title   : contains\n Usage   : if($alphabet->contains($symbol)) { }\n Function: Tests of Symbol is contained in this alphabet\n Returns : Boolean\n Args    : L<Bio::Symbol::SymbolI>","parameters":[{"label":"$self"},{"label":"@args"}],"label":"contains($self,@args)"},"line":129,"kind":12,"range":{"end":{"character":9999,"line":132},"start":{"line":129,"character":0}}}]}